(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1213949,      29417]
NotebookOptionsPosition[   1098963,      27115]
NotebookOutlinePosition[   1196503,      29113]
CellTagsIndexPosition[   1195562,      29077]
WindowTitle->Coordinates and Graphics: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Coordinates and Graphics", "SectionInline",ExpressionUUID->
   "1d8b1404-91e7-4969-8dc0-3dfa898e31c5"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 13}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:63",
 CellLabel->"In[16]:=",ExpressionUUID->"51b621cb-236c-41e8-aa49-c364d9cd0555"],

Cell[TextData[{
 "We\[CloseCurlyQuote]ve used ",
 ButtonBox["ListPlot",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["ListLinePlot",
  BaseStyle->"Link"],
 " to plot lists of values, where each value appears after the one before. \
But by giving lists containing ",
 StyleBox["pairs of coordinates",
  FontSlant->"Italic"],
 " instead of single values, we can use these functions to plot points at \
arbitrary positions. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2ea5dca0-abf8-48ac-9df6-6e5a1778e7cd"],

Cell["\<\
Plot a list of values where each value appears after the one before:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"b0505a0a-167c-45f3-a639-b16871f35200"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
   "4", ",", "3", ",", "2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", 
    ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"b5f9e11b-cd29-4b18-9094-f1118fa63557"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{1., 4.}, {2., 3.}, {3., 2.}, {4., 1.}, {5., 1.}, {6., 1.}, {
      7., 1.}, {8., 2.}, {9., 3.}, {10., 4.}}]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{175.41015625, Automatic},
  Method->{},
  PlotRange->{{0., 10.}, {0, 4.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"94adc332-b1f1-4d4c-a500-21381b6a9f11"]
}, Open  ]],

Cell[TextData[{
 "Plot a sequence of arbitrary points specified by {",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "} coordinates:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"119d6edb-e1f1-4c5d-b50d-8b3a069ff2e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"7ef5e4ed-5b93-4cb0-9ad6-c2d35f64afb4"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.019444444444444445`],
      AbsoluteThickness[1.6], 
     LineBox[{{1., 1.}, {1., 5.}, {6., 4.}, {6., 2.}, {2., 3.}, {5., 
      5.}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{174.87890625, Automatic},
  Method->{},
  PlotRange->{{0, 6.}, {0, 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"9e374971-2613-454a-89a2-5ce7ec7d7891"]
}, Open  ]],

Cell[TextData[{
 "The position of each point here is specified by {",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "} coordinates. Following the standard convention in mathematics, the ",
 StyleBox["x",
  FontSlant->"Italic"],
 " value says how far across horizontally the point should be; the ",
 StyleBox["y",
  FontSlant->"Italic"],
 " value says how far up vertically it should be. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"a5874100-3fe5-456c-b62f-26ed079ff48f"],

Cell[TextData[{
 "Generate a sequence of random {",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "} coordinates:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8b744cec-8cb0-42d7-ad1e-fb029744a245"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", "20", "]"}], ",", "10", ",", "2"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"092e005a-2ef4-4b1d-b028-4ae26e3fe559"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"19", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "2"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"5aa6c452-0bc5-47e9-9f4e-9b1746b8bbd2"]
}, Open  ]],

Cell["Another way to get random coordinates:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cc8b3254-9aed-42fc-99e2-9e6a2cebbfb6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"20", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "2"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"c54fd3a8-0dc4-49ee-a779-0b49530b82fd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "10"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[4]=",ExpressionUUID->"fa0ddf39-e8ba-4d6c-8d04-62e8e403dfff"]
}, Open  ]],

Cell["Plot 100 points at random coordinates:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:64",ExpressionUUID->"c7d41d9d-5f17-46b5-81c1-f715aedd56fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RandomInteger", "[", "1000", "]"}], ",", "100", ",", "2"}], 
   "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"ebbd507b-4168-4a5e-a75a-905af4588299"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlDlMw0AQRVdUlClTGonCpRuklG6QaJAiQAgQQibiCOIyd7iX25xKSemS
0mVKl5RbpnSZ0iUlx7wpgqXoayez8//8nd2hxvbE8oAxZunn94t/n/8W/mF8
Jhg2BMtT1o+CVTBaEUyuBO2doJkQTF8E3+8Fi43Q9H0hfBeCPfh96gxSN7pm
37JgcATfPHH2lTE6D+A/ERyjTvMVHeTXqPvJuglvk3gd/dGD4IwlvoMO8uwU
/PD5xDP4vCUwQtcm/1OvvBRsKx9+JOzPV+EZY41euyeofgfH1EFHTF1vnTz8
K9Cf4ovBN7Ml+HEr2HumDrqc9qv1lDehD865C1ZvyBunL/oIJ+Eh7x1/6/Bl
8OXk1anTeoKPeXTsS/GjQL/Fvxp1OvhomBfXYj0CDz5k+GKqIOcWwRfga4Gv
4bRgTNx4xLkf3WvBCvwB8YL8HN+t4hx1hgXV/zZ95/is51f550OHfDOKbu2T
fr44V72npZ7PgqCPvuCcOHPq4G3yv9P7vChYo+4nfnuHIO+D4Rw99JacV0fn
CmxR1/Iu2AZ56O1xX/SeetTRee+qPuIJujOdB/qt8D7YNVB9nyUf31Lq5ehy
+KvzOkg85V7Xkv6+quS7ffbpnOq54FPOPEXUibnHkb535H0wpyX8jvtv8T+g
Px/M64JdPZfd/roe73yKHn3/LftD8izxjH5KdDjy4sPwGyYs7EQ=
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{215.0078125, Automatic},
  Method->{},
  PlotRange->{{0, 989.}, {0, 990.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"c3639221-2279-42e1-9096-35e0ded303ad"]
}, Open  ]],

Cell[TextData[{
 "We can use coordinates to construct graphics. ",
 ButtonBox["Earlier",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-08-basic-graphics-objects.nb", None}],
 " we saw how to make graphics of one circle. To make graphics of more than \
one circle we have to say where each circle is, which we can do by giving the \
coordinates of their centers. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "graphics-with-several-objects",ExpressionUUID->"377ce040-dc07-4f68-a4ed-\
e9515a51488e"],

Cell["Place circles by giving the coordinates of their centers:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"7d24248f-581e-4760-bac4-3a6a85c33e0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"5de62309-3b39-4a1e-976b-1af9a4ebe7bc"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{1, 1}], CircleBox[{1, 2}], CircleBox[{3, 1}]},
  ImageSize->{135.140625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"125c276a-800e-4fb9-889e-8ab35eab30f8"]
}, Open  ]],

Cell["\<\
If we apply color styles it\[CloseCurlyQuote]s easier to see which circle is \
which:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c7156a34-cfad-41b7-8487-e78eb39ea270"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Circle", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", "Red"}], "]"}], ",", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Circle", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", "Green"}], "]"}], ",", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Circle", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], "]"}], ",", "Blue"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"dbcfc329-ed12-4195-b33a-58122cda39bf"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], CircleBox[{1, 1}]}, 
   {RGBColor[0, 1, 0], CircleBox[{1, 2}]}, 
   {RGBColor[0, 0, 1], CircleBox[{3, 1}]}},
  ImageSize->{135.15625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"5f2dcab5-1493-4160-9748-c2ec2d8964ad"]
}, Open  ]],

Cell["\<\
Make a graphic with 100 randomly placed circles, each with center coordinates \
up to 50:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0751051e-9340-4d9c-a8e8-40524846932d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"50", ",", "2"}], "]"}], "]"}], ",", "100"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"236ac9d1-7f67-4ad7-8003-a31b61e9ef53"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{21, 32}], CircleBox[{47, 27}], CircleBox[{14, 36}], 
   CircleBox[{30, 38}], CircleBox[{35, 14}], CircleBox[{11, 36}], 
   CircleBox[{2, 19}], CircleBox[{0, 26}], CircleBox[{36, 34}], 
   CircleBox[{40, 22}], CircleBox[{1, 26}], CircleBox[{26, 4}], 
   CircleBox[{6, 27}], CircleBox[{1, 24}], CircleBox[{31, 17}], 
   CircleBox[{41, 39}], CircleBox[{5, 1}], CircleBox[{31, 26}], 
   CircleBox[{18, 19}], CircleBox[{30, 11}], CircleBox[{32, 9}], 
   CircleBox[{13, 19}], CircleBox[{38, 1}], CircleBox[{28, 31}], 
   CircleBox[{33, 4}], CircleBox[{5, 14}], CircleBox[{33, 22}], 
   CircleBox[{34, 50}], CircleBox[{31, 26}], CircleBox[{7, 28}], 
   CircleBox[{24, 48}], CircleBox[{17, 37}], CircleBox[{6, 0}], 
   CircleBox[{48, 0}], CircleBox[{28, 49}], CircleBox[{24, 6}], 
   CircleBox[{29, 49}], CircleBox[{2, 11}], CircleBox[{5, 42}], 
   CircleBox[{3, 34}], CircleBox[{40, 27}], CircleBox[{6, 24}], 
   CircleBox[{48, 10}], CircleBox[{16, 4}], CircleBox[{16, 2}], 
   CircleBox[{12, 50}], CircleBox[{29, 39}], CircleBox[{8, 44}], 
   CircleBox[{18, 46}], CircleBox[{5, 1}], CircleBox[{25, 37}], 
   CircleBox[{36, 13}], CircleBox[{28, 1}], CircleBox[{41, 4}], 
   CircleBox[{41, 18}], CircleBox[{40, 45}], CircleBox[{48, 13}], 
   CircleBox[{23, 42}], CircleBox[{26, 47}], CircleBox[{11, 9}], 
   CircleBox[{46, 2}], CircleBox[{9, 22}], CircleBox[{41, 36}], 
   CircleBox[{43, 23}], CircleBox[{14, 41}], CircleBox[{29, 11}], 
   CircleBox[{43, 9}], CircleBox[{50, 18}], CircleBox[{18, 17}], 
   CircleBox[{17, 0}], CircleBox[{6, 7}], CircleBox[{28, 25}], 
   CircleBox[{44, 19}], CircleBox[{34, 11}], CircleBox[{2, 24}], 
   CircleBox[{49, 11}], CircleBox[{0, 12}], CircleBox[{47, 49}], 
   CircleBox[{22, 9}], CircleBox[{39, 39}], CircleBox[{28, 47}], 
   CircleBox[{33, 1}], CircleBox[{33, 19}], CircleBox[{25, 3}], 
   CircleBox[{33, 17}], CircleBox[{10, 28}], CircleBox[{34, 45}], 
   CircleBox[{32, 11}], CircleBox[{2, 28}], CircleBox[{44, 37}], 
   CircleBox[{29, 48}], CircleBox[{40, 24}], CircleBox[{37, 45}], 
   CircleBox[{42, 23}], CircleBox[{7, 19}], CircleBox[{39, 39}], 
   CircleBox[{26, 13}], CircleBox[{30, 3}], CircleBox[{13, 15}], 
   CircleBox[{25, 50}]},
  ImageSize->{142.09765625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[8]=",ExpressionUUID->"f2372213-c0c8-41cb-9ac0-2c545cf2bdb9"]
}, Open  ]],

Cell["A 2D array of circles, arranged so that they just touch:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:65", "i:5"},ExpressionUUID->"8d5818e2-69a0-4be6-92b7-5e8c4fbfde4f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "10", ",", "2"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"6a1e3a3c-6a37-48f0-942e-6e96d03bfb5b"],

Cell[BoxData[
 GraphicsBox[{{CircleBox[{0, 0}], CircleBox[{0, 2}], CircleBox[{0, 4}], 
    CircleBox[{0, 6}], CircleBox[{0, 8}], CircleBox[{0, 10}]}, {
    CircleBox[{2, 0}], CircleBox[{2, 2}], CircleBox[{2, 4}], 
    CircleBox[{2, 6}], CircleBox[{2, 8}], CircleBox[{2, 10}]}, {
    CircleBox[{4, 0}], CircleBox[{4, 2}], CircleBox[{4, 4}], 
    CircleBox[{4, 6}], CircleBox[{4, 8}], CircleBox[{4, 10}]}, {
    CircleBox[{6, 0}], CircleBox[{6, 2}], CircleBox[{6, 4}], 
    CircleBox[{6, 6}], CircleBox[{6, 8}], CircleBox[{6, 10}]}, {
    CircleBox[{8, 0}], CircleBox[{8, 2}], CircleBox[{8, 4}], 
    CircleBox[{8, 6}], CircleBox[{8, 8}], CircleBox[{8, 10}]}, {
    CircleBox[{10, 0}], CircleBox[{10, 2}], CircleBox[{10, 4}], 
    CircleBox[{10, 6}], CircleBox[{10, 8}], CircleBox[{10, 10}]}},
  ImageSize->{141.7578125, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"f64065ca-4fc0-4e7a-ab91-45517b46824f"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Circle",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "CodeVariable"], ",", 
     StyleBox["y", "CodeVariable"]}], "}"}], "]"}]], "InlineCodeText",
  ExpressionUUID->"4a7b7b9a-f853-4576-8b3e-7dfc3987b8e1"],
 " means a circle centered at position ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "CodeVariable"], ",", 
    StyleBox["y", "CodeVariable"]}], "}"}]], "InlineCodeText",ExpressionUUID->
  "8d4c23e9-6468-4757-b163-1fd1059e40dc"],
 ". If you don\[CloseCurlyQuote]t say otherwise, the circle is given radius \
1. You can make a circle of any radius using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Circle",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "CodeVariable"], ",", 
      StyleBox["y", "CodeVariable"]}], "}"}], ",", 
    StyleBox["r", "CodeVariable"]}], "]"}]], "InlineCodeText",ExpressionUUID->
  "a01160f9-03a7-4204-9094-2fb4fd0e8b03"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "circle-x-y", "i:6"},ExpressionUUID->"e3c28f7d-9580-4924-8636-d7fcd303f7f7"],

Cell["Use different radii for different circles:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5b659e5c-dcf4-439d-a270-9c69f745ecfe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "0.5"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", "1.2"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}], ",", "0.8"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"7b655398-79cd-45cb-9a5e-086e18353551"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{1, 1}, 0.5], CircleBox[{1, 2}, 1.2], 
   CircleBox[{3, 1}, 0.8]},
  ImageSize->{140.09375, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"c3ffa128-7b6a-422c-a59b-a69fdcf6f9e2"]
}, Open  ]],

Cell["Make 10 concentric circles:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ea8f9ddf-eabe-43b4-8b14-696b7dab032d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "r"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"7f110117-f2d0-4a6f-bb86-b973882dffea"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], CircleBox[{0, 0}, 2], CircleBox[{0, 0}, 3], 
   CircleBox[{0, 0}, 4], CircleBox[{0, 0}, 5], CircleBox[{0, 0}, 6], 
   CircleBox[{0, 0}, 7], CircleBox[{0, 0}, 8], CircleBox[{0, 0}, 9], 
   CircleBox[{0, 0}, 10]},
  ImageSize->{135.234375, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"7defb0ec-6d4f-4fb6-bce0-ec4ac52619ac"]
}, Open  ]],

Cell["\<\
Draw larger circles with centers that shift progressively to the right:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7a30b493-3f03-4f2f-8ade-c9aea88b14ce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "0"}], "}"}], ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"451c6092-bdcb-4532-9f02-bc09ee5714ee"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{1, 0}], CircleBox[{2, 0}, 2], CircleBox[{3, 0}, 3], 
   CircleBox[{4, 0}, 4], CircleBox[{5, 0}, 5], CircleBox[{6, 0}, 6], 
   CircleBox[{7, 0}, 7], CircleBox[{8, 0}, 8], CircleBox[{9, 0}, 9], 
   CircleBox[{10, 0}, 10]},
  ImageSize->{135.12890625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[12]=",ExpressionUUID->"2f1929d2-3e1a-407c-b3fb-b930ab8101ee"]
}, Open  ]],

Cell["Pick both positions and radii at random:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:66",ExpressionUUID->"9ede54b2-c142-4b12-971c-b9ef0d0ddce6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"RandomInteger", "[", 
       RowBox[{"50", ",", "2"}], "]"}], ",", 
      RowBox[{"RandomInteger", "[", "10", "]"}]}], "]"}], ",", "100"}], "]"}],
   "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"87fd8ffa-5af6-4482-8ebb-0baf2c2bbafd"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{39, 19}], CircleBox[{27, 26}, 3], 
   CircleBox[{29, 34}, 6], CircleBox[{45, 35}, 10], CircleBox[{27, 37}, 8], 
   CircleBox[{47, 4}, 5], CircleBox[{9, 50}, 7], CircleBox[{11, 11}, 6], 
   CircleBox[{31, 45}, 5], CircleBox[{11, 35}, 0], CircleBox[{43, 41}], 
   CircleBox[{50, 7}, 0], CircleBox[{48, 22}, 7], CircleBox[{29, 41}], 
   CircleBox[{1, 18}, 10], CircleBox[{48, 16}, 3], CircleBox[{10, 1}, 3], 
   CircleBox[{7, 22}, 2], CircleBox[{14, 49}, 8], CircleBox[{49, 33}, 8], 
   CircleBox[{43, 4}, 7], CircleBox[{27, 47}, 9], CircleBox[{11, 43}, 4], 
   CircleBox[{31, 7}, 4], CircleBox[{22, 48}, 4], CircleBox[{4, 37}, 6], 
   CircleBox[{28, 37}, 3], CircleBox[{21, 50}, 0], CircleBox[{45, 47}, 8], 
   CircleBox[{0, 40}, 10], CircleBox[{3, 39}, 7], CircleBox[{1, 11}, 9], 
   CircleBox[{12, 18}], CircleBox[{4, 50}, 8], CircleBox[{22, 15}, 2], 
   CircleBox[{42, 47}, 7], CircleBox[{49, 42}, 6], CircleBox[{13, 11}], 
   CircleBox[{18, 20}], CircleBox[{13, 36}], CircleBox[{9, 42}, 7], 
   CircleBox[{43, 6}, 5], CircleBox[{33, 44}, 7], CircleBox[{48, 2}, 2], 
   CircleBox[{41, 32}, 7], CircleBox[{35, 21}, 0], CircleBox[{23, 20}, 4], 
   CircleBox[{12, 26}, 0], CircleBox[{50, 9}, 8], CircleBox[{34, 22}, 8], 
   CircleBox[{39, 41}, 3], CircleBox[{37, 1}, 0], CircleBox[{23, 7}, 0], 
   CircleBox[{40, 33}, 8], CircleBox[{10, 33}, 6], CircleBox[{46, 11}, 9], 
   CircleBox[{24, 0}, 2], CircleBox[{30, 43}, 9], CircleBox[{17, 13}, 5], 
   CircleBox[{30, 46}, 8], CircleBox[{45, 49}, 2], CircleBox[{14, 1}, 3], 
   CircleBox[{30, 15}], CircleBox[{32, 42}, 2], CircleBox[{1, 28}, 3], 
   CircleBox[{29, 37}, 3], CircleBox[{6, 49}, 5], CircleBox[{14, 6}, 6], 
   CircleBox[{7, 4}, 7], CircleBox[{21, 6}, 3], CircleBox[{26, 26}], 
   CircleBox[{13, 5}, 6], CircleBox[{9, 24}, 10], CircleBox[{27, 10}, 8], 
   CircleBox[{19, 0}, 2], CircleBox[{29, 30}, 7], CircleBox[{43, 0}, 2], 
   CircleBox[{48, 29}, 4], CircleBox[{24, 35}, 2], CircleBox[{11, 13}, 4], 
   CircleBox[{33, 7}, 0], CircleBox[{44, 16}, 7], CircleBox[{7, 35}, 0], 
   CircleBox[{3, 46}, 7], CircleBox[{18, 32}, 0], CircleBox[{27, 30}, 7], 
   CircleBox[{37, 4}, 7], CircleBox[{29, 34}, 8], CircleBox[{42, 0}, 2], 
   CircleBox[{0, 38}, 6], CircleBox[{12, 29}, 0], CircleBox[{44, 4}, 8], 
   CircleBox[{5, 12}, 7], CircleBox[{43, 7}, 4], CircleBox[{30, 49}, 6], 
   CircleBox[{13, 38}, 6], CircleBox[{17, 1}, 0], CircleBox[{19, 34}, 10], 
   CircleBox[{2, 15}, 9], CircleBox[{31, 17}, 10]},
  ImageSize->{141.5625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"1a93e032-e00a-47b6-9283-4fa32c99d2e1"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["RegularPolygon",
  BaseStyle->"Link"],
 " works much the same as ",
 ButtonBox["Circle",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Disk",
  BaseStyle->"Link"],
 ", except that in addition to giving the position of the center ",
 "and the size, you also have to specify how many sides the polygon should \
have",
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"5073db62-9698-44f1-8b63-df80c3b149af"],

Cell["\<\
Make graphics of a size-1 regular pentagon and a size-0.5 regular heptagon:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b32965d9-67f7-4119-8d48-b7ec78fe2f3b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RegularPolygon", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "1", ",", "5"}], "]"}], ",", 
    RowBox[{"RegularPolygon", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}], ",", "0.5", ",", "7"}], "]"}]}], "}"}],
   "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"9aafd539-43a7-4915-b6f9-07d2138c5223"],

Cell[BoxData[
 GraphicsBox[{
   InterpretationBox[
    PolygonBox[
     NCache[{{1 + (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 1 + Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
       1 + (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        1 + Rational[1, 4] (-1 + 5^Rational[1, 2])}, {1, 2}, {
       1 - (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        1 + Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
       1 - (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2],
         1 + Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{1.5877852522924731`, 
       0.19098300562505255`}, {1.9510565162951536`, 1.3090169943749475`}, {1, 
       2}, {0.04894348370484647, 1.3090169943749475`}, {0.41221474770752686`, 
       0.19098300562505255`}}]],
    RegularPolygon[{1, 1}, 1, 5]], 
   InterpretationBox[
    PolygonBox[{{3.216941869558779, 0.5495155660487905}, {3.4874639560909118`,
      0.8887395330218428}, {3.3909157412340147`, 1.3117449009293667`}, {3., 
     1.5}, {2.6090842587659853`, 1.3117449009293667`}, {2.5125360439090882`, 
     0.8887395330218428}, {2.783058130441221, 0.5495155660487905}}],
    RegularPolygon[{3, 1}, 0.5, 7]]},
  ImageSize->{164.625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"eabafa1c-121f-474b-9361-8fc3aff5891e"]
}, Open  ]],

Cell["You can mix different kinds of graphics objects:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b0f19e39-ca29-4c66-9a13-2545eefcf784"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RegularPolygon", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "1", ",", "5"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "]"}], ",", 
    RowBox[{"RegularPolygon", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}], ",", ".5", ",", "7"}], "]"}], ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], ",", ".5"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"fd5d7247-d67a-4879-bbe0-2054ba315038"],

Cell[BoxData[
 GraphicsBox[{
   InterpretationBox[
    PolygonBox[
     NCache[{{1 + (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 1 + Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
       1 + (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        1 + Rational[1, 4] (-1 + 5^Rational[1, 2])}, {1, 2}, {
       1 - (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        1 + Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
       1 - (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2],
         1 + Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{1.5877852522924731`, 
       0.19098300562505255`}, {1.9510565162951536`, 1.3090169943749475`}, {1, 
       2}, {0.04894348370484647, 1.3090169943749475`}, {0.41221474770752686`, 
       0.19098300562505255`}}]],
    RegularPolygon[{1, 1}, 1, 5]], CircleBox[{1, 1}], 
   InterpretationBox[
    PolygonBox[{{3.216941869558779, 0.5495155660487905}, {3.4874639560909118`,
      0.8887395330218428}, {3.3909157412340147`, 1.3117449009293667`}, {3., 
     1.5}, {2.6090842587659853`, 1.3117449009293667`}, {2.5125360439090882`, 
     0.8887395330218428}, {2.783058130441221, 0.5495155660487905}}],
    RegularPolygon[{3, 1}, 0.5, 7]], DiskBox[{2, 2}, 0.5]},
  ImageSize->{164.55078125, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"7a63a9fc-45f3-4f97-9f76-554999720ac2"]
}, Open  ]],

Cell[TextData[{
 "To make arbitrary graphics, you need the basic ",
 StyleBox["graphics primitives",
  FontSlant->"Italic"],
 " ",
 ButtonBox["Point",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Line",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Polygon",
  BaseStyle->"Link"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Point",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "CodeVariable"], ",", 
     StyleBox["y", "CodeVariable"]}], "}"}], "]"}]], "InlineCodeText",
  ExpressionUUID->"04fef061-8727-49a4-a464-7a1b5294b018"],
 " represents a point at coordinate position ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "CodeVariable"], ",", 
    StyleBox["y", "CodeVariable"]}], "}"}]], "InlineCodeText",ExpressionUUID->
  "cc17cfa0-6c38-49bc-bc91-1c1adc5051f8"],
 ". To get multiple points, you can either give a list of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Point",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "CodeVariable"], ",", 
     StyleBox["y", "CodeVariable"]}], "}"}], "]"}]], "InlineCodeText",
  ExpressionUUID->"83abe570-378f-4e05-8416-a0585ac19f87"],
 "s, or you can give a list of coordinate positions inside a single ",
 ButtonBox["Point",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"89b18744-5460-406f-a016-e87ec36ffbbd"],

Cell["Graphics of three points at specified positions:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"24f05b29-32e3-4b37-864a-dbb356e4a39c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.5"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"cd819b67-4329-4fa2-bbdb-0d3fc6459ed0"],

Cell[BoxData[
 GraphicsBox[{PointBox[{0, 0}], PointBox[{2, 0}], PointBox[{1, 1.5}]},
  ImageSize->{111.74609375, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[16]=",ExpressionUUID->"4387f9a2-704f-4069-9ba1-fffbda2a6f4d"]
}, Open  ]],

Cell["\<\
An alternative form, where all the coordinate positions are collected in a \
single list:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:67",ExpressionUUID->"b83e2405-b279-495f-9235-0cc51a48d4d4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.5"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"ea2cb09c-36c9-45a9-bd87-e436072a30eb"],

Cell[BoxData[
 GraphicsBox[PointBox[{{0, 0}, {2, 0}, {1, 1.5}}],
  ImageSize->{120.1484375, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"a551802e-93d7-4574-89a9-4c563576cf27"]
}, Open  ]],

Cell["Make a line joining the positions:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"ea0fd7fa-ab99-4390-a28f-9c5bb79a7304"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.5"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"9fbf4cc8-4df2-4c6c-ac66-e33e06473aef"],

Cell[BoxData[
 GraphicsBox[LineBox[{{0, 0}, {2, 0}, {1, 1.5}}],
  ImageSize->{117.6953125, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"1a7e82d3-c538-4c3a-8e6a-8a02f7df853b"]
}, Open  ]],

Cell["Make a polygon with corners at the positions you give:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"e57eb57d-0e95-433a-a272-18da890cf154"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.5"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"c989009b-f373-4606-b712-ee57ae9dfe03"],

Cell[BoxData[
 GraphicsBox[PolygonBox[{{0, 0}, {2, 0}, {1, 1.5}}],
  ImageSize->{117.890625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"085534b1-9899-4d86-822e-0a80c8d01521"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["RegularPolygon",
  BaseStyle->"Link"],
 " makes a regular polygon in which all sides and angles are the same. ",
 ButtonBox["Polygon",
  BaseStyle->"Link"],
 " lets you make any polygon, even strange ones that fold over themselves. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"86a81036-e3e8-424f-a03c-5c020e9fff7e"],

Cell["\<\
A polygon with 20 corners at random coordinates below 100; the polygon folds \
over itself:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6923c658-c06b-4923-b880-f1478e68593f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", "100", "]"}], ",", "20", ",", "2"}], "]"}],
    "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"50566354-93dc-4580-830f-1bdffa6eef9a"],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[{{28, 55}, {14, 45}, {55, 14}, {10, 83}, {87, 65}, {14, 100}, {
   65, 75}, {98, 9}, {14, 84}, {40, 23}, {36, 49}, {2, 72}, {37, 77}, {43, 
   70}, {12, 35}, {31, 5}, {69, 99}, {62, 17}, {56, 28}, {39, 10}}],
  ImageSize->{160.015625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[20]=",ExpressionUUID->"764bfe33-500f-4d84-bb95-000c3717f3cb"]
}, Open  ]],

Cell[TextData[{
 "The things we\[CloseCurlyQuote]ve done so far here immediately generalize \
to 3D. Instead of having two coordinates {",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "} we have three: {",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y, z",
  FontSlant->"Italic"],
 "}. In the Wolfram Language, ",
 StyleBox["x",
  FontSlant->"Italic"],
 " by default goes across the screen, ",
 StyleBox["y",
  FontSlant->"Italic"],
 " goes \[OpenCurlyDoubleQuote]into\[CloseCurlyDoubleQuote] the screen, and \
",
 StyleBox["z",
  FontSlant->"Italic"],
 " goes up the screen."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:68", "i:11"},ExpressionUUID->"607a42cf-1a21-498f-8042-0c83bf766fd8"],

Cell["Two spheres stacked on top of each other:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2fc3c8a5-9ca0-4cc2-a334-67e289957955"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"080292c8-8d02-4b04-8f23-4399a944675e"],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], SphereBox[{0, 0, 2}]},
  ImageSize->{109.50206211813634`, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"c9d63797-3bd8-48ec-84da-e1c68229dce9"]
}, Open  ]],

Cell["A 3D array of spheres (radius 1/2 makes them just touch):", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d2d04f59-7b13-443d-a69f-ab5d60ad57cd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"1", "/", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"793fef98-383f-4b8f-82a9-307004716a4e"],

Cell[BoxData[
 Graphics3DBox[{{{SphereBox[{1, 1, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 1, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 1, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 1, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 1, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{1, 2, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 2, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 2, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 2, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 2, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{1, 3, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 3, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 3, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 3, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 3, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{1, 4, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 4, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 4, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 4, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 4, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{1, 5, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 5, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 5, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 5, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{1, 5, 5}, NCache[Rational[1, 2], 0.5]]}}, {{
     SphereBox[{2, 1, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 1, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 1, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 1, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 1, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{2, 2, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 2, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 2, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 2, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 2, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{2, 3, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 3, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 3, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 3, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 3, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{2, 4, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 4, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 4, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 4, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 4, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{2, 5, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 5, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 5, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 5, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{2, 5, 5}, NCache[Rational[1, 2], 0.5]]}}, {{
     SphereBox[{3, 1, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 1, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 1, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 1, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 1, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{3, 2, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 2, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 2, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 2, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 2, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{3, 3, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 3, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 3, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 3, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 3, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{3, 4, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 4, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 4, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 4, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 4, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{3, 5, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 5, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 5, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 5, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{3, 5, 5}, NCache[Rational[1, 2], 0.5]]}}, {{
     SphereBox[{4, 1, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 1, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 1, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 1, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 1, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{4, 2, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 2, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 2, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 2, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 2, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{4, 3, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 3, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 3, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 3, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 3, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{4, 4, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 4, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 4, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 4, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 4, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{4, 5, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 5, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 5, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 5, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{4, 5, 5}, NCache[Rational[1, 2], 0.5]]}}, {{
     SphereBox[{5, 1, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 1, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 1, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 1, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 1, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{5, 2, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 2, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 2, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 2, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 2, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{5, 3, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 3, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 3, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 3, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 3, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{5, 4, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 4, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 4, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 4, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 4, 5}, NCache[Rational[1, 2], 0.5]]}, {
     SphereBox[{5, 5, 1}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 5, 2}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 5, 3}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 5, 4}, NCache[Rational[1, 2], 0.5]], 
     SphereBox[{5, 5, 5}, NCache[Rational[1, 2], 0.5]]}}},
  ImageSize->{135.328125, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"e354eda8-eb5b-4210-a91d-f0b89caf7b17"]
}, Open  ]],

Cell["A 3D array of points:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"48ef6213-33ba-40ac-8299-7e59b68fdb10"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"82ff4cdb-84a6-422f-be54-4c1fa1623056"],

Cell[BoxData[
 Graphics3DBox[{{{Point3DBox[{1, 1, 1}], Point3DBox[{1, 1, 2}], 
     Point3DBox[{1, 1, 3}], Point3DBox[{1, 1, 4}], Point3DBox[{1, 1, 5}], 
     Point3DBox[{1, 1, 6}], Point3DBox[{1, 1, 7}], Point3DBox[{1, 1, 8}], 
     Point3DBox[{1, 1, 9}], Point3DBox[{1, 1, 10}]}, {Point3DBox[{1, 2, 1}], 
     Point3DBox[{1, 2, 2}], Point3DBox[{1, 2, 3}], Point3DBox[{1, 2, 4}], 
     Point3DBox[{1, 2, 5}], Point3DBox[{1, 2, 6}], Point3DBox[{1, 2, 7}], 
     Point3DBox[{1, 2, 8}], Point3DBox[{1, 2, 9}], Point3DBox[{1, 2, 10}]}, {
     Point3DBox[{1, 3, 1}], Point3DBox[{1, 3, 2}], Point3DBox[{1, 3, 3}], 
     Point3DBox[{1, 3, 4}], Point3DBox[{1, 3, 5}], Point3DBox[{1, 3, 6}], 
     Point3DBox[{1, 3, 7}], Point3DBox[{1, 3, 8}], Point3DBox[{1, 3, 9}], 
     Point3DBox[{1, 3, 10}]}, {Point3DBox[{1, 4, 1}], Point3DBox[{1, 4, 2}], 
     Point3DBox[{1, 4, 3}], Point3DBox[{1, 4, 4}], Point3DBox[{1, 4, 5}], 
     Point3DBox[{1, 4, 6}], Point3DBox[{1, 4, 7}], Point3DBox[{1, 4, 8}], 
     Point3DBox[{1, 4, 9}], Point3DBox[{1, 4, 10}]}, {Point3DBox[{1, 5, 1}], 
     Point3DBox[{1, 5, 2}], Point3DBox[{1, 5, 3}], Point3DBox[{1, 5, 4}], 
     Point3DBox[{1, 5, 5}], Point3DBox[{1, 5, 6}], Point3DBox[{1, 5, 7}], 
     Point3DBox[{1, 5, 8}], Point3DBox[{1, 5, 9}], Point3DBox[{1, 5, 10}]}, {
     Point3DBox[{1, 6, 1}], Point3DBox[{1, 6, 2}], Point3DBox[{1, 6, 3}], 
     Point3DBox[{1, 6, 4}], Point3DBox[{1, 6, 5}], Point3DBox[{1, 6, 6}], 
     Point3DBox[{1, 6, 7}], Point3DBox[{1, 6, 8}], Point3DBox[{1, 6, 9}], 
     Point3DBox[{1, 6, 10}]}, {Point3DBox[{1, 7, 1}], Point3DBox[{1, 7, 2}], 
     Point3DBox[{1, 7, 3}], Point3DBox[{1, 7, 4}], Point3DBox[{1, 7, 5}], 
     Point3DBox[{1, 7, 6}], Point3DBox[{1, 7, 7}], Point3DBox[{1, 7, 8}], 
     Point3DBox[{1, 7, 9}], Point3DBox[{1, 7, 10}]}, {Point3DBox[{1, 8, 1}], 
     Point3DBox[{1, 8, 2}], Point3DBox[{1, 8, 3}], Point3DBox[{1, 8, 4}], 
     Point3DBox[{1, 8, 5}], Point3DBox[{1, 8, 6}], Point3DBox[{1, 8, 7}], 
     Point3DBox[{1, 8, 8}], Point3DBox[{1, 8, 9}], Point3DBox[{1, 8, 10}]}, {
     Point3DBox[{1, 9, 1}], Point3DBox[{1, 9, 2}], Point3DBox[{1, 9, 3}], 
     Point3DBox[{1, 9, 4}], Point3DBox[{1, 9, 5}], Point3DBox[{1, 9, 6}], 
     Point3DBox[{1, 9, 7}], Point3DBox[{1, 9, 8}], Point3DBox[{1, 9, 9}], 
     Point3DBox[{1, 9, 10}]}, {Point3DBox[{1, 10, 1}], Point3DBox[{1, 10, 2}],
      Point3DBox[{1, 10, 3}], Point3DBox[{1, 10, 4}], Point3DBox[{1, 10, 5}], 
     Point3DBox[{1, 10, 6}], Point3DBox[{1, 10, 7}], Point3DBox[{1, 10, 8}], 
     Point3DBox[{1, 10, 9}], Point3DBox[{1, 10, 10}]}}, {{
     Point3DBox[{2, 1, 1}], Point3DBox[{2, 1, 2}], Point3DBox[{2, 1, 3}], 
     Point3DBox[{2, 1, 4}], Point3DBox[{2, 1, 5}], Point3DBox[{2, 1, 6}], 
     Point3DBox[{2, 1, 7}], Point3DBox[{2, 1, 8}], Point3DBox[{2, 1, 9}], 
     Point3DBox[{2, 1, 10}]}, {Point3DBox[{2, 2, 1}], Point3DBox[{2, 2, 2}], 
     Point3DBox[{2, 2, 3}], Point3DBox[{2, 2, 4}], Point3DBox[{2, 2, 5}], 
     Point3DBox[{2, 2, 6}], Point3DBox[{2, 2, 7}], Point3DBox[{2, 2, 8}], 
     Point3DBox[{2, 2, 9}], Point3DBox[{2, 2, 10}]}, {Point3DBox[{2, 3, 1}], 
     Point3DBox[{2, 3, 2}], Point3DBox[{2, 3, 3}], Point3DBox[{2, 3, 4}], 
     Point3DBox[{2, 3, 5}], Point3DBox[{2, 3, 6}], Point3DBox[{2, 3, 7}], 
     Point3DBox[{2, 3, 8}], Point3DBox[{2, 3, 9}], Point3DBox[{2, 3, 10}]}, {
     Point3DBox[{2, 4, 1}], Point3DBox[{2, 4, 2}], Point3DBox[{2, 4, 3}], 
     Point3DBox[{2, 4, 4}], Point3DBox[{2, 4, 5}], Point3DBox[{2, 4, 6}], 
     Point3DBox[{2, 4, 7}], Point3DBox[{2, 4, 8}], Point3DBox[{2, 4, 9}], 
     Point3DBox[{2, 4, 10}]}, {Point3DBox[{2, 5, 1}], Point3DBox[{2, 5, 2}], 
     Point3DBox[{2, 5, 3}], Point3DBox[{2, 5, 4}], Point3DBox[{2, 5, 5}], 
     Point3DBox[{2, 5, 6}], Point3DBox[{2, 5, 7}], Point3DBox[{2, 5, 8}], 
     Point3DBox[{2, 5, 9}], Point3DBox[{2, 5, 10}]}, {Point3DBox[{2, 6, 1}], 
     Point3DBox[{2, 6, 2}], Point3DBox[{2, 6, 3}], Point3DBox[{2, 6, 4}], 
     Point3DBox[{2, 6, 5}], Point3DBox[{2, 6, 6}], Point3DBox[{2, 6, 7}], 
     Point3DBox[{2, 6, 8}], Point3DBox[{2, 6, 9}], Point3DBox[{2, 6, 10}]}, {
     Point3DBox[{2, 7, 1}], Point3DBox[{2, 7, 2}], Point3DBox[{2, 7, 3}], 
     Point3DBox[{2, 7, 4}], Point3DBox[{2, 7, 5}], Point3DBox[{2, 7, 6}], 
     Point3DBox[{2, 7, 7}], Point3DBox[{2, 7, 8}], Point3DBox[{2, 7, 9}], 
     Point3DBox[{2, 7, 10}]}, {Point3DBox[{2, 8, 1}], Point3DBox[{2, 8, 2}], 
     Point3DBox[{2, 8, 3}], Point3DBox[{2, 8, 4}], Point3DBox[{2, 8, 5}], 
     Point3DBox[{2, 8, 6}], Point3DBox[{2, 8, 7}], Point3DBox[{2, 8, 8}], 
     Point3DBox[{2, 8, 9}], Point3DBox[{2, 8, 10}]}, {Point3DBox[{2, 9, 1}], 
     Point3DBox[{2, 9, 2}], Point3DBox[{2, 9, 3}], Point3DBox[{2, 9, 4}], 
     Point3DBox[{2, 9, 5}], Point3DBox[{2, 9, 6}], Point3DBox[{2, 9, 7}], 
     Point3DBox[{2, 9, 8}], Point3DBox[{2, 9, 9}], Point3DBox[{2, 9, 10}]}, {
     Point3DBox[{2, 10, 1}], Point3DBox[{2, 10, 2}], Point3DBox[{2, 10, 3}], 
     Point3DBox[{2, 10, 4}], Point3DBox[{2, 10, 5}], Point3DBox[{2, 10, 6}], 
     Point3DBox[{2, 10, 7}], Point3DBox[{2, 10, 8}], Point3DBox[{2, 10, 9}], 
     Point3DBox[{2, 10, 10}]}}, {{Point3DBox[{3, 1, 1}], 
     Point3DBox[{3, 1, 2}], Point3DBox[{3, 1, 3}], Point3DBox[{3, 1, 4}], 
     Point3DBox[{3, 1, 5}], Point3DBox[{3, 1, 6}], Point3DBox[{3, 1, 7}], 
     Point3DBox[{3, 1, 8}], Point3DBox[{3, 1, 9}], Point3DBox[{3, 1, 10}]}, {
     Point3DBox[{3, 2, 1}], Point3DBox[{3, 2, 2}], Point3DBox[{3, 2, 3}], 
     Point3DBox[{3, 2, 4}], Point3DBox[{3, 2, 5}], Point3DBox[{3, 2, 6}], 
     Point3DBox[{3, 2, 7}], Point3DBox[{3, 2, 8}], Point3DBox[{3, 2, 9}], 
     Point3DBox[{3, 2, 10}]}, {Point3DBox[{3, 3, 1}], Point3DBox[{3, 3, 2}], 
     Point3DBox[{3, 3, 3}], Point3DBox[{3, 3, 4}], Point3DBox[{3, 3, 5}], 
     Point3DBox[{3, 3, 6}], Point3DBox[{3, 3, 7}], Point3DBox[{3, 3, 8}], 
     Point3DBox[{3, 3, 9}], Point3DBox[{3, 3, 10}]}, {Point3DBox[{3, 4, 1}], 
     Point3DBox[{3, 4, 2}], Point3DBox[{3, 4, 3}], Point3DBox[{3, 4, 4}], 
     Point3DBox[{3, 4, 5}], Point3DBox[{3, 4, 6}], Point3DBox[{3, 4, 7}], 
     Point3DBox[{3, 4, 8}], Point3DBox[{3, 4, 9}], Point3DBox[{3, 4, 10}]}, {
     Point3DBox[{3, 5, 1}], Point3DBox[{3, 5, 2}], Point3DBox[{3, 5, 3}], 
     Point3DBox[{3, 5, 4}], Point3DBox[{3, 5, 5}], Point3DBox[{3, 5, 6}], 
     Point3DBox[{3, 5, 7}], Point3DBox[{3, 5, 8}], Point3DBox[{3, 5, 9}], 
     Point3DBox[{3, 5, 10}]}, {Point3DBox[{3, 6, 1}], Point3DBox[{3, 6, 2}], 
     Point3DBox[{3, 6, 3}], Point3DBox[{3, 6, 4}], Point3DBox[{3, 6, 5}], 
     Point3DBox[{3, 6, 6}], Point3DBox[{3, 6, 7}], Point3DBox[{3, 6, 8}], 
     Point3DBox[{3, 6, 9}], Point3DBox[{3, 6, 10}]}, {Point3DBox[{3, 7, 1}], 
     Point3DBox[{3, 7, 2}], Point3DBox[{3, 7, 3}], Point3DBox[{3, 7, 4}], 
     Point3DBox[{3, 7, 5}], Point3DBox[{3, 7, 6}], Point3DBox[{3, 7, 7}], 
     Point3DBox[{3, 7, 8}], Point3DBox[{3, 7, 9}], Point3DBox[{3, 7, 10}]}, {
     Point3DBox[{3, 8, 1}], Point3DBox[{3, 8, 2}], Point3DBox[{3, 8, 3}], 
     Point3DBox[{3, 8, 4}], Point3DBox[{3, 8, 5}], Point3DBox[{3, 8, 6}], 
     Point3DBox[{3, 8, 7}], Point3DBox[{3, 8, 8}], Point3DBox[{3, 8, 9}], 
     Point3DBox[{3, 8, 10}]}, {Point3DBox[{3, 9, 1}], Point3DBox[{3, 9, 2}], 
     Point3DBox[{3, 9, 3}], Point3DBox[{3, 9, 4}], Point3DBox[{3, 9, 5}], 
     Point3DBox[{3, 9, 6}], Point3DBox[{3, 9, 7}], Point3DBox[{3, 9, 8}], 
     Point3DBox[{3, 9, 9}], Point3DBox[{3, 9, 10}]}, {Point3DBox[{3, 10, 1}], 
     Point3DBox[{3, 10, 2}], Point3DBox[{3, 10, 3}], Point3DBox[{3, 10, 4}], 
     Point3DBox[{3, 10, 5}], Point3DBox[{3, 10, 6}], Point3DBox[{3, 10, 7}], 
     Point3DBox[{3, 10, 8}], Point3DBox[{3, 10, 9}], 
     Point3DBox[{3, 10, 10}]}}, {{Point3DBox[{4, 1, 1}], 
     Point3DBox[{4, 1, 2}], Point3DBox[{4, 1, 3}], Point3DBox[{4, 1, 4}], 
     Point3DBox[{4, 1, 5}], Point3DBox[{4, 1, 6}], Point3DBox[{4, 1, 7}], 
     Point3DBox[{4, 1, 8}], Point3DBox[{4, 1, 9}], Point3DBox[{4, 1, 10}]}, {
     Point3DBox[{4, 2, 1}], Point3DBox[{4, 2, 2}], Point3DBox[{4, 2, 3}], 
     Point3DBox[{4, 2, 4}], Point3DBox[{4, 2, 5}], Point3DBox[{4, 2, 6}], 
     Point3DBox[{4, 2, 7}], Point3DBox[{4, 2, 8}], Point3DBox[{4, 2, 9}], 
     Point3DBox[{4, 2, 10}]}, {Point3DBox[{4, 3, 1}], Point3DBox[{4, 3, 2}], 
     Point3DBox[{4, 3, 3}], Point3DBox[{4, 3, 4}], Point3DBox[{4, 3, 5}], 
     Point3DBox[{4, 3, 6}], Point3DBox[{4, 3, 7}], Point3DBox[{4, 3, 8}], 
     Point3DBox[{4, 3, 9}], Point3DBox[{4, 3, 10}]}, {Point3DBox[{4, 4, 1}], 
     Point3DBox[{4, 4, 2}], Point3DBox[{4, 4, 3}], Point3DBox[{4, 4, 4}], 
     Point3DBox[{4, 4, 5}], Point3DBox[{4, 4, 6}], Point3DBox[{4, 4, 7}], 
     Point3DBox[{4, 4, 8}], Point3DBox[{4, 4, 9}], Point3DBox[{4, 4, 10}]}, {
     Point3DBox[{4, 5, 1}], Point3DBox[{4, 5, 2}], Point3DBox[{4, 5, 3}], 
     Point3DBox[{4, 5, 4}], Point3DBox[{4, 5, 5}], Point3DBox[{4, 5, 6}], 
     Point3DBox[{4, 5, 7}], Point3DBox[{4, 5, 8}], Point3DBox[{4, 5, 9}], 
     Point3DBox[{4, 5, 10}]}, {Point3DBox[{4, 6, 1}], Point3DBox[{4, 6, 2}], 
     Point3DBox[{4, 6, 3}], Point3DBox[{4, 6, 4}], Point3DBox[{4, 6, 5}], 
     Point3DBox[{4, 6, 6}], Point3DBox[{4, 6, 7}], Point3DBox[{4, 6, 8}], 
     Point3DBox[{4, 6, 9}], Point3DBox[{4, 6, 10}]}, {Point3DBox[{4, 7, 1}], 
     Point3DBox[{4, 7, 2}], Point3DBox[{4, 7, 3}], Point3DBox[{4, 7, 4}], 
     Point3DBox[{4, 7, 5}], Point3DBox[{4, 7, 6}], Point3DBox[{4, 7, 7}], 
     Point3DBox[{4, 7, 8}], Point3DBox[{4, 7, 9}], Point3DBox[{4, 7, 10}]}, {
     Point3DBox[{4, 8, 1}], Point3DBox[{4, 8, 2}], Point3DBox[{4, 8, 3}], 
     Point3DBox[{4, 8, 4}], Point3DBox[{4, 8, 5}], Point3DBox[{4, 8, 6}], 
     Point3DBox[{4, 8, 7}], Point3DBox[{4, 8, 8}], Point3DBox[{4, 8, 9}], 
     Point3DBox[{4, 8, 10}]}, {Point3DBox[{4, 9, 1}], Point3DBox[{4, 9, 2}], 
     Point3DBox[{4, 9, 3}], Point3DBox[{4, 9, 4}], Point3DBox[{4, 9, 5}], 
     Point3DBox[{4, 9, 6}], Point3DBox[{4, 9, 7}], Point3DBox[{4, 9, 8}], 
     Point3DBox[{4, 9, 9}], Point3DBox[{4, 9, 10}]}, {Point3DBox[{4, 10, 1}], 
     Point3DBox[{4, 10, 2}], Point3DBox[{4, 10, 3}], Point3DBox[{4, 10, 4}], 
     Point3DBox[{4, 10, 5}], Point3DBox[{4, 10, 6}], Point3DBox[{4, 10, 7}], 
     Point3DBox[{4, 10, 8}], Point3DBox[{4, 10, 9}], 
     Point3DBox[{4, 10, 10}]}}, {{Point3DBox[{5, 1, 1}], 
     Point3DBox[{5, 1, 2}], Point3DBox[{5, 1, 3}], Point3DBox[{5, 1, 4}], 
     Point3DBox[{5, 1, 5}], Point3DBox[{5, 1, 6}], Point3DBox[{5, 1, 7}], 
     Point3DBox[{5, 1, 8}], Point3DBox[{5, 1, 9}], Point3DBox[{5, 1, 10}]}, {
     Point3DBox[{5, 2, 1}], Point3DBox[{5, 2, 2}], Point3DBox[{5, 2, 3}], 
     Point3DBox[{5, 2, 4}], Point3DBox[{5, 2, 5}], Point3DBox[{5, 2, 6}], 
     Point3DBox[{5, 2, 7}], Point3DBox[{5, 2, 8}], Point3DBox[{5, 2, 9}], 
     Point3DBox[{5, 2, 10}]}, {Point3DBox[{5, 3, 1}], Point3DBox[{5, 3, 2}], 
     Point3DBox[{5, 3, 3}], Point3DBox[{5, 3, 4}], Point3DBox[{5, 3, 5}], 
     Point3DBox[{5, 3, 6}], Point3DBox[{5, 3, 7}], Point3DBox[{5, 3, 8}], 
     Point3DBox[{5, 3, 9}], Point3DBox[{5, 3, 10}]}, {Point3DBox[{5, 4, 1}], 
     Point3DBox[{5, 4, 2}], Point3DBox[{5, 4, 3}], Point3DBox[{5, 4, 4}], 
     Point3DBox[{5, 4, 5}], Point3DBox[{5, 4, 6}], Point3DBox[{5, 4, 7}], 
     Point3DBox[{5, 4, 8}], Point3DBox[{5, 4, 9}], Point3DBox[{5, 4, 10}]}, {
     Point3DBox[{5, 5, 1}], Point3DBox[{5, 5, 2}], Point3DBox[{5, 5, 3}], 
     Point3DBox[{5, 5, 4}], Point3DBox[{5, 5, 5}], Point3DBox[{5, 5, 6}], 
     Point3DBox[{5, 5, 7}], Point3DBox[{5, 5, 8}], Point3DBox[{5, 5, 9}], 
     Point3DBox[{5, 5, 10}]}, {Point3DBox[{5, 6, 1}], Point3DBox[{5, 6, 2}], 
     Point3DBox[{5, 6, 3}], Point3DBox[{5, 6, 4}], Point3DBox[{5, 6, 5}], 
     Point3DBox[{5, 6, 6}], Point3DBox[{5, 6, 7}], Point3DBox[{5, 6, 8}], 
     Point3DBox[{5, 6, 9}], Point3DBox[{5, 6, 10}]}, {Point3DBox[{5, 7, 1}], 
     Point3DBox[{5, 7, 2}], Point3DBox[{5, 7, 3}], Point3DBox[{5, 7, 4}], 
     Point3DBox[{5, 7, 5}], Point3DBox[{5, 7, 6}], Point3DBox[{5, 7, 7}], 
     Point3DBox[{5, 7, 8}], Point3DBox[{5, 7, 9}], Point3DBox[{5, 7, 10}]}, {
     Point3DBox[{5, 8, 1}], Point3DBox[{5, 8, 2}], Point3DBox[{5, 8, 3}], 
     Point3DBox[{5, 8, 4}], Point3DBox[{5, 8, 5}], Point3DBox[{5, 8, 6}], 
     Point3DBox[{5, 8, 7}], Point3DBox[{5, 8, 8}], Point3DBox[{5, 8, 9}], 
     Point3DBox[{5, 8, 10}]}, {Point3DBox[{5, 9, 1}], Point3DBox[{5, 9, 2}], 
     Point3DBox[{5, 9, 3}], Point3DBox[{5, 9, 4}], Point3DBox[{5, 9, 5}], 
     Point3DBox[{5, 9, 6}], Point3DBox[{5, 9, 7}], Point3DBox[{5, 9, 8}], 
     Point3DBox[{5, 9, 9}], Point3DBox[{5, 9, 10}]}, {Point3DBox[{5, 10, 1}], 
     Point3DBox[{5, 10, 2}], Point3DBox[{5, 10, 3}], Point3DBox[{5, 10, 4}], 
     Point3DBox[{5, 10, 5}], Point3DBox[{5, 10, 6}], Point3DBox[{5, 10, 7}], 
     Point3DBox[{5, 10, 8}], Point3DBox[{5, 10, 9}], 
     Point3DBox[{5, 10, 10}]}}, {{Point3DBox[{6, 1, 1}], 
     Point3DBox[{6, 1, 2}], Point3DBox[{6, 1, 3}], Point3DBox[{6, 1, 4}], 
     Point3DBox[{6, 1, 5}], Point3DBox[{6, 1, 6}], Point3DBox[{6, 1, 7}], 
     Point3DBox[{6, 1, 8}], Point3DBox[{6, 1, 9}], Point3DBox[{6, 1, 10}]}, {
     Point3DBox[{6, 2, 1}], Point3DBox[{6, 2, 2}], Point3DBox[{6, 2, 3}], 
     Point3DBox[{6, 2, 4}], Point3DBox[{6, 2, 5}], Point3DBox[{6, 2, 6}], 
     Point3DBox[{6, 2, 7}], Point3DBox[{6, 2, 8}], Point3DBox[{6, 2, 9}], 
     Point3DBox[{6, 2, 10}]}, {Point3DBox[{6, 3, 1}], Point3DBox[{6, 3, 2}], 
     Point3DBox[{6, 3, 3}], Point3DBox[{6, 3, 4}], Point3DBox[{6, 3, 5}], 
     Point3DBox[{6, 3, 6}], Point3DBox[{6, 3, 7}], Point3DBox[{6, 3, 8}], 
     Point3DBox[{6, 3, 9}], Point3DBox[{6, 3, 10}]}, {Point3DBox[{6, 4, 1}], 
     Point3DBox[{6, 4, 2}], Point3DBox[{6, 4, 3}], Point3DBox[{6, 4, 4}], 
     Point3DBox[{6, 4, 5}], Point3DBox[{6, 4, 6}], Point3DBox[{6, 4, 7}], 
     Point3DBox[{6, 4, 8}], Point3DBox[{6, 4, 9}], Point3DBox[{6, 4, 10}]}, {
     Point3DBox[{6, 5, 1}], Point3DBox[{6, 5, 2}], Point3DBox[{6, 5, 3}], 
     Point3DBox[{6, 5, 4}], Point3DBox[{6, 5, 5}], Point3DBox[{6, 5, 6}], 
     Point3DBox[{6, 5, 7}], Point3DBox[{6, 5, 8}], Point3DBox[{6, 5, 9}], 
     Point3DBox[{6, 5, 10}]}, {Point3DBox[{6, 6, 1}], Point3DBox[{6, 6, 2}], 
     Point3DBox[{6, 6, 3}], Point3DBox[{6, 6, 4}], Point3DBox[{6, 6, 5}], 
     Point3DBox[{6, 6, 6}], Point3DBox[{6, 6, 7}], Point3DBox[{6, 6, 8}], 
     Point3DBox[{6, 6, 9}], Point3DBox[{6, 6, 10}]}, {Point3DBox[{6, 7, 1}], 
     Point3DBox[{6, 7, 2}], Point3DBox[{6, 7, 3}], Point3DBox[{6, 7, 4}], 
     Point3DBox[{6, 7, 5}], Point3DBox[{6, 7, 6}], Point3DBox[{6, 7, 7}], 
     Point3DBox[{6, 7, 8}], Point3DBox[{6, 7, 9}], Point3DBox[{6, 7, 10}]}, {
     Point3DBox[{6, 8, 1}], Point3DBox[{6, 8, 2}], Point3DBox[{6, 8, 3}], 
     Point3DBox[{6, 8, 4}], Point3DBox[{6, 8, 5}], Point3DBox[{6, 8, 6}], 
     Point3DBox[{6, 8, 7}], Point3DBox[{6, 8, 8}], Point3DBox[{6, 8, 9}], 
     Point3DBox[{6, 8, 10}]}, {Point3DBox[{6, 9, 1}], Point3DBox[{6, 9, 2}], 
     Point3DBox[{6, 9, 3}], Point3DBox[{6, 9, 4}], Point3DBox[{6, 9, 5}], 
     Point3DBox[{6, 9, 6}], Point3DBox[{6, 9, 7}], Point3DBox[{6, 9, 8}], 
     Point3DBox[{6, 9, 9}], Point3DBox[{6, 9, 10}]}, {Point3DBox[{6, 10, 1}], 
     Point3DBox[{6, 10, 2}], Point3DBox[{6, 10, 3}], Point3DBox[{6, 10, 4}], 
     Point3DBox[{6, 10, 5}], Point3DBox[{6, 10, 6}], Point3DBox[{6, 10, 7}], 
     Point3DBox[{6, 10, 8}], Point3DBox[{6, 10, 9}], 
     Point3DBox[{6, 10, 10}]}}, {{Point3DBox[{7, 1, 1}], 
     Point3DBox[{7, 1, 2}], Point3DBox[{7, 1, 3}], Point3DBox[{7, 1, 4}], 
     Point3DBox[{7, 1, 5}], Point3DBox[{7, 1, 6}], Point3DBox[{7, 1, 7}], 
     Point3DBox[{7, 1, 8}], Point3DBox[{7, 1, 9}], Point3DBox[{7, 1, 10}]}, {
     Point3DBox[{7, 2, 1}], Point3DBox[{7, 2, 2}], Point3DBox[{7, 2, 3}], 
     Point3DBox[{7, 2, 4}], Point3DBox[{7, 2, 5}], Point3DBox[{7, 2, 6}], 
     Point3DBox[{7, 2, 7}], Point3DBox[{7, 2, 8}], Point3DBox[{7, 2, 9}], 
     Point3DBox[{7, 2, 10}]}, {Point3DBox[{7, 3, 1}], Point3DBox[{7, 3, 2}], 
     Point3DBox[{7, 3, 3}], Point3DBox[{7, 3, 4}], Point3DBox[{7, 3, 5}], 
     Point3DBox[{7, 3, 6}], Point3DBox[{7, 3, 7}], Point3DBox[{7, 3, 8}], 
     Point3DBox[{7, 3, 9}], Point3DBox[{7, 3, 10}]}, {Point3DBox[{7, 4, 1}], 
     Point3DBox[{7, 4, 2}], Point3DBox[{7, 4, 3}], Point3DBox[{7, 4, 4}], 
     Point3DBox[{7, 4, 5}], Point3DBox[{7, 4, 6}], Point3DBox[{7, 4, 7}], 
     Point3DBox[{7, 4, 8}], Point3DBox[{7, 4, 9}], Point3DBox[{7, 4, 10}]}, {
     Point3DBox[{7, 5, 1}], Point3DBox[{7, 5, 2}], Point3DBox[{7, 5, 3}], 
     Point3DBox[{7, 5, 4}], Point3DBox[{7, 5, 5}], Point3DBox[{7, 5, 6}], 
     Point3DBox[{7, 5, 7}], Point3DBox[{7, 5, 8}], Point3DBox[{7, 5, 9}], 
     Point3DBox[{7, 5, 10}]}, {Point3DBox[{7, 6, 1}], Point3DBox[{7, 6, 2}], 
     Point3DBox[{7, 6, 3}], Point3DBox[{7, 6, 4}], Point3DBox[{7, 6, 5}], 
     Point3DBox[{7, 6, 6}], Point3DBox[{7, 6, 7}], Point3DBox[{7, 6, 8}], 
     Point3DBox[{7, 6, 9}], Point3DBox[{7, 6, 10}]}, {Point3DBox[{7, 7, 1}], 
     Point3DBox[{7, 7, 2}], Point3DBox[{7, 7, 3}], Point3DBox[{7, 7, 4}], 
     Point3DBox[{7, 7, 5}], Point3DBox[{7, 7, 6}], Point3DBox[{7, 7, 7}], 
     Point3DBox[{7, 7, 8}], Point3DBox[{7, 7, 9}], Point3DBox[{7, 7, 10}]}, {
     Point3DBox[{7, 8, 1}], Point3DBox[{7, 8, 2}], Point3DBox[{7, 8, 3}], 
     Point3DBox[{7, 8, 4}], Point3DBox[{7, 8, 5}], Point3DBox[{7, 8, 6}], 
     Point3DBox[{7, 8, 7}], Point3DBox[{7, 8, 8}], Point3DBox[{7, 8, 9}], 
     Point3DBox[{7, 8, 10}]}, {Point3DBox[{7, 9, 1}], Point3DBox[{7, 9, 2}], 
     Point3DBox[{7, 9, 3}], Point3DBox[{7, 9, 4}], Point3DBox[{7, 9, 5}], 
     Point3DBox[{7, 9, 6}], Point3DBox[{7, 9, 7}], Point3DBox[{7, 9, 8}], 
     Point3DBox[{7, 9, 9}], Point3DBox[{7, 9, 10}]}, {Point3DBox[{7, 10, 1}], 
     Point3DBox[{7, 10, 2}], Point3DBox[{7, 10, 3}], Point3DBox[{7, 10, 4}], 
     Point3DBox[{7, 10, 5}], Point3DBox[{7, 10, 6}], Point3DBox[{7, 10, 7}], 
     Point3DBox[{7, 10, 8}], Point3DBox[{7, 10, 9}], 
     Point3DBox[{7, 10, 10}]}}, {{Point3DBox[{8, 1, 1}], 
     Point3DBox[{8, 1, 2}], Point3DBox[{8, 1, 3}], Point3DBox[{8, 1, 4}], 
     Point3DBox[{8, 1, 5}], Point3DBox[{8, 1, 6}], Point3DBox[{8, 1, 7}], 
     Point3DBox[{8, 1, 8}], Point3DBox[{8, 1, 9}], Point3DBox[{8, 1, 10}]}, {
     Point3DBox[{8, 2, 1}], Point3DBox[{8, 2, 2}], Point3DBox[{8, 2, 3}], 
     Point3DBox[{8, 2, 4}], Point3DBox[{8, 2, 5}], Point3DBox[{8, 2, 6}], 
     Point3DBox[{8, 2, 7}], Point3DBox[{8, 2, 8}], Point3DBox[{8, 2, 9}], 
     Point3DBox[{8, 2, 10}]}, {Point3DBox[{8, 3, 1}], Point3DBox[{8, 3, 2}], 
     Point3DBox[{8, 3, 3}], Point3DBox[{8, 3, 4}], Point3DBox[{8, 3, 5}], 
     Point3DBox[{8, 3, 6}], Point3DBox[{8, 3, 7}], Point3DBox[{8, 3, 8}], 
     Point3DBox[{8, 3, 9}], Point3DBox[{8, 3, 10}]}, {Point3DBox[{8, 4, 1}], 
     Point3DBox[{8, 4, 2}], Point3DBox[{8, 4, 3}], Point3DBox[{8, 4, 4}], 
     Point3DBox[{8, 4, 5}], Point3DBox[{8, 4, 6}], Point3DBox[{8, 4, 7}], 
     Point3DBox[{8, 4, 8}], Point3DBox[{8, 4, 9}], Point3DBox[{8, 4, 10}]}, {
     Point3DBox[{8, 5, 1}], Point3DBox[{8, 5, 2}], Point3DBox[{8, 5, 3}], 
     Point3DBox[{8, 5, 4}], Point3DBox[{8, 5, 5}], Point3DBox[{8, 5, 6}], 
     Point3DBox[{8, 5, 7}], Point3DBox[{8, 5, 8}], Point3DBox[{8, 5, 9}], 
     Point3DBox[{8, 5, 10}]}, {Point3DBox[{8, 6, 1}], Point3DBox[{8, 6, 2}], 
     Point3DBox[{8, 6, 3}], Point3DBox[{8, 6, 4}], Point3DBox[{8, 6, 5}], 
     Point3DBox[{8, 6, 6}], Point3DBox[{8, 6, 7}], Point3DBox[{8, 6, 8}], 
     Point3DBox[{8, 6, 9}], Point3DBox[{8, 6, 10}]}, {Point3DBox[{8, 7, 1}], 
     Point3DBox[{8, 7, 2}], Point3DBox[{8, 7, 3}], Point3DBox[{8, 7, 4}], 
     Point3DBox[{8, 7, 5}], Point3DBox[{8, 7, 6}], Point3DBox[{8, 7, 7}], 
     Point3DBox[{8, 7, 8}], Point3DBox[{8, 7, 9}], Point3DBox[{8, 7, 10}]}, {
     Point3DBox[{8, 8, 1}], Point3DBox[{8, 8, 2}], Point3DBox[{8, 8, 3}], 
     Point3DBox[{8, 8, 4}], Point3DBox[{8, 8, 5}], Point3DBox[{8, 8, 6}], 
     Point3DBox[{8, 8, 7}], Point3DBox[{8, 8, 8}], Point3DBox[{8, 8, 9}], 
     Point3DBox[{8, 8, 10}]}, {Point3DBox[{8, 9, 1}], Point3DBox[{8, 9, 2}], 
     Point3DBox[{8, 9, 3}], Point3DBox[{8, 9, 4}], Point3DBox[{8, 9, 5}], 
     Point3DBox[{8, 9, 6}], Point3DBox[{8, 9, 7}], Point3DBox[{8, 9, 8}], 
     Point3DBox[{8, 9, 9}], Point3DBox[{8, 9, 10}]}, {Point3DBox[{8, 10, 1}], 
     Point3DBox[{8, 10, 2}], Point3DBox[{8, 10, 3}], Point3DBox[{8, 10, 4}], 
     Point3DBox[{8, 10, 5}], Point3DBox[{8, 10, 6}], Point3DBox[{8, 10, 7}], 
     Point3DBox[{8, 10, 8}], Point3DBox[{8, 10, 9}], 
     Point3DBox[{8, 10, 10}]}}, {{Point3DBox[{9, 1, 1}], 
     Point3DBox[{9, 1, 2}], Point3DBox[{9, 1, 3}], Point3DBox[{9, 1, 4}], 
     Point3DBox[{9, 1, 5}], Point3DBox[{9, 1, 6}], Point3DBox[{9, 1, 7}], 
     Point3DBox[{9, 1, 8}], Point3DBox[{9, 1, 9}], Point3DBox[{9, 1, 10}]}, {
     Point3DBox[{9, 2, 1}], Point3DBox[{9, 2, 2}], Point3DBox[{9, 2, 3}], 
     Point3DBox[{9, 2, 4}], Point3DBox[{9, 2, 5}], Point3DBox[{9, 2, 6}], 
     Point3DBox[{9, 2, 7}], Point3DBox[{9, 2, 8}], Point3DBox[{9, 2, 9}], 
     Point3DBox[{9, 2, 10}]}, {Point3DBox[{9, 3, 1}], Point3DBox[{9, 3, 2}], 
     Point3DBox[{9, 3, 3}], Point3DBox[{9, 3, 4}], Point3DBox[{9, 3, 5}], 
     Point3DBox[{9, 3, 6}], Point3DBox[{9, 3, 7}], Point3DBox[{9, 3, 8}], 
     Point3DBox[{9, 3, 9}], Point3DBox[{9, 3, 10}]}, {Point3DBox[{9, 4, 1}], 
     Point3DBox[{9, 4, 2}], Point3DBox[{9, 4, 3}], Point3DBox[{9, 4, 4}], 
     Point3DBox[{9, 4, 5}], Point3DBox[{9, 4, 6}], Point3DBox[{9, 4, 7}], 
     Point3DBox[{9, 4, 8}], Point3DBox[{9, 4, 9}], Point3DBox[{9, 4, 10}]}, {
     Point3DBox[{9, 5, 1}], Point3DBox[{9, 5, 2}], Point3DBox[{9, 5, 3}], 
     Point3DBox[{9, 5, 4}], Point3DBox[{9, 5, 5}], Point3DBox[{9, 5, 6}], 
     Point3DBox[{9, 5, 7}], Point3DBox[{9, 5, 8}], Point3DBox[{9, 5, 9}], 
     Point3DBox[{9, 5, 10}]}, {Point3DBox[{9, 6, 1}], Point3DBox[{9, 6, 2}], 
     Point3DBox[{9, 6, 3}], Point3DBox[{9, 6, 4}], Point3DBox[{9, 6, 5}], 
     Point3DBox[{9, 6, 6}], Point3DBox[{9, 6, 7}], Point3DBox[{9, 6, 8}], 
     Point3DBox[{9, 6, 9}], Point3DBox[{9, 6, 10}]}, {Point3DBox[{9, 7, 1}], 
     Point3DBox[{9, 7, 2}], Point3DBox[{9, 7, 3}], Point3DBox[{9, 7, 4}], 
     Point3DBox[{9, 7, 5}], Point3DBox[{9, 7, 6}], Point3DBox[{9, 7, 7}], 
     Point3DBox[{9, 7, 8}], Point3DBox[{9, 7, 9}], Point3DBox[{9, 7, 10}]}, {
     Point3DBox[{9, 8, 1}], Point3DBox[{9, 8, 2}], Point3DBox[{9, 8, 3}], 
     Point3DBox[{9, 8, 4}], Point3DBox[{9, 8, 5}], Point3DBox[{9, 8, 6}], 
     Point3DBox[{9, 8, 7}], Point3DBox[{9, 8, 8}], Point3DBox[{9, 8, 9}], 
     Point3DBox[{9, 8, 10}]}, {Point3DBox[{9, 9, 1}], Point3DBox[{9, 9, 2}], 
     Point3DBox[{9, 9, 3}], Point3DBox[{9, 9, 4}], Point3DBox[{9, 9, 5}], 
     Point3DBox[{9, 9, 6}], Point3DBox[{9, 9, 7}], Point3DBox[{9, 9, 8}], 
     Point3DBox[{9, 9, 9}], Point3DBox[{9, 9, 10}]}, {Point3DBox[{9, 10, 1}], 
     Point3DBox[{9, 10, 2}], Point3DBox[{9, 10, 3}], Point3DBox[{9, 10, 4}], 
     Point3DBox[{9, 10, 5}], Point3DBox[{9, 10, 6}], Point3DBox[{9, 10, 7}], 
     Point3DBox[{9, 10, 8}], Point3DBox[{9, 10, 9}], 
     Point3DBox[{9, 10, 10}]}}, {{Point3DBox[{10, 1, 1}], 
     Point3DBox[{10, 1, 2}], Point3DBox[{10, 1, 3}], Point3DBox[{10, 1, 4}], 
     Point3DBox[{10, 1, 5}], Point3DBox[{10, 1, 6}], Point3DBox[{10, 1, 7}], 
     Point3DBox[{10, 1, 8}], Point3DBox[{10, 1, 9}], 
     Point3DBox[{10, 1, 10}]}, {Point3DBox[{10, 2, 1}], 
     Point3DBox[{10, 2, 2}], Point3DBox[{10, 2, 3}], Point3DBox[{10, 2, 4}], 
     Point3DBox[{10, 2, 5}], Point3DBox[{10, 2, 6}], Point3DBox[{10, 2, 7}], 
     Point3DBox[{10, 2, 8}], Point3DBox[{10, 2, 9}], 
     Point3DBox[{10, 2, 10}]}, {Point3DBox[{10, 3, 1}], 
     Point3DBox[{10, 3, 2}], Point3DBox[{10, 3, 3}], Point3DBox[{10, 3, 4}], 
     Point3DBox[{10, 3, 5}], Point3DBox[{10, 3, 6}], Point3DBox[{10, 3, 7}], 
     Point3DBox[{10, 3, 8}], Point3DBox[{10, 3, 9}], 
     Point3DBox[{10, 3, 10}]}, {Point3DBox[{10, 4, 1}], 
     Point3DBox[{10, 4, 2}], Point3DBox[{10, 4, 3}], Point3DBox[{10, 4, 4}], 
     Point3DBox[{10, 4, 5}], Point3DBox[{10, 4, 6}], Point3DBox[{10, 4, 7}], 
     Point3DBox[{10, 4, 8}], Point3DBox[{10, 4, 9}], 
     Point3DBox[{10, 4, 10}]}, {Point3DBox[{10, 5, 1}], 
     Point3DBox[{10, 5, 2}], Point3DBox[{10, 5, 3}], Point3DBox[{10, 5, 4}], 
     Point3DBox[{10, 5, 5}], Point3DBox[{10, 5, 6}], Point3DBox[{10, 5, 7}], 
     Point3DBox[{10, 5, 8}], Point3DBox[{10, 5, 9}], 
     Point3DBox[{10, 5, 10}]}, {Point3DBox[{10, 6, 1}], 
     Point3DBox[{10, 6, 2}], Point3DBox[{10, 6, 3}], Point3DBox[{10, 6, 4}], 
     Point3DBox[{10, 6, 5}], Point3DBox[{10, 6, 6}], Point3DBox[{10, 6, 7}], 
     Point3DBox[{10, 6, 8}], Point3DBox[{10, 6, 9}], 
     Point3DBox[{10, 6, 10}]}, {Point3DBox[{10, 7, 1}], 
     Point3DBox[{10, 7, 2}], Point3DBox[{10, 7, 3}], Point3DBox[{10, 7, 4}], 
     Point3DBox[{10, 7, 5}], Point3DBox[{10, 7, 6}], Point3DBox[{10, 7, 7}], 
     Point3DBox[{10, 7, 8}], Point3DBox[{10, 7, 9}], 
     Point3DBox[{10, 7, 10}]}, {Point3DBox[{10, 8, 1}], 
     Point3DBox[{10, 8, 2}], Point3DBox[{10, 8, 3}], Point3DBox[{10, 8, 4}], 
     Point3DBox[{10, 8, 5}], Point3DBox[{10, 8, 6}], Point3DBox[{10, 8, 7}], 
     Point3DBox[{10, 8, 8}], Point3DBox[{10, 8, 9}], 
     Point3DBox[{10, 8, 10}]}, {Point3DBox[{10, 9, 1}], 
     Point3DBox[{10, 9, 2}], Point3DBox[{10, 9, 3}], Point3DBox[{10, 9, 4}], 
     Point3DBox[{10, 9, 5}], Point3DBox[{10, 9, 6}], Point3DBox[{10, 9, 7}], 
     Point3DBox[{10, 9, 8}], Point3DBox[{10, 9, 9}], 
     Point3DBox[{10, 9, 10}]}, {Point3DBox[{10, 10, 1}], 
     Point3DBox[{10, 10, 2}], Point3DBox[{10, 10, 3}], 
     Point3DBox[{10, 10, 4}], Point3DBox[{10, 10, 5}], 
     Point3DBox[{10, 10, 6}], Point3DBox[{10, 10, 7}], 
     Point3DBox[{10, 10, 8}], Point3DBox[{10, 10, 9}], 
     Point3DBox[{10, 10, 10}]}}},
  ImageSize->{141.8046875, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[23]=",ExpressionUUID->"c23a65b7-bcef-4651-9259-1602aeb73dcc"]
}, Open  ]],

Cell["\<\
50 spheres at random 3D positions, with each coordinate running up to 10:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:69",ExpressionUUID->"9cd0f899-9b9f-40db-a644-f671d9661a31"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"10", ",", "3"}], "]"}], "]"}], ",", "50"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[24]:=",ExpressionUUID->"adfe8980-4102-4162-bab4-600213ca08e8"],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 1, 9}], SphereBox[{5, 7, 10}], 
   SphereBox[{9, 8, 6}], SphereBox[{7, 4, 7}], SphereBox[{10, 5, 9}], 
   SphereBox[{4, 8, 0}], SphereBox[{3, 5, 6}], SphereBox[{9, 1, 3}], 
   SphereBox[{1, 1, 2}], SphereBox[{3, 4, 1}], SphereBox[{7, 6, 5}], 
   SphereBox[{9, 0, 0}], SphereBox[{10, 4, 0}], SphereBox[{10, 0, 1}], 
   SphereBox[{0, 0, 1}], SphereBox[{7, 5, 6}], SphereBox[{7, 0, 2}], 
   SphereBox[{1, 8, 3}], SphereBox[{2, 9, 5}], SphereBox[{8, 2, 1}], 
   SphereBox[{7, 4, 4}], SphereBox[{8, 2, 7}], SphereBox[{6, 1, 5}], 
   SphereBox[{4, 7, 9}], SphereBox[{0, 3, 2}], SphereBox[{4, 10, 6}], 
   SphereBox[{6, 3, 2}], SphereBox[{8, 5, 2}], SphereBox[{2, 5, 7}], 
   SphereBox[{8, 2, 9}], SphereBox[{9, 4, 6}], SphereBox[{2, 3, 9}], 
   SphereBox[{9, 7, 8}], SphereBox[{4, 6, 9}], SphereBox[{8, 8, 9}], 
   SphereBox[{0, 2, 10}], SphereBox[{3, 5, 0}], SphereBox[{3, 5, 10}], 
   SphereBox[{10, 4, 2}], SphereBox[{8, 1, 3}], SphereBox[{3, 5, 8}], 
   SphereBox[{1, 10, 0}], SphereBox[{0, 1, 10}], SphereBox[{3, 6, 5}], 
   SphereBox[{7, 0, 10}], SphereBox[{7, 6, 8}], SphereBox[{5, 7, 4}], 
   SphereBox[{2, 6, 1}], SphereBox[{7, 0, 7}], SphereBox[{6, 8, 5}]},
  ImageSize->{135.1654079713864, 140.},
  ViewPoint->{1.1871497513097968`, -2.8600357588801035`, 1.3641374292541772`},
  
  ViewVertical->{0.10601793945450096`, -0.1897213793333381, 
   0.9760973285168224}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[24]=",ExpressionUUID->"53ea50e7-eaaf-4853-a63b-16be1f9ba1d7"]
}, Open  ]],

Cell[TextData[{
 "If you don\[CloseCurlyQuote]t say otherwise, 3D objects like spheres are \
drawn solid, so you can\[CloseCurlyQuote]t see through them. But just like \
you can specify what color something is, you can also specify its ",
 StyleBox["opacity",
  FontSlant->"Italic"],
 ". Opacity 1 means completely opaque, so you can\[CloseCurlyQuote]t see \
through it at all; opacity 0 means completely transparent."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"8cfeaab2-eaff-4b8e-b1be-3a0f25633ef6"],

Cell["Specify opacity 0.5 for all spheres:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"01ac1543-4b0b-469b-bf74-5bae1dc6ffc7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"10", ",", "3"}], "]"}], "]"}], ",", 
      RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}], ",", "50"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[25]:=",ExpressionUUID->"d0fdca08-6312-4147-98da-214a2248ac51"],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.5], SphereBox[{9, 8, 6}]}, 
   {Opacity[0.5], SphereBox[{4, 5, 3}]}, 
   {Opacity[0.5], SphereBox[{2, 7, 7}]}, 
   {Opacity[0.5], SphereBox[{3, 4, 9}]}, 
   {Opacity[0.5], SphereBox[{4, 0, 0}]}, 
   {Opacity[0.5], SphereBox[{0, 4, 7}]}, 
   {Opacity[0.5], SphereBox[{6, 0, 3}]}, 
   {Opacity[0.5], SphereBox[{6, 6, 1}]}, 
   {Opacity[0.5], SphereBox[{3, 7, 10}]}, 
   {Opacity[0.5], SphereBox[{2, 4, 10}]}, 
   {Opacity[0.5], SphereBox[{0, 2, 3}]}, 
   {Opacity[0.5], SphereBox[{10, 6, 1}]}, 
   {Opacity[0.5], SphereBox[{3, 9, 5}]}, 
   {Opacity[0.5], SphereBox[{1, 4, 2}]}, 
   {Opacity[0.5], SphereBox[{4, 2, 2}]}, 
   {Opacity[0.5], SphereBox[{9, 8, 8}]}, 
   {Opacity[0.5], SphereBox[{3, 6, 3}]}, 
   {Opacity[0.5], SphereBox[{10, 3, 5}]}, 
   {Opacity[0.5], SphereBox[{0, 3, 8}]}, 
   {Opacity[0.5], SphereBox[{6, 4, 10}]}, 
   {Opacity[0.5], SphereBox[{0, 3, 6}]}, 
   {Opacity[0.5], SphereBox[{0, 9, 1}]}, 
   {Opacity[0.5], SphereBox[{7, 7, 4}]}, 
   {Opacity[0.5], SphereBox[{10, 1, 0}]}, 
   {Opacity[0.5], SphereBox[{0, 0, 4}]}, 
   {Opacity[0.5], SphereBox[{4, 3, 0}]}, 
   {Opacity[0.5], SphereBox[{0, 8, 3}]}, 
   {Opacity[0.5], SphereBox[{8, 10, 0}]}, 
   {Opacity[0.5], SphereBox[{8, 2, 10}]}, 
   {Opacity[0.5], SphereBox[{4, 0, 1}]}, 
   {Opacity[0.5], SphereBox[{6, 4, 9}]}, 
   {Opacity[0.5], SphereBox[{1, 7, 7}]}, 
   {Opacity[0.5], SphereBox[{0, 2, 7}]}, 
   {Opacity[0.5], SphereBox[{8, 9, 2}]}, 
   {Opacity[0.5], SphereBox[{1, 7, 1}]}, 
   {Opacity[0.5], SphereBox[{5, 9, 1}]}, 
   {Opacity[0.5], SphereBox[{10, 1, 10}]}, 
   {Opacity[0.5], SphereBox[{5, 8, 2}]}, 
   {Opacity[0.5], SphereBox[{3, 7, 1}]}, 
   {Opacity[0.5], SphereBox[{0, 4, 7}]}, 
   {Opacity[0.5], SphereBox[{2, 5, 10}]}, 
   {Opacity[0.5], SphereBox[{9, 4, 4}]}, 
   {Opacity[0.5], SphereBox[{9, 6, 6}]}, 
   {Opacity[0.5], SphereBox[{0, 6, 9}]}, 
   {Opacity[0.5], SphereBox[{6, 2, 3}]}, 
   {Opacity[0.5], SphereBox[{9, 2, 3}]}, 
   {Opacity[0.5], SphereBox[{1, 6, 7}]}, 
   {Opacity[0.5], SphereBox[{3, 2, 2}]}, 
   {Opacity[0.5], SphereBox[{4, 0, 1}]}, 
   {Opacity[0.5], SphereBox[{10, 3, 0}]}},
  ImageSize->{134.5703125, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[25]=",ExpressionUUID->"7780e84c-2157-446f-aa0d-5f2df14f712a"]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to make graphics\[LongDash]in 2D or 3D\[LongDash]that can be manipulated. \
"
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"203ece10-4eaa-469b-84e2-26cc53715047"],

Cell["Manipulate the position and opacity of the second sphere:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"73766561-56da-4f31-8474-e97ba45d35d3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"Sphere", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"Opacity", "[", "o", "]"}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"o", ",", "0.5", ",", "1"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[26]:=",ExpressionUUID->"49066769-031d-4d3a-83a9-11feea68d636"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`o$$ = 0.5, $CellContext`x$$ = 1.03, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 1, 3}, {
      Hold[$CellContext`o$$], 0.5, 1}}, Typeset`size$$ = {200., {89., 95.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$6420$$ = 0, $CellContext`o$6421$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`o$$ = 0.5, $CellContext`x$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$6420$$, 0], 
        Hold[$CellContext`o$$, $CellContext`o$6421$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{
         Sphere[{0, 0, 0}], 
         Style[
          Sphere[{$CellContext`x$$, 0, 0}], 
          Opacity[$CellContext`o$$]]}], 
      "Specifications" :> {{$CellContext`x$$, 1, 3}, {$CellContext`o$$, 0.5, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{247., {150., 158.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 Graphics3DBoxOptions->{ImageSize->200},
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[26]=",ExpressionUUID->"d1e82a3d-71f6-4ee6-bde4-2c58deec6522"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:70",ExpressionUUID->"66a2688a-489c-48b5-bbde-64b18e8126ae"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Point",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "CodeVariableLrg"], ",", 
       StyleBox["y", "CodeVariableLrg"]}], "}"}], "]"}], " ", Cell[TextData[{
     "a point at coordinates ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "CodeVariable"], ",", 
       StyleBox["y", "CodeVariable"], "}"}]], "InlineCode",ExpressionUUID->
      "10d8bbfb-545e-4109-99b8-a380890cd7fc"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "4b570ece-2a66-4c45-9568-c84acfc28584"]},
   {
    RowBox[{
     ButtonBox["Line",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}], " ", Cell[
    "a line connecting specified coordinates ", "VocabularyText",
     ExpressionUUID->"03950498-d2d6-4779-8ae8-78d0a27727cf"]},
   {
    RowBox[{
     ButtonBox["Circle",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "CodeVariableLrg"], ",", 
       StyleBox["y", "CodeVariableLrg"]}], "}"}], "]"}], " ", Cell[TextData[{
     "a circle with center at ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "CodeVariable"], ",", 
       StyleBox["y", "CodeVariable"], "}"}]], "InlineCode",ExpressionUUID->
      "72b81338-1762-4a42-b989-b55951f8deb0"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "7d4442d2-aae0-4b25-8a55-64877e081ed3"]},
   {
    RowBox[{
     ButtonBox["Circle",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "CodeVariableLrg"], ",", 
        StyleBox["y", "CodeVariableLrg"]}], "}"}], ",", 
      StyleBox["r", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "a circle with center at ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "CodeVariable"], ",", 
       StyleBox["y", "CodeVariable"], "}"}]], "InlineCode",ExpressionUUID->
      "7bc7cb7a-f430-4794-9317-34a60e0e3be5"],
     " and radius ",
     Cell[BoxData[
      StyleBox["r", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "444b0f41-2e77-4f12-a61a-b4d50b0afa23"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "97ed432c-d084-4a2e-8606-1541a6ecefb9"]},
   {
    RowBox[{
     ButtonBox["RegularPolygon",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "CodeVariableLrg"], ",", 
        StyleBox["y", "CodeVariableLrg"]}], "}"}], ",", 
      StyleBox["s", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "a regular polygon with center ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "CodeVariable"], ",", 
       StyleBox["y", "CodeVariable"], "}"}]], "InlineCode",ExpressionUUID->
      "6ffbaa81-204d-46c0-9333-1add3b7cc8ec"],
     "\[LineSeparator]and ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "950123e3-dd5b-4ade-9394-fadaaf5ee106"],
     " sides each ",
     Cell[BoxData[
      StyleBox["s", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "dec9fcd4-148d-40d4-9f62-a3b21be01c24"],
     " long "
    }], "VocabularyText",ExpressionUUID->
     "4d2b457e-43cc-41d0-a5ed-f35e519515ce"]},
   {
    RowBox[{
     ButtonBox["Polygon",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}], " ", Cell[
    "a polygon with the specified corners ", "VocabularyText",ExpressionUUID->
     "d35462d8-da69-4ab4-80ca-ceacba9f1c85"]},
   {
    RowBox[{
     ButtonBox["Sphere",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "CodeVariableLrg"], ",", 
       StyleBox["y", "CodeVariableLrg"], ",", 
       StyleBox["z", "CodeVariableLrg"]}], "}"}], "]"}], " ", Cell[TextData[{
     "a sphere with center at ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "CodeVariable"], ",", 
       StyleBox["y", "CodeVariable"], ",", 
       StyleBox["z", "CodeVariable"], "}"}]], "InlineCode",ExpressionUUID->
      "98466bd8-4fa0-4b87-93f7-2dd1d65634d8"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "8ab1f6e6-9e14-4106-89bb-24f3f81127a5"]},
   {
    RowBox[{
     ButtonBox["Sphere",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "CodeVariableLrg"], ",", 
        StyleBox["y", "CodeVariableLrg"], ",", 
        StyleBox["z", "CodeVariableLrg"]}], "}"}], ",", 
      StyleBox["r", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "a sphere with center at ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "CodeVariable"], ",", 
       StyleBox["y", "CodeVariable"], ",", 
       StyleBox["z", "CodeVariable"], "}"}]], "InlineCode",ExpressionUUID->
      "fc0f37a4-6799-4228-89cd-d10daab390b0"],
     " and radius ",
     Cell[BoxData[
      StyleBox["r", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "993dde14-2f55-43c0-8a1f-e26359e0ef54"]
    }], "VocabularyText",ExpressionUUID->
     "a2820c1a-3982-4bba-81bc-904494cdb3ec"]},
   {
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["level", "CodeVariableLrg"], "]"}], " ", Cell[
    "specify an opacity level (0: transparent; 1: solid) ", "VocabularyText",
     ExpressionUUID->"791b8e98-dbc3-41cc-9b63-b2f58c23805c"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"29e8c129-466e-469c-8b68-8b543f0924ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"59a119be-0b59-4f45-a32e-302c433f0718"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"10 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 6 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-14-coordinates-and-graphics-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b31c6bfb-d889-4c65-9391-fe623fc73fed"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make graphics of 5 concentric circles centered at ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "2cf931b2-12b8-4809-87ca-d7930d9217cb"],
 " with radii 1, 2, ",
 StyleBox["...",
  FontColor->GrayLevel[0.6]],
 " , 5.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "14.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b4205619-af66-4acb-b017-94502dc6d791"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{CircleBox[{0, 0}], CircleBox[{0, 0}, 2], 
         CircleBox[{0, 0}, 3], CircleBox[{0, 0}, 4], CircleBox[{0, 0}, 5]}]], 
       "ExerciseOutput",ExpressionUUID->
       "d13eda8b-c028-4dc5-987a-72a4b5be4051"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{
           CircleBox[{0, 0}], 
           CircleBox[{0, 0}, 2], 
           CircleBox[{0, 0}, 3], 
           CircleBox[{0, 0}, 4], 
           CircleBox[{0, 0}, 5]}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1a32e0a2-1a0c-435e-ab5c-59476d163fef"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make 10 concentric circles with random colors.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "14.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a74afadf-4602-4f1d-88f5-be2d9c1c038c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {RGBColor[
          0.07498102317705135, 0.43160687973829437`, 0.970143101166755], 
          CircleBox[{0, 0}]}, 
         {RGBColor[
          0.6553045326764393, 0.3489220578810519, 0.7056981718469595], 
          CircleBox[{0, 0}, 2]}, 
         {RGBColor[
          0.25601520606852546`, 0.5917530316824493, 0.21644203696165576`], 
          CircleBox[{0, 0}, 3]}, 
         {RGBColor[
          0.38599206435277944`, 0.9177288620066919, 0.994894252528558], 
          CircleBox[{0, 0}, 4]}, 
         {RGBColor[
          0.47132428561284145`, 0.8133786499238076, 0.8235599667494851], 
          CircleBox[{0, 0}, 5]}, 
         {RGBColor[
          0.45385805785835376`, 0.13844232414459623`, 0.8509664262839938], 
          CircleBox[{0, 0}, 6]}, 
         {RGBColor[
          0.12914406315977667`, 0.13030789402037302`, 0.8942155677776185], 
          CircleBox[{0, 0}, 7]}, 
         {RGBColor[
          0.5909411364080293, 0.05430680157001677, 0.5825496886054231], 
          CircleBox[{0, 0}, 8]}, 
         {RGBColor[
          0.5238853825583525, 0.01042823008920224, 0.7818362891886015], 
          CircleBox[{0, 0}, 9]}, 
         {RGBColor[
          0.2815420060231544, 0.42643152932526607`, 0.3294956818898711], 
          CircleBox[{0, 0}, 10]}}]], "ExerciseOutput",ExpressionUUID->
       "dda78cd6-6245-48cd-a49c-7b9308461b6c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             RGBColor[
             0.07498102317705135, 0.43160687973829437`, 0.970143101166755], 
             CircleBox[{0, 0}]}}, {{
             RGBColor[
             0.6553045326764393, 0.3489220578810519, 0.7056981718469595], 
             CircleBox[{0, 0}, 2]}}, {{
             RGBColor[
             0.25601520606852546`, 0.5917530316824493, 0.21644203696165576`], 
             
             CircleBox[{0, 0}, 3]}}, {{
             RGBColor[
             0.38599206435277944`, 0.9177288620066919, 0.994894252528558], 
             CircleBox[{0, 0}, 4]}}, {{
             RGBColor[
             0.47132428561284145`, 0.8133786499238076, 0.8235599667494851], 
             CircleBox[{0, 0}, 5]}}, {{
             RGBColor[
             0.45385805785835376`, 0.13844232414459623`, 0.8509664262839938], 
             
             CircleBox[{0, 0}, 6]}}, {{
             RGBColor[
             0.12914406315977667`, 0.13030789402037302`, 0.8942155677776185], 
             
             CircleBox[{0, 0}, 7]}}, {{
             RGBColor[
             0.5909411364080293, 0.05430680157001677, 0.5825496886054231], 
             CircleBox[{0, 0}, 8]}}, {{
             RGBColor[
             0.5238853825583525, 0.01042823008920224, 0.7818362891886015], 
             CircleBox[{0, 0}, 9]}}, {{
             RGBColor[
             0.2815420060231544, 0.42643152932526607`, 0.3294956818898711], 
             CircleBox[{0, 0}, 10]}}}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6bb08754-2d4b-4c39-9fbc-cb068de3ecac"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make graphics of a 10\[Times]10 grid of circles with radius 1 centered at \
integer points ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]], "InlineCode",ExpressionUUID->
  "e55b1e17-703b-4fda-8be2-84b08a8dacd9"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "14.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"07a6af62-445b-45d4-b063-1d8580b29c18"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{CircleBox[{1, 1}], CircleBox[{1, 2}], CircleBox[{1, 3}], 
          CircleBox[{1, 4}], CircleBox[{1, 5}], CircleBox[{1, 6}], 
          CircleBox[{1, 7}], CircleBox[{1, 8}], CircleBox[{1, 9}], 
          CircleBox[{1, 10}]}, {CircleBox[{2, 1}], CircleBox[{2, 2}], 
          CircleBox[{2, 3}], CircleBox[{2, 4}], CircleBox[{2, 5}], 
          CircleBox[{2, 6}], CircleBox[{2, 7}], CircleBox[{2, 8}], 
          CircleBox[{2, 9}], CircleBox[{2, 10}]}, {CircleBox[{3, 1}], 
          CircleBox[{3, 2}], CircleBox[{3, 3}], CircleBox[{3, 4}], 
          CircleBox[{3, 5}], CircleBox[{3, 6}], CircleBox[{3, 7}], 
          CircleBox[{3, 8}], CircleBox[{3, 9}], CircleBox[{3, 10}]}, {
          CircleBox[{4, 1}], CircleBox[{4, 2}], CircleBox[{4, 3}], 
          CircleBox[{4, 4}], CircleBox[{4, 5}], CircleBox[{4, 6}], 
          CircleBox[{4, 7}], CircleBox[{4, 8}], CircleBox[{4, 9}], 
          CircleBox[{4, 10}]}, {CircleBox[{5, 1}], CircleBox[{5, 2}], 
          CircleBox[{5, 3}], CircleBox[{5, 4}], CircleBox[{5, 5}], 
          CircleBox[{5, 6}], CircleBox[{5, 7}], CircleBox[{5, 8}], 
          CircleBox[{5, 9}], CircleBox[{5, 10}]}, {CircleBox[{6, 1}], 
          CircleBox[{6, 2}], CircleBox[{6, 3}], CircleBox[{6, 4}], 
          CircleBox[{6, 5}], CircleBox[{6, 6}], CircleBox[{6, 7}], 
          CircleBox[{6, 8}], CircleBox[{6, 9}], CircleBox[{6, 10}]}, {
          CircleBox[{7, 1}], CircleBox[{7, 2}], CircleBox[{7, 3}], 
          CircleBox[{7, 4}], CircleBox[{7, 5}], CircleBox[{7, 6}], 
          CircleBox[{7, 7}], CircleBox[{7, 8}], CircleBox[{7, 9}], 
          CircleBox[{7, 10}]}, {CircleBox[{8, 1}], CircleBox[{8, 2}], 
          CircleBox[{8, 3}], CircleBox[{8, 4}], CircleBox[{8, 5}], 
          CircleBox[{8, 6}], CircleBox[{8, 7}], CircleBox[{8, 8}], 
          CircleBox[{8, 9}], CircleBox[{8, 10}]}, {CircleBox[{9, 1}], 
          CircleBox[{9, 2}], CircleBox[{9, 3}], CircleBox[{9, 4}], 
          CircleBox[{9, 5}], CircleBox[{9, 6}], CircleBox[{9, 7}], 
          CircleBox[{9, 8}], CircleBox[{9, 9}], CircleBox[{9, 10}]}, {
          CircleBox[{10, 1}], CircleBox[{10, 2}], CircleBox[{10, 3}], 
          CircleBox[{10, 4}], CircleBox[{10, 5}], CircleBox[{10, 6}], 
          CircleBox[{10, 7}], CircleBox[{10, 8}], CircleBox[{10, 9}], 
          CircleBox[{10, 10}]}}]], "ExerciseOutput",ExpressionUUID->
       "8b39f580-e8ed-42d2-b5fa-fdf2055be1e4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{
            CircleBox[{1, 1}], 
            CircleBox[{1, 2}], 
            CircleBox[{1, 3}], 
            CircleBox[{1, 4}], 
            CircleBox[{1, 5}], 
            CircleBox[{1, 6}], 
            CircleBox[{1, 7}], 
            CircleBox[{1, 8}], 
            CircleBox[{1, 9}], 
            CircleBox[{1, 10}]}, {
            CircleBox[{2, 1}], 
            CircleBox[{2, 2}], 
            CircleBox[{2, 3}], 
            CircleBox[{2, 4}], 
            CircleBox[{2, 5}], 
            CircleBox[{2, 6}], 
            CircleBox[{2, 7}], 
            CircleBox[{2, 8}], 
            CircleBox[{2, 9}], 
            CircleBox[{2, 10}]}, {
            CircleBox[{3, 1}], 
            CircleBox[{3, 2}], 
            CircleBox[{3, 3}], 
            CircleBox[{3, 4}], 
            CircleBox[{3, 5}], 
            CircleBox[{3, 6}], 
            CircleBox[{3, 7}], 
            CircleBox[{3, 8}], 
            CircleBox[{3, 9}], 
            CircleBox[{3, 10}]}, {
            CircleBox[{4, 1}], 
            CircleBox[{4, 2}], 
            CircleBox[{4, 3}], 
            CircleBox[{4, 4}], 
            CircleBox[{4, 5}], 
            CircleBox[{4, 6}], 
            CircleBox[{4, 7}], 
            CircleBox[{4, 8}], 
            CircleBox[{4, 9}], 
            CircleBox[{4, 10}]}, {
            CircleBox[{5, 1}], 
            CircleBox[{5, 2}], 
            CircleBox[{5, 3}], 
            CircleBox[{5, 4}], 
            CircleBox[{5, 5}], 
            CircleBox[{5, 6}], 
            CircleBox[{5, 7}], 
            CircleBox[{5, 8}], 
            CircleBox[{5, 9}], 
            CircleBox[{5, 10}]}, {
            CircleBox[{6, 1}], 
            CircleBox[{6, 2}], 
            CircleBox[{6, 3}], 
            CircleBox[{6, 4}], 
            CircleBox[{6, 5}], 
            CircleBox[{6, 6}], 
            CircleBox[{6, 7}], 
            CircleBox[{6, 8}], 
            CircleBox[{6, 9}], 
            CircleBox[{6, 10}]}, {
            CircleBox[{7, 1}], 
            CircleBox[{7, 2}], 
            CircleBox[{7, 3}], 
            CircleBox[{7, 4}], 
            CircleBox[{7, 5}], 
            CircleBox[{7, 6}], 
            CircleBox[{7, 7}], 
            CircleBox[{7, 8}], 
            CircleBox[{7, 9}], 
            CircleBox[{7, 10}]}, {
            CircleBox[{8, 1}], 
            CircleBox[{8, 2}], 
            CircleBox[{8, 3}], 
            CircleBox[{8, 4}], 
            CircleBox[{8, 5}], 
            CircleBox[{8, 6}], 
            CircleBox[{8, 7}], 
            CircleBox[{8, 8}], 
            CircleBox[{8, 9}], 
            CircleBox[{8, 10}]}, {
            CircleBox[{9, 1}], 
            CircleBox[{9, 2}], 
            CircleBox[{9, 3}], 
            CircleBox[{9, 4}], 
            CircleBox[{9, 5}], 
            CircleBox[{9, 6}], 
            CircleBox[{9, 7}], 
            CircleBox[{9, 8}], 
            CircleBox[{9, 9}], 
            CircleBox[{9, 10}]}, {
            CircleBox[{10, 1}], 
            CircleBox[{10, 2}], 
            CircleBox[{10, 3}], 
            CircleBox[{10, 4}], 
            CircleBox[{10, 5}], 
            CircleBox[{10, 6}], 
            CircleBox[{10, 7}], 
            CircleBox[{10, 8}], 
            CircleBox[{10, 9}], 
            CircleBox[{10, 10}]}}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1ce370dc-26c9-4249-803d-648a0d22a503"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 10\[Times]10 grid of points with coordinates at integer positions up \
to 10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "14.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"045e89aa-de45-4436-947c-3fe1ee86d845"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{PointBox[{1, 1}], PointBox[{1, 2}], PointBox[{1, 3}], 
          PointBox[{1, 4}], PointBox[{1, 5}], PointBox[{1, 6}], 
          PointBox[{1, 7}], PointBox[{1, 8}], PointBox[{1, 9}], 
          PointBox[{1, 10}]}, {PointBox[{2, 1}], PointBox[{2, 2}], 
          PointBox[{2, 3}], PointBox[{2, 4}], PointBox[{2, 5}], 
          PointBox[{2, 6}], PointBox[{2, 7}], PointBox[{2, 8}], 
          PointBox[{2, 9}], PointBox[{2, 10}]}, {PointBox[{3, 1}], 
          PointBox[{3, 2}], PointBox[{3, 3}], PointBox[{3, 4}], 
          PointBox[{3, 5}], PointBox[{3, 6}], PointBox[{3, 7}], 
          PointBox[{3, 8}], PointBox[{3, 9}], PointBox[{3, 10}]}, {
          PointBox[{4, 1}], PointBox[{4, 2}], PointBox[{4, 3}], 
          PointBox[{4, 4}], PointBox[{4, 5}], PointBox[{4, 6}], 
          PointBox[{4, 7}], PointBox[{4, 8}], PointBox[{4, 9}], 
          PointBox[{4, 10}]}, {PointBox[{5, 1}], PointBox[{5, 2}], 
          PointBox[{5, 3}], PointBox[{5, 4}], PointBox[{5, 5}], 
          PointBox[{5, 6}], PointBox[{5, 7}], PointBox[{5, 8}], 
          PointBox[{5, 9}], PointBox[{5, 10}]}, {PointBox[{6, 1}], 
          PointBox[{6, 2}], PointBox[{6, 3}], PointBox[{6, 4}], 
          PointBox[{6, 5}], PointBox[{6, 6}], PointBox[{6, 7}], 
          PointBox[{6, 8}], PointBox[{6, 9}], PointBox[{6, 10}]}, {
          PointBox[{7, 1}], PointBox[{7, 2}], PointBox[{7, 3}], 
          PointBox[{7, 4}], PointBox[{7, 5}], PointBox[{7, 6}], 
          PointBox[{7, 7}], PointBox[{7, 8}], PointBox[{7, 9}], 
          PointBox[{7, 10}]}, {PointBox[{8, 1}], PointBox[{8, 2}], 
          PointBox[{8, 3}], PointBox[{8, 4}], PointBox[{8, 5}], 
          PointBox[{8, 6}], PointBox[{8, 7}], PointBox[{8, 8}], 
          PointBox[{8, 9}], PointBox[{8, 10}]}, {PointBox[{9, 1}], 
          PointBox[{9, 2}], PointBox[{9, 3}], PointBox[{9, 4}], 
          PointBox[{9, 5}], PointBox[{9, 6}], PointBox[{9, 7}], 
          PointBox[{9, 8}], PointBox[{9, 9}], PointBox[{9, 10}]}, {
          PointBox[{10, 1}], PointBox[{10, 2}], PointBox[{10, 3}], 
          PointBox[{10, 4}], PointBox[{10, 5}], PointBox[{10, 6}], 
          PointBox[{10, 7}], PointBox[{10, 8}], PointBox[{10, 9}], 
          PointBox[{10, 10}]}}]], "ExerciseOutput",ExpressionUUID->
       "f43ad9af-4c07-4c1d-ab73-35245b1820ec"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{
            PointBox[{1, 1}], 
            PointBox[{1, 2}], 
            PointBox[{1, 3}], 
            PointBox[{1, 4}], 
            PointBox[{1, 5}], 
            PointBox[{1, 6}], 
            PointBox[{1, 7}], 
            PointBox[{1, 8}], 
            PointBox[{1, 9}], 
            PointBox[{1, 10}]}, {
            PointBox[{2, 1}], 
            PointBox[{2, 2}], 
            PointBox[{2, 3}], 
            PointBox[{2, 4}], 
            PointBox[{2, 5}], 
            PointBox[{2, 6}], 
            PointBox[{2, 7}], 
            PointBox[{2, 8}], 
            PointBox[{2, 9}], 
            PointBox[{2, 10}]}, {
            PointBox[{3, 1}], 
            PointBox[{3, 2}], 
            PointBox[{3, 3}], 
            PointBox[{3, 4}], 
            PointBox[{3, 5}], 
            PointBox[{3, 6}], 
            PointBox[{3, 7}], 
            PointBox[{3, 8}], 
            PointBox[{3, 9}], 
            PointBox[{3, 10}]}, {
            PointBox[{4, 1}], 
            PointBox[{4, 2}], 
            PointBox[{4, 3}], 
            PointBox[{4, 4}], 
            PointBox[{4, 5}], 
            PointBox[{4, 6}], 
            PointBox[{4, 7}], 
            PointBox[{4, 8}], 
            PointBox[{4, 9}], 
            PointBox[{4, 10}]}, {
            PointBox[{5, 1}], 
            PointBox[{5, 2}], 
            PointBox[{5, 3}], 
            PointBox[{5, 4}], 
            PointBox[{5, 5}], 
            PointBox[{5, 6}], 
            PointBox[{5, 7}], 
            PointBox[{5, 8}], 
            PointBox[{5, 9}], 
            PointBox[{5, 10}]}, {
            PointBox[{6, 1}], 
            PointBox[{6, 2}], 
            PointBox[{6, 3}], 
            PointBox[{6, 4}], 
            PointBox[{6, 5}], 
            PointBox[{6, 6}], 
            PointBox[{6, 7}], 
            PointBox[{6, 8}], 
            PointBox[{6, 9}], 
            PointBox[{6, 10}]}, {
            PointBox[{7, 1}], 
            PointBox[{7, 2}], 
            PointBox[{7, 3}], 
            PointBox[{7, 4}], 
            PointBox[{7, 5}], 
            PointBox[{7, 6}], 
            PointBox[{7, 7}], 
            PointBox[{7, 8}], 
            PointBox[{7, 9}], 
            PointBox[{7, 10}]}, {
            PointBox[{8, 1}], 
            PointBox[{8, 2}], 
            PointBox[{8, 3}], 
            PointBox[{8, 4}], 
            PointBox[{8, 5}], 
            PointBox[{8, 6}], 
            PointBox[{8, 7}], 
            PointBox[{8, 8}], 
            PointBox[{8, 9}], 
            PointBox[{8, 10}]}, {
            PointBox[{9, 1}], 
            PointBox[{9, 2}], 
            PointBox[{9, 3}], 
            PointBox[{9, 4}], 
            PointBox[{9, 5}], 
            PointBox[{9, 6}], 
            PointBox[{9, 7}], 
            PointBox[{9, 8}], 
            PointBox[{9, 9}], 
            PointBox[{9, 10}]}, {
            PointBox[{10, 1}], 
            PointBox[{10, 2}], 
            PointBox[{10, 3}], 
            PointBox[{10, 4}], 
            PointBox[{10, 5}], 
            PointBox[{10, 6}], 
            PointBox[{10, 7}], 
            PointBox[{10, 8}], 
            PointBox[{10, 9}], 
            PointBox[{10, 10}]}}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"29bb5be5-4e72-4f33-a2a4-de3e7e0fb178"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " with between 1 and 20 concentric circles.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "14.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"251d3f38-92a4-4db2-8e96-3b7672f198ca"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 10, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 1, 20, 1}}, Typeset`size$$ = {
          240., {117., 123.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`n$73113$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$73113$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            Graphics[
              Table[
               
               Circle[{0, 
                0}, $CellContext`r], {$CellContext`r, $CellContext`n$$}]], 
            "Specifications" :> {{$CellContext`n$$, 1, 20, 1}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{285., {164., 170.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "d26b7484-a768-4573-9749-2b6a81790175"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 10, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 1, 20, 1}}, 
             Typeset`size$$ = {240., {117., 123.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$73113$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$73113$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Graphics[
                Table[
                 
                 Circle[{0, 
                  0}, $CellContext`r], {$CellContext`r, $CellContext`n$$}]], 
              "Specifications" :> {{$CellContext`n$$, 1, 20, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {291., {165., 172.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"59b36f6f-b4eb-4ffc-8c86-d4faa65158dd"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Place 50 spheres with random colors at random integer coordinates up to 10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "14.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"3738ef63-cbaa-490c-b915-7ebe4d80fe00"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       Graphics3DBox[{
         {RGBColor[
          0.12690917584109696`, 0.8793718148036707, 0.7795189225059196], 
          SphereBox[{9, 3, 6}]}, 
         {RGBColor[0.2666388792550649, 0.696329209205999, 0.7264717102964], 
          SphereBox[{10, 1, 6}]}, 
         {RGBColor[
          0.05551317115169674, 0.7791983648762086, 0.24478508190921477`], 
          SphereBox[{6, 1, 9}]}, 
         {RGBColor[
          0.637991417511321, 0.5803957395354529, 0.49772855251494597`], 
          SphereBox[{0, 6, 10}]}, 
         {RGBColor[
          0.4609135424692177, 0.054471140800188556`, 0.26666321220399314`], 
          SphereBox[{0, 0, 5}]}, 
         {RGBColor[
          0.2754716499678729, 0.5395059869261793, 0.5365304643156554], 
          SphereBox[{0, 0, 4}]}, 
         {RGBColor[
          0.8933282067473727, 0.8998252638482842, 0.3899479051255652], 
          SphereBox[{0, 3, 3}]}, 
         {RGBColor[0.05916057297660826, 0.9017116892413326, 0.63819853036185],
           SphereBox[{4, 10, 4}]}, 
         {RGBColor[
          0.18399559405600496`, 0.27567213015128167`, 0.3414746567129827], 
          SphereBox[{10, 8, 10}]}, 
         {RGBColor[0.907626309116488, 0.9738177315716248, 0.5129322283171109],
           SphereBox[{0, 1, 1}]}, 
         {RGBColor[
          0.8004367972947979, 0.9481972026675987, 0.7469062883609063], 
          SphereBox[{7, 10, 3}]}, 
         {RGBColor[
          0.9617428844938192, 0.3848937223436557, 0.25339818245789036`], 
          SphereBox[{8, 10, 5}]}, 
         {RGBColor[
          0.19069746838569812`, 0.7662724330212385, 0.5657079713324777], 
          SphereBox[{0, 8, 2}]}, 
         {RGBColor[
          0.2765478078476269, 0.1915922687910756, 0.20529521336198475`], 
          SphereBox[{1, 9, 8}]}, 
         {RGBColor[
          0.2231697056316917, 0.9852961513001373, 0.19650908809492296`], 
          SphereBox[{5, 10, 3}]}, 
         {RGBColor[
          0.010603293291303162`, 0.8143957245641287, 0.6683183655648997], 
          SphereBox[{4, 1, 4}]}, 
         {RGBColor[
          0.4592919071119774, 0.32622052978782623`, 0.048292688977219944`], 
          SphereBox[{0, 9, 8}]}, 
         {RGBColor[
          0.5050727983427545, 0.9865814832094193, 0.4122524970532724], 
          SphereBox[{6, 8, 7}]}, 
         {RGBColor[
          0.6651078138297093, 0.09412871820357083, 0.5656369260449938], 
          SphereBox[{10, 0, 5}]}, 
         {RGBColor[
          0.151158518002098, 0.06200246140393406, 0.11438565829349501`], 
          SphereBox[{1, 8, 3}]}, 
         {RGBColor[
          0.6725383863615786, 0.012900989341726676`, 0.2621920647565297], 
          SphereBox[{5, 5, 8}]}, 
         {RGBColor[
          0.5549694563153378, 0.7787957789040221, 0.1504837514828079], 
          SphereBox[{1, 7, 10}]}, 
         {RGBColor[
          0.5716395926702809, 0.8561218668216255, 0.5039849411057651], 
          SphereBox[{3, 7, 0}]}, 
         {RGBColor[
          0.9737872690985612, 0.8622725547294552, 0.24680443880632064`], 
          SphereBox[{8, 6, 2}]}, 
         {RGBColor[0.5920385934474632, 0.630768157911836, 0.8682257595354443],
           SphereBox[{0, 1, 2}]}, 
         {RGBColor[
          0.22741658571742707`, 0.03543690281962597, 0.9175650905375266], 
          SphereBox[{3, 4, 1}]}, 
         {RGBColor[
          0.5983228682179706, 0.8411000422343053, 0.17730116335672497`], 
          SphereBox[{8, 10, 3}]}, 
         {RGBColor[
          0.14397794124131735`, 0.2748032427723439, 0.4718976074243535], 
          SphereBox[{9, 10, 1}]}, 
         {RGBColor[
          0.5827457410202299, 0.9189686491601485, 0.4898155772021082], 
          SphereBox[{1, 4, 8}]}, 
         {RGBColor[
          0.7358958184975835, 0.8478963300505711, 0.5753899081019282], 
          SphereBox[{9, 8, 3}]}, 
         {RGBColor[
          0.40353760350917844`, 0.17500617846111366`, 0.7076827550032689], 
          SphereBox[{4, 7, 8}]}, 
         {RGBColor[
          0.14000164287060102`, 0.6506127954497818, 0.03829984642190731], 
          SphereBox[{2, 7, 8}]}, 
         {RGBColor[
          0.06501231100342997, 0.7835300542109025, 0.35323299481216086`], 
          SphereBox[{8, 4, 5}]}, 
         {RGBColor[
          0.6232493161403108, 0.24373358140411416`, 0.2822878258203194], 
          SphereBox[{2, 6, 10}]}, 
         {RGBColor[
          0.2552908815033166, 0.7497694745834484, 0.7587320548670031], 
          SphereBox[{2, 3, 9}]}, 
         {RGBColor[
          0.0896702356884671, 0.03639833107274537, 0.6312535349502113], 
          SphereBox[{0, 6, 1}]}, 
         {RGBColor[
          0.3979051276907455, 0.14311036213322015`, 0.17559280348369954`], 
          SphereBox[{2, 0, 2}]}, 
         {RGBColor[
          0.9917160616027727, 0.7737757384216453, 0.6979865895937782], 
          SphereBox[{5, 5, 8}]}, 
         {RGBColor[
          0.638576294313608, 0.24833748979284032`, 0.37252978567657613`], 
          SphereBox[{10, 3, 5}]}, 
         {RGBColor[
          0.38944257780097247`, 0.5904986300752695, 0.09441485928318682], 
          SphereBox[{6, 2, 5}]}, 
         {RGBColor[
          0.33328361171823695`, 0.0655571210860777, 0.3570309280576378], 
          SphereBox[{4, 8, 7}]}, 
         {RGBColor[0.2531864748273187, 0.5036738778212624, 0.902972214066786],
           SphereBox[{5, 0, 7}]}, 
         {RGBColor[0.345741047327752, 0.7134960023958175, 0.3064230307106508],
           SphereBox[{0, 1, 4}]}, 
         {RGBColor[
          0.11451052345051083`, 0.3072008047047785, 0.3354556937797557], 
          SphereBox[{0, 1, 5}]}, 
         {RGBColor[
          0.13206564283526623`, 0.2087182092332609, 0.6898484182095146], 
          SphereBox[{2, 6, 7}]}, 
         {RGBColor[
          0.5954948830308919, 0.9395151861516513, 0.5764927267216853], 
          SphereBox[{0, 10, 9}]}, 
         {RGBColor[
          0.5721988147519639, 0.1285348062543228, 0.37066702687821595`], 
          SphereBox[{7, 10, 7}]}, 
         {RGBColor[0.659192977161323, 0.2860414092079018, 0.229662709888504], 
          SphereBox[{9, 2, 3}]}, 
         {RGBColor[
          0.16669862043574502`, 0.4852511588158872, 0.8708800669240953], 
          SphereBox[{2, 3, 0}]}, 
         {RGBColor[
          0.31106675086432145`, 0.12005541692075083`, 0.12709057958028502`], 
          SphereBox[{5, 0, 8}]}},
        ViewPoint->{1.3, -2.4, 2.},
        ViewVertical->{0., 0., 1.}]], "ExerciseOutput",ExpressionUUID->
       "50ca675a-1fd8-44da-acc8-414b78be69ea"],
      Apply[TextCell, 
       Cell[
        BoxData[
         Graphics3DBox[{{{
             RGBColor[
             0.12690917584109696`, 0.8793718148036707, 0.7795189225059196], 
             SphereBox[{9, 3, 6}]}}, {{
             RGBColor[0.2666388792550649, 0.696329209205999, 0.7264717102964], 
             SphereBox[{10, 1, 6}]}}, {{
             RGBColor[
             0.05551317115169674, 0.7791983648762086, 0.24478508190921477`], 
             SphereBox[{6, 1, 9}]}}, {{
             RGBColor[
             0.637991417511321, 0.5803957395354529, 0.49772855251494597`], 
             SphereBox[{0, 6, 10}]}}, {{
             RGBColor[
             0.4609135424692177, 0.054471140800188556`, 0.26666321220399314`], 
             SphereBox[{0, 0, 5}]}}, {{
             RGBColor[
             0.2754716499678729, 0.5395059869261793, 0.5365304643156554], 
             SphereBox[{0, 0, 4}]}}, {{
             RGBColor[
             0.8933282067473727, 0.8998252638482842, 0.3899479051255652], 
             SphereBox[{0, 3, 3}]}}, {{
             RGBColor[
             0.05916057297660826, 0.9017116892413326, 0.63819853036185], 
             SphereBox[{4, 10, 4}]}}, {{
             RGBColor[
             0.18399559405600496`, 0.27567213015128167`, 0.3414746567129827], 
             
             SphereBox[{10, 8, 10}]}}, {{
             RGBColor[
             0.907626309116488, 0.9738177315716248, 0.5129322283171109], 
             SphereBox[{0, 1, 1}]}}, {{
             RGBColor[
             0.8004367972947979, 0.9481972026675987, 0.7469062883609063], 
             SphereBox[{7, 10, 3}]}}, {{
             RGBColor[
             0.9617428844938192, 0.3848937223436557, 0.25339818245789036`], 
             SphereBox[{8, 10, 5}]}}, {{
             RGBColor[
             0.19069746838569812`, 0.7662724330212385, 0.5657079713324777], 
             SphereBox[{0, 8, 2}]}}, {{
             RGBColor[
             0.2765478078476269, 0.1915922687910756, 0.20529521336198475`], 
             SphereBox[{1, 9, 8}]}}, {{
             RGBColor[
             0.2231697056316917, 0.9852961513001373, 0.19650908809492296`], 
             SphereBox[{5, 10, 3}]}}, {{
             RGBColor[
             0.010603293291303162`, 0.8143957245641287, 0.6683183655648997], 
             SphereBox[{4, 1, 4}]}}, {{
             RGBColor[
             0.4592919071119774, 0.32622052978782623`, 0.048292688977219944`], 
             SphereBox[{0, 9, 8}]}}, {{
             RGBColor[
             0.5050727983427545, 0.9865814832094193, 0.4122524970532724], 
             SphereBox[{6, 8, 7}]}}, {{
             RGBColor[
             0.6651078138297093, 0.09412871820357083, 0.5656369260449938], 
             SphereBox[{10, 0, 5}]}}, {{
             RGBColor[
             0.151158518002098, 0.06200246140393406, 0.11438565829349501`], 
             SphereBox[{1, 8, 3}]}}, {{
             RGBColor[
             0.6725383863615786, 0.012900989341726676`, 0.2621920647565297], 
             SphereBox[{5, 5, 8}]}}, {{
             RGBColor[
             0.5549694563153378, 0.7787957789040221, 0.1504837514828079], 
             SphereBox[{1, 7, 10}]}}, {{
             RGBColor[
             0.5716395926702809, 0.8561218668216255, 0.5039849411057651], 
             SphereBox[{3, 7, 0}]}}, {{
             RGBColor[
             0.9737872690985612, 0.8622725547294552, 0.24680443880632064`], 
             SphereBox[{8, 6, 2}]}}, {{
             RGBColor[
             0.5920385934474632, 0.630768157911836, 0.8682257595354443], 
             SphereBox[{0, 1, 2}]}}, {{
             RGBColor[
             0.22741658571742707`, 0.03543690281962597, 0.9175650905375266], 
             SphereBox[{3, 4, 1}]}}, {{
             RGBColor[
             0.5983228682179706, 0.8411000422343053, 0.17730116335672497`], 
             SphereBox[{8, 10, 3}]}}, {{
             RGBColor[
             0.14397794124131735`, 0.2748032427723439, 0.4718976074243535], 
             SphereBox[{9, 10, 1}]}}, {{
             RGBColor[
             0.5827457410202299, 0.9189686491601485, 0.4898155772021082], 
             SphereBox[{1, 4, 8}]}}, {{
             RGBColor[
             0.7358958184975835, 0.8478963300505711, 0.5753899081019282], 
             SphereBox[{9, 8, 3}]}}, {{
             RGBColor[
             0.40353760350917844`, 0.17500617846111366`, 0.7076827550032689], 
             
             SphereBox[{4, 7, 8}]}}, {{
             RGBColor[
             0.14000164287060102`, 0.6506127954497818, 0.03829984642190731], 
             SphereBox[{2, 7, 8}]}}, {{
             RGBColor[
             0.06501231100342997, 0.7835300542109025, 0.35323299481216086`], 
             SphereBox[{8, 4, 5}]}}, {{
             RGBColor[
             0.6232493161403108, 0.24373358140411416`, 0.2822878258203194], 
             SphereBox[{2, 6, 10}]}}, {{
             RGBColor[
             0.2552908815033166, 0.7497694745834484, 0.7587320548670031], 
             SphereBox[{2, 3, 9}]}}, {{
             RGBColor[
             0.0896702356884671, 0.03639833107274537, 0.6312535349502113], 
             SphereBox[{0, 6, 1}]}}, {{
             RGBColor[
             0.3979051276907455, 0.14311036213322015`, 0.17559280348369954`], 
             
             SphereBox[{2, 0, 2}]}}, {{
             RGBColor[
             0.9917160616027727, 0.7737757384216453, 0.6979865895937782], 
             SphereBox[{5, 5, 8}]}}, {{
             RGBColor[
             0.638576294313608, 0.24833748979284032`, 0.37252978567657613`], 
             SphereBox[{10, 3, 5}]}}, {{
             RGBColor[
             0.38944257780097247`, 0.5904986300752695, 0.09441485928318682], 
             SphereBox[{6, 2, 5}]}}, {{
             RGBColor[
             0.33328361171823695`, 0.0655571210860777, 0.3570309280576378], 
             SphereBox[{4, 8, 7}]}}, {{
             RGBColor[
             0.2531864748273187, 0.5036738778212624, 0.902972214066786], 
             SphereBox[{5, 0, 7}]}}, {{
             RGBColor[
             0.345741047327752, 0.7134960023958175, 0.3064230307106508], 
             SphereBox[{0, 1, 4}]}}, {{
             RGBColor[
             0.11451052345051083`, 0.3072008047047785, 0.3354556937797557], 
             SphereBox[{0, 1, 5}]}}, {{
             RGBColor[
             0.13206564283526623`, 0.2087182092332609, 0.6898484182095146], 
             SphereBox[{2, 6, 7}]}}, {{
             RGBColor[
             0.5954948830308919, 0.9395151861516513, 0.5764927267216853], 
             SphereBox[{0, 10, 9}]}}, {{
             RGBColor[
             0.5721988147519639, 0.1285348062543228, 0.37066702687821595`], 
             SphereBox[{7, 10, 7}]}}, {{
             RGBColor[
             0.659192977161323, 0.2860414092079018, 0.229662709888504], 
             SphereBox[{9, 2, 3}]}}, {{
             RGBColor[
             0.16669862043574502`, 0.4852511588158872, 0.8708800669240953], 
             SphereBox[{2, 3, 0}]}}, {{
             RGBColor[
             0.31106675086432145`, 0.12005541692075083`, 
              0.12709057958028502`], 
             SphereBox[{5, 0, 8}]}}}, ViewPoint -> {1.3, -2.4, 2.}, 
          ViewVertical -> {0., 0., 1.}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cc878e6a-4784-41c6-ad81-e843d43e6a5c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 10\[Times]10\[Times]10 array of spheres with RGB components ranging \
from 0 to 1. The spheres should be centered at integer coordinates, and \
should just touch each other.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "14.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"bd57b4a8-1f48-4eaa-a09e-3e6b4e3c5bba"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       Graphics3DBox[{{{
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 10], 
             Rational[1, 10]], 
            SphereBox[{1, 1, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 10], 
             Rational[1, 5]], 
            SphereBox[{1, 1, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 10], 
             Rational[3, 10]], 
            SphereBox[{1, 1, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 10], 
             Rational[2, 5]], 
            SphereBox[{1, 1, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 10], 
             Rational[1, 2]], 
            SphereBox[{1, 1, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 10], 
             Rational[3, 5]], 
            SphereBox[{1, 1, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 10], 
             Rational[7, 10]], 
            SphereBox[{1, 1, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 10], 
             Rational[4, 5]], 
            SphereBox[{1, 1, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 10], 
             Rational[9, 10]], 
            SphereBox[{1, 1, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 10], 1], 
            SphereBox[{1, 1, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 5], 
             Rational[1, 10]], 
            SphereBox[{1, 2, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 5], 
             Rational[1, 5]], 
            SphereBox[{1, 2, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 5], 
             Rational[3, 10]], 
            SphereBox[{1, 2, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 5], 
             Rational[2, 5]], 
            SphereBox[{1, 2, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 5], 
             Rational[1, 2]], 
            SphereBox[{1, 2, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 5], 
             Rational[3, 5]], 
            SphereBox[{1, 2, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 5], 
             Rational[7, 10]], 
            SphereBox[{1, 2, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 5], 
             Rational[4, 5]], 
            SphereBox[{1, 2, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 5], 
             Rational[9, 10]], 
            SphereBox[{1, 2, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 5], 1], 
            SphereBox[{1, 2, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 10], 
             Rational[1, 10]], 
            SphereBox[{1, 3, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 10], 
             Rational[1, 5]], 
            SphereBox[{1, 3, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 10], 
             Rational[3, 10]], 
            SphereBox[{1, 3, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 10], 
             Rational[2, 5]], 
            SphereBox[{1, 3, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 10], 
             Rational[1, 2]], 
            SphereBox[{1, 3, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 10], 
             Rational[3, 5]], 
            SphereBox[{1, 3, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 10], 
             Rational[7, 10]], 
            SphereBox[{1, 3, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 10], 
             Rational[4, 5]], 
            SphereBox[{1, 3, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 10], 
             Rational[9, 10]], 
            SphereBox[{1, 3, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 10], 1], 
            SphereBox[{1, 3, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 10], 
             Rational[2, 5], 
             Rational[1, 10]], 
            SphereBox[{1, 4, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[2, 5], 
             Rational[1, 5]], 
            SphereBox[{1, 4, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[2, 5], 
             Rational[3, 10]], 
            SphereBox[{1, 4, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[2, 5], 
             Rational[2, 5]], 
            SphereBox[{1, 4, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[2, 5], 
             Rational[1, 2]], 
            SphereBox[{1, 4, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[2, 5], 
             Rational[3, 5]], 
            SphereBox[{1, 4, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[2, 5], 
             Rational[7, 10]], 
            SphereBox[{1, 4, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[2, 5], 
             Rational[4, 5]], 
            SphereBox[{1, 4, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[2, 5], 
             Rational[9, 10]], 
            SphereBox[{1, 4, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[2, 5], 1], 
            SphereBox[{1, 4, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 2], 
             Rational[1, 10]], 
            SphereBox[{1, 5, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 2], 
             Rational[1, 5]], 
            SphereBox[{1, 5, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 2], 
             Rational[3, 10]], 
            SphereBox[{1, 5, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 2], 
             Rational[2, 5]], 
            SphereBox[{1, 5, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 2], 
             Rational[1, 2]], 
            SphereBox[{1, 5, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 2], 
             Rational[3, 5]], 
            SphereBox[{1, 5, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 2], 
             Rational[7, 10]], 
            SphereBox[{1, 5, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 2], 
             Rational[4, 5]], 
            SphereBox[{1, 5, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 2], 
             Rational[9, 10]], 
            SphereBox[{1, 5, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[1, 2], 1], 
            SphereBox[{1, 5, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 5], 
             Rational[1, 10]], 
            SphereBox[{1, 6, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 5], 
             Rational[1, 5]], 
            SphereBox[{1, 6, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 5], 
             Rational[3, 10]], 
            SphereBox[{1, 6, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 5], 
             Rational[2, 5]], 
            SphereBox[{1, 6, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 5], 
             Rational[1, 2]], 
            SphereBox[{1, 6, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 5], 
             Rational[3, 5]], 
            SphereBox[{1, 6, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 5], 
             Rational[7, 10]], 
            SphereBox[{1, 6, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 5], 
             Rational[4, 5]], 
            SphereBox[{1, 6, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 5], 
             Rational[9, 10]], 
            SphereBox[{1, 6, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[3, 5], 1], 
            SphereBox[{1, 6, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 10], 
             Rational[7, 10], 
             Rational[1, 10]], 
            SphereBox[{1, 7, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[7, 10], 
             Rational[1, 5]], 
            SphereBox[{1, 7, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[7, 10], 
             Rational[3, 10]], 
            SphereBox[{1, 7, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[7, 10], 
             Rational[2, 5]], 
            SphereBox[{1, 7, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[7, 10], 
             Rational[1, 2]], 
            SphereBox[{1, 7, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[7, 10], 
             Rational[3, 5]], 
            SphereBox[{1, 7, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[7, 10], 
             Rational[7, 10]], 
            SphereBox[{1, 7, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[7, 10], 
             Rational[4, 5]], 
            SphereBox[{1, 7, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[7, 10], 
             Rational[9, 10]], 
            SphereBox[{1, 7, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[7, 10], 1], 
            SphereBox[{1, 7, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 10], 
             Rational[4, 5], 
             Rational[1, 10]], 
            SphereBox[{1, 8, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[4, 5], 
             Rational[1, 5]], 
            SphereBox[{1, 8, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[4, 5], 
             Rational[3, 10]], 
            SphereBox[{1, 8, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[4, 5], 
             Rational[2, 5]], 
            SphereBox[{1, 8, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[4, 5], 
             Rational[1, 2]], 
            SphereBox[{1, 8, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[4, 5], 
             Rational[3, 5]], 
            SphereBox[{1, 8, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[4, 5], 
             Rational[7, 10]], 
            SphereBox[{1, 8, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[4, 5], 
             Rational[4, 5]], 
            SphereBox[{1, 8, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[4, 5], 
             Rational[9, 10]], 
            SphereBox[{1, 8, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[4, 5], 1], 
            SphereBox[{1, 8, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 10], 
             Rational[9, 10], 
             Rational[1, 10]], 
            SphereBox[{1, 9, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[9, 10], 
             Rational[1, 5]], 
            SphereBox[{1, 9, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[9, 10], 
             Rational[3, 10]], 
            SphereBox[{1, 9, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[9, 10], 
             Rational[2, 5]], 
            SphereBox[{1, 9, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[9, 10], 
             Rational[1, 2]], 
            SphereBox[{1, 9, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[9, 10], 
             Rational[3, 5]], 
            SphereBox[{1, 9, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[9, 10], 
             Rational[7, 10]], 
            SphereBox[{1, 9, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[9, 10], 
             Rational[4, 5]], 
            SphereBox[{1, 9, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[9, 10], 
             Rational[9, 10]], 
            SphereBox[{1, 9, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 
             Rational[9, 10], 1], 
            SphereBox[{1, 9, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 10], 1, 
             Rational[1, 10]], 
            SphereBox[{1, 10, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 1, 
             Rational[1, 5]], 
            SphereBox[{1, 10, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 1, 
             Rational[3, 10]], 
            SphereBox[{1, 10, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 1, 
             Rational[2, 5]], 
            SphereBox[{1, 10, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 1, 
             Rational[1, 2]], 
            SphereBox[{1, 10, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 1, 
             Rational[3, 5]], 
            SphereBox[{1, 10, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 1, 
             Rational[7, 10]], 
            SphereBox[{1, 10, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 1, 
             Rational[4, 5]], 
            SphereBox[{1, 10, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 1, 
             Rational[9, 10]], 
            SphereBox[{1, 10, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 10], 1, 1], 
            SphereBox[{1, 10, 10}, NCache[Rational[1, 2], 0.5]]}}}, {{
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 10], 
             Rational[1, 10]], 
            SphereBox[{2, 1, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 10], 
             Rational[1, 5]], 
            SphereBox[{2, 1, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 10], 
             Rational[3, 10]], 
            SphereBox[{2, 1, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 10], 
             Rational[2, 5]], 
            SphereBox[{2, 1, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 10], 
             Rational[1, 2]], 
            SphereBox[{2, 1, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 10], 
             Rational[3, 5]], 
            SphereBox[{2, 1, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 10], 
             Rational[7, 10]], 
            SphereBox[{2, 1, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 10], 
             Rational[4, 5]], 
            SphereBox[{2, 1, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 10], 
             Rational[9, 10]], 
            SphereBox[{2, 1, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 10], 1], 
            SphereBox[{2, 1, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 5], 
             Rational[1, 10]], 
            SphereBox[{2, 2, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 5], 
             Rational[1, 5]], 
            SphereBox[{2, 2, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 5], 
             Rational[3, 10]], 
            SphereBox[{2, 2, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 5], 
             Rational[2, 5]], 
            SphereBox[{2, 2, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 5], 
             Rational[1, 2]], 
            SphereBox[{2, 2, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 5], 
             Rational[3, 5]], 
            SphereBox[{2, 2, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 5], 
             Rational[7, 10]], 
            SphereBox[{2, 2, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 5], 
             Rational[4, 5]], 
            SphereBox[{2, 2, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 5], 
             Rational[9, 10]], 
            SphereBox[{2, 2, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 5], 1], 
            SphereBox[{2, 2, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 10], 
             Rational[1, 10]], 
            SphereBox[{2, 3, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 10], 
             Rational[1, 5]], 
            SphereBox[{2, 3, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 10], 
             Rational[3, 10]], 
            SphereBox[{2, 3, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 10], 
             Rational[2, 5]], 
            SphereBox[{2, 3, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 10], 
             Rational[1, 2]], 
            SphereBox[{2, 3, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 10], 
             Rational[3, 5]], 
            SphereBox[{2, 3, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 10], 
             Rational[7, 10]], 
            SphereBox[{2, 3, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 10], 
             Rational[4, 5]], 
            SphereBox[{2, 3, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 10], 
             Rational[9, 10]], 
            SphereBox[{2, 3, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 10], 1], 
            SphereBox[{2, 3, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 5], 
             Rational[2, 5], 
             Rational[1, 10]], 
            SphereBox[{2, 4, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[2, 5], 
             Rational[1, 5]], 
            SphereBox[{2, 4, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[2, 5], 
             Rational[3, 10]], 
            SphereBox[{2, 4, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[2, 5], 
             Rational[2, 5]], 
            SphereBox[{2, 4, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[2, 5], 
             Rational[1, 2]], 
            SphereBox[{2, 4, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[2, 5], 
             Rational[3, 5]], 
            SphereBox[{2, 4, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[2, 5], 
             Rational[7, 10]], 
            SphereBox[{2, 4, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[2, 5], 
             Rational[4, 5]], 
            SphereBox[{2, 4, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[2, 5], 
             Rational[9, 10]], 
            SphereBox[{2, 4, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[2, 5], 1], 
            SphereBox[{2, 4, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 2], 
             Rational[1, 10]], 
            SphereBox[{2, 5, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 2], 
             Rational[1, 5]], 
            SphereBox[{2, 5, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 2], 
             Rational[3, 10]], 
            SphereBox[{2, 5, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 2], 
             Rational[2, 5]], 
            SphereBox[{2, 5, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 2], 
             Rational[1, 2]], 
            SphereBox[{2, 5, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 2], 
             Rational[3, 5]], 
            SphereBox[{2, 5, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 2], 
             Rational[7, 10]], 
            SphereBox[{2, 5, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 2], 
             Rational[4, 5]], 
            SphereBox[{2, 5, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 2], 
             Rational[9, 10]], 
            SphereBox[{2, 5, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[1, 2], 1], 
            SphereBox[{2, 5, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 5], 
             Rational[1, 10]], 
            SphereBox[{2, 6, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 5], 
             Rational[1, 5]], 
            SphereBox[{2, 6, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 5], 
             Rational[3, 10]], 
            SphereBox[{2, 6, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 5], 
             Rational[2, 5]], 
            SphereBox[{2, 6, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 5], 
             Rational[1, 2]], 
            SphereBox[{2, 6, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 5], 
             Rational[3, 5]], 
            SphereBox[{2, 6, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 5], 
             Rational[7, 10]], 
            SphereBox[{2, 6, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 5], 
             Rational[4, 5]], 
            SphereBox[{2, 6, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 5], 
             Rational[9, 10]], 
            SphereBox[{2, 6, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[3, 5], 1], 
            SphereBox[{2, 6, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 5], 
             Rational[7, 10], 
             Rational[1, 10]], 
            SphereBox[{2, 7, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[7, 10], 
             Rational[1, 5]], 
            SphereBox[{2, 7, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[7, 10], 
             Rational[3, 10]], 
            SphereBox[{2, 7, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[7, 10], 
             Rational[2, 5]], 
            SphereBox[{2, 7, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[7, 10], 
             Rational[1, 2]], 
            SphereBox[{2, 7, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[7, 10], 
             Rational[3, 5]], 
            SphereBox[{2, 7, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[7, 10], 
             Rational[7, 10]], 
            SphereBox[{2, 7, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[7, 10], 
             Rational[4, 5]], 
            SphereBox[{2, 7, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[7, 10], 
             Rational[9, 10]], 
            SphereBox[{2, 7, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[7, 10], 1], 
            SphereBox[{2, 7, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 5], 
             Rational[4, 5], 
             Rational[1, 10]], 
            SphereBox[{2, 8, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[4, 5], 
             Rational[1, 5]], 
            SphereBox[{2, 8, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[4, 5], 
             Rational[3, 10]], 
            SphereBox[{2, 8, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[4, 5], 
             Rational[2, 5]], 
            SphereBox[{2, 8, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[4, 5], 
             Rational[1, 2]], 
            SphereBox[{2, 8, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[4, 5], 
             Rational[3, 5]], 
            SphereBox[{2, 8, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[4, 5], 
             Rational[7, 10]], 
            SphereBox[{2, 8, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[4, 5], 
             Rational[4, 5]], 
            SphereBox[{2, 8, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[4, 5], 
             Rational[9, 10]], 
            SphereBox[{2, 8, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[4, 5], 1], 
            SphereBox[{2, 8, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 5], 
             Rational[9, 10], 
             Rational[1, 10]], 
            SphereBox[{2, 9, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[9, 10], 
             Rational[1, 5]], 
            SphereBox[{2, 9, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[9, 10], 
             Rational[3, 10]], 
            SphereBox[{2, 9, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[9, 10], 
             Rational[2, 5]], 
            SphereBox[{2, 9, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[9, 10], 
             Rational[1, 2]], 
            SphereBox[{2, 9, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[9, 10], 
             Rational[3, 5]], 
            SphereBox[{2, 9, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[9, 10], 
             Rational[7, 10]], 
            SphereBox[{2, 9, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[9, 10], 
             Rational[4, 5]], 
            SphereBox[{2, 9, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[9, 10], 
             Rational[9, 10]], 
            SphereBox[{2, 9, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 
             Rational[9, 10], 1], 
            SphereBox[{2, 9, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 5], 1, 
             Rational[1, 10]], 
            SphereBox[{2, 10, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 1, 
             Rational[1, 5]], 
            SphereBox[{2, 10, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 1, 
             Rational[3, 10]], 
            SphereBox[{2, 10, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 1, 
             Rational[2, 5]], 
            SphereBox[{2, 10, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 1, 
             Rational[1, 2]], 
            SphereBox[{2, 10, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 1, 
             Rational[3, 5]], 
            SphereBox[{2, 10, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 1, 
             Rational[7, 10]], 
            SphereBox[{2, 10, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 1, 
             Rational[4, 5]], 
            SphereBox[{2, 10, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 1, 
             Rational[9, 10]], 
            SphereBox[{2, 10, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 5], 1, 1], 
            SphereBox[{2, 10, 10}, NCache[Rational[1, 2], 0.5]]}}}, {{
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 10], 
             Rational[1, 10]], 
            SphereBox[{3, 1, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 10], 
             Rational[1, 5]], 
            SphereBox[{3, 1, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 10], 
             Rational[3, 10]], 
            SphereBox[{3, 1, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 10], 
             Rational[2, 5]], 
            SphereBox[{3, 1, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 10], 
             Rational[1, 2]], 
            SphereBox[{3, 1, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 10], 
             Rational[3, 5]], 
            SphereBox[{3, 1, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 10], 
             Rational[7, 10]], 
            SphereBox[{3, 1, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 10], 
             Rational[4, 5]], 
            SphereBox[{3, 1, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 10], 
             Rational[9, 10]], 
            SphereBox[{3, 1, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 10], 1], 
            SphereBox[{3, 1, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 5], 
             Rational[1, 10]], 
            SphereBox[{3, 2, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 5], 
             Rational[1, 5]], 
            SphereBox[{3, 2, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 5], 
             Rational[3, 10]], 
            SphereBox[{3, 2, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 5], 
             Rational[2, 5]], 
            SphereBox[{3, 2, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 5], 
             Rational[1, 2]], 
            SphereBox[{3, 2, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 5], 
             Rational[3, 5]], 
            SphereBox[{3, 2, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 5], 
             Rational[7, 10]], 
            SphereBox[{3, 2, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 5], 
             Rational[4, 5]], 
            SphereBox[{3, 2, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 5], 
             Rational[9, 10]], 
            SphereBox[{3, 2, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 5], 1], 
            SphereBox[{3, 2, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 10], 
             Rational[1, 10]], 
            SphereBox[{3, 3, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 10], 
             Rational[1, 5]], 
            SphereBox[{3, 3, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 10], 
             Rational[3, 10]], 
            SphereBox[{3, 3, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 10], 
             Rational[2, 5]], 
            SphereBox[{3, 3, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 10], 
             Rational[1, 2]], 
            SphereBox[{3, 3, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 10], 
             Rational[3, 5]], 
            SphereBox[{3, 3, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 10], 
             Rational[7, 10]], 
            SphereBox[{3, 3, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 10], 
             Rational[4, 5]], 
            SphereBox[{3, 3, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 10], 
             Rational[9, 10]], 
            SphereBox[{3, 3, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 10], 1], 
            SphereBox[{3, 3, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 10], 
             Rational[2, 5], 
             Rational[1, 10]], 
            SphereBox[{3, 4, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[2, 5], 
             Rational[1, 5]], 
            SphereBox[{3, 4, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[2, 5], 
             Rational[3, 10]], 
            SphereBox[{3, 4, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[2, 5], 
             Rational[2, 5]], 
            SphereBox[{3, 4, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[2, 5], 
             Rational[1, 2]], 
            SphereBox[{3, 4, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[2, 5], 
             Rational[3, 5]], 
            SphereBox[{3, 4, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[2, 5], 
             Rational[7, 10]], 
            SphereBox[{3, 4, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[2, 5], 
             Rational[4, 5]], 
            SphereBox[{3, 4, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[2, 5], 
             Rational[9, 10]], 
            SphereBox[{3, 4, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[2, 5], 1], 
            SphereBox[{3, 4, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 2], 
             Rational[1, 10]], 
            SphereBox[{3, 5, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 2], 
             Rational[1, 5]], 
            SphereBox[{3, 5, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 2], 
             Rational[3, 10]], 
            SphereBox[{3, 5, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 2], 
             Rational[2, 5]], 
            SphereBox[{3, 5, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 2], 
             Rational[1, 2]], 
            SphereBox[{3, 5, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 2], 
             Rational[3, 5]], 
            SphereBox[{3, 5, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 2], 
             Rational[7, 10]], 
            SphereBox[{3, 5, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 2], 
             Rational[4, 5]], 
            SphereBox[{3, 5, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 2], 
             Rational[9, 10]], 
            SphereBox[{3, 5, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[1, 2], 1], 
            SphereBox[{3, 5, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 5], 
             Rational[1, 10]], 
            SphereBox[{3, 6, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 5], 
             Rational[1, 5]], 
            SphereBox[{3, 6, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 5], 
             Rational[3, 10]], 
            SphereBox[{3, 6, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 5], 
             Rational[2, 5]], 
            SphereBox[{3, 6, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 5], 
             Rational[1, 2]], 
            SphereBox[{3, 6, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 5], 
             Rational[3, 5]], 
            SphereBox[{3, 6, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 5], 
             Rational[7, 10]], 
            SphereBox[{3, 6, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 5], 
             Rational[4, 5]], 
            SphereBox[{3, 6, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 5], 
             Rational[9, 10]], 
            SphereBox[{3, 6, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[3, 5], 1], 
            SphereBox[{3, 6, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 10], 
             Rational[7, 10], 
             Rational[1, 10]], 
            SphereBox[{3, 7, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[7, 10], 
             Rational[1, 5]], 
            SphereBox[{3, 7, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[7, 10], 
             Rational[3, 10]], 
            SphereBox[{3, 7, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[7, 10], 
             Rational[2, 5]], 
            SphereBox[{3, 7, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[7, 10], 
             Rational[1, 2]], 
            SphereBox[{3, 7, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[7, 10], 
             Rational[3, 5]], 
            SphereBox[{3, 7, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[7, 10], 
             Rational[7, 10]], 
            SphereBox[{3, 7, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[7, 10], 
             Rational[4, 5]], 
            SphereBox[{3, 7, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[7, 10], 
             Rational[9, 10]], 
            SphereBox[{3, 7, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[7, 10], 1], 
            SphereBox[{3, 7, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 10], 
             Rational[4, 5], 
             Rational[1, 10]], 
            SphereBox[{3, 8, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[4, 5], 
             Rational[1, 5]], 
            SphereBox[{3, 8, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[4, 5], 
             Rational[3, 10]], 
            SphereBox[{3, 8, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[4, 5], 
             Rational[2, 5]], 
            SphereBox[{3, 8, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[4, 5], 
             Rational[1, 2]], 
            SphereBox[{3, 8, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[4, 5], 
             Rational[3, 5]], 
            SphereBox[{3, 8, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[4, 5], 
             Rational[7, 10]], 
            SphereBox[{3, 8, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[4, 5], 
             Rational[4, 5]], 
            SphereBox[{3, 8, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[4, 5], 
             Rational[9, 10]], 
            SphereBox[{3, 8, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[4, 5], 1], 
            SphereBox[{3, 8, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 10], 
             Rational[9, 10], 
             Rational[1, 10]], 
            SphereBox[{3, 9, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[9, 10], 
             Rational[1, 5]], 
            SphereBox[{3, 9, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[9, 10], 
             Rational[3, 10]], 
            SphereBox[{3, 9, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[9, 10], 
             Rational[2, 5]], 
            SphereBox[{3, 9, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[9, 10], 
             Rational[1, 2]], 
            SphereBox[{3, 9, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[9, 10], 
             Rational[3, 5]], 
            SphereBox[{3, 9, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[9, 10], 
             Rational[7, 10]], 
            SphereBox[{3, 9, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[9, 10], 
             Rational[4, 5]], 
            SphereBox[{3, 9, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[9, 10], 
             Rational[9, 10]], 
            SphereBox[{3, 9, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 
             Rational[9, 10], 1], 
            SphereBox[{3, 9, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 10], 1, 
             Rational[1, 10]], 
            SphereBox[{3, 10, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 1, 
             Rational[1, 5]], 
            SphereBox[{3, 10, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 1, 
             Rational[3, 10]], 
            SphereBox[{3, 10, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 1, 
             Rational[2, 5]], 
            SphereBox[{3, 10, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 1, 
             Rational[1, 2]], 
            SphereBox[{3, 10, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 1, 
             Rational[3, 5]], 
            SphereBox[{3, 10, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 1, 
             Rational[7, 10]], 
            SphereBox[{3, 10, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 1, 
             Rational[4, 5]], 
            SphereBox[{3, 10, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 1, 
             Rational[9, 10]], 
            SphereBox[{3, 10, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 10], 1, 1], 
            SphereBox[{3, 10, 10}, NCache[Rational[1, 2], 0.5]]}}}, {{
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 10], 
             Rational[1, 10]], 
            SphereBox[{4, 1, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 10], 
             Rational[1, 5]], 
            SphereBox[{4, 1, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 10], 
             Rational[3, 10]], 
            SphereBox[{4, 1, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 10], 
             Rational[2, 5]], 
            SphereBox[{4, 1, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 10], 
             Rational[1, 2]], 
            SphereBox[{4, 1, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 10], 
             Rational[3, 5]], 
            SphereBox[{4, 1, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 10], 
             Rational[7, 10]], 
            SphereBox[{4, 1, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 10], 
             Rational[4, 5]], 
            SphereBox[{4, 1, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 10], 
             Rational[9, 10]], 
            SphereBox[{4, 1, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 10], 1], 
            SphereBox[{4, 1, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 5], 
             Rational[1, 10]], 
            SphereBox[{4, 2, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 5], 
             Rational[1, 5]], 
            SphereBox[{4, 2, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 5], 
             Rational[3, 10]], 
            SphereBox[{4, 2, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 5], 
             Rational[2, 5]], 
            SphereBox[{4, 2, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 5], 
             Rational[1, 2]], 
            SphereBox[{4, 2, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 5], 
             Rational[3, 5]], 
            SphereBox[{4, 2, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 5], 
             Rational[7, 10]], 
            SphereBox[{4, 2, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 5], 
             Rational[4, 5]], 
            SphereBox[{4, 2, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 5], 
             Rational[9, 10]], 
            SphereBox[{4, 2, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 5], 1], 
            SphereBox[{4, 2, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 10], 
             Rational[1, 10]], 
            SphereBox[{4, 3, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 10], 
             Rational[1, 5]], 
            SphereBox[{4, 3, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 10], 
             Rational[3, 10]], 
            SphereBox[{4, 3, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 10], 
             Rational[2, 5]], 
            SphereBox[{4, 3, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 10], 
             Rational[1, 2]], 
            SphereBox[{4, 3, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 10], 
             Rational[3, 5]], 
            SphereBox[{4, 3, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 10], 
             Rational[7, 10]], 
            SphereBox[{4, 3, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 10], 
             Rational[4, 5]], 
            SphereBox[{4, 3, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 10], 
             Rational[9, 10]], 
            SphereBox[{4, 3, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 10], 1], 
            SphereBox[{4, 3, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[2, 5], 
             Rational[2, 5], 
             Rational[1, 10]], 
            SphereBox[{4, 4, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[2, 5], 
             Rational[1, 5]], 
            SphereBox[{4, 4, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[2, 5], 
             Rational[3, 10]], 
            SphereBox[{4, 4, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[2, 5], 
             Rational[2, 5]], 
            SphereBox[{4, 4, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[2, 5], 
             Rational[1, 2]], 
            SphereBox[{4, 4, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[2, 5], 
             Rational[3, 5]], 
            SphereBox[{4, 4, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[2, 5], 
             Rational[7, 10]], 
            SphereBox[{4, 4, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[2, 5], 
             Rational[4, 5]], 
            SphereBox[{4, 4, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[2, 5], 
             Rational[9, 10]], 
            SphereBox[{4, 4, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[2, 5], 1], 
            SphereBox[{4, 4, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 2], 
             Rational[1, 10]], 
            SphereBox[{4, 5, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 2], 
             Rational[1, 5]], 
            SphereBox[{4, 5, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 2], 
             Rational[3, 10]], 
            SphereBox[{4, 5, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 2], 
             Rational[2, 5]], 
            SphereBox[{4, 5, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 2], 
             Rational[1, 2]], 
            SphereBox[{4, 5, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 2], 
             Rational[3, 5]], 
            SphereBox[{4, 5, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 2], 
             Rational[7, 10]], 
            SphereBox[{4, 5, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 2], 
             Rational[4, 5]], 
            SphereBox[{4, 5, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 2], 
             Rational[9, 10]], 
            SphereBox[{4, 5, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[1, 2], 1], 
            SphereBox[{4, 5, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 5], 
             Rational[1, 10]], 
            SphereBox[{4, 6, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 5], 
             Rational[1, 5]], 
            SphereBox[{4, 6, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 5], 
             Rational[3, 10]], 
            SphereBox[{4, 6, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 5], 
             Rational[2, 5]], 
            SphereBox[{4, 6, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 5], 
             Rational[1, 2]], 
            SphereBox[{4, 6, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 5], 
             Rational[3, 5]], 
            SphereBox[{4, 6, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 5], 
             Rational[7, 10]], 
            SphereBox[{4, 6, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 5], 
             Rational[4, 5]], 
            SphereBox[{4, 6, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 5], 
             Rational[9, 10]], 
            SphereBox[{4, 6, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[3, 5], 1], 
            SphereBox[{4, 6, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[2, 5], 
             Rational[7, 10], 
             Rational[1, 10]], 
            SphereBox[{4, 7, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[7, 10], 
             Rational[1, 5]], 
            SphereBox[{4, 7, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[7, 10], 
             Rational[3, 10]], 
            SphereBox[{4, 7, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[7, 10], 
             Rational[2, 5]], 
            SphereBox[{4, 7, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[7, 10], 
             Rational[1, 2]], 
            SphereBox[{4, 7, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[7, 10], 
             Rational[3, 5]], 
            SphereBox[{4, 7, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[7, 10], 
             Rational[7, 10]], 
            SphereBox[{4, 7, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[7, 10], 
             Rational[4, 5]], 
            SphereBox[{4, 7, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[7, 10], 
             Rational[9, 10]], 
            SphereBox[{4, 7, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[7, 10], 1], 
            SphereBox[{4, 7, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[2, 5], 
             Rational[4, 5], 
             Rational[1, 10]], 
            SphereBox[{4, 8, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[4, 5], 
             Rational[1, 5]], 
            SphereBox[{4, 8, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[4, 5], 
             Rational[3, 10]], 
            SphereBox[{4, 8, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[4, 5], 
             Rational[2, 5]], 
            SphereBox[{4, 8, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[4, 5], 
             Rational[1, 2]], 
            SphereBox[{4, 8, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[4, 5], 
             Rational[3, 5]], 
            SphereBox[{4, 8, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[4, 5], 
             Rational[7, 10]], 
            SphereBox[{4, 8, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[4, 5], 
             Rational[4, 5]], 
            SphereBox[{4, 8, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[4, 5], 
             Rational[9, 10]], 
            SphereBox[{4, 8, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[4, 5], 1], 
            SphereBox[{4, 8, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[2, 5], 
             Rational[9, 10], 
             Rational[1, 10]], 
            SphereBox[{4, 9, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[9, 10], 
             Rational[1, 5]], 
            SphereBox[{4, 9, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[9, 10], 
             Rational[3, 10]], 
            SphereBox[{4, 9, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[9, 10], 
             Rational[2, 5]], 
            SphereBox[{4, 9, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[9, 10], 
             Rational[1, 2]], 
            SphereBox[{4, 9, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[9, 10], 
             Rational[3, 5]], 
            SphereBox[{4, 9, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[9, 10], 
             Rational[7, 10]], 
            SphereBox[{4, 9, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[9, 10], 
             Rational[4, 5]], 
            SphereBox[{4, 9, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[9, 10], 
             Rational[9, 10]], 
            SphereBox[{4, 9, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 
             Rational[9, 10], 1], 
            SphereBox[{4, 9, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[2, 5], 1, 
             Rational[1, 10]], 
            SphereBox[{4, 10, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 1, 
             Rational[1, 5]], 
            SphereBox[{4, 10, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 1, 
             Rational[3, 10]], 
            SphereBox[{4, 10, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 1, 
             Rational[2, 5]], 
            SphereBox[{4, 10, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 1, 
             Rational[1, 2]], 
            SphereBox[{4, 10, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 1, 
             Rational[3, 5]], 
            SphereBox[{4, 10, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 1, 
             Rational[7, 10]], 
            SphereBox[{4, 10, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 1, 
             Rational[4, 5]], 
            SphereBox[{4, 10, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 1, 
             Rational[9, 10]], 
            SphereBox[{4, 10, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[2, 5], 1, 1], 
            SphereBox[{4, 10, 10}, NCache[Rational[1, 2], 0.5]]}}}, {{
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 10], 
             Rational[1, 10]], 
            SphereBox[{5, 1, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 10], 
             Rational[1, 5]], 
            SphereBox[{5, 1, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 10], 
             Rational[3, 10]], 
            SphereBox[{5, 1, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 10], 
             Rational[2, 5]], 
            SphereBox[{5, 1, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 10], 
             Rational[1, 2]], 
            SphereBox[{5, 1, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 10], 
             Rational[3, 5]], 
            SphereBox[{5, 1, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 10], 
             Rational[7, 10]], 
            SphereBox[{5, 1, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 10], 
             Rational[4, 5]], 
            SphereBox[{5, 1, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 10], 
             Rational[9, 10]], 
            SphereBox[{5, 1, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 10], 1], 
            SphereBox[{5, 1, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 5], 
             Rational[1, 10]], 
            SphereBox[{5, 2, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 5], 
             Rational[1, 5]], 
            SphereBox[{5, 2, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 5], 
             Rational[3, 10]], 
            SphereBox[{5, 2, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 5], 
             Rational[2, 5]], 
            SphereBox[{5, 2, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 5], 
             Rational[1, 2]], 
            SphereBox[{5, 2, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 5], 
             Rational[3, 5]], 
            SphereBox[{5, 2, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 5], 
             Rational[7, 10]], 
            SphereBox[{5, 2, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 5], 
             Rational[4, 5]], 
            SphereBox[{5, 2, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 5], 
             Rational[9, 10]], 
            SphereBox[{5, 2, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 5], 1], 
            SphereBox[{5, 2, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 10], 
             Rational[1, 10]], 
            SphereBox[{5, 3, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 10], 
             Rational[1, 5]], 
            SphereBox[{5, 3, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 10], 
             Rational[3, 10]], 
            SphereBox[{5, 3, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 10], 
             Rational[2, 5]], 
            SphereBox[{5, 3, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 10], 
             Rational[1, 2]], 
            SphereBox[{5, 3, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 10], 
             Rational[3, 5]], 
            SphereBox[{5, 3, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 10], 
             Rational[7, 10]], 
            SphereBox[{5, 3, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 10], 
             Rational[4, 5]], 
            SphereBox[{5, 3, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 10], 
             Rational[9, 10]], 
            SphereBox[{5, 3, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 10], 1], 
            SphereBox[{5, 3, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 2], 
             Rational[2, 5], 
             Rational[1, 10]], 
            SphereBox[{5, 4, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[2, 5], 
             Rational[1, 5]], 
            SphereBox[{5, 4, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[2, 5], 
             Rational[3, 10]], 
            SphereBox[{5, 4, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[2, 5], 
             Rational[2, 5]], 
            SphereBox[{5, 4, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[2, 5], 
             Rational[1, 2]], 
            SphereBox[{5, 4, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[2, 5], 
             Rational[3, 5]], 
            SphereBox[{5, 4, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[2, 5], 
             Rational[7, 10]], 
            SphereBox[{5, 4, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[2, 5], 
             Rational[4, 5]], 
            SphereBox[{5, 4, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[2, 5], 
             Rational[9, 10]], 
            SphereBox[{5, 4, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[2, 5], 1], 
            SphereBox[{5, 4, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 2], 
             Rational[1, 10]], 
            SphereBox[{5, 5, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 2], 
             Rational[1, 5]], 
            SphereBox[{5, 5, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 2], 
             Rational[3, 10]], 
            SphereBox[{5, 5, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 2], 
             Rational[2, 5]], 
            SphereBox[{5, 5, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 2], 
             Rational[1, 2]], 
            SphereBox[{5, 5, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 2], 
             Rational[3, 5]], 
            SphereBox[{5, 5, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 2], 
             Rational[7, 10]], 
            SphereBox[{5, 5, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 2], 
             Rational[4, 5]], 
            SphereBox[{5, 5, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 2], 
             Rational[9, 10]], 
            SphereBox[{5, 5, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[1, 2], 1], 
            SphereBox[{5, 5, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 5], 
             Rational[1, 10]], 
            SphereBox[{5, 6, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 5], 
             Rational[1, 5]], 
            SphereBox[{5, 6, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 5], 
             Rational[3, 10]], 
            SphereBox[{5, 6, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 5], 
             Rational[2, 5]], 
            SphereBox[{5, 6, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 5], 
             Rational[1, 2]], 
            SphereBox[{5, 6, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 5], 
             Rational[3, 5]], 
            SphereBox[{5, 6, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 5], 
             Rational[7, 10]], 
            SphereBox[{5, 6, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 5], 
             Rational[4, 5]], 
            SphereBox[{5, 6, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 5], 
             Rational[9, 10]], 
            SphereBox[{5, 6, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[3, 5], 1], 
            SphereBox[{5, 6, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 2], 
             Rational[7, 10], 
             Rational[1, 10]], 
            SphereBox[{5, 7, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[7, 10], 
             Rational[1, 5]], 
            SphereBox[{5, 7, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[7, 10], 
             Rational[3, 10]], 
            SphereBox[{5, 7, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[7, 10], 
             Rational[2, 5]], 
            SphereBox[{5, 7, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[7, 10], 
             Rational[1, 2]], 
            SphereBox[{5, 7, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[7, 10], 
             Rational[3, 5]], 
            SphereBox[{5, 7, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[7, 10], 
             Rational[7, 10]], 
            SphereBox[{5, 7, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[7, 10], 
             Rational[4, 5]], 
            SphereBox[{5, 7, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[7, 10], 
             Rational[9, 10]], 
            SphereBox[{5, 7, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[7, 10], 1], 
            SphereBox[{5, 7, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 2], 
             Rational[4, 5], 
             Rational[1, 10]], 
            SphereBox[{5, 8, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[4, 5], 
             Rational[1, 5]], 
            SphereBox[{5, 8, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[4, 5], 
             Rational[3, 10]], 
            SphereBox[{5, 8, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[4, 5], 
             Rational[2, 5]], 
            SphereBox[{5, 8, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[4, 5], 
             Rational[1, 2]], 
            SphereBox[{5, 8, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[4, 5], 
             Rational[3, 5]], 
            SphereBox[{5, 8, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[4, 5], 
             Rational[7, 10]], 
            SphereBox[{5, 8, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[4, 5], 
             Rational[4, 5]], 
            SphereBox[{5, 8, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[4, 5], 
             Rational[9, 10]], 
            SphereBox[{5, 8, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[4, 5], 1], 
            SphereBox[{5, 8, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 2], 
             Rational[9, 10], 
             Rational[1, 10]], 
            SphereBox[{5, 9, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[9, 10], 
             Rational[1, 5]], 
            SphereBox[{5, 9, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[9, 10], 
             Rational[3, 10]], 
            SphereBox[{5, 9, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[9, 10], 
             Rational[2, 5]], 
            SphereBox[{5, 9, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[9, 10], 
             Rational[1, 2]], 
            SphereBox[{5, 9, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[9, 10], 
             Rational[3, 5]], 
            SphereBox[{5, 9, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[9, 10], 
             Rational[7, 10]], 
            SphereBox[{5, 9, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[9, 10], 
             Rational[4, 5]], 
            SphereBox[{5, 9, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[9, 10], 
             Rational[9, 10]], 
            SphereBox[{5, 9, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 
             Rational[9, 10], 1], 
            SphereBox[{5, 9, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[1, 2], 1, 
             Rational[1, 10]], 
            SphereBox[{5, 10, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 1, 
             Rational[1, 5]], 
            SphereBox[{5, 10, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 1, 
             Rational[3, 10]], 
            SphereBox[{5, 10, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 1, 
             Rational[2, 5]], 
            SphereBox[{5, 10, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 1, 
             Rational[1, 2]], 
            SphereBox[{5, 10, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 1, 
             Rational[3, 5]], 
            SphereBox[{5, 10, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 1, 
             Rational[7, 10]], 
            SphereBox[{5, 10, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 1, 
             Rational[4, 5]], 
            SphereBox[{5, 10, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 1, 
             Rational[9, 10]], 
            SphereBox[{5, 10, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[1, 2], 1, 1], 
            SphereBox[{5, 10, 10}, NCache[Rational[1, 2], 0.5]]}}}, {{
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 10], 
             Rational[1, 10]], 
            SphereBox[{6, 1, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 10], 
             Rational[1, 5]], 
            SphereBox[{6, 1, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 10], 
             Rational[3, 10]], 
            SphereBox[{6, 1, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 10], 
             Rational[2, 5]], 
            SphereBox[{6, 1, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 10], 
             Rational[1, 2]], 
            SphereBox[{6, 1, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 10], 
             Rational[3, 5]], 
            SphereBox[{6, 1, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 10], 
             Rational[7, 10]], 
            SphereBox[{6, 1, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 10], 
             Rational[4, 5]], 
            SphereBox[{6, 1, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 10], 
             Rational[9, 10]], 
            SphereBox[{6, 1, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 10], 1], 
            SphereBox[{6, 1, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 5], 
             Rational[1, 10]], 
            SphereBox[{6, 2, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 5], 
             Rational[1, 5]], 
            SphereBox[{6, 2, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 5], 
             Rational[3, 10]], 
            SphereBox[{6, 2, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 5], 
             Rational[2, 5]], 
            SphereBox[{6, 2, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 5], 
             Rational[1, 2]], 
            SphereBox[{6, 2, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 5], 
             Rational[3, 5]], 
            SphereBox[{6, 2, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 5], 
             Rational[7, 10]], 
            SphereBox[{6, 2, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 5], 
             Rational[4, 5]], 
            SphereBox[{6, 2, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 5], 
             Rational[9, 10]], 
            SphereBox[{6, 2, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 5], 1], 
            SphereBox[{6, 2, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 10], 
             Rational[1, 10]], 
            SphereBox[{6, 3, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 10], 
             Rational[1, 5]], 
            SphereBox[{6, 3, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 10], 
             Rational[3, 10]], 
            SphereBox[{6, 3, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 10], 
             Rational[2, 5]], 
            SphereBox[{6, 3, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 10], 
             Rational[1, 2]], 
            SphereBox[{6, 3, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 10], 
             Rational[3, 5]], 
            SphereBox[{6, 3, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 10], 
             Rational[7, 10]], 
            SphereBox[{6, 3, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 10], 
             Rational[4, 5]], 
            SphereBox[{6, 3, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 10], 
             Rational[9, 10]], 
            SphereBox[{6, 3, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 10], 1], 
            SphereBox[{6, 3, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 5], 
             Rational[2, 5], 
             Rational[1, 10]], 
            SphereBox[{6, 4, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[2, 5], 
             Rational[1, 5]], 
            SphereBox[{6, 4, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[2, 5], 
             Rational[3, 10]], 
            SphereBox[{6, 4, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[2, 5], 
             Rational[2, 5]], 
            SphereBox[{6, 4, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[2, 5], 
             Rational[1, 2]], 
            SphereBox[{6, 4, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[2, 5], 
             Rational[3, 5]], 
            SphereBox[{6, 4, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[2, 5], 
             Rational[7, 10]], 
            SphereBox[{6, 4, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[2, 5], 
             Rational[4, 5]], 
            SphereBox[{6, 4, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[2, 5], 
             Rational[9, 10]], 
            SphereBox[{6, 4, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[2, 5], 1], 
            SphereBox[{6, 4, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 2], 
             Rational[1, 10]], 
            SphereBox[{6, 5, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 2], 
             Rational[1, 5]], 
            SphereBox[{6, 5, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 2], 
             Rational[3, 10]], 
            SphereBox[{6, 5, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 2], 
             Rational[2, 5]], 
            SphereBox[{6, 5, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 2], 
             Rational[1, 2]], 
            SphereBox[{6, 5, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 2], 
             Rational[3, 5]], 
            SphereBox[{6, 5, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 2], 
             Rational[7, 10]], 
            SphereBox[{6, 5, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 2], 
             Rational[4, 5]], 
            SphereBox[{6, 5, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 2], 
             Rational[9, 10]], 
            SphereBox[{6, 5, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[1, 2], 1], 
            SphereBox[{6, 5, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 5], 
             Rational[1, 10]], 
            SphereBox[{6, 6, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 5], 
             Rational[1, 5]], 
            SphereBox[{6, 6, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 5], 
             Rational[3, 10]], 
            SphereBox[{6, 6, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 5], 
             Rational[2, 5]], 
            SphereBox[{6, 6, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 5], 
             Rational[1, 2]], 
            SphereBox[{6, 6, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 5], 
             Rational[3, 5]], 
            SphereBox[{6, 6, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 5], 
             Rational[7, 10]], 
            SphereBox[{6, 6, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 5], 
             Rational[4, 5]], 
            SphereBox[{6, 6, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 5], 
             Rational[9, 10]], 
            SphereBox[{6, 6, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[3, 5], 1], 
            SphereBox[{6, 6, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 5], 
             Rational[7, 10], 
             Rational[1, 10]], 
            SphereBox[{6, 7, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[7, 10], 
             Rational[1, 5]], 
            SphereBox[{6, 7, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[7, 10], 
             Rational[3, 10]], 
            SphereBox[{6, 7, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[7, 10], 
             Rational[2, 5]], 
            SphereBox[{6, 7, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[7, 10], 
             Rational[1, 2]], 
            SphereBox[{6, 7, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[7, 10], 
             Rational[3, 5]], 
            SphereBox[{6, 7, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[7, 10], 
             Rational[7, 10]], 
            SphereBox[{6, 7, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[7, 10], 
             Rational[4, 5]], 
            SphereBox[{6, 7, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[7, 10], 
             Rational[9, 10]], 
            SphereBox[{6, 7, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[7, 10], 1], 
            SphereBox[{6, 7, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 5], 
             Rational[4, 5], 
             Rational[1, 10]], 
            SphereBox[{6, 8, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[4, 5], 
             Rational[1, 5]], 
            SphereBox[{6, 8, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[4, 5], 
             Rational[3, 10]], 
            SphereBox[{6, 8, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[4, 5], 
             Rational[2, 5]], 
            SphereBox[{6, 8, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[4, 5], 
             Rational[1, 2]], 
            SphereBox[{6, 8, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[4, 5], 
             Rational[3, 5]], 
            SphereBox[{6, 8, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[4, 5], 
             Rational[7, 10]], 
            SphereBox[{6, 8, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[4, 5], 
             Rational[4, 5]], 
            SphereBox[{6, 8, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[4, 5], 
             Rational[9, 10]], 
            SphereBox[{6, 8, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[4, 5], 1], 
            SphereBox[{6, 8, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 5], 
             Rational[9, 10], 
             Rational[1, 10]], 
            SphereBox[{6, 9, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[9, 10], 
             Rational[1, 5]], 
            SphereBox[{6, 9, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[9, 10], 
             Rational[3, 10]], 
            SphereBox[{6, 9, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[9, 10], 
             Rational[2, 5]], 
            SphereBox[{6, 9, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[9, 10], 
             Rational[1, 2]], 
            SphereBox[{6, 9, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[9, 10], 
             Rational[3, 5]], 
            SphereBox[{6, 9, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[9, 10], 
             Rational[7, 10]], 
            SphereBox[{6, 9, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[9, 10], 
             Rational[4, 5]], 
            SphereBox[{6, 9, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[9, 10], 
             Rational[9, 10]], 
            SphereBox[{6, 9, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 
             Rational[9, 10], 1], 
            SphereBox[{6, 9, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[3, 5], 1, 
             Rational[1, 10]], 
            SphereBox[{6, 10, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 1, 
             Rational[1, 5]], 
            SphereBox[{6, 10, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 1, 
             Rational[3, 10]], 
            SphereBox[{6, 10, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 1, 
             Rational[2, 5]], 
            SphereBox[{6, 10, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 1, 
             Rational[1, 2]], 
            SphereBox[{6, 10, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 1, 
             Rational[3, 5]], 
            SphereBox[{6, 10, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 1, 
             Rational[7, 10]], 
            SphereBox[{6, 10, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 1, 
             Rational[4, 5]], 
            SphereBox[{6, 10, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 1, 
             Rational[9, 10]], 
            SphereBox[{6, 10, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[3, 5], 1, 1], 
            SphereBox[{6, 10, 10}, NCache[Rational[1, 2], 0.5]]}}}, {{
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 10], 
             Rational[1, 10]], 
            SphereBox[{7, 1, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 10], 
             Rational[1, 5]], 
            SphereBox[{7, 1, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 10], 
             Rational[3, 10]], 
            SphereBox[{7, 1, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 10], 
             Rational[2, 5]], 
            SphereBox[{7, 1, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 10], 
             Rational[1, 2]], 
            SphereBox[{7, 1, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 10], 
             Rational[3, 5]], 
            SphereBox[{7, 1, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 10], 
             Rational[7, 10]], 
            SphereBox[{7, 1, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 10], 
             Rational[4, 5]], 
            SphereBox[{7, 1, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 10], 
             Rational[9, 10]], 
            SphereBox[{7, 1, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 10], 1], 
            SphereBox[{7, 1, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 5], 
             Rational[1, 10]], 
            SphereBox[{7, 2, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 5], 
             Rational[1, 5]], 
            SphereBox[{7, 2, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 5], 
             Rational[3, 10]], 
            SphereBox[{7, 2, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 5], 
             Rational[2, 5]], 
            SphereBox[{7, 2, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 5], 
             Rational[1, 2]], 
            SphereBox[{7, 2, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 5], 
             Rational[3, 5]], 
            SphereBox[{7, 2, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 5], 
             Rational[7, 10]], 
            SphereBox[{7, 2, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 5], 
             Rational[4, 5]], 
            SphereBox[{7, 2, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 5], 
             Rational[9, 10]], 
            SphereBox[{7, 2, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 5], 1], 
            SphereBox[{7, 2, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 10], 
             Rational[1, 10]], 
            SphereBox[{7, 3, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 10], 
             Rational[1, 5]], 
            SphereBox[{7, 3, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 10], 
             Rational[3, 10]], 
            SphereBox[{7, 3, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 10], 
             Rational[2, 5]], 
            SphereBox[{7, 3, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 10], 
             Rational[1, 2]], 
            SphereBox[{7, 3, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 10], 
             Rational[3, 5]], 
            SphereBox[{7, 3, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 10], 
             Rational[7, 10]], 
            SphereBox[{7, 3, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 10], 
             Rational[4, 5]], 
            SphereBox[{7, 3, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 10], 
             Rational[9, 10]], 
            SphereBox[{7, 3, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 10], 1], 
            SphereBox[{7, 3, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[7, 10], 
             Rational[2, 5], 
             Rational[1, 10]], 
            SphereBox[{7, 4, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[2, 5], 
             Rational[1, 5]], 
            SphereBox[{7, 4, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[2, 5], 
             Rational[3, 10]], 
            SphereBox[{7, 4, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[2, 5], 
             Rational[2, 5]], 
            SphereBox[{7, 4, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[2, 5], 
             Rational[1, 2]], 
            SphereBox[{7, 4, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[2, 5], 
             Rational[3, 5]], 
            SphereBox[{7, 4, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[2, 5], 
             Rational[7, 10]], 
            SphereBox[{7, 4, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[2, 5], 
             Rational[4, 5]], 
            SphereBox[{7, 4, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[2, 5], 
             Rational[9, 10]], 
            SphereBox[{7, 4, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[2, 5], 1], 
            SphereBox[{7, 4, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 2], 
             Rational[1, 10]], 
            SphereBox[{7, 5, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 2], 
             Rational[1, 5]], 
            SphereBox[{7, 5, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 2], 
             Rational[3, 10]], 
            SphereBox[{7, 5, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 2], 
             Rational[2, 5]], 
            SphereBox[{7, 5, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 2], 
             Rational[1, 2]], 
            SphereBox[{7, 5, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 2], 
             Rational[3, 5]], 
            SphereBox[{7, 5, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 2], 
             Rational[7, 10]], 
            SphereBox[{7, 5, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 2], 
             Rational[4, 5]], 
            SphereBox[{7, 5, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 2], 
             Rational[9, 10]], 
            SphereBox[{7, 5, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[1, 2], 1], 
            SphereBox[{7, 5, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 5], 
             Rational[1, 10]], 
            SphereBox[{7, 6, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 5], 
             Rational[1, 5]], 
            SphereBox[{7, 6, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 5], 
             Rational[3, 10]], 
            SphereBox[{7, 6, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 5], 
             Rational[2, 5]], 
            SphereBox[{7, 6, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 5], 
             Rational[1, 2]], 
            SphereBox[{7, 6, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 5], 
             Rational[3, 5]], 
            SphereBox[{7, 6, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 5], 
             Rational[7, 10]], 
            SphereBox[{7, 6, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 5], 
             Rational[4, 5]], 
            SphereBox[{7, 6, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 5], 
             Rational[9, 10]], 
            SphereBox[{7, 6, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[3, 5], 1], 
            SphereBox[{7, 6, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[7, 10], 
             Rational[7, 10], 
             Rational[1, 10]], 
            SphereBox[{7, 7, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[7, 10], 
             Rational[1, 5]], 
            SphereBox[{7, 7, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[7, 10], 
             Rational[3, 10]], 
            SphereBox[{7, 7, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[7, 10], 
             Rational[2, 5]], 
            SphereBox[{7, 7, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[7, 10], 
             Rational[1, 2]], 
            SphereBox[{7, 7, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[7, 10], 
             Rational[3, 5]], 
            SphereBox[{7, 7, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[7, 10], 
             Rational[7, 10]], 
            SphereBox[{7, 7, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[7, 10], 
             Rational[4, 5]], 
            SphereBox[{7, 7, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[7, 10], 
             Rational[9, 10]], 
            SphereBox[{7, 7, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[7, 10], 1], 
            SphereBox[{7, 7, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[7, 10], 
             Rational[4, 5], 
             Rational[1, 10]], 
            SphereBox[{7, 8, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[4, 5], 
             Rational[1, 5]], 
            SphereBox[{7, 8, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[4, 5], 
             Rational[3, 10]], 
            SphereBox[{7, 8, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[4, 5], 
             Rational[2, 5]], 
            SphereBox[{7, 8, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[4, 5], 
             Rational[1, 2]], 
            SphereBox[{7, 8, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[4, 5], 
             Rational[3, 5]], 
            SphereBox[{7, 8, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[4, 5], 
             Rational[7, 10]], 
            SphereBox[{7, 8, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[4, 5], 
             Rational[4, 5]], 
            SphereBox[{7, 8, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[4, 5], 
             Rational[9, 10]], 
            SphereBox[{7, 8, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[4, 5], 1], 
            SphereBox[{7, 8, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[7, 10], 
             Rational[9, 10], 
             Rational[1, 10]], 
            SphereBox[{7, 9, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[9, 10], 
             Rational[1, 5]], 
            SphereBox[{7, 9, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[9, 10], 
             Rational[3, 10]], 
            SphereBox[{7, 9, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[9, 10], 
             Rational[2, 5]], 
            SphereBox[{7, 9, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[9, 10], 
             Rational[1, 2]], 
            SphereBox[{7, 9, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[9, 10], 
             Rational[3, 5]], 
            SphereBox[{7, 9, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[9, 10], 
             Rational[7, 10]], 
            SphereBox[{7, 9, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[9, 10], 
             Rational[4, 5]], 
            SphereBox[{7, 9, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[9, 10], 
             Rational[9, 10]], 
            SphereBox[{7, 9, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 
             Rational[9, 10], 1], 
            SphereBox[{7, 9, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[7, 10], 1, 
             Rational[1, 10]], 
            SphereBox[{7, 10, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 1, 
             Rational[1, 5]], 
            SphereBox[{7, 10, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 1, 
             Rational[3, 10]], 
            SphereBox[{7, 10, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 1, 
             Rational[2, 5]], 
            SphereBox[{7, 10, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 1, 
             Rational[1, 2]], 
            SphereBox[{7, 10, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 1, 
             Rational[3, 5]], 
            SphereBox[{7, 10, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 1, 
             Rational[7, 10]], 
            SphereBox[{7, 10, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 1, 
             Rational[4, 5]], 
            SphereBox[{7, 10, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 1, 
             Rational[9, 10]], 
            SphereBox[{7, 10, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[7, 10], 1, 1], 
            SphereBox[{7, 10, 10}, NCache[Rational[1, 2], 0.5]]}}}, {{
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 10], 
             Rational[1, 10]], 
            SphereBox[{8, 1, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 10], 
             Rational[1, 5]], 
            SphereBox[{8, 1, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 10], 
             Rational[3, 10]], 
            SphereBox[{8, 1, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 10], 
             Rational[2, 5]], 
            SphereBox[{8, 1, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 10], 
             Rational[1, 2]], 
            SphereBox[{8, 1, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 10], 
             Rational[3, 5]], 
            SphereBox[{8, 1, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 10], 
             Rational[7, 10]], 
            SphereBox[{8, 1, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 10], 
             Rational[4, 5]], 
            SphereBox[{8, 1, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 10], 
             Rational[9, 10]], 
            SphereBox[{8, 1, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 10], 1], 
            SphereBox[{8, 1, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 5], 
             Rational[1, 10]], 
            SphereBox[{8, 2, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 5], 
             Rational[1, 5]], 
            SphereBox[{8, 2, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 5], 
             Rational[3, 10]], 
            SphereBox[{8, 2, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 5], 
             Rational[2, 5]], 
            SphereBox[{8, 2, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 5], 
             Rational[1, 2]], 
            SphereBox[{8, 2, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 5], 
             Rational[3, 5]], 
            SphereBox[{8, 2, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 5], 
             Rational[7, 10]], 
            SphereBox[{8, 2, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 5], 
             Rational[4, 5]], 
            SphereBox[{8, 2, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 5], 
             Rational[9, 10]], 
            SphereBox[{8, 2, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 5], 1], 
            SphereBox[{8, 2, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 10], 
             Rational[1, 10]], 
            SphereBox[{8, 3, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 10], 
             Rational[1, 5]], 
            SphereBox[{8, 3, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 10], 
             Rational[3, 10]], 
            SphereBox[{8, 3, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 10], 
             Rational[2, 5]], 
            SphereBox[{8, 3, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 10], 
             Rational[1, 2]], 
            SphereBox[{8, 3, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 10], 
             Rational[3, 5]], 
            SphereBox[{8, 3, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 10], 
             Rational[7, 10]], 
            SphereBox[{8, 3, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 10], 
             Rational[4, 5]], 
            SphereBox[{8, 3, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 10], 
             Rational[9, 10]], 
            SphereBox[{8, 3, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 10], 1], 
            SphereBox[{8, 3, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[4, 5], 
             Rational[2, 5], 
             Rational[1, 10]], 
            SphereBox[{8, 4, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[2, 5], 
             Rational[1, 5]], 
            SphereBox[{8, 4, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[2, 5], 
             Rational[3, 10]], 
            SphereBox[{8, 4, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[2, 5], 
             Rational[2, 5]], 
            SphereBox[{8, 4, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[2, 5], 
             Rational[1, 2]], 
            SphereBox[{8, 4, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[2, 5], 
             Rational[3, 5]], 
            SphereBox[{8, 4, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[2, 5], 
             Rational[7, 10]], 
            SphereBox[{8, 4, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[2, 5], 
             Rational[4, 5]], 
            SphereBox[{8, 4, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[2, 5], 
             Rational[9, 10]], 
            SphereBox[{8, 4, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[2, 5], 1], 
            SphereBox[{8, 4, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 2], 
             Rational[1, 10]], 
            SphereBox[{8, 5, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 2], 
             Rational[1, 5]], 
            SphereBox[{8, 5, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 2], 
             Rational[3, 10]], 
            SphereBox[{8, 5, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 2], 
             Rational[2, 5]], 
            SphereBox[{8, 5, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 2], 
             Rational[1, 2]], 
            SphereBox[{8, 5, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 2], 
             Rational[3, 5]], 
            SphereBox[{8, 5, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 2], 
             Rational[7, 10]], 
            SphereBox[{8, 5, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 2], 
             Rational[4, 5]], 
            SphereBox[{8, 5, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 2], 
             Rational[9, 10]], 
            SphereBox[{8, 5, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[1, 2], 1], 
            SphereBox[{8, 5, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 5], 
             Rational[1, 10]], 
            SphereBox[{8, 6, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 5], 
             Rational[1, 5]], 
            SphereBox[{8, 6, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 5], 
             Rational[3, 10]], 
            SphereBox[{8, 6, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 5], 
             Rational[2, 5]], 
            SphereBox[{8, 6, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 5], 
             Rational[1, 2]], 
            SphereBox[{8, 6, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 5], 
             Rational[3, 5]], 
            SphereBox[{8, 6, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 5], 
             Rational[7, 10]], 
            SphereBox[{8, 6, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 5], 
             Rational[4, 5]], 
            SphereBox[{8, 6, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 5], 
             Rational[9, 10]], 
            SphereBox[{8, 6, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[3, 5], 1], 
            SphereBox[{8, 6, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[4, 5], 
             Rational[7, 10], 
             Rational[1, 10]], 
            SphereBox[{8, 7, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[7, 10], 
             Rational[1, 5]], 
            SphereBox[{8, 7, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[7, 10], 
             Rational[3, 10]], 
            SphereBox[{8, 7, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[7, 10], 
             Rational[2, 5]], 
            SphereBox[{8, 7, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[7, 10], 
             Rational[1, 2]], 
            SphereBox[{8, 7, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[7, 10], 
             Rational[3, 5]], 
            SphereBox[{8, 7, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[7, 10], 
             Rational[7, 10]], 
            SphereBox[{8, 7, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[7, 10], 
             Rational[4, 5]], 
            SphereBox[{8, 7, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[7, 10], 
             Rational[9, 10]], 
            SphereBox[{8, 7, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[7, 10], 1], 
            SphereBox[{8, 7, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[4, 5], 
             Rational[4, 5], 
             Rational[1, 10]], 
            SphereBox[{8, 8, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[4, 5], 
             Rational[1, 5]], 
            SphereBox[{8, 8, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[4, 5], 
             Rational[3, 10]], 
            SphereBox[{8, 8, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[4, 5], 
             Rational[2, 5]], 
            SphereBox[{8, 8, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[4, 5], 
             Rational[1, 2]], 
            SphereBox[{8, 8, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[4, 5], 
             Rational[3, 5]], 
            SphereBox[{8, 8, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[4, 5], 
             Rational[7, 10]], 
            SphereBox[{8, 8, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[4, 5], 
             Rational[4, 5]], 
            SphereBox[{8, 8, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[4, 5], 
             Rational[9, 10]], 
            SphereBox[{8, 8, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[4, 5], 1], 
            SphereBox[{8, 8, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[4, 5], 
             Rational[9, 10], 
             Rational[1, 10]], 
            SphereBox[{8, 9, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[9, 10], 
             Rational[1, 5]], 
            SphereBox[{8, 9, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[9, 10], 
             Rational[3, 10]], 
            SphereBox[{8, 9, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[9, 10], 
             Rational[2, 5]], 
            SphereBox[{8, 9, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[9, 10], 
             Rational[1, 2]], 
            SphereBox[{8, 9, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[9, 10], 
             Rational[3, 5]], 
            SphereBox[{8, 9, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[9, 10], 
             Rational[7, 10]], 
            SphereBox[{8, 9, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[9, 10], 
             Rational[4, 5]], 
            SphereBox[{8, 9, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[9, 10], 
             Rational[9, 10]], 
            SphereBox[{8, 9, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 
             Rational[9, 10], 1], 
            SphereBox[{8, 9, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[4, 5], 1, 
             Rational[1, 10]], 
            SphereBox[{8, 10, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 1, 
             Rational[1, 5]], 
            SphereBox[{8, 10, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 1, 
             Rational[3, 10]], 
            SphereBox[{8, 10, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 1, 
             Rational[2, 5]], 
            SphereBox[{8, 10, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 1, 
             Rational[1, 2]], 
            SphereBox[{8, 10, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 1, 
             Rational[3, 5]], 
            SphereBox[{8, 10, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 1, 
             Rational[7, 10]], 
            SphereBox[{8, 10, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 1, 
             Rational[4, 5]], 
            SphereBox[{8, 10, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 1, 
             Rational[9, 10]], 
            SphereBox[{8, 10, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[4, 5], 1, 1], 
            SphereBox[{8, 10, 10}, NCache[Rational[1, 2], 0.5]]}}}, {{
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 10], 
             Rational[1, 10]], 
            SphereBox[{9, 1, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 10], 
             Rational[1, 5]], 
            SphereBox[{9, 1, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 10], 
             Rational[3, 10]], 
            SphereBox[{9, 1, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 10], 
             Rational[2, 5]], 
            SphereBox[{9, 1, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 10], 
             Rational[1, 2]], 
            SphereBox[{9, 1, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 10], 
             Rational[3, 5]], 
            SphereBox[{9, 1, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 10], 
             Rational[7, 10]], 
            SphereBox[{9, 1, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 10], 
             Rational[4, 5]], 
            SphereBox[{9, 1, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 10], 
             Rational[9, 10]], 
            SphereBox[{9, 1, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 10], 1], 
            SphereBox[{9, 1, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 5], 
             Rational[1, 10]], 
            SphereBox[{9, 2, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 5], 
             Rational[1, 5]], 
            SphereBox[{9, 2, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 5], 
             Rational[3, 10]], 
            SphereBox[{9, 2, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 5], 
             Rational[2, 5]], 
            SphereBox[{9, 2, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 5], 
             Rational[1, 2]], 
            SphereBox[{9, 2, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 5], 
             Rational[3, 5]], 
            SphereBox[{9, 2, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 5], 
             Rational[7, 10]], 
            SphereBox[{9, 2, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 5], 
             Rational[4, 5]], 
            SphereBox[{9, 2, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 5], 
             Rational[9, 10]], 
            SphereBox[{9, 2, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 5], 1], 
            SphereBox[{9, 2, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 10], 
             Rational[1, 10]], 
            SphereBox[{9, 3, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 10], 
             Rational[1, 5]], 
            SphereBox[{9, 3, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 10], 
             Rational[3, 10]], 
            SphereBox[{9, 3, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 10], 
             Rational[2, 5]], 
            SphereBox[{9, 3, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 10], 
             Rational[1, 2]], 
            SphereBox[{9, 3, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 10], 
             Rational[3, 5]], 
            SphereBox[{9, 3, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 10], 
             Rational[7, 10]], 
            SphereBox[{9, 3, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 10], 
             Rational[4, 5]], 
            SphereBox[{9, 3, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 10], 
             Rational[9, 10]], 
            SphereBox[{9, 3, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 10], 1], 
            SphereBox[{9, 3, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[9, 10], 
             Rational[2, 5], 
             Rational[1, 10]], 
            SphereBox[{9, 4, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[2, 5], 
             Rational[1, 5]], 
            SphereBox[{9, 4, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[2, 5], 
             Rational[3, 10]], 
            SphereBox[{9, 4, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[2, 5], 
             Rational[2, 5]], 
            SphereBox[{9, 4, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[2, 5], 
             Rational[1, 2]], 
            SphereBox[{9, 4, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[2, 5], 
             Rational[3, 5]], 
            SphereBox[{9, 4, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[2, 5], 
             Rational[7, 10]], 
            SphereBox[{9, 4, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[2, 5], 
             Rational[4, 5]], 
            SphereBox[{9, 4, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[2, 5], 
             Rational[9, 10]], 
            SphereBox[{9, 4, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[2, 5], 1], 
            SphereBox[{9, 4, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 2], 
             Rational[1, 10]], 
            SphereBox[{9, 5, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 2], 
             Rational[1, 5]], 
            SphereBox[{9, 5, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 2], 
             Rational[3, 10]], 
            SphereBox[{9, 5, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 2], 
             Rational[2, 5]], 
            SphereBox[{9, 5, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 2], 
             Rational[1, 2]], 
            SphereBox[{9, 5, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 2], 
             Rational[3, 5]], 
            SphereBox[{9, 5, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 2], 
             Rational[7, 10]], 
            SphereBox[{9, 5, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 2], 
             Rational[4, 5]], 
            SphereBox[{9, 5, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 2], 
             Rational[9, 10]], 
            SphereBox[{9, 5, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[1, 2], 1], 
            SphereBox[{9, 5, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 5], 
             Rational[1, 10]], 
            SphereBox[{9, 6, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 5], 
             Rational[1, 5]], 
            SphereBox[{9, 6, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 5], 
             Rational[3, 10]], 
            SphereBox[{9, 6, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 5], 
             Rational[2, 5]], 
            SphereBox[{9, 6, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 5], 
             Rational[1, 2]], 
            SphereBox[{9, 6, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 5], 
             Rational[3, 5]], 
            SphereBox[{9, 6, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 5], 
             Rational[7, 10]], 
            SphereBox[{9, 6, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 5], 
             Rational[4, 5]], 
            SphereBox[{9, 6, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 5], 
             Rational[9, 10]], 
            SphereBox[{9, 6, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[3, 5], 1], 
            SphereBox[{9, 6, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[9, 10], 
             Rational[7, 10], 
             Rational[1, 10]], 
            SphereBox[{9, 7, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[7, 10], 
             Rational[1, 5]], 
            SphereBox[{9, 7, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[7, 10], 
             Rational[3, 10]], 
            SphereBox[{9, 7, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[7, 10], 
             Rational[2, 5]], 
            SphereBox[{9, 7, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[7, 10], 
             Rational[1, 2]], 
            SphereBox[{9, 7, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[7, 10], 
             Rational[3, 5]], 
            SphereBox[{9, 7, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[7, 10], 
             Rational[7, 10]], 
            SphereBox[{9, 7, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[7, 10], 
             Rational[4, 5]], 
            SphereBox[{9, 7, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[7, 10], 
             Rational[9, 10]], 
            SphereBox[{9, 7, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[7, 10], 1], 
            SphereBox[{9, 7, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[9, 10], 
             Rational[4, 5], 
             Rational[1, 10]], 
            SphereBox[{9, 8, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[4, 5], 
             Rational[1, 5]], 
            SphereBox[{9, 8, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[4, 5], 
             Rational[3, 10]], 
            SphereBox[{9, 8, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[4, 5], 
             Rational[2, 5]], 
            SphereBox[{9, 8, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[4, 5], 
             Rational[1, 2]], 
            SphereBox[{9, 8, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[4, 5], 
             Rational[3, 5]], 
            SphereBox[{9, 8, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[4, 5], 
             Rational[7, 10]], 
            SphereBox[{9, 8, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[4, 5], 
             Rational[4, 5]], 
            SphereBox[{9, 8, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[4, 5], 
             Rational[9, 10]], 
            SphereBox[{9, 8, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[4, 5], 1], 
            SphereBox[{9, 8, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[9, 10], 
             Rational[9, 10], 
             Rational[1, 10]], 
            SphereBox[{9, 9, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[9, 10], 
             Rational[1, 5]], 
            SphereBox[{9, 9, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[9, 10], 
             Rational[3, 10]], 
            SphereBox[{9, 9, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[9, 10], 
             Rational[2, 5]], 
            SphereBox[{9, 9, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[9, 10], 
             Rational[1, 2]], 
            SphereBox[{9, 9, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[9, 10], 
             Rational[3, 5]], 
            SphereBox[{9, 9, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[9, 10], 
             Rational[7, 10]], 
            SphereBox[{9, 9, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[9, 10], 
             Rational[4, 5]], 
            SphereBox[{9, 9, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[9, 10], 
             Rational[9, 10]], 
            SphereBox[{9, 9, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 
             Rational[9, 10], 1], 
            SphereBox[{9, 9, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[
             Rational[9, 10], 1, 
             Rational[1, 10]], 
            SphereBox[{9, 10, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 1, 
             Rational[1, 5]], 
            SphereBox[{9, 10, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 1, 
             Rational[3, 10]], 
            SphereBox[{9, 10, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 1, 
             Rational[2, 5]], 
            SphereBox[{9, 10, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 1, 
             Rational[1, 2]], 
            SphereBox[{9, 10, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 1, 
             Rational[3, 5]], 
            SphereBox[{9, 10, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 1, 
             Rational[7, 10]], 
            SphereBox[{9, 10, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 1, 
             Rational[4, 5]], 
            SphereBox[{9, 10, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 1, 
             Rational[9, 10]], 
            SphereBox[{9, 10, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[
             Rational[9, 10], 1, 1], 
            SphereBox[{9, 10, 10}, NCache[Rational[1, 2], 0.5]]}}}, {{
           {RGBColor[1, 
             Rational[1, 10], 
             Rational[1, 10]], 
            SphereBox[{10, 1, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 10], 
             Rational[1, 5]], 
            SphereBox[{10, 1, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 10], 
             Rational[3, 10]], 
            SphereBox[{10, 1, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 10], 
             Rational[2, 5]], 
            SphereBox[{10, 1, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 10], 
             Rational[1, 2]], 
            SphereBox[{10, 1, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 10], 
             Rational[3, 5]], 
            SphereBox[{10, 1, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 10], 
             Rational[7, 10]], 
            SphereBox[{10, 1, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 10], 
             Rational[4, 5]], 
            SphereBox[{10, 1, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 10], 
             Rational[9, 10]], 
            SphereBox[{10, 1, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 10], 1], 
            SphereBox[{10, 1, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[1, 
             Rational[1, 5], 
             Rational[1, 10]], 
            SphereBox[{10, 2, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 5], 
             Rational[1, 5]], 
            SphereBox[{10, 2, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 5], 
             Rational[3, 10]], 
            SphereBox[{10, 2, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 5], 
             Rational[2, 5]], 
            SphereBox[{10, 2, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 5], 
             Rational[1, 2]], 
            SphereBox[{10, 2, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 5], 
             Rational[3, 5]], 
            SphereBox[{10, 2, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 5], 
             Rational[7, 10]], 
            SphereBox[{10, 2, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 5], 
             Rational[4, 5]], 
            SphereBox[{10, 2, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 5], 
             Rational[9, 10]], 
            SphereBox[{10, 2, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 5], 1], 
            SphereBox[{10, 2, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[1, 
             Rational[3, 10], 
             Rational[1, 10]], 
            SphereBox[{10, 3, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 10], 
             Rational[1, 5]], 
            SphereBox[{10, 3, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 10], 
             Rational[3, 10]], 
            SphereBox[{10, 3, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 10], 
             Rational[2, 5]], 
            SphereBox[{10, 3, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 10], 
             Rational[1, 2]], 
            SphereBox[{10, 3, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 10], 
             Rational[3, 5]], 
            SphereBox[{10, 3, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 10], 
             Rational[7, 10]], 
            SphereBox[{10, 3, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 10], 
             Rational[4, 5]], 
            SphereBox[{10, 3, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 10], 
             Rational[9, 10]], 
            SphereBox[{10, 3, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 10], 1], 
            SphereBox[{10, 3, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[1, 
             Rational[2, 5], 
             Rational[1, 10]], 
            SphereBox[{10, 4, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[2, 5], 
             Rational[1, 5]], 
            SphereBox[{10, 4, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[2, 5], 
             Rational[3, 10]], 
            SphereBox[{10, 4, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[2, 5], 
             Rational[2, 5]], 
            SphereBox[{10, 4, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[2, 5], 
             Rational[1, 2]], 
            SphereBox[{10, 4, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[2, 5], 
             Rational[3, 5]], 
            SphereBox[{10, 4, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[2, 5], 
             Rational[7, 10]], 
            SphereBox[{10, 4, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[2, 5], 
             Rational[4, 5]], 
            SphereBox[{10, 4, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[2, 5], 
             Rational[9, 10]], 
            SphereBox[{10, 4, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[2, 5], 1], 
            SphereBox[{10, 4, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[1, 
             Rational[1, 2], 
             Rational[1, 10]], 
            SphereBox[{10, 5, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 2], 
             Rational[1, 5]], 
            SphereBox[{10, 5, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 2], 
             Rational[3, 10]], 
            SphereBox[{10, 5, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 2], 
             Rational[2, 5]], 
            SphereBox[{10, 5, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 2], 
             Rational[1, 2]], 
            SphereBox[{10, 5, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 2], 
             Rational[3, 5]], 
            SphereBox[{10, 5, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 2], 
             Rational[7, 10]], 
            SphereBox[{10, 5, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 2], 
             Rational[4, 5]], 
            SphereBox[{10, 5, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 2], 
             Rational[9, 10]], 
            SphereBox[{10, 5, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[1, 2], 1], 
            SphereBox[{10, 5, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[1, 
             Rational[3, 5], 
             Rational[1, 10]], 
            SphereBox[{10, 6, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 5], 
             Rational[1, 5]], 
            SphereBox[{10, 6, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 5], 
             Rational[3, 10]], 
            SphereBox[{10, 6, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 5], 
             Rational[2, 5]], 
            SphereBox[{10, 6, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 5], 
             Rational[1, 2]], 
            SphereBox[{10, 6, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 5], 
             Rational[3, 5]], 
            SphereBox[{10, 6, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 5], 
             Rational[7, 10]], 
            SphereBox[{10, 6, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 5], 
             Rational[4, 5]], 
            SphereBox[{10, 6, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 5], 
             Rational[9, 10]], 
            SphereBox[{10, 6, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[3, 5], 1], 
            SphereBox[{10, 6, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[1, 
             Rational[7, 10], 
             Rational[1, 10]], 
            SphereBox[{10, 7, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[7, 10], 
             Rational[1, 5]], 
            SphereBox[{10, 7, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[7, 10], 
             Rational[3, 10]], 
            SphereBox[{10, 7, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[7, 10], 
             Rational[2, 5]], 
            SphereBox[{10, 7, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[7, 10], 
             Rational[1, 2]], 
            SphereBox[{10, 7, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[7, 10], 
             Rational[3, 5]], 
            SphereBox[{10, 7, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[7, 10], 
             Rational[7, 10]], 
            SphereBox[{10, 7, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[7, 10], 
             Rational[4, 5]], 
            SphereBox[{10, 7, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[7, 10], 
             Rational[9, 10]], 
            SphereBox[{10, 7, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[7, 10], 1], 
            SphereBox[{10, 7, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[1, 
             Rational[4, 5], 
             Rational[1, 10]], 
            SphereBox[{10, 8, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[4, 5], 
             Rational[1, 5]], 
            SphereBox[{10, 8, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[4, 5], 
             Rational[3, 10]], 
            SphereBox[{10, 8, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[4, 5], 
             Rational[2, 5]], 
            SphereBox[{10, 8, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[4, 5], 
             Rational[1, 2]], 
            SphereBox[{10, 8, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[4, 5], 
             Rational[3, 5]], 
            SphereBox[{10, 8, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[4, 5], 
             Rational[7, 10]], 
            SphereBox[{10, 8, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[4, 5], 
             Rational[4, 5]], 
            SphereBox[{10, 8, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[4, 5], 
             Rational[9, 10]], 
            SphereBox[{10, 8, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[4, 5], 1], 
            SphereBox[{10, 8, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[1, 
             Rational[9, 10], 
             Rational[1, 10]], 
            SphereBox[{10, 9, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[9, 10], 
             Rational[1, 5]], 
            SphereBox[{10, 9, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[9, 10], 
             Rational[3, 10]], 
            SphereBox[{10, 9, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[9, 10], 
             Rational[2, 5]], 
            SphereBox[{10, 9, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[9, 10], 
             Rational[1, 2]], 
            SphereBox[{10, 9, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[9, 10], 
             Rational[3, 5]], 
            SphereBox[{10, 9, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[9, 10], 
             Rational[7, 10]], 
            SphereBox[{10, 9, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[9, 10], 
             Rational[4, 5]], 
            SphereBox[{10, 9, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[9, 10], 
             Rational[9, 10]], 
            SphereBox[{10, 9, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 
             Rational[9, 10], 1], 
            SphereBox[{10, 9, 10}, NCache[Rational[1, 2], 0.5]]}}, {
           {RGBColor[1, 1, 
             Rational[1, 10]], 
            SphereBox[{10, 10, 1}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 1, 
             Rational[1, 5]], 
            SphereBox[{10, 10, 2}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 1, 
             Rational[3, 10]], 
            SphereBox[{10, 10, 3}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 1, 
             Rational[2, 5]], 
            SphereBox[{10, 10, 4}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 1, 
             Rational[1, 2]], 
            SphereBox[{10, 10, 5}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 1, 
             Rational[3, 5]], 
            SphereBox[{10, 10, 6}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 1, 
             Rational[7, 10]], 
            SphereBox[{10, 10, 7}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 1, 
             Rational[4, 5]], 
            SphereBox[{10, 10, 8}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 1, 
             Rational[9, 10]], 
            SphereBox[{10, 10, 9}, NCache[Rational[1, 2], 0.5]]}, 
           {RGBColor[1, 1, 1], 
            SphereBox[{10, 10, 10}, NCache[Rational[1, 2], 0.5]]}}}},
        ImageSize->{284.87890625, Automatic},
        ViewPoint->{1.3, -2.4, 2.},
        ViewVertical->{0., 0., 1.}]], "ExerciseOutput",ExpressionUUID->
       "4b19f212-25a2-4ec4-98f7-caa6adc78d3b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         Graphics3DBox[{{{{{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 10], 
                Rational[1, 10]], 
               SphereBox[{1, 1, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 10], 
                Rational[1, 5]], 
               SphereBox[{1, 1, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 10], 
                Rational[3, 10]], 
               SphereBox[{1, 1, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 10], 
                Rational[2, 5]], 
               SphereBox[{1, 1, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 10], 
                Rational[1, 2]], 
               SphereBox[{1, 1, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 10], 
                Rational[3, 5]], 
               SphereBox[{1, 1, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 10], 
                Rational[7, 10]], 
               SphereBox[{1, 1, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 10], 
                Rational[4, 5]], 
               SphereBox[{1, 1, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 10], 
                Rational[9, 10]], 
               SphereBox[{1, 1, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 10], 1], 
               SphereBox[{1, 1, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 5], 
                Rational[1, 10]], 
               SphereBox[{1, 2, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 5], 
                Rational[1, 5]], 
               SphereBox[{1, 2, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 5], 
                Rational[3, 10]], 
               SphereBox[{1, 2, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 5], 
                Rational[2, 5]], 
               SphereBox[{1, 2, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 5], 
                Rational[1, 2]], 
               SphereBox[{1, 2, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 5], 
                Rational[3, 5]], 
               SphereBox[{1, 2, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 5], 
                Rational[7, 10]], 
               SphereBox[{1, 2, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 5], 
                Rational[4, 5]], 
               SphereBox[{1, 2, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 5], 
                Rational[9, 10]], 
               SphereBox[{1, 2, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 5], 1], 
               SphereBox[{1, 2, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 10], 
                Rational[1, 10]], 
               SphereBox[{1, 3, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 10], 
                Rational[1, 5]], 
               SphereBox[{1, 3, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 10], 
                Rational[3, 10]], 
               SphereBox[{1, 3, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 10], 
                Rational[2, 5]], 
               SphereBox[{1, 3, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 10], 
                Rational[1, 2]], 
               SphereBox[{1, 3, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 10], 
                Rational[3, 5]], 
               SphereBox[{1, 3, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 10], 
                Rational[7, 10]], 
               SphereBox[{1, 3, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 10], 
                Rational[4, 5]], 
               SphereBox[{1, 3, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 10], 
                Rational[9, 10]], 
               SphereBox[{1, 3, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 10], 1], 
               SphereBox[{1, 3, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 10], 
                Rational[2, 5], 
                Rational[1, 10]], 
               SphereBox[{1, 4, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[2, 5], 
                Rational[1, 5]], 
               SphereBox[{1, 4, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[2, 5], 
                Rational[3, 10]], 
               SphereBox[{1, 4, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[2, 5], 
                Rational[2, 5]], 
               SphereBox[{1, 4, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[2, 5], 
                Rational[1, 2]], 
               SphereBox[{1, 4, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[2, 5], 
                Rational[3, 5]], 
               SphereBox[{1, 4, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[2, 5], 
                Rational[7, 10]], 
               SphereBox[{1, 4, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[2, 5], 
                Rational[4, 5]], 
               SphereBox[{1, 4, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[2, 5], 
                Rational[9, 10]], 
               SphereBox[{1, 4, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[2, 5], 1], 
               SphereBox[{1, 4, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 2], 
                Rational[1, 10]], 
               SphereBox[{1, 5, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 2], 
                Rational[1, 5]], 
               SphereBox[{1, 5, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 2], 
                Rational[3, 10]], 
               SphereBox[{1, 5, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 2], 
                Rational[2, 5]], 
               SphereBox[{1, 5, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 2], 
                Rational[1, 2]], 
               SphereBox[{1, 5, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 2], 
                Rational[3, 5]], 
               SphereBox[{1, 5, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 2], 
                Rational[7, 10]], 
               SphereBox[{1, 5, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 2], 
                Rational[4, 5]], 
               SphereBox[{1, 5, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 2], 
                Rational[9, 10]], 
               SphereBox[{1, 5, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[1, 2], 1], 
               SphereBox[{1, 5, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 5], 
                Rational[1, 10]], 
               SphereBox[{1, 6, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 5], 
                Rational[1, 5]], 
               SphereBox[{1, 6, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 5], 
                Rational[3, 10]], 
               SphereBox[{1, 6, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 5], 
                Rational[2, 5]], 
               SphereBox[{1, 6, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 5], 
                Rational[1, 2]], 
               SphereBox[{1, 6, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 5], 
                Rational[3, 5]], 
               SphereBox[{1, 6, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 5], 
                Rational[7, 10]], 
               SphereBox[{1, 6, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 5], 
                Rational[4, 5]], 
               SphereBox[{1, 6, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 5], 
                Rational[9, 10]], 
               SphereBox[{1, 6, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[3, 5], 1], 
               SphereBox[{1, 6, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 10], 
                Rational[7, 10], 
                Rational[1, 10]], 
               SphereBox[{1, 7, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[7, 10], 
                Rational[1, 5]], 
               SphereBox[{1, 7, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[7, 10], 
                Rational[3, 10]], 
               SphereBox[{1, 7, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[7, 10], 
                Rational[2, 5]], 
               SphereBox[{1, 7, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[7, 10], 
                Rational[1, 2]], 
               SphereBox[{1, 7, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[7, 10], 
                Rational[3, 5]], 
               SphereBox[{1, 7, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[7, 10], 
                Rational[7, 10]], 
               SphereBox[{1, 7, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[7, 10], 
                Rational[4, 5]], 
               SphereBox[{1, 7, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[7, 10], 
                Rational[9, 10]], 
               SphereBox[{1, 7, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[7, 10], 1], 
               SphereBox[{1, 7, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 10], 
                Rational[4, 5], 
                Rational[1, 10]], 
               SphereBox[{1, 8, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[4, 5], 
                Rational[1, 5]], 
               SphereBox[{1, 8, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[4, 5], 
                Rational[3, 10]], 
               SphereBox[{1, 8, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[4, 5], 
                Rational[2, 5]], 
               SphereBox[{1, 8, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[4, 5], 
                Rational[1, 2]], 
               SphereBox[{1, 8, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[4, 5], 
                Rational[3, 5]], 
               SphereBox[{1, 8, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[4, 5], 
                Rational[7, 10]], 
               SphereBox[{1, 8, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[4, 5], 
                Rational[4, 5]], 
               SphereBox[{1, 8, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[4, 5], 
                Rational[9, 10]], 
               SphereBox[{1, 8, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[4, 5], 1], 
               SphereBox[{1, 8, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 10], 
                Rational[9, 10], 
                Rational[1, 10]], 
               SphereBox[{1, 9, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[9, 10], 
                Rational[1, 5]], 
               SphereBox[{1, 9, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[9, 10], 
                Rational[3, 10]], 
               SphereBox[{1, 9, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[9, 10], 
                Rational[2, 5]], 
               SphereBox[{1, 9, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[9, 10], 
                Rational[1, 2]], 
               SphereBox[{1, 9, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[9, 10], 
                Rational[3, 5]], 
               SphereBox[{1, 9, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[9, 10], 
                Rational[7, 10]], 
               SphereBox[{1, 9, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[9, 10], 
                Rational[4, 5]], 
               SphereBox[{1, 9, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[9, 10], 
                Rational[9, 10]], 
               SphereBox[{1, 9, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 
                Rational[9, 10], 1], 
               SphereBox[{1, 9, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 10], 1, 
                Rational[1, 10]], 
               SphereBox[{1, 10, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 1, 
                Rational[1, 5]], 
               SphereBox[{1, 10, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 1, 
                Rational[3, 10]], 
               SphereBox[{1, 10, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 1, 
                Rational[2, 5]], 
               SphereBox[{1, 10, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 1, 
                Rational[1, 2]], 
               SphereBox[{1, 10, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 1, 
                Rational[3, 5]], 
               SphereBox[{1, 10, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 1, 
                Rational[7, 10]], 
               SphereBox[{1, 10, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 1, 
                Rational[4, 5]], 
               SphereBox[{1, 10, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 1, 
                Rational[9, 10]], 
               SphereBox[{1, 10, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 10], 1, 1], 
               SphereBox[{1, 10, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}}, {{{{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 10], 
                Rational[1, 10]], 
               SphereBox[{2, 1, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 10], 
                Rational[1, 5]], 
               SphereBox[{2, 1, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 10], 
                Rational[3, 10]], 
               SphereBox[{2, 1, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 10], 
                Rational[2, 5]], 
               SphereBox[{2, 1, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 10], 
                Rational[1, 2]], 
               SphereBox[{2, 1, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 10], 
                Rational[3, 5]], 
               SphereBox[{2, 1, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 10], 
                Rational[7, 10]], 
               SphereBox[{2, 1, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 10], 
                Rational[4, 5]], 
               SphereBox[{2, 1, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 10], 
                Rational[9, 10]], 
               SphereBox[{2, 1, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 10], 1], 
               SphereBox[{2, 1, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 5], 
                Rational[1, 10]], 
               SphereBox[{2, 2, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 5], 
                Rational[1, 5]], 
               SphereBox[{2, 2, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 5], 
                Rational[3, 10]], 
               SphereBox[{2, 2, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 5], 
                Rational[2, 5]], 
               SphereBox[{2, 2, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 5], 
                Rational[1, 2]], 
               SphereBox[{2, 2, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 5], 
                Rational[3, 5]], 
               SphereBox[{2, 2, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 5], 
                Rational[7, 10]], 
               SphereBox[{2, 2, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 5], 
                Rational[4, 5]], 
               SphereBox[{2, 2, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 5], 
                Rational[9, 10]], 
               SphereBox[{2, 2, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 5], 1], 
               SphereBox[{2, 2, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 10], 
                Rational[1, 10]], 
               SphereBox[{2, 3, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 10], 
                Rational[1, 5]], 
               SphereBox[{2, 3, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 10], 
                Rational[3, 10]], 
               SphereBox[{2, 3, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 10], 
                Rational[2, 5]], 
               SphereBox[{2, 3, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 10], 
                Rational[1, 2]], 
               SphereBox[{2, 3, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 10], 
                Rational[3, 5]], 
               SphereBox[{2, 3, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 10], 
                Rational[7, 10]], 
               SphereBox[{2, 3, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 10], 
                Rational[4, 5]], 
               SphereBox[{2, 3, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 10], 
                Rational[9, 10]], 
               SphereBox[{2, 3, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 10], 1], 
               SphereBox[{2, 3, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 5], 
                Rational[2, 5], 
                Rational[1, 10]], 
               SphereBox[{2, 4, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[2, 5], 
                Rational[1, 5]], 
               SphereBox[{2, 4, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[2, 5], 
                Rational[3, 10]], 
               SphereBox[{2, 4, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[2, 5], 
                Rational[2, 5]], 
               SphereBox[{2, 4, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[2, 5], 
                Rational[1, 2]], 
               SphereBox[{2, 4, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[2, 5], 
                Rational[3, 5]], 
               SphereBox[{2, 4, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[2, 5], 
                Rational[7, 10]], 
               SphereBox[{2, 4, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[2, 5], 
                Rational[4, 5]], 
               SphereBox[{2, 4, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[2, 5], 
                Rational[9, 10]], 
               SphereBox[{2, 4, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[2, 5], 1], 
               SphereBox[{2, 4, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 2], 
                Rational[1, 10]], 
               SphereBox[{2, 5, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 2], 
                Rational[1, 5]], 
               SphereBox[{2, 5, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 2], 
                Rational[3, 10]], 
               SphereBox[{2, 5, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 2], 
                Rational[2, 5]], 
               SphereBox[{2, 5, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 2], 
                Rational[1, 2]], 
               SphereBox[{2, 5, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 2], 
                Rational[3, 5]], 
               SphereBox[{2, 5, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 2], 
                Rational[7, 10]], 
               SphereBox[{2, 5, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 2], 
                Rational[4, 5]], 
               SphereBox[{2, 5, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 2], 
                Rational[9, 10]], 
               SphereBox[{2, 5, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[1, 2], 1], 
               SphereBox[{2, 5, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 5], 
                Rational[1, 10]], 
               SphereBox[{2, 6, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 5], 
                Rational[1, 5]], 
               SphereBox[{2, 6, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 5], 
                Rational[3, 10]], 
               SphereBox[{2, 6, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 5], 
                Rational[2, 5]], 
               SphereBox[{2, 6, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 5], 
                Rational[1, 2]], 
               SphereBox[{2, 6, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 5], 
                Rational[3, 5]], 
               SphereBox[{2, 6, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 5], 
                Rational[7, 10]], 
               SphereBox[{2, 6, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 5], 
                Rational[4, 5]], 
               SphereBox[{2, 6, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 5], 
                Rational[9, 10]], 
               SphereBox[{2, 6, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[3, 5], 1], 
               SphereBox[{2, 6, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 5], 
                Rational[7, 10], 
                Rational[1, 10]], 
               SphereBox[{2, 7, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[7, 10], 
                Rational[1, 5]], 
               SphereBox[{2, 7, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[7, 10], 
                Rational[3, 10]], 
               SphereBox[{2, 7, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[7, 10], 
                Rational[2, 5]], 
               SphereBox[{2, 7, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[7, 10], 
                Rational[1, 2]], 
               SphereBox[{2, 7, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[7, 10], 
                Rational[3, 5]], 
               SphereBox[{2, 7, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[7, 10], 
                Rational[7, 10]], 
               SphereBox[{2, 7, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[7, 10], 
                Rational[4, 5]], 
               SphereBox[{2, 7, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[7, 10], 
                Rational[9, 10]], 
               SphereBox[{2, 7, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[7, 10], 1], 
               SphereBox[{2, 7, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 5], 
                Rational[4, 5], 
                Rational[1, 10]], 
               SphereBox[{2, 8, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[4, 5], 
                Rational[1, 5]], 
               SphereBox[{2, 8, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[4, 5], 
                Rational[3, 10]], 
               SphereBox[{2, 8, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[4, 5], 
                Rational[2, 5]], 
               SphereBox[{2, 8, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[4, 5], 
                Rational[1, 2]], 
               SphereBox[{2, 8, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[4, 5], 
                Rational[3, 5]], 
               SphereBox[{2, 8, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[4, 5], 
                Rational[7, 10]], 
               SphereBox[{2, 8, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[4, 5], 
                Rational[4, 5]], 
               SphereBox[{2, 8, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[4, 5], 
                Rational[9, 10]], 
               SphereBox[{2, 8, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[4, 5], 1], 
               SphereBox[{2, 8, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 5], 
                Rational[9, 10], 
                Rational[1, 10]], 
               SphereBox[{2, 9, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[9, 10], 
                Rational[1, 5]], 
               SphereBox[{2, 9, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[9, 10], 
                Rational[3, 10]], 
               SphereBox[{2, 9, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[9, 10], 
                Rational[2, 5]], 
               SphereBox[{2, 9, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[9, 10], 
                Rational[1, 2]], 
               SphereBox[{2, 9, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[9, 10], 
                Rational[3, 5]], 
               SphereBox[{2, 9, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[9, 10], 
                Rational[7, 10]], 
               SphereBox[{2, 9, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[9, 10], 
                Rational[4, 5]], 
               SphereBox[{2, 9, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[9, 10], 
                Rational[9, 10]], 
               SphereBox[{2, 9, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 
                Rational[9, 10], 1], 
               SphereBox[{2, 9, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 5], 1, 
                Rational[1, 10]], 
               SphereBox[{2, 10, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 1, 
                Rational[1, 5]], 
               SphereBox[{2, 10, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 1, 
                Rational[3, 10]], 
               SphereBox[{2, 10, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 1, 
                Rational[2, 5]], 
               SphereBox[{2, 10, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 1, 
                Rational[1, 2]], 
               SphereBox[{2, 10, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 1, 
                Rational[3, 5]], 
               SphereBox[{2, 10, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 1, 
                Rational[7, 10]], 
               SphereBox[{2, 10, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 1, 
                Rational[4, 5]], 
               SphereBox[{2, 10, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 1, 
                Rational[9, 10]], 
               SphereBox[{2, 10, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 5], 1, 1], 
               SphereBox[{2, 10, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}}, {{{{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 10], 
                Rational[1, 10]], 
               SphereBox[{3, 1, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 10], 
                Rational[1, 5]], 
               SphereBox[{3, 1, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 10], 
                Rational[3, 10]], 
               SphereBox[{3, 1, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 10], 
                Rational[2, 5]], 
               SphereBox[{3, 1, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 10], 
                Rational[1, 2]], 
               SphereBox[{3, 1, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 10], 
                Rational[3, 5]], 
               SphereBox[{3, 1, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 10], 
                Rational[7, 10]], 
               SphereBox[{3, 1, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 10], 
                Rational[4, 5]], 
               SphereBox[{3, 1, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 10], 
                Rational[9, 10]], 
               SphereBox[{3, 1, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 10], 1], 
               SphereBox[{3, 1, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 5], 
                Rational[1, 10]], 
               SphereBox[{3, 2, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 5], 
                Rational[1, 5]], 
               SphereBox[{3, 2, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 5], 
                Rational[3, 10]], 
               SphereBox[{3, 2, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 5], 
                Rational[2, 5]], 
               SphereBox[{3, 2, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 5], 
                Rational[1, 2]], 
               SphereBox[{3, 2, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 5], 
                Rational[3, 5]], 
               SphereBox[{3, 2, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 5], 
                Rational[7, 10]], 
               SphereBox[{3, 2, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 5], 
                Rational[4, 5]], 
               SphereBox[{3, 2, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 5], 
                Rational[9, 10]], 
               SphereBox[{3, 2, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 5], 1], 
               SphereBox[{3, 2, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 10], 
                Rational[1, 10]], 
               SphereBox[{3, 3, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 10], 
                Rational[1, 5]], 
               SphereBox[{3, 3, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 10], 
                Rational[3, 10]], 
               SphereBox[{3, 3, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 10], 
                Rational[2, 5]], 
               SphereBox[{3, 3, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 10], 
                Rational[1, 2]], 
               SphereBox[{3, 3, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 10], 
                Rational[3, 5]], 
               SphereBox[{3, 3, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 10], 
                Rational[7, 10]], 
               SphereBox[{3, 3, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 10], 
                Rational[4, 5]], 
               SphereBox[{3, 3, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 10], 
                Rational[9, 10]], 
               SphereBox[{3, 3, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 10], 1], 
               SphereBox[{3, 3, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 10], 
                Rational[2, 5], 
                Rational[1, 10]], 
               SphereBox[{3, 4, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[2, 5], 
                Rational[1, 5]], 
               SphereBox[{3, 4, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[2, 5], 
                Rational[3, 10]], 
               SphereBox[{3, 4, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[2, 5], 
                Rational[2, 5]], 
               SphereBox[{3, 4, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[2, 5], 
                Rational[1, 2]], 
               SphereBox[{3, 4, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[2, 5], 
                Rational[3, 5]], 
               SphereBox[{3, 4, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[2, 5], 
                Rational[7, 10]], 
               SphereBox[{3, 4, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[2, 5], 
                Rational[4, 5]], 
               SphereBox[{3, 4, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[2, 5], 
                Rational[9, 10]], 
               SphereBox[{3, 4, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[2, 5], 1], 
               SphereBox[{3, 4, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 2], 
                Rational[1, 10]], 
               SphereBox[{3, 5, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 2], 
                Rational[1, 5]], 
               SphereBox[{3, 5, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 2], 
                Rational[3, 10]], 
               SphereBox[{3, 5, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 2], 
                Rational[2, 5]], 
               SphereBox[{3, 5, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 2], 
                Rational[1, 2]], 
               SphereBox[{3, 5, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 2], 
                Rational[3, 5]], 
               SphereBox[{3, 5, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 2], 
                Rational[7, 10]], 
               SphereBox[{3, 5, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 2], 
                Rational[4, 5]], 
               SphereBox[{3, 5, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 2], 
                Rational[9, 10]], 
               SphereBox[{3, 5, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[1, 2], 1], 
               SphereBox[{3, 5, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 5], 
                Rational[1, 10]], 
               SphereBox[{3, 6, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 5], 
                Rational[1, 5]], 
               SphereBox[{3, 6, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 5], 
                Rational[3, 10]], 
               SphereBox[{3, 6, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 5], 
                Rational[2, 5]], 
               SphereBox[{3, 6, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 5], 
                Rational[1, 2]], 
               SphereBox[{3, 6, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 5], 
                Rational[3, 5]], 
               SphereBox[{3, 6, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 5], 
                Rational[7, 10]], 
               SphereBox[{3, 6, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 5], 
                Rational[4, 5]], 
               SphereBox[{3, 6, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 5], 
                Rational[9, 10]], 
               SphereBox[{3, 6, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[3, 5], 1], 
               SphereBox[{3, 6, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 10], 
                Rational[7, 10], 
                Rational[1, 10]], 
               SphereBox[{3, 7, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[7, 10], 
                Rational[1, 5]], 
               SphereBox[{3, 7, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[7, 10], 
                Rational[3, 10]], 
               SphereBox[{3, 7, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[7, 10], 
                Rational[2, 5]], 
               SphereBox[{3, 7, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[7, 10], 
                Rational[1, 2]], 
               SphereBox[{3, 7, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[7, 10], 
                Rational[3, 5]], 
               SphereBox[{3, 7, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[7, 10], 
                Rational[7, 10]], 
               SphereBox[{3, 7, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[7, 10], 
                Rational[4, 5]], 
               SphereBox[{3, 7, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[7, 10], 
                Rational[9, 10]], 
               SphereBox[{3, 7, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[7, 10], 1], 
               SphereBox[{3, 7, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 10], 
                Rational[4, 5], 
                Rational[1, 10]], 
               SphereBox[{3, 8, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[4, 5], 
                Rational[1, 5]], 
               SphereBox[{3, 8, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[4, 5], 
                Rational[3, 10]], 
               SphereBox[{3, 8, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[4, 5], 
                Rational[2, 5]], 
               SphereBox[{3, 8, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[4, 5], 
                Rational[1, 2]], 
               SphereBox[{3, 8, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[4, 5], 
                Rational[3, 5]], 
               SphereBox[{3, 8, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[4, 5], 
                Rational[7, 10]], 
               SphereBox[{3, 8, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[4, 5], 
                Rational[4, 5]], 
               SphereBox[{3, 8, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[4, 5], 
                Rational[9, 10]], 
               SphereBox[{3, 8, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[4, 5], 1], 
               SphereBox[{3, 8, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 10], 
                Rational[9, 10], 
                Rational[1, 10]], 
               SphereBox[{3, 9, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[9, 10], 
                Rational[1, 5]], 
               SphereBox[{3, 9, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[9, 10], 
                Rational[3, 10]], 
               SphereBox[{3, 9, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[9, 10], 
                Rational[2, 5]], 
               SphereBox[{3, 9, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[9, 10], 
                Rational[1, 2]], 
               SphereBox[{3, 9, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[9, 10], 
                Rational[3, 5]], 
               SphereBox[{3, 9, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[9, 10], 
                Rational[7, 10]], 
               SphereBox[{3, 9, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[9, 10], 
                Rational[4, 5]], 
               SphereBox[{3, 9, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[9, 10], 
                Rational[9, 10]], 
               SphereBox[{3, 9, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 
                Rational[9, 10], 1], 
               SphereBox[{3, 9, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 10], 1, 
                Rational[1, 10]], 
               SphereBox[{3, 10, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 1, 
                Rational[1, 5]], 
               SphereBox[{3, 10, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 1, 
                Rational[3, 10]], 
               SphereBox[{3, 10, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 1, 
                Rational[2, 5]], 
               SphereBox[{3, 10, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 1, 
                Rational[1, 2]], 
               SphereBox[{3, 10, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 1, 
                Rational[3, 5]], 
               SphereBox[{3, 10, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 1, 
                Rational[7, 10]], 
               SphereBox[{3, 10, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 1, 
                Rational[4, 5]], 
               SphereBox[{3, 10, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 1, 
                Rational[9, 10]], 
               SphereBox[{3, 10, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 10], 1, 1], 
               SphereBox[{3, 10, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}}, {{{{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 10], 
                Rational[1, 10]], 
               SphereBox[{4, 1, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 10], 
                Rational[1, 5]], 
               SphereBox[{4, 1, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 10], 
                Rational[3, 10]], 
               SphereBox[{4, 1, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 10], 
                Rational[2, 5]], 
               SphereBox[{4, 1, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 10], 
                Rational[1, 2]], 
               SphereBox[{4, 1, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 10], 
                Rational[3, 5]], 
               SphereBox[{4, 1, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 10], 
                Rational[7, 10]], 
               SphereBox[{4, 1, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 10], 
                Rational[4, 5]], 
               SphereBox[{4, 1, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 10], 
                Rational[9, 10]], 
               SphereBox[{4, 1, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 10], 1], 
               SphereBox[{4, 1, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 5], 
                Rational[1, 10]], 
               SphereBox[{4, 2, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 5], 
                Rational[1, 5]], 
               SphereBox[{4, 2, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 5], 
                Rational[3, 10]], 
               SphereBox[{4, 2, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 5], 
                Rational[2, 5]], 
               SphereBox[{4, 2, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 5], 
                Rational[1, 2]], 
               SphereBox[{4, 2, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 5], 
                Rational[3, 5]], 
               SphereBox[{4, 2, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 5], 
                Rational[7, 10]], 
               SphereBox[{4, 2, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 5], 
                Rational[4, 5]], 
               SphereBox[{4, 2, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 5], 
                Rational[9, 10]], 
               SphereBox[{4, 2, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 5], 1], 
               SphereBox[{4, 2, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 10], 
                Rational[1, 10]], 
               SphereBox[{4, 3, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 10], 
                Rational[1, 5]], 
               SphereBox[{4, 3, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 10], 
                Rational[3, 10]], 
               SphereBox[{4, 3, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 10], 
                Rational[2, 5]], 
               SphereBox[{4, 3, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 10], 
                Rational[1, 2]], 
               SphereBox[{4, 3, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 10], 
                Rational[3, 5]], 
               SphereBox[{4, 3, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 10], 
                Rational[7, 10]], 
               SphereBox[{4, 3, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 10], 
                Rational[4, 5]], 
               SphereBox[{4, 3, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 10], 
                Rational[9, 10]], 
               SphereBox[{4, 3, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 10], 1], 
               SphereBox[{4, 3, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[2, 5], 
                Rational[2, 5], 
                Rational[1, 10]], 
               SphereBox[{4, 4, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[2, 5], 
                Rational[1, 5]], 
               SphereBox[{4, 4, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[2, 5], 
                Rational[3, 10]], 
               SphereBox[{4, 4, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[2, 5], 
                Rational[2, 5]], 
               SphereBox[{4, 4, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[2, 5], 
                Rational[1, 2]], 
               SphereBox[{4, 4, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[2, 5], 
                Rational[3, 5]], 
               SphereBox[{4, 4, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[2, 5], 
                Rational[7, 10]], 
               SphereBox[{4, 4, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[2, 5], 
                Rational[4, 5]], 
               SphereBox[{4, 4, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[2, 5], 
                Rational[9, 10]], 
               SphereBox[{4, 4, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[2, 5], 1], 
               SphereBox[{4, 4, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 2], 
                Rational[1, 10]], 
               SphereBox[{4, 5, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 2], 
                Rational[1, 5]], 
               SphereBox[{4, 5, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 2], 
                Rational[3, 10]], 
               SphereBox[{4, 5, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 2], 
                Rational[2, 5]], 
               SphereBox[{4, 5, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 2], 
                Rational[1, 2]], 
               SphereBox[{4, 5, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 2], 
                Rational[3, 5]], 
               SphereBox[{4, 5, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 2], 
                Rational[7, 10]], 
               SphereBox[{4, 5, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 2], 
                Rational[4, 5]], 
               SphereBox[{4, 5, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 2], 
                Rational[9, 10]], 
               SphereBox[{4, 5, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[1, 2], 1], 
               SphereBox[{4, 5, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 5], 
                Rational[1, 10]], 
               SphereBox[{4, 6, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 5], 
                Rational[1, 5]], 
               SphereBox[{4, 6, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 5], 
                Rational[3, 10]], 
               SphereBox[{4, 6, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 5], 
                Rational[2, 5]], 
               SphereBox[{4, 6, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 5], 
                Rational[1, 2]], 
               SphereBox[{4, 6, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 5], 
                Rational[3, 5]], 
               SphereBox[{4, 6, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 5], 
                Rational[7, 10]], 
               SphereBox[{4, 6, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 5], 
                Rational[4, 5]], 
               SphereBox[{4, 6, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 5], 
                Rational[9, 10]], 
               SphereBox[{4, 6, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[3, 5], 1], 
               SphereBox[{4, 6, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[2, 5], 
                Rational[7, 10], 
                Rational[1, 10]], 
               SphereBox[{4, 7, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[7, 10], 
                Rational[1, 5]], 
               SphereBox[{4, 7, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[7, 10], 
                Rational[3, 10]], 
               SphereBox[{4, 7, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[7, 10], 
                Rational[2, 5]], 
               SphereBox[{4, 7, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[7, 10], 
                Rational[1, 2]], 
               SphereBox[{4, 7, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[7, 10], 
                Rational[3, 5]], 
               SphereBox[{4, 7, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[7, 10], 
                Rational[7, 10]], 
               SphereBox[{4, 7, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[7, 10], 
                Rational[4, 5]], 
               SphereBox[{4, 7, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[7, 10], 
                Rational[9, 10]], 
               SphereBox[{4, 7, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[7, 10], 1], 
               SphereBox[{4, 7, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[2, 5], 
                Rational[4, 5], 
                Rational[1, 10]], 
               SphereBox[{4, 8, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[4, 5], 
                Rational[1, 5]], 
               SphereBox[{4, 8, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[4, 5], 
                Rational[3, 10]], 
               SphereBox[{4, 8, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[4, 5], 
                Rational[2, 5]], 
               SphereBox[{4, 8, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[4, 5], 
                Rational[1, 2]], 
               SphereBox[{4, 8, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[4, 5], 
                Rational[3, 5]], 
               SphereBox[{4, 8, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[4, 5], 
                Rational[7, 10]], 
               SphereBox[{4, 8, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[4, 5], 
                Rational[4, 5]], 
               SphereBox[{4, 8, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[4, 5], 
                Rational[9, 10]], 
               SphereBox[{4, 8, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[4, 5], 1], 
               SphereBox[{4, 8, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[2, 5], 
                Rational[9, 10], 
                Rational[1, 10]], 
               SphereBox[{4, 9, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[9, 10], 
                Rational[1, 5]], 
               SphereBox[{4, 9, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[9, 10], 
                Rational[3, 10]], 
               SphereBox[{4, 9, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[9, 10], 
                Rational[2, 5]], 
               SphereBox[{4, 9, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[9, 10], 
                Rational[1, 2]], 
               SphereBox[{4, 9, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[9, 10], 
                Rational[3, 5]], 
               SphereBox[{4, 9, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[9, 10], 
                Rational[7, 10]], 
               SphereBox[{4, 9, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[9, 10], 
                Rational[4, 5]], 
               SphereBox[{4, 9, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[9, 10], 
                Rational[9, 10]], 
               SphereBox[{4, 9, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 
                Rational[9, 10], 1], 
               SphereBox[{4, 9, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[2, 5], 1, 
                Rational[1, 10]], 
               SphereBox[{4, 10, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 1, 
                Rational[1, 5]], 
               SphereBox[{4, 10, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 1, 
                Rational[3, 10]], 
               SphereBox[{4, 10, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 1, 
                Rational[2, 5]], 
               SphereBox[{4, 10, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 1, 
                Rational[1, 2]], 
               SphereBox[{4, 10, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 1, 
                Rational[3, 5]], 
               SphereBox[{4, 10, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 1, 
                Rational[7, 10]], 
               SphereBox[{4, 10, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 1, 
                Rational[4, 5]], 
               SphereBox[{4, 10, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 1, 
                Rational[9, 10]], 
               SphereBox[{4, 10, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[2, 5], 1, 1], 
               SphereBox[{4, 10, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}}, {{{{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 10], 
                Rational[1, 10]], 
               SphereBox[{5, 1, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 10], 
                Rational[1, 5]], 
               SphereBox[{5, 1, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 10], 
                Rational[3, 10]], 
               SphereBox[{5, 1, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 10], 
                Rational[2, 5]], 
               SphereBox[{5, 1, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 10], 
                Rational[1, 2]], 
               SphereBox[{5, 1, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 10], 
                Rational[3, 5]], 
               SphereBox[{5, 1, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 10], 
                Rational[7, 10]], 
               SphereBox[{5, 1, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 10], 
                Rational[4, 5]], 
               SphereBox[{5, 1, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 10], 
                Rational[9, 10]], 
               SphereBox[{5, 1, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 10], 1], 
               SphereBox[{5, 1, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 5], 
                Rational[1, 10]], 
               SphereBox[{5, 2, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 5], 
                Rational[1, 5]], 
               SphereBox[{5, 2, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 5], 
                Rational[3, 10]], 
               SphereBox[{5, 2, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 5], 
                Rational[2, 5]], 
               SphereBox[{5, 2, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 5], 
                Rational[1, 2]], 
               SphereBox[{5, 2, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 5], 
                Rational[3, 5]], 
               SphereBox[{5, 2, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 5], 
                Rational[7, 10]], 
               SphereBox[{5, 2, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 5], 
                Rational[4, 5]], 
               SphereBox[{5, 2, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 5], 
                Rational[9, 10]], 
               SphereBox[{5, 2, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 5], 1], 
               SphereBox[{5, 2, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 10], 
                Rational[1, 10]], 
               SphereBox[{5, 3, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 10], 
                Rational[1, 5]], 
               SphereBox[{5, 3, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 10], 
                Rational[3, 10]], 
               SphereBox[{5, 3, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 10], 
                Rational[2, 5]], 
               SphereBox[{5, 3, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 10], 
                Rational[1, 2]], 
               SphereBox[{5, 3, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 10], 
                Rational[3, 5]], 
               SphereBox[{5, 3, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 10], 
                Rational[7, 10]], 
               SphereBox[{5, 3, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 10], 
                Rational[4, 5]], 
               SphereBox[{5, 3, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 10], 
                Rational[9, 10]], 
               SphereBox[{5, 3, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 10], 1], 
               SphereBox[{5, 3, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 2], 
                Rational[2, 5], 
                Rational[1, 10]], 
               SphereBox[{5, 4, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[2, 5], 
                Rational[1, 5]], 
               SphereBox[{5, 4, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[2, 5], 
                Rational[3, 10]], 
               SphereBox[{5, 4, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[2, 5], 
                Rational[2, 5]], 
               SphereBox[{5, 4, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[2, 5], 
                Rational[1, 2]], 
               SphereBox[{5, 4, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[2, 5], 
                Rational[3, 5]], 
               SphereBox[{5, 4, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[2, 5], 
                Rational[7, 10]], 
               SphereBox[{5, 4, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[2, 5], 
                Rational[4, 5]], 
               SphereBox[{5, 4, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[2, 5], 
                Rational[9, 10]], 
               SphereBox[{5, 4, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[2, 5], 1], 
               SphereBox[{5, 4, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 
                Rational[1, 10]], 
               SphereBox[{5, 5, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 
                Rational[1, 5]], 
               SphereBox[{5, 5, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 
                Rational[3, 10]], 
               SphereBox[{5, 5, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 
                Rational[2, 5]], 
               SphereBox[{5, 5, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 
                Rational[1, 2]], 
               SphereBox[{5, 5, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 
                Rational[3, 5]], 
               SphereBox[{5, 5, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 
                Rational[7, 10]], 
               SphereBox[{5, 5, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 
                Rational[4, 5]], 
               SphereBox[{5, 5, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 
                Rational[9, 10]], 
               SphereBox[{5, 5, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 1], 
               SphereBox[{5, 5, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 5], 
                Rational[1, 10]], 
               SphereBox[{5, 6, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 5], 
                Rational[1, 5]], 
               SphereBox[{5, 6, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 5], 
                Rational[3, 10]], 
               SphereBox[{5, 6, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 5], 
                Rational[2, 5]], 
               SphereBox[{5, 6, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 5], 
                Rational[1, 2]], 
               SphereBox[{5, 6, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 5], 
                Rational[3, 5]], 
               SphereBox[{5, 6, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 5], 
                Rational[7, 10]], 
               SphereBox[{5, 6, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 5], 
                Rational[4, 5]], 
               SphereBox[{5, 6, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 5], 
                Rational[9, 10]], 
               SphereBox[{5, 6, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[3, 5], 1], 
               SphereBox[{5, 6, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 2], 
                Rational[7, 10], 
                Rational[1, 10]], 
               SphereBox[{5, 7, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[7, 10], 
                Rational[1, 5]], 
               SphereBox[{5, 7, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[7, 10], 
                Rational[3, 10]], 
               SphereBox[{5, 7, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[7, 10], 
                Rational[2, 5]], 
               SphereBox[{5, 7, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[7, 10], 
                Rational[1, 2]], 
               SphereBox[{5, 7, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[7, 10], 
                Rational[3, 5]], 
               SphereBox[{5, 7, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[7, 10], 
                Rational[7, 10]], 
               SphereBox[{5, 7, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[7, 10], 
                Rational[4, 5]], 
               SphereBox[{5, 7, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[7, 10], 
                Rational[9, 10]], 
               SphereBox[{5, 7, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[7, 10], 1], 
               SphereBox[{5, 7, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 2], 
                Rational[4, 5], 
                Rational[1, 10]], 
               SphereBox[{5, 8, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[4, 5], 
                Rational[1, 5]], 
               SphereBox[{5, 8, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[4, 5], 
                Rational[3, 10]], 
               SphereBox[{5, 8, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[4, 5], 
                Rational[2, 5]], 
               SphereBox[{5, 8, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[4, 5], 
                Rational[1, 2]], 
               SphereBox[{5, 8, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[4, 5], 
                Rational[3, 5]], 
               SphereBox[{5, 8, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[4, 5], 
                Rational[7, 10]], 
               SphereBox[{5, 8, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[4, 5], 
                Rational[4, 5]], 
               SphereBox[{5, 8, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[4, 5], 
                Rational[9, 10]], 
               SphereBox[{5, 8, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[4, 5], 1], 
               SphereBox[{5, 8, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 2], 
                Rational[9, 10], 
                Rational[1, 10]], 
               SphereBox[{5, 9, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[9, 10], 
                Rational[1, 5]], 
               SphereBox[{5, 9, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[9, 10], 
                Rational[3, 10]], 
               SphereBox[{5, 9, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[9, 10], 
                Rational[2, 5]], 
               SphereBox[{5, 9, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[9, 10], 
                Rational[1, 2]], 
               SphereBox[{5, 9, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[9, 10], 
                Rational[3, 5]], 
               SphereBox[{5, 9, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[9, 10], 
                Rational[7, 10]], 
               SphereBox[{5, 9, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[9, 10], 
                Rational[4, 5]], 
               SphereBox[{5, 9, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[9, 10], 
                Rational[9, 10]], 
               SphereBox[{5, 9, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 
                Rational[9, 10], 1], 
               SphereBox[{5, 9, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[1, 2], 1, 
                Rational[1, 10]], 
               SphereBox[{5, 10, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 1, 
                Rational[1, 5]], 
               SphereBox[{5, 10, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 1, 
                Rational[3, 10]], 
               SphereBox[{5, 10, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 1, 
                Rational[2, 5]], 
               SphereBox[{5, 10, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 1, 
                Rational[1, 2]], 
               SphereBox[{5, 10, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 1, 
                Rational[3, 5]], 
               SphereBox[{5, 10, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 1, 
                Rational[7, 10]], 
               SphereBox[{5, 10, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 1, 
                Rational[4, 5]], 
               SphereBox[{5, 10, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 1, 
                Rational[9, 10]], 
               SphereBox[{5, 10, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[1, 2], 1, 1], 
               SphereBox[{5, 10, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}}, {{{{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 10], 
                Rational[1, 10]], 
               SphereBox[{6, 1, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 10], 
                Rational[1, 5]], 
               SphereBox[{6, 1, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 10], 
                Rational[3, 10]], 
               SphereBox[{6, 1, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 10], 
                Rational[2, 5]], 
               SphereBox[{6, 1, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 10], 
                Rational[1, 2]], 
               SphereBox[{6, 1, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 10], 
                Rational[3, 5]], 
               SphereBox[{6, 1, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 10], 
                Rational[7, 10]], 
               SphereBox[{6, 1, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 10], 
                Rational[4, 5]], 
               SphereBox[{6, 1, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 10], 
                Rational[9, 10]], 
               SphereBox[{6, 1, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 10], 1], 
               SphereBox[{6, 1, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 5], 
                Rational[1, 10]], 
               SphereBox[{6, 2, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 5], 
                Rational[1, 5]], 
               SphereBox[{6, 2, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 5], 
                Rational[3, 10]], 
               SphereBox[{6, 2, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 5], 
                Rational[2, 5]], 
               SphereBox[{6, 2, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 5], 
                Rational[1, 2]], 
               SphereBox[{6, 2, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 5], 
                Rational[3, 5]], 
               SphereBox[{6, 2, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 5], 
                Rational[7, 10]], 
               SphereBox[{6, 2, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 5], 
                Rational[4, 5]], 
               SphereBox[{6, 2, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 5], 
                Rational[9, 10]], 
               SphereBox[{6, 2, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 5], 1], 
               SphereBox[{6, 2, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 10], 
                Rational[1, 10]], 
               SphereBox[{6, 3, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 10], 
                Rational[1, 5]], 
               SphereBox[{6, 3, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 10], 
                Rational[3, 10]], 
               SphereBox[{6, 3, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 10], 
                Rational[2, 5]], 
               SphereBox[{6, 3, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 10], 
                Rational[1, 2]], 
               SphereBox[{6, 3, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 10], 
                Rational[3, 5]], 
               SphereBox[{6, 3, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 10], 
                Rational[7, 10]], 
               SphereBox[{6, 3, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 10], 
                Rational[4, 5]], 
               SphereBox[{6, 3, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 10], 
                Rational[9, 10]], 
               SphereBox[{6, 3, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 10], 1], 
               SphereBox[{6, 3, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 5], 
                Rational[2, 5], 
                Rational[1, 10]], 
               SphereBox[{6, 4, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[2, 5], 
                Rational[1, 5]], 
               SphereBox[{6, 4, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[2, 5], 
                Rational[3, 10]], 
               SphereBox[{6, 4, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[2, 5], 
                Rational[2, 5]], 
               SphereBox[{6, 4, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[2, 5], 
                Rational[1, 2]], 
               SphereBox[{6, 4, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[2, 5], 
                Rational[3, 5]], 
               SphereBox[{6, 4, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[2, 5], 
                Rational[7, 10]], 
               SphereBox[{6, 4, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[2, 5], 
                Rational[4, 5]], 
               SphereBox[{6, 4, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[2, 5], 
                Rational[9, 10]], 
               SphereBox[{6, 4, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[2, 5], 1], 
               SphereBox[{6, 4, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 2], 
                Rational[1, 10]], 
               SphereBox[{6, 5, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 2], 
                Rational[1, 5]], 
               SphereBox[{6, 5, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 2], 
                Rational[3, 10]], 
               SphereBox[{6, 5, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 2], 
                Rational[2, 5]], 
               SphereBox[{6, 5, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 2], 
                Rational[1, 2]], 
               SphereBox[{6, 5, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 2], 
                Rational[3, 5]], 
               SphereBox[{6, 5, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 2], 
                Rational[7, 10]], 
               SphereBox[{6, 5, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 2], 
                Rational[4, 5]], 
               SphereBox[{6, 5, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 2], 
                Rational[9, 10]], 
               SphereBox[{6, 5, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[1, 2], 1], 
               SphereBox[{6, 5, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 5], 
                Rational[1, 10]], 
               SphereBox[{6, 6, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 5], 
                Rational[1, 5]], 
               SphereBox[{6, 6, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 5], 
                Rational[3, 10]], 
               SphereBox[{6, 6, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 5], 
                Rational[2, 5]], 
               SphereBox[{6, 6, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 5], 
                Rational[1, 2]], 
               SphereBox[{6, 6, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 5], 
                Rational[3, 5]], 
               SphereBox[{6, 6, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 5], 
                Rational[7, 10]], 
               SphereBox[{6, 6, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 5], 
                Rational[4, 5]], 
               SphereBox[{6, 6, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 5], 
                Rational[9, 10]], 
               SphereBox[{6, 6, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[3, 5], 1], 
               SphereBox[{6, 6, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 5], 
                Rational[7, 10], 
                Rational[1, 10]], 
               SphereBox[{6, 7, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[7, 10], 
                Rational[1, 5]], 
               SphereBox[{6, 7, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[7, 10], 
                Rational[3, 10]], 
               SphereBox[{6, 7, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[7, 10], 
                Rational[2, 5]], 
               SphereBox[{6, 7, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[7, 10], 
                Rational[1, 2]], 
               SphereBox[{6, 7, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[7, 10], 
                Rational[3, 5]], 
               SphereBox[{6, 7, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[7, 10], 
                Rational[7, 10]], 
               SphereBox[{6, 7, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[7, 10], 
                Rational[4, 5]], 
               SphereBox[{6, 7, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[7, 10], 
                Rational[9, 10]], 
               SphereBox[{6, 7, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[7, 10], 1], 
               SphereBox[{6, 7, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 5], 
                Rational[4, 5], 
                Rational[1, 10]], 
               SphereBox[{6, 8, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[4, 5], 
                Rational[1, 5]], 
               SphereBox[{6, 8, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[4, 5], 
                Rational[3, 10]], 
               SphereBox[{6, 8, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[4, 5], 
                Rational[2, 5]], 
               SphereBox[{6, 8, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[4, 5], 
                Rational[1, 2]], 
               SphereBox[{6, 8, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[4, 5], 
                Rational[3, 5]], 
               SphereBox[{6, 8, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[4, 5], 
                Rational[7, 10]], 
               SphereBox[{6, 8, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[4, 5], 
                Rational[4, 5]], 
               SphereBox[{6, 8, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[4, 5], 
                Rational[9, 10]], 
               SphereBox[{6, 8, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[4, 5], 1], 
               SphereBox[{6, 8, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 5], 
                Rational[9, 10], 
                Rational[1, 10]], 
               SphereBox[{6, 9, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[9, 10], 
                Rational[1, 5]], 
               SphereBox[{6, 9, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[9, 10], 
                Rational[3, 10]], 
               SphereBox[{6, 9, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[9, 10], 
                Rational[2, 5]], 
               SphereBox[{6, 9, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[9, 10], 
                Rational[1, 2]], 
               SphereBox[{6, 9, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[9, 10], 
                Rational[3, 5]], 
               SphereBox[{6, 9, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[9, 10], 
                Rational[7, 10]], 
               SphereBox[{6, 9, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[9, 10], 
                Rational[4, 5]], 
               SphereBox[{6, 9, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[9, 10], 
                Rational[9, 10]], 
               SphereBox[{6, 9, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 
                Rational[9, 10], 1], 
               SphereBox[{6, 9, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[3, 5], 1, 
                Rational[1, 10]], 
               SphereBox[{6, 10, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 1, 
                Rational[1, 5]], 
               SphereBox[{6, 10, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 1, 
                Rational[3, 10]], 
               SphereBox[{6, 10, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 1, 
                Rational[2, 5]], 
               SphereBox[{6, 10, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 1, 
                Rational[1, 2]], 
               SphereBox[{6, 10, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 1, 
                Rational[3, 5]], 
               SphereBox[{6, 10, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 1, 
                Rational[7, 10]], 
               SphereBox[{6, 10, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 1, 
                Rational[4, 5]], 
               SphereBox[{6, 10, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 1, 
                Rational[9, 10]], 
               SphereBox[{6, 10, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[3, 5], 1, 1], 
               SphereBox[{6, 10, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}}, {{{{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 10], 
                Rational[1, 10]], 
               SphereBox[{7, 1, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 10], 
                Rational[1, 5]], 
               SphereBox[{7, 1, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 10], 
                Rational[3, 10]], 
               SphereBox[{7, 1, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 10], 
                Rational[2, 5]], 
               SphereBox[{7, 1, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 10], 
                Rational[1, 2]], 
               SphereBox[{7, 1, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 10], 
                Rational[3, 5]], 
               SphereBox[{7, 1, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 10], 
                Rational[7, 10]], 
               SphereBox[{7, 1, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 10], 
                Rational[4, 5]], 
               SphereBox[{7, 1, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 10], 
                Rational[9, 10]], 
               SphereBox[{7, 1, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 10], 1], 
               SphereBox[{7, 1, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 5], 
                Rational[1, 10]], 
               SphereBox[{7, 2, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 5], 
                Rational[1, 5]], 
               SphereBox[{7, 2, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 5], 
                Rational[3, 10]], 
               SphereBox[{7, 2, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 5], 
                Rational[2, 5]], 
               SphereBox[{7, 2, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 5], 
                Rational[1, 2]], 
               SphereBox[{7, 2, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 5], 
                Rational[3, 5]], 
               SphereBox[{7, 2, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 5], 
                Rational[7, 10]], 
               SphereBox[{7, 2, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 5], 
                Rational[4, 5]], 
               SphereBox[{7, 2, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 5], 
                Rational[9, 10]], 
               SphereBox[{7, 2, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 5], 1], 
               SphereBox[{7, 2, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 10], 
                Rational[1, 10]], 
               SphereBox[{7, 3, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 10], 
                Rational[1, 5]], 
               SphereBox[{7, 3, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 10], 
                Rational[3, 10]], 
               SphereBox[{7, 3, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 10], 
                Rational[2, 5]], 
               SphereBox[{7, 3, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 10], 
                Rational[1, 2]], 
               SphereBox[{7, 3, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 10], 
                Rational[3, 5]], 
               SphereBox[{7, 3, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 10], 
                Rational[7, 10]], 
               SphereBox[{7, 3, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 10], 
                Rational[4, 5]], 
               SphereBox[{7, 3, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 10], 
                Rational[9, 10]], 
               SphereBox[{7, 3, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 10], 1], 
               SphereBox[{7, 3, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[7, 10], 
                Rational[2, 5], 
                Rational[1, 10]], 
               SphereBox[{7, 4, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[2, 5], 
                Rational[1, 5]], 
               SphereBox[{7, 4, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[2, 5], 
                Rational[3, 10]], 
               SphereBox[{7, 4, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[2, 5], 
                Rational[2, 5]], 
               SphereBox[{7, 4, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[2, 5], 
                Rational[1, 2]], 
               SphereBox[{7, 4, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[2, 5], 
                Rational[3, 5]], 
               SphereBox[{7, 4, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[2, 5], 
                Rational[7, 10]], 
               SphereBox[{7, 4, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[2, 5], 
                Rational[4, 5]], 
               SphereBox[{7, 4, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[2, 5], 
                Rational[9, 10]], 
               SphereBox[{7, 4, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[2, 5], 1], 
               SphereBox[{7, 4, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 2], 
                Rational[1, 10]], 
               SphereBox[{7, 5, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 2], 
                Rational[1, 5]], 
               SphereBox[{7, 5, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 2], 
                Rational[3, 10]], 
               SphereBox[{7, 5, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 2], 
                Rational[2, 5]], 
               SphereBox[{7, 5, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 2], 
                Rational[1, 2]], 
               SphereBox[{7, 5, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 2], 
                Rational[3, 5]], 
               SphereBox[{7, 5, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 2], 
                Rational[7, 10]], 
               SphereBox[{7, 5, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 2], 
                Rational[4, 5]], 
               SphereBox[{7, 5, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 2], 
                Rational[9, 10]], 
               SphereBox[{7, 5, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[1, 2], 1], 
               SphereBox[{7, 5, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 5], 
                Rational[1, 10]], 
               SphereBox[{7, 6, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 5], 
                Rational[1, 5]], 
               SphereBox[{7, 6, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 5], 
                Rational[3, 10]], 
               SphereBox[{7, 6, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 5], 
                Rational[2, 5]], 
               SphereBox[{7, 6, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 5], 
                Rational[1, 2]], 
               SphereBox[{7, 6, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 5], 
                Rational[3, 5]], 
               SphereBox[{7, 6, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 5], 
                Rational[7, 10]], 
               SphereBox[{7, 6, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 5], 
                Rational[4, 5]], 
               SphereBox[{7, 6, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 5], 
                Rational[9, 10]], 
               SphereBox[{7, 6, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[3, 5], 1], 
               SphereBox[{7, 6, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[7, 10], 
                Rational[7, 10], 
                Rational[1, 10]], 
               SphereBox[{7, 7, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[7, 10], 
                Rational[1, 5]], 
               SphereBox[{7, 7, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[7, 10], 
                Rational[3, 10]], 
               SphereBox[{7, 7, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[7, 10], 
                Rational[2, 5]], 
               SphereBox[{7, 7, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[7, 10], 
                Rational[1, 2]], 
               SphereBox[{7, 7, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[7, 10], 
                Rational[3, 5]], 
               SphereBox[{7, 7, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[7, 10], 
                Rational[7, 10]], 
               SphereBox[{7, 7, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[7, 10], 
                Rational[4, 5]], 
               SphereBox[{7, 7, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[7, 10], 
                Rational[9, 10]], 
               SphereBox[{7, 7, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[7, 10], 1], 
               SphereBox[{7, 7, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[7, 10], 
                Rational[4, 5], 
                Rational[1, 10]], 
               SphereBox[{7, 8, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[4, 5], 
                Rational[1, 5]], 
               SphereBox[{7, 8, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[4, 5], 
                Rational[3, 10]], 
               SphereBox[{7, 8, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[4, 5], 
                Rational[2, 5]], 
               SphereBox[{7, 8, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[4, 5], 
                Rational[1, 2]], 
               SphereBox[{7, 8, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[4, 5], 
                Rational[3, 5]], 
               SphereBox[{7, 8, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[4, 5], 
                Rational[7, 10]], 
               SphereBox[{7, 8, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[4, 5], 
                Rational[4, 5]], 
               SphereBox[{7, 8, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[4, 5], 
                Rational[9, 10]], 
               SphereBox[{7, 8, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[4, 5], 1], 
               SphereBox[{7, 8, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[7, 10], 
                Rational[9, 10], 
                Rational[1, 10]], 
               SphereBox[{7, 9, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[9, 10], 
                Rational[1, 5]], 
               SphereBox[{7, 9, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[9, 10], 
                Rational[3, 10]], 
               SphereBox[{7, 9, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[9, 10], 
                Rational[2, 5]], 
               SphereBox[{7, 9, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[9, 10], 
                Rational[1, 2]], 
               SphereBox[{7, 9, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[9, 10], 
                Rational[3, 5]], 
               SphereBox[{7, 9, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[9, 10], 
                Rational[7, 10]], 
               SphereBox[{7, 9, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[9, 10], 
                Rational[4, 5]], 
               SphereBox[{7, 9, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[9, 10], 
                Rational[9, 10]], 
               SphereBox[{7, 9, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 
                Rational[9, 10], 1], 
               SphereBox[{7, 9, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[7, 10], 1, 
                Rational[1, 10]], 
               SphereBox[{7, 10, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 1, 
                Rational[1, 5]], 
               SphereBox[{7, 10, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 1, 
                Rational[3, 10]], 
               SphereBox[{7, 10, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 1, 
                Rational[2, 5]], 
               SphereBox[{7, 10, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 1, 
                Rational[1, 2]], 
               SphereBox[{7, 10, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 1, 
                Rational[3, 5]], 
               SphereBox[{7, 10, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 1, 
                Rational[7, 10]], 
               SphereBox[{7, 10, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 1, 
                Rational[4, 5]], 
               SphereBox[{7, 10, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 1, 
                Rational[9, 10]], 
               SphereBox[{7, 10, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[7, 10], 1, 1], 
               SphereBox[{7, 10, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}}, {{{{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 10], 
                Rational[1, 10]], 
               SphereBox[{8, 1, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 10], 
                Rational[1, 5]], 
               SphereBox[{8, 1, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 10], 
                Rational[3, 10]], 
               SphereBox[{8, 1, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 10], 
                Rational[2, 5]], 
               SphereBox[{8, 1, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 10], 
                Rational[1, 2]], 
               SphereBox[{8, 1, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 10], 
                Rational[3, 5]], 
               SphereBox[{8, 1, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 10], 
                Rational[7, 10]], 
               SphereBox[{8, 1, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 10], 
                Rational[4, 5]], 
               SphereBox[{8, 1, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 10], 
                Rational[9, 10]], 
               SphereBox[{8, 1, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 10], 1], 
               SphereBox[{8, 1, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 5], 
                Rational[1, 10]], 
               SphereBox[{8, 2, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 5], 
                Rational[1, 5]], 
               SphereBox[{8, 2, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 5], 
                Rational[3, 10]], 
               SphereBox[{8, 2, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 5], 
                Rational[2, 5]], 
               SphereBox[{8, 2, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 5], 
                Rational[1, 2]], 
               SphereBox[{8, 2, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 5], 
                Rational[3, 5]], 
               SphereBox[{8, 2, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 5], 
                Rational[7, 10]], 
               SphereBox[{8, 2, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 5], 
                Rational[4, 5]], 
               SphereBox[{8, 2, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 5], 
                Rational[9, 10]], 
               SphereBox[{8, 2, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 5], 1], 
               SphereBox[{8, 2, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 10], 
                Rational[1, 10]], 
               SphereBox[{8, 3, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 10], 
                Rational[1, 5]], 
               SphereBox[{8, 3, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 10], 
                Rational[3, 10]], 
               SphereBox[{8, 3, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 10], 
                Rational[2, 5]], 
               SphereBox[{8, 3, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 10], 
                Rational[1, 2]], 
               SphereBox[{8, 3, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 10], 
                Rational[3, 5]], 
               SphereBox[{8, 3, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 10], 
                Rational[7, 10]], 
               SphereBox[{8, 3, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 10], 
                Rational[4, 5]], 
               SphereBox[{8, 3, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 10], 
                Rational[9, 10]], 
               SphereBox[{8, 3, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 10], 1], 
               SphereBox[{8, 3, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[4, 5], 
                Rational[2, 5], 
                Rational[1, 10]], 
               SphereBox[{8, 4, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[2, 5], 
                Rational[1, 5]], 
               SphereBox[{8, 4, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[2, 5], 
                Rational[3, 10]], 
               SphereBox[{8, 4, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[2, 5], 
                Rational[2, 5]], 
               SphereBox[{8, 4, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[2, 5], 
                Rational[1, 2]], 
               SphereBox[{8, 4, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[2, 5], 
                Rational[3, 5]], 
               SphereBox[{8, 4, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[2, 5], 
                Rational[7, 10]], 
               SphereBox[{8, 4, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[2, 5], 
                Rational[4, 5]], 
               SphereBox[{8, 4, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[2, 5], 
                Rational[9, 10]], 
               SphereBox[{8, 4, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[2, 5], 1], 
               SphereBox[{8, 4, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 2], 
                Rational[1, 10]], 
               SphereBox[{8, 5, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 2], 
                Rational[1, 5]], 
               SphereBox[{8, 5, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 2], 
                Rational[3, 10]], 
               SphereBox[{8, 5, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 2], 
                Rational[2, 5]], 
               SphereBox[{8, 5, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 2], 
                Rational[1, 2]], 
               SphereBox[{8, 5, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 2], 
                Rational[3, 5]], 
               SphereBox[{8, 5, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 2], 
                Rational[7, 10]], 
               SphereBox[{8, 5, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 2], 
                Rational[4, 5]], 
               SphereBox[{8, 5, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 2], 
                Rational[9, 10]], 
               SphereBox[{8, 5, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[1, 2], 1], 
               SphereBox[{8, 5, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 5], 
                Rational[1, 10]], 
               SphereBox[{8, 6, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 5], 
                Rational[1, 5]], 
               SphereBox[{8, 6, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 5], 
                Rational[3, 10]], 
               SphereBox[{8, 6, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 5], 
                Rational[2, 5]], 
               SphereBox[{8, 6, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 5], 
                Rational[1, 2]], 
               SphereBox[{8, 6, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 5], 
                Rational[3, 5]], 
               SphereBox[{8, 6, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 5], 
                Rational[7, 10]], 
               SphereBox[{8, 6, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 5], 
                Rational[4, 5]], 
               SphereBox[{8, 6, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 5], 
                Rational[9, 10]], 
               SphereBox[{8, 6, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[3, 5], 1], 
               SphereBox[{8, 6, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[4, 5], 
                Rational[7, 10], 
                Rational[1, 10]], 
               SphereBox[{8, 7, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[7, 10], 
                Rational[1, 5]], 
               SphereBox[{8, 7, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[7, 10], 
                Rational[3, 10]], 
               SphereBox[{8, 7, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[7, 10], 
                Rational[2, 5]], 
               SphereBox[{8, 7, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[7, 10], 
                Rational[1, 2]], 
               SphereBox[{8, 7, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[7, 10], 
                Rational[3, 5]], 
               SphereBox[{8, 7, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[7, 10], 
                Rational[7, 10]], 
               SphereBox[{8, 7, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[7, 10], 
                Rational[4, 5]], 
               SphereBox[{8, 7, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[7, 10], 
                Rational[9, 10]], 
               SphereBox[{8, 7, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[7, 10], 1], 
               SphereBox[{8, 7, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[4, 5], 
                Rational[4, 5], 
                Rational[1, 10]], 
               SphereBox[{8, 8, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[4, 5], 
                Rational[1, 5]], 
               SphereBox[{8, 8, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[4, 5], 
                Rational[3, 10]], 
               SphereBox[{8, 8, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[4, 5], 
                Rational[2, 5]], 
               SphereBox[{8, 8, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[4, 5], 
                Rational[1, 2]], 
               SphereBox[{8, 8, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[4, 5], 
                Rational[3, 5]], 
               SphereBox[{8, 8, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[4, 5], 
                Rational[7, 10]], 
               SphereBox[{8, 8, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[4, 5], 
                Rational[4, 5]], 
               SphereBox[{8, 8, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[4, 5], 
                Rational[9, 10]], 
               SphereBox[{8, 8, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[4, 5], 1], 
               SphereBox[{8, 8, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[4, 5], 
                Rational[9, 10], 
                Rational[1, 10]], 
               SphereBox[{8, 9, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[9, 10], 
                Rational[1, 5]], 
               SphereBox[{8, 9, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[9, 10], 
                Rational[3, 10]], 
               SphereBox[{8, 9, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[9, 10], 
                Rational[2, 5]], 
               SphereBox[{8, 9, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[9, 10], 
                Rational[1, 2]], 
               SphereBox[{8, 9, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[9, 10], 
                Rational[3, 5]], 
               SphereBox[{8, 9, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[9, 10], 
                Rational[7, 10]], 
               SphereBox[{8, 9, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[9, 10], 
                Rational[4, 5]], 
               SphereBox[{8, 9, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[9, 10], 
                Rational[9, 10]], 
               SphereBox[{8, 9, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 
                Rational[9, 10], 1], 
               SphereBox[{8, 9, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[4, 5], 1, 
                Rational[1, 10]], 
               SphereBox[{8, 10, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 1, 
                Rational[1, 5]], 
               SphereBox[{8, 10, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 1, 
                Rational[3, 10]], 
               SphereBox[{8, 10, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 1, 
                Rational[2, 5]], 
               SphereBox[{8, 10, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 1, 
                Rational[1, 2]], 
               SphereBox[{8, 10, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 1, 
                Rational[3, 5]], 
               SphereBox[{8, 10, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 1, 
                Rational[7, 10]], 
               SphereBox[{8, 10, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 1, 
                Rational[4, 5]], 
               SphereBox[{8, 10, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 1, 
                Rational[9, 10]], 
               SphereBox[{8, 10, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[4, 5], 1, 1], 
               SphereBox[{8, 10, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}}, {{{{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 10], 
                Rational[1, 10]], 
               SphereBox[{9, 1, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 10], 
                Rational[1, 5]], 
               SphereBox[{9, 1, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 10], 
                Rational[3, 10]], 
               SphereBox[{9, 1, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 10], 
                Rational[2, 5]], 
               SphereBox[{9, 1, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 10], 
                Rational[1, 2]], 
               SphereBox[{9, 1, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 10], 
                Rational[3, 5]], 
               SphereBox[{9, 1, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 10], 
                Rational[7, 10]], 
               SphereBox[{9, 1, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 10], 
                Rational[4, 5]], 
               SphereBox[{9, 1, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 10], 
                Rational[9, 10]], 
               SphereBox[{9, 1, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 10], 1], 
               SphereBox[{9, 1, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 5], 
                Rational[1, 10]], 
               SphereBox[{9, 2, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 5], 
                Rational[1, 5]], 
               SphereBox[{9, 2, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 5], 
                Rational[3, 10]], 
               SphereBox[{9, 2, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 5], 
                Rational[2, 5]], 
               SphereBox[{9, 2, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 5], 
                Rational[1, 2]], 
               SphereBox[{9, 2, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 5], 
                Rational[3, 5]], 
               SphereBox[{9, 2, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 5], 
                Rational[7, 10]], 
               SphereBox[{9, 2, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 5], 
                Rational[4, 5]], 
               SphereBox[{9, 2, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 5], 
                Rational[9, 10]], 
               SphereBox[{9, 2, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 5], 1], 
               SphereBox[{9, 2, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 10], 
                Rational[1, 10]], 
               SphereBox[{9, 3, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 10], 
                Rational[1, 5]], 
               SphereBox[{9, 3, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 10], 
                Rational[3, 10]], 
               SphereBox[{9, 3, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 10], 
                Rational[2, 5]], 
               SphereBox[{9, 3, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 10], 
                Rational[1, 2]], 
               SphereBox[{9, 3, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 10], 
                Rational[3, 5]], 
               SphereBox[{9, 3, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 10], 
                Rational[7, 10]], 
               SphereBox[{9, 3, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 10], 
                Rational[4, 5]], 
               SphereBox[{9, 3, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 10], 
                Rational[9, 10]], 
               SphereBox[{9, 3, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 10], 1], 
               SphereBox[{9, 3, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[9, 10], 
                Rational[2, 5], 
                Rational[1, 10]], 
               SphereBox[{9, 4, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[2, 5], 
                Rational[1, 5]], 
               SphereBox[{9, 4, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[2, 5], 
                Rational[3, 10]], 
               SphereBox[{9, 4, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[2, 5], 
                Rational[2, 5]], 
               SphereBox[{9, 4, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[2, 5], 
                Rational[1, 2]], 
               SphereBox[{9, 4, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[2, 5], 
                Rational[3, 5]], 
               SphereBox[{9, 4, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[2, 5], 
                Rational[7, 10]], 
               SphereBox[{9, 4, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[2, 5], 
                Rational[4, 5]], 
               SphereBox[{9, 4, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[2, 5], 
                Rational[9, 10]], 
               SphereBox[{9, 4, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[2, 5], 1], 
               SphereBox[{9, 4, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 2], 
                Rational[1, 10]], 
               SphereBox[{9, 5, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 2], 
                Rational[1, 5]], 
               SphereBox[{9, 5, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 2], 
                Rational[3, 10]], 
               SphereBox[{9, 5, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 2], 
                Rational[2, 5]], 
               SphereBox[{9, 5, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 2], 
                Rational[1, 2]], 
               SphereBox[{9, 5, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 2], 
                Rational[3, 5]], 
               SphereBox[{9, 5, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 2], 
                Rational[7, 10]], 
               SphereBox[{9, 5, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 2], 
                Rational[4, 5]], 
               SphereBox[{9, 5, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 2], 
                Rational[9, 10]], 
               SphereBox[{9, 5, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[1, 2], 1], 
               SphereBox[{9, 5, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 5], 
                Rational[1, 10]], 
               SphereBox[{9, 6, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 5], 
                Rational[1, 5]], 
               SphereBox[{9, 6, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 5], 
                Rational[3, 10]], 
               SphereBox[{9, 6, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 5], 
                Rational[2, 5]], 
               SphereBox[{9, 6, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 5], 
                Rational[1, 2]], 
               SphereBox[{9, 6, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 5], 
                Rational[3, 5]], 
               SphereBox[{9, 6, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 5], 
                Rational[7, 10]], 
               SphereBox[{9, 6, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 5], 
                Rational[4, 5]], 
               SphereBox[{9, 6, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 5], 
                Rational[9, 10]], 
               SphereBox[{9, 6, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[3, 5], 1], 
               SphereBox[{9, 6, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[9, 10], 
                Rational[7, 10], 
                Rational[1, 10]], 
               SphereBox[{9, 7, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[7, 10], 
                Rational[1, 5]], 
               SphereBox[{9, 7, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[7, 10], 
                Rational[3, 10]], 
               SphereBox[{9, 7, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[7, 10], 
                Rational[2, 5]], 
               SphereBox[{9, 7, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[7, 10], 
                Rational[1, 2]], 
               SphereBox[{9, 7, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[7, 10], 
                Rational[3, 5]], 
               SphereBox[{9, 7, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[7, 10], 
                Rational[7, 10]], 
               SphereBox[{9, 7, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[7, 10], 
                Rational[4, 5]], 
               SphereBox[{9, 7, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[7, 10], 
                Rational[9, 10]], 
               SphereBox[{9, 7, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[7, 10], 1], 
               SphereBox[{9, 7, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[9, 10], 
                Rational[4, 5], 
                Rational[1, 10]], 
               SphereBox[{9, 8, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[4, 5], 
                Rational[1, 5]], 
               SphereBox[{9, 8, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[4, 5], 
                Rational[3, 10]], 
               SphereBox[{9, 8, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[4, 5], 
                Rational[2, 5]], 
               SphereBox[{9, 8, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[4, 5], 
                Rational[1, 2]], 
               SphereBox[{9, 8, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[4, 5], 
                Rational[3, 5]], 
               SphereBox[{9, 8, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[4, 5], 
                Rational[7, 10]], 
               SphereBox[{9, 8, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[4, 5], 
                Rational[4, 5]], 
               SphereBox[{9, 8, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[4, 5], 
                Rational[9, 10]], 
               SphereBox[{9, 8, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[4, 5], 1], 
               SphereBox[{9, 8, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[9, 10], 
                Rational[9, 10], 
                Rational[1, 10]], 
               SphereBox[{9, 9, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[9, 10], 
                Rational[1, 5]], 
               SphereBox[{9, 9, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[9, 10], 
                Rational[3, 10]], 
               SphereBox[{9, 9, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[9, 10], 
                Rational[2, 5]], 
               SphereBox[{9, 9, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[9, 10], 
                Rational[1, 2]], 
               SphereBox[{9, 9, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[9, 10], 
                Rational[3, 5]], 
               SphereBox[{9, 9, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[9, 10], 
                Rational[7, 10]], 
               SphereBox[{9, 9, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[9, 10], 
                Rational[4, 5]], 
               SphereBox[{9, 9, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[9, 10], 
                Rational[9, 10]], 
               SphereBox[{9, 9, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 
                Rational[9, 10], 1], 
               SphereBox[{9, 9, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[
                Rational[9, 10], 1, 
                Rational[1, 10]], 
               SphereBox[{9, 10, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 1, 
                Rational[1, 5]], 
               SphereBox[{9, 10, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 1, 
                Rational[3, 10]], 
               SphereBox[{9, 10, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 1, 
                Rational[2, 5]], 
               SphereBox[{9, 10, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 1, 
                Rational[1, 2]], 
               SphereBox[{9, 10, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 1, 
                Rational[3, 5]], 
               SphereBox[{9, 10, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 1, 
                Rational[7, 10]], 
               SphereBox[{9, 10, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 1, 
                Rational[4, 5]], 
               SphereBox[{9, 10, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 1, 
                Rational[9, 10]], 
               SphereBox[{9, 10, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[
                Rational[9, 10], 1, 1], 
               SphereBox[{9, 10, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}}, {{{{
               RGBColor[1, 
                Rational[1, 10], 
                Rational[1, 10]], 
               SphereBox[{10, 1, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 10], 
                Rational[1, 5]], 
               SphereBox[{10, 1, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 10], 
                Rational[3, 10]], 
               SphereBox[{10, 1, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 10], 
                Rational[2, 5]], 
               SphereBox[{10, 1, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 10], 
                Rational[1, 2]], 
               SphereBox[{10, 1, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 10], 
                Rational[3, 5]], 
               SphereBox[{10, 1, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 10], 
                Rational[7, 10]], 
               SphereBox[{10, 1, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 10], 
                Rational[4, 5]], 
               SphereBox[{10, 1, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 10], 
                Rational[9, 10]], 
               SphereBox[{10, 1, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 10], 1], 
               SphereBox[{10, 1, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[1, 
                Rational[1, 5], 
                Rational[1, 10]], 
               SphereBox[{10, 2, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 5], 
                Rational[1, 5]], 
               SphereBox[{10, 2, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 5], 
                Rational[3, 10]], 
               SphereBox[{10, 2, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 5], 
                Rational[2, 5]], 
               SphereBox[{10, 2, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 5], 
                Rational[1, 2]], 
               SphereBox[{10, 2, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 5], 
                Rational[3, 5]], 
               SphereBox[{10, 2, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 5], 
                Rational[7, 10]], 
               SphereBox[{10, 2, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 5], 
                Rational[4, 5]], 
               SphereBox[{10, 2, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 5], 
                Rational[9, 10]], 
               SphereBox[{10, 2, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 5], 1], 
               SphereBox[{10, 2, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[1, 
                Rational[3, 10], 
                Rational[1, 10]], 
               SphereBox[{10, 3, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 10], 
                Rational[1, 5]], 
               SphereBox[{10, 3, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 10], 
                Rational[3, 10]], 
               SphereBox[{10, 3, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 10], 
                Rational[2, 5]], 
               SphereBox[{10, 3, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 10], 
                Rational[1, 2]], 
               SphereBox[{10, 3, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 10], 
                Rational[3, 5]], 
               SphereBox[{10, 3, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 10], 
                Rational[7, 10]], 
               SphereBox[{10, 3, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 10], 
                Rational[4, 5]], 
               SphereBox[{10, 3, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 10], 
                Rational[9, 10]], 
               SphereBox[{10, 3, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 10], 1], 
               SphereBox[{10, 3, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[1, 
                Rational[2, 5], 
                Rational[1, 10]], 
               SphereBox[{10, 4, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[2, 5], 
                Rational[1, 5]], 
               SphereBox[{10, 4, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[2, 5], 
                Rational[3, 10]], 
               SphereBox[{10, 4, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[2, 5], 
                Rational[2, 5]], 
               SphereBox[{10, 4, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[2, 5], 
                Rational[1, 2]], 
               SphereBox[{10, 4, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[2, 5], 
                Rational[3, 5]], 
               SphereBox[{10, 4, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[2, 5], 
                Rational[7, 10]], 
               SphereBox[{10, 4, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[2, 5], 
                Rational[4, 5]], 
               SphereBox[{10, 4, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[2, 5], 
                Rational[9, 10]], 
               SphereBox[{10, 4, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[2, 5], 1], 
               SphereBox[{10, 4, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[1, 
                Rational[1, 2], 
                Rational[1, 10]], 
               SphereBox[{10, 5, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 2], 
                Rational[1, 5]], 
               SphereBox[{10, 5, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 2], 
                Rational[3, 10]], 
               SphereBox[{10, 5, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 2], 
                Rational[2, 5]], 
               SphereBox[{10, 5, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 2], 
                Rational[1, 2]], 
               SphereBox[{10, 5, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 2], 
                Rational[3, 5]], 
               SphereBox[{10, 5, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 2], 
                Rational[7, 10]], 
               SphereBox[{10, 5, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 2], 
                Rational[4, 5]], 
               SphereBox[{10, 5, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 2], 
                Rational[9, 10]], 
               SphereBox[{10, 5, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[1, 2], 1], 
               SphereBox[{10, 5, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[1, 
                Rational[3, 5], 
                Rational[1, 10]], 
               SphereBox[{10, 6, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 5], 
                Rational[1, 5]], 
               SphereBox[{10, 6, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 5], 
                Rational[3, 10]], 
               SphereBox[{10, 6, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 5], 
                Rational[2, 5]], 
               SphereBox[{10, 6, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 5], 
                Rational[1, 2]], 
               SphereBox[{10, 6, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 5], 
                Rational[3, 5]], 
               SphereBox[{10, 6, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 5], 
                Rational[7, 10]], 
               SphereBox[{10, 6, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 5], 
                Rational[4, 5]], 
               SphereBox[{10, 6, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 5], 
                Rational[9, 10]], 
               SphereBox[{10, 6, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[3, 5], 1], 
               SphereBox[{10, 6, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[1, 
                Rational[7, 10], 
                Rational[1, 10]], 
               SphereBox[{10, 7, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[7, 10], 
                Rational[1, 5]], 
               SphereBox[{10, 7, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[7, 10], 
                Rational[3, 10]], 
               SphereBox[{10, 7, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[7, 10], 
                Rational[2, 5]], 
               SphereBox[{10, 7, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[7, 10], 
                Rational[1, 2]], 
               SphereBox[{10, 7, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[7, 10], 
                Rational[3, 5]], 
               SphereBox[{10, 7, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[7, 10], 
                Rational[7, 10]], 
               SphereBox[{10, 7, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[7, 10], 
                Rational[4, 5]], 
               SphereBox[{10, 7, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[7, 10], 
                Rational[9, 10]], 
               SphereBox[{10, 7, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[7, 10], 1], 
               SphereBox[{10, 7, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[1, 
                Rational[4, 5], 
                Rational[1, 10]], 
               SphereBox[{10, 8, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[4, 5], 
                Rational[1, 5]], 
               SphereBox[{10, 8, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[4, 5], 
                Rational[3, 10]], 
               SphereBox[{10, 8, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[4, 5], 
                Rational[2, 5]], 
               SphereBox[{10, 8, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[4, 5], 
                Rational[1, 2]], 
               SphereBox[{10, 8, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[4, 5], 
                Rational[3, 5]], 
               SphereBox[{10, 8, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[4, 5], 
                Rational[7, 10]], 
               SphereBox[{10, 8, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[4, 5], 
                Rational[4, 5]], 
               SphereBox[{10, 8, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[4, 5], 
                Rational[9, 10]], 
               SphereBox[{10, 8, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[4, 5], 1], 
               SphereBox[{10, 8, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[1, 
                Rational[9, 10], 
                Rational[1, 10]], 
               SphereBox[{10, 9, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[9, 10], 
                Rational[1, 5]], 
               SphereBox[{10, 9, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[9, 10], 
                Rational[3, 10]], 
               SphereBox[{10, 9, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[9, 10], 
                Rational[2, 5]], 
               SphereBox[{10, 9, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[9, 10], 
                Rational[1, 2]], 
               SphereBox[{10, 9, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[9, 10], 
                Rational[3, 5]], 
               SphereBox[{10, 9, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[9, 10], 
                Rational[7, 10]], 
               SphereBox[{10, 9, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[9, 10], 
                Rational[4, 5]], 
               SphereBox[{10, 9, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[9, 10], 
                Rational[9, 10]], 
               SphereBox[{10, 9, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 
                Rational[9, 10], 1], 
               SphereBox[{10, 9, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}, {{{
               RGBColor[1, 1, 
                Rational[1, 10]], 
               SphereBox[{10, 10, 1}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 1, 
                Rational[1, 5]], 
               SphereBox[{10, 10, 2}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 1, 
                Rational[3, 10]], 
               SphereBox[{10, 10, 3}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 1, 
                Rational[2, 5]], 
               SphereBox[{10, 10, 4}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 1, 
                Rational[1, 2]], 
               SphereBox[{10, 10, 5}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 1, 
                Rational[3, 5]], 
               SphereBox[{10, 10, 6}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 1, 
                Rational[7, 10]], 
               SphereBox[{10, 10, 7}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 1, 
                Rational[4, 5]], 
               SphereBox[{10, 10, 8}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 1, 
                Rational[9, 10]], 
               SphereBox[{10, 10, 9}, 
                NCache[
                 Rational[1, 2], 0.5]]}}, {{
               RGBColor[1, 1, 1], 
               SphereBox[{10, 10, 10}, 
                NCache[
                 Rational[1, 2], 0.5]]}}}}}, 
          ImageSize -> {284.87890625, Automatic}, 
          ViewPoint -> {1.3, -2.4, 2.}, ViewVertical -> {0., 0., 1.}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"881749ac-2f07-4d79-b3e9-0874bd32cf12"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " with ",
 Cell[BoxData[
 "t"], "InlineCode",ExpressionUUID->"411c631f-fff4-4777-97b7-0b8ada23ac38"],
 " varying between \[Minus]2 and +2 that contains circles of radius ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"851a0037-9c48-45cf-bbf2-4f8327cd2ac3"],
 " centered at ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t", "*", "x"}], ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "8a8f2868-5ba5-4a85-940b-25323f799455"],
 " with ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"42d2c9e4-1a51-4784-bb34-51a4637d86cb"],
 " going from 1 to 10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "14.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"48f5ac47-9527-44f4-a9c2-8331ae7c1634"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`t$$ = -2, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`t$$], -2, 2}}, Typeset`size$$ = {
          240., {81., 87.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`t$74877$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`t$$ = -2}, 
            "ControllerVariables" :> {
              Hold[$CellContext`t$$, $CellContext`t$74877$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            Graphics[
              Table[
               
               Circle[{$CellContext`t$$ $CellContext`x, 
                 0}, $CellContext`x], {$CellContext`x, 10}]], 
            "Specifications" :> {{$CellContext`t$$, -2, 2}}, "Options" :> {}, 
            "DefaultOptions" :> {}],
           ImageSizeCache->{285., {128., 134.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "aa6d71cb-485f-463d-af29-de562ac686e9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`t$$ = -2, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`t$$], -2, 2}}, 
             Typeset`size$$ = {240., {81., 87.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`t$74877$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`t$$ = -2}, 
              "ControllerVariables" :> {
                Hold[$CellContext`t$$, $CellContext`t$74877$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Graphics[
                Table[
                 
                 Circle[{$CellContext`t$$ $CellContext`x, 
                   0}, $CellContext`x], {$CellContext`x, 10}]], 
              "Specifications" :> {{$CellContext`t$$, -2, 2}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {291., {129., 136.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"29175ee3-4798-49d0-a813-4226254ef59e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 5\[Times]5 array of regular hexagons with size 1/2, centered at \
integer points.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "14.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"226cb395-e5ed-420d-8229-0517948d9ea1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[5, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[3, 2], 1}, {
              Rational[5, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[3, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[1, 2], 1}, {
              Rational[3, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}}, {{1.25, 
              0.5669872981077807}, {1.5, 1}, {1.25, 1.4330127018922192`}, {
              0.75, 1.4330127018922192`}, {0.5, 1}, {0.75, 
              0.5669872981077807}}]],
           RegularPolygon[{1, 1}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[5, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[3, 2], 2}, {
              Rational[5, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[3, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[1, 2], 2}, {
              Rational[3, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}}, {{1.25, 
              1.5669872981077808`}, {1.5, 2}, {1.25, 2.433012701892219}, {
              0.75, 2.433012701892219}, {0.5, 2}, {0.75, 
              1.5669872981077808`}}]],
           RegularPolygon[{1, 2}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[5, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[3, 2], 3}, {
              Rational[5, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[3, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[1, 2], 3}, {
              Rational[3, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}}, {{1.25, 
              2.566987298107781}, {1.5, 3}, {1.25, 3.433012701892219}, {0.75, 
              3.433012701892219}, {0.5, 3}, {0.75, 2.566987298107781}}]],
           RegularPolygon[{1, 3}, 
            Rational[1, 2], 6]], 
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[5, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[3, 2], 4}, {
              Rational[5, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[3, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[1, 2], 4}, {
              Rational[3, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}}, {{1.25, 
              3.566987298107781}, {1.5, 4}, {1.25, 4.43301270189222}, {0.75, 
              4.43301270189222}, {0.5, 4}, {0.75, 3.566987298107781}}]],
           RegularPolygon[{1, 4}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[5, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[3, 2], 5}, {
              Rational[5, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[3, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[1, 2], 5}, {
              Rational[3, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}}, {{1.25, 
              4.56698729810778}, {1.5, 5}, {1.25, 5.43301270189222}, {0.75, 
              5.43301270189222}, {0.5, 5}, {0.75, 4.56698729810778}}]],
           RegularPolygon[{1, 5}, 
            Rational[1, 2], 6]]}, {
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[9, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[5, 2], 1}, {
              Rational[9, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[7, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[3, 2], 1}, {
              Rational[7, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}}, {{2.25, 
              0.5669872981077807}, {2.5, 1}, {2.25, 1.4330127018922192`}, {
              1.75, 1.4330127018922192`}, {1.5, 1}, {1.75, 
              0.5669872981077807}}]],
           RegularPolygon[{2, 1}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[9, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[5, 2], 2}, {
              Rational[9, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[7, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[3, 2], 2}, {
              Rational[7, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}}, {{2.25, 
              1.5669872981077808`}, {2.5, 2}, {2.25, 2.433012701892219}, {
              1.75, 2.433012701892219}, {1.5, 2}, {1.75, 
              1.5669872981077808`}}]],
           RegularPolygon[{2, 2}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[9, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[5, 2], 3}, {
              Rational[9, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[7, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[3, 2], 3}, {
              Rational[7, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}}, {{2.25, 
              2.566987298107781}, {2.5, 3}, {2.25, 3.433012701892219}, {1.75, 
              3.433012701892219}, {1.5, 3}, {1.75, 2.566987298107781}}]],
           RegularPolygon[{2, 3}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[9, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[5, 2], 4}, {
              Rational[9, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[7, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[3, 2], 4}, {
              Rational[7, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}}, {{2.25, 
              3.566987298107781}, {2.5, 4}, {2.25, 4.43301270189222}, {1.75, 
              4.43301270189222}, {1.5, 4}, {1.75, 3.566987298107781}}]],
           RegularPolygon[{2, 4}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[9, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[5, 2], 5}, {
              Rational[9, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[7, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[3, 2], 5}, {
              Rational[7, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}}, {{2.25, 
              4.56698729810778}, {2.5, 5}, {2.25, 5.43301270189222}, {1.75, 
              5.43301270189222}, {1.5, 5}, {1.75, 4.56698729810778}}]],
           RegularPolygon[{2, 5}, 
            Rational[1, 2], 6]]}, {
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[13, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[7, 2], 1}, {
              Rational[13, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[11, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[5, 2], 1}, {
              Rational[11, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}}, {{3.25,
               0.5669872981077807}, {3.5, 1}, {3.25, 1.4330127018922192`}, {
              2.75, 1.4330127018922192`}, {2.5, 1}, {2.75, 
              0.5669872981077807}}]],
           RegularPolygon[{3, 1}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[13, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[7, 2], 2}, {
              Rational[13, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[11, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[5, 2], 2}, {
              Rational[11, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}}, {{3.25,
               1.5669872981077808`}, {3.5, 2}, {3.25, 2.433012701892219}, {
              2.75, 2.433012701892219}, {2.5, 2}, {2.75, 
              1.5669872981077808`}}]],
           RegularPolygon[{3, 2}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[13, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[7, 2], 3}, {
              Rational[13, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[11, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[5, 2], 3}, {
              Rational[11, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}}, {{3.25,
               2.566987298107781}, {3.5, 3}, {3.25, 3.433012701892219}, {2.75,
               3.433012701892219}, {2.5, 3}, {2.75, 2.566987298107781}}]],
           RegularPolygon[{3, 3}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[13, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[7, 2], 4}, {
              Rational[13, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[11, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[5, 2], 4}, {
              Rational[11, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}}, {{3.25,
               3.566987298107781}, {3.5, 4}, {3.25, 4.43301270189222}, {2.75, 
              4.43301270189222}, {2.5, 4}, {2.75, 3.566987298107781}}]],
           RegularPolygon[{3, 4}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[13, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[7, 2], 5}, {
              Rational[13, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[11, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[5, 2], 5}, {
              Rational[11, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}}, {{3.25,
               4.56698729810778}, {3.5, 5}, {3.25, 5.43301270189222}, {2.75, 
              5.43301270189222}, {2.5, 5}, {2.75, 4.56698729810778}}]],
           RegularPolygon[{3, 5}, 
            Rational[1, 2], 6]]}, {
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[17, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[9, 2], 1}, {
              Rational[17, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[15, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[7, 2], 1}, {
              Rational[15, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}}, {{4.25,
               0.5669872981077807}, {4.5, 1}, {4.25, 1.4330127018922192`}, {
              3.75, 1.4330127018922192`}, {3.5, 1}, {3.75, 
              0.5669872981077807}}]],
           RegularPolygon[{4, 1}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[17, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[9, 2], 2}, {
              Rational[17, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[15, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[7, 2], 2}, {
              Rational[15, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}}, {{4.25,
               1.5669872981077808`}, {4.5, 2}, {4.25, 2.433012701892219}, {
              3.75, 2.433012701892219}, {3.5, 2}, {3.75, 
              1.5669872981077808`}}]],
           RegularPolygon[{4, 2}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[17, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[9, 2], 3}, {
              Rational[17, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[15, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[7, 2], 3}, {
              Rational[15, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}}, {{4.25,
               2.566987298107781}, {4.5, 3}, {4.25, 3.433012701892219}, {3.75,
               3.433012701892219}, {3.5, 3}, {3.75, 2.566987298107781}}]],
           RegularPolygon[{4, 3}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[17, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[9, 2], 4}, {
              Rational[17, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[15, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[7, 2], 4}, {
              Rational[15, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}}, {{4.25,
               3.566987298107781}, {4.5, 4}, {4.25, 4.43301270189222}, {3.75, 
              4.43301270189222}, {3.5, 4}, {3.75, 3.566987298107781}}]],
           RegularPolygon[{4, 4}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[17, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[9, 2], 5}, {
              Rational[17, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[15, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[7, 2], 5}, {
              Rational[15, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}}, {{4.25,
               4.56698729810778}, {4.5, 5}, {4.25, 5.43301270189222}, {3.75, 
              5.43301270189222}, {3.5, 5}, {3.75, 4.56698729810778}}]],
           RegularPolygon[{4, 5}, 
            Rational[1, 2], 6]]}, {
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[21, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[11, 2], 1}, {
              Rational[21, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[19, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[9, 2], 1}, {
              Rational[19, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}}, {{5.25,
               0.5669872981077807}, {5.5, 1}, {5.25, 1.4330127018922192`}, {
              4.75, 1.4330127018922192`}, {4.5, 1}, {4.75, 
              0.5669872981077807}}]],
           RegularPolygon[{5, 1}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[21, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[11, 2], 2}, {
              Rational[21, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[19, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[9, 2], 2}, {
              Rational[19, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}}, {{5.25,
               1.5669872981077808`}, {5.5, 2}, {5.25, 2.433012701892219}, {
              4.75, 2.433012701892219}, {4.5, 2}, {4.75, 
              1.5669872981077808`}}]],
           RegularPolygon[{5, 2}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[21, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[11, 2], 3}, {
              Rational[21, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[19, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[9, 2], 3}, {
              Rational[19, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}}, {{5.25,
               2.566987298107781}, {5.5, 3}, {5.25, 3.433012701892219}, {4.75,
               3.433012701892219}, {4.5, 3}, {4.75, 2.566987298107781}}]],
           RegularPolygon[{5, 3}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[21, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[11, 2], 4}, {
              Rational[21, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[19, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[9, 2], 4}, {
              Rational[19, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}}, {{5.25,
               3.566987298107781}, {5.5, 4}, {5.25, 4.43301270189222}, {4.75, 
              4.43301270189222}, {4.5, 4}, {4.75, 3.566987298107781}}]],
           RegularPolygon[{5, 4}, 
            Rational[1, 2], 6]], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[21, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}, {
              Rational[11, 2], 5}, {
              Rational[21, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[19, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
              Rational[9, 2], 5}, {
              Rational[19, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}}, {{5.25,
               4.56698729810778}, {5.5, 5}, {5.25, 5.43301270189222}, {4.75, 
              5.43301270189222}, {4.5, 5}, {4.75, 4.56698729810778}}]],
           RegularPolygon[{5, 5}, 
            Rational[1, 2], 6]]}}]], "ExerciseOutput",ExpressionUUID->
       "90dce922-0c33-45b7-85d6-ad2156b86e25"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[5, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 2], 1}, {
                 Rational[5, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[1, 2], 1}, {
                 Rational[3, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                1.25, 0.5669872981077807}, {1.5, 1}, {1.25, 
                1.4330127018922192`}, {0.75, 1.4330127018922192`}, {0.5, 1}, {
                0.75, 0.5669872981077807}}]], 
             RegularPolygon[{1, 1}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[5, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 2], 2}, {
                 Rational[5, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[1, 2], 2}, {
                 Rational[3, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                1.25, 1.5669872981077808`}, {1.5, 2}, {1.25, 
                2.433012701892219}, {0.75, 2.433012701892219}, {0.5, 2}, {
                0.75, 1.5669872981077808`}}]], 
             RegularPolygon[{1, 2}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[5, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 2], 3}, {
                 Rational[5, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[1, 2], 3}, {
                 Rational[3, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                1.25, 2.566987298107781}, {1.5, 3}, {1.25, 
                3.433012701892219}, {0.75, 3.433012701892219}, {0.5, 3}, {
                0.75, 2.566987298107781}}]], 
             RegularPolygon[{1, 3}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[5, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 2], 4}, {
                 Rational[5, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[1, 2], 4}, {
                 Rational[3, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                1.25, 3.566987298107781}, {1.5, 4}, {1.25, 
                4.43301270189222}, {0.75, 4.43301270189222}, {0.5, 4}, {0.75, 
                3.566987298107781}}]], 
             RegularPolygon[{1, 4}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[5, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 2], 5}, {
                 Rational[5, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[1, 2], 5}, {
                 Rational[3, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                1.25, 4.56698729810778}, {1.5, 5}, {1.25, 5.43301270189222}, {
                0.75, 5.43301270189222}, {0.5, 5}, {0.75, 
                4.56698729810778}}]], 
             RegularPolygon[{1, 5}, 
              Rational[1, 2], 6]]}, {
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[9, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[5, 2], 1}, {
                 Rational[9, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 2], 1}, {
                 Rational[7, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                2.25, 0.5669872981077807}, {2.5, 1}, {2.25, 
                1.4330127018922192`}, {1.75, 1.4330127018922192`}, {1.5, 1}, {
                1.75, 0.5669872981077807}}]], 
             RegularPolygon[{2, 1}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[9, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[5, 2], 2}, {
                 Rational[9, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 2], 2}, {
                 Rational[7, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                2.25, 1.5669872981077808`}, {2.5, 2}, {2.25, 
                2.433012701892219}, {1.75, 2.433012701892219}, {1.5, 2}, {
                1.75, 1.5669872981077808`}}]], 
             RegularPolygon[{2, 2}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[9, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[5, 2], 3}, {
                 Rational[9, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 2], 3}, {
                 Rational[7, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                2.25, 2.566987298107781}, {2.5, 3}, {2.25, 
                3.433012701892219}, {1.75, 3.433012701892219}, {1.5, 3}, {
                1.75, 2.566987298107781}}]], 
             RegularPolygon[{2, 3}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[9, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[5, 2], 4}, {
                 Rational[9, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 2], 4}, {
                 Rational[7, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                2.25, 3.566987298107781}, {2.5, 4}, {2.25, 
                4.43301270189222}, {1.75, 4.43301270189222}, {1.5, 4}, {1.75, 
                3.566987298107781}}]], 
             RegularPolygon[{2, 4}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[9, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[5, 2], 5}, {
                 Rational[9, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[3, 2], 5}, {
                 Rational[7, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                2.25, 4.56698729810778}, {2.5, 5}, {2.25, 5.43301270189222}, {
                1.75, 5.43301270189222}, {1.5, 5}, {1.75, 
                4.56698729810778}}]], 
             RegularPolygon[{2, 5}, 
              Rational[1, 2], 6]]}, {
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[13, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 2], 1}, {
                 Rational[13, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[11, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[5, 2], 1}, {
                 Rational[11, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                3.25, 0.5669872981077807}, {3.5, 1}, {3.25, 
                1.4330127018922192`}, {2.75, 1.4330127018922192`}, {2.5, 1}, {
                2.75, 0.5669872981077807}}]], 
             RegularPolygon[{3, 1}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[13, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 2], 2}, {
                 Rational[13, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[11, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[5, 2], 2}, {
                 Rational[11, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                3.25, 1.5669872981077808`}, {3.5, 2}, {3.25, 
                2.433012701892219}, {2.75, 2.433012701892219}, {2.5, 2}, {
                2.75, 1.5669872981077808`}}]], 
             RegularPolygon[{3, 2}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[13, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 2], 3}, {
                 Rational[13, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[11, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[5, 2], 3}, {
                 Rational[11, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                3.25, 2.566987298107781}, {3.5, 3}, {3.25, 
                3.433012701892219}, {2.75, 3.433012701892219}, {2.5, 3}, {
                2.75, 2.566987298107781}}]], 
             RegularPolygon[{3, 3}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[13, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 2], 4}, {
                 Rational[13, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[11, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[5, 2], 4}, {
                 Rational[11, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                3.25, 3.566987298107781}, {3.5, 4}, {3.25, 
                4.43301270189222}, {2.75, 4.43301270189222}, {2.5, 4}, {2.75, 
                3.566987298107781}}]], 
             RegularPolygon[{3, 4}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[13, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 2], 5}, {
                 Rational[13, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[11, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[5, 2], 5}, {
                 Rational[11, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                3.25, 4.56698729810778}, {3.5, 5}, {3.25, 5.43301270189222}, {
                2.75, 5.43301270189222}, {2.5, 5}, {2.75, 
                4.56698729810778}}]], 
             RegularPolygon[{3, 5}, 
              Rational[1, 2], 6]]}, {
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[17, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[9, 2], 1}, {
                 Rational[17, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[15, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 2], 1}, {
                 Rational[15, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                4.25, 0.5669872981077807}, {4.5, 1}, {4.25, 
                1.4330127018922192`}, {3.75, 1.4330127018922192`}, {3.5, 1}, {
                3.75, 0.5669872981077807}}]], 
             RegularPolygon[{4, 1}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[17, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[9, 2], 2}, {
                 Rational[17, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[15, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 2], 2}, {
                 Rational[15, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                4.25, 1.5669872981077808`}, {4.5, 2}, {4.25, 
                2.433012701892219}, {3.75, 2.433012701892219}, {3.5, 2}, {
                3.75, 1.5669872981077808`}}]], 
             RegularPolygon[{4, 2}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[17, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[9, 2], 3}, {
                 Rational[17, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[15, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 2], 3}, {
                 Rational[15, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                4.25, 2.566987298107781}, {4.5, 3}, {4.25, 
                3.433012701892219}, {3.75, 3.433012701892219}, {3.5, 3}, {
                3.75, 2.566987298107781}}]], 
             RegularPolygon[{4, 3}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[17, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[9, 2], 4}, {
                 Rational[17, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[15, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 2], 4}, {
                 Rational[15, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                4.25, 3.566987298107781}, {4.5, 4}, {4.25, 
                4.43301270189222}, {3.75, 4.43301270189222}, {3.5, 4}, {3.75, 
                3.566987298107781}}]], 
             RegularPolygon[{4, 4}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[17, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[9, 2], 5}, {
                 Rational[17, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[15, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[7, 2], 5}, {
                 Rational[15, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                4.25, 4.56698729810778}, {4.5, 5}, {4.25, 5.43301270189222}, {
                3.75, 5.43301270189222}, {3.5, 5}, {3.75, 
                4.56698729810778}}]], 
             RegularPolygon[{4, 5}, 
              Rational[1, 2], 6]]}, {
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[21, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[11, 2], 1}, {
                 Rational[21, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[19, 4], 1 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[9, 2], 1}, {
                 Rational[19, 4], 1 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                5.25, 0.5669872981077807}, {5.5, 1}, {5.25, 
                1.4330127018922192`}, {4.75, 1.4330127018922192`}, {4.5, 1}, {
                4.75, 0.5669872981077807}}]], 
             RegularPolygon[{5, 1}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[21, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[11, 2], 2}, {
                 Rational[21, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[19, 4], 2 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[9, 2], 2}, {
                 Rational[19, 4], 2 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                5.25, 1.5669872981077808`}, {5.5, 2}, {5.25, 
                2.433012701892219}, {4.75, 2.433012701892219}, {4.5, 2}, {
                4.75, 1.5669872981077808`}}]], 
             RegularPolygon[{5, 2}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[21, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[11, 2], 3}, {
                 Rational[21, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[19, 4], 3 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[9, 2], 3}, {
                 Rational[19, 4], 3 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                5.25, 2.566987298107781}, {5.5, 3}, {5.25, 
                3.433012701892219}, {4.75, 3.433012701892219}, {4.5, 3}, {
                4.75, 2.566987298107781}}]], 
             RegularPolygon[{5, 3}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[21, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[11, 2], 4}, {
                 Rational[21, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[19, 4], 4 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[9, 2], 4}, {
                 Rational[19, 4], 4 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                5.25, 3.566987298107781}, {5.5, 4}, {5.25, 
                4.43301270189222}, {4.75, 4.43301270189222}, {4.5, 4}, {4.75, 
                3.566987298107781}}]], 
             RegularPolygon[{5, 4}, 
              Rational[1, 2], 6]], 
            InterpretationBox[
             PolygonBox[
              NCache[{{
                 Rational[21, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}, {
                 Rational[11, 2], 5}, {
                 Rational[21, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[19, 4], 5 + Rational[1, 4] 3^Rational[1, 2]}, {
                 Rational[9, 2], 5}, {
                 Rational[19, 4], 5 + Rational[-1, 4] 3^Rational[1, 2]}}, {{
                5.25, 4.56698729810778}, {5.5, 5}, {5.25, 5.43301270189222}, {
                4.75, 5.43301270189222}, {4.5, 5}, {4.75, 
                4.56698729810778}}]], 
             RegularPolygon[{5, 5}, 
              Rational[1, 2], 6]]}}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"29831608-f162-48fc-9c87-8eca1de7c223"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line in 3D that goes through 50 random points with integer \
coordinates randomly chosen up to 50.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "14.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"f85f3742-6de3-4bca-aea5-071dba6736ff"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       Graphics3DBox[
        Line3DBox[{{47, 9, 2}, {42, 9, 19}, {20, 2, 8}, {0, 36, 10}, {41, 1, 
         4}, {38, 9, 2}, {4, 32, 35}, {3, 2, 2}, {13, 18, 27}, {40, 38, 7}, {
         16, 16, 4}, {48, 30, 12}, {26, 28, 28}, {27, 4, 25}, {28, 4, 35}, {
         10, 20, 26}, {47, 2, 7}, {0, 15, 1}, {3, 13, 6}, {45, 30, 2}, {17, 
         45, 42}, {15, 27, 40}, {5, 39, 20}, {30, 17, 21}, {23, 16, 47}, {42, 
         34, 2}, {8, 44, 17}, {11, 15, 43}, {24, 31, 10}, {3, 16, 23}, {36, 
         10, 7}, {21, 16, 4}, {46, 42, 16}, {26, 49, 30}, {43, 16, 7}, {8, 37,
          2}, {9, 11, 16}, {41, 10, 11}, {32, 42, 22}, {38, 3, 33}, {1, 28, 
         27}, {2, 23, 33}, {31, 35, 21}, {21, 2, 13}, {31, 10, 26}, {44, 11, 
         3}, {2, 24, 5}, {45, 23, 21}, {35, 43, 38}, {22, 39, 0}}],
        ImageSize->{215.51171875, Automatic},
        ViewPoint->{1.3, -2.4, 2.},
        ViewVertical->{0., 0., 1.021276595744681}]], "ExerciseOutput",
       ExpressionUUID->"2a907f34-ff9c-47f1-89a9-b3104051b178"],
      Apply[TextCell, 
       Cell[
        BoxData[
         Graphics3DBox[
          
          Line3DBox[{{47, 9, 2}, {42, 9, 19}, {20, 2, 8}, {0, 36, 10}, {41, 1,
            4}, {38, 9, 2}, {4, 32, 35}, {3, 2, 2}, {13, 18, 27}, {40, 38, 
           7}, {16, 16, 4}, {48, 30, 12}, {26, 28, 28}, {27, 4, 25}, {28, 4, 
           35}, {10, 20, 26}, {47, 2, 7}, {0, 15, 1}, {3, 13, 6}, {45, 30, 
           2}, {17, 45, 42}, {15, 27, 40}, {5, 39, 20}, {30, 17, 21}, {23, 16,
            47}, {42, 34, 2}, {8, 44, 17}, {11, 15, 43}, {24, 31, 10}, {3, 16,
            23}, {36, 10, 7}, {21, 16, 4}, {46, 42, 16}, {26, 49, 30}, {43, 
           16, 7}, {8, 37, 2}, {9, 11, 16}, {41, 10, 11}, {32, 42, 22}, {38, 
           3, 33}, {1, 28, 27}, {2, 23, 33}, {31, 35, 21}, {21, 2, 13}, {31, 
           10, 26}, {44, 11, 3}, {2, 24, 5}, {45, 23, 21}, {35, 43, 38}, {22, 
           39, 0}}], ImageSize -> {215.51171875, Automatic}, 
          ViewPoint -> {1.3, -2.4, 2.}, 
          ViewVertical -> {0., 0., 1.021276595744681}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fe6eda41-357a-4541-a10b-20bf4f919051"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to create an ",
 Cell[BoxData[
  RowBox[{"n", "\[Times]", "n"}]], "InlineCode",ExpressionUUID->
  "c78ca033-ae53-4d94-bfcc-e8e085c41b75"],
 " regular grid of points at integer positions, with ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"217d0fe9-8d05-454c-8c6f-d96d032ac32d"],
 " going from 5 to 20.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+14.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a7e82184-0b2c-4632-ac14-c097897cd6c2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 12, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 5, 20, 1}}, Typeset`size$$ = {
          240., {117., 123.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`n$79147$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 5}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$79147$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            Graphics[
              Table[
               
               Point[{$CellContext`x, $CellContext`y}], {$CellContext`x, \
$CellContext`n$$}, {$CellContext`y, $CellContext`n$$}]], 
            "Specifications" :> {{$CellContext`n$$, 5, 20, 1}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{285., {164., 170.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "89397852-f43c-436b-aeef-a8bb03ae4de5"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 12, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 5, 20, 1}}, 
             Typeset`size$$ = {240., {117., 123.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$79147$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 5}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$79147$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Graphics[
                Table[
                 
                 Point[{$CellContext`x, $CellContext`y}], {$CellContext`x, \
$CellContext`n$$}, {$CellContext`y, $CellContext`n$$}]], 
              "Specifications" :> {{$CellContext`n$$, 5, 20, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {291., {165., 172.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7b6f7475-644f-46eb-a1dc-1ed63a183b80"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Place 30 radius-1 circles with random colors at random integer coordinates \
up to 10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+14.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b9c09ab7-71a6-4bba-9a70-965c053ca15c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {RGBColor[
          0.4381671644939775, 0.8523339001494179, 0.6594062168519887], 
          CircleBox[{10, 6}]}, 
         {RGBColor[0.557678296449664, 0.4406777434731257, 0.2679640887455814],
           CircleBox[{6, 8}]}, 
         {RGBColor[0.274635846491996, 0.3855879808329268, 0.5608532611429768],
           CircleBox[{9, 9}]}, 
         {RGBColor[
          0.960079766985054, 0.9252516526916523, 0.17160910169901689`], 
          CircleBox[{5, 5}]}, 
         {RGBColor[
          0.1828065473323326, 0.3678231625314581, 0.10395644128778092`], 
          CircleBox[{10, 4}]}, 
         {RGBColor[
          0.07799956813900932, 0.33431815464679815`, 0.4354286650375141], 
          CircleBox[{1, 10}]}, 
         {RGBColor[
          0.46219554576608024`, 0.3647520992009161, 0.7393685610729215], 
          CircleBox[{1, 9}]}, 
         {RGBColor[
          0.7235582760501447, 0.1912077308875093, 0.20246765466129557`], 
          CircleBox[{1, 8}]}, 
         {RGBColor[
          0.5929354312505342, 0.5331067286141631, 0.5644821908730788], 
          CircleBox[{9, 0}]}, 
         {RGBColor[
          0.5204341218251833, 0.9554628754134524, 0.3480929153915684], 
          CircleBox[{9, 0}]}, 
         {RGBColor[
          0.5791974672664502, 0.6640227093591884, 0.8017833849126164], 
          CircleBox[{6, 9}]}, 
         {RGBColor[
          0.38578193136071315`, 0.9193096959313143, 0.7088170967260683], 
          CircleBox[{4, 3}]}, 
         {RGBColor[
          0.5626931664568939, 0.25342317135843784`, 0.09156023877790398], 
          CircleBox[{7, 10}]}, 
         {RGBColor[
          0.39194234630228375`, 0.3344185236158441, 0.1848284191981142], 
          CircleBox[{0, 4}]}, 
         {RGBColor[
          0.7787813590398176, 0.019414682410534567`, 0.2510726826817322], 
          CircleBox[{10, 1}]}, 
         {RGBColor[
          0.2689642847979823, 0.8164419603928181, 0.5739297056451302], 
          CircleBox[{3, 0}]}, 
         {RGBColor[
          0.08351779916835067, 0.6163722691536082, 0.0626608970675564], 
          CircleBox[{0, 4}]}, 
         {RGBColor[
          0.6266857573407407, 0.012027772808860693`, 0.14477428884331967`], 
          CircleBox[{10, 1}]}, 
         {RGBColor[
          0.12718316792619655`, 0.7030262294724596, 0.04619869878337313], 
          CircleBox[{8, 8}]}, 
         {RGBColor[
          0.15361979353604283`, 0.6612416663827156, 0.1656266515893121], 
          CircleBox[{0, 6}]}, 
         {RGBColor[0.1185486705514307, 0.7706136523743834, 0.295453739431055],
           CircleBox[{10, 1}]}, 
         {RGBColor[
          0.16064379172416587`, 0.2150260077598709, 0.22889247556333703`], 
          CircleBox[{8, 9}]}, 
         {RGBColor[
          0.9190833774422735, 0.9745375679677619, 0.5279161834531996], 
          CircleBox[{4, 0}]}, 
         {RGBColor[
          0.2581497966938173, 0.7407284830772913, 0.42931418035184166`], 
          CircleBox[{1, 10}]}, 
         {RGBColor[0.5469557192641139, 0.927104184876099, 0.2722513736463048],
           CircleBox[{4, 6}]}, 
         {RGBColor[
          0.8045322605423211, 0.05368262579790528, 0.3106613535598324], 
          CircleBox[{6, 8}]}, 
         {RGBColor[
          0.4915523857484987, 0.8650234465956166, 0.40023193439848304`], 
          CircleBox[{0, 5}]}, 
         {RGBColor[0.57494861281062, 0.4307139111679321, 0.3722588258215862], 
          CircleBox[{5, 8}]}, 
         {RGBColor[
          0.1499681157537911, 0.37760052453168713`, 0.5595482193042007], 
          CircleBox[{4, 7}]}, 
         {RGBColor[
          0.5389099581918786, 0.5209910889725693, 0.5247580408328465], 
          CircleBox[{7, 7}]}}]], "ExerciseOutput",ExpressionUUID->
       "d37abd44-a310-422b-b912-b636a674f1fe"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             RGBColor[
             0.4381671644939775, 0.8523339001494179, 0.6594062168519887], 
             CircleBox[{10, 6}]}}, {{
             RGBColor[
             0.557678296449664, 0.4406777434731257, 0.2679640887455814], 
             CircleBox[{6, 8}]}}, {{
             RGBColor[
             0.274635846491996, 0.3855879808329268, 0.5608532611429768], 
             CircleBox[{9, 9}]}}, {{
             RGBColor[
             0.960079766985054, 0.9252516526916523, 0.17160910169901689`], 
             CircleBox[{5, 5}]}}, {{
             RGBColor[
             0.1828065473323326, 0.3678231625314581, 0.10395644128778092`], 
             CircleBox[{10, 4}]}}, {{
             RGBColor[
             0.07799956813900932, 0.33431815464679815`, 0.4354286650375141], 
             CircleBox[{1, 10}]}}, {{
             RGBColor[
             0.46219554576608024`, 0.3647520992009161, 0.7393685610729215], 
             CircleBox[{1, 9}]}}, {{
             RGBColor[
             0.7235582760501447, 0.1912077308875093, 0.20246765466129557`], 
             CircleBox[{1, 8}]}}, {{
             RGBColor[
             0.5929354312505342, 0.5331067286141631, 0.5644821908730788], 
             CircleBox[{9, 0}]}}, {{
             RGBColor[
             0.5204341218251833, 0.9554628754134524, 0.3480929153915684], 
             CircleBox[{9, 0}]}}, {{
             RGBColor[
             0.5791974672664502, 0.6640227093591884, 0.8017833849126164], 
             CircleBox[{6, 9}]}}, {{
             RGBColor[
             0.38578193136071315`, 0.9193096959313143, 0.7088170967260683], 
             CircleBox[{4, 3}]}}, {{
             RGBColor[
             0.5626931664568939, 0.25342317135843784`, 0.09156023877790398], 
             CircleBox[{7, 10}]}}, {{
             RGBColor[
             0.39194234630228375`, 0.3344185236158441, 0.1848284191981142], 
             CircleBox[{0, 4}]}}, {{
             RGBColor[
             0.7787813590398176, 0.019414682410534567`, 0.2510726826817322], 
             CircleBox[{10, 1}]}}, {{
             RGBColor[
             0.2689642847979823, 0.8164419603928181, 0.5739297056451302], 
             CircleBox[{3, 0}]}}, {{
             RGBColor[
             0.08351779916835067, 0.6163722691536082, 0.0626608970675564], 
             CircleBox[{0, 4}]}}, {{
             RGBColor[
             0.6266857573407407, 0.012027772808860693`, 0.14477428884331967`], 
             CircleBox[{10, 1}]}}, {{
             RGBColor[
             0.12718316792619655`, 0.7030262294724596, 0.04619869878337313], 
             CircleBox[{8, 8}]}}, {{
             RGBColor[
             0.15361979353604283`, 0.6612416663827156, 0.1656266515893121], 
             CircleBox[{0, 6}]}}, {{
             RGBColor[
             0.1185486705514307, 0.7706136523743834, 0.295453739431055], 
             CircleBox[{10, 1}]}}, {{
             RGBColor[
             0.16064379172416587`, 0.2150260077598709, 0.22889247556333703`], 
             
             CircleBox[{8, 9}]}}, {{
             RGBColor[
             0.9190833774422735, 0.9745375679677619, 0.5279161834531996], 
             CircleBox[{4, 0}]}}, {{
             RGBColor[
             0.2581497966938173, 0.7407284830772913, 0.42931418035184166`], 
             CircleBox[{1, 10}]}}, {{
             RGBColor[
             0.5469557192641139, 0.927104184876099, 0.2722513736463048], 
             CircleBox[{4, 6}]}}, {{
             RGBColor[
             0.8045322605423211, 0.05368262579790528, 0.3106613535598324], 
             CircleBox[{6, 8}]}}, {{
             RGBColor[
             0.4915523857484987, 0.8650234465956166, 0.40023193439848304`], 
             CircleBox[{0, 5}]}}, {{
             RGBColor[
             0.57494861281062, 0.4307139111679321, 0.3722588258215862], 
             CircleBox[{5, 8}]}}, {{
             RGBColor[
             0.1499681157537911, 0.37760052453168713`, 0.5595482193042007], 
             CircleBox[{4, 7}]}}, {{
             RGBColor[
             0.5389099581918786, 0.5209910889725693, 0.5247580408328465], 
             CircleBox[{7, 7}]}}}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"10d69720-b240-492f-9a2a-d753a2bc2ba8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Display 100 polygons with side length 10, opacity .5, and random choices of \
colors, sides between 3 and 8, and integer coordinates up to 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+14.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d6b87435-ecd2-47c3-bad6-76c49c6d73b4"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {RGBColor[
          0.3396745258731211, 0.8270683200943605, 0.48626642727457026`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{19 + 5 3^Rational[1, 2], 87}, {19, 102}, {
              19 - 5 3^Rational[1, 2], 87}}, {{27.660254037844386`, 87}, {19, 
              102}, {10.339745962155614`, 87}}]],
           RegularPolygon[{19, 92}, 10, 3]]}, 
         {RGBColor[
          0.7065957198785975, 0.7790613773327952, 0.7793200802202469], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              60 + 10 Sin[Rational[1, 8] Pi], 22 - 10 
               Cos[Rational[1, 8] Pi]}, {
              60 + 10 Cos[Rational[1, 8] Pi], 22 - 10 
               Sin[Rational[1, 8] Pi]}, {
              60 + 10 Cos[Rational[1, 8] Pi], 22 + 
               10 Sin[Rational[1, 8] Pi]}, {
              60 + 10 Sin[Rational[1, 8] Pi], 22 + 
               10 Cos[Rational[1, 8] Pi]}, {
              60 - 10 Sin[Rational[1, 8] Pi], 22 + 
               10 Cos[Rational[1, 8] Pi]}, {
              60 - 10 Cos[Rational[1, 8] Pi], 22 + 
               10 Sin[Rational[1, 8] Pi]}, {
              60 - 10 Cos[Rational[1, 8] Pi], 22 - 10 
               Sin[Rational[1, 8] Pi]}, {
              60 - 10 Sin[Rational[1, 8] Pi], 22 - 10 
               Cos[Rational[1, 8] Pi]}}, {{63.8268343236509, 
             12.761204674887132`}, {69.23879532511287, 18.1731656763491}, {
             69.23879532511287, 25.8268343236509}, {63.8268343236509, 
             31.238795325112868`}, {56.1731656763491, 31.238795325112868`}, {
             50.76120467488713, 25.8268343236509}, {50.76120467488713, 
             18.1731656763491}, {56.1731656763491, 12.761204674887132`}}]],
           RegularPolygon[{60, 22}, 10, 8]]}, 
         {RGBColor[
          0.08516952371737196, 0.2533713349882585, 0.41701379410105055`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              34 + 10 Sin[Rational[1, 7] Pi], 73 - 10 
               Cos[Rational[1, 7] Pi]}, {
              34 + 10 Cos[Rational[1, 14] Pi], 73 - 10 
               Sin[Rational[1, 14] Pi]}, {
              34 + 10 Cos[Rational[3, 14] Pi], 73 + 
               10 Sin[Rational[3, 14] Pi]}, {34, 83}, {
              34 - 10 Cos[Rational[3, 14] Pi], 73 + 
               10 Sin[Rational[3, 14] Pi]}, {
              34 - 10 Cos[Rational[1, 14] Pi], 73 - 10 
               Sin[Rational[1, 14] Pi]}, {
              34 - 10 Sin[Rational[1, 7] Pi], 73 - 10 
               Cos[Rational[1, 7] Pi]}}, {{38.33883739117558, 
              63.990311320975806`}, {43.74927912181823, 70.77479066043685}, {
              41.8183148246803, 79.23489801858733}, {34, 83}, {
              26.1816851753197, 79.23489801858733}, {24.250720878181763`, 
              70.77479066043685}, {29.66116260882442, 63.990311320975806`}}]],
           
           RegularPolygon[{34, 73}, 10, 7]]}, 
         {RGBColor[
          0.17032155069250687`, 0.8054895630938566, 0.011000963315223267`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{23 + 5 2^Rational[1, 2], 73 - 5 2^Rational[1, 2]}, {
              23 + 5 2^Rational[1, 2], 73 + 5 2^Rational[1, 2]}, {
              23 - 5 2^Rational[1, 2], 73 + 5 2^Rational[1, 2]}, {
              23 - 5 2^Rational[1, 2], 73 - 5 2^Rational[1, 2]}}, {{
             30.071067811865476`, 65.92893218813452}, {30.071067811865476`, 
             80.07106781186548}, {15.928932188134524`, 80.07106781186548}, {
             15.928932188134524`, 65.92893218813452}}]],
           RegularPolygon[{23, 73}, 10, 4]]}, 
         {RGBColor[
          0.9179751122780282, 0.10812814496602963`, 0.6381906374709023], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              94 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 84 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              94 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 84 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {94, 94}, {
              94 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 84 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              94 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 84 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{99.87785252292473, 
              75.90983005625053}, {103.51056516295154`, 87.09016994374947}, {
              94, 94}, {84.48943483704846, 87.09016994374947}, {
              88.12214747707527, 75.90983005625053}}]],
           RegularPolygon[{94, 84}, 10, 5]]}, 
         {RGBColor[
          0.07008661207818534, 0.4213510508370366, 0.321581311413204], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{50, 93 - 5 3^Rational[1, 2]}, {55, 93}, {
              50, 93 + 5 3^Rational[1, 2]}, {40, 93 + 5 3^Rational[1, 2]}, {
              35, 93}, {40, 93 - 5 3^Rational[1, 2]}}, {{
              50, 84.33974596215562}, {55, 93}, {50, 101.66025403784438`}, {
              40, 101.66025403784438`}, {35, 93}, {40, 84.33974596215562}}]],
           RegularPolygon[{45, 93}, 10, 6]]}, 
         {RGBColor[
          0.48491964991746106`, 0.7634448484660599, 0.2503350801689681], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{4 + 5 3^Rational[1, 2], 80}, {4, 95}, {
              4 - 5 3^Rational[1, 2], 80}}, {{12.660254037844386`, 80}, {4, 
              95}, {-4.6602540378443855`, 80}}]],
           RegularPolygon[{4, 85}, 10, 3]]}, 
         {RGBColor[
          0.29798126028877725`, 0.3071424017557691, 0.07969641141077011], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{37 + 5 3^Rational[1, 2], -1}, {37, 14}, {
              37 - 5 3^Rational[1, 2], -1}}, {{45.66025403784438, -1}, {37, 
              14}, {28.339745962155614`, -1}}]],
           RegularPolygon[{37, 4}, 10, 3]]}, 
         {RGBColor[
          0.3917369142802476, 0.6722133734308067, 0.37927507001132854`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              34 + 10 Sin[Rational[1, 7] Pi], 51 - 10 
               Cos[Rational[1, 7] Pi]}, {
              34 + 10 Cos[Rational[1, 14] Pi], 51 - 10 
               Sin[Rational[1, 14] Pi]}, {
              34 + 10 Cos[Rational[3, 14] Pi], 51 + 
               10 Sin[Rational[3, 14] Pi]}, {34, 61}, {
              34 - 10 Cos[Rational[3, 14] Pi], 51 + 
               10 Sin[Rational[3, 14] Pi]}, {
              34 - 10 Cos[Rational[1, 14] Pi], 51 - 10 
               Sin[Rational[1, 14] Pi]}, {
              34 - 10 Sin[Rational[1, 7] Pi], 51 - 10 
               Cos[Rational[1, 7] Pi]}}, {{38.33883739117558, 
              41.990311320975806`}, {43.74927912181823, 48.77479066043686}, {
              41.8183148246803, 57.23489801858734}, {34, 61}, {
              26.1816851753197, 57.23489801858734}, {24.250720878181763`, 
              48.77479066043686}, {29.66116260882442, 41.990311320975806`}}]],
           
           RegularPolygon[{34, 51}, 10, 7]]}, 
         {RGBColor[
          0.4845716900583088, 0.11457208869874025`, 0.22537050318895058`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              55 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 7 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              55 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 7 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {55, 17}, {
              55 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 7 + Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              55 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 7 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
              60.877852522924734`, -1.0901699437494745`}, {64.51056516295154, 
              10.090169943749475`}, {55, 17}, {45.489434837048464`, 
              10.090169943749475`}, {
              49.122147477075266`, -1.0901699437494745`}}]],
           RegularPolygon[{55, 7}, 10, 5]]}, 
         {RGBColor[
          0.040545690086605246`, 0.6914920096842319, 0.9333148707958092], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              24 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 20 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              24 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 20 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {24, 30}, {
              24 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 20 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              24 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 20 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
              29.877852522924734`, 11.909830056250525`}, {33.510565162951536`,
               23.090169943749473`}, {24, 30}, {14.489434837048465`, 
              23.090169943749473`}, {18.122147477075266`, 
              11.909830056250525`}}]],
           RegularPolygon[{24, 20}, 10, 5]]}, 
         {RGBColor[
          0.19908731919587086`, 0.008564856736899662, 0.6760074959663931], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              26 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 96 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              26 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 96 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {26, 106}, {
              26 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 96 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              26 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 96 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
              31.877852522924734`, 87.90983005625053}, {35.510565162951536`, 
              99.09016994374947}, {26, 106}, {16.489434837048464`, 
              99.09016994374947}, {20.122147477075266`, 87.90983005625053}}]],
           
           RegularPolygon[{26, 96}, 10, 5]]}, 
         {RGBColor[
          0.7013115011946318, 0.8850821847262835, 0.5324305394846776], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{5, 93 - 5 3^Rational[1, 2]}, {10, 93}, {
              5, 93 + 5 3^Rational[1, 2]}, {-5, 93 + 
               5 3^Rational[1, 2]}, {-10, 
              93}, {-5, 93 - 5 3^Rational[1, 2]}}, {{5, 84.33974596215562}, {
              10, 93}, {
              5, 101.66025403784438`}, {-5, 101.66025403784438`}, {-10, 
              93}, {-5, 84.33974596215562}}]],
           RegularPolygon[{0, 93}, 10, 6]]}, 
         {RGBColor[
          0.7412998854751585, 0.5023068276375928, 0.3259873718510353], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              48 + 10 Sin[Rational[1, 8] Pi], 37 - 10 
               Cos[Rational[1, 8] Pi]}, {
              48 + 10 Cos[Rational[1, 8] Pi], 37 - 10 
               Sin[Rational[1, 8] Pi]}, {
              48 + 10 Cos[Rational[1, 8] Pi], 37 + 
               10 Sin[Rational[1, 8] Pi]}, {
              48 + 10 Sin[Rational[1, 8] Pi], 37 + 
               10 Cos[Rational[1, 8] Pi]}, {
              48 - 10 Sin[Rational[1, 8] Pi], 37 + 
               10 Cos[Rational[1, 8] Pi]}, {
              48 - 10 Cos[Rational[1, 8] Pi], 37 + 
               10 Sin[Rational[1, 8] Pi]}, {
              48 - 10 Cos[Rational[1, 8] Pi], 37 - 10 
               Sin[Rational[1, 8] Pi]}, {
              48 - 10 Sin[Rational[1, 8] Pi], 37 - 10 
               Cos[Rational[1, 8] Pi]}}, {{51.8268343236509, 
             27.761204674887132`}, {57.23879532511287, 33.1731656763491}, {
             57.23879532511287, 40.8268343236509}, {51.8268343236509, 
             46.23879532511287}, {44.1731656763491, 46.23879532511287}, {
             38.76120467488713, 40.8268343236509}, {38.76120467488713, 
             33.1731656763491}, {44.1731656763491, 27.761204674887132`}}]],
           RegularPolygon[{48, 37}, 10, 8]]}, 
         {RGBColor[
          0.4082644326160796, 0.5064692825154098, 0.5359906665273428], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              21 + 10 Sin[Rational[1, 8] Pi], 56 - 10 
               Cos[Rational[1, 8] Pi]}, {
              21 + 10 Cos[Rational[1, 8] Pi], 56 - 10 
               Sin[Rational[1, 8] Pi]}, {
              21 + 10 Cos[Rational[1, 8] Pi], 56 + 
               10 Sin[Rational[1, 8] Pi]}, {
              21 + 10 Sin[Rational[1, 8] Pi], 56 + 
               10 Cos[Rational[1, 8] Pi]}, {
              21 - 10 Sin[Rational[1, 8] Pi], 56 + 
               10 Cos[Rational[1, 8] Pi]}, {
              21 - 10 Cos[Rational[1, 8] Pi], 56 + 
               10 Sin[Rational[1, 8] Pi]}, {
              21 - 10 Cos[Rational[1, 8] Pi], 56 - 10 
               Sin[Rational[1, 8] Pi]}, {
              21 - 10 Sin[Rational[1, 8] Pi], 56 - 10 
               Cos[Rational[1, 8] Pi]}}, {{24.8268343236509, 
             46.76120467488713}, {30.238795325112868`, 52.1731656763491}, {
             30.238795325112868`, 59.8268343236509}, {24.8268343236509, 
             65.23879532511287}, {17.1731656763491, 65.23879532511287}, {
             11.761204674887132`, 59.8268343236509}, {11.761204674887132`, 
             52.1731656763491}, {17.1731656763491, 46.76120467488713}}]],
           RegularPolygon[{21, 56}, 10, 8]]}, 
         {RGBColor[
          0.48951802645519327`, 0.041240982521276504`, 0.6304189890016287], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              29 + 10 Sin[Rational[1, 7] Pi], 11 - 10 
               Cos[Rational[1, 7] Pi]}, {
              29 + 10 Cos[Rational[1, 14] Pi], 11 - 10 
               Sin[Rational[1, 14] Pi]}, {
              29 + 10 Cos[Rational[3, 14] Pi], 11 + 
               10 Sin[Rational[3, 14] Pi]}, {29, 21}, {
              29 - 10 Cos[Rational[3, 14] Pi], 11 + 
               10 Sin[Rational[3, 14] Pi]}, {
              29 - 10 Cos[Rational[1, 14] Pi], 11 - 10 
               Sin[Rational[1, 14] Pi]}, {
              29 - 10 Sin[Rational[1, 7] Pi], 11 - 10 
               Cos[Rational[1, 7] Pi]}}, {{33.33883739117558, 
              1.9903113209758079`}, {38.74927912181823, 8.774790660436857}, {
              36.8183148246803, 17.234898018587334`}, {29, 21}, {
              21.1816851753197, 17.234898018587334`}, {19.250720878181763`, 
              8.774790660436857}, {24.66116260882442, 1.9903113209758079`}}]],
           
           RegularPolygon[{29, 11}, 10, 7]]}, 
         {RGBColor[
          0.8663949967194648, 0.9638818220691363, 0.017232945051648185`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              51 + 10 Sin[Rational[1, 7] Pi], 11 - 10 
               Cos[Rational[1, 7] Pi]}, {
              51 + 10 Cos[Rational[1, 14] Pi], 11 - 10 
               Sin[Rational[1, 14] Pi]}, {
              51 + 10 Cos[Rational[3, 14] Pi], 11 + 
               10 Sin[Rational[3, 14] Pi]}, {51, 21}, {
              51 - 10 Cos[Rational[3, 14] Pi], 11 + 
               10 Sin[Rational[3, 14] Pi]}, {
              51 - 10 Cos[Rational[1, 14] Pi], 11 - 10 
               Sin[Rational[1, 14] Pi]}, {
              51 - 10 Sin[Rational[1, 7] Pi], 11 - 10 
               Cos[Rational[1, 7] Pi]}}, {{55.33883739117558, 
              1.9903113209758079`}, {60.74927912181823, 8.774790660436857}, {
              58.8183148246803, 17.234898018587334`}, {51, 21}, {
              43.1816851753197, 17.234898018587334`}, {41.25072087818177, 
              8.774790660436857}, {46.66116260882442, 1.9903113209758079`}}]],
           
           RegularPolygon[{51, 11}, 10, 7]]}, 
         {RGBColor[
          0.6786867928076816, 0.8658020122195118, 0.30686289709463077`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              52 + 10 Sin[Rational[1, 7] Pi], 11 - 10 
               Cos[Rational[1, 7] Pi]}, {
              52 + 10 Cos[Rational[1, 14] Pi], 11 - 10 
               Sin[Rational[1, 14] Pi]}, {
              52 + 10 Cos[Rational[3, 14] Pi], 11 + 
               10 Sin[Rational[3, 14] Pi]}, {52, 21}, {
              52 - 10 Cos[Rational[3, 14] Pi], 11 + 
               10 Sin[Rational[3, 14] Pi]}, {
              52 - 10 Cos[Rational[1, 14] Pi], 11 - 10 
               Sin[Rational[1, 14] Pi]}, {
              52 - 10 Sin[Rational[1, 7] Pi], 11 - 10 
               Cos[Rational[1, 7] Pi]}}, {{56.33883739117558, 
              1.9903113209758079`}, {61.74927912181823, 8.774790660436857}, {
              59.8183148246803, 17.234898018587334`}, {52, 21}, {
              44.1816851753197, 17.234898018587334`}, {42.25072087818177, 
              8.774790660436857}, {47.66116260882442, 1.9903113209758079`}}]],
           
           RegularPolygon[{52, 11}, 10, 7]]}, 
         {RGBColor[
          0.3258776865462165, 0.16832512679921474`, 0.06877407866586127], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{76 + 5 3^Rational[1, 2], 73}, {76, 88}, {
              76 - 5 3^Rational[1, 2], 73}}, {{84.66025403784438, 73}, {76, 
              88}, {67.33974596215562, 73}}]],
           RegularPolygon[{76, 78}, 10, 3]]}, 
         {RGBColor[
          0.3186940673345855, 0.27435200048969977`, 0.5901295067300902], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{53 + 5 3^Rational[1, 2], 87}, {53, 102}, {
              53 - 5 3^Rational[1, 2], 87}}, {{61.66025403784438, 87}, {53, 
              102}, {44.33974596215562, 87}}]],
           RegularPolygon[{53, 92}, 10, 3]]}, 
         {RGBColor[
          0.12351011670731449`, 0.9636832470999681, 0.26144293325161105`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              74 + 10 Sin[Rational[1, 8] Pi], 24 - 10 
               Cos[Rational[1, 8] Pi]}, {
              74 + 10 Cos[Rational[1, 8] Pi], 24 - 10 
               Sin[Rational[1, 8] Pi]}, {
              74 + 10 Cos[Rational[1, 8] Pi], 24 + 
               10 Sin[Rational[1, 8] Pi]}, {
              74 + 10 Sin[Rational[1, 8] Pi], 24 + 
               10 Cos[Rational[1, 8] Pi]}, {
              74 - 10 Sin[Rational[1, 8] Pi], 24 + 
               10 Cos[Rational[1, 8] Pi]}, {
              74 - 10 Cos[Rational[1, 8] Pi], 24 + 
               10 Sin[Rational[1, 8] Pi]}, {
              74 - 10 Cos[Rational[1, 8] Pi], 24 - 10 
               Sin[Rational[1, 8] Pi]}, {
              74 - 10 Sin[Rational[1, 8] Pi], 24 - 10 
               Cos[Rational[1, 8] Pi]}}, {{77.8268343236509, 
             14.761204674887132`}, {83.23879532511287, 20.1731656763491}, {
             83.23879532511287, 27.8268343236509}, {77.8268343236509, 
             33.23879532511287}, {70.1731656763491, 33.23879532511287}, {
             64.76120467488713, 27.8268343236509}, {64.76120467488713, 
             20.1731656763491}, {70.1731656763491, 14.761204674887132`}}]],
           RegularPolygon[{74, 24}, 10, 8]]}, 
         {RGBColor[
          0.1487583577118634, 0.8176924720879759, 0.9148609028706269], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{29 + 5 3^Rational[1, 2], 59}, {29, 74}, {
              29 - 5 3^Rational[1, 2], 59}}, {{37.66025403784438, 59}, {29, 
              74}, {20.339745962155614`, 59}}]],
           RegularPolygon[{29, 64}, 10, 3]]}, 
         {RGBColor[
          0.9835414972086658, 0.9252127249623048, 0.9572565471557801], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{52, 44 - 5 3^Rational[1, 2]}, {57, 44}, {
              52, 44 + 5 3^Rational[1, 2]}, {42, 44 + 5 3^Rational[1, 2]}, {
              37, 44}, {42, 44 - 5 3^Rational[1, 2]}}, {{
              52, 35.33974596215562}, {57, 44}, {52, 52.66025403784438}, {
              42, 52.66025403784438}, {37, 44}, {42, 35.33974596215562}}]],
           RegularPolygon[{47, 44}, 10, 6]]}, 
         {RGBColor[
          0.08933232655327306, 0.38449881481669235`, 0.8501437293722958], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              3 + 10 Sin[Rational[1, 8] Pi], 51 - 10 
               Cos[Rational[1, 8] Pi]}, {
              3 + 10 Cos[Rational[1, 8] Pi], 51 - 10 
               Sin[Rational[1, 8] Pi]}, {
              3 + 10 Cos[Rational[1, 8] Pi], 51 + 
               10 Sin[Rational[1, 8] Pi]}, {
              3 + 10 Sin[Rational[1, 8] Pi], 51 + 
               10 Cos[Rational[1, 8] Pi]}, {
              3 - 10 Sin[Rational[1, 8] Pi], 51 + 
               10 Cos[Rational[1, 8] Pi]}, {
              3 - 10 Cos[Rational[1, 8] Pi], 51 + 
               10 Sin[Rational[1, 8] Pi]}, {
              3 - 10 Cos[Rational[1, 8] Pi], 51 - 10 
               Sin[Rational[1, 8] Pi]}, {
              3 - 10 Sin[Rational[1, 8] Pi], 51 - 10 
               Cos[Rational[1, 8] Pi]}}, {{6.826834323650898, 
             41.76120467488713}, {12.238795325112868`, 47.1731656763491}, {
             12.238795325112868`, 54.8268343236509}, {6.826834323650898, 
             60.23879532511287}, {-0.8268343236508979, 
             60.23879532511287}, {-6.238795325112868, 
             54.8268343236509}, {-6.238795325112868, 
             47.1731656763491}, {-0.8268343236508979, 41.76120467488713}}]],
           RegularPolygon[{3, 51}, 10, 8]]}, 
         {RGBColor[
          0.5160868296166465, 0.3093904250098589, 0.39961009054766206`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              89 + 10 Sin[Rational[1, 8] Pi], 83 - 10 
               Cos[Rational[1, 8] Pi]}, {
              89 + 10 Cos[Rational[1, 8] Pi], 83 - 10 
               Sin[Rational[1, 8] Pi]}, {
              89 + 10 Cos[Rational[1, 8] Pi], 83 + 
               10 Sin[Rational[1, 8] Pi]}, {
              89 + 10 Sin[Rational[1, 8] Pi], 83 + 
               10 Cos[Rational[1, 8] Pi]}, {
              89 - 10 Sin[Rational[1, 8] Pi], 83 + 
               10 Cos[Rational[1, 8] Pi]}, {
              89 - 10 Cos[Rational[1, 8] Pi], 83 + 
               10 Sin[Rational[1, 8] Pi]}, {
              89 - 10 Cos[Rational[1, 8] Pi], 83 - 10 
               Sin[Rational[1, 8] Pi]}, {
              89 - 10 Sin[Rational[1, 8] Pi], 83 - 10 
               Cos[Rational[1, 8] Pi]}}, {{92.8268343236509, 
             73.76120467488713}, {98.23879532511287, 79.1731656763491}, {
             98.23879532511287, 86.8268343236509}, {92.8268343236509, 
             92.23879532511287}, {85.1731656763491, 92.23879532511287}, {
             79.76120467488713, 86.8268343236509}, {79.76120467488713, 
             79.1731656763491}, {85.1731656763491, 73.76120467488713}}]],
           RegularPolygon[{89, 83}, 10, 8]]}, 
         {RGBColor[
          0.532051493354891, 0.23241846820826528`, 0.5620571695708585], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{64, 6 - 5 3^Rational[1, 2]}, {69, 6}, {
              64, 6 + 5 3^Rational[1, 2]}, {54, 6 + 5 3^Rational[1, 2]}, {49, 
              6}, {54, 6 - 5 3^Rational[1, 2]}}, {{
              64, -2.6602540378443855`}, {69, 6}, {64, 14.660254037844386`}, {
              54, 14.660254037844386`}, {49, 6}, {54, -2.6602540378443855`}}]],
           RegularPolygon[{59, 6}, 10, 6]]}, 
         {RGBColor[
          0.1364509437136594, 0.12924070538473487`, 0.7856113777741496], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              30 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 94 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              30 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 94 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {30, 104}, {
              30 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 94 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              30 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 94 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
              35.877852522924734`, 85.90983005625053}, {39.510565162951536`, 
              97.09016994374947}, {30, 104}, {20.489434837048464`, 
              97.09016994374947}, {24.122147477075266`, 85.90983005625053}}]],
           
           RegularPolygon[{30, 94}, 10, 5]]}, 
         {RGBColor[
          0.05310753244600108, 0.7104357291660051, 0.44479420599973096`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{37, 40 - 5 3^Rational[1, 2]}, {42, 40}, {
              37, 40 + 5 3^Rational[1, 2]}, {27, 40 + 5 3^Rational[1, 2]}, {
              22, 40}, {27, 40 - 5 3^Rational[1, 2]}}, {{
              37, 31.339745962155614`}, {42, 40}, {37, 48.66025403784438}, {
              27, 48.66025403784438}, {22, 40}, {27, 31.339745962155614`}}]],
           RegularPolygon[{32, 40}, 10, 6]]}, 
         {RGBColor[
          0.7346109518647743, 0.36616087898851113`, 0.6355148632492338], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{67, 74 - 5 3^Rational[1, 2]}, {72, 74}, {
              67, 74 + 5 3^Rational[1, 2]}, {57, 74 + 5 3^Rational[1, 2]}, {
              52, 74}, {57, 74 - 5 3^Rational[1, 2]}}, {{
              67, 65.33974596215562}, {72, 74}, {67, 82.66025403784438}, {
              57, 82.66025403784438}, {52, 74}, {57, 65.33974596215562}}]],
           RegularPolygon[{62, 74}, 10, 6]]}, 
         {RGBColor[0.88904594960253, 0.1426256110003774, 0.5426113272833943], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{86 + 5 3^Rational[1, 2], 44}, {86, 59}, {
              86 - 5 3^Rational[1, 2], 44}}, {{94.66025403784438, 44}, {86, 
              59}, {77.33974596215562, 44}}]],
           RegularPolygon[{86, 49}, 10, 3]]}, 
         {RGBColor[
          0.6356257653462558, 0.8118702539140812, 0.4894669854006273], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              39 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 88 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              39 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 88 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {39, 98}, {
              39 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 88 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              39 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 88 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
              44.877852522924734`, 79.90983005625053}, {48.510565162951536`, 
              91.09016994374947}, {39, 98}, {29.489434837048464`, 
              91.09016994374947}, {33.122147477075266`, 79.90983005625053}}]],
           
           RegularPolygon[{39, 88}, 10, 5]]}, 
         {RGBColor[
          0.03443366935766412, 0.3043133766857462, 0.8414745077070249], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{34 + 5 2^Rational[1, 2], 15 - 5 2^Rational[1, 2]}, {
              34 + 5 2^Rational[1, 2], 15 + 5 2^Rational[1, 2]}, {
              34 - 5 2^Rational[1, 2], 15 + 5 2^Rational[1, 2]}, {
              34 - 5 2^Rational[1, 2], 15 - 5 2^Rational[1, 2]}}, {{
             41.071067811865476`, 7.9289321881345245`}, {41.071067811865476`, 
             22.071067811865476`}, {26.928932188134524`, 
             22.071067811865476`}, {26.928932188134524`, 
             7.9289321881345245`}}]],
           RegularPolygon[{34, 15}, 10, 4]]}, 
         {RGBColor[
          0.6067134242453611, 0.5914788817779291, 0.6581120094750317], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              72 + 10 Sin[Rational[1, 7] Pi], 1 - 10 
               Cos[Rational[1, 7] Pi]}, {
              72 + 10 Cos[Rational[1, 14] Pi], 1 - 10 
               Sin[Rational[1, 14] Pi]}, {
              72 + 10 Cos[Rational[3, 14] Pi], 1 + 
               10 Sin[Rational[3, 14] Pi]}, {72, 11}, {
              72 - 10 Cos[Rational[3, 14] Pi], 1 + 
               10 Sin[Rational[3, 14] Pi]}, {
              72 - 10 Cos[Rational[1, 14] Pi], 1 - 10 
               Sin[Rational[1, 14] Pi]}, {
              72 - 10 Sin[Rational[1, 7] Pi], 1 - 10 
               Cos[Rational[1, 7] Pi]}}, {{
              76.33883739117559, -8.009688679024192}, {
              81.74927912181823, -1.2252093395631438`}, {79.8183148246803, 
              7.234898018587335}, {72, 11}, {64.1816851753197, 
              7.234898018587335}, {62.25072087818177, -1.2252093395631438`}, {
              67.66116260882441, -8.009688679024192}}]],
           RegularPolygon[{72, 1}, 10, 7]]}, 
         {RGBColor[0.883059134610223, 0.6304981241972059, 0.7650819226132299],
           Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              63 + 10 Sin[Rational[1, 7] Pi], 87 - 10 
               Cos[Rational[1, 7] Pi]}, {
              63 + 10 Cos[Rational[1, 14] Pi], 87 - 10 
               Sin[Rational[1, 14] Pi]}, {
              63 + 10 Cos[Rational[3, 14] Pi], 87 + 
               10 Sin[Rational[3, 14] Pi]}, {63, 97}, {
              63 - 10 Cos[Rational[3, 14] Pi], 87 + 
               10 Sin[Rational[3, 14] Pi]}, {
              63 - 10 Cos[Rational[1, 14] Pi], 87 - 10 
               Sin[Rational[1, 14] Pi]}, {
              63 - 10 Sin[Rational[1, 7] Pi], 87 - 10 
               Cos[Rational[1, 7] Pi]}}, {{67.33883739117559, 
              77.9903113209758}, {72.74927912181823, 84.77479066043685}, {
              70.8183148246803, 93.23489801858733}, {63, 97}, {
              55.1816851753197, 93.23489801858733}, {53.25072087818177, 
              84.77479066043685}, {58.66116260882442, 77.9903113209758}}]],
           RegularPolygon[{63, 87}, 10, 7]]}, 
         {RGBColor[
          0.22820673917620238`, 0.14229824153922332`, 0.09302105515486869], 
          Opacity[0.5], 
          InterpretationBox[
           PolygonBox[
            NCache[{{36 + 5 3^Rational[1, 2], 94}, {36, 109}, {
              36 - 5 3^Rational[1, 2], 94}}, {{44.66025403784438, 94}, {36, 
              109}, {27.339745962155614`, 94}}]],
           RegularPolygon[{36, 99}, 10, 3]]}, 
         {RGBColor[
          0.32518332784195403`, 0.9021976996613916, 0.4222693420364356], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{21 + 5 2^Rational[1, 2], 99 - 5 2^Rational[1, 2]}, {
              21 + 5 2^Rational[1, 2], 99 + 5 2^Rational[1, 2]}, {
              21 - 5 2^Rational[1, 2], 99 + 5 2^Rational[1, 2]}, {
              21 - 5 2^Rational[1, 2], 99 - 5 2^Rational[1, 2]}}, {{
             28.071067811865476`, 91.92893218813452}, {28.071067811865476`, 
             106.07106781186548`}, {13.928932188134524`, 
             106.07106781186548`}, {13.928932188134524`, 91.92893218813452}}]],
           RegularPolygon[{21, 99}, 10, 4]]}, 
         {RGBColor[
          0.07519406604965284, 0.17297384098476365`, 0.5799490184483234], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              60 + 10 Sin[Rational[1, 8] Pi], 34 - 10 
               Cos[Rational[1, 8] Pi]}, {
              60 + 10 Cos[Rational[1, 8] Pi], 34 - 10 
               Sin[Rational[1, 8] Pi]}, {
              60 + 10 Cos[Rational[1, 8] Pi], 34 + 
               10 Sin[Rational[1, 8] Pi]}, {
              60 + 10 Sin[Rational[1, 8] Pi], 34 + 
               10 Cos[Rational[1, 8] Pi]}, {
              60 - 10 Sin[Rational[1, 8] Pi], 34 + 
               10 Cos[Rational[1, 8] Pi]}, {
              60 - 10 Cos[Rational[1, 8] Pi], 34 + 
               10 Sin[Rational[1, 8] Pi]}, {
              60 - 10 Cos[Rational[1, 8] Pi], 34 - 10 
               Sin[Rational[1, 8] Pi]}, {
              60 - 10 Sin[Rational[1, 8] Pi], 34 - 10 
               Cos[Rational[1, 8] Pi]}}, {{63.8268343236509, 
             24.761204674887132`}, {69.23879532511287, 30.1731656763491}, {
             69.23879532511287, 37.8268343236509}, {63.8268343236509, 
             43.23879532511287}, {56.1731656763491, 43.23879532511287}, {
             50.76120467488713, 37.8268343236509}, {50.76120467488713, 
             30.1731656763491}, {56.1731656763491, 24.761204674887132`}}]],
           RegularPolygon[{60, 34}, 10, 8]]}, 
         {RGBColor[
          0.6054180011032666, 0.8238005061786104, 0.4430508947196159], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              55 + 10 Sin[Rational[1, 8] Pi], 67 - 10 
               Cos[Rational[1, 8] Pi]}, {
              55 + 10 Cos[Rational[1, 8] Pi], 67 - 10 
               Sin[Rational[1, 8] Pi]}, {
              55 + 10 Cos[Rational[1, 8] Pi], 67 + 
               10 Sin[Rational[1, 8] Pi]}, {
              55 + 10 Sin[Rational[1, 8] Pi], 67 + 
               10 Cos[Rational[1, 8] Pi]}, {
              55 - 10 Sin[Rational[1, 8] Pi], 67 + 
               10 Cos[Rational[1, 8] Pi]}, {
              55 - 10 Cos[Rational[1, 8] Pi], 67 + 
               10 Sin[Rational[1, 8] Pi]}, {
              55 - 10 Cos[Rational[1, 8] Pi], 67 - 10 
               Sin[Rational[1, 8] Pi]}, {
              55 - 10 Sin[Rational[1, 8] Pi], 67 - 10 
               Cos[Rational[1, 8] Pi]}}, {{58.8268343236509, 
             57.76120467488713}, {64.23879532511287, 63.1731656763491}, {
             64.23879532511287, 70.8268343236509}, {58.8268343236509, 
             76.23879532511287}, {51.1731656763491, 76.23879532511287}, {
             45.76120467488713, 70.8268343236509}, {45.76120467488713, 
             63.1731656763491}, {51.1731656763491, 57.76120467488713}}]],
           RegularPolygon[{55, 67}, 10, 8]]}, 
         {RGBColor[
          0.01451010069836256, 0.9166076617302117, 0.26045947202173747`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              65 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 59 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              65 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 59 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {65, 69}, {
              65 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 59 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              65 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 59 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{70.87785252292473, 
              50.90983005625053}, {74.51056516295154, 62.09016994374947}, {65,
               69}, {55.489434837048464`, 62.09016994374947}, {
              59.122147477075266`, 50.90983005625053}}]],
           RegularPolygon[{65, 59}, 10, 5]]}, 
         {RGBColor[
          0.35726854625421045`, 0.763613800275103, 0.6487240846127984], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{74 + 5 2^Rational[1, 2], 76 - 5 2^Rational[1, 2]}, {
              74 + 5 2^Rational[1, 2], 76 + 5 2^Rational[1, 2]}, {
              74 - 5 2^Rational[1, 2], 76 + 5 2^Rational[1, 2]}, {
              74 - 5 2^Rational[1, 2], 76 - 5 2^Rational[1, 2]}}, {{
             81.07106781186548, 68.92893218813452}, {81.07106781186548, 
             83.07106781186548}, {66.92893218813452, 83.07106781186548}, {
             66.92893218813452, 68.92893218813452}}]],
           RegularPolygon[{74, 76}, 10, 4]]}, 
         {RGBColor[
          0.9829001011491747, 0.6408852556322993, 0.5359765604624989], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{102, 15 - 5 3^Rational[1, 2]}, {107, 15}, {
              102, 15 + 5 3^Rational[1, 2]}, {92, 15 + 5 3^Rational[1, 2]}, {
              87, 15}, {92, 15 - 5 3^Rational[1, 2]}}, {{
              102, 6.3397459621556145`}, {107, 15}, {
              102, 23.660254037844386`}, {92, 23.660254037844386`}, {87, 
              15}, {92, 6.3397459621556145`}}]],
           RegularPolygon[{97, 15}, 10, 6]]}, 
         {RGBColor[
          0.976492585186874, 0.04068707751497591, 0.19132790388553755`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{18 + 5 2^Rational[1, 2], 8 - 5 2^Rational[1, 2]}, {
              18 + 5 2^Rational[1, 2], 8 + 5 2^Rational[1, 2]}, {
              18 - 5 2^Rational[1, 2], 8 + 5 2^Rational[1, 2]}, {
              18 - 5 2^Rational[1, 2], 8 - 5 2^Rational[1, 2]}}, {{
             25.071067811865476`, 0.9289321881345245}, {25.071067811865476`, 
             15.071067811865476`}, {10.928932188134524`, 
             15.071067811865476`}, {10.928932188134524`, 
             0.9289321881345245}}]],
           RegularPolygon[{18, 8}, 10, 4]]}, 
         {RGBColor[
          0.7467419855277684, 0.7812253058840126, 0.3406156645278797], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              20 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 2 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              20 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 2 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {20, 12}, {
              20 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 2 + Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              20 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 2 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
              25.877852522924734`, -6.0901699437494745`}, {
              29.510565162951536`, 5.0901699437494745`}, {20, 12}, {
              10.489434837048465`, 5.0901699437494745`}, {
              14.122147477075268`, -6.0901699437494745`}}]],
           RegularPolygon[{20, 2}, 10, 5]]}, 
         {RGBColor[
          0.0193557230586634, 0.3379879836367885, 0.08902427705687854], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              11 + 10 Sin[Rational[1, 7] Pi], 9 - 10 
               Cos[Rational[1, 7] Pi]}, {
              11 + 10 Cos[Rational[1, 14] Pi], 9 - 10 
               Sin[Rational[1, 14] Pi]}, {
              11 + 10 Cos[Rational[3, 14] Pi], 9 + 
               10 Sin[Rational[3, 14] Pi]}, {11, 19}, {
              11 - 10 Cos[Rational[3, 14] Pi], 9 + 
               10 Sin[Rational[3, 14] Pi]}, {
              11 - 10 Cos[Rational[1, 14] Pi], 9 - 10 
               Sin[Rational[1, 14] Pi]}, {
              11 - 10 Sin[Rational[1, 7] Pi], 9 - 10 
               Cos[Rational[1, 7] Pi]}}, {{
              15.33883739117558, -0.009688679024192126}, {20.749279121818237`,
               6.774790660436857}, {18.8183148246803, 15.234898018587334`}, {
              11, 19}, {3.1816851753197017`, 15.234898018587334`}, {
              1.2507208781817631`, 6.774790660436857}, {
              6.6611626088244185`, -0.009688679024192126}}]],
           RegularPolygon[{11, 9}, 10, 7]]}, 
         {RGBColor[
          0.13124600572776246`, 0.7344400646370504, 0.872053375519978], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{15, (-5) 3^Rational[1, 2]}, {20, 0}, {
              15, 5 3^Rational[1, 2]}, {5, 5 3^Rational[1, 2]}, {0, 0}, {
              5, (-5) 3^Rational[1, 2]}}, {{15, -8.660254037844386}, {20, 
              0}, {15, 8.660254037844386}, {5, 8.660254037844386}, {0, 0}, {
              5, -8.660254037844386}}]],
           RegularPolygon[{10, 0}, 10, 6]]}, 
         {RGBColor[
          0.3528879181298368, 0.13324035457063443`, 0.43431343034810244`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              23 + 10 Sin[Rational[1, 7] Pi], 20 - 10 
               Cos[Rational[1, 7] Pi]}, {
              23 + 10 Cos[Rational[1, 14] Pi], 20 - 10 
               Sin[Rational[1, 14] Pi]}, {
              23 + 10 Cos[Rational[3, 14] Pi], 20 + 
               10 Sin[Rational[3, 14] Pi]}, {23, 30}, {
              23 - 10 Cos[Rational[3, 14] Pi], 20 + 
               10 Sin[Rational[3, 14] Pi]}, {
              23 - 10 Cos[Rational[1, 14] Pi], 20 - 10 
               Sin[Rational[1, 14] Pi]}, {
              23 - 10 Sin[Rational[1, 7] Pi], 20 - 10 
               Cos[Rational[1, 7] Pi]}}, {{27.33883739117558, 
              10.990311320975808`}, {32.74927912181823, 
              17.774790660436857`}, {30.8183148246803, 26.234898018587334`}, {
              23, 30}, {15.181685175319702`, 26.234898018587334`}, {
              13.250720878181763`, 17.774790660436857`}, {18.66116260882442, 
              10.990311320975808`}}]],
           RegularPolygon[{23, 20}, 10, 7]]}, 
         {RGBColor[
          0.5776639155614913, 0.6462899221702223, 0.7542952055843306], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              32 + 10 Sin[Rational[1, 7] Pi], 77 - 10 
               Cos[Rational[1, 7] Pi]}, {
              32 + 10 Cos[Rational[1, 14] Pi], 77 - 10 
               Sin[Rational[1, 14] Pi]}, {
              32 + 10 Cos[Rational[3, 14] Pi], 77 + 
               10 Sin[Rational[3, 14] Pi]}, {32, 87}, {
              32 - 10 Cos[Rational[3, 14] Pi], 77 + 
               10 Sin[Rational[3, 14] Pi]}, {
              32 - 10 Cos[Rational[1, 14] Pi], 77 - 10 
               Sin[Rational[1, 14] Pi]}, {
              32 - 10 Sin[Rational[1, 7] Pi], 77 - 10 
               Cos[Rational[1, 7] Pi]}}, {{36.33883739117558, 
              67.9903113209758}, {41.74927912181823, 74.77479066043685}, {
              39.8183148246803, 83.23489801858733}, {32, 87}, {
              24.1816851753197, 83.23489801858733}, {22.250720878181763`, 
              74.77479066043685}, {27.66116260882442, 67.9903113209758}}]],
           RegularPolygon[{32, 77}, 10, 7]]}, 
         {RGBColor[0.3161404217475605, 0.364697119934863, 0.7831464717902363],
           Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              91 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 39 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              91 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 39 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {91, 49}, {
              91 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 39 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              91 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 39 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{96.87785252292473, 
              30.909830056250527`}, {100.51056516295154`, 
              42.09016994374947}, {91, 49}, {81.48943483704846, 
              42.09016994374947}, {85.12214747707527, 30.909830056250527`}}]],
           
           RegularPolygon[{91, 39}, 10, 5]]}, 
         {RGBColor[
          0.26711426099682045`, 0.02584679625383779, 0.9072981938146223], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{22 + 5 3^Rational[1, 2], 42}, {22, 57}, {
              22 - 5 3^Rational[1, 2], 42}}, {{30.660254037844386`, 42}, {22, 
              57}, {13.339745962155614`, 42}}]],
           RegularPolygon[{22, 47}, 10, 3]]}, 
         {RGBColor[
          0.930841359532556, 0.19235596077250694`, 0.6086319826628983], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              47 + 10 Sin[Rational[1, 7] Pi], 51 - 10 
               Cos[Rational[1, 7] Pi]}, {
              47 + 10 Cos[Rational[1, 14] Pi], 51 - 10 
               Sin[Rational[1, 14] Pi]}, {
              47 + 10 Cos[Rational[3, 14] Pi], 51 + 
               10 Sin[Rational[3, 14] Pi]}, {47, 61}, {
              47 - 10 Cos[Rational[3, 14] Pi], 51 + 
               10 Sin[Rational[3, 14] Pi]}, {
              47 - 10 Cos[Rational[1, 14] Pi], 51 - 10 
               Sin[Rational[1, 14] Pi]}, {
              47 - 10 Sin[Rational[1, 7] Pi], 51 - 10 
               Cos[Rational[1, 7] Pi]}}, {{51.33883739117558, 
              41.990311320975806`}, {56.74927912181823, 48.77479066043686}, {
              54.8183148246803, 57.23489801858734}, {47, 61}, {
              39.1816851753197, 57.23489801858734}, {37.25072087818177, 
              48.77479066043686}, {42.66116260882442, 41.990311320975806`}}]],
           
           RegularPolygon[{47, 51}, 10, 7]]}, 
         {RGBColor[
          0.1119442892722482, 0.5744370791817177, 0.04797974220893253], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              65 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 78 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              65 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 78 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {65, 88}, {
              65 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 78 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              65 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 78 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{70.87785252292473, 
              69.90983005625053}, {74.51056516295154, 81.09016994374947}, {65,
               88}, {55.489434837048464`, 81.09016994374947}, {
              59.122147477075266`, 69.90983005625053}}]],
           RegularPolygon[{65, 78}, 10, 5]]}, 
         {RGBColor[
          0.2697157671406669, 0.795222227485793, 0.31350739945795625`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{67 + 5 2^Rational[1, 2], 89 - 5 2^Rational[1, 2]}, {
              67 + 5 2^Rational[1, 2], 89 + 5 2^Rational[1, 2]}, {
              67 - 5 2^Rational[1, 2], 89 + 5 2^Rational[1, 2]}, {
              67 - 5 2^Rational[1, 2], 89 - 5 2^Rational[1, 2]}}, {{
             74.07106781186548, 81.92893218813452}, {74.07106781186548, 
             96.07106781186548}, {59.928932188134524`, 96.07106781186548}, {
             59.928932188134524`, 81.92893218813452}}]],
           RegularPolygon[{67, 89}, 10, 4]]}, 
         {RGBColor[
          0.3382259614318679, 0.8182899274584505, 0.5152311994058298], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              3 + 10 Sin[Rational[1, 8] Pi], 2 - 10 Cos[Rational[1, 8] Pi]}, {
              3 + 10 Cos[Rational[1, 8] Pi], 2 - 10 Sin[Rational[1, 8] Pi]}, {
              3 + 10 Cos[Rational[1, 8] Pi], 2 + 10 Sin[Rational[1, 8] Pi]}, {
              3 + 10 Sin[Rational[1, 8] Pi], 2 + 10 Cos[Rational[1, 8] Pi]}, {
              3 - 10 Sin[Rational[1, 8] Pi], 2 + 10 Cos[Rational[1, 8] Pi]}, {
              3 - 10 Cos[Rational[1, 8] Pi], 2 + 10 Sin[Rational[1, 8] Pi]}, {
              3 - 10 Cos[Rational[1, 8] Pi], 2 - 10 Sin[Rational[1, 8] Pi]}, {
              3 - 10 Sin[Rational[1, 8] Pi], 2 - 10 
               Cos[Rational[1, 8] Pi]}}, {{
             6.826834323650898, -7.238795325112868}, {
             12.238795325112868`, -1.826834323650898}, {12.238795325112868`, 
             5.826834323650898}, {6.826834323650898, 
             11.238795325112868`}, {-0.8268343236508979, 
             11.238795325112868`}, {-6.238795325112868, 
             5.826834323650898}, {-6.238795325112868, -1.826834323650898}, \
{-0.8268343236508979, -7.238795325112868}}]],
           RegularPolygon[{3, 2}, 10, 8]]}, 
         {RGBColor[
          0.9546284342773053, 0.7705515085669739, 0.0023347644024838132`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{104, (-5) 3^Rational[1, 2]}, {109, 0}, {
              104, 5 3^Rational[1, 2]}, {94, 5 3^Rational[1, 2]}, {89, 0}, {
              94, (-5) 3^Rational[1, 2]}}, {{104, -8.660254037844386}, {109, 
              0}, {104, 8.660254037844386}, {94, 8.660254037844386}, {89, 
              0}, {94, -8.660254037844386}}]],
           RegularPolygon[{99, 0}, 10, 6]]}, 
         {RGBColor[0.7863854027114427, 0.8521244813009565, 0.812448107902279],
           Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{90, 30 - 5 3^Rational[1, 2]}, {95, 30}, {
              90, 30 + 5 3^Rational[1, 2]}, {80, 30 + 5 3^Rational[1, 2]}, {
              75, 30}, {80, 30 - 5 3^Rational[1, 2]}}, {{
              90, 21.339745962155614`}, {95, 30}, {90, 38.66025403784438}, {
              80, 38.66025403784438}, {75, 30}, {80, 21.339745962155614`}}]],
           RegularPolygon[{85, 30}, 10, 6]]}, 
         {RGBColor[
          0.36770601058775787`, 0.8603599212117592, 0.384332943287542], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{9 + 5 3^Rational[1, 2], 3}, {9, 18}, {
              9 - 5 3^Rational[1, 2], 3}}, {{17.660254037844386`, 3}, {9, 
              18}, {0.3397459621556145, 3}}]],
           RegularPolygon[{9, 8}, 10, 3]]}, 
         {RGBColor[
          0.15644995101268866`, 0.822851164850213, 0.8507672437127254], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              53 + 10 Sin[Rational[1, 7] Pi], 49 - 10 
               Cos[Rational[1, 7] Pi]}, {
              53 + 10 Cos[Rational[1, 14] Pi], 49 - 10 
               Sin[Rational[1, 14] Pi]}, {
              53 + 10 Cos[Rational[3, 14] Pi], 49 + 
               10 Sin[Rational[3, 14] Pi]}, {53, 59}, {
              53 - 10 Cos[Rational[3, 14] Pi], 49 + 
               10 Sin[Rational[3, 14] Pi]}, {
              53 - 10 Cos[Rational[1, 14] Pi], 49 - 10 
               Sin[Rational[1, 14] Pi]}, {
              53 - 10 Sin[Rational[1, 7] Pi], 49 - 10 
               Cos[Rational[1, 7] Pi]}}, {{57.33883739117558, 
              39.990311320975806`}, {62.74927912181823, 46.77479066043686}, {
              60.8183148246803, 55.23489801858734}, {53, 59}, {
              45.1816851753197, 55.23489801858734}, {43.25072087818177, 
              46.77479066043686}, {48.66116260882442, 39.990311320975806`}}]],
           
           RegularPolygon[{53, 49}, 10, 7]]}, 
         {RGBColor[0.5215420632802785, 0.8574822869525511, 0.250075406264185],
           Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{60 + 5 3^Rational[1, 2], 10}, {60, 25}, {
              60 - 5 3^Rational[1, 2], 10}}, {{68.66025403784438, 10}, {60, 
              25}, {51.33974596215562, 10}}]],
           RegularPolygon[{60, 15}, 10, 3]]}, 
         {RGBColor[
          0.05371417570380954, 0.5136720160124912, 0.9513620786193406], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              53 + 10 Sin[Rational[1, 8] Pi], 80 - 10 
               Cos[Rational[1, 8] Pi]}, {
              53 + 10 Cos[Rational[1, 8] Pi], 80 - 10 
               Sin[Rational[1, 8] Pi]}, {
              53 + 10 Cos[Rational[1, 8] Pi], 80 + 
               10 Sin[Rational[1, 8] Pi]}, {
              53 + 10 Sin[Rational[1, 8] Pi], 80 + 
               10 Cos[Rational[1, 8] Pi]}, {
              53 - 10 Sin[Rational[1, 8] Pi], 80 + 
               10 Cos[Rational[1, 8] Pi]}, {
              53 - 10 Cos[Rational[1, 8] Pi], 80 + 
               10 Sin[Rational[1, 8] Pi]}, {
              53 - 10 Cos[Rational[1, 8] Pi], 80 - 10 
               Sin[Rational[1, 8] Pi]}, {
              53 - 10 Sin[Rational[1, 8] Pi], 80 - 10 
               Cos[Rational[1, 8] Pi]}}, {{56.8268343236509, 
             70.76120467488713}, {62.23879532511287, 76.1731656763491}, {
             62.23879532511287, 83.8268343236509}, {56.8268343236509, 
             89.23879532511287}, {49.1731656763491, 89.23879532511287}, {
             43.76120467488713, 83.8268343236509}, {43.76120467488713, 
             76.1731656763491}, {49.1731656763491, 70.76120467488713}}]],
           RegularPolygon[{53, 80}, 10, 8]]}, 
         {RGBColor[
          0.15598564644414448`, 0.13811521719252595`, 0.08500261506168383], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{25, 8 - 5 3^Rational[1, 2]}, {30, 8}, {
              25, 8 + 5 3^Rational[1, 2]}, {15, 8 + 5 3^Rational[1, 2]}, {10, 
              8}, {15, 8 - 5 3^Rational[1, 2]}}, {{25, -0.6602540378443855}, {
              30, 8}, {25, 16.660254037844386`}, {15, 16.660254037844386`}, {
              10, 8}, {15, -0.6602540378443855}}]],
           RegularPolygon[{20, 8}, 10, 6]]}, 
         {RGBColor[
          0.6744646019422045, 0.4268493144879386, 0.07634272462526925], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{49 + 5 3^Rational[1, 2], 87}, {49, 102}, {
              49 - 5 3^Rational[1, 2], 87}}, {{57.66025403784438, 87}, {49, 
              102}, {40.33974596215562, 87}}]],
           RegularPolygon[{49, 92}, 10, 3]]}, 
         {RGBColor[
          0.23730299488882722`, 0.7103184485854448, 0.22248172521893128`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              51 + 10 Sin[Rational[1, 7] Pi], 24 - 10 
               Cos[Rational[1, 7] Pi]}, {
              51 + 10 Cos[Rational[1, 14] Pi], 24 - 10 
               Sin[Rational[1, 14] Pi]}, {
              51 + 10 Cos[Rational[3, 14] Pi], 24 + 
               10 Sin[Rational[3, 14] Pi]}, {51, 34}, {
              51 - 10 Cos[Rational[3, 14] Pi], 24 + 
               10 Sin[Rational[3, 14] Pi]}, {
              51 - 10 Cos[Rational[1, 14] Pi], 24 - 10 
               Sin[Rational[1, 14] Pi]}, {
              51 - 10 Sin[Rational[1, 7] Pi], 24 - 10 
               Cos[Rational[1, 7] Pi]}}, {{55.33883739117558, 
              14.990311320975808`}, {60.74927912181823, 
              21.774790660436857`}, {58.8183148246803, 30.234898018587334`}, {
              51, 34}, {43.1816851753197, 30.234898018587334`}, {
              41.25072087818177, 21.774790660436857`}, {46.66116260882442, 
              14.990311320975808`}}]],
           RegularPolygon[{51, 24}, 10, 7]]}, 
         {RGBColor[
          0.13431334426185115`, 0.3124682507368186, 0.18139201368834756`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              78 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 83 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              78 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 83 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {78, 93}, {
              78 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 83 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              78 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 83 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{83.87785252292473, 
              74.90983005625053}, {87.51056516295154, 86.09016994374947}, {78,
               93}, {68.48943483704846, 86.09016994374947}, {
              72.12214747707527, 74.90983005625053}}]],
           RegularPolygon[{78, 83}, 10, 5]]}, 
         {RGBColor[
          0.2933819049970776, 0.4333658800074154, 0.2583204699816797], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              24 + 10 Sin[Rational[1, 7] Pi], 46 - 10 
               Cos[Rational[1, 7] Pi]}, {
              24 + 10 Cos[Rational[1, 14] Pi], 46 - 10 
               Sin[Rational[1, 14] Pi]}, {
              24 + 10 Cos[Rational[3, 14] Pi], 46 + 
               10 Sin[Rational[3, 14] Pi]}, {24, 56}, {
              24 - 10 Cos[Rational[3, 14] Pi], 46 + 
               10 Sin[Rational[3, 14] Pi]}, {
              24 - 10 Cos[Rational[1, 14] Pi], 46 - 10 
               Sin[Rational[1, 14] Pi]}, {
              24 - 10 Sin[Rational[1, 7] Pi], 46 - 10 
               Cos[Rational[1, 7] Pi]}}, {{28.33883739117558, 
              36.990311320975806`}, {33.74927912181823, 43.77479066043686}, {
              31.8183148246803, 52.23489801858734}, {24, 56}, {
              16.1816851753197, 52.23489801858734}, {14.250720878181763`, 
              43.77479066043686}, {19.66116260882442, 36.990311320975806`}}]],
           
           RegularPolygon[{24, 46}, 10, 7]]}, 
         {RGBColor[
          0.7606431478253546, 0.548377753266259, 0.14098023286431616`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              9 + 10 Sin[Rational[1, 7] Pi], 96 - 10 
               Cos[Rational[1, 7] Pi]}, {
              9 + 10 Cos[Rational[1, 14] Pi], 96 - 10 
               Sin[Rational[1, 14] Pi]}, {
              9 + 10 Cos[Rational[3, 14] Pi], 96 + 
               10 Sin[Rational[3, 14] Pi]}, {9, 106}, {
              9 - 10 Cos[Rational[3, 14] Pi], 96 + 
               10 Sin[Rational[3, 14] Pi]}, {
              9 - 10 Cos[Rational[1, 14] Pi], 96 - 10 
               Sin[Rational[1, 14] Pi]}, {
              9 - 10 Sin[Rational[1, 7] Pi], 96 - 10 
               Cos[Rational[1, 7] Pi]}}, {{13.33883739117558, 
              86.9903113209758}, {18.749279121818237`, 93.77479066043685}, {
              16.8183148246803, 102.23489801858733`}, {9, 106}, {
              1.1816851753197017`, 102.23489801858733`}, {-0.7492791218182369,
               93.77479066043685}, {4.6611626088244185`, 86.9903113209758}}]],
           
           RegularPolygon[{9, 96}, 10, 7]]}, 
         {RGBColor[
          0.24185914273557474`, 0.12780487595388546`, 0.7324603975441122], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{31 + 5 2^Rational[1, 2], 32 - 5 2^Rational[1, 2]}, {
              31 + 5 2^Rational[1, 2], 32 + 5 2^Rational[1, 2]}, {
              31 - 5 2^Rational[1, 2], 32 + 5 2^Rational[1, 2]}, {
              31 - 5 2^Rational[1, 2], 32 - 5 2^Rational[1, 2]}}, {{
             38.071067811865476`, 24.928932188134524`}, {38.071067811865476`, 
             39.071067811865476`}, {23.928932188134524`, 
             39.071067811865476`}, {23.928932188134524`, 
             24.928932188134524`}}]],
           RegularPolygon[{31, 32}, 10, 4]]}, 
         {RGBColor[
          0.4285658124840235, 0.4605841370897532, 0.5480093173224139], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{5 + 5 2^Rational[1, 2], 41 - 5 2^Rational[1, 2]}, {
              5 + 5 2^Rational[1, 2], 41 + 5 2^Rational[1, 2]}, {
              5 - 5 2^Rational[1, 2], 41 + 5 2^Rational[1, 2]}, {
              5 - 5 2^Rational[1, 2], 41 - 5 2^Rational[1, 2]}}, {{
             12.071067811865476`, 33.928932188134524`}, {12.071067811865476`, 
             48.071067811865476`}, {-2.0710678118654755`, 
             48.071067811865476`}, {-2.0710678118654755`, 
             33.928932188134524`}}]],
           RegularPolygon[{5, 41}, 10, 4]]}, 
         {RGBColor[
          0.38979413397180185`, 0.40185611346055317`, 0.008704032600402423], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{46, 46 - 5 3^Rational[1, 2]}, {51, 46}, {
              46, 46 + 5 3^Rational[1, 2]}, {36, 46 + 5 3^Rational[1, 2]}, {
              31, 46}, {36, 46 - 5 3^Rational[1, 2]}}, {{
              46, 37.33974596215562}, {51, 46}, {46, 54.66025403784438}, {
              36, 54.66025403784438}, {31, 46}, {36, 37.33974596215562}}]],
           RegularPolygon[{41, 46}, 10, 6]]}, 
         {RGBColor[
          0.9406568562078943, 0.31182779692823037`, 0.6098471911758756], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              93 + 10 Sin[Rational[1, 8] Pi], 97 - 10 
               Cos[Rational[1, 8] Pi]}, {
              93 + 10 Cos[Rational[1, 8] Pi], 97 - 10 
               Sin[Rational[1, 8] Pi]}, {
              93 + 10 Cos[Rational[1, 8] Pi], 97 + 
               10 Sin[Rational[1, 8] Pi]}, {
              93 + 10 Sin[Rational[1, 8] Pi], 97 + 
               10 Cos[Rational[1, 8] Pi]}, {
              93 - 10 Sin[Rational[1, 8] Pi], 97 + 
               10 Cos[Rational[1, 8] Pi]}, {
              93 - 10 Cos[Rational[1, 8] Pi], 97 + 
               10 Sin[Rational[1, 8] Pi]}, {
              93 - 10 Cos[Rational[1, 8] Pi], 97 - 10 
               Sin[Rational[1, 8] Pi]}, {
              93 - 10 Sin[Rational[1, 8] Pi], 97 - 10 
               Cos[Rational[1, 8] Pi]}}, {{96.8268343236509, 
             87.76120467488713}, {102.23879532511287`, 93.1731656763491}, {
             102.23879532511287`, 100.8268343236509}, {96.8268343236509, 
             106.23879532511287`}, {89.1731656763491, 106.23879532511287`}, {
             83.76120467488713, 100.8268343236509}, {83.76120467488713, 
             93.1731656763491}, {89.1731656763491, 87.76120467488713}}]],
           RegularPolygon[{93, 97}, 10, 8]]}, 
         {RGBColor[0.816477053310892, 0.5061507036729977, 0.604572230630573], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{38, 53 - 5 3^Rational[1, 2]}, {43, 53}, {
              38, 53 + 5 3^Rational[1, 2]}, {28, 53 + 5 3^Rational[1, 2]}, {
              23, 53}, {28, 53 - 5 3^Rational[1, 2]}}, {{
              38, 44.33974596215562}, {43, 53}, {38, 61.66025403784438}, {
              28, 61.66025403784438}, {23, 53}, {28, 44.33974596215562}}]],
           RegularPolygon[{33, 53}, 10, 6]]}, 
         {RGBColor[
          0.9511941199251182, 0.00678489098437951, 0.12505715068297163`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              92 + 10 Sin[Rational[1, 7] Pi], 12 - 10 
               Cos[Rational[1, 7] Pi]}, {
              92 + 10 Cos[Rational[1, 14] Pi], 12 - 10 
               Sin[Rational[1, 14] Pi]}, {
              92 + 10 Cos[Rational[3, 14] Pi], 12 + 
               10 Sin[Rational[3, 14] Pi]}, {92, 22}, {
              92 - 10 Cos[Rational[3, 14] Pi], 12 + 
               10 Sin[Rational[3, 14] Pi]}, {
              92 - 10 Cos[Rational[1, 14] Pi], 12 - 10 
               Sin[Rational[1, 14] Pi]}, {
              92 - 10 Sin[Rational[1, 7] Pi], 12 - 10 
               Cos[Rational[1, 7] Pi]}}, {{96.33883739117559, 
              2.990311320975808}, {101.74927912181823`, 9.774790660436857}, {
              99.8183148246803, 18.234898018587334`}, {92, 22}, {
              84.1816851753197, 18.234898018587334`}, {82.25072087818177, 
              9.774790660436857}, {87.66116260882441, 2.990311320975808}}]],
           RegularPolygon[{92, 12}, 10, 7]]}, 
         {RGBColor[
          0.9926773502738482, 0.6386425900591328, 0.20471574756982447`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{41, 43 - 5 3^Rational[1, 2]}, {46, 43}, {
              41, 43 + 5 3^Rational[1, 2]}, {31, 43 + 5 3^Rational[1, 2]}, {
              26, 43}, {31, 43 - 5 3^Rational[1, 2]}}, {{
              41, 34.33974596215562}, {46, 43}, {41, 51.66025403784438}, {
              31, 51.66025403784438}, {26, 43}, {31, 34.33974596215562}}]],
           RegularPolygon[{36, 43}, 10, 6]]}, 
         {RGBColor[
          0.24096055187655696`, 0.7956067458943188, 0.6707840130088074], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{85 + 5 2^Rational[1, 2], 66 - 5 2^Rational[1, 2]}, {
              85 + 5 2^Rational[1, 2], 66 + 5 2^Rational[1, 2]}, {
              85 - 5 2^Rational[1, 2], 66 + 5 2^Rational[1, 2]}, {
              85 - 5 2^Rational[1, 2], 66 - 5 2^Rational[1, 2]}}, {{
             92.07106781186548, 58.928932188134524`}, {92.07106781186548, 
             73.07106781186548}, {77.92893218813452, 73.07106781186548}, {
             77.92893218813452, 58.928932188134524`}}]],
           RegularPolygon[{85, 66}, 10, 4]]}, 
         {RGBColor[
          0.6962867070712211, 0.03779461467066714, 0.10061999430300994`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{32 + 5 3^Rational[1, 2], 30}, {32, 45}, {
              32 - 5 3^Rational[1, 2], 30}}, {{40.66025403784438, 30}, {32, 
              45}, {23.339745962155614`, 30}}]],
           RegularPolygon[{32, 35}, 10, 3]]}, 
         {RGBColor[
          0.3525936612321894, 0.036876166872091165`, 0.9520129155202468], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              28 + 10 Sin[Rational[1, 8] Pi], 98 - 10 
               Cos[Rational[1, 8] Pi]}, {
              28 + 10 Cos[Rational[1, 8] Pi], 98 - 10 
               Sin[Rational[1, 8] Pi]}, {
              28 + 10 Cos[Rational[1, 8] Pi], 98 + 
               10 Sin[Rational[1, 8] Pi]}, {
              28 + 10 Sin[Rational[1, 8] Pi], 98 + 
               10 Cos[Rational[1, 8] Pi]}, {
              28 - 10 Sin[Rational[1, 8] Pi], 98 + 
               10 Cos[Rational[1, 8] Pi]}, {
              28 - 10 Cos[Rational[1, 8] Pi], 98 + 
               10 Sin[Rational[1, 8] Pi]}, {
              28 - 10 Cos[Rational[1, 8] Pi], 98 - 10 
               Sin[Rational[1, 8] Pi]}, {
              28 - 10 Sin[Rational[1, 8] Pi], 98 - 10 
               Cos[Rational[1, 8] Pi]}}, {{31.8268343236509, 
             88.76120467488713}, {37.23879532511287, 94.1731656763491}, {
             37.23879532511287, 101.8268343236509}, {31.8268343236509, 
             107.23879532511287`}, {24.1731656763491, 107.23879532511287`}, {
             18.761204674887132`, 101.8268343236509}, {18.761204674887132`, 
             94.1731656763491}, {24.1731656763491, 88.76120467488713}}]],
           RegularPolygon[{28, 98}, 10, 8]]}, 
         {RGBColor[
          0.7142736849869464, 0.09289674096863099, 0.6405219512876956], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              7 + 10 Sin[Rational[1, 8] Pi], 69 - 10 
               Cos[Rational[1, 8] Pi]}, {
              7 + 10 Cos[Rational[1, 8] Pi], 69 - 10 
               Sin[Rational[1, 8] Pi]}, {
              7 + 10 Cos[Rational[1, 8] Pi], 69 + 
               10 Sin[Rational[1, 8] Pi]}, {
              7 + 10 Sin[Rational[1, 8] Pi], 69 + 
               10 Cos[Rational[1, 8] Pi]}, {
              7 - 10 Sin[Rational[1, 8] Pi], 69 + 
               10 Cos[Rational[1, 8] Pi]}, {
              7 - 10 Cos[Rational[1, 8] Pi], 69 + 
               10 Sin[Rational[1, 8] Pi]}, {
              7 - 10 Cos[Rational[1, 8] Pi], 69 - 10 
               Sin[Rational[1, 8] Pi]}, {
              7 - 10 Sin[Rational[1, 8] Pi], 69 - 10 
               Cos[Rational[1, 8] Pi]}}, {{10.826834323650898`, 
             59.76120467488713}, {16.238795325112868`, 65.1731656763491}, {
             16.238795325112868`, 72.8268343236509}, {10.826834323650898`, 
             78.23879532511287}, {3.173165676349102, 
             78.23879532511287}, {-2.238795325112868, 
             72.8268343236509}, {-2.238795325112868, 65.1731656763491}, {
             3.173165676349102, 59.76120467488713}}]],
           RegularPolygon[{7, 69}, 10, 8]]}, 
         {RGBColor[
          0.672277328552908, 0.08982976735721349, 0.5498099986265119], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              96 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 34 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              96 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 34 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {96, 44}, {
              96 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 34 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              96 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 34 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
              101.87785252292473`, 25.909830056250527`}, {105.51056516295154`,
               37.09016994374947}, {96, 44}, {86.48943483704846, 
              37.09016994374947}, {90.12214747707527, 25.909830056250527`}}]],
           
           RegularPolygon[{96, 34}, 10, 5]]}, 
         {RGBColor[
          0.525371165213369, 0.08402683190573002, 0.5243615235498036], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{8 + 5 3^Rational[1, 2], 2}, {8, 17}, {
              8 - 5 3^Rational[1, 2], 2}}, {{16.660254037844386`, 2}, {8, 
              17}, {-0.6602540378443855, 2}}]],
           RegularPolygon[{8, 7}, 10, 3]]}, 
         {RGBColor[0.5391301758565321, 0.954012887881353, 0.5252210602744241],
           Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              41 + 10 Sin[Rational[1, 8] Pi], 3 - 10 
               Cos[Rational[1, 8] Pi]}, {
              41 + 10 Cos[Rational[1, 8] Pi], 3 - 10 
               Sin[Rational[1, 8] Pi]}, {
              41 + 10 Cos[Rational[1, 8] Pi], 3 + 
               10 Sin[Rational[1, 8] Pi]}, {
              41 + 10 Sin[Rational[1, 8] Pi], 3 + 
               10 Cos[Rational[1, 8] Pi]}, {
              41 - 10 Sin[Rational[1, 8] Pi], 3 + 
               10 Cos[Rational[1, 8] Pi]}, {
              41 - 10 Cos[Rational[1, 8] Pi], 3 + 
               10 Sin[Rational[1, 8] Pi]}, {
              41 - 10 Cos[Rational[1, 8] Pi], 3 - 10 
               Sin[Rational[1, 8] Pi]}, {
              41 - 10 Sin[Rational[1, 8] Pi], 3 - 10 
               Cos[Rational[1, 8] Pi]}}, {{
             44.8268343236509, -6.238795325112868}, {
             50.23879532511287, -0.8268343236508979}, {50.23879532511287, 
             6.826834323650898}, {44.8268343236509, 12.238795325112868`}, {
             37.1731656763491, 12.238795325112868`}, {31.761204674887132`, 
             6.826834323650898}, {31.761204674887132`, -0.8268343236508979}, {
             37.1731656763491, -6.238795325112868}}]],
           RegularPolygon[{41, 3}, 10, 8]]}, 
         {RGBColor[
          0.6456031075806483, 0.20845601297222083`, 0.9785988532269325], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{73, 35 - 5 3^Rational[1, 2]}, {78, 35}, {
              73, 35 + 5 3^Rational[1, 2]}, {63, 35 + 5 3^Rational[1, 2]}, {
              58, 35}, {63, 35 - 5 3^Rational[1, 2]}}, {{
              73, 26.339745962155614`}, {78, 35}, {73, 43.66025403784438}, {
              63, 43.66025403784438}, {58, 35}, {63, 26.339745962155614`}}]],
           RegularPolygon[{68, 35}, 10, 6]]}, 
         {RGBColor[
          0.5554985043082217, 0.07491637027880294, 0.7469836606553633], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              39 + 10 Sin[Rational[1, 8] Pi], 2 - 10 
               Cos[Rational[1, 8] Pi]}, {
              39 + 10 Cos[Rational[1, 8] Pi], 2 - 10 
               Sin[Rational[1, 8] Pi]}, {
              39 + 10 Cos[Rational[1, 8] Pi], 2 + 
               10 Sin[Rational[1, 8] Pi]}, {
              39 + 10 Sin[Rational[1, 8] Pi], 2 + 
               10 Cos[Rational[1, 8] Pi]}, {
              39 - 10 Sin[Rational[1, 8] Pi], 2 + 
               10 Cos[Rational[1, 8] Pi]}, {
              39 - 10 Cos[Rational[1, 8] Pi], 2 + 
               10 Sin[Rational[1, 8] Pi]}, {
              39 - 10 Cos[Rational[1, 8] Pi], 2 - 10 
               Sin[Rational[1, 8] Pi]}, {
              39 - 10 Sin[Rational[1, 8] Pi], 2 - 10 
               Cos[Rational[1, 8] Pi]}}, {{
             42.8268343236509, -7.238795325112868}, {
             48.23879532511287, -1.826834323650898}, {48.23879532511287, 
             5.826834323650898}, {42.8268343236509, 11.238795325112868`}, {
             35.1731656763491, 11.238795325112868`}, {29.761204674887132`, 
             5.826834323650898}, {29.761204674887132`, -1.826834323650898}, {
             35.1731656763491, -7.238795325112868}}]],
           RegularPolygon[{39, 2}, 10, 8]]}, 
         {RGBColor[
          0.5259930176055541, 0.3489349194315772, 0.7095420343344472], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              19 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 96 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              19 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 96 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {19, 106}, {
              19 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 96 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              19 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 96 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
              24.877852522924734`, 87.90983005625053}, {28.510565162951536`, 
              99.09016994374947}, {19, 106}, {9.489434837048465, 
              99.09016994374947}, {13.122147477075268`, 87.90983005625053}}]],
           
           RegularPolygon[{19, 96}, 10, 5]]}, 
         {RGBColor[
          0.33885478192577656`, 0.26672240528832525`, 0.6064198113180701], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              86 + 10 Sin[Rational[1, 8] Pi], 33 - 10 
               Cos[Rational[1, 8] Pi]}, {
              86 + 10 Cos[Rational[1, 8] Pi], 33 - 10 
               Sin[Rational[1, 8] Pi]}, {
              86 + 10 Cos[Rational[1, 8] Pi], 33 + 
               10 Sin[Rational[1, 8] Pi]}, {
              86 + 10 Sin[Rational[1, 8] Pi], 33 + 
               10 Cos[Rational[1, 8] Pi]}, {
              86 - 10 Sin[Rational[1, 8] Pi], 33 + 
               10 Cos[Rational[1, 8] Pi]}, {
              86 - 10 Cos[Rational[1, 8] Pi], 33 + 
               10 Sin[Rational[1, 8] Pi]}, {
              86 - 10 Cos[Rational[1, 8] Pi], 33 - 10 
               Sin[Rational[1, 8] Pi]}, {
              86 - 10 Sin[Rational[1, 8] Pi], 33 - 10 
               Cos[Rational[1, 8] Pi]}}, {{89.8268343236509, 
             23.761204674887132`}, {95.23879532511287, 29.1731656763491}, {
             95.23879532511287, 36.8268343236509}, {89.8268343236509, 
             42.23879532511287}, {82.1731656763491, 42.23879532511287}, {
             76.76120467488713, 36.8268343236509}, {76.76120467488713, 
             29.1731656763491}, {82.1731656763491, 23.761204674887132`}}]],
           RegularPolygon[{86, 33}, 10, 8]]}, 
         {RGBColor[
          0.7846788590783385, 0.6007091610821271, 0.41323836161465555`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{62 + 5 3^Rational[1, 2], 41}, {62, 56}, {
              62 - 5 3^Rational[1, 2], 41}}, {{70.66025403784438, 41}, {62, 
              56}, {53.33974596215562, 41}}]],
           RegularPolygon[{62, 46}, 10, 3]]}, 
         {RGBColor[0.8171009401848579, 0.232997308692801, 0.1115635061286464],
           Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{31, 5 - 5 3^Rational[1, 2]}, {36, 5}, {
              31, 5 + 5 3^Rational[1, 2]}, {21, 5 + 5 3^Rational[1, 2]}, {16, 
              5}, {21, 5 - 5 3^Rational[1, 2]}}, {{
              31, -3.6602540378443855`}, {36, 5}, {31, 13.660254037844386`}, {
              21, 13.660254037844386`}, {16, 5}, {21, -3.6602540378443855`}}]],
           RegularPolygon[{26, 5}, 10, 6]]}, 
         {RGBColor[
          0.03516467355523223, 0.9937025205320749, 0.20214686646221836`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              96 + 10 Sin[Rational[1, 8] Pi], 89 - 10 
               Cos[Rational[1, 8] Pi]}, {
              96 + 10 Cos[Rational[1, 8] Pi], 89 - 10 
               Sin[Rational[1, 8] Pi]}, {
              96 + 10 Cos[Rational[1, 8] Pi], 89 + 
               10 Sin[Rational[1, 8] Pi]}, {
              96 + 10 Sin[Rational[1, 8] Pi], 89 + 
               10 Cos[Rational[1, 8] Pi]}, {
              96 - 10 Sin[Rational[1, 8] Pi], 89 + 
               10 Cos[Rational[1, 8] Pi]}, {
              96 - 10 Cos[Rational[1, 8] Pi], 89 + 
               10 Sin[Rational[1, 8] Pi]}, {
              96 - 10 Cos[Rational[1, 8] Pi], 89 - 10 
               Sin[Rational[1, 8] Pi]}, {
              96 - 10 Sin[Rational[1, 8] Pi], 89 - 10 
               Cos[Rational[1, 8] Pi]}}, {{99.8268343236509, 
             79.76120467488713}, {105.23879532511287`, 85.1731656763491}, {
             105.23879532511287`, 92.8268343236509}, {99.8268343236509, 
             98.23879532511287}, {92.1731656763491, 98.23879532511287}, {
             86.76120467488713, 92.8268343236509}, {86.76120467488713, 
             85.1731656763491}, {92.1731656763491, 79.76120467488713}}]],
           RegularPolygon[{96, 89}, 10, 8]]}, 
         {RGBColor[
          0.3276347140124287, 0.80952016582526, 0.17149165339666994`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              32 + 10 Sin[Rational[1, 8] Pi], 70 - 10 
               Cos[Rational[1, 8] Pi]}, {
              32 + 10 Cos[Rational[1, 8] Pi], 70 - 10 
               Sin[Rational[1, 8] Pi]}, {
              32 + 10 Cos[Rational[1, 8] Pi], 70 + 
               10 Sin[Rational[1, 8] Pi]}, {
              32 + 10 Sin[Rational[1, 8] Pi], 70 + 
               10 Cos[Rational[1, 8] Pi]}, {
              32 - 10 Sin[Rational[1, 8] Pi], 70 + 
               10 Cos[Rational[1, 8] Pi]}, {
              32 - 10 Cos[Rational[1, 8] Pi], 70 + 
               10 Sin[Rational[1, 8] Pi]}, {
              32 - 10 Cos[Rational[1, 8] Pi], 70 - 10 
               Sin[Rational[1, 8] Pi]}, {
              32 - 10 Sin[Rational[1, 8] Pi], 70 - 10 
               Cos[Rational[1, 8] Pi]}}, {{35.8268343236509, 
             60.76120467488713}, {41.23879532511287, 66.1731656763491}, {
             41.23879532511287, 73.8268343236509}, {35.8268343236509, 
             79.23879532511287}, {28.1731656763491, 79.23879532511287}, {
             22.761204674887132`, 73.8268343236509}, {22.761204674887132`, 
             66.1731656763491}, {28.1731656763491, 60.76120467488713}}]],
           RegularPolygon[{32, 70}, 10, 8]]}, 
         {RGBColor[
          0.5367812926806756, 0.12196240927732926`, 0.9682621428502807], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{68 + 5 2^Rational[1, 2], 87 - 5 2^Rational[1, 2]}, {
              68 + 5 2^Rational[1, 2], 87 + 5 2^Rational[1, 2]}, {
              68 - 5 2^Rational[1, 2], 87 + 5 2^Rational[1, 2]}, {
              68 - 5 2^Rational[1, 2], 87 - 5 2^Rational[1, 2]}}, {{
             75.07106781186548, 79.92893218813452}, {75.07106781186548, 
             94.07106781186548}, {60.928932188134524`, 94.07106781186548}, {
             60.928932188134524`, 79.92893218813452}}]],
           RegularPolygon[{68, 87}, 10, 4]]}, 
         {RGBColor[
          0.22549854861934215`, 0.5465784314501305, 0.5419764527654094], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{77 + 5 2^Rational[1, 2], 82 - 5 2^Rational[1, 2]}, {
              77 + 5 2^Rational[1, 2], 82 + 5 2^Rational[1, 2]}, {
              77 - 5 2^Rational[1, 2], 82 + 5 2^Rational[1, 2]}, {
              77 - 5 2^Rational[1, 2], 82 - 5 2^Rational[1, 2]}}, {{
             84.07106781186548, 74.92893218813452}, {84.07106781186548, 
             89.07106781186548}, {69.92893218813452, 89.07106781186548}, {
             69.92893218813452, 74.92893218813452}}]],
           RegularPolygon[{77, 82}, 10, 4]]}, 
         {RGBColor[
          0.1250584100900871, 0.10681254286853892`, 0.9721756025510631], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              58 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 59 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              58 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 59 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {58, 69}, {
              58 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 59 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              58 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 59 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
              63.877852522924734`, 50.90983005625053}, {67.51056516295154, 
              62.09016994374947}, {58, 69}, {48.489434837048464`, 
              62.09016994374947}, {52.122147477075266`, 50.90983005625053}}]],
           
           RegularPolygon[{58, 59}, 10, 5]]}, 
         {RGBColor[
          0.7216691649234865, 0.16959433047977446`, 0.7303731337408539], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              62 + 10 Sin[Rational[1, 8] Pi], 76 - 10 
               Cos[Rational[1, 8] Pi]}, {
              62 + 10 Cos[Rational[1, 8] Pi], 76 - 10 
               Sin[Rational[1, 8] Pi]}, {
              62 + 10 Cos[Rational[1, 8] Pi], 76 + 
               10 Sin[Rational[1, 8] Pi]}, {
              62 + 10 Sin[Rational[1, 8] Pi], 76 + 
               10 Cos[Rational[1, 8] Pi]}, {
              62 - 10 Sin[Rational[1, 8] Pi], 76 + 
               10 Cos[Rational[1, 8] Pi]}, {
              62 - 10 Cos[Rational[1, 8] Pi], 76 + 
               10 Sin[Rational[1, 8] Pi]}, {
              62 - 10 Cos[Rational[1, 8] Pi], 76 - 10 
               Sin[Rational[1, 8] Pi]}, {
              62 - 10 Sin[Rational[1, 8] Pi], 76 - 10 
               Cos[Rational[1, 8] Pi]}}, {{65.8268343236509, 
             66.76120467488713}, {71.23879532511287, 72.1731656763491}, {
             71.23879532511287, 79.8268343236509}, {65.8268343236509, 
             85.23879532511287}, {58.1731656763491, 85.23879532511287}, {
             52.76120467488713, 79.8268343236509}, {52.76120467488713, 
             72.1731656763491}, {58.1731656763491, 66.76120467488713}}]],
           RegularPolygon[{62, 76}, 10, 8]]}, 
         {RGBColor[
          0.7438953850464027, 0.7403105009003266, 0.1470487190780041], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{11, 37 - 5 3^Rational[1, 2]}, {16, 37}, {
              11, 37 + 5 3^Rational[1, 2]}, {1, 37 + 5 3^Rational[1, 2]}, {-4,
               37}, {1, 37 - 5 3^Rational[1, 2]}}, {{
              11, 28.339745962155614`}, {16, 37}, {11, 45.66025403784438}, {
              1, 45.66025403784438}, {-4, 37}, {1, 28.339745962155614`}}]],
           RegularPolygon[{6, 37}, 10, 6]]}, 
         {RGBColor[
          0.11081733393110249`, 0.5813398800836753, 0.5614281729992157], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              78 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 35 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              78 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 35 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {78, 45}, {
              78 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 35 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              78 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 35 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{83.87785252292473, 
              26.909830056250527`}, {87.51056516295154, 38.09016994374947}, {
              78, 45}, {68.48943483704846, 38.09016994374947}, {
              72.12214747707527, 26.909830056250527`}}]],
           RegularPolygon[{78, 35}, 10, 5]]}, 
         {RGBColor[
          0.8149410577774916, 0.46420182711252567`, 0.22478473548383082`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              67 + 10 Sin[Rational[1, 7] Pi], 47 - 10 
               Cos[Rational[1, 7] Pi]}, {
              67 + 10 Cos[Rational[1, 14] Pi], 47 - 10 
               Sin[Rational[1, 14] Pi]}, {
              67 + 10 Cos[Rational[3, 14] Pi], 47 + 
               10 Sin[Rational[3, 14] Pi]}, {67, 57}, {
              67 - 10 Cos[Rational[3, 14] Pi], 47 + 
               10 Sin[Rational[3, 14] Pi]}, {
              67 - 10 Cos[Rational[1, 14] Pi], 47 - 10 
               Sin[Rational[1, 14] Pi]}, {
              67 - 10 Sin[Rational[1, 7] Pi], 47 - 10 
               Cos[Rational[1, 7] Pi]}}, {{71.33883739117559, 
              37.990311320975806`}, {76.74927912181823, 44.77479066043686}, {
              74.8183148246803, 53.23489801858734}, {67, 57}, {
              59.1816851753197, 53.23489801858734}, {57.25072087818177, 
              44.77479066043686}, {62.66116260882442, 37.990311320975806`}}]],
           
           RegularPolygon[{67, 47}, 10, 7]]}, 
         {RGBColor[
          0.12441231431893574`, 0.9286683538810827, 0.7903907583697836], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{74 + 5 2^Rational[1, 2], 3 - 5 2^Rational[1, 2]}, {
              74 + 5 2^Rational[1, 2], 3 + 5 2^Rational[1, 2]}, {
              74 - 5 2^Rational[1, 2], 3 + 5 2^Rational[1, 2]}, {
              74 - 5 2^Rational[1, 2], 3 - 5 2^Rational[1, 2]}}, {{
             81.07106781186548, -4.0710678118654755`}, {81.07106781186548, 
             10.071067811865476`}, {66.92893218813452, 10.071067811865476`}, {
             66.92893218813452, -4.0710678118654755`}}]],
           RegularPolygon[{74, 3}, 10, 4]]}, 
         {RGBColor[
          0.23860154957557445`, 0.6394877318563028, 0.1451363078641701], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              64 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 50 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
              64 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 50 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {64, 60}, {
              64 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 50 + 
               Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
              64 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 50 + 
               Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{69.87785252292473, 
              41.90983005625053}, {73.51056516295154, 53.09016994374947}, {64,
               60}, {54.489434837048464`, 53.09016994374947}, {
              58.122147477075266`, 41.90983005625053}}]],
           RegularPolygon[{64, 50}, 10, 5]]}, 
         {RGBColor[
          0.4319005239332321, 0.9569725539554408, 0.9522547739960223], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{3 + 5 3^Rational[1, 2], 21}, {3, 36}, {
              3 - 5 3^Rational[1, 2], 21}}, {{11.660254037844386`, 21}, {3, 
              36}, {-5.6602540378443855`, 21}}]],
           RegularPolygon[{3, 26}, 10, 3]]}, 
         {RGBColor[
          0.2843446381627537, 0.18690451244395523`, 0.40542767170641025`], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              66 + 10 Sin[Rational[1, 7] Pi], 80 - 10 
               Cos[Rational[1, 7] Pi]}, {
              66 + 10 Cos[Rational[1, 14] Pi], 80 - 10 
               Sin[Rational[1, 14] Pi]}, {
              66 + 10 Cos[Rational[3, 14] Pi], 80 + 
               10 Sin[Rational[3, 14] Pi]}, {66, 90}, {
              66 - 10 Cos[Rational[3, 14] Pi], 80 + 
               10 Sin[Rational[3, 14] Pi]}, {
              66 - 10 Cos[Rational[1, 14] Pi], 80 - 10 
               Sin[Rational[1, 14] Pi]}, {
              66 - 10 Sin[Rational[1, 7] Pi], 80 - 10 
               Cos[Rational[1, 7] Pi]}}, {{70.33883739117559, 
              70.9903113209758}, {75.74927912181823, 77.77479066043685}, {
              73.8183148246803, 86.23489801858733}, {66, 90}, {
              58.1816851753197, 86.23489801858733}, {56.25072087818177, 
              77.77479066043685}, {61.66116260882442, 70.9903113209758}}]],
           RegularPolygon[{66, 80}, 10, 7]]}, 
         {RGBColor[
          0.3066491372537661, 0.6134626876334246, 0.05619933854074333], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{28 + 5 2^Rational[1, 2], 29 - 5 2^Rational[1, 2]}, {
              28 + 5 2^Rational[1, 2], 29 + 5 2^Rational[1, 2]}, {
              28 - 5 2^Rational[1, 2], 29 + 5 2^Rational[1, 2]}, {
              28 - 5 2^Rational[1, 2], 29 - 5 2^Rational[1, 2]}}, {{
             35.071067811865476`, 21.928932188134524`}, {35.071067811865476`, 
             36.071067811865476`}, {20.928932188134524`, 
             36.071067811865476`}, {20.928932188134524`, 
             21.928932188134524`}}]],
           RegularPolygon[{28, 29}, 10, 4]]}, 
         {RGBColor[
          0.31168541535677785`, 0.22250257824343223`, 0.6999236872964518], 
          Opacity[0.5], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{62 + 5 3^Rational[1, 2], 48}, {62, 63}, {
              62 - 5 3^Rational[1, 2], 48}}, {{70.66025403784438, 48}, {62, 
              63}, {53.33974596215562, 48}}]],
           RegularPolygon[{62, 53}, 10, 3]]}}]], "ExerciseOutput",
       ExpressionUUID->"a39e7f8f-2662-4790-aa06-8aee0b28e2cb"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             RGBColor[
             0.3396745258731211, 0.8270683200943605, 0.48626642727457026`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{19 + 5 3^Rational[1, 2], 87}, {19, 102}, {
                 19 - 5 3^Rational[1, 2], 87}}, {{27.660254037844386`, 87}, {
                 19, 102}, {10.339745962155614`, 87}}]], 
              RegularPolygon[{19, 92}, 10, 3]]}}, {{
             RGBColor[
             0.7065957198785975, 0.7790613773327952, 0.7793200802202469], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 60 + 10 Sin[Rational[1, 8] Pi], 22 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 60 + 10 Cos[Rational[1, 8] Pi], 22 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 60 + 10 Cos[Rational[1, 8] Pi], 22 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 60 + 10 Sin[Rational[1, 8] Pi], 22 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 60 - 10 Sin[Rational[1, 8] Pi], 22 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 60 - 10 Cos[Rational[1, 8] Pi], 22 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 60 - 10 Cos[Rational[1, 8] Pi], 22 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 60 - 10 Sin[Rational[1, 8] Pi], 22 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{63.8268343236509, 
                12.761204674887132`}, {69.23879532511287, 18.1731656763491}, {
                69.23879532511287, 25.8268343236509}, {63.8268343236509, 
                31.238795325112868`}, {56.1731656763491, 
                31.238795325112868`}, {50.76120467488713, 25.8268343236509}, {
                50.76120467488713, 18.1731656763491}, {56.1731656763491, 
                12.761204674887132`}}]], 
              RegularPolygon[{60, 22}, 10, 8]]}}, {{
             RGBColor[
             0.08516952371737196, 0.2533713349882585, 0.41701379410105055`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 34 + 10 Sin[Rational[1, 7] Pi], 73 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 34 + 10 Cos[Rational[1, 14] Pi], 73 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 34 + 10 Cos[Rational[3, 14] Pi], 73 + 
                  10 Sin[Rational[3, 14] Pi]}, {34, 83}, {
                 34 - 10 Cos[Rational[3, 14] Pi], 73 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 34 - 10 Cos[Rational[1, 14] Pi], 73 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 34 - 10 Sin[Rational[1, 7] Pi], 73 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{38.33883739117558, 
                 63.990311320975806`}, {43.74927912181823, 
                 70.77479066043685}, {41.8183148246803, 79.23489801858733}, {
                 34, 83}, {26.1816851753197, 79.23489801858733}, {
                 24.250720878181763`, 70.77479066043685}, {29.66116260882442, 
                 63.990311320975806`}}]], 
              RegularPolygon[{34, 73}, 10, 7]]}}, {{
             RGBColor[
             0.17032155069250687`, 0.8054895630938566, 0.011000963315223267`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{23 + 5 2^Rational[1, 2], 73 - 5 2^Rational[1, 2]}, {
                 23 + 5 2^Rational[1, 2], 73 + 5 2^Rational[1, 2]}, {
                 23 - 5 2^Rational[1, 2], 73 + 5 2^Rational[1, 2]}, {
                 23 - 5 2^Rational[1, 2], 73 - 5 2^Rational[1, 2]}}, {{
                30.071067811865476`, 65.92893218813452}, {30.071067811865476`,
                 80.07106781186548}, {15.928932188134524`, 
                80.07106781186548}, {15.928932188134524`, 
                65.92893218813452}}]], 
              RegularPolygon[{23, 73}, 10, 4]]}}, {{
             RGBColor[
             0.9179751122780282, 0.10812814496602963`, 0.6381906374709023], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 94 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 84 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 94 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 84 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {94, 94}, {
                 94 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 84 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 94 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 84 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 99.87785252292473, 75.90983005625053}, {103.51056516295154`, 
                 87.09016994374947}, {94, 94}, {84.48943483704846, 
                 87.09016994374947}, {88.12214747707527, 
                 75.90983005625053}}]], 
              RegularPolygon[{94, 84}, 10, 5]]}}, {{
             RGBColor[
             0.07008661207818534, 0.4213510508370366, 0.321581311413204], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{50, 93 - 5 3^Rational[1, 2]}, {55, 93}, {
                 50, 93 + 5 3^Rational[1, 2]}, {
                 40, 93 + 5 3^Rational[1, 2]}, {35, 93}, {
                 40, 93 - 5 3^Rational[1, 2]}}, {{50, 84.33974596215562}, {55,
                  93}, {50, 101.66025403784438`}, {40, 101.66025403784438`}, {
                 35, 93}, {40, 84.33974596215562}}]], 
              RegularPolygon[{45, 93}, 10, 6]]}}, {{
             RGBColor[
             0.48491964991746106`, 0.7634448484660599, 0.2503350801689681], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{4 + 5 3^Rational[1, 2], 80}, {4, 95}, {
                 4 - 5 3^Rational[1, 2], 80}}, {{12.660254037844386`, 80}, {4,
                  95}, {-4.6602540378443855`, 80}}]], 
              RegularPolygon[{4, 85}, 10, 3]]}}, {{
             RGBColor[
             0.29798126028877725`, 0.3071424017557691, 0.07969641141077011], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{37 + 5 3^Rational[1, 2], -1}, {37, 14}, {
                 37 - 5 3^Rational[1, 2], -1}}, {{45.66025403784438, -1}, {37,
                  14}, {28.339745962155614`, -1}}]], 
              RegularPolygon[{37, 4}, 10, 3]]}}, {{
             RGBColor[
             0.3917369142802476, 0.6722133734308067, 0.37927507001132854`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 34 + 10 Sin[Rational[1, 7] Pi], 51 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 34 + 10 Cos[Rational[1, 14] Pi], 51 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 34 + 10 Cos[Rational[3, 14] Pi], 51 + 
                  10 Sin[Rational[3, 14] Pi]}, {34, 61}, {
                 34 - 10 Cos[Rational[3, 14] Pi], 51 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 34 - 10 Cos[Rational[1, 14] Pi], 51 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 34 - 10 Sin[Rational[1, 7] Pi], 51 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{38.33883739117558, 
                 41.990311320975806`}, {43.74927912181823, 
                 48.77479066043686}, {41.8183148246803, 57.23489801858734}, {
                 34, 61}, {26.1816851753197, 57.23489801858734}, {
                 24.250720878181763`, 48.77479066043686}, {29.66116260882442, 
                 41.990311320975806`}}]], 
              RegularPolygon[{34, 51}, 10, 7]]}}, {{
             RGBColor[
             0.4845716900583088, 0.11457208869874025`, 0.22537050318895058`], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 55 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 7 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 55 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 7 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {55, 17}, {
                 55 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 7 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 55 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 7 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 60.877852522924734`, -1.0901699437494745`}, {
                 64.51056516295154, 10.090169943749475`}, {55, 17}, {
                 45.489434837048464`, 10.090169943749475`}, {
                 49.122147477075266`, -1.0901699437494745`}}]], 
              RegularPolygon[{55, 7}, 10, 5]]}}, {{
             RGBColor[
             0.040545690086605246`, 0.6914920096842319, 0.9333148707958092], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 24 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 20 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 24 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 20 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {24, 30}, {
                 24 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 20 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 24 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 20 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 29.877852522924734`, 11.909830056250525`}, {
                 33.510565162951536`, 23.090169943749473`}, {24, 30}, {
                 14.489434837048465`, 23.090169943749473`}, {
                 18.122147477075266`, 11.909830056250525`}}]], 
              RegularPolygon[{24, 20}, 10, 5]]}}, {{
             RGBColor[
             0.19908731919587086`, 0.008564856736899662, 0.6760074959663931], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 26 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 96 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 26 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 96 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {26, 106}, {
                 26 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 96 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 26 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 96 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 31.877852522924734`, 87.90983005625053}, {
                 35.510565162951536`, 99.09016994374947}, {26, 106}, {
                 16.489434837048464`, 99.09016994374947}, {
                 20.122147477075266`, 87.90983005625053}}]], 
              RegularPolygon[{26, 96}, 10, 5]]}}, {{
             RGBColor[
             0.7013115011946318, 0.8850821847262835, 0.5324305394846776], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{5, 93 - 5 3^Rational[1, 2]}, {10, 93}, {
                 5, 93 + 5 3^Rational[1, 2]}, {-5, 93 + 
                  5 3^Rational[1, 2]}, {-10, 
                 93}, {-5, 93 - 5 3^Rational[1, 2]}}, {{
                 5, 84.33974596215562}, {10, 93}, {
                 5, 101.66025403784438`}, {-5, 101.66025403784438`}, {-10, 
                 93}, {-5, 84.33974596215562}}]], 
              RegularPolygon[{0, 93}, 10, 6]]}}, {{
             RGBColor[
             0.7412998854751585, 0.5023068276375928, 0.3259873718510353], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 48 + 10 Sin[Rational[1, 8] Pi], 37 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 48 + 10 Cos[Rational[1, 8] Pi], 37 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 48 + 10 Cos[Rational[1, 8] Pi], 37 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 48 + 10 Sin[Rational[1, 8] Pi], 37 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 48 - 10 Sin[Rational[1, 8] Pi], 37 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 48 - 10 Cos[Rational[1, 8] Pi], 37 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 48 - 10 Cos[Rational[1, 8] Pi], 37 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 48 - 10 Sin[Rational[1, 8] Pi], 37 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{51.8268343236509, 
                27.761204674887132`}, {57.23879532511287, 33.1731656763491}, {
                57.23879532511287, 40.8268343236509}, {51.8268343236509, 
                46.23879532511287}, {44.1731656763491, 46.23879532511287}, {
                38.76120467488713, 40.8268343236509}, {38.76120467488713, 
                33.1731656763491}, {44.1731656763491, 27.761204674887132`}}]], 
              RegularPolygon[{48, 37}, 10, 8]]}}, {{
             RGBColor[
             0.4082644326160796, 0.5064692825154098, 0.5359906665273428], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 21 + 10 Sin[Rational[1, 8] Pi], 56 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 21 + 10 Cos[Rational[1, 8] Pi], 56 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 21 + 10 Cos[Rational[1, 8] Pi], 56 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 21 + 10 Sin[Rational[1, 8] Pi], 56 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 21 - 10 Sin[Rational[1, 8] Pi], 56 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 21 - 10 Cos[Rational[1, 8] Pi], 56 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 21 - 10 Cos[Rational[1, 8] Pi], 56 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 21 - 10 Sin[Rational[1, 8] Pi], 56 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{24.8268343236509, 
                46.76120467488713}, {30.238795325112868`, 52.1731656763491}, {
                30.238795325112868`, 59.8268343236509}, {24.8268343236509, 
                65.23879532511287}, {17.1731656763491, 65.23879532511287}, {
                11.761204674887132`, 59.8268343236509}, {11.761204674887132`, 
                52.1731656763491}, {17.1731656763491, 46.76120467488713}}]], 
              RegularPolygon[{21, 56}, 10, 8]]}}, {{
             RGBColor[
             0.48951802645519327`, 0.041240982521276504`, 0.6304189890016287], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 29 + 10 Sin[Rational[1, 7] Pi], 11 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 29 + 10 Cos[Rational[1, 14] Pi], 11 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 29 + 10 Cos[Rational[3, 14] Pi], 11 + 
                  10 Sin[Rational[3, 14] Pi]}, {29, 21}, {
                 29 - 10 Cos[Rational[3, 14] Pi], 11 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 29 - 10 Cos[Rational[1, 14] Pi], 11 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 29 - 10 Sin[Rational[1, 7] Pi], 11 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{33.33883739117558, 
                 1.9903113209758079`}, {38.74927912181823, 
                 8.774790660436857}, {36.8183148246803, 
                 17.234898018587334`}, {29, 21}, {21.1816851753197, 
                 17.234898018587334`}, {19.250720878181763`, 
                 8.774790660436857}, {24.66116260882442, 
                 1.9903113209758079`}}]], 
              RegularPolygon[{29, 11}, 10, 7]]}}, {{
             RGBColor[
             0.8663949967194648, 0.9638818220691363, 0.017232945051648185`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 51 + 10 Sin[Rational[1, 7] Pi], 11 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 51 + 10 Cos[Rational[1, 14] Pi], 11 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 51 + 10 Cos[Rational[3, 14] Pi], 11 + 
                  10 Sin[Rational[3, 14] Pi]}, {51, 21}, {
                 51 - 10 Cos[Rational[3, 14] Pi], 11 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 51 - 10 Cos[Rational[1, 14] Pi], 11 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 51 - 10 Sin[Rational[1, 7] Pi], 11 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{55.33883739117558, 
                 1.9903113209758079`}, {60.74927912181823, 
                 8.774790660436857}, {58.8183148246803, 
                 17.234898018587334`}, {51, 21}, {43.1816851753197, 
                 17.234898018587334`}, {41.25072087818177, 
                 8.774790660436857}, {46.66116260882442, 
                 1.9903113209758079`}}]], 
              RegularPolygon[{51, 11}, 10, 7]]}}, {{
             RGBColor[
             0.6786867928076816, 0.8658020122195118, 0.30686289709463077`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 52 + 10 Sin[Rational[1, 7] Pi], 11 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 52 + 10 Cos[Rational[1, 14] Pi], 11 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 52 + 10 Cos[Rational[3, 14] Pi], 11 + 
                  10 Sin[Rational[3, 14] Pi]}, {52, 21}, {
                 52 - 10 Cos[Rational[3, 14] Pi], 11 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 52 - 10 Cos[Rational[1, 14] Pi], 11 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 52 - 10 Sin[Rational[1, 7] Pi], 11 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{56.33883739117558, 
                 1.9903113209758079`}, {61.74927912181823, 
                 8.774790660436857}, {59.8183148246803, 
                 17.234898018587334`}, {52, 21}, {44.1816851753197, 
                 17.234898018587334`}, {42.25072087818177, 
                 8.774790660436857}, {47.66116260882442, 
                 1.9903113209758079`}}]], 
              RegularPolygon[{52, 11}, 10, 7]]}}, {{
             RGBColor[
             0.3258776865462165, 0.16832512679921474`, 0.06877407866586127], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{76 + 5 3^Rational[1, 2], 73}, {76, 88}, {
                 76 - 5 3^Rational[1, 2], 73}}, {{84.66025403784438, 73}, {76,
                  88}, {67.33974596215562, 73}}]], 
              RegularPolygon[{76, 78}, 10, 3]]}}, {{
             RGBColor[
             0.3186940673345855, 0.27435200048969977`, 0.5901295067300902], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{53 + 5 3^Rational[1, 2], 87}, {53, 102}, {
                 53 - 5 3^Rational[1, 2], 87}}, {{61.66025403784438, 87}, {53,
                  102}, {44.33974596215562, 87}}]], 
              RegularPolygon[{53, 92}, 10, 3]]}}, {{
             RGBColor[
             0.12351011670731449`, 0.9636832470999681, 0.26144293325161105`], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 74 + 10 Sin[Rational[1, 8] Pi], 24 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 74 + 10 Cos[Rational[1, 8] Pi], 24 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 74 + 10 Cos[Rational[1, 8] Pi], 24 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 74 + 10 Sin[Rational[1, 8] Pi], 24 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 74 - 10 Sin[Rational[1, 8] Pi], 24 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 74 - 10 Cos[Rational[1, 8] Pi], 24 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 74 - 10 Cos[Rational[1, 8] Pi], 24 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 74 - 10 Sin[Rational[1, 8] Pi], 24 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{77.8268343236509, 
                14.761204674887132`}, {83.23879532511287, 20.1731656763491}, {
                83.23879532511287, 27.8268343236509}, {77.8268343236509, 
                33.23879532511287}, {70.1731656763491, 33.23879532511287}, {
                64.76120467488713, 27.8268343236509}, {64.76120467488713, 
                20.1731656763491}, {70.1731656763491, 14.761204674887132`}}]], 
              RegularPolygon[{74, 24}, 10, 8]]}}, {{
             RGBColor[
             0.1487583577118634, 0.8176924720879759, 0.9148609028706269], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{29 + 5 3^Rational[1, 2], 59}, {29, 74}, {
                 29 - 5 3^Rational[1, 2], 59}}, {{37.66025403784438, 59}, {29,
                  74}, {20.339745962155614`, 59}}]], 
              RegularPolygon[{29, 64}, 10, 3]]}}, {{
             RGBColor[
             0.9835414972086658, 0.9252127249623048, 0.9572565471557801], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{52, 44 - 5 3^Rational[1, 2]}, {57, 44}, {
                 52, 44 + 5 3^Rational[1, 2]}, {
                 42, 44 + 5 3^Rational[1, 2]}, {37, 44}, {
                 42, 44 - 5 3^Rational[1, 2]}}, {{52, 35.33974596215562}, {57,
                  44}, {52, 52.66025403784438}, {42, 52.66025403784438}, {37, 
                 44}, {42, 35.33974596215562}}]], 
              RegularPolygon[{47, 44}, 10, 6]]}}, {{
             RGBColor[
             0.08933232655327306, 0.38449881481669235`, 0.8501437293722958], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 3 + 10 Sin[Rational[1, 8] Pi], 51 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 3 + 10 Cos[Rational[1, 8] Pi], 51 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 3 + 10 Cos[Rational[1, 8] Pi], 51 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 3 + 10 Sin[Rational[1, 8] Pi], 51 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 3 - 10 Sin[Rational[1, 8] Pi], 51 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 3 - 10 Cos[Rational[1, 8] Pi], 51 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 3 - 10 Cos[Rational[1, 8] Pi], 51 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 3 - 10 Sin[Rational[1, 8] Pi], 51 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{6.826834323650898, 
                41.76120467488713}, {12.238795325112868`, 47.1731656763491}, {
                12.238795325112868`, 54.8268343236509}, {6.826834323650898, 
                60.23879532511287}, {-0.8268343236508979, 
                60.23879532511287}, {-6.238795325112868, 
                54.8268343236509}, {-6.238795325112868, 
                47.1731656763491}, {-0.8268343236508979, 
                41.76120467488713}}]], 
              RegularPolygon[{3, 51}, 10, 8]]}}, {{
             RGBColor[
             0.5160868296166465, 0.3093904250098589, 0.39961009054766206`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 89 + 10 Sin[Rational[1, 8] Pi], 83 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 89 + 10 Cos[Rational[1, 8] Pi], 83 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 89 + 10 Cos[Rational[1, 8] Pi], 83 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 89 + 10 Sin[Rational[1, 8] Pi], 83 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 89 - 10 Sin[Rational[1, 8] Pi], 83 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 89 - 10 Cos[Rational[1, 8] Pi], 83 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 89 - 10 Cos[Rational[1, 8] Pi], 83 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 89 - 10 Sin[Rational[1, 8] Pi], 83 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{92.8268343236509, 
                73.76120467488713}, {98.23879532511287, 79.1731656763491}, {
                98.23879532511287, 86.8268343236509}, {92.8268343236509, 
                92.23879532511287}, {85.1731656763491, 92.23879532511287}, {
                79.76120467488713, 86.8268343236509}, {79.76120467488713, 
                79.1731656763491}, {85.1731656763491, 73.76120467488713}}]], 
              RegularPolygon[{89, 83}, 10, 8]]}}, {{
             RGBColor[
             0.532051493354891, 0.23241846820826528`, 0.5620571695708585], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{64, 6 - 5 3^Rational[1, 2]}, {69, 6}, {
                 64, 6 + 5 3^Rational[1, 2]}, {54, 6 + 5 3^Rational[1, 2]}, {
                 49, 6}, {54, 6 - 5 3^Rational[1, 2]}}, {{
                 64, -2.6602540378443855`}, {69, 6}, {
                 64, 14.660254037844386`}, {54, 14.660254037844386`}, {49, 
                 6}, {54, -2.6602540378443855`}}]], 
              RegularPolygon[{59, 6}, 10, 6]]}}, {{
             RGBColor[
             0.1364509437136594, 0.12924070538473487`, 0.7856113777741496], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 30 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 94 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 30 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 94 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {30, 104}, {
                 30 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 94 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 30 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 94 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 35.877852522924734`, 85.90983005625053}, {
                 39.510565162951536`, 97.09016994374947}, {30, 104}, {
                 20.489434837048464`, 97.09016994374947}, {
                 24.122147477075266`, 85.90983005625053}}]], 
              RegularPolygon[{30, 94}, 10, 5]]}}, {{
             RGBColor[
             0.05310753244600108, 0.7104357291660051, 0.44479420599973096`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{37, 40 - 5 3^Rational[1, 2]}, {42, 40}, {
                 37, 40 + 5 3^Rational[1, 2]}, {
                 27, 40 + 5 3^Rational[1, 2]}, {22, 40}, {
                 27, 40 - 5 3^Rational[1, 2]}}, {{37, 31.339745962155614`}, {
                 42, 40}, {37, 48.66025403784438}, {27, 48.66025403784438}, {
                 22, 40}, {27, 31.339745962155614`}}]], 
              RegularPolygon[{32, 40}, 10, 6]]}}, {{
             RGBColor[
             0.7346109518647743, 0.36616087898851113`, 0.6355148632492338], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{67, 74 - 5 3^Rational[1, 2]}, {72, 74}, {
                 67, 74 + 5 3^Rational[1, 2]}, {
                 57, 74 + 5 3^Rational[1, 2]}, {52, 74}, {
                 57, 74 - 5 3^Rational[1, 2]}}, {{67, 65.33974596215562}, {72,
                  74}, {67, 82.66025403784438}, {57, 82.66025403784438}, {52, 
                 74}, {57, 65.33974596215562}}]], 
              RegularPolygon[{62, 74}, 10, 6]]}}, {{
             RGBColor[
             0.88904594960253, 0.1426256110003774, 0.5426113272833943], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{86 + 5 3^Rational[1, 2], 44}, {86, 59}, {
                 86 - 5 3^Rational[1, 2], 44}}, {{94.66025403784438, 44}, {86,
                  59}, {77.33974596215562, 44}}]], 
              RegularPolygon[{86, 49}, 10, 3]]}}, {{
             RGBColor[
             0.6356257653462558, 0.8118702539140812, 0.4894669854006273], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 39 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 88 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 39 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 88 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {39, 98}, {
                 39 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 88 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 39 - 
                  10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 88 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 44.877852522924734`, 79.90983005625053}, {
                 48.510565162951536`, 91.09016994374947}, {39, 98}, {
                 29.489434837048464`, 91.09016994374947}, {
                 33.122147477075266`, 79.90983005625053}}]], 
              RegularPolygon[{39, 88}, 10, 5]]}}, {{
             RGBColor[
             0.03443366935766412, 0.3043133766857462, 0.8414745077070249], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{34 + 5 2^Rational[1, 2], 15 - 5 2^Rational[1, 2]}, {
                 34 + 5 2^Rational[1, 2], 15 + 5 2^Rational[1, 2]}, {
                 34 - 5 2^Rational[1, 2], 15 + 5 2^Rational[1, 2]}, {
                 34 - 5 2^Rational[1, 2], 15 - 5 2^Rational[1, 2]}}, {{
                41.071067811865476`, 7.9289321881345245`}, {
                41.071067811865476`, 22.071067811865476`}, {
                26.928932188134524`, 22.071067811865476`}, {
                26.928932188134524`, 7.9289321881345245`}}]], 
              RegularPolygon[{34, 15}, 10, 4]]}}, {{
             RGBColor[
             0.6067134242453611, 0.5914788817779291, 0.6581120094750317], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 72 + 10 Sin[Rational[1, 7] Pi], 1 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 72 + 10 Cos[Rational[1, 14] Pi], 1 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 72 + 10 Cos[Rational[3, 14] Pi], 1 + 
                  10 Sin[Rational[3, 14] Pi]}, {72, 11}, {
                 72 - 10 Cos[Rational[3, 14] Pi], 1 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 72 - 10 Cos[Rational[1, 14] Pi], 1 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 72 - 10 Sin[Rational[1, 7] Pi], 1 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{
                 76.33883739117559, -8.009688679024192}, {
                 81.74927912181823, -1.2252093395631438`}, {79.8183148246803, 
                 7.234898018587335}, {72, 11}, {64.1816851753197, 
                 7.234898018587335}, {
                 62.25072087818177, -1.2252093395631438`}, {
                 67.66116260882441, -8.009688679024192}}]], 
              RegularPolygon[{72, 1}, 10, 7]]}}, {{
             RGBColor[
             0.883059134610223, 0.6304981241972059, 0.7650819226132299], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 63 + 10 Sin[Rational[1, 7] Pi], 87 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 63 + 10 Cos[Rational[1, 14] Pi], 87 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 63 + 10 Cos[Rational[3, 14] Pi], 87 + 
                  10 Sin[Rational[3, 14] Pi]}, {63, 97}, {
                 63 - 10 Cos[Rational[3, 14] Pi], 87 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 63 - 10 Cos[Rational[1, 14] Pi], 87 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 63 - 10 Sin[Rational[1, 7] Pi], 87 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{67.33883739117559, 
                 77.9903113209758}, {72.74927912181823, 84.77479066043685}, {
                 70.8183148246803, 93.23489801858733}, {63, 97}, {
                 55.1816851753197, 93.23489801858733}, {53.25072087818177, 
                 84.77479066043685}, {58.66116260882442, 77.9903113209758}}]], 
              RegularPolygon[{63, 87}, 10, 7]]}}, {{
             RGBColor[
             0.22820673917620238`, 0.14229824153922332`, 0.09302105515486869], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{36 + 5 3^Rational[1, 2], 94}, {36, 109}, {
                 36 - 5 3^Rational[1, 2], 94}}, {{44.66025403784438, 94}, {36,
                  109}, {27.339745962155614`, 94}}]], 
              RegularPolygon[{36, 99}, 10, 3]]}}, {{
             RGBColor[
             0.32518332784195403`, 0.9021976996613916, 0.4222693420364356], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{21 + 5 2^Rational[1, 2], 99 - 5 2^Rational[1, 2]}, {
                 21 + 5 2^Rational[1, 2], 99 + 5 2^Rational[1, 2]}, {
                 21 - 5 2^Rational[1, 2], 99 + 5 2^Rational[1, 2]}, {
                 21 - 5 2^Rational[1, 2], 99 - 5 2^Rational[1, 2]}}, {{
                28.071067811865476`, 91.92893218813452}, {28.071067811865476`,
                 106.07106781186548`}, {13.928932188134524`, 
                106.07106781186548`}, {13.928932188134524`, 
                91.92893218813452}}]], 
              RegularPolygon[{21, 99}, 10, 4]]}}, {{
             RGBColor[
             0.07519406604965284, 0.17297384098476365`, 0.5799490184483234], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 60 + 10 Sin[Rational[1, 8] Pi], 34 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 60 + 10 Cos[Rational[1, 8] Pi], 34 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 60 + 10 Cos[Rational[1, 8] Pi], 34 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 60 + 10 Sin[Rational[1, 8] Pi], 34 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 60 - 10 Sin[Rational[1, 8] Pi], 34 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 60 - 10 Cos[Rational[1, 8] Pi], 34 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 60 - 10 Cos[Rational[1, 8] Pi], 34 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 60 - 10 Sin[Rational[1, 8] Pi], 34 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{63.8268343236509, 
                24.761204674887132`}, {69.23879532511287, 30.1731656763491}, {
                69.23879532511287, 37.8268343236509}, {63.8268343236509, 
                43.23879532511287}, {56.1731656763491, 43.23879532511287}, {
                50.76120467488713, 37.8268343236509}, {50.76120467488713, 
                30.1731656763491}, {56.1731656763491, 24.761204674887132`}}]], 
              RegularPolygon[{60, 34}, 10, 8]]}}, {{
             RGBColor[
             0.6054180011032666, 0.8238005061786104, 0.4430508947196159], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 55 + 10 Sin[Rational[1, 8] Pi], 67 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 55 + 10 Cos[Rational[1, 8] Pi], 67 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 55 + 10 Cos[Rational[1, 8] Pi], 67 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 55 + 10 Sin[Rational[1, 8] Pi], 67 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 55 - 10 Sin[Rational[1, 8] Pi], 67 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 55 - 10 Cos[Rational[1, 8] Pi], 67 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 55 - 10 Cos[Rational[1, 8] Pi], 67 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 55 - 10 Sin[Rational[1, 8] Pi], 67 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{58.8268343236509, 
                57.76120467488713}, {64.23879532511287, 63.1731656763491}, {
                64.23879532511287, 70.8268343236509}, {58.8268343236509, 
                76.23879532511287}, {51.1731656763491, 76.23879532511287}, {
                45.76120467488713, 70.8268343236509}, {45.76120467488713, 
                63.1731656763491}, {51.1731656763491, 57.76120467488713}}]], 
              RegularPolygon[{55, 67}, 10, 8]]}}, {{
             RGBColor[
             0.01451010069836256, 0.9166076617302117, 0.26045947202173747`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 65 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 59 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 65 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 59 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {65, 69}, {
                 65 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 59 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 65 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 59 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 70.87785252292473, 50.90983005625053}, {74.51056516295154, 
                 62.09016994374947}, {65, 69}, {55.489434837048464`, 
                 62.09016994374947}, {59.122147477075266`, 
                 50.90983005625053}}]], 
              RegularPolygon[{65, 59}, 10, 5]]}}, {{
             RGBColor[
             0.35726854625421045`, 0.763613800275103, 0.6487240846127984], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{74 + 5 2^Rational[1, 2], 76 - 5 2^Rational[1, 2]}, {
                 74 + 5 2^Rational[1, 2], 76 + 5 2^Rational[1, 2]}, {
                 74 - 5 2^Rational[1, 2], 76 + 5 2^Rational[1, 2]}, {
                 74 - 5 2^Rational[1, 2], 76 - 5 2^Rational[1, 2]}}, {{
                81.07106781186548, 68.92893218813452}, {81.07106781186548, 
                83.07106781186548}, {66.92893218813452, 83.07106781186548}, {
                66.92893218813452, 68.92893218813452}}]], 
              RegularPolygon[{74, 76}, 10, 4]]}}, {{
             RGBColor[
             0.9829001011491747, 0.6408852556322993, 0.5359765604624989], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{102, 15 - 5 3^Rational[1, 2]}, {107, 15}, {
                 102, 15 + 5 3^Rational[1, 2]}, {
                 92, 15 + 5 3^Rational[1, 2]}, {87, 15}, {
                 92, 15 - 5 3^Rational[1, 2]}}, {{102, 6.3397459621556145`}, {
                 107, 15}, {102, 23.660254037844386`}, {
                 92, 23.660254037844386`}, {87, 15}, {
                 92, 6.3397459621556145`}}]], 
              RegularPolygon[{97, 15}, 10, 6]]}}, {{
             RGBColor[
             0.976492585186874, 0.04068707751497591, 0.19132790388553755`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{18 + 5 2^Rational[1, 2], 8 - 5 2^Rational[1, 2]}, {
                 18 + 5 2^Rational[1, 2], 8 + 5 2^Rational[1, 2]}, {
                 18 - 5 2^Rational[1, 2], 8 + 5 2^Rational[1, 2]}, {
                 18 - 5 2^Rational[1, 2], 8 - 5 2^Rational[1, 2]}}, {{
                25.071067811865476`, 0.9289321881345245}, {
                25.071067811865476`, 15.071067811865476`}, {
                10.928932188134524`, 15.071067811865476`}, {
                10.928932188134524`, 0.9289321881345245}}]], 
              RegularPolygon[{18, 8}, 10, 4]]}}, {{
             RGBColor[
             0.7467419855277684, 0.7812253058840126, 0.3406156645278797], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 20 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 2 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 20 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 2 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {20, 12}, {
                 20 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 2 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 20 - 
                  10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 2 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 25.877852522924734`, -6.0901699437494745`}, {
                 29.510565162951536`, 5.0901699437494745`}, {20, 12}, {
                 10.489434837048465`, 5.0901699437494745`}, {
                 14.122147477075268`, -6.0901699437494745`}}]], 
              RegularPolygon[{20, 2}, 10, 5]]}}, {{
             RGBColor[
             0.0193557230586634, 0.3379879836367885, 0.08902427705687854], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 11 + 10 Sin[Rational[1, 7] Pi], 9 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 11 + 10 Cos[Rational[1, 14] Pi], 9 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 11 + 10 Cos[Rational[3, 14] Pi], 9 + 
                  10 Sin[Rational[3, 14] Pi]}, {11, 19}, {
                 11 - 10 Cos[Rational[3, 14] Pi], 9 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 11 - 10 Cos[Rational[1, 14] Pi], 9 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 11 - 10 Sin[Rational[1, 7] Pi], 9 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{
                 15.33883739117558, -0.009688679024192126}, {
                 20.749279121818237`, 6.774790660436857}, {18.8183148246803, 
                 15.234898018587334`}, {11, 19}, {3.1816851753197017`, 
                 15.234898018587334`}, {1.2507208781817631`, 
                 6.774790660436857}, {
                 6.6611626088244185`, -0.009688679024192126}}]], 
              RegularPolygon[{11, 9}, 10, 7]]}}, {{
             RGBColor[
             0.13124600572776246`, 0.7344400646370504, 0.872053375519978], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{15, (-5) 3^Rational[1, 2]}, {20, 0}, {
                 15, 5 3^Rational[1, 2]}, {5, 5 3^Rational[1, 2]}, {0, 0}, {
                 5, (-5) 3^Rational[1, 2]}}, {{15, -8.660254037844386}, {20, 
                 0}, {15, 8.660254037844386}, {5, 8.660254037844386}, {0, 
                 0}, {5, -8.660254037844386}}]], 
              RegularPolygon[{10, 0}, 10, 6]]}}, {{
             RGBColor[
             0.3528879181298368, 0.13324035457063443`, 0.43431343034810244`], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 23 + 10 Sin[Rational[1, 7] Pi], 20 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 23 + 10 Cos[Rational[1, 14] Pi], 20 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 23 + 10 Cos[Rational[3, 14] Pi], 20 + 
                  10 Sin[Rational[3, 14] Pi]}, {23, 30}, {
                 23 - 10 Cos[Rational[3, 14] Pi], 20 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 23 - 10 Cos[Rational[1, 14] Pi], 20 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 23 - 10 Sin[Rational[1, 7] Pi], 20 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{27.33883739117558, 
                 10.990311320975808`}, {32.74927912181823, 
                 17.774790660436857`}, {30.8183148246803, 
                 26.234898018587334`}, {23, 30}, {15.181685175319702`, 
                 26.234898018587334`}, {13.250720878181763`, 
                 17.774790660436857`}, {18.66116260882442, 
                 10.990311320975808`}}]], 
              RegularPolygon[{23, 20}, 10, 7]]}}, {{
             RGBColor[
             0.5776639155614913, 0.6462899221702223, 0.7542952055843306], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 32 + 10 Sin[Rational[1, 7] Pi], 77 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 32 + 10 Cos[Rational[1, 14] Pi], 77 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 32 + 10 Cos[Rational[3, 14] Pi], 77 + 
                  10 Sin[Rational[3, 14] Pi]}, {32, 87}, {
                 32 - 10 Cos[Rational[3, 14] Pi], 77 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 32 - 10 Cos[Rational[1, 14] Pi], 77 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 32 - 10 Sin[Rational[1, 7] Pi], 77 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{36.33883739117558, 
                 67.9903113209758}, {41.74927912181823, 74.77479066043685}, {
                 39.8183148246803, 83.23489801858733}, {32, 87}, {
                 24.1816851753197, 83.23489801858733}, {22.250720878181763`, 
                 74.77479066043685}, {27.66116260882442, 67.9903113209758}}]], 
              RegularPolygon[{32, 77}, 10, 7]]}}, {{
             RGBColor[
             0.3161404217475605, 0.364697119934863, 0.7831464717902363], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 91 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 39 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 91 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 39 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {91, 49}, {
                 91 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 39 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 91 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 39 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 96.87785252292473, 30.909830056250527`}, {
                 100.51056516295154`, 42.09016994374947}, {91, 49}, {
                 81.48943483704846, 42.09016994374947}, {85.12214747707527, 
                 30.909830056250527`}}]], 
              RegularPolygon[{91, 39}, 10, 5]]}}, {{
             RGBColor[
             0.26711426099682045`, 0.02584679625383779, 0.9072981938146223], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{22 + 5 3^Rational[1, 2], 42}, {22, 57}, {
                 22 - 5 3^Rational[1, 2], 42}}, {{30.660254037844386`, 42}, {
                 22, 57}, {13.339745962155614`, 42}}]], 
              RegularPolygon[{22, 47}, 10, 3]]}}, {{
             RGBColor[
             0.930841359532556, 0.19235596077250694`, 0.6086319826628983], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 47 + 10 Sin[Rational[1, 7] Pi], 51 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 47 + 10 Cos[Rational[1, 14] Pi], 51 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 47 + 10 Cos[Rational[3, 14] Pi], 51 + 
                  10 Sin[Rational[3, 14] Pi]}, {47, 61}, {
                 47 - 10 Cos[Rational[3, 14] Pi], 51 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 47 - 10 Cos[Rational[1, 14] Pi], 51 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 47 - 10 Sin[Rational[1, 7] Pi], 51 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{51.33883739117558, 
                 41.990311320975806`}, {56.74927912181823, 
                 48.77479066043686}, {54.8183148246803, 57.23489801858734}, {
                 47, 61}, {39.1816851753197, 57.23489801858734}, {
                 37.25072087818177, 48.77479066043686}, {42.66116260882442, 
                 41.990311320975806`}}]], 
              RegularPolygon[{47, 51}, 10, 7]]}}, {{
             RGBColor[
             0.1119442892722482, 0.5744370791817177, 0.04797974220893253], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 65 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 78 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 65 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 78 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {65, 88}, {
                 65 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 78 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 65 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 78 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 70.87785252292473, 69.90983005625053}, {74.51056516295154, 
                 81.09016994374947}, {65, 88}, {55.489434837048464`, 
                 81.09016994374947}, {59.122147477075266`, 
                 69.90983005625053}}]], 
              RegularPolygon[{65, 78}, 10, 5]]}}, {{
             RGBColor[
             0.2697157671406669, 0.795222227485793, 0.31350739945795625`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{67 + 5 2^Rational[1, 2], 89 - 5 2^Rational[1, 2]}, {
                 67 + 5 2^Rational[1, 2], 89 + 5 2^Rational[1, 2]}, {
                 67 - 5 2^Rational[1, 2], 89 + 5 2^Rational[1, 2]}, {
                 67 - 5 2^Rational[1, 2], 89 - 5 2^Rational[1, 2]}}, {{
                74.07106781186548, 81.92893218813452}, {74.07106781186548, 
                96.07106781186548}, {59.928932188134524`, 
                96.07106781186548}, {59.928932188134524`, 
                81.92893218813452}}]], 
              RegularPolygon[{67, 89}, 10, 4]]}}, {{
             RGBColor[
             0.3382259614318679, 0.8182899274584505, 0.5152311994058298], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 3 + 10 Sin[Rational[1, 8] Pi], 2 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 3 + 10 Cos[Rational[1, 8] Pi], 2 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 3 + 10 Cos[Rational[1, 8] Pi], 2 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 3 + 10 Sin[Rational[1, 8] Pi], 2 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 3 - 10 Sin[Rational[1, 8] Pi], 2 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 3 - 10 Cos[Rational[1, 8] Pi], 2 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 3 - 10 Cos[Rational[1, 8] Pi], 2 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 3 - 10 Sin[Rational[1, 8] Pi], 2 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{
                6.826834323650898, -7.238795325112868}, {
                12.238795325112868`, -1.826834323650898}, {
                12.238795325112868`, 5.826834323650898}, {6.826834323650898, 
                11.238795325112868`}, {-0.8268343236508979, 
                11.238795325112868`}, {-6.238795325112868, 
                5.826834323650898}, {-6.238795325112868, -1.826834323650898}, \
{-0.8268343236508979, -7.238795325112868}}]], 
              RegularPolygon[{3, 2}, 10, 8]]}}, {{
             RGBColor[
             0.9546284342773053, 0.7705515085669739, 0.0023347644024838132`], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{104, (-5) 3^Rational[1, 2]}, {109, 0}, {
                 104, 5 3^Rational[1, 2]}, {94, 5 3^Rational[1, 2]}, {89, 
                 0}, {94, (-5) 3^Rational[1, 2]}}, {{
                 104, -8.660254037844386}, {109, 0}, {
                 104, 8.660254037844386}, {94, 8.660254037844386}, {89, 0}, {
                 94, -8.660254037844386}}]], 
              RegularPolygon[{99, 0}, 10, 6]]}}, {{
             RGBColor[
             0.7863854027114427, 0.8521244813009565, 0.812448107902279], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{90, 30 - 5 3^Rational[1, 2]}, {95, 30}, {
                 90, 30 + 5 3^Rational[1, 2]}, {
                 80, 30 + 5 3^Rational[1, 2]}, {75, 30}, {
                 80, 30 - 5 3^Rational[1, 2]}}, {{90, 21.339745962155614`}, {
                 95, 30}, {90, 38.66025403784438}, {80, 38.66025403784438}, {
                 75, 30}, {80, 21.339745962155614`}}]], 
              RegularPolygon[{85, 30}, 10, 6]]}}, {{
             RGBColor[
             0.36770601058775787`, 0.8603599212117592, 0.384332943287542], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{9 + 5 3^Rational[1, 2], 3}, {9, 18}, {
                 9 - 5 3^Rational[1, 2], 3}}, {{17.660254037844386`, 3}, {9, 
                 18}, {0.3397459621556145, 3}}]], 
              RegularPolygon[{9, 8}, 10, 3]]}}, {{
             RGBColor[
             0.15644995101268866`, 0.822851164850213, 0.8507672437127254], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 53 + 10 Sin[Rational[1, 7] Pi], 49 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 53 + 10 Cos[Rational[1, 14] Pi], 49 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 53 + 10 Cos[Rational[3, 14] Pi], 49 + 
                  10 Sin[Rational[3, 14] Pi]}, {53, 59}, {
                 53 - 10 Cos[Rational[3, 14] Pi], 49 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 53 - 10 Cos[Rational[1, 14] Pi], 49 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 53 - 10 Sin[Rational[1, 7] Pi], 49 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{57.33883739117558, 
                 39.990311320975806`}, {62.74927912181823, 
                 46.77479066043686}, {60.8183148246803, 55.23489801858734}, {
                 53, 59}, {45.1816851753197, 55.23489801858734}, {
                 43.25072087818177, 46.77479066043686}, {48.66116260882442, 
                 39.990311320975806`}}]], 
              RegularPolygon[{53, 49}, 10, 7]]}}, {{
             RGBColor[
             0.5215420632802785, 0.8574822869525511, 0.250075406264185], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{60 + 5 3^Rational[1, 2], 10}, {60, 25}, {
                 60 - 5 3^Rational[1, 2], 10}}, {{68.66025403784438, 10}, {60,
                  25}, {51.33974596215562, 10}}]], 
              RegularPolygon[{60, 15}, 10, 3]]}}, {{
             RGBColor[
             0.05371417570380954, 0.5136720160124912, 0.9513620786193406], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 53 + 10 Sin[Rational[1, 8] Pi], 80 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 53 + 10 Cos[Rational[1, 8] Pi], 80 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 53 + 10 Cos[Rational[1, 8] Pi], 80 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 53 + 10 Sin[Rational[1, 8] Pi], 80 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 53 - 10 Sin[Rational[1, 8] Pi], 80 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 53 - 10 Cos[Rational[1, 8] Pi], 80 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 53 - 10 Cos[Rational[1, 8] Pi], 80 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 53 - 10 Sin[Rational[1, 8] Pi], 80 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{56.8268343236509, 
                70.76120467488713}, {62.23879532511287, 76.1731656763491}, {
                62.23879532511287, 83.8268343236509}, {56.8268343236509, 
                89.23879532511287}, {49.1731656763491, 89.23879532511287}, {
                43.76120467488713, 83.8268343236509}, {43.76120467488713, 
                76.1731656763491}, {49.1731656763491, 70.76120467488713}}]], 
              RegularPolygon[{53, 80}, 10, 8]]}}, {{
             RGBColor[
             0.15598564644414448`, 0.13811521719252595`, 0.08500261506168383], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{25, 8 - 5 3^Rational[1, 2]}, {30, 8}, {
                 25, 8 + 5 3^Rational[1, 2]}, {15, 8 + 5 3^Rational[1, 2]}, {
                 10, 8}, {15, 8 - 5 3^Rational[1, 2]}}, {{
                 25, -0.6602540378443855}, {30, 8}, {
                 25, 16.660254037844386`}, {15, 16.660254037844386`}, {10, 
                 8}, {15, -0.6602540378443855}}]], 
              RegularPolygon[{20, 8}, 10, 6]]}}, {{
             RGBColor[
             0.6744646019422045, 0.4268493144879386, 0.07634272462526925], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{49 + 5 3^Rational[1, 2], 87}, {49, 102}, {
                 49 - 5 3^Rational[1, 2], 87}}, {{57.66025403784438, 87}, {49,
                  102}, {40.33974596215562, 87}}]], 
              RegularPolygon[{49, 92}, 10, 3]]}}, {{
             RGBColor[
             0.23730299488882722`, 0.7103184485854448, 0.22248172521893128`], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 51 + 10 Sin[Rational[1, 7] Pi], 24 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 51 + 10 Cos[Rational[1, 14] Pi], 24 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 51 + 10 Cos[Rational[3, 14] Pi], 24 + 
                  10 Sin[Rational[3, 14] Pi]}, {51, 34}, {
                 51 - 10 Cos[Rational[3, 14] Pi], 24 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 51 - 10 Cos[Rational[1, 14] Pi], 24 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 51 - 10 Sin[Rational[1, 7] Pi], 24 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{55.33883739117558, 
                 14.990311320975808`}, {60.74927912181823, 
                 21.774790660436857`}, {58.8183148246803, 
                 30.234898018587334`}, {51, 34}, {43.1816851753197, 
                 30.234898018587334`}, {41.25072087818177, 
                 21.774790660436857`}, {46.66116260882442, 
                 14.990311320975808`}}]], 
              RegularPolygon[{51, 24}, 10, 7]]}}, {{
             RGBColor[
             0.13431334426185115`, 0.3124682507368186, 0.18139201368834756`], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 78 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 83 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 78 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 83 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {78, 93}, {
                 78 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 83 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 78 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 83 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 83.87785252292473, 74.90983005625053}, {87.51056516295154, 
                 86.09016994374947}, {78, 93}, {68.48943483704846, 
                 86.09016994374947}, {72.12214747707527, 
                 74.90983005625053}}]], 
              RegularPolygon[{78, 83}, 10, 5]]}}, {{
             RGBColor[
             0.2933819049970776, 0.4333658800074154, 0.2583204699816797], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 24 + 10 Sin[Rational[1, 7] Pi], 46 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 24 + 10 Cos[Rational[1, 14] Pi], 46 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 24 + 10 Cos[Rational[3, 14] Pi], 46 + 
                  10 Sin[Rational[3, 14] Pi]}, {24, 56}, {
                 24 - 10 Cos[Rational[3, 14] Pi], 46 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 24 - 10 Cos[Rational[1, 14] Pi], 46 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 24 - 10 Sin[Rational[1, 7] Pi], 46 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{28.33883739117558, 
                 36.990311320975806`}, {33.74927912181823, 
                 43.77479066043686}, {31.8183148246803, 52.23489801858734}, {
                 24, 56}, {16.1816851753197, 52.23489801858734}, {
                 14.250720878181763`, 43.77479066043686}, {19.66116260882442, 
                 36.990311320975806`}}]], 
              RegularPolygon[{24, 46}, 10, 7]]}}, {{
             RGBColor[
             0.7606431478253546, 0.548377753266259, 0.14098023286431616`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 9 + 10 Sin[Rational[1, 7] Pi], 96 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 9 + 10 Cos[Rational[1, 14] Pi], 96 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 9 + 10 Cos[Rational[3, 14] Pi], 96 + 
                  10 Sin[Rational[3, 14] Pi]}, {9, 106}, {
                 9 - 10 Cos[Rational[3, 14] Pi], 96 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 9 - 10 Cos[Rational[1, 14] Pi], 96 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 9 - 10 Sin[Rational[1, 7] Pi], 96 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{13.33883739117558, 
                 86.9903113209758}, {18.749279121818237`, 
                 93.77479066043685}, {16.8183148246803, 
                 102.23489801858733`}, {9, 106}, {1.1816851753197017`, 
                 102.23489801858733`}, {-0.7492791218182369, 
                 93.77479066043685}, {4.6611626088244185`, 
                 86.9903113209758}}]], 
              RegularPolygon[{9, 96}, 10, 7]]}}, {{
             RGBColor[
             0.24185914273557474`, 0.12780487595388546`, 0.7324603975441122], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{31 + 5 2^Rational[1, 2], 32 - 5 2^Rational[1, 2]}, {
                 31 + 5 2^Rational[1, 2], 32 + 5 2^Rational[1, 2]}, {
                 31 - 5 2^Rational[1, 2], 32 + 5 2^Rational[1, 2]}, {
                 31 - 5 2^Rational[1, 2], 32 - 5 2^Rational[1, 2]}}, {{
                38.071067811865476`, 24.928932188134524`}, {
                38.071067811865476`, 39.071067811865476`}, {
                23.928932188134524`, 39.071067811865476`}, {
                23.928932188134524`, 24.928932188134524`}}]], 
              RegularPolygon[{31, 32}, 10, 4]]}}, {{
             RGBColor[
             0.4285658124840235, 0.4605841370897532, 0.5480093173224139], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{5 + 5 2^Rational[1, 2], 41 - 5 2^Rational[1, 2]}, {
                 5 + 5 2^Rational[1, 2], 41 + 5 2^Rational[1, 2]}, {
                 5 - 5 2^Rational[1, 2], 41 + 5 2^Rational[1, 2]}, {
                 5 - 5 2^Rational[1, 2], 41 - 5 2^Rational[1, 2]}}, {{
                12.071067811865476`, 33.928932188134524`}, {
                12.071067811865476`, 
                48.071067811865476`}, {-2.0710678118654755`, 
                48.071067811865476`}, {-2.0710678118654755`, 
                33.928932188134524`}}]], 
              RegularPolygon[{5, 41}, 10, 4]]}}, {{
             RGBColor[
             0.38979413397180185`, 0.40185611346055317`, 
              0.008704032600402423], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{46, 46 - 5 3^Rational[1, 2]}, {51, 46}, {
                 46, 46 + 5 3^Rational[1, 2]}, {
                 36, 46 + 5 3^Rational[1, 2]}, {31, 46}, {
                 36, 46 - 5 3^Rational[1, 2]}}, {{46, 37.33974596215562}, {51,
                  46}, {46, 54.66025403784438}, {36, 54.66025403784438}, {31, 
                 46}, {36, 37.33974596215562}}]], 
              RegularPolygon[{41, 46}, 10, 6]]}}, {{
             RGBColor[
             0.9406568562078943, 0.31182779692823037`, 0.6098471911758756], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 93 + 10 Sin[Rational[1, 8] Pi], 97 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 93 + 10 Cos[Rational[1, 8] Pi], 97 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 93 + 10 Cos[Rational[1, 8] Pi], 97 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 93 + 10 Sin[Rational[1, 8] Pi], 97 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 93 - 10 Sin[Rational[1, 8] Pi], 97 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 93 - 10 Cos[Rational[1, 8] Pi], 97 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 93 - 10 Cos[Rational[1, 8] Pi], 97 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 93 - 10 Sin[Rational[1, 8] Pi], 97 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{96.8268343236509, 
                87.76120467488713}, {102.23879532511287`, 93.1731656763491}, {
                102.23879532511287`, 100.8268343236509}, {96.8268343236509, 
                106.23879532511287`}, {89.1731656763491, 
                106.23879532511287`}, {83.76120467488713, 
                100.8268343236509}, {83.76120467488713, 93.1731656763491}, {
                89.1731656763491, 87.76120467488713}}]], 
              RegularPolygon[{93, 97}, 10, 8]]}}, {{
             RGBColor[
             0.816477053310892, 0.5061507036729977, 0.604572230630573], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{38, 53 - 5 3^Rational[1, 2]}, {43, 53}, {
                 38, 53 + 5 3^Rational[1, 2]}, {
                 28, 53 + 5 3^Rational[1, 2]}, {23, 53}, {
                 28, 53 - 5 3^Rational[1, 2]}}, {{38, 44.33974596215562}, {43,
                  53}, {38, 61.66025403784438}, {28, 61.66025403784438}, {23, 
                 53}, {28, 44.33974596215562}}]], 
              RegularPolygon[{33, 53}, 10, 6]]}}, {{
             RGBColor[
             0.9511941199251182, 0.00678489098437951, 0.12505715068297163`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 92 + 10 Sin[Rational[1, 7] Pi], 12 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 92 + 10 Cos[Rational[1, 14] Pi], 12 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 92 + 10 Cos[Rational[3, 14] Pi], 12 + 
                  10 Sin[Rational[3, 14] Pi]}, {92, 22}, {
                 92 - 10 Cos[Rational[3, 14] Pi], 12 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 92 - 10 Cos[Rational[1, 14] Pi], 12 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 92 - 10 Sin[Rational[1, 7] Pi], 12 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{96.33883739117559, 
                 2.990311320975808}, {101.74927912181823`, 
                 9.774790660436857}, {99.8183148246803, 
                 18.234898018587334`}, {92, 22}, {84.1816851753197, 
                 18.234898018587334`}, {82.25072087818177, 
                 9.774790660436857}, {87.66116260882441, 
                 2.990311320975808}}]], 
              RegularPolygon[{92, 12}, 10, 7]]}}, {{
             RGBColor[
             0.9926773502738482, 0.6386425900591328, 0.20471574756982447`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{41, 43 - 5 3^Rational[1, 2]}, {46, 43}, {
                 41, 43 + 5 3^Rational[1, 2]}, {
                 31, 43 + 5 3^Rational[1, 2]}, {26, 43}, {
                 31, 43 - 5 3^Rational[1, 2]}}, {{41, 34.33974596215562}, {46,
                  43}, {41, 51.66025403784438}, {31, 51.66025403784438}, {26, 
                 43}, {31, 34.33974596215562}}]], 
              RegularPolygon[{36, 43}, 10, 6]]}}, {{
             RGBColor[
             0.24096055187655696`, 0.7956067458943188, 0.6707840130088074], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{85 + 5 2^Rational[1, 2], 66 - 5 2^Rational[1, 2]}, {
                 85 + 5 2^Rational[1, 2], 66 + 5 2^Rational[1, 2]}, {
                 85 - 5 2^Rational[1, 2], 66 + 5 2^Rational[1, 2]}, {
                 85 - 5 2^Rational[1, 2], 66 - 5 2^Rational[1, 2]}}, {{
                92.07106781186548, 58.928932188134524`}, {92.07106781186548, 
                73.07106781186548}, {77.92893218813452, 73.07106781186548}, {
                77.92893218813452, 58.928932188134524`}}]], 
              RegularPolygon[{85, 66}, 10, 4]]}}, {{
             RGBColor[
             0.6962867070712211, 0.03779461467066714, 0.10061999430300994`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{32 + 5 3^Rational[1, 2], 30}, {32, 45}, {
                 32 - 5 3^Rational[1, 2], 30}}, {{40.66025403784438, 30}, {32,
                  45}, {23.339745962155614`, 30}}]], 
              RegularPolygon[{32, 35}, 10, 3]]}}, {{
             RGBColor[
             0.3525936612321894, 0.036876166872091165`, 0.9520129155202468], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 28 + 10 Sin[Rational[1, 8] Pi], 98 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 28 + 10 Cos[Rational[1, 8] Pi], 98 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 28 + 10 Cos[Rational[1, 8] Pi], 98 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 28 + 10 Sin[Rational[1, 8] Pi], 98 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 28 - 10 Sin[Rational[1, 8] Pi], 98 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 28 - 10 Cos[Rational[1, 8] Pi], 98 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 28 - 10 Cos[Rational[1, 8] Pi], 98 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 28 - 10 Sin[Rational[1, 8] Pi], 98 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{31.8268343236509, 
                88.76120467488713}, {37.23879532511287, 94.1731656763491}, {
                37.23879532511287, 101.8268343236509}, {31.8268343236509, 
                107.23879532511287`}, {24.1731656763491, 
                107.23879532511287`}, {18.761204674887132`, 
                101.8268343236509}, {18.761204674887132`, 94.1731656763491}, {
                24.1731656763491, 88.76120467488713}}]], 
              RegularPolygon[{28, 98}, 10, 8]]}}, {{
             RGBColor[
             0.7142736849869464, 0.09289674096863099, 0.6405219512876956], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 7 + 10 Sin[Rational[1, 8] Pi], 69 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 7 + 10 Cos[Rational[1, 8] Pi], 69 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 7 + 10 Cos[Rational[1, 8] Pi], 69 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 7 + 10 Sin[Rational[1, 8] Pi], 69 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 7 - 10 Sin[Rational[1, 8] Pi], 69 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 7 - 10 Cos[Rational[1, 8] Pi], 69 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 7 - 10 Cos[Rational[1, 8] Pi], 69 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 7 - 10 Sin[Rational[1, 8] Pi], 69 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{10.826834323650898`, 
                59.76120467488713}, {16.238795325112868`, 65.1731656763491}, {
                16.238795325112868`, 72.8268343236509}, {10.826834323650898`, 
                78.23879532511287}, {3.173165676349102, 
                78.23879532511287}, {-2.238795325112868, 
                72.8268343236509}, {-2.238795325112868, 65.1731656763491}, {
                3.173165676349102, 59.76120467488713}}]], 
              RegularPolygon[{7, 69}, 10, 8]]}}, {{
             RGBColor[
             0.672277328552908, 0.08982976735721349, 0.5498099986265119], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 96 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 34 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 96 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 34 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {96, 44}, {
                 96 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 34 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 96 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 34 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 101.87785252292473`, 25.909830056250527`}, {
                 105.51056516295154`, 37.09016994374947}, {96, 44}, {
                 86.48943483704846, 37.09016994374947}, {90.12214747707527, 
                 25.909830056250527`}}]], 
              RegularPolygon[{96, 34}, 10, 5]]}}, {{
             RGBColor[
             0.525371165213369, 0.08402683190573002, 0.5243615235498036], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{8 + 5 3^Rational[1, 2], 2}, {8, 17}, {
                 8 - 5 3^Rational[1, 2], 2}}, {{16.660254037844386`, 2}, {8, 
                 17}, {-0.6602540378443855, 2}}]], 
              RegularPolygon[{8, 7}, 10, 3]]}}, {{
             RGBColor[
             0.5391301758565321, 0.954012887881353, 0.5252210602744241], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 41 + 10 Sin[Rational[1, 8] Pi], 3 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 41 + 10 Cos[Rational[1, 8] Pi], 3 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 41 + 10 Cos[Rational[1, 8] Pi], 3 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 41 + 10 Sin[Rational[1, 8] Pi], 3 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 41 - 10 Sin[Rational[1, 8] Pi], 3 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 41 - 10 Cos[Rational[1, 8] Pi], 3 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 41 - 10 Cos[Rational[1, 8] Pi], 3 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 41 - 10 Sin[Rational[1, 8] Pi], 3 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{
                44.8268343236509, -6.238795325112868}, {
                50.23879532511287, -0.8268343236508979}, {50.23879532511287, 
                6.826834323650898}, {44.8268343236509, 12.238795325112868`}, {
                37.1731656763491, 12.238795325112868`}, {31.761204674887132`, 
                6.826834323650898}, {
                31.761204674887132`, -0.8268343236508979}, {
                37.1731656763491, -6.238795325112868}}]], 
              RegularPolygon[{41, 3}, 10, 8]]}}, {{
             RGBColor[
             0.6456031075806483, 0.20845601297222083`, 0.9785988532269325], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{73, 35 - 5 3^Rational[1, 2]}, {78, 35}, {
                 73, 35 + 5 3^Rational[1, 2]}, {
                 63, 35 + 5 3^Rational[1, 2]}, {58, 35}, {
                 63, 35 - 5 3^Rational[1, 2]}}, {{73, 26.339745962155614`}, {
                 78, 35}, {73, 43.66025403784438}, {63, 43.66025403784438}, {
                 58, 35}, {63, 26.339745962155614`}}]], 
              RegularPolygon[{68, 35}, 10, 6]]}}, {{
             RGBColor[
             0.5554985043082217, 0.07491637027880294, 0.7469836606553633], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 39 + 10 Sin[Rational[1, 8] Pi], 2 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 39 + 10 Cos[Rational[1, 8] Pi], 2 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 39 + 10 Cos[Rational[1, 8] Pi], 2 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 39 + 10 Sin[Rational[1, 8] Pi], 2 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 39 - 10 Sin[Rational[1, 8] Pi], 2 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 39 - 10 Cos[Rational[1, 8] Pi], 2 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 39 - 10 Cos[Rational[1, 8] Pi], 2 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 39 - 10 Sin[Rational[1, 8] Pi], 2 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{
                42.8268343236509, -7.238795325112868}, {
                48.23879532511287, -1.826834323650898}, {48.23879532511287, 
                5.826834323650898}, {42.8268343236509, 11.238795325112868`}, {
                35.1731656763491, 11.238795325112868`}, {29.761204674887132`, 
                5.826834323650898}, {
                29.761204674887132`, -1.826834323650898}, {
                35.1731656763491, -7.238795325112868}}]], 
              RegularPolygon[{39, 2}, 10, 8]]}}, {{
             RGBColor[
             0.5259930176055541, 0.3489349194315772, 0.7095420343344472], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 19 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 96 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 19 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 96 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {19, 106}, {
                 19 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 96 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 19 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 96 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 24.877852522924734`, 87.90983005625053}, {
                 28.510565162951536`, 99.09016994374947}, {19, 106}, {
                 9.489434837048465, 99.09016994374947}, {13.122147477075268`, 
                 87.90983005625053}}]], 
              RegularPolygon[{19, 96}, 10, 5]]}}, {{
             RGBColor[
             0.33885478192577656`, 0.26672240528832525`, 0.6064198113180701], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 86 + 10 Sin[Rational[1, 8] Pi], 33 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 86 + 10 Cos[Rational[1, 8] Pi], 33 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 86 + 10 Cos[Rational[1, 8] Pi], 33 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 86 + 10 Sin[Rational[1, 8] Pi], 33 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 86 - 10 Sin[Rational[1, 8] Pi], 33 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 86 - 10 Cos[Rational[1, 8] Pi], 33 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 86 - 10 Cos[Rational[1, 8] Pi], 33 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 86 - 10 Sin[Rational[1, 8] Pi], 33 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{89.8268343236509, 
                23.761204674887132`}, {95.23879532511287, 29.1731656763491}, {
                95.23879532511287, 36.8268343236509}, {89.8268343236509, 
                42.23879532511287}, {82.1731656763491, 42.23879532511287}, {
                76.76120467488713, 36.8268343236509}, {76.76120467488713, 
                29.1731656763491}, {82.1731656763491, 23.761204674887132`}}]], 
              RegularPolygon[{86, 33}, 10, 8]]}}, {{
             RGBColor[
             0.7846788590783385, 0.6007091610821271, 0.41323836161465555`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{62 + 5 3^Rational[1, 2], 41}, {62, 56}, {
                 62 - 5 3^Rational[1, 2], 41}}, {{70.66025403784438, 41}, {62,
                  56}, {53.33974596215562, 41}}]], 
              RegularPolygon[{62, 46}, 10, 3]]}}, {{
             RGBColor[
             0.8171009401848579, 0.232997308692801, 0.1115635061286464], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{31, 5 - 5 3^Rational[1, 2]}, {36, 5}, {
                 31, 5 + 5 3^Rational[1, 2]}, {21, 5 + 5 3^Rational[1, 2]}, {
                 16, 5}, {21, 5 - 5 3^Rational[1, 2]}}, {{
                 31, -3.6602540378443855`}, {36, 5}, {
                 31, 13.660254037844386`}, {21, 13.660254037844386`}, {16, 
                 5}, {21, -3.6602540378443855`}}]], 
              RegularPolygon[{26, 5}, 10, 6]]}}, {{
             RGBColor[
             0.03516467355523223, 0.9937025205320749, 0.20214686646221836`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 96 + 10 Sin[Rational[1, 8] Pi], 89 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 96 + 10 Cos[Rational[1, 8] Pi], 89 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 96 + 10 Cos[Rational[1, 8] Pi], 89 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 96 + 10 Sin[Rational[1, 8] Pi], 89 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 96 - 10 Sin[Rational[1, 8] Pi], 89 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 96 - 10 Cos[Rational[1, 8] Pi], 89 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 96 - 10 Cos[Rational[1, 8] Pi], 89 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 96 - 10 Sin[Rational[1, 8] Pi], 89 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{99.8268343236509, 
                79.76120467488713}, {105.23879532511287`, 85.1731656763491}, {
                105.23879532511287`, 92.8268343236509}, {99.8268343236509, 
                98.23879532511287}, {92.1731656763491, 98.23879532511287}, {
                86.76120467488713, 92.8268343236509}, {86.76120467488713, 
                85.1731656763491}, {92.1731656763491, 79.76120467488713}}]], 
              RegularPolygon[{96, 89}, 10, 8]]}}, {{
             RGBColor[
             0.3276347140124287, 0.80952016582526, 0.17149165339666994`], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 32 + 10 Sin[Rational[1, 8] Pi], 70 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 32 + 10 Cos[Rational[1, 8] Pi], 70 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 32 + 10 Cos[Rational[1, 8] Pi], 70 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 32 + 10 Sin[Rational[1, 8] Pi], 70 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 32 - 10 Sin[Rational[1, 8] Pi], 70 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 32 - 10 Cos[Rational[1, 8] Pi], 70 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 32 - 10 Cos[Rational[1, 8] Pi], 70 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 32 - 10 Sin[Rational[1, 8] Pi], 70 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{35.8268343236509, 
                60.76120467488713}, {41.23879532511287, 66.1731656763491}, {
                41.23879532511287, 73.8268343236509}, {35.8268343236509, 
                79.23879532511287}, {28.1731656763491, 79.23879532511287}, {
                22.761204674887132`, 73.8268343236509}, {22.761204674887132`, 
                66.1731656763491}, {28.1731656763491, 60.76120467488713}}]], 
              RegularPolygon[{32, 70}, 10, 8]]}}, {{
             RGBColor[
             0.5367812926806756, 0.12196240927732926`, 0.9682621428502807], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{68 + 5 2^Rational[1, 2], 87 - 5 2^Rational[1, 2]}, {
                 68 + 5 2^Rational[1, 2], 87 + 5 2^Rational[1, 2]}, {
                 68 - 5 2^Rational[1, 2], 87 + 5 2^Rational[1, 2]}, {
                 68 - 5 2^Rational[1, 2], 87 - 5 2^Rational[1, 2]}}, {{
                75.07106781186548, 79.92893218813452}, {75.07106781186548, 
                94.07106781186548}, {60.928932188134524`, 
                94.07106781186548}, {60.928932188134524`, 
                79.92893218813452}}]], 
              RegularPolygon[{68, 87}, 10, 4]]}}, {{
             RGBColor[
             0.22549854861934215`, 0.5465784314501305, 0.5419764527654094], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{77 + 5 2^Rational[1, 2], 82 - 5 2^Rational[1, 2]}, {
                 77 + 5 2^Rational[1, 2], 82 + 5 2^Rational[1, 2]}, {
                 77 - 5 2^Rational[1, 2], 82 + 5 2^Rational[1, 2]}, {
                 77 - 5 2^Rational[1, 2], 82 - 5 2^Rational[1, 2]}}, {{
                84.07106781186548, 74.92893218813452}, {84.07106781186548, 
                89.07106781186548}, {69.92893218813452, 89.07106781186548}, {
                69.92893218813452, 74.92893218813452}}]], 
              RegularPolygon[{77, 82}, 10, 4]]}}, {{
             RGBColor[
             0.1250584100900871, 0.10681254286853892`, 0.9721756025510631], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 58 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 59 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 58 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 59 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {58, 69}, {
                 58 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 59 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 58 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 59 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 63.877852522924734`, 50.90983005625053}, {67.51056516295154, 
                 62.09016994374947}, {58, 69}, {48.489434837048464`, 
                 62.09016994374947}, {52.122147477075266`, 
                 50.90983005625053}}]], 
              RegularPolygon[{58, 59}, 10, 5]]}}, {{
             RGBColor[
             0.7216691649234865, 0.16959433047977446`, 0.7303731337408539], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 62 + 10 Sin[Rational[1, 8] Pi], 76 - 10 
                  Cos[Rational[1, 8] Pi]}, {
                 62 + 10 Cos[Rational[1, 8] Pi], 76 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 62 + 10 Cos[Rational[1, 8] Pi], 76 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 62 + 10 Sin[Rational[1, 8] Pi], 76 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 62 - 10 Sin[Rational[1, 8] Pi], 76 + 
                  10 Cos[Rational[1, 8] Pi]}, {
                 62 - 10 Cos[Rational[1, 8] Pi], 76 + 
                  10 Sin[Rational[1, 8] Pi]}, {
                 62 - 10 Cos[Rational[1, 8] Pi], 76 - 10 
                  Sin[Rational[1, 8] Pi]}, {
                 62 - 10 Sin[Rational[1, 8] Pi], 76 - 10 
                  Cos[Rational[1, 8] Pi]}}, {{65.8268343236509, 
                66.76120467488713}, {71.23879532511287, 72.1731656763491}, {
                71.23879532511287, 79.8268343236509}, {65.8268343236509, 
                85.23879532511287}, {58.1731656763491, 85.23879532511287}, {
                52.76120467488713, 79.8268343236509}, {52.76120467488713, 
                72.1731656763491}, {58.1731656763491, 66.76120467488713}}]], 
              RegularPolygon[{62, 76}, 10, 8]]}}, {{
             RGBColor[
             0.7438953850464027, 0.7403105009003266, 0.1470487190780041], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{11, 37 - 5 3^Rational[1, 2]}, {16, 37}, {
                 11, 37 + 5 3^Rational[1, 2]}, {
                 1, 37 + 5 3^Rational[1, 2]}, {-4, 37}, {
                 1, 37 - 5 3^Rational[1, 2]}}, {{11, 28.339745962155614`}, {
                 16, 37}, {11, 45.66025403784438}, {
                 1, 45.66025403784438}, {-4, 37}, {1, 28.339745962155614`}}]], 
              RegularPolygon[{6, 37}, 10, 6]]}}, {{
             RGBColor[
             0.11081733393110249`, 0.5813398800836753, 0.5614281729992157], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 78 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 35 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 78 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 35 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {78, 45}, {
                 78 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 35 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 78 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 35 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 83.87785252292473, 26.909830056250527`}, {87.51056516295154, 
                 38.09016994374947}, {78, 45}, {68.48943483704846, 
                 38.09016994374947}, {72.12214747707527, 
                 26.909830056250527`}}]], 
              RegularPolygon[{78, 35}, 10, 5]]}}, {{
             RGBColor[
             0.8149410577774916, 0.46420182711252567`, 0.22478473548383082`], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 67 + 10 Sin[Rational[1, 7] Pi], 47 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 67 + 10 Cos[Rational[1, 14] Pi], 47 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 67 + 10 Cos[Rational[3, 14] Pi], 47 + 
                  10 Sin[Rational[3, 14] Pi]}, {67, 57}, {
                 67 - 10 Cos[Rational[3, 14] Pi], 47 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 67 - 10 Cos[Rational[1, 14] Pi], 47 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 67 - 10 Sin[Rational[1, 7] Pi], 47 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{71.33883739117559, 
                 37.990311320975806`}, {76.74927912181823, 
                 44.77479066043686}, {74.8183148246803, 53.23489801858734}, {
                 67, 57}, {59.1816851753197, 53.23489801858734}, {
                 57.25072087818177, 44.77479066043686}, {62.66116260882442, 
                 37.990311320975806`}}]], 
              RegularPolygon[{67, 47}, 10, 7]]}}, {{
             RGBColor[
             0.12441231431893574`, 0.9286683538810827, 0.7903907583697836], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{74 + 5 2^Rational[1, 2], 3 - 5 2^Rational[1, 2]}, {
                 74 + 5 2^Rational[1, 2], 3 + 5 2^Rational[1, 2]}, {
                 74 - 5 2^Rational[1, 2], 3 + 5 2^Rational[1, 2]}, {
                 74 - 5 2^Rational[1, 2], 3 - 5 2^Rational[1, 2]}}, {{
                81.07106781186548, -4.0710678118654755`}, {81.07106781186548, 
                10.071067811865476`}, {66.92893218813452, 
                10.071067811865476`}, {
                66.92893218813452, -4.0710678118654755`}}]], 
              RegularPolygon[{74, 3}, 10, 4]]}}, {{
             RGBColor[
             0.23860154957557445`, 0.6394877318563028, 0.1451363078641701], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 64 + 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 50 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}, {
                 64 + 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 50 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {64, 60}, {
                 64 - 10 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 50 + 
                  Rational[5, 2] (-1 + 5^Rational[1, 2])}, {
                 64 - 10 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 50 + 
                  Rational[5, 2] (-1 - 5^Rational[1, 2])}}, {{
                 69.87785252292473, 41.90983005625053}, {73.51056516295154, 
                 53.09016994374947}, {64, 60}, {54.489434837048464`, 
                 53.09016994374947}, {58.122147477075266`, 
                 41.90983005625053}}]], 
              RegularPolygon[{64, 50}, 10, 5]]}}, {{
             RGBColor[
             0.4319005239332321, 0.9569725539554408, 0.9522547739960223], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{3 + 5 3^Rational[1, 2], 21}, {3, 36}, {
                 3 - 5 3^Rational[1, 2], 21}}, {{11.660254037844386`, 21}, {3,
                  36}, {-5.6602540378443855`, 21}}]], 
              RegularPolygon[{3, 26}, 10, 3]]}}, {{
             RGBColor[
             0.2843446381627537, 0.18690451244395523`, 0.40542767170641025`], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{
                 66 + 10 Sin[Rational[1, 7] Pi], 80 - 10 
                  Cos[Rational[1, 7] Pi]}, {
                 66 + 10 Cos[Rational[1, 14] Pi], 80 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 66 + 10 Cos[Rational[3, 14] Pi], 80 + 
                  10 Sin[Rational[3, 14] Pi]}, {66, 90}, {
                 66 - 10 Cos[Rational[3, 14] Pi], 80 + 
                  10 Sin[Rational[3, 14] Pi]}, {
                 66 - 10 Cos[Rational[1, 14] Pi], 80 - 10 
                  Sin[Rational[1, 14] Pi]}, {
                 66 - 10 Sin[Rational[1, 7] Pi], 80 - 10 
                  Cos[Rational[1, 7] Pi]}}, {{70.33883739117559, 
                 70.9903113209758}, {75.74927912181823, 77.77479066043685}, {
                 73.8183148246803, 86.23489801858733}, {66, 90}, {
                 58.1816851753197, 86.23489801858733}, {56.25072087818177, 
                 77.77479066043685}, {61.66116260882442, 70.9903113209758}}]], 
              RegularPolygon[{66, 80}, 10, 7]]}}, {{
             RGBColor[
             0.3066491372537661, 0.6134626876334246, 0.05619933854074333], 
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{28 + 5 2^Rational[1, 2], 29 - 5 2^Rational[1, 2]}, {
                 28 + 5 2^Rational[1, 2], 29 + 5 2^Rational[1, 2]}, {
                 28 - 5 2^Rational[1, 2], 29 + 5 2^Rational[1, 2]}, {
                 28 - 5 2^Rational[1, 2], 29 - 5 2^Rational[1, 2]}}, {{
                35.071067811865476`, 21.928932188134524`}, {
                35.071067811865476`, 36.071067811865476`}, {
                20.928932188134524`, 36.071067811865476`}, {
                20.928932188134524`, 21.928932188134524`}}]], 
              RegularPolygon[{28, 29}, 10, 4]]}}, {{
             RGBColor[
             0.31168541535677785`, 0.22250257824343223`, 0.6999236872964518], 
             
             Opacity[0.5], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{62 + 5 3^Rational[1, 2], 48}, {62, 63}, {
                 62 - 5 3^Rational[1, 2], 48}}, {{70.66025403784438, 48}, {62,
                  63}, {53.33974596215562, 48}}]], 
              RegularPolygon[{62, 53}, 10, 3]]}}}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"78d15dbf-8b0e-49f3-b521-49795474e954"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 10\[Times]10\[Times]10 array of points in 3D, with each point having \
a random color.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+14.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"676d21e2-3874-4d1b-b518-600bb39a7447"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       Graphics3DBox[{{{
           {RGBColor[
            0.030226047463962624`, 0.44325593064423074`, 0.6208198239912806], 
            Point3DBox[{1, 1, 1}]}, 
           {RGBColor[
            0.5471143145417774, 0.9595092631312614, 0.1093732234181426], 
            Point3DBox[{1, 1, 2}]}, 
           {RGBColor[
            0.6771525810474233, 0.2819331093309283, 0.28249384274080147`], 
            Point3DBox[{1, 1, 3}]}, 
           {RGBColor[
            0.6344282430004764, 0.8203798998049077, 0.4566119058945619], 
            Point3DBox[{1, 1, 4}]}, 
           {RGBColor[
            0.2969217003101263, 0.15399802422432596`, 0.16953116194605733`], 
            Point3DBox[{1, 1, 5}]}, 
           {RGBColor[
            0.17262886064247351`, 0.3779339132025965, 0.12399520342770232`], 
            Point3DBox[{1, 1, 6}]}, 
           {RGBColor[
            0.6710148222288634, 0.8525524303950833, 0.2605488252342629], 
            Point3DBox[{1, 1, 7}]}, 
           {RGBColor[
            0.8257641606301611, 0.9355359364415838, 0.6411834832561292], 
            Point3DBox[{1, 1, 8}]}, 
           {RGBColor[
            0.7504055280853497, 0.5211261341577103, 0.9435207763084086], 
            Point3DBox[{1, 1, 9}]}, 
           {RGBColor[
            0.2385588316453382, 0.9001249838155558, 0.28410182658416816`], 
            Point3DBox[{1, 1, 10}]}}, {
           {RGBColor[
            0.30137701786753057`, 0.24818375709703155`, 0.36783556434136244`],
             Point3DBox[{1, 2, 1}]}, 
           {RGBColor[
            0.8429241265701424, 0.32561507711161686`, 0.7149926504866888], 
            Point3DBox[{1, 2, 2}]}, 
           {RGBColor[
            0.025642992962680022`, 0.20161529792845645`, 0.8021629912687567], 
            Point3DBox[{1, 2, 3}]}, 
           {RGBColor[
            0.5348810858829132, 0.7600711738741939, 0.11580501440267654`], 
            Point3DBox[{1, 2, 4}]}, 
           {RGBColor[
            0.8584132404642264, 0.32857008981385616`, 0.5766930917134623], 
            Point3DBox[{1, 2, 5}]}, 
           {RGBColor[
            0.011126695577744483`, 0.5426131762868516, 0.02663182937847508], 
            Point3DBox[{1, 2, 6}]}, 
           {RGBColor[
            0.35667301789142525`, 0.9247129185039993, 0.37063757321940893`], 
            Point3DBox[{1, 2, 7}]}, 
           {RGBColor[
            0.01708172477463088, 0.959445203647777, 0.003648831525236762], 
            Point3DBox[{1, 2, 8}]}, 
           {RGBColor[
            0.14962398064939486`, 0.8232554321240344, 0.7605127620108647], 
            Point3DBox[{1, 2, 9}]}, 
           {RGBColor[
            0.49912173813233607`, 0.4882876999342671, 0.02219183104461231], 
            Point3DBox[{1, 2, 10}]}}, {
           {RGBColor[
            0.2030749048688174, 0.9935469590164643, 0.1661824096251534], 
            Point3DBox[{1, 3, 1}]}, 
           {RGBColor[
            0.008303359472750849, 0.9350854162873821, 0.7213565764570276], 
            Point3DBox[{1, 3, 2}]}, 
           {RGBColor[
            0.2994070893615681, 0.3812524209221342, 0.8995658884464461], 
            Point3DBox[{1, 3, 3}]}, 
           {RGBColor[
            0.4606503269152378, 0.9639685082686014, 0.204839251338659], 
            Point3DBox[{1, 3, 4}]}, 
           {RGBColor[
            0.7524837933074937, 0.8482339880745742, 0.7894324720402879], 
            Point3DBox[{1, 3, 5}]}, 
           {RGBColor[
            0.6190726525151737, 0.22100776003517253`, 0.6393134349986449], 
            Point3DBox[{1, 3, 6}]}, 
           {RGBColor[
            0.7431979712652572, 0.6815743926107878, 0.449533245260199], 
            Point3DBox[{1, 3, 7}]}, 
           {RGBColor[
            0.36834362898729034`, 0.1367160272288357, 0.07313015686219826], 
            Point3DBox[{1, 3, 8}]}, 
           {RGBColor[
            0.9674358435915309, 0.7850623909317067, 0.15045382673908914`], 
            Point3DBox[{1, 3, 9}]}, 
           {RGBColor[
            0.894744332624201, 0.14277945474139098`, 0.39374372791719936`], 
            Point3DBox[{1, 3, 10}]}}, {
           {RGBColor[
            0.7925554683610241, 0.27321960636691056`, 0.46243670585221164`], 
            Point3DBox[{1, 4, 1}]}, 
           {RGBColor[
            0.07118243759195741, 0.6611067409209903, 0.9471716337133824], 
            Point3DBox[{1, 4, 2}]}, 
           {RGBColor[
            0.008910904213379922, 0.33693315370878874`, 0.35524863457220524`],
             Point3DBox[{1, 4, 3}]}, 
           {RGBColor[
            0.757147556818347, 0.322352357746297, 0.8853160180143715], 
            Point3DBox[{1, 4, 4}]}, 
           {RGBColor[
            0.5002051582939924, 0.2151112011110088, 0.7636132051947144], 
            Point3DBox[{1, 4, 5}]}, 
           {RGBColor[
            0.46195962868972895`, 0.8560840201943045, 0.3994260200493076], 
            Point3DBox[{1, 4, 6}]}, 
           {RGBColor[
            0.2520961409954441, 0.45259456818818333`, 0.9295755958344383], 
            Point3DBox[{1, 4, 7}]}, 
           {RGBColor[
            0.8917885319788148, 0.6058899163971854, 0.6311074694505372], 
            Point3DBox[{1, 4, 8}]}, 
           {RGBColor[
            0.9938141154944848, 0.555698177252753, 0.1633933156950793], 
            Point3DBox[{1, 4, 9}]}, 
           {RGBColor[
            0.9128836023044391, 0.40710541569497627`, 0.22475229409969222`], 
            Point3DBox[{1, 4, 10}]}}, {
           {RGBColor[
            0.07126713995330336, 0.5108399643472723, 0.2510729420413407], 
            Point3DBox[{1, 5, 1}]}, 
           {RGBColor[
            0.8399531592414884, 0.5184387904879484, 0.770119013435761], 
            Point3DBox[{1, 5, 2}]}, 
           {RGBColor[
            0.34385004055259905`, 0.7959166779159803, 0.4325592749421785], 
            Point3DBox[{1, 5, 3}]}, 
           {RGBColor[
            0.5976419802556725, 0.9744576014007544, 0.39371264752660595`], 
            Point3DBox[{1, 5, 4}]}, 
           {RGBColor[
            0.5240943727610394, 0.023428378135993855`, 0.8915308340800077], 
            Point3DBox[{1, 5, 5}]}, 
           {RGBColor[
            0.9337798135688657, 0.43549380765237755`, 0.2492723747747858], 
            Point3DBox[{1, 5, 6}]}, 
           {RGBColor[
            0.9489908861764624, 0.7508868886921438, 0.5069569086651371], 
            Point3DBox[{1, 5, 7}]}, 
           {RGBColor[
            0.7219690190540835, 0.9726299718451514, 0.035838227823833835`], 
            Point3DBox[{1, 5, 8}]}, 
           {RGBColor[
            0.02849462426631888, 0.9567562503493254, 0.40979808610737667`], 
            Point3DBox[{1, 5, 9}]}, 
           {RGBColor[
            0.2951020484266209, 0.7991778587206397, 0.8144643901489892], 
            Point3DBox[{1, 5, 10}]}}, {
           {RGBColor[
            0.7241790949200211, 0.016168779799683897`, 0.18961555275919717`], 
            Point3DBox[{1, 6, 1}]}, 
           {RGBColor[
            0.726692241411768, 0.9593655010087194, 0.42621399846862196`], 
            Point3DBox[{1, 6, 2}]}, 
           {RGBColor[
            0.20758416038133043`, 0.5546283612306968, 0.4819301858155376], 
            Point3DBox[{1, 6, 3}]}, 
           {RGBColor[
            0.6697814668581039, 0.439953010248733, 0.0946871266083209], 
            Point3DBox[{1, 6, 4}]}, 
           {RGBColor[
            0.16242416208173616`, 0.6687795110872261, 0.6216199619358489], 
            Point3DBox[{1, 6, 5}]}, 
           {RGBColor[
            0.990947167261363, 0.7908337988731293, 0.5990097288717504], 
            Point3DBox[{1, 6, 6}]}, 
           {RGBColor[
            0.9197089612387663, 0.8790535145651528, 0.7339163913239688], 
            Point3DBox[{1, 6, 7}]}, 
           {RGBColor[
            0.6842460137002664, 0.09768959056520399, 0.3516490760326023], 
            Point3DBox[{1, 6, 8}]}, 
           {RGBColor[
            0.25888161596282777`, 0.9335495495165735, 0.2547615373311558], 
            Point3DBox[{1, 6, 9}]}, 
           {RGBColor[
            0.7756069177709157, 0.3455550091360362, 0.9973554265359927], 
            Point3DBox[{1, 6, 10}]}}, {
           {RGBColor[
            0.4341527505823135, 0.8347239656051584, 0.6208838496994049], 
            Point3DBox[{1, 7, 1}]}, 
           {RGBColor[
            0.8268647971416752, 0.4312491360824233, 0.11356038392239443`], 
            Point3DBox[{1, 7, 2}]}, 
           {RGBColor[
            0.7626106837114128, 0.6779056290096663, 0.8742435964184792], 
            Point3DBox[{1, 7, 3}]}, 
           {RGBColor[
            0.7775791191936385, 0.3413897634576859, 0.6546067508879816], 
            Point3DBox[{1, 7, 4}]}, 
           {RGBColor[
            0.6017250675427008, 0.8666660450244796, 0.3531183757688954], 
            Point3DBox[{1, 7, 5}]}, 
           {RGBColor[
            0.9512288258782309, 0.6178575522066312, 0.5326469998799832], 
            Point3DBox[{1, 7, 6}]}, 
           {RGBColor[
            0.05636550503977489, 0.41838631079813493`, 0.10074489775223738`], 
            Point3DBox[{1, 7, 7}]}, 
           {RGBColor[
            0.12406654256172245`, 0.006934462054569046, 0.02890178028624657], 
            Point3DBox[{1, 7, 8}]}, 
           {RGBColor[
            0.03561072711452984, 0.9016088768958399, 0.4232282628946846], 
            Point3DBox[{1, 7, 9}]}, 
           {RGBColor[
            0.688992225121801, 0.8834781107765366, 0.47122943929537464`], 
            Point3DBox[{1, 7, 10}]}}, {
           {RGBColor[
            0.7530583991100261, 0.48500473656891807`, 0.6735377056669405], 
            Point3DBox[{1, 8, 1}]}, 
           {RGBColor[
            0.37090752814166716`, 0.3060903064644882, 0.07208259282031215], 
            Point3DBox[{1, 8, 2}]}, 
           {RGBColor[
            0.10164864444319965`, 0.2799663657971714, 0.3861393779571429], 
            Point3DBox[{1, 8, 3}]}, 
           {RGBColor[
            0.43212497778038395`, 0.18152877686460567`, 0.09485519563969724], 
            Point3DBox[{1, 8, 4}]}, 
           {RGBColor[
            0.32785553413184565`, 0.6283252604413452, 0.9868411020988199], 
            Point3DBox[{1, 8, 5}]}, 
           {RGBColor[
            0.887816106858244, 0.21485447721764328`, 0.47327862177259106`], 
            Point3DBox[{1, 8, 6}]}, 
           {RGBColor[
            0.6134289994084401, 0.21126061649973327`, 0.2616962835096157], 
            Point3DBox[{1, 8, 7}]}, 
           {RGBColor[
            0.5170975348373612, 0.32389763549989325`, 0.5675245287916146], 
            Point3DBox[{1, 8, 8}]}, 
           {RGBColor[
            0.5784865826008034, 0.09036293369186121, 0.3361365692186278], 
            Point3DBox[{1, 8, 9}]}, 
           {RGBColor[
            0.9170337398413948, 0.6779834506540268, 0.48069923030084216`], 
            Point3DBox[{1, 8, 10}]}}, {
           {RGBColor[
            0.9659435718694596, 0.9299064497882137, 0.9169912970455529], 
            Point3DBox[{1, 9, 1}]}, 
           {RGBColor[
            0.5617828491688612, 0.1534651506092901, 0.8224180881476775], 
            Point3DBox[{1, 9, 2}]}, 
           {RGBColor[
            0.6005084070670035, 0.7650539276887203, 0.24017333995255163`], 
            Point3DBox[{1, 9, 3}]}, 
           {RGBColor[
            0.9476818325728282, 0.8019889139842467, 0.6716955634102906], 
            Point3DBox[{1, 9, 4}]}, 
           {RGBColor[
            0.13635597206079875`, 0.9463104949310521, 0.07220872468887096], 
            Point3DBox[{1, 9, 5}]}, 
           {RGBColor[
            0.9807444193224186, 0.1343879708603839, 0.6439586588869883], 
            Point3DBox[{1, 9, 6}]}, 
           {RGBColor[
            0.22719120233723888`, 0.9354834538872161, 0.7445540312404564], 
            Point3DBox[{1, 9, 7}]}, 
           {RGBColor[
            0.0024592236286506974`, 0.43302285477393654`, 0.7318555613923503],
             Point3DBox[{1, 9, 8}]}, 
           {RGBColor[
            0.8295865635736088, 0.48796403225969587`, 0.7952771804343979], 
            Point3DBox[{1, 9, 9}]}, 
           {RGBColor[
            0.6895815352859007, 0.5209922782326637, 0.4920219386431792], 
            Point3DBox[{1, 9, 10}]}}, {
           {RGBColor[
            0.12609321597657974`, 0.8678841332915337, 0.8171949283818862], 
            Point3DBox[{1, 10, 1}]}, 
           {RGBColor[
            0.5732123985505848, 0.615182619521291, 0.20998199775392323`], 
            Point3DBox[{1, 10, 2}]}, 
           {RGBColor[
            0.14230261213053574`, 0.4558047975387669, 0.7548073771923427], 
            Point3DBox[{1, 10, 3}]}, 
           {RGBColor[
            0.4912328657819882, 0.6758051777559186, 0.6375209470857068], 
            Point3DBox[{1, 10, 4}]}, 
           {RGBColor[
            0.31108806673033507`, 0.6841826424062796, 0.8623532159376408], 
            Point3DBox[{1, 10, 5}]}, 
           {RGBColor[
            0.47890937593671534`, 0.7181929371759823, 0.8371616977328948], 
            Point3DBox[{1, 10, 6}]}, 
           {RGBColor[
            0.6636459868677438, 0.9968973791261211, 0.6286886449317359], 
            Point3DBox[{1, 10, 7}]}, 
           {RGBColor[
            0.7872836724281274, 0.6851694483928252, 0.038574486878128145`], 
            Point3DBox[{1, 10, 8}]}, 
           {RGBColor[
            0.18903418572599606`, 0.6062994343677333, 0.6845763122256034], 
            Point3DBox[{1, 10, 9}]}, 
           {RGBColor[
            0.8791452738067012, 0.3156583478557742, 0.4205254892073038], 
            Point3DBox[{1, 10, 10}]}}}, {{
           {RGBColor[
            0.5004300345312183, 0.11899472669191224`, 0.049915203616287984`], 
            Point3DBox[{2, 1, 1}]}, 
           {RGBColor[
            0.11966697234887103`, 0.6648570249826491, 0.6050962690110169], 
            Point3DBox[{2, 1, 2}]}, 
           {RGBColor[
            0.7185117376345203, 0.019575648976903448`, 0.428963383637063], 
            Point3DBox[{2, 1, 3}]}, 
           {RGBColor[
            0.03399063681428083, 0.11235727038527332`, 0.47861543341138946`], 
            Point3DBox[{2, 1, 4}]}, 
           {RGBColor[
            0.6448322241144826, 0.08869614494408062, 0.0024886383473219365`], 
            Point3DBox[{2, 1, 5}]}, 
           {RGBColor[
            0.3976748160250989, 0.8791563959728668, 0.3900125650253272], 
            Point3DBox[{2, 1, 6}]}, 
           {RGBColor[
            0.6444973524787794, 0.4728161516526417, 0.25685732790371474`], 
            Point3DBox[{2, 1, 7}]}, 
           {RGBColor[
            0.3789018780472362, 0.8252387717587748, 0.3546200732956595], 
            Point3DBox[{2, 1, 8}]}, 
           {RGBColor[
            0.09633172364285492, 0.20639774655117393`, 0.18310088805646618`], 
            Point3DBox[{2, 1, 9}]}, 
           {RGBColor[
            0.2447114533683068, 0.7115355875707661, 0.2108890666772396], 
            Point3DBox[{2, 1, 10}]}}, {
           {RGBColor[
            0.7204555213628034, 0.8025122943385476, 0.6358147304933666], 
            Point3DBox[{2, 2, 1}]}, 
           {RGBColor[
            0.32208569344277604`, 0.8842925158757213, 0.013889653869919139`], 
            Point3DBox[{2, 2, 2}]}, 
           {RGBColor[
            0.016425915483119002`, 0.584513450335379, 0.30821628651827293`], 
            Point3DBox[{2, 2, 3}]}, 
           {RGBColor[
            0.13766905373012706`, 0.8172191486621987, 0.9114419293969183], 
            Point3DBox[{2, 2, 4}]}, 
           {RGBColor[
            0.7523939585240118, 0.2158423549533166, 0.6842403562243409], 
            Point3DBox[{2, 2, 5}]}, 
           {RGBColor[
            0.09334188741280158, 0.3816055279175927, 0.4218646939906292], 
            Point3DBox[{2, 2, 6}]}, 
           {RGBColor[
            0.922391823166181, 0.6250997181158156, 0.7787013097488307], 
            Point3DBox[{2, 2, 7}]}, 
           {RGBColor[
            0.5153649588912455, 0.2952895139690006, 0.07721967501888205], 
            Point3DBox[{2, 2, 8}]}, 
           {RGBColor[
            0.06201563961878498, 0.26575002413504034`, 0.988213955166463], 
            Point3DBox[{2, 2, 9}]}, 
           {RGBColor[
            0.5062338655696852, 0.9598187984639917, 0.5825351996580086], 
            Point3DBox[{2, 2, 10}]}}, {
           {RGBColor[
            0.9371979507863448, 0.9484322963882588, 0.07831134648763971], 
            Point3DBox[{2, 3, 1}]}, 
           {RGBColor[
            0.4998391004968443, 0.6227080051909777, 0.5774455340206539], 
            Point3DBox[{2, 3, 2}]}, 
           {RGBColor[
            0.8079682227000862, 0.11899078919773554`, 0.9539196630595506], 
            Point3DBox[{2, 3, 3}]}, 
           {RGBColor[
            0.10109339507484072`, 0.02418589834951712, 0.9563009028437572], 
            Point3DBox[{2, 3, 4}]}, 
           {RGBColor[
            0.8415973712039433, 0.8798925072165362, 0.010185295037547393`], 
            Point3DBox[{2, 3, 5}]}, 
           {RGBColor[
            0.2485364667370673, 0.6146779850025861, 0.8859341339300035], 
            Point3DBox[{2, 3, 6}]}, 
           {RGBColor[
            0.5879852996764354, 0.5879901312740745, 0.7986402953259013], 
            Point3DBox[{2, 3, 7}]}, 
           {RGBColor[
            0.900437855431085, 0.18270542684374047`, 0.32449955758597016`], 
            Point3DBox[{2, 3, 8}]}, 
           {RGBColor[
            0.6609836832527438, 0.12317418285114501`, 0.030434744356602428`], 
            Point3DBox[{2, 3, 9}]}, 
           {RGBColor[
            0.23810319465340668`, 0.5693339283920686, 0.6356843073005038], 
            Point3DBox[{2, 3, 10}]}}, {
           {RGBColor[
            0.28462393348976356`, 0.9944154976645712, 0.5420718219743295], 
            Point3DBox[{2, 4, 1}]}, 
           {RGBColor[
            0.22752512106430856`, 0.10568237868942787`, 0.13681419412907148`],
             Point3DBox[{2, 4, 2}]}, 
           {RGBColor[
            0.1547041503145572, 0.6738943169948486, 0.8134987380721344], 
            Point3DBox[{2, 4, 3}]}, 
           {RGBColor[
            0.7340125192184854, 0.7028109056374845, 0.48421186192499355`], 
            Point3DBox[{2, 4, 4}]}, 
           {RGBColor[
            0.7009942289026629, 0.9039973733124607, 0.6492802975900538], 
            Point3DBox[{2, 4, 5}]}, 
           {RGBColor[
            0.257837016716707, 0.8478216514683061, 0.6722240561732122], 
            Point3DBox[{2, 4, 6}]}, 
           {RGBColor[
            0.20698942754504213`, 0.24266391430646328`, 0.9456613560336047], 
            Point3DBox[{2, 4, 7}]}, 
           {RGBColor[
            0.9636976510314097, 0.10022768336101828`, 0.0507666469639676], 
            Point3DBox[{2, 4, 8}]}, 
           {RGBColor[
            0.9835278829541054, 0.03861301203217349, 0.19818083751603055`], 
            Point3DBox[{2, 4, 9}]}, 
           {RGBColor[
            0.33664464987373743`, 0.7256511979327449, 0.3227132628552951], 
            Point3DBox[{2, 4, 10}]}}, {
           {RGBColor[
            0.7309463215841654, 0.10218099056175789`, 0.07088662888699493], 
            Point3DBox[{2, 5, 1}]}, 
           {RGBColor[
            0.7231035679152285, 0.7641464285525505, 0.7469960365161403], 
            Point3DBox[{2, 5, 2}]}, 
           {RGBColor[
            0.7779786333101368, 0.6735380611877129, 0.3377764862516006], 
            Point3DBox[{2, 5, 3}]}, 
           {RGBColor[
            0.9026647921930273, 0.9407841248696855, 0.9854069576570244], 
            Point3DBox[{2, 5, 4}]}, 
           {RGBColor[
            0.7472145196662374, 0.33314464537600075`, 0.48205084295298706`], 
            Point3DBox[{2, 5, 5}]}, 
           {RGBColor[
            0.694960718271735, 0.2997171558145537, 0.8888881496811336], 
            Point3DBox[{2, 5, 6}]}, 
           {RGBColor[
            0.4228327059782462, 0.588178930409744, 0.5095214744513978], 
            Point3DBox[{2, 5, 7}]}, 
           {RGBColor[
            0.7042643604924963, 0.43705050894824593`, 0.5738920598446307], 
            Point3DBox[{2, 5, 8}]}, 
           {RGBColor[
            0.14163941034554828`, 0.011500011204049754`, 0.7899068307919628], 
            Point3DBox[{2, 5, 9}]}, 
           {RGBColor[
            0.281417482756688, 0.9553081731850259, 0.9505608786763993], 
            Point3DBox[{2, 5, 10}]}}, {
           {RGBColor[
            0.6762859057821746, 0.010444697846570206`, 0.37267748335052], 
            Point3DBox[{2, 6, 1}]}, 
           {RGBColor[
            0.8923048092380963, 0.043979227798127685`, 0.2282452057484734], 
            Point3DBox[{2, 6, 2}]}, 
           {RGBColor[
            0.48891915384632845`, 0.9219726899720824, 0.7408002639152467], 
            Point3DBox[{2, 6, 3}]}, 
           {RGBColor[
            0.6890278282170479, 0.19111675522650406`, 0.41475341406294497`], 
            Point3DBox[{2, 6, 4}]}, 
           {RGBColor[
            0.3501166696555893, 0.00557304242868506, 0.9203770320532352], 
            Point3DBox[{2, 6, 5}]}, 
           {RGBColor[
            0.23690247753696636`, 0.44938523918931406`, 0.05394497323810299], 
            Point3DBox[{2, 6, 6}]}, 
           {RGBColor[
            0.4756390402796502, 0.3237570895084063, 0.00305088991666147], 
            Point3DBox[{2, 6, 7}]}, 
           {RGBColor[
            0.6374522961472935, 0.1614033354115092, 0.15850239270014121`], 
            Point3DBox[{2, 6, 8}]}, 
           {RGBColor[
            0.9794169345006363, 0.7767238324292758, 0.7220651850283291], 
            Point3DBox[{2, 6, 9}]}, 
           {RGBColor[
            0.6678945570652846, 0.8623283985848385, 0.9304103734725744], 
            Point3DBox[{2, 6, 10}]}}, {
           {RGBColor[
            0.9222216050785552, 0.37583556077886926`, 0.3187726603406207], 
            Point3DBox[{2, 7, 1}]}, 
           {RGBColor[
            0.18166963284458704`, 0.2425863461761233, 0.4695012353993415], 
            Point3DBox[{2, 7, 2}]}, 
           {RGBColor[
            0.24386183830136776`, 0.15104801236082976`, 0.14260625728704368`],
             Point3DBox[{2, 7, 3}]}, 
           {RGBColor[
            0.2627807140352205, 0.327818071942122, 0.06916397418705444], 
            Point3DBox[{2, 7, 4}]}, 
           {RGBColor[
            0.5067377322197466, 0.5001286561116378, 0.9375368245115978], 
            Point3DBox[{2, 7, 5}]}, 
           {RGBColor[
            0.6552735154631426, 0.7216558195090614, 0.9063591112651845], 
            Point3DBox[{2, 7, 6}]}, 
           {RGBColor[
            0.06676047177124489, 0.373992542543339, 0.8992086013303147], 
            Point3DBox[{2, 7, 7}]}, 
           {RGBColor[
            0.7717505233033777, 0.5694258894492092, 0.9073136975473919], 
            Point3DBox[{2, 7, 8}]}, 
           {RGBColor[
            0.3373807537972162, 0.8867198136642211, 0.7370086041475976], 
            Point3DBox[{2, 7, 9}]}, 
           {RGBColor[
            0.910150417778105, 0.3581918347537818, 0.9810642513735122], 
            Point3DBox[{2, 7, 10}]}}, {
           {RGBColor[
            0.04109721323528093, 0.2951650241340542, 0.22506503990371773`], 
            Point3DBox[{2, 8, 1}]}, 
           {RGBColor[
            0.6620373225037177, 0.7019921022703326, 0.44518352291806274`], 
            Point3DBox[{2, 8, 2}]}, 
           {RGBColor[
            0.7541773351809107, 0.6668315323685936, 0.981558565902376], 
            Point3DBox[{2, 8, 3}]}, 
           {RGBColor[
            0.9392567330381898, 0.39929799921504405`, 0.7251044169177612], 
            Point3DBox[{2, 8, 4}]}, 
           {RGBColor[
            0.2187765168394964, 0.5374140443693844, 0.3560973673039336], 
            Point3DBox[{2, 8, 5}]}, 
           {RGBColor[
            0.007156117378968707, 0.19154950288724004`, 0.6623554787670998], 
            Point3DBox[{2, 8, 6}]}, 
           {RGBColor[
            0.5186621756090968, 0.7842945747368655, 0.9827098726688543], 
            Point3DBox[{2, 8, 7}]}, 
           {RGBColor[
            0.7362036363417934, 0.9724923050088834, 0.22148646032668928`], 
            Point3DBox[{2, 8, 8}]}, 
           {RGBColor[
            0.5214058250424327, 0.42719084587598144`, 0.7049667542539244], 
            Point3DBox[{2, 8, 9}]}, 
           {RGBColor[
            0.8151320345601667, 0.688591166193492, 0.1549401668116046], 
            Point3DBox[{2, 8, 10}]}}, {
           {RGBColor[
            0.14553503721796002`, 0.5553462001001337, 0.2786282613988502], 
            Point3DBox[{2, 9, 1}]}, 
           {RGBColor[
            0.813884257173662, 0.37442959357683003`, 0.6222839901407158], 
            Point3DBox[{2, 9, 2}]}, 
           {RGBColor[
            0.38900586325340236`, 0.4758475949160541, 0.1970460459528809], 
            Point3DBox[{2, 9, 3}]}, 
           {RGBColor[
            0.9588365247498218, 0.6797113143704359, 0.9378170746549608], 
            Point3DBox[{2, 9, 4}]}, 
           {RGBColor[
            0.9761167228996661, 0.4739384729918814, 0.3906434945116388], 
            Point3DBox[{2, 9, 5}]}, 
           {RGBColor[
            0.239711874284686, 0.8130901486568787, 0.5569856293889917], 
            Point3DBox[{2, 9, 6}]}, 
           {RGBColor[
            0.5630682324828664, 0.19412963879191358`, 0.5007644043244159], 
            Point3DBox[{2, 9, 7}]}, 
           {RGBColor[
            0.6679200109581425, 0.8798106736794675, 0.7522716782733783], 
            Point3DBox[{2, 9, 8}]}, 
           {RGBColor[
            0.11004136878729609`, 0.4531395827837206, 0.508880454330034], 
            Point3DBox[{2, 9, 9}]}, 
           {RGBColor[
            0.3530008431315057, 0.7881325064229014, 0.11889738511712422`], 
            Point3DBox[{2, 9, 10}]}}, {
           {RGBColor[
            0.03084708810315484, 0.42349878412444997`, 0.6446461701506934], 
            Point3DBox[{2, 10, 1}]}, 
           {RGBColor[
            0.3950339652807777, 0.07926255190823506, 0.23802101799514697`], 
            Point3DBox[{2, 10, 2}]}, 
           {RGBColor[
            0.5561260868154547, 0.08089077871022399, 0.790331715579754], 
            Point3DBox[{2, 10, 3}]}, 
           {RGBColor[
            0.19939754936192666`, 0.48068417684936193`, 0.5765204373031354], 
            Point3DBox[{2, 10, 4}]}, 
           {RGBColor[
            0.43856671391714963`, 0.9895040255985479, 0.40851301757795677`], 
            Point3DBox[{2, 10, 5}]}, 
           {RGBColor[
            0.6991093089290117, 0.2947006385981241, 0.7682585445499011], 
            Point3DBox[{2, 10, 6}]}, 
           {RGBColor[
            0.5025241003944101, 0.8400536050689196, 0.2883806724188389], 
            Point3DBox[{2, 10, 7}]}, 
           {RGBColor[
            0.8621725015423463, 0.3047885263329322, 0.5665658925997801], 
            Point3DBox[{2, 10, 8}]}, 
           {RGBColor[
            0.17201001971935703`, 0.30321115683419975`, 0.4194914881044116], 
            Point3DBox[{2, 10, 9}]}, 
           {RGBColor[
            0.522850856612487, 0.5285334422384493, 0.17405340375274503`], 
            Point3DBox[{2, 10, 10}]}}}, {{
           {RGBColor[
            0.6519115795429848, 0.09452541434896644, 0.24224170928420152`], 
            Point3DBox[{3, 1, 1}]}, 
           {RGBColor[
            0.2707658375535227, 0.5049515344686044, 0.9807405434277727], 
            Point3DBox[{3, 1, 2}]}, 
           {RGBColor[
            0.2767788323692737, 0.46358932991714275`, 0.08839968860894865], 
            Point3DBox[{3, 1, 3}]}, 
           {RGBColor[
            0.046682457191454585`, 0.8708007702758203, 0.781335190609378], 
            Point3DBox[{3, 1, 4}]}, 
           {RGBColor[
            0.6073908113736741, 0.024791005341595618`, 0.06087496686943572], 
            Point3DBox[{3, 1, 5}]}, 
           {RGBColor[
            0.5145145068557113, 0.060471444327363066`, 0.17641518654242794`], 
            Point3DBox[{3, 1, 6}]}, 
           {RGBColor[
            0.722362987197174, 0.5105064405376802, 0.4534961629715555], 
            Point3DBox[{3, 1, 7}]}, 
           {RGBColor[
            0.8774709116072004, 0.05660126212767147, 0.6424629030223126], 
            Point3DBox[{3, 1, 8}]}, 
           {RGBColor[
            0.2250738214189112, 0.6681875953154777, 0.4023995116941994], 
            Point3DBox[{3, 1, 9}]}, 
           {RGBColor[
            0.5337341703219214, 0.15187694668374463`, 0.9653301665402896], 
            Point3DBox[{3, 1, 10}]}}, {
           {RGBColor[
            0.5372344239682325, 0.45095435679134166`, 0.32830757005897615`], 
            Point3DBox[{3, 2, 1}]}, 
           {RGBColor[
            0.15484508844190437`, 0.35892662184136537`, 0.4086965543757697], 
            Point3DBox[{3, 2, 2}]}, 
           {RGBColor[
            0.0604716819728468, 0.9015223700287118, 0.9517312397432458], 
            Point3DBox[{3, 2, 3}]}, 
           {RGBColor[
            0.2354909493605284, 0.30332351969508675`, 0.048805868968567756`], 
            Point3DBox[{3, 2, 4}]}, 
           {RGBColor[
            0.9296492456499417, 0.5420806777692997, 0.030814220363015066`], 
            Point3DBox[{3, 2, 5}]}, 
           {RGBColor[
            0.1655070571639523, 0.7537902862447576, 0.05201120875921039], 
            Point3DBox[{3, 2, 6}]}, 
           {RGBColor[
            0.8829341891989533, 0.2841970245803418, 0.49805003825223526`], 
            Point3DBox[{3, 2, 7}]}, 
           {RGBColor[
            0.9832831497939432, 0.4904994779647416, 0.7862666728449401], 
            Point3DBox[{3, 2, 8}]}, 
           {RGBColor[
            0.7936673564286665, 0.4645697150341095, 0.8955989091294629], 
            Point3DBox[{3, 2, 9}]}, 
           {RGBColor[
            0.6749397852127184, 0.45083897536957207`, 0.16060723387421838`], 
            Point3DBox[{3, 2, 10}]}}, {
           {RGBColor[
            0.45892816013786275`, 0.19885198436934037`, 0.5294015688264129], 
            Point3DBox[{3, 3, 1}]}, 
           {RGBColor[
            0.9344061232688188, 0.3593528253059346, 0.8808720347693753], 
            Point3DBox[{3, 3, 2}]}, 
           {RGBColor[
            0.4812086215126343, 0.9885054190311164, 0.6690953028435482], 
            Point3DBox[{3, 3, 3}]}, 
           {RGBColor[
            0.23071741141557256`, 0.5596739504595716, 0.49581056073069996`], 
            Point3DBox[{3, 3, 4}]}, 
           {RGBColor[
            0.3926758795308567, 0.4616722720231303, 0.7631533495818219], 
            Point3DBox[{3, 3, 5}]}, 
           {RGBColor[
            0.8557097569613576, 0.4311045613577571, 0.6236520346534691], 
            Point3DBox[{3, 3, 6}]}, 
           {RGBColor[
            0.7942766541140607, 0.4999768873473849, 0.6958326680424332], 
            Point3DBox[{3, 3, 7}]}, 
           {RGBColor[
            0.28223503234979885`, 0.00625875973194745, 0.6354540699637501], 
            Point3DBox[{3, 3, 8}]}, 
           {RGBColor[
            0.9598507653463222, 0.2708753973838349, 0.25015901564769294`], 
            Point3DBox[{3, 3, 9}]}, 
           {RGBColor[
            0.8315012264866275, 0.8100476499838343, 0.27342504136474344`], 
            Point3DBox[{3, 3, 10}]}}, {
           {RGBColor[
            0.825732410267688, 0.6050835619550952, 0.8884965343613893], 
            Point3DBox[{3, 4, 1}]}, 
           {RGBColor[
            0.7105319155741412, 0.7044891453152486, 0.5371557458108476], 
            Point3DBox[{3, 4, 2}]}, 
           {RGBColor[
            0.9858977499893136, 0.052636643100376634`, 0.4090947394174962], 
            Point3DBox[{3, 4, 3}]}, 
           {RGBColor[
            0.7142077040263259, 0.913509468050268, 0.07696035114027344], 
            Point3DBox[{3, 4, 4}]}, 
           {RGBColor[
            0.9309331463556598, 0.1789642234333919, 0.40900774883159974`], 
            Point3DBox[{3, 4, 5}]}, 
           {RGBColor[
            0.28892932786124303`, 0.9696854812058995, 0.05224360204529388], 
            Point3DBox[{3, 4, 6}]}, 
           {RGBColor[
            0.7360102078786432, 0.11102687994281935`, 0.9995951377796077], 
            Point3DBox[{3, 4, 7}]}, 
           {RGBColor[
            0.2687025180203224, 0.8430267188876768, 0.2971990456798945], 
            Point3DBox[{3, 4, 8}]}, 
           {RGBColor[
            0.3754283713362603, 0.5121372777713957, 0.3568931601473011], 
            Point3DBox[{3, 4, 9}]}, 
           {RGBColor[
            0.7459092133536758, 0.3769337017551302, 0.7001407519867302], 
            Point3DBox[{3, 4, 10}]}}, {
           {RGBColor[
            0.6174001683605694, 0.6160172679749127, 0.7090452433482421], 
            Point3DBox[{3, 5, 1}]}, 
           {RGBColor[
            0.44456545637895073`, 0.7923407907647488, 0.0029876511505730896`],
             Point3DBox[{3, 5, 2}]}, 
           {RGBColor[
            0.7598544144708752, 0.9880352515627635, 0.9836142119176463], 
            Point3DBox[{3, 5, 3}]}, 
           {RGBColor[
            0.800269345660142, 0.9165440880779214, 0.3345655370283409], 
            Point3DBox[{3, 5, 4}]}, 
           {RGBColor[
            0.15004482510673944`, 0.8563141812182926, 0.7538481812404338], 
            Point3DBox[{3, 5, 5}]}, 
           {RGBColor[
            0.13617534499018746`, 0.20098700196172037`, 0.655278427287548], 
            Point3DBox[{3, 5, 6}]}, 
           {RGBColor[
            0.7141716784414915, 0.8757909054167783, 0.6981731483468352], 
            Point3DBox[{3, 5, 7}]}, 
           {RGBColor[
            0.24562451768519722`, 0.400169855214191, 0.06081233560346311], 
            Point3DBox[{3, 5, 8}]}, 
           {RGBColor[
            0.47347302135989744`, 0.5510245128764106, 0.2230286228182463], 
            Point3DBox[{3, 5, 9}]}, 
           {RGBColor[
            0.005916973205077669, 0.614593517055283, 0.9975643033437915], 
            Point3DBox[{3, 5, 10}]}}, {
           {RGBColor[
            0.4977933432474051, 0.34974236667194725`, 0.7579210680208397], 
            Point3DBox[{3, 6, 1}]}, 
           {RGBColor[
            0.017981314735465936`, 0.12960860605717772`, 0.9928154346677358], 
            Point3DBox[{3, 6, 2}]}, 
           {RGBColor[
            0.3100630001225979, 0.35721846855801975`, 0.8159816298170024], 
            Point3DBox[{3, 6, 3}]}, 
           {RGBColor[
            0.15277374936816202`, 0.18260039460878152`, 0.63886966516932], 
            Point3DBox[{3, 6, 4}]}, 
           {RGBColor[
            0.18615370657670138`, 0.5675117028213483, 0.12682713397745915`], 
            Point3DBox[{3, 6, 5}]}, 
           {RGBColor[
            0.8852900218797655, 0.8888342683573023, 0.7130667627859841], 
            Point3DBox[{3, 6, 6}]}, 
           {RGBColor[
            0.8044569618451123, 0.43556925111084355`, 0.6124272442294194], 
            Point3DBox[{3, 6, 7}]}, 
           {RGBColor[
            0.7851667992211944, 0.9033860527889148, 0.0850234030027115], 
            Point3DBox[{3, 6, 8}]}, 
           {RGBColor[
            0.5851968434083117, 0.7664103538560201, 0.600972691565089], 
            Point3DBox[{3, 6, 9}]}, 
           {RGBColor[
            0.3846355434265065, 0.10173726165508712`, 0.6672537166403423], 
            Point3DBox[{3, 6, 10}]}}, {
           {RGBColor[
            0.985916482309998, 0.24292219390772885`, 0.05528529488264011], 
            Point3DBox[{3, 7, 1}]}, 
           {RGBColor[
            0.11868618914163043`, 0.7243248972310019, 0.018329545265127978`], 
            Point3DBox[{3, 7, 2}]}, 
           {RGBColor[
            0.562337801662163, 0.15516159535192253`, 0.689292473026913], 
            Point3DBox[{3, 7, 3}]}, 
           {RGBColor[
            0.19496418482846178`, 0.736819916531551, 0.7424527292374248], 
            Point3DBox[{3, 7, 4}]}, 
           {RGBColor[
            0.5191170634394158, 0.4142340891633385, 0.2809949512621097], 
            Point3DBox[{3, 7, 5}]}, 
           {RGBColor[
            0.20984519530484502`, 0.7130599166131537, 0.25574927896223065`], 
            Point3DBox[{3, 7, 6}]}, 
           {RGBColor[
            0.0362596031057405, 0.008280859303067212, 0.4184101157418758], 
            Point3DBox[{3, 7, 7}]}, 
           {RGBColor[
            0.07546885363133016, 0.958045126897928, 0.24625953661047628`], 
            Point3DBox[{3, 7, 8}]}, 
           {RGBColor[
            0.9467913561638406, 0.20712674297949096`, 0.36304232728674113`], 
            Point3DBox[{3, 7, 9}]}, 
           {RGBColor[
            0.4682299905256717, 0.20554112789598555`, 0.6545670636794529], 
            Point3DBox[{3, 7, 10}]}}, {
           {RGBColor[
            0.19757216675963551`, 0.1336754384979526, 0.36698370005787373`], 
            Point3DBox[{3, 8, 1}]}, 
           {RGBColor[
            0.8377842314578177, 0.5942571890894921, 0.6308752683473549], 
            Point3DBox[{3, 8, 2}]}, 
           {RGBColor[
            0.08144707764897019, 0.5317205342709799, 0.741303024088058], 
            Point3DBox[{3, 8, 3}]}, 
           {RGBColor[
            0.7456535398639395, 0.34388310447747505`, 0.15989690393101208`], 
            Point3DBox[{3, 8, 4}]}, 
           {RGBColor[
            0.9191495017326103, 0.4148766961856787, 0.7354619546203418], 
            Point3DBox[{3, 8, 5}]}, 
           {RGBColor[
            0.7923022828074391, 0.6833852243613332, 0.4808621204076844], 
            Point3DBox[{3, 8, 6}]}, 
           {RGBColor[
            0.3531710340260221, 0.5651674802830517, 0.406838432850984], 
            Point3DBox[{3, 8, 7}]}, 
           {RGBColor[
            0.7819750028442092, 0.8990963579080937, 0.43935795682001233`], 
            Point3DBox[{3, 8, 8}]}, 
           {RGBColor[
            0.01523511750301787, 0.9359121850835359, 0.8922927402652918], 
            Point3DBox[{3, 8, 9}]}, 
           {RGBColor[
            0.6967387376494758, 0.9178095410581009, 0.49549331472697666`], 
            Point3DBox[{3, 8, 10}]}}, {
           {RGBColor[
            0.3250431499685451, 0.5654460341092578, 0.514972704763708], 
            Point3DBox[{3, 9, 1}]}, 
           {RGBColor[
            0.5004768741654528, 0.9193361935781974, 0.9764238052740888], 
            Point3DBox[{3, 9, 2}]}, 
           {RGBColor[
            0.9384039136569895, 0.7259743184822123, 0.4562449007793732], 
            Point3DBox[{3, 9, 3}]}, 
           {RGBColor[
            0.25673922035949337`, 0.1847760263163818, 0.6709899805540052], 
            Point3DBox[{3, 9, 4}]}, 
           {RGBColor[
            0.342308397032836, 0.2877554471036503, 0.35259991347465025`], 
            Point3DBox[{3, 9, 5}]}, 
           {RGBColor[
            0.9827087350497903, 0.008823920285799147, 0.4094336211182139], 
            Point3DBox[{3, 9, 6}]}, 
           {RGBColor[
            0.219295631463166, 0.4235281452702717, 0.8187211389376405], 
            Point3DBox[{3, 9, 7}]}, 
           {RGBColor[
            0.8986741252468842, 0.5771210691112634, 0.17401383353172029`], 
            Point3DBox[{3, 9, 8}]}, 
           {RGBColor[
            0.37843221421054674`, 0.36970328596091795`, 0.08934811767221729], 
            Point3DBox[{3, 9, 9}]}, 
           {RGBColor[
            0.8604387714030131, 0.6394057598471259, 0.5748958619786291], 
            Point3DBox[{3, 9, 10}]}}, {
           {RGBColor[
            0.6405460716877869, 0.6201911500106594, 0.5044890331876097], 
            Point3DBox[{3, 10, 1}]}, 
           {RGBColor[
            0.5989657445750585, 0.399285022710552, 0.5939898062123543], 
            Point3DBox[{3, 10, 2}]}, 
           {RGBColor[
            0.8757717709528867, 0.6612519254503024, 0.1263567759990456], 
            Point3DBox[{3, 10, 3}]}, 
           {RGBColor[
            0.5298531085498268, 0.8346299051453392, 0.3346423535530012], 
            Point3DBox[{3, 10, 4}]}, 
           {RGBColor[
            0.7623013008935484, 0.22975943601642612`, 0.5620010201495775], 
            Point3DBox[{3, 10, 5}]}, 
           {RGBColor[
            0.3679528991003824, 0.6993807350978773, 0.529509035009937], 
            Point3DBox[{3, 10, 6}]}, 
           {RGBColor[
            0.4873132833141707, 0.04341149876150774, 0.14455971618599572`], 
            Point3DBox[{3, 10, 7}]}, 
           {RGBColor[
            0.14998337718312627`, 0.9351161675406732, 0.6541036422483271], 
            Point3DBox[{3, 10, 8}]}, 
           {RGBColor[
            0.2868221044767545, 0.6289041375403368, 0.5192677070318457], 
            Point3DBox[{3, 10, 9}]}, 
           {RGBColor[
            0.6230252638404363, 0.6759791969456295, 0.296403460638885], 
            Point3DBox[{3, 10, 10}]}}}, {{
           {RGBColor[
            0.1076974850108765, 0.6544579160850197, 0.3500634151901847], 
            Point3DBox[{4, 1, 1}]}, 
           {RGBColor[
            0.17395278911242884`, 0.33025509470554115`, 0.622158932808299], 
            Point3DBox[{4, 1, 2}]}, 
           {RGBColor[
            0.944033189908559, 0.8796516964161931, 0.7934162488028458], 
            Point3DBox[{4, 1, 3}]}, 
           {RGBColor[
            0.09074795696617999, 0.017637460073064437`, 0.710027675853041], 
            Point3DBox[{4, 1, 4}]}, 
           {RGBColor[
            0.17355278392772822`, 0.06257218801144715, 0.14549210544009994`], 
            Point3DBox[{4, 1, 5}]}, 
           {RGBColor[
            0.8296994786907446, 0.7544836462554099, 0.40598704623935045`], 
            Point3DBox[{4, 1, 6}]}, 
           {RGBColor[
            0.9003267099455685, 0.3075233231951051, 0.25516723626099647`], 
            Point3DBox[{4, 1, 7}]}, 
           {RGBColor[
            0.7759128470495438, 0.9934419116873212, 0.6048904930390233], 
            Point3DBox[{4, 1, 8}]}, 
           {RGBColor[
            0.5918988976467656, 0.40075109800261566`, 0.054062064016884515`], 
            Point3DBox[{4, 1, 9}]}, 
           {RGBColor[
            0.8049187176305241, 0.028944403092504345`, 0.5662196043253414], 
            Point3DBox[{4, 1, 10}]}}, {
           {RGBColor[
            0.5327103955665784, 0.46682645229349884`, 0.31385581414010577`], 
            Point3DBox[{4, 2, 1}]}, 
           {RGBColor[
            0.9989980162946859, 0.6908914868706679, 0.3657705861175018], 
            Point3DBox[{4, 2, 2}]}, 
           {RGBColor[
            0.3525259926888893, 0.5283329675925272, 0.8429349943904929], 
            Point3DBox[{4, 2, 3}]}, 
           {RGBColor[
            0.07020250621479196, 0.0031987658643974903`, 0.8212303981025835], 
            Point3DBox[{4, 2, 4}]}, 
           {RGBColor[
            0.8353275018423172, 0.04986417436764645, 0.0683727114583399], 
            Point3DBox[{4, 2, 5}]}, 
           {RGBColor[
            0.7762098114166927, 0.148655370220802, 0.10088168437698353`], 
            Point3DBox[{4, 2, 6}]}, 
           {RGBColor[
            0.3998079874984193, 0.9791462393810353, 0.7488965018226936], 
            Point3DBox[{4, 2, 7}]}, 
           {RGBColor[
            0.21980890764599414`, 0.7513885631200172, 0.8650850744631655], 
            Point3DBox[{4, 2, 8}]}, 
           {RGBColor[
            0.4008940326302308, 0.9919645905707106, 0.8190441353886933], 
            Point3DBox[{4, 2, 9}]}, 
           {RGBColor[
            0.6274769361440329, 0.5018555781532932, 0.8641143503780879], 
            Point3DBox[{4, 2, 10}]}}, {
           {RGBColor[
            0.13593282105031168`, 0.1337337409309971, 0.5983765722877894], 
            Point3DBox[{4, 3, 1}]}, 
           {RGBColor[
            0.3587334472687749, 0.988575851395407, 0.9147852585117069], 
            Point3DBox[{4, 3, 2}]}, 
           {RGBColor[
            0.27531448105238, 0.7270904521247554, 0.6966738672691837], 
            Point3DBox[{4, 3, 3}]}, 
           {RGBColor[
            0.2612119572794005, 0.8738124441085939, 0.2048829891773778], 
            Point3DBox[{4, 3, 4}]}, 
           {RGBColor[
            0.6339551203041425, 0.06676348538663546, 0.48338879314827743`], 
            Point3DBox[{4, 3, 5}]}, 
           {RGBColor[
            0.2443322448087637, 0.189513704782452, 0.715362221053718], 
            Point3DBox[{4, 3, 6}]}, 
           {RGBColor[
            0.07005927842166093, 0.1295922589586782, 0.3631373219843441], 
            Point3DBox[{4, 3, 7}]}, 
           {RGBColor[
            0.024849809700978165`, 0.6663845203868388, 0.7130962984797187], 
            Point3DBox[{4, 3, 8}]}, 
           {RGBColor[
            0.24641884708462602`, 0.6033969188375015, 0.19603574346811592`], 
            Point3DBox[{4, 3, 9}]}, 
           {RGBColor[
            0.3653979875189033, 0.4920496346912102, 0.5970376242078936], 
            Point3DBox[{4, 3, 10}]}}, {
           {RGBColor[
            0.3830878852586441, 0.5660754003582502, 0.1411186927939898], 
            Point3DBox[{4, 4, 1}]}, 
           {RGBColor[
            0.6750323185055067, 0.014486409340938033`, 0.662364830165034], 
            Point3DBox[{4, 4, 2}]}, 
           {RGBColor[
            0.6320085459306919, 0.1784067528603468, 0.8375382168446774], 
            Point3DBox[{4, 4, 3}]}, 
           {RGBColor[
            0.20211241309915762`, 0.5438816773011044, 0.15485838509525673`], 
            Point3DBox[{4, 4, 4}]}, 
           {RGBColor[
            0.6871919778743552, 0.0692392233107737, 0.38353738301182405`], 
            Point3DBox[{4, 4, 5}]}, 
           {RGBColor[
            0.22096599906221281`, 0.14906017910574465`, 0.5524163407807121], 
            Point3DBox[{4, 4, 6}]}, 
           {RGBColor[
            0.44235081145832544`, 0.7412398149759625, 0.9059816957443898], 
            Point3DBox[{4, 4, 7}]}, 
           {RGBColor[
            0.3051789946780388, 0.8916701362361825, 0.23398499573218667`], 
            Point3DBox[{4, 4, 8}]}, 
           {RGBColor[
            0.7555764442249528, 0.7570052280591353, 0.7088681826743239], 
            Point3DBox[{4, 4, 9}]}, 
           {RGBColor[
            0.7239280375851036, 0.5328022723824914, 0.27909346134823454`], 
            Point3DBox[{4, 4, 10}]}}, {
           {RGBColor[
            0.6673883773697706, 0.7150575787756897, 0.1963018880274412], 
            Point3DBox[{4, 5, 1}]}, 
           {RGBColor[
            0.5543756424703885, 0.33184057475469864`, 0.0562168238820564], 
            Point3DBox[{4, 5, 2}]}, 
           {RGBColor[
            0.24609564498070546`, 0.6805981688919738, 0.5230451271278924], 
            Point3DBox[{4, 5, 3}]}, 
           {RGBColor[
            0.9627110738141018, 0.7194318713839047, 0.9213320878515163], 
            Point3DBox[{4, 5, 4}]}, 
           {RGBColor[
            0.2481951358536385, 0.29424000848000986`, 0.7959248037089115], 
            Point3DBox[{4, 5, 5}]}, 
           {RGBColor[
            0.4305707908919303, 0.8975864554756214, 0.1473311418475527], 
            Point3DBox[{4, 5, 6}]}, 
           {RGBColor[
            0.4570580326945981, 0.9482045437250792, 0.5603557753844419], 
            Point3DBox[{4, 5, 7}]}, 
           {RGBColor[
            0.237112222205778, 0.10270365879566956`, 0.8428857083831505], 
            Point3DBox[{4, 5, 8}]}, 
           {RGBColor[
            0.34062797293749236`, 0.30576020797800374`, 0.2975219148279644], 
            Point3DBox[{4, 5, 9}]}, 
           {RGBColor[
            0.7995615635832434, 0.13372892454436003`, 0.6036541019181558], 
            Point3DBox[{4, 5, 10}]}}, {
           {RGBColor[
            0.9341742919914091, 0.35339443532298764`, 0.3996235141874964], 
            Point3DBox[{4, 6, 1}]}, 
           {RGBColor[
            0.6791727429506427, 0.7524420144866346, 0.44856727335701607`], 
            Point3DBox[{4, 6, 2}]}, 
           {RGBColor[
            0.6270621449927827, 0.3488165751640129, 0.40737774059438236`], 
            Point3DBox[{4, 6, 3}]}, 
           {RGBColor[
            0.07122027029951616, 0.0040456786810865175`, 0.5771105596536572], 
            Point3DBox[{4, 6, 4}]}, 
           {RGBColor[
            0.9136738279081951, 0.299468331352444, 0.7460933074701899], 
            Point3DBox[{4, 6, 5}]}, 
           {RGBColor[
            0.6749564735115936, 0.11587197415588468`, 0.8899205852281207], 
            Point3DBox[{4, 6, 6}]}, 
           {RGBColor[
            0.03670819997912522, 0.6565433654586197, 0.3741360211019995], 
            Point3DBox[{4, 6, 7}]}, 
           {RGBColor[
            0.7062962326781481, 0.938191300132613, 0.5525575854419285], 
            Point3DBox[{4, 6, 8}]}, 
           {RGBColor[
            0.01887139597173748, 0.6069720528777345, 0.5678964592286888], 
            Point3DBox[{4, 6, 9}]}, 
           {RGBColor[
            0.4931171691554317, 0.996186237833268, 0.6628116239526436], 
            Point3DBox[{4, 6, 10}]}}, {
           {RGBColor[
            0.9477412584064888, 0.8450878991808213, 0.13934453345401598`], 
            Point3DBox[{4, 7, 1}]}, 
           {RGBColor[
            0.926696049751943, 0.5325606662678464, 0.7392125561110372], 
            Point3DBox[{4, 7, 2}]}, 
           {RGBColor[
            0.2350958258934419, 0.19711885505285154`, 0.4518059813770374], 
            Point3DBox[{4, 7, 3}]}, 
           {RGBColor[
            0.654003891907021, 0.08383544222684525, 0.4658895495179074], 
            Point3DBox[{4, 7, 4}]}, 
           {RGBColor[
            0.4580238922415931, 0.9402518503615243, 0.5051119365744585], 
            Point3DBox[{4, 7, 5}]}, 
           {RGBColor[
            0.5445105645174639, 0.20122927254417067`, 0.538426089066794], 
            Point3DBox[{4, 7, 6}]}, 
           {RGBColor[
            0.7880424232827592, 0.08359901118560265, 0.3882262811750987], 
            Point3DBox[{4, 7, 7}]}, 
           {RGBColor[
            0.8458739875933514, 0.38866857166057844`, 0.9685263277526202], 
            Point3DBox[{4, 7, 8}]}, 
           {RGBColor[
            0.32830898028533206`, 0.0575663045016539, 0.2573006355585341], 
            Point3DBox[{4, 7, 9}]}, 
           {RGBColor[
            0.8912335345187907, 0.7068489379069756, 0.8406533095366666], 
            Point3DBox[{4, 7, 10}]}}, {
           {RGBColor[
            0.08241297901908129, 0.21588068982711306`, 0.4112827305029587], 
            Point3DBox[{4, 8, 1}]}, 
           {RGBColor[
            0.3220108718060828, 0.17950018546146085`, 0.24217579018900115`], 
            Point3DBox[{4, 8, 2}]}, 
           {RGBColor[
            0.3383562520538508, 0.7449148433723936, 0.21043252012565516`], 
            Point3DBox[{4, 8, 3}]}, 
           {RGBColor[
            0.6038766012742227, 0.7521110243001952, 0.2364377492069485], 
            Point3DBox[{4, 8, 4}]}, 
           {RGBColor[
            0.16981731958476676`, 0.8763042098654072, 0.5278958648994758], 
            Point3DBox[{4, 8, 5}]}, 
           {RGBColor[
            0.8402657600225814, 0.9629637246709246, 0.6091229901979436], 
            Point3DBox[{4, 8, 6}]}, 
           {RGBColor[
            0.5361644260509879, 0.9508643378724715, 0.46408906953211426`], 
            Point3DBox[{4, 8, 7}]}, 
           {RGBColor[
            0.9271320630920685, 0.33580214772771244`, 0.7486527951735884], 
            Point3DBox[{4, 8, 8}]}, 
           {RGBColor[
            0.7320116781613031, 0.8111681969700613, 0.004758679042716318], 
            Point3DBox[{4, 8, 9}]}, 
           {RGBColor[
            0.5836161406335534, 0.8650165134431975, 0.3369288953434497], 
            Point3DBox[{4, 8, 10}]}}, {
           {RGBColor[
            0.8404863364509305, 0.5932423760167194, 0.13534761393230532`], 
            Point3DBox[{4, 9, 1}]}, 
           {RGBColor[
            0.9847649786251751, 0.5169822325431728, 0.7379403645418503], 
            Point3DBox[{4, 9, 2}]}, 
           {RGBColor[
            0.3938657221646513, 0.36145151201079484`, 0.1648998901381149], 
            Point3DBox[{4, 9, 3}]}, 
           {RGBColor[
            0.6494104432604297, 0.8612863596737295, 0.42427569055342684`], 
            Point3DBox[{4, 9, 4}]}, 
           {RGBColor[
            0.1206778026176687, 0.6126955566813019, 0.3045682619076322], 
            Point3DBox[{4, 9, 5}]}, 
           {RGBColor[
            0.8705880473006016, 0.5872703846412102, 0.9838763511012698], 
            Point3DBox[{4, 9, 6}]}, 
           {RGBColor[
            0.5102236334469983, 0.5258278659280393, 0.7868018744297336], 
            Point3DBox[{4, 9, 7}]}, 
           {RGBColor[
            0.553995052064512, 0.27953405366295336`, 0.13085631388701557`], 
            Point3DBox[{4, 9, 8}]}, 
           {RGBColor[
            0.6885131459394427, 0.7235248817557449, 0.7647682206763531], 
            Point3DBox[{4, 9, 9}]}, 
           {RGBColor[
            0.4416845238659961, 0.22883662037205332`, 0.9266871800257599], 
            Point3DBox[{4, 9, 10}]}}, {
           {RGBColor[
            0.848544816209299, 0.702833089502455, 0.4640686465360897], 
            Point3DBox[{4, 10, 1}]}, 
           {RGBColor[
            0.9934194583660105, 0.07425379005532706, 0.7560510896565802], 
            Point3DBox[{4, 10, 2}]}, 
           {RGBColor[
            0.9346613912652206, 0.7492989136605721, 0.146718273271214], 
            Point3DBox[{4, 10, 3}]}, 
           {RGBColor[
            0.33192359298318874`, 0.7388461630924297, 0.8713507463491905], 
            Point3DBox[{4, 10, 4}]}, 
           {RGBColor[
            0.7775206058538819, 0.14873824437231775`, 0.9291461438461313], 
            Point3DBox[{4, 10, 5}]}, 
           {RGBColor[
            0.09758063554652208, 0.917582652731354, 0.5389095606616854], 
            Point3DBox[{4, 10, 6}]}, 
           {RGBColor[
            0.12090988382113843`, 0.9442839575520583, 0.5981682111559956], 
            Point3DBox[{4, 10, 7}]}, 
           {RGBColor[
            0.23764955509077734`, 0.29066687568855687`, 0.46900548770104256`],
             Point3DBox[{4, 10, 8}]}, 
           {RGBColor[
            0.9704207968853222, 0.21173941042015443`, 0.41855889850062633`], 
            Point3DBox[{4, 10, 9}]}, 
           {RGBColor[
            0.009206990136912063, 0.006839064621932289, 0.1207039770525904], 
            Point3DBox[{4, 10, 10}]}}}, {{
           {RGBColor[
            0.9447344990929307, 0.7039380210093842, 0.5886276870226528], 
            Point3DBox[{5, 1, 1}]}, 
           {RGBColor[
            0.440975289918627, 0.8175348630459849, 0.9004257235701478], 
            Point3DBox[{5, 1, 2}]}, 
           {RGBColor[
            0.016161394555104902`, 0.0012932172300081923`, 0.221373515827056],
             Point3DBox[{5, 1, 3}]}, 
           {RGBColor[
            0.24223871275503872`, 0.23924686244036764`, 0.20125541204402309`],
             Point3DBox[{5, 1, 4}]}, 
           {RGBColor[
            0.36769358091886617`, 0.6615124595661022, 0.9676859864762049], 
            Point3DBox[{5, 1, 5}]}, 
           {RGBColor[
            0.8501719124156011, 0.34329391045450897`, 0.5082219895893787], 
            Point3DBox[{5, 1, 6}]}, 
           {RGBColor[
            0.3124644052264056, 0.6603538254128132, 0.8999369185652903], 
            Point3DBox[{5, 1, 7}]}, 
           {RGBColor[
            0.5090194606962715, 0.619750733499616, 0.07087013094614791], 
            Point3DBox[{5, 1, 8}]}, 
           {RGBColor[
            0.7075614077276027, 0.23419882203406805`, 0.2502364898638274], 
            Point3DBox[{5, 1, 9}]}, 
           {RGBColor[
            0.6726108453865263, 0.8001184276993001, 0.6800751850373454], 
            Point3DBox[{5, 1, 10}]}}, {
           {RGBColor[
            0.68755735443024, 0.22426567182317192`, 0.6701763815312829], 
            Point3DBox[{5, 2, 1}]}, 
           {RGBColor[
            0.43816718968931223`, 0.8982865046196751, 0.12448336690505557`], 
            Point3DBox[{5, 2, 2}]}, 
           {RGBColor[
            0.04070018177010226, 0.6163101983254207, 0.7873843048125568], 
            Point3DBox[{5, 2, 3}]}, 
           {RGBColor[
            0.6437525189868429, 0.9883123591869099, 0.9004602347276687], 
            Point3DBox[{5, 2, 4}]}, 
           {RGBColor[
            0.7443822877073298, 0.5387736330970896, 0.018054554505675613`], 
            Point3DBox[{5, 2, 5}]}, 
           {RGBColor[
            0.3104498486206362, 0.6230812741166629, 0.6229649583605237], 
            Point3DBox[{5, 2, 6}]}, 
           {RGBColor[
            0.4266609340477501, 0.6810214223617452, 0.19534178969227933`], 
            Point3DBox[{5, 2, 7}]}, 
           {RGBColor[
            0.3881080376366757, 0.4474007708845906, 0.5060256941422845], 
            Point3DBox[{5, 2, 8}]}, 
           {RGBColor[
            0.9097266164725222, 0.6635273824844219, 0.19415793562103056`], 
            Point3DBox[{5, 2, 9}]}, 
           {RGBColor[
            0.7981098570254943, 0.6676535490231377, 0.7425420038823973], 
            Point3DBox[{5, 2, 10}]}}, {
           {RGBColor[
            0.5111780436012172, 0.647600554837586, 0.8334636626736498], 
            Point3DBox[{5, 3, 1}]}, 
           {RGBColor[
            0.004831861396863424, 0.056213689972136605`, 0.9824234566508969], 
            Point3DBox[{5, 3, 2}]}, 
           {RGBColor[
            0.4998702078100423, 0.15067518767562071`, 0.0768084562622866], 
            Point3DBox[{5, 3, 3}]}, 
           {RGBColor[
            0.5361509974677059, 0.3828430175335964, 0.7305373951298588], 
            Point3DBox[{5, 3, 4}]}, 
           {RGBColor[
            0.3788053499490416, 0.9393048070312839, 0.2310166155874671], 
            Point3DBox[{5, 3, 5}]}, 
           {RGBColor[
            0.9549063591458042, 0.9951718990864167, 0.7635990043850458], 
            Point3DBox[{5, 3, 6}]}, 
           {RGBColor[
            0.6349478522301735, 0.06512950964059128, 0.10338787444766373`], 
            Point3DBox[{5, 3, 7}]}, 
           {RGBColor[
            0.5308597410339577, 0.8996807936167601, 0.7919136399605307], 
            Point3DBox[{5, 3, 8}]}, 
           {RGBColor[
            0.5393713085432863, 0.9568820891338121, 0.49392569134235], 
            Point3DBox[{5, 3, 9}]}, 
           {RGBColor[
            0.8512612218976363, 0.4942674318423186, 0.21133689381728837`], 
            Point3DBox[{5, 3, 10}]}}, {
           {RGBColor[
            0.10340338542574701`, 0.4568831850175554, 0.2399026894635765], 
            Point3DBox[{5, 4, 1}]}, 
           {RGBColor[
            0.6953438023268266, 0.8386862652298479, 0.940296974855743], 
            Point3DBox[{5, 4, 2}]}, 
           {RGBColor[
            0.8849034940749729, 0.0491903763564443, 0.3046364121126759], 
            Point3DBox[{5, 4, 3}]}, 
           {RGBColor[
            0.7263772052685702, 0.5820797028077018, 0.4330475608239941], 
            Point3DBox[{5, 4, 4}]}, 
           {RGBColor[
            0.5780408011215414, 0.7191434784924671, 0.9628732837760003], 
            Point3DBox[{5, 4, 5}]}, 
           {RGBColor[
            0.8530237564734011, 0.3869431678551525, 0.9075783934915069], 
            Point3DBox[{5, 4, 6}]}, 
           {RGBColor[
            0.3248867749167188, 0.20672786358049722`, 0.27874298241460926`], 
            Point3DBox[{5, 4, 7}]}, 
           {RGBColor[
            0.4947960964620528, 0.20555240041754197`, 0.4512309227005009], 
            Point3DBox[{5, 4, 8}]}, 
           {RGBColor[
            0.21225860060720803`, 0.9785198134177795, 0.7617651463426334], 
            Point3DBox[{5, 4, 9}]}, 
           {RGBColor[
            0.3070488896997319, 0.623657663723949, 0.8409280369109751], 
            Point3DBox[{5, 4, 10}]}}, {
           {RGBColor[
            0.3881100436585534, 0.7708623931733238, 0.6613874093575045], 
            Point3DBox[{5, 5, 1}]}, 
           {RGBColor[
            0.3130637923446944, 0.4214794110022473, 0.391040806521439], 
            Point3DBox[{5, 5, 2}]}, 
           {RGBColor[
            0.06482143002021945, 0.320970143045886, 0.5431044694727936], 
            Point3DBox[{5, 5, 3}]}, 
           {RGBColor[
            0.7425115196881911, 0.9462185254809621, 0.6099677335454075], 
            Point3DBox[{5, 5, 4}]}, 
           {RGBColor[
            0.38325365305579884`, 0.5313704761073763, 0.3890367601104283], 
            Point3DBox[{5, 5, 5}]}, 
           {RGBColor[
            0.03752858558964234, 0.6834792935141423, 0.0019007142240967667`], 
            Point3DBox[{5, 5, 6}]}, 
           {RGBColor[
            0.9204238923391879, 0.5771618484439873, 0.8138800996627822], 
            Point3DBox[{5, 5, 7}]}, 
           {RGBColor[
            0.4646097846634085, 0.26534124765356126`, 0.19959236039351969`], 
            Point3DBox[{5, 5, 8}]}, 
           {RGBColor[
            0.05234857859201636, 0.3751420986115124, 0.6315987918727568], 
            Point3DBox[{5, 5, 9}]}, 
           {RGBColor[
            0.746649201415257, 0.4373037809356841, 0.35377884075570143`], 
            Point3DBox[{5, 5, 10}]}}, {
           {RGBColor[
            0.7551456915909553, 0.4527611686715374, 0.7795812360410337], 
            Point3DBox[{5, 6, 1}]}, 
           {RGBColor[
            0.4298384232419259, 0.9843378306130677, 0.5608710030508401], 
            Point3DBox[{5, 6, 2}]}, 
           {RGBColor[
            0.381632999518275, 0.8941649246164558, 0.049886245466883805`], 
            Point3DBox[{5, 6, 3}]}, 
           {RGBColor[
            0.5094605102319967, 0.9159187666891464, 0.08014284765500923], 
            Point3DBox[{5, 6, 4}]}, 
           {RGBColor[
            0.01414787091795433, 0.07278660655512437, 0.42213626195597564`], 
            Point3DBox[{5, 6, 5}]}, 
           {RGBColor[
            0.7489720771974915, 0.5183629109277275, 0.4132834994622685], 
            Point3DBox[{5, 6, 6}]}, 
           {RGBColor[
            0.3297659796371344, 0.37733865203588013`, 0.4607566259810547], 
            Point3DBox[{5, 6, 7}]}, 
           {RGBColor[
            0.7807764321954613, 0.5082773575724733, 0.4540762396401985], 
            Point3DBox[{5, 6, 8}]}, 
           {RGBColor[
            0.8234135367953523, 0.9094379737704643, 0.43623259591176455`], 
            Point3DBox[{5, 6, 9}]}, 
           {RGBColor[
            0.1940701165571599, 0.37947966326450033`, 0.28313003483414634`], 
            Point3DBox[{5, 6, 10}]}}, {
           {RGBColor[
            0.6202971428968984, 0.39958695747810036`, 0.30532906832789064`], 
            Point3DBox[{5, 7, 1}]}, 
           {RGBColor[
            0.31608980927731256`, 0.6430386863325084, 0.4171371931576555], 
            Point3DBox[{5, 7, 2}]}, 
           {RGBColor[
            0.4072738946393015, 0.7354247050958611, 0.358824307228091], 
            Point3DBox[{5, 7, 3}]}, 
           {RGBColor[
            0.026285046923404165`, 0.23045809068884737`, 0.6311439789778843], 
            Point3DBox[{5, 7, 4}]}, 
           {RGBColor[
            0.9281557051753855, 0.7312015418628186, 0.1736606044235005], 
            Point3DBox[{5, 7, 5}]}, 
           {RGBColor[
            0.11505505519966697`, 0.41842911318285103`, 0.5565778655015745], 
            Point3DBox[{5, 7, 6}]}, 
           {RGBColor[
            0.8569176312218942, 0.9526423752062785, 0.21270182952539773`], 
            Point3DBox[{5, 7, 7}]}, 
           {RGBColor[
            0.4533063315652597, 0.8418432017795348, 0.8265403434537724], 
            Point3DBox[{5, 7, 8}]}, 
           {RGBColor[
            0.3303834019710483, 0.06567379222959113, 0.050203365797550914`], 
            Point3DBox[{5, 7, 9}]}, 
           {RGBColor[
            0.27970391571099973`, 0.8588579319304963, 0.9042016908464576], 
            Point3DBox[{5, 7, 10}]}}, {
           {RGBColor[
            0.2040313301018406, 0.4223568458287892, 0.8428998409507036], 
            Point3DBox[{5, 8, 1}]}, 
           {RGBColor[
            0.3712785511123331, 0.6492415888262419, 0.724405609573985], 
            Point3DBox[{5, 8, 2}]}, 
           {RGBColor[
            0.6078090815473798, 0.6006525829177214, 0.06775349077892923], 
            Point3DBox[{5, 8, 3}]}, 
           {RGBColor[
            0.547567056259729, 0.5439335005362531, 0.1774078080276078], 
            Point3DBox[{5, 8, 4}]}, 
           {RGBColor[
            0.7700064166838643, 0.3174196375084666, 0.0872616856624866], 
            Point3DBox[{5, 8, 5}]}, 
           {RGBColor[
            0.5841604288565918, 0.7208271835864584, 0.8808521423232996], 
            Point3DBox[{5, 8, 6}]}, 
           {RGBColor[
            0.6400915535061658, 0.2903597742956274, 0.7075334787188314], 
            Point3DBox[{5, 8, 7}]}, 
           {RGBColor[
            0.03197608225940618, 0.7025093666864004, 0.26675384534588464`], 
            Point3DBox[{5, 8, 8}]}, 
           {RGBColor[
            0.4811289138565358, 0.6343638714090485, 0.41660004867241174`], 
            Point3DBox[{5, 8, 9}]}, 
           {RGBColor[
            0.4520696616024382, 0.46126623697537616`, 0.1001516771700417], 
            Point3DBox[{5, 8, 10}]}}, {
           {RGBColor[
            0.2032320397509606, 0.18666281198997536`, 0.7869594178455819], 
            Point3DBox[{5, 9, 1}]}, 
           {RGBColor[
            0.0010753639897134182`, 0.7337349006453877, 0.4996090755600231], 
            Point3DBox[{5, 9, 2}]}, 
           {RGBColor[
            0.05615498332706559, 0.5301894262835756, 0.5994141448841552], 
            Point3DBox[{5, 9, 3}]}, 
           {RGBColor[
            0.6088142078944614, 0.26597793897272615`, 0.22894869363018455`], 
            Point3DBox[{5, 9, 4}]}, 
           {RGBColor[
            0.4304746060668425, 0.8726747172468838, 0.8146413534934891], 
            Point3DBox[{5, 9, 5}]}, 
           {RGBColor[
            0.07515196272965041, 0.9393424401496822, 0.4509332773341008], 
            Point3DBox[{5, 9, 6}]}, 
           {RGBColor[
            0.1765985248645494, 0.3865367336961181, 0.7089550200342289], 
            Point3DBox[{5, 9, 7}]}, 
           {RGBColor[
            0.8158905848161384, 0.6001443191645006, 0.6255288988900942], 
            Point3DBox[{5, 9, 8}]}, 
           {RGBColor[
            0.3904637288528541, 0.4028469420211218, 0.8328240027354201], 
            Point3DBox[{5, 9, 9}]}, 
           {RGBColor[
            0.8469682611385947, 0.1125898656407891, 0.6180749513454515], 
            Point3DBox[{5, 9, 10}]}}, {
           {RGBColor[
            0.7187505853356855, 0.19109507818117266`, 0.1917665112542688], 
            Point3DBox[{5, 10, 1}]}, 
           {RGBColor[
            0.260279720155423, 0.420749688184634, 0.7772864928721246], 
            Point3DBox[{5, 10, 2}]}, 
           {RGBColor[
            0.3801839436276253, 0.2903040625151776, 0.7700726525584971], 
            Point3DBox[{5, 10, 3}]}, 
           {RGBColor[
            0.1865869188717435, 0.8201814172399136, 0.5999248721762889], 
            Point3DBox[{5, 10, 4}]}, 
           {RGBColor[
            0.45883691668509785`, 0.4507212123527795, 0.7203728101962521], 
            Point3DBox[{5, 10, 5}]}, 
           {RGBColor[
            0.15714687421577223`, 0.2739670392450726, 0.26619764209794083`], 
            Point3DBox[{5, 10, 6}]}, 
           {RGBColor[
            0.9266372111661745, 0.5839634948292167, 0.2991816215181555], 
            Point3DBox[{5, 10, 7}]}, 
           {RGBColor[
            0.04640026091889626, 0.15283097999321482`, 0.3982410369342926], 
            Point3DBox[{5, 10, 8}]}, 
           {RGBColor[
            0.9309397983090977, 0.8190076140641476, 0.6348528137429441], 
            Point3DBox[{5, 10, 9}]}, 
           {RGBColor[
            0.5437755885522069, 0.5880186501523539, 0.5007720662989565], 
            Point3DBox[{5, 10, 10}]}}}, {{
           {RGBColor[
            0.19926895729293825`, 0.6595062540299712, 0.10105982399152236`], 
            Point3DBox[{6, 1, 1}]}, 
           {RGBColor[
            0.18280963925266813`, 0.11307002770867047`, 0.2543938162525552], 
            Point3DBox[{6, 1, 2}]}, 
           {RGBColor[
            0.6652896830073722, 0.052497607723682504`, 0.6981035027485276], 
            Point3DBox[{6, 1, 3}]}, 
           {RGBColor[
            0.20793403385560705`, 0.6022702944511098, 0.9270120533297994], 
            Point3DBox[{6, 1, 4}]}, 
           {RGBColor[
            0.49440522645316687`, 0.8379233670158084, 0.7700263821939652], 
            Point3DBox[{6, 1, 5}]}, 
           {RGBColor[
            0.1311716617634915, 0.8042283194912856, 0.6734634330738603], 
            Point3DBox[{6, 1, 6}]}, 
           {RGBColor[
            0.5859789510535776, 0.3993851962207553, 0.5646248194676213], 
            Point3DBox[{6, 1, 7}]}, 
           {RGBColor[
            0.4201835733093655, 0.5310028021386073, 0.5908604840103282], 
            Point3DBox[{6, 1, 8}]}, 
           {RGBColor[
            0.20907623519982588`, 0.7159844523238217, 0.8665463283522901], 
            Point3DBox[{6, 1, 9}]}, 
           {RGBColor[
            0.29576677121133144`, 0.19090119961602414`, 0.640827201841174], 
            Point3DBox[{6, 1, 10}]}}, {
           {RGBColor[
            0.041414579604792, 0.5265361914811677, 0.11143643343154253`], 
            Point3DBox[{6, 2, 1}]}, 
           {RGBColor[
            0.8500498367857641, 0.32487979326135696`, 0.0641924346425955], 
            Point3DBox[{6, 2, 2}]}, 
           {RGBColor[
            0.4962081110096943, 0.9925759569720916, 0.3888985220287404], 
            Point3DBox[{6, 2, 3}]}, 
           {RGBColor[
            0.4936408543185027, 0.9907602756063945, 0.7355826648594594], 
            Point3DBox[{6, 2, 4}]}, 
           {RGBColor[
            0.38470331960910964`, 0.7886293738813068, 0.0800153408123867], 
            Point3DBox[{6, 2, 5}]}, 
           {RGBColor[
            0.24365102933537974`, 0.1407322592565916, 0.12214093732021714`], 
            Point3DBox[{6, 2, 6}]}, 
           {RGBColor[
            0.2240215086773225, 0.046759159205371104`, 0.10647810662206147`], 
            Point3DBox[{6, 2, 7}]}, 
           {RGBColor[
            0.38186498675362945`, 0.3916326330895634, 0.3169268696379548], 
            Point3DBox[{6, 2, 8}]}, 
           {RGBColor[
            0.2144064550552145, 0.17697889896083097`, 0.35436728796112393`], 
            Point3DBox[{6, 2, 9}]}, 
           {RGBColor[
            0.5462060891939855, 0.2712725088762835, 0.13453717415069644`], 
            Point3DBox[{6, 2, 10}]}}, {
           {RGBColor[
            0.538350399799554, 0.5047365353151385, 0.6326101405504163], 
            Point3DBox[{6, 3, 1}]}, 
           {RGBColor[
            0.0009778120496382048, 0.6514544721084365, 0.6771753419702395], 
            Point3DBox[{6, 3, 2}]}, 
           {RGBColor[
            0.9143818201323624, 0.901730740055463, 0.010999379480741256`], 
            Point3DBox[{6, 3, 3}]}, 
           {RGBColor[
            0.014171556021737475`, 0.8169901984502057, 0.9634240869480513], 
            Point3DBox[{6, 3, 4}]}, 
           {RGBColor[
            0.9671511387143736, 0.7458764375037576, 0.15637702043482737`], 
            Point3DBox[{6, 3, 5}]}, 
           {RGBColor[
            0.8855593428126305, 0.3785525319025256, 0.874792057033333], 
            Point3DBox[{6, 3, 6}]}, 
           {RGBColor[
            0.07323993135859941, 0.13841997424549501`, 0.02749784945428657], 
            Point3DBox[{6, 3, 7}]}, 
           {RGBColor[
            0.7246914321208628, 0.2616620223261421, 0.031061613915251307`], 
            Point3DBox[{6, 3, 8}]}, 
           {RGBColor[
            0.2476825891725405, 0.9980349341922585, 0.5508864808186575], 
            Point3DBox[{6, 3, 9}]}, 
           {RGBColor[
            0.5626916031120817, 0.3686817277327952, 0.27639363883285273`], 
            Point3DBox[{6, 3, 10}]}}, {
           {RGBColor[
            0.38570308875164305`, 0.465353750628795, 0.341890678815433], 
            Point3DBox[{6, 4, 1}]}, 
           {RGBColor[
            0.5993156147243113, 0.022783986422387548`, 0.9716754764752942], 
            Point3DBox[{6, 4, 2}]}, 
           {RGBColor[
            0.9479153584538003, 0.06363957555753297, 0.24580755947712407`], 
            Point3DBox[{6, 4, 3}]}, 
           {RGBColor[
            0.6030904181788022, 0.31416876940609306`, 0.825542564094305], 
            Point3DBox[{6, 4, 4}]}, 
           {RGBColor[
            0.7851701427625475, 0.2922479388524706, 0.4396648875136677], 
            Point3DBox[{6, 4, 5}]}, 
           {RGBColor[
            0.5338867768429989, 0.41676097132810375`, 0.614267489331302], 
            Point3DBox[{6, 4, 6}]}, 
           {RGBColor[
            0.06738243379997555, 0.27658122105045035`, 0.9722218372545886], 
            Point3DBox[{6, 4, 7}]}, 
           {RGBColor[
            0.866690313891676, 0.6890998019169645, 0.45876190701016073`], 
            Point3DBox[{6, 4, 8}]}, 
           {RGBColor[
            0.02404542811312993, 0.7167653604234803, 0.47020985743310284`], 
            Point3DBox[{6, 4, 9}]}, 
           {RGBColor[
            0.7789430878073065, 0.9719713856935246, 0.6260193403383818], 
            Point3DBox[{6, 4, 10}]}}, {
           {RGBColor[
            0.8701957107081588, 0.10961315632808066`, 0.006990907874389274], 
            Point3DBox[{6, 5, 1}]}, 
           {RGBColor[
            0.39297029192828004`, 0.7281222521960595, 0.26238112316685136`], 
            Point3DBox[{6, 5, 2}]}, 
           {RGBColor[
            0.4024198021471155, 0.4219928597336091, 0.6136299681414632], 
            Point3DBox[{6, 5, 3}]}, 
           {RGBColor[
            0.5228965910849812, 0.4764020798033173, 0.6287440415047312], 
            Point3DBox[{6, 5, 4}]}, 
           {RGBColor[
            0.7788037121610678, 0.5758324668344372, 0.08417445777612054], 
            Point3DBox[{6, 5, 5}]}, 
           {RGBColor[
            0.8756536040750489, 0.7656495900736091, 0.38954954342891646`], 
            Point3DBox[{6, 5, 6}]}, 
           {RGBColor[
            0.15479569507010438`, 0.44078615207356364`, 0.6829863659394471], 
            Point3DBox[{6, 5, 7}]}, 
           {RGBColor[
            0.7424407143000542, 0.5179987385830676, 0.0890676777656938], 
            Point3DBox[{6, 5, 8}]}, 
           {RGBColor[
            0.7544365217215971, 0.3112803349370916, 0.0027720330987524022`], 
            Point3DBox[{6, 5, 9}]}, 
           {RGBColor[
            0.25766911879219245`, 0.033830329554313865`, 
             0.20895103670492876`], Point3DBox[{6, 5, 10}]}}, {
           {RGBColor[
            0.3314786731166526, 0.0010568074287669038`, 0.20998166694549192`],
             Point3DBox[{6, 6, 1}]}, 
           {RGBColor[
            0.4565995323762708, 0.3141578382110275, 0.3595767571942856], 
            Point3DBox[{6, 6, 2}]}, 
           {RGBColor[
            0.018404233586126084`, 0.7025845233712704, 0.4570486860155334], 
            Point3DBox[{6, 6, 3}]}, 
           {RGBColor[
            0.5540928180134781, 0.4768619039321573, 0.9030596707432197], 
            Point3DBox[{6, 6, 4}]}, 
           {RGBColor[
            0.5614933655169092, 0.0611925131299067, 0.27413875230617224`], 
            Point3DBox[{6, 6, 5}]}, 
           {RGBColor[
            0.38049235844831797`, 0.615314699588291, 0.9436135459025723], 
            Point3DBox[{6, 6, 6}]}, 
           {RGBColor[
            0.5316164873178584, 0.2682870157639001, 0.06382103043459364], 
            Point3DBox[{6, 6, 7}]}, 
           {RGBColor[
            0.2742713167140567, 0.1418348041741695, 0.17834986256458807`], 
            Point3DBox[{6, 6, 8}]}, 
           {RGBColor[
            0.34975791730136496`, 0.6744228550903582, 0.30193084972056483`], 
            Point3DBox[{6, 6, 9}]}, 
           {RGBColor[
            0.3213161441644914, 0.546817402423224, 0.8049830256007127], 
            Point3DBox[{6, 6, 10}]}}, {
           {RGBColor[
            0.7603455038805591, 0.9361553544725219, 0.12773551094258062`], 
            Point3DBox[{6, 7, 1}]}, 
           {RGBColor[
            0.9701970235823794, 0.113347983393989, 0.9338962570202229], 
            Point3DBox[{6, 7, 2}]}, 
           {RGBColor[
            0.3916778859531129, 0.836023748961499, 0.03200641856687181], 
            Point3DBox[{6, 7, 3}]}, 
           {RGBColor[
            0.37399717523644016`, 0.7767005970264311, 0.7197047300527157], 
            Point3DBox[{6, 7, 4}]}, 
           {RGBColor[
            0.9235157309312476, 0.4404105709034718, 0.22256404783782568`], 
            Point3DBox[{6, 7, 5}]}, 
           {RGBColor[
            0.3026501819839096, 0.2924238067641596, 0.1756433295511577], 
            Point3DBox[{6, 7, 6}]}, 
           {RGBColor[
            0.8155769357133518, 0.7023583144913317, 0.7416866685893098], 
            Point3DBox[{6, 7, 7}]}, 
           {RGBColor[
            0.9854744425402662, 0.31561813583368714`, 0.189581505528855], 
            Point3DBox[{6, 7, 8}]}, 
           {RGBColor[
            0.931063475447899, 0.30128483733837474`, 0.2598806135241962], 
            Point3DBox[{6, 7, 9}]}, 
           {RGBColor[
            0.5250474780403007, 0.28004245426338925`, 0.8204764618407396], 
            Point3DBox[{6, 7, 10}]}}, {
           {RGBColor[
            0.9024202100859695, 0.586137284005972, 0.24670376052692577`], 
            Point3DBox[{6, 8, 1}]}, 
           {RGBColor[
            0.4689755720788107, 0.2541112905414502, 0.21674857100034672`], 
            Point3DBox[{6, 8, 2}]}, 
           {RGBColor[
            0.18273692396058827`, 0.48440466056210374`, 0.8294557164015042], 
            Point3DBox[{6, 8, 3}]}, 
           {RGBColor[
            0.16104422487982828`, 0.43167072712193444`, 0.14363314964053564`],
             Point3DBox[{6, 8, 4}]}, 
           {RGBColor[
            0.6005772869216417, 0.30380296749234614`, 0.38027539162235713`], 
            Point3DBox[{6, 8, 5}]}, 
           {RGBColor[
            0.02429124100433766, 0.2533476055168489, 0.9730387530931499], 
            Point3DBox[{6, 8, 6}]}, 
           {RGBColor[
            0.21209935432253735`, 0.6115754808990066, 0.8442025202167565], 
            Point3DBox[{6, 8, 7}]}, 
           {RGBColor[
            0.23741775082844985`, 0.6801005999197818, 0.3063447700262074], 
            Point3DBox[{6, 8, 8}]}, 
           {RGBColor[
            0.8555358092281289, 0.07773038106620711, 0.6652107861353262], 
            Point3DBox[{6, 8, 9}]}, 
           {RGBColor[
            0.9882389915127228, 0.07323419395036646, 0.13304990157290675`], 
            Point3DBox[{6, 8, 10}]}}, {
           {RGBColor[
            0.6830029993987856, 0.5035149936610661, 0.7507344239860589], 
            Point3DBox[{6, 9, 1}]}, 
           {RGBColor[
            0.6406344130787487, 0.7807559328121327, 0.2349309947322702], 
            Point3DBox[{6, 9, 2}]}, 
           {RGBColor[
            0.10585707890225082`, 0.8999924378882156, 0.05413726550652331], 
            Point3DBox[{6, 9, 3}]}, 
           {RGBColor[
            0.7623004595254497, 0.03691623294257185, 0.09545729388681612], 
            Point3DBox[{6, 9, 4}]}, 
           {RGBColor[
            0.9605067696824263, 0.6474292588437809, 0.6961142402028377], 
            Point3DBox[{6, 9, 5}]}, 
           {RGBColor[
            0.041423572441541046`, 0.6988204065660826, 0.9984318434831172], 
            Point3DBox[{6, 9, 6}]}, 
           {RGBColor[
            0.6699501443919449, 0.08368725142966271, 0.7183403589758162], 
            Point3DBox[{6, 9, 7}]}, 
           {RGBColor[
            0.787559188592718, 0.4482474836178778, 0.5102630758097597], 
            Point3DBox[{6, 9, 8}]}, 
           {RGBColor[
            0.249153830074879, 0.8529495677103918, 0.7972252010316725], 
            Point3DBox[{6, 9, 9}]}, 
           {RGBColor[
            0.9009816402655346, 0.03044780596801222, 0.5553885438301931], 
            Point3DBox[{6, 9, 10}]}}, {
           {RGBColor[
            0.8512371235638521, 0.36797821216138615`, 0.986267304184341], 
            Point3DBox[{6, 10, 1}]}, 
           {RGBColor[
            0.8153504077930573, 0.526368526960534, 0.3680420430488962], 
            Point3DBox[{6, 10, 2}]}, 
           {RGBColor[
            0.008306162381144677, 0.5797548258102898, 0.2851245664608075], 
            Point3DBox[{6, 10, 3}]}, 
           {RGBColor[
            0.6993124559028032, 0.08495318898001747, 0.20313375830589608`], 
            Point3DBox[{6, 10, 4}]}, 
           {RGBColor[
            0.373060324156244, 0.09437117029212105, 0.41231985735051446`], 
            Point3DBox[{6, 10, 5}]}, 
           {RGBColor[
            0.17233902361176434`, 0.5484642017155312, 0.8619206011710099], 
            Point3DBox[{6, 10, 6}]}, 
           {RGBColor[
            0.31074110444318404`, 0.393035823741295, 0.8469018021840999], 
            Point3DBox[{6, 10, 7}]}, 
           {RGBColor[
            0.9288698164414182, 0.0013106529109192522`, 0.8429263059751357], 
            Point3DBox[{6, 10, 8}]}, 
           {RGBColor[
            0.7803099542688883, 0.24546509951599904`, 0.7257002340765848], 
            Point3DBox[{6, 10, 9}]}, 
           {RGBColor[
            0.5384131524607141, 0.29687607091497314`, 0.3810946857212305], 
            Point3DBox[{6, 10, 10}]}}}, {{
           {RGBColor[
            0.07198343748480496, 0.5580513742519051, 0.5919884762068712], 
            Point3DBox[{7, 1, 1}]}, 
           {RGBColor[
            0.967228545115526, 0.8337013284984731, 0.7048860281687142], 
            Point3DBox[{7, 1, 2}]}, 
           {RGBColor[
            0.1055902747477786, 0.5614496702028433, 0.4855774068861458], 
            Point3DBox[{7, 1, 3}]}, 
           {RGBColor[
            0.631532932493728, 0.8047354101240816, 0.9965319828281956], 
            Point3DBox[{7, 1, 4}]}, 
           {RGBColor[
            0.5656200474489077, 0.7854189255458515, 0.08944059641206592], 
            Point3DBox[{7, 1, 5}]}, 
           {RGBColor[
            0.04008414493399881, 0.266262998787675, 0.9936143974880773], 
            Point3DBox[{7, 1, 6}]}, 
           {RGBColor[
            0.3318003983113693, 0.5558932854987917, 0.08795653961315986], 
            Point3DBox[{7, 1, 7}]}, 
           {RGBColor[
            0.6911491972363568, 0.8001135377608077, 0.13237780225716644`], 
            Point3DBox[{7, 1, 8}]}, 
           {RGBColor[
            0.5101733464213678, 0.9626316267397916, 0.6802656194541794], 
            Point3DBox[{7, 1, 9}]}, 
           {RGBColor[
            0.018917712423102584`, 0.38113677191543016`, 0.6185086235735584], 
            Point3DBox[{7, 1, 10}]}}, {
           {RGBColor[
            0.4893964934872743, 0.32881452779785403`, 0.8618242623870787], 
            Point3DBox[{7, 2, 1}]}, 
           {RGBColor[
            0.6607776884796761, 0.17072638872325796`, 0.9474178558861133], 
            Point3DBox[{7, 2, 2}]}, 
           {RGBColor[
            0.4841335183297997, 0.15866927920222662`, 0.6193339032179286], 
            Point3DBox[{7, 2, 3}]}, 
           {RGBColor[
            0.012682082925656868`, 0.7462495911336162, 0.9829348918609442], 
            Point3DBox[{7, 2, 4}]}, 
           {RGBColor[
            0.20281900966281619`, 0.30108589353131787`, 0.8822639336819653], 
            Point3DBox[{7, 2, 5}]}, 
           {RGBColor[
            0.5506189324765733, 0.9598148429002313, 0.008716689254592014], 
            Point3DBox[{7, 2, 6}]}, 
           {RGBColor[
            0.7829249640492915, 0.8720143733241137, 0.69572998623797], 
            Point3DBox[{7, 2, 7}]}, 
           {RGBColor[
            0.11382697044787182`, 0.6479442329169984, 0.34491536417934876`], 
            Point3DBox[{7, 2, 8}]}, 
           {RGBColor[
            0.36057145762027654`, 0.291428766006842, 0.10385891797061775`], 
            Point3DBox[{7, 2, 9}]}, 
           {RGBColor[
            0.86575692525105, 0.4229796198425133, 0.7455726467813684], 
            Point3DBox[{7, 2, 10}]}}, {
           {RGBColor[
            0.8422681399104375, 0.23736740526201894`, 0.8978116032216856], 
            Point3DBox[{7, 3, 1}]}, 
           {RGBColor[
            0.49927964218405885`, 0.3592428753543575, 0.29653667929824223`], 
            Point3DBox[{7, 3, 2}]}, 
           {RGBColor[
            0.4600294960097362, 0.12008575721056558`, 0.27771218475622406`], 
            Point3DBox[{7, 3, 3}]}, 
           {RGBColor[
            0.9213503437032824, 0.37074977532746156`, 0.06225256090170839], 
            Point3DBox[{7, 3, 4}]}, 
           {RGBColor[
            0.839774497305831, 0.2086389221587961, 0.38176683208167606`], 
            Point3DBox[{7, 3, 5}]}, 
           {RGBColor[
            0.21734610796401954`, 0.20509034513613655`, 0.7398390984599286], 
            Point3DBox[{7, 3, 6}]}, 
           {RGBColor[
            0.6296247519534468, 0.8506408245669401, 0.426757770305499], 
            Point3DBox[{7, 3, 7}]}, 
           {RGBColor[
            0.25556592666586786`, 0.6767740061620755, 0.1692114197487138], 
            Point3DBox[{7, 3, 8}]}, 
           {RGBColor[
            0.32517238712016705`, 0.12107218407084686`, 0.7571877759898069], 
            Point3DBox[{7, 3, 9}]}, 
           {RGBColor[
            0.3350295417810687, 0.6004668286362367, 0.145309582302648], 
            Point3DBox[{7, 3, 10}]}}, {
           {RGBColor[
            0.5086705829783984, 0.3188905555432078, 0.39456813553548664`], 
            Point3DBox[{7, 4, 1}]}, 
           {RGBColor[
            0.1821165185654181, 0.10812712831535887`, 0.007487540910484425], 
            Point3DBox[{7, 4, 2}]}, 
           {RGBColor[
            0.4502441462524631, 0.7062224588575008, 0.5356024127935854], 
            Point3DBox[{7, 4, 3}]}, 
           {RGBColor[
            0.9055934935017733, 0.27495694494323697`, 0.16509896355431297`], 
            Point3DBox[{7, 4, 4}]}, 
           {RGBColor[
            0.9226894440530973, 0.26173577132055814`, 0.7194059327642746], 
            Point3DBox[{7, 4, 5}]}, 
           {RGBColor[
            0.03278385259725791, 0.8951373729503651, 0.6947823644855047], 
            Point3DBox[{7, 4, 6}]}, 
           {RGBColor[
            0.9383174700727357, 0.6119069532573973, 0.8990196552790279], 
            Point3DBox[{7, 4, 7}]}, 
           {RGBColor[
            0.9974477426655359, 0.8933202938377649, 0.13182700295231475`], 
            Point3DBox[{7, 4, 8}]}, 
           {RGBColor[
            0.2137763460952693, 0.014983491572306162`, 0.22588896067015196`], 
            Point3DBox[{7, 4, 9}]}, 
           {RGBColor[
            0.2409695038413311, 0.7689405620773706, 0.5793232231896874], 
            Point3DBox[{7, 4, 10}]}}, {
           {RGBColor[
            0.011484119915978974`, 0.10681133975084434`, 0.6674282723953013], 
            Point3DBox[{7, 5, 1}]}, 
           {RGBColor[
            0.5040050207558624, 0.03050555030349189, 0.5567143270021526], 
            Point3DBox[{7, 5, 2}]}, 
           {RGBColor[
            0.41188254957355097`, 0.633961493533084, 0.04277048529025129], 
            Point3DBox[{7, 5, 3}]}, 
           {RGBColor[
            0.9031706476789692, 0.8648497584156165, 0.9394990313390392], 
            Point3DBox[{7, 5, 4}]}, 
           {RGBColor[
            0.9809068274863066, 0.3774369298366296, 0.6976515793449971], 
            Point3DBox[{7, 5, 5}]}, 
           {RGBColor[
            0.031623435946160905`, 0.40233682831029816`, 0.5678129145670665], 
            Point3DBox[{7, 5, 6}]}, 
           {RGBColor[
            0.3904540363373077, 0.3394996548368723, 0.41785011943802], 
            Point3DBox[{7, 5, 7}]}, 
           {RGBColor[
            0.10202865185456966`, 0.7941595025328587, 0.6197351231738557], 
            Point3DBox[{7, 5, 8}]}, 
           {RGBColor[
            0.6980682554078554, 0.5151267625617142, 0.32108276636378363`], 
            Point3DBox[{7, 5, 9}]}, 
           {RGBColor[
            0.13250597644595685`, 0.691319772403246, 0.23176639194779347`], 
            Point3DBox[{7, 5, 10}]}}, {
           {RGBColor[
            0.03570809885482262, 0.3753927077266259, 0.7497307363594274], 
            Point3DBox[{7, 6, 1}]}, 
           {RGBColor[
            0.17918445643246317`, 0.9682428800230651, 0.9819724155582963], 
            Point3DBox[{7, 6, 2}]}, 
           {RGBColor[
            0.232999808438775, 0.002623845806398739, 0.5535735455534425], 
            Point3DBox[{7, 6, 3}]}, 
           {RGBColor[
            0.46061614853193245`, 0.5028857224828582, 0.6319559308374509], 
            Point3DBox[{7, 6, 4}]}, 
           {RGBColor[
            0.6605891712098095, 0.3137709936881603, 0.9386837816972624], 
            Point3DBox[{7, 6, 5}]}, 
           {RGBColor[
            0.37810061214073154`, 0.23705691144506846`, 0.45323850768456597`],
             Point3DBox[{7, 6, 6}]}, 
           {RGBColor[
            0.34068660168381215`, 0.7805971361688429, 0.8315809917541617], 
            Point3DBox[{7, 6, 7}]}, 
           {RGBColor[
            0.1381699646864698, 0.1568243377874612, 0.350292179681436], 
            Point3DBox[{7, 6, 8}]}, 
           {RGBColor[
            0.8184580228076477, 0.34236619438843796`, 0.8631500283890028], 
            Point3DBox[{7, 6, 9}]}, 
           {RGBColor[
            0.567225828922566, 0.13376404323249358`, 0.9815878465612216], 
            Point3DBox[{7, 6, 10}]}}, {
           {RGBColor[
            0.8500153280394223, 0.288981848175599, 0.07441831025470114], 
            Point3DBox[{7, 7, 1}]}, 
           {RGBColor[
            0.8057967218015485, 0.01667706123241075, 0.7474489838412621], 
            Point3DBox[{7, 7, 2}]}, 
           {RGBColor[
            0.7439659963169902, 0.5796133893837807, 0.2566987597577268], 
            Point3DBox[{7, 7, 3}]}, 
           {RGBColor[
            0.7145303624873376, 0.9631464145916142, 0.9469980304039465], 
            Point3DBox[{7, 7, 4}]}, 
           {RGBColor[
            0.15606959192929182`, 0.9994043448356176, 0.9098336244943868], 
            Point3DBox[{7, 7, 5}]}, 
           {RGBColor[
            0.3272978388625276, 0.5501460327051277, 0.30718344204223924`], 
            Point3DBox[{7, 7, 6}]}, 
           {RGBColor[
            0.1039589047838374, 0.028404537023182685`, 0.11064496526682421`], 
            Point3DBox[{7, 7, 7}]}, 
           {RGBColor[
            0.7954556061164832, 0.6465897026227934, 0.9029363443665053], 
            Point3DBox[{7, 7, 8}]}, 
           {RGBColor[
            0.2857709639660213, 0.09045491013960927, 0.33856263825052735`], 
            Point3DBox[{7, 7, 9}]}, 
           {RGBColor[
            0.10711466531095337`, 0.38118158045410744`, 0.28534199325491816`],
             Point3DBox[{7, 7, 10}]}}, {
           {RGBColor[
            0.3353580977807826, 0.6636890270502671, 0.9998960743635152], 
            Point3DBox[{7, 8, 1}]}, 
           {RGBColor[
            0.476637104550635, 0.9566198100591448, 0.48730542443997193`], 
            Point3DBox[{7, 8, 2}]}, 
           {RGBColor[
            0.5918024920722518, 0.48092051499509214`, 0.2539121185402977], 
            Point3DBox[{7, 8, 3}]}, 
           {RGBColor[
            0.8543701138193833, 0.8184986373124539, 0.9172993080604326], 
            Point3DBox[{7, 8, 4}]}, 
           {RGBColor[
            0.6936529119128059, 0.4369649551496313, 0.815603374142519], 
            Point3DBox[{7, 8, 5}]}, 
           {RGBColor[
            0.6395785390434356, 0.738373307897205, 0.5190976686332684], 
            Point3DBox[{7, 8, 6}]}, 
           {RGBColor[
            0.4908735895309013, 0.7175819639064163, 0.1252277479024717], 
            Point3DBox[{7, 8, 7}]}, 
           {RGBColor[
            0.8092894764997738, 0.22049714480799443`, 0.10737651973790818`], 
            Point3DBox[{7, 8, 8}]}, 
           {RGBColor[
            0.6789174530519961, 0.06560368812235517, 0.8559504141857042], 
            Point3DBox[{7, 8, 9}]}, 
           {RGBColor[
            0.7339220976006158, 0.4222166247752077, 0.15111334626358497`], 
            Point3DBox[{7, 8, 10}]}}, {
           {RGBColor[
            0.996882250619098, 0.414123045822371, 0.20167959203663388`], 
            Point3DBox[{7, 9, 1}]}, 
           {RGBColor[
            0.6334853405876957, 0.6561723128030956, 0.5417395590002625], 
            Point3DBox[{7, 9, 2}]}, 
           {RGBColor[
            0.32550392219052826`, 0.6409005079574659, 0.10813583554046091`], 
            Point3DBox[{7, 9, 3}]}, 
           {RGBColor[
            0.31844720101686574`, 0.47560303495117107`, 0.5465296654972474], 
            Point3DBox[{7, 9, 4}]}, 
           {RGBColor[
            0.16029016463340517`, 0.1103761401024086, 0.35228323305116205`], 
            Point3DBox[{7, 9, 5}]}, 
           {RGBColor[
            0.2785133315968953, 0.22648530575168668`, 0.6349722208073416], 
            Point3DBox[{7, 9, 6}]}, 
           {RGBColor[
            0.916387307381302, 0.04023495561302659, 0.43302343696316825`], 
            Point3DBox[{7, 9, 7}]}, 
           {RGBColor[
            0.20675243768428797`, 0.7946328178862956, 0.0674069546702758], 
            Point3DBox[{7, 9, 8}]}, 
           {RGBColor[
            0.3575044108473373, 0.899966834320914, 0.5596262469726261], 
            Point3DBox[{7, 9, 9}]}, 
           {RGBColor[
            0.9048378449133179, 0.8710274224137398, 0.8041284246082585], 
            Point3DBox[{7, 9, 10}]}}, {
           {RGBColor[
            0.05280747569441635, 0.871890855881478, 0.6899430553368908], 
            Point3DBox[{7, 10, 1}]}, 
           {RGBColor[
            0.809743245279992, 0.6544281775485916, 0.46859447917119623`], 
            Point3DBox[{7, 10, 2}]}, 
           {RGBColor[
            0.5841531300708465, 0.804125634256295, 0.8889471934234328], 
            Point3DBox[{7, 10, 3}]}, 
           {RGBColor[
            0.9763654197326253, 0.9597286104410703, 0.8056804027953162], 
            Point3DBox[{7, 10, 4}]}, 
           {RGBColor[
            0.9187071399490048, 0.9408186708665405, 0.35664615890344464`], 
            Point3DBox[{7, 10, 5}]}, 
           {RGBColor[
            0.9138320777513325, 0.08522663834957012, 0.8566348611295105], 
            Point3DBox[{7, 10, 6}]}, 
           {RGBColor[
            0.365511119409176, 0.3731828408596778, 0.4249911485963749], 
            Point3DBox[{7, 10, 7}]}, 
           {RGBColor[
            0.5344736366904783, 0.7379724092610822, 0.8731460559570097], 
            Point3DBox[{7, 10, 8}]}, 
           {RGBColor[
            0.7647242597812225, 0.5515232552179656, 0.08915443320174288], 
            Point3DBox[{7, 10, 9}]}, 
           {RGBColor[
            0.6079321787330358, 0.24195341759176725`, 0.9694934697226805], 
            Point3DBox[{7, 10, 10}]}}}, {{
           {RGBColor[
            0.3218137799657077, 0.640664853790518, 0.687717235348037], 
            Point3DBox[{8, 1, 1}]}, 
           {RGBColor[
            0.2611341736160968, 0.47035022888310696`, 0.5045336613010607], 
            Point3DBox[{8, 1, 2}]}, 
           {RGBColor[
            0.5331083585448086, 0.5501547903721411, 0.09625873713010513], 
            Point3DBox[{8, 1, 3}]}, 
           {RGBColor[
            0.516775743909857, 0.34873168994954473`, 0.9982572247560153], 
            Point3DBox[{8, 1, 4}]}, 
           {RGBColor[
            0.06933552586726033, 0.406061517766106, 0.5757779823372331], 
            Point3DBox[{8, 1, 5}]}, 
           {RGBColor[
            0.6152622683511335, 0.2989881044699585, 0.9035952282609363], 
            Point3DBox[{8, 1, 6}]}, 
           {RGBColor[0.752164404828789, 0.771525923976689, 0.742682773456155],
             Point3DBox[{8, 1, 7}]}, 
           {RGBColor[
            0.578382463043535, 0.25553648756882463`, 0.3765546189010296], 
            Point3DBox[{8, 1, 8}]}, 
           {RGBColor[
            0.6906403126783496, 0.5342328747016036, 0.7037747348691141], 
            Point3DBox[{8, 1, 9}]}, 
           {RGBColor[
            0.9184077970414963, 0.07851581290085496, 0.35811989152120427`], 
            Point3DBox[{8, 1, 10}]}}, {
           {RGBColor[
            0.2686753670836337, 0.6613460800415216, 0.5920094206590174], 
            Point3DBox[{8, 2, 1}]}, 
           {RGBColor[
            0.0410599374397167, 0.23983175194710893`, 0.41997120396391985`], 
            Point3DBox[{8, 2, 2}]}, 
           {RGBColor[
            0.29309443801646085`, 0.7908447933468159, 0.18723043212091617`], 
            Point3DBox[{8, 2, 3}]}, 
           {RGBColor[
            0.1476806979593328, 0.6718587169488135, 0.9688996440608526], 
            Point3DBox[{8, 2, 4}]}, 
           {RGBColor[
            0.8430848506261082, 0.1851118703681307, 0.31265046813149766`], 
            Point3DBox[{8, 2, 5}]}, 
           {RGBColor[
            0.8645395784144283, 0.3656425177716667, 0.45372237314046737`], 
            Point3DBox[{8, 2, 6}]}, 
           {RGBColor[
            0.028751109347328496`, 0.031425789066079846`, 0.6097567426996631],
             Point3DBox[{8, 2, 7}]}, 
           {RGBColor[
            0.9345625389865404, 0.24490731221629058`, 0.9536055274606638], 
            Point3DBox[{8, 2, 8}]}, 
           {RGBColor[
            0.5334750415840182, 0.509458176302241, 0.6864558242894148], 
            Point3DBox[{8, 2, 9}]}, 
           {RGBColor[
            0.5823076158912064, 0.6432443180978711, 0.3455828272995485], 
            Point3DBox[{8, 2, 10}]}}, {
           {RGBColor[
            0.3846312923778532, 0.11554904090570162`, 0.37946830488599503`], 
            Point3DBox[{8, 3, 1}]}, 
           {RGBColor[
            0.43868484586275813`, 0.9543786763978115, 0.6564004673470929], 
            Point3DBox[{8, 3, 2}]}, 
           {RGBColor[
            0.7475131264453816, 0.3764006338890953, 0.7323115802046187], 
            Point3DBox[{8, 3, 3}]}, 
           {RGBColor[
            0.3115455401845648, 0.3991924614347462, 0.2916608146222841], 
            Point3DBox[{8, 3, 4}]}, 
           {RGBColor[
            0.9305379594413798, 0.5181046807917962, 0.42811630482298746`], 
            Point3DBox[{8, 3, 5}]}, 
           {RGBColor[
            0.03302352454774282, 0.2347719197014031, 0.5396670904834453], 
            Point3DBox[{8, 3, 6}]}, 
           {RGBColor[
            0.9095334172824645, 0.2921906306095039, 0.7612201771573255], 
            Point3DBox[{8, 3, 7}]}, 
           {RGBColor[
            0.5157840357740697, 0.03934702171928639, 0.09610240620975974], 
            Point3DBox[{8, 3, 8}]}, 
           {RGBColor[
            0.753560396105807, 0.8262625768165719, 0.8362228973782542], 
            Point3DBox[{8, 3, 9}]}, 
           {RGBColor[
            0.11234907055360477`, 0.6549431834317647, 0.6228601829356515], 
            Point3DBox[{8, 3, 10}]}}, {
           {RGBColor[
            0.20151754736221106`, 0.0806336197881452, 0.5009237159412554], 
            Point3DBox[{8, 4, 1}]}, 
           {RGBColor[
            0.09264693124030488, 0.9416290861237233, 0.8644249760459668], 
            Point3DBox[{8, 4, 2}]}, 
           {RGBColor[
            0.03347941703338564, 0.9143789154267308, 0.7022285865767122], 
            Point3DBox[{8, 4, 3}]}, 
           {RGBColor[
            0.007176350887668104, 0.1578230273842922, 0.3391942673754016], 
            Point3DBox[{8, 4, 4}]}, 
           {RGBColor[
            0.1511616029162839, 0.5534945590172291, 0.37453864263890346`], 
            Point3DBox[{8, 4, 5}]}, 
           {RGBColor[
            0.5001277808331788, 0.7178453187583234, 0.40591515607551165`], 
            Point3DBox[{8, 4, 6}]}, 
           {RGBColor[
            0.5577708026055004, 0.14207698801205404`, 0.6925418346779111], 
            Point3DBox[{8, 4, 7}]}, 
           {RGBColor[
            0.5428224659228023, 0.7140637525799827, 0.35537314651383367`], 
            Point3DBox[{8, 4, 8}]}, 
           {RGBColor[
            0.7083308458315214, 0.6099583371151489, 0.11149082015673883`], 
            Point3DBox[{8, 4, 9}]}, 
           {RGBColor[
            0.7701704703472785, 0.7750547913989982, 0.7771912904350802], 
            Point3DBox[{8, 4, 10}]}}, {
           {RGBColor[
            0.9351168491355404, 0.3770719313332058, 0.39856825971062815`], 
            Point3DBox[{8, 5, 1}]}, 
           {RGBColor[
            0.489889219589019, 0.6841301903994206, 0.965143013082213], 
            Point3DBox[{8, 5, 2}]}, 
           {RGBColor[
            0.9451508758686711, 0.541170491515844, 0.6676870699594135], 
            Point3DBox[{8, 5, 3}]}, 
           {RGBColor[
            0.2550376651142052, 0.14722078511734926`, 0.12039532262010888`], 
            Point3DBox[{8, 5, 4}]}, 
           {RGBColor[
            0.5159243904088857, 0.12925729568517053`, 0.24767108024440776`], 
            Point3DBox[{8, 5, 5}]}, 
           {RGBColor[
            0.9093314984171492, 0.41393338543315017`, 0.9051096036941335], 
            Point3DBox[{8, 5, 6}]}, 
           {RGBColor[
            0.17722019683495072`, 0.7179317541305472, 0.23687512238566755`], 
            Point3DBox[{8, 5, 7}]}, 
           {RGBColor[
            0.8677531956930782, 0.19530293763098583`, 0.3373326509646122], 
            Point3DBox[{8, 5, 8}]}, 
           {RGBColor[
            0.6373407463712808, 0.8422516546194474, 0.8015468551345251], 
            Point3DBox[{8, 5, 9}]}, 
           {RGBColor[
            0.41643076156559733`, 0.05077874088190448, 0.6081916525400628], 
            Point3DBox[{8, 5, 10}]}}, {
           {RGBColor[
            0.32682052813708884`, 0.1538689571584002, 0.760482444512186], 
            Point3DBox[{8, 6, 1}]}, 
           {RGBColor[
            0.5208190063913962, 0.09241335473649381, 0.200394982798497], 
            Point3DBox[{8, 6, 2}]}, 
           {RGBColor[
            0.43207988778895445`, 0.3026994149308726, 0.4077657356654736], 
            Point3DBox[{8, 6, 3}]}, 
           {RGBColor[
            0.3787855635037909, 0.476822913361171, 0.3991494020012041], 
            Point3DBox[{8, 6, 4}]}, 
           {RGBColor[
            0.9231381800427931, 0.8790155628065743, 0.49985157703954997`], 
            Point3DBox[{8, 6, 5}]}, 
           {RGBColor[
            0.162457648193854, 0.5209368038881415, 0.2951967286881687], 
            Point3DBox[{8, 6, 6}]}, 
           {RGBColor[
            0.21932742103954905`, 0.9747025299134979, 0.11898730231526145`], 
            Point3DBox[{8, 6, 7}]}, 
           {RGBColor[
            0.8806579018526677, 0.7920868805341006, 0.6168107068225983], 
            Point3DBox[{8, 6, 8}]}, 
           {RGBColor[
            0.21293451740238245`, 0.22862001196390502`, 0.9099728393049973], 
            Point3DBox[{8, 6, 9}]}, 
           {RGBColor[
            0.4630302983747794, 0.005221408230903002, 0.049167096269409516`], 
            Point3DBox[{8, 6, 10}]}}, {
           {RGBColor[
            0.2992804245174885, 0.0001094773161089968, 0.43925006344703643`], 
            Point3DBox[{8, 7, 1}]}, 
           {RGBColor[
            0.1869001357240303, 0.876823212365365, 0.4614919831764608], 
            Point3DBox[{8, 7, 2}]}, 
           {RGBColor[
            0.589782234493067, 0.09487940747654844, 0.9087237691113872], 
            Point3DBox[{8, 7, 3}]}, 
           {RGBColor[
            0.561511306616727, 0.5700819664635342, 0.8571597001492548], 
            Point3DBox[{8, 7, 4}]}, 
           {RGBColor[
            0.018549373601765007`, 0.8285527730144311, 0.520728735467161], 
            Point3DBox[{8, 7, 5}]}, 
           {RGBColor[
            0.4924283848937887, 0.3589007154431727, 0.7551191288878096], 
            Point3DBox[{8, 7, 6}]}, 
           {RGBColor[
            0.9761246310506764, 0.23815076159220405`, 0.04237832012469189], 
            Point3DBox[{8, 7, 7}]}, 
           {RGBColor[
            0.3901827257468966, 0.8103315823746555, 0.197421005618174], 
            Point3DBox[{8, 7, 8}]}, 
           {RGBColor[
            0.612894046868103, 0.11137930141457075`, 0.20383113070062508`], 
            Point3DBox[{8, 7, 9}]}, 
           {RGBColor[
            0.6941095729988351, 0.5956736346146194, 0.443872915520908], 
            Point3DBox[{8, 7, 10}]}}, {
           {RGBColor[
            0.7860816738582022, 0.0005686033681013836, 0.7392443366574202], 
            Point3DBox[{8, 8, 1}]}, 
           {RGBColor[0.328483152997044, 0.873373146317332, 0.51110607175799], 
            Point3DBox[{8, 8, 2}]}, 
           {RGBColor[
            0.5857629508310613, 0.40243274337416524`, 0.35550693737761074`], 
            Point3DBox[{8, 8, 3}]}, 
           {RGBColor[
            0.8086882150017518, 0.07089421790459438, 0.622072818444428], 
            Point3DBox[{8, 8, 4}]}, 
           {RGBColor[
            0.002146538776574669, 0.22545309521199375`, 0.9729567625610207], 
            Point3DBox[{8, 8, 5}]}, 
           {RGBColor[
            0.12054009389659526`, 0.05954931709111766, 0.7993014734704795], 
            Point3DBox[{8, 8, 6}]}, 
           {RGBColor[
            0.9480544536902071, 0.4696339984161455, 0.44609525043390397`], 
            Point3DBox[{8, 8, 7}]}, 
           {RGBColor[
            0.43528083198415124`, 0.7543402275613931, 0.8533371789127342], 
            Point3DBox[{8, 8, 8}]}, 
           {RGBColor[
            0.7182925183696167, 0.43142922910722836`, 0.8163157165918726], 
            Point3DBox[{8, 8, 9}]}, 
           {RGBColor[
            0.9520768844448042, 0.1673199895695423, 0.15012070870913097`], 
            Point3DBox[{8, 8, 10}]}}, {
           {RGBColor[
            0.40164069158750837`, 0.45545365435129326`, 0.8952886424997692], 
            Point3DBox[{8, 9, 1}]}, 
           {RGBColor[
            0.2626007018854206, 0.21509879835273749`, 0.3312771864787054], 
            Point3DBox[{8, 9, 2}]}, 
           {RGBColor[
            0.14277567910269262`, 0.5409146509886937, 0.7276183452030938], 
            Point3DBox[{8, 9, 3}]}, 
           {RGBColor[
            0.33539329057415634`, 0.03967071090697605, 0.5421801278834055], 
            Point3DBox[{8, 9, 4}]}, 
           {RGBColor[
            0.053618435747066595`, 0.3516426473848939, 0.7603416534648513], 
            Point3DBox[{8, 9, 5}]}, 
           {RGBColor[
            0.269635799818154, 0.0012981176934008243`, 0.5112888105062223], 
            Point3DBox[{8, 9, 6}]}, 
           {RGBColor[
            0.44909986940499746`, 0.9283080777536257, 0.012866626799643788`], 
            Point3DBox[{8, 9, 7}]}, 
           {RGBColor[
            0.7358510433904077, 0.7436638642562363, 0.85964398071979], 
            Point3DBox[{8, 9, 8}]}, 
           {RGBColor[
            0.8500616300061734, 0.3267615673317845, 0.34333873583692665`], 
            Point3DBox[{8, 9, 9}]}, 
           {RGBColor[
            0.14878356430973083`, 0.6301947452086316, 0.6424581959384745], 
            Point3DBox[{8, 9, 10}]}}, {
           {RGBColor[
            0.7184170274261341, 0.5280830502421028, 0.45955638876051164`], 
            Point3DBox[{8, 10, 1}]}, 
           {RGBColor[
            0.5205362136038469, 0.2794421936182052, 0.18675454917730483`], 
            Point3DBox[{8, 10, 2}]}, 
           {RGBColor[
            0.9711296744594093, 0.042039648199164725`, 0.9884462142825745], 
            Point3DBox[{8, 10, 3}]}, 
           {RGBColor[
            0.9403505601063527, 0.34212900637216404`, 0.8542944082339894], 
            Point3DBox[{8, 10, 4}]}, 
           {RGBColor[
            0.013476789314807336`, 0.09033452677639797, 0.94245680272282], 
            Point3DBox[{8, 10, 5}]}, 
           {RGBColor[
            0.8096440604611708, 0.21977944611984257`, 0.2215808646570292], 
            Point3DBox[{8, 10, 6}]}, 
           {RGBColor[
            0.3060483835868162, 0.09996420885547064, 0.8344806577116519], 
            Point3DBox[{8, 10, 7}]}, 
           {RGBColor[
            0.3860059054227398, 0.4423409253582675, 0.2212605530849472], 
            Point3DBox[{8, 10, 8}]}, 
           {RGBColor[
            0.7716074580426968, 0.2636230943087805, 0.9033739001062528], 
            Point3DBox[{8, 10, 9}]}, 
           {RGBColor[
            0.22409154532587272`, 0.6264344633390251, 0.5263940313253144], 
            Point3DBox[{8, 10, 10}]}}}, {{
           {RGBColor[
            0.08151120038983972, 0.9149631010650257, 0.898743863229964], 
            Point3DBox[{9, 1, 1}]}, 
           {RGBColor[
            0.7197165509645935, 0.12151687027917468`, 0.15079687312699264`], 
            Point3DBox[{9, 1, 2}]}, 
           {RGBColor[
            0.36953674813928816`, 0.880379772847919, 0.9013870789527363], 
            Point3DBox[{9, 1, 3}]}, 
           {RGBColor[
            0.6573215686631846, 0.5193950059513524, 0.0087148246087847], 
            Point3DBox[{9, 1, 4}]}, 
           {RGBColor[
            0.3498483301297761, 0.8130398797880054, 0.6802568962035922], 
            Point3DBox[{9, 1, 5}]}, 
           {RGBColor[
            0.6222623159216982, 0.001304497441892316, 0.6424214109441218], 
            Point3DBox[{9, 1, 6}]}, 
           {RGBColor[
            0.49420170863182555`, 0.23883811806873778`, 0.8469883153226638], 
            Point3DBox[{9, 1, 7}]}, 
           {RGBColor[
            0.07029784029224873, 0.8137613746666912, 0.10563395710404566`], 
            Point3DBox[{9, 1, 8}]}, 
           {RGBColor[
            0.18868897166244158`, 0.571766106378949, 0.8895507593583243], 
            Point3DBox[{9, 1, 9}]}, 
           {RGBColor[
            0.15761485077878, 0.17958202823219738`, 0.7389421901238813], 
            Point3DBox[{9, 1, 10}]}}, {
           {RGBColor[
            0.910048751525478, 0.16090742887641074`, 0.4715958187506548], 
            Point3DBox[{9, 2, 1}]}, 
           {RGBColor[
            0.11856011225289276`, 0.5002918806117842, 0.7204934813058661], 
            Point3DBox[{9, 2, 2}]}, 
           {RGBColor[
            0.343463436885207, 0.6659472233083956, 0.5284979530438418], 
            Point3DBox[{9, 2, 3}]}, 
           {RGBColor[
            0.4572990271777555, 0.37026106195964603`, 0.8293710998868122], 
            Point3DBox[{9, 2, 4}]}, 
           {RGBColor[
            0.4670268894432701, 0.5757460240166425, 0.745015012565142], 
            Point3DBox[{9, 2, 5}]}, 
           {RGBColor[
            0.7005521672592379, 0.2849550417217521, 0.7840928509440925], 
            Point3DBox[{9, 2, 6}]}, 
           {RGBColor[
            0.7636444285801673, 0.8661050750825166, 0.4919948992998182], 
            Point3DBox[{9, 2, 7}]}, 
           {RGBColor[
            0.2771971870593495, 0.3435623221841755, 0.7273007502495357], 
            Point3DBox[{9, 2, 8}]}, 
           {RGBColor[
            0.5324734146031262, 0.8259530846005687, 0.9616533167862804], 
            Point3DBox[{9, 2, 9}]}, 
           {RGBColor[
            0.3178826325103903, 0.3925694103377044, 0.6248487793261677], 
            Point3DBox[{9, 2, 10}]}}, {
           {RGBColor[
            0.03589620325755205, 0.32912104741484827`, 0.07030421676327214], 
            Point3DBox[{9, 3, 1}]}, 
           {RGBColor[
            0.20498428062419016`, 0.04929908316100162, 0.926820269336629], 
            Point3DBox[{9, 3, 2}]}, 
           {RGBColor[
            0.4326380151942695, 0.7072037266072624, 0.94749577384893], 
            Point3DBox[{9, 3, 3}]}, 
           {RGBColor[
            0.37048630764371393`, 0.11444236954310427`, 0.2085647882561903], 
            Point3DBox[{9, 3, 4}]}, 
           {RGBColor[
            0.5125058223514503, 0.5872479769594965, 0.8323445235342894], 
            Point3DBox[{9, 3, 5}]}, 
           {RGBColor[
            0.7437708914850565, 0.8053273288006468, 0.12541500354558432`], 
            Point3DBox[{9, 3, 6}]}, 
           {RGBColor[
            0.5535953943277998, 0.735852243629024, 0.7871769252223795], 
            Point3DBox[{9, 3, 7}]}, 
           {RGBColor[
            0.78399681228287, 0.5631822052642792, 0.7343230666492222], 
            Point3DBox[{9, 3, 8}]}, 
           {RGBColor[
            0.5862257176375396, 0.46774530125932, 0.2229630268563012], 
            Point3DBox[{9, 3, 9}]}, 
           {RGBColor[
            0.6400487509698012, 0.5871459096697866, 0.1821139229766895], 
            Point3DBox[{9, 3, 10}]}}, {
           {RGBColor[
            0.8853510573551409, 0.8519764032547104, 0.9609322559431814], 
            Point3DBox[{9, 4, 1}]}, 
           {RGBColor[
            0.47214182456045806`, 0.5125185799625354, 0.8671965302423335], 
            Point3DBox[{9, 4, 2}]}, 
           {RGBColor[
            0.0963924889706389, 0.7389363896786321, 0.24181073738548875`], 
            Point3DBox[{9, 4, 3}]}, 
           {RGBColor[
            0.21893353509429647`, 0.0685010767703571, 0.8609978989340106], 
            Point3DBox[{9, 4, 4}]}, 
           {RGBColor[
            0.8866793762963827, 0.7619338385418475, 0.027236257946852138`], 
            Point3DBox[{9, 4, 5}]}, 
           {RGBColor[
            0.9374173248389355, 0.3433199013295052, 0.01908554554888031], 
            Point3DBox[{9, 4, 6}]}, 
           {RGBColor[
            0.8419960636586841, 0.050406677769640806`, 0.7260077513892413], 
            Point3DBox[{9, 4, 7}]}, 
           {RGBColor[
            0.5060595839333417, 0.05930196923023234, 0.6625317880671757], 
            Point3DBox[{9, 4, 8}]}, 
           {RGBColor[
            0.6813124962021382, 0.03405041919022045, 0.5148834078274616], 
            Point3DBox[{9, 4, 9}]}, 
           {RGBColor[
            0.8237461986609727, 0.35092802052931793`, 0.9515706264201023], 
            Point3DBox[{9, 4, 10}]}}, {
           {RGBColor[
            0.3794963592338363, 0.13572611208190244`, 0.3614438754735545], 
            Point3DBox[{9, 5, 1}]}, 
           {RGBColor[
            0.10429457538687781`, 0.8332398541617687, 0.05491970320549355], 
            Point3DBox[{9, 5, 2}]}, 
           {RGBColor[
            0.13271810393418115`, 0.23430416147740263`, 0.13019725304621343`],
             Point3DBox[{9, 5, 3}]}, 
           {RGBColor[
            0.9611660135983062, 0.01092114928612653, 0.554014263017562], 
            Point3DBox[{9, 5, 4}]}, 
           {RGBColor[
            0.12864385958893831`, 0.4892227146890933, 0.013769608063900263`], 
            Point3DBox[{9, 5, 5}]}, 
           {RGBColor[
            0.8142751677481788, 0.758912317050221, 0.9133295835385993], 
            Point3DBox[{9, 5, 6}]}, 
           {RGBColor[
            0.5139832424251434, 0.7038152248987206, 0.17940546869133844`], 
            Point3DBox[{9, 5, 7}]}, 
           {RGBColor[
            0.7080090933941114, 0.5531702687451081, 0.14065238818725945`], 
            Point3DBox[{9, 5, 8}]}, 
           {RGBColor[
            0.9759555120631194, 0.7428196809167662, 0.05136351628157443], 
            Point3DBox[{9, 5, 9}]}, 
           {RGBColor[
            0.686081136870262, 0.6060725832927769, 0.34741005811700654`], 
            Point3DBox[{9, 5, 10}]}}, {
           {RGBColor[
            0.5549674864182033, 0.48130000995787836`, 0.46271610292896326`], 
            Point3DBox[{9, 6, 1}]}, 
           {RGBColor[
            0.33981283481386426`, 0.28643689414544005`, 0.8471715451939725], 
            Point3DBox[{9, 6, 2}]}, 
           {RGBColor[
            0.9626642273560673, 0.9932914615460025, 0.14708304345152978`], 
            Point3DBox[{9, 6, 3}]}, 
           {RGBColor[
            0.8304666687743447, 0.6744266455947692, 0.4180116477554867], 
            Point3DBox[{9, 6, 4}]}, 
           {RGBColor[
            0.28172570296617816`, 0.11964199621539873`, 0.7063802507250942], 
            Point3DBox[{9, 6, 5}]}, 
           {RGBColor[
            0.6878633879728859, 0.8931881401854542, 0.04618648756117394], 
            Point3DBox[{9, 6, 6}]}, 
           {RGBColor[
            0.15225650707814364`, 0.5395500221969136, 0.7413979534882114], 
            Point3DBox[{9, 6, 7}]}, 
           {RGBColor[
            0.9585426587058443, 0.23661258491751647`, 0.5945722499825596], 
            Point3DBox[{9, 6, 8}]}, 
           {RGBColor[
            0.5568159964089989, 0.5738550643034506, 0.29655358241738794`], 
            Point3DBox[{9, 6, 9}]}, 
           {RGBColor[
            0.9413729785440896, 0.37780338273722847`, 0.8594963385438625], 
            Point3DBox[{9, 6, 10}]}}, {
           {RGBColor[
            0.7291819803454711, 0.05015472725075654, 0.2251725129654838], 
            Point3DBox[{9, 7, 1}]}, 
           {RGBColor[
            0.11141413208721285`, 0.40179481128201044`, 0.9430288921383363], 
            Point3DBox[{9, 7, 2}]}, 
           {RGBColor[
            0.9914043793781848, 0.6766362337274572, 0.7008651428670516], 
            Point3DBox[{9, 7, 3}]}, 
           {RGBColor[
            0.8129657674320518, 0.39864855678003064`, 0.4367603123788748], 
            Point3DBox[{9, 7, 4}]}, 
           {RGBColor[
            0.7634299632859705, 0.548380527110685, 0.4164464777529764], 
            Point3DBox[{9, 7, 5}]}, 
           {RGBColor[
            0.7774439648821856, 0.39212868732375483`, 0.4770572992744855], 
            Point3DBox[{9, 7, 6}]}, 
           {RGBColor[
            0.3160814403754395, 0.7406769122397303, 0.8638273868711672], 
            Point3DBox[{9, 7, 7}]}, 
           {RGBColor[
            0.08225504300868525, 0.23752850828501315`, 0.5822067680213057], 
            Point3DBox[{9, 7, 8}]}, 
           {RGBColor[
            0.4217143600659006, 0.536482169024221, 0.5600215853357433], 
            Point3DBox[{9, 7, 9}]}, 
           {RGBColor[
            0.8956942161525558, 0.16748669657033366`, 0.17767095447142167`], 
            Point3DBox[{9, 7, 10}]}}, {
           {RGBColor[
            0.6410162760106717, 0.992851880682281, 0.17270437343912604`], 
            Point3DBox[{9, 8, 1}]}, 
           {RGBColor[
            0.8685705615214345, 0.4718498573925345, 0.6274487920016738], 
            Point3DBox[{9, 8, 2}]}, 
           {RGBColor[
            0.43278726803576784`, 0.41790724824391345`, 0.5948109646591218], 
            Point3DBox[{9, 8, 3}]}, 
           {RGBColor[
            0.19258342809578988`, 0.305753122811661, 0.9716636891026036], 
            Point3DBox[{9, 8, 4}]}, 
           {RGBColor[
            0.18529984546549794`, 0.3463788029498087, 0.5010269170767081], 
            Point3DBox[{9, 8, 5}]}, 
           {RGBColor[
            0.8494203380762209, 0.03397527996555105, 0.5089612868233802], 
            Point3DBox[{9, 8, 6}]}, 
           {RGBColor[
            0.2855619733699022, 0.5682765029267518, 0.9046123607386034], 
            Point3DBox[{9, 8, 7}]}, 
           {RGBColor[
            0.10794642660013953`, 0.35754118435031734`, 0.1977406289455408], 
            Point3DBox[{9, 8, 8}]}, 
           {RGBColor[
            0.023876867967441484`, 0.6652686304503701, 0.4919163203615131], 
            Point3DBox[{9, 8, 9}]}, 
           {RGBColor[
            0.31989128616730844`, 0.6022419183355405, 0.4888199006245577], 
            Point3DBox[{9, 8, 10}]}}, {
           {RGBColor[
            0.2842374692219918, 0.8962693478301331, 0.4685943911366921], 
            Point3DBox[{9, 9, 1}]}, 
           {RGBColor[
            0.008324075944370568, 0.1758280579041498, 0.04802033706725539], 
            Point3DBox[{9, 9, 2}]}, 
           {RGBColor[
            0.06746396296301338, 0.4877178543055032, 0.09451322013609875], 
            Point3DBox[{9, 9, 3}]}, 
           {RGBColor[
            0.708814279033201, 0.7687793115649713, 0.9116501158758576], 
            Point3DBox[{9, 9, 4}]}, 
           {RGBColor[
            0.27330127350725264`, 0.9453904242824851, 0.3788530274026696], 
            Point3DBox[{9, 9, 5}]}, 
           {RGBColor[
            0.8837000001942321, 0.3631024542849468, 0.13708689924053297`], 
            Point3DBox[{9, 9, 6}]}, 
           {RGBColor[
            0.9232423845614708, 0.5805982853235334, 0.4140804253714392], 
            Point3DBox[{9, 9, 7}]}, 
           {RGBColor[
            0.4206213066925346, 0.1005086485811637, 0.9474668476985426], 
            Point3DBox[{9, 9, 8}]}, 
           {RGBColor[
            0.07242347114442316, 0.8002455700400823, 0.736912811910948], 
            Point3DBox[{9, 9, 9}]}, 
           {RGBColor[
            0.9147779184898563, 0.06722137575050491, 0.7673040426985507], 
            Point3DBox[{9, 9, 10}]}}, {
           {RGBColor[
            0.8607714091142951, 0.5221084348901832, 0.32389416740071786`], 
            Point3DBox[{9, 10, 1}]}, 
           {RGBColor[
            0.44097631811351623`, 0.7749949975315897, 0.32613133363692914`], 
            Point3DBox[{9, 10, 2}]}, 
           {RGBColor[
            0.5250674562131799, 0.4060564440822807, 0.4557067013924958], 
            Point3DBox[{9, 10, 3}]}, 
           {RGBColor[
            0.5613496159016933, 0.6642313848884158, 0.3733193377946047], 
            Point3DBox[{9, 10, 4}]}, 
           {RGBColor[
            0.7153813882262297, 0.8596562038435587, 0.10944351758659598`], 
            Point3DBox[{9, 10, 5}]}, 
           {RGBColor[
            0.1256741087017268, 0.14099130179234276`, 0.923292166897153], 
            Point3DBox[{9, 10, 6}]}, 
           {RGBColor[
            0.6736796798772928, 0.08863753696219745, 0.7185054407285199], 
            Point3DBox[{9, 10, 7}]}, 
           {RGBColor[
            0.09293558701911309, 0.16714584963460055`, 0.8717704775707165], 
            Point3DBox[{9, 10, 8}]}, 
           {RGBColor[
            0.496399442756581, 0.23556807731648832`, 0.5754319676481345], 
            Point3DBox[{9, 10, 9}]}, 
           {RGBColor[
            0.6118855429132102, 0.539666256400992, 0.2963576981191989], 
            Point3DBox[{9, 10, 10}]}}}, {{
           {RGBColor[
            0.08958579027167102, 0.7797558147508081, 0.5210683982174207], 
            Point3DBox[{10, 1, 1}]}, 
           {RGBColor[
            0.9974357454009617, 0.031387782348535564`, 0.325327561962669], 
            Point3DBox[{10, 1, 2}]}, 
           {RGBColor[
            0.38818875302870515`, 0.9558052788842362, 0.3616486450667593], 
            Point3DBox[{10, 1, 3}]}, 
           {RGBColor[
            0.37235284387083634`, 0.07068788025230299, 0.9665575548557044], 
            Point3DBox[{10, 1, 4}]}, 
           {RGBColor[
            0.8124140930597035, 0.33457378793855863`, 0.13366402033614433`], 
            Point3DBox[{10, 1, 5}]}, 
           {RGBColor[
            0.4153170350775337, 0.14839410850012036`, 0.10231696863746209`], 
            Point3DBox[{10, 1, 6}]}, 
           {RGBColor[
            0.15152889164564143`, 0.2698703725661835, 0.44046840104352536`], 
            Point3DBox[{10, 1, 7}]}, 
           {RGBColor[
            0.5804275203514495, 0.4409647893149282, 0.1765829375756225], 
            Point3DBox[{10, 1, 8}]}, 
           {RGBColor[
            0.8415300977326696, 0.28985793705613894`, 0.714298955087983], 
            Point3DBox[{10, 1, 9}]}, 
           {RGBColor[
            0.805575814459915, 0.5854563905673138, 0.5704031092109256], 
            Point3DBox[{10, 1, 10}]}}, {
           {RGBColor[
            0.258367715842061, 0.8420298956023351, 0.19333332915794488`], 
            Point3DBox[{10, 2, 1}]}, 
           {RGBColor[
            0.39216049765732897`, 0.6233306697273517, 0.5057195656360387], 
            Point3DBox[{10, 2, 2}]}, 
           {RGBColor[
            0.14549670902800438`, 0.1830895982094951, 0.5286758621222132], 
            Point3DBox[{10, 2, 3}]}, 
           {RGBColor[
            0.8847576444272875, 0.9888147417251065, 0.2349756613073668], 
            Point3DBox[{10, 2, 4}]}, 
           {RGBColor[
            0.941001683321375, 0.7212889054727378, 0.9525171201616336], 
            Point3DBox[{10, 2, 5}]}, 
           {RGBColor[
            0.9596674684320339, 0.9439377867642937, 0.6741753277487423], 
            Point3DBox[{10, 2, 6}]}, 
           {RGBColor[
            0.7660703665443471, 0.81916638635643, 0.8480360364488781], 
            Point3DBox[{10, 2, 7}]}, 
           {RGBColor[
            0.8893231821330525, 0.6350896640438239, 0.779715574904714], 
            Point3DBox[{10, 2, 8}]}, 
           {RGBColor[
            0.06532399862377036, 0.1459276915960379, 0.05632512996161765], 
            Point3DBox[{10, 2, 9}]}, 
           {RGBColor[
            0.737187305262518, 0.39667317465623175`, 0.8327235972037321], 
            Point3DBox[{10, 2, 10}]}}, {
           {RGBColor[
            0.730179554897149, 0.657859133088361, 0.7089789579930679], 
            Point3DBox[{10, 3, 1}]}, 
           {RGBColor[
            0.1370627928357624, 0.592669392017346, 0.3960203703625713], 
            Point3DBox[{10, 3, 2}]}, 
           {RGBColor[
            0.9320747637668945, 0.7383449603061867, 0.06488262093686137], 
            Point3DBox[{10, 3, 3}]}, 
           {RGBColor[
            0.9944340187329437, 0.08481946492185655, 0.3234885176043403], 
            Point3DBox[{10, 3, 4}]}, 
           {RGBColor[
            0.6047043828973155, 0.9574862664460342, 0.7726957857294778], 
            Point3DBox[{10, 3, 5}]}, 
           {RGBColor[
            0.3567330616919977, 0.7004251307287057, 0.7422911326722583], 
            Point3DBox[{10, 3, 6}]}, 
           {RGBColor[
            0.16963370821833745`, 0.3374060879023988, 0.30653878161028514`], 
            Point3DBox[{10, 3, 7}]}, 
           {RGBColor[
            0.5738259842453381, 0.4229188476199832, 0.37072617584878653`], 
            Point3DBox[{10, 3, 8}]}, 
           {RGBColor[
            0.9440133274372999, 0.2981076817294852, 0.03004108746041445], 
            Point3DBox[{10, 3, 9}]}, 
           {RGBColor[
            0.20346113423036383`, 0.8009337595865189, 0.623617700262667], 
            Point3DBox[{10, 3, 10}]}}, {
           {RGBColor[
            0.3851791472978281, 0.27613035406944597`, 0.38593696833354363`], 
            Point3DBox[{10, 4, 1}]}, 
           {RGBColor[
            0.9028695563624525, 0.07550004385816389, 0.02531079956397564], 
            Point3DBox[{10, 4, 2}]}, 
           {RGBColor[
            0.9902281814725582, 0.23337994779182591`, 0.8930942831449102], 
            Point3DBox[{10, 4, 3}]}, 
           {RGBColor[
            0.2726871971885436, 0.6310655247259611, 0.9092669658555781], 
            Point3DBox[{10, 4, 4}]}, 
           {RGBColor[
            0.8584427598895101, 0.21648769467732798`, 0.2111475586067022], 
            Point3DBox[{10, 4, 5}]}, 
           {RGBColor[
            0.42395722460759533`, 0.027306126554707433`, 
             0.24754003898003485`], Point3DBox[{10, 4, 6}]}, 
           {RGBColor[
            0.28126123391031754`, 0.5526528653992273, 0.3542187323006658], 
            Point3DBox[{10, 4, 7}]}, 
           {RGBColor[
            0.8976093115471331, 0.7057446152730447, 0.3512846993398282], 
            Point3DBox[{10, 4, 8}]}, 
           {RGBColor[
            0.6921497570613926, 0.7263446406509237, 0.5680623135742451], 
            Point3DBox[{10, 4, 9}]}, 
           {RGBColor[
            0.8533540893828635, 0.6255073032649494, 0.7542890627411827], 
            Point3DBox[{10, 4, 10}]}}, {
           {RGBColor[
            0.49674146796645635`, 0.43238048258686, 0.842154243270882], 
            Point3DBox[{10, 5, 1}]}, 
           {RGBColor[
            0.5651233323071514, 0.5733947122180487, 0.32644518075115636`], 
            Point3DBox[{10, 5, 2}]}, 
           {RGBColor[
            0.0802283830419992, 0.951139907382968, 0.08685164907892617], 
            Point3DBox[{10, 5, 3}]}, 
           {RGBColor[
            0.1250068979506216, 0.781112387422255, 0.23044212717538248`], 
            Point3DBox[{10, 5, 4}]}, 
           {RGBColor[
            0.11301503847649852`, 0.6207298290050656, 0.4636409651785922], 
            Point3DBox[{10, 5, 5}]}, 
           {RGBColor[
            0.07182639930311807, 0.15942006272565212`, 0.8126630877922827], 
            Point3DBox[{10, 5, 6}]}, 
           {RGBColor[
            0.29297301196547765`, 0.7044588431189738, 0.06368009366792449], 
            Point3DBox[{10, 5, 7}]}, 
           {RGBColor[
            0.8018566073879987, 0.11985469838399565`, 0.7203808302793535], 
            Point3DBox[{10, 5, 8}]}, 
           {RGBColor[
            0.1401201377260184, 0.7801860142019066, 0.9526811068172962], 
            Point3DBox[{10, 5, 9}]}, 
           {RGBColor[
            0.1318426712996572, 0.5358153992317418, 0.4662632101200921], 
            Point3DBox[{10, 5, 10}]}}, {
           {RGBColor[
            0.7385308452134673, 0.44159251973229097`, 0.19571222376115327`], 
            Point3DBox[{10, 6, 1}]}, 
           {RGBColor[
            0.28352629746035807`, 0.969667725287662, 0.4094470677585338], 
            Point3DBox[{10, 6, 2}]}, 
           {RGBColor[
            0.30926017539522954`, 0.9111726487899834, 0.7651515376589433], 
            Point3DBox[{10, 6, 3}]}, 
           {RGBColor[
            0.6083112046832428, 0.8716260465367283, 0.7140653809402737], 
            Point3DBox[{10, 6, 4}]}, 
           {RGBColor[
            0.32381030322352533`, 0.27163620018021617`, 0.6863037414675324], 
            Point3DBox[{10, 6, 5}]}, 
           {RGBColor[
            0.722012001112514, 0.7378659087467849, 0.32563213234114996`], 
            Point3DBox[{10, 6, 6}]}, 
           {RGBColor[
            0.6877528111052695, 0.01117742732138538, 0.9623120809750876], 
            Point3DBox[{10, 6, 7}]}, 
           {RGBColor[
            0.5542291676361899, 0.13919282039064496`, 0.23273586715324113`], 
            Point3DBox[{10, 6, 8}]}, 
           {RGBColor[
            0.9571321060152918, 0.951164111474295, 0.43922673571361126`], 
            Point3DBox[{10, 6, 9}]}, 
           {RGBColor[
            0.7959463728767593, 0.32740595750134194`, 0.7857555836901435], 
            Point3DBox[{10, 6, 10}]}}, {
           {RGBColor[
            0.33616745618325083`, 0.9498667054687182, 0.9304604489353421], 
            Point3DBox[{10, 7, 1}]}, 
           {RGBColor[
            0.9161506385387801, 0.612774912802855, 0.5378065650186097], 
            Point3DBox[{10, 7, 2}]}, 
           {RGBColor[
            0.553327414132518, 0.20383322059088105`, 0.24621128365709288`], 
            Point3DBox[{10, 7, 3}]}, 
           {RGBColor[
            0.700739383388544, 0.36400125859747146`, 0.08517766701663176], 
            Point3DBox[{10, 7, 4}]}, 
           {RGBColor[
            0.6538551899011482, 0.6654312750618949, 0.06528566333108721], 
            Point3DBox[{10, 7, 5}]}, 
           {RGBColor[
            0.996501056227473, 0.32223525368863526`, 0.46233594500168285`], 
            Point3DBox[{10, 7, 6}]}, 
           {RGBColor[
            0.31425983564640103`, 0.4068721964453528, 0.8805030872848127], 
            Point3DBox[{10, 7, 7}]}, 
           {RGBColor[
            0.23272120315194544`, 0.8582736841221821, 0.8986818821541116], 
            Point3DBox[{10, 7, 8}]}, 
           {RGBColor[
            0.6413087315020636, 0.026991905692865803`, 0.050781886779467156`],
             Point3DBox[{10, 7, 9}]}, 
           {RGBColor[
            0.6832985255842032, 0.7478307558132005, 0.7402384683473684], 
            Point3DBox[{10, 7, 10}]}}, {
           {RGBColor[
            0.9968822875600478, 0.491980656934204, 0.7179398764518055], 
            Point3DBox[{10, 8, 1}]}, 
           {RGBColor[
            0.3607541842876836, 0.7683397381604884, 0.8201963032852617], 
            Point3DBox[{10, 8, 2}]}, 
           {RGBColor[
            0.3527615548067877, 0.46740534720198745`, 0.38514785244104455`], 
            Point3DBox[{10, 8, 3}]}, 
           {RGBColor[
            0.9287822726922903, 0.7931961008206467, 0.3722486544117847], 
            Point3DBox[{10, 8, 4}]}, 
           {RGBColor[
            0.09015572477190048, 0.18154347495029333`, 0.9197695763430338], 
            Point3DBox[{10, 8, 5}]}, 
           {RGBColor[
            0.9737289866629966, 0.7905762699598962, 0.3294866323536543], 
            Point3DBox[{10, 8, 6}]}, 
           {RGBColor[
            0.23699899387357615`, 0.1303868253669136, 0.7723521726112783], 
            Point3DBox[{10, 8, 7}]}, 
           {RGBColor[
            0.6174933743444542, 0.2684607861105366, 0.017271580079708748`], 
            Point3DBox[{10, 8, 8}]}, 
           {RGBColor[
            0.42243869750724317`, 0.012358722117459475`, 0.02015668372299828],
             Point3DBox[{10, 8, 9}]}, 
           {RGBColor[
            0.7040952918398142, 0.12106675635199826`, 0.2620071309408343], 
            Point3DBox[{10, 8, 10}]}}, {
           {RGBColor[
            0.32358212876274695`, 0.563155420301328, 0.09318626747733738], 
            Point3DBox[{10, 9, 1}]}, 
           {RGBColor[
            0.3536283210310709, 0.11788655379439428`, 0.8346891916932866], 
            Point3DBox[{10, 9, 2}]}, 
           {RGBColor[
            0.9760978020568534, 0.9958781970878978, 0.3492811331621646], 
            Point3DBox[{10, 9, 3}]}, 
           {RGBColor[
            0.7133914553772973, 0.3673105884653054, 0.6121406810385976], 
            Point3DBox[{10, 9, 4}]}, 
           {RGBColor[
            0.6032888075513048, 0.9705404031562956, 0.2682774894907547], 
            Point3DBox[{10, 9, 5}]}, 
           {RGBColor[
            0.9185674263004127, 0.8704717632927494, 0.882341116389902], 
            Point3DBox[{10, 9, 6}]}, 
           {RGBColor[
            0.3940171328210196, 0.1781016412217682, 0.5186822739807724], 
            Point3DBox[{10, 9, 7}]}, 
           {RGBColor[
            0.08212399071790899, 0.0092321031515743, 0.7821422855679194], 
            Point3DBox[{10, 9, 8}]}, 
           {RGBColor[
            0.9471518418397566, 0.551981562651509, 0.4919138404102883], 
            Point3DBox[{10, 9, 9}]}, 
           {RGBColor[
            0.9801070892772963, 0.5837426043588265, 0.9387716056704865], 
            Point3DBox[{10, 9, 10}]}}, {
           {RGBColor[
            0.3645217775809091, 0.0507438956656725, 0.9992977997734005], 
            Point3DBox[{10, 10, 1}]}, 
           {RGBColor[
            0.33317527762545285`, 0.07415452396436306, 0.039453783088698735`],
             Point3DBox[{10, 10, 2}]}, 
           {RGBColor[
            0.9023529331080251, 0.737218084585946, 0.8037865869131327], 
            Point3DBox[{10, 10, 3}]}, 
           {RGBColor[
            0.28623960979064167`, 0.36490236795086584`, 0.585167020883586], 
            Point3DBox[{10, 10, 4}]}, 
           {RGBColor[
            0.3184869888311086, 0.42095308765478223`, 0.7768663733569259], 
            Point3DBox[{10, 10, 5}]}, 
           {RGBColor[
            0.055456023037524504`, 0.5521684102684328, 0.8097243394509321], 
            Point3DBox[{10, 10, 6}]}, 
           {RGBColor[
            0.8811024888062862, 0.9580157126841089, 0.5122952675635752], 
            Point3DBox[{10, 10, 7}]}, 
           {RGBColor[
            0.8039918603870795, 0.39239358131714774`, 0.487851982372838], 
            Point3DBox[{10, 10, 8}]}, 
           {RGBColor[
            0.4631937287798913, 0.13113430748815946`, 0.7658935823138919], 
            Point3DBox[{10, 10, 9}]}, 
           {RGBColor[
            0.7320903828692651, 0.22483208701004953`, 0.8078603527965327], 
            Point3DBox[{10, 10, 10}]}}}},
        ImageSize->{261.66015625, Automatic},
        ViewPoint->{1.3, -2.4, 2.},
        ViewVertical->{0., 0., 1.}]], "ExerciseOutput",ExpressionUUID->
       "ce699dd7-20f2-456e-9fd6-27d7c87e4f01"],
      Apply[TextCell, 
       Cell[
        BoxData[
         Graphics3DBox[{{{{{
               RGBColor[
               0.030226047463962624`, 0.44325593064423074`, 
                0.6208198239912806], 
               Point3DBox[{1, 1, 1}]}}, {{
               RGBColor[
               0.5471143145417774, 0.9595092631312614, 0.1093732234181426], 
               Point3DBox[{1, 1, 2}]}}, {{
               RGBColor[
               0.6771525810474233, 0.2819331093309283, 0.28249384274080147`], 
               
               Point3DBox[{1, 1, 3}]}}, {{
               RGBColor[
               0.6344282430004764, 0.8203798998049077, 0.4566119058945619], 
               Point3DBox[{1, 1, 4}]}}, {{
               RGBColor[
               0.2969217003101263, 0.15399802422432596`, 
                0.16953116194605733`], 
               Point3DBox[{1, 1, 5}]}}, {{
               RGBColor[
               0.17262886064247351`, 0.3779339132025965, 
                0.12399520342770232`], 
               Point3DBox[{1, 1, 6}]}}, {{
               RGBColor[
               0.6710148222288634, 0.8525524303950833, 0.2605488252342629], 
               Point3DBox[{1, 1, 7}]}}, {{
               RGBColor[
               0.8257641606301611, 0.9355359364415838, 0.6411834832561292], 
               Point3DBox[{1, 1, 8}]}}, {{
               RGBColor[
               0.7504055280853497, 0.5211261341577103, 0.9435207763084086], 
               Point3DBox[{1, 1, 9}]}}, {{
               RGBColor[
               0.2385588316453382, 0.9001249838155558, 0.28410182658416816`], 
               
               Point3DBox[{1, 1, 10}]}}}, {{{
               RGBColor[
               0.30137701786753057`, 0.24818375709703155`, 
                0.36783556434136244`], 
               Point3DBox[{1, 2, 1}]}}, {{
               RGBColor[
               0.8429241265701424, 0.32561507711161686`, 0.7149926504866888], 
               
               Point3DBox[{1, 2, 2}]}}, {{
               RGBColor[
               0.025642992962680022`, 0.20161529792845645`, 
                0.8021629912687567], 
               Point3DBox[{1, 2, 3}]}}, {{
               RGBColor[
               0.5348810858829132, 0.7600711738741939, 0.11580501440267654`], 
               
               Point3DBox[{1, 2, 4}]}}, {{
               RGBColor[
               0.8584132404642264, 0.32857008981385616`, 0.5766930917134623], 
               
               Point3DBox[{1, 2, 5}]}}, {{
               RGBColor[
               0.011126695577744483`, 0.5426131762868516, 
                0.02663182937847508], 
               Point3DBox[{1, 2, 6}]}}, {{
               RGBColor[
               0.35667301789142525`, 0.9247129185039993, 
                0.37063757321940893`], 
               Point3DBox[{1, 2, 7}]}}, {{
               RGBColor[
               0.01708172477463088, 0.959445203647777, 0.003648831525236762], 
               
               Point3DBox[{1, 2, 8}]}}, {{
               RGBColor[
               0.14962398064939486`, 0.8232554321240344, 0.7605127620108647], 
               
               Point3DBox[{1, 2, 9}]}}, {{
               RGBColor[
               0.49912173813233607`, 0.4882876999342671, 0.02219183104461231], 
               Point3DBox[{1, 2, 10}]}}}, {{{
               RGBColor[
               0.2030749048688174, 0.9935469590164643, 0.1661824096251534], 
               Point3DBox[{1, 3, 1}]}}, {{
               RGBColor[
               0.008303359472750849, 0.9350854162873821, 0.7213565764570276], 
               
               Point3DBox[{1, 3, 2}]}}, {{
               RGBColor[
               0.2994070893615681, 0.3812524209221342, 0.8995658884464461], 
               Point3DBox[{1, 3, 3}]}}, {{
               RGBColor[
               0.4606503269152378, 0.9639685082686014, 0.204839251338659], 
               Point3DBox[{1, 3, 4}]}}, {{
               RGBColor[
               0.7524837933074937, 0.8482339880745742, 0.7894324720402879], 
               Point3DBox[{1, 3, 5}]}}, {{
               RGBColor[
               0.6190726525151737, 0.22100776003517253`, 0.6393134349986449], 
               
               Point3DBox[{1, 3, 6}]}}, {{
               RGBColor[
               0.7431979712652572, 0.6815743926107878, 0.449533245260199], 
               Point3DBox[{1, 3, 7}]}}, {{
               RGBColor[
               0.36834362898729034`, 0.1367160272288357, 0.07313015686219826], 
               Point3DBox[{1, 3, 8}]}}, {{
               RGBColor[
               0.9674358435915309, 0.7850623909317067, 0.15045382673908914`], 
               
               Point3DBox[{1, 3, 9}]}}, {{
               RGBColor[
               0.894744332624201, 0.14277945474139098`, 0.39374372791719936`], 
               Point3DBox[{1, 3, 10}]}}}, {{{
               RGBColor[
               0.7925554683610241, 0.27321960636691056`, 
                0.46243670585221164`], 
               Point3DBox[{1, 4, 1}]}}, {{
               RGBColor[
               0.07118243759195741, 0.6611067409209903, 0.9471716337133824], 
               Point3DBox[{1, 4, 2}]}}, {{
               RGBColor[
               0.008910904213379922, 0.33693315370878874`, 
                0.35524863457220524`], 
               Point3DBox[{1, 4, 3}]}}, {{
               RGBColor[
               0.757147556818347, 0.322352357746297, 0.8853160180143715], 
               Point3DBox[{1, 4, 4}]}}, {{
               RGBColor[
               0.5002051582939924, 0.2151112011110088, 0.7636132051947144], 
               Point3DBox[{1, 4, 5}]}}, {{
               RGBColor[
               0.46195962868972895`, 0.8560840201943045, 0.3994260200493076], 
               
               Point3DBox[{1, 4, 6}]}}, {{
               RGBColor[
               0.2520961409954441, 0.45259456818818333`, 0.9295755958344383], 
               
               Point3DBox[{1, 4, 7}]}}, {{
               RGBColor[
               0.8917885319788148, 0.6058899163971854, 0.6311074694505372], 
               Point3DBox[{1, 4, 8}]}}, {{
               RGBColor[
               0.9938141154944848, 0.555698177252753, 0.1633933156950793], 
               Point3DBox[{1, 4, 9}]}}, {{
               RGBColor[
               0.9128836023044391, 0.40710541569497627`, 
                0.22475229409969222`], 
               Point3DBox[{1, 4, 10}]}}}, {{{
               RGBColor[
               0.07126713995330336, 0.5108399643472723, 0.2510729420413407], 
               Point3DBox[{1, 5, 1}]}}, {{
               RGBColor[
               0.8399531592414884, 0.5184387904879484, 0.770119013435761], 
               Point3DBox[{1, 5, 2}]}}, {{
               RGBColor[
               0.34385004055259905`, 0.7959166779159803, 0.4325592749421785], 
               
               Point3DBox[{1, 5, 3}]}}, {{
               RGBColor[
               0.5976419802556725, 0.9744576014007544, 0.39371264752660595`], 
               
               Point3DBox[{1, 5, 4}]}}, {{
               RGBColor[
               0.5240943727610394, 0.023428378135993855`, 0.8915308340800077], 
               Point3DBox[{1, 5, 5}]}}, {{
               RGBColor[
               0.9337798135688657, 0.43549380765237755`, 0.2492723747747858], 
               
               Point3DBox[{1, 5, 6}]}}, {{
               RGBColor[
               0.9489908861764624, 0.7508868886921438, 0.5069569086651371], 
               Point3DBox[{1, 5, 7}]}}, {{
               RGBColor[
               0.7219690190540835, 0.9726299718451514, 0.035838227823833835`], 
               Point3DBox[{1, 5, 8}]}}, {{
               RGBColor[
               0.02849462426631888, 0.9567562503493254, 0.40979808610737667`], 
               Point3DBox[{1, 5, 9}]}}, {{
               RGBColor[
               0.2951020484266209, 0.7991778587206397, 0.8144643901489892], 
               Point3DBox[{1, 5, 10}]}}}, {{{
               RGBColor[
               0.7241790949200211, 0.016168779799683897`, 
                0.18961555275919717`], 
               Point3DBox[{1, 6, 1}]}}, {{
               RGBColor[
               0.726692241411768, 0.9593655010087194, 0.42621399846862196`], 
               Point3DBox[{1, 6, 2}]}}, {{
               RGBColor[
               0.20758416038133043`, 0.5546283612306968, 0.4819301858155376], 
               
               Point3DBox[{1, 6, 3}]}}, {{
               RGBColor[
               0.6697814668581039, 0.439953010248733, 0.0946871266083209], 
               Point3DBox[{1, 6, 4}]}}, {{
               RGBColor[
               0.16242416208173616`, 0.6687795110872261, 0.6216199619358489], 
               
               Point3DBox[{1, 6, 5}]}}, {{
               RGBColor[
               0.990947167261363, 0.7908337988731293, 0.5990097288717504], 
               Point3DBox[{1, 6, 6}]}}, {{
               RGBColor[
               0.9197089612387663, 0.8790535145651528, 0.7339163913239688], 
               Point3DBox[{1, 6, 7}]}}, {{
               RGBColor[
               0.6842460137002664, 0.09768959056520399, 0.3516490760326023], 
               Point3DBox[{1, 6, 8}]}}, {{
               RGBColor[
               0.25888161596282777`, 0.9335495495165735, 0.2547615373311558], 
               
               Point3DBox[{1, 6, 9}]}}, {{
               RGBColor[
               0.7756069177709157, 0.3455550091360362, 0.9973554265359927], 
               Point3DBox[{1, 6, 10}]}}}, {{{
               RGBColor[
               0.4341527505823135, 0.8347239656051584, 0.6208838496994049], 
               Point3DBox[{1, 7, 1}]}}, {{
               RGBColor[
               0.8268647971416752, 0.4312491360824233, 0.11356038392239443`], 
               
               Point3DBox[{1, 7, 2}]}}, {{
               RGBColor[
               0.7626106837114128, 0.6779056290096663, 0.8742435964184792], 
               Point3DBox[{1, 7, 3}]}}, {{
               RGBColor[
               0.7775791191936385, 0.3413897634576859, 0.6546067508879816], 
               Point3DBox[{1, 7, 4}]}}, {{
               RGBColor[
               0.6017250675427008, 0.8666660450244796, 0.3531183757688954], 
               Point3DBox[{1, 7, 5}]}}, {{
               RGBColor[
               0.9512288258782309, 0.6178575522066312, 0.5326469998799832], 
               Point3DBox[{1, 7, 6}]}}, {{
               RGBColor[
               0.05636550503977489, 0.41838631079813493`, 
                0.10074489775223738`], 
               Point3DBox[{1, 7, 7}]}}, {{
               RGBColor[
               0.12406654256172245`, 0.006934462054569046, 
                0.02890178028624657], 
               Point3DBox[{1, 7, 8}]}}, {{
               RGBColor[
               0.03561072711452984, 0.9016088768958399, 0.4232282628946846], 
               Point3DBox[{1, 7, 9}]}}, {{
               RGBColor[
               0.688992225121801, 0.8834781107765366, 0.47122943929537464`], 
               Point3DBox[{1, 7, 10}]}}}, {{{
               RGBColor[
               0.7530583991100261, 0.48500473656891807`, 0.6735377056669405], 
               
               Point3DBox[{1, 8, 1}]}}, {{
               RGBColor[
               0.37090752814166716`, 0.3060903064644882, 0.07208259282031215], 
               Point3DBox[{1, 8, 2}]}}, {{
               RGBColor[
               0.10164864444319965`, 0.2799663657971714, 0.3861393779571429], 
               
               Point3DBox[{1, 8, 3}]}}, {{
               RGBColor[
               0.43212497778038395`, 0.18152877686460567`, 
                0.09485519563969724], 
               Point3DBox[{1, 8, 4}]}}, {{
               RGBColor[
               0.32785553413184565`, 0.6283252604413452, 0.9868411020988199], 
               
               Point3DBox[{1, 8, 5}]}}, {{
               RGBColor[
               0.887816106858244, 0.21485447721764328`, 0.47327862177259106`], 
               Point3DBox[{1, 8, 6}]}}, {{
               RGBColor[
               0.6134289994084401, 0.21126061649973327`, 0.2616962835096157], 
               
               Point3DBox[{1, 8, 7}]}}, {{
               RGBColor[
               0.5170975348373612, 0.32389763549989325`, 0.5675245287916146], 
               
               Point3DBox[{1, 8, 8}]}}, {{
               RGBColor[
               0.5784865826008034, 0.09036293369186121, 0.3361365692186278], 
               Point3DBox[{1, 8, 9}]}}, {{
               RGBColor[
               0.9170337398413948, 0.6779834506540268, 0.48069923030084216`], 
               
               Point3DBox[{1, 8, 10}]}}}, {{{
               RGBColor[
               0.9659435718694596, 0.9299064497882137, 0.9169912970455529], 
               Point3DBox[{1, 9, 1}]}}, {{
               RGBColor[
               0.5617828491688612, 0.1534651506092901, 0.8224180881476775], 
               Point3DBox[{1, 9, 2}]}}, {{
               RGBColor[
               0.6005084070670035, 0.7650539276887203, 0.24017333995255163`], 
               
               Point3DBox[{1, 9, 3}]}}, {{
               RGBColor[
               0.9476818325728282, 0.8019889139842467, 0.6716955634102906], 
               Point3DBox[{1, 9, 4}]}}, {{
               RGBColor[
               0.13635597206079875`, 0.9463104949310521, 0.07220872468887096], 
               Point3DBox[{1, 9, 5}]}}, {{
               RGBColor[
               0.9807444193224186, 0.1343879708603839, 0.6439586588869883], 
               Point3DBox[{1, 9, 6}]}}, {{
               RGBColor[
               0.22719120233723888`, 0.9354834538872161, 0.7445540312404564], 
               
               Point3DBox[{1, 9, 7}]}}, {{
               RGBColor[
               0.0024592236286506974`, 0.43302285477393654`, 
                0.7318555613923503], 
               Point3DBox[{1, 9, 8}]}}, {{
               RGBColor[
               0.8295865635736088, 0.48796403225969587`, 0.7952771804343979], 
               
               Point3DBox[{1, 9, 9}]}}, {{
               RGBColor[
               0.6895815352859007, 0.5209922782326637, 0.4920219386431792], 
               Point3DBox[{1, 9, 10}]}}}, {{{
               RGBColor[
               0.12609321597657974`, 0.8678841332915337, 0.8171949283818862], 
               
               Point3DBox[{1, 10, 1}]}}, {{
               RGBColor[
               0.5732123985505848, 0.615182619521291, 0.20998199775392323`], 
               Point3DBox[{1, 10, 2}]}}, {{
               RGBColor[
               0.14230261213053574`, 0.4558047975387669, 0.7548073771923427], 
               
               Point3DBox[{1, 10, 3}]}}, {{
               RGBColor[
               0.4912328657819882, 0.6758051777559186, 0.6375209470857068], 
               Point3DBox[{1, 10, 4}]}}, {{
               RGBColor[
               0.31108806673033507`, 0.6841826424062796, 0.8623532159376408], 
               
               Point3DBox[{1, 10, 5}]}}, {{
               RGBColor[
               0.47890937593671534`, 0.7181929371759823, 0.8371616977328948], 
               
               Point3DBox[{1, 10, 6}]}}, {{
               RGBColor[
               0.6636459868677438, 0.9968973791261211, 0.6286886449317359], 
               Point3DBox[{1, 10, 7}]}}, {{
               RGBColor[
               0.7872836724281274, 0.6851694483928252, 0.038574486878128145`], 
               Point3DBox[{1, 10, 8}]}}, {{
               RGBColor[
               0.18903418572599606`, 0.6062994343677333, 0.6845763122256034], 
               
               Point3DBox[{1, 10, 9}]}}, {{
               RGBColor[
               0.8791452738067012, 0.3156583478557742, 0.4205254892073038], 
               Point3DBox[{1, 10, 10}]}}}}, {{{{
               RGBColor[
               0.5004300345312183, 0.11899472669191224`, 
                0.049915203616287984`], 
               Point3DBox[{2, 1, 1}]}}, {{
               RGBColor[
               0.11966697234887103`, 0.6648570249826491, 0.6050962690110169], 
               
               Point3DBox[{2, 1, 2}]}}, {{
               RGBColor[
               0.7185117376345203, 0.019575648976903448`, 0.428963383637063], 
               
               Point3DBox[{2, 1, 3}]}}, {{
               RGBColor[
               0.03399063681428083, 0.11235727038527332`, 
                0.47861543341138946`], 
               Point3DBox[{2, 1, 4}]}}, {{
               RGBColor[
               0.6448322241144826, 0.08869614494408062, 
                0.0024886383473219365`], 
               Point3DBox[{2, 1, 5}]}}, {{
               RGBColor[
               0.3976748160250989, 0.8791563959728668, 0.3900125650253272], 
               Point3DBox[{2, 1, 6}]}}, {{
               RGBColor[
               0.6444973524787794, 0.4728161516526417, 0.25685732790371474`], 
               
               Point3DBox[{2, 1, 7}]}}, {{
               RGBColor[
               0.3789018780472362, 0.8252387717587748, 0.3546200732956595], 
               Point3DBox[{2, 1, 8}]}}, {{
               RGBColor[
               0.09633172364285492, 0.20639774655117393`, 
                0.18310088805646618`], 
               Point3DBox[{2, 1, 9}]}}, {{
               RGBColor[
               0.2447114533683068, 0.7115355875707661, 0.2108890666772396], 
               Point3DBox[{2, 1, 10}]}}}, {{{
               RGBColor[
               0.7204555213628034, 0.8025122943385476, 0.6358147304933666], 
               Point3DBox[{2, 2, 1}]}}, {{
               RGBColor[
               0.32208569344277604`, 0.8842925158757213, 
                0.013889653869919139`], 
               Point3DBox[{2, 2, 2}]}}, {{
               RGBColor[
               0.016425915483119002`, 0.584513450335379, 
                0.30821628651827293`], 
               Point3DBox[{2, 2, 3}]}}, {{
               RGBColor[
               0.13766905373012706`, 0.8172191486621987, 0.9114419293969183], 
               
               Point3DBox[{2, 2, 4}]}}, {{
               RGBColor[
               0.7523939585240118, 0.2158423549533166, 0.6842403562243409], 
               Point3DBox[{2, 2, 5}]}}, {{
               RGBColor[
               0.09334188741280158, 0.3816055279175927, 0.4218646939906292], 
               Point3DBox[{2, 2, 6}]}}, {{
               RGBColor[
               0.922391823166181, 0.6250997181158156, 0.7787013097488307], 
               Point3DBox[{2, 2, 7}]}}, {{
               RGBColor[
               0.5153649588912455, 0.2952895139690006, 0.07721967501888205], 
               Point3DBox[{2, 2, 8}]}}, {{
               RGBColor[
               0.06201563961878498, 0.26575002413504034`, 0.988213955166463], 
               
               Point3DBox[{2, 2, 9}]}}, {{
               RGBColor[
               0.5062338655696852, 0.9598187984639917, 0.5825351996580086], 
               Point3DBox[{2, 2, 10}]}}}, {{{
               RGBColor[
               0.9371979507863448, 0.9484322963882588, 0.07831134648763971], 
               Point3DBox[{2, 3, 1}]}}, {{
               RGBColor[
               0.4998391004968443, 0.6227080051909777, 0.5774455340206539], 
               Point3DBox[{2, 3, 2}]}}, {{
               RGBColor[
               0.8079682227000862, 0.11899078919773554`, 0.9539196630595506], 
               
               Point3DBox[{2, 3, 3}]}}, {{
               RGBColor[
               0.10109339507484072`, 0.02418589834951712, 0.9563009028437572], 
               Point3DBox[{2, 3, 4}]}}, {{
               RGBColor[
               0.8415973712039433, 0.8798925072165362, 0.010185295037547393`], 
               Point3DBox[{2, 3, 5}]}}, {{
               RGBColor[
               0.2485364667370673, 0.6146779850025861, 0.8859341339300035], 
               Point3DBox[{2, 3, 6}]}}, {{
               RGBColor[
               0.5879852996764354, 0.5879901312740745, 0.7986402953259013], 
               Point3DBox[{2, 3, 7}]}}, {{
               RGBColor[
               0.900437855431085, 0.18270542684374047`, 0.32449955758597016`], 
               Point3DBox[{2, 3, 8}]}}, {{
               RGBColor[
               0.6609836832527438, 0.12317418285114501`, 
                0.030434744356602428`], 
               Point3DBox[{2, 3, 9}]}}, {{
               RGBColor[
               0.23810319465340668`, 0.5693339283920686, 0.6356843073005038], 
               
               Point3DBox[{2, 3, 10}]}}}, {{{
               RGBColor[
               0.28462393348976356`, 0.9944154976645712, 0.5420718219743295], 
               
               Point3DBox[{2, 4, 1}]}}, {{
               RGBColor[
               0.22752512106430856`, 0.10568237868942787`, 
                0.13681419412907148`], 
               Point3DBox[{2, 4, 2}]}}, {{
               RGBColor[
               0.1547041503145572, 0.6738943169948486, 0.8134987380721344], 
               Point3DBox[{2, 4, 3}]}}, {{
               RGBColor[
               0.7340125192184854, 0.7028109056374845, 0.48421186192499355`], 
               
               Point3DBox[{2, 4, 4}]}}, {{
               RGBColor[
               0.7009942289026629, 0.9039973733124607, 0.6492802975900538], 
               Point3DBox[{2, 4, 5}]}}, {{
               RGBColor[
               0.257837016716707, 0.8478216514683061, 0.6722240561732122], 
               Point3DBox[{2, 4, 6}]}}, {{
               RGBColor[
               0.20698942754504213`, 0.24266391430646328`, 
                0.9456613560336047], 
               Point3DBox[{2, 4, 7}]}}, {{
               RGBColor[
               0.9636976510314097, 0.10022768336101828`, 0.0507666469639676], 
               
               Point3DBox[{2, 4, 8}]}}, {{
               RGBColor[
               0.9835278829541054, 0.03861301203217349, 0.19818083751603055`], 
               Point3DBox[{2, 4, 9}]}}, {{
               RGBColor[
               0.33664464987373743`, 0.7256511979327449, 0.3227132628552951], 
               
               Point3DBox[{2, 4, 10}]}}}, {{{
               RGBColor[
               0.7309463215841654, 0.10218099056175789`, 0.07088662888699493], 
               Point3DBox[{2, 5, 1}]}}, {{
               RGBColor[
               0.7231035679152285, 0.7641464285525505, 0.7469960365161403], 
               Point3DBox[{2, 5, 2}]}}, {{
               RGBColor[
               0.7779786333101368, 0.6735380611877129, 0.3377764862516006], 
               Point3DBox[{2, 5, 3}]}}, {{
               RGBColor[
               0.9026647921930273, 0.9407841248696855, 0.9854069576570244], 
               Point3DBox[{2, 5, 4}]}}, {{
               RGBColor[
               0.7472145196662374, 0.33314464537600075`, 
                0.48205084295298706`], 
               Point3DBox[{2, 5, 5}]}}, {{
               RGBColor[
               0.694960718271735, 0.2997171558145537, 0.8888881496811336], 
               Point3DBox[{2, 5, 6}]}}, {{
               RGBColor[
               0.4228327059782462, 0.588178930409744, 0.5095214744513978], 
               Point3DBox[{2, 5, 7}]}}, {{
               RGBColor[
               0.7042643604924963, 0.43705050894824593`, 0.5738920598446307], 
               
               Point3DBox[{2, 5, 8}]}}, {{
               RGBColor[
               0.14163941034554828`, 0.011500011204049754`, 
                0.7899068307919628], 
               Point3DBox[{2, 5, 9}]}}, {{
               RGBColor[
               0.281417482756688, 0.9553081731850259, 0.9505608786763993], 
               Point3DBox[{2, 5, 10}]}}}, {{{
               RGBColor[
               0.6762859057821746, 0.010444697846570206`, 0.37267748335052], 
               Point3DBox[{2, 6, 1}]}}, {{
               RGBColor[
               0.8923048092380963, 0.043979227798127685`, 0.2282452057484734], 
               Point3DBox[{2, 6, 2}]}}, {{
               RGBColor[
               0.48891915384632845`, 0.9219726899720824, 0.7408002639152467], 
               
               Point3DBox[{2, 6, 3}]}}, {{
               RGBColor[
               0.6890278282170479, 0.19111675522650406`, 
                0.41475341406294497`], 
               Point3DBox[{2, 6, 4}]}}, {{
               RGBColor[
               0.3501166696555893, 0.00557304242868506, 0.9203770320532352], 
               Point3DBox[{2, 6, 5}]}}, {{
               RGBColor[
               0.23690247753696636`, 0.44938523918931406`, 
                0.05394497323810299], 
               Point3DBox[{2, 6, 6}]}}, {{
               RGBColor[
               0.4756390402796502, 0.3237570895084063, 0.00305088991666147], 
               Point3DBox[{2, 6, 7}]}}, {{
               RGBColor[
               0.6374522961472935, 0.1614033354115092, 0.15850239270014121`], 
               
               Point3DBox[{2, 6, 8}]}}, {{
               RGBColor[
               0.9794169345006363, 0.7767238324292758, 0.7220651850283291], 
               Point3DBox[{2, 6, 9}]}}, {{
               RGBColor[
               0.6678945570652846, 0.8623283985848385, 0.9304103734725744], 
               Point3DBox[{2, 6, 10}]}}}, {{{
               RGBColor[
               0.9222216050785552, 0.37583556077886926`, 0.3187726603406207], 
               
               Point3DBox[{2, 7, 1}]}}, {{
               RGBColor[
               0.18166963284458704`, 0.2425863461761233, 0.4695012353993415], 
               
               Point3DBox[{2, 7, 2}]}}, {{
               RGBColor[
               0.24386183830136776`, 0.15104801236082976`, 
                0.14260625728704368`], 
               Point3DBox[{2, 7, 3}]}}, {{
               RGBColor[
               0.2627807140352205, 0.327818071942122, 0.06916397418705444], 
               Point3DBox[{2, 7, 4}]}}, {{
               RGBColor[
               0.5067377322197466, 0.5001286561116378, 0.9375368245115978], 
               Point3DBox[{2, 7, 5}]}}, {{
               RGBColor[
               0.6552735154631426, 0.7216558195090614, 0.9063591112651845], 
               Point3DBox[{2, 7, 6}]}}, {{
               RGBColor[
               0.06676047177124489, 0.373992542543339, 0.8992086013303147], 
               Point3DBox[{2, 7, 7}]}}, {{
               RGBColor[
               0.7717505233033777, 0.5694258894492092, 0.9073136975473919], 
               Point3DBox[{2, 7, 8}]}}, {{
               RGBColor[
               0.3373807537972162, 0.8867198136642211, 0.7370086041475976], 
               Point3DBox[{2, 7, 9}]}}, {{
               RGBColor[
               0.910150417778105, 0.3581918347537818, 0.9810642513735122], 
               Point3DBox[{2, 7, 10}]}}}, {{{
               RGBColor[
               0.04109721323528093, 0.2951650241340542, 0.22506503990371773`], 
               Point3DBox[{2, 8, 1}]}}, {{
               RGBColor[
               0.6620373225037177, 0.7019921022703326, 0.44518352291806274`], 
               
               Point3DBox[{2, 8, 2}]}}, {{
               RGBColor[
               0.7541773351809107, 0.6668315323685936, 0.981558565902376], 
               Point3DBox[{2, 8, 3}]}}, {{
               RGBColor[
               0.9392567330381898, 0.39929799921504405`, 0.7251044169177612], 
               
               Point3DBox[{2, 8, 4}]}}, {{
               RGBColor[
               0.2187765168394964, 0.5374140443693844, 0.3560973673039336], 
               Point3DBox[{2, 8, 5}]}}, {{
               RGBColor[
               0.007156117378968707, 0.19154950288724004`, 
                0.6623554787670998], 
               Point3DBox[{2, 8, 6}]}}, {{
               RGBColor[
               0.5186621756090968, 0.7842945747368655, 0.9827098726688543], 
               Point3DBox[{2, 8, 7}]}}, {{
               RGBColor[
               0.7362036363417934, 0.9724923050088834, 0.22148646032668928`], 
               
               Point3DBox[{2, 8, 8}]}}, {{
               RGBColor[
               0.5214058250424327, 0.42719084587598144`, 0.7049667542539244], 
               
               Point3DBox[{2, 8, 9}]}}, {{
               RGBColor[
               0.8151320345601667, 0.688591166193492, 0.1549401668116046], 
               Point3DBox[{2, 8, 10}]}}}, {{{
               RGBColor[
               0.14553503721796002`, 0.5553462001001337, 0.2786282613988502], 
               
               Point3DBox[{2, 9, 1}]}}, {{
               RGBColor[
               0.813884257173662, 0.37442959357683003`, 0.6222839901407158], 
               Point3DBox[{2, 9, 2}]}}, {{
               RGBColor[
               0.38900586325340236`, 0.4758475949160541, 0.1970460459528809], 
               
               Point3DBox[{2, 9, 3}]}}, {{
               RGBColor[
               0.9588365247498218, 0.6797113143704359, 0.9378170746549608], 
               Point3DBox[{2, 9, 4}]}}, {{
               RGBColor[
               0.9761167228996661, 0.4739384729918814, 0.3906434945116388], 
               Point3DBox[{2, 9, 5}]}}, {{
               RGBColor[
               0.239711874284686, 0.8130901486568787, 0.5569856293889917], 
               Point3DBox[{2, 9, 6}]}}, {{
               RGBColor[
               0.5630682324828664, 0.19412963879191358`, 0.5007644043244159], 
               
               Point3DBox[{2, 9, 7}]}}, {{
               RGBColor[
               0.6679200109581425, 0.8798106736794675, 0.7522716782733783], 
               Point3DBox[{2, 9, 8}]}}, {{
               RGBColor[
               0.11004136878729609`, 0.4531395827837206, 0.508880454330034], 
               Point3DBox[{2, 9, 9}]}}, {{
               RGBColor[
               0.3530008431315057, 0.7881325064229014, 0.11889738511712422`], 
               
               Point3DBox[{2, 9, 10}]}}}, {{{
               RGBColor[
               0.03084708810315484, 0.42349878412444997`, 0.6446461701506934], 
               Point3DBox[{2, 10, 1}]}}, {{
               RGBColor[
               0.3950339652807777, 0.07926255190823506, 0.23802101799514697`], 
               Point3DBox[{2, 10, 2}]}}, {{
               RGBColor[
               0.5561260868154547, 0.08089077871022399, 0.790331715579754], 
               Point3DBox[{2, 10, 3}]}}, {{
               RGBColor[
               0.19939754936192666`, 0.48068417684936193`, 
                0.5765204373031354], 
               Point3DBox[{2, 10, 4}]}}, {{
               RGBColor[
               0.43856671391714963`, 0.9895040255985479, 
                0.40851301757795677`], 
               Point3DBox[{2, 10, 5}]}}, {{
               RGBColor[
               0.6991093089290117, 0.2947006385981241, 0.7682585445499011], 
               Point3DBox[{2, 10, 6}]}}, {{
               RGBColor[
               0.5025241003944101, 0.8400536050689196, 0.2883806724188389], 
               Point3DBox[{2, 10, 7}]}}, {{
               RGBColor[
               0.8621725015423463, 0.3047885263329322, 0.5665658925997801], 
               Point3DBox[{2, 10, 8}]}}, {{
               RGBColor[
               0.17201001971935703`, 0.30321115683419975`, 
                0.4194914881044116], 
               Point3DBox[{2, 10, 9}]}}, {{
               RGBColor[
               0.522850856612487, 0.5285334422384493, 0.17405340375274503`], 
               Point3DBox[{2, 10, 10}]}}}}, {{{{
               RGBColor[
               0.6519115795429848, 0.09452541434896644, 0.24224170928420152`], 
               Point3DBox[{3, 1, 1}]}}, {{
               RGBColor[
               0.2707658375535227, 0.5049515344686044, 0.9807405434277727], 
               Point3DBox[{3, 1, 2}]}}, {{
               RGBColor[
               0.2767788323692737, 0.46358932991714275`, 0.08839968860894865], 
               Point3DBox[{3, 1, 3}]}}, {{
               RGBColor[
               0.046682457191454585`, 0.8708007702758203, 0.781335190609378], 
               
               Point3DBox[{3, 1, 4}]}}, {{
               RGBColor[
               0.6073908113736741, 0.024791005341595618`, 
                0.06087496686943572], 
               Point3DBox[{3, 1, 5}]}}, {{
               RGBColor[
               0.5145145068557113, 0.060471444327363066`, 
                0.17641518654242794`], 
               Point3DBox[{3, 1, 6}]}}, {{
               RGBColor[
               0.722362987197174, 0.5105064405376802, 0.4534961629715555], 
               Point3DBox[{3, 1, 7}]}}, {{
               RGBColor[
               0.8774709116072004, 0.05660126212767147, 0.6424629030223126], 
               Point3DBox[{3, 1, 8}]}}, {{
               RGBColor[
               0.2250738214189112, 0.6681875953154777, 0.4023995116941994], 
               Point3DBox[{3, 1, 9}]}}, {{
               RGBColor[
               0.5337341703219214, 0.15187694668374463`, 0.9653301665402896], 
               
               Point3DBox[{3, 1, 10}]}}}, {{{
               RGBColor[
               0.5372344239682325, 0.45095435679134166`, 
                0.32830757005897615`], 
               Point3DBox[{3, 2, 1}]}}, {{
               RGBColor[
               0.15484508844190437`, 0.35892662184136537`, 
                0.4086965543757697], 
               Point3DBox[{3, 2, 2}]}}, {{
               RGBColor[
               0.0604716819728468, 0.9015223700287118, 0.9517312397432458], 
               Point3DBox[{3, 2, 3}]}}, {{
               RGBColor[
               0.2354909493605284, 0.30332351969508675`, 
                0.048805868968567756`], 
               Point3DBox[{3, 2, 4}]}}, {{
               RGBColor[
               0.9296492456499417, 0.5420806777692997, 0.030814220363015066`], 
               Point3DBox[{3, 2, 5}]}}, {{
               RGBColor[
               0.1655070571639523, 0.7537902862447576, 0.05201120875921039], 
               Point3DBox[{3, 2, 6}]}}, {{
               RGBColor[
               0.8829341891989533, 0.2841970245803418, 0.49805003825223526`], 
               
               Point3DBox[{3, 2, 7}]}}, {{
               RGBColor[
               0.9832831497939432, 0.4904994779647416, 0.7862666728449401], 
               Point3DBox[{3, 2, 8}]}}, {{
               RGBColor[
               0.7936673564286665, 0.4645697150341095, 0.8955989091294629], 
               Point3DBox[{3, 2, 9}]}}, {{
               RGBColor[
               0.6749397852127184, 0.45083897536957207`, 
                0.16060723387421838`], 
               Point3DBox[{3, 2, 10}]}}}, {{{
               RGBColor[
               0.45892816013786275`, 0.19885198436934037`, 
                0.5294015688264129], 
               Point3DBox[{3, 3, 1}]}}, {{
               RGBColor[
               0.9344061232688188, 0.3593528253059346, 0.8808720347693753], 
               Point3DBox[{3, 3, 2}]}}, {{
               RGBColor[
               0.4812086215126343, 0.9885054190311164, 0.6690953028435482], 
               Point3DBox[{3, 3, 3}]}}, {{
               RGBColor[
               0.23071741141557256`, 0.5596739504595716, 
                0.49581056073069996`], 
               Point3DBox[{3, 3, 4}]}}, {{
               RGBColor[
               0.3926758795308567, 0.4616722720231303, 0.7631533495818219], 
               Point3DBox[{3, 3, 5}]}}, {{
               RGBColor[
               0.8557097569613576, 0.4311045613577571, 0.6236520346534691], 
               Point3DBox[{3, 3, 6}]}}, {{
               RGBColor[
               0.7942766541140607, 0.4999768873473849, 0.6958326680424332], 
               Point3DBox[{3, 3, 7}]}}, {{
               RGBColor[
               0.28223503234979885`, 0.00625875973194745, 0.6354540699637501], 
               Point3DBox[{3, 3, 8}]}}, {{
               RGBColor[
               0.9598507653463222, 0.2708753973838349, 0.25015901564769294`], 
               
               Point3DBox[{3, 3, 9}]}}, {{
               RGBColor[
               0.8315012264866275, 0.8100476499838343, 0.27342504136474344`], 
               
               Point3DBox[{3, 3, 10}]}}}, {{{
               RGBColor[
               0.825732410267688, 0.6050835619550952, 0.8884965343613893], 
               Point3DBox[{3, 4, 1}]}}, {{
               RGBColor[
               0.7105319155741412, 0.7044891453152486, 0.5371557458108476], 
               Point3DBox[{3, 4, 2}]}}, {{
               RGBColor[
               0.9858977499893136, 0.052636643100376634`, 0.4090947394174962], 
               Point3DBox[{3, 4, 3}]}}, {{
               RGBColor[
               0.7142077040263259, 0.913509468050268, 0.07696035114027344], 
               Point3DBox[{3, 4, 4}]}}, {{
               RGBColor[
               0.9309331463556598, 0.1789642234333919, 0.40900774883159974`], 
               
               Point3DBox[{3, 4, 5}]}}, {{
               RGBColor[
               0.28892932786124303`, 0.9696854812058995, 0.05224360204529388], 
               Point3DBox[{3, 4, 6}]}}, {{
               RGBColor[
               0.7360102078786432, 0.11102687994281935`, 0.9995951377796077], 
               
               Point3DBox[{3, 4, 7}]}}, {{
               RGBColor[
               0.2687025180203224, 0.8430267188876768, 0.2971990456798945], 
               Point3DBox[{3, 4, 8}]}}, {{
               RGBColor[
               0.3754283713362603, 0.5121372777713957, 0.3568931601473011], 
               Point3DBox[{3, 4, 9}]}}, {{
               RGBColor[
               0.7459092133536758, 0.3769337017551302, 0.7001407519867302], 
               Point3DBox[{3, 4, 10}]}}}, {{{
               RGBColor[
               0.6174001683605694, 0.6160172679749127, 0.7090452433482421], 
               Point3DBox[{3, 5, 1}]}}, {{
               RGBColor[
               0.44456545637895073`, 0.7923407907647488, 
                0.0029876511505730896`], 
               Point3DBox[{3, 5, 2}]}}, {{
               RGBColor[
               0.7598544144708752, 0.9880352515627635, 0.9836142119176463], 
               Point3DBox[{3, 5, 3}]}}, {{
               RGBColor[
               0.800269345660142, 0.9165440880779214, 0.3345655370283409], 
               Point3DBox[{3, 5, 4}]}}, {{
               RGBColor[
               0.15004482510673944`, 0.8563141812182926, 0.7538481812404338], 
               
               Point3DBox[{3, 5, 5}]}}, {{
               RGBColor[
               0.13617534499018746`, 0.20098700196172037`, 0.655278427287548], 
               Point3DBox[{3, 5, 6}]}}, {{
               RGBColor[
               0.7141716784414915, 0.8757909054167783, 0.6981731483468352], 
               Point3DBox[{3, 5, 7}]}}, {{
               RGBColor[
               0.24562451768519722`, 0.400169855214191, 0.06081233560346311], 
               
               Point3DBox[{3, 5, 8}]}}, {{
               RGBColor[
               0.47347302135989744`, 0.5510245128764106, 0.2230286228182463], 
               
               Point3DBox[{3, 5, 9}]}}, {{
               RGBColor[
               0.005916973205077669, 0.614593517055283, 0.9975643033437915], 
               Point3DBox[{3, 5, 10}]}}}, {{{
               RGBColor[
               0.4977933432474051, 0.34974236667194725`, 0.7579210680208397], 
               
               Point3DBox[{3, 6, 1}]}}, {{
               RGBColor[
               0.017981314735465936`, 0.12960860605717772`, 
                0.9928154346677358], 
               Point3DBox[{3, 6, 2}]}}, {{
               RGBColor[
               0.3100630001225979, 0.35721846855801975`, 0.8159816298170024], 
               
               Point3DBox[{3, 6, 3}]}}, {{
               RGBColor[
               0.15277374936816202`, 0.18260039460878152`, 0.63886966516932], 
               
               Point3DBox[{3, 6, 4}]}}, {{
               RGBColor[
               0.18615370657670138`, 0.5675117028213483, 
                0.12682713397745915`], 
               Point3DBox[{3, 6, 5}]}}, {{
               RGBColor[
               0.8852900218797655, 0.8888342683573023, 0.7130667627859841], 
               Point3DBox[{3, 6, 6}]}}, {{
               RGBColor[
               0.8044569618451123, 0.43556925111084355`, 0.6124272442294194], 
               
               Point3DBox[{3, 6, 7}]}}, {{
               RGBColor[
               0.7851667992211944, 0.9033860527889148, 0.0850234030027115], 
               Point3DBox[{3, 6, 8}]}}, {{
               RGBColor[
               0.5851968434083117, 0.7664103538560201, 0.600972691565089], 
               Point3DBox[{3, 6, 9}]}}, {{
               RGBColor[
               0.3846355434265065, 0.10173726165508712`, 0.6672537166403423], 
               
               Point3DBox[{3, 6, 10}]}}}, {{{
               RGBColor[
               0.985916482309998, 0.24292219390772885`, 0.05528529488264011], 
               
               Point3DBox[{3, 7, 1}]}}, {{
               RGBColor[
               0.11868618914163043`, 0.7243248972310019, 
                0.018329545265127978`], 
               Point3DBox[{3, 7, 2}]}}, {{
               RGBColor[
               0.562337801662163, 0.15516159535192253`, 0.689292473026913], 
               Point3DBox[{3, 7, 3}]}}, {{
               RGBColor[
               0.19496418482846178`, 0.736819916531551, 0.7424527292374248], 
               Point3DBox[{3, 7, 4}]}}, {{
               RGBColor[
               0.5191170634394158, 0.4142340891633385, 0.2809949512621097], 
               Point3DBox[{3, 7, 5}]}}, {{
               RGBColor[
               0.20984519530484502`, 0.7130599166131537, 
                0.25574927896223065`], 
               Point3DBox[{3, 7, 6}]}}, {{
               RGBColor[
               0.0362596031057405, 0.008280859303067212, 0.4184101157418758], 
               
               Point3DBox[{3, 7, 7}]}}, {{
               RGBColor[
               0.07546885363133016, 0.958045126897928, 0.24625953661047628`], 
               
               Point3DBox[{3, 7, 8}]}}, {{
               RGBColor[
               0.9467913561638406, 0.20712674297949096`, 
                0.36304232728674113`], 
               Point3DBox[{3, 7, 9}]}}, {{
               RGBColor[
               0.4682299905256717, 0.20554112789598555`, 0.6545670636794529], 
               
               Point3DBox[{3, 7, 10}]}}}, {{{
               RGBColor[
               0.19757216675963551`, 0.1336754384979526, 
                0.36698370005787373`], 
               Point3DBox[{3, 8, 1}]}}, {{
               RGBColor[
               0.8377842314578177, 0.5942571890894921, 0.6308752683473549], 
               Point3DBox[{3, 8, 2}]}}, {{
               RGBColor[
               0.08144707764897019, 0.5317205342709799, 0.741303024088058], 
               Point3DBox[{3, 8, 3}]}}, {{
               RGBColor[
               0.7456535398639395, 0.34388310447747505`, 
                0.15989690393101208`], 
               Point3DBox[{3, 8, 4}]}}, {{
               RGBColor[
               0.9191495017326103, 0.4148766961856787, 0.7354619546203418], 
               Point3DBox[{3, 8, 5}]}}, {{
               RGBColor[
               0.7923022828074391, 0.6833852243613332, 0.4808621204076844], 
               Point3DBox[{3, 8, 6}]}}, {{
               RGBColor[
               0.3531710340260221, 0.5651674802830517, 0.406838432850984], 
               Point3DBox[{3, 8, 7}]}}, {{
               RGBColor[
               0.7819750028442092, 0.8990963579080937, 0.43935795682001233`], 
               
               Point3DBox[{3, 8, 8}]}}, {{
               RGBColor[
               0.01523511750301787, 0.9359121850835359, 0.8922927402652918], 
               Point3DBox[{3, 8, 9}]}}, {{
               RGBColor[
               0.6967387376494758, 0.9178095410581009, 0.49549331472697666`], 
               
               Point3DBox[{3, 8, 10}]}}}, {{{
               RGBColor[
               0.3250431499685451, 0.5654460341092578, 0.514972704763708], 
               Point3DBox[{3, 9, 1}]}}, {{
               RGBColor[
               0.5004768741654528, 0.9193361935781974, 0.9764238052740888], 
               Point3DBox[{3, 9, 2}]}}, {{
               RGBColor[
               0.9384039136569895, 0.7259743184822123, 0.4562449007793732], 
               Point3DBox[{3, 9, 3}]}}, {{
               RGBColor[
               0.25673922035949337`, 0.1847760263163818, 0.6709899805540052], 
               
               Point3DBox[{3, 9, 4}]}}, {{
               RGBColor[
               0.342308397032836, 0.2877554471036503, 0.35259991347465025`], 
               Point3DBox[{3, 9, 5}]}}, {{
               RGBColor[
               0.9827087350497903, 0.008823920285799147, 0.4094336211182139], 
               
               Point3DBox[{3, 9, 6}]}}, {{
               RGBColor[
               0.219295631463166, 0.4235281452702717, 0.8187211389376405], 
               Point3DBox[{3, 9, 7}]}}, {{
               RGBColor[
               0.8986741252468842, 0.5771210691112634, 0.17401383353172029`], 
               
               Point3DBox[{3, 9, 8}]}}, {{
               RGBColor[
               0.37843221421054674`, 0.36970328596091795`, 
                0.08934811767221729], 
               Point3DBox[{3, 9, 9}]}}, {{
               RGBColor[
               0.8604387714030131, 0.6394057598471259, 0.5748958619786291], 
               Point3DBox[{3, 9, 10}]}}}, {{{
               RGBColor[
               0.6405460716877869, 0.6201911500106594, 0.5044890331876097], 
               Point3DBox[{3, 10, 1}]}}, {{
               RGBColor[
               0.5989657445750585, 0.399285022710552, 0.5939898062123543], 
               Point3DBox[{3, 10, 2}]}}, {{
               RGBColor[
               0.8757717709528867, 0.6612519254503024, 0.1263567759990456], 
               Point3DBox[{3, 10, 3}]}}, {{
               RGBColor[
               0.5298531085498268, 0.8346299051453392, 0.3346423535530012], 
               Point3DBox[{3, 10, 4}]}}, {{
               RGBColor[
               0.7623013008935484, 0.22975943601642612`, 0.5620010201495775], 
               
               Point3DBox[{3, 10, 5}]}}, {{
               RGBColor[
               0.3679528991003824, 0.6993807350978773, 0.529509035009937], 
               Point3DBox[{3, 10, 6}]}}, {{
               RGBColor[
               0.4873132833141707, 0.04341149876150774, 0.14455971618599572`], 
               Point3DBox[{3, 10, 7}]}}, {{
               RGBColor[
               0.14998337718312627`, 0.9351161675406732, 0.6541036422483271], 
               
               Point3DBox[{3, 10, 8}]}}, {{
               RGBColor[
               0.2868221044767545, 0.6289041375403368, 0.5192677070318457], 
               Point3DBox[{3, 10, 9}]}}, {{
               RGBColor[
               0.6230252638404363, 0.6759791969456295, 0.296403460638885], 
               Point3DBox[{3, 10, 10}]}}}}, {{{{
               RGBColor[
               0.1076974850108765, 0.6544579160850197, 0.3500634151901847], 
               Point3DBox[{4, 1, 1}]}}, {{
               RGBColor[
               0.17395278911242884`, 0.33025509470554115`, 0.622158932808299], 
               Point3DBox[{4, 1, 2}]}}, {{
               RGBColor[
               0.944033189908559, 0.8796516964161931, 0.7934162488028458], 
               Point3DBox[{4, 1, 3}]}}, {{
               RGBColor[
               0.09074795696617999, 0.017637460073064437`, 0.710027675853041], 
               Point3DBox[{4, 1, 4}]}}, {{
               RGBColor[
               0.17355278392772822`, 0.06257218801144715, 
                0.14549210544009994`], 
               Point3DBox[{4, 1, 5}]}}, {{
               RGBColor[
               0.8296994786907446, 0.7544836462554099, 0.40598704623935045`], 
               
               Point3DBox[{4, 1, 6}]}}, {{
               RGBColor[
               0.9003267099455685, 0.3075233231951051, 0.25516723626099647`], 
               
               Point3DBox[{4, 1, 7}]}}, {{
               RGBColor[
               0.7759128470495438, 0.9934419116873212, 0.6048904930390233], 
               Point3DBox[{4, 1, 8}]}}, {{
               RGBColor[
               0.5918988976467656, 0.40075109800261566`, 
                0.054062064016884515`], 
               Point3DBox[{4, 1, 9}]}}, {{
               RGBColor[
               0.8049187176305241, 0.028944403092504345`, 0.5662196043253414], 
               Point3DBox[{4, 1, 10}]}}}, {{{
               RGBColor[
               0.5327103955665784, 0.46682645229349884`, 
                0.31385581414010577`], 
               Point3DBox[{4, 2, 1}]}}, {{
               RGBColor[
               0.9989980162946859, 0.6908914868706679, 0.3657705861175018], 
               Point3DBox[{4, 2, 2}]}}, {{
               RGBColor[
               0.3525259926888893, 0.5283329675925272, 0.8429349943904929], 
               Point3DBox[{4, 2, 3}]}}, {{
               RGBColor[
               0.07020250621479196, 0.0031987658643974903`, 
                0.8212303981025835], 
               Point3DBox[{4, 2, 4}]}}, {{
               RGBColor[
               0.8353275018423172, 0.04986417436764645, 0.0683727114583399], 
               Point3DBox[{4, 2, 5}]}}, {{
               RGBColor[
               0.7762098114166927, 0.148655370220802, 0.10088168437698353`], 
               Point3DBox[{4, 2, 6}]}}, {{
               RGBColor[
               0.3998079874984193, 0.9791462393810353, 0.7488965018226936], 
               Point3DBox[{4, 2, 7}]}}, {{
               RGBColor[
               0.21980890764599414`, 0.7513885631200172, 0.8650850744631655], 
               
               Point3DBox[{4, 2, 8}]}}, {{
               RGBColor[
               0.4008940326302308, 0.9919645905707106, 0.8190441353886933], 
               Point3DBox[{4, 2, 9}]}}, {{
               RGBColor[
               0.6274769361440329, 0.5018555781532932, 0.8641143503780879], 
               Point3DBox[{4, 2, 10}]}}}, {{{
               RGBColor[
               0.13593282105031168`, 0.1337337409309971, 0.5983765722877894], 
               
               Point3DBox[{4, 3, 1}]}}, {{
               RGBColor[
               0.3587334472687749, 0.988575851395407, 0.9147852585117069], 
               Point3DBox[{4, 3, 2}]}}, {{
               RGBColor[
               0.27531448105238, 0.7270904521247554, 0.6966738672691837], 
               Point3DBox[{4, 3, 3}]}}, {{
               RGBColor[
               0.2612119572794005, 0.8738124441085939, 0.2048829891773778], 
               Point3DBox[{4, 3, 4}]}}, {{
               RGBColor[
               0.6339551203041425, 0.06676348538663546, 0.48338879314827743`], 
               Point3DBox[{4, 3, 5}]}}, {{
               RGBColor[
               0.2443322448087637, 0.189513704782452, 0.715362221053718], 
               Point3DBox[{4, 3, 6}]}}, {{
               RGBColor[
               0.07005927842166093, 0.1295922589586782, 0.3631373219843441], 
               Point3DBox[{4, 3, 7}]}}, {{
               RGBColor[
               0.024849809700978165`, 0.6663845203868388, 0.7130962984797187], 
               Point3DBox[{4, 3, 8}]}}, {{
               RGBColor[
               0.24641884708462602`, 0.6033969188375015, 
                0.19603574346811592`], 
               Point3DBox[{4, 3, 9}]}}, {{
               RGBColor[
               0.3653979875189033, 0.4920496346912102, 0.5970376242078936], 
               Point3DBox[{4, 3, 10}]}}}, {{{
               RGBColor[
               0.3830878852586441, 0.5660754003582502, 0.1411186927939898], 
               Point3DBox[{4, 4, 1}]}}, {{
               RGBColor[
               0.6750323185055067, 0.014486409340938033`, 0.662364830165034], 
               
               Point3DBox[{4, 4, 2}]}}, {{
               RGBColor[
               0.6320085459306919, 0.1784067528603468, 0.8375382168446774], 
               Point3DBox[{4, 4, 3}]}}, {{
               RGBColor[
               0.20211241309915762`, 0.5438816773011044, 
                0.15485838509525673`], 
               Point3DBox[{4, 4, 4}]}}, {{
               RGBColor[
               0.6871919778743552, 0.0692392233107737, 0.38353738301182405`], 
               
               Point3DBox[{4, 4, 5}]}}, {{
               RGBColor[
               0.22096599906221281`, 0.14906017910574465`, 
                0.5524163407807121], 
               Point3DBox[{4, 4, 6}]}}, {{
               RGBColor[
               0.44235081145832544`, 0.7412398149759625, 0.9059816957443898], 
               
               Point3DBox[{4, 4, 7}]}}, {{
               RGBColor[
               0.3051789946780388, 0.8916701362361825, 0.23398499573218667`], 
               
               Point3DBox[{4, 4, 8}]}}, {{
               RGBColor[
               0.7555764442249528, 0.7570052280591353, 0.7088681826743239], 
               Point3DBox[{4, 4, 9}]}}, {{
               RGBColor[
               0.7239280375851036, 0.5328022723824914, 0.27909346134823454`], 
               
               Point3DBox[{4, 4, 10}]}}}, {{{
               RGBColor[
               0.6673883773697706, 0.7150575787756897, 0.1963018880274412], 
               Point3DBox[{4, 5, 1}]}}, {{
               RGBColor[
               0.5543756424703885, 0.33184057475469864`, 0.0562168238820564], 
               
               Point3DBox[{4, 5, 2}]}}, {{
               RGBColor[
               0.24609564498070546`, 0.6805981688919738, 0.5230451271278924], 
               
               Point3DBox[{4, 5, 3}]}}, {{
               RGBColor[
               0.9627110738141018, 0.7194318713839047, 0.9213320878515163], 
               Point3DBox[{4, 5, 4}]}}, {{
               RGBColor[
               0.2481951358536385, 0.29424000848000986`, 0.7959248037089115], 
               
               Point3DBox[{4, 5, 5}]}}, {{
               RGBColor[
               0.4305707908919303, 0.8975864554756214, 0.1473311418475527], 
               Point3DBox[{4, 5, 6}]}}, {{
               RGBColor[
               0.4570580326945981, 0.9482045437250792, 0.5603557753844419], 
               Point3DBox[{4, 5, 7}]}}, {{
               RGBColor[
               0.237112222205778, 0.10270365879566956`, 0.8428857083831505], 
               Point3DBox[{4, 5, 8}]}}, {{
               RGBColor[
               0.34062797293749236`, 0.30576020797800374`, 
                0.2975219148279644], 
               Point3DBox[{4, 5, 9}]}}, {{
               RGBColor[
               0.7995615635832434, 0.13372892454436003`, 0.6036541019181558], 
               
               Point3DBox[{4, 5, 10}]}}}, {{{
               RGBColor[
               0.9341742919914091, 0.35339443532298764`, 0.3996235141874964], 
               
               Point3DBox[{4, 6, 1}]}}, {{
               RGBColor[
               0.6791727429506427, 0.7524420144866346, 0.44856727335701607`], 
               
               Point3DBox[{4, 6, 2}]}}, {{
               RGBColor[
               0.6270621449927827, 0.3488165751640129, 0.40737774059438236`], 
               
               Point3DBox[{4, 6, 3}]}}, {{
               RGBColor[
               0.07122027029951616, 0.0040456786810865175`, 
                0.5771105596536572], 
               Point3DBox[{4, 6, 4}]}}, {{
               RGBColor[
               0.9136738279081951, 0.299468331352444, 0.7460933074701899], 
               Point3DBox[{4, 6, 5}]}}, {{
               RGBColor[
               0.6749564735115936, 0.11587197415588468`, 0.8899205852281207], 
               
               Point3DBox[{4, 6, 6}]}}, {{
               RGBColor[
               0.03670819997912522, 0.6565433654586197, 0.3741360211019995], 
               Point3DBox[{4, 6, 7}]}}, {{
               RGBColor[
               0.7062962326781481, 0.938191300132613, 0.5525575854419285], 
               Point3DBox[{4, 6, 8}]}}, {{
               RGBColor[
               0.01887139597173748, 0.6069720528777345, 0.5678964592286888], 
               Point3DBox[{4, 6, 9}]}}, {{
               RGBColor[
               0.4931171691554317, 0.996186237833268, 0.6628116239526436], 
               Point3DBox[{4, 6, 10}]}}}, {{{
               RGBColor[
               0.9477412584064888, 0.8450878991808213, 0.13934453345401598`], 
               
               Point3DBox[{4, 7, 1}]}}, {{
               RGBColor[
               0.926696049751943, 0.5325606662678464, 0.7392125561110372], 
               Point3DBox[{4, 7, 2}]}}, {{
               RGBColor[
               0.2350958258934419, 0.19711885505285154`, 0.4518059813770374], 
               
               Point3DBox[{4, 7, 3}]}}, {{
               RGBColor[
               0.654003891907021, 0.08383544222684525, 0.4658895495179074], 
               Point3DBox[{4, 7, 4}]}}, {{
               RGBColor[
               0.4580238922415931, 0.9402518503615243, 0.5051119365744585], 
               Point3DBox[{4, 7, 5}]}}, {{
               RGBColor[
               0.5445105645174639, 0.20122927254417067`, 0.538426089066794], 
               Point3DBox[{4, 7, 6}]}}, {{
               RGBColor[
               0.7880424232827592, 0.08359901118560265, 0.3882262811750987], 
               Point3DBox[{4, 7, 7}]}}, {{
               RGBColor[
               0.8458739875933514, 0.38866857166057844`, 0.9685263277526202], 
               
               Point3DBox[{4, 7, 8}]}}, {{
               RGBColor[
               0.32830898028533206`, 0.0575663045016539, 0.2573006355585341], 
               
               Point3DBox[{4, 7, 9}]}}, {{
               RGBColor[
               0.8912335345187907, 0.7068489379069756, 0.8406533095366666], 
               Point3DBox[{4, 7, 10}]}}}, {{{
               RGBColor[
               0.08241297901908129, 0.21588068982711306`, 0.4112827305029587], 
               Point3DBox[{4, 8, 1}]}}, {{
               RGBColor[
               0.3220108718060828, 0.17950018546146085`, 
                0.24217579018900115`], 
               Point3DBox[{4, 8, 2}]}}, {{
               RGBColor[
               0.3383562520538508, 0.7449148433723936, 0.21043252012565516`], 
               
               Point3DBox[{4, 8, 3}]}}, {{
               RGBColor[
               0.6038766012742227, 0.7521110243001952, 0.2364377492069485], 
               Point3DBox[{4, 8, 4}]}}, {{
               RGBColor[
               0.16981731958476676`, 0.8763042098654072, 0.5278958648994758], 
               
               Point3DBox[{4, 8, 5}]}}, {{
               RGBColor[
               0.8402657600225814, 0.9629637246709246, 0.6091229901979436], 
               Point3DBox[{4, 8, 6}]}}, {{
               RGBColor[
               0.5361644260509879, 0.9508643378724715, 0.46408906953211426`], 
               
               Point3DBox[{4, 8, 7}]}}, {{
               RGBColor[
               0.9271320630920685, 0.33580214772771244`, 0.7486527951735884], 
               
               Point3DBox[{4, 8, 8}]}}, {{
               RGBColor[
               0.7320116781613031, 0.8111681969700613, 0.004758679042716318], 
               
               Point3DBox[{4, 8, 9}]}}, {{
               RGBColor[
               0.5836161406335534, 0.8650165134431975, 0.3369288953434497], 
               Point3DBox[{4, 8, 10}]}}}, {{{
               RGBColor[
               0.8404863364509305, 0.5932423760167194, 0.13534761393230532`], 
               
               Point3DBox[{4, 9, 1}]}}, {{
               RGBColor[
               0.9847649786251751, 0.5169822325431728, 0.7379403645418503], 
               Point3DBox[{4, 9, 2}]}}, {{
               RGBColor[
               0.3938657221646513, 0.36145151201079484`, 0.1648998901381149], 
               
               Point3DBox[{4, 9, 3}]}}, {{
               RGBColor[
               0.6494104432604297, 0.8612863596737295, 0.42427569055342684`], 
               
               Point3DBox[{4, 9, 4}]}}, {{
               RGBColor[
               0.1206778026176687, 0.6126955566813019, 0.3045682619076322], 
               Point3DBox[{4, 9, 5}]}}, {{
               RGBColor[
               0.8705880473006016, 0.5872703846412102, 0.9838763511012698], 
               Point3DBox[{4, 9, 6}]}}, {{
               RGBColor[
               0.5102236334469983, 0.5258278659280393, 0.7868018744297336], 
               Point3DBox[{4, 9, 7}]}}, {{
               RGBColor[
               0.553995052064512, 0.27953405366295336`, 0.13085631388701557`], 
               Point3DBox[{4, 9, 8}]}}, {{
               RGBColor[
               0.6885131459394427, 0.7235248817557449, 0.7647682206763531], 
               Point3DBox[{4, 9, 9}]}}, {{
               RGBColor[
               0.4416845238659961, 0.22883662037205332`, 0.9266871800257599], 
               
               Point3DBox[{4, 9, 10}]}}}, {{{
               RGBColor[
               0.848544816209299, 0.702833089502455, 0.4640686465360897], 
               Point3DBox[{4, 10, 1}]}}, {{
               RGBColor[
               0.9934194583660105, 0.07425379005532706, 0.7560510896565802], 
               Point3DBox[{4, 10, 2}]}}, {{
               RGBColor[
               0.9346613912652206, 0.7492989136605721, 0.146718273271214], 
               Point3DBox[{4, 10, 3}]}}, {{
               RGBColor[
               0.33192359298318874`, 0.7388461630924297, 0.8713507463491905], 
               
               Point3DBox[{4, 10, 4}]}}, {{
               RGBColor[
               0.7775206058538819, 0.14873824437231775`, 0.9291461438461313], 
               
               Point3DBox[{4, 10, 5}]}}, {{
               RGBColor[
               0.09758063554652208, 0.917582652731354, 0.5389095606616854], 
               Point3DBox[{4, 10, 6}]}}, {{
               RGBColor[
               0.12090988382113843`, 0.9442839575520583, 0.5981682111559956], 
               
               Point3DBox[{4, 10, 7}]}}, {{
               RGBColor[
               0.23764955509077734`, 0.29066687568855687`, 
                0.46900548770104256`], 
               Point3DBox[{4, 10, 8}]}}, {{
               RGBColor[
               0.9704207968853222, 0.21173941042015443`, 
                0.41855889850062633`], 
               Point3DBox[{4, 10, 9}]}}, {{
               RGBColor[
               0.009206990136912063, 0.006839064621932289, 
                0.1207039770525904], 
               Point3DBox[{4, 10, 10}]}}}}, {{{{
               RGBColor[
               0.9447344990929307, 0.7039380210093842, 0.5886276870226528], 
               Point3DBox[{5, 1, 1}]}}, {{
               RGBColor[
               0.440975289918627, 0.8175348630459849, 0.9004257235701478], 
               Point3DBox[{5, 1, 2}]}}, {{
               RGBColor[
               0.016161394555104902`, 0.0012932172300081923`, 
                0.221373515827056], 
               Point3DBox[{5, 1, 3}]}}, {{
               RGBColor[
               0.24223871275503872`, 0.23924686244036764`, 
                0.20125541204402309`], 
               Point3DBox[{5, 1, 4}]}}, {{
               RGBColor[
               0.36769358091886617`, 0.6615124595661022, 0.9676859864762049], 
               
               Point3DBox[{5, 1, 5}]}}, {{
               RGBColor[
               0.8501719124156011, 0.34329391045450897`, 0.5082219895893787], 
               
               Point3DBox[{5, 1, 6}]}}, {{
               RGBColor[
               0.3124644052264056, 0.6603538254128132, 0.8999369185652903], 
               Point3DBox[{5, 1, 7}]}}, {{
               RGBColor[
               0.5090194606962715, 0.619750733499616, 0.07087013094614791], 
               Point3DBox[{5, 1, 8}]}}, {{
               RGBColor[
               0.7075614077276027, 0.23419882203406805`, 0.2502364898638274], 
               
               Point3DBox[{5, 1, 9}]}}, {{
               RGBColor[
               0.6726108453865263, 0.8001184276993001, 0.6800751850373454], 
               Point3DBox[{5, 1, 10}]}}}, {{{
               RGBColor[
               0.68755735443024, 0.22426567182317192`, 0.6701763815312829], 
               Point3DBox[{5, 2, 1}]}}, {{
               RGBColor[
               0.43816718968931223`, 0.8982865046196751, 
                0.12448336690505557`], 
               Point3DBox[{5, 2, 2}]}}, {{
               RGBColor[
               0.04070018177010226, 0.6163101983254207, 0.7873843048125568], 
               Point3DBox[{5, 2, 3}]}}, {{
               RGBColor[
               0.6437525189868429, 0.9883123591869099, 0.9004602347276687], 
               Point3DBox[{5, 2, 4}]}}, {{
               RGBColor[
               0.7443822877073298, 0.5387736330970896, 0.018054554505675613`], 
               Point3DBox[{5, 2, 5}]}}, {{
               RGBColor[
               0.3104498486206362, 0.6230812741166629, 0.6229649583605237], 
               Point3DBox[{5, 2, 6}]}}, {{
               RGBColor[
               0.4266609340477501, 0.6810214223617452, 0.19534178969227933`], 
               
               Point3DBox[{5, 2, 7}]}}, {{
               RGBColor[
               0.3881080376366757, 0.4474007708845906, 0.5060256941422845], 
               Point3DBox[{5, 2, 8}]}}, {{
               RGBColor[
               0.9097266164725222, 0.6635273824844219, 0.19415793562103056`], 
               
               Point3DBox[{5, 2, 9}]}}, {{
               RGBColor[
               0.7981098570254943, 0.6676535490231377, 0.7425420038823973], 
               Point3DBox[{5, 2, 10}]}}}, {{{
               RGBColor[
               0.5111780436012172, 0.647600554837586, 0.8334636626736498], 
               Point3DBox[{5, 3, 1}]}}, {{
               RGBColor[
               0.004831861396863424, 0.056213689972136605`, 
                0.9824234566508969], 
               Point3DBox[{5, 3, 2}]}}, {{
               RGBColor[
               0.4998702078100423, 0.15067518767562071`, 0.0768084562622866], 
               
               Point3DBox[{5, 3, 3}]}}, {{
               RGBColor[
               0.5361509974677059, 0.3828430175335964, 0.7305373951298588], 
               Point3DBox[{5, 3, 4}]}}, {{
               RGBColor[
               0.3788053499490416, 0.9393048070312839, 0.2310166155874671], 
               Point3DBox[{5, 3, 5}]}}, {{
               RGBColor[
               0.9549063591458042, 0.9951718990864167, 0.7635990043850458], 
               Point3DBox[{5, 3, 6}]}}, {{
               RGBColor[
               0.6349478522301735, 0.06512950964059128, 0.10338787444766373`], 
               Point3DBox[{5, 3, 7}]}}, {{
               RGBColor[
               0.5308597410339577, 0.8996807936167601, 0.7919136399605307], 
               Point3DBox[{5, 3, 8}]}}, {{
               RGBColor[
               0.5393713085432863, 0.9568820891338121, 0.49392569134235], 
               Point3DBox[{5, 3, 9}]}}, {{
               RGBColor[
               0.8512612218976363, 0.4942674318423186, 0.21133689381728837`], 
               
               Point3DBox[{5, 3, 10}]}}}, {{{
               RGBColor[
               0.10340338542574701`, 0.4568831850175554, 0.2399026894635765], 
               
               Point3DBox[{5, 4, 1}]}}, {{
               RGBColor[
               0.6953438023268266, 0.8386862652298479, 0.940296974855743], 
               Point3DBox[{5, 4, 2}]}}, {{
               RGBColor[
               0.8849034940749729, 0.0491903763564443, 0.3046364121126759], 
               Point3DBox[{5, 4, 3}]}}, {{
               RGBColor[
               0.7263772052685702, 0.5820797028077018, 0.4330475608239941], 
               Point3DBox[{5, 4, 4}]}}, {{
               RGBColor[
               0.5780408011215414, 0.7191434784924671, 0.9628732837760003], 
               Point3DBox[{5, 4, 5}]}}, {{
               RGBColor[
               0.8530237564734011, 0.3869431678551525, 0.9075783934915069], 
               Point3DBox[{5, 4, 6}]}}, {{
               RGBColor[
               0.3248867749167188, 0.20672786358049722`, 
                0.27874298241460926`], 
               Point3DBox[{5, 4, 7}]}}, {{
               RGBColor[
               0.4947960964620528, 0.20555240041754197`, 0.4512309227005009], 
               
               Point3DBox[{5, 4, 8}]}}, {{
               RGBColor[
               0.21225860060720803`, 0.9785198134177795, 0.7617651463426334], 
               
               Point3DBox[{5, 4, 9}]}}, {{
               RGBColor[
               0.3070488896997319, 0.623657663723949, 0.8409280369109751], 
               Point3DBox[{5, 4, 10}]}}}, {{{
               RGBColor[
               0.3881100436585534, 0.7708623931733238, 0.6613874093575045], 
               Point3DBox[{5, 5, 1}]}}, {{
               RGBColor[
               0.3130637923446944, 0.4214794110022473, 0.391040806521439], 
               Point3DBox[{5, 5, 2}]}}, {{
               RGBColor[
               0.06482143002021945, 0.320970143045886, 0.5431044694727936], 
               Point3DBox[{5, 5, 3}]}}, {{
               RGBColor[
               0.7425115196881911, 0.9462185254809621, 0.6099677335454075], 
               Point3DBox[{5, 5, 4}]}}, {{
               RGBColor[
               0.38325365305579884`, 0.5313704761073763, 0.3890367601104283], 
               
               Point3DBox[{5, 5, 5}]}}, {{
               RGBColor[
               0.03752858558964234, 0.6834792935141423, 
                0.0019007142240967667`], 
               Point3DBox[{5, 5, 6}]}}, {{
               RGBColor[
               0.9204238923391879, 0.5771618484439873, 0.8138800996627822], 
               Point3DBox[{5, 5, 7}]}}, {{
               RGBColor[
               0.4646097846634085, 0.26534124765356126`, 
                0.19959236039351969`], 
               Point3DBox[{5, 5, 8}]}}, {{
               RGBColor[
               0.05234857859201636, 0.3751420986115124, 0.6315987918727568], 
               Point3DBox[{5, 5, 9}]}}, {{
               RGBColor[
               0.746649201415257, 0.4373037809356841, 0.35377884075570143`], 
               Point3DBox[{5, 5, 10}]}}}, {{{
               RGBColor[
               0.7551456915909553, 0.4527611686715374, 0.7795812360410337], 
               Point3DBox[{5, 6, 1}]}}, {{
               RGBColor[
               0.4298384232419259, 0.9843378306130677, 0.5608710030508401], 
               Point3DBox[{5, 6, 2}]}}, {{
               RGBColor[
               0.381632999518275, 0.8941649246164558, 0.049886245466883805`], 
               
               Point3DBox[{5, 6, 3}]}}, {{
               RGBColor[
               0.5094605102319967, 0.9159187666891464, 0.08014284765500923], 
               Point3DBox[{5, 6, 4}]}}, {{
               RGBColor[
               0.01414787091795433, 0.07278660655512437, 
                0.42213626195597564`], 
               Point3DBox[{5, 6, 5}]}}, {{
               RGBColor[
               0.7489720771974915, 0.5183629109277275, 0.4132834994622685], 
               Point3DBox[{5, 6, 6}]}}, {{
               RGBColor[
               0.3297659796371344, 0.37733865203588013`, 0.4607566259810547], 
               
               Point3DBox[{5, 6, 7}]}}, {{
               RGBColor[
               0.7807764321954613, 0.5082773575724733, 0.4540762396401985], 
               Point3DBox[{5, 6, 8}]}}, {{
               RGBColor[
               0.8234135367953523, 0.9094379737704643, 0.43623259591176455`], 
               
               Point3DBox[{5, 6, 9}]}}, {{
               RGBColor[
               0.1940701165571599, 0.37947966326450033`, 
                0.28313003483414634`], 
               Point3DBox[{5, 6, 10}]}}}, {{{
               RGBColor[
               0.6202971428968984, 0.39958695747810036`, 
                0.30532906832789064`], 
               Point3DBox[{5, 7, 1}]}}, {{
               RGBColor[
               0.31608980927731256`, 0.6430386863325084, 0.4171371931576555], 
               
               Point3DBox[{5, 7, 2}]}}, {{
               RGBColor[
               0.4072738946393015, 0.7354247050958611, 0.358824307228091], 
               Point3DBox[{5, 7, 3}]}}, {{
               RGBColor[
               0.026285046923404165`, 0.23045809068884737`, 
                0.6311439789778843], 
               Point3DBox[{5, 7, 4}]}}, {{
               RGBColor[
               0.9281557051753855, 0.7312015418628186, 0.1736606044235005], 
               Point3DBox[{5, 7, 5}]}}, {{
               RGBColor[
               0.11505505519966697`, 0.41842911318285103`, 
                0.5565778655015745], 
               Point3DBox[{5, 7, 6}]}}, {{
               RGBColor[
               0.8569176312218942, 0.9526423752062785, 0.21270182952539773`], 
               
               Point3DBox[{5, 7, 7}]}}, {{
               RGBColor[
               0.4533063315652597, 0.8418432017795348, 0.8265403434537724], 
               Point3DBox[{5, 7, 8}]}}, {{
               RGBColor[
               0.3303834019710483, 0.06567379222959113, 
                0.050203365797550