(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    535917,      12754]
NotebookOptionsPosition[    408856,      10226]
NotebookOutlinePosition[    508114,      12272]
CellTagsIndexPosition[    506872,      12222]
WindowTitle->Strings and Text: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Strings and Text", "SectionInline",ExpressionUUID->
   "16236a53-a78b-4891-9e13-0627b9877889"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 10}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{"p:45", "i:1"},
 CellLabel->"In[10]:=",ExpressionUUID->"c29c9217-4dee-4e5f-96c6-7d7ade5a7f52"],

Cell[TextData[{
 "Another thing the Wolfram Language lets you compute with is text. You enter \
text as a ",
 StyleBox["string",
  FontSlant->"Italic"],
 ", indicated by quotes (",
 Cell[BoxData[
 "\"\<\>"], "InlineCodeText",ExpressionUUID->
  "1dbf4464-ef29-4d97-b8e9-6250b1be5bf1"],
 "). "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"3c54d72c-373f-482d-a837-610d28fb76f9"],

Cell["Enter a string:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"60db7d0a-ab50-496b-951c-ecfc1fb341fa"],

Cell[CellGroupData[{

Cell[BoxData["\"\<This is a string.\>\""], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"44ea086c-5430-4e61-a258-fb1039044b3a"],

Cell[BoxData["\<\"This is a string.\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"18039637-b56a-4ea3-9ec7-3e43b2a0f124"]
}, Open  ]],

Cell[TextData[{
 "Just like when you enter a number, a string on its own comes back unchanged\
\[LongDash]except that the quotes aren\[CloseCurlyQuote]t visible when the \
string is displayed. There are many functions that work on strings. Like ",
 ButtonBox["StringLength",
  BaseStyle->"Link"],
 ", which gives the length of a string."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"858f1cfb-6fd3-47c1-bad5-e3c65b42992e"],

Cell[TextData[{
 ButtonBox["StringLength",
  BaseStyle->"Link"],
 " counts the number of characters in ",
 "a string",
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2ad6cd57-5b8f-49b8-a86f-61be388dd729"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "\"\<hello\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"c5a27feb-1d7d-4e2f-b91d-3cebae4116dd"],

Cell[BoxData["5"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"f6905243-1003-4096-bb58-2745bac92bf5"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["StringReverse",
  BaseStyle->"Link"],
 " ",
 "reverses the characters in a string",
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"183d1cc9-bb9b-4dd3-ae44-d88677da56a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReverse", "[", "\"\<hello\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"8e2ccf69-4679-4165-a48c-f8e3a82de09d"],

Cell[BoxData["\<\"olleh\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"41a6f1d6-da8f-4f87-ab0a-5349df1a4211"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["ToUpperCase",
  BaseStyle->"Link"],
 " makes all the characters in a string uppercase (capital letters):"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"39b095b6-358a-4804-b79b-a5065177d8b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", "\"\<I'm coding in the Wolfram Language!\>\"", 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"97356774-6e2b-492b-9ccf-51ae61fda6f3"],

Cell[BoxData["\<\"I'M CODING IN THE WOLFRAM LANGUAGE!\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"f0944685-f9e1-4432-87d4-6fe360305ead"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["StringTake",
  BaseStyle->"Link"],
 " ",
 "takes a certain number of characters from",
 " the beginning of a string:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"8c8eaf97-d49d-433a-82c9-2cefc132ae6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<this is about strings\>\"", ",", "10"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"92fd872e-ca96-4635-9fe3-f3ac8a7fbbc7"],

Cell[BoxData["\<\"this is ab\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"704fb30c-52eb-468a-8042-b1b71277ee1f"]
}, Open  ]],

Cell["If you take 10 characters, you get a string of length 10:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"becc914c-9386-4c7b-afb1-f66a8b0da3ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", 
  RowBox[{"StringTake", "[", 
   RowBox[{"\"\<this is about strings\>\"", ",", "10"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"80150650-6dc7-4abf-8634-c91578c39e4a"],

Cell[BoxData["10"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"3baa6704-d206-4378-90d1-a3160dd0faac"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["StringJoin",
  BaseStyle->"Link"],
 " joins strings (don\[CloseCurlyQuote]t ",
 "forget spaces if you want to separate words",
 "):"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"c436bd45-7fcf-4c48-a722-dcfb73d8d900"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{
  "\"\<Hello\>\"", ",", "\"\< \>\"", ",", " ", "\"\<there!\>\"", ",", " ", 
   "\"\< How are you?\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"c0e1382c-bbe5-4d7c-9da6-200691e78e0c"],

Cell[BoxData["\<\"Hello there! How are you?\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"0fa3f747-6338-42c7-8c21-011cb7886f6e"]
}, Open  ]],

Cell["You can make lists of strings, then apply functions to them.", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"abb959d6-7843-44db-803c-e6745801ce2f"],

Cell["A list of strings:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5623f91e-6cd0-4c25-bc32-dd1d4c74b976"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\"\<apple\>\"", ",", "\"\<banana\>\"", ",", "\"\<strawberry\>\""}],
   "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"f979fb3f-d677-4c55-b3c9-bdc07db4a386"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"apple\"\>", ",", "\<\"banana\"\>", ",", "\<\"strawberry\"\>"}],
   "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[8]=",ExpressionUUID->"a2c56b2d-64b9-4d3f-b9eb-9bac3716dc24"]
}, Open  ]],

Cell["Get the first two characters from each string:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:46",ExpressionUUID->"e2d7d6a0-abad-423c-8efb-d4e1a8e78c63"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<apple\>\"", ",", "\"\<banana\>\"", ",", "\"\<strawberry\>\""}], 
    "}"}], ",", "2"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"c459cd34-1c6c-47fe-a886-255bce31c5ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ap\"\>", ",", "\<\"ba\"\>", ",", "\<\"st\"\>"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"01d2cf7f-3b1f-45d6-b299-bd3fd89aee5e"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["StringJoin",
  BaseStyle->"Link"],
 " joins the strings in a list:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2bc3842b-b33f-4f81-b4ef-0f0b25c9b4ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<apple\>\"", ",", "\"\<banana\>\"", ",", "\"\<strawberry\>\""}], "}"}],
   "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"9a1091df-afad-47cc-bfb1-19f9bf6b0b86"],

Cell[BoxData["\<\"applebananastrawberry\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"13b0c4d8-530f-42f2-ae3e-16351ec8160f"]
}, Open  ]],

Cell["\<\
Sometimes it\[CloseCurlyQuote]s useful to turn strings into lists of their \
constituent characters. Each character is actually a string itself, of length \
1.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"67ed6e08-3c2a-4c03-b259-9f28cf02a823"],

Cell[TextData[{
 ButtonBox["Characters",
  BaseStyle->"Link"],
 " breaks a string into ",
 "a list of its characters",
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"838f9b9b-83a8-4ef2-b7ab-46f590bea46c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "\"\<a string is made of characters\>\"", 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"aa4ed83f-eed3-4b8a-a34c-895bc0c7d7a6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\" \"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"r\"\>", ",", "\<\"i\"\>", ",", "\<\"n\"\>", ",", "\<\"g\"\>", 
   ",", "\<\" \"\>", ",", "\<\"i\"\>", ",", "\<\"s\"\>", ",", "\<\" \"\>", 
   ",", "\<\"m\"\>", ",", "\<\"a\"\>", ",", "\<\"d\"\>", ",", "\<\"e\"\>", 
   ",", "\<\" \"\>", ",", "\<\"o\"\>", ",", "\<\"f\"\>", ",", "\<\" \"\>", 
   ",", "\<\"c\"\>", ",", "\<\"h\"\>", ",", "\<\"a\"\>", ",", "\<\"r\"\>", 
   ",", "\<\"a\"\>", ",", "\<\"c\"\>", ",", "\<\"t\"\>", ",", "\<\"e\"\>", 
   ",", "\<\"r\"\>", ",", "\<\"s\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"18072af7-9b69-47bc-9a4a-bf55433522d4"]
}, Open  ]],

Cell["\<\
Once you\[CloseCurlyQuote]ve broken a string into a list of characters, you \
can use all the usual list functions on it.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"fea1c075-5e00-4044-b0bc-d74417bee565"],

Cell["Sort the characters in a string:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a76d52d1-4f14-4df4-857c-0c4de0cba195"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"Characters", "[", "\"\<a string of characters\>\"", "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"55550bf0-7d3a-412d-a4c8-90b2860f6e8f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\" \"\>", ",", "\<\" \"\>", ",", "\<\" \"\>", ",", "\<\"a\"\>", 
   ",", "\<\"a\"\>", ",", "\<\"a\"\>", ",", "\<\"c\"\>", ",", "\<\"c\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"i\"\>", ",", "\<\"n\"\>", ",", "\<\"o\"\>", ",", "\<\"r\"\>", 
   ",", "\<\"r\"\>", ",", "\<\"r\"\>", ",", "\<\"s\"\>", ",", "\<\"s\"\>", 
   ",", "\<\"t\"\>", ",", "\<\"t\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"2dd93a58-a8b5-4450-8ba9-b6405966d61e"]
}, Open  ]],

Cell[TextData[{
 "The invisible elements at the beginning of the list are space characters. \
If you want to see strings in the form you\[CloseCurlyQuote]d input them, \
complete with ",
 Cell[BoxData["\<\"\!\(\*
StyleBox[\"...\",
FontColor->GrayLevel[0.6]]\)\"\>"], "InlineCodeText",ExpressionUUID->
  "c09b8561-7d30-4279-8a55-6e0fc90ebc33"],
 ", use ",
 ButtonBox["InputForm",
  BaseStyle->"Link"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"c5916c37-aff5-4483-bf00-42875f82b10d"],

Cell[TextData[{
 ButtonBox["InputForm",
  BaseStyle->"Link"],
 " shows strings as you would input them, including quotes:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cd13ef6c-1851-4d0d-a43c-0af983047775"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{"Characters", "[", "\"\<a string of characters\>\"", "]"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"62cee333-4002-4475-a2e7-d560824a38ad"],

Cell["\<\
{\" \", \" \", \" \", \"a\", \"a\", \"a\", \"c\", \"c\", \"e\", \"f\", \"g\", \
\"h\", \"i\", \"n\", \"o\", \"r\", 
 \"r\", \"r\", \"s\", \"s\", \"t\", \"t\"}\
\>", "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,ExpressionUUID->"e1af86d7-9faa-414b-83d2-c18a4ebbc227"]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 ButtonBox["StringJoin",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Characters",
  BaseStyle->"Link"],
 " work on strings of any kind; it doesn\[CloseCurlyQuote]t matter if they\
\[CloseCurlyQuote]re meaningful text or not. ",
 "There are other functions, like ",
 ButtonBox["TextWords",
  BaseStyle->"Link"],
 ", that specifically work",
 " on meaningful text, written, say, in English."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"d3cf573e-2e7a-448d-ae16-22a96c450bf2"],

Cell[TextData[{
 ButtonBox["TextWords",
  BaseStyle->"Link"],
 " gives a list of the words in a string of text:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3b9e2fc5-9edc-4b0f-95fd-53251ede4387"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TextWords", "[", 
  "\"\<This is a sentence. Sentences are made of words.\>\"", "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"625ac5e7-5c1f-49f4-ad15-58240a4d60ee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"This\"\>", ",", "\<\"is\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"sentence\"\>", ",", "\<\"Sentences\"\>", ",", "\<\"are\"\>", 
   ",", "\<\"made\"\>", ",", "\<\"of\"\>", ",", "\<\"words\"\>"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"57f16d1e-8778-4e0e-ace4-e46fecade825"]
}, Open  ]],

Cell["This gives the length of each word:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d60a14f7-327c-4127-bf32-dbd44efe1a1c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", 
  RowBox[{
  "TextWords", "[", 
   "\"\<This is a sentence. Sentences are made of words.\>\"", "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"4ab08163-22f3-4e02-9f69-12572848e8f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "2", ",", "1", ",", "8", ",", "9", ",", "3", ",", "4", ",", "2", 
   ",", "5"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"88252033-4320-4b45-9e88-f788c8097897"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["TextSentences",
  BaseStyle->"Link"],
 " breaks a text string into a list of sentences:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:47", "i:12"},ExpressionUUID->"274df771-c85b-4f7e-aadf-c7db7b66b839"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TextSentences", "[", 
  "\"\<This is a sentence. Sentences are made of words.\>\"", "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"e6594139-6130-49d1-8bc8-4a122c237392"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"This is a sentence.\"\>", 
   ",", "\<\"Sentences are made of words.\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[16]=",ExpressionUUID->"f0502440-e27a-4a48-99f6-3febd031b233"]
}, Open  ]],

Cell[TextData[{
 "There are lots of ways to get text into the Wolfram Language. One example \
is the ",
 ButtonBox["WikipediaData",
  BaseStyle->"Link"],
 " function, which ",
 "gets the current text",
 " of Wikipedia articles. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"a6774136-0c02-4484-8b2c-4b190e5216fa"],

Cell["\<\
Get the first 100 characters of the Wikipedia article about \
\[OpenCurlyDoubleQuote]computers\[CloseCurlyDoubleQuote]:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b00fe649-b72b-4d8b-95b8-f57c57ee8ab5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{
   RowBox[{"WikipediaData", "[", "\"\<computers\>\"", "]"}], ",", "100"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"19e5c110-46dd-4c4f-ae07-a78779acdd18"],

Cell[BoxData["\<\"A computer is a general-purpose device that can be \
programmed to carry out a set of arithmetic or lo\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"aefc8261-0f8a-465e-ac71-ec8f6881e9fe"]
}, Open  ]],

Cell[TextData[{
 "A convenient way to get a sense of what\[CloseCurlyQuote]s in a piece of \
text is to create a word cloud. The function ",
 ButtonBox["WordCloud",
  BaseStyle->"Link"],
 " does this."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"2f8aedc8-bc06-44cb-b45e-915af32ae179"],

Cell["\<\
Create a word cloud for the Wikipedia article on \
\[OpenCurlyDoubleQuote]computers\[CloseCurlyDoubleQuote]:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4fc4bbd1-8e53-4ccd-821c-debe6218ed6f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordCloud", "[", 
  RowBox[{"WikipediaData", "[", "\"\<computers\>\"", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"e8fced7f-581e-4bb6-9e55-490debc9ed5e"],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"computer\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.208955223880597],
     FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"computers\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.1253731343283582],
     FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {0., 44.}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"program\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.07893864013266998],
     FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {0., -45.}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"machine\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.07761194029850746],
     FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {5., -69.}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"memory\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.07495854063018242],
     FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {6., 72.}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"instructions\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.06301824212271974],
     FontColor->RGBColor[0.363898, 0.618501, 0.782349]], {-9., 88.}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"devices\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.07097844112769486],
     FontColor->RGBColor[0.772079, 0.431554, 0.102387]], {0., -92.}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"programs\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.06036484245439469],
     FontColor->RGBColor[1, 0.75, 0]], {93., -30.}, Center, Automatic], 
   InsetBox[
    StyleBox["\<\"mechanical\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04577114427860697],
     FontColor->RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965]], {-90., -32.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"computing\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04709784411276949],
     FontColor->RGBColor[0.736782672705901, 0.358, 0.5030266573755369]], {87., -48.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"electronic\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.048424543946932005`],
     FontColor->RGBColor[
      0.9728288904374106, 0.621644452187053, 0.07336199581899142]], {-88., -49.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"modern\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.05240464344941957],
     FontColor->RGBColor[0.571589, 0.586483, 0.]], {-70., 65.}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"languages\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.044444444444444446`],
     FontColor->RGBColor[
      0.6753413537738198, 0.3589675436319385, 0.5991466155654507]], {2., 105.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"information\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04046434494195688],
     FontColor->RGBColor[
      0.9637822400302223, 0.5764112001511111, 0.0977879519184]], {-80., -66.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"language\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.044444444444444446`],
     FontColor->RGBColor[
      0.9324333565611593, 0.5282889043741062, 0.0921900209050434]], {85., 67.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"numbers\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04577114427860697],
     FontColor->RGBColor[
      0.838355547812947, 0.44746667828057946`, 0.0208888695323676]], {87., -65.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"instruction\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04311774461028192],
     FontColor->RGBColor[
      0.9874666782805795, 0.6948333914028977, 0.033839968642435214`]], {0., -110.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"machines\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04046434494195688],
     FontColor->RGBColor[0.7132613816472081, 0.358, 0.5392132590042952]], {-75., -81.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"programmable\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.8510135028964549, 0.47400900193096995`, 0.018912152606809424`]], {77., -84.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"operations\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03781094527363184],
     FontColor->RGBColor[
      0.23716678280579248`, 0.645266573755366, 0.699600139366951]], {78., 86.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"programming\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03250414593698176],
     FontColor->RGBColor[0.31827505306025683`, 0.715, 0.3808317506505822]], {6., 118.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"software\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04311774461028192],
     FontColor->RGBColor[0.7748409210981391, 0.358, 0.4444755060028629]], {-71., -96.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"different\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04046434494195688],
     FontColor->RGBColor[
      0.35558897405758294`, 0.5505288207539337, 0.8417067688690995]], {65., 101.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"processing\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[
      0.9492067688690977, 0.5394711792460651, 0.10728609198218791`]], {72., -97.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"hardware\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03913764510779436],
     FontColor->RGBColor[
      0.8564488486273256, 0.42032672705901153`, 0.06612212156831418]], {-63., 104.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"architecture\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[0.428777913273419, 0.5052332520359486, 0.85]], {0., -124.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"called\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.05107794361525705],
     FontColor->RGBColor[0.915, 0.3325, 0.2125]], {-87., 83.}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"computer's\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03383084577114428],
     FontColor->RGBColor[0.5019668524892619, 0.46131988850644284`, 0.85]], {-64., -111.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"perform\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04046434494195688],
     FontColor->RGBColor[0.37977756485605163`, 0.715, 0.3025558265468435]], {59., -112.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"integrated\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[0.8493197142977551, 0.7407577460330839, 0.]], {0., 131.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"stored\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04577114427860697],
     FontColor->RGBColor[0.8996399512215667, 0.7463488834690629, 0.]], {121., 27.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"output\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04577114427860697],
     FontColor->RGBColor[
      0.5833680111493557, 0.4126186601628758, 0.8290799721266107]], {-123., 31.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"specialized\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03250414593698176],
     FontColor->RGBColor[
      0.845266573755366, 0.437100139366951, 0.03816643438841502]], {-56., 119.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"thousands\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03383084577114428],
     FontColor->RGBColor[0.7175796237092107, 0.7261199581899123, 0.]], {68., 115.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"designed\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[
      0.8342400905885153, 0.4628267270590103, 0.0038160815296638794`]], {-58., -126.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"digital\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.044444444444444446`],
     FontColor->RGBColor[
      0.8439466852489265, 0.3467106629502147, 0.3309221912517893]], {120., 43.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"control\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04311774461028192],
     FontColor->RGBColor[0.47401116530937026`, 0.47809330081437784`, 0.85]], {-123., 45.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"analog\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.041791044776119404`],
     FontColor->RGBColor[
      0.16397784358994957`, 0.7038177251280403, 0.6117734123079395]], {50., 129.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"data\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.05240464344941957],
     FontColor->RGBColor[0.647624, 0.37816, 0.614037]], {-120., 60.}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"developed\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.922066817647527, 0.5213778784316846, 0.08286013588277422]], {63., -125.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"applications\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[0.7042770479220728, 0.358, 0.5530353108891188]], {-56., 131.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"device\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04046434494195688],
     FontColor->RGBColor[
      0.8878600487784333, 0.33792799024431336`, 0.2577332520359445]], {-113., 96.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"invented\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03648424543946932],
     FontColor->RGBColor[
      0.6536293927965667, 0.37163285420200276`, 0.6534265180085832]], {116., 97.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"number\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03913764510779436],
     FontColor->RGBColor[0.5472001045252132, 0.43417993728487203`, 0.85]], {22., -28.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"arithmetic\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[
      0.9784200278733908, 0.649600139366954, 0.058265924741844846`]], {114., -112.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"used\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.05107794361525705],
     FontColor->RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85]], {-126., -81.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"operation\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[0.7658565873730018, 0.358, 0.4582975578876895]], {-108., 116.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"differential\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[
      0.8064401951137368, 0.3542119609772526, 0.39343300814377197`]], {99., 126.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"input\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.044444444444444446`],
     FontColor->RGBColor[
      0.28240003484173815`, 0.6090799721266095, 0.7538800418100857]], {127., 78.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"problems\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[0.15725938678540247`, 0.715, 0.5857607804549424]], {-123., -96.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"example\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03383084577114428],
     FontColor->RGBColor[
      0.9930578157165594, 0.7227890785827968, 0.01874389756528967]], {-117., -110.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"personal\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03250414593698176],
     FontColor->RGBColor[
      0.969373377466199, 0.6043668873309952, 0.08269188084126262]], {118., 112.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"typically\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03383084577114428],
     FontColor->RGBColor[
      0.9046334610863751, 0.334573307782725, 0.22977756485604156`]], {-107., -126.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"systems\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03383084577114428],
     FontColor->RGBColor[
      0.6319174318193065, 0.38429816477207124`, 0.7077064204517338]], {-106., 127.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"assembly\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[0.4177882075393331, 0.715, 0.25417864494993975`]], {111., -125.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"possible\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03250414593698176],
     FontColor->RGBColor[0.7277983389807635, 0.358, 0.5168487092603637]], {124., -96.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"system\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[0.47929071933511125`, 0.715, 0.1759027208462221]], {-9., -136.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"design\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[0.2187618985811806, 0.715, 0.5074848563512248]], {31., -137.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"time\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.044444444444444446`],
     FontColor->RGBColor[0.5407932311309059, 0.715, 0.09762679674248334]], {-130., -63.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Colossus\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[
      0.8633598745697435, 0.40996018814538476`, 0.08339968642435877]], {-51., -141.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"working\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.9603267270590103, 0.5591336352950514, 0.10711783694067224`]], {-130., 77.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"century\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03250414593698176],
     FontColor->RGBColor[0.38354466123747527`, 0.5323732032575149, 0.85]], {134., -77.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"complex\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[0.529922539669161, 0.44454647619850335`, 0.85]], {71., -138.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"CPU\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.04046434494195688],
     FontColor->RGBColor[0.7678998606330495, 0.7317110956258943, 0.]], {-139., -47.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"tubes\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03648424543946932],
     FontColor->RGBColor[0.6361597700445392, 0.7170733077827265, 0.]], {-29., -27.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"vacuum\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[
      0.8745421494417032, 0.39318677583744527`, 0.11135537360425793`]], {71., 143.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"read\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.041791044776119404`],
     FontColor->RGBColor[
      0.6184987019729621, 0.39212575718243875`, 0.7412532450675947]], {133., 58.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"usually\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.3383114092015346, 0.5643508726387724, 0.8209736910418415]], {136., -63.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Turing\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03250414593698176],
     FontColor->RGBColor[
      0.5750747800184488, 0.4174563783225715, 0.8498130499538777]], {-101., 139.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"contain\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[
      0.9986489531525362, 0.7507447657626809, 0.0036478264881522893`]], {-90., -140.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"built\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.041791044776119404`],
     FontColor->RGBColor[
      0.8613800418100862, 0.48092002787339083`, 0.02824203762907758]], {140., -47.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"using\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03648424543946932],
     FontColor->RGBColor[
      0.9038177251280404, 0.3492734123079395, 0.18454431282010084`]], {108., -138.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"code\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03781094527363184],
     FontColor->RGBColor[
      0.8168067340273636, 0.3521386531945273, 0.3761554432877274]], {109., 139.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"circuit\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[0.7513196300394465, 0.358, 0.48066210763162087`]], {-126., -141.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"speed\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[0.7989994773739094, 0.735166608597101, 0.]], {139., 126.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"circuits\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.26512246998569167`, 0.6229020240114467, 0.73314696398283]], {-137., 137.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Early\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[
      0.596786740995709, 0.404791067752503, 0.7955331475107271]], {139., -139.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"ROM\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03383084577114428],
     FontColor->RGBColor[
      0.19193353076984873`, 0.681453175384121, 0.6453202369238185]], {140., 136.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"logic\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[
      0.3103557220216354, 0.5867154223826917, 0.7874268664259625]], {0., 144.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"ALU\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03648424543946932],
     FontColor->RGBColor[
      0.9052934053395919, 0.510195603559728, 0.06776406480563275]], {29., 143.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"given\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.6670481226429111, 0.3638052617916352, 0.6198796933927223]], {-28., 143.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"known\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[
      0.9107287510704583, 0.33890687339431275`, 0.20182187767614543`]], {15., -148.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"faster\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[
      0.8949268664259606, 0.5032845776173072, 0.05843417978336459]], {-146., -27.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"jump\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[0.5788038738141875, 0.715, 0.049249615145579635`]], {149., 0.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"RAM\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03383084577114428],
     FontColor->RGBColor[
      0.7896667828057927, 0.3575666434388414, 0.4213886953236787]], {149., -16.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"unit\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03913764510779436],
     FontColor->RGBColor[0.9810598048862722, 0.7553955338762525, 0.]], {-14., -150.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"tasks\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.8774935098648088, 0.34000129802703827`, 0.2750108168919853]], {-57., 143.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Mark\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.9840111653093676, 0.677555826546838, 0.04316985366470745]], {150., -28.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"store\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03383084577114428],
     FontColor->RGBColor[
      0.8781534541180211, 0.4921023027453475, 0.04333810870621905]], {45., -152.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Later\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.8926354502560807, 0.366046824615879, 0.15658862564020168`]], {-152., 55.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"use\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.044444444444444446`],
     FontColor->RGBColor[
      0.8857244243136628, 0.3764133635295058, 0.1393110607841571]], {73., -151.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"main\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[0.4567336004533182, 0.4884598397280091, 0.85]], {154., 40.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"high\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[
      0.6453361616656581, 0.37647057236169945`, 0.6741595958358548]], {-155., 17.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"able\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[0.9307395679624266, 0.7498043964402695, 0.]], {-145., 86.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"like\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[
      0.8607200975568693, 0.34335598048862614`, 0.30296650407188447`]], {-156., -11.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"cell\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.8335801463353031, 0.3487839707329394, 0.3481997561078282]], {-156., 1.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"set\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0351575456053068],
     FontColor->RGBColor[0.6897400905885174, 0.358, 0.5753998606330502]], {156., 10.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"etc\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[
      0.2198892179497479, 0.6590886256402017, 0.6788670615396974]], {152., 26.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"run\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031177446102819237`],
     FontColor->RGBColor[
      0.6102054708420535, 0.39696347534213544`, 0.7619863228948663]], {-23., 153.},
     Center, Automatic], InsetBox[
    StyleBox["\<\"II\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029850746268656716`],
     FontColor->RGBColor[0.6672593867853922, 0.7205288207539324, 0.]], {4., -1.},
     Center, Automatic]},
  DefaultBaseStyle->{"Graphics", FontFamily -> "Helvetica"},
  ImageSize->{251.19140625000026`, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
  PlotRange->{{-167.5, 167.5}, {-158.5, 157.5}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"6251267e-bcd5-4fb3-8e35-30fe1442ef71"]
}, Open  ]],

Cell["\<\
Not surprisingly, \[OpenCurlyDoubleQuote]computer\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]computers\[CloseCurlyDoubleQuote] are the most common \
words in the article.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"717bc03b-8140-48f5-bf8f-16f563b124fe"],

Cell[TextData[{
 "The Wolfram Language has lots of built-in knowledge about words that appear \
in English and other languages. ",
 ButtonBox["WordList",
  BaseStyle->"Link"],
 " gives lists of words."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"6010aaf3-81d8-41b6-88cc-e1f982f1d2fd"],

Cell["Get the first 20 words from a list of common English words:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b53b7006-c71a-48c0-b673-70765041fb33"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"WordList", "[", "\[ThinSpace]", "]"}], ",", "20"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"7a1473a4-f376-4ef1-bd53-5c19f1ad564a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"aah\"\>", ",", "\<\"aardvark\"\>", 
   ",", "\<\"aback\"\>", ",", "\<\"abacus\"\>", ",", "\<\"abaft\"\>", 
   ",", "\<\"abalone\"\>", ",", "\<\"abandon\"\>", ",", "\<\"abandoned\"\>", 
   ",", "\<\"abandonment\"\>", ",", "\<\"abase\"\>", ",", "\<\"abasement\"\>",
    ",", "\<\"abash\"\>", ",", "\<\"abashed\"\>", ",", "\<\"abashment\"\>", 
   ",", "\<\"abate\"\>", ",", "\<\"abatement\"\>", ",", "\<\"abattoir\"\>", 
   ",", "\<\"abbe\"\>", ",", "\<\"abbess\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"e349b797-8c2c-484d-b577-f61bffe18e52"]
}, Open  ]],

Cell["Make a word cloud from the first letters of all the words:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:48",ExpressionUUID->"f21437e6-1387-4431-b91c-909326c4c59f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordCloud", "[", 
  RowBox[{"StringTake", "[", 
   RowBox[{
    RowBox[{"WordList", "[", "\[ThinSpace]", "]"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"1fb56401-196b-4fed-b745-2ce74d6a2fd8"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     StyleBox["\<\"p\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.43128324924913136`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {0, 0}], InsetBox[
     StyleBox["\<\"s\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.578512396694215],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {31.5, -2.5}], 
    InsetBox[
     StyleBox["\<\"c\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.48578480273971136`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {-30.5, 0.5}], 
    InsetBox[
     StyleBox["\<\"d\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.3495844568850595],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {-0.5, 30.5}], 
    InsetBox[
     StyleBox["\<\"b\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.3194961729344643],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.772079, 0.431554, 0.102387]], {-25.5, 31.5}], 
    InsetBox[
     StyleBox["\<\"m\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.30086499354868645`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[1, 0.75, 0]], {11.5, -36.5}], InsetBox[
     StyleBox["\<\"a\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.3430528365256777],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {22.5, 32.5}], 
    InsetBox[
     StyleBox["\<\"h\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.23629832016004254`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.736782672705901, 0.358, 0.5030266573755369]], {-21.5, -34.5}], 
    InsetBox[
     StyleBox["\<\"t\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.2996871603691258],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.647624, 0.37816, 0.614037]], {41.5, 30.5}], 
    InsetBox[
     StyleBox["\<\"g\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.21242042933803992`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.28026441037696703`, 0.715, 0.4292089322474965]], {-38.5, -28.5}], 
    InsetBox[
     StyleBox["\<\"f\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.26520877093107714`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.915, 0.3325, 0.2125]], {-43.5, 25.5}], InsetBox[
     StyleBox["\<\"e\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.26071158970002734`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.40082222609352647`, 0.5220066643438841, 0.85]], {37.5, -35.5}], 
    InsetBox[
     StyleBox["\<\"r\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.3054692505233327],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.363898, 0.618501, 0.782349]], {-52.5, -21.5}], 
    InsetBox[
     StyleBox["\<\"u\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.24807665195564924`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9728288904374106, 0.621644452187053, 
        0.07336199581899142]], {-54.5, 0.5}], InsetBox[
     StyleBox["\<\"w\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.18929206872121224`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5833680111493557, 0.4126186601628758, 
        0.8290799721266107]], {-7.5, 51.5}], InsetBox[
     StyleBox["\<\"i\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.28630269241957274`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.571589, 0.586483, 0.]], {52.5, 7.5}], InsetBox[
     StyleBox["\<\"o\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.18800715979805516`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8996399512215667, 0.7463488834690629, 0.]], {-11.5, -53.5}], InsetBox[
     StyleBox["\<\"n\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.1728024042073629],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8439466852489265, 0.3467106629502147, 
        0.3309221912517893]], {18.5, 52.5}], InsetBox[
     StyleBox["\<\"v\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.15063772528290303`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.28240003484173815`, 0.6090799721266095, 
        0.7538800418100857]], {3.5, -56.5}], InsetBox[
     StyleBox["\<\"l\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.21070721744049714`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.838355547812947, 0.44746667828057946`, 
        0.0208888695323676]], {53.5, -17.5}], InsetBox[
     StyleBox["\<\"q\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.1025607164081085],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5407932311309059, 0.715, 0.09762679674248334]], {-24.5, -49.5}], 
    InsetBox[
     StyleBox["\<\"k\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.10641544317757977`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6753413537738198, 0.3589675436319385, 
        0.5991466155654507]], {-52.5, 15.5}], InsetBox[
     StyleBox["\<\"y\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.09313805097162314],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8857244243136628, 0.3764133635295058, 
        0.1393110607841571]], {16.5, -54.5}], InsetBox[
     StyleBox["\<\"j\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.11562395712687228`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9324333565611593, 0.5282889043741062, 
        0.0921900209050434]], {-7.5, -35.5}], InsetBox[
     StyleBox["\<\"x\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.08264462809917356],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9874666782805795, 0.6948333914028977, 
        0.033839968642435214`]], {29.5, 49.5}], InsetBox[
     StyleBox["\<\"z\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.0876771880482055],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.47401116530937026`, 0.47809330081437784`, 0.85]], {25.5, -53.5}]}},
  ImageSize->{141.84244791666657`, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
  PlotRange->{{-64., 57.}, {-64., 60.}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[20]=",ExpressionUUID->"4f1997e8-96c4-4964-ae86-92d8b47c73da"]
}, Open  ]],

Cell["\<\
Strings don\[CloseCurlyQuote]t have to contain text. In a juxtaposition of \
ancient and modern, we can for example generate Roman numerals as strings. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"f5c6da04-2482-4f5b-b13a-16f1286c9ad7"],

Cell["Generate the Roman numeral string for 1988:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2cc8d8ba-6a66-4937-9269-125f45289d76"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RomanNumeral", "[", "1988", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"7048362f-a839-4d0b-a7f0-c83e865469a4"],

Cell[BoxData["\<\"MCMLXXXVIII\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"e8958597-68e0-4fcc-8418-0b1be1e02d60"]
}, Open  ]],

Cell["Make a table of the Roman numerals for numbers up to 20:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"268cc7b2-07e2-4974-9814-8b703ab7b0cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RomanNumeral", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"51bf87b7-e8a5-4303-ad90-19228bc09613"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"I\"\>", ",", "\<\"II\"\>", ",", "\<\"III\"\>", 
   ",", "\<\"IV\"\>", ",", "\<\"V\"\>", ",", "\<\"VI\"\>", ",", "\<\"VII\"\>",
    ",", "\<\"VIII\"\>", ",", "\<\"IX\"\>", ",", "\<\"X\"\>", 
   ",", "\<\"XI\"\>", ",", "\<\"XII\"\>", ",", "\<\"XIII\"\>", 
   ",", "\<\"XIV\"\>", ",", "\<\"XV\"\>", ",", "\<\"XVI\"\>", 
   ",", "\<\"XVII\"\>", ",", "\<\"XVIII\"\>", ",", "\<\"XIX\"\>", 
   ",", "\<\"XX\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"35e243a1-5837-4bbe-9a53-9d08e513a2a0"]
}, Open  ]],

Cell["\<\
As with everything, we can do computations on these strings. For example, we \
can plot the lengths of successive Roman numerals.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5cc6a68f-fb1b-47b1-b749-bbe63e2b94b8"],

Cell["\<\
Plot the lengths of the Roman numerals for numbers up to 100:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"297be57b-a44a-43f4-b044-8393b3cbf863"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"StringLength", "[", 
     RowBox[{"RomanNumeral", "[", "n", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"650c363d-7fa4-4bbd-b100-e8ab87c3276a"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.01388888888888889], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxdlDlOQ0EQRFtEhAQEBASAEEIIIbPv/MFmMYsNNsZAiiDmCn20OZKPgBH9
gi5LVumpumrmz3z95c+f4feMmX1N/3/6/5s0Wa1knRWdE3++5PyC+IuSX5Ke
FZlflb418delb0P6NsXfknxL/G3J74TyXLsyvyd9++IfSN+h9B2Jfyz5E/FP
JX8Wyjmfy/yF9DXil9znMH2X4sPk2+LD5Duhce/eyfN2FRrn5zD7vc7rOUz+
RnyY/K34MPlu3q9387zdhcb75zD3fZ/Xc5j8g/gw+UfxYfK9vF/v5Xnr5z7v
i/+U+xzm+Z+zX2D2I36FyQ9C4/zKIM87HH1VfBvmvgJzH+JXmPyL5GHycLx/
VeZtlPvKKPsOR1+F+Y69Zr/A5MWvMPlxaHwHyzjPOxz3W2Hu9032D7O++BUm
/y55mDzM/mXePkInzS9arW7V
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{199.84375, Automatic},
  Method->{},
  PlotRange->{{0., 100.}, {0, 8.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[23]=",ExpressionUUID->"3c24a67e-22d2-4d58-9b2c-194db9867043"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["IntegerName",
  BaseStyle->"Link"],
 " gives the English name of an integer."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"dadcc9c7-79d2-4d8c-9698-a7d6e44c8422"],

Cell["Generate a string giving the name of the integer 56:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9cf2c905-2dde-402f-95fa-2f999814a995"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerName", "[", "56", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[24]:=",ExpressionUUID->"c1cecb8a-11c1-4e93-9e1f-8d5acdf2deb7"],

Cell[BoxData["\<\"fifty\[Hyphen]six\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[24]=",ExpressionUUID->"a5b6a2ee-f99d-456c-b808-85ae362c31a3"]
}, Open  ]],

Cell["Here\[CloseCurlyQuote]s a plot of the lengths of integer names in \
English:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:49",ExpressionUUID->"20696e17-9823-4914-9237-5f58f2ffea46"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"StringLength", "[", 
     RowBox[{"IntegerName", "[", "n", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[25]:=",ExpressionUUID->"377d2e6e-bd7c-4708-9fc1-c43e83fa7778"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.01388888888888889], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd00lKQ0EUQNHCkUMHDhw40CAiIhL73pSx7zX2U9GxW6il1ZJcgkreFeoG
QnE+ue+/kPzp96/B50hK6eP3/XcOX9+94Tma40JuzTke55hOX59QN6nPTckd
9TPqZzV3Tp7X3AV5UXt05SXtsax+RV7V/de097q8ob034+R7bcnb6nfU78p7
6ve1X0/zcuuCmXfQzity6qvH9IetC6Y/ijN+/4I7cR63Lpj+RPeX06l6TH/W
umD6c+2H2e9C8zHzL7WfnK7UY/pr7Yfpb7QfZr9bzcfMv2vnZbng6Cumv2+d
MT2O56vq82mgHsdzXHD8f6qcHtRjerli+sc44/nImP3liumfdH+5YHpM/9w6
Y3oc+1XM7//SOmOeNxzzqpxe1WN6uWL6t3//AFQ/cao=
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{199.79296875, Automatic},
  Method->{},
  PlotRange->{{0., 100.}, {0, 13.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[25]=",ExpressionUUID->"6d376dc2-0833-4094-aed0-dfd2444ded52"]
}, Open  ]],

Cell["\<\
There are various ways to turn letters into numbers (and vice versa). \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:20",ExpressionUUID->"a1d37298-f795-44ea-af27-f5e7edee7dc9"],

Cell[TextData[{
 ButtonBox["Alphabet",
  BaseStyle->"Link"],
 " gives the alphabet:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7a4ec1e5-5439-426e-9c64-97fba48d60cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Alphabet", "[", "\[ThinSpace]", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[26]:=",ExpressionUUID->"f9892e43-a606-421d-84b9-53d68b42a451"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"i\"\>", ",", "\<\"j\"\>", ",", "\<\"k\"\>", ",", "\<\"l\"\>", 
   ",", "\<\"m\"\>", ",", "\<\"n\"\>", ",", "\<\"o\"\>", ",", "\<\"p\"\>", 
   ",", "\<\"q\"\>", ",", "\<\"r\"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"u\"\>", ",", "\<\"v\"\>", ",", "\<\"w\"\>", ",", "\<\"x\"\>", 
   ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[26]=",ExpressionUUID->"5d1bb0bd-8726-4b34-99bd-1c03165a5b40"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["LetterNumber",
  BaseStyle->"Link"],
 " tells you where in the alphabet a letter appears:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"378da19e-db59-480f-8cae-3aa1fed9bb8b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterNumber", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<x\>\"", ",", "\"\<y\>\"", ",", 
    "\"\<z\>\""}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[27]:=",ExpressionUUID->"21108b6a-9e02-4373-b621-1861ccb9f7d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "24", ",", "25", ",", "26"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[27]=",ExpressionUUID->"27e10754-67e8-40a1-9f71-f55fb286494d"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["FromLetterNumber",
  BaseStyle->"Link"],
 " does the opposite:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:22",ExpressionUUID->"a783c10c-11fe-44d8-9c9a-e6cbd5a5237e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromLetterNumber", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15"}], 
   "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[28]:=",ExpressionUUID->"e618ecc9-1412-4409-912a-267c2fa353e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"j\"\>", ",", "\<\"k\"\>", ",", "\<\"l\"\>", ",", "\<\"m\"\>", 
   ",", "\<\"n\"\>", ",", "\<\"o\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[28]=",ExpressionUUID->"ec0096c1-2bc1-43ef-88ea-fbc6024acae5"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Alphabet",
  BaseStyle->"Link"],
 " knows about non-English alphabets too:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:23",ExpressionUUID->"44f7e35f-678e-4518-90d5-7d19a3855b08"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Alphabet", "[", "\"\<Russian\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[29]:=",ExpressionUUID->"a5409555-16f5-46d4-9db5-cea028f711fd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\:0430\"\>", ",", "\<\"\:0431\"\>", ",", "\<\"\:0432\"\>", 
   ",", "\<\"\:0433\"\>", ",", "\<\"\:0434\"\>", ",", "\<\"\:0435\"\>", 
   ",", "\<\"\:0451\"\>", ",", "\<\"\:0436\"\>", ",", "\<\"\:0437\"\>", 
   ",", "\<\"\:0438\"\>", ",", "\<\"\:0439\"\>", ",", "\<\"\:043a\"\>", 
   ",", "\<\"\:043b\"\>", ",", "\<\"\:043c\"\>", ",", "\<\"\:043d\"\>", 
   ",", "\<\"\:043e\"\>", ",", "\<\"\:043f\"\>", ",", "\<\"\:0440\"\>", 
   ",", "\<\"\:0441\"\>", ",", "\<\"\:0442\"\>", ",", "\<\"\:0443\"\>", 
   ",", "\<\"\:0444\"\>", ",", "\<\"\:0445\"\>", ",", "\<\"\:0446\"\>", 
   ",", "\<\"\:0447\"\>", ",", "\<\"\:0448\"\>", ",", "\<\"\:0449\"\>", 
   ",", "\<\"\:044a\"\>", ",", "\<\"\:044b\"\>", ",", "\<\"\:044c\"\>", 
   ",", "\<\"\:044d\"\>", ",", "\<\"\:044e\"\>", ",", "\<\"\:044f\"\>"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[29]=",ExpressionUUID->"01abf333-3e26-4122-b7a4-da09dcd30bd2"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Transliterate",
  BaseStyle->"Link"],
 " converts to (approximately) equivalent English letters:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:24",ExpressionUUID->"d3f37b2b-078f-409c-b932-33b93b1a6184"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transliterate", "[", 
  RowBox[{"Alphabet", "[", "\"\<Russian\>\"", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[30]:=",ExpressionUUID->"ebd73288-128f-4b50-b09b-e461dac28354"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"v\"\>", ",", "\<\"g\"\>", 
   ",", "\<\"d\"\>", ",", "\<\"e\"\>", ",", "\<\"e\"\>", ",", "\<\"z\"\>", 
   ",", "\<\"z\"\>", ",", "\<\"i\"\>", ",", "\<\"j\"\>", ",", "\<\"k\"\>", 
   ",", "\<\"l\"\>", ",", "\<\"m\"\>", ",", "\<\"n\"\>", ",", "\<\"o\"\>", 
   ",", "\<\"p\"\>", ",", "\<\"r\"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"u\"\>", ",", "\<\"f\"\>", ",", "\<\"h\"\>", ",", "\<\"c\"\>", 
   ",", "\<\"c\"\>", ",", "\<\"s\"\>", ",", "\<\"s\"\>", 
   ",", "\<\"\:02ba\"\>", ",", "\<\"y\"\>", ",", "\<\"\:02b9\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"u\"\>", ",", "\<\"a\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[30]=",ExpressionUUID->"abe25eb4-9e70-4249-86e4-9ef8af24a5c4"]
}, Open  ]],

Cell["\<\
This transliterates the word \[OpenCurlyDoubleQuote]wolfram\
\[CloseCurlyDoubleQuote] into the Russian alphabet:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3343994a-48e2-4a88-9590-06de880b953e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transliterate", "[", 
  RowBox[{"\"\<wolfram\>\"", ",", "\"\<Russian\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[31]:=",ExpressionUUID->"414d5998-4349-418c-91b9-1b603197c5e4"],

Cell[BoxData["\<\"\:0443\:043e\:043b\:0444\:0440\:0430\:043c\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[31]=",ExpressionUUID->"4a17077e-8f8a-443c-a06c-8ed8d07fe177"]
}, Open  ]],

Cell[TextData[{
 "If you want to, you can also turn text into images, which you can then \
manipulate using image processing. The function ",
 ButtonBox["Rasterize",
  BaseStyle->"Link"],
 " makes a ",
 StyleBox["raster",
  FontSlant->"Italic"],
 ", or ",
 StyleBox["bitmap",
  FontSlant->"Italic"],
 ", of something."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:25",ExpressionUUID->"3d15ba1a-4eb3-4892-8b71-8677abed94fc"],

Cell["Generate an image of a piece of text:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:26",ExpressionUUID->"81525f79-d794-4eeb-91a4-a80f6a92d593"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{"Style", "[", 
   RowBox[{"\"\<ABC\>\"", ",", "100"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[32]:=",ExpressionUUID->"2074d497-b344-46bd-a444-5cbb91f7ffe4"],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztna2yrDoWgLtqnmRegHfgCagajbo1hR0sFofE4VAoVBQKg8IwAoNBYDAI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   "], {{0, 0}, {206, 
   100}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{171.03125, 83.},
  PlotRange->{{0, 206}, {0, 100}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[32]=",ExpressionUUID->"b14b00e4-35ef-4085-bbe6-2c29d5226ebf"]
}, Open  ]],

Cell["Do image processing on it:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:27",ExpressionUUID->"01148fe8-9ab8-4d7f-88cb-33a5bc73af2a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EdgeDetect", "[", 
  RowBox[{"Rasterize", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<ABC\>\"", ",", "100"}], "]"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[33]:=",ExpressionUUID->"9ca27605-1f3d-40af-bb46-5f109da49895"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztmkFuGzEMRaWuuuwVeotuu+w2RQ+QIG7QjQs4BYpesmeqk3hiS+InPyWN
HaMkkMD2UCSfKFEazXy8+3nz/V1K6fH9/t/N7e/Pu93tn68f9l++bR9/PGw3
91+2vzYPm92nuye1+/3f3xQSEhIScs2Sc750CM9BFFJf5O3s/zr8yeKlWCxr
v7ERPusmkoaOzIWkqB9MZTbCtOgRynyUDiBTcTFFGvQo8x3P6bXTA45XFw2d
SRxBrvVMk4VGOVGaxmQnurTbGMpwMlS07AhloPzKxca5BoabHjRCBBdlRdRt
jM0pNImJslUb0AGRORYo3QcVQ+YcOzvbS19pyiMEfAZuVb+vV70r4jQau4to
GF+VyvAL1woEy49FooxrnkBYZINakRhIwlXf8KaX93rBs1tUen00Po+Z3Ho1
yzdhu9SDtVXRcEyakwYETWWRLdLzaDh3mVLNL6p2cDCeDhp3ahJ3z7Jk0J2c
ERr3+p68NN7kDNGAz5ZDS/c4HC9E41uumVW2rhfO7ZCbpnPzYSbneMvtTo69
3jA0nuMD89bvNCve9czShvZ6agAlBY0vOQ4a5Q5yJk05YXxF2qLBCTg3jW97
Jyoru4uVaE5rQGl6mEabGytNG6UyczsiqEvCrErjSo62b1FL8FoDrbHnSU4R
MTpTl5aI89E4kkNkT17u1qFpYVxFujuQS9DY+1XbgbkQzaOpy3Ntnj0VUl1Y
B/3zaERrfHJAFai1zlQFAA1dB4Ci8LgSNpxHI8M4kqNg6w8Jro1G51mBJrde
WgeqL37XWX8BnwcEpWYaDUcwh+ZwEGo87Ncfi1khwYeJ8s8DQloZoklgrF0p
DYp7Ng5tQ1H872jK/YKoP4EmH+wTL/0wkVI0QH8WDdXtq9DMxTGfU1FF+s3Q
mFaY5IzQsGsaIz4aezVx08xMDt6iiS6ugobQ0b2N0MzDyYwJ4hh/jGbWzGFS
wySH2QtgK5OSQ75GYHvr39kcw7AM1G3ku3IiuWZyxmjQBluLKDdm2Dc87CJt
0+jd78WRXn+gakDtoI/GGkw+HOn4b7nntNomOzkWjTkz+Lc/Udx0asw6YKbO
jpV+OTdrMB006rCXrnKBklpZvJ57aXyT2DztRJfEU+vXoGGNd84boUUTf+fr
6m1HZPGrdsBtvxAvBMUGiNtR18V+MbOv3IeBJxWHIulgoVTJ6lz8ICmhxtCq
a0/FY+t6qMiUKTQqTXvy8fQvixetsxKCBy7BoLjz7rT4pkI0Tptfeq29BZnT
LyEhISEhISEhISEhISEhISEhIYPyD17pEms=
    "], {{0, 100}, {206, 0}}, {0, 1},
    ColorFunction->GrayLevel],
   BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->{174.9375, Automatic},
  ImageSizeRaw->{206, 100},
  PlotRange->{{0, 206}, {0, 100}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[33]=",ExpressionUUID->"25a1e508-4561-499e-92d3-d97480d54dea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:50",ExpressionUUID->"4d54e2b7-a370-415f-8a2a-d396a55a55fe"],

Cell[BoxData[GridBox[{
   {"\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", " ", Cell[
    "a string ", "VocabularyText",ExpressionUUID->
     "031a0fe4-2aa1-468c-9247-d772266556ea"]},
   {
    RowBox[{
     ButtonBox["StringLength",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["length of a string ", "VocabularyText",ExpressionUUID->
     "45271e31-0b71-4eb8-be11-235fbc8153ff"]},
   {
    RowBox[{
     ButtonBox["StringReverse",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["reverse a string ", "VocabularyText",ExpressionUUID->
     "0e27761d-eccd-438a-a1fa-0b6135c64354"]},
   {
    RowBox[{
     ButtonBox["StringTake",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", ",", "4"}], 
     "]"}], " ", Cell[
    "take characters at the beginning of a string ", "VocabularyText",
     ExpressionUUID->"076a5262-cf99-4a77-81bd-64493a817f80"]},
   {
    RowBox[{
     ButtonBox["StringJoin",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\""}], "]"}], 
    " ", Cell[
    "join strings together ", "VocabularyText",ExpressionUUID->
     "24ad7f00-3bf1-420d-a2d8-be614504c047"]},
   {
    RowBox[{
     ButtonBox["StringJoin",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", ",", 
       "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\""}], "}"}], 
     "]"}], " ", Cell[
    "join a list of strings  ", "VocabularyText",ExpressionUUID->
     "f4a1febb-d065-4408-8613-00e789d27e3a"]},
   {
    RowBox[{
     ButtonBox["ToUpperCase",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["convert characters to uppercase ", "VocabularyText",ExpressionUUID->
     "576aa88d-d532-4424-8b6d-6e480b1bccf1"]},
   {
    RowBox[{
     ButtonBox["Characters",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["convert a string to a list of characters ", "VocabularyText",
     ExpressionUUID->"9eac8c77-eb75-4394-8430-fd923f7c0635"]},
   {
    RowBox[{
     ButtonBox["TextWords",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["list of words from a string ", "VocabularyText",ExpressionUUID->
     "1556167c-b3f2-494d-82fd-bd3b6442f071"]},
   {
    RowBox[{
     ButtonBox["TextSentences",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["list of sentences ", "VocabularyText",ExpressionUUID->
     "d918d77d-8bfb-493a-9453-4b4c09d1c61c"]},
   {
    RowBox[{
     ButtonBox["WikipediaData",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"topic\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["Wikipedia article about a topic ", "VocabularyText",ExpressionUUID->
     "df1264fd-9d99-453f-ba69-31c6541649b3"]},
   {
    RowBox[{
     ButtonBox["WordCloud",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"text\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["word cloud based on word frequencies ", "VocabularyText",
     ExpressionUUID->"3db37c14-21ea-465c-b81c-ee8bfb67db90"]},
   {
    RowBox[{
     ButtonBox["WordList",
      BaseStyle->"CodeLink"], "[", " ", "]"}], " ", Cell[
    "list of common words in English ", "VocabularyText",ExpressionUUID->
     "64c45ca5-1220-4f16-a254-9fcdfeca8a1b"]},
   {
    RowBox[{
     ButtonBox["Alphabet",
      BaseStyle->"CodeLink"], "[", "\[ThinSpace]", "]"}], " ", Cell[
    "list of letters of the alphabet ", "VocabularyText",ExpressionUUID->
     "eb4a9df0-ae4b-4647-895c-5d242d661947"]},
   {
    RowBox[{
     ButtonBox["LetterNumber",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"c\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", Cell[
    "where a letter appears in the alphabet ", "VocabularyText",
     ExpressionUUID->"6daf821e-dcac-444e-8db0-5dacab82c5c3"]},
   {
    RowBox[{
     ButtonBox["FromLetterNumber",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["n", "CodeVariableLrg"], "]"}], " ", Cell[
    "letter appearing at a position in the alphabet ", "VocabularyText",
     ExpressionUUID->"7a818888-279b-4bf3-ba61-7b26995e6ac9"]},
   {
    RowBox[{
     ButtonBox["Transliterate",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"text\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["transliterate text in any language into English", "VocabularyText",
     ExpressionUUID->"dfb16f7d-ad40-48cc-9e4d-8bf356b9ba3c"]},
   {
    RowBox[{
     ButtonBox["Transliterate",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"text\", \"CodeVariableLrg\"]\)\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"alphabet\", \"CodeVariableLrg\"]\)\>\""}], "]"}], 
    " ", Cell[
    "transliterate text into other alphabets", "VocabularyText",
     ExpressionUUID->"f40c0e37-da3c-4d86-8edc-ac0aa7b8dbc7"]},
   {
    RowBox[{
     ButtonBox["RomanNumeral",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["n", "CodeVariableLrg"], "]"}], " ", Cell[
    "convert a number to its Roman numeral string ", "VocabularyText",
     ExpressionUUID->"56baaef2-3a83-422f-93fb-c1b926de3957"]},
   {
    RowBox[{
     ButtonBox["IntegerName",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["n", "CodeVariableLrg"], "]"}], " ", Cell[
    "convert a number to its English name string", "VocabularyText",
     ExpressionUUID->"a009057f-e189-42f8-9776-9c29b1fe8eca"]},
   {
    RowBox[{
     ButtonBox["InputForm",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["show a string with quotes ", "VocabularyText",ExpressionUUID->
     "5f1707aa-8de7-47ec-9eb2-dfbad7f8bbde"]},
   {
    RowBox[{
     ButtonBox["Rasterize",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"string\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["make a bitmap image ", "VocabularyText",ExpressionUUID->
     "33744a99-6a97-408d-969f-12ca6e6a3fe7"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "Rows" -> {False, {True, True, True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True}, False}}},
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"fd00cb12-a7ed-4303-b459-cc4ca1573ea8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"d5408c30-9f43-4169-a5d7-e341bc53a607"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"30 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 13 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-11-strings-and-text-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"95ac9034-d460-46ad-94b5-cbaa0d9e6655"],

Cell[CellGroupData[{

Cell[TextData[{
 "Join two copies of the string ",
 Cell[BoxData["\<\"Hello\"\>"], "InlineCode",ExpressionUUID->
  "bb54e618-51a5-46dd-9543-e35b898ea299"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"310e89b5-c892-49d7-98f1-5e7732e358ed"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"HelloHello\"\>"], "ExerciseOutput",ExpressionUUID->
       "621a9e31-df76-4e6d-a79d-e533efcbc309"],
      Apply[TextCell, 
       Cell[
        BoxData["\"HelloHello\""], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8e40acb8-6e3a-4b9c-93f3-5a23564e4ba7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a single string of the whole alphabet, in uppercase.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"da7a0bf2-457b-4fe8-b428-e6d4bf756a47"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\>"], "ExerciseOutput",
       ExpressionUUID->"be36a068-bbfd-4d21-9909-0459352b4e1c"],
      Apply[TextCell, 
       Cell[
        BoxData["\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\""], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2ba5ab42-91de-4fc1-88d6-865b10b6196c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a string of the alphabet in reverse order.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7422e693-e5c8-4720-a3a0-827f8f45bc38"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"zyxwvutsrqponmlkjihgfedcba\"\>"], "ExerciseOutput",
       ExpressionUUID->"9d20c541-b68d-49d7-9d1a-a02284147554"],
      Apply[TextCell, 
       Cell[
        BoxData["\"zyxwvutsrqponmlkjihgfedcba\""], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"23540d4e-afbe-40af-877b-2a2e5c2d576b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Join 100 copies of the string ",
 Cell[BoxData["\<\"AGCT\"\>"], "InlineCode",ExpressionUUID->
  "af15b2ad-9cb8-4bcb-a185-dff7f9d78574"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:28",ExpressionUUID->"4b233154-aea9-4608-bcc4-80d9b6f61858"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"\
AGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAG\
CTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCT\
AGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAG\
CTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCT\
AGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAG\
CTAGCTAGCT\"\>"], "ExerciseOutput",ExpressionUUID->
       "fdd09701-0192-401e-9f55-5d7217ee5054"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "\"AGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGC\
TAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTA\
GCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGC\
TAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTA\
GCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGCTAGC\
TAGCTAGCTAGCTAGCTAGCT\""], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4aa622a3-28bd-401c-a3cd-530d8e3179d9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["StringTake",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["StringJoin",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Alphabet",
  BaseStyle->"Link"],
 " to get ",
 Cell[BoxData["\<\"abcdef\"\>"], "InlineCode",ExpressionUUID->
  "9662f5f6-8aff-4482-9228-cbd7cfb7cb53"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"020cdda1-ecc3-4ae4-9cca-dc15fc57d439"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"abcdef\"\>"], "ExerciseOutput",ExpressionUUID->
       "15c762c2-82cf-4cb1-a0d9-cd475ae738d7"],
      Apply[TextCell, 
       Cell[
        BoxData["\"abcdef\""], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f67e126f-7533-4599-ba50-33791fc342f2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Create a column with increasing numbers of letters from the string ",
 Cell[BoxData["\<\"this is about strings\"\>"], "InlineCode",ExpressionUUID->
  "d71800a4-093e-4276-80c1-c59ea8bec8ab"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"332c38f6-b59c-4f70-a93f-98ed684c1d7e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"\<\"t\"\>"},
          {"\<\"th\"\>"},
          {"\<\"thi\"\>"},
          {"\<\"this\"\>"},
          {"\<\"this \"\>"},
          {"\<\"this i\"\>"},
          {"\<\"this is\"\>"},
          {"\<\"this is \"\>"},
          {"\<\"this is a\"\>"},
          {"\<\"this is ab\"\>"},
          {"\<\"this is abo\"\>"},
          {"\<\"this is abou\"\>"},
          {"\<\"this is about\"\>"},
          {"\<\"this is about \"\>"},
          {"\<\"this is about s\"\>"},
          {"\<\"this is about st\"\>"},
          {"\<\"this is about str\"\>"},
          {"\<\"this is about stri\"\>"},
          {"\<\"this is about strin\"\>"},
          {"\<\"this is about string\"\>"},
          {"\<\"this is about strings\"\>"}
         },
         DefaultBaseStyle->"Column",
         GridBoxAlignment->{"Columns" -> {{Left}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Column"]], "ExerciseOutput",ExpressionUUID->
       "49fa5cd4-b8ba-4c8c-beb5-084008d9ded3"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{"\"t\""}, {"\"th\""}, {"\"thi\""}, {"\"this\""}, {
            "\"this \""}, {"\"this i\""}, {"\"this is\""}, {"\"this is \""}, {
            "\"this is a\""}, {"\"this is ab\""}, {"\"this is abo\""}, {
            "\"this is abou\""}, {"\"this is about\""}, {
            "\"this is about \""}, {"\"this is about s\""}, {
            "\"this is about st\""}, {"\"this is about str\""}, {
            "\"this is about stri\""}, {"\"this is about strin\""}, {
            "\"this is about string\""}, {"\"this is about strings\""}}, 
           DefaultBaseStyle -> "Column", 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1b198612-38e4-4569-af4e-40258ce844af"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a bar chart of the lengths of the words in \[OpenCurlyDoubleQuote]A \
long time ago, in a galaxy far, far away\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b5ea32b3-771b-44d8-a44e-6ff220b5e63d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {Opacity[0], PointBox[{0.3429357798165137, 0.}]}, {{}, 
          {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63], 
           Thickness[Small]}], 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{0.5412844036697247, 0.}, {1.4587155963302751`, 
                  1.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{13.081144222394839`, 33.61418872930899}, {
                 41.915254454380126`, 64.89781741247579}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{1.5412844036697246`, 0.}, {2.458715596330275, 
                  4.}, "RoundingRadius" -> 0]},
                ImageSizeCache->{{34.91716273493126, 
                 55.45020724184542}, {-25.532434419906863`, 
                 64.89781741247579}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{2.541284403669725, 0.}, {3.4587155963302756`, 
                  4.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{56.753181247467694`, 
                 77.28622575438186}, {-25.532434419906863`, 
                 64.89781741247579}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{3.5412844036697253`, 0.}, {4.458715596330276, 
                  3.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{78.58919976000413, 
                 99.12224426691829}, {-3.0498714618112075`, 
                 64.89781741247579}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[3, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{4.541284403669725, 0.}, {5.458715596330276, 
                  2.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{100.42521827254056`, 120.95826277945471`}, {
                 19.432691496284463`, 64.89781741247579}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{5.541284403669725, 0.}, {6.458715596330276, 
                  1.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{122.26123678507699`, 142.79428129199113`}, {
                 41.915254454380126`, 64.89781741247579}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{6.541284403669725, 0.}, {7.458715596330276, 
                  6.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{144.0972552976134, 
                 164.63029980452757`}, {-70.4975603360982, 
                 64.89781741247579}}],
               StatusArea[#, 6]& ,
               TagBoxNote->"6"],
              StyleBox["6", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[6, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{7.541284403669725, 0.}, {8.458715596330276, 
                  3.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{165.93327381014984`, 
                 186.46631831706398`}, {-3.0498714618112075`, 
                 64.89781741247579}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[3, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{8.541284403669724, 0.}, {9.458715596330276, 
                  3.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{187.76929232268623`, 
                 208.30233682960042`}, {-3.0498714618112075`, 
                 64.89781741247579}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[3, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{9.541284403669724, 0.}, {10.458715596330276`, 
                  4.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{209.60531083522267`, 
                 230.13835534213683`}, {-25.532434419906863`, 
                 64.89781741247579}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
         StyleBox[{
           {Thickness[Tiny], 
            LineBox[{{0.3429357798165137, 0.}, {10.66103119266055, 0.}}], 
            StyleBox[{}, "GraphicsLabel",
             StripOnInput->False]}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.5412844036697247, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {0.5412844036697247, 
                 0.}]}], 
              LineBox[{{10.458715596330276`, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {10.458715596330276`, 
                 0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
             StyleBox[{}, "GraphicsLabel",
              StripOnInput->False]}, "GraphicsTicks",
            StripOnInput->False]}, "GraphicsAxes",
          StripOnInput->False,
          Antialiasing->False]},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.3429357798165137, 0.},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {{{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        PlotRange->{{All, All}, {All, All}},
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{None, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "df44989d-4477-49ae-81da-6d80381b5e98"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{
            Opacity[0], 
            PointBox[{0.3429357798165137, 0.}]}, {{}, {
             RGBColor[0.982864, 0.7431472, 0.3262672], 
             EdgeForm[{
               Opacity[0.63], 
               Thickness[Small]}], {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.5412844036697247, 0.}, {
                    1.4587155963302751`, 1.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{13.081144222394839`, 
                   33.61418872930899}, {41.915254454380126`, 
                   64.89781741247579}}], StatusArea[#, 1]& , TagBoxNote -> 
                 "1"], 
                StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                Style[1, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.5412844036697246`, 0.}, {2.458715596330275,
                     4.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{34.91716273493126, 
                   55.45020724184542}, {-25.532434419906863`, 
                   64.89781741247579}}], StatusArea[#, 4]& , TagBoxNote -> 
                 "4"], 
                StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                Style[4, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.541284403669725, 0.}, {3.4587155963302756`,
                     4.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{56.753181247467694`, 
                   77.28622575438186}, {-25.532434419906863`, 
                   64.89781741247579}}], StatusArea[#, 4]& , TagBoxNote -> 
                 "4"], 
                StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                Style[4, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.5412844036697253`, 0.}, {4.458715596330276,
                     3.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{78.58919976000413, 
                   99.12224426691829}, {-3.0498714618112075`, 
                   64.89781741247579}}], StatusArea[#, 3]& , TagBoxNote -> 
                 "3"], 
                StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                Style[3, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.541284403669725, 0.}, {5.458715596330276, 
                    2.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{100.42521827254056`, 
                   120.95826277945471`}, {19.432691496284463`, 
                   64.89781741247579}}], StatusArea[#, 2]& , TagBoxNote -> 
                 "2"], 
                StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                Style[2, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{5.541284403669725, 0.}, {6.458715596330276, 
                    1.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{122.26123678507699`, 
                   142.79428129199113`}, {41.915254454380126`, 
                   64.89781741247579}}], StatusArea[#, 1]& , TagBoxNote -> 
                 "1"], 
                StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                Style[1, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6.541284403669725, 0.}, {7.458715596330276, 
                    6.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{144.0972552976134, 
                   164.63029980452757`}, {-70.4975603360982, 
                   64.89781741247579}}], StatusArea[#, 6]& , TagBoxNote -> 
                 "6"], 
                StyleBox["6", {}, StripOnInput -> False]], Annotation[#, 
                Style[6, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{7.541284403669725, 0.}, {8.458715596330276, 
                    3.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{165.93327381014984`, 
                   186.46631831706398`}, {-3.0498714618112075`, 
                   64.89781741247579}}], StatusArea[#, 3]& , TagBoxNote -> 
                 "3"], 
                StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                Style[3, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{8.541284403669724, 0.}, {9.458715596330276, 
                    3.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{187.76929232268623`, 
                   208.30233682960042`}, {-3.0498714618112075`, 
                   64.89781741247579}}], StatusArea[#, 3]& , TagBoxNote -> 
                 "3"], 
                StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                Style[3, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{9.541284403669724, 0.}, {10.458715596330276`,
                     4.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{209.60531083522267`, 
                   230.13835534213683`}, {-25.532434419906863`, 
                   64.89781741247579}}], StatusArea[#, 4]& , TagBoxNote -> 
                 "4"], 
                StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                Style[4, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
           StyleBox[{{
              Thickness[Tiny], 
              LineBox[{{0.3429357798165137, 0.}, {10.66103119266055, 0.}}], 
              StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
             StyleBox[{{
                Thickness[Tiny], 
                LineBox[{{0.5412844036697247, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {0.5412844036697247, 
                   0.}]}], 
                LineBox[{{10.458715596330276`, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {10.458715596330276`,
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
               StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
              "GraphicsTicks", StripOnInput -> False]}, "GraphicsAxes", 
            StripOnInput -> False, Antialiasing -> False]}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, True},
           AxesLabel -> {None, None}, AxesOrigin -> {0.3429357798165137, 0.}, 
          CoordinatesToolOptions :> {"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )}, FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {{{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], PlotRange -> {{All, All}, {All, All}}, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {None, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8ebffb53-c4dc-4a60-96dc-e6f620e5f44f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the string length of the Wikipedia article for \
\[OpenCurlyDoubleQuote]computer\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"633ca38e-91c1-44f0-90a7-00a20f95ca96"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "49848"], "ExerciseOutput",ExpressionUUID->
       "97a93405-21ec-494c-b598-c0ecc3234543"],
      Apply[TextCell, 
       Cell[
        BoxData["49848"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e498811b-c565-48ad-8d4b-025d4aa8a6bd"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find how many words are in the Wikipedia article for \
\[OpenCurlyDoubleQuote]computer\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b2aee78a-17d2-462d-b232-dd596e8d8b72"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "7742"], "ExerciseOutput",ExpressionUUID->
       "14cc77ec-dc27-4d83-945c-7b643b4df70e"],
      Apply[TextCell, 
       Cell[
        BoxData["7742"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6df4825c-d45d-4c7a-97bf-dc0b921ecb5c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the first sentence in the Wikipedia article about \
\[OpenCurlyDoubleQuote]strings\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"0e2e8d61-5202-4f41-933d-0b99d8b25c78"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"String is a flexible piece of rope or twine which is used \
to tie, bind, or hang other objects.\"\>"], "ExerciseOutput",ExpressionUUID->
       "5141f804-8f20-4545-80e5-1085d6331a61"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "\"String is a flexible piece of rope or twine which is used to tie, \
bind, or hang other objects.\""], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"28164449-3bff-4df8-acfe-7d5426b27976"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a string from the first letters of all sentences in the Wikipedia \
article about computers.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"bdeb71a9-ead1-4379-a7cc-94fca51c1b8c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"ASCTPMIDOMCPH=\\\"ITFTLTTTSITIIDMTTAAATTTIAATAIBIATITIITS=\
CATFTTTAEBNH=HTTTLHTWAB=THHHVTE=TDETTITPIRT=\
TEIBTDTTHACIINCTAILOIIIHBTCWATIHJTIWIAATBAITFCSTATHT=\
TDTKINHPTWTTTMIALITHTFMPWSTCBOTI=TTSTTITMWITCUTTS=FTHHIT=TEALTP=TBOBSA=TIET=\
CATDIRTPIWJSAITETSHTALATSGETTLSIETWOAMTTRACRIIISFIIGDOHCIAMTOBItSTBSITMSTSS=\
TITTITCIIA\\\"QCSLTTT=W\\\"A=HFMMH=C=C=W=T=TTSOSCT=\"\>"], "ExerciseOutput",
       ExpressionUUID->"e89c09b1-dcb3-472c-bc2c-157424342fe8"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "\"ASCTPMIDOMCPH=\\\"ITFTLTTTSITIIDMTTAAATTTIAATAIBIATITIITS=\
CATFTTTAEBNH=HTTTLHTWAB=THHHVTE=TDETTITPIRT=\
TEIBTDTTHACIINCTAILOIIIHBTCWATIHJTIWIAATBAITFCSTATHT=\
TDTKINHPTWTTTMIALITHTFMPWSTCBOTI=TTSTTITMWITCUTTS=FTHHIT=TEALTP=TBOBSA=TIET=\
CATDIRTPIWJSAITETSHTALATSGETTLSIETWOAMTTRACRIIISFIIGDOHCIAMTOBItSTBSITMSTSS=\
TITTITCIIA\\\"QCSLTTT=W\\\"A=HFMMH=C=C=W=T=TTSOSCT=\""], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d8191f3a-d827-4010-bb78-5593c632c316"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the maximum word length among English words from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", "\[ThinSpace]", "]"}]], "InlineCode",
  ExpressionUUID->"16930a23-8c23-430c-8353-d77ee8128c71"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4bd500c5-9296-4b73-a59c-e61412dc1c87"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "23"], "ExerciseOutput",ExpressionUUID->
       "36642bba-4708-4c49-bd21-8115a1b7ce9c"],
      Apply[TextCell, 
       Cell[
        BoxData["23"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bb31db79-dce6-4998-a209-fd269f6abdae"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Count the number of words in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "93531c21-dbad-4d1c-882c-78706e907cb7"],
 " that start with \[OpenCurlyDoubleQuote]q\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b9517e7b-d067-478d-9c58-e32589ec250d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "197"], "ExerciseOutput",ExpressionUUID->
       "14e7aec6-5d0c-4f59-bab6-4c38e0b572be"],
      Apply[TextCell, 
       Cell[
        BoxData["197"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f6f778cc-8ab8-4b93-89fc-1ea6360e241d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the lengths of the first 1000 words from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", "\[ThinSpace]", "]"}]], "InlineCode",
  ExpressionUUID->"06926757-191b-428d-8b93-83160805cd78"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1a9843aa-c7bc-4bd0-86f7-cfb4ed35f65b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.006944444444444445], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdmjmw81YZhjXQuFRB4YJCeBjGwzCM2c0asRsCxCQsN6wikGCWEBEIMbsI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            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{303.4296875, Automatic},
        Method->{},
        PlotRange->{{0., 1000.}, {0, 16.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "8592f873-104b-4095-80bc-9fcbfb0cb708"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{{
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[0.006944444444444445], 
                AbsoluteThickness[1.6], 
                LineBox[CompressedData["
1:eJxdmjmw81YZhjXQuFRB4YJCeBjGwzCM2c0asRsCxCQsN6wikGCWEBEIMbsI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                 "]]}}}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {303.4296875, Automatic}, 
          Method -> {}, PlotRange -> {{0., 1000.}, {0, 16.}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0cfc1b0f-fab8-4702-a067-0394f703c568"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["StringJoin",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Characters",
  BaseStyle->"Link"],
 " to make a word cloud of all letters in the words from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", "\[ThinSpace]", "]"}]], "InlineCode",
  ExpressionUUID->"d6fd8ece-0a2b-42f0-8420-411c19440e8c"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.15", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4b8a5327-3d75-4f38-b471-826ab2ff9f2b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {InsetBox[
           StyleBox["\<\"e\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.578512396694215],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
          InsetBox[
           StyleBox["\<\"a\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.42969026508914804`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {33., -2.}], 
          InsetBox[
           StyleBox["\<\"o\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.3656933297187769],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.363898, 0.618501, 0.782349]], {-32., 8.}], 
          InsetBox[
           StyleBox["\<\"n\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.4025504100235129],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {0., 35.}], 
          InsetBox[
           StyleBox["\<\"t\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.3944505307984978],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.772079, 0.431554, 0.102387]], {22., 29.}], 
          InsetBox[
           StyleBox["\<\"s\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.3653251533903671],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[1, 0.75, 0]], {-27., -23.}], InsetBox[
           StyleBox["\<\"r\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.3987108568843823],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {17., -35.}], 
          InsetBox[
           StyleBox["\<\"d\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.23784409967848125`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.40082222609352647`, 0.5220066643438841, 0.85]], {-21., 32.}], 
          InsetBox[
           StyleBox["\<\"i\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.4677570676158019],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {35., 30.}], 
          InsetBox[
           StyleBox["\<\"p\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.21283440765578843`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.9728288904374106, 0.621644452187053, 
              0.07336199581899142]], {0., -32.}], InsetBox[
           StyleBox["\<\"c\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.27445134604608207`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.571589, 0.586483, 0.]], {37., -31.}], 
          InsetBox[
           StyleBox["\<\"g\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.197213212007545],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.28026441037696703`, 0.715, 0.4292089322474965]], {-47., -14.}],
           InsetBox[
           StyleBox["\<\"b\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.17031004172445904`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8996399512215667, 0.7463488834690629, 0.]], {-39., 30.}], 
          InsetBox[
           StyleBox["\<\"y\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.18213113169733014`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.5833680111493557, 0.4126186601628758, 
              0.8290799721266107]], {-17., -47.}], InsetBox[
           StyleBox["\<\"h\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.18432704051320273`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.838355547812947, 0.44746667828057946`, 
              0.0208888695323676]], {48., 20.}], InsetBox[
           StyleBox["\<\"m\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.20611518966231],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.736782672705901, 0.358, 0.5030266573755369]], {-31., 50.}], 
          InsetBox[
           StyleBox["\<\"u\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.24476055499075067`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.915, 0.3325, 0.2125]], {-33., -49.}], 
          InsetBox[
           StyleBox["\<\"l\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.342748054966096],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.647624, 0.37816, 0.614037]], {-50., 7.}], 
          InsetBox[
           StyleBox["\<\"f\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.14795647892815106`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8439466852489265, 0.3467106629502147, 
              0.3309221912517893]], {51., 0.}], InsetBox[
           StyleBox["\<\"k\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.11898889137505311`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.6753413537738198, 0.3589675436319385, 
              0.5991466155654507]], {24., -48.}], InsetBox[
           StyleBox["\<\"w\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.12046159668869223`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.9324333565611593, 0.5282889043741062, 
              0.0921900209050434]], {0., -53.}], InsetBox[
           StyleBox["\<\"q\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.09079710394253294],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.47401116530937026`, 0.47809330081437784`, 0.85]], {55., -12.}],
           InsetBox[
           StyleBox["\<\"v\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.13149373738639952`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.28240003484173815`, 0.6090799721266095, 
              0.7538800418100857]], {12., 55.}], InsetBox[
           StyleBox["\<\"j\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0896925749573036],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.9874666782805795, 0.6948333914028977, 
              0.033839968642435214`]], {-57., 0.}], InsetBox[
           StyleBox["\<\"x\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0954256063568273],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8857244243136628, 0.3764133635295058, 
              0.1393110607841571]], {0., 54.}], InsetBox[
           StyleBox["\<\"z\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.09724018968970406],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[
             0.5407932311309059, 0.715, 0.09762679674248334]], {-45., -33.}], 
          InsetBox[
           StyleBox["\<\"'\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.08264462809917356],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.16397784358994957`, 0.7038177251280403, 
              0.6117734123079395]], {0., 21.}], InsetBox[
           StyleBox["\<\"-\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.08543224887141902],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.7748409210981391, 0.358, 0.4444755060028629]], {-10., 52.}]}},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
        PlotRange->{{-61.5, 59.5}, {-60.5, 61.5}}]], "ExerciseOutput",
       ExpressionUUID->"c2a231ec-c135-43a9-9dcc-4b0166a8abd1"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {
            InsetBox[
             StyleBox[
             "\"e\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.578512396694215], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
            InsetBox[
             StyleBox[
             "\"a\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.42969026508914804`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.560181, 0.691569, 0.194885]], {33., -2.}], 
            InsetBox[
             StyleBox[
             "\"o\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.3656933297187769], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.363898, 0.618501, 0.782349]], {-32., 8.}], 
            InsetBox[
             StyleBox[
             "\"n\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.4025504100235129], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.922526, 0.385626, 0.209179]], {0., 35.}], 
            InsetBox[
             StyleBox[
             "\"t\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.3944505307984978], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.772079, 0.431554, 0.102387]], {22., 29.}], 
            InsetBox[
             StyleBox[
             "\"s\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.3653251533903671], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[1, 0.75, 0]], {-27., -23.}], 
            InsetBox[
             StyleBox[
             "\"r\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.3987108568843823], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.528488, 0.470624, 0.701351]], {17., -35.}], 
            InsetBox[
             StyleBox[
             "\"d\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.23784409967848125`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.40082222609352647`, 0.5220066643438841, 0.85]], {-21., 32.}], 
            InsetBox[
             StyleBox[
             "\"i\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.4677570676158019], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.880722, 0.611041, 0.142051]], {35., 30.}], 
            InsetBox[
             StyleBox[
             "\"p\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.21283440765578843`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.9728288904374106, 0.621644452187053, 0.07336199581899142]], {
             0., -32.}], 
            InsetBox[
             StyleBox[
             "\"c\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.27445134604608207`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.571589, 0.586483, 0.]], {37., -31.}], 
            InsetBox[
             StyleBox[
             "\"g\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.197213212007545], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.28026441037696703`, 0.715, 
                0.4292089322474965]], {-47., -14.}], 
            InsetBox[
             StyleBox[
             "\"b\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.17031004172445904`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.8996399512215667, 0.7463488834690629, 0.]], {-39., 
             30.}], 
            InsetBox[
             StyleBox[
             "\"y\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.18213113169733014`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.5833680111493557, 0.4126186601628758, 
                0.8290799721266107]], {-17., -47.}], 
            InsetBox[
             StyleBox[
             "\"h\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.18432704051320273`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.838355547812947, 0.44746667828057946`, 
                0.0208888695323676]], {48., 20.}], 
            InsetBox[
             StyleBox[
             "\"m\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.20611518966231], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.736782672705901, 0.358, 0.5030266573755369]], {-31., 
             50.}], 
            InsetBox[
             StyleBox[
             "\"u\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.24476055499075067`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.915, 0.3325, 0.2125]], {-33., -49.}], 
            InsetBox[
             StyleBox[
             "\"l\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.342748054966096], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.647624, 0.37816, 0.614037]], {-50., 7.}], 
            InsetBox[
             StyleBox[
             "\"f\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.14795647892815106`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.8439466852489265, 0.3467106629502147, 0.3309221912517893]], {
             51., 0.}], 
            InsetBox[
             StyleBox[
             "\"k\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.11898889137505311`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.6753413537738198, 0.3589675436319385, 0.5991466155654507]], {
             24., -48.}], 
            InsetBox[
             StyleBox[
             "\"w\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.12046159668869223`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.9324333565611593, 0.5282889043741062, 0.0921900209050434]], {
             0., -53.}], 
            InsetBox[
             StyleBox[
             "\"q\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.09079710394253294], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.47401116530937026`, 0.47809330081437784`, 0.85]], {
             55., -12.}], 
            InsetBox[
             StyleBox[
             "\"v\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.13149373738639952`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.28240003484173815`, 0.6090799721266095, 
                0.7538800418100857]], {12., 55.}], 
            InsetBox[
             StyleBox[
             "\"j\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0896925749573036], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.9874666782805795, 0.6948333914028977, 
                0.033839968642435214`]], {-57., 0.}], 
            InsetBox[
             StyleBox[
             "\"x\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0954256063568273], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.8857244243136628, 0.3764133635295058, 0.1393110607841571]], {
             0., 54.}], 
            InsetBox[
             StyleBox[
             "\"z\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.09724018968970406], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.5407932311309059, 0.715, 
                0.09762679674248334]], {-45., -33.}], 
            InsetBox[
             StyleBox[
             "\"'\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.08264462809917356], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.16397784358994957`, 0.7038177251280403, 
                0.6117734123079395]], {0., 21.}], 
            InsetBox[
             StyleBox[
             "\"-\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.08543224887141902], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.7748409210981391, 0.358, 0.4444755060028629]], {-10.,
              52.}]}}, 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}, PlotRange -> {{-61.5, 59.5}, {-60.5, 61.5}}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e86b266d-3882-415b-a466-1370b629a012"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["StringReverse",
  BaseStyle->"Link"],
 " to make a word cloud of the last letters in the words from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", "\[ThinSpace]", "]"}]], "InlineCode",
  ExpressionUUID->"b0afc979-afc6-49c3-ad1f-a5bbe49201ba"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.16", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"88826d14-b45e-4a48-a074-5f9391f21967"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {InsetBox[
           StyleBox["\<\"y\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.552432988936446],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {0, 0}], 
          InsetBox[
           StyleBox["\<\"e\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.6481481481481481],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {28., -13.}], 
          InsetBox[
           StyleBox["\<\"d\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.379267725464988],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {-28., 0.}], 
          InsetBox[
           StyleBox["\<\"g\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.29758451834083266`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[1, 0.75, 0]], {-24., -25.}], InsetBox[
           StyleBox["\<\"s\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.3523012924028869],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {0., 31.}], 
          InsetBox[
           StyleBox["\<\"n\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.3444622130243691],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.363898, 0.618501, 0.782349]], {27., 19.}], 
          InsetBox[
           StyleBox["\<\"t\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.35120382128989436`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.772079, 0.431554, 0.102387]], {-18., 34.}], 
          InsetBox[
           StyleBox["\<\"r\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.3536339358972349],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {-31., 25.}], 
          InsetBox[
           StyleBox["\<\"m\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.16918039812071134`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.571589, 0.586483, 0.]], {0., -38.}], 
          InsetBox[
           StyleBox["\<\"k\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.14534959681001727`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.9728288904374106, 0.621644452187053, 
              0.07336199581899142]], {16., 37.}], InsetBox[
           StyleBox["\<\"h\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.15687304349643846`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.40082222609352647`, 0.5220066643438841, 0.85]], {43., 13.}], 
          InsetBox[
           StyleBox["\<\"l\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.2523530303267851],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.647624, 0.37816, 0.614037]], {-40., 18.}], 
          InsetBox[
           StyleBox["\<\"c\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.1647905136687414],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.915, 0.3325, 0.2125]], {15., -42.}], 
          InsetBox[
           StyleBox["\<\"p\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.13014178281569277`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.28026441037696703`, 0.715, 0.4292089322474965]], {-40., -18.}],
           InsetBox[
           StyleBox["\<\"a\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.13907833330720307`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.736782672705901, 0.358, 0.5030266573755369]], {28., 37.}], 
          InsetBox[
           StyleBox["\<\"b\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.10403764848522856`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8439466852489265, 0.3467106629502147, 
              0.3309221912517893]], {-46., 0.}], InsetBox[
           StyleBox["\<\"o\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.12269465740610089`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.838355547812947, 0.44746667828057946`, 
              0.0208888695323676]], {27., -41.}], InsetBox[
           StyleBox["\<\"w\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.10999534881290207`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.5833680111493557, 0.4126186601628758, 
              0.8290799721266107]], {0., 48.}], InsetBox[
           StyleBox["\<\"x\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.10333213134116195`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.28240003484173815`, 0.6090799721266095, 
              0.7538800418100857]], {-48., 11.}], InsetBox[
           StyleBox["\<\"f\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.10623259071121353`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8996399512215667, 0.7463488834690629, 0.]], {40., 27.}], 
          InsetBox[
           StyleBox["\<\"i\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.10019649958975485`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.9324333565611593, 0.5282889043741062, 
              0.0921900209050434]], {50., -2.}], InsetBox[
           StyleBox["\<\"v\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.09282776497394811],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8857244243136628, 0.3764133635295058, 
              0.1393110607841571]], {-14., -47.}], InsetBox[
           StyleBox["\<\"z\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.09510109799371827],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.5407932311309059, 0.715, 0.09762679674248334]], {-40., -31.}], 
          InsetBox[
           StyleBox["\<\"j\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.09259259259259259],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.47401116530937026`, 0.47809330081437784`, 
              0.85]], {-48., -13.}], InsetBox[
           StyleBox["\<\"u\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.09619856910671078],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.6753413537738198, 0.3589675436319385, 
              0.5991466155654507]], {-30., 42.}]}},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
        PlotRange->{{-54.5, 53.5}, {-51.5, 53.5}}]], "ExerciseOutput",
       ExpressionUUID->"46a417dc-be49-4fd1-828e-00df854b55d8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {
            InsetBox[
             StyleBox[
             "\"y\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.552432988936446], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.880722, 0.611041, 0.142051]], {0, 0}], 
            InsetBox[
             StyleBox[
             "\"e\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.6481481481481481], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.368417, 0.506779, 0.709798]], {28., -13.}], 
            InsetBox[
             StyleBox[
             "\"d\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.379267725464988], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.560181, 0.691569, 0.194885]], {-28., 0.}], 
            InsetBox[
             StyleBox[
             "\"g\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.29758451834083266`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[1, 0.75, 0]], {-24., -25.}], 
            InsetBox[
             StyleBox[
             "\"s\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.3523012924028869], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.528488, 0.470624, 0.701351]], {0., 31.}], 
            InsetBox[
             StyleBox[
             "\"n\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.3444622130243691], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.363898, 0.618501, 0.782349]], {27., 19.}], 
            InsetBox[
             StyleBox[
             "\"t\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.35120382128989436`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.772079, 0.431554, 0.102387]], {-18., 34.}], 
            InsetBox[
             StyleBox[
             "\"r\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.3536339358972349], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.922526, 0.385626, 0.209179]], {-31., 25.}], 
            InsetBox[
             StyleBox[
             "\"m\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.16918039812071134`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.571589, 0.586483, 0.]], {0., -38.}], 
            InsetBox[
             StyleBox[
             "\"k\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.14534959681001727`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.9728288904374106, 0.621644452187053, 0.07336199581899142]], {
             16., 37.}], 
            InsetBox[
             StyleBox[
             "\"h\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.15687304349643846`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85]], {43.,
              13.}], 
            InsetBox[
             StyleBox[
             "\"l\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.2523530303267851], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.647624, 0.37816, 0.614037]], {-40., 18.}], 
            InsetBox[
             StyleBox[
             "\"c\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.1647905136687414], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.915, 0.3325, 0.2125]], {15., -42.}], 
            InsetBox[
             StyleBox[
             "\"p\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.13014178281569277`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.28026441037696703`, 0.715, 
                0.4292089322474965]], {-40., -18.}], 
            InsetBox[
             StyleBox[
             "\"a\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.13907833330720307`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.736782672705901, 0.358, 0.5030266573755369]], {28., 
             37.}], 
            InsetBox[
             StyleBox[
             "\"b\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.10403764848522856`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.8439466852489265, 0.3467106629502147, 
                0.3309221912517893]], {-46., 0.}], 
            InsetBox[
             StyleBox[
             "\"o\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.12269465740610089`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.838355547812947, 0.44746667828057946`, 
                0.0208888695323676]], {27., -41.}], 
            InsetBox[
             StyleBox[
             "\"w\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.10999534881290207`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.5833680111493557, 0.4126186601628758, 0.8290799721266107]], {
             0., 48.}], 
            InsetBox[
             StyleBox[
             "\"x\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.10333213134116195`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.28240003484173815`, 0.6090799721266095, 
                0.7538800418100857]], {-48., 11.}], 
            InsetBox[
             StyleBox[
             "\"f\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.10623259071121353`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.8996399512215667, 0.7463488834690629, 0.]], {40., 
             27.}], 
            InsetBox[
             StyleBox[
             "\"i\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.10019649958975485`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.9324333565611593, 0.5282889043741062, 0.0921900209050434]], {
             50., -2.}], 
            InsetBox[
             StyleBox[
             "\"v\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.09282776497394811], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.8857244243136628, 0.3764133635295058, 
                0.1393110607841571]], {-14., -47.}], 
            InsetBox[
             StyleBox[
             "\"z\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.09510109799371827], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.5407932311309059, 0.715, 
                0.09762679674248334]], {-40., -31.}], 
            InsetBox[
             StyleBox[
             "\"j\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.09259259259259259], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.47401116530937026`, 0.47809330081437784`, 
                0.85]], {-48., -13.}], 
            InsetBox[
             StyleBox[
             "\"u\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.09619856910671078], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.6753413537738198, 0.3589675436319385, 
                0.5991466155654507]], {-30., 42.}]}}, 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}, PlotRange -> {{-54.5, 53.5}, {-51.5, 53.5}}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4a5a8f6b-2cb4-4fee-ba40-d3b534e165c2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the Roman numerals for the year 1959.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.17", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"11c955da-7e85-4575-8ce3-a4096e8cf29c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"MCMLIX\"\>"], "ExerciseOutput",ExpressionUUID->
       "1570a106-fe65-4595-9158-64e58c89b57d"],
      Apply[TextCell, 
       Cell[
        BoxData["\"MCMLIX\""], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c8dc0769-60cd-4104-9a93-a54b26bcb03c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the maximum string length of any Roman-numeral year from 1 to 2020.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.18", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"8a3a0fca-6621-4769-9eab-daeae1c314f5"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "13"], "ExerciseOutput",ExpressionUUID->
       "1526f1a3-6cc1-4123-a34c-54dfd5561245"],
      Apply[TextCell, 
       Cell[
        BoxData["13"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2e671c49-0751-4ff8-b661-e451dfc4720f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a word cloud from the first characters of the Roman numerals up to \
100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.19", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"bfc93c2c-7eb6-4f1a-b74a-412c19fca4d9"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {InsetBox[
           StyleBox["\<\"X\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[1.1475409836065575`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
          InsetBox[
           StyleBox["\<\"L\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.9468049514887923],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.880722, 0.611041, 0.142051]], {-20.5, -11.5}], InsetBox[
           StyleBox["\<\"V\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.22415523586483774`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {17.5, 2.5}], 
          InsetBox[
           StyleBox["\<\"C\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.1639344262295082],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {-17.5, 5.5}],
           InsetBox[
           StyleBox["\<\"I\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.24422883907661427`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.560181, 0.691569, 0.194885]], {-0.5, -18.5}]}},
        Background->GrayLevel[0, 0],
        ImageSize->{61., 64.},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
        PlotRange->{{-36., 25.}, {-29., 35.}}]], "ExerciseOutput",
       ExpressionUUID->"14c6141c-dec2-4e6c-b8f2-4824828fc1df"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {
            InsetBox[
             StyleBox[
             "\"X\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[1.1475409836065575`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
            InsetBox[
             StyleBox[
             "\"L\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.9468049514887923], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.880722, 0.611041, 0.142051]], {-20.5, -11.5}], 
            InsetBox[
             StyleBox[
             "\"V\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.22415523586483774`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.922526, 0.385626, 0.209179]], {17.5, 2.5}], 
            InsetBox[
             StyleBox[
             "\"C\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.1639344262295082], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.528488, 0.470624, 0.701351]], {-17.5, 5.5}], 
            InsetBox[
             StyleBox[
             "\"I\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.24422883907661427`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.560181, 0.691569, 0.194885]], {-0.5, -18.5}]}}, 
          Background -> GrayLevel[0, 0], ImageSize -> {61., 64.}, 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}, PlotRange -> {{-36., 25.}, {-29., 35.}}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7dc42a6c-fac9-4ca3-98b5-5993bd089ae4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Length",
  BaseStyle->"Link"],
 " to find the length of the Russian alphabet.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.20", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"16476dd2-ac55-4716-a6bf-99ce81fcfe86"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "33"], "ExerciseOutput",ExpressionUUID->
       "ee5b7252-3cf2-4215-a83b-bb69465746bf"],
      Apply[TextCell, 
       Cell[
        BoxData["33"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0f58b842-e20b-42f3-879f-47c85623d86e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate the uppercase Greek alphabet.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.21", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:29",ExpressionUUID->"ddf49df1-5cc0-4fc0-83e8-2e4743c53296"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"\[CapitalAlpha]\"\>", ",", "\<\"\[CapitalBeta]\"\>", 
         ",", "\<\"\[CapitalGamma]\"\>", ",", "\<\"\[CapitalDelta]\"\>", 
         ",", "\<\"\[CapitalEpsilon]\"\>", ",", "\<\"\[CapitalZeta]\"\>", 
         ",", "\<\"\[CapitalEta]\"\>", ",", "\<\"\[CapitalTheta]\"\>", 
         ",", "\<\"\[CapitalIota]\"\>", ",", "\<\"\[CapitalKappa]\"\>", 
         ",", "\<\"\[CapitalLambda]\"\>", ",", "\<\"\[CapitalMu]\"\>", 
         ",", "\<\"\[CapitalNu]\"\>", ",", "\<\"\[CapitalXi]\"\>", 
         ",", "\<\"\[CapitalOmicron]\"\>", ",", "\<\"\[CapitalPi]\"\>", 
         ",", "\<\"\[CapitalRho]\"\>", ",", "\<\"\[CapitalSigma]\"\>", 
         ",", "\<\"\[CapitalTau]\"\>", ",", "\<\"\[CapitalUpsilon]\"\>", 
         ",", "\<\"\[CapitalPhi]\"\>", ",", "\<\"\[CapitalChi]\"\>", 
         ",", "\<\"\[CapitalPsi]\"\>", ",", "\<\"\[CapitalOmega]\"\>"}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "3c2cd215-924d-4c33-bf2a-3907f50e8aa0"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"\[CapitalAlpha]\"", ",", "\"\[CapitalBeta]\"", ",", 
             "\"\[CapitalGamma]\"", ",", "\"\[CapitalDelta]\"", ",", 
             "\"\[CapitalEpsilon]\"", ",", "\"\[CapitalZeta]\"", ",", 
             "\"\[CapitalEta]\"", ",", "\"\[CapitalTheta]\"", ",", 
             "\"\[CapitalIota]\"", ",", "\"\[CapitalKappa]\"", ",", 
             "\"\[CapitalLambda]\"", ",", "\"\[CapitalMu]\"", ",", 
             "\"\[CapitalNu]\"", ",", "\"\[CapitalXi]\"", ",", 
             "\"\[CapitalOmicron]\"", ",", "\"\[CapitalPi]\"", ",", 
             "\"\[CapitalRho]\"", ",", "\"\[CapitalSigma]\"", ",", 
             "\"\[CapitalTau]\"", ",", "\"\[CapitalUpsilon]\"", ",", 
             "\"\[CapitalPhi]\"", ",", "\"\[CapitalChi]\"", ",", 
             "\"\[CapitalPsi]\"", ",", "\"\[CapitalOmega]\""}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"57ebda89-2f51-47c0-a3cb-6f6952ea1177"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a bar chart of the letter numbers in \[OpenCurlyDoubleQuote]wolfram\
\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.22", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"26977dc6-3fdc-4a55-bc1b-f5c5cb8e2d8d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {Opacity[0], PointBox[{0.40424519670631287`, 0.}]}, {{}, 
          {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.651],
            Thickness[Small]}], 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.651], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{0.5425434583714547, 0.}, {1.4574565416285452`, 
                  23.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{17.986988913212343`, 
                 46.51681765899392}, {-68.65522206792213, 63.80764746872629}}],
               StatusArea[#, 23]& ,
               TagBoxNote->"23"],
              StyleBox["23", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[23, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.651], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{1.5425434583714546`, 0.}, {2.457456541628545, 
                  15.}, "RoundingRadius" -> 0]},
                ImageSizeCache->{{48.62359173235161, 
                 77.1534204781332}, {-22.755093533435726`, 
                 63.80764746872629}}],
               StatusArea[#, 15]& ,
               TagBoxNote->"15"],
              StyleBox["15", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[15, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.651], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{2.542543458371455, 0.}, {3.457456541628545, 
                  12.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{79.26019455149088, 
                 107.79002329727246`}, {-5.542545333003318, 
                 63.80764746872629}}],
               StatusArea[#, 12]& ,
               TagBoxNote->"12"],
              StyleBox["12", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[12, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.651], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{3.542543458371455, 0.}, {4.457456541628545, 
                  6.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{109.89679737063017`, 138.42662611641174`}, {
                 28.882551067861485`, 63.80764746872629}}],
               StatusArea[#, 6]& ,
               TagBoxNote->"6"],
              StyleBox["6", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[6, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.651], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{4.542543458371455, 0.}, {5.457456541628545, 
                  18.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{140.53340018976942`, 
                 169.06322893555102`}, {-39.96764173386812, 
                 63.80764746872629}}],
               StatusArea[#, 18]& ,
               TagBoxNote->"18"],
              StyleBox["18", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[18, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.651], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{5.542543458371455, 0.}, {6.457456541628545, 
                  1.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{171.1700030089087, 199.69983175469028`}, {
                 57.57013140191549, 63.80764746872629}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.651], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{6.542543458371455, 0.}, {7.457456541628545, 
                  13.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{201.80660582804796`, 
                 230.33643457382956`}, {-11.280061399814116`, 
                 63.80764746872629}}],
               StatusArea[#, 13]& ,
               TagBoxNote->"13"],
              StyleBox["13", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[13, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
         StyleBox[{
           {Thickness[Tiny], 
            LineBox[{{0.40424519670631287`, 0.}, {7.598520768526989, 0.}}], 
            StyleBox[{}, "GraphicsLabel",
             StripOnInput->False]}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.5425434583714547, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {0.5425434583714547, 
                 0.}]}], 
              LineBox[{{7.457456541628544, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {7.457456541628544, 
                 0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
             StyleBox[{}, "GraphicsLabel",
              StripOnInput->False]}, "GraphicsTicks",
            StripOnInput->False]}, "GraphicsAxes",
          StripOnInput->False,
          Antialiasing->False]},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.40424519670631287`, 0.},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {{{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        PlotRange->{{All, All}, {All, All}},
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{None, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "e73f4010-bb65-441a-8045-e664c55919af"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{
            Opacity[0], 
            PointBox[{0.40424519670631287`, 0.}]}, {{}, {
             RGBColor[0.982864, 0.7431472, 0.3262672], 
             EdgeForm[{
               Opacity[0.651], 
               Thickness[Small]}], {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.651], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.5425434583714547, 0.}, {
                    1.4574565416285452`, 23.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{18.968157851375846`, 
                   47.37340958050951}, {-68.68675441428692, 
                   63.18961347997643}}], StatusArea[#, 23]& , TagBoxNote -> 
                 "23"], 
                StyleBox["23", {}, StripOnInput -> False]], Annotation[#, 
                Style[23, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.651], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.5425434583714546`, 0.}, {2.457456541628545,
                     15.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{49.46859799131894, 
                   77.87384972045261}, {-22.990626451064884`, 
                   63.18961347997643}}], StatusArea[#, 15]& , TagBoxNote -> 
                 "15"], 
                StyleBox["15", {}, StripOnInput -> False]], Annotation[#, 
                Style[15, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.651], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.542543458371455, 0.}, {3.457456541628545, 
                    12.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{79.96903813126204, 
                   108.3742898603957}, {-5.8545784648566155`, 
                   63.18961347997643}}], StatusArea[#, 12]& , TagBoxNote -> 
                 "12"], 
                StyleBox["12", {}, StripOnInput -> False]], Annotation[#, 
                Style[12, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.651], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.542543458371455, 0.}, {4.457456541628545, 
                    6.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{110.46947827120515`, 
                   138.8747300003388}, {28.417517507559907`, 
                   63.18961347997643}}], StatusArea[#, 6]& , TagBoxNote -> 
                 "6"], 
                StyleBox["6", {}, StripOnInput -> False]], Annotation[#, 
                Style[6, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.651], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.542543458371455, 0.}, {5.457456541628545, 
                    18.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{140.96991841114823`, 
                   169.3751701402819}, {-40.12667443727314, 
                   63.18961347997643}}], StatusArea[#, 18]& , TagBoxNote -> 
                 "18"], 
                StyleBox["18", {}, StripOnInput -> False]], Annotation[#, 
                Style[18, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.651], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{5.542543458371455, 0.}, {6.457456541628545, 
                    1.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{171.47035855109135`, 
                   199.87561028022498`}, {56.97759748457368, 
                   63.18961347997643}}], StatusArea[#, 1]& , TagBoxNote -> 
                 "1"], 
                StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                Style[1, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.651], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6.542543458371455, 0.}, {7.457456541628545, 
                    13.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{201.97079869103442`, 
                   230.3760504201681}, {-11.566594460259367`, 
                   63.18961347997643}}], StatusArea[#, 13]& , TagBoxNote -> 
                 "13"], 
                StyleBox["13", {}, StripOnInput -> False]], Annotation[#, 
                Style[13, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
           StyleBox[{{
              Thickness[Tiny], 
              LineBox[{{0.40424519670631287`, 0.}, {7.598520768526989, 0.}}], 
              
              StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
             StyleBox[{{
                Thickness[Tiny], 
                LineBox[{{0.5425434583714547, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {0.5425434583714547, 
                   0.}]}], 
                LineBox[{{7.457456541628544, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {7.457456541628544, 
                   0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
               StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
              "GraphicsTicks", StripOnInput -> False]}, "GraphicsAxes", 
            StripOnInput -> False, Antialiasing -> False]}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, True},
           AxesLabel -> {None, None}, 
          AxesOrigin -> {0.40424519670631287`, 0.}, 
          CoordinatesToolOptions :> {"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )}, FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {{{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], PlotRange -> {{All, All}, {All, All}}, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {None, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"66c4148e-fd11-4000-b0bf-ab9760c82ff3"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["FromLetterNumber",
  BaseStyle->"Link"],
 " to make a string of 1000 random letters.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.23", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4360f85e-b4e1-4884-930f-8dad04715083"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"\
chfpmqpcyncvrvvsczeyfihbbtyvwtejczkwdpfxwtfncqphiptelkyrkectbxxccksjxzubmcfsdv\
eiexjzvldmyduewyayvstpajkttgelnayfsnlrnvmvhoomknurnjobsexzxiajjwdewgxldwjnwgqt\
muwqalzopswwbvbrcdkaczpvpekkbcwotsevhukcbzjrbgtheypludcajvdcukftzsctsctvuimuji\
yrbgkaeuuiavggepzipouyhyvqlyjvbewluhqfgvmwwqtzjwmeoyjsbinlvmzpbjrdlelyrfzpwfjf\
hlowquqawzrbufvilscljlptgilvzggomjtlbtbvttwcqrucmsydwmbxqedqewjdfsevrzybymhwal\
zbaqazkhsrbfsalmtkxbcyxliaapasvdqvtqptoudinbabftutdoijvlmlgnodeiyprjkmfsdhdqma\
gbohksoyevwpljdmdglibgtrfbplfsewhrnoqnkryhaazlfqlikxmrwamtfdwiqyalivbqgrocsiav\
czjgtidffntqavtjtpwyjpbynwmmxfhnkzynrcvmewbtdsoanygujfooupnozbaetulhrpbngnxojq\
nbtsmtfelnrqsydvlxlxtcgfltegagyobeonakngwjchqgpycjdzaotfvxigouzmogrdpwwkkttsie\
ddsmahqthvymvkcjlzigwenxvekurkixqjrormukhqyyzygvzntzptuooboriyjkaxofuediewvxrr\
ifcdjfrlqeuneyrwppapdpooitwcevydjozxxfwlnzwulzjacoiryqogroikztsbbwbkfcjqvjlvdw\
abuiwoehnqbuxodlwnqidwbtzpbkdfwmjgtczbqbgldivjjprzuslsoszcghcklobxeknddhkgjvvh\
tsuffdrfhefjhawtxylpfxzjumgbcdhetsankemseloadcegkizwddlsqwzuxbpz\"\>"], 
       "ExerciseOutput",ExpressionUUID->
       "81a3ba55-8d03-4376-a74d-0b0aced9dadd"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "\"chfpmqpcyncvrvvsczeyfihbbtyvwtejczkwdpfxwtfncqphiptelkyrkectbxxccks\
jxzubmcfsdveiexjzvldmyduewyayvstpajkttgelnayfsnlrnvmvhoomknurnjobsexzxiajjwdew\
gxldwjnwgqtmuwqalzopswwbvbrcdkaczpvpekkbcwotsevhukcbzjrbgtheypludcajvdcukftzsc\
tsctvuimujiyrbgkaeuuiavggepzipouyhyvqlyjvbewluhqfgvmwwqtzjwmeoyjsbinlvmzpbjrdl\
elyrfzpwfjfhlowquqawzrbufvilscljlptgilvzggomjtlbtbvttwcqrucmsydwmbxqedqewjdfse\
vrzybymhwalzbaqazkhsrbfsalmtkxbcyxliaapasvdqvtqptoudinbabftutdoijvlmlgnodeiypr\
jkmfsdhdqmagbohksoyevwpljdmdglibgtrfbplfsewhrnoqnkryhaazlfqlikxmrwamtfdwiqyali\
vbqgrocsiavczjgtidffntqavtjtpwyjpbynwmmxfhnkzynrcvmewbtdsoanygujfooupnozbaetul\
hrpbngnxojqnbtsmtfelnrqsydvlxlxtcgfltegagyobeonakngwjchqgpycjdzaotfvxigouzmogr\
dpwwkkttsieddsmahqthvymvkcjlzigwenxvekurkixqjrormukhqyyzygvzntzptuooboriyjkaxo\
fuediewvxrrifcdjfrlqeuneyrwppapdpooitwcevydjozxxfwlnzwulzjacoiryqogroikztsbbwb\
kfcjqvjlvdwabuiwoehnqbuxodlwnqidwbtzpbkdfwmjgtczbqbgldivjjprzuslsoszcghcklobxe\
knddhkgjvvhtsuffdrfhefjhawtxylpfxzjumgbcdhetsankemseloadcegkizwddlsqwzuxbpz\"\
"], "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"697bfdb3-4a73-452b-8eae-abb42a87196e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of 100 random 5-letter strings.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.24", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"14b988ea-7836-4c09-80fb-b38224b99178"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"vjdxl\"\>", ",", "\<\"yeftc\"\>", ",", "\<\"tguag\"\>", 
         ",", "\<\"rsdyz\"\>", ",", "\<\"jvbgm\"\>", ",", "\<\"pdntg\"\>", 
         ",", "\<\"wqupa\"\>", ",", "\<\"xznnh\"\>", ",", "\<\"gmuvl\"\>", 
         ",", "\<\"nzxqd\"\>", ",", "\<\"qnokn\"\>", ",", "\<\"tyues\"\>", 
         ",", "\<\"ukblh\"\>", ",", "\<\"mdats\"\>", ",", "\<\"pbjuu\"\>", 
         ",", "\<\"hjifa\"\>", ",", "\<\"xnbtw\"\>", ",", "\<\"xquds\"\>", 
         ",", "\<\"egttt\"\>", ",", "\<\"fkkax\"\>", ",", "\<\"udcrc\"\>", 
         ",", "\<\"aucim\"\>", ",", "\<\"lulzv\"\>", ",", "\<\"isjpn\"\>", 
         ",", "\<\"umgax\"\>", ",", "\<\"kdhoy\"\>", ",", "\<\"nysyq\"\>", 
         ",", "\<\"ukhwl\"\>", ",", "\<\"remdz\"\>", ",", "\<\"ljjzn\"\>", 
         ",", "\<\"ujtti\"\>", ",", "\<\"bircn\"\>", ",", "\<\"hnaqd\"\>", 
         ",", "\<\"jhfwg\"\>", ",", "\<\"jlyju\"\>", ",", "\<\"jcegb\"\>", 
         ",", "\<\"gcnso\"\>", ",", "\<\"rryks\"\>", ",", "\<\"hbnhg\"\>", 
         ",", "\<\"gvoko\"\>", ",", "\<\"pcwjk\"\>", ",", "\<\"lnhps\"\>", 
         ",", "\<\"umjom\"\>", ",", "\<\"knfia\"\>", ",", "\<\"gpxvw\"\>", 
         ",", "\<\"esvzo\"\>", ",", "\<\"euiam\"\>", ",", "\<\"vxlnl\"\>", 
         ",", "\<\"yajli\"\>", ",", "\<\"twfiz\"\>", ",", "\<\"veong\"\>", 
         ",", "\<\"htndw\"\>", ",", "\<\"fggfy\"\>", ",", "\<\"jkvou\"\>", 
         ",", "\<\"yurvh\"\>", ",", "\<\"buesn\"\>", ",", "\<\"svgzn\"\>", 
         ",", "\<\"paevj\"\>", ",", "\<\"bmrza\"\>", ",", "\<\"hbiqc\"\>", 
         ",", "\<\"cjazs\"\>", ",", "\<\"kkiuw\"\>", ",", "\<\"wtzrl\"\>", 
         ",", "\<\"lqcpm\"\>", ",", "\<\"pwnng\"\>", ",", "\<\"xepji\"\>", 
         ",", "\<\"wmmcl\"\>", ",", "\<\"fhlfe\"\>", ",", "\<\"thakf\"\>", 
         ",", "\<\"nckgv\"\>", ",", "\<\"fzttu\"\>", ",", "\<\"hdffz\"\>", 
         ",", "\<\"uadni\"\>", ",", "\<\"asfav\"\>", ",", "\<\"wouah\"\>", 
         ",", "\<\"rtzaz\"\>", ",", "\<\"kjfhi\"\>", ",", "\<\"jaaiu\"\>", 
         ",", "\<\"uinzk\"\>", ",", "\<\"bcarm\"\>", ",", "\<\"zujeq\"\>", 
         ",", "\<\"icoko\"\>", ",", "\<\"ccaxw\"\>", ",", "\<\"eynlq\"\>", 
         ",", "\<\"gnlso\"\>", ",", "\<\"jpkiu\"\>", ",", "\<\"wsrhb\"\>", 
         ",", "\<\"bjlvz\"\>", ",", "\<\"ahdmc\"\>", ",", "\<\"nqpot\"\>", 
         ",", "\<\"netkc\"\>", ",", "\<\"cxnzv\"\>", ",", "\<\"lyfky\"\>", 
         ",", "\<\"uebwg\"\>", ",", "\<\"lklqj\"\>", ",", "\<\"iwvlp\"\>", 
         ",", "\<\"ayxfv\"\>", ",", "\<\"rxjge\"\>", ",", "\<\"mheur\"\>", 
         ",", "\<\"gxzmo\"\>"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "f0571206-4dd2-4e16-8887-04726dc973e3"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"vjdxl\"", ",", "\"yeftc\"", ",", "\"tguag\"", ",", 
             "\"rsdyz\"", ",", "\"jvbgm\"", ",", "\"pdntg\"", ",", 
             "\"wqupa\"", ",", "\"xznnh\"", ",", "\"gmuvl\"", ",", 
             "\"nzxqd\"", ",", "\"qnokn\"", ",", "\"tyues\"", ",", 
             "\"ukblh\"", ",", "\"mdats\"", ",", "\"pbjuu\"", ",", 
             "\"hjifa\"", ",", "\"xnbtw\"", ",", "\"xquds\"", ",", 
             "\"egttt\"", ",", "\"fkkax\"", ",", "\"udcrc\"", ",", 
             "\"aucim\"", ",", "\"lulzv\"", ",", "\"isjpn\"", ",", 
             "\"umgax\"", ",", "\"kdhoy\"", ",", "\"nysyq\"", ",", 
             "\"ukhwl\"", ",", "\"remdz\"", ",", "\"ljjzn\"", ",", 
             "\"ujtti\"", ",", "\"bircn\"", ",", "\"hnaqd\"", ",", 
             "\"jhfwg\"", ",", "\"jlyju\"", ",", "\"jcegb\"", ",", 
             "\"gcnso\"", ",", "\"rryks\"", ",", "\"hbnhg\"", ",", 
             "\"gvoko\"", ",", "\"pcwjk\"", ",", "\"lnhps\"", ",", 
             "\"umjom\"", ",", "\"knfia\"", ",", "\"gpxvw\"", ",", 
             "\"esvzo\"", ",", "\"euiam\"", ",", "\"vxlnl\"", ",", 
             "\"yajli\"", ",", "\"twfiz\"", ",", "\"veong\"", ",", 
             "\"htndw\"", ",", "\"fggfy\"", ",", "\"jkvou\"", ",", 
             "\"yurvh\"", ",", "\"buesn\"", ",", "\"svgzn\"", ",", 
             "\"paevj\"", ",", "\"bmrza\"", ",", "\"hbiqc\"", ",", 
             "\"cjazs\"", ",", "\"kkiuw\"", ",", "\"wtzrl\"", ",", 
             "\"lqcpm\"", ",", "\"pwnng\"", ",", "\"xepji\"", ",", 
             "\"wmmcl\"", ",", "\"fhlfe\"", ",", "\"thakf\"", ",", 
             "\"nckgv\"", ",", "\"fzttu\"", ",", "\"hdffz\"", ",", 
             "\"uadni\"", ",", "\"asfav\"", ",", "\"wouah\"", ",", 
             "\"rtzaz\"", ",", "\"kjfhi\"", ",", "\"jaaiu\"", ",", 
             "\"uinzk\"", ",", "\"bcarm\"", ",", "\"zujeq\"", ",", 
             "\"icoko\"", ",", "\"ccaxw\"", ",", "\"eynlq\"", ",", 
             "\"gnlso\"", ",", "\"jpkiu\"", ",", "\"wsrhb\"", ",", 
             "\"bjlvz\"", ",", "\"ahdmc\"", ",", "\"nqpot\"", ",", 
             "\"netkc\"", ",", "\"cxnzv\"", ",", "\"lyfky\"", ",", 
             "\"uebwg\"", ",", "\"lklqj\"", ",", "\"iwvlp\"", ",", 
             "\"ayxfv\"", ",", "\"rxjge\"", ",", "\"mheur\"", ",", 
             "\"gxzmo\""}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8701859e-0257-4788-9560-b0d2ecf3685a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Transliterate \[OpenCurlyDoubleQuote]wolfram\[CloseCurlyDoubleQuote] into \
Greek.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.25", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"8c89d6c5-a158-4bf0-814d-f3e5e9ca72a0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"\[Beta]\[Omicron]\[Lambda]\[CurlyPhi]\[Rho]\[Alpha]\[Mu]\"\
\>"], "ExerciseOutput",ExpressionUUID->"41fc30f1-3374-4e3c-86e5-92814331daaa"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "\"\[Beta]\[Omicron]\[Lambda]\[CurlyPhi]\[Rho]\[Alpha]\[Mu]\""], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"31af64e6-0519-4c1c-8b50-7aa742596f99"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Get the Arabic alphabet and transliterate it into English.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.26", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"83553475-c35b-4803-8c86-be9e267150ea"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"t\"\>", 
         ",", "\<\"th\"\>", ",", "\<\"j\"\>", ",", "\<\"h\"\>", 
         ",", "\<\"kh\"\>", ",", "\<\"d\"\>", ",", "\<\"dh\"\>", 
         ",", "\<\"r\"\>", ",", "\<\"z\"\>", ",", "\<\"s\"\>", 
         ",", "\<\"sh\"\>", ",", "\<\"s\"\>", ",", "\<\"d\"\>", 
         ",", "\<\"t\"\>", ",", "\<\"z\"\>", ",", "\<\"\:02bf\"\>", 
         ",", "\<\"gh\"\>", ",", "\<\"f\"\>", ",", "\<\"q\"\>", 
         ",", "\<\"k\"\>", ",", "\<\"l\"\>", ",", "\<\"m\"\>", 
         ",", "\<\"n\"\>", ",", "\<\"h\"\>", ",", "\<\"w\"\>", 
         ",", "\<\"y\"\>"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "fa121cf6-2911-46d4-98b2-87d0f9ffb7ca"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"a\"", ",", "\"b\"", ",", "\"t\"", ",", "\"th\"", ",", 
             "\"j\"", ",", "\"h\"", ",", "\"kh\"", ",", "\"d\"", ",", 
             "\"dh\"", ",", "\"r\"", ",", "\"z\"", ",", "\"s\"", ",", 
             "\"sh\"", ",", "\"s\"", ",", "\"d\"", ",", "\"t\"", ",", "\"z\"",
              ",", "\"\:02bf\"", ",", "\"gh\"", ",", "\"f\"", ",", "\"q\"", 
             ",", "\"k\"", ",", "\"l\"", ",", "\"m\"", ",", "\"n\"", ",", 
             "\"h\"", ",", "\"w\"", ",", "\"y\""}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d674d10e-a796-4cab-89af-d7fc3849a00d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a white-on-black size-200 letter \[OpenCurlyDoubleQuote]A\
\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.27", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"24a83f2b-a56c-4795-b297-0c882bc68680"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJztnb2OIkcUhUd2ByRIJiAhQRYJCQkJTghMhJMJ1jiZiF3tuOXAWJq1sByQ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          "], {{0, 252}, {109, 
          0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSize->Automatic,
        ImageSizeRaw->{109, 252},
        PlotRange->{{0, 109}, {0, 252}}]], "ExerciseOutput",ExpressionUUID->
       "a8b3f691-d25e-4704-a454-c45bee3f882a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          TagBox[
           RasterBox[CompressedData["
1:eJztnb2OIkcUhUd2ByRIJiAhQRYJCQkJTghMhJMJ1jiZiF3tuOXAWJq1sByQ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            "], {{0, 252}, {109, 
            0}}, {0, 255}, ColorFunction -> RGBColor], 
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
           False], BaseStyle -> "ImageGraphics", ImageSize -> Automatic, 
          ImageSizeRaw -> {109, 252}, PlotRange -> {{0, 109}, {0, 252}}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aa8860e8-584a-45a8-bdf6-b3aa12067f0f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to make an interactive selector of size-100 characters from the alphabet, \
controlled by a slider.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.28", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"8bde00ae-7fd6-4977-994d-bb03598722c9"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 1, 26, 1}}, Typeset`size$$ = {
          51., {2., 50.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`n$39715$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$39715$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Style[
              FromLetterNumber[$CellContext`n$$], 100], 
            "Specifications" :> {{$CellContext`n$$, 1, 26, 1}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{247., {71., 77.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "05397287-509b-4c04-aff5-41113fe370a2"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 1, 26, 1}}, 
             Typeset`size$$ = {51., {2., 50.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$39715$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$39715$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Style[
                FromLetterNumber[$CellContext`n$$], 100], 
              "Specifications" :> {{$CellContext`n$$, 1, 26, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {258., {72., 79.}}, SingleEvaluation -> True], 
            Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7661075e-1207-4660-9c97-c444280070b0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to make an interactive selector of black-on-white outlines of rasterized \
size-100 characters from the alphabet, controlled by a menu.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.29", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d901f066-2835-4eaf-a0e5-6c23b8d97087"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`c$$ = "k", Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`c$$], {
            "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", 
             "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", 
             "z"}}}, Typeset`size$$ = {50., {60., 66.}}, Typeset`update$$ = 0,
           Typeset`initDone$$, Typeset`skipInitDone$$ = 
          True, $CellContext`c$37110$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`c$$ = "a"}, 
            "ControllerVariables" :> {
              Hold[$CellContext`c$$, $CellContext`c$37110$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            ColorNegate[
              EdgeDetect[
               Rasterize[
                Style[$CellContext`c$$, 100]]]], 
            "Specifications" :> {{$CellContext`c$$, {
               "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", 
                "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", 
                "y", "z"}}}, "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{95., {106., 112.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "80b0985b-fbbb-429f-9de0-cf9fe6d426a2"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`c$$ = "k", Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`c$$], {
                "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", 
                 "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", 
                 "y", "z"}}}, Typeset`size$$ = {50., {60., 66.}}, 
             Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`c$37110$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`c$$ = "a"}, 
              "ControllerVariables" :> {
                Hold[$CellContext`c$$, $CellContext`c$37110$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              ColorNegate[
                EdgeDetect[
                 Rasterize[
                  Style[$CellContext`c$$, 100]]]], 
              "Specifications" :> {{$CellContext`c$$, {
                 "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", 
                  "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", 
                  "y", "z"}}}, "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {101., {110., 117.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"08c2abdc-8c66-436d-aaf2-bea271807df8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to create a \[OpenCurlyDoubleQuote]vision \
simulator\[CloseCurlyDoubleQuote] that blurs a size-200 letter \
\[OpenCurlyDoubleQuote]A\[CloseCurlyDoubleQuote] by an amount from 0 to 50.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.30", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"1ecf0036-89a9-4a0e-bf77-8bcb2298d946"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`r$$ = 0., Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`r$$], 0, 50}}, Typeset`size$$ = {
          109., {123., 129.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`r$49024$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`r$$ = 0}, 
            "ControllerVariables" :> {
              Hold[$CellContext`r$$, $CellContext`r$49024$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Blur[
              Rasterize[
               Style["A", 200]], $CellContext`r$$], 
            "Specifications" :> {{$CellContext`r$$, 0, 50}}, "Options" :> {}, 
            "DefaultOptions" :> {}],
           ImageSizeCache->{245., {170., 176.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "9ec11824-2276-4da8-9132-f10c988bf6b4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`r$$ = 0., Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`r$$], 0, 50}}, 
             Typeset`size$$ = {109., {123., 129.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`r$49024$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`r$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`r$$, $CellContext`r$49024$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Blur[
                Rasterize[
                 Style["A", 200]], $CellContext`r$$], 
              "Specifications" :> {{$CellContext`r$$, 0, 50}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {255., {171., 178.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6d573929-9430-4c48-8f6d-307a08e48e20"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a string of the alphabet followed by the alphabet written in \
reverse.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"5035a32e-e349-4d7c-a4e1-453f88e237bc"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"abcdefghijklmnopqrstuvwxyzzyxwvutsrqponmlkjihgfedcba\"\>"],
        "ExerciseOutput",ExpressionUUID->
       "95acceb8-dfc8-47ed-955e-d7204f98b212"],
      Apply[TextCell, 
       Cell[
        BoxData["\"abcdefghijklmnopqrstuvwxyzzyxwvutsrqponmlkjihgfedcba\""], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d6ab0048-8194-44fa-8c25-b493c01d2d05"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a column of a string of the alphabet and its reverse.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b1cfe41a-1e3f-4875-be34-267b3dc5d20c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"\<\"abcdefghijklmnopqrstuvwxyz\"\>"},
          {"\<\"zyxwvutsrqponmlkjihgfedcba\"\>"}
         },
         DefaultBaseStyle->"Column",
         GridBoxAlignment->{"Columns" -> {{Left}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Column"]], "ExerciseOutput",ExpressionUUID->
       "dd3bfd02-4538-4c06-892b-a40adcb511b4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{"\"abcdefghijklmnopqrstuvwxyz\""}, {
            "\"zyxwvutsrqponmlkjihgfedcba\""}}, DefaultBaseStyle -> "Column", 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4c479610-816e-4f85-a337-a1828b480a1f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find how many sentences are in the Wikipedia article for \
\[OpenCurlyDoubleQuote]computer\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c6ac2ca3-1e7a-4b89-b07e-f929254b3bdc"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "339"], "ExerciseOutput",ExpressionUUID->
       "b15b5b5d-5220-4846-8d04-49fb930c1caa"],
      Apply[TextCell, 
       Cell[
        BoxData["339"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"eb9db74d-96ba-4d96-9218-cae88fe51337"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Join together without spaces, etc. the words in the first sentence in the \
Wikipedia article for \[OpenCurlyDoubleQuote]strings\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ce7aa125-ab55-4edf-9fc3-a2935e9ada19"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"\
Stringisaflexiblepieceofropeortwinewhichisusedtotiebindorhangotherobjects\"\>\
"], "ExerciseOutput",ExpressionUUID->"3ef0d8b7-5e1b-469d-bdbe-215592254754"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "\"Stringisaflexiblepieceofropeortwinewhichisusedtotiebindorhangothero\
bjects\""], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"10e1eb09-15a0-44f1-8ba8-090636ff22ff"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the length of the longest word in the Wikipedia article about \
computers.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"3a879e5b-a548-4753-a72e-5eaaa6593f2f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "20"], "ExerciseOutput",ExpressionUUID->
       "70c5eef3-2078-47c7-871e-cf59c63ca8c3"],
      Apply[TextCell, 
       Cell[
        BoxData["20"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"26ac09f0-46a1-40bb-8228-18b9a7654450"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Plot the lengths of Roman numerals for numbers up to 2000.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a1ca7ffb-5d71-437d-8ca6-eca3ede09b84"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.006944444444444445], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdnTFw+/xdxnVc7vCQwUMGDxmEL8f5ejnOQAADoVVpAANpUUsohoaitnlb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            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{280.71484375, Automatic},
        Method->{},
        PlotRange->{{0., 2000.}, {0, 13.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "5005f442-49d6-4bc9-9f6f-ad0ff6f93979"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{{
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[0.006944444444444445], 
                AbsoluteThickness[1.6], 
                LineBox[CompressedData["
1:eJxdnTFw+/xdxnVc7vCQwUMGDxmEL8f5ejnOQAADoVVpAANpUUsohoaitnlb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                 "]]}}}}}, {}}, 
          AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
          Axes -> {True, True}, AxesLabel -> {None, None}, 
          AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
          Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {280.71484375, Automatic}, 
          Method -> {}, PlotRange -> {{0., 2000.}, {0, 13.}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a030b041-3292-40cf-8062-aca5499bdf3a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a string by joining the Roman numerals up to 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"3e2e728f-cdac-4641-a818-306a425cf14b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"\
IIIIIIIVVVIVIIVIIIIXXXIXIIXIIIXIVXVXVIXVIIXVIIIXIXXXXXIXXIIXXIIIXXIVXXVXXVIXXV\
IIXXVIIIXXIXXXXXXXIXXXIIXXXIIIXXXIVXXXVXXXVIXXXVIIXXXVIIIXXXIXXLXLIXLIIXLIIIXL\
IVXLVXLVIXLVIIXLVIIIXLIXLLILIILIIILIVLVLVILVIILVIIILIXLXLXILXIILXIIILXIVLXVLXV\
ILXVIILXVIIILXIXLXXLXXILXXIILXXIIILXXIVLXXVLXXVILXXVIILXXVIIILXXIXLXXXLXXXILXX\
XIILXXXIIILXXXIVLXXXVLXXXVILXXXVIILXXXVIIILXXXIXXCXCIXCIIXCIIIXCIVXCVXCVIXCVII\
XCVIIIXCIXC\"\>"], "ExerciseOutput",ExpressionUUID->
       "ab906f9a-adb2-4192-aff3-9cada389fe79"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "\"IIIIIIIVVVIVIIVIIIIXXXIXIIXIIIXIVXVXVIXVIIXVIIIXIXXXXXIXXIIXXIIIXXI\
VXXVXXVIXXVIIXXVIIIXXIXXXXXXXIXXXIIXXXIIIXXXIVXXXVXXXVIXXXVIIXXXVIIIXXXIXXLXLI\
XLIIXLIIIXLIVXLVXLVIXLVIIXLVIIIXLIXLLILIILIIILIVLVLVILVIILVIIILIXLXLXILXIILXII\
ILXIVLXVLXVILXVIILXVIIILXIXLXXLXXILXXIILXXIIILXXIVLXXVLXXVILXXVIILXXVIIILXXIXL\
XXXLXXXILXXXIILXXXIIILXXXIVLXXXVLXXXVILXXXVIILXXXVIIILXXXIXXCXCIXCIIXCIIIXCIVX\
CVXCVIXCVIIXCVIIIXCIXC\""], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2f37c7bb-7975-4f2c-8dff-7d796bfc021e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the successive letter numbers for the concatenation of \
all Roman numerals up to 30.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"42ae52b1-fb73-48ea-8445-dc347d3f3161"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.016666666666666666`], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxd0btOQkEUheEdK0sLCwsLNcQYYoiiInhjuAqoXA4XKxsTa15hHm0eyUcQ
wqyY/ZOQne+sveZM4PR7XfzsmdnX5rudu89vczfPQn4QvPfhA/gQPoKP4ZM8
a3gul+Bz7F0gLyO/hCvYv0J+DVfhG/g2z3qed3ANvke/jtlA/gA/Yv8J+TP8
AjfRDz6Psu7d8vuxhbyNvI28g/M7ft+6fj92/b710JfV76Pf9/v2ij5sA9x/
gHyIHLYRctjekMs6/x05bB+4P2xj9GGboA/b1DvIOg9O2LdZnvn3DzO/H+GE
fSt8HuBY+P0k6/1z9OEoqy+rv/AOsvpwknX/JfpwhJOs/2eF+6/8fkSeYPtE
/99/AP5smg==
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 93.}, {0, 24.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "c7d8be57-276e-45aa-acc0-e36c275ac1a9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{{
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[0.016666666666666666`], 
                AbsoluteThickness[1.6], 
                LineBox[CompressedData["
1:eJxd0btOQkEUheEdK0sLCwsLNcQYYoiiInhjuAqoXA4XKxsTa15hHm0eyUcQ
wqyY/ZOQne+sveZM4PR7XfzsmdnX5rudu89vczfPQn4QvPfhA/gQPoKP4ZM8
a3gul+Bz7F0gLyO/hCvYv0J+DVfhG/g2z3qed3ANvke/jtlA/gA/Yv8J+TP8
AjfRDz6Psu7d8vuxhbyNvI28g/M7ft+6fj92/b710JfV76Pf9/v2ij5sA9x/
gHyIHLYRctjekMs6/x05bB+4P2xj9GGboA/b1DvIOg9O2LdZnvn3DzO/H+GE
fSt8HuBY+P0k6/1z9OEoqy+rv/AOsvpwknX/JfpwhJOs/2eF+6/8fkSeYPtE
/99/AP5smg==
                 "]]}}}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 93.}, {0, 24.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a16aa8db-445b-47d0-9357-7e26215c91a4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the maximum string length of the name of any integer up to 1000.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"5e336858-b0a2-435f-b5c1-cdd05b85af0a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "27"], "ExerciseOutput",ExpressionUUID->
       "ee02aad6-3f9e-463e-92c6-b23afd204253"],
      Apply[TextCell, 
       Cell[
        BoxData["27"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c62aeef8-09f9-4a62-ab02-f47c13997c6f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of uppercase size-20 letters of the alphabet in random \
colors.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ca2430b8-8d2a-4ec4-9acc-0ca0d0e1447d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         StyleBox["\<\"A\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.16439536682216205`, 0.18143330208321085`, 0.30184492217970327`],
          $CellContext`LineColor -> 
          RGBColor[
           0.16439536682216205`, 0.18143330208321085`, 0.30184492217970327`],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.16439536682216205`, 0.18143330208321085`, 0.30184492217970327`],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.16439536682216205`, 0.18143330208321085`, 0.30184492217970327`],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.16439536682216205`, 0.18143330208321085`, 0.30184492217970327`]],
          ",", 
         StyleBox["\<\"B\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.5977028530807622, 0.1258131155554385, 0.831731477153778],
          $CellContext`LineColor -> 
          RGBColor[
           0.5977028530807622, 0.1258131155554385, 0.831731477153778],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.5977028530807622, 0.1258131155554385, 0.831731477153778],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.5977028530807622, 0.1258131155554385, 0.831731477153778],
          $CellContext`GraphicsColor -> 
          RGBColor[0.5977028530807622, 0.1258131155554385, 0.831731477153778]],
          ",", 
         StyleBox["\<\"C\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.4223510723699704, 0.6033374085192011, 0.5536948800151322],
          $CellContext`LineColor -> 
          RGBColor[0.4223510723699704, 0.6033374085192011, 0.5536948800151322],
          $CellContext`FrontFaceColor -> 
          RGBColor[0.4223510723699704, 0.6033374085192011, 0.5536948800151322],
          $CellContext`BackFaceColor -> 
          RGBColor[0.4223510723699704, 0.6033374085192011, 0.5536948800151322],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.4223510723699704, 0.6033374085192011, 0.5536948800151322]], ",", 
         
         StyleBox["\<\"D\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.3197366439487279, 0.21623353926744127`, 0.8413339698470326],
          $CellContext`LineColor -> 
          RGBColor[
           0.3197366439487279, 0.21623353926744127`, 0.8413339698470326],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.3197366439487279, 0.21623353926744127`, 0.8413339698470326],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.3197366439487279, 0.21623353926744127`, 0.8413339698470326],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.3197366439487279, 0.21623353926744127`, 0.8413339698470326]], 
         ",", 
         StyleBox["\<\"E\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.1628070460954072, 0.34349830926844693`, 0.17521397241155956`],
          $CellContext`LineColor -> 
          RGBColor[
           0.1628070460954072, 0.34349830926844693`, 0.17521397241155956`],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.1628070460954072, 0.34349830926844693`, 0.17521397241155956`],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.1628070460954072, 0.34349830926844693`, 0.17521397241155956`],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.1628070460954072, 0.34349830926844693`, 0.17521397241155956`]], 
         ",", 
         StyleBox["\<\"F\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.4850966905674272, 0.6139531322051532, 0.956410036331037],
          $CellContext`LineColor -> 
          RGBColor[
           0.4850966905674272, 0.6139531322051532, 0.956410036331037],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.4850966905674272, 0.6139531322051532, 0.956410036331037],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.4850966905674272, 0.6139531322051532, 0.956410036331037],
          $CellContext`GraphicsColor -> 
          RGBColor[0.4850966905674272, 0.6139531322051532, 0.956410036331037]],
          ",", 
         StyleBox["\<\"G\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.020478769897763538`, 0.4720907892346906, 0.1791635603553472],
          $CellContext`LineColor -> 
          RGBColor[
           0.020478769897763538`, 0.4720907892346906, 0.1791635603553472],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.020478769897763538`, 0.4720907892346906, 0.1791635603553472],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.020478769897763538`, 0.4720907892346906, 0.1791635603553472],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.020478769897763538`, 0.4720907892346906, 0.1791635603553472]], 
         ",", 
         StyleBox["\<\"H\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.5752110979188081, 0.6478835633022086, 0.39083911155186013`],
          $CellContext`LineColor -> 
          RGBColor[
           0.5752110979188081, 0.6478835633022086, 0.39083911155186013`],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.5752110979188081, 0.6478835633022086, 0.39083911155186013`],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.5752110979188081, 0.6478835633022086, 0.39083911155186013`],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.5752110979188081, 0.6478835633022086, 0.39083911155186013`]], 
         ",", 
         StyleBox["\<\"I\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.4507787174782145, 0.6817837409792642, 0.6879099043676715],
          $CellContext`LineColor -> 
          RGBColor[0.4507787174782145, 0.6817837409792642, 0.6879099043676715],
          $CellContext`FrontFaceColor -> 
          RGBColor[0.4507787174782145, 0.6817837409792642, 0.6879099043676715],
          $CellContext`BackFaceColor -> 
          RGBColor[0.4507787174782145, 0.6817837409792642, 0.6879099043676715],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.4507787174782145, 0.6817837409792642, 0.6879099043676715]], ",", 
         
         StyleBox["\<\"J\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.4668928718248673, 0.5451336260972648, 0.3090838373400955],
          $CellContext`LineColor -> 
          RGBColor[0.4668928718248673, 0.5451336260972648, 0.3090838373400955],
          $CellContext`FrontFaceColor -> 
          RGBColor[0.4668928718248673, 0.5451336260972648, 0.3090838373400955],
          $CellContext`BackFaceColor -> 
          RGBColor[0.4668928718248673, 0.5451336260972648, 0.3090838373400955],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.4668928718248673, 0.5451336260972648, 0.3090838373400955]], ",", 
         
         StyleBox["\<\"K\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.7155235741976622, 0.013760403495812312`, 0.6161129533452598],
          $CellContext`LineColor -> 
          RGBColor[
           0.7155235741976622, 0.013760403495812312`, 0.6161129533452598],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.7155235741976622, 0.013760403495812312`, 0.6161129533452598],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.7155235741976622, 0.013760403495812312`, 0.6161129533452598],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.7155235741976622, 0.013760403495812312`, 0.6161129533452598]], 
         ",", 
         StyleBox["\<\"L\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.6997990201393987, 0.9075307554204755, 0.675849958581823],
          $CellContext`LineColor -> 
          RGBColor[
           0.6997990201393987, 0.9075307554204755, 0.675849958581823],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.6997990201393987, 0.9075307554204755, 0.675849958581823],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.6997990201393987, 0.9075307554204755, 0.675849958581823],
          $CellContext`GraphicsColor -> 
          RGBColor[0.6997990201393987, 0.9075307554204755, 0.675849958581823]],
          ",", 
         StyleBox["\<\"M\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.2970090986331839, 0.1655051095627964, 0.3801451802711453],
          $CellContext`LineColor -> 
          RGBColor[0.2970090986331839, 0.1655051095627964, 0.3801451802711453],
          $CellContext`FrontFaceColor -> 
          RGBColor[0.2970090986331839, 0.1655051095627964, 0.3801451802711453],
          $CellContext`BackFaceColor -> 
          RGBColor[0.2970090986331839, 0.1655051095627964, 0.3801451802711453],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.2970090986331839, 0.1655051095627964, 0.3801451802711453]], ",", 
         
         StyleBox["\<\"N\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.1429050850313731, 0.8807029792269441, 0.16461171625145843`],
          $CellContext`LineColor -> 
          RGBColor[
           0.1429050850313731, 0.8807029792269441, 0.16461171625145843`],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.1429050850313731, 0.8807029792269441, 0.16461171625145843`],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.1429050850313731, 0.8807029792269441, 0.16461171625145843`],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.1429050850313731, 0.8807029792269441, 0.16461171625145843`]], 
         ",", 
         StyleBox["\<\"O\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.26930253153603534`, 0.4895677929983173, 0.7263821251272402],
          $CellContext`LineColor -> 
          RGBColor[
           0.26930253153603534`, 0.4895677929983173, 0.7263821251272402],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.26930253153603534`, 0.4895677929983173, 0.7263821251272402],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.26930253153603534`, 0.4895677929983173, 0.7263821251272402],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.26930253153603534`, 0.4895677929983173, 0.7263821251272402]], 
         ",", 
         StyleBox["\<\"P\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.25379965703798546`, 0.33098880061438596`, 0.4832396057135495],
          $CellContext`LineColor -> 
          RGBColor[
           0.25379965703798546`, 0.33098880061438596`, 0.4832396057135495],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.25379965703798546`, 0.33098880061438596`, 0.4832396057135495],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.25379965703798546`, 0.33098880061438596`, 0.4832396057135495],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.25379965703798546`, 0.33098880061438596`, 0.4832396057135495]], 
         ",", 
         StyleBox["\<\"Q\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.23328459422826953`, 0.5354468783741075, 0.1956668745143808],
          $CellContext`LineColor -> 
          RGBColor[
           0.23328459422826953`, 0.5354468783741075, 0.1956668745143808],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.23328459422826953`, 0.5354468783741075, 0.1956668745143808],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.23328459422826953`, 0.5354468783741075, 0.1956668745143808],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.23328459422826953`, 0.5354468783741075, 0.1956668745143808]], 
         ",", 
         StyleBox["\<\"R\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.03831400806125429, 0.15735093598199157`, 0.8882959019012715],
          $CellContext`LineColor -> 
          RGBColor[
           0.03831400806125429, 0.15735093598199157`, 0.8882959019012715],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.03831400806125429, 0.15735093598199157`, 0.8882959019012715],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.03831400806125429, 0.15735093598199157`, 0.8882959019012715],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.03831400806125429, 0.15735093598199157`, 0.8882959019012715]], 
         ",", 
         StyleBox["\<\"S\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.3368700912098934, 0.27509768203486273`, 0.7766720555496243],
          $CellContext`LineColor -> 
          RGBColor[
           0.3368700912098934, 0.27509768203486273`, 0.7766720555496243],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.3368700912098934, 0.27509768203486273`, 0.7766720555496243],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.3368700912098934, 0.27509768203486273`, 0.7766720555496243],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.3368700912098934, 0.27509768203486273`, 0.7766720555496243]], 
         ",", 
         StyleBox["\<\"T\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.019770062406319733`, 0.7093559473281219, 0.4684494792782463],
          $CellContext`LineColor -> 
          RGBColor[
           0.019770062406319733`, 0.7093559473281219, 0.4684494792782463],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.019770062406319733`, 0.7093559473281219, 0.4684494792782463],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.019770062406319733`, 0.7093559473281219, 0.4684494792782463],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.019770062406319733`, 0.7093559473281219, 0.4684494792782463]], 
         ",", 
         StyleBox["\<\"U\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.48937077633897164`, 0.021481778903063686`, 0.8129524978234306],
          $CellContext`LineColor -> 
          RGBColor[
           0.48937077633897164`, 0.021481778903063686`, 0.8129524978234306],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.48937077633897164`, 0.021481778903063686`, 0.8129524978234306],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.48937077633897164`, 0.021481778903063686`, 0.8129524978234306],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.48937077633897164`, 0.021481778903063686`, 0.8129524978234306]], 
         ",", 
         StyleBox["\<\"V\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.7989604994591777, 0.9453620265661109, 0.10677448841896808`],
          $CellContext`LineColor -> 
          RGBColor[
           0.7989604994591777, 0.9453620265661109, 0.10677448841896808`],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.7989604994591777, 0.9453620265661109, 0.10677448841896808`],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.7989604994591777, 0.9453620265661109, 0.10677448841896808`],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.7989604994591777, 0.9453620265661109, 0.10677448841896808`]], 
         ",", 
         StyleBox["\<\"W\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.9918158489816893, 0.9727687005676755, 0.9521369410253848],
          $CellContext`LineColor -> 
          RGBColor[0.9918158489816893, 0.9727687005676755, 0.9521369410253848],
          $CellContext`FrontFaceColor -> 
          RGBColor[0.9918158489816893, 0.9727687005676755, 0.9521369410253848],
          $CellContext`BackFaceColor -> 
          RGBColor[0.9918158489816893, 0.9727687005676755, 0.9521369410253848],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.9918158489816893, 0.9727687005676755, 0.9521369410253848]], ",", 
         
         StyleBox["\<\"X\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.5074810987083509, 0.1681900026742158, 0.7492125631898887],
          $CellContext`LineColor -> 
          RGBColor[0.5074810987083509, 0.1681900026742158, 0.7492125631898887],
          $CellContext`FrontFaceColor -> 
          RGBColor[0.5074810987083509, 0.1681900026742158, 0.7492125631898887],
          $CellContext`BackFaceColor -> 
          RGBColor[0.5074810987083509, 0.1681900026742158, 0.7492125631898887],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.5074810987083509, 0.1681900026742158, 0.7492125631898887]], ",", 
         
         StyleBox["\<\"Y\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.8118125445766569, 0.6331709281068709, 0.5376973656456505],
          $CellContext`LineColor -> 
          RGBColor[0.8118125445766569, 0.6331709281068709, 0.5376973656456505],
          $CellContext`FrontFaceColor -> 
          RGBColor[0.8118125445766569, 0.6331709281068709, 0.5376973656456505],
          $CellContext`BackFaceColor -> 
          RGBColor[0.8118125445766569, 0.6331709281068709, 0.5376973656456505],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.8118125445766569, 0.6331709281068709, 0.5376973656456505]], ",", 
         
         StyleBox["\<\"Z\"\>",
          StripOnInput->False,
          FontSize->20,
          
          FontColor->RGBColor[
           0.0030363769284456055`, 0.32905827077620886`, 0.13249873215093055`],
          $CellContext`LineColor -> 
          RGBColor[
           0.0030363769284456055`, 0.32905827077620886`, 0.13249873215093055`],
          $CellContext`FrontFaceColor -> 
          RGBColor[
           0.0030363769284456055`, 0.32905827077620886`, 0.13249873215093055`],
          $CellContext`BackFaceColor -> 
          RGBColor[
           0.0030363769284456055`, 0.32905827077620886`, 0.13249873215093055`],
          $CellContext`GraphicsColor -> 
          RGBColor[
           0.0030363769284456055`, 0.32905827077620886`, 
            0.13249873215093055`]]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "d266df97-1a2a-43ff-b129-a138842c98a0"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             StyleBox[
             "\"A\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.16439536682216205`, 0.18143330208321085`, 
                0.30184492217970327`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.16439536682216205`, 0.18143330208321085`, 
                0.30184492217970327`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.16439536682216205`, 0.18143330208321085`, 
                0.30184492217970327`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.16439536682216205`, 0.18143330208321085`, 
                0.30184492217970327`], FontSize -> 20, FontColor -> 
              RGBColor[
               0.16439536682216205`, 0.18143330208321085`, 
                0.30184492217970327`]], ",", 
             StyleBox[
             "\"B\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5977028530807622, 0.1258131155554385, 
                0.831731477153778], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5977028530807622, 0.1258131155554385, 
                0.831731477153778], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5977028530807622, 0.1258131155554385, 
                0.831731477153778], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5977028530807622, 0.1258131155554385, 0.831731477153778], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.5977028530807622, 0.1258131155554385, 0.831731477153778]], 
             ",", 
             StyleBox[
             "\"C\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.4223510723699704, 0.6033374085192011, 
                0.5536948800151322], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.4223510723699704, 0.6033374085192011, 
                0.5536948800151322], $CellContext`BackFaceColor -> 
              RGBColor[
               0.4223510723699704, 0.6033374085192011, 
                0.5536948800151322], $CellContext`GraphicsColor -> 
              RGBColor[
               0.4223510723699704, 0.6033374085192011, 0.5536948800151322], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.4223510723699704, 0.6033374085192011, 0.5536948800151322]], 
             ",", 
             StyleBox[
             "\"D\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.3197366439487279, 0.21623353926744127`, 
                0.8413339698470326], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.3197366439487279, 0.21623353926744127`, 
                0.8413339698470326], $CellContext`BackFaceColor -> 
              RGBColor[
               0.3197366439487279, 0.21623353926744127`, 
                0.8413339698470326], $CellContext`GraphicsColor -> 
              RGBColor[
               0.3197366439487279, 0.21623353926744127`, 0.8413339698470326], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.3197366439487279, 0.21623353926744127`, 0.8413339698470326]],
              ",", 
             StyleBox[
             "\"E\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.1628070460954072, 0.34349830926844693`, 
                0.17521397241155956`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.1628070460954072, 0.34349830926844693`, 
                0.17521397241155956`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.1628070460954072, 0.34349830926844693`, 
                0.17521397241155956`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.1628070460954072, 0.34349830926844693`, 
                0.17521397241155956`], FontSize -> 20, FontColor -> 
              RGBColor[
               0.1628070460954072, 0.34349830926844693`, 
                0.17521397241155956`]], ",", 
             StyleBox[
             "\"F\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.4850966905674272, 0.6139531322051532, 
                0.956410036331037], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.4850966905674272, 0.6139531322051532, 
                0.956410036331037], $CellContext`BackFaceColor -> 
              RGBColor[
               0.4850966905674272, 0.6139531322051532, 
                0.956410036331037], $CellContext`GraphicsColor -> 
              RGBColor[
               0.4850966905674272, 0.6139531322051532, 0.956410036331037], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.4850966905674272, 0.6139531322051532, 0.956410036331037]], 
             ",", 
             StyleBox[
             "\"G\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.020478769897763538`, 0.4720907892346906, 
                0.1791635603553472], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.020478769897763538`, 0.4720907892346906, 
                0.1791635603553472], $CellContext`BackFaceColor -> 
              RGBColor[
               0.020478769897763538`, 0.4720907892346906, 
                0.1791635603553472], $CellContext`GraphicsColor -> 
              RGBColor[
               0.020478769897763538`, 0.4720907892346906, 0.1791635603553472],
               FontSize -> 20, FontColor -> 
              RGBColor[
               0.020478769897763538`, 0.4720907892346906, 
                0.1791635603553472]], ",", 
             StyleBox[
             "\"H\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5752110979188081, 0.6478835633022086, 
                0.39083911155186013`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5752110979188081, 0.6478835633022086, 
                0.39083911155186013`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5752110979188081, 0.6478835633022086, 
                0.39083911155186013`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5752110979188081, 0.6478835633022086, 0.39083911155186013`], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.5752110979188081, 0.6478835633022086, 0.39083911155186013`]],
              ",", 
             StyleBox[
             "\"I\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.4507787174782145, 0.6817837409792642, 
                0.6879099043676715], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.4507787174782145, 0.6817837409792642, 
                0.6879099043676715], $CellContext`BackFaceColor -> 
              RGBColor[
               0.4507787174782145, 0.6817837409792642, 
                0.6879099043676715], $CellContext`GraphicsColor -> 
              RGBColor[
               0.4507787174782145, 0.6817837409792642, 0.6879099043676715], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.4507787174782145, 0.6817837409792642, 0.6879099043676715]], 
             ",", 
             StyleBox[
             "\"J\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.4668928718248673, 0.5451336260972648, 
                0.3090838373400955], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.4668928718248673, 0.5451336260972648, 
                0.3090838373400955], $CellContext`BackFaceColor -> 
              RGBColor[
               0.4668928718248673, 0.5451336260972648, 
                0.3090838373400955], $CellContext`GraphicsColor -> 
              RGBColor[
               0.4668928718248673, 0.5451336260972648, 0.3090838373400955], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.4668928718248673, 0.5451336260972648, 0.3090838373400955]], 
             ",", 
             StyleBox[
             "\"K\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7155235741976622, 0.013760403495812312`, 
                0.6161129533452598], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7155235741976622, 0.013760403495812312`, 
                0.6161129533452598], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7155235741976622, 0.013760403495812312`, 
                0.6161129533452598], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7155235741976622, 0.013760403495812312`, 0.6161129533452598],
               FontSize -> 20, FontColor -> 
              RGBColor[
               0.7155235741976622, 0.013760403495812312`, 
                0.6161129533452598]], ",", 
             StyleBox[
             "\"L\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6997990201393987, 0.9075307554204755, 
                0.675849958581823], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6997990201393987, 0.9075307554204755, 
                0.675849958581823], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6997990201393987, 0.9075307554204755, 
                0.675849958581823], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6997990201393987, 0.9075307554204755, 0.675849958581823], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.6997990201393987, 0.9075307554204755, 0.675849958581823]], 
             ",", 
             StyleBox[
             "\"M\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.2970090986331839, 0.1655051095627964, 
                0.3801451802711453], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.2970090986331839, 0.1655051095627964, 
                0.3801451802711453], $CellContext`BackFaceColor -> 
              RGBColor[
               0.2970090986331839, 0.1655051095627964, 
                0.3801451802711453], $CellContext`GraphicsColor -> 
              RGBColor[
               0.2970090986331839, 0.1655051095627964, 0.3801451802711453], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.2970090986331839, 0.1655051095627964, 0.3801451802711453]], 
             ",", 
             StyleBox[
             "\"N\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.1429050850313731, 0.8807029792269441, 
                0.16461171625145843`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.1429050850313731, 0.8807029792269441, 
                0.16461171625145843`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.1429050850313731, 0.8807029792269441, 
                0.16461171625145843`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.1429050850313731, 0.8807029792269441, 0.16461171625145843`], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.1429050850313731, 0.8807029792269441, 0.16461171625145843`]],
              ",", 
             StyleBox[
             "\"O\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.26930253153603534`, 0.4895677929983173, 
                0.7263821251272402], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.26930253153603534`, 0.4895677929983173, 
                0.7263821251272402], $CellContext`BackFaceColor -> 
              RGBColor[
               0.26930253153603534`, 0.4895677929983173, 
                0.7263821251272402], $CellContext`GraphicsColor -> 
              RGBColor[
               0.26930253153603534`, 0.4895677929983173, 0.7263821251272402], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.26930253153603534`, 0.4895677929983173, 0.7263821251272402]],
              ",", 
             StyleBox[
             "\"P\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.25379965703798546`, 0.33098880061438596`, 
                0.4832396057135495], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.25379965703798546`, 0.33098880061438596`, 
                0.4832396057135495], $CellContext`BackFaceColor -> 
              RGBColor[
               0.25379965703798546`, 0.33098880061438596`, 
                0.4832396057135495], $CellContext`GraphicsColor -> 
              RGBColor[
               0.25379965703798546`, 0.33098880061438596`, 
                0.4832396057135495], FontSize -> 20, FontColor -> 
              RGBColor[
               0.25379965703798546`, 0.33098880061438596`, 
                0.4832396057135495]], ",", 
             StyleBox[
             "\"Q\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.23328459422826953`, 0.5354468783741075, 
                0.1956668745143808], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.23328459422826953`, 0.5354468783741075, 
                0.1956668745143808], $CellContext`BackFaceColor -> 
              RGBColor[
               0.23328459422826953`, 0.5354468783741075, 
                0.1956668745143808], $CellContext`GraphicsColor -> 
              RGBColor[
               0.23328459422826953`, 0.5354468783741075, 0.1956668745143808], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.23328459422826953`, 0.5354468783741075, 0.1956668745143808]],
              ",", 
             StyleBox[
             "\"R\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.03831400806125429, 0.15735093598199157`, 
                0.8882959019012715], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.03831400806125429, 0.15735093598199157`, 
                0.8882959019012715], $CellContext`BackFaceColor -> 
              RGBColor[
               0.03831400806125429, 0.15735093598199157`, 
                0.8882959019012715], $CellContext`GraphicsColor -> 
              RGBColor[
               0.03831400806125429, 0.15735093598199157`, 0.8882959019012715],
               FontSize -> 20, FontColor -> 
              RGBColor[
               0.03831400806125429, 0.15735093598199157`, 
                0.8882959019012715]], ",", 
             StyleBox[
             "\"S\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.3368700912098934, 0.27509768203486273`, 
                0.7766720555496243], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.3368700912098934, 0.27509768203486273`, 
                0.7766720555496243], $CellContext`BackFaceColor -> 
              RGBColor[
               0.3368700912098934, 0.27509768203486273`, 
                0.7766720555496243], $CellContext`GraphicsColor -> 
              RGBColor[
               0.3368700912098934, 0.27509768203486273`, 0.7766720555496243], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.3368700912098934, 0.27509768203486273`, 0.7766720555496243]],
              ",", 
             StyleBox[
             "\"T\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.019770062406319733`, 0.7093559473281219, 
                0.4684494792782463], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.019770062406319733`, 0.7093559473281219, 
                0.4684494792782463], $CellContext`BackFaceColor -> 
              RGBColor[
               0.019770062406319733`, 0.7093559473281219, 
                0.4684494792782463], $CellContext`GraphicsColor -> 
              RGBColor[
               0.019770062406319733`, 0.7093559473281219, 0.4684494792782463],
               FontSize -> 20, FontColor -> 
              RGBColor[
               0.019770062406319733`, 0.7093559473281219, 
                0.4684494792782463]], ",", 
             StyleBox[
             "\"U\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.48937077633897164`, 0.021481778903063686`, 
                0.8129524978234306], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.48937077633897164`, 0.021481778903063686`, 
                0.8129524978234306], $CellContext`BackFaceColor -> 
              RGBColor[
               0.48937077633897164`, 0.021481778903063686`, 
                0.8129524978234306], $CellContext`GraphicsColor -> 
              RGBColor[
               0.48937077633897164`, 0.021481778903063686`, 
                0.8129524978234306], FontSize -> 20, FontColor -> 
              RGBColor[
               0.48937077633897164`, 0.021481778903063686`, 
                0.8129524978234306]], ",", 
             StyleBox[
             "\"V\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7989604994591777, 0.9453620265661109, 
                0.10677448841896808`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7989604994591777, 0.9453620265661109, 
                0.10677448841896808`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7989604994591777, 0.9453620265661109, 
                0.10677448841896808`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7989604994591777, 0.9453620265661109, 0.10677448841896808`], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.7989604994591777, 0.9453620265661109, 0.10677448841896808`]],
              ",", 
             StyleBox[
             "\"W\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9918158489816893, 0.9727687005676755, 
                0.9521369410253848], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9918158489816893, 0.9727687005676755, 
                0.9521369410253848], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9918158489816893, 0.9727687005676755, 
                0.9521369410253848], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9918158489816893, 0.9727687005676755, 0.9521369410253848], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.9918158489816893, 0.9727687005676755, 0.9521369410253848]], 
             ",", 
             StyleBox[
             "\"X\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5074810987083509, 0.1681900026742158, 
                0.7492125631898887], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5074810987083509, 0.1681900026742158, 
                0.7492125631898887], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5074810987083509, 0.1681900026742158, 
                0.7492125631898887], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5074810987083509, 0.1681900026742158, 0.7492125631898887], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.5074810987083509, 0.1681900026742158, 0.7492125631898887]], 
             ",", 
             StyleBox[
             "\"Y\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8118125445766569, 0.6331709281068709, 
                0.5376973656456505], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8118125445766569, 0.6331709281068709, 
                0.5376973656456505], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8118125445766569, 0.6331709281068709, 
                0.5376973656456505], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8118125445766569, 0.6331709281068709, 0.5376973656456505], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.8118125445766569, 0.6331709281068709, 0.5376973656456505]], 
             ",", 
             StyleBox[
             "\"Z\"", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.0030363769284456055`, 0.32905827077620886`, 
                0.13249873215093055`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.0030363769284456055`, 0.32905827077620886`, 
                0.13249873215093055`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.0030363769284456055`, 0.32905827077620886`, 
                0.13249873215093055`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.0030363769284456055`, 0.32905827077620886`, 
                0.13249873215093055`], FontSize -> 20, FontColor -> 
              RGBColor[
               0.0030363769284456055`, 0.32905827077620886`, 
                0.13249873215093055`]]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"787002a7-8787-4149-9443-4e23d1d3e0b0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of 100 random 5-letter strings with the Russian alphabet.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b73eef40-33ef-438d-8d7d-10e0a534ae32"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"\:0449\:0451\:044f\:0440\:0444\"\>", 
         ",", "\<\"\:0446\:0440\:0443\:0439\:043b\"\>", 
         ",", "\<\"\:043f\:0445\:0451\:043a\:0446\"\>", 
         ",", "\<\"\:0432\:0433\:0445\:0444\:0432\"\>", 
         ",", "\<\"\:0444\:043b\:044d\:0448\:043c\"\>", 
         ",", "\<\"\:044f\:0451\:0443\:0439\:0443\"\>", 
         ",", "\<\"\:043b\:0447\:0442\:043b\:043e\"\>", 
         ",", "\<\"\:0433\:043d\:0445\:0448\:0443\"\>", 
         ",", "\<\"\:043a\:043b\:0447\:0449\:0447\"\>", 
         ",", "\<\"\:044d\:0439\:0430\:0440\:044d\"\>", 
         ",", "\<\"\:0441\:043e\:0432\:044d\:0444\"\>", 
         ",", "\<\"\:0446\:0445\:0448\:043d\:0438\"\>", 
         ",", "\<\"\:043a\:0434\:043f\:0444\:0437\"\>", 
         ",", "\<\"\:0437\:0434\:044a\:0436\:044c\"\>", 
         ",", "\<\"\:044b\:0439\:0440\:044f\:043f\"\>", 
         ",", "\<\"\:0437\:043c\:0433\:0449\:0434\"\>", 
         ",", "\<\"\:044f\:0444\:0442\:0431\:043c\"\>", 
         ",", "\<\"\:043a\:0430\:043e\:0435\:044d\"\>", 
         ",", "\<\"\:043b\:043a\:0436\:0440\:0431\"\>", 
         ",", "\<\"\:0443\:0430\:0442\:043e\:043e\"\>", 
         ",", "\<\"\:043d\:0437\:043a\:0432\:043a\"\>", 
         ",", "\<\"\:0441\:043e\:043d\:043b\:044c\"\>", 
         ",", "\<\"\:044e\:0444\:0449\:0437\:0441\"\>", 
         ",", "\<\"\:044f\:0431\:0433\:0448\:0448\"\>", 
         ",", "\<\"\:043d\:044f\:0441\:0437\:043e\"\>", 
         ",", "\<\"\:0445\:043e\:044d\:0441\:0432\"\>", 
         ",", "\<\"\:043f\:0441\:0438\:043a\:0445\"\>", 
         ",", "\<\"\:0434\:043d\:044d\:0445\:0445\"\>", 
         ",", "\<\"\:044a\:0431\:0448\:043d\:0449\"\>", 
         ",", "\<\"\:0432\:044e\:0430\:0434\:0433\"\>", 
         ",", "\<\"\:044a\:0447\:0438\:0437\:0431\"\>", 
         ",", "\<\"\:0446\:043f\:0432\:044e\:0430\"\>", 
         ",", "\<\"\:043d\:044b\:0438\:044c\:044f\"\>", 
         ",", "\<\"\:043f\:0433\:0431\:0431\:0438\"\>", 
         ",", "\<\"\:044b\:0445\:0436\:0437\:0439\"\>", 
         ",", "\<\"\:0445\:0432\:0437\:0435\:0442\"\>", 
         ",", "\<\"\:0447\:0438\:0432\:0438\:0440\"\>", 
         ",", "\<\"\:0447\:0437\:0433\:0432\:043c\"\>", 
         ",", "\<\"\:043c\:043b\:0447\:044e\:043d\"\>", 
         ",", "\<\"\:0448\:0433\:0448\:043d\:0436\"\>", 
         ",", "\<\"\:0441\:043d\:0441\:043b\:0436\"\>", 
         ",", "\<\"\:0436\:0439\:0437\:044c\:0430\"\>", 
         ",", "\<\"\:0432\:0439\:0440\:0430\:043a\"\>", 
         ",", "\<\"\:0432\:0436\:044a\:043d\:0445\"\>", 
         ",", "\<\"\:0438\:0451\:0436\:0449\:0438\"\>", 
         ",", "\<\"\:043a\:0448\:044a\:0438\:0444\"\>", 
         ",", "\<\"\:0439\:0446\:044e\:0443\:044e\"\>", 
         ",", "\<\"\:0446\:0438\:0437\:0448\:0437\"\>", 
         ",", "\<\"\:044e\:0448\:0435\:044f\:0445\"\>", 
         ",", "\<\"\:0445\:0435\:0449\:044d\:0431\"\>", 
         ",", "\<\"\:0444\:0444\:0432\:043c\:0432\"\>", 
         ",", "\<\"\:044e\:044f\:044f\:043a\:043e\"\>", 
         ",", "\<\"\:043b\:0447\:0432\:043b\:044f\"\>", 
         ",", "\<\"\:0444\:0446\:0430\:044c\:0441\"\>", 
         ",", "\<\"\:0447\:0440\:0445\:0438\:044c\"\>", 
         ",", "\<\"\:043f\:0443\:043d\:0437\:0449\"\>", 
         ",", "\<\"\:0440\:0435\:0437\:0443\:044f\"\>", 
         ",", "\<\"\:043c\:043f\:0443\:0449\:0434\"\>", 
         ",", "\<\"\:0433\:044b\:0437\:0448\:0433\"\>", 
         ",", "\<\"\:043a\:0451\:0436\:043c\:044d\"\>", 
         ",", "\<\"\:0431\:0437\:044f\:0451\:044f\"\>", 
         ",", "\<\"\:0445\:0434\:0445\:0434\:044a\"\>", 
         ",", "\<\"\:044e\:0437\:0444\:0449\:0430\"\>", 
         ",", "\<\"\:044b\:0437\:0443\:0446\:0440\"\>", 
         ",", "\<\"\:044c\:044f\:044f\:0449\:043b\"\>", 
         ",", "\<\"\:043e\:044d\:043c\:0449\:0438\"\>", 
         ",", "\<\"\:044d\:0433\:0449\:043e\:0432\"\>", 
         ",", "\<\"\:0443\:0444\:043f\:0432\:043b\"\>", 
         ",", "\<\"\:044f\:0434\:044c\:0449\:044d\"\>", 
         ",", "\<\"\:0439\:0443\:044d\:0451\:044d\"\>", 
         ",", "\<\"\:0446\:0441\:043d\:0441\:043a\"\>", 
         ",", "\<\"\:0439\:043f\:0446\:0436\:044a\"\>", 
         ",", "\<\"\:0439\:0433\:0443\:0445\:043b\"\>", 
         ",", "\<\"\:0443\:0440\:043c\:0449\:0440\"\>", 
         ",", "\<\"\:0449\:0433\:0445\:043e\:0444\"\>", 
         ",", "\<\"\:0430\:0449\:0432\:0444\:0445\"\>", 
         ",", "\<\"\:043a\:0447\:044c\:0430\:044c\"\>", 
         ",", "\<\"\:0443\:043b\:0447\:043f\:0443\"\>", 
         ",", "\<\"\:0430\:0441\:043c\:043b\:0436\"\>", 
         ",", "\<\"\:043a\:0430\:043a\:0445\:0439\"\>", 
         ",", "\<\"\:0440\:0432\:0440\:0432\:0433\"\>", 
         ",", "\<\"\:043e\:043b\:0439\:0437\:044f\"\>", 
         ",", "\<\"\:0451\:0446\:0448\:0446\:044d\"\>", 
         ",", "\<\"\:044d\:043d\:0441\:0430\:0432\"\>", 
         ",", "\<\"\:0435\:0451\:044f\:0443\:0431\"\>", 
         ",", "\<\"\:0447\:0446\:0435\:044f\:0441\"\>", 
         ",", "\<\"\:0432\:0448\:044d\:0435\:0438\"\>", 
         ",", "\<\"\:0447\:043e\:043c\:0440\:044b\"\>", 
         ",", "\<\"\:0438\:043f\:0431\:044c\:044d\"\>", 
         ",", "\<\"\:044c\:044f\:0444\:044b\:043c\"\>", 
         ",", "\<\"\:0448\:0438\:0434\:044f\:0431\"\>", 
         ",", "\<\"\:0449\:0430\:044e\:043a\:044b\"\>", 
         ",", "\<\"\:0448\:043e\:0431\:0440\:043e\"\>", 
         ",", "\<\"\:0430\:0439\:044d\:043d\:0439\"\>", 
         ",", "\<\"\:0430\:0448\:0444\:0433\:043a\"\>", 
         ",", "\<\"\:0441\:044a\:0433\:0440\:043c\"\>", 
         ",", "\<\"\:044b\:0444\:0430\:0444\:0449\"\>", 
         ",", "\<\"\:043f\:0431\:044f\:043d\:0441\"\>", 
         ",", "\<\"\:0444\:043c\:0441\:0433\:0444\"\>", 
         ",", "\<\"\:0445\:0440\:0443\:0431\:0451\"\>"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "86be28e9-4d14-42c0-a252-d27a3a65a764"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"\:0449\:0451\:044f\:0440\:0444\"", ",", 
             "\"\:0446\:0440\:0443\:0439\:043b\"", ",", 
             "\"\:043f\:0445\:0451\:043a\:0446\"", ",", 
             "\"\:0432\:0433\:0445\:0444\:0432\"", ",", 
             "\"\:0444\:043b\:044d\:0448\:043c\"", ",", 
             "\"\:044f\:0451\:0443\:0439\:0443\"", ",", 
             "\"\:043b\:0447\:0442\:043b\:043e\"", ",", 
             "\"\:0433\:043d\:0445\:0448\:0443\"", ",", 
             "\"\:043a\:043b\:0447\:0449\:0447\"", ",", 
             "\"\:044d\:0439\:0430\:0440\:044d\"", ",", 
             "\"\:0441\:043e\:0432\:044d\:0444\"", ",", 
             "\"\:0446\:0445\:0448\:043d\:0438\"", ",", 
             "\"\:043a\:0434\:043f\:0444\:0437\"", ",", 
             "\"\:0437\:0434\:044a\:0436\:044c\"", ",", 
             "\"\:044b\:0439\:0440\:044f\:043f\"", ",", 
             "\"\:0437\:043c\:0433\:0449\:0434\"", ",", 
             "\"\:044f\:0444\:0442\:0431\:043c\"", ",", 
             "\"\:043a\:0430\:043e\:0435\:044d\"", ",", 
             "\"\:043b\:043a\:0436\:0440\:0431\"", ",", 
             "\"\:0443\:0430\:0442\:043e\:043e\"", ",", 
             "\"\:043d\:0437\:043a\:0432\:043a\"", ",", 
             "\"\:0441\:043e\:043d\:043b\:044c\"", ",", 
             "\"\:044e\:0444\:0449\:0437\:0441\"", ",", 
             "\"\:044f\:0431\:0433\:0448\:0448\"", ",", 
             "\"\:043d\:044f\:0441\:0437\:043e\"", ",", 
             "\"\:0445\:043e\:044d\:0441\:0432\"", ",", 
             "\"\:043f\:0441\:0438\:043a\:0445\"", ",", 
             "\"\:0434\:043d\:044d\:0445\:0445\"", ",", 
             "\"\:044a\:0431\:0448\:043d\:0449\"", ",", 
             "\"\:0432\:044e\:0430\:0434\:0433\"", ",", 
             "\"\:044a\:0447\:0438\:0437\:0431\"", ",", 
             "\"\:0446\:043f\:0432\:044e\:0430\"", ",", 
             "\"\:043d\:044b\:0438\:044c\:044f\"", ",", 
             "\"\:043f\:0433\:0431\:0431\:0438\"", ",", 
             "\"\:044b\:0445\:0436\:0437\:0439\"", ",", 
             "\"\:0445\:0432\:0437\:0435\:0442\"", ",", 
             "\"\:0447\:0438\:0432\:0438\:0440\"", ",", 
             "\"\:0447\:0437\:0433\:0432\:043c\"", ",", 
             "\"\:043c\:043b\:0447\:044e\:043d\"", ",", 
             "\"\:0448\:0433\:0448\:043d\:0436\"", ",", 
             "\"\:0441\:043d\:0441\:043b\:0436\"", ",", 
             "\"\:0436\:0439\:0437\:044c\:0430\"", ",", 
             "\"\:0432\:0439\:0440\:0430\:043a\"", ",", 
             "\"\:0432\:0436\:044a\:043d\:0445\"", ",", 
             "\"\:0438\:0451\:0436\:0449\:0438\"", ",", 
             "\"\:043a\:0448\:044a\:0438\:0444\"", ",", 
             "\"\:0439\:0446\:044e\:0443\:044e\"", ",", 
             "\"\:0446\:0438\:0437\:0448\:0437\"", ",", 
             "\"\:044e\:0448\:0435\:044f\:0445\"", ",", 
             "\"\:0445\:0435\:0449\:044d\:0431\"", ",", 
             "\"\:0444\:0444\:0432\:043c\:0432\"", ",", 
             "\"\:044e\:044f\:044f\:043a\:043e\"", ",", 
             "\"\:043b\:0447\:0432\:043b\:044f\"", ",", 
             "\"\:0444\:0446\:0430\:044c\:0441\"", ",", 
             "\"\:0447\:0440\:0445\:0438\:044c\"", ",", 
             "\"\:043f\:0443\:043d\:0437\:0449\"", ",", 
             "\"\:0440\:0435\:0437\:0443\:044f\"", ",", 
             "\"\:043c\:043f\:0443\:0449\:0434\"", ",", 
             "\"\:0433\:044b\:0437\:0448\:0433\"", ",", 
             "\"\:043a\:0451\:0436\:043c\:044d\"", ",", 
             "\"\:0431\:0437\:044f\:0451\:044f\"", ",", 
             "\"\:0445\:0434\:0445\:0434\:044a\"", ",", 
             "\"\:044e\:0437\:0444\:0449\:0430\"", ",", 
             "\"\:044b\:0437\:0443\:0446\:0440\"", ",", 
             "\"\:044c\:044f\:044f\:0449\:043b\"", ",", 
             "\"\:043e\:044d\:043c\:0449\:0438\"", ",", 
             "\"\:044d\:0433\:0449\:043e\:0432\"", ",", 
             "\"\:0443\:0444\:043f\:0432\:043b\"", ",", 
             "\"\:044f\:0434\:044c\:0449\:044d\"", ",", 
             "\"\:0439\:0443\:044d\:0451\:044d\"", ",", 
             "\"\:0446\:0441\:043d\:0441\:043a\"", ",", 
             "\"\:0439\:043f\:0446\:0436\:044a\"", ",", 
             "\"\:0439\:0433\:0443\:0445\:043b\"", ",", 
             "\"\:0443\:0440\:043c\:0449\:0440\"", ",", 
             "\"\:0449\:0433\:0445\:043e\:0444\"", ",", 
             "\"\:0430\:0449\:0432\:0444\:0445\"", ",", 
             "\"\:043a\:0447\:044c\:0430\:044c\"", ",", 
             "\"\:0443\:043b\:0447\:043f\:0443\"", ",", 
             "\"\:0430\:0441\:043c\:043b\:0436\"", ",", 
             "\"\:043a\:0430\:043a\:0445\:0439\"", ",", 
             "\"\:0440\:0432\:0440\:0432\:0433\"", ",", 
             "\"\:043e\:043b\:0439\:0437\:044f\"", ",", 
             "\"\:0451\:0446\:0448\:0446\:044d\"", ",", 
             "\"\:044d\:043d\:0441\:0430\:0432\"", ",", 
             "\"\:0435\:0451\:044f\:0443\:0431\"", ",", 
             "\"\:0447\:0446\:0435\:044f\:0441\"", ",", 
             "\"\:0432\:0448\:044d\:0435\:0438\"", ",", 
             "\"\:0447\:043e\:043c\:0440\:044b\"", ",", 
             "\"\:0438\:043f\:0431\:044c\:044d\"", ",", 
             "\"\:044c\:044f\:0444\:044b\:043c\"", ",", 
             "\"\:0448\:0438\:0434\:044f\:0431\"", ",", 
             "\"\:0449\:0430\:044e\:043a\:044b\"", ",", 
             "\"\:0448\:043e\:0431\:0440\:043e\"", ",", 
             "\"\:0430\:0439\:044d\:043d\:0439\"", ",", 
             "\"\:0430\:0448\:0444\:0433\:043a\"", ",", 
             "\"\:0441\:044a\:0433\:0440\:043c\"", ",", 
             "\"\:044b\:0444\:0430\:0444\:0449\"", ",", 
             "\"\:043f\:0431\:044f\:043d\:0441\"", ",", 
             "\"\:0444\:043c\:0441\:0433\:0444\"", ",", 
             "\"\:0445\:0440\:0443\:0431\:0451\""}], "}"}]], "ExerciseOutput",
         Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"de7baa7e-02d5-459d-9ebc-1fc7e3fb6d2a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Create a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to display edges in size-200 letter A, blurred from 0 to 50.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d3d5d88e-0a96-48c6-b2ae-0c34a8537534"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`r$$ = 50., Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`r$$], 0, 50}}, Typeset`size$$ = {
          109., {123., 129.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`r$51541$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`r$$ = 0}, 
            "ControllerVariables" :> {
              Hold[$CellContext`r$$, $CellContext`r$51541$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            EdgeDetect[
              Blur[
               Rasterize[
                Style["A", 200]], $CellContext`r$$]], 
            "Specifications" :> {{$CellContext`r$$, 0, 50}}, "Options" :> {}, 
            "DefaultOptions" :> {}],
           ImageSizeCache->{245., {170., 176.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "704572ff-c3e0-4f5b-94c4-b4a7bedf0f83"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`r$$ = 50., Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`r$$], 0, 50}}, 
             Typeset`size$$ = {109., {123., 129.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`r$51541$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`r$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`r$$, $CellContext`r$51541$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              EdgeDetect[
                Blur[
                 Rasterize[
                  Style["A", 200]], $CellContext`r$$]], 
              "Specifications" :> {{$CellContext`r$$, 0, 50}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {255., {171., 178.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"312eea89-a8d9-46fd-a540-9100acc4ae90"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Add together white-on-black size-200 letters A and B.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"11debe04-4cc1-493c-939f-9eadc517689b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJztnT/o48gVx02iQo0gLlREjUjUqDEcanwkuIgrpXFxURpxhW7JRlwRBfYW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          "], {{0, 252}, {109, 
          0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSize->Automatic,
        ImageSizeRaw->{109, 252},
        PlotRange->{{0, 109}, {0, 252}}]], "ExerciseOutput",ExpressionUUID->
       "63588868-92b9-415d-958c-ba4e4236aee3"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          TagBox[
           RasterBox[CompressedData["
1:eJztnT/o48gVx02iQo0gLlREjUjUqDEcanwkuIgrpXFxURpxhW7JRlwRBfYW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            "], {{0, 252}, {109, 
            0}}, {0, 255}, ColorFunction -> RGBColor], 
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
           False], BaseStyle -> "ImageGraphics", ImageSize -> Automatic, 
          ImageSizeRaw -> {109, 252}, PlotRange -> {{0, 109}, {0, 252}}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7e71f986-782c-468e-a750-7fc253d4769f"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:52",ExpressionUUID->"5b00b670-4e20-4f50-b553-3722664b5862"],

Cell[TextData[{
 "What is the difference ",
 "between ",
 Cell[BoxData["\<\"x\"\>"], "InlineCode",ExpressionUUID->
  "35a3844c-0801-411c-bdb2-7e0fe11e9e6b"],
 " and ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"580b9ea5-0004-41cc-9e10-52cf218c53fa"],
 "?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8744b7c0-37d3-4e26-ac0d-4721ad12f1d8"],

Cell[TextData[{
 Cell[BoxData["\<\"x\"\>"], "InlineCode",ExpressionUUID->
  "6816752b-a198-49a5-8c8d-dc122e4b5494"],
 " is a string; ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"1cf1694b-d343-49c5-9046-5fd9291bbfc0"],
 " is a Wolfram Language symbol, just like ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 " or ",
 ButtonBox["Max",
  BaseStyle->"Link"],
 ", that can be defined to actually do computations. We\[CloseCurlyQuote]ll \
talk much more about symbols ",
 ButtonBox["later",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-33-expressions-and-their-structure.nb", None}],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:30",ExpressionUUID->"afc66f6b-81a1-45bd-ad64-6859ea5d26c7"],

Cell["How do I enter characters that aren\[CloseCurlyQuote]t on my \
keyboard?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"20b04be5-7051-44ca-b127-50a86345db87"],

Cell[TextData[{
 "You can use whatever methods your computer provides, or you can do it ",
 ButtonBox["directly with the Wolfram Language ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SpecialCharacters"],
 "using constructs such as ",
 Cell[BoxData[
  RowBox[{"\\", "\[VeryThinSpace]", 
   RowBox[{"[", 
    ButtonBox["Alpha",
     BaseStyle->"CodeLink",
     ButtonData->"paclet:ref/character/Alpha"], "]"}]}]], "InlineCode",
  ExpressionUUID->"fa6e6514-7083-4db9-bc18-b07ca1e06613"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:31",ExpressionUUID->"9464ce6a-d768-4d5c-999c-6fad688ecdce"],

Cell[TextData[{
 "How do I put quotes (",
 Cell[BoxData[
 "\"\<\>"], "InlineCode",ExpressionUUID->
  "280ddaf8-39be-46c8-b0db-2d4b8431c18c"],
 ") inside a string?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:32",ExpressionUUID->"d98e495d-cae6-44a1-9773-491441ab7bbb"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
 "\\\""], "InlineCode",ExpressionUUID->"6842e9ea-fe00-4e50-9493-a5bb1015befd"],
 " (and if you want to put ",
 Cell[BoxData[
 "\\\""], "InlineCode",ExpressionUUID->"0b2baf78-cd89-46fa-86dd-23eef1e1915e"],
 " literally in the string, use ",
 Cell[BoxData[
  RowBox[{"\\\\", "\[NegativeVeryThinSpace]", "\\\""}]], "InlineCode",
  ExpressionUUID->"6b86a7eb-ff5a-4a77-87bb-497131ee963d"],
 "). (You\[CloseCurlyQuote]ll use a lot of backslashes if you want to put ",
 Cell[BoxData[
  RowBox[{"\\\\", "\[NegativeVeryThinSpace]", "\\\""}]], "InlineCode",
  ExpressionUUID->"49e51cc0-6ec1-4426-8384-4b2055ac3790"],
 " in: ",
 Cell[BoxData[
  RowBox[{
  "\\\\", "\[NegativeVeryThinSpace]", "\\\\", "\[NegativeVeryThinSpace]", 
   "\\\\", "\[NegativeVeryThinSpace]", "\\\""}]], "InlineCode",ExpressionUUID->
  "7ea84c62-7d68-4d7a-b733-302327afa248"],
 ".)"
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e9afcc39-6219-4736-8789-0c769bfb6af5"],

Cell["How are the colors of elements in word clouds determined?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"953cb306-ec7f-4961-994d-a8c0d6372edb"],

Cell["\<\
By default it\[CloseCurlyQuote]s random within a certain color palette. You \
can specify it if you want to.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b70ef65c-aa38-4b26-ad83-7b1ffd80f4df"],

Cell["How come the word cloud shows \[OpenCurlyDoubleQuote]s\
\[CloseCurlyDoubleQuote] as the most common letter?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a05468da-4929-4d2b-a448-1913ac3fe9a4"],

Cell[TextData[{
 "Because it is the most common ",
 StyleBox["first",
  FontSlant->"Italic"],
 " letter for common words in English. If you look at all letters, the most \
common is \[OpenCurlyDoubleQuote]e\[CloseCurlyDoubleQuote]."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"00f5451e-452b-4234-9645-f4e49830db05"],

Cell["\<\
What about letters that aren\[CloseCurlyQuote]t English? How are they \
numbered?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:33",ExpressionUUID->"db250831-dd2f-4a60-9f47-9551f4b505b1"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LetterNumber",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"\<\"\!\(\*
StyleBox[\"\[Alpha]\", \"TR\"]\)\"\>", ",", "\<\"Greek\"\>"}], "]"}]], 
  "InlineCode",ExpressionUUID->"0d444066-7c5e-4ba2-a84b-42fc5c515f2d"],
 " gives numbering in the Greek alphabet. ",
 "All characters are assigned a ",
 StyleBox["character code",
  FontSlant->"Italic"],
 ".",
 " You can find it using ",
 ButtonBox["ToCharacterCode",
  BaseStyle->"Link"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3dbd94ce-9752-4c27-afaa-354a585d3aa4"],

Cell["What alphabets does the Wolfram Language know about?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:34",ExpressionUUID->"52c6940c-91a6-4581-8b63-6f4e398fbfb8"],

Cell["\<\
Basically all the ones that are used today. Try \[OpenCurlyDoubleQuote]Greek\
\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]Arabic\
\[CloseCurlyDoubleQuote], or the name of a language. Note that when a \
language uses accented characters, it\[CloseCurlyQuote]s sometimes tricky to \
decide what\[CloseCurlyQuote]s \[OpenCurlyDoubleQuote]in\
\[CloseCurlyDoubleQuote] the alphabet, and what\[CloseCurlyQuote]s just \
derived from it.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8f8991a4-24fe-44af-ab23-df84f5980799"],

Cell["\<\
Can I translate words instead of just transliterating their letters?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cb42c763-9034-4af9-bd37-8edb9682758c"],

Cell[TextData[{
 "Yes. Use ",
 ButtonBox["WordTranslation",
  BaseStyle->"Link"],
 ". ",
 "See ",
 ButtonBox["Section 35",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-35-natural-language-understanding.nb", None}],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7fdd539a-b9af-4447-b7a6-df4773058d66"],

Cell["\<\
Can I get lists of common words in languages other than English?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:35",ExpressionUUID->"8befd43b-6011-461b-9527-a56a49bfe84e"],

Cell[TextData[{
 "Yes. Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    ButtonBox["Language",
     BaseStyle->"CodeLink"], "\[Rule]", "\<\"Spanish\"\>"}], "]"}]], 
  "InlineCode",ExpressionUUID->"513fee68-b2ee-414f-8976-cd629c875b97"],
 ", etc."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e7ebafd8-ada7-4d41-9e73-6a2ea2a1687e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"34dce786-5c04-4120-8023-545142b4d528"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomWord",
    BaseStyle->"CodeLink"], "[", "10", "]"}]], "InlineCode",ExpressionUUID->
  "15a291b0-c598-4d7c-b860-d7fcf661404d"],
 " gives 10 random words. How many of them do you know?"
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:36",ExpressionUUID->"79dd4888-4564-42c3-bcd1-8892a8c0d70c"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringTake",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"\<\"\!\(\*
StyleBox[\"string\", \"TI\",
FontSlant->\"Italic\"]\)\"\>", ",", 
    RowBox[{"-", "2"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "918dab51-1632-40e8-966e-7e80d06702de"],
 " takes 2 characters from the end of the string."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4bdd2587-39c8-48d7-8763-9d49d2660e94"],

Cell[TextData[{
 "Every character, whether \[OpenCurlyDoubleQuote]a\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]\[Alpha]\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]",
 "\:72fc",
 "\[CloseCurlyDoubleQuote] is represented by a Unicode character code, found \
with ",
 ButtonBox["ToCharacterCode",
  BaseStyle->"Link"],
 ". You can explore \[OpenCurlyDoubleQuote]Unicode space\
\[CloseCurlyDoubleQuote] with ",
 ButtonBox["FromCharacterCode",
  BaseStyle->"Link"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:37",ExpressionUUID->"f1e24207-67d8-4ea1-b785-0641462e3353"],

Cell[TextData[{
 "If you get a different result from ",
 ButtonBox["WikipediaData",
  BaseStyle->"Link"],
 ", that\[CloseCurlyQuote]s because Wikipedia has been changed."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"342b7493-bbe5-459b-929b-33d0da9069de"],

Cell[TextData[{
 ButtonBox["WordCloud",
  BaseStyle->"Link"],
 " automatically removes \[OpenCurlyDoubleQuote]uninteresting\
\[CloseCurlyDoubleQuote] words in text, like \[OpenCurlyDoubleQuote]the\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]and\[CloseCurlyDoubleQuote], \
etc."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:38",ExpressionUUID->"8d6ceae3-7eb1-4d86-a07e-3e40aa850cfd"],

Cell[TextData[{
 "If you can\[CloseCurlyQuote]t figure out the name of an alphabet or \
language, use ",
 Cell[TextData[Cell[BoxData[
  TemplateBox[{"ctrl", "="},
   "Key1"]],ExpressionUUID->"a1cf1a2e-c41e-49a1-af17-42768fdf61ff"]],
  ExpressionUUID->"91bb2b0d-fa3c-4f54-ad1b-849fae085ad5"],
 " (as described in ",
 ButtonBox["Section 16",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-16-real-world-data.nb", None}],
 ") to give it in natural language form."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6a5de72d-0a3e-427d-8481-753bdad3a275"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"22ce2082-4488-4cb5-bc2c-3364d2476a0a"],

Cell[TextData[ButtonBox["Guide to String Manipulation in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"fd074e9b-56cb-4641-b438-e7481eb61f62"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Strings and Text: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-10-images.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-10-images.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Images\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Images", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-12-sound.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-12-sound.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Sound\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Sound", "Tooltip"]& ]}, "RowWithSeparators"], 
          Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->79,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Strings and Text \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"6ce9eb0d-8386-4dd1-9b70-e3842550b302"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:45"->{
  Cell[661, 24, 468, 11, 93, "SectionDoubleDigit",ExpressionUUID->"c29c9217-4dee-4e5f-96c6-7d7ade5a7f52",
   CounterAssignments->{{"Section", 10}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->{"p:45", "i:1"}]},
 "i:1"->{
  Cell[661, 24, 468, 11, 93, "SectionDoubleDigit",ExpressionUUID->"c29c9217-4dee-4e5f-96c6-7d7ade5a7f52",
   CounterAssignments->{{"Section", 10}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->{"p:45", "i:1"}]},
 "i:2"->{
  Cell[1132, 37, 438, 14, 65, "Text",ExpressionUUID->"3c54d72c-373f-482d-a837-610d28fb76f9",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[2118, 72, 484, 11, 90, "Text",ExpressionUUID->"858f1cfb-6fd3-47c1-bad5-e3c65b42992e",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[3256, 111, 270, 10, 37, "CodeCaption",ExpressionUUID->"183d1cc9-bb9b-4dd3-ae44-d88677da56a3",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[3928, 137, 287, 8, 37, "CodeCaption",ExpressionUUID->"39b095b6-358a-4804-b79b-a5065177d8b9",
   CellTags->"i:5"]},
 "i:6"->{
  Cell[4678, 162, 299, 10, 37, "CodeCaption",ExpressionUUID->"8c8eaf97-d49d-433a-82c9-2cefc132ae6b",
   CellTags->"i:6"]},
 "i:7"->{
  Cell[6094, 213, 314, 10, 70, "CodeCaption",ExpressionUUID->"c436bd45-7fcf-4c48-a722-dcfb73d8d900",
   CellTags->"i:7"]},
 "LastCellOfAPage"->{
  Cell[7540, 263, 302, 8, 70, "Output",ExpressionUUID->"a2c56b2d-64b9-4d3f-b9eb-9bac3716dc24",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[16566, 561, 313, 8, 70, "Output",ExpressionUUID->"f0502440-e27a-4a48-99f6-3febd031b233",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[45237, 1282, 8583, 253, 70, "Output",ExpressionUUID->"4f1997e8-96c4-4964-ae86-92d8b47c73da",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[61764, 1783, 720, 13, 70, "Output",ExpressionUUID->"5d1bb0bd-8726-4b34-99bd-1c03165a5b40",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[73589, 2083, 1866, 37, 70, "Output",ExpressionUUID->"25a1e508-4561-499e-92d3-d97480d54dea",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[75682, 2132, 7032, 177, 70, "VocabularyTable",ExpressionUUID->"fd00cb12-a7ed-4303-b459-cc4ca1573ea8",
   CellTags->"LastCellOfAPage"],
  Cell[284312, 7278, 937, 26, 70, "Exercise",ExpressionUUID->"1ecf0036-89a9-4a0e-bf77-8bcb2298d946",
   CellTags->"LastCellOfAPage"],
  Cell[408488, 10215, 352, 8, 70, "MoreExplore",ExpressionUUID->"fd074e9b-56cb-4641-b438-e7481eb61f62",
   CellTags->"LastCellOfAPage"]},
 "p:46"->{
  Cell[7857, 274, 205, 4, 70, "CodeCaption",ExpressionUUID->"e2d7d6a0-abad-423c-8efb-d4e1a8e78c63",
   CellTags->"p:46"]},
 "i:8"->{
  Cell[9401, 330, 318, 8, 70, "Text",ExpressionUUID->"67ed6e08-3c2a-4c03-b259-9f28cf02a823",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[10994, 376, 280, 7, 70, "Text",ExpressionUUID->"fea1c075-5e00-4044-b0bc-d74417bee565",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[12333, 414, 554, 16, 70, "Text",ExpressionUUID->"c5916c37-aff5-4483-bf00-42875f82b10d",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[13760, 462, 573, 18, 70, "Text",ExpressionUUID->"d3cf573e-2e7a-448d-ae16-22a96c450bf2",
   CellTags->"i:11"]},
 "p:47"->{
  Cell[16030, 541, 284, 9, 70, "CodeCaption",ExpressionUUID->"274df771-c85b-4f7e-aadf-c7db7b66b839",
   CellTags->{"p:47", "i:12"}]},
 "i:12"->{
  Cell[16030, 541, 284, 9, 70, "CodeCaption",ExpressionUUID->"274df771-c85b-4f7e-aadf-c7db7b66b839",
   CellTags->{"p:47", "i:12"}]},
 "i:13"->{
  Cell[16894, 572, 377, 12, 70, "Text",ExpressionUUID->"a6774136-0c02-4484-8b2c-4b190e5216fa",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[18115, 613, 349, 10, 70, "Text",ExpressionUUID->"2f8aedc8-bc06-44cb-b45e-915af32ae179",
   CellTags->"i:14"]},
 "i:15"->{
  Cell[42856, 1210, 340, 8, 70, "Text",ExpressionUUID->"717bc03b-8140-48f5-bf8f-16f563b124fe",
   CellTags->"i:15"]},
 "i:16"->{
  Cell[43199, 1220, 349, 10, 70, "Text",ExpressionUUID->"6010aaf3-81d8-41b6-88cc-e1f982f1d2fd",
   CellTags->"i:16"]},
 "p:48"->{
  Cell[44718, 1264, 219, 5, 70, "CodeCaption",ExpressionUUID->"f21437e6-1387-4431-b91c-909326c4c59f",
   CellTags->"p:48"]},
 "i:17"->{
  Cell[53835, 1538, 312, 7, 70, "Text",ExpressionUUID->"f5c6da04-2482-4f5b-b13a-16f1286c9ad7",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[56137, 1608, 228, 6, 70, "CodeCaption",ExpressionUUID->"297be57b-a44a-43f4-b044-8393b3cbf863",
   CellTags->"i:18"]},
 "i:19"->{
  Cell[58212, 1669, 253, 8, 70, "Text",ExpressionUUID->"dadcc9c7-79d2-4d8c-9698-a7d6e44c8422",
   CellTags->"i:19"]},
 "p:49"->{
  Cell[59066, 1699, 235, 5, 70, "CodeCaption",ExpressionUUID->"20696e17-9823-4914-9237-5f58f2ffea46",
   CellTags->"p:49"]},
 "i:20"->{
  Cell[61110, 1758, 230, 6, 70, "Text",ExpressionUUID->"a1d37298-f795-44ea-af27-f5e7edee7dc9",
   CellTags->"i:20"]},
 "i:21"->{
  Cell[62499, 1799, 273, 8, 70, "CodeCaption",ExpressionUUID->"378da19e-db59-480f-8cae-3aa1fed9bb8b",
   CellTags->"i:21"]},
 "i:22"->{
  Cell[63355, 1829, 246, 8, 70, "CodeCaption",ExpressionUUID->"a783c10c-11fe-44d8-9c9a-e6cbd5a5237e",
   CellTags->"i:22"]},
 "i:23"->{
  Cell[64218, 1859, 258, 8, 70, "CodeCaption",ExpressionUUID->"44f7e35f-678e-4518-90d5-7d19a3855b08",
   CellTags->"i:23"]},
 "i:24"->{
  Cell[65692, 1896, 280, 8, 70, "CodeCaption",ExpressionUUID->"d3f37b2b-078f-409c-b932-33b93b1a6184",
   CellTags->"i:24"]},
 "i:25"->{
  Cell[67805, 1955, 466, 16, 70, "Text",ExpressionUUID->"3d15ba1a-4eb3-4892-8b71-8677abed94fc",
   CellTags->"i:25"]},
 "i:26"->{
  Cell[68274, 1973, 196, 4, 70, "CodeCaption",ExpressionUUID->"81525f79-d794-4eeb-91a4-a80f6a92d593",
   CellTags->"i:26"]},
 "i:27"->{
  Cell[73109, 2067, 185, 4, 70, "CodeCaption",ExpressionUUID->"01148fe8-9ab8-4d7f-88cb-33a5bc73af2a",
   CellTags->"i:27"]},
 "p:50"->{
  Cell[75504, 2126, 175, 4, 70, "VocabularySection",ExpressionUUID->"4d54e2b7-a370-415f-8a2a-d396a55a55fe",
   CellTags->"p:50"]},
 "i:28"->{
  Cell[91764, 2592, 821, 23, 70, "Exercise",ExpressionUUID->"4b233154-aea9-4608-bcc4-80d9b6f61858",
   CellTags->"i:28"]},
 "i:29"->{
  Cell[217379, 5726, 720, 20, 70, "Exercise",ExpressionUUID->"ddf49df1-5cc0-4fc0-83e8-2e4743c53296",
   CellTags->"i:29"]},
 "p:52"->{
  Cell[397702, 9858, 160, 4, 70, "QASection",ExpressionUUID->"5b00b670-4e20-4f50-b553-3722664b5862",
   CellTags->"p:52"]},
 "i:30"->{
  Cell[398268, 9879, 744, 22, 70, "Answer",ExpressionUUID->"afc66f6b-81a1-45bd-ad64-6859ea5d26c7",
   CellTags->"i:30"]},
 "i:31"->{
  Cell[399230, 9910, 646, 18, 70, "Answer",ExpressionUUID->"9464ce6a-d768-4d5c-999c-6fad688ecdce",
   CellTags->"i:31"]},
 "i:32"->{
  Cell[399879, 9930, 315, 10, 70, "Question",ExpressionUUID->"d98e495d-cae6-44a1-9773-491441ab7bbb",
   CellTags->"i:32"]},
 "i:33"->{
  Cell[402296, 10004, 245, 7, 70, "Question",ExpressionUUID->"db250831-dd2f-4a60-9f47-9551f4b505b1",
   CellTags->"i:33"]},
 "i:34"->{
  Cell[403175, 10036, 208, 4, 70, "Question",ExpressionUUID->"52c6940c-91a6-4581-8b63-6f4e398fbfb8",
   CellTags->"i:34"]},
 "i:35"->{
  Cell[404549, 10080, 228, 6, 70, "Question",ExpressionUUID->"8befd43b-6011-461b-9527-a56a49bfe84e",
   CellTags->"i:35"]},
 "i:36"->{
  Cell[405415, 10114, 397, 11, 70, "TechNote",ExpressionUUID->"79dd4888-4564-42c3-bcd1-8892a8c0d70c",
   CellTags->"i:36"]},
 "i:37"->{
  Cell[406303, 10144, 633, 18, 70, "TechNote",ExpressionUUID->"f1e24207-67d8-4ea1-b785-0641462e3353",
   CellTags->"i:37"]},
 "i:38"->{
  Cell[407248, 10175, 435, 11, 70, "TechNote",ExpressionUUID->"8d6ceae3-7eb1-4d86-a07e-3e40aa850cfd",
   CellTags->"i:38"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:45", 499393, 12060},
 {"i:1", 499658, 12064},
 {"i:2", 499923, 12068},
 {"i:3", 500048, 12071},
 {"i:4", 500173, 12074},
 {"i:5", 500306, 12077},
 {"i:6", 500438, 12080},
 {"i:7", 500571, 12083},
 {"LastCellOfAPage", 500716, 12086},
 {"p:46", 501909, 12108},
 {"i:8", 502042, 12111},
 {"i:9", 502167, 12114},
 {"i:10", 502294, 12117},
 {"i:11", 502423, 12120},
 {"p:47", 502552, 12123},
 {"i:12", 502697, 12126},
 {"i:13", 502842, 12129},
 {"i:14", 502971, 12132},
 {"i:15", 503100, 12135},
 {"i:16", 503229, 12138},
 {"p:48", 503359, 12141},
 {"i:17", 503495, 12144},
 {"i:18", 503624, 12147},
 {"i:19", 503760, 12150},
 {"p:49", 503889, 12153},
 {"i:20", 504025, 12156},
 {"i:21", 504154, 12159},
 {"i:22", 504290, 12162},
 {"i:23", 504426, 12165},
 {"i:24", 504562, 12168},
 {"i:25", 504698, 12171},
 {"i:26", 504828, 12174},
 {"i:27", 504964, 12177},
 {"p:50", 505100, 12180},
 {"i:28", 505242, 12183},
 {"i:29", 505376, 12186},
 {"p:52", 505511, 12189},
 {"i:30", 505646, 12192},
 {"i:31", 505779, 12195},
 {"i:32", 505912, 12198},
 {"i:33", 506047, 12201},
 {"i:34", 506182, 12204},
 {"i:35", 506317, 12207},
 {"i:36", 506452, 12210},
 {"i:37", 506588, 12213},
 {"i:38", 506724, 12216}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[661, 24, 468, 11, 93, "SectionDoubleDigit",ExpressionUUID->"c29c9217-4dee-4e5f-96c6-7d7ade5a7f52",
 CounterAssignments->{{"Section", 10}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{"p:45", "i:1"}],
Cell[1132, 37, 438, 14, 65, "Text",ExpressionUUID->"3c54d72c-373f-482d-a837-610d28fb76f9",
 CellTags->"i:2"],
Cell[1573, 53, 158, 4, 37, "CodeCaption",ExpressionUUID->"60db7d0a-ab50-496b-951c-ecfc1fb341fa"],
Cell[CellGroupData[{
Cell[1756, 61, 148, 2, 29, "Input",ExpressionUUID->"44ea086c-5430-4e61-a258-fb1039044b3a"],
Cell[1907, 65, 196, 4, 40, "Output",ExpressionUUID->"18039637-b56a-4ea3-9ec7-3e43b2a0f124",
 Evaluatable->False]
}, Open  ]],
Cell[2118, 72, 484, 11, 90, "Text",ExpressionUUID->"858f1cfb-6fd3-47c1-bad5-e3c65b42992e",
 CellTags->"i:3"],
Cell[2605, 85, 262, 10, 37, "CodeCaption",ExpressionUUID->"2ad6cd57-5b8f-49b8-a86f-61be388dd729"],
Cell[CellGroupData[{
Cell[2892, 99, 174, 3, 29, "Input",ExpressionUUID->"c5a27feb-1d7d-4e2f-b91d-3cebae4116dd"],
Cell[3069, 104, 172, 4, 40, "Output",ExpressionUUID->"f6905243-1003-4096-bb58-2745bac92bf5",
 Evaluatable->False]
}, Open  ]],
Cell[3256, 111, 270, 10, 37, "CodeCaption",ExpressionUUID->"183d1cc9-bb9b-4dd3-ae44-d88677da56a3",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[3551, 125, 175, 3, 29, "Input",ExpressionUUID->"8e2ccf69-4679-4165-a48c-f8e3a82de09d"],
Cell[3729, 130, 184, 4, 40, "Output",ExpressionUUID->"41a6f1d6-da8f-4f87-ab0a-5349df1a4211",
 Evaluatable->False]
}, Open  ]],
Cell[3928, 137, 287, 8, 37, "CodeCaption",ExpressionUUID->"39b095b6-358a-4804-b79b-a5065177d8b9",
 CellTags->"i:5"],
Cell[CellGroupData[{
Cell[4240, 149, 206, 4, 29, "Input",ExpressionUUID->"97356774-6e2b-492b-9ccf-51ae61fda6f3"],
Cell[4449, 155, 214, 4, 40, "Output",ExpressionUUID->"f0944685-f9e1-4432-87d4-6fe360305ead",
 Evaluatable->False]
}, Open  ]],
Cell[4678, 162, 299, 10, 37, "CodeCaption",ExpressionUUID->"8c8eaf97-d49d-433a-82c9-2cefc132ae6b",
 CellTags->"i:6"],
Cell[CellGroupData[{
Cell[5002, 176, 212, 4, 29, "Input",ExpressionUUID->"92fd872e-ca96-4635-9fe3-f3ac8a7fbbc7"],
Cell[5217, 182, 189, 4, 40, "Output",ExpressionUUID->"704fb30c-52eb-468a-8042-b1b71277ee1f",
 Evaluatable->False]
}, Open  ]],
Cell[5421, 189, 202, 5, 37, "CodeCaption",ExpressionUUID->"becc914c-9386-4c7b-afb1-f66a8b0da3ea"],
Cell[CellGroupData[{
Cell[5648, 198, 255, 6, 70, "Input",ExpressionUUID->"80150650-6dc7-4abf-8634-c91578c39e4a"],
Cell[5906, 206, 173, 4, 70, "Output",ExpressionUUID->"3baa6704-d206-4378-90d1-a3160dd0faac",
 Evaluatable->False]
}, Open  ]],
Cell[6094, 213, 314, 10, 70, "CodeCaption",ExpressionUUID->"c436bd45-7fcf-4c48-a722-dcfb73d8d900",
 CellTags->"i:7"],
Cell[CellGroupData[{
Cell[6433, 227, 273, 6, 70, "Input",ExpressionUUID->"c0e1382c-bbe5-4d7c-9da6-200691e78e0c"],
Cell[6709, 235, 204, 4, 70, "Output",ExpressionUUID->"0fa3f747-6338-42c7-8c21-011cb7886f6e",
 Evaluatable->False]
}, Open  ]],
Cell[6928, 242, 196, 4, 70, "Text",ExpressionUUID->"abb959d6-7843-44db-803c-e6745801ce2f"],
Cell[7127, 248, 161, 4, 70, "CodeCaption",ExpressionUUID->"5623f91e-6cd0-4c25-bc32-dd1d4c74b976"],
Cell[CellGroupData[{
Cell[7313, 256, 224, 5, 70, "Input",ExpressionUUID->"f979fb3f-d677-4c55-b3c9-bdc07db4a386"],
Cell[7540, 263, 302, 8, 70, "Output",ExpressionUUID->"a2c56b2d-64b9-4d3f-b9eb-9bac3716dc24",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[7857, 274, 205, 4, 70, "CodeCaption",ExpressionUUID->"e2d7d6a0-abad-423c-8efb-d4e1a8e78c63",
 CellTags->"p:46"],
Cell[CellGroupData[{
Cell[8087, 282, 294, 8, 70, "Input",ExpressionUUID->"c459cd34-1c6c-47fe-a886-255bce31c5ba"],
Cell[8384, 292, 257, 7, 70, "Output",ExpressionUUID->"01d2cf7f-3b1f-45d6-b299-bd3fd89aee5e",
 Evaluatable->False]
}, Open  ]],
Cell[8656, 302, 234, 8, 70, "CodeCaption",ExpressionUUID->"2bc3842b-b33f-4f81-b4ef-0f0b25c9b4ff"],
Cell[CellGroupData[{
Cell[8915, 314, 267, 7, 70, "Input",ExpressionUUID->"9a1091df-afad-47cc-bfb1-19f9bf6b0b86"],
Cell[9185, 323, 201, 4, 70, "Output",ExpressionUUID->"13b0c4d8-530f-42f2-ae3e-16351ec8160f",
 Evaluatable->False]
}, Open  ]],
Cell[9401, 330, 318, 8, 70, "Text",ExpressionUUID->"67ed6e08-3c2a-4c03-b259-9f28cf02a823",
 CellTags->"i:8"],
Cell[9722, 340, 262, 10, 70, "CodeCaption",ExpressionUUID->"838f9b9b-83a8-4ef2-b7ab-46f590bea46c"],
Cell[CellGroupData[{
Cell[10009, 354, 201, 4, 70, "Input",ExpressionUUID->"aa4ed83f-eed3-4b8a-a34c-895bc0c7d7a6"],
Cell[10213, 360, 766, 13, 70, "Output",ExpressionUUID->"18072af7-9b69-47bc-9a4a-bf55433522d4",
 Evaluatable->False]
}, Open  ]],
Cell[10994, 376, 280, 7, 70, "Text",ExpressionUUID->"fea1c075-5e00-4044-b0bc-d74417bee565",
 CellTags->"i:9"],
Cell[11277, 385, 175, 4, 70, "CodeCaption",ExpressionUUID->"a76d52d1-4f14-4df4-857c-0c4de0cba195"],
Cell[CellGroupData[{
Cell[11477, 393, 224, 5, 70, "Input",ExpressionUUID->"55550bf0-7d3a-412d-a4c8-90b2860f6e8f"],
Cell[11704, 400, 614, 11, 70, "Output",ExpressionUUID->"2dd93a58-a8b5-4450-8ba9-b6405966d61e",
 Evaluatable->False]
}, Open  ]],
Cell[12333, 414, 554, 16, 70, "Text",ExpressionUUID->"c5916c37-aff5-4483-bf00-42875f82b10d",
 CellTags->"i:10"],
Cell[12890, 432, 261, 8, 70, "CodeCaption",ExpressionUUID->"cd13ef6c-1851-4d0d-a43c-0af983047775"],
Cell[CellGroupData[{
Cell[13176, 444, 261, 6, 70, "Input",ExpressionUUID->"62cee333-4002-4475-a2e7-d560824a38ad"],
Cell[13440, 452, 305, 7, 70, "Output",ExpressionUUID->"e1af86d7-9faa-414b-83d2-c18a4ebbc227",
 Evaluatable->False]
}, Open  ]],
Cell[13760, 462, 573, 18, 70, "Text",ExpressionUUID->"d3cf573e-2e7a-448d-ae16-22a96c450bf2",
 CellTags->"i:11"],
Cell[14336, 482, 251, 8, 70, "CodeCaption",ExpressionUUID->"3b9e2fc5-9edc-4b0f-95fd-53251ede4387"],
Cell[CellGroupData[{
Cell[14612, 494, 220, 5, 70, "Input",ExpressionUUID->"625ac5e7-5c1f-49f4-ad15-58240a4d60ee"],
Cell[14835, 501, 400, 9, 70, "Output",ExpressionUUID->"57f16d1e-8778-4e0e-ace4-e46fecade825",
 Evaluatable->False]
}, Open  ]],
Cell[15250, 513, 178, 4, 70, "CodeCaption",ExpressionUUID->"d60a14f7-327c-4127-bf32-dbd44efe1a1c"],
Cell[CellGroupData[{
Cell[15453, 521, 264, 7, 70, "Input",ExpressionUUID->"4ab08163-22f3-4e02-9f69-12572848e8f2"],
Cell[15720, 530, 295, 8, 70, "Output",ExpressionUUID->"88252033-4320-4b45-9e88-f788c8097897",
 Evaluatable->False]
}, Open  ]],
Cell[16030, 541, 284, 9, 70, "CodeCaption",ExpressionUUID->"274df771-c85b-4f7e-aadf-c7db7b66b839",
 CellTags->{"p:47", "i:12"}],
Cell[CellGroupData[{
Cell[16339, 554, 224, 5, 70, "Input",ExpressionUUID->"e6594139-6130-49d1-8bc8-4a122c237392"],
Cell[16566, 561, 313, 8, 70, "Output",ExpressionUUID->"f0502440-e27a-4a48-99f6-3febd031b233",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[16894, 572, 377, 12, 70, "Text",ExpressionUUID->"a6774136-0c02-4484-8b2c-4b190e5216fa",
 CellTags->"i:13"],
Cell[17274, 586, 270, 7, 70, "CodeCaption",ExpressionUUID->"b00fe649-b72b-4d8b-95b8-f57c57ee8ab5"],
Cell[CellGroupData[{
Cell[17569, 597, 246, 6, 70, "Input",ExpressionUUID->"19e5c110-46dd-4c4f-ae07-a78779acdd18"],
Cell[17818, 605, 282, 5, 70, "Output",ExpressionUUID->"aefc8261-0f8a-465e-ac71-ec8f6881e9fe",
 Evaluatable->False]
}, Open  ]],
Cell[18115, 613, 349, 10, 70, "Text",ExpressionUUID->"2f8aedc8-bc06-44cb-b45e-915af32ae179",
 CellTags->"i:14"],
Cell[18467, 625, 259, 7, 70, "CodeCaption",ExpressionUUID->"4fc4bbd1-8e53-4ccd-821c-debe6218ed6f"],
Cell[CellGroupData[{
Cell[18751, 636, 216, 4, 70, "Input",ExpressionUUID->"e8fced7f-581e-4bb6-9e55-490debc9ed5e"],
Cell[18970, 642, 23871, 565, 70, "Output",ExpressionUUID->"6251267e-bcd5-4fb3-8e35-30fe1442ef71",
 Evaluatable->False]
}, Open  ]],
Cell[42856, 1210, 340, 8, 70, "Text",ExpressionUUID->"717bc03b-8140-48f5-bf8f-16f563b124fe",
 CellTags->"i:15"],
Cell[43199, 1220, 349, 10, 70, "Text",ExpressionUUID->"6010aaf3-81d8-41b6-88cc-e1f982f1d2fd",
 CellTags->"i:16"],
Cell[43551, 1232, 204, 5, 70, "CodeCaption",ExpressionUUID->"b53b7006-c71a-48c0-b673-70765041fb33"],
Cell[CellGroupData[{
Cell[43780, 1241, 229, 6, 70, "Input",ExpressionUUID->"7a1473a4-f376-4ef1-bd53-5c19f1ad564a"],
Cell[44012, 1249, 691, 12, 70, "Output",ExpressionUUID->"e349b797-8c2c-484d-b577-f61bffe18e52",
 Evaluatable->False]
}, Open  ]],
Cell[44718, 1264, 219, 5, 70, "CodeCaption",ExpressionUUID->"f21437e6-1387-4431-b91c-909326c4c59f",
 CellTags->"p:48"],
Cell[CellGroupData[{
Cell[44962, 1273, 272, 7, 70, "Input",ExpressionUUID->"1fb56401-196b-4fed-b745-2ce74d6a2fd8"],
Cell[45237, 1282, 8583, 253, 70, "Output",ExpressionUUID->"4f1997e8-96c4-4964-ae86-92d8b47c73da",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[53835, 1538, 312, 7, 70, "Text",ExpressionUUID->"f5c6da04-2482-4f5b-b13a-16f1286c9ad7",
 CellTags->"i:17"],
Cell[54150, 1547, 186, 4, 70, "CodeCaption",ExpressionUUID->"2cc8d8ba-6a66-4937-9269-125f45289d76"],
Cell[CellGroupData[{
Cell[54361, 1555, 166, 3, 70, "Input",ExpressionUUID->"7048362f-a839-4d0b-a7f0-c83e865469a4"],
Cell[54530, 1560, 191, 4, 70, "Output",ExpressionUUID->"e8958597-68e0-4fcc-8418-0b1be1e02d60",
 Evaluatable->False]
}, Open  ]],
Cell[54736, 1567, 199, 4, 70, "CodeCaption",ExpressionUUID->"268cc7b2-07e2-4974-9814-8b703ab7b0cb"],
Cell[CellGroupData[{
Cell[54960, 1575, 269, 7, 70, "Input",ExpressionUUID->"51bf87b7-e8a5-4303-ad90-19228bc09613"],
Cell[55232, 1584, 614, 12, 70, "Output",ExpressionUUID->"35e243a1-5837-4bbe-9a53-9d08e513a2a0",
 Evaluatable->False]
}, Open  ]],
Cell[55861, 1599, 273, 7, 70, "Text",ExpressionUUID->"5cc6a68f-fb1b-47b1-b749-bbe63e2b94b8"],
Cell[56137, 1608, 228, 6, 70, "CodeCaption",ExpressionUUID->"297be57b-a44a-43f4-b044-8393b3cbf863",
 CellTags->"i:18"],
Cell[CellGroupData[{
Cell[56390, 1618, 355, 9, 70, "Input",ExpressionUUID->"650c363d-7fa4-4bbd-b100-e8ab87c3276a"],
Cell[56748, 1629, 1449, 37, 70, "Output",ExpressionUUID->"3c24a67e-22d2-4d58-9b2c-194db9867043",
 Evaluatable->False]
}, Open  ]],
Cell[58212, 1669, 253, 8, 70, "Text",ExpressionUUID->"dadcc9c7-79d2-4d8c-9698-a7d6e44c8422",
 CellTags->"i:19"],
Cell[58468, 1679, 195, 4, 70, "CodeCaption",ExpressionUUID->"9cf2c905-2dde-402f-95fa-2f999814a995"],
Cell[CellGroupData[{
Cell[58688, 1687, 163, 3, 70, "Input",ExpressionUUID->"c1cecb8a-11c1-4e93-9e1f-8d5acdf2deb7"],
Cell[58854, 1692, 197, 4, 70, "Output",ExpressionUUID->"a5b6a2ee-f99d-456c-b808-85ae362c31a3",
 Evaluatable->False]
}, Open  ]],
Cell[59066, 1699, 235, 5, 70, "CodeCaption",ExpressionUUID->"20696e17-9823-4914-9237-5f58f2ffea46",
 CellTags->"p:49"],
Cell[CellGroupData[{
Cell[59326, 1708, 354, 9, 70, "Input",ExpressionUUID->"377d2e6e-bd7c-4708-9fc1-c43e83fa7778"],
Cell[59683, 1719, 1412, 36, 70, "Output",ExpressionUUID->"6d376dc2-0833-4094-aed0-dfd2444ded52",
 Evaluatable->False]
}, Open  ]],
Cell[61110, 1758, 230, 6, 70, "Text",ExpressionUUID->"a1d37298-f795-44ea-af27-f5e7edee7dc9",
 CellTags->"i:20"],
Cell[61343, 1766, 223, 8, 70, "CodeCaption",ExpressionUUID->"7a4ec1e5-5439-426e-9c64-97fba48d60cc"],
Cell[CellGroupData[{
Cell[61591, 1778, 170, 3, 70, "Input",ExpressionUUID->"f9892e43-a606-421d-84b9-53d68b42a451"],
Cell[61764, 1783, 720, 13, 70, "Output",ExpressionUUID->"5d1bb0bd-8726-4b34-99bd-1c03165a5b40",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[62499, 1799, 273, 8, 70, "CodeCaption",ExpressionUUID->"378da19e-db59-480f-8cae-3aa1fed9bb8b",
 CellTags->"i:21"],
Cell[CellGroupData[{
Cell[62797, 1811, 289, 7, 70, "Input",ExpressionUUID->"21108b6a-9e02-4373-b621-1861ccb9f7d4"],
Cell[63089, 1820, 251, 6, 70, "Output",ExpressionUUID->"27e10754-67e8-40a1-9f71-f55fb286494d",
 Evaluatable->False]
}, Open  ]],
Cell[63355, 1829, 246, 8, 70, "CodeCaption",ExpressionUUID->"a783c10c-11fe-44d8-9c9a-e6cbd5a5237e",
 CellTags->"i:22"],
Cell[CellGroupData[{
Cell[63626, 1841, 264, 6, 70, "Input",ExpressionUUID->"e618ecc9-1412-4409-912a-267c2fa353e6"],
Cell[63893, 1849, 310, 7, 70, "Output",ExpressionUUID->"ec0096c1-2bc1-43ef-88ea-fbc6024acae5",
 Evaluatable->False]
}, Open  ]],
Cell[64218, 1859, 258, 8, 70, "CodeCaption",ExpressionUUID->"44f7e35f-678e-4518-90d5-7d19a3855b08",
 CellTags->"i:23"],
Cell[CellGroupData[{
Cell[64501, 1871, 173, 3, 70, "Input",ExpressionUUID->"a5409555-16f5-46d4-9db5-cea028f711fd"],
Cell[64677, 1876, 1000, 17, 70, "Output",ExpressionUUID->"01abf333-3e26-4122-b7a4-da09dcd30bd2",
 Evaluatable->False]
}, Open  ]],
Cell[65692, 1896, 280, 8, 70, "CodeCaption",ExpressionUUID->"d3f37b2b-078f-409c-b932-33b93b1a6184",
 CellTags->"i:24"],
Cell[CellGroupData[{
Cell[65997, 1908, 213, 4, 70, "Input",ExpressionUUID->"ebd73288-128f-4b50-b09b-e461dac28354"],
Cell[66213, 1914, 834, 14, 70, "Output",ExpressionUUID->"abe25eb4-9e70-4249-86e4-9ef8af24a5c4",
 Evaluatable->False]
}, Open  ]],
Cell[67062, 1931, 263, 7, 70, "CodeCaption",ExpressionUUID->"3343994a-48e2-4a88-9590-06de880b953e"],
Cell[CellGroupData[{
Cell[67350, 1942, 215, 4, 70, "Input",ExpressionUUID->"414d5998-4349-418c-91b9-1b603197c5e4"],
Cell[67568, 1948, 222, 4, 70, "Output",ExpressionUUID->"4a17077e-8f8a-443c-a06c-8ed8d07fe177",
 Evaluatable->False]
}, Open  ]],
Cell[67805, 1955, 466, 16, 70, "Text",ExpressionUUID->"3d15ba1a-4eb3-4892-8b71-8677abed94fc",
 CellTags->"i:25"],
Cell[68274, 1973, 196, 4, 70, "CodeCaption",ExpressionUUID->"81525f79-d794-4eeb-91a4-a80f6a92d593",
 CellTags->"i:26"],
Cell[CellGroupData[{
Cell[68495, 1981, 228, 5, 70, "Input",ExpressionUUID->"2074d497-b344-46bd-a444-5cbb91f7ffe4"],
Cell[68726, 1988, 4368, 76, 70, "Output",ExpressionUUID->"b14b00e4-35ef-4085-bbe6-2c29d5226ebf",
 Evaluatable->False]
}, Open  ]],
Cell[73109, 2067, 185, 4, 70, "CodeCaption",ExpressionUUID->"01148fe8-9ab8-4d7f-88cb-33a5bc73af2a",
 CellTags->"i:27"],
Cell[CellGroupData[{
Cell[73319, 2075, 267, 6, 70, "Input",ExpressionUUID->"9ca27605-1f3d-40af-bb46-5f109da49895"],
Cell[73589, 2083, 1866, 37, 70, "Output",ExpressionUUID->"25a1e508-4561-499e-92d3-d97480d54dea",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75504, 2126, 175, 4, 70, "VocabularySection",ExpressionUUID->"4d54e2b7-a370-415f-8a2a-d396a55a55fe",
 CellTags->"p:50"],
Cell[75682, 2132, 7032, 177, 70, "VocabularyTable",ExpressionUUID->"fd00cb12-a7ed-4303-b459-cc4ca1573ea8",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82751, 2314, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"d5408c30-9f43-4169-a5d7-e341bc53a607"],
Cell[CellGroupData[{
Cell[84556, 2364, 1452, 45, 70, "ExerciseSummaryCell",ExpressionUUID->"95ac9034-d460-46ad-94b5-cbaa0d9e6655"],
Cell[CellGroupData[{
Cell[86033, 2413, 806, 23, 70, "Exercise",ExpressionUUID->"310e89b5-c892-49d7-98f1-5e7732e358ed"],
Cell[86842, 2438, 1095, 31, 70, "ExerciseOutput",ExpressionUUID->"8e40acb8-6e3a-4b9c-93f3-5a23564e4ba7"]
}, Closed]],
Cell[CellGroupData[{
Cell[87974, 2474, 722, 20, 70, "Exercise",ExpressionUUID->"da7a0bf2-457b-4fe8-b428-e6d4bf756a47"],
Cell[88699, 2496, 1136, 32, 70, "ExerciseOutput",ExpressionUUID->"2ba5ab42-91de-4fc1-88d6-865b10b6196c"]
}, Closed]],
Cell[CellGroupData[{
Cell[89872, 2533, 716, 20, 70, "Exercise",ExpressionUUID->"7422e693-e5c8-4720-a3a0-827f8f45bc38"],
Cell[90591, 2555, 1136, 32, 70, "ExerciseOutput",ExpressionUUID->"23540d4e-afbe-40af-877b-2a2e5c2d576b"]
}, Closed]],
Cell[CellGroupData[{
Cell[91764, 2592, 821, 23, 70, "Exercise",ExpressionUUID->"4b233154-aea9-4608-bcc4-80d9b6f61858",
 CellTags->"i:28"],
Cell[92588, 2617, 1906, 43, 70, "ExerciseOutput",ExpressionUUID->"4aa622a3-28bd-401c-a3cd-530d8e3179d9"]
}, Closed]],
Cell[CellGroupData[{
Cell[94531, 2665, 950, 32, 70, "Exercise",ExpressionUUID->"020cdda1-ecc3-4ae4-9cca-dc15fc57d439"],
Cell[95484, 2699, 1087, 31, 70, "ExerciseOutput",ExpressionUUID->"f67e126f-7533-4599-ba50-33791fc342f2"]
}, Closed]],
Cell[CellGroupData[{
Cell[96608, 2735, 859, 23, 70, "Exercise",ExpressionUUID->"332c38f6-b59c-4f70-a93f-98ed684c1d7e"],
Cell[97470, 2760, 2820, 73, 70, "ExerciseOutput",ExpressionUUID->"1b198612-38e4-4569-af4e-40258ce844af"]
}, Closed]],
Cell[CellGroupData[{
Cell[100327, 2838, 805, 21, 70, "Exercise",ExpressionUUID->"b5ea32b3-771b-44d8-a44e-6ff220b5e63d"],
Cell[101135, 2861, 36337, 866, 70, "ExerciseOutput",ExpressionUUID->"8ebffb53-c4dc-4a60-96dc-e6f620e5f44f"]
}, Closed]],
Cell[CellGroupData[{
Cell[137509, 3732, 775, 21, 70, "Exercise",ExpressionUUID->"633ca38e-91c1-44f0-90a7-00a20f95ca96"],
Cell[138287, 3755, 1088, 31, 70, "ExerciseOutput",ExpressionUUID->"e498811b-c565-48ad-8d4b-025d4aa8a6bd"]
}, Closed]],
Cell[CellGroupData[{
Cell[139412, 3791, 776, 21, 70, "Exercise",ExpressionUUID->"b2aee78a-17d2-462d-b232-dd596e8d8b72"],
Cell[140191, 3814, 1086, 31, 70, "ExerciseOutput",ExpressionUUID->"6df4825c-d45d-4c7a-97bf-dc0b921ecb5c"]
}, Closed]],
Cell[CellGroupData[{
Cell[141314, 3850, 778, 21, 70, "Exercise",ExpressionUUID->"0e2e8d61-5202-4f41-933d-0b99d8b25c78"],
Cell[142095, 3873, 1291, 34, 70, "ExerciseOutput",ExpressionUUID->"28164449-3bff-4df8-acfe-7d5426b27976"]
}, Closed]],
Cell[CellGroupData[{
Cell[143423, 3912, 763, 21, 70, "Exercise",ExpressionUUID->"bdeb71a9-ead1-4379-a7cc-94fca51c1b8c"],
Cell[144189, 3935, 1844, 43, 70, "ExerciseOutput",ExpressionUUID->"d8191f3a-d827-4010-bb78-5593c632c316"]
}, Closed]],
Cell[CellGroupData[{
Cell[146070, 3983, 907, 26, 70, "Exercise",ExpressionUUID->"4bd500c5-9296-4b73-a59c-e61412dc1c87"],
Cell[146980, 4011, 1082, 31, 70, "ExerciseOutput",ExpressionUUID->"bb31db79-dce6-4998-a209-fd269f6abdae"]
}, Closed]],
Cell[CellGroupData[{
Cell[148099, 4047, 936, 26, 70, "Exercise",ExpressionUUID->"b9517e7b-d067-478d-9c58-e32589ec250d"],
Cell[149038, 4075, 1084, 31, 70, "ExerciseOutput",ExpressionUUID->"f6f778cc-8ab8-4b93-89fc-1ea6360e241d"]
}, Closed]],
Cell[CellGroupData[{
Cell[150159, 4111, 914, 26, 70, "Exercise",ExpressionUUID->"1a9843aa-c7bc-4bd0-86f7-cfb4ed35f65b"],
Cell[151076, 4139, 10458, 198, 70, "ExerciseOutput",ExpressionUUID->"0cfc1b0f-fab8-4702-a067-0394f703c568"]
}, Closed]],
Cell[CellGroupData[{
Cell[161571, 4342, 1021, 32, 70, "Exercise",ExpressionUUID->"4b8a5327-3d75-4f38-b471-826ab2ff9f2b"],
Cell[162595, 4376, 22347, 519, 70, "ExerciseOutput",ExpressionUUID->"e86b266d-3882-415b-a466-1370b629a012"]
}, Closed]],
Cell[CellGroupData[{
Cell[184979, 4900, 972, 29, 70, "Exercise",ExpressionUUID->"88826d14-b45e-4a48-a074-5f9391f21967"],
Cell[185954, 4931, 20030, 466, 70, "ExerciseOutput",ExpressionUUID->"4a5a8f6b-2cb4-4fee-ba40-d3b534e165c2"]
}, Closed]],
Cell[CellGroupData[{
Cell[206021, 5402, 708, 20, 70, "Exercise",ExpressionUUID->"11c955da-7e85-4575-8ce3-a4096e8cf29c"],
Cell[206732, 5424, 1087, 31, 70, "ExerciseOutput",ExpressionUUID->"c8dc0769-60cd-4104-9a93-a54b26bcb03c"]
}, Closed]],
Cell[CellGroupData[{
Cell[207856, 5460, 738, 20, 70, "Exercise",ExpressionUUID->"8a3a0fca-6621-4769-9eab-daeae1c314f5"],
Cell[208597, 5482, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"2e671c49-0751-4ff8-b661-e451dfc4720f"]
}, Closed]],
Cell[CellGroupData[{
Cell[209701, 5518, 744, 21, 70, "Exercise",ExpressionUUID->"bfc93c2c-7eb6-4f1a-b74a-412c19fca4d9"],
Cell[210448, 5541, 5025, 119, 70, "ExerciseOutput",ExpressionUUID->"7dc42a6c-fac9-4ca3-98b5-5993bd089ae4"]
}, Closed]],
Cell[CellGroupData[{
Cell[215510, 5665, 762, 23, 70, "Exercise",ExpressionUUID->"16476dd2-ac55-4716-a6bf-99ce81fcfe86"],
Cell[216275, 5690, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"0f58b842-e20b-42f3-879f-47c85623d86e"]
}, Closed]],
Cell[CellGroupData[{
Cell[217379, 5726, 720, 20, 70, "Exercise",ExpressionUUID->"ddf49df1-5cc0-4fc0-83e8-2e4743c53296",
 CellTags->"i:29"],
Cell[218102, 5748, 2831, 59, 70, "ExerciseOutput",ExpressionUUID->"57ebda89-2f51-47c0-a3cb-6f6952ea1177"]
}, Closed]],
Cell[CellGroupData[{
Cell[220970, 5812, 765, 21, 70, "Exercise",ExpressionUUID->"26977dc6-3fdc-4a55-bc1b-f5c5cb8e2d8d"],
Cell[221738, 5835, 26982, 644, 70, "ExerciseOutput",ExpressionUUID->"66c4148e-fd11-4000-b0bf-ab9760c82ff3"]
}, Closed]],
Cell[CellGroupData[{
Cell[248757, 6484, 769, 23, 70, "Exercise",ExpressionUUID->"4360f85e-b4e1-4884-930f-8dad04715083"],
Cell[249529, 6509, 3159, 59, 70, "ExerciseOutput",ExpressionUUID->"697bfdb3-4a73-452b-8eae-abb42a87196e"]
}, Closed]],
Cell[CellGroupData[{
Cell[252725, 6573, 709, 20, 70, "Exercise",ExpressionUUID->"14b988ea-7836-4c09-80fb-b38224b99178"],
Cell[253437, 6595, 5956, 101, 70, "ExerciseOutput",ExpressionUUID->"8701859e-0257-4788-9560-b0d2ecf3685a"]
}, Closed]],
Cell[CellGroupData[{
Cell[259430, 6701, 748, 21, 70, "Exercise",ExpressionUUID->"8c89d6c5-a158-4bf0-814d-f3e5e9ca72a0"],
Cell[260181, 6724, 1199, 33, 70, "ExerciseOutput",ExpressionUUID->"31af64e6-0519-4c1c-8b50-7aa742596f99"]
}, Closed]],
Cell[CellGroupData[{
Cell[261417, 6762, 724, 20, 70, "Exercise",ExpressionUUID->"83553475-c35b-4803-8c86-be9e267150ea"],
Cell[262144, 6784, 2248, 51, 70, "ExerciseOutput",ExpressionUUID->"d674d10e-a796-4cab-89af-d7fc3849a00d"]
}, Closed]],
Cell[CellGroupData[{
Cell[264429, 6840, 755, 21, 70, "Exercise",ExpressionUUID->"24a83f2b-a56c-4795-b297-0c882bc68680"],
Cell[265187, 6863, 7348, 141, 70, "ExerciseOutput",ExpressionUUID->"aa8860e8-584a-45a8-bdf6-b3aa12067f0f"]
}, Closed]],
Cell[CellGroupData[{
Cell[272572, 7009, 822, 24, 70, "Exercise",ExpressionUUID->"8bde00ae-7fd6-4977-994d-bb03598722c9"],
Cell[273397, 7035, 4593, 96, 70, "ExerciseOutput",ExpressionUUID->"7661075e-1207-4660-9c97-c444280070b0"]
}, Closed]],
Cell[CellGroupData[{
Cell[278027, 7136, 858, 24, 70, "Exercise",ExpressionUUID->"d901f066-2835-4eaf-a0e5-6c23b8d97087"],
Cell[278888, 7162, 5387, 111, 70, "ExerciseOutput",ExpressionUUID->"08c2abdc-8c66-436d-aaf2-bea271807df8"]
}, Closed]],
Cell[CellGroupData[{
Cell[284312, 7278, 937, 26, 70, "Exercise",ExpressionUUID->"1ecf0036-89a9-4a0e-bf77-8bcb2298d946",
 CellTags->"LastCellOfAPage"],
Cell[285252, 7306, 4638, 98, 70, "ExerciseOutput",ExpressionUUID->"6d573929-9430-4c48-8f6d-307a08e48e20"]
}, Closed]],
Cell[CellGroupData[{
Cell[289927, 7409, 746, 21, 70, "Exercise",ExpressionUUID->"5035a32e-e349-4d7c-a4e1-453f88e237bc"],
Cell[290676, 7432, 1196, 33, 70, "ExerciseOutput",ExpressionUUID->"d6ab0048-8194-44fa-8c25-b493c01d2d05"]
}, Closed]],
Cell[CellGroupData[{
Cell[291909, 7470, 724, 20, 70, "Exercise",ExpressionUUID->"b1cfe41a-1e3f-4875-be34-267b3dc5d20c"],
Cell[292636, 7492, 1726, 47, 70, "ExerciseOutput",ExpressionUUID->"4c479610-816e-4f85-a337-a1828b480a1f"]
}, Closed]],
Cell[CellGroupData[{
Cell[294399, 7544, 781, 21, 70, "Exercise",ExpressionUUID->"c6ac2ca3-1e7a-4b89-b07e-f929254b3bdc"],
Cell[295183, 7567, 1069, 31, 70, "ExerciseOutput",ExpressionUUID->"eb9db74d-96ba-4d96-9218-cae88fe51337"]
}, Closed]],
Cell[CellGroupData[{
Cell[296289, 7603, 819, 21, 70, "Exercise",ExpressionUUID->"ce7aa125-ab55-4edf-9fc3-a2935e9ada19"],
Cell[297111, 7626, 1228, 34, 70, "ExerciseOutput",ExpressionUUID->"10e1eb09-15a0-44f1-8ba8-090636ff22ff"]
}, Closed]],
Cell[CellGroupData[{
Cell[298376, 7665, 745, 21, 70, "Exercise",ExpressionUUID->"3a879e5b-a548-4753-a72e-5eaaa6593f2f"],
Cell[299124, 7688, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"26ac09f0-46a1-40bb-8228-18b9a7654450"]
}, Closed]],
Cell[CellGroupData[{
Cell[300228, 7724, 724, 20, 70, "Exercise",ExpressionUUID->"a1ca7ffb-5d71-437d-8ca6-eca3ede09b84"],
Cell[300955, 7746, 16978, 305, 70, "ExerciseOutput",ExpressionUUID->"a030b041-3292-40cf-8062-aca5499bdf3a"]
}, Closed]],
Cell[CellGroupData[{
Cell[317970, 8056, 724, 20, 70, "Exercise",ExpressionUUID->"3e2e728f-cdac-4641-a818-306a425cf14b"],
Cell[318697, 8078, 1908, 43, 70, "ExerciseOutput",ExpressionUUID->"2f37c7bb-7975-4f2c-8dff-7d796bfc021e"]
}, Closed]],
Cell[CellGroupData[{
Cell[320642, 8126, 771, 21, 70, "Exercise",ExpressionUUID->"42ae52b1-fb73-48ea-8445-dc347d3f3161"],
Cell[321416, 8149, 3769, 89, 70, "ExerciseOutput",ExpressionUUID->"a16aa8db-445b-47d0-9357-7e26215c91a4"]
}, Closed]],
Cell[CellGroupData[{
Cell[325222, 8243, 735, 20, 70, "Exercise",ExpressionUUID->"5e336858-b0a2-435f-b5c1-cdd05b85af0a"],
Cell[325960, 8265, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"c62aeef8-09f9-4a62-ab02-f47c13997c6f"]
}, Closed]],
Cell[CellGroupData[{
Cell[327064, 8301, 743, 21, 70, "Exercise",ExpressionUUID->"ca2430b8-8d2a-4ec4-9acc-0ca0d0e1447d"],
Cell[327810, 8324, 41750, 947, 70, "ExerciseOutput",ExpressionUUID->"787002a7-8787-4149-9443-4e23d1d3e0b0"]
}, Closed]],
Cell[CellGroupData[{
Cell[369597, 9276, 736, 20, 70, "Exercise",ExpressionUUID->"b73eef40-33ef-438d-8d7d-10e0a534ae32"],
Cell[370336, 9298, 12542, 235, 70, "ExerciseOutput",ExpressionUUID->"de7baa7e-02d5-459d-9ebc-1fc7e3fb6d2a"]
}, Closed]],
Cell[CellGroupData[{
Cell[382915, 9538, 789, 23, 70, "Exercise",ExpressionUUID->"d3d5d88e-0a96-48c6-b2ae-0c34a8537534"],
Cell[383707, 9563, 4728, 102, 70, "ExerciseOutput",ExpressionUUID->"312eea89-a8d9-46fd-a540-9100acc4ae90"]
}, Closed]],
Cell[CellGroupData[{
Cell[388472, 9670, 720, 20, 70, "Exercise",ExpressionUUID->"11debe04-4cc1-493c-939f-9eadc517689b"],
Cell[389195, 9692, 8446, 159, 70, "ExerciseOutput",ExpressionUUID->"7e71f986-782c-468e-a750-7fc253d4769f"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[397702, 9858, 160, 4, 70, "QASection",ExpressionUUID->"5b00b670-4e20-4f50-b553-3722664b5862",
 CellTags->"p:52"],
Cell[397865, 9864, 400, 13, 70, "Question",ExpressionUUID->"8744b7c0-37d3-4e26-ac0d-4721ad12f1d8"],
Cell[398268, 9879, 744, 22, 70, "Answer",ExpressionUUID->"afc66f6b-81a1-45bd-ad64-6859ea5d26c7",
 CellTags->"i:30"],
Cell[399015, 9903, 212, 5, 70, "Question",ExpressionUUID->"20b04be5-7051-44ca-b127-50a86345db87"],
Cell[399230, 9910, 646, 18, 70, "Answer",ExpressionUUID->"9464ce6a-d768-4d5c-999c-6fad688ecdce",
 CellTags->"i:31"],
Cell[399879, 9930, 315, 10, 70, "Question",ExpressionUUID->"d98e495d-cae6-44a1-9773-491441ab7bbb",
 CellTags->"i:32"],
Cell[400197, 9942, 1020, 26, 70, "Answer",ExpressionUUID->"e9afcc39-6219-4736-8789-0c769bfb6af5"],
Cell[401220, 9970, 197, 4, 70, "Question",ExpressionUUID->"953cb306-ec7f-4961-994d-a8c0d6372edb"],
Cell[401420, 9976, 254, 7, 70, "Answer",ExpressionUUID->"b70ef65c-aa38-4b26-ad83-7b1ffd80f4df"],
Cell[401677, 9985, 247, 5, 70, "Question",ExpressionUUID->"a05468da-4929-4d2b-a448-1913ac3fe9a4"],
Cell[401927, 9992, 366, 10, 70, "Answer",ExpressionUUID->"00f5451e-452b-4234-9645-f4e49830db05"],
Cell[402296, 10004, 245, 7, 70, "Question",ExpressionUUID->"db250831-dd2f-4a60-9f47-9551f4b505b1",
 CellTags->"i:33"],
Cell[402544, 10013, 628, 21, 70, "Answer",ExpressionUUID->"3dbd94ce-9752-4c27-afaa-354a585d3aa4"],
Cell[403175, 10036, 208, 4, 70, "Question",ExpressionUUID->"52c6940c-91a6-4581-8b63-6f4e398fbfb8",
 CellTags->"i:34"],
Cell[403386, 10042, 582, 12, 70, "Answer",ExpressionUUID->"8f8991a4-24fe-44af-ab23-df84f5980799"],
Cell[403971, 10056, 216, 6, 70, "Question",ExpressionUUID->"cb42c763-9034-4af9-bd37-8edb9682758c"],
Cell[404190, 10064, 356, 14, 70, "Answer",ExpressionUUID->"7fdd539a-b9af-4447-b7a6-df4773058d66"],
Cell[404549, 10080, 228, 6, 70, "Question",ExpressionUUID->"8befd43b-6011-461b-9527-a56a49bfe84e",
 CellTags->"i:35"],
Cell[404780, 10088, 438, 15, 70, "Answer",ExpressionUUID->"e7ebafd8-ada7-4d41-9e73-6a2ea2a1687e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[405255, 10108, 157, 4, 70, "TechNoteSection",ExpressionUUID->"34dce786-5c04-4120-8023-545142b4d528"],
Cell[405415, 10114, 397, 11, 70, "TechNote",ExpressionUUID->"79dd4888-4564-42c3-bcd1-8892a8c0d70c",
 CellTags->"i:36"],
Cell[405815, 10127, 485, 15, 70, "TechNote",ExpressionUUID->"4bdd2587-39c8-48d7-8763-9d49d2660e94"],
Cell[406303, 10144, 633, 18, 70, "TechNote",ExpressionUUID->"f1e24207-67d8-4ea1-b785-0641462e3353",
 CellTags->"i:37"],
Cell[406939, 10164, 306, 9, 70, "TechNote",ExpressionUUID->"342b7493-bbe5-459b-929b-33d0da9069de"],
Cell[407248, 10175, 435, 11, 70, "TechNote",ExpressionUUID->"8d6ceae3-7eb1-4d86-a07e-3e40aa850cfd",
 CellTags->"i:38"],
Cell[407686, 10188, 597, 16, 70, "TechNote",ExpressionUUID->"6a5de72d-0a3e-427d-8481-753bdad3a275"]
}, Open  ]],
Cell[CellGroupData[{
Cell[408320, 10209, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"22ce2082-4488-4cb5-bc2c-3364d2476a0a"],
Cell[408488, 10215, 352, 8, 70, "MoreExplore",ExpressionUUID->"fd074e9b-56cb-4641-b438-e7481eb61f62",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature OLN8OP7oT133wIOYlK3jDq2R *)
