(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    273499,       6361]
NotebookOptionsPosition[    169067,       4264]
NotebookOutlinePosition[    262727,       6176]
CellTagsIndexPosition[    262331,       6158]
WindowTitle->Interactive Manipulation: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Interactive Manipulation", "SectionInline",ExpressionUUID->
   "ced00f92-2522-42e7-980b-599d2572362c"],
  $Line = 0; Null]], "Section",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowCellLabel->False,
 CounterAssignments->{{"Section", 8}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:33",ExpressionUUID->"5de891c8-bc60-430c-97d8-44fba6081abe"],

Cell[TextData[{
 "So far, we\[CloseCurlyQuote]ve been using the Wolfram Language in a \
question-answer way: we type input, and the language responds with output. \
But the language also lets you set up user interfaces where one can \
continually manipulate a variable. The function ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " works a lot like ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 ", except that instead of producing a list of results, it gives a slider to \
interactively choose the value you want."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"f83b3285-6606-45b4-86f8-faf1ed6fdcb1"],

Cell[TextData[{
 "The slider lets you pick values of ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"f7f1f736-589f-4740-8c75-3033e0e96915"],
 " between 1 and 5 (in steps of 1):"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c43a0e50-cc24-4fcb-85eb-4afb370817cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"Orange", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "5", ",", "1"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"6584d885-9b48-4438-879d-4b2657f75e7c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 5, 1}}, Typeset`size$$ = {
    20., {2.939453125, 10.1923828125}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`n$348$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$348$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Table[Orange, $CellContext`n$$], 
      "Specifications" :> {{$CellContext`n$$, 1, 5, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{247., {54., 62.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"925276a9-1d1a-4623-899b-f867d8a76e79"]
}, Open  ]],

Cell["Here\[CloseCurlyQuote]s the whole sequence of possible results:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e3908d3e-b18c-48a0-9766-fc19880b009d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"Orange", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "5", ",", "1"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"4477a56a-9873-408e-8609-aa6617bcc604"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0],
     Editable->False,
     Selectable->False], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0],
      Editable->False,
      Selectable->False]}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[2]=",ExpressionUUID->"bff9e3f5-4a6a-4876-b784-fd716976ef9f"]
}, Open  ]],

Cell["\<\
Here\[CloseCurlyQuote]s a similar interface for displaying a column of powers \
of a number:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6cff301b-b21f-4d64-a4c9-d7e3a0d45d14"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"n", "^", "2"}], ",", 
      RowBox[{"n", "^", "3"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10", ",", "1"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"7abe3b59-7d5b-4f1d-b871-73570a3c1f40"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 6, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 10, 1}}, Typeset`size$$ = {
    22., {23.3837890625, 30.6162109375}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`n$425$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$425$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Column[{$CellContext`n$$, $CellContext`n$$^2, $CellContext`n$$^3}], 
      "Specifications" :> {{$CellContext`n$$, 1, 10, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{247., {72., 80.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"113fef4c-239e-449b-80bb-963a9637047f"]
}, Open  ]],

Cell["And here\[CloseCurlyQuote]s the list of possible results in this \
case:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"356c829e-23a7-4bbb-8603-b16567b344ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"n", "^", "2"}], ",", 
      RowBox[{"n", "^", "3"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10", ",", "1"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"15b5f1f8-d856-4249-bfa0-4a87e86805f9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"1"},
      {"1"},
      {"1"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"2"},
      {"4"},
      {"8"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"3"},
      {"9"},
      {"27"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"4"},
      {"16"},
      {"64"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"5"},
      {"25"},
      {"125"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"6"},
      {"36"},
      {"216"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"7"},
      {"49"},
      {"343"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"8"},
      {"64"},
      {"512"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"9"},
      {"81"},
      {"729"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"10"},
      {"100"},
      {"1000"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"eaad5b52-fc3a-4e24-82da-ffe9f0fa07e5"]
}, Open  ]],

Cell[TextData[{
 "Unlike ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " isn\[CloseCurlyQuote]t limited to a fixed set of possible values. If you \
simply omit the step size in ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 ", it\[CloseCurlyQuote]ll assume you want any possible value in the range, \
not limited to whole numbers."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"97b59067-9300-4d05-bb2d-4810ac77c7e7"],

Cell[TextData[{
 "Without the step size, ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " allows any value:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:34",ExpressionUUID->"37d877b8-f854-44cc-a6ff-34c049b94700"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"n", "^", "2"}], ",", 
      RowBox[{"n", "^", "3"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"5f32bc9a-edc0-4aeb-ab82-8aaa28eab31b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 4.41, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 10}}, Typeset`size$$ = {
    48., {23.3837890625, 30.6162109375}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`n$449$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$449$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Column[{$CellContext`n$$, $CellContext`n$$^2, $CellContext`n$$^3}], 
      "Specifications" :> {{$CellContext`n$$, 1, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{247., {72., 80.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"e6ebb3a7-4059-4cbf-8ac0-8bd3d06abdae"]
}, Open  ]],

Cell["\<\
It\[CloseCurlyQuote]s very common to have graphics that you want to adjust \
interactively.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"0fa7f5d8-9a11-4a5d-8fac-400713a27129"],

Cell["A bar chart that changes as you move the slider:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"327b51e8-b962-458c-9af3-905dc63990f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"BarChart", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "a", ",", "4", ",", 
      RowBox[{"2", "*", "a"}], ",", "4", ",", 
      RowBox[{"3", "*", "a"}], ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"c90efb21-f030-47a7-9759-1d86df2b93a7"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 5}}, Typeset`size$$ = {200., {59., 66.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$472$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$472$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      BarChart[{
        1, $CellContext`a$$, 4, 2 $CellContext`a$$, 4, 3 $CellContext`a$$, 
         1}], "Specifications" :> {{$CellContext`a$$, 0, 5}}, "Options" :> {},
       "DefaultOptions" :> {}],
     ImageSizeCache->{247., {107., 115.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{ImageSize->200},
 CellLabel->"Out[6]=",ExpressionUUID->"20841a67-021d-4a20-b1fe-997ea9941818"]
}, Open  ]],

Cell["A pie chart of the same list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7085fab9-a1c6-41c4-a980-a5f113c454c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"PieChart", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "a", ",", "4", ",", 
      RowBox[{"2", "*", "a"}], ",", "4", ",", 
      RowBox[{"3", "*", "a"}], ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"4635d1b3-f761-4c41-bf6b-11053ca84191"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.98, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 5}}, Typeset`size$$ = {200., {97., 103.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$589$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$589$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      PieChart[{
        1, $CellContext`a$$, 4, 2 $CellContext`a$$, 4, 3 $CellContext`a$$, 
         1}], "Specifications" :> {{$CellContext`a$$, 0, 5}}, "Options" :> {},
       "DefaultOptions" :> {}],
     ImageSizeCache->{247., {144., 152.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{ImageSize->200},
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[7]=",ExpressionUUID->"2a013e6c-50eb-4c38-832e-07277a831d0a"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " lets you set up any number of controls. You just give the information for \
each variable in turn, one after another. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:35",ExpressionUUID->"ab559f97-e831-4913-ae2c-7f0b9244be59"],

Cell["\<\
Build an interface to vary the number of sides, and the hue, of a polygon:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5c5e3107-ca88-4916-bdb6-a30efe6399ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"RegularPolygon", "[", "n", "]"}], ",", 
      RowBox[{"Hue", "[", "h", "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5", ",", "20", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"23ae9cc5-a64b-4a93-9ed6-46deba2f5322"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`h$$ = 0.794, $CellContext`n$$ = 10, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 5, 20, 1}, {
      Hold[$CellContext`h$$], 0, 1}}, Typeset`size$$ = {200., {92., 98.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$665$$ = 0, $CellContext`h$666$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`h$$ = 0, $CellContext`n$$ = 5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$665$$, 0], 
        Hold[$CellContext`h$$, $CellContext`h$666$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Style[
         RegularPolygon[$CellContext`n$$], 
         Hue[$CellContext`h$$]]], 
      "Specifications" :> {{$CellContext`n$$, 5, 20, 1}, {$CellContext`h$$, 0,
          1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{247., {153., 161.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{ImageSize->200},
 CellLabel->"Out[8]=",ExpressionUUID->"e53963cb-ff7e-4037-beb4-d1ced7810110"]
}, Open  ]],

Cell[TextData[{
 "There are many ways to specify controls for ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 ". If you give a list of possible values, you\[CloseCurlyQuote]ll get a ",
 StyleBox["chooser",
  FontSlant->"Italic"],
 " or ",
 StyleBox["menu",
  FontSlant->"Italic"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"7ee05707-fee6-4b40-8c4c-0102c4a712d0"],

Cell["\<\
Build an interface that lets you choose between three colors:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3f96c3cc-72e1-4b43-9d19-55cb2205de20"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"RegularPolygon", "[", "5", "]"}], ",", "color"}], "]"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"color", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Yellow", ",", "Blue"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"16e7787c-5e2e-42da-b079-82e203847f9a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`color$$ = RGBColor[1, 0, 0], 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`color$$], {
       RGBColor[1, 0, 0], 
       RGBColor[1, 1, 0], 
       RGBColor[0, 0, 1]}}}, Typeset`size$$ = {100., {44., 51.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`color$985$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`color$$ = RGBColor[1, 0, 0]}, 
      "ControllerVariables" :> {
        Hold[$CellContext`color$$, $CellContext`color$985$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Style[
         RegularPolygon[5], $CellContext`color$$]], 
      "Specifications" :> {{$CellContext`color$$, {
          RGBColor[1, 0, 0], 
          RGBColor[1, 1, 0], 
          RGBColor[0, 0, 1]}}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{145., {89., 97.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{ImageSize->100},
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[9]=",ExpressionUUID->"958ff456-734c-434d-974e-8949ef7d5b78"]
}, Open  ]],

Cell[TextData[{
 "If there are more choices, like for ",
 Cell[BoxData[
 "size"], "InlineCode",ExpressionUUID->"03e80394-da28-4b19-a09c-1dab0db0cb68"],
 " here, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"CodeLink"]], "InlineCode",ExpressionUUID->
  "a8c26a1a-18fe-49c8-bd8e-0d07ac1018f6"],
 " sets up a drop-down menu:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b0822a83-362a-4b3c-8d9f-deca9fdf8166"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"value", ",", "color", ",", "size"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"value", ",", "1", ",", "20", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"color", ",", 
     RowBox[{"{", 
      RowBox[{"Black", ",", "Red", ",", "Purple"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"size", ",", 
     RowBox[{"Range", "[", 
      RowBox[{"12", ",", "96", ",", "12"}], "]"}]}], "}"}]}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"68ccf6a3-8c1f-43ae-a40c-686c69613aed"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`color$$ = RGBColor[
    0.5, 0, 0.5], $CellContext`size$$ = 60, $CellContext`value$$ = 14, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`value$$], 1, 20, 1}, {
      Hold[$CellContext`color$$], {
       GrayLevel[0], 
       RGBColor[1, 0, 0], 
       RGBColor[0.5, 0, 0.5]}}, {
      Hold[$CellContext`size$$], {12, 24, 36, 48, 60, 72, 84, 96}}}, 
    Typeset`size$$ = {60., {0., 39.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`value$10129$$ = 0, $CellContext`color$10130$$ = 
    0, $CellContext`size$10131$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`color$$ = 
        GrayLevel[0], $CellContext`size$$ = 12, $CellContext`value$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`value$$, $CellContext`value$10129$$, 0], 
        Hold[$CellContext`color$$, $CellContext`color$10130$$, 0], 
        Hold[$CellContext`size$$, $CellContext`size$10131$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Style[$CellContext`value$$, $CellContext`color$$, $CellContext`size$$], 
      "Specifications" :> {{$CellContext`value$$, 1, 20, 
         1}, {$CellContext`color$$, {
          GrayLevel[0], 
          RGBColor[1, 0, 0], 
          RGBColor[0.5, 0, 0.5]}}, {$CellContext`size$$, {12, 24, 36, 48, 60, 
         72, 84, 96}}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{265., {91., 99.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"5c7d7a74-ac6d-479b-927f-15cac969d9c7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2ecdd701-8a1f-4458-8d43-a2b78259f112"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Manipulate",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["anything", "CodeVariableLrg"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["n", "CodeVariableLrg"], ",", "0", ",", "10", ",", "1"}], 
       "}"}]}], "]"}], " ", Cell[TextData[{
     "manipulate ",
     Cell[BoxData[
      StyleBox["anything", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "5d972e5f-ebaa-4560-9c00-66399522aed9"],
     " with ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "3a72c57a-99f3-4bd5-83e1-e091d7c974bf"],
     " varying in steps of 1 "
    }], "VocabularyText",ExpressionUUID->
     "a6a27544-cb69-4e1a-8448-1a95a1e81562"]},
   {
    RowBox[{
     ButtonBox["Manipulate",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["anything", "CodeVariableLrg"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "CodeVariableLrg"], ",", "0", ",", "10"}], "}"}]}], 
     "]"}], " ", Cell[TextData[{
     "manipulate ",
     Cell[BoxData[
      StyleBox["anything", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "554b3814-56ef-435f-9da7-01d9d26ca5d5"],
     " with ",
     Cell[BoxData[
      StyleBox["x", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "ffcd9993-8b4e-4b56-9f3d-d9b8bfc9a504"],
     " varying continuously "
    }], "VocabularyText",ExpressionUUID->
     "acaa3e07-6b7a-4d27-adc1-c0447627cb01"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"450f611e-3b4e-4ec1-b208-9b091fa905d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"dd8bb8e7-fe93-48c7-ad60-3c9acc922c48"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"15 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 3 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-09-interactive-manipulation-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9c598517-3bc8-4e0a-b4f3-0c1406c8fb3a"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to show ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"CodeLink"], "[", "n", "]"}]], "InlineCode",ExpressionUUID->
  "c16e0000-e8e1-4e9f-9d00-ff5c44a19012"],
 " with ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"b870bebe-16a6-48de-8d31-930089559060"],
 " varying from 0 to 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ee1262fb-3e1d-440d-b8c4-e68cdff508b8"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 100., Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 0, 100}}, Typeset`size$$ = {
          518., {69.82192993164062, 13.775909423828125`}}, Typeset`update$$ = 
          0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
          True, $CellContext`n$11529$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 0}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$11529$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            Range[$CellContext`n$$], 
            "Specifications" :> {{$CellContext`n$$, 0, 100}}, "Options" :> {},
             "DefaultOptions" :> {}],
           ImageSizeCache->{563., {86., 92.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "a2004704-17aa-4f74-8eec-7f359da3a7af"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 100., Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 0, 100}}, 
             Typeset`size$$ = {
              518., {69.82192993164062, 13.775909423828125`}}, 
             Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$11529$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$11529$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Range[$CellContext`n$$], 
              "Specifications" :> {{$CellContext`n$$, 0, 100}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {569., {87., 94.}}, SingleEvaluation -> True], 
            Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ef4645d5-a292-4ca0-a516-586d446ca24a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to plot the whole numbers up to ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"598f1c85-d673-4317-800a-718857ace4b1"],
 ", where ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"15a62011-eba0-462d-b8df-0cda842b54fa"],
 " can range from 5 to 50.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"49cba057-b482-4549-a37e-8faa4afc6432"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 5, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 5, 50, 1}}, Typeset`size$$ = {
          240., {77., 82.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`n$80096$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 5}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$80096$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            ListPlot[
              Range[$CellContext`n$$]], 
            "Specifications" :> {{$CellContext`n$$, 5, 50, 1}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{285., {123., 129.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "74f00d97-291d-43ee-8200-2bcfa21af7eb"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 5, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 5, 50, 1}}, 
             Typeset`size$$ = {240., {77., 82.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$80096$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 5}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$80096$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              ListPlot[
                Range[$CellContext`n$$]], 
              "Specifications" :> {{$CellContext`n$$, 5, 50, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {291., {124., 131.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6f630138-9c09-48ce-a881-2aa0212de666"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to show a column of between 1 and 10 copies of ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"c28303e2-cd61-4b72-8b5f-10dfcfa72654"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d6c36727-7bad-462a-9e7d-4248367a251b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 1, 10, 1}}, Typeset`size$$ = {
          6., {3.14208984375, 9.85791015625}}, Typeset`update$$ = 0, 
          Typeset`initDone$$, Typeset`skipInitDone$$ = 
          True, $CellContext`n$81717$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$81717$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Column[
              Table[$CellContext`x, $CellContext`n$$]], 
            "Specifications" :> {{$CellContext`n$$, 1, 10, 1}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{247., {53., 59.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "fbc59b9a-b91c-4c7d-ab80-193943fc0b63"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 1, 10, 1}}, 
             Typeset`size$$ = {6., {3.14208984375, 9.85791015625}}, 
             Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$81717$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$81717$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Column[
                Table[$CellContext`x, $CellContext`n$$]], 
              "Specifications" :> {{$CellContext`n$$, 1, 10, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {258., {54., 61.}}, SingleEvaluation -> True], 
            Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"96e8fa65-70fc-49dd-93bd-519c2c1aca54"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to show a disk ",
 "with a hue",
 " varying from 0 to 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ab7445fb-8a12-4a86-bcdd-6b7ed9aa500d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`h$$ = 0, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`h$$], 0, 1}}, Typeset`size$$ = {
          200., {97., 103.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`h$11552$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`h$$ = 0}, 
            "ControllerVariables" :> {
              Hold[$CellContext`h$$, $CellContext`h$11552$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            Graphics[
              Style[
               Disk[], 
               Hue[$CellContext`h$$]]], 
            "Specifications" :> {{$CellContext`h$$, 0, 1}}, "Options" :> {}, 
            "DefaultOptions" :> {}],
           ImageSizeCache->{247., {144., 150.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",
       GraphicsBoxOptions->{ImageSize->200},ExpressionUUID->
       "e239b5eb-03be-49d7-ac95-29c4e91360cb"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`h$$ = 0, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`h$$], 0, 1}}, 
             Typeset`size$$ = {200., {97., 103.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`h$11552$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`h$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`h$$, $CellContext`h$11552$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Graphics[
                Style[
                 Disk[], 
                 Hue[$CellContext`h$$]]], 
              "Specifications" :> {{$CellContext`h$$, 0, 1}}, "Options" :> {},
               "DefaultOptions" :> {}], 
             ImageSizeCache -> {258., {145., 152.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cf2807ef-4454-45b5-b13d-e510f485f212"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to show a disk with red, green and blue color components varying from 0 to \
1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"546b0649-241d-4f8b-82f5-b45fc8da7872"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`blue$$ = 0.708, $CellContext`green$$ =
           0.546, $CellContext`red$$ = 0.646, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`red$$], 0, 1}, {
            Hold[$CellContext`green$$], 0, 1}, {
            Hold[$CellContext`blue$$], 0, 1}}, Typeset`size$$ = {
          200., {97., 103.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`red$86907$$ = 
          0, $CellContext`green$86908$$ = 0, $CellContext`blue$86909$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, 
            "Variables" :> {$CellContext`blue$$ = 0, $CellContext`green$$ = 
              0, $CellContext`red$$ = 0}, "ControllerVariables" :> {
              Hold[$CellContext`red$$, $CellContext`red$86907$$, 0], 
              Hold[$CellContext`green$$, $CellContext`green$86908$$, 0], 
              Hold[$CellContext`blue$$, $CellContext`blue$86909$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            Graphics[
              Style[
               Disk[], 
               
               RGBColor[$CellContext`red$$, $CellContext`green$$, \
$CellContext`blue$$]]], 
            "Specifications" :> {{$CellContext`red$$, 0, 
               1}, {$CellContext`green$$, 0, 1}, {$CellContext`blue$$, 0, 1}},
             "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{266., {172., 178.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",
       GraphicsBoxOptions->{ImageSize->200},ExpressionUUID->
       "c0018493-621c-47f2-a30c-b1418336032b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`blue$$ = 
             0.708, $CellContext`green$$ = 0.546, $CellContext`red$$ = 0.646, 
             Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
             Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, 
             Typeset`animvar$$ = 1, Typeset`name$$ = "\"untitled\"", 
             Typeset`specs$$ = {{
                Hold[$CellContext`red$$], 0, 1}, {
                Hold[$CellContext`green$$], 0, 1}, {
                Hold[$CellContext`blue$$], 0, 1}}, 
             Typeset`size$$ = {200., {97., 103.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`red$86907$$ = 0, $CellContext`green$86908$$ = 
             0, $CellContext`blue$86909$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, 
              "Variables" :> {$CellContext`blue$$ = 0, $CellContext`green$$ = 
                0, $CellContext`red$$ = 0}, "ControllerVariables" :> {
                Hold[$CellContext`red$$, $CellContext`red$86907$$, 0], 
                Hold[$CellContext`green$$, $CellContext`green$86908$$, 0], 
                Hold[$CellContext`blue$$, $CellContext`blue$86909$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Graphics[
                Style[
                 Disk[], 
                 
                 RGBColor[$CellContext`red$$, $CellContext`green$$, \
$CellContext`blue$$]]], 
              "Specifications" :> {{$CellContext`red$$, 0, 
                 1}, {$CellContext`green$$, 0, 1}, {$CellContext`blue$$, 0, 
                 1}}, "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {281., {172., 179.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bb528612-b53a-4753-a513-d326f1fa7b2f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to show digit sequences ",
 "of 4-digit integers (between 1000 and 9999)",
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"239aa80d-b1dd-4aaa-a7ee-3e3fd32fa79f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 1000, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 1000, 9999, 1}}, Typeset`size$$ = {
          54., {3., 9.46435546875}}, Typeset`update$$ = 0, Typeset`initDone$$,
           Typeset`skipInitDone$$ = True, $CellContext`n$11575$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 1000}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$11575$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            IntegerDigits[$CellContext`n$$], 
            "Specifications" :> {{$CellContext`n$$, 1000, 9999, 1}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{247., {53., 59.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "7fbf9fe5-b974-49d7-847e-32b9f64e26e6"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 1000, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 1000, 9999, 1}}, 
             Typeset`size$$ = {54., {3., 9.46435546875}}, Typeset`update$$ = 
             0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$11575$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 1000}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$11575$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              IntegerDigits[$CellContext`n$$], 
              "Specifications" :> {{$CellContext`n$$, 1000, 9999, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {258., {54., 61.}}, SingleEvaluation -> True], 
            Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ac27e0d7-6ddc-4f3e-9cfe-7f450e7475bf"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to create a list of between 5 and 50 equally spaced hues.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"3bdceaf9-3183-4b16-81ac-4fbe66696b8f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 5, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 5, 50, 1}}, Typeset`size$$ = {
          98., {3., 9.46435546875}}, Typeset`update$$ = 0, Typeset`initDone$$,
           Typeset`skipInitDone$$ = True, $CellContext`n$50237$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 5}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$50237$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Table[
              
              Hue[$CellContext`h], {$CellContext`h, 0, 1, 
               1/$CellContext`n$$}], 
            "Specifications" :> {{$CellContext`n$$, 5, 50, 1}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{247., {53., 59.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "8ca8eca3-dc07-443e-8798-1e7350076a58"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 5, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 5, 50, 1}}, 
             Typeset`size$$ = {98., {3., 9.46435546875}}, Typeset`update$$ = 
             0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$50237$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 5}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$50237$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Table[
                
                Hue[$CellContext`h], {$CellContext`h, 0, 1, 
                 1/$CellContext`n$$}], 
              "Specifications" :> {{$CellContext`n$$, 5, 50, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {258., {54., 61.}}, SingleEvaluation -> True], 
            Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"750b8cfc-6c63-48b4-b76d-55f62cb9e45f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " that shows a list ",
 "of a variable number of hexagons (between 1 and 10), and with variable hues",
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e0e53507-b929-49ec-977d-19ed59a1e821"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`h$$ = 0.326, $CellContext`n$$ = 8, 
          Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
          Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, 
          Typeset`animvar$$ = 1, Typeset`name$$ = "\"untitled\"", 
          Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 1, 10, 1}, {
            Hold[$CellContext`h$$], 0, 1}}, Typeset`size$$ = {
          437.10599994659424`, {150., 46.}}, Typeset`update$$ = 0, 
          Typeset`initDone$$, Typeset`skipInitDone$$ = 
          True, $CellContext`n$11598$$ = 0, $CellContext`h$11599$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, 
            "Variables" :> {$CellContext`h$$ = 0, $CellContext`n$$ = 1}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$11598$$, 0], 
              Hold[$CellContext`h$$, $CellContext`h$11599$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Table[
              Graphics[
               Style[
                RegularPolygon[6], 
                Hue[$CellContext`h$$]]], $CellContext`n$$], 
            "Specifications" :> {{$CellContext`n$$, 1, 10, 
               1}, {$CellContext`h$$, 0, 1}}, "Options" :> {}, 
            "DefaultOptions" :> {}],
           ImageSizeCache->{483., {156., 162.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",
       GraphicsBoxOptions->{ImageSize->100},ExpressionUUID->
       "9a82c515-835f-4f13-8054-96a4903814ce"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`h$$ = 0.326, $CellContext`n$$ = 8, 
             Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
             Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, 
             Typeset`animvar$$ = 1, Typeset`name$$ = "\"untitled\"", 
             Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 1, 10, 1}, {
                Hold[$CellContext`h$$], 0, 1}}, 
             Typeset`size$$ = {437.10599994659424`, {150., 46.}}, 
             Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$11598$$ = 0, $CellContext`h$11599$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, 
              "Variables" :> {$CellContext`h$$ = 0, $CellContext`n$$ = 1}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$11598$$, 0], 
                Hold[$CellContext`h$$, $CellContext`h$11599$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Table[
                Graphics[
                 Style[
                  RegularPolygon[6], 
                  Hue[$CellContext`h$$]]], $CellContext`n$$], 
              "Specifications" :> {{$CellContext`n$$, 1, 10, 
                 1}, {$CellContext`h$$, 0, 1}}, "Options" :> {}, 
              "DefaultOptions" :> {}], ImageSizeCache -> {489., {157., 164.}},
              SingleEvaluation -> True], Deinitialization :> None, 
            DynamicModuleValues :> {}, SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"122fbe10-d61a-40a1-8eba-3820e024d6d1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " that lets you show a regular polygon with between 5 and 20 sides, in red, \
yellow or blue.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"5b9a18d1-c5f8-447d-8cc3-69922f86d43a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`color$$ = RGBColor[
          1, 0, 0], $CellContext`n$$ = 5, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 5, 20, 1}, {
            Hold[$CellContext`color$$], {
             RGBColor[1, 0, 0], 
             RGBColor[1, 1, 0], 
             RGBColor[0, 0, 1]}}}, Typeset`size$$ = {200., {92., 98.}}, 
          Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
          True, $CellContext`n$85999$$ = 0, $CellContext`color$86000$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, 
            "Variables" :> {$CellContext`color$$ = 
              RGBColor[1, 0, 0], $CellContext`n$$ = 5}, "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$85999$$, 0], 
              Hold[$CellContext`color$$, $CellContext`color$86000$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            Graphics[
              Style[
               RegularPolygon[$CellContext`n$$], $CellContext`color$$]], 
            "Specifications" :> {{$CellContext`n$$, 5, 20, 
               1}, {$CellContext`color$$, {
                RGBColor[1, 0, 0], 
                RGBColor[1, 1, 0], 
                RGBColor[0, 0, 1]}}}, "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{263., {150., 156.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",
       GraphicsBoxOptions->{ImageSize->200},ExpressionUUID->
       "8b3f2b26-1000-418e-aab2-9eaa37426d08"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`color$$ = 
             RGBColor[1, 0, 0], $CellContext`n$$ = 5, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 5, 20, 1}, {
                Hold[$CellContext`color$$], {
                 RGBColor[1, 0, 0], 
                 RGBColor[1, 1, 0], 
                 RGBColor[0, 0, 1]}}}, Typeset`size$$ = {200., {92., 98.}}, 
             Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$85999$$ = 0, $CellContext`color$86000$$ = 
             0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, 
              "Variables" :> {$CellContext`color$$ = 
                RGBColor[1, 0, 0], $CellContext`n$$ = 5}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$85999$$, 0], 
                Hold[$CellContext`color$$, $CellContext`color$86000$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Graphics[
                Style[
                 RegularPolygon[$CellContext`n$$], $CellContext`color$$]], 
              "Specifications" :> {{$CellContext`n$$, 5, 20, 
                 1}, {$CellContext`color$$, {
                  RGBColor[1, 0, 0], 
                  RGBColor[1, 1, 0], 
                  RGBColor[0, 0, 1]}}}, "Options" :> {}, 
              "DefaultOptions" :> {}], ImageSizeCache -> {277., {150., 157.}},
              SingleEvaluation -> True], Deinitialization :> None, 
            DynamicModuleValues :> {}, SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"29c2fdea-4b98-4d1f-a132-61ca609cf5ff"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " that shows a pie chart with a number of equal segments varying from 1 to \
10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4342e81d-5934-4638-beda-0c4f8df03530"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 10, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 1, 10, 1}}, Typeset`size$$ = {
          240., {117., 123.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`n$11628$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$11628$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            PieChart[
              Table[1, $CellContext`n$$]], 
            "Specifications" :> {{$CellContext`n$$, 1, 10, 1}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{285., {164., 170.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "8f8911b2-0060-4e25-bfc1-cfcf5f218ab0"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 10, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 1, 10, 1}}, 
             Typeset`size$$ = {240., {117., 123.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$11628$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$11628$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              PieChart[
                Table[1, $CellContext`n$$]], 
              "Specifications" :> {{$CellContext`n$$, 1, 10, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {291., {165., 172.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"402d95b0-3efb-4426-b03c-d60932fafe91"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " that gives ",
 "a bar chart of the 3 digits in integers from 100 to 999",
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c654d3ff-2f20-4086-bd73-8c5dcf322576"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 146, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 100, 999, 1}}, Typeset`size$$ = {
          240., {72., 78.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`n$70749$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 100}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$70749$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            BarChart[
              IntegerDigits[$CellContext`n$$]], 
            "Specifications" :> {{$CellContext`n$$, 100, 999, 1}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{285., {119., 125.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "9ff9d850-4241-44ee-b132-4240bfabf97f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 146, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 100, 999, 1}}, 
             Typeset`size$$ = {240., {72., 78.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$70749$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 100}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$70749$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              BarChart[
                IntegerDigits[$CellContext`n$$]], 
              "Specifications" :> {{$CellContext`n$$, 100, 999, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {291., {120., 127.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dab4f839-ad64-49df-9efd-882794bb3346"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " that shows ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"e4e68f8a-5ce2-4cc2-81bb-6911797e62b9"],
 " random colors, where ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"99551010-5d32-4476-8d41-5098b0d80b64"],
 " can range from 1 to 50.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e53effc4-c039-4862-b37f-3aa2759e8e54"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 29, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 1, 50, 1}}, Typeset`size$$ = {
          466., {3., 9.46435546875}}, Typeset`update$$ = 0, 
          Typeset`initDone$$, Typeset`skipInitDone$$ = 
          True, $CellContext`n$31942$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$31942$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Table[
              RandomColor[], $CellContext`n$$], 
            "Specifications" :> {{$CellContext`n$$, 1, 50, 1}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{511., {53., 59.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "c78df530-c5d7-4398-a359-dac723801a69"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 29, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 1, 50, 1}}, 
             Typeset`size$$ = {466., {3., 9.46435546875}}, Typeset`update$$ = 
             0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$31942$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$31942$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Table[
                RandomColor[], $CellContext`n$$], 
              "Specifications" :> {{$CellContext`n$$, 1, 50, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {517., {54., 61.}}, SingleEvaluation -> True], 
            Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"23185b2e-75ed-48f6-978f-5f93a17fc048"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to display a column of integer powers with bases from 1 to 25 and \
exponents from 1 to 10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9d2952d9-faf5-4907-884a-9d029a982a7b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`a$$ = 25, $CellContext`n$$ = 9, 
          Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
          Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, 
          Typeset`animvar$$ = 1, Typeset`name$$ = "\"untitled\"", 
          Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 1, 10, 1}, {
            Hold[$CellContext`a$$], 1, 25, 1}}, Typeset`size$$ = {
          97., {79.14208984375, 85.85791015625}}, Typeset`update$$ = 0, 
          Typeset`initDone$$, Typeset`skipInitDone$$ = 
          True, $CellContext`n$11713$$ = 0, $CellContext`a$11714$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, 
            "Variables" :> {$CellContext`a$$ = 1, $CellContext`n$$ = 1}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$11713$$, 0], 
              Hold[$CellContext`a$$, $CellContext`a$11714$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Column[
              
              Table[$CellContext`a$$^$CellContext`m, {$CellContext`m, \
$CellContext`n$$}]], 
            "Specifications" :> {{$CellContext`n$$, 1, 10, 
               1}, {$CellContext`a$$, 1, 25, 1}}, "Options" :> {}, 
            "DefaultOptions" :> {}],
           ImageSizeCache->{247., {141., 147.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "dcc5adde-fa66-4f8f-8829-c2fdd3dc66c6"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`a$$ = 25, $CellContext`n$$ = 9, 
             Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
             Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, 
             Typeset`animvar$$ = 1, Typeset`name$$ = "\"untitled\"", 
             Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 1, 10, 1}, {
                Hold[$CellContext`a$$], 1, 25, 1}}, 
             Typeset`size$$ = {97., {79.14208984375, 85.85791015625}}, 
             Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$11713$$ = 0, $CellContext`a$11714$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, 
              "Variables" :> {$CellContext`a$$ = 1, $CellContext`n$$ = 1}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$11713$$, 0], 
                Hold[$CellContext`a$$, $CellContext`a$11714$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Column[
                
                Table[$CellContext`a$$^$CellContext`m, {$CellContext`m, \
$CellContext`n$$}]], 
              "Specifications" :> {{$CellContext`n$$, 1, 10, 
                 1}, {$CellContext`a$$, 1, 25, 1}}, "Options" :> {}, 
              "DefaultOptions" :> {}], ImageSizeCache -> {258., {142., 149.}},
              SingleEvaluation -> True], Deinitialization :> None, 
            DynamicModuleValues :> {}, SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"127567c1-010a-4d1f-b71f-e882c64a71f4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " of a number line of values of ",
 Cell[BoxData[
  RowBox[{"x", "^", "n"}]], "InlineCode",ExpressionUUID->
  "d55ca3db-ef28-4cb3-8f7e-9699805c7832"],
 " for integer ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"405fe008-dce2-4740-a827-2e66b24c02a5"],
 " from 1 to 10, with ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"89e43d9f-ca4a-4785-afcb-1b11644614ba"],
 " varying from 0 to 5.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"3b3afe60-1935-420a-866d-9aa70af932d0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 1.43, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 0, 5}}, Typeset`size$$ = {
          240., {13., 18.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`n$30594$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 0}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$30594$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            NumberLinePlot[
              Table[$CellContext`x^$CellContext`n$$, {$CellContext`x, 10}]], 
            "Specifications" :> {{$CellContext`n$$, 0, 5}}, "Options" :> {}, 
            "DefaultOptions" :> {}],
           ImageSizeCache->{285., {59., 65.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "e86ca7fa-6ada-4767-baac-923db440c332"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 1.43, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 0, 5}}, 
             Typeset`size$$ = {240., {13., 18.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$30594$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$30594$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              NumberLinePlot[
                Table[$CellContext`x^$CellContext`n$$, {$CellContext`x, 10}]],
               "Specifications" :> {{$CellContext`n$$, 0, 5}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {291., {60., 67.}}, SingleEvaluation -> True], 
            Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ebda1ed8-44b9-43b8-9633-f6651edd01b5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to show ",
 "a sphere that can vary in color from green to red",
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "9.15", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"a8db4020-2192-4b01-a42d-be0a2020e737"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 0., Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 0, 1}}, Typeset`size$$ = {
          200., {106., 111.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`n$476537$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 0}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$476537$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            Graphics3D[
              Style[
               Sphere[], 
               RGBColor[$CellContext`n$$, 1 - $CellContext`n$$, 0]]], 
            "Specifications" :> {{$CellContext`n$$, 0, 1}}, "Options" :> {}, 
            "DefaultOptions" :> {}],
           ImageSizeCache->{247., {152., 158.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",
       Graphics3DBoxOptions->{ImageSize->200},ExpressionUUID->
       "cb32b6a7-4204-4d1f-8189-ba6d87ab082e"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 0., Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 0, 1}}, 
             Typeset`size$$ = {200., {106., 111.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$476537$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$476537$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Graphics3D[
                Style[
                 Sphere[], 
                 RGBColor[$CellContext`n$$, 1 - $CellContext`n$$, 0]]], 
              "Specifications" :> {{$CellContext`n$$, 0, 1}}, "Options" :> {},
               "DefaultOptions" :> {}], 
             ImageSizeCache -> {258., {153., 160.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aab02b10-ea77-4f39-b7db-0be06b54fa4d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to plot numbers from 1 to 100 raised to powers that can vary between \
\[Minus]1 and +1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+9.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"09036777-6fed-438b-87b0-66c0212f72ca"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`p$$ = -1, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`p$$], -1, 1}}, Typeset`size$$ = {
          240., {72., 77.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`p$68524$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`p$$ = -1}, 
            "ControllerVariables" :> {
              Hold[$CellContext`p$$, $CellContext`p$68524$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            ListLinePlot[
              Table[$CellContext`n^$CellContext`p$$, {$CellContext`n, 100}]], 
            "Specifications" :> {{$CellContext`p$$, -1, 1}}, "Options" :> {}, 
            "DefaultOptions" :> {}],
           ImageSizeCache->{285., {118., 124.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "36a29f2d-7680-4436-9f1f-08558e19f281"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`p$$ = -1, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`p$$], -1, 1}}, 
             Typeset`size$$ = {240., {72., 77.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`p$68524$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`p$$ = -1}, 
              "ControllerVariables" :> {
                Hold[$CellContext`p$$, $CellContext`p$68524$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              ListLinePlot[
                
                Table[$CellContext`n^$CellContext`p$$, {$CellContext`n, 
                  100}]], "Specifications" :> {{$CellContext`p$$, -1, 1}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {291., {119., 126.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4c5aa576-861e-4d42-b3a7-8e64188f5610"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to display 1000 at sizes between 5 and 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+9.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"de6700b4-c8bf-4b76-abe5-7f81a3cce346"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`s$$ = 5, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`s$$], 5, 100}}, Typeset`size$$ = {
          10., {0., 4.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`s$86449$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`s$$ = 5}, 
            "ControllerVariables" :> {
              Hold[$CellContext`s$$, $CellContext`s$86449$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            Style[1000, $CellContext`s$$], 
            "Specifications" :> {{$CellContext`s$$, 5, 100}}, "Options" :> {},
             "DefaultOptions" :> {}],
           ImageSizeCache->{247., {53., 59.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "3c5bf6e1-efdf-41f7-914d-986582b93dc4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`s$$ = 5, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`s$$], 5, 100}}, 
             Typeset`size$$ = {10., {0., 4.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`s$86449$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`s$$ = 5}, 
              "ControllerVariables" :> {
                Hold[$CellContext`s$$, $CellContext`s$86449$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Style[1000, $CellContext`s$$], 
              "Specifications" :> {{$CellContext`s$$, 5, 100}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {256., {54., 61.}}, SingleEvaluation -> True], 
            Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5e8a34b3-db45-4e3c-b715-a85defaf96e0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to show a bar chart with 4 bars, each with a height that can be between 0 \
and 10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+9.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c9c8e64e-ae94-461c-97fa-8d18f27c8a00"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`a$$ = 2.54, $CellContext`b$$ = 
          9.540000000000001, $CellContext`c$$ = 4.68, $CellContext`d$$ = 
          7.6000000000000005`, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`a$$], 0, 10}, {
            Hold[$CellContext`b$$], 0, 10}, {
            Hold[$CellContext`c$$], 0, 10}, {
            Hold[$CellContext`d$$], 0, 10}}, Typeset`size$$ = {
          240., {73., 79.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`a$20514$$ = 
          0, $CellContext`b$20515$$ = 0, $CellContext`c$20516$$ = 
          0, $CellContext`d$20517$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, 
            "Variables" :> {$CellContext`a$$ = 0, $CellContext`b$$ = 
              0, $CellContext`c$$ = 0, $CellContext`d$$ = 0}, 
            "ControllerVariables" :> {
              Hold[$CellContext`a$$, $CellContext`a$20514$$, 0], 
              Hold[$CellContext`b$$, $CellContext`b$20515$$, 0], 
              Hold[$CellContext`c$$, $CellContext`c$20516$$, 0], 
              Hold[$CellContext`d$$, $CellContext`d$20517$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            BarChart[{$CellContext`a$$, $CellContext`b$$, $CellContext`c$$, \
$CellContext`d$$}], 
            "Specifications" :> {{$CellContext`a$$, 0, 10}, {$CellContext`b$$,
                0, 10}, {$CellContext`c$$, 0, 10}, {$CellContext`d$$, 0, 10}},
             "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{285., {162., 168.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "7eeabbc4-00dc-4206-9bf5-5456c84b7f44"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`a$$ = 2.54, $CellContext`b$$ = 
             9.540000000000001, $CellContext`c$$ = 4.68, $CellContext`d$$ = 
             7.6000000000000005`, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`a$$], 0, 10}, {
                Hold[$CellContext`b$$], 0, 10}, {
                Hold[$CellContext`c$$], 0, 10}, {
                Hold[$CellContext`d$$], 0, 10}}, 
             Typeset`size$$ = {240., {73., 79.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`a$20514$$ = 0, $CellContext`b$20515$$ = 
             0, $CellContext`c$20516$$ = 0, $CellContext`d$20517$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, 
              "Variables" :> {$CellContext`a$$ = 0, $CellContext`b$$ = 
                0, $CellContext`c$$ = 0, $CellContext`d$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`a$$, $CellContext`a$20514$$, 0], 
                Hold[$CellContext`b$$, $CellContext`b$20515$$, 0], 
                Hold[$CellContext`c$$, $CellContext`c$20516$$, 0], 
                Hold[$CellContext`d$$, $CellContext`d$20517$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              BarChart[{$CellContext`a$$, $CellContext`b$$, $CellContext`c$$, \
$CellContext`d$$}], 
              "Specifications" :> {{$CellContext`a$$, 0, 
                 10}, {$CellContext`b$$, 0, 10}, {$CellContext`c$$, 0, 
                 10}, {$CellContext`d$$, 0, 10}}, "Options" :> {}, 
              "DefaultOptions" :> {}], ImageSizeCache -> {291., {162., 169.}},
              SingleEvaluation -> True], Deinitialization :> None, 
            DynamicModuleValues :> {}, SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"601c8c4f-4eaa-408e-85ed-ea13e9129b1a"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"006a2315-fa2a-4d5b-9fc8-d704506b1bab"],

Cell[TextData[{
 "Does ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " work the same on web, mobile and desktop?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"35c5b0e5-3742-4d15-83a4-428113a540b1"],

Cell["\<\
Ultimately yes. But it can be significantly slower on the web and on some \
mobile systems, because every time you move a slider it has to communicate \
over the internet with a server to find out what to do. On desktop and some \
mobile systems, everything is happening right there, inside your computer or \
other device\[LongDash]so it\[CloseCurlyQuote]s very fast.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"256aa8dc-0b3c-48ac-906e-aefcb1a9136c"],

Cell[TextData[{
 "Can I make a standalone app out of a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 "?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b318ede8-258e-474d-9482-c6c600537855"],

Cell[TextData[{
 "Yes. To make a web app, for example, you just need to use ",
 ButtonBox["CloudDeploy",
  BaseStyle->"Link"],
 ". We\[CloseCurlyQuote]ll talk about this in ",
 ButtonBox["Section 36",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-36-creating-websites-and-apps.nb", "manipulate"}],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"af7d26b2-d637-44aa-8f71-9bb289a7fb47"],

Cell[TextData[{
 "Can I use ",
 "random numbers",
 " in ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 "?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"de8a18fc-2d94-4d38-93de-5582bb580087"],

Cell[TextData[{
 "Yes, but unless you \[OpenCurlyDoubleQuote]seed\[CloseCurlyDoubleQuote] \
them with ",
 ButtonBox["SeedRandom",
  BaseStyle->"Link"],
 ", the random numbers will be different every time you move a slider."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"312181c8-1bfc-4cb3-becb-5ca9fc0c68e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:37",ExpressionUUID->"2106727b-d8db-4056-88ae-f4482ee05c90"],

Cell[TextData[{
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " supports pretty much all standard user interface control types \
(checkboxes, menus, input fields, color pickers, etc.)."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"45ce74a3-16f0-4ea9-8241-33ba8b9d3efe"],

Cell[TextData[{
 "Sliders in ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " often provide a ",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzt2jGKE2EYgOGgFpZewVvYWtqueIBdjItNhKwgnsBjBWYhsAcI7AFyha3H
DCis6FsshCSSp3iHSYoPvn+e8n999eXi07PZbHbzcve4uPz2drm8/P7+1e7H
h8XN5+vF/OO7xdf59Xz55ur57s8fv3qxa7VaSX81juPv91F6FBuq2FDFhio2
VLGhig1VbKhiQxUbqthQxYYqNlSxoYoNVWyoYkMVG6rOxsYwDON6vd5L06xj
73OAzsbGZrMZHx4e9tI069j7HCA22KjYYKNig42KDTYqNtio2GCjYoONig02
KjbYqNhgo2KDjYoNNio22KjYYKNig42KDTYqNtio2GCjYoONig02KjbYqNhg
o2KDjYoNNio22KjYYKNig42KDTYqNtio2GCjYoONig02KjbYqNhgo2KDjYoN
Nqq927i9vR3v7+9Pru12uzcb06xj7/OvprM/ZRt3d3d7+wZ6WtPZsyE2xIbY
EBvHP6dzjA2xITbEhthggw02Ti02xIbYEBtigw022Di1Tt2GO4HuBP5vuUvM
RsUGGxUbbFRssFGxwUbFBhsVG2xUbLBRscFGxQYbFRtsVGywUbHBRsUGGxUb
bFRssFGxwUbFBhsVG2xUbLBRscFGxQYbFRtsVGywUbHBRsUGGxUbbFRssFGx
wUbFBhsVG2xUbLBRscFGxQYbFRtsVGywUbHBRjUMw7her/fSNOvY+xygs7Gh
J8eGKjZUsaGKDVVsqGJDFRuq2FDFhio2VLGhig1VbKhiQxUbqthQxYaqxzak
P5psSNVPobz0uA==
     "], {{0, 135}, {135, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   BaseStyle->"ImageGraphics",
   ImagePadding->{{0, 0}, {5, 0}},
   ImageSize->{11.76171875, Automatic},
   ImageSizeRaw->{135, 135},
   PlotRange->{{0, 135}, {0, 135}}]], "InlineCode",ExpressionUUID->
  "643877cc-2aab-4eea-a32f-265468eff735"],
 "\[VeryThinSpace] button which opens out to additional \
controls\[LongDash]including animation, single stepping and numerical value \
display."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"cab51821-fa46-47b9-b2d5-a78cbf239d48"],

Cell["\<\
Many controls are rendered differently on mouse and touch devices, and some \
controls only work on one or the other.\
\>", "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e2b27332-a8e3-4074-bdbf-215680f2fb12"],

Cell[TextData[{
 "If you\[CloseCurlyQuote]re running natively on your computer, devices like \
gamepads should immediately work with ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 ". You can specify which controls should be hooked to what. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerInformation",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "41ee8ddf-469a-4657-86f7-218e2760dc3c"],
 " gives information on all your controllers. "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"236cc188-ae2d-4c0a-8b8c-f083c4d2b0f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"566bb4f7-5c28-4b02-83c4-2b658efdf5f4"],

Cell[TextData[{
 "The ",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com"], None},
  ButtonNote->"http://demonstrations.wolfram.com"],
 ": more than 11,000 interactive Demonstrations created with ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"]
}], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:9"},ExpressionUUID->"3d305f78-5329-4944-a448-8cb9dfca82a3"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Interactive Manipulation: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Basic Graphics Objects\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Basic Graphics Objects", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-10-images.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-10-images.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Images\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Images", "Tooltip"]& ]}, "RowWithSeparators"], 
          Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->58,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[
      " | Interactive Manipulation \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"31f5abb1-251e-4036-afbb-b10d4093c7d7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:33"->{
  Cell[669, 24, 474, 12, 93, "Section",ExpressionUUID->"5de891c8-bc60-430c-97d8-44fba6081abe",
   CounterAssignments->{{"Section", 8}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->"p:33"]},
 "i:1"->{
  Cell[1146, 38, 665, 16, 140, "Text",ExpressionUUID->"f83b3285-6606-45b4-86f8-faf1ed6fdcb1",
   CellTags->"i:1"]},
 "LastCellOfAPage"->{
  Cell[34456, 956, 551, 18, 70, "Text",ExpressionUUID->"97b59067-9300-4d05-bb2d-4810ac77c7e7",
   CellTags->"LastCellOfAPage"],
  Cell[40749, 1134, 1795, 39, 70, "Output",ExpressionUUID->"2a013e6c-50eb-4c38-832e-07277a831d0a",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[46779, 1300, 1988, 45, 70, "Output",ExpressionUUID->"958ff456-734c-434d-974e-8949ef7d5b78",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[139289, 3520, 823, 26, 70, "Exercise",ExpressionUUID->"a8db4020-2192-4b01-a42d-be0a2020e737",
   CellTags->"LastCellOfAPage"],
  Cell[168543, 4245, 508, 16, 70, "MoreExplore",ExpressionUUID->"3d305f78-5329-4944-a448-8cb9dfca82a3",
   CellTags->{"LastCellOfAPage", "i:9"}]},
 "p:34"->{
  Cell[35010, 976, 267, 9, 70, "CodeCaption",ExpressionUUID->"37d877b8-f854-44cc-a6ff-34c049b94700",
   CellTags->"p:34"]},
 "i:2"->{
  Cell[37435, 1042, 250, 7, 70, "Text",ExpressionUUID->"0fa7f5d8-9a11-4a5d-8fac-400713a27129",
   CellTags->"i:2"]},
 "p:35"->{
  Cell[42559, 1176, 333, 9, 70, "Text",ExpressionUUID->"ab559f97-e831-4913-ae2c-7f0b9244be59",
   CellTags->"p:35"]},
 "i:3"->{
  Cell[45639, 1257, 436, 15, 70, "Text",ExpressionUUID->"7ee05707-fee6-4b40-8c4c-0102c4a712d0",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[163095, 4074, 269, 9, 70, "Question",ExpressionUUID->"35c5b0e5-3742-4d15-83a4-428113a540b1",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[164822, 4136, 372, 10, 70, "Answer",ExpressionUUID->"312181c8-1bfc-4cb3-becb-5ca9fc0c68e2",
   CellTags->"i:5"]},
 "p:37"->{
  Cell[165231, 4151, 173, 4, 70, "TechNoteSection",ExpressionUUID->"2106727b-d8db-4056-88ae-f4482ee05c90",
   CellTags->"p:37"]},
 "i:6"->{
  Cell[165407, 4157, 338, 9, 70, "TechNote",ExpressionUUID->"45ce74a3-16f0-4ea9-8241-33ba8b9d3efe",
   CellTags->"i:6"]},
 "i:7"->{
  Cell[165748, 4168, 1691, 39, 70, "TechNote",ExpressionUUID->"cab51821-fa46-47b9-b2d5-a78cbf239d48",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[167710, 4218, 628, 16, 70, "TechNote",ExpressionUUID->"236cc188-ae2d-4c0a-8b8c-f083c4d2b0f4",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[168543, 4245, 508, 16, 70, "MoreExplore",ExpressionUUID->"3d305f78-5329-4944-a448-8cb9dfca82a3",
   CellTags->{"LastCellOfAPage", "i:9"}]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:33", 259728, 6102},
 {"i:1", 259972, 6106},
 {"LastCellOfAPage", 260110, 6109},
 {"p:34", 260840, 6122},
 {"i:2", 260974, 6125},
 {"p:35", 261102, 6128},
 {"i:3", 261230, 6131},
 {"i:4", 261358, 6134},
 {"i:5", 261490, 6137},
 {"p:37", 261622, 6140},
 {"i:6", 261762, 6143},
 {"i:7", 261894, 6146},
 {"i:8", 262028, 6149},
 {"i:9", 262161, 6152}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[669, 24, 474, 12, 93, "Section",ExpressionUUID->"5de891c8-bc60-430c-97d8-44fba6081abe",
 CounterAssignments->{{"Section", 8}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:33"],
Cell[1146, 38, 665, 16, 140, "Text",ExpressionUUID->"f83b3285-6606-45b4-86f8-faf1ed6fdcb1",
 CellTags->"i:1"],
Cell[1814, 56, 323, 9, 37, "CodeCaption",ExpressionUUID->"c43a0e50-cc24-4fcb-85eb-4afb370817cb"],
Cell[CellGroupData[{
Cell[2162, 69, 315, 8, 29, "Input",ExpressionUUID->"6584d885-9b48-4438-879d-4b2657f75e7c"],
Cell[2480, 79, 1680, 36, 139, "Output",ExpressionUUID->"925276a9-1d1a-4623-899b-f867d8a76e79",
 Evaluatable->False]
}, Open  ]],
Cell[4175, 118, 208, 5, 37, "CodeCaption",ExpressionUUID->"e3908d3e-b18c-48a0-9766-fc19880b009d"],
Cell[CellGroupData[{
Cell[4408, 127, 310, 8, 29, "Input",ExpressionUUID->"4477a56a-9873-408e-8609-aa6617bcc604"],
Cell[4721, 137, 23970, 631, 40, "Output",ExpressionUUID->"bff9e3f5-4a6a-4876-b784-fd716976ef9f",
 Evaluatable->False]
}, Open  ]],
Cell[28706, 771, 243, 7, 37, "CodeCaption",ExpressionUUID->"6cff301b-b21f-4d64-a4c9-d7e3a0d45d14"],
Cell[CellGroupData[{
Cell[28974, 782, 402, 11, 29, "Input",ExpressionUUID->"7abe3b59-7d5b-4f1d-b871-73570a3c1f40"],
Cell[29379, 795, 1726, 37, 175, "Output",ExpressionUUID->"113fef4c-239e-449b-80bb-963a9637047f",
 Evaluatable->False]
}, Open  ]],
Cell[31120, 835, 215, 5, 37, "CodeCaption",ExpressionUUID->"356c829e-23a7-4bbb-8603-b16567b344ca"],
Cell[CellGroupData[{
Cell[31360, 844, 397, 11, 70, "Input",ExpressionUUID->"15b5f1f8-d856-4249-bfa0-4a87e86805f9"],
Cell[31760, 857, 2681, 96, 70, "Output",ExpressionUUID->"eaad5b52-fc3a-4e24-82da-ffe9f0fa07e5",
 Evaluatable->False]
}, Open  ]],
Cell[34456, 956, 551, 18, 70, "Text",ExpressionUUID->"97b59067-9300-4d05-bb2d-4810ac77c7e7",
 CellTags->"LastCellOfAPage"],
Cell[35010, 976, 267, 9, 70, "CodeCaption",ExpressionUUID->"37d877b8-f854-44cc-a6ff-34c049b94700",
 CellTags->"p:34"],
Cell[CellGroupData[{
Cell[35302, 989, 392, 11, 70, "Input",ExpressionUUID->"5f32bc9a-edc0-4aeb-ab82-8aaa28eab31b"],
Cell[35697, 1002, 1723, 37, 70, "Output",ExpressionUUID->"e6ebb3a7-4059-4cbf-8ac0-8bd3d06abdae",
 Evaluatable->False]
}, Open  ]],
Cell[37435, 1042, 250, 7, 70, "Text",ExpressionUUID->"0fa7f5d8-9a11-4a5d-8fac-400713a27129",
 CellTags->"i:2"],
Cell[37688, 1051, 191, 4, 70, "CodeCaption",ExpressionUUID->"327b51e8-b962-458c-9af3-905dc63990f4"],
Cell[CellGroupData[{
Cell[37904, 1059, 433, 11, 70, "Input",ExpressionUUID->"c90efb21-f030-47a7-9759-1d86df2b93a7"],
Cell[38340, 1072, 1761, 38, 70, "Output",ExpressionUUID->"20841a67-021d-4a20-b1fe-997ea9941818",
 Evaluatable->False]
}, Open  ]],
Cell[40116, 1113, 172, 4, 70, "CodeCaption",ExpressionUUID->"7085fab9-a1c6-41c4-a980-a5f113c454c8"],
Cell[CellGroupData[{
Cell[40313, 1121, 433, 11, 70, "Input",ExpressionUUID->"4635d1b3-f761-4c41-bf6b-11053ca84191"],
Cell[40749, 1134, 1795, 39, 70, "Output",ExpressionUUID->"2a013e6c-50eb-4c38-832e-07277a831d0a",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[42559, 1176, 333, 9, 70, "Text",ExpressionUUID->"ab559f97-e831-4913-ae2c-7f0b9244be59",
 CellTags->"p:35"],
Cell[42895, 1187, 225, 6, 70, "CodeCaption",ExpressionUUID->"5c5e3107-ca88-4916-bdb6-a30efe6399ad"],
Cell[CellGroupData[{
Cell[43145, 1197, 497, 13, 70, "Input",ExpressionUUID->"23ae9cc5-a64b-4a93-9ed6-46deba2f5322"],
Cell[43645, 1212, 1979, 42, 70, "Output",ExpressionUUID->"e53963cb-ff7e-4037-beb4-d1ced7810110",
 Evaluatable->False]
}, Open  ]],
Cell[45639, 1257, 436, 15, 70, "Text",ExpressionUUID->"7ee05707-fee6-4b40-8c4c-0102c4a712d0",
 CellTags->"i:3"],
Cell[46078, 1274, 212, 6, 70, "CodeCaption",ExpressionUUID->"3f96c3cc-72e1-4b43-9d19-55cb2205de20"],
Cell[CellGroupData[{
Cell[46315, 1284, 461, 14, 70, "Input",ExpressionUUID->"16e7787c-5e2e-42da-b079-82e203847f9a"],
Cell[46779, 1300, 1988, 45, 70, "Output",ExpressionUUID->"958ff456-734c-434d-974e-8949ef7d5b78",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[48782, 1348, 474, 14, 70, "CodeCaption",ExpressionUUID->"b0822a83-362a-4b3c-8d9f-deca9fdf8166"],
Cell[CellGroupData[{
Cell[49281, 1366, 613, 17, 70, "Input",ExpressionUUID->"68ccf6a3-8c1f-43ae-a40c-686c69613aed"],
Cell[49897, 1385, 2475, 52, 70, "Output",ExpressionUUID->"5c7d7a74-ac6d-479b-927f-15cac969d9c7",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52421, 1443, 159, 4, 70, "VocabularySection",ExpressionUUID->"2ecdd701-8a1f-4458-8d43-a2b78259f112"],
Cell[52583, 1449, 1626, 47, 70, "VocabularyTable",ExpressionUUID->"450f611e-3b4e-4ec1-b208-9b091fa905d0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54246, 1501, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"dd8bb8e7-fe93-48c7-ad60-3c9acc922c48"],
Cell[CellGroupData[{
Cell[56051, 1551, 1459, 45, 70, "ExerciseSummaryCell",ExpressionUUID->"9c598517-3bc8-4e0a-b4f3-0c1406c8fb3a"],
Cell[CellGroupData[{
Cell[57535, 1600, 1030, 32, 70, "Exercise",ExpressionUUID->"ee1262fb-3e1d-440d-b8c4-e68cdff508b8"],
Cell[58568, 1634, 4631, 98, 70, "ExerciseOutput",ExpressionUUID->"ef4645d5-a292-4ca0-a516-586d446ca24a"]
}, Closed]],
Cell[CellGroupData[{
Cell[63236, 1737, 982, 29, 70, "Exercise",ExpressionUUID->"49cba057-b482-4549-a37e-8faa4afc6432"],
Cell[64221, 1768, 4604, 98, 70, "ExerciseOutput",ExpressionUUID->"6f630138-9c09-48ce-a881-2aa0212de666"]
}, Closed]],
Cell[CellGroupData[{
Cell[68862, 1871, 869, 26, 70, "Exercise",ExpressionUUID->"d6c36727-7bad-462a-9e7d-4248367a251b"],
Cell[69734, 1899, 4661, 98, 70, "ExerciseOutput",ExpressionUUID->"96e8fa65-70fc-49dd-93bd-519c2c1aca54"]
}, Closed]],
Cell[CellGroupData[{
Cell[74432, 2002, 780, 25, 70, "Exercise",ExpressionUUID->"ab7445fb-8a12-4a86-bcdd-6b7ed9aa500d"],
Cell[75215, 2029, 4729, 103, 70, "ExerciseOutput",ExpressionUUID->"cf2807ef-4454-45b5-b13d-e510f485f212"]
}, Closed]],
Cell[CellGroupData[{
Cell[79981, 2137, 803, 24, 70, "Exercise",ExpressionUUID->"546b0649-241d-4f8b-82f5-b45fc8da7872"],
Cell[80787, 2163, 5998, 124, 70, "ExerciseOutput",ExpressionUUID->"bb528612-b53a-4753-a513-d326f1fa7b2f"]
}, Closed]],
Cell[CellGroupData[{
Cell[86822, 2292, 802, 25, 70, "Exercise",ExpressionUUID->"239aa80d-b1dd-4aaa-a7ee-3e3fd32fa79f"],
Cell[87627, 2319, 4611, 96, 70, "ExerciseOutput",ExpressionUUID->"ac27e0d7-6ddc-4f3e-9cfe-7f450e7475bf"]
}, Closed]],
Cell[CellGroupData[{
Cell[92275, 2420, 781, 23, 70, "Exercise",ExpressionUUID->"3bdceaf9-3183-4b16-81ac-4fbe66696b8f"],
Cell[93059, 2445, 4727, 100, 70, "ExerciseOutput",ExpressionUUID->"750b8cfc-6c63-48b4-b76d-55f62cb9e45f"]
}, Closed]],
Cell[CellGroupData[{
Cell[97823, 2550, 828, 25, 70, "Exercise",ExpressionUUID->"e0e53507-b929-49ec-977d-19ed59a1e821"],
Cell[98654, 2577, 5373, 113, 70, "ExerciseOutput",ExpressionUUID->"122fbe10-d61a-40a1-8eba-3820e024d6d1"]
}, Closed]],
Cell[CellGroupData[{
Cell[104064, 2695, 815, 24, 70, "Exercise",ExpressionUUID->"5b9a18d1-c5f8-447d-8cc3-69922f86d43a"],
Cell[104882, 2721, 5798, 122, 70, "ExerciseOutput",ExpressionUUID->"29c2fdea-4b98-4d1f-a132-61ca609cf5ff"]
}, Closed]],
Cell[CellGroupData[{
Cell[110717, 2848, 803, 24, 70, "Exercise",ExpressionUUID->"4342e81d-5934-4638-beda-0c4f8df03530"],
Cell[111523, 2874, 4616, 98, 70, "ExerciseOutput",ExpressionUUID->"402d95b0-3efb-4426-b03c-d60932fafe91"]
}, Closed]],
Cell[CellGroupData[{
Cell[116176, 2977, 802, 25, 70, "Exercise",ExpressionUUID->"c654d3ff-2f20-4086-bd73-8c5dcf322576"],
Cell[116981, 3004, 4640, 98, 70, "ExerciseOutput",ExpressionUUID->"dab4f839-ad64-49df-9efd-882794bb3346"]
}, Closed]],
Cell[CellGroupData[{
Cell[121658, 3107, 976, 29, 70, "Exercise",ExpressionUUID->"e53effc4-c039-4862-b37f-3aa2759e8e54"],
Cell[122637, 3138, 4627, 97, 70, "ExerciseOutput",ExpressionUUID->"23185b2e-75ed-48f6-978f-5f93a17fc048"]
}, Closed]],
Cell[CellGroupData[{
Cell[127301, 3240, 816, 24, 70, "Exercise",ExpressionUUID->"9d2952d9-faf5-4907-884a-9d029a982a7b"],
Cell[128120, 3266, 5293, 111, 70, "ExerciseOutput",ExpressionUUID->"127567c1-010a-4d1f-b71f-e882c64a71f4"]
}, Closed]],
Cell[CellGroupData[{
Cell[133450, 3382, 1124, 33, 70, "Exercise",ExpressionUUID->"3b3afe60-1935-420a-866d-9aa70af932d0"],
Cell[134577, 3417, 4675, 98, 70, "ExerciseOutput",ExpressionUUID->"ebda1ed8-44b9-43b8-9633-f6651edd01b5"]
}, Closed]],
Cell[CellGroupData[{
Cell[139289, 3520, 823, 26, 70, "Exercise",ExpressionUUID->"a8db4020-2192-4b01-a42d-be0a2020e737",
 CellTags->"LastCellOfAPage"],
Cell[140115, 3548, 4807, 103, 70, "ExerciseOutput",ExpressionUUID->"aab02b10-ea77-4f39-b7db-0be06b54fa4d"]
}, Closed]],
Cell[CellGroupData[{
Cell[144959, 3656, 813, 24, 70, "Exercise",ExpressionUUID->"09036777-6fed-438b-87b0-66c0212f72ca"],
Cell[145775, 3682, 4701, 99, 70, "ExerciseOutput",ExpressionUUID->"4c5aa576-861e-4d42-b3a7-8e64188f5610"]
}, Closed]],
Cell[CellGroupData[{
Cell[150513, 3786, 768, 23, 70, "Exercise",ExpressionUUID->"de6700b4-c8bf-4b76-abe5-7f81a3cce346"],
Cell[151284, 3811, 4545, 96, 70, "ExerciseOutput",ExpressionUUID->"5e8a34b3-db45-4e3c-b715-a85defaf96e0"]
}, Closed]],
Cell[CellGroupData[{
Cell[155866, 3912, 808, 24, 70, "Exercise",ExpressionUUID->"c9c8e64e-ae94-461c-97fa-8d18f27c8a00"],
Cell[156677, 3938, 6210, 123, 70, "ExerciseOutput",ExpressionUUID->"601c8c4f-4eaa-408e-85ed-ea13e9129b1a"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[162948, 4068, 144, 4, 70, "QASection",ExpressionUUID->"006a2315-fa2a-4d5b-9fc8-d704506b1bab"],
Cell[163095, 4074, 269, 9, 70, "Question",ExpressionUUID->"35c5b0e5-3742-4d15-83a4-428113a540b1",
 CellTags->"i:4"],
Cell[163367, 4085, 514, 10, 70, "Answer",ExpressionUUID->"256aa8dc-0b3c-48ac-906e-aefcb1a9136c"],
Cell[163884, 4097, 245, 9, 70, "Question",ExpressionUUID->"b318ede8-258e-474d-9482-c6c600537855"],
Cell[164132, 4108, 438, 13, 70, "Answer",ExpressionUUID->"af7d26b2-d637-44aa-8f71-9bb289a7fb47"],
Cell[164573, 4123, 246, 11, 70, "Question",ExpressionUUID->"de8a18fc-2d94-4d38-93de-5582bb580087"],
Cell[164822, 4136, 372, 10, 70, "Answer",ExpressionUUID->"312181c8-1bfc-4cb3-becb-5ca9fc0c68e2",
 CellTags->"i:5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165231, 4151, 173, 4, 70, "TechNoteSection",ExpressionUUID->"2106727b-d8db-4056-88ae-f4482ee05c90",
 CellTags->"p:37"],
Cell[165407, 4157, 338, 9, 70, "TechNote",ExpressionUUID->"45ce74a3-16f0-4ea9-8241-33ba8b9d3efe",
 CellTags->"i:6"],
Cell[165748, 4168, 1691, 39, 70, "TechNote",ExpressionUUID->"cab51821-fa46-47b9-b2d5-a78cbf239d48",
 CellTags->"i:7"],
Cell[167442, 4209, 265, 7, 70, "TechNote",ExpressionUUID->"e2b27332-a8e3-4074-bdbf-215680f2fb12"],
Cell[167710, 4218, 628, 16, 70, "TechNote",ExpressionUUID->"236cc188-ae2d-4c0a-8b8c-f083c4d2b0f4",
 CellTags->"i:8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168375, 4239, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"566bb4f7-5c28-4b02-83c4-2b658efdf5f4"],
Cell[168543, 4245, 508, 16, 70, "MoreExplore",ExpressionUUID->"3d305f78-5329-4944-a448-8cb9dfca82a3",
 CellTags->{"LastCellOfAPage", "i:9"}]
}, Open  ]]
}
]
*)

(* NotebookSignature 0ING9qM5N2VPnI#YrG30YRaM *)
