(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    325776,       6602]
NotebookOptionsPosition[    256833,       5155]
NotebookOutlinePosition[    316192,       6376]
CellTagsIndexPosition[    316113,       6371]
WindowTitle->Basic Graphics Objects: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Use ",
 StyleBox["RegularPolygon",
  FontFamily->"Source Sans Pro"],
 " to draw a triangle."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"e8804ec9-c3bf-4e17-8b7e-1931dd6640e6"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"db7446a9-80ac-4796-956c-68db5c225adb"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmUko9Xscxo9jHgqFhOJaiI2QeSHXyrUydkss3jcH7wad99Y1rQw7w06s
TCuxQ7GRIZKF4WwMRSTKUGZHh3Pufd573nrd13Gc4f/7P3+9PnWE1ff51PMo
v98+1xZWqlUq1VcvfCn89PfvWu2nhqIA/FBS8/VLVY2m4o+avzRVGm36Z1f8
8k98KvD59v0/H3zwa3B3d6fT6dhXvA+am5szMzPZV7wDDg4OvL29MaTDw8Ps
W5ROSUmJ6j8iIiJQRvY5ymVhYUH1DJSRfZFCMRqNSUlJz12hjKgk+y4l0tfX
p3pBcXEx+y7FcXV1FRIS8tIVmJ+fZ1+nLLRarUVRIDExEfVkH6gUdnZ2PDw8
XnMFUE/2jUohLy/PiiiAeqKk7DP5TE9PWxdlBiVlX0rm8fExLi7OFlcoKarK
vpdJd3e3LaLMoKrse2mcn58HBgba7gpMTU2xr+ZQXV1tlyiAwqK27MPlRqfT
ubq62usKoLbs2+UmJyfHAVEAtUV52efLx9jYmGOizFRVVbETyMTDw0N0dLQz
rlDeX+SfzO3t7c6IMoMKs3MI5/j42M/Pz3lXAEVmpxFLeXm5JKIAiow6swOJ
YmVlxcXFRSpXAHVmZxKCyWTKyMiQUBRAnVFqdjLpGRoaklaUGZSanUxibm9v
w8PDRbhCqVFtdj4paWpqEiHKTHp6OgrOjigN+/v7Xl5e4lwBFJydUhqKioqE
igIoOGrODuosc3NzokWZaWxsZGd1CqPRmJCQII8r1BxlZyd2nN7eXnlEmUHZ
2Ykd5PLyMjg4WE5XYHZ2lp3bEerq6mQWBVD5d/dIvb297e7uLr8rgOKz09vH
m0/J4kDxUX+2AFuZnJxkiTKD+rMd2ITBYIiNjeW6Qv23trbYJt6mq6uLK8qM
8h+pz87OAgIC2J6+gylg+7BGZWUl29APMAUYBLYSy2xsbDj2lCyOzs5OthXL
ZGdns938DAYBs8AW8zOjo6NsMZbBLLDd/A+9Xh8VFcW2Yhm1Wr2+vs429IPW
1la2EmtgHNiGvnN0dOTr68v28QaYCLanb5SVlbFNvA0mAkPBFbW8vCztU7I4
MBREUSaTKS0tje3AVjAUmAuWq8HBQbYA+8BcUETd3NyEhYWx09sH5gKjIb+r
hoYGdnRHSE1NlfmRem9vz9PTk53bQQYGBuR0VVhYyE7sOJgODIg8omZmZthx
nQUDIoOop6en+Ph4dlZnwYBgRkS76unpYQeVhoKCAqGiLi4ugoKC2CklA2Mi
zlVtbS07n5RgTDApIkRtbm66ubmx80kMJkWEq9zcXHYy6cGkYFikFTUxMcGO
JQoMi4SiDAZDTEwMO5MoMCyYF6lcdXR0sAOJBfMiiajT01N/f392GuGMj487
70qj0bBzyAFGxslH6rW1NbVazc4hE5gaZ1xlZWWxE8gHpubk5MQxUSMjI+zz
5aaiosIBUXq9PjIykn273GBwVldX7XXV0tLCPpwDZscuUYeHhz4+PuyraWB8
bHdVWlrKvpcJxuf+/t4WUUtLS+/lKVkcmKA3RZlMppSUFPalfDBBGCLrrvr7
+9lnKgUMkRVRNzc3oaGh7BsVBOboNVf19fXs65RFcnKyxUfq3d3d9/uULA6M
0ktX+fn57LuUCEbp+vr6uajFxcWAD16hra3N+h/EDz5whn8BePe0CA==
            "], {{0, 
            87}, {100, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{100, 87},
          PlotRange->{{0, 100}, {0, 87}}]], "ExerciseOutput",
         ImageSize->{100, 87},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "0b2fc318-1766-4cfc-83f2-36fa6f8cebdc"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmUko9Xscxo9jHgqFhOJaiI2QeSHXyrUydkss3jcH7wad99Y1rQw7w06s
TCuxQ7GRIZKF4WwMRSTKUGZHh3Pufd573nrd13Gc4f/7P3+9PnWE1ff51PMo
v98+1xZWqlUq1VcvfCn89PfvWu2nhqIA/FBS8/VLVY2m4o+avzRVGm36Z1f8
8k98KvD59v0/H3zwa3B3d6fT6dhXvA+am5szMzPZV7wDDg4OvL29MaTDw8Ps
W5ROSUmJ6j8iIiJQRvY5ymVhYUH1DJSRfZFCMRqNSUlJz12hjKgk+y4l0tfX
p3pBcXEx+y7FcXV1FRIS8tIVmJ+fZ1+nLLRarUVRIDExEfVkH6gUdnZ2PDw8
XnMFUE/2jUohLy/PiiiAeqKk7DP5TE9PWxdlBiVlX0rm8fExLi7OFlcoKarK
vpdJd3e3LaLMoKrse2mcn58HBgba7gpMTU2xr+ZQXV1tlyiAwqK27MPlRqfT
ubq62usKoLbs2+UmJyfHAVEAtUV52efLx9jYmGOizFRVVbETyMTDw0N0dLQz
rlDeX+SfzO3t7c6IMoMKs3MI5/j42M/Pz3lXAEVmpxFLeXm5JKIAiow6swOJ
YmVlxcXFRSpXAHVmZxKCyWTKyMiQUBRAnVFqdjLpGRoaklaUGZSanUxibm9v
w8PDRbhCqVFtdj4paWpqEiHKTHp6OgrOjigN+/v7Xl5e4lwBFJydUhqKioqE
igIoOGrODuosc3NzokWZaWxsZGd1CqPRmJCQII8r1BxlZyd2nN7eXnlEmUHZ
2Ykd5PLyMjg4WE5XYHZ2lp3bEerq6mQWBVD5d/dIvb297e7uLr8rgOKz09vH
m0/J4kDxUX+2AFuZnJxkiTKD+rMd2ITBYIiNjeW6Qv23trbYJt6mq6uLK8qM
8h+pz87OAgIC2J6+gylg+7BGZWUl29APMAUYBLYSy2xsbDj2lCyOzs5OthXL
ZGdns938DAYBs8AW8zOjo6NsMZbBLLDd/A+9Xh8VFcW2Yhm1Wr2+vs429IPW
1la2EmtgHNiGvnN0dOTr68v28QaYCLanb5SVlbFNvA0mAkPBFbW8vCztU7I4
MBREUSaTKS0tje3AVjAUmAuWq8HBQbYA+8BcUETd3NyEhYWx09sH5gKjIb+r
hoYGdnRHSE1NlfmRem9vz9PTk53bQQYGBuR0VVhYyE7sOJgODIg8omZmZthx
nQUDIoOop6en+Ph4dlZnwYBgRkS76unpYQeVhoKCAqGiLi4ugoKC2CklA2Mi
zlVtbS07n5RgTDApIkRtbm66ubmx80kMJkWEq9zcXHYy6cGkYFikFTUxMcGO
JQoMi4SiDAZDTEwMO5MoMCyYF6lcdXR0sAOJBfMiiajT01N/f392GuGMj487
70qj0bBzyAFGxslH6rW1NbVazc4hE5gaZ1xlZWWxE8gHpubk5MQxUSMjI+zz
5aaiosIBUXq9PjIykn273GBwVldX7XXV0tLCPpwDZscuUYeHhz4+PuyraWB8
bHdVWlrKvpcJxuf+/t4WUUtLS+/lKVkcmKA3RZlMppSUFPalfDBBGCLrrvr7
+9lnKgUMkRVRNzc3oaGh7BsVBOboNVf19fXs65RFcnKyxUfq3d3d9/uULA6M
0ktX+fn57LuUCEbp+vr6uajFxcWAD16hra3N+h/EDz5whn8BePe0CA==
              "], {{
              0, 87}, {100, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {100, 87}, 
            PlotRange -> {{0, 100}, {0, 87}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d7dab86e-7fa8-48ff-baca-2d9b3f1a077d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["8.1"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b304187a-f82b-4c57-9604-af96c1acb8c2"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4eae43b0-2e0c-468b-937d-029ee983c508"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"095029ea-2f42-46fe-af06-0ee8e5928b1f"],

Cell["Make graphics of a red circle.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"518111ea-7a61-478b-8612-852051422b46"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6944409c-6591-49fd-81a6-d24c2aa351a4"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnU1IW1kUgGUGdJYDlYqLFqZCoerCQpEp1sUsdSN20FUUonWaEZoBI5VZ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            "], {{0, 
            100}, {100, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{100, 100},
          PlotRange->{{0, 100}, {0, 100}}]], "ExerciseOutput",
         ImageSize->{100, 100},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "621455b9-eb34-4927-99f8-4567b2af81c2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnU1IW1kUgGUGdJYDlYqLFqZCoerCQpEp1sUsdSN20FUUonWaEZoBI5VZ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              "], {{
              0, 100}, {100, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {100, 100}, 
            PlotRange -> {{0, 100}, {0, 100}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3bd4bb8c-a918-4f3e-a8a2-489d4cd9f8a5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["8.2"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"03281bb2-bced-48d8-adb4-0153bfbe8a60"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7f217419-70b3-4867-a37e-5a8dd9a56a1f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6fe63fcb-fd6c-4fab-9f6b-e1e5b544b95f"],

Cell["Make a red octagon.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"cd559b2b-816c-48d4-aa75-79b6bd69eabc"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9735dbb8-3a26-4f99-a89e-5a9b6a660032"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt07FtwkAYxXFImpSZACkLUKdNmZYoA0DsoFA4kokIETswAWzAOkhUDABy
SX05dFVQCtvY933v7v31bAHV3U/iYfQ5eL/pdDrTO/saDL+f8nz483Jvv7xm
049xlibP2Vc6TvPH0a398c0+iX3Onw1jQB2PZjIxSeJ7y6X0zStmofp9Y//g
IpvNpO9fOlkoIC4NUBBceqCUc2mDUsulE0ohl2YoVVz6oZRwoUCJc2FBCXIh
Qolw4UJ55kKH8sYVBpQHrpCgWuUKD6olrlChGucKG6pBrhigGuGKB+pKrtig
anPFCVWDK2aoSlyEKslFqJJchCrJRajyXIuF/KnUbrf7YzWfyx9J7bZbWtGK
VrTCGK1oRStaoYxWtKIVrVBGK1rRilYooxWtaEUrlNGKVrSiFcpoRSta0Qpl
tKIVrWiFMlrRila0QhmtalttNqbblT+VwvV6pijMRasVuf6B2u8vochVCYpc
laDIVQmKXJWgYuaqARUnV22o2LiuhIqHqxGoGLgahAqbq3GoULlaggqPq1Uo
13odApcHqDC4vEGhc3mGwuUSgULkEoTC4hKHQuFSAuXSzKUKyqWTSyGUSxuX
WiiXHi7lUC4NXBBQLlkuICiXFBcclKsozOHge6eT9LXZuV+VN9Ix
            "], {{0, 
            99}, {100, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{100, 99},
          PlotRange->{{0, 100}, {0, 99}}]], "ExerciseOutput",
         ImageSize->{100, 99},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3aebac4e-d149-4f3b-a0c7-205340fed426"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt07FtwkAYxXFImpSZACkLUKdNmZYoA0DsoFA4kokIETswAWzAOkhUDABy
SX05dFVQCtvY933v7v31bAHV3U/iYfQ5eL/pdDrTO/saDL+f8nz483Jvv7xm
049xlibP2Vc6TvPH0a398c0+iX3Onw1jQB2PZjIxSeJ7y6X0zStmofp9Y//g
IpvNpO9fOlkoIC4NUBBceqCUc2mDUsulE0ohl2YoVVz6oZRwoUCJc2FBCXIh
Qolw4UJ55kKH8sYVBpQHrpCgWuUKD6olrlChGucKG6pBrhigGuGKB+pKrtig
anPFCVWDK2aoSlyEKslFqJJchCrJRajyXIuF/KnUbrf7YzWfyx9J7bZbWtGK
VrTCGK1oRStaoYxWtKIVrVBGK1rRilYooxWtaEUrlNGKVrSiFcpoRSta0Qpl
tKIVrWiFMlrRila0QhmtalttNqbblT+VwvV6pijMRasVuf6B2u8vochVCYpc
laDIVQmKXJWgYuaqARUnV22o2LiuhIqHqxGoGLgahAqbq3GoULlaggqPq1Uo
13odApcHqDC4vEGhc3mGwuUSgULkEoTC4hKHQuFSAuXSzKUKyqWTSyGUSxuX
WiiXHi7lUC4NXBBQLlkuICiXFBcclKsozOHge6eT9LXZuV+VN9Ix
              "], {{0, 
              99}, {100, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {100, 99}, 
            PlotRange -> {{0, 100}, {0, 99}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6418b4ed-d053-4448-b35f-ae3a830fad2c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["8.3"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"457d58a9-3d99-4367-bc83-3159a90b0159"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8673fd08-5678-409c-8655-1577f02966aa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b182c3c0-4147-4eae-86f0-39671ccca667"],

Cell["\<\
Make a list whose elements are disks with hues varying from 0 to 1 in steps \
of 0.1.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"45d4a91c-b0dc-4968-a90d-1e149fad61da"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6471f7e5-cb06-4bd9-a5ed-5fdeb2965fcc"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnQ10lOWZ95PgB9S1uPYoKlvdFre2e3bjKbqt2y1uOdW+dWWhSq27hVM/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            "], {{0, 
            352}, {438, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{438, 352},
          PlotRange->{{0, 438}, {0, 352}}]], "ExerciseOutput",
         ImageSize->{442, 352},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "598b2032-7fdf-4dcb-bda8-6b626f7a453c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnQ10lOWZ95PgB9S1uPYoKlvdFre2e3bjKbqt2y1uOdW+dWWhSq27hVM/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              "], {{
              0, 352}, {438, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {438, 352}, 
            PlotRange -> {{0, 438}, {0, 352}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"75551293-2466-4be1-94fe-775c61b1e61e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["8.4"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"07818f42-9547-4336-b352-01d7863cc04f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6cc9859f-90ee-448f-bf97-3e14d0cfe7bf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ec04ad15-846d-4b33-8a6a-6aeca72ce54f"],

Cell["Make a column of a red and a green triangle.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"475116d9-4a36-4597-b012-b6a690125e1a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ac0771bb-71c6-4784-b8c0-a071bec4dd5e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnXlsVNUexzttKbQItIIIKmBVEMEdCU8laF0ICKLSVEWJSKEVVKiWLY0b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            "], {{0, 183}, {100, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{100, 183},
          PlotRange->{{0, 100}, {0, 183}}]], "ExerciseOutput",
         ImageSize->{104, 183},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "51d1b850-e8e7-4723-8a4a-0c6bf52eefa2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnXlsVNUexzttKbQItIIIKmBVEMEdCU8laF0ICKLSVEWJSKEVVKiWLY0b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              "], {{0, 183}, {100, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {100, 183}, 
            PlotRange -> {{0, 100}, {0, 183}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ea42ae0c-de89-44a7-a162-83a94fafaf08"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["8.5"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"579a6e01-9988-45ec-8439-6955cada5afe"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"cbd5b258-9d4f-4836-9b22-b2a5463c8835"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c56037f5-54b0-4d22-8d3c-d47f3bd47b9b"],

Cell["\<\
Make a list giving the regular polygons with 5 through 10 sides, with each \
polygon being colored pink.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"5557a417-e6f7-4f38-ba12-f9b54fe03b7d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ff1efa64-8ce1-47e9-ab6f-1f871610bd4e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnVtTFcmWx/fMvMzjfIX5AjzPK4/zMGHEmThvvpwT031iXnqMPhMx0W/c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            "], {{0, 226}, {333, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{333, 226},
          PlotRange->{{0, 333}, {0, 226}}]], "ExerciseOutput",
         ImageSize->{337, 226},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3c2ca9e4-ad54-44be-b487-0546c329b098"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnVtTFcmWx/fMvMzjfIX5AjzPK4/zMGHEmThvvpwT031iXnqMPhMx0W/c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              "], {{0, 226}, {333, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {333, 226}, 
            PlotRange -> {{0, 333}, {0, 226}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"05a63b52-869c-465e-ba66-a0f4106800ca"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["8.6"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"383f74de-d472-4547-baaf-3c7dfc1e32eb"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c4ff1169-46e5-4aec-aae0-603102e1f2a8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"01ee2dd9-76ad-4929-911c-20f71c7ca996"],

Cell["Make a graphic of a purple cylinder.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"f4b8a219-14dd-4bda-b88c-fd958dfabf7d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"57e1269e-fe9a-43c6-9321-09bfd94547fc"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnUtvW8cVxw/6styEbh00QFUVLWUnSvxo/KD1lmXqQbKy5KcsJbQtmXq/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            "], {{0, 141}, {130, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{130, 141},
          PlotRange->{{0, 130}, {0, 141}}]], "ExerciseOutput",
         ImageSize->{134, 141},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "de98a049-15be-4bbe-82bc-30272ef69293"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnUtvW8cVxw/6styEbh00QFUVLWUnSvxo/KD1lmXqQbKy5KcsJbQtmXq/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              "], {{0, 141}, {130, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {130, 141}, 
            PlotRange -> {{0, 130}, {0, 141}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d39ddc05-428f-4ada-a4a3-7893572a59cc"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["8.7"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"497b34b8-85e4-489f-82b6-0323dd606b21"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"517e322d-aa64-4b2e-8e04-fe145db76db3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"abdcc755-338e-468d-b1b1-0c34ceae2cfb"],

Cell[TextData[{
 "Make a list of polygons with 8, 7, 6, ",
 StyleBox["... ", "GrayPointSix"],
 ", 3 sides, and colored with ",
 StyleBox["RandomColor",
  FontFamily->"Source Sans Pro"],
 ", then show them all overlaid with the triangle on top (hint: apply ",
 StyleBox["Graphics",
  FontFamily->"Source Sans Pro"],
 " to the list)."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"3b879b67-237d-470d-b3d3-b7676dbf77fd"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"18ebebfe-1baf-48e7-b911-fd49c69c05d9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnQd4VGX6xQWVhE5CFUFpkwRCk967CKG3IL33lgAWcFFhsaBSdP+Ki2Vd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            "], {{0, 346}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 346},
          PlotRange->{{0, 360}, {0, 346}}]], "ExerciseOutput",
         ImageSize->{364, 346},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "194c5acd-78e0-4944-b3cf-e87299309de3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnQd4VGX6xQWVhE5CFUFpkwRCk967CKG3IL33lgAWcFFhsaBSdP+Ki2Vd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              "], {{0, 346}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 346}, 
            PlotRange -> {{0, 360}, {0, 346}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"30bcdbd1-edec-4cc7-83fd-4ee144713d98"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["8.8"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2569692e-cbcc-46b0-a8e1-e40e5da0d68a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"cf9ed4ca-9883-4faf-8bcf-ef03fb12b114"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a687515a-4389-4f31-8f61-a9675846f8cf"],

Cell["Make a list of 10 regular pentagons with random colors. ", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+8.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"a4633bcc-39a4-40a6-826b-4bd6fb4a959f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"92bb143c-7f3a-44d3-95f1-625dfa99dbcf"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnWdYVPfboNndL/txv7ypJlGTWBNMrEk0KhqN3RhbNPYao2Ih9o6xYO+i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            "], {{0, 335}, {434, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{434, 335},
          PlotRange->{{0, 434}, {0, 335}}]], "ExerciseOutput",
         ImageSize->{438, 335},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "99410f33-4746-4749-87b7-aa6542f6cf26"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnWdYVPfboNndL/txv7ypJlGTWBNMrEk0KhqN3RhbNPYao2Ih9o6xYO+i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              "], {{0, 335}, {434, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {434, 335}, 
            PlotRange -> {{0, 434}, {0, 335}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"15c9ffd2-e03a-4fdf-8ca7-85aa82184ed5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x8.1"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0c72cffa-c85e-49b3-9e15-12c35ad2a668"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ca0d64f4-d0ed-4c43-ae5f-fbca69f940ea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a9495b38-2f87-45f1-beab-a005ae1793d2"],

Cell["Make a list of a 20-sided regular polygon and a disk.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+8.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"6e5114d3-a64b-4f05-a887-b2cdc690c279"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b8a0c739-209e-47b4-b075-98579946beb5"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnX1IU28bx/eSpVChkfRKVCSU1JKweEiaaP2RGS2zQqKMfqhpby5/xUNU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            "], {{0, 102}, {
            220, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{220, 102},
          PlotRange->{{0, 220}, {0, 102}}]], "ExerciseOutput",
         ImageSize->{224, 102},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a918032c-1b35-45f6-a8e9-5974e91bf812"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnX1IU28bx/eSpVChkfRKVCSU1JKweEiaaP2RGS2zQqKMfqhpby5/xUNU
kBXYiNKVK6OkqJRMNA1CDcQog6KEmr1A7Y+VmGS1cm7NtmXPZfak7uXs7Oyc
c93T+wOKbWfnXN9v1865z33u+7pn/ZO7LksmkUj+DYVf67b9NyEvb9uB1HD4
x4Y9/+Zs35OZkbRnX+b2zLz//COHF7PgxwA/fX//olAoFAqFQuGK0+lsamra
t2/fdtbs3r27pqbGZrNhx46P3W5vbW2tqKgoKCjIzs5OSUlRKpUxMTHR0dFR
UVHwG/6GV+B1eBe2gS1he/gUduAkArY0NDRkZmZGRkZKODF27NiNGzeCyd3d
3dhqRKWrq6u6ulqtVsfGxo4ePZqDdfAp+CzsAfYDe8MWhExPT8/t27e3bt0a
ERHBLRXdCQ0NXbt27bVr1759+4atT0A6OjqKi4vj4+NHjRrFl3UA7A32CXuG
/WNLFBWr1VpZWZmWljZu3Dge/XQBvv5JSUmXLl369OkTtmLegLYNNFSSk5Pl
crlw1gGwfzgKHAuOiC1aQOC6UFZWtm7durCwMEH9dLc3MTFRp9N9+PAB2wPu
wBdZq9XOmjVLTOsAOCIcF46ObQD/wOVA5FR0RyaT5eXl/fjxA9sM/4AWTmFh
4aRJkxCtg6NDDBAJthn88PnzZ5VKheinC4sWLXrz5g22K2ypr6+fM2cOtmd/
gEggHmxLAqWpqWnatGnYXroCN+lXrlzB9sYHbW1t69evx7bKAxAVxIZtDxcc
DsehQ4fgcoltoVc2bdpEbNdHaWkpfHGwHfIKxAYRYpvkH0ajcenSpdjO+Wb2
7NmPHz/GdmsIFotly5Yt2MawAuKEaLENY8XNmzfDw8OxDWNLSEjIiRMnent7
sW3rQ6/Xz507F9sSP4BoIWZs25iwWq0ZGRnYPnFhxYoV6D1FDQ0NJF+vvQEx
Q+S41nnj2bNnwfUddyEyMvLOnTtY7pWXl8MZG9sDjkDkED+Wdd44c+bMmDFj
sL3hAbVaLX4HZlFRkVQqxZYeEBC/VqsV2TcGzp8/j20Jn2RnZ4vpHvxXYivm
DULS8sWLF+gPaHinurpaHPfgkhfsZ8jBgBb0i7jNZps/fz62E/wTERHx/v17
od2DW4PgbUN6AxTh3vLk5ORgeyAUy5YtE3RIjF6vD8a7bDaALqwOolu3bmGr
F5YjR44IZJ3FYgnqPgqfgDrxu9Pb2tomTJiALV1Y5HL5gwcPhHAvWJ7UBAJo
FMI6b/z8+VOpVGKLFoMZM2aYTCZ+3SstLcWWJRJiPhPPz8/HliseqampPFoH
15fh2ox0B5SKM4KoublZ6IH3pFFSUsKXe2QOPxMO0MuXdd74+vUrXM6whYpN
WFjYy5cvA3evvr4eWwoCQg8DHmlf878sWLAgwCnkPT095IwYFxNQLdykiQsX
LmDrw2THjh2BuFdYWIitAA3QzlcSDgZSffz48djikHn16hU396xWK+4kL1xA
uxAzH2/fvo2tDJ9jx45xc284DbTghhDDM9LT07Fl4bNw4UIO1jmdTvHnZZMG
OMDvs1q73c5j+ZSgxmAw+OteTU0NdtREAD7wmJMjsxPDIxqNxl/3kpOTsaMm
AvCBx5zMzMzEFkQKS5Ys8cu6jo6OkfaIwRvgA1+lsaAZwLkE3/BDKpX6NbSy
uLgYO2SCADf8TT+H2dTZ3t5pdgx+sampCVsKWRQVFbG3ND4+HjteggA3XFPO
Zurs7DSZPT6PMNce/X9Vn6OPBr+xa9cuVB3EsWzZMpYJ2dXVxW99yGAH3HCp
PdKiUfS/pVCXdQ51z/b6MryuOnD5kf610TSQtL29vVOnTkXVQRwymYxlu6iq
qgo7WOJwmetkM7W/fq2v1fYtRaJ5NGRYoKFsM5wfXRIVePjwIbYIEjl37hyb
nMzNzcWOlDjAE09WmbUKiULbMvglfUmCRFFidts0Ly8PWwSJLF++nE1OxsbG
YkdKHOCJJ6tsZSq2OTlz5kxsESQC7aLPnz8zJ6TdbudW9H54A554WmnCfDlB
ksAiJ58+fYqtgFx8DuxvbW3FjpFQwBn3nCxhl5PHjx/HDp9cNm7cyJyTN27c
wI6RUMAZzjl58OBB7PDJZfXq1cw5WVBQgB0joYAzNCeFwGdOZmdnY8dIKJ4q
MplLFO45qaI56Rc+czIlJQU7RkIBZ9zteqRRKDSDH9Y4arMkQ1+hOekDnzk5
QqbAcwCccbdLf7mvM2jgrGi6r5BItC2uXUE0JxnwmZMxMTHYMRIKOONul8NY
CW/VGvvGWpiMj44mSCSby9w7J2lOMuAzJ6Ojo7FjJBRwxpNhjroDcGpUNxo6
NX1bKRo9FSChOcmAz5yMiorCjpFQwBnPltlafr+vsZkMJZslcM/j/rCb5iQD
9DzJGS/nSXPfmIsEjb7T1p+fKrdRGTQnmRnIScdruOYkHK1zGQJI25Pe8Nie
7B+Z1jhwZnTUqV2HTdKcZGYgJ216+H4PuWf8Db3v9obn++6+TvMhvZG/+ye1
LidKmpMMDL52Gyo3u/fu0v5Jb3jsn7x/VKHQ0Oc4AfE3J9v7rjGSMr1ry4c+
x/EG6+c4NCf9429OOszthnYP00no825v0OfdAuHzvpuOC/JGRUUF55ykY9UY
2LBhA3NO0vGT3ghk/OSTJ0+wwyeXS5cuMeckHWfuEW/jzN1zskXreifezwis
yssGuVz+6dMn5pz8RefjeMLLfBwPOWmozJJI1Ea3Tffu3YstgkQSExN9JuQv
Om/RE2q12pNVJvd5iw5DGWyvyNLUNd7XGwfOl83NzdgiSESn07HJSTq/2x2X
+d3m9tf3Gxsv/653oW1x6U9ztJQd+FOSYNADnd7e3ilTpqCKIA6pVMpyAXpa
B8MFhjoY6pL7XurFO2xms802pF7Qjh07cIWQRlxcHJuE7IfWCxqMh3pBfRk3
tEAVCxobG7GlkIVfFeNpXbXBcKir5hGn0zlx4kRsNQTx7t079u7R+pN/4bH+
JJCRkYEtiBQWL17sr3u0Tm8//NbpraurwxZECidOnPDXPVrPvB9+65nb7fbw
8HBsTUTw9u1bf92j6z5IBFj34dfIWHLaJwqFgpt7dH0cIdbHoRcgID8/n5t7
dB0xIdYRs9ls48aNwxaHTCCr09L1FoVAp9Nhi8MkKysrEPfourQCoVKpfAcx
HImOjv7+/XuA7o3Mpa+EXr/7y5cv06dPx1YpNqGhoXq9nhcDR9oC6KCXF9+Y
uXfvnkwmw9YqKnw9EQPa2trGjh2LLUgkQCno5cs6Zg4fPowtVzzWrFnDr3ul
paXYmkTCZ3ltHnE6nXFxcdiKxWDatGk+a+lzYCR09oJG3n1jxmg0DvsnO9BE
aWpqEsI9i8Uyd+5cbH0CAupAoxDWMVNZWYktXVgOHToknHtw0zRcG5agi69b
Qg4M4zWUly5d6nD4O9TUPxoaGkJCQrCF8gwoAl2C+saM1WqdN28etg38A80S
aJyIYGB5eblUKsWWyxugBRSJ4Bszz58/HzNmDLYZPHPz5k3RDCwqKsKWyxt+
rSItKGfPnsU2g08yMjJENlCr1Qb72RLiF2LkTyCcPHlyeDSNcnJybDYv8+eE
BC55wWsgRE7CJdudJ0+eBPUYgwkTJty6dQvRQLg1CMY7cYgZ96aGme7u7iDt
DVYqlaI9BWNAr9cHV78lRIvY7cOea9euBdFIS7lcnp+f//PnT2zb/mCxWILl
ew1xonSMc8NgMCxevBjbM9/MmDGjubkZ2y0PlJaWknwdh9jEfJbNF3a7ff/+
/STfTqampn79+hXbJ69AW4LMgW0QFQntHM7cvXt38uTJ2C66EhYWduHCBWxv
WFFfX0/OnSNEIvQAXXH4+PFjUlIStp0DLFiwIJBpNeLT09NTWFiIO8UMjg4x
CDqFQWR6e3tPnTpFQtHanTt3onQ/Bo7VatVqteLPE4cjwnGFmHVIAl++fIGG
8apVq0ROTplMFhcXd/r0ab/q/JCJ0+msqalJTk4WugYR7B+OAsfivVAAmXR1
dV2/fj0lJQXadYK6mpiYqNPpWNaKDC46OjqKi4vj4+P5rW8Je4N9wp55LDYV
XFgslsrKyrS0NB77M0NCQlauXHnx4kU29caHAfAFr6qqys3NjY2N5XYBgk/B
Z2EP1dXVLgVLRzLQeK6trU1PT4+IiOCWiqGhoSqV6urVqyR37wiN3W5vbW29
ceNGQUFBdnY2XImUSmVMTEx0dHRUVBT8hr/hFXgd3oVtYEvY3tMqDJQBwJ/6
+vrdu3dvY01WVlZFRUV3dzd27BQKhUKhUCgjlP8BarQDFQ==
              "], {{0, 
              102}, {220, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {220, 102}, 
            PlotRange -> {{0, 220}, {0, 102}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8701c3d3-64cb-4d7b-b7cd-0ca759b31426"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x8.2"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e27f273e-7ac1-4980-b451-ae861a7bddd2"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"382b5e6a-9e5e-4377-8b4a-e644b61c6a94"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2d1f4e44-4040-427c-82c3-3bfbffb80de5"],

Cell["Make a list of polygons with 10, 9, ... , 3 sides.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+8.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"3c610f5d-d45f-41b0-a55b-51b60a6e607a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"06b5bc4a-3b4c-4fc4-ad53-3c6e389aeacc"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3Ql4TdfaB/BMcjIgJDEkKuEa25JclIYi0ouqWYLborRC0BqbWyS02nDd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            "], {{0, 227}, {438, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{438, 227},
          PlotRange->{{0, 438}, {0, 227}}]], "ExerciseOutput",
         ImageSize->{442, 227},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2dd1acbd-83af-4fe4-9c43-b803e85711a2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3Ql4TdfaB/BMcjIgJDEkKuEa25JclIYi0ouqWYLborRC0BqbWyS02nDd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              "], {{0, 227}, {438, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {438, 227}, 
            PlotRange -> {{0, 438}, {0, 227}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"55fdc391-2b27-40de-ad3d-cf86f0896ecf"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x8.3"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3f282bf8-1cf6-462f-8690-cabee4cfa1db"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"24402934-54dd-4b1b-8a24-adac9e2b3d3b"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"95f2e7f4-e5ea-4fec-87ea-fc86c2f230cd"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Basic Graphics Objects: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 8  Basic Graphics Objects", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
08-basic-graphics-objects.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+8.1", "8.1", "+8.2", "8.2", "+8.3", "8.3", "8.4", "8.5", "8.6", 
         "8.7", "8.8"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+8.1", "8.1", "+8.2", "8.2", "+8.3", "8.3", "8.4", "8.5", "8.6", "8.7", 
      "8.8"}, "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[8620, 216, 813, 26, 
  70, "Input", "ExpressionUUID" -> "4eae43b0-2e0c-468b-937d-029ee983c508",
   CellTags->"FirstInputCell"],
  Cell[18395, 459, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7f217419-70b3-4867-a37e-5a8dd9a56a1f",
   CellTags->"FirstInputCell"],
  Cell[25350, 657, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8673fd08-5678-409c-8655-1577f02966aa",
   CellTags->"FirstInputCell"],
  Cell[70214, 1478, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6cc9859f-90ee-448f-bf97-3e14d0cfe7bf",
   CellTags->"FirstInputCell"],
  Cell[82301, 1760, 813, 26, 
  70, "Input", "ExpressionUUID" -> "cbd5b258-9d4f-4836-9b22-b2a5463c8835",
   CellTags->"FirstInputCell"],
  Cell[106123, 2236, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c4ff1169-46e5-4aec-aae0-603102e1f2a8",
   CellTags->"FirstInputCell"],
  Cell[122631, 2591, 813, 26, 
  70, "Input", "ExpressionUUID" -> "517e322d-aa64-4b2e-8e04-fe145db76db3",
   CellTags->"FirstInputCell"],
  Cell[160523, 3302, 813, 26, 
  70, "Input", "ExpressionUUID" -> "cf9ed4ca-9883-4faf-8bcf-ef03fb12b114",
   CellTags->"FirstInputCell"],
  Cell[208361, 4171, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ca0d64f4-d0ed-4c43-ae5f-fbca69f940ea",
   CellTags->"FirstInputCell"],
  Cell[222793, 4491, 813, 26, 
  70, "Input", "ExpressionUUID" -> "382b5e6a-9e5e-4377-8b4a-e644b61c6a94",
   CellTags->"FirstInputCell"],
  Cell[255705, 5114, 813, 26, 
  70, "Input", "ExpressionUUID" -> "24402934-54dd-4b1b-8a24-adac9e2b3d3b",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 314580, 6334}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[645, 22, 489, 14, 70, "Exercise", "ExpressionUUID" -> \
"e8804ec9-c3bf-4e17-8b7e-1931dd6640e6",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1159, 40, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"db7446a9-80ac-4796-956c-68db5c225adb"],
Cell[1798, 61, 6216, 130, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d7dab86e-7fa8-48ff-baca-2d9b3f1a077d"]
}, Closed]],
Cell[CellGroupData[{
Cell[8051, 196, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"b304187a-f82b-4c57-9604-af96c1acb8c2"],
Cell[8620, 216, 813, 26, 70, "Input", "ExpressionUUID" -> \
"4eae43b0-2e0c-468b-937d-029ee983c508",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9470, 247, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"095029ea-2f42-46fe-af06-0ee8e5928b1f"],
Cell[9757, 258, 413, 9, 70, "Exercise", "ExpressionUUID" -> \
"518111ea-7a61-478b-8612-852051422b46",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[10195, 271, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6944409c-6591-49fd-81a6-d24c2aa351a4"],
Cell[10834, 292, 6955, 142, 70, "ExerciseOutput", "ExpressionUUID" -> \
"3bd4bb8c-a918-4f3e-a8a2-489d4cd9f8a5"]
}, Closed]],
Cell[CellGroupData[{
Cell[17826, 439, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"03281bb2-bced-48d8-adb4-0153bfbe8a60"],
Cell[18395, 459, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7f217419-70b3-4867-a37e-5a8dd9a56a1f",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19257, 491, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"6fe63fcb-fd6c-4fab-9f6b-e1e5b544b95f"],
Cell[19544, 502, 402, 9, 70, "Exercise", "ExpressionUUID" -> \
"cd559b2b-816c-48d4-aa75-79b6bd69eabc",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[19971, 515, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"9735dbb8-3a26-4f99-a89e-5a9b6a660032"],
Cell[20610, 536, 4134, 96, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6418b4ed-d053-4448-b35f-ae3a830fad2c"]
}, Closed]],
Cell[CellGroupData[{
Cell[24781, 637, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"457d58a9-3d99-4367-bc83-3159a90b0159"],
Cell[25350, 657, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8673fd08-5678-409c-8655-1577f02966aa",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26212, 689, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b182c3c0-4147-4eae-86f0-39671ccca667"],
Cell[26499, 700, 476, 12, 70, "Exercise", "ExpressionUUID" -> \
"45d4a91c-b0dc-4968-a90d-1e149fad61da",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[27000, 716, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6471f7e5-cb06-4bd9-a5ed-5fdeb2965fcc"],
Cell[27639, 737, 41969, 716, 70, "ExerciseOutput", "ExpressionUUID" -> \
"75551293-2466-4be1-94fe-775c61b1e61e"]
}, Closed]],
Cell[CellGroupData[{
Cell[69645, 1458, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"07818f42-9547-4336-b352-01d7863cc04f"],
Cell[70214, 1478, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6cc9859f-90ee-448f-bf97-3e14d0cfe7bf",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71076, 1510, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ec04ad15-846d-4b33-8a6a-6aeca72ce54f"],
Cell[71363, 1521, 427, 9, 70, "Exercise", "ExpressionUUID" -> \
"475116d9-4a36-4597-b012-b6a690125e1a",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[71815, 1534, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"ac0771bb-71c6-4784-b8c0-a071bec4dd5e"],
Cell[72454, 1555, 9241, 180, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ea42ae0c-de89-44a7-a162-83a94fafaf08"]
}, Closed]],
Cell[CellGroupData[{
Cell[81732, 1740, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"579a6e01-9988-45ec-8439-6955cada5afe"],
Cell[82301, 1760, 813, 26, 70, "Input", "ExpressionUUID" -> \
"cbd5b258-9d4f-4836-9b22-b2a5463c8835",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83163, 1792, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c56037f5-54b0-4d22-8d3c-d47f3bd47b9b"],
Cell[83450, 1803, 495, 12, 70, "Exercise", "ExpressionUUID" -> \
"5557a417-e6f7-4f38-ba12-f9b54fe03b7d",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[83970, 1819, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"ff1efa64-8ce1-47e9-ab6f-1f871610bd4e"],
Cell[84609, 1840, 20908, 371, 70, "ExerciseOutput", "ExpressionUUID" -> \
"05a63b52-869c-465e-ba66-a0f4106800ca"]
}, Closed]],
Cell[CellGroupData[{
Cell[105554, 2216, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"383f74de-d472-4547-baaf-3c7dfc1e32eb"],
Cell[106123, 2236, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c4ff1169-46e5-4aec-aae0-603102e1f2a8",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[106985, 2268, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"01ee2dd9-76ad-4929-911c-20f71c7ca996"],
Cell[107272, 2279, 419, 9, 70, "Exercise", "ExpressionUUID" -> \
"f4b8a219-14dd-4bda-b88c-fd958dfabf7d",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[107716, 2292, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"57e1269e-fe9a-43c6-9321-09bfd94547fc"],
Cell[108355, 2313, 13670, 253, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d39ddc05-428f-4ada-a4a3-7893572a59cc"]
}, Closed]],
Cell[CellGroupData[{
Cell[122062, 2571, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"497b34b8-85e4-489f-82b6-0323dd606b21"],
Cell[122631, 2591, 813, 26, 70, "Input", "ExpressionUUID" -> \
"517e322d-aa64-4b2e-8e04-fe145db76db3",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[123493, 2623, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"abdcc755-338e-468d-b1b1-0c34ceae2cfb"],
Cell[123780, 2634, 759, 20, 70, "Exercise", "ExpressionUUID" -> \
"3b879b67-237d-470d-b3d3-b7676dbf77fd",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[124564, 2658, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"18ebebfe-1baf-48e7-b911-fd49c69c05d9"],
Cell[125223, 2680, 34694, 597, 70, "ExerciseOutput", "ExpressionUUID" -> \
"30bcdbd1-edec-4cc7-83fd-4ee144713d98"]
}, Closed]],
Cell[CellGroupData[{
Cell[159954, 3282, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"2569692e-cbcc-46b0-a8e1-e40e5da0d68a"],
Cell[160523, 3302, 813, 26, 70, "Input", "ExpressionUUID" -> \
"cf9ed4ca-9883-4faf-8bcf-ef03fb12b114",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[161385, 3334, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a687515a-4389-4f31-8f61-a9675846f8cf"],
Cell[161672, 3345, 488, 10, 70, "Exercise", "ExpressionUUID" -> \
"a4633bcc-39a4-40a6-826b-4bd6fb4a959f",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[162185, 3359, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"92bb143c-7f3a-44d3-95f1-625dfa99dbcf"],
Cell[162844, 3381, 44910, 765, 70, "ExerciseOutput", "ExpressionUUID" -> \
"15c9ffd2-e03a-4fdf-8ca7-85aa82184ed5"]
}, Closed]],
Cell[CellGroupData[{
Cell[207791, 4151, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"0c72cffa-c85e-49b3-9e15-12c35ad2a668"],
Cell[208361, 4171, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ca0d64f4-d0ed-4c43-ae5f-fbca69f940ea",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[209223, 4203, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a9495b38-2f87-45f1-beab-a005ae1793d2"],
Cell[209510, 4214, 437, 9, 70, "Exercise", "ExpressionUUID" -> \
"6e5114d3-a64b-4f05-a887-b2cdc690c279",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[209972, 4227, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b8a0c739-209e-47b4-b075-98579946beb5"],
Cell[210611, 4248, 11575, 218, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8701c3d3-64cb-4d7b-b7cd-0ca759b31426"]
}, Closed]],
Cell[CellGroupData[{
Cell[222223, 4471, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"e27f273e-7ac1-4980-b451-ae861a7bddd2"],
Cell[222793, 4491, 813, 26, 70, "Input", "ExpressionUUID" -> \
"382b5e6a-9e5e-4377-8b4a-e644b61c6a94",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[223655, 4523, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2d1f4e44-4040-427c-82c3-3bfbffb80de5"],
Cell[223942, 4534, 434, 9, 70, "Exercise", "ExpressionUUID" -> \
"3c610f5d-d45f-41b0-a55b-51b60a6e607a",
 CounterAssignments->{{"SectionNumber", 8}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[224401, 4547, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"06b5bc4a-3b4c-4fc4-ad53-3c6e389aeacc"],
Cell[225040, 4568, 30058, 521, 70, "ExerciseOutput", "ExpressionUUID" -> \
"55fdc391-2b27-40de-ad3d-cf86f0896ecf"]
}, Closed]],
Cell[CellGroupData[{
Cell[255135, 5094, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3f282bf8-1cf6-462f-8690-cabee4cfa1db"],
Cell[255705, 5114, 813, 26, 70, "Input", "ExpressionUUID" -> \
"24402934-54dd-4b1b-8a24-adac9e2b3d3b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[256545, 5144, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"95f2e7f4-e5ea-4fec-87ea-fc86c2f230cd"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature UScxDAsInE#zOkudKfYGj589 *)
