(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1869858,      42826]
NotebookOptionsPosition[   1759232,      40616]
NotebookOutlinePosition[   1854569,      42566]
CellTagsIndexPosition[   1853875,      42538]
WindowTitle->Colors and Styles: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Colors and Styles", "SectionInline",ExpressionUUID->
   "44a0102e-d952-46d8-88ad-baf4261c19e8"],
  $Line = 0; Null]], "Section",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowCellLabel->False,
 CounterAssignments->{{"Section", 6}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{
  "p:25", "i:1"},ExpressionUUID->"60415583-6487-4d9e-a1d7-38fe4f7b8eda"],

Cell["\<\
The Wolfram Language doesn\[CloseCurlyQuote]t just handle things like \
numbers. It also for example handles things like colors. It lets you refer to \
common colors by their names.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d061260b-982a-4fd2-a253-7cb11a2b5d14"],

Cell[TextData[{
 ButtonBox["Red",
  BaseStyle->"Link"],
 " represents the color red:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"33546c76-50b2-4623-96a9-c0889ba03e09"],

Cell[CellGroupData[{

Cell[BoxData["Red"], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"53cd4e3e-942c-4577-bf27-c0cc5d323148"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     Frame->True,
     FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 
        1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification])}],
     PlotRangePadding->None],
    "RGBColor[1, 0, 0]"],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[1, 0, 0],
  Editable->False,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"022f0568-df0b-4a23-8947-5c7a09089f4a"]
}, Open  ]],

Cell["Make a list of colors:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"bfa780e8-fc72-445e-80bb-2734833285ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Red", ",", "Green", ",", "Blue", ",", "Purple", ",", "Orange", ",", 
   "Black"}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"6fbb1ddd-1a15-4822-a977-bde185146dee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.5, 0, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.33333333333333337`, 0., 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.5, 0, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.5, 0, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.5, 0, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->GrayLevel[0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "GrayLevel[0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["GrayLevelColorValueSelector"], {
           0, {Left, Bottom}}, {Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    GrayLevel[0],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[2]=",ExpressionUUID->"ae2a1f3f-662a-4ced-b378-d2450136a992"]
}, Open  ]],

Cell[TextData[{
 "You can do operations on colors. ",
 ButtonBox["ColorNegate",
  BaseStyle->"Link"],
 " \[OpenCurlyDoubleQuote]negates\[CloseCurlyDoubleQuote] a color, giving the \
complementary color. ",
 ButtonBox["Blend",
  BaseStyle->"Link"],
 " blends a list of colors together. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"bdb9d760-63e2-41b2-b7d7-3379d97ad1e1"],

Cell["Negating the color yellow gives blue:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fc10c2e0-6cd4-43a4-8631-87b8f9152be8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorNegate", "[", "Yellow", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"8f5d08f6-b920-4ab0-bd1a-d9800765949d"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[0., 0., 1.], RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     Frame->True,
     FrameStyle->RGBColor[0., 0., 0.6666666666666667],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 
        1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification])}],
     PlotRangePadding->None],
    "RGBColor[0., 0., 1.]"],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0., 0., 1.]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[0., 0., 1.],
  Editable->False,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"fc7d5427-b60a-45dc-b2bb-15f9e399983d"]
}, Open  ]],

Cell["Here\[CloseCurlyQuote]s the result of blending yellow, pink and \
green:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"2e6dad9e-1e74-45c8-b0cd-73c195d1bf67"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blend", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", "Pink", ",", "Green"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"38484dda-e712-49cc-ba9f-ceda54cc106f"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[
        Rational[2, 3], 0.8333333333333333, 0.16666666666666666`], 
       RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     Frame->True,
     FrameStyle->RGBColor[
      0.4444444444444444, 0.5555555555555556, 0.1111111111111111],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 
        1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification])}],
     PlotRangePadding->None],
    "RGBColor[2/3, 0.8333333333333333, 0.16666666666666666]"],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
         Rational[2, 3], 0.8333333333333333, 0.16666666666666666`]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[
   Rational[2, 3], 0.8333333333333333, 0.16666666666666666`],
  Editable->False,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"45eee564-c5cc-4fdb-9050-86d5fa6e67d6"]
}, Open  ]],

Cell[TextData[{
 "You can specify a color by saying how much red, green and blue it contains. \
The function ",
 ButtonBox["RGBColor",
  BaseStyle->"Link"],
 " lets you do that, giving the amount of each color, from 0 to 1."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"fb6ab293-dab9-4d2e-9c8f-6c551d58bcef"],

Cell["This gives maximum red, with no green or blue:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dfae255b-b353-4a54-be74-34b0bcd9707e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"1", ",", "0", ",", "0"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"a48cf64f-b034-4464-8bf9-a9a3fe7ed7e2"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     Frame->True,
     FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 
        1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification])}],
     PlotRangePadding->None],
    "RGBColor[1, 0, 0]"],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[1, 0, 0],
  Editable->False,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"ac1444ea-6cee-41e8-971d-61033e1795e8"]
}, Open  ]],

Cell["Maximum red and green gives yellow:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2c2afbf6-55ab-48b9-a8ba-76043932e9e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"1", ",", "1", ",", "0"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"d61998d0-8375-49df-b2ec-1725063c5460"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     Frame->True,
     FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 
        1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification])}],
     PlotRangePadding->None],
    "RGBColor[1, 1, 0]"],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[1, 1, 0],
  Editable->False,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"dee6ad81-d9da-45f6-8028-89af7bb4971c"]
}, Open  ]],

Cell["\<\
This gives a table of colors with maximum red and varying levels of green:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f288b2a0-d5da-4d60-b6fe-96d59726761e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{"1", ",", "g", ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "0", ",", "1", ",", "0.05"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"8048fcd6-09f0-4bef-b308-7724b39ad3e9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0., 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0., 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0., 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0., 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.05, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.03333333333333334, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.05, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.05, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.05, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.06666666666666668, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.15000000000000002`, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.10000000000000002`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.15000000000000002, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[1, 0.15000000000000002`, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.15000000000000002`, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.2, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.13333333333333336`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.2, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.2, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.2, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.25, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.16666666666666669`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.25, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.25, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.25, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.30000000000000004`, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.20000000000000004`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.30000000000000004, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[1, 0.30000000000000004`, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.30000000000000004`, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.35000000000000003`, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.23333333333333336`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.35000000000000003, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[1, 0.35000000000000003`, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.35000000000000003`, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.4, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.2666666666666667, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.4, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.4, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.4, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.45, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.30000000000000004`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.45, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.45, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.45, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.55, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.3666666666666667, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.55, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.55, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.55, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.6000000000000001, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.4000000000000001, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.6000000000000001, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[1, 0.6000000000000001, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.6000000000000001, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.65, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.43333333333333335`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.65, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.65, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.65, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.7000000000000001, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.46666666666666673`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.7000000000000001, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[1, 0.7000000000000001, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.7000000000000001, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.75, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.5, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.75, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.75, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.75, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.8, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.5333333333333334, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.8, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.8, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.8, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.8500000000000001, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.5666666666666668, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.8500000000000001, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[1, 0.8500000000000001, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.8500000000000001, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.9, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6000000000000001, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.9, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.9, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.9, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.9500000000000001, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6333333333333334, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.9500000000000001, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[1, 0.9500000000000001, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.9500000000000001, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1., 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666667, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1., 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1., 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1., 0],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[7]=",ExpressionUUID->"1564083e-73e7-43a5-8d70-4f3b6718ba4a"]
}, Open  ]],

Cell[TextData[{
 "It\[CloseCurlyQuote]s often convenient to specify colors not directly in \
terms of red, green and blue, but for example instead in terms of ",
 StyleBox["hue",
  FontSlant->"Italic"],
 ". The function ",
 ButtonBox["Hue",
  BaseStyle->"Link"],
 " lets you do this. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:26",ExpressionUUID->"9b093de0-e159-4ceb-b1f6-68e6e230632c"],

Cell["A hue of 0.5 corresponds to cyan:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2d2aec0a-3d15-4fa0-bfde-e6650d59dbcf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hue", "[", "0.5", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"c04262b0-37b3-49c1-9cfa-a123f8cba7fe"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {Hue[0.5], RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     Frame->True,
     FrameStyle->Hue[0.5, 1., 0.6666666666666667],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 
        1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification])}],
     PlotRangePadding->None],
    "Hue[0.5]"],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.5, 0.5, 0.5]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  Hue[0.5],
  Editable->False,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"27d78d4d-3e03-46ca-8f8d-f0040b3a2000"]
}, Open  ]],

Cell["Here\[CloseCurlyQuote]s a table of colors with hues from 0 to 1:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"cfd57a36-0d3c-4fdf-9229-7d1cb5c33718"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Hue", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1", ",", "0.05"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"547b99e1-77b4-469e-bb6f-c22577c9bb30"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0., 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0., 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.05], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.05000000000000001, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.05]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.05, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.05],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.10000000000000002`, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.15000000000000002`], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.15, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.15000000000000002]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         Hue[0.15000000000000002`, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.15000000000000002`],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.2], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.20000000000000004`, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.2]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.2, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.2],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.25], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.25, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.25]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.25, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.25],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.30000000000000004`], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.30000000000000004`, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.30000000000000004]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         Hue[0.30000000000000004`, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.30000000000000004`],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.35000000000000003`], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.35000000000000003`, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.35000000000000003]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         Hue[0.35000000000000003`, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.35000000000000003`],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.4], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.4000000000000001, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.4]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.4, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.4],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.45], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.45, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.45]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.45, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.45],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.5, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.5, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.55], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.55, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.55]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.55, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.55],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.6000000000000001], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.6000000000000001, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.6000000000000001]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         Hue[0.6000000000000001, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.6000000000000001],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.65], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.65, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.65]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.65, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.65],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.7000000000000001], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.7000000000000001, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.7000000000000001]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         Hue[0.7000000000000001, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.7000000000000001],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.75], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.75, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.75]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.75, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.75],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.8], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.8000000000000002, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.8]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.8, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.8],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.8500000000000001], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.8500000000000001, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.8500000000000001]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         Hue[0.8500000000000001, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.8500000000000001],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.9], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.9, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.9]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[0.9, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.9],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[0.9500000000000001], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0.9500000000000001, 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[0.9500000000000001]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         Hue[0.9500000000000001, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[0.9500000000000001],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {Hue[1.], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->Hue[0., 1., 0.6666666666666667],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "Hue[1.]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = Hue[1., 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["HueColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    Hue[1.],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[9]=",ExpressionUUID->"f15051f7-f26c-44d7-b19a-26e068681939"]
}, Open  ]],

Cell[TextData[{
 "Sometimes you may want to just pick a random color. ",
 ButtonBox["RandomColor",
  BaseStyle->"Link"],
 " lets you do this. When you say ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomInteger",
    BaseStyle->"CodeLink"], "[", "10", "]"}]], "InlineCodeText",
  ExpressionUUID->"ace530d8-00a2-43c8-98b7-0ad7318522d9"],
 ", you\[CloseCurlyQuote]re asking to generate a random integer up to 10. But \
for a random color you don\[CloseCurlyQuote]t have to specify a range, so you \
can just write ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomColor",
    BaseStyle->"CodeLink"], "[", "\[ThinSpace]", "]"}]], "InlineCodeText",
  ExpressionUUID->"c3a60c9f-132f-4480-b107-4c4a416f8ff0"],
 "\[LongDash]not giving any explicit input to the function."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"384eedf4-9fa3-4052-a2ae-712d91ab639b"],

Cell["Generate a random color:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ef8996aa-0935-4015-a205-c8a55b1cc13e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomColor", "[", "\[ThinSpace]", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"2ba3096b-b784-477b-b1f9-d53aea019748"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[
       0.8812081483098249, 0.5103047063903976, 0.014571406485982985`], 
       RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     Frame->True,
     FrameStyle->RGBColor[
      0.5874720988732166, 0.34020313759359844`, 0.009714270990655324],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 
        1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification])}],
     PlotRangePadding->None],
    "RGBColor[0.8812081483098249, 0.5103047063903976, 0.014571406485982985]"],
   
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = 
       RGBColor[
        0.8812081483098249, 0.5103047063903976, 0.014571406485982985`]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[0.8812081483098249, 0.5103047063903976, 0.014571406485982985`],
  Editable->False,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"6646f254-075e-4ab0-acb6-ea9dd9a4e8db"]
}, Open  ]],

Cell["Make a table of 30 random colors:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dfee40b0-d3f8-4ced-85aa-0a396a92659f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RandomColor", "[", "\[ThinSpace]", "]"}], ",", "30"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"498d4bb3-b7a4-40f9-a349-f1d34278ce69"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.97320979758615, 0.1438453032759397, 0.6243618450435431], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6488065317241001, 0.09589686885062647, 0.41624123002902874`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.97320979758615, 0.1438453032759397, 0.6243618450435431]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[0.97320979758615, 0.1438453032759397, 0.6243618450435431]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.97320979758615, 0.1438453032759397, 0.6243618450435431],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.7269318416232196, 0.802805164739923, 0.25131235063877155`], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.48462122774881305`, 0.5352034431599487, 0.1675415670925144],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.7269318416232196, 0.802805164739923, 0.25131235063877155]"],
     
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.7269318416232196, 0.802805164739923, 0.25131235063877155`]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.7269318416232196, 0.802805164739923, 0.25131235063877155`],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.0897731101343957, 0.21340734034669206`, 0.5406135539460637], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.05984874008959714, 0.14227156023112805`, 0.3604090359640425],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.0897731101343957, 0.21340734034669206, 0.5406135539460637]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.0897731101343957, 0.21340734034669206`, 0.5406135539460637]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.0897731101343957, 0.21340734034669206`, 0.5406135539460637],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.19890195569306224`, 0.4460671950313444, 0.8124979594671975], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.13260130379537483`, 0.2973781300208963, 0.541665306311465],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.19890195569306224, 0.4460671950313444, 0.8124979594671975]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.19890195569306224`, 0.4460671950313444, 0.8124979594671975]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.19890195569306224`, 0.4460671950313444, 0.8124979594671975],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.7741045469349486, 0.6499294877880157, 0.06803889458630219], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.5160696979566324, 0.4332863251920105, 0.04535926305753479],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.7741045469349486, 0.6499294877880157, 0.06803889458630219]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.7741045469349486, 0.6499294877880157, 0.06803889458630219]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.7741045469349486, 0.6499294877880157, 0.06803889458630219],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.4511297167672681, 0.2935935685274975, 0.4304944984514649],
          RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.3007531445115121, 0.19572904568499835`, 0.28699633230097665`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.4511297167672681, 0.2935935685274975, 0.4304944984514649]"],
     
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[0.4511297167672681, 0.2935935685274975, 0.4304944984514649]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.4511297167672681, 0.2935935685274975, 0.4304944984514649],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.9060219064087653, 0.7101604930650787, 0.48482683572553764`], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6040146042725103, 0.4734403287100525, 0.32321789048369176`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.9060219064087653, 0.7101604930650787, 0.48482683572553764]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.9060219064087653, 0.7101604930650787, 0.48482683572553764`]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.9060219064087653, 0.7101604930650787, 0.48482683572553764`],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.8158359993769988, 0.045971927828049264`, 0.17016248102914955`], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.5438906662513325, 0.030647951885366176`, 0.11344165401943304`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.8158359993769988, 0.045971927828049264, \
0.17016248102914955]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.8158359993769988, 0.045971927828049264`, 0.17016248102914955`]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.8158359993769988, 0.045971927828049264`, 0.17016248102914955`],
    
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.8880730366207876, 0.4887904324904828, 0.8837231446849692],
          RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.5920486910805252, 0.32586028832698855`, 0.5891487631233128],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.8880730366207876, 0.4887904324904828, 0.8837231446849692]"],
     
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[0.8880730366207876, 0.4887904324904828, 0.8837231446849692]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.8880730366207876, 0.4887904324904828, 0.8837231446849692],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.17247173888956602`, 0.5821122444748299, 0.7291249742445489], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.11498115925971068`, 0.3880748296498866, 0.48608331616303263`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.17247173888956602, 0.5821122444748299, 0.7291249742445489]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.17247173888956602`, 0.5821122444748299, 0.7291249742445489]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.17247173888956602`, 0.5821122444748299, 0.7291249742445489],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.0750422514161222, 0.49651847987662534`, 0.7906681442379], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.05002816761074813, 0.33101231991775026`, 0.5271120961586],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.0750422514161222, 0.49651847987662534, 0.7906681442379]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[0.0750422514161222, 0.49651847987662534`, 0.7906681442379]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.0750422514161222, 0.49651847987662534`, 0.7906681442379],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.28613481978198285`, 0.8096196462941596, 0.829802343016004], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.1907565465213219, 0.5397464308627731, 0.5532015620106694],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.28613481978198285, 0.8096196462941596, 0.829802343016004]"],
     
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.28613481978198285`, 0.8096196462941596, 0.829802343016004]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.28613481978198285`, 0.8096196462941596, 0.829802343016004],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.7102241160493812, 0.8294405913773397, 0.8812033527741852],
          RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.4734827440329208, 0.5529603942515599, 0.5874689018494568],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.7102241160493812, 0.8294405913773397, 0.8812033527741852]"],
     
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[0.7102241160493812, 0.8294405913773397, 0.8812033527741852]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.7102241160493812, 0.8294405913773397, 0.8812033527741852],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.8237591001455009, 0.5686032159703007, 0.029895941038938778`], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.549172733430334, 0.37906881064686715`, 0.01993062735929252],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.8237591001455009, 0.5686032159703007, \
0.029895941038938778]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.8237591001455009, 0.5686032159703007, 0.029895941038938778`]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.8237591001455009, 0.5686032159703007, 0.029895941038938778`],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.19322300983895113`, 0.03811547219775879, 0.7165279764423917], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.1288153398926341, 0.025410314798505862`, 0.47768531762826116`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.19322300983895113, 0.03811547219775879, \
0.7165279764423917]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.19322300983895113`, 0.03811547219775879, 0.7165279764423917]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.19322300983895113`, 0.03811547219775879, 0.7165279764423917],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.8309422271415552, 0.7799859359816903, 0.014677270218953042`], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.5539614847610368, 0.5199906239877936, 0.009784846812635362],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.8309422271415552, 0.7799859359816903, \
0.014677270218953042]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.8309422271415552, 0.7799859359816903, 0.014677270218953042`]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.8309422271415552, 0.7799859359816903, 0.014677270218953042`],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.9077847803840746, 0.3523081995312334, 0.42000254971034945`], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6051898535893832, 0.23487213302082227`, 0.28000169980689965`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.9077847803840746, 0.3523081995312334, 0.42000254971034945]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.9077847803840746, 0.3523081995312334, 0.42000254971034945`]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.9077847803840746, 0.3523081995312334, 0.42000254971034945`],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.06511440944221869, 0.5145676123068976, 0.7925216584776673], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.04340960629481246, 0.3430450748712651, 0.5283477723184449],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.06511440944221869, 0.5145676123068976, 0.7925216584776673]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.06511440944221869, 0.5145676123068976, 0.7925216584776673]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.06511440944221869, 0.5145676123068976, 0.7925216584776673],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.7927485066479314, 0.16461604263951024`, 0.09494517743715258], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.5284990044319543, 0.10974402842634016`, 0.06329678495810173],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.7927485066479314, 0.16461604263951024, \
0.09494517743715258]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.7927485066479314, 0.16461604263951024`, 0.09494517743715258]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.7927485066479314, 0.16461604263951024`, 0.09494517743715258],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.42046073094631664`, 0.9540617992393343, 0.9562361369061758], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.28030715396421113`, 0.6360411994928896, 0.6374907579374506],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.42046073094631664, 0.9540617992393343, 0.9562361369061758]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.42046073094631664`, 0.9540617992393343, 0.9562361369061758]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.42046073094631664`, 0.9540617992393343, 0.9562361369061758],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.582675327871977, 0.6605281429960126, 0.09236637303657957],
          RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.388450218581318, 0.4403520953306751, 0.06157758202438639],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.582675327871977, 0.6605281429960126, 0.09236637303657957]"],
     
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[0.582675327871977, 0.6605281429960126, 0.09236637303657957]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.582675327871977, 0.6605281429960126, 0.09236637303657957],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.19881689163722216`, 0.5346044956131881, 0.9163669842512419], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.13254459442481478`, 0.35640299707545875`, 0.6109113228341613],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.19881689163722216, 0.5346044956131881, 0.9163669842512419]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.19881689163722216`, 0.5346044956131881, 0.9163669842512419]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.19881689163722216`, 0.5346044956131881, 0.9163669842512419],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.022810314175669255`, 0.7127079787867858, 0.6173020280281141], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.015206876117112838`, 0.4751386525245239, 0.41153468535207605`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.022810314175669255, 0.7127079787867858, \
0.6173020280281141]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.022810314175669255`, 0.7127079787867858, 0.6173020280281141]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.022810314175669255`, 0.7127079787867858, 0.6173020280281141],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.5843196164886222, 0.7226268478324285, 0.9778047909369658],
          RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.3895464109924148, 0.48175123188828567`, 0.6518698606246439],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.5843196164886222, 0.7226268478324285, 0.9778047909369658]"],
     
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[0.5843196164886222, 0.7226268478324285, 0.9778047909369658]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.5843196164886222, 0.7226268478324285, 0.9778047909369658],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.6165049575059962, 0.09063763378773193, 0.9587122011402291], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.4110033050039975, 0.06042508919182129, 0.6391414674268194],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.6165049575059962, 0.09063763378773193, 0.9587122011402291]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.6165049575059962, 0.09063763378773193, 0.9587122011402291]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.6165049575059962, 0.09063763378773193, 0.9587122011402291],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.5016727076470935, 0.11388377822625007`, 0.4827657809049324], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.334448471764729, 0.07592251881750005, 0.3218438539366216],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.5016727076470935, 0.11388377822625007, 0.4827657809049324]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.5016727076470935, 0.11388377822625007`, 0.4827657809049324]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.5016727076470935, 0.11388377822625007`, 0.4827657809049324],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.9529386355692835, 0.589134661831864, 0.8441262968948244], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6352924237128557, 0.3927564412212427, 0.5627508645965497],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.9529386355692835, 0.589134661831864, 0.8441262968948244]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[0.9529386355692835, 0.589134661831864, 0.8441262968948244]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.9529386355692835, 0.589134661831864, 0.8441262968948244],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.8184374251635835, 0.8085113784561468, 0.5297257284288377],
          RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.5456249501090558, 0.5390075856374312, 0.35315048561922513`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.8184374251635835, 0.8085113784561468, 0.5297257284288377]"],
     
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[0.8184374251635835, 0.8085113784561468, 0.5297257284288377]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.8184374251635835, 0.8085113784561468, 0.5297257284288377],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.5692428578689825, 0.3717192237058249, 0.8766070081349657],
          RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.3794952385793217, 0.24781281580388326`, 0.5844046720899772],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.5692428578689825, 0.3717192237058249, 0.8766070081349657]"],
     
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[0.5692428578689825, 0.3717192237058249, 0.8766070081349657]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.5692428578689825, 0.3717192237058249, 0.8766070081349657],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[
         0.12739040036471683`, 0.6951334724843365, 0.8453638593757753], 
         RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.08492693357647789, 0.4634223149895577, 0.5635759062505169],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.12739040036471683, 0.6951334724843365, 0.8453638593757753]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = 
         RGBColor[
          0.12739040036471683`, 0.6951334724843365, 0.8453638593757753]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.12739040036471683`, 0.6951334724843365, 0.8453638593757753],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[11]=",ExpressionUUID->"5872f65b-0081-4574-9f56-fe27e0aec8a4"]
}, Open  ]],

Cell["\<\
Blending together lots of random colors usually gives something muddy:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f354126a-b249-48eb-8bac-ce52148f5c1a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blend", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RandomColor", "[", "\[ThinSpace]", "]"}], ",", "20"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"c05de5ca-4585-4d59-9d6e-60068f624dc5"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[0.4366298640736129, 0.5579529340681736, 0.5921790959532055], 
       RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     Frame->True,
     FrameStyle->RGBColor[
      0.2910865760490753, 0.3719686227121157, 0.39478606396880367`],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 
        1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification])}],
     PlotRangePadding->None],
    "RGBColor[0.4366298640736129, 0.5579529340681736, 0.5921790959532055]"],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = 
       RGBColor[0.4366298640736129, 0.5579529340681736, 0.5921790959532055]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[0.4366298640736129, 0.5579529340681736, 0.5921790959532055],
  Editable->False,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"c1fb742f-cf80-4037-af82-92e834afe687"]
}, Open  ]],

Cell["\<\
You can use colors in all sorts of places. For example, you can style output \
with colors.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"d9909bbd-327d-4f14-8f49-95ba076a5aee"],

Cell["This gives the number 1000, styled in red:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3ef10e56-e3cd-4053-ad8b-02e4113bd880"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"1000", ",", "Red"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"07388704-3c83-4f58-a907-c2c3f85ad755"],

Cell[BoxData[
 StyleBox["1000",
  StripOnInput->False,
  FontColor->RGBColor[1, 0, 0],
  $CellContext`LineColor -> RGBColor[1, 0, 0],
  $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
  $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
  $CellContext`BackFaceColor -> RGBColor[1, 0, 0]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"4044ff09-5e86-4aa4-a292-71639694c8a1"]
}, Open  ]],

Cell["Here are 30 random integers, styled in random colors:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a69c58ab-eb14-4310-b34f-7cd8fe168b26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", "1000", "]"}], ",", 
     RowBox[{"RandomColor", "[", "\[ThinSpace]", "]"}]}], "]"}], ",", "30"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"0c1adda6-501f-4be7-bb80-fe03b1aec0ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["423",
    StripOnInput->False,
    FontColor->RGBColor[
     0.10690922571212624`, 0.016743568038997125`, 0.6885418527740617],
    $CellContext`LineColor -> 
    RGBColor[0.10690922571212624`, 0.016743568038997125`, 
      0.6885418527740617],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.10690922571212624`, 0.016743568038997125`, 
      0.6885418527740617],
    $CellContext`GraphicsColor -> 
    RGBColor[0.10690922571212624`, 0.016743568038997125`, 
      0.6885418527740617],
    $CellContext`BackFaceColor -> 
    RGBColor[0.10690922571212624`, 0.016743568038997125`, 0.6885418527740617]],
    ",", 
   StyleBox["803",
    StripOnInput->False,
    FontColor->RGBColor[
     0.5506410349458875, 0.9193411187164278, 0.6998850528420983],
    $CellContext`LineColor -> 
    RGBColor[0.5506410349458875, 0.9193411187164278, 0.6998850528420983],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.5506410349458875, 0.9193411187164278, 0.6998850528420983],
    $CellContext`GraphicsColor -> 
    RGBColor[0.5506410349458875, 0.9193411187164278, 0.6998850528420983],
    $CellContext`BackFaceColor -> 
    RGBColor[0.5506410349458875, 0.9193411187164278, 0.6998850528420983]], 
   ",", 
   StyleBox["10",
    StripOnInput->False,
    FontColor->RGBColor[
     0.6308573169524514, 0.4702276890659667, 0.5332607392904019],
    $CellContext`LineColor -> 
    RGBColor[0.6308573169524514, 0.4702276890659667, 0.5332607392904019],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.6308573169524514, 0.4702276890659667, 0.5332607392904019],
    $CellContext`GraphicsColor -> 
    RGBColor[0.6308573169524514, 0.4702276890659667, 0.5332607392904019],
    $CellContext`BackFaceColor -> 
    RGBColor[0.6308573169524514, 0.4702276890659667, 0.5332607392904019]], 
   ",", 
   StyleBox["432",
    StripOnInput->False,
    FontColor->RGBColor[
     0.9021652946848138, 0.3290112594060335, 0.12628858756132044`],
    $CellContext`LineColor -> 
    RGBColor[0.9021652946848138, 0.3290112594060335, 0.12628858756132044`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.9021652946848138, 0.3290112594060335, 0.12628858756132044`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.9021652946848138, 0.3290112594060335, 0.12628858756132044`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.9021652946848138, 0.3290112594060335, 0.12628858756132044`]], 
   ",", 
   StyleBox["139",
    StripOnInput->False,
    FontColor->RGBColor[
     0.7526530255651194, 0.7733930742820647, 0.27862465187865726`],
    $CellContext`LineColor -> 
    RGBColor[0.7526530255651194, 0.7733930742820647, 0.27862465187865726`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.7526530255651194, 0.7733930742820647, 0.27862465187865726`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.7526530255651194, 0.7733930742820647, 0.27862465187865726`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.7526530255651194, 0.7733930742820647, 0.27862465187865726`]], 
   ",", 
   StyleBox["188",
    StripOnInput->False,
    FontColor->RGBColor[
     0.6906338749699441, 0.19618850894190754`, 0.10826026365605013`],
    $CellContext`LineColor -> 
    RGBColor[0.6906338749699441, 0.19618850894190754`, 0.10826026365605013`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.6906338749699441, 0.19618850894190754`, 0.10826026365605013`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.6906338749699441, 0.19618850894190754`, 0.10826026365605013`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.6906338749699441, 0.19618850894190754`, 0.10826026365605013`]],
    ",", 
   StyleBox["34",
    StripOnInput->False,
    FontColor->RGBColor[
     0.4459178636316645, 0.38670780468295063`, 0.6935312566414404],
    $CellContext`LineColor -> 
    RGBColor[0.4459178636316645, 0.38670780468295063`, 0.6935312566414404],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.4459178636316645, 0.38670780468295063`, 0.6935312566414404],
    $CellContext`GraphicsColor -> 
    RGBColor[0.4459178636316645, 0.38670780468295063`, 0.6935312566414404],
    $CellContext`BackFaceColor -> 
    RGBColor[0.4459178636316645, 0.38670780468295063`, 0.6935312566414404]], 
   ",", 
   StyleBox["981",
    StripOnInput->False,
    FontColor->RGBColor[
     0.4633796221153621, 0.7159677572743612, 0.3231961442043467],
    $CellContext`LineColor -> 
    RGBColor[0.4633796221153621, 0.7159677572743612, 0.3231961442043467],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.4633796221153621, 0.7159677572743612, 0.3231961442043467],
    $CellContext`GraphicsColor -> 
    RGBColor[0.4633796221153621, 0.7159677572743612, 0.3231961442043467],
    $CellContext`BackFaceColor -> 
    RGBColor[0.4633796221153621, 0.7159677572743612, 0.3231961442043467]], 
   ",", 
   StyleBox["154",
    StripOnInput->False,
    FontColor->RGBColor[
     0.10432846118564254`, 0.9314598967944578, 0.8116568144800491],
    $CellContext`LineColor -> 
    RGBColor[0.10432846118564254`, 0.9314598967944578, 0.8116568144800491],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.10432846118564254`, 0.9314598967944578, 0.8116568144800491],
    $CellContext`GraphicsColor -> 
    RGBColor[0.10432846118564254`, 0.9314598967944578, 0.8116568144800491],
    $CellContext`BackFaceColor -> 
    RGBColor[0.10432846118564254`, 0.9314598967944578, 0.8116568144800491]], 
   ",", 
   StyleBox["340",
    StripOnInput->False,
    FontColor->RGBColor[
     0.5359063129864698, 0.8548066869795603, 0.20510378569736298`],
    $CellContext`LineColor -> 
    RGBColor[0.5359063129864698, 0.8548066869795603, 0.20510378569736298`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.5359063129864698, 0.8548066869795603, 0.20510378569736298`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.5359063129864698, 0.8548066869795603, 0.20510378569736298`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.5359063129864698, 0.8548066869795603, 0.20510378569736298`]], 
   ",", 
   StyleBox["533",
    StripOnInput->False,
    FontColor->RGBColor[
     0.1981605199100771, 0.969881338048717, 0.8041160063763324],
    $CellContext`LineColor -> 
    RGBColor[0.1981605199100771, 0.969881338048717, 0.8041160063763324],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.1981605199100771, 0.969881338048717, 0.8041160063763324],
    $CellContext`GraphicsColor -> 
    RGBColor[0.1981605199100771, 0.969881338048717, 0.8041160063763324],
    $CellContext`BackFaceColor -> 
    RGBColor[0.1981605199100771, 0.969881338048717, 0.8041160063763324]], ",", 
   StyleBox["52",
    StripOnInput->False,
    FontColor->RGBColor[
     0.08846794234511579, 0.9686482347893492, 0.6940095818881009],
    $CellContext`LineColor -> 
    RGBColor[0.08846794234511579, 0.9686482347893492, 0.6940095818881009],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.08846794234511579, 0.9686482347893492, 0.6940095818881009],
    $CellContext`GraphicsColor -> 
    RGBColor[0.08846794234511579, 0.9686482347893492, 0.6940095818881009],
    $CellContext`BackFaceColor -> 
    RGBColor[0.08846794234511579, 0.9686482347893492, 0.6940095818881009]], 
   ",", 
   StyleBox["313",
    StripOnInput->False,
    FontColor->RGBColor[
     0.10694637838180587`, 0.42693345957478757`, 0.4353556469030424],
    $CellContext`LineColor -> 
    RGBColor[0.10694637838180587`, 0.42693345957478757`, 0.4353556469030424],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.10694637838180587`, 0.42693345957478757`, 0.4353556469030424],
    $CellContext`GraphicsColor -> 
    RGBColor[0.10694637838180587`, 0.42693345957478757`, 0.4353556469030424],
    $CellContext`BackFaceColor -> 
    RGBColor[0.10694637838180587`, 0.42693345957478757`, 0.4353556469030424]],
    ",", 
   StyleBox["555",
    StripOnInput->False,
    FontColor->RGBColor[
     0.4879485442005187, 0.8278380605828715, 0.8607172312448239],
    $CellContext`LineColor -> 
    RGBColor[0.4879485442005187, 0.8278380605828715, 0.8607172312448239],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.4879485442005187, 0.8278380605828715, 0.8607172312448239],
    $CellContext`GraphicsColor -> 
    RGBColor[0.4879485442005187, 0.8278380605828715, 0.8607172312448239],
    $CellContext`BackFaceColor -> 
    RGBColor[0.4879485442005187, 0.8278380605828715, 0.8607172312448239]], 
   ",", 
   StyleBox["930",
    StripOnInput->False,
    FontColor->RGBColor[
     0.42468939677388273`, 0.5580554999791241, 0.8430769676273007],
    $CellContext`LineColor -> 
    RGBColor[0.42468939677388273`, 0.5580554999791241, 0.8430769676273007],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.42468939677388273`, 0.5580554999791241, 0.8430769676273007],
    $CellContext`GraphicsColor -> 
    RGBColor[0.42468939677388273`, 0.5580554999791241, 0.8430769676273007],
    $CellContext`BackFaceColor -> 
    RGBColor[0.42468939677388273`, 0.5580554999791241, 0.8430769676273007]], 
   ",", 
   StyleBox["332",
    StripOnInput->False,
    FontColor->RGBColor[
     0.24696390129101276`, 0.08438122627707889, 0.917347862375989],
    $CellContext`LineColor -> 
    RGBColor[0.24696390129101276`, 0.08438122627707889, 0.917347862375989],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.24696390129101276`, 0.08438122627707889, 0.917347862375989],
    $CellContext`GraphicsColor -> 
    RGBColor[0.24696390129101276`, 0.08438122627707889, 0.917347862375989],
    $CellContext`BackFaceColor -> 
    RGBColor[0.24696390129101276`, 0.08438122627707889, 0.917347862375989]], 
   ",", 
   StyleBox["582",
    StripOnInput->False,
    FontColor->RGBColor[
     0.29697787038295176`, 0.9443892512979792, 0.0741016902445748],
    $CellContext`LineColor -> 
    RGBColor[0.29697787038295176`, 0.9443892512979792, 0.0741016902445748],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.29697787038295176`, 0.9443892512979792, 0.0741016902445748],
    $CellContext`GraphicsColor -> 
    RGBColor[0.29697787038295176`, 0.9443892512979792, 0.0741016902445748],
    $CellContext`BackFaceColor -> 
    RGBColor[0.29697787038295176`, 0.9443892512979792, 0.0741016902445748]], 
   ",", 
   StyleBox["67",
    StripOnInput->False,
    FontColor->RGBColor[
     0.7510243349125649, 0.17731526513978912`, 0.0015489101983332532`],
    $CellContext`LineColor -> 
    RGBColor[0.7510243349125649, 0.17731526513978912`, 0.0015489101983332532`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.7510243349125649, 0.17731526513978912`, 0.0015489101983332532`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.7510243349125649, 0.17731526513978912`, 0.0015489101983332532`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.7510243349125649, 0.17731526513978912`, 
      0.0015489101983332532`]], ",", 
   StyleBox["385",
    StripOnInput->False,
    FontColor->RGBColor[
     0.39144529235108627`, 0.8660225262985721, 0.7129645355261855],
    $CellContext`LineColor -> 
    RGBColor[0.39144529235108627`, 0.8660225262985721, 0.7129645355261855],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.39144529235108627`, 0.8660225262985721, 0.7129645355261855],
    $CellContext`GraphicsColor -> 
    RGBColor[0.39144529235108627`, 0.8660225262985721, 0.7129645355261855],
    $CellContext`BackFaceColor -> 
    RGBColor[0.39144529235108627`, 0.8660225262985721, 0.7129645355261855]], 
   ",", 
   StyleBox["564",
    StripOnInput->False,
    FontColor->RGBColor[
     0.4552451346934543, 0.313763148114526, 0.7603317413628328],
    $CellContext`LineColor -> 
    RGBColor[0.4552451346934543, 0.313763148114526, 0.7603317413628328],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.4552451346934543, 0.313763148114526, 0.7603317413628328],
    $CellContext`GraphicsColor -> 
    RGBColor[0.4552451346934543, 0.313763148114526, 0.7603317413628328],
    $CellContext`BackFaceColor -> 
    RGBColor[0.4552451346934543, 0.313763148114526, 0.7603317413628328]], ",", 
   StyleBox["943",
    StripOnInput->False,
    FontColor->RGBColor[
     0.23382607790017773`, 0.33565469306845497`, 0.5291726853073107],
    $CellContext`LineColor -> 
    RGBColor[0.23382607790017773`, 0.33565469306845497`, 0.5291726853073107],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.23382607790017773`, 0.33565469306845497`, 0.5291726853073107],
    $CellContext`GraphicsColor -> 
    RGBColor[0.23382607790017773`, 0.33565469306845497`, 0.5291726853073107],
    $CellContext`BackFaceColor -> 
    RGBColor[0.23382607790017773`, 0.33565469306845497`, 0.5291726853073107]],
    ",", 
   StyleBox["987",
    StripOnInput->False,
    FontColor->RGBColor[
     0.6924743598526371, 0.1410032929333378, 0.8255037876291749],
    $CellContext`LineColor -> 
    RGBColor[0.6924743598526371, 0.1410032929333378, 0.8255037876291749],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.6924743598526371, 0.1410032929333378, 0.8255037876291749],
    $CellContext`GraphicsColor -> 
    RGBColor[0.6924743598526371, 0.1410032929333378, 0.8255037876291749],
    $CellContext`BackFaceColor -> 
    RGBColor[0.6924743598526371, 0.1410032929333378, 0.8255037876291749]], 
   ",", 
   StyleBox["179",
    StripOnInput->False,
    FontColor->RGBColor[
     0.10931213312378052`, 0.16897297688224944`, 0.638244501310292],
    $CellContext`LineColor -> 
    RGBColor[0.10931213312378052`, 0.16897297688224944`, 0.638244501310292],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.10931213312378052`, 0.16897297688224944`, 0.638244501310292],
    $CellContext`GraphicsColor -> 
    RGBColor[0.10931213312378052`, 0.16897297688224944`, 0.638244501310292],
    $CellContext`BackFaceColor -> 
    RGBColor[0.10931213312378052`, 0.16897297688224944`, 0.638244501310292]], 
   ",", 
   StyleBox["391",
    StripOnInput->False,
    FontColor->RGBColor[
     0.3974582551047101, 0.26220551119854907`, 0.22318859484695253`],
    $CellContext`LineColor -> 
    RGBColor[0.3974582551047101, 0.26220551119854907`, 0.22318859484695253`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.3974582551047101, 0.26220551119854907`, 0.22318859484695253`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.3974582551047101, 0.26220551119854907`, 0.22318859484695253`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.3974582551047101, 0.26220551119854907`, 0.22318859484695253`]],
    ",", 
   StyleBox["661",
    StripOnInput->False,
    FontColor->RGBColor[
     0.7939041839203007, 0.16612010022707646`, 0.491216668509711],
    $CellContext`LineColor -> 
    RGBColor[0.7939041839203007, 0.16612010022707646`, 0.491216668509711],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.7939041839203007, 0.16612010022707646`, 0.491216668509711],
    $CellContext`GraphicsColor -> 
    RGBColor[0.7939041839203007, 0.16612010022707646`, 0.491216668509711],
    $CellContext`BackFaceColor -> 
    RGBColor[0.7939041839203007, 0.16612010022707646`, 0.491216668509711]], 
   ",", 
   StyleBox["606",
    StripOnInput->False,
    FontColor->RGBColor[
     0.05583492577296956, 0.12725095783309692`, 0.481824346207373],
    $CellContext`LineColor -> 
    RGBColor[0.05583492577296956, 0.12725095783309692`, 0.481824346207373],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.05583492577296956, 0.12725095783309692`, 0.481824346207373],
    $CellContext`GraphicsColor -> 
    RGBColor[0.05583492577296956, 0.12725095783309692`, 0.481824346207373],
    $CellContext`BackFaceColor -> 
    RGBColor[0.05583492577296956, 0.12725095783309692`, 0.481824346207373]], 
   ",", 
   StyleBox["52",
    StripOnInput->False,
    FontColor->RGBColor[
     0.4632261086313889, 0.04741498429603941, 0.1784773097500023],
    $CellContext`LineColor -> 
    RGBColor[0.4632261086313889, 0.04741498429603941, 0.1784773097500023],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.4632261086313889, 0.04741498429603941, 0.1784773097500023],
    $CellContext`GraphicsColor -> 
    RGBColor[0.4632261086313889, 0.04741498429603941, 0.1784773097500023],
    $CellContext`BackFaceColor -> 
    RGBColor[0.4632261086313889, 0.04741498429603941, 0.1784773097500023]], 
   ",", 
   StyleBox["577",
    StripOnInput->False,
    FontColor->RGBColor[
     0.0449905136378177, 0.3868982330971851, 0.5936882260662804],
    $CellContext`LineColor -> 
    RGBColor[0.0449905136378177, 0.3868982330971851, 0.5936882260662804],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.0449905136378177, 0.3868982330971851, 0.5936882260662804],
    $CellContext`GraphicsColor -> 
    RGBColor[0.0449905136378177, 0.3868982330971851, 0.5936882260662804],
    $CellContext`BackFaceColor -> 
    RGBColor[0.0449905136378177, 0.3868982330971851, 0.5936882260662804]], 
   ",", 
   StyleBox["721",
    StripOnInput->False,
    FontColor->RGBColor[
     0.3256285870924007, 0.6086911909113208, 0.12473195611947707`],
    $CellContext`LineColor -> 
    RGBColor[0.3256285870924007, 0.6086911909113208, 0.12473195611947707`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.3256285870924007, 0.6086911909113208, 0.12473195611947707`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.3256285870924007, 0.6086911909113208, 0.12473195611947707`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.3256285870924007, 0.6086911909113208, 0.12473195611947707`]], 
   ",", 
   StyleBox["507",
    StripOnInput->False,
    FontColor->RGBColor[
     0.2928082896185329, 0.5334455678048242, 0.4922733306116587],
    $CellContext`LineColor -> 
    RGBColor[0.2928082896185329, 0.5334455678048242, 0.4922733306116587],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.2928082896185329, 0.5334455678048242, 0.4922733306116587],
    $CellContext`GraphicsColor -> 
    RGBColor[0.2928082896185329, 0.5334455678048242, 0.4922733306116587],
    $CellContext`BackFaceColor -> 
    RGBColor[0.2928082896185329, 0.5334455678048242, 0.4922733306116587]]}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[14]=",ExpressionUUID->"36752316-4a01-4923-a502-34ead54b2937"]
}, Open  ]],

Cell[TextData[{
 "Another form of styling is size. You can specify a font size in ",
 ButtonBox["Style",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:27", "i:9"},ExpressionUUID->"129a5fca-252c-45e8-a73b-15a9264d2b16"],

Cell["Show x styled in 30-point type:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1f97d816-a534-42be-99cc-a065efff85ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"x", ",", "30"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"204818e7-d0d9-44fa-83e6-f0f5ed83ea80"],

Cell[BoxData[
 StyleBox["x",
  StripOnInput->False,
  FontSize->30]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"e4e8912b-b471-48fc-b9f5-66b44b5be5fc"]
}, Open  ]],

Cell["This styles the number 100 in a sequence of different sizes:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"32afda03-21c4-4adc-a7c9-17db62d8b154"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"100", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "30"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"0e42edf1-442e-427c-902e-e832b3ed3cbd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["100",
    StripOnInput->False,
    FontSize->1], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->2], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->3], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->4], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->5], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->6], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->7], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->8], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->9], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->10], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->11], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->12], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->13], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->14], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->15], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->16], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->17], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->18], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->19], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->20], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->21], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->22], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->23], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->24], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->25], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->26], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->27], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->28], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->29], ",", 
   StyleBox["100",
    StripOnInput->False,
    FontSize->30]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[16]=",ExpressionUUID->"2630e2de-f415-459f-a0c8-1fef26307084"]
}, Open  ]],

Cell["\<\
You can combine color and size styling; here\[CloseCurlyQuote]s x in 25 \
random colors and sizes:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6f35a72c-5412-4923-9bb0-6e7a6f5452c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"x", ",", 
     RowBox[{"RandomColor", "[", "\[ThinSpace]", "]"}], ",", 
     RowBox[{"RandomInteger", "[", "30", "]"}]}], "]"}], ",", "25"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"e8fc0699-5716-49ea-98c8-740a39689712"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["x",
    StripOnInput->False,
    FontSize->25,
    FontColor->RGBColor[
     0.2722853760387498, 0.23407790725283628`, 0.938541547280948],
    $CellContext`LineColor -> 
    RGBColor[0.2722853760387498, 0.23407790725283628`, 0.938541547280948],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.2722853760387498, 0.23407790725283628`, 0.938541547280948],
    $CellContext`GraphicsColor -> 
    RGBColor[0.2722853760387498, 0.23407790725283628`, 0.938541547280948],
    $CellContext`BackFaceColor -> 
    RGBColor[0.2722853760387498, 0.23407790725283628`, 0.938541547280948]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->29,
    FontColor->RGBColor[
     0.31807568915419804`, 0.591082962391517, 0.8986277255592598],
    $CellContext`LineColor -> 
    RGBColor[0.31807568915419804`, 0.591082962391517, 0.8986277255592598],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.31807568915419804`, 0.591082962391517, 0.8986277255592598],
    $CellContext`GraphicsColor -> 
    RGBColor[0.31807568915419804`, 0.591082962391517, 0.8986277255592598],
    $CellContext`BackFaceColor -> 
    RGBColor[0.31807568915419804`, 0.591082962391517, 0.8986277255592598]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->2,
    FontColor->RGBColor[
     0.9066586249008046, 0.10113174014683879`, 0.9223005998733651],
    $CellContext`LineColor -> 
    RGBColor[0.9066586249008046, 0.10113174014683879`, 0.9223005998733651],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.9066586249008046, 0.10113174014683879`, 0.9223005998733651],
    $CellContext`GraphicsColor -> 
    RGBColor[0.9066586249008046, 0.10113174014683879`, 0.9223005998733651],
    $CellContext`BackFaceColor -> 
    RGBColor[0.9066586249008046, 0.10113174014683879`, 0.9223005998733651]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->15,
    FontColor->RGBColor[
     0.4149490894684944, 0.3846793823684307, 0.2158203436950903],
    $CellContext`LineColor -> 
    RGBColor[0.4149490894684944, 0.3846793823684307, 0.2158203436950903],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.4149490894684944, 0.3846793823684307, 0.2158203436950903],
    $CellContext`GraphicsColor -> 
    RGBColor[0.4149490894684944, 0.3846793823684307, 0.2158203436950903],
    $CellContext`BackFaceColor -> 
    RGBColor[0.4149490894684944, 0.3846793823684307, 0.2158203436950903]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->18,
    FontColor->RGBColor[
     0.036516181365000566`, 0.9936517643306366, 0.33422099320131604`],
    $CellContext`LineColor -> 
    RGBColor[0.036516181365000566`, 0.9936517643306366, 
      0.33422099320131604`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.036516181365000566`, 0.9936517643306366, 
      0.33422099320131604`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.036516181365000566`, 0.9936517643306366, 
      0.33422099320131604`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.036516181365000566`, 0.9936517643306366, 0.33422099320131604`]],
    ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->15,
    FontColor->RGBColor[
     0.6229366968118382, 0.5181406281197216, 0.3894974004259568],
    $CellContext`LineColor -> 
    RGBColor[0.6229366968118382, 0.5181406281197216, 0.3894974004259568],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.6229366968118382, 0.5181406281197216, 0.3894974004259568],
    $CellContext`GraphicsColor -> 
    RGBColor[0.6229366968118382, 0.5181406281197216, 0.3894974004259568],
    $CellContext`BackFaceColor -> 
    RGBColor[0.6229366968118382, 0.5181406281197216, 0.3894974004259568]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->23,
    FontColor->RGBColor[
     0.2786971047319251, 0.7945370622219281, 0.9930921851088963],
    $CellContext`LineColor -> 
    RGBColor[0.2786971047319251, 0.7945370622219281, 0.9930921851088963],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.2786971047319251, 0.7945370622219281, 0.9930921851088963],
    $CellContext`GraphicsColor -> 
    RGBColor[0.2786971047319251, 0.7945370622219281, 0.9930921851088963],
    $CellContext`BackFaceColor -> 
    RGBColor[0.2786971047319251, 0.7945370622219281, 0.9930921851088963]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->5,
    FontColor->RGBColor[
     0.4802624181215229, 0.6961218766554329, 0.30886061273046317`],
    $CellContext`LineColor -> 
    RGBColor[0.4802624181215229, 0.6961218766554329, 0.30886061273046317`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.4802624181215229, 0.6961218766554329, 0.30886061273046317`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.4802624181215229, 0.6961218766554329, 0.30886061273046317`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.4802624181215229, 0.6961218766554329, 0.30886061273046317`]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->15,
    FontColor->RGBColor[
     0.7218254490534988, 0.9513503345500671, 0.21368636106881245`],
    $CellContext`LineColor -> 
    RGBColor[0.7218254490534988, 0.9513503345500671, 0.21368636106881245`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.7218254490534988, 0.9513503345500671, 0.21368636106881245`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.7218254490534988, 0.9513503345500671, 0.21368636106881245`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.7218254490534988, 0.9513503345500671, 0.21368636106881245`]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->12,
    FontColor->RGBColor[
     0.3766196124066643, 0.5462096042591931, 0.47310742096756875`],
    $CellContext`LineColor -> 
    RGBColor[0.3766196124066643, 0.5462096042591931, 0.47310742096756875`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.3766196124066643, 0.5462096042591931, 0.47310742096756875`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.3766196124066643, 0.5462096042591931, 0.47310742096756875`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.3766196124066643, 0.5462096042591931, 0.47310742096756875`]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->23,
    FontColor->RGBColor[
     0.40108397757395764`, 0.014450432822551207`, 0.8811854539788859],
    $CellContext`LineColor -> 
    RGBColor[0.40108397757395764`, 0.014450432822551207`, 
      0.8811854539788859],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.40108397757395764`, 0.014450432822551207`, 
      0.8811854539788859],
    $CellContext`GraphicsColor -> 
    RGBColor[0.40108397757395764`, 0.014450432822551207`, 
      0.8811854539788859],
    $CellContext`BackFaceColor -> 
    RGBColor[0.40108397757395764`, 0.014450432822551207`, 0.8811854539788859]],
    ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->1,
    FontColor->RGBColor[
     0.5932758901076822, 0.39647670205065255`, 0.5047923149626607],
    $CellContext`LineColor -> 
    RGBColor[0.5932758901076822, 0.39647670205065255`, 0.5047923149626607],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.5932758901076822, 0.39647670205065255`, 0.5047923149626607],
    $CellContext`GraphicsColor -> 
    RGBColor[0.5932758901076822, 0.39647670205065255`, 0.5047923149626607],
    $CellContext`BackFaceColor -> 
    RGBColor[0.5932758901076822, 0.39647670205065255`, 0.5047923149626607]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->17,
    FontColor->RGBColor[
     0.12293435612299852`, 0.46170501326500024`, 0.4338406967374555],
    $CellContext`LineColor -> 
    RGBColor[0.12293435612299852`, 0.46170501326500024`, 0.4338406967374555],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.12293435612299852`, 0.46170501326500024`, 0.4338406967374555],
    $CellContext`GraphicsColor -> 
    RGBColor[0.12293435612299852`, 0.46170501326500024`, 0.4338406967374555],
    $CellContext`BackFaceColor -> 
    RGBColor[0.12293435612299852`, 0.46170501326500024`, 0.4338406967374555]],
    ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->3,
    FontColor->RGBColor[
     0.25916932396799064`, 0.0911840763657028, 0.2999633312584373],
    $CellContext`LineColor -> 
    RGBColor[0.25916932396799064`, 0.0911840763657028, 0.2999633312584373],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.25916932396799064`, 0.0911840763657028, 0.2999633312584373],
    $CellContext`GraphicsColor -> 
    RGBColor[0.25916932396799064`, 0.0911840763657028, 0.2999633312584373],
    $CellContext`BackFaceColor -> 
    RGBColor[0.25916932396799064`, 0.0911840763657028, 0.2999633312584373]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->28,
    FontColor->RGBColor[
     0.3858646609293881, 0.17573084235864012`, 0.8913737822072285],
    $CellContext`LineColor -> 
    RGBColor[0.3858646609293881, 0.17573084235864012`, 0.8913737822072285],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.3858646609293881, 0.17573084235864012`, 0.8913737822072285],
    $CellContext`GraphicsColor -> 
    RGBColor[0.3858646609293881, 0.17573084235864012`, 0.8913737822072285],
    $CellContext`BackFaceColor -> 
    RGBColor[0.3858646609293881, 0.17573084235864012`, 0.8913737822072285]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->5,
    FontColor->RGBColor[
     0.9841607210120655, 0.5287900315018841, 0.8869828101716386],
    $CellContext`LineColor -> 
    RGBColor[0.9841607210120655, 0.5287900315018841, 0.8869828101716386],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.9841607210120655, 0.5287900315018841, 0.8869828101716386],
    $CellContext`GraphicsColor -> 
    RGBColor[0.9841607210120655, 0.5287900315018841, 0.8869828101716386],
    $CellContext`BackFaceColor -> 
    RGBColor[0.9841607210120655, 0.5287900315018841, 0.8869828101716386]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->20,
    FontColor->RGBColor[
     0.44888858704734, 0.5768758869280619, 0.039544462933349234`],
    $CellContext`LineColor -> 
    RGBColor[0.44888858704734, 0.5768758869280619, 0.039544462933349234`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.44888858704734, 0.5768758869280619, 0.039544462933349234`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.44888858704734, 0.5768758869280619, 0.039544462933349234`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.44888858704734, 0.5768758869280619, 0.039544462933349234`]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->19,
    FontColor->RGBColor[
     0.9945064326801356, 0.6640905678480713, 0.7978645232292263],
    $CellContext`LineColor -> 
    RGBColor[0.9945064326801356, 0.6640905678480713, 0.7978645232292263],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.9945064326801356, 0.6640905678480713, 0.7978645232292263],
    $CellContext`GraphicsColor -> 
    RGBColor[0.9945064326801356, 0.6640905678480713, 0.7978645232292263],
    $CellContext`BackFaceColor -> 
    RGBColor[0.9945064326801356, 0.6640905678480713, 0.7978645232292263]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->19,
    FontColor->RGBColor[
     0.9209265349039779, 0.4732553500747274, 0.1296968831874039],
    $CellContext`LineColor -> 
    RGBColor[0.9209265349039779, 0.4732553500747274, 0.1296968831874039],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.9209265349039779, 0.4732553500747274, 0.1296968831874039],
    $CellContext`GraphicsColor -> 
    RGBColor[0.9209265349039779, 0.4732553500747274, 0.1296968831874039],
    $CellContext`BackFaceColor -> 
    RGBColor[0.9209265349039779, 0.4732553500747274, 0.1296968831874039]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->30,
    FontColor->RGBColor[
     0.6105386279874525, 0.3171231517006221, 0.88565315337973],
    $CellContext`LineColor -> 
    RGBColor[0.6105386279874525, 0.3171231517006221, 0.88565315337973],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.6105386279874525, 0.3171231517006221, 0.88565315337973],
    $CellContext`GraphicsColor -> 
    RGBColor[0.6105386279874525, 0.3171231517006221, 0.88565315337973],
    $CellContext`BackFaceColor -> 
    RGBColor[0.6105386279874525, 0.3171231517006221, 0.88565315337973]], ",", 
   
   StyleBox["x",
    StripOnInput->False,
    FontSize->10,
    FontColor->RGBColor[
     0.9717589781846703, 0.938363341433686, 0.5965375238052559],
    $CellContext`LineColor -> 
    RGBColor[0.9717589781846703, 0.938363341433686, 0.5965375238052559],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.9717589781846703, 0.938363341433686, 0.5965375238052559],
    $CellContext`GraphicsColor -> 
    RGBColor[0.9717589781846703, 0.938363341433686, 0.5965375238052559],
    $CellContext`BackFaceColor -> 
    RGBColor[0.9717589781846703, 0.938363341433686, 0.5965375238052559]], ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->27,
    FontColor->RGBColor[
     0.059744188626442485`, 0.26559037700905397`, 0.43460997082199326`],
    $CellContext`LineColor -> 
    RGBColor[0.059744188626442485`, 0.26559037700905397`, 
      0.43460997082199326`],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.059744188626442485`, 0.26559037700905397`, 
      0.43460997082199326`],
    $CellContext`GraphicsColor -> 
    RGBColor[0.059744188626442485`, 0.26559037700905397`, 
      0.43460997082199326`],
    $CellContext`BackFaceColor -> 
    RGBColor[0.059744188626442485`, 0.26559037700905397`, 
      0.43460997082199326`]], ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->23,
    FontColor->RGBColor[
     0.8020548061765378, 0.5161422582172426, 0.2942639618034526],
    $CellContext`LineColor -> 
    RGBColor[0.8020548061765378, 0.5161422582172426, 0.2942639618034526],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.8020548061765378, 0.5161422582172426, 0.2942639618034526],
    $CellContext`GraphicsColor -> 
    RGBColor[0.8020548061765378, 0.5161422582172426, 0.2942639618034526],
    $CellContext`BackFaceColor -> 
    RGBColor[0.8020548061765378, 0.5161422582172426, 0.2942639618034526]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->8,
    FontColor->RGBColor[
     0.2506740180873228, 0.8945164936463947, 0.6872501320220263],
    $CellContext`LineColor -> 
    RGBColor[0.2506740180873228, 0.8945164936463947, 0.6872501320220263],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.2506740180873228, 0.8945164936463947, 0.6872501320220263],
    $CellContext`GraphicsColor -> 
    RGBColor[0.2506740180873228, 0.8945164936463947, 0.6872501320220263],
    $CellContext`BackFaceColor -> 
    RGBColor[0.2506740180873228, 0.8945164936463947, 0.6872501320220263]], 
   ",", 
   StyleBox["x",
    StripOnInput->False,
    FontSize->0,
    FontColor->RGBColor[
     0.286957632939689, 0.6203123104691919, 0.7494266818175763],
    $CellContext`LineColor -> 
    RGBColor[0.286957632939689, 0.6203123104691919, 0.7494266818175763],
    $CellContext`FrontFaceColor -> 
    RGBColor[0.286957632939689, 0.6203123104691919, 0.7494266818175763],
    $CellContext`GraphicsColor -> 
    RGBColor[0.286957632939689, 0.6203123104691919, 0.7494266818175763],
    $CellContext`BackFaceColor -> 
    RGBColor[0.286957632939689, 0.6203123104691919, 0.7494266818175763]]}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"eda9a4b5-7fb2-4105-83ad-f9817b4380bc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"efcf59cd-fabb-421f-a07f-2b781c786c16"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Red",
      BaseStyle->"CodeLink"], ",", " ", 
     ButtonBox["Green",
      BaseStyle->"CodeLink"], ",", " ", 
     ButtonBox["Blue",
      BaseStyle->"CodeLink"], ",", " ", 
     ButtonBox["Yellow",
      BaseStyle->"CodeLink"], ",", " ", 
     ButtonBox["Orange",
      BaseStyle->"CodeLink"], ",", " ", 
     ButtonBox["Pink",
      BaseStyle->"CodeLink"], ",", " ", 
     ButtonBox["Purple",
      BaseStyle->"CodeLink"], ",", " ", 
     StyleBox["...", "GrayPointSix"]}], " ", Cell[
    "colors ", "VocabularyText",ExpressionUUID->
     "3b0c5056-aafc-428c-ba99-64b8ec98c0cf"]},
   {
    RowBox[{
     ButtonBox["RGBColor",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"0.4", ",", "0.7", ",", "0.3"}], "]"}], " ", Cell[
    "red, green, blue color ", "VocabularyText",ExpressionUUID->
     "f735cdd2-08b3-4f65-9b17-cadad5377092"]},
   {
    RowBox[{
     ButtonBox["Hue",
      BaseStyle->"CodeLink"], "[", "0.8", "]"}], " ", Cell[
    "color specified by hue ", "VocabularyText",ExpressionUUID->
     "c27ef9b4-ad88-48f5-ab1b-c4079802c4eb"]},
   {
    RowBox[{
     ButtonBox["RandomColor",
      BaseStyle->"CodeLink"], "[", " ", "]"}], " ", Cell[
    "randomly chosen color  ", "VocabularyText",ExpressionUUID->
     "bafbac90-e000-43d6-adb6-57b85322b7ae"]},
   {
    RowBox[{
     ButtonBox["ColorNegate",
      BaseStyle->"CodeLink"], "[", 
     ButtonBox["Red",
      BaseStyle->"CodeLink"], "]"}], " ", Cell[
    "negate a color (complement) ", "VocabularyText",ExpressionUUID->
     "ab6b669c-6dbc-4889-b43e-183a93419bb7"]},
   {
    RowBox[{
     ButtonBox["Blend",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       ButtonBox["Red",
        BaseStyle->"CodeLink"], ",", 
       ButtonBox["Blue",
        BaseStyle->"CodeLink"]}], "}"}], "]"}], " ", Cell[
    "blend a list of colors ", "VocabularyText",ExpressionUUID->
     "74958637-150b-496d-b32f-c7182ca1dea7"]},
   {
    RowBox[{
     ButtonBox["Style",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"x", ",", 
      ButtonBox["Red",
       BaseStyle->"CodeLink"]}], "]"}], " ", Cell[
    "style with a color ", "VocabularyText",ExpressionUUID->
     "6260489d-a143-4841-8ae4-7fe2c881ad5a"]},
   {
    RowBox[{
     ButtonBox["Style",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"x", ",", "20"}], "]"}], " ", Cell[
    "style with a size ", "VocabularyText",ExpressionUUID->
     "47219ba8-f4e6-4e6b-ad7c-5441348687fa"]},
   {
    RowBox[{
     ButtonBox["Style",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"x", ",", "20", ",", 
      ButtonBox["Red",
       BaseStyle->"CodeLink"]}], "]"}], " ", Cell[
    "style with a size and color ", "VocabularyText",ExpressionUUID->
     "c30b2abb-ebc3-4a2a-9cb0-704d5b740a33"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "Rows" -> {False, {True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True, True, True}, 
     False}}},ExpressionUUID->"18dd0761-5fd6-4da9-b1e5-a5550abfb563"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"135d2772-978f-41ac-9db0-1e4da93674a8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"14 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 9 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-07-colors-and-styles-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"39c501ec-349c-4444-b412-e430c45af179"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of red, yellow and green.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"0c9137b3-78c1-4d18-bfdd-f7c1a1004a1c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "cd28e2b2-4e01-4bc2-89bd-2e5be1e47a1f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False]}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f754dd3e-2102-4502-9d1c-04d9ed03b0c6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a red, yellow, green column (\[OpenCurlyDoubleQuote]traffic light\
\[CloseCurlyDoubleQuote]).",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"5b5322d4-897a-438b-88ac-bed379b70198"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0, 0],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.6666666666666666, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 1, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 1, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 1, 0],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[0, 1, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[0, 1, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[0, 1, 0],
            Editable->False,
            Selectable->False]}
         },
         DefaultBaseStyle->"Column",
         GridBoxAlignment->{"Columns" -> {{Left}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Column"]], "ExerciseOutput",ExpressionUUID->
       "3c1486d6-cd58-4c87-920e-dd6a7d96dfdc"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False]}}, 
           DefaultBaseStyle -> "Column", 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"29f2e483-7265-4989-95b5-06af69fe31e9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the negation of the color orange.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"03043613-57b5-429f-9dbd-218bd8b6cc16"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[0., 0.5, 1.], RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           Frame->True,
           FrameStyle->RGBColor[0., 0.33333333333333337`, 0.6666666666666667],
           
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 
              1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
               Magnification])}],
           PlotRangePadding->None],
          "RGBColor[0., 0.5, 1.]"],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[0., 0.5, 1.]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[0., 0.5, 1.],
        Editable->False,
        Selectable->False]], "ExerciseOutput",ExpressionUUID->
       "ab29c1f7-1696-4912-b55a-bb30142d5850"],
      Apply[TextCell, 
       Cell[
        BoxData[
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{{{{
                 GrayLevel[0], 
                 RectangleBox[{0, 0}]}}}, {{{
                 GrayLevel[0], 
                 RectangleBox[{1, -1}]}}}, {{{
                 RGBColor[0., 0.5, 1.], 
                 RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, Frame -> 
             True, FrameStyle -> 
             RGBColor[0., 0.33333333333333337`, 0.6666666666666667], 
             FrameTicks -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}], PlotRangePadding -> None], 
            "RGBColor[0., 0.5, 1.]"], Appearance -> None, BaseStyle -> {}, 
           BaselinePosition -> Baseline, ButtonFunction :> 
           With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0., 0.5, 1.]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle -> {}, Evaluator -> Automatic, Method -> 
           "Preemptive"], 
          RGBColor[0., 0.5, 1.], Editable -> False, Selectable -> False]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"48ea5fcf-6bd2-4bc1-8c28-0027ad8dcc06"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of colors with hues varying from 0 to 1 in steps of 0.02.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2cb49104-a8a6-4f77-b50a-51b9159a2213"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0., 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = Hue[0., 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.02], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.02, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.02]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.02, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.02],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.04], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.04, 1., 0.6666666666666667],
             FrameTicks->None,
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.04]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.04, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.04],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.06], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.05999999999999999, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.06]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.06, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.06],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.08], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.08, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.08]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.08, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.08],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.10000000000000002`, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.1, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.12], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.11999999999999998`, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.12]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.12, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.12],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.14], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.13999999999999999`, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.14]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.14, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.14],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.16], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.16, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.16]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.16, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.16],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.18], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.18000000000000002`, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.18]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.18, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.18],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.2], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.20000000000000004`, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.2]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.2, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.2],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.22], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.22, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.22]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.22, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.22],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.24], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.24, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.24]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.24, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.24],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.26], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.26, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.26]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.26, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.26],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.28], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.28, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.28]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.28, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.28],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.3], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.3, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.3]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.3, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.3],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.32], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.32, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.32]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.32, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.32],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.34], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.34, 1., 0.6666666666666667],
             FrameTicks->None,
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.34]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.34, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.34],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.36], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.36000000000000004`, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.36]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.36, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.36],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.38], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.38000000000000006`, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.38]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.38, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.38],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.4], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.4000000000000001, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.4]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.4, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.4],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.42], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.42, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.42]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.42, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.42],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.44], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.44, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.44]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.44, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.44],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.46], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.46, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.46]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.46, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.46],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.48], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.48, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.48]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.48, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.48],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.5], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.5, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.5]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.5, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.5],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.52], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.52, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.52]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.52, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.52],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.54], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.54, 1., 0.6666666666666667],
             FrameTicks->None,
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.54]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.54, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.54],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.56], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.56, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.56]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.56, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.56],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.58], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.58, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.58]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.58, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.58],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.6], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.6, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.6]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.6, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.6],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.62], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.62, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.62]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.62, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.62],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.64], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.64, 1., 0.6666666666666667],
             FrameTicks->None,
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.64]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.64, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.64],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.66], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.66, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.66]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.66, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.66],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.68], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.68, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.68]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.68, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.68],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.7000000000000001], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.7000000000000001, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.7000000000000001]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.7000000000000001, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.7000000000000001],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.72], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.7200000000000001, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.72]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.72, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.72],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.74], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.7399999999999999, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.74]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.74, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.74],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.76], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.7600000000000001, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.76]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.76, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.76],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.78], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.7799999999999999, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.78]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.78, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.78],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.8], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.8000000000000002, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.8]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.8, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.8],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.8200000000000001], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.82, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.8200000000000001]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.8200000000000001, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.8200000000000001],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.84], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.84, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.84]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.84, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.84],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.86], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.86, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.86]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.86, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.86],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.88], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.88, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.88]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.88, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.88],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.9], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.9, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.9]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.9, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.9],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.92], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.92, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.92]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.92, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.92],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.9400000000000001], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.9400000000000001, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.9400000000000001]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.9400000000000001, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.9400000000000001],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.96], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.96, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.96]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.96, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.96],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[0.98], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0.98, 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[0.98]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.98, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[0.98],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {Hue[1.], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->Hue[0., 1., 0.6666666666666667],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "Hue[1.]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = Hue[1., 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          Hue[1.],
          Editable->False,
          Selectable->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "5b3c9bb6-1045-4f40-8e3a-705acb37a70b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> Hue[0., 1., 0.6666666666666667],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], "Hue[0.]"], 
               Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0., 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.02], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.02, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.02]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.02, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.02], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.04], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.04, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.04]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.04, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.04], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.06], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.05999999999999999, 1., 0.6666666666666667], FrameTicks -> 
                 None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.06]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.06, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.06], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.08], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.08, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.08]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.08, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.08], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.10000000000000002`, 1., 0.6666666666666667], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], "Hue[0.1]"],
                Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.1, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.1], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.12], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.11999999999999998`, 1., 0.6666666666666667], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.12]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.12, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.12], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.14], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.13999999999999999`, 1., 0.6666666666666667], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.14]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.14, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.14], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.16], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.16, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.16]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.16, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.16], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.18], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.18000000000000002`, 1., 0.6666666666666667], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.18]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.18, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.18], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.2], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.20000000000000004`, 1., 0.6666666666666667], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], "Hue[0.2]"],
                Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.2, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.2], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.22], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.22, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.22]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.22, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.22], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.24], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.24, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.24]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.24, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.24], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.26], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.26, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.26]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.26, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.26], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.28], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.28, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.28]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.28, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.28], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.3], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.3, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], "Hue[0.3]"],
                Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.3, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.3], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.32], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.32, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.32]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.32, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.32], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.34], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.34, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.34]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.34, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.34], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.36], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.36000000000000004`, 1., 0.6666666666666667], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.36]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.36, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.36], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.38], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.38000000000000006`, 1., 0.6666666666666667], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.38]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.38, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.38], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.4], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.4000000000000001, 1., 0.6666666666666667], FrameTicks -> 
                 None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], "Hue[0.4]"],
                Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.4, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.4], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.42], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.42, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.42]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.42, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.42], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.44], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.44, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.44]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.44, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.44], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.46], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.46, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.46]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.46, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.46], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.48], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.48, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.48]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.48, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.48], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.5, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], "Hue[0.5]"],
                Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.5, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.5], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.52], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.52, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.52]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.52, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.52], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.54], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.54, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.54]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.54, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.54], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.56], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.56, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.56]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.56, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.56], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.58], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.58, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.58]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.58, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.58], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.6], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.6, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], "Hue[0.6]"],
                Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.6, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.6], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.62], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.62, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.62]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.62, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.62], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.64], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.64, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.64]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.64, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.64], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.66], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.66, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.66]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.66, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.66], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.68], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.68, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.68]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.68, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.68], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.7000000000000001], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.7000000000000001, 1., 0.6666666666666667], FrameTicks -> 
                 None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.7000000000000001]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.7000000000000001, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.7000000000000001], Editable -> False, Selectable -> 
              False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.72], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.7200000000000001, 1., 0.6666666666666667], FrameTicks -> 
                 None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.72]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.72, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.72], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.74], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.7399999999999999, 1., 0.6666666666666667], FrameTicks -> 
                 None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.74]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.74, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.74], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.76], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.7600000000000001, 1., 0.6666666666666667], FrameTicks -> 
                 None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.76]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.76, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.76], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.78], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.7799999999999999, 1., 0.6666666666666667], FrameTicks -> 
                 None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.78]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.78, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.78], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.8], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.8000000000000002, 1., 0.6666666666666667], FrameTicks -> 
                 None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], "Hue[0.8]"],
                Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.8, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.8], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.8200000000000001], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.82, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.8200000000000001]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.8200000000000001, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.8200000000000001], Editable -> False, Selectable -> 
              False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.84], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.84, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.84]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.84, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.84], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.86], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.86, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.86]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.86, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.86], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.88], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.88, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.88]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.88, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.88], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.9], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.9, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], "Hue[0.9]"],
                Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.9, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.9], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.92], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.92, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.92]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.92, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.92], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.9400000000000001], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.9400000000000001, 1., 0.6666666666666667], FrameTicks -> 
                 None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.9400000000000001]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.9400000000000001, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.9400000000000001], Editable -> False, Selectable -> 
              False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.96], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.96, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.96]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.96, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.96], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[0.98], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 Hue[0.98, 1., 0.6666666666666667], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "Hue[0.98]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.98, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.98], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    Hue[1.], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> Hue[0., 1., 0.6666666666666667],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], "Hue[1.]"], 
               Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[1., 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[1.], Editable -> False, Selectable -> False]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7087a5ae-433c-4ca4-b5b8-daa87885b856"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of colors with maximum red and blue, but with green varying \
from 0 to 1 in steps of 0.05.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b0b60892-b0f9-47b6-a42d-94574d6627c2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0., 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.6666666666666666],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0., 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0., 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0., 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.05, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.03333333333333334, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.05, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.05, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.05, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.1, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.06666666666666668, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.1, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.1, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.1, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.15000000000000002`, 1], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.10000000000000002`, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.15000000000000002, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.15000000000000002`, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.15000000000000002`, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.2, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.13333333333333336`, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.2, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.2, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.2, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.25, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.16666666666666669`, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.25, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.25, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.25, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.30000000000000004`, 1], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.20000000000000004`, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.30000000000000004, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.30000000000000004`, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.30000000000000004`, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.35000000000000003`, 1], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.23333333333333336`, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.35000000000000003, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.35000000000000003`, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.35000000000000003`, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.4, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.2666666666666667, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.4, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.4, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.4, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.45, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.30000000000000004`, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.45, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.45, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.45, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.5, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.33333333333333337`, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.5, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.5, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.5, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.55, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.3666666666666667, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.55, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.55, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.55, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.6000000000000001, 1], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.4000000000000001, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.6000000000000001, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.6000000000000001, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.6000000000000001, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.65, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.43333333333333335`, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.65, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.65, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.65, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.7000000000000001, 1], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.46666666666666673`, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.7000000000000001, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.7000000000000001, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.7000000000000001, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.75, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.5, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.75, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.75, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.75, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.8, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.5333333333333334, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.8, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.8, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.8, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.8500000000000001, 1], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.5666666666666668, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.8500000000000001, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.8500000000000001, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.8500000000000001, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.9, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.6000000000000001, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.9, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.9, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.9, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0.9500000000000001, 1], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.6333333333333334, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0.9500000000000001, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.9500000000000001, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0.9500000000000001, 1],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1., 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666666, 0.6666666666666667, 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1., 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 1., 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1., 1],
          Editable->False,
          Selectable->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "a73e0eb4-27a9-4669-9078-a6700cf5a0a4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0., 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.6666666666666666], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0., 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0., 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0., 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.05, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.03333333333333334, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.05, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.05, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.05, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.1, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.06666666666666668, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.1, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.1, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.1, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.15000000000000002`, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.10000000000000002`, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.15000000000000002, 1]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.15000000000000002`, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.15000000000000002`, 1], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.2, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.13333333333333336`, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.2, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.2, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.2, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.25, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.16666666666666669`, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.25, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.25, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.25, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.30000000000000004`, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.20000000000000004`, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.30000000000000004, 1]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.30000000000000004`, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.30000000000000004`, 1], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.35000000000000003`, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.23333333333333336`, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.35000000000000003, 1]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.35000000000000003`, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.35000000000000003`, 1], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.4, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.2666666666666667, 0.6666666666666666],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.4, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.4, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.4, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.45, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.30000000000000004`, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.45, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.45, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.45, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.33333333333333337`, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.5, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.5, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.5, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.55, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.3666666666666667, 0.6666666666666666],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.55, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.55, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.55, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.6000000000000001, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.4000000000000001, 0.6666666666666666],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.6000000000000001, 1]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.6000000000000001, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.6000000000000001, 1], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.65, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.43333333333333335`, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.65, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.65, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.65, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.7000000000000001, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.46666666666666673`, 
                   0.6666666666666666], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.7000000000000001, 1]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.7000000000000001, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.7000000000000001, 1], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.75, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.5, 0.6666666666666666], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.75, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.75, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.75, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.8, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.5333333333333334, 0.6666666666666666],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.8, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.8, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.8, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.8500000000000001, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.5666666666666668, 0.6666666666666666],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.8500000000000001, 1]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.8500000000000001, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.8500000000000001, 1], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.9, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.6000000000000001, 0.6666666666666666],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.9, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.9, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.9, 1], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.9500000000000001, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.6333333333333334, 0.6666666666666666],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0.9500000000000001, 1]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0.9500000000000001, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0.9500000000000001, 1], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1., 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666666, 0.6666666666666667, 0.6666666666666666],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1., 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1., 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1., 1], Editable -> False, Selectable -> False]}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8bb8b1e5-8215-4ba0-a4f7-2c0836558942"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Blend the colors pink and yellow.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9ffaacb2-ad02-41c3-9bdb-230b91d72ff2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{
            {GrayLevel[0], RectangleBox[{0, 0}]}, 
            {GrayLevel[0], RectangleBox[{1, -1}]}, 
            {RGBColor[1, 0.75, 0.25], RectangleBox[{0, -1}, {2, 1}]}},
           AspectRatio->1,
           Frame->True,
           FrameStyle->RGBColor[0.6666666666666666, 0.5, 0.16666666666666669`],
           FrameTicks->None,
           
           ImageSize->
            Dynamic[{
             Automatic, 
              1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
               Magnification])}],
           PlotRangePadding->None],
          "RGBColor[1, 0.75, 0.25]"],
         Appearance->None,
         BaseStyle->{},
         BaselinePosition->Baseline,
         ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[1, 0.75, 0.25]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
         DefaultBaseStyle->{},
         Evaluator->Automatic,
         Method->"Preemptive"],
        RGBColor[1, 0.75, 0.25],
        Editable->False,
        Selectable->False]], "ExerciseOutput",ExpressionUUID->
       "6e5214bf-396a-497c-855e-558a305aab46"],
      Apply[TextCell, 
       Cell[
        BoxData[
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{{{{
                 GrayLevel[0], 
                 RectangleBox[{0, 0}]}}}, {{{
                 GrayLevel[0], 
                 RectangleBox[{1, -1}]}}}, {{{
                 RGBColor[1, 0.75, 0.25], 
                 RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, Frame -> 
             True, FrameStyle -> 
             RGBColor[0.6666666666666666, 0.5, 0.16666666666666669`], 
             FrameTicks -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}], PlotRangePadding -> None], 
            "RGBColor[1, 0.75, 0.25]"], Appearance -> None, BaseStyle -> {}, 
           BaselinePosition -> Baseline, ButtonFunction :> 
           With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1, 0.75, 0.25]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle -> {}, Evaluator -> Automatic, Method -> 
           "Preemptive"], 
          RGBColor[1, 0.75, 0.25], Editable -> False, Selectable -> False]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7821da49-01bf-4a23-9289-a844b8b54cc5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of colors obtained by blending yellow with hues from 0 to 1 in \
steps of 0.05.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->{
  "p:28", "LastCellOfAPage"},ExpressionUUID->"552a524d-abfd-4d5b-8ea1-\
1453c2130d34"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1., 0.5, 0.], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666667, 0.33333333333333337`, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1., 0.5, 0.]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1., 0.5, 0.]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1., 0.5, 0.],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1., 0.65, 0.], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666667, 0.43333333333333335`, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1., 0.65, 0.]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1., 0.65, 0.]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1., 0.65, 0.],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1., 0.8, 0.], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666667, 0.5333333333333334, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1., 0.8, 0.]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1., 0.8, 0.]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1., 0.8, 0.],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1., 0.9500000000000001, 0.], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666667, 0.6333333333333334, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1., 0.9500000000000001, 0.]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1., 0.9500000000000001, 0.]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1., 0.9500000000000001, 0.],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.8999999999999999, 1., 0.], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6, 0.6666666666666667, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.8999999999999999, 1., 0.]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.8999999999999999, 1., 0.]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.8999999999999999, 1., 0.],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.75, 1., 0.], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.5, 0.6666666666666667, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.75, 1., 0.]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.75, 1., 0.]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.75, 1., 0.],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.5999999999999999, 1., 0.], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.3999999999999999, 0.6666666666666667, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.5999999999999999, 1., 0.]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.5999999999999999, 1., 0.]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.5999999999999999, 1., 0.],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.5, 1., 0.050000000000000044`], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.33333333333333337`, 0.6666666666666667, 0.03333333333333337],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.5, 1., 0.050000000000000044]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.5, 1., 0.050000000000000044`]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.5, 1., 0.050000000000000044`],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.5, 1., 0.20000000000000018`], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.33333333333333337`, 0.6666666666666667, 0.13333333333333347`],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.5, 1., 0.20000000000000018]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.5, 1., 0.20000000000000018`]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.5, 1., 0.20000000000000018`],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.5, 1., 0.3500000000000001], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.33333333333333337`, 0.6666666666666667, 0.2333333333333334],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.5, 1., 0.3500000000000001]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.5, 1., 0.3500000000000001]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.5, 1., 0.3500000000000001],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.5, 1., 0.5], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.33333333333333337`, 0.6666666666666667, 0.33333333333333337`],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.5, 1., 0.5]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.5, 1., 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.5, 1., 0.5],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.5, 0.8499999999999999, 0.5], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.33333333333333337`, 0.5666666666666667, 0.33333333333333337`],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.5, 0.8499999999999999, 0.5]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.5, 0.8499999999999999, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.5, 0.8499999999999999, 0.5],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.5, 0.6999999999999997, 0.5], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.33333333333333337`, 0.4666666666666665, 0.33333333333333337`],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.5, 0.6999999999999997, 0.5]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.5, 0.6999999999999997, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.5, 0.6999999999999997, 0.5],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.5, 0.5499999999999998, 0.5], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.33333333333333337`, 0.3666666666666666, 0.33333333333333337`],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.5, 0.5499999999999998, 0.5]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.5, 0.5499999999999998, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.5, 0.5499999999999998, 0.5],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.6000000000000001, 0.5, 0.5], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.4000000000000001, 0.33333333333333337`, 0.33333333333333337`],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.6000000000000001, 0.5, 0.5]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.6000000000000001, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.6000000000000001, 0.5, 0.5],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.75, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.5, 0.33333333333333337`, 0.33333333333333337`],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.75, 0.5, 0.5]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.75, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.75, 0.5, 0.5],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0.9000000000000004, 0.5, 0.5], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6000000000000003, 0.33333333333333337`, 0.33333333333333337`],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0.9000000000000004, 0.5, 0.5]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[0.9000000000000004, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0.9000000000000004, 0.5, 0.5],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1., 0.5, 0.44999999999999973`], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666667, 0.33333333333333337`, 0.2999999999999998],
             FrameTicks->None,
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1., 0.5, 0.44999999999999973]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1., 0.5, 0.44999999999999973`]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1., 0.5, 0.44999999999999973`],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1., 0.5, 0.2999999999999998], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666667, 0.33333333333333337`, 0.1999999999999999],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1., 0.5, 0.2999999999999998]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1., 0.5, 0.2999999999999998]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1., 0.5, 0.2999999999999998],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1., 0.5, 0.1499999999999999], 
               RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666667, 0.33333333333333337`, 0.09999999999999995],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1., 0.5, 0.1499999999999999]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1., 0.5, 0.1499999999999999]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1., 0.5, 0.1499999999999999],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1., 0.5, 0.], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             
             FrameStyle->RGBColor[
              0.6666666666666667, 0.33333333333333337`, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1., 0.5, 0.]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               RGBColor[1., 0.5, 0.]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1., 0.5, 0.],
          Editable->False,
          Selectable->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "7928e777-2664-4559-8f63-74b1456e8df6"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1., 0.5, 0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666667, 0.33333333333333337`, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1., 0.5, 0.]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1., 0.5, 0.]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1., 0.5, 0.], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1., 0.65, 0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666667, 0.43333333333333335`, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1., 0.65, 0.]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1., 0.65, 0.]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1., 0.65, 0.], Editable -> False, Selectable -> False],
              ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1., 0.8, 0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666667, 0.5333333333333334, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1., 0.8, 0.]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1., 0.8, 0.]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1., 0.8, 0.], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1., 0.9500000000000001, 0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666667, 0.6333333333333334, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1., 0.9500000000000001, 0.]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1., 0.9500000000000001, 0.]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1., 0.9500000000000001, 0.], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.8999999999999999, 1., 0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6, 0.6666666666666667, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.8999999999999999, 1., 0.]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.8999999999999999, 1., 0.]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.8999999999999999, 1., 0.], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.75, 1., 0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.5, 0.6666666666666667, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.75, 1., 0.]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.75, 1., 0.]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.75, 1., 0.], Editable -> False, Selectable -> False],
              ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.5999999999999999, 1., 0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.3999999999999999, 0.6666666666666667, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5999999999999999, 1., 0.]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.5999999999999999, 1., 0.]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.5999999999999999, 1., 0.], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.5, 1., 0.050000000000000044`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.33333333333333337`, 0.6666666666666667, 
                   0.03333333333333337], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5, 1., 0.050000000000000044]"], Appearance -> 
               None, BaseStyle -> {}, BaselinePosition -> Baseline, 
               ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.5, 1., 0.050000000000000044`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.5, 1., 0.050000000000000044`], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.5, 1., 0.20000000000000018`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.33333333333333337`, 0.6666666666666667, 
                   0.13333333333333347`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5, 1., 0.20000000000000018]"], Appearance -> None,
                BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.5, 1., 0.20000000000000018`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.5, 1., 0.20000000000000018`], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.5, 1., 0.3500000000000001], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.33333333333333337`, 0.6666666666666667, 
                   0.2333333333333334], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5, 1., 0.3500000000000001]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.5, 1., 0.3500000000000001]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.5, 1., 0.3500000000000001], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.5, 1., 0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.33333333333333337`, 0.6666666666666667, 
                   0.33333333333333337`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5, 1., 0.5]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.5, 1., 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.5, 1., 0.5], Editable -> False, Selectable -> False],
              ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.5, 0.8499999999999999, 0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.33333333333333337`, 0.5666666666666667, 
                   0.33333333333333337`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5, 0.8499999999999999, 0.5]"], Appearance -> None,
                BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.5, 0.8499999999999999, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.5, 0.8499999999999999, 0.5], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.5, 0.6999999999999997, 0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.33333333333333337`, 0.4666666666666665, 
                   0.33333333333333337`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5, 0.6999999999999997, 0.5]"], Appearance -> None,
                BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.5, 0.6999999999999997, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.5, 0.6999999999999997, 0.5], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.5, 0.5499999999999998, 0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.33333333333333337`, 0.3666666666666666, 
                   0.33333333333333337`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5, 0.5499999999999998, 0.5]"], Appearance -> None,
                BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.5, 0.5499999999999998, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.5, 0.5499999999999998, 0.5], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.6000000000000001, 0.5, 0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.4000000000000001, 0.33333333333333337`, 
                   0.33333333333333337`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6000000000000001, 0.5, 0.5]"], Appearance -> None,
                BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.6000000000000001, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.6000000000000001, 0.5, 0.5], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.75, 0.5, 0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.5, 0.33333333333333337`, 0.33333333333333337`], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.75, 0.5, 0.5]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.75, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.75, 0.5, 0.5], Editable -> False, Selectable -> 
              False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0.9000000000000004, 0.5, 0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6000000000000003, 0.33333333333333337`, 
                   0.33333333333333337`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.9000000000000004, 0.5, 0.5]"], Appearance -> None,
                BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0.9000000000000004, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0.9000000000000004, 0.5, 0.5], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1., 0.5, 0.44999999999999973`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666667, 0.33333333333333337`, 
                   0.2999999999999998], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1., 0.5, 0.44999999999999973]"], Appearance -> None,
                BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1., 0.5, 0.44999999999999973`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1., 0.5, 0.44999999999999973`], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1., 0.5, 0.2999999999999998], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666667, 0.33333333333333337`, 
                   0.1999999999999999], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1., 0.5, 0.2999999999999998]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1., 0.5, 0.2999999999999998]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1., 0.5, 0.2999999999999998], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1., 0.5, 0.1499999999999999], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[
                  0.6666666666666667, 0.33333333333333337`, 
                   0.09999999999999995], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1., 0.5, 0.1499999999999999]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1., 0.5, 0.1499999999999999]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1., 0.5, 0.1499999999999999], Editable -> False, 
              Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1., 0.5, 0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666667, 0.33333333333333337`, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1., 0.5, 0.]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1., 0.5, 0.]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1., 0.5, 0.], Editable -> False, Selectable -> 
              False]}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"714a74a1-832f-45ff-8e99-2c4ca3ebd17c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of numbers from 0 to 1 in steps of 0.1, each with a hue equal \
to its value.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"5d648784-3e00-4762-9c6e-399cc79e167b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         StyleBox["0.`",
          StripOnInput->False,
          FontColor->Hue[0.],
          $CellContext`LineColor -> Hue[0.],
          $CellContext`FrontFaceColor -> Hue[0.],
          $CellContext`GraphicsColor -> Hue[0.],
          $CellContext`BackFaceColor -> Hue[0.]], ",", 
         StyleBox["0.1`",
          StripOnInput->False,
          FontColor->Hue[0.1],
          $CellContext`LineColor -> Hue[0.1],
          $CellContext`FrontFaceColor -> Hue[0.1],
          $CellContext`GraphicsColor -> Hue[0.1],
          $CellContext`BackFaceColor -> Hue[0.1]], ",", 
         StyleBox["0.2`",
          StripOnInput->False,
          FontColor->Hue[0.2],
          $CellContext`LineColor -> Hue[0.2],
          $CellContext`FrontFaceColor -> Hue[0.2],
          $CellContext`GraphicsColor -> Hue[0.2],
          $CellContext`BackFaceColor -> Hue[0.2]], ",", 
         StyleBox["0.30000000000000004`",
          StripOnInput->False,
          FontColor->Hue[0.30000000000000004`],
          $CellContext`LineColor -> Hue[0.30000000000000004`],
          $CellContext`FrontFaceColor -> Hue[0.30000000000000004`],
          $CellContext`GraphicsColor -> Hue[0.30000000000000004`],
          $CellContext`BackFaceColor -> Hue[0.30000000000000004`]], ",", 
         StyleBox["0.4`",
          StripOnInput->False,
          FontColor->Hue[0.4],
          $CellContext`LineColor -> Hue[0.4],
          $CellContext`FrontFaceColor -> Hue[0.4],
          $CellContext`GraphicsColor -> Hue[0.4],
          $CellContext`BackFaceColor -> Hue[0.4]], ",", 
         StyleBox["0.5`",
          StripOnInput->False,
          FontColor->Hue[0.5],
          $CellContext`LineColor -> Hue[0.5],
          $CellContext`FrontFaceColor -> Hue[0.5],
          $CellContext`GraphicsColor -> Hue[0.5],
          $CellContext`BackFaceColor -> Hue[0.5]], ",", 
         StyleBox["0.6000000000000001`",
          StripOnInput->False,
          FontColor->Hue[0.6000000000000001],
          $CellContext`LineColor -> Hue[0.6000000000000001],
          $CellContext`FrontFaceColor -> Hue[0.6000000000000001],
          $CellContext`GraphicsColor -> Hue[0.6000000000000001],
          $CellContext`BackFaceColor -> Hue[0.6000000000000001]], ",", 
         StyleBox["0.7000000000000001`",
          StripOnInput->False,
          FontColor->Hue[0.7000000000000001],
          $CellContext`LineColor -> Hue[0.7000000000000001],
          $CellContext`FrontFaceColor -> Hue[0.7000000000000001],
          $CellContext`GraphicsColor -> Hue[0.7000000000000001],
          $CellContext`BackFaceColor -> Hue[0.7000000000000001]], ",", 
         StyleBox["0.8`",
          StripOnInput->False,
          FontColor->Hue[0.8],
          $CellContext`LineColor -> Hue[0.8],
          $CellContext`FrontFaceColor -> Hue[0.8],
          $CellContext`GraphicsColor -> Hue[0.8],
          $CellContext`BackFaceColor -> Hue[0.8]], ",", 
         StyleBox["0.9`",
          StripOnInput->False,
          FontColor->Hue[0.9],
          $CellContext`LineColor -> Hue[0.9],
          $CellContext`FrontFaceColor -> Hue[0.9],
          $CellContext`GraphicsColor -> Hue[0.9],
          $CellContext`BackFaceColor -> Hue[0.9]], ",", 
         StyleBox["1.`",
          StripOnInput->False,
          FontColor->Hue[1.],
          $CellContext`LineColor -> Hue[1.],
          $CellContext`FrontFaceColor -> Hue[1.],
          $CellContext`GraphicsColor -> Hue[1.],
          $CellContext`BackFaceColor -> Hue[1.]]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"40a3ae16-73a5-4c23-b815-e58434815c13"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             StyleBox[
             "0.`", StripOnInput -> False, $CellContext`LineColor -> 
              Hue[0.], $CellContext`FrontFaceColor -> 
              Hue[0.], $CellContext`GraphicsColor -> Hue[0.], FontColor -> 
              Hue[0.], $CellContext`BackFaceColor -> Hue[0.]], ",", 
             StyleBox[
             "0.1`", StripOnInput -> False, $CellContext`LineColor -> 
              Hue[0.1], $CellContext`FrontFaceColor -> 
              Hue[0.1], $CellContext`GraphicsColor -> Hue[0.1], FontColor -> 
              Hue[0.1], $CellContext`BackFaceColor -> Hue[0.1]], ",", 
             StyleBox[
             "0.2`", StripOnInput -> False, $CellContext`LineColor -> 
              Hue[0.2], $CellContext`FrontFaceColor -> 
              Hue[0.2], $CellContext`GraphicsColor -> Hue[0.2], FontColor -> 
              Hue[0.2], $CellContext`BackFaceColor -> Hue[0.2]], ",", 
             StyleBox[
             "0.30000000000000004`", StripOnInput -> 
              False, $CellContext`LineColor -> 
              Hue[0.30000000000000004`], $CellContext`FrontFaceColor -> 
              Hue[0.30000000000000004`], $CellContext`GraphicsColor -> 
              Hue[0.30000000000000004`], FontColor -> 
              Hue[0.30000000000000004`], $CellContext`BackFaceColor -> 
              Hue[0.30000000000000004`]], ",", 
             StyleBox[
             "0.4`", StripOnInput -> False, $CellContext`LineColor -> 
              Hue[0.4], $CellContext`FrontFaceColor -> 
              Hue[0.4], $CellContext`GraphicsColor -> Hue[0.4], FontColor -> 
              Hue[0.4], $CellContext`BackFaceColor -> Hue[0.4]], ",", 
             StyleBox[
             "0.5`", StripOnInput -> False, $CellContext`LineColor -> 
              Hue[0.5], $CellContext`FrontFaceColor -> 
              Hue[0.5], $CellContext`GraphicsColor -> Hue[0.5], FontColor -> 
              Hue[0.5], $CellContext`BackFaceColor -> Hue[0.5]], ",", 
             StyleBox[
             "0.6000000000000001`", StripOnInput -> 
              False, $CellContext`LineColor -> 
              Hue[0.6000000000000001], $CellContext`FrontFaceColor -> 
              Hue[0.6000000000000001], $CellContext`GraphicsColor -> 
              Hue[0.6000000000000001], FontColor -> 
              Hue[0.6000000000000001], $CellContext`BackFaceColor -> 
              Hue[0.6000000000000001]], ",", 
             StyleBox[
             "0.7000000000000001`", StripOnInput -> 
              False, $CellContext`LineColor -> 
              Hue[0.7000000000000001], $CellContext`FrontFaceColor -> 
              Hue[0.7000000000000001], $CellContext`GraphicsColor -> 
              Hue[0.7000000000000001], FontColor -> 
              Hue[0.7000000000000001], $CellContext`BackFaceColor -> 
              Hue[0.7000000000000001]], ",", 
             StyleBox[
             "0.8`", StripOnInput -> False, $CellContext`LineColor -> 
              Hue[0.8], $CellContext`FrontFaceColor -> 
              Hue[0.8], $CellContext`GraphicsColor -> Hue[0.8], FontColor -> 
              Hue[0.8], $CellContext`BackFaceColor -> Hue[0.8]], ",", 
             StyleBox[
             "0.9`", StripOnInput -> False, $CellContext`LineColor -> 
              Hue[0.9], $CellContext`FrontFaceColor -> 
              Hue[0.9], $CellContext`GraphicsColor -> Hue[0.9], FontColor -> 
              Hue[0.9], $CellContext`BackFaceColor -> Hue[0.9]], ",", 
             StyleBox[
             "1.`", StripOnInput -> False, $CellContext`LineColor -> 
              Hue[1.], $CellContext`FrontFaceColor -> 
              Hue[1.], $CellContext`GraphicsColor -> Hue[1.], FontColor -> 
              Hue[1.], $CellContext`BackFaceColor -> Hue[1.]]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b7032b77-a10c-4f9f-8aca-f67bcd637ede"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a purple color swatch of size 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d765d1be-2f25-4a3c-97be-c36cacb31a1f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       StyleBox[
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.5, 0, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.33333333333333337`, 0., 0.33333333333333337`],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[0.5, 0, 0.5]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.5, 0, 0.5]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.5, 0, 0.5],
         Editable->False,
         Selectable->False],
        StripOnInput->False,
        FontSize->100]], "ExerciseOutput",ExpressionUUID->
       "d047677e-be73-4454-8de3-64bbd245be04"],
      Apply[TextCell, 
       Cell[
        BoxData[
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{{{{
                  GrayLevel[0], 
                  RectangleBox[{0, 0}]}}}, {{{
                  GrayLevel[0], 
                  RectangleBox[{1, -1}]}}}, {{{
                  RGBColor[0.5, 0, 0.5], 
                  RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, Frame -> 
              True, FrameStyle -> 
              RGBColor[0.33333333333333337`, 0., 0.33333333333333337`], 
              FrameTicks -> None, ImageSize -> 
              Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], PlotRangePadding -> None], 
             "RGBColor[0.5, 0, 0.5]"], Appearance -> None, BaseStyle -> {}, 
            BaselinePosition -> Baseline, ButtonFunction :> 
            With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[0.5, 0, 0.5]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
            Automatic, Method -> "Preemptive"], 
           RGBColor[0.5, 0, 0.5], Editable -> False, Selectable -> False], 
          StripOnInput -> False, FontSize -> 100]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4d6b3ecc-7095-4587-8ba2-98bbccc3eaa9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of red swatches with sizes from 10 to 100 in steps of 10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1597c850-431d-4b8a-a44b-4a15a8b46247"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0, 0],
           Editable->False,
           Selectable->False],
          StripOnInput->False,
          FontSize->10], ",", 
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0, 0],
           Editable->False,
           Selectable->False],
          StripOnInput->False,
          FontSize->20], ",", 
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0, 0],
           Editable->False,
           Selectable->False],
          StripOnInput->False,
          FontSize->30], ",", 
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0, 0],
           Editable->False,
           Selectable->False],
          StripOnInput->False,
          FontSize->40], ",", 
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0, 0],
           Editable->False,
           Selectable->False],
          StripOnInput->False,
          FontSize->50], ",", 
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0, 0],
           Editable->False,
           Selectable->False],
          StripOnInput->False,
          FontSize->60], ",", 
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0, 0],
           Editable->False,
           Selectable->False],
          StripOnInput->False,
          FontSize->70], ",", 
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0, 0],
           Editable->False,
           Selectable->False],
          StripOnInput->False,
          FontSize->80], ",", 
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0, 0],
           Editable->False,
           Selectable->False],
          StripOnInput->False,
          FontSize->90], ",", 
         StyleBox[
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0, 0],
           Editable->False,
           Selectable->False],
          StripOnInput->False,
          FontSize->100]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "87e5f1f8-b4d8-4285-82c1-c66935d4d2e4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             StyleBox[
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                  Frame -> True, FrameStyle -> 
                  RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                  ImageSize -> 
                  Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                 "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, ButtonFunction :> 
                With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
              StripOnInput -> False, FontSize -> 10], ",", 
             StyleBox[
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                  Frame -> True, FrameStyle -> 
                  RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                  ImageSize -> 
                  Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                 "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, ButtonFunction :> 
                With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
              StripOnInput -> False, FontSize -> 20], ",", 
             StyleBox[
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                  Frame -> True, FrameStyle -> 
                  RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                  ImageSize -> 
                  Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                 "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, ButtonFunction :> 
                With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
              StripOnInput -> False, FontSize -> 30], ",", 
             StyleBox[
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                  Frame -> True, FrameStyle -> 
                  RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                  ImageSize -> 
                  Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                 "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, ButtonFunction :> 
                With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
              StripOnInput -> False, FontSize -> 40], ",", 
             StyleBox[
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                  Frame -> True, FrameStyle -> 
                  RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                  ImageSize -> 
                  Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                 "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, ButtonFunction :> 
                With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> A\
utomatic, Method -> "Preemptive"], 
               RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
              StripOnInput -> False, FontSize -> 50], ",", 
             StyleBox[
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                  Frame -> True, FrameStyle -> 
                  RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                  ImageSize -> 
                  Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                 "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, ButtonFunction :> 
                With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
              StripOnInput -> False, FontSize -> 60], ",", 
             StyleBox[
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                  Frame -> True, FrameStyle -> 
                  RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                  ImageSize -> 
                  Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                 "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, ButtonFunction :> 
                With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
              StripOnInput -> False, FontSize -> 70], ",", 
             StyleBox[
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                  Frame -> True, FrameStyle -> 
                  RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                  ImageSize -> 
                  Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                 "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, ButtonFunction :> 
                With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
              StripOnInput -> False, FontSize -> 80], ",", 
             StyleBox[
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                  Frame -> True, FrameStyle -> 
                  RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                  ImageSize -> 
                  Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                 "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, ButtonFunction :> 
                With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
              StripOnInput -> False, FontSize -> 90], ",", 
             StyleBox[
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                  Frame -> True, FrameStyle -> 
                  RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                  ImageSize -> 
                  Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                 "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, ButtonFunction :> 
                With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
              StripOnInput -> False, FontSize -> 100]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"47e915d1-c36a-44f7-af78-98e46d762b9e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Display the number 999 in red at size 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a516723f-ab1f-482d-ae84-9ca081866b36"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       StyleBox["999",
        StripOnInput->False,
        FontSize->100,
        FontColor->RGBColor[1, 0, 0],
        $CellContext`LineColor -> RGBColor[1, 0, 0],
        $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
        $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
        $CellContext`BackFaceColor -> RGBColor[1, 0, 0]]], "ExerciseOutput",
       ExpressionUUID->"4464061b-7d2b-4c80-b3b4-034552d0bcf9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         StyleBox[
         "999", StripOnInput -> False, $CellContext`LineColor -> 
          RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
          RGBColor[1, 0, 0], $CellContext`GraphicsColor -> RGBColor[1, 0, 0], 
          FontSize -> 100, FontColor -> 
          RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
          RGBColor[1, 0, 0]]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"47c4c762-bdbf-4c0b-8be9-80fc7638eceb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the first 10 squares, in which each value is styled at its \
size.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d83541dd-15a4-4f0b-bb66-7907f3181f15"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         StyleBox["1",
          StripOnInput->False,
          FontSize->1], ",", 
         StyleBox["4",
          StripOnInput->False,
          FontSize->4], ",", 
         StyleBox["9",
          StripOnInput->False,
          FontSize->9], ",", 
         StyleBox["16",
          StripOnInput->False,
          FontSize->16], ",", 
         StyleBox["25",
          StripOnInput->False,
          FontSize->25], ",", 
         StyleBox["36",
          StripOnInput->False,
          FontSize->36], ",", 
         StyleBox["49",
          StripOnInput->False,
          FontSize->49], ",", 
         StyleBox["64",
          StripOnInput->False,
          FontSize->64], ",", 
         StyleBox["81",
          StripOnInput->False,
          FontSize->81], ",", 
         StyleBox["100",
          StripOnInput->False,
          FontSize->100]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "b1a46121-7a1b-44b8-9ed6-089ba3045ad4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             StyleBox["1", StripOnInput -> False, FontSize -> 1], ",", 
             StyleBox["4", StripOnInput -> False, FontSize -> 4], ",", 
             StyleBox["9", StripOnInput -> False, FontSize -> 9], ",", 
             StyleBox["16", StripOnInput -> False, FontSize -> 16], ",", 
             StyleBox["25", StripOnInput -> False, FontSize -> 25], ",", 
             StyleBox["36", StripOnInput -> False, FontSize -> 36], ",", 
             StyleBox["49", StripOnInput -> False, FontSize -> 49], ",", 
             StyleBox["64", StripOnInput -> False, FontSize -> 64], ",", 
             StyleBox["81", StripOnInput -> False, FontSize -> 81], ",", 
             StyleBox["100", StripOnInput -> False, FontSize -> 100]}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f2d0e88a-3af9-43b9-862d-c5c751550378"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Part",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["RandomInteger",
  BaseStyle->"Link"],
 " to make a length-100 list in which each element is randomly ",
 ButtonBox["Red",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Yellow",
  BaseStyle->"Link"],
 " or ",
 ButtonBox["Green",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"12bfc92f-0be7-42d9-a93c-d6f03a8a046d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "3d3f9815-ed13-477f-9a68-217f00c5a5f0"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0., 0.6666666666666666, 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
        