(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    514572,      10498]
NotebookOptionsPosition[    436365,       8979]
NotebookOutlinePosition[    497040,      10209]
CellTagsIndexPosition[    496960,      10204]
WindowTitle->Making Tables: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Make a list in which the number 1000 is repeated 5 times.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmC2P20AQhlctKazUX9A/YFy6sCjSVWUhd2r2VJJGd5WqUDNDMzMjI5cY
GZkEmZgsWWJgEhJgsGTBgnTGH+c7KUmdVE1SdV7J0e67m31iZeSZ8fu7bzfi
FWPs8Q183Nz+4A8Pt8tPb2Hyef749X4++/Jx/n12P3v4cPcazHdw/YQLx1sS
iUQikUgkVJ16wnEW0rRTXUpZaTus280qjaM4kWtzirlbRLkgRUeC86mbb7rT
tAygOBResrbbMl6yRl5e99+vPM56OUlpjjR3iCiXpliVhlOYeHl7li58xvxu
dxa5iwlsDYqOtc6QHpcQMBWORGKPMXeKKNdAUeGEOX57nJEYA3oAKoD5Hcsm
C8Z40K6qCGJHKDPe3HNLRLkCigw4czq/BL+PB5Qp+MDSgcO4X3QrmDV4rseb
+2+IKJemqOZ/h2FdZhgmfV7YweLDCU3lwAs93hx9R0Q5O8WWMRYYifKaOiGr
97P+kagmyvEUA0sgWysXBm42sKzEvCPbfTbFx0TYpqkyEphN7Hhz/x0R5dIU
o0IIgDBfox9DndDWAwY6ULnCpWW0UhK7ybZzdBO5KTPsJtzVdnuECV3IEuLQ
TZ8VO0S5AkpXBwYtZegLTDFhL+Q3maMIRTef+FUfqGNNI6eYbZ71HUS5BsrL
vqB5P+AdSET4K3Rd19qeZOJzpmcdFlHOSVFYLHaUNi9wEVQHktGpWmM2YpGs
f7+VKOejmDzE10VPtSI6kSeEe/AFxanSm2rzN84lyp/IpN5i4YblmGcNiUT6
D/QL+K3VKQ==
            "], {{0, 19}, {172, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{172, 19},
          PlotRange->{{0, 172}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{176, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmC2P20AQhlctKazUX9A/YFy6sCjSVWUhd2r2VJJGd5WqUDNDMzMjI5cY
GZkEmZgsWWJgEhJgsGTBgnTGH+c7KUmdVE1SdV7J0e67m31iZeSZ8fu7bzfi
FWPs8Q183Nz+4A8Pt8tPb2Hyef749X4++/Jx/n12P3v4cPcazHdw/YQLx1sS
iUQikUgkVJ16wnEW0rRTXUpZaTus280qjaM4kWtzirlbRLkgRUeC86mbb7rT
tAygOBResrbbMl6yRl5e99+vPM56OUlpjjR3iCiXpliVhlOYeHl7li58xvxu
dxa5iwlsDYqOtc6QHpcQMBWORGKPMXeKKNdAUeGEOX57nJEYA3oAKoD5Hcsm
C8Z40K6qCGJHKDPe3HNLRLkCigw4czq/BL+PB5Qp+MDSgcO4X3QrmDV4rseb
+2+IKJemqOZ/h2FdZhgmfV7YweLDCU3lwAs93hx9R0Q5O8WWMRYYifKaOiGr
97P+kagmyvEUA0sgWysXBm42sKzEvCPbfTbFx0TYpqkyEphN7Hhz/x0R5dIU
o0IIgDBfox9DndDWAwY6ULnCpWW0UhK7ybZzdBO5KTPsJtzVdnuECV3IEuLQ
TZ8VO0S5AkpXBwYtZegLTDFhL+Q3maMIRTef+FUfqGNNI6eYbZ71HUS5BsrL
vqB5P+AdSET4K3Rd19qeZOJzpmcdFlHOSVFYLHaUNi9wEVQHktGpWmM2YpGs
f7+VKOejmDzE10VPtSI6kSeEe/AFxanSm2rzN84lyp/IpN5i4YblmGcNiUT6
D/QL+K3VKQ==
              "], {{0, 19}, {172, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {172, 19}, 
            PlotRange -> {{0, 172}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["6.1"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d5196d5c-047e-4a4b-bd77-58ed6dd27c40"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell[TextData[{
 "Make a table of the values of ",
 Cell[BoxData[
  RowBox[{"n", "^", "3"}]], "InlineCode"],
 " for ",
 Cell[BoxData["n"], "InlineCode"],
 " from 10 to 20."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztW7+rvcgVN0mTMpC/IP+A9baWqYRd0t1ml3xd0nxXvhvYtbWztLOzsjKN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            "], {{0, 19}, {
            376, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{376, 19},
          PlotRange->{{0, 376}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{380, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztW7+rvcgVN0mTMpC/IP+A9baWqYRd0t1ml3xd0nxXvhvYtbWztLOzsjKN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              "], {{0, 19}, {
              376, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {376, 19}, 
            PlotRange -> {{0, 376}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["6.2"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5025bd79-9c70-452e-9d02-e189708aad99"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["Make a number line plot of the first 20 squares.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmjGP2zYUx9126div0ClfoWvGrim6FkiQY1qgYIFLwaKDhgLenBtu8qJJ
QKLJi4B48eJBHXyBBi4aDNSDEPjgwYMABSAQXdxHSb46ku+gylJsBv8fLj6K
enzmH+/xSeTl2ye/PWJf9nq951/Tx6PHfzw8P3/85w/f0MWP/Pkvz/jZ0+/5
72fPzs6/e/IVdT6gfz9/0evp9gYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKhw
c/Ph9d//vHh5dfHq6uLlFbXfv7+hz4tXb+iT7uYGt5e7o+p0lr7orrt1DGra
1DdrYNx4SONRhwxsZXgrHtr1066rjhx25PNEIEU//fV694cKyG2b7u4aULs6
6v7OvV9UvVvHoKZNfbMGxo2HNB51yMBWhrfioV0/7brqyGFHPk8EKoaluvHr
i8lODXmza0Dt6qj7O/d+UfVuHYOaNvXNGhg3HtJ41CEDWxneiod2/bTrqiOH
Hfk8EfC+gfeNT+ChXT/tuurIYUc+TwScb+B84xN4aNdPu646ctiRTwAAAAAA
AAAAAAAAAAAAANA6jLEujLuwNMstJoAJHH0Cp+C2ozkcfQIducUEMIGjT6At
twwAAP4P9WsUAAAAAAAAAAAAAAAAgPqoyLeyY1jL9tWxJ3Mgc68vHJm3I9/O
j5dtP9LXKnJEdi3syBydq2DEcxl9N5u28u0iXNMo0RZG6kqld5nLcvyl7qio
MDgtVWgxSyZ5u6yrnJamErucDSl2akl6nDA+9nwakwRuX6fZKNRXcSAY95dK
LX3OBAVROoIPKQNp3XHuhMeebU0ikuTKNenxKBe9RSwdyril2iwp/bhL0TJR
V7qcMMaDdaqWU1pRoaqqMDct1VinoQizulHWVUlLU0kkzwJHzF3Btg9r40jm
I2vgUuUQrl47SUjry82fx/TAduS1q9NPd6g5NV0zEjFd+5PZOmvKIQmQobMt
DmlIGSiTxEhdySqc69eMbPlYoaqoMDYtF1Q1rOFA9LOaUNZ1XU5LM8K1h0Ra
3M4zM5a2sI0J0F4WI5EvK6obYhjkndK2bPnWFWKWRykJBDdkfW1ZBZR1fLZK
Q8caFoUkdrgVJLG5uhbjbKtiefGmosLMtFTRmLHL1Sb1hCV10Svrui6npUHh
+phECrYNUDA0JUB3EbrbuiEdPpzlnZmstw7fRjCekZE5AVPZ/suiorHJ3nu3
dWNtM0F1w1BdafFb70f2RMfItNRvF6zvTCYji/FLd7JS5ehcl9PSlHBVWVLR
9xZK78toBz1eHHs+B3FbNzYr2jj35yQrXdCqG0fv/IE+H9gUb5JjQ47a1JTC
I5zsSC1N083Kv2TCU8Wjrb9IUxN1ZS/teVlYO9nxRUWFiWmZRmEwm82C2XRA
u8mJjKvRKaelEeHaTxx6xf9r73vrY0/mQOYj6/ZsMPQGhazipDQsrtnAlDKf
FYf/sPTRTewNij+wjMIsXAbqoklPh6IQZU/1fr+iwuS0VCPRl3lJqOgqp6XR
pCpJDC59d5HJSnc7kiRJ7zQ3hrIsM3XpSd8fnc8kLcu6KmkJAAAAAAAAAJ8/
/wIydO+L
            "], {{0, 39}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 39},
          PlotRange->{{0, 360}, {0, 39}}]], "ExerciseOutput",
         ImageSize->{364, 39},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmjGP2zYUx9126div0ClfoWvGrim6FkiQY1qgYIFLwaKDhgLenBtu8qJJ
QKLJi4B48eJBHXyBBi4aDNSDEPjgwYMABSAQXdxHSb46ku+gylJsBv8fLj6K
enzmH+/xSeTl2ye/PWJf9nq951/Tx6PHfzw8P3/85w/f0MWP/Pkvz/jZ0+/5
72fPzs6/e/IVdT6gfz9/0evp9gYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKhw
c/Ph9d//vHh5dfHq6uLlFbXfv7+hz4tXb+iT7uYGt5e7o+p0lr7orrt1DGra
1DdrYNx4SONRhwxsZXgrHtr1066rjhx25PNEIEU//fV694cKyG2b7u4aULs6
6v7OvV9UvVvHoKZNfbMGxo2HNB51yMBWhrfioV0/7brqyGFHPk8EKoaluvHr
i8lODXmza0Dt6qj7O/d+UfVuHYOaNvXNGhg3HtJ41CEDWxneiod2/bTrqiOH
Hfk8EfC+gfeNT+ChXT/tuurIYUc+TwScb+B84xN4aNdPu646ctiRTwAAAAAA
AAAAAAAAAAAAANA6jLEujLuwNMstJoAJHH0Cp+C2ozkcfQIducUEMIGjT6At
twwAAP4P9WsUAAAAAAAAAAAAAAAAgPqoyLeyY1jL9tWxJ3Mgc68vHJm3I9/O
j5dtP9LXKnJEdi3syBydq2DEcxl9N5u28u0iXNMo0RZG6kqld5nLcvyl7qio
MDgtVWgxSyZ5u6yrnJamErucDSl2akl6nDA+9nwakwRuX6fZKNRXcSAY95dK
LX3OBAVROoIPKQNp3XHuhMeebU0ikuTKNenxKBe9RSwdyril2iwp/bhL0TJR
V7qcMMaDdaqWU1pRoaqqMDct1VinoQizulHWVUlLU0kkzwJHzF3Btg9r40jm
I2vgUuUQrl47SUjry82fx/TAduS1q9NPd6g5NV0zEjFd+5PZOmvKIQmQobMt
DmlIGSiTxEhdySqc69eMbPlYoaqoMDYtF1Q1rOFA9LOaUNZ1XU5LM8K1h0Ra
3M4zM5a2sI0J0F4WI5EvK6obYhjkndK2bPnWFWKWRykJBDdkfW1ZBZR1fLZK
Q8caFoUkdrgVJLG5uhbjbKtiefGmosLMtFTRmLHL1Sb1hCV10Svrui6npUHh
+phECrYNUDA0JUB3EbrbuiEdPpzlnZmstw7fRjCekZE5AVPZ/suiorHJ3nu3
dWNtM0F1w1BdafFb70f2RMfItNRvF6zvTCYji/FLd7JS5ehcl9PSlHBVWVLR
9xZK78toBz1eHHs+B3FbNzYr2jj35yQrXdCqG0fv/IE+H9gUb5JjQ47a1JTC
I5zsSC1N083Kv2TCU8Wjrb9IUxN1ZS/teVlYO9nxRUWFiWmZRmEwm82C2XRA
u8mJjKvRKaelEeHaTxx6xf9r73vrY0/mQOYj6/ZsMPQGhazipDQsrtnAlDKf
FYf/sPTRTewNij+wjMIsXAbqoklPh6IQZU/1fr+iwuS0VCPRl3lJqOgqp6XR
pCpJDC59d5HJSnc7kiRJ7zQ3hrIsM3XpSd8fnc8kLcu6KmkJAAAAAAAAAJ8/
/wIydO+L
              "], {{0, 39}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 39}, 
            PlotRange -> {{0, 360}, {0, 39}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["6.3"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2fdaa873-b859-4828-81bb-5001e21a3ad5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell[TextData[{
 "Make a list of the even numbers (2, 4, 6, ",
 StyleBox["...", "GrayPointSix"],
 ") up to 20."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWa+v5DYQjlpSWKl/Qf+B4NLAokhXlS25Uy+nkmt0V6kKDTMMCwsKinRS
UFBIUEhUyaAmBlGlkACDEAODV4+d3ctubO++u6onVRlpn3az/jy/Ps+M933/
6rcX0Vee573/Rv558fKP4N27l8lP38oPP799/+ubt69/+fHt76/fvH73w6uv
5cPv5OuDfMH7p0MOOeSQQw455BCXsAZFvh9j/vS0TH1TV1Xdk/kRIBmGkXHH
CsHGTm5YN2R2LZtwL7U2PXEtAlkoxuMiNgrmrqnKqsbTPegOy0bcVNLXdmTC
ATPrXZXTYSC7x/exMxka0Dzc07z3lw0dQGXcnThTHm9jtZRREJzSfl73X3Au
R8cI1X/9WfkeiP4bV8RtZZ+FsBj1VnNI6W2kNOeZtyiQ3wZhoLTWtozSKtH7
oP4ShFFBtfg1tZJhjx2KSIG0r0E7WVNi0rtqT9UW/WKDmrF9ftpEJaEWzQYs
J+qRr0OVtqMRyLAxj/tYCdIUp00GlyHzvEx+QUv5GE3qWQlxQo66wGmlNw3z
wbKEZYHyFPLDKpSbibD0ATgFalmfOQI7tmUaA/fyYY3M1EJgKgjlCO+i2pbO
HZYXwdly1ku3g8zmhUGvlmFNaDjYmWDATg1gUCdNFVOH8u5hm3WmAs0LcN3P
jHXBmEdbrEgRXvbhGJigvFnYuRCxHoFSq48TkoQLTiffGkMx1YrP9jCd3ZNM
SDpli8CB84hJw2VosjUyoo6lDbleTsD9yNldttgnsVy62pI5mbDHAlwdhDBJ
JKHuuXiFpZXMzYncbUcmrGJCqo/nDJk1M8GUR2uscC5Dvj4HCu3YNcB5TieL
fRiKiteMUwmEMsdQmR12RFagoigbYu2Is6pQUUvGHip2MjqixIE258gs+YaH
HHqcg7o32K1MqWf1woKd4SD42bzg0K30Fiua2PNlWSdtkedV4ygnBr1iauTH
IC7phGWpD1DnRj99zKM1VkRlX75ltAWyXPd6McJxjkrznKC/TRqgiayxQW5e
pscP2CdJT77qxZZmMwJfVwlL6nLshgnBR++UusAVWQsTFKv9xj4n7LEKokuB
LGIBdh/wG5vD1dEkVV6HhWvyu7V5KTa93hbPi2zyaI2VLm6oJkjvubVG9U3v
VFqCuhTKlxhlWZaGelIwjS6aCfV6wmkMTmODr6SAYRLPYqFlEm4gdyPzL9SE
qYUAJLWTftdYHV7pTZZnSGUzSlA72tvSjr0yN+uHZ9rcpb4c7ygXM2liKErW
og1ylUdHrHiuJkvBiNxeTmwrfO5hxAgyO914V+ZZnmcgKPQVrTsDE5Q6vzu3
OKnOWIGHTJpYnHPPkLtlCwx9E2sfoNJKrM4BhdkocvXfKyzIqGgQmfjpwIp5
kM7nOgJoZULnYMK1XijXQa5Xi7G6w4QrLJOhutRMgTMX9jaP1ljpk1j0wCla
nfTswadWT8N5O+Bh6PueyuYuSCJzlTYmV4XqDiqShmXQf71TTuZ5UBeigiz7
ZXObquqE2bLQLldD5mzajcubNe7A7KTsCIY7sS47aY1nCpb7aWexxICldarv
WB3WvmIYZB7DbjMlAzBo+j2G5RRu1nHZM0bVRTamj+rlMGx6UUvnZZkaJDly
wtyANebRHKt1SlyZebk74HMPuwjcZDmGbf3MxD6odWvNNy0TZ5OUO4Nlmejy
6KIx0req/TI+3BiXqT63/iygqvXaVR7C/p0H14/0+XpY7+Xb4HIwH8aSlYRg
dE2WZ2A5RR+fhhVmRqw5j8ZYXd8d1JCPHCUKisZ5sUMsy8QihYs7ywTnsOzZ
SqXwhTF29RPe49i9/EdYeYllW3efgRUQqU/0dx8rAqPkitWdIohy46Q2QYOR
E53zt80vtOzAfh6W9wV07c1gxvsSRVFq+Q1wHp3/MviSyw7sZ2F5g+I4Lein
VcBDDjnkfy3/ANKqSLY=
            "], {{0, 19}, {174, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{174, 19},
          PlotRange->{{0, 174}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{178, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWa+v5DYQjlpSWKl/Qf+B4NLAokhXlS25Uy+nkmt0V6kKDTMMCwsKinRS
UFBIUEhUyaAmBlGlkACDEAODV4+d3ctubO++u6onVRlpn3az/jy/Ps+M933/
6rcX0Vee573/Rv558fKP4N27l8lP38oPP799/+ubt69/+fHt76/fvH73w6uv
5cPv5OuDfMH7p0MOOeSQQw455BCXsAZFvh9j/vS0TH1TV1Xdk/kRIBmGkXHH
CsHGTm5YN2R2LZtwL7U2PXEtAlkoxuMiNgrmrqnKqsbTPegOy0bcVNLXdmTC
ATPrXZXTYSC7x/exMxka0Dzc07z3lw0dQGXcnThTHm9jtZRREJzSfl73X3Au
R8cI1X/9WfkeiP4bV8RtZZ+FsBj1VnNI6W2kNOeZtyiQ3wZhoLTWtozSKtH7
oP4ShFFBtfg1tZJhjx2KSIG0r0E7WVNi0rtqT9UW/WKDmrF9ftpEJaEWzQYs
J+qRr0OVtqMRyLAxj/tYCdIUp00GlyHzvEx+QUv5GE3qWQlxQo66wGmlNw3z
wbKEZYHyFPLDKpSbibD0ATgFalmfOQI7tmUaA/fyYY3M1EJgKgjlCO+i2pbO
HZYXwdly1ku3g8zmhUGvlmFNaDjYmWDATg1gUCdNFVOH8u5hm3WmAs0LcN3P
jHXBmEdbrEgRXvbhGJigvFnYuRCxHoFSq48TkoQLTiffGkMx1YrP9jCd3ZNM
SDpli8CB84hJw2VosjUyoo6lDbleTsD9yNldttgnsVy62pI5mbDHAlwdhDBJ
JKHuuXiFpZXMzYncbUcmrGJCqo/nDJk1M8GUR2uscC5Dvj4HCu3YNcB5TieL
fRiKiteMUwmEMsdQmR12RFagoigbYu2Is6pQUUvGHip2MjqixIE258gs+YaH
HHqcg7o32K1MqWf1woKd4SD42bzg0K30Fiua2PNlWSdtkedV4ygnBr1iauTH
IC7phGWpD1DnRj99zKM1VkRlX75ltAWyXPd6McJxjkrznKC/TRqgiayxQW5e
pscP2CdJT77qxZZmMwJfVwlL6nLshgnBR++UusAVWQsTFKv9xj4n7LEKokuB
LGIBdh/wG5vD1dEkVV6HhWvyu7V5KTa93hbPi2zyaI2VLm6oJkjvubVG9U3v
VFqCuhTKlxhlWZaGelIwjS6aCfV6wmkMTmODr6SAYRLPYqFlEm4gdyPzL9SE
qYUAJLWTftdYHV7pTZZnSGUzSlA72tvSjr0yN+uHZ9rcpb4c7ygXM2liKErW
og1ylUdHrHiuJkvBiNxeTmwrfO5hxAgyO914V+ZZnmcgKPQVrTsDE5Q6vzu3
OKnOWIGHTJpYnHPPkLtlCwx9E2sfoNJKrM4BhdkocvXfKyzIqGgQmfjpwIp5
kM7nOgJoZULnYMK1XijXQa5Xi7G6w4QrLJOhutRMgTMX9jaP1ljpk1j0wCla
nfTswadWT8N5O+Bh6PueyuYuSCJzlTYmV4XqDiqShmXQf71TTuZ5UBeigiz7
ZXObquqE2bLQLldD5mzajcubNe7A7KTsCIY7sS47aY1nCpb7aWexxICldarv
WB3WvmIYZB7DbjMlAzBo+j2G5RRu1nHZM0bVRTamj+rlMGx6UUvnZZkaJDly
wtyANebRHKt1SlyZebk74HMPuwjcZDmGbf3MxD6odWvNNy0TZ5OUO4Nlmejy
6KIx0req/TI+3BiXqT63/iygqvXaVR7C/p0H14/0+XpY7+Xb4HIwH8aSlYRg
dE2WZ2A5RR+fhhVmRqw5j8ZYXd8d1JCPHCUKisZ5sUMsy8QihYs7ywTnsOzZ
SqXwhTF29RPe49i9/EdYeYllW3efgRUQqU/0dx8rAqPkitWdIohy46Q2QYOR
E53zt80vtOzAfh6W9wV07c1gxvsSRVFq+Q1wHp3/MviSyw7sZ2F5g+I4Lein
VcBDDjnkfy3/ANKqSLY=
              "], {{0, 19}, {174, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {174, 19}, 
            PlotRange -> {{0, 174}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["6.4"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9eab19e6-f1ef-4554-a000-6aaabfa764db"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell[TextData[{
 "Use ",
 StyleBox["Table",
  FontFamily->"Source Sans Pro"],
 " to get the same result as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Range",
    FontFamily->"Source Sans Pro"], "[", "10", "]"}]], "InlineCode"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWK1v5EYUt1pSWKl/Qf8B41LDIktXlZncqfGpJF3lKlWmZtYhs2FGRkZG
RiZGQ0yGDBlgYmJgYDJgwPa9Ge+uNzvjzTWgZJ+UaJP8/D5+79P5+dNfH+Lv
PM/78gN8+/Dxn+Dl5WPy24/ww+/PX/78/Pz0x6/Pfz99fnr55dP38Muf4Osr
fOHn40Me8pCHPOQh/6fMTRb7/oFJ8+MiGBsWtffEMtKmrqqa8mkPJifa1lXd
UD6+xQ3e98MsHX9VI2cX4YMLh9B56Bq0yyc7Sk4Du5bBgQQZGYVQIYYdi8BI
3yIKAthDaeRretXUNVVZ1Ww0FpYyDoIopdOKWRiBayHO6lEdRZV4WjLqNDSz
ytcY8/1QcStMjW24gYVZt5vyI80R7mfUFVduFK0S9IsDx8strrTxyvLAuxY/
723KZJshMgg1/lDbc6QGjfJ87WHSDK4YbfSuzxovagEWFG+KaEPF0ueelxvT
Q1umBySK9M4EiRKeznRLQK7RmrWL1NgEfip0VnSYAXVQikSIyrgYEitRaIsE
XlgwUKzFpWnW3CcY6HGuMuKoe6XkqoUVEG9oT/dCQVnaYqwzBZZ8awhji7RX
GKqqE0jSwZWhW3o3zw74Ka5NZBy88nMDkgwTtLHMQUXuThD4PZ86dKbZPvMr
rEt3YWMGYQVR5HuBvZJBJrBE+H4XQlXUuj7vOXR5gEO1RaV9CEDtQoKSTlOh
WOBIUA81cSLzODbgQMF3HNjSq+oDBE4MmmPlx6aiGJSjv/4eO+KsH0SiV7sJ
uvbNS3cWzDKNrKsirI3S5TTDhvaaYSxD16hBrvQEjA5xnOYln+yZ0tMg7DgM
iaIoGz7fSehQwQiIhRM16VkTt3ygBSCTwYbUJGQrX3N3h70reheyqUmJu2Yt
Y66TAh9n0WIOt5P/zQlSQ62Jd5SfceA0YF0KjZKkwSQXAVSTQ5sSaeDHWdE0
ZYyjPrQuSbNP0askjRAWtHtXDE4VPTbdCCzxVcJSWDFSlLp2UkJSsyeJa0Ee
bxIUXBKknV93q9IzP6t5pndTO7s0uGWmWPeRsy/OouTU5IitLfW3FPqSOGR5
nqeh2UKtc8meTHe+44wxCToZEod9/vU4KoXzOpO8QACb1CLKJHSEoD0SXZ4m
SUo6WmM7vbuD4Ceik61mjllP24sGxXBIsl3iJ4rXQZDvH9mXyHGAWymVXUly
QnKULNStUXTWBG3uAr27rSToGP1u/QuG75yZ0B0NNFDE3NdzD4djUJzszrhu
3dpWB3DGengQu+SKXtXg/CqMCwJPrtisWVMbBcXBInBFmB0k4URnHf4pKTt4
7Rj10QeHSZA25zjk2Eamkdue9T2lVMCov4GhaT9p+ThPQ52Fa63ewLau6xGn
C/4GppdpSsU4Db1uR78ZLUahK1Lsa8Knqdc3Le5rh1G93MmlEG9gU5vqOcPm
ZREd0efHdAuD95hDlHZ8EH0V6mtc2bRZ6TUtn9ZsEsiqn3bHNVmwg4h59nLF
yT68fjvIYSBKpvm4nHmMvELp1riBybE3a2B9z2iEMfYKtpHzIW2BLUOXXMwG
BZ1c2tSpfjQP/Y5RDCTYJMgCUx2Jz1Zjol/lbmAK5skpUD8m6xS81WalF+qk
OJkI8/ME3V5x+vLJdiYatti20r4FpuQCou7BvkGblG/QptDqBvgeo2AVg5B3
YMtyDXqzURC5zPN8xRLH62F91oy74Jz6axlxVMGivHMzPGD/DWYTSYvEu9p3
kpYZvF7YX7qXaef/VA/Ye2EWkU12OKSFePPb9kMe8hCX/Atbt9lG
            "], {{0, 
            19}, {139, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{139, 19},
          PlotRange->{{0, 139}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{143, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWK1v5EYUt1pSWKl/Qf8B41LDIktXlZncqfGpJF3lKlWmZtYhs2FGRkZG
RiZGQ0yGDBlgYmJgYDJgwPa9Ge+uNzvjzTWgZJ+UaJP8/D5+79P5+dNfH+Lv
PM/78gN8+/Dxn+Dl5WPy24/ww+/PX/78/Pz0x6/Pfz99fnr55dP38Muf4Osr
fOHn40Me8pCHPOQh/6fMTRb7/oFJ8+MiGBsWtffEMtKmrqqa8mkPJifa1lXd
UD6+xQ3e98MsHX9VI2cX4YMLh9B56Bq0yyc7Sk4Du5bBgQQZGYVQIYYdi8BI
3yIKAthDaeRretXUNVVZ1Ww0FpYyDoIopdOKWRiBayHO6lEdRZV4WjLqNDSz
ytcY8/1QcStMjW24gYVZt5vyI80R7mfUFVduFK0S9IsDx8strrTxyvLAuxY/
723KZJshMgg1/lDbc6QGjfJ87WHSDK4YbfSuzxovagEWFG+KaEPF0ueelxvT
Q1umBySK9M4EiRKeznRLQK7RmrWL1NgEfip0VnSYAXVQikSIyrgYEitRaIsE
XlgwUKzFpWnW3CcY6HGuMuKoe6XkqoUVEG9oT/dCQVnaYqwzBZZ8awhji7RX
GKqqE0jSwZWhW3o3zw74Ka5NZBy88nMDkgwTtLHMQUXuThD4PZ86dKbZPvMr
rEt3YWMGYQVR5HuBvZJBJrBE+H4XQlXUuj7vOXR5gEO1RaV9CEDtQoKSTlOh
WOBIUA81cSLzODbgQMF3HNjSq+oDBE4MmmPlx6aiGJSjv/4eO+KsH0SiV7sJ
uvbNS3cWzDKNrKsirI3S5TTDhvaaYSxD16hBrvQEjA5xnOYln+yZ0tMg7DgM
iaIoGz7fSehQwQiIhRM16VkTt3ygBSCTwYbUJGQrX3N3h70reheyqUmJu2Yt
Y66TAh9n0WIOt5P/zQlSQ62Jd5SfceA0YF0KjZKkwSQXAVSTQ5sSaeDHWdE0
ZYyjPrQuSbNP0askjRAWtHtXDE4VPTbdCCzxVcJSWDFSlLp2UkJSsyeJa0Ee
bxIUXBKknV93q9IzP6t5pndTO7s0uGWmWPeRsy/OouTU5IitLfW3FPqSOGR5
nqeh2UKtc8meTHe+44wxCToZEod9/vU4KoXzOpO8QACb1CLKJHSEoD0SXZ4m
SUo6WmM7vbuD4Ceik61mjllP24sGxXBIsl3iJ4rXQZDvH9mXyHGAWymVXUly
QnKULNStUXTWBG3uAr27rSToGP1u/QuG75yZ0B0NNFDE3NdzD4djUJzszrhu
3dpWB3DGengQu+SKXtXg/CqMCwJPrtisWVMbBcXBInBFmB0k4URnHf4pKTt4
7Rj10QeHSZA25zjk2Eamkdue9T2lVMCov4GhaT9p+ThPQ52Fa63ewLau6xGn
C/4GppdpSsU4Db1uR78ZLUahK1Lsa8Knqdc3Le5rh1G93MmlEG9gU5vqOcPm
ZREd0efHdAuD95hDlHZ8EH0V6mtc2bRZ6TUtn9ZsEsiqn3bHNVmwg4h59nLF
yT68fjvIYSBKpvm4nHmMvELp1riBybE3a2B9z2iEMfYKtpHzIW2BLUOXXMwG
BZ1c2tSpfjQP/Y5RDCTYJMgCUx2Jz1Zjol/lbmAK5skpUD8m6xS81WalF+qk
OJkI8/ME3V5x+vLJdiYatti20r4FpuQCou7BvkGblG/QptDqBvgeo2AVg5B3
YMtyDXqzURC5zPN8xRLH62F91oy74Jz6axlxVMGivHMzPGD/DWYTSYvEu9p3
kpYZvF7YX7qXaef/VA/Ye2EWkU12OKSFePPb9kMe8hCX/Atbt9lG
              "], {{0, 
              19}, {139, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {139, 19}, 
            PlotRange -> {{0, 139}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["6.5"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7a59cbef-a0bb-47fe-93d0-b360072f5a67"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["Make a bar chart of the first 10 squares.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb2L40Ycho+kSZm/IJD/Im2aQNo70l1zR3aONBPYCwopVJ07V67cqFLj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            "], {{0, 
            131}, {220, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{220, 131},
          PlotRange->{{0, 220}, {0, 131}}]], "ExerciseOutput",
         ImageSize->{224, 131},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb2L40Ycho+kSZm/IJD/Im2aQNo70l1zR3aONBPYCwopVJ07V67cqFLj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              "], {{
              0, 131}, {220, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {220, 131}, 
            PlotRange -> {{0, 220}, {0, 131}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["6.6"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"75c32002-8800-4d9e-aea7-9afaea9626f3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["Make a table of lists of digits for the first 10 squares.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWq+vpUYUpq2pbNK/oP8AuqIGWUWyTd01u+ljU7Mlu00aLA6Jw6FQKBQK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            "], {{0, 19}, {316, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{316, 19},
          PlotRange->{{0, 316}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{320, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWq+vpUYUpq2pbNK/oP8AuqIGWUWyTd01u+ljU7Mlu00aLA6Jw6FQKBQK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              "], {{0, 19}, {316, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {316, 19}, 
            PlotRange -> {{0, 316}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["6.7"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f74fbd6b-16bd-4ea1-b029-a913887d0527"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["\<\
Make a list line plot of the length of the sequence of digits for each of the \
first 100 squares.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3e+T03QCx3Hu7sk9vH/h/ot7eg/vqTf3VEc4o5x38cYfcZyxznDWU6ij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            "], {{0, 
            233}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 233},
          PlotRange->{{0, 360}, {0, 233}}]], "ExerciseOutput",
         ImageSize->{364, 233},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3e+T03QCx3Hu7sk9vH/h/ot7eg/vqTf3VEc4o5x38cYfcZyxznDWU6ij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              "], {{0, 
              233}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 233}, 
            PlotRange -> {{0, 360}, {0, 233}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["6.8"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"99a62a54-d8ff-4721-a2f5-a159ef7b2eb2"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["Make a table of the first digit of the first 20 squares.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWiGP5DYUTlupKqx0v6B/ILg0sCjSVWVD7tTNqWQb7VWqQsMCw8yCggYF
BYUEmYSYmASEhAQEhBgYTP3smdmZThxbs9FpTpdP2tHMzhc/P39+fu9595eP
f78Pvncc5/NP4uX9h3+9l5cP0e8/iw9/PH/+69Pz05+/Pf/z9Onp5dePP4hf
vhM/P37nOPD+sGHDhg0bNmzYsGHDhg33YCyTwHVDwtTHqSWkm7jNg7RpupHp
CVNTFft9KUimoSyMTj0uxWgFpsMSjQ1YGC1KTHuT0YOFCwc+dnUJA9JhidYT
DK5iukQCWC7vo9IsVViXZqnpndJPeeB5uxgPR8cngkSLHSRFzw/tPnIkEmzc
wwec+oLpJnj+a94lHgzluvAalZ1uHBujI9nLYRz1Gu7pvM2+8i9oflIvbwKD
C2JxaO5cIJ/f76ySrnq+dDgsdEFhubwPS7NUYV2apaZvkJ7TMttdbIOpSR0n
VSJ2VR6HwESNISJYu1cL6KNmltBXsML7VsyLF5GYZqgLCRujbS6mnMjIFxEN
us2eKbwvPTdu5VrIXerh6X4XhGgp7PGohdUZ9wmaD4gJC1ZcwexGLBbT1Rm1
XN6HpVmqsC7NUtM3Sk8z33FT5TkjEBEXT1OxLqkhIvpE7HFvt3MdL53fTo3Y
TCcTh74U1jOqn6LZ6DSesvmIk2V/j7Q6XqSZXeB9Ic9Mk6WpEQJEtZw8J54+
IiRslvdhaZYqrEt7hUlTS9qM9AQJ3ZB6AkL1vHUFGOi7vHoEkoxTdn0OgaWP
CCcZT1M0jGlh9HrkeKFSnIae1HuYYpDrVsXGBZk9/ZqKpJpleUlHXR4eZNIN
KtrhTBx2UbeQsC09fWSahFGFdWk2mlrSZqWnMgrEI2NbhSJcLgtp07LwrpB9
AUw/8xwPzZd/rIUK3N3FCMWqtEPNQhqz1UJZD/J5oxIT8o5lv25ASxdUhwXm
ongHPniVpv/rivDca/h5u+TAI2/1NVVYl2bW1JKmk57LOiopaCJ7keryacOy
TJlsYMIkTdPYV7VYNd8ijG2dxlEUoxoXkDDeniNGDOG9WzolFDgbyhS4xcx5
beuCiojTCK3Y9H5GZuZOM0HLycCnNo98jdEz+4G3+roqrEszaGpJW5CeIXlw
85HCCR5XFyMSKCaJboKszlGKUApIfBjEz2rtPdLxGSg/HLjM0rqxbFRiwNB+
eenyPd1r7wsl/ezNia0LDCLCrY8DTGLFZuurJhX1aHbybYSCWFOGqVmZPX1k
mpUK69JsNLWkaaVXx1qGIXe0UHapPoK1hJAavorymhLSM7iaioTgcTl3y8Jl
3pHH5g2ND3W4i2vatc0egjEs+BzN0ijrq50qvaqGNA3GuBVV/Q2tFOe4G1W0
H4euSMBs3rK7XRAtWAzHF6LD0MjLSbgcuKENVSwTLhmnqa2RbMaHuz19ZJql
CuvSLDV9k/THbhop2utdE2t85wqpqPwZgWm76dzBAWXbsZC4oXER/u5xHDdA
xwx2O5qdUYL+x5InwA2N9Y2q+JXZtGznjdq5cJC33LvTcFHeaGi8RsF5YgGS
N+H3evrINEsV1qVZavom6a/vmuSNSrKQKSGJnMgLmKVNAGakrWuUM7DKTTRr
o1w6wQ00zti1r1/A02+HZqnp3dJTBAlD0VQF5Z2P8Wv0kI1E22jotjbaRvtq
aQxnUBJfdH8M50kQxJo/yA7d4v/zbLSN9pXTWJmEYZy1xkSyYcOGDRu+bfwH
kdo8kQ==
            "], {{0, 19}, {262, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{262, 19},
          PlotRange->{{0, 262}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{266, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWiGP5DYUTlupKqx0v6B/ILg0sCjSVWVD7tTNqWQb7VWqQsMCw8yCggYF
BYUEmYSYmASEhAQEhBgYTP3smdmZThxbs9FpTpdP2tHMzhc/P39+fu9595eP
f78Pvncc5/NP4uX9h3+9l5cP0e8/iw9/PH/+69Pz05+/Pf/z9Onp5dePP4hf
vhM/P37nOPD+sGHDhg0bNmzYsGHDhg33YCyTwHVDwtTHqSWkm7jNg7RpupHp
CVNTFft9KUimoSyMTj0uxWgFpsMSjQ1YGC1KTHuT0YOFCwc+dnUJA9JhidYT
DK5iukQCWC7vo9IsVViXZqnpndJPeeB5uxgPR8cngkSLHSRFzw/tPnIkEmzc
wwec+oLpJnj+a94lHgzluvAalZ1uHBujI9nLYRz1Gu7pvM2+8i9oflIvbwKD
C2JxaO5cIJ/f76ySrnq+dDgsdEFhubwPS7NUYV2apaZvkJ7TMttdbIOpSR0n
VSJ2VR6HwESNISJYu1cL6KNmltBXsML7VsyLF5GYZqgLCRujbS6mnMjIFxEN
us2eKbwvPTdu5VrIXerh6X4XhGgp7PGohdUZ9wmaD4gJC1ZcwexGLBbT1Rm1
XN6HpVmqsC7NUtM3Sk8z33FT5TkjEBEXT1OxLqkhIvpE7HFvt3MdL53fTo3Y
TCcTh74U1jOqn6LZ6DSesvmIk2V/j7Q6XqSZXeB9Ic9Mk6WpEQJEtZw8J54+
IiRslvdhaZYqrEt7hUlTS9qM9AQJ3ZB6AkL1vHUFGOi7vHoEkoxTdn0OgaWP
CCcZT1M0jGlh9HrkeKFSnIae1HuYYpDrVsXGBZk9/ZqKpJpleUlHXR4eZNIN
KtrhTBx2UbeQsC09fWSahFGFdWk2mlrSZqWnMgrEI2NbhSJcLgtp07LwrpB9
AUw/8xwPzZd/rIUK3N3FCMWqtEPNQhqz1UJZD/J5oxIT8o5lv25ASxdUhwXm
ongHPniVpv/rivDca/h5u+TAI2/1NVVYl2bW1JKmk57LOiopaCJ7keryacOy
TJlsYMIkTdPYV7VYNd8ijG2dxlEUoxoXkDDeniNGDOG9WzolFDgbyhS4xcx5
beuCiojTCK3Y9H5GZuZOM0HLycCnNo98jdEz+4G3+roqrEszaGpJW5CeIXlw
85HCCR5XFyMSKCaJboKszlGKUApIfBjEz2rtPdLxGSg/HLjM0rqxbFRiwNB+
eenyPd1r7wsl/ezNia0LDCLCrY8DTGLFZuurJhX1aHbybYSCWFOGqVmZPX1k
mpUK69JsNLWkaaVXx1qGIXe0UHapPoK1hJAavorymhLSM7iaioTgcTl3y8Jl
3pHH5g2ND3W4i2vatc0egjEs+BzN0ijrq50qvaqGNA3GuBVV/Q2tFOe4G1W0
H4euSMBs3rK7XRAtWAzHF6LD0MjLSbgcuKENVSwTLhmnqa2RbMaHuz19ZJql
CuvSLDV9k/THbhop2utdE2t85wqpqPwZgWm76dzBAWXbsZC4oXER/u5xHDdA
xwx2O5qdUYL+x5InwA2N9Y2q+JXZtGznjdq5cJC33LvTcFHeaGi8RsF5YgGS
N+H3evrINEsV1qVZavom6a/vmuSNSrKQKSGJnMgLmKVNAGakrWuUM7DKTTRr
o1w6wQ00zti1r1/A02+HZqnp3dJTBAlD0VQF5Z2P8Wv0kI1E22jotjbaRvtq
aQxnUBJfdH8M50kQxJo/yA7d4v/zbLSN9pXTWJmEYZy1xkSyYcOGDRu+bfwH
kdo8kQ==
              "], {{0, 19}, {262, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {262, 19}, 
            PlotRange -> {{0, 262}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["6.9"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1695a3b9-675c-4f3e-bcc5-782dea8240f3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["\<\
Make a list line plot of the first digits of the first 100 squares.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnVtbE9n3538zczOX8xbmXcztXM7tf5651e7WTuu/W+yf3cbuVmxFEAVR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            "], {{0, 233}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 233},
          PlotRange->{{0, 360}, {0, 233}}]], "ExerciseOutput",
         ImageSize->{364, 233},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnVtbE9n3538zczOX8xbmXcztXM7tf5651e7WTuu/W+yf3cbuVmxFEAVR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              "], {{0, 233}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 233}, 
            PlotRange -> {{0, 360}, {0, 233}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["6.10"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a7ee5aff-6de2-488b-8299-1deb9a6bb4e1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell[TextData[{
 "Make a list of the differences between ",
 Cell[BoxData[
  RowBox[{"n", "^", "3"}]], "InlineCode"],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "^", "2"}]], "InlineCode"],
 " with ",
 Cell[BoxData["n"], "InlineCode"],
 " up to 10."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWT+rpUYUl6RJGcgnyAeIdVrLNBE2pLPZJeuSZnPZDYTbCikG0pgiWCxY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            "], {{0, 
            19}, {230, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{230, 19},
          PlotRange->{{0, 230}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{234, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWT+rpUYUl6RJGcgnyAeIdVrLNBE2pLPZJeuSZnPZDYTbCikG0pgiWCxY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              "], {{
              0, 19}, {230, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {230, 19}, 
            PlotRange -> {{0, 230}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.1"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1c23abbd-80be-405f-adcf-e3471468ff5e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["Make a list of the odd numbers (1, 3, 5, ...) up to 100.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnbGvq8gVh0nSpMy/kDYFdVqXqSxtlM7NrrJepdlYbyNFbuko3dG5onLl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            "], {{0, 42}, {491, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{491, 42},
          PlotRange->{{0, 491}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{495, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnbGvq8gVh0nSpMy/kDYFdVqXqSxtlM7NrrJepdlYbyNFbuko3dG5onLl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              "], {{0, 42}, {491, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {491, 42}, 
            PlotRange -> {{0, 491}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.2"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"40c7622b-4e76-40c8-b13a-bb40967649b0"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["Make a list of the squares of even numbers up to 100.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb3r81h2x52kSZl/IX/Auk4Zl2nWsCGp3OyS8ZJmYnYDwa1gWQTbaCt1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            "], {{0, 86}, {418, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{418, 86},
          PlotRange->{{0, 418}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{422, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb3r81h2x52kSZl/IX/Auk4Zl2nWsCGp3OyS8ZJmYnYDwa1gWQTbaCt1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              "], {{0, 86}, {418, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {418, 86}, 
            PlotRange -> {{0, 418}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.3"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7ed27c5c-27d3-415d-8c71-d39927f008e1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell[TextData[{
 "Create the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "3"}], ",", 
    RowBox[{"-", "2"}], ",", 
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}]], 
  "InlineCode"],
 " using ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVi1v3DAYtjYyOGm/YH8geNRw6KROY0darammSV3UTZqOhhmGhQUFBQUF
hRwyCTExMQgJCQgwMQjo/Dq93jVNnFx6U8HukRI50evn/fD74Y9XPy/cNwih
X+/06+LyD767u9x8ea8/vt7++n5ze/3t8+3v65vru09Xb/XPD/r5oR9Y359x
xhln/O9oMuI6jseUVUrVNE+TNKO8WqhHVjRLkySlvF7IYFgEY6Vs7UJlkSdx
khflCdj6ZsvYxXjt0/phl2ShniYuSatxmrbKVwjgmPeKbCcceIaGJc4Bg5fw
IwkAItmY3YjQxiJWhOtHTeuoeAnbkNktzyKtwCG0k5FFgFBgz762yrDjCxO1
nGCEMJXWDc+tjbVOYnJXnyBYvSALyzz2PTjJsBgPoKTavlUIcaMBLMcqaw7b
mNk8WiEn6LYpBgGcH49m6y8IoDag2VVKQ8kihg5c+xyMu6xMQeWdn1WGQNii
aYJtzGwWYuSEHS8EeRdMO2RdsW0C5eHGC703KCAx/IWdVBXY6rJI3H16t8K1
B3CK7RCHZnMTNM3biNzTYe3KWdWCi6eoDtJf6qh3GNU4wWB8KlNzAiM9cJJh
ymVwc5cbWjrCCIdsNCizA9gzuxUJ1HPKiWmQuSGQBUF9OL1Ca1WdBZCDaTkw
RqYZGgqb16MJPM0wJwP3BVXq9CCW+MwM4IDZKjRzpW24rxd+Dv9a1fQgHw9f
7dOgZXhsctkY7u9rCm0YB7bxYWcw2qFrsdGqVFz3QGfbWVfnMCPGhSfZxsxW
PNL/IgoFLaCrTfTATB+ks8l51dRlSmByxULpeb5xEPYz+wR/0Fjl5m6Bwrxg
RUEpFU17FIPm0Hc2tgXLN/GWMwa1/ZzB9D1dbGVdRrDy4C44oGgW27DZD4Mj
7MTmTGFVFf7aeaypIBPdzrX5mjNQWLjqVSbk8DEMutx6FDAdhhgkT3bdGqdC
Dps6j23Y7KdT2NwDyRwXWiU1DnsfZO++Yy/Bv2Jo9fWjObR1pqKZYjyE4dSJ
deWM3XBoLNhQQWGjmM26A7wuw0nFFI02pikW+z8xcV2fz+tEe8i6rI/d80oM
pxRTGfE8PxIvKZszzjgR/gKBrTZ5
            "], {{0, 19}, {107, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{107, 19},
          PlotRange->{{0, 107}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{111, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVi1v3DAYtjYyOGm/YH8geNRw6KROY0darammSV3UTZqOhhmGhQUFBQUF
hRwyCTExMQgJCQgwMQjo/Dq93jVNnFx6U8HukRI50evn/fD74Y9XPy/cNwih
X+/06+LyD767u9x8ea8/vt7++n5ze/3t8+3v65vru09Xb/XPD/r5oR9Y359x
xhln/O9oMuI6jseUVUrVNE+TNKO8WqhHVjRLkySlvF7IYFgEY6Vs7UJlkSdx
khflCdj6ZsvYxXjt0/phl2ShniYuSatxmrbKVwjgmPeKbCcceIaGJc4Bg5fw
IwkAItmY3YjQxiJWhOtHTeuoeAnbkNktzyKtwCG0k5FFgFBgz762yrDjCxO1
nGCEMJXWDc+tjbVOYnJXnyBYvSALyzz2PTjJsBgPoKTavlUIcaMBLMcqaw7b
mNk8WiEn6LYpBgGcH49m6y8IoDag2VVKQ8kihg5c+xyMu6xMQeWdn1WGQNii
aYJtzGwWYuSEHS8EeRdMO2RdsW0C5eHGC703KCAx/IWdVBXY6rJI3H16t8K1
B3CK7RCHZnMTNM3biNzTYe3KWdWCi6eoDtJf6qh3GNU4wWB8KlNzAiM9cJJh
ymVwc5cbWjrCCIdsNCizA9gzuxUJ1HPKiWmQuSGQBUF9OL1Ca1WdBZCDaTkw
RqYZGgqb16MJPM0wJwP3BVXq9CCW+MwM4IDZKjRzpW24rxd+Dv9a1fQgHw9f
7dOgZXhsctkY7u9rCm0YB7bxYWcw2qFrsdGqVFz3QGfbWVfnMCPGhSfZxsxW
PNL/IgoFLaCrTfTATB+ks8l51dRlSmByxULpeb5xEPYz+wR/0Fjl5m6Bwrxg
RUEpFU17FIPm0Hc2tgXLN/GWMwa1/ZzB9D1dbGVdRrDy4C44oGgW27DZD4Mj
7MTmTGFVFf7aeaypIBPdzrX5mjNQWLjqVSbk8DEMutx6FDAdhhgkT3bdGqdC
Dps6j23Y7KdT2NwDyRwXWiU1DnsfZO++Yy/Bv2Jo9fWjObR1pqKZYjyE4dSJ
deWM3XBoLNhQQWGjmM26A7wuw0nFFI02pikW+z8xcV2fz+tEe8i6rI/d80oM
pxRTGfE8PxIvKZszzjgR/gKBrTZ5
              "], {{0, 19}, {107, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {107, 19}, 
            PlotRange -> {{0, 107}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.4"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6e78091e-2a8a-4102-b362-9807a3743690"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell[TextData[{
 "Make a list for numbers n up to 20 in which each element is a column of the \
values of ",
 Cell[BoxData["n"], "InlineCode"],
 ", ",
 Cell[BoxData[
  RowBox[{"n", "^", "2"}]], "InlineCode"],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "^", "3"}]], "InlineCode"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnTvL61p6x52kSZmvkA8Q1WldpolhQjo3M+R4kmZiZhKCWkEIgjRK5U6V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            "], {{0, 117}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 117},
          PlotRange->{{0, 360}, {0, 117}}]], "ExerciseOutput",
         ImageSize->{364, 117},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnTvL61p6x52kSZmvkA8Q1WldpolhQjo3M+R4kmZiZhKCWkEIgjRK5U6V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              "], {{0, 117}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 117}, 
            PlotRange -> {{0, 360}, {0, 117}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.5"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"729792ca-d223-4b22-acc3-b7d54d06a660"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["\<\
Make a list line plot of the last digits of the first 100 squares.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnd17XcWV5jMzN3M5/8L8F3M7l3Pb88ytyAc5HbqD6CaJ6A6okxAZAubL
fCkJ6gAKRAkgBxywARljiDAWRBDxIRPZ2GCwwAZjlAgjQKZmnfOeU5RqV62q
WrV2eMxz1kP3Q8w5rnPW2Wu96/3tvWv/z29e8g+d//q1r33te/+d/t8/fOOy
/33ppd/49//7P+h//L/R7130j6PfvvD/jH7/2//47Uv/1zf/G/3hSfq/7/yX
r32t++8mHp1BMK8ZxjCGMQw3hh1jGMMYRmkM+8YwhjGM0hj2jWEMYxilMewb
wxjGMEpj2DeGMYxhlMawbwxjGMMojWHfGMYwhlEaw74xjGEMozSGfWMYwxhG
aQz7xjCGMYzSGF5nPoxhDKM0mI6x8clnt9y3+NSLx5N/ydLhUzfft/jO++uy
z3DHQ0u/37+SfNmb767RKofeOC1b5YF9r931yMvJl/31o09olWdfPiFbZe/z
b9Dbz33+efKVtz3wwp4Dr8tW+dOhd2iV9z88m3zlvY8t/+axZdkqR94+Q6vQ
/0++cveB12+ffVG2yum1s3SYPb/8TvKVB14+Qa+kH0iwyrlzn9N79z73RvKV
h469T9/6+LtrglUo7n7klfv2vpZ8GRULrfLS4VOyVR56+vAvfv/n5MuohG/O
K+HSYPrGmb9tjPzkkf/c9VLyL3nkmdfpleKK7lz92E9/dSD5ssXX3qVVnlx8
U7bKf/xy/uLr5pIvO/He32iVmceFtTY5+yK9/ezGZ/zLqLHQy26ceV62CrVZ
evvhtz5IvvL7Nz952a37ZatQ86RVDrz0dvKV19373AU/eUS2yhurH9Iq9z+R
rrV7H32VXvnuaYk8UQXRe6lXJ1/5xPNv0Ctf/MtJwSoUl9yw9/LJp5Mve/Xo
+7TKnmePyla5+u5nvzmxJ/my02sf0yp3PpyWy9Jg+sZ7Z85mpnr2yb/QK18+
Imye3/jp7pxUP/PS27TK4wvHZKv8cPLpC696NPmy198+Q6tM735Ftgq1d3r7
B3/9mH/Z2Y1P6WXX/npBtgopGr39ldffS77yu9fNXXrTPtkqf/zzW7TKE39K
N+ptdx6gV362eU6wyuHjH9B7f70nnXCSMHrlWyf/Kljlb2c/ofde/5vnkq+E
CObMP8G46NrHL92RTjhEcNcfD8tW+cl/PkNvpyGKfxlE8JcPpieT0mD6xmpv
0ZxUQwheeO1dwQf4vKe8OamGENDPKliF4ge3PNlNdcpBQAhypqxgULro7ZQ6
/mUQgm13PStbhdxH5rF94bY9OVNWMKhjZCb8il/8MWfKCsbysW7C73hwKfnK
W+9/gV559ETaNzWDOnlmwiGCOVNWMEib/unax5MvgwjufPIvslXGewlfP/sp
/zKIYI70lwbTN958Zy0z1RCChVdXBR/gk8826b05qYYQkLMTrELxLzc+kXNs
Qwh+vlPo1n82fTDn2IYQ/HhqXrbKXY+8TG+neYB/GdzQd655TLbKowePZh7b
5IbolWvrG4JVlg6fovfect9i8pXkhuiVf3lTYodPfvARvZfKLflKiOBTLwiZ
wNev3J3jICCCv5s7JFvl3257it6eBFwQwR2/+5NsFSaYvnGk16xyUg0hmF+S
tOj1j7sT+7cyUg0heGBf2ggH45+3z+U4CAjBrfenD+Ng/PRX3YmdNJR/GYTg
8p+n3Vkw7nhoid4+99wx/mVwQ9/als5tMB6eP0JvvzcDq5IbyjmMg/GnQ+/Q
e7ffk7ZscEM57qwZJ051GzXNnMlXQgT3Pp8mqM0g40DvzXEQEMF79rwqWIXi
ezv25Vg2iCD1W9kqTDB949AbpzNTDSGQEUvQ15xUQwjExLJz9WM5DgJCICaW
//HL+RzLBiEQE0vQ1z/MH+FfBjckJpagrzmWjdyQmFiCvuaAcbghGbEEfc2x
bBBBGbEEfc1xEBBBMbG85Ia99PYjbyXGWojg1XcL7TATTN946cipzFRDCGTE
EvQ1J9UQAjGx/MZPd+c4CAiBmFj+cPLpHHcMIRATS9DX5DkIuCExsQR9Tbpj
uCExsQR9zQHjcEMyYgn6mgPGIYIyYgn6mjN6QQTFxPKiax/PGb0ggj/5z2dk
qzDB9I0Xesd2TqohBDJiuTo4tpOphhDIiOXng2M76SAgBGJiCfqaPAcBIRAT
S9DX5DkIuCExsQR9TYJxuCExsQR9zQHjcEMyYokBLweMQwRlxBL0NaeFQgTF
xJKqMqeFQgRzUENpMH1j4dXVzFRDCGTEEvSV/nn7VCLVEAIZsQR9zXEQEAIx
sQR9TbZQCMF3fiYklqCvyXMQtlhkxBL0NdlC4YbExBL09Z+3p1so3JCMWIK+
5rRQiKCMWIK+5jgIiOBNvxUSy69f2R2ek2AcIvhvtz0lW4UJpm/ML72dmWoI
gYxYHhloYjLVEAIZsQR9zVErCIGYWIK+JtUKQiAmlqCvt6RSATckJpagr0m1
sm5IRixBX5Ng3LohGbEEfR3JAOMQQRmxBH3NSQVEUEYsLX1NXv4KEfxexixX
Gsz9KU8uvpmZagiBjFiCvuakGkIgI5aWviYdBIRATCxBX5PnICAEYmIJ+po8
BwE3NCIllqCvSTBu3ZCMWIK+jqTAuHVDMmIJ+jqSAcYhgjJiCfqa4yAggjJi
aelrEoxDBC+5Ya9gFT6YeePxhWM5qbZCICOWoK85qYYQyIilpa9JBwEhEBNL
0NckhIEQjEiJJehr8hwE3FCO3Q4G6GsSwlg3JCOWoK8jKTBu3ZCMWIK+5kAY
iKCMWIK+5jgIiKCMWFr6mgTjEMGLMi6OKg2mb2CWTqbaCoGMWL4wmKWTl39A
CGTE0tLXpIOAEMiIpaWvSd4FIcjxgMEAfU2eg8j8BWMB+poE49YNyYgl6GvS
TJ3I/gWDAfo6kgLj57J/wWDYFpp0EBBBGbG09DUJxiGCOac2SoPpGw89fTgn
1VYIZMTS0tdkqiEEMmJp6WvSQUAIZMTS0tfkOQgIwYiUWIK+Jn0r3NCIlFiC
vo6kwLh1QzJiCfo6kgLj1g3JiCXo60gKjFsRlBFLS1+TDgIiKCOWlr7e8VAC
jEMEv37lbsEqfDB944F9r+Wk2gqBjFha+sqn2gqBjFha+pociiAEMmJp6Wty
KIIQJEU2FqCvyXMQ1g3JiCXoa3Iosm5IRixBX0dSYNxKuYxYgr4mhyIrgjJi
aelr0kFABGXEkhosVkmCcYjgSMZFlaXB9I2Zx5dzUm2FQEYsLX3lU22FYExE
LC19Tc6fEAIZsbT0NTl/QghGpMQS9DV5DsK6IRmxBH0dSYFx64ZkxBL0Ndnc
rBu68w8SO2zpKw/GrQjKiKWlr7yDsCIoI5aWvibBOESQ/tn4RGKHmWD6xvTu
V3JS/erR9/AyGbG09JXXESsEMmJp6WvSQUAIRkTE0tLX5DkIKwQyYgn6mtQR
64ZkxPLfb39qJAOMP7Cv74ZkxBL0lf4hsWZeZt2QjFha+sqDcSuCMmJp6Svv
IKwIyoilpa9JMA4RpH/+dlay2RETTN+wasWn2gqBjFhateJTbYVARiwtfSWh
Z15mhSA5nAdjNftDWiEQEMvPnQ9Jzoh5pXVDMmIJ+pr8kNYNyYgl6OtICoxb
NyQjlpa+zrIf0oqgjFha+so7CCuCMmJpLVvSs1sRTF5KEYm1ucmx3mUaY7uX
tyAypm/8fOeLOam2QiAjlpa+8qm2QiAjlpa+8seDFYIREbG09DV5PFghEBBL
S19HUnhkYuCGZMQS9JX+oQOVeZnVFxmxtPSVB+NWX2TE0tJXHoxbEZQRS0tf
eQdhRVBGLC195fGIK4InP/hIsND6ykyns2N105ycn+x0ZlxHzfQNKmTMw3yq
IQTdPbtExBL0ld7OpxpCQC+TEUvQV3o77yAgBPjWAmIJ+oq38+cgSAjwMgGx
BH3F2/lzEOSG8DIZsfzn7XN4Ow/GyQ3hZTJiScM23s6DcbgheqWMWNI0e8GV
XWzFg3GIIK0iI5agr/R23kG87h4n5cQS9JXezoPxj5zj5MSpxNVuwej1jamT
VBdL053R3L5x48zz9MGSqYYQjF6/V0YsQV8vvn4vn2oIAa0iI5agr7QK7yAg
BLTKiIhYgr5e3Hs7Y3MgBFhFQCxBX7EKfw6C3BBWkRHLztWPYRXe5lAh42Uy
Ytnd97X3dv4+Bbgh+joyYjk5+yINgfSNeJsDEaRVZMQS9JW+Dq+hEEH8NAJi
CfpKq/BgHCKIVd5Y/bB0lW6sr0xQgxjtWpWx2S3DQ2druP/p2l8v/OtNTyRT
DSG4fPJpGbEEff3h5NN8qiEEl/eukxQQS9DXy1NbjPa30+mtIiCWoK+4mJNx
lHBDWEVALEFfsQo/rpAbwioyYol9X0dSYJzc0GW37acXy4jlv9/+FL4LP66Q
eJFk0ItlxPLm+xYvuuZx6gY8GIcI0reWEUvQV/o6/LgCEURuBcQS9BVJY8Za
iCBWOXw8vYV1M5anR0ene9RxfXm8M7roCCkzb2y78wCNEMlUQwjIpcqIJdzx
VXc9y6caQgAvLCCWOB6uvvsgn2oIQeZef80AfcUqzDkICAFWERBL0Feswp+D
IDeEVXhCFQzQV6zCg3FyQz+6Y75z9aMyYknOcdtdz16QAuPkhv7xZ4/RcCIj
lnQMYyTmwThEkJImI5agr5Q03kFABPHTCIgl6Ct+GgaMQwSxCk+oYrEyM9aZ
6lHHjRXqG0t5fePHU/M0AyRTDSG45b5FGbH8+c4XadyCJ2JehsLHiUUBsXzw
qcP27UzbgRDgZQJiCfp66/2LfNuBEGAVAbEEfcUqzDkIuCGsIiCWoK94O992
yA2hUmTE8l9ufGL7PQs01vJgnNzQJTc8QWZWRiypfEiYkm0HIkjfWkYsQV/p
p+EdBEQQuRUQS9BXHAAMhYMIYpUl2YNa1lb6p1M6nR27lzed/8L0DWoaP75j
PplqCEG3/EXEko4WajhkP/m3QwhgagTEEvT17kde4Ts8hACrCIgl6CtWYTq8
fdTCSMbV9c0AfcUqzNvhhrCKgFiCvmIVHoyTG7rxt89T+cuIJRoOjbX82+GG
UP6CVajh0NuvvvtZHoxDBO96+GUZsQR9vfMPL/FjLUQQP01y25lmgL7ip2He
DhHEKvxcysfG+npTqJm+gUkjmWoIARIu+FQ0aZDBSaYaQrCzx50ExBL0FW9n
HASEAC8TEEvQ1529u0KYcxAQAqwiIJagr1jl4fg5CLghrCIglqCv1K6TYJzc
EKlGb+qQEEsANDrYeDAON0R2Q0YsSf7ob8DBxrwMIoiDTUAsQV9xsDEOAiKI
n0ZALEFfcQAwT9PrP2qh92Lx8wdjwfSNS2/ad+2vF5KphhCgrQmIJehrMtXo
S8CbAmKJjzf33DHeQUAISMRlxBIfD6sw4AJCgFUExBL0Fasw5yDghh599qiM
WIK+0sfjwTjcEAm0mFjSx/vF7/9Mdc2DcbihHb/7k4xY4uOhrpmXQQSBNwXE
EvQVdc1MxehLOAAExBIfDwcAMxVDBLFK8r7+0mD6BrWLG2aeT6YaQoDCFxBL
0NdkqiEEEHQBsQR9xQksxkFACA6+siojlmg7B1/prsKcg4AQYBUBsQR9xSqM
AYEb2v/CcRmxBH3dc+B1HozDDdGvLyOWoK80DtGswhsQuKHbU0djLGhmpiWS
Yy1EEBotIJagrzRD8g4CInggdTTGAvQVBwBjQAZH4yp/NMqC6Rvf+VkXVd0J
rxdPNYTg/idekxFL0Fekmrk6BUIAgCAglqCvZD14BwEhwHW8AmIJ+gobwpyD
gBBgFQGxBH19+cgp/hwEPgYdNjJiCfpKanUZC8bhhh58akVGLEFfqfslwTjc
EH1fGbEEfU2qG0TwDz2AICCWwC9QN8ZBQARx+ZaAWIK+4vdlwDhEEIfZoweF
D6KNBdM3vtX7pZKphhCgZATEEvQ1mWoIAZqngFiCvoIMMIMEhOCNQcmUrgL6
+ua7a/wgASE43nuZgFja5kkOgtm7AG7ozysnZcQS9JWaJz9IWDckI5agr7+d
O8SDceuGxMQSzfP3qUECIogTFgJiCfqKSYA5SiGC9NPIiCXoK+6KZa4Ehgji
MGM4mCyYvgEglkw1hAC1ICCWoK/JVEMIUAsCYglKg1QzMxuEALUgIJbosWd6
2zEx5yAgBHiZgFhas8afg4Abeu2N0zJiiR5LfwkPxq0bkhFL0FfqsfxYa92Q
mFiC0mCsZcA4RBADoYBYgr5irGUaAkQQk4CAWMKsUa3xDQEiiIGQqrh0FT5i
feOzzXMjvZM4fKqtEIiJJehrMtUQAiDB58ofRAv6ilQzDgJCcOrMRzJiCfr6
6Web/DmI/sH/6aaMWCLVpCOXsecg+gf/O2syYmlTzYNx64ZkxNLSVx6MWzfU
J5YfFRNL0NckH4MIPv3iWzJiiVSj5TIOAiKI2+EFxBL09cP+Ca8oGIcIUq7o
ZZS30lX4iO1nbjs8n2rcO5N8GROgr8lUQwgO9Z5dLiCWoK8fDtQt9jIIwZnU
y2IB+moG6sa87IL+yyTEEqPdO++v8+cg7AQoI5Z2tOPB+OKhvhuSEUtLXzHW
nl4L+1zrhmTE0tJXjLUxFGlFMMnPYwH6mnQQEMFjqek3FqCv2NWc8bkQQbws
5yG/RRGbN9bWu7Vz/xOv8am2QiAmlqCvyVRDCI68dUZGLEFf+zl8NJrqK37+
NAkBTLeAWIK+mt7jO5lzEBACMzDdpatYlESHKB2BsZfBDdHvKCOWoK/kHHkH
Yd2QjFha+sqDceuGZMTS0leMtYsRMG5FUEwsQV+TDgIiiO3+BMTSoiRSn6k4
GIcIbp7rGoe7HhE+iDYWsb5Bh2WvIRzmU22FQEwsQV/5VFsheFNKLEFfzQDa
xF4GIfjk000ZsQR9pX/hz0FACEzvMBMQS9BXagj8OYh7Bm5IRiytEAzAeNhB
WDckI5aWvvJg3LohGbG09JUH41YExcQSQpB0EBBBbC8sIJZWCHgwDhGkf7ng
yvQOxqUR6xs0BgMF8Km2QiAmlihkPtVWCFalxNLeZcM7CAjBucFYW7qKRQHg
Y7GXQQhMv00VE0tbyPw5COuGZMTSGk8ejFs3JCOWlr7yYNy6IdzSVUosrfHk
wbgVQTGxxNHFOwgrgmJiaY8uHoxDBE3vYbJ0qJSuwkesb7x1sjtEPb5wjE+1
FQIZsbT0tZ/qiIOwQiAmlqCvJuUgIASmh9EExBL0lf6FPwdhhUBGLO2lubyD
sG5IRiwt6ObBuHVDMmJpD5v+WHsoPNZaNyQjlpa+8mDciqCYWIK+GtZBWBEU
E0t72PBgHCJI/3LRNY/ffJ/kWQNMxPoGCQ19KRIdPtVWCGTE0tJXw6baCoGY
WIK+GtZBWCEwUmIJ+mqcwSMYVghkxNLSVwweH0XOQVg3JCOWlr7yxBtuiJyd
jFjaMZUH49YNyYilpa88GLciKCOWnztjKuMgrAiKiSXoq8HgEQfjVgRHr09s
hSGIWN8gY4vfkU+1FQIZsbT01bCptkIgJpagr4Z1EB8NXLCREkvQVzO4vyn2
MisEMmJp6St/DsK6IVwmVLqKpa88GO+6od5fLiOWlr7yYNy6IRmxtFiMB+NW
BGXE0tJXwzoIK4JiYgn6anpjbQyMuyL4vR37fjZ9sHQVPmJ9g35KWpd+Vj7V
VghkxNLSV8Om2gqBmFhSoaH3Mg7CCoGREktLX3kHYYVARiwtfeXPQVwx+DAy
YmnpKw/GrRuSEUtLX3kwbt2QjFi6osaAcSuCMmK57ugO4yCsCBopsbSixoBx
VwRJPpJPTCiNWN9wjxYm1VYIZMTS0lfTS/VExEFYIRATy5HBV2AchBUCIyWW
lr4y5yBcIcCJ+NJV7Ffgz0FYNyQjlvYr8GDcuiEZsbQmaADGw2OtdUMyYmnp
q2HBuBVBGbF0TTTjIKwImh6xvL2cWNqvwIBxVwRpwKbPU7pK4jNE+sZzvQHy
pSOnDJtqKwQyYmnpq2FTbYXAiIilpa+GdRCuEMiIpaWvzDkIVwhkxNLS14GD
CJ+DsG5IRiwtfeXBuHVDMmJp6SsPxq0bkhFLF9ozYNyKoIxYWvpqWAdhRdBI
iaWlr8xY64ogHcl0PJeuwkesbxzoleqhXqkyqbZCICOWlr4aNtVWCIyIWLr0
lUm1KwQyYmnpK3MOwhUCGbG09JU/B2HdUPIOo2BY+sqDceuGZMTS0lfDgnHr
hmTE0r1IgAHjVgRlxNLSV8M6CFcEBcTSpa8MGHdFMLn1liBifYPM4Mhgm30m
1VYIZMTS0lfDptq9aU5ALEFfcXEI4yBcIZARS0tfmXMQrhDIiKWlr8w5CNcN
yYilpa88GLduSEYs3duoGTBu3ZCMWFr6algwbkVQRixdxMc4CFcEBcTSpa8M
GHdFcPs9C/9y4xNFqyQjdn8Ktgl6s/ftfnRHNNVWCGTE0tJXAwcRSbUVAiMi
li59ZcTXFQIZsbT0lTkH4QoBNlIoJZaWvjLnIFw3JCOWlr5u9H7ZGBi3bkhG
LC19NSwYt25IRizdmyAY8bUiaETE0qWvzFjriiBpUymxdOkrA8ZdESSd5fc2
EURs3nAnbSbVVghkxNKlr0yqrRAYEbF06SvjIFwhkBFLS19RRMFzEK4QyIil
pa+Mg3DdkIxYugCZAePWDcmIpTv+MWDcuiEZsXTHPwaMWxE0ImLp0lfGQbgi
KCCWLhDA93o9BMZdESRfT7Nc0SrJiPWNXX/sDpCnznSHWybVVgiMiFi69JVJ
tSsEAmLp0lfGQbhCICCWLn1lzkG4QiAjlv960xOgr8w5CNcNyYilpa8mDsZd
NyQjlu62tN2xNgLGrRuSEUt3kwcGjFsRNCJi6dJXxkG4Iigglu4JCAaMuyL4
i9//mWqzaJVkxPrGbG+3ZGpuhk21FQIjIpYufWVS7QoBf+tHMFz6yjgIVwgE
xNKlr8w5CFcIZMTS0lc4iOA5CNcNyYilpa8mDsZdNyQjlpa+GhaMWzeUvKM5
GC59ZcZaVwQFxNKlr4yDcEVQQCxd+tofa0Ng3BVB7Kr6OfvA4tKI9Q06GEYG
+6gwqbZCYETE0qWv/VSHHIQrBAJi6dJXxkG4QiAgli59ZRyEKwQyYmnpq4mf
g3DdkIxYkhzYzT1iYJyavHVDMmJp6avpjbXfjYy11g3JiKVLXxkw7oqggFi6
9JVxEK4ICoilS18ZMO6K4D17egf2Z5vNl4kj1jf6a/WKiEm1FQIjIpYufWVS
7QqBgFi69NU1oV5MOb1CQCxd+sqcg3CFQEYsLX01/XMQgRnPdUMyYnm5U0Qx
MO66IRmxtPTVxMG464aMiFi69HUw1gZmPFcEBcTSpa+Mg3BFUEAsXfraH2tD
YNwVQXcG0IpY33BnGybVVgiMiFi6lJJJtSsEAmLp0lfGQbhCICCWLn1lzkG4
QiAjliMOpYydg8AxDDckI5bu8z1jDsJ1QzJi6aKz2FjruiEjIpau8DFg3BVB
AbF00RnjIFwRFBBLF50xY60rgi5z0IpY33BZSizVnhAIiKVLX5lUu0LQ3Vyx
kFi69JVJtSsEAmLp0lcTPwfhCoGAWLr01cTPQbhuSEYsLX01cTDuuiEZsXTp
awyMu26Ign79UmLp0lcGjLsiKCCWLn1lHIQrggJi6dJXBoy7Iogqe+9M8bMG
mIj1DbcTxlLtCYGAWLqdkHEQrhAIiKVLXxkH4QqBgFi69NXEz0G4QiAgli59
NfFzEK4bkhFLahQ3zvRzHgPjrhuSEUuXvsbGWtcNGRGxdOlrDIx7Iiggli59
ZRyEK4ICYunSVwaMuyK458DrsRFLHLG+4TqvWKoHQtC/J0VALF3nxaTaFQLB
PpYufWUchCsEAmLp0lcTPwfhCoGAWLr01cQdhOuGZMTSpa8xB+E6ehmxdOlr
DIy7bsiIiKVLX2Ng3BNBAbF06Ssz1roiKCCWLn018bHWFUGXImpFrG+4eYul
2hMCAbF06Wss1efObRECAbH08hZLNRWgPSAFxNKlryZ+DsIVAgGxdOmriZ+D
cN0QiOUfComlS19jYNx1Q0ZELF36GgPjrhsyImLp0tfYWOuJoIBYuvSVcRCu
CAqIpbcBeAyMuyLo6qZWxK4zd+e0WKo9IRAQS3dOi6XaEwIBsfTmtJiDcIVA
QCy9fSpi5yBcIRAQS5e+mvg5CNcNyYilS19jDsJ72JaAWLr0NQbGXTdkRMTy
BofPxMC4J4ICYul215iD8ERQQCw9aBAD464IPuP4dK2IzRsuF4ql2hMCAbF0
uVDMQXhCICCWLn01cQfhCoGAWLr01cQdhCsEIJa0Vv4qHn2NOQjXDQmIpUdf
Y2DcdUNGRCxd+hobaz2FFRBLl77GxlpPBAXE0qWvJjLWeiLoHZk54T3gLAbG
XRH0jkyViPUNt6vHUu0JgYBYel09mGpPCATE0uvqQQfhCYGAWB7Y2tVj5yBc
IRAQS4++xhyE64YExNKjrzEw7rohIyKWLn2NjbWeGxIQS5e+xsC4J4ICYunS
VxNxEJ4ICoilS19NfKx1RZDfsU0Wsb7hushYqj0hEBBLz0UGU+0JgYBYei4y
mGpPCATE0nORsXMQrhAIiKVHX2MOwnVD/ZZYQiw9+hoD41Nbr6oVEEuXvsbA
uOeGBMTSpa+xsdYTQQGxdOmriTgITwQFxNJ7gHtwrPVE0CNvKhHrG+4xEEu1
JwQCYukdA8FUe0IgIJbeMXD13QebqfaEQEAsvWMg5iBcIRAQS+8YiJ2DcN2Q
KSeWHn2NOQjXDRkRsXTpa2ys9dyQgFh26euUk43QWOuJoIBYuvTVRByEJ4IC
YunSVxMB454IelqjErG+4c2cwVR7QiAglt7MGXQQnhAIiKU3cwYdhCcEAmLp
zZxBB+EJwQd/LSaW3swZOwfhuiFTTiw9+vpaxEG4bsiIiKVLX2NjreeGBMRy
bOtxFQTjnggKiOUNW4+r4FjrieCBcmLpHVdBMO6JoOdtVSLWNzzGFUy1JwQC
YukxrmCqPSEQEEuPcQUdhCcEAmLpMa4Hnwo4CE8IBMTSY1wxB+G6IVNOLD36
GgPjrhsy5cTSo6+xsdZzQwJi6dJXEwHjnggKiKVLX01krPVEUEAsPfoaHGs9
EfR+TZWI9Q1PoYKp9oRAQCw9hQqm2hMCAbH0FCqYak8IBMTSU6jgOQhPCATE
0junFnMQrhsy5cTSU6iYg/DcUCmx9OiriYy1nhsSEEuXvprIWOuJoIBYuvTV
RByEJ4ICYunR1+BY64mgNz2WxObSrh24TmN6fsujkWJ9w3PEwVR7QiAglp4j
DqbaEwIQS9uxc8JzxMFUe0IgIJaeIw6eg/CEQEAsPUccdBCeGzLlxNJzxDEH
4bmhUmLp0VcTAeOeG3KvFcwMl76ayFjriaCAWLr01UQchCeCAmLp0dfgWOuJ
oEer8mN9ZbbTmVjZMBtH6V/GjzopD/aN5jXDwVTfev+iKwQCYukdz0EH4QmB
gFh6x3Mw1Z4QCIilR1+DDsITAlNOLL3jOXgOwnNDppxYesdzzEFQN3bdUCmx
bB7PwbHWc0MCYunSVxMZaz0RFBBLj74Gx1pPBAXE0qOvQTDuiWCzP2fG8vTY
9t0rq0eXl5ZXjp9cczt1sG805+dgqj0hEBBLb34OptoTAgGx9ObnYKr3bhUC
AbH05uegg/CEwJQTS29+DjoIzw2ZcmLZnJ+DDsJzQ6XEsjk/B8dazw0JiOXI
1g8fHGs9ERQQS4++BsdaTwQFxNKjr8Gx1hPBph/MjJXZMeoPO6ZnJsdp3Jh1
cxHsG01eF0y1JwQCYunxumCqPSEQEEuP1wVT7QmBgFh6vC7oIDwhMOXE0rsn
OuggTpza4oZMObFs8rqmg2i6oVJi2eR1wbHWc0OlxNKjryYy1noiKCCWHn0N
jrWeCAqIJS1x6U1f3AUWHGs9EWxmIDOWZ0Y7kxiGT+7ojC2uf/GfOlsDf9i8
o4EOiW9O7PFgVHfDjakvNtwQEEtPbR96OnBIdLcIvuaLy9cFxNJT24XQIYGT
QX8dnAwSEEsqK1dt33x3rXlIoLWuOK21lFh6aounaXiHBFrrUy9+4YZKiWXz
jgYyetc4RWEGrfV3e79wQ6XEsqm212w9JYGgX5+OAfs/S4llU21xodGnW6/p
8lqrgFh+dyt9fexg94Lw4+9uISReaxUQS4++vnT4i+04bPRbq0MaR+I70jNx
fG6iM76r2y3WFkc7o0tb+0bz9c0939A87VVqpvfcKBpT3aoXEEvP3aN5vry1
osk2ulUvIJaeuwcTmHvumPsaso2dq7/QIAGx9Nz9x73O41X0/U+85s3YpcSy
6e4vuWHvtfdsqWiMqYeOfdHAS4ll3907l4WQUb10683O2LDOrfpSYtl092RU
L9ha0XhciFv1pcSy6e7ReewtHgj67W5wql5ALD36CqP6/PIWEEfHoVv1AmLp
0VcY1T/8cQuIw5Xbm+fO2T/xCE92rO3eMYqJYnL/looL9o1mbTYrGl95pzOT
lBLLJn1tVnSzOwmIpVebwYr2upMpJ5bN2mxWtNedTDmxbF7/3KzoZncqJZbN
2mxWdLM7lRLLZm0CPbkV3exOpcSyWZuYJdyKbnYnAbH0ajNY0V53EhBLj75S
EdEAc8eDWw5UrzuZRk8rio319Y2GFAT7RtMLNCsaP7rLJ0uJZdMLNCu62Z0E
xLLpBbyKbnYnU04sm16gW9E3banoyyf97lRKLJteoFnRze7UI5YFtxw2vUCz
opvdqZRYNr1AU6Ob3amUWDa9AP7ErehmdxIQS88LoKLdJwo1u5OAWI410PFl
t+6/cuv+nF53Ms6zM7Qi2DeaO1I2KxqSdMw5e1JKLIPs0avoZncSEMvmM3S8
im52J1NOLJvs0avoYHcqJZZN9tis6GZ3KiWWzR0pmxXd7E6lxLLJHpsa3exO
pcTyeAM0NSu62Z1KiWWQPXoV3exOAmLp0VfTO2fxT87+Fc3uFHxXZQT7RnBy
8Cr613u617t+7NyNwmwVHozgfjKk2m5FN7uTgFg2JwevopvdyZQTy+bk4FV0
sDsxDxsKRvNcp1fRwe5USiybk0OzopvdidkqPBhN+tqs6GZ3KiWWwclhbGtF
N7tTKbEMTg5eRZMQe93JlBNL79pXMzgLuX62bw+b3cmEppTKCPaNIKnwKprs
vLe7VymxDD5xw6voZncS7GPZJBVeRTe7kyknlk1S4VV0sDuVEssmqfAqGt3J
68alxLJJKryKphb0rUZ3KiWWTfpqGhrd7E6lxDJIKm7YWtHN7lRKLIOkwqvo
Zncy5cSySSpwXcHht/on6frdaauPu3zrNTD1Eewbwd0nvIq+dMc+72kppcQy
2Ge8im52J1NILIN9xqvoZncy5cSy2We8ip577lizO5USy2af8So62J1+V0gs
g7tPuBUd7E6lxDLYZ1yNDnanUmIZ7DOo6L+d7Z92b3anUmIZ7DNeRd9yn9+d
TDmxbPYZ7HdkqUKwO/14astZmPoI9o3glRhuRVP3uKDx9PlSYhm8EsOr6GZ3
MoXEsu9rHtsyQHoVHexOpcSy6Wu8ig52p1JiGbwSw63oYHcqJZZBX0MVbfeB
DHanUmIZvBLDrehgdyollvA1L2z1NW5FB7tTKbEM+hqvopvdyZQTy6avwbV/
1C7wP4Pdybvqoz6CfSN45adb0aBGeLitjVJiGXwekFvRwe5kColl8FN5FR3s
TqXEMvgEc7eirw11J/oMRcQy+Kncig52p1JiGeSobkUHu1MpsQw+D8it6GB3
KiWWwU/lVnSwO5USyyZ9NVsrOtidKMj75xPL2KfqXP2YPfaC3ena0AV1NRHs
G8E7TdyKpu4xMnj4i41SYhmkr25FB7uTKSSWsd28bUXHulMpsQxOQW5FB7tT
KbEMTkFuRQe7UymxDN5p4lZ0sDuVEsvgFORWdLA7lRLL4G7eZ5yKDnYnU0gs
Y1OQrehgdzKFxDI2Bf3ojvkfTnZtSKw7xXa7FUfwOQjBO1vdiqbuMeJsjooo
vcYydp2YrehgdzKFxDL2vGNb0f3u9KyPc0uJZZC62IqOdadSYnnZbfub1MWt
6GB3KiWWQeriVnSwO5USy+B1Yq5GB7tTKbEM0lfjVDS6U/N+zCJiGaMutqJf
7j2fsdmdiohljLpMzr5I7YKaRqw7eXfR1kdw3ojtpGEr+o4Hl6iHuBeyIoqI
ZWzvX1vRwe5kColl7CyPrehYdyoilrGzPLaiY92plFgGe6at6Fh3KiWWwZ7p
VnSwO5USy9jev7aig90JtWPtfDJiPZPGNlR0sDuZQmIZ65m2omPdqYhYxnom
tswixxfrTt6uHfUR7Bs7Izt32Yqm7hHELEXEMnYfnK3oWHcqIpax++BsRce6
UxGxDNJX41R0rDuVEsugR7MVHetOpcTyqrvC98GhomPdqZRYxjyarehgdyol
lrH74G4fVHSwO5lCYhmkr8apaOzv1+xORcQy5tHsbSCx7uTtElYfwb4R2ynU
VvQ/Xfv4jaGUFhHL2H33/Yo+/kGsOxURy9jT2G1Fx7pTEbGMMWFb0bHuVEos
g/TVDCo61p1KiWUsw6joWHcqJZaxq1ih0eTdgt2plFjGnsZuKzrYnUwhsYxl
2FZ0rDsVEcsgfTWDSy7pz2PdyduVtD6CfSO2MzkqGq012PCLiGVsnx9b0bHu
VEQsY3fN2IqOdaciYsk8SxEVjS7U7E6lxJImusnQRIeKjnWnUmIZm+i6FT2x
BxsRNLtTKbGM7fODisZnbnYnU0gsYxMdxl2aEILdyRQSy9izFG1FUxcKdqci
Yhmb6OxtILHuFHs+lziCfeOuh8NPQkFFo6CC42gRsYztK4iKxirB7nTdvc/l
E0vmLl1UdKw7FRHLGH01g4qOdadSYhkjSKhoKHizO5USyyB9NYOKxk/T7E6l
xDJGkKDRWKXZnSi+ta2AWMbu0kVFY5VgdyoiljH6ioqmLhfrTkXEkiFI3dtA
elv6BLuT99SV+gj2jdiT13D2ij5hzCwXEUtmH2OqaKwS7E5FxBKje/DJa1TR
WCXYnYqIJXONPSqa/EWwOxURS+Yae1Q0fZ1gdyollrH+j4qmVYLdqZRYxs5Y
oaLx09gd2NwoIpbAnk36iorGKsHuVEQsmf5PS2CVYHcqIpZM/6d2cfH1e2Pd
yXvKW30E+wbzpFeqaPoAMZRXRCxj9NX0KhqrBLtTEbFkdiGjisYqwe5URCyZ
XchQ0bHuVEQsY/TVDCqa/gl2p1JiGfObqGj6J9idSolljL6ioumfYHcyhcSS
8Zso51h3KiKWzC5kVNFYJdidiohljL6awd68se7kPVW2PoJ9o7s1X+TJ8qjo
2PazRcSSeU6Trehg2RYRS2bXU1vRwbItIpYx+mqcig6WbRGxZK7ItRUdLNtS
Yhmjr7aig92plFgyRwsqOla2RcSS2UMAFR3rTkXEMkZfjVPRwe5URCyZowWg
LNad8BR7b9PCmgj2DdIa+uGCr0dFx4aKImLJPBcSFR3rTkXEsv/EitAu67ai
g92piFgyexbZig52pyJiydBXW9HB7lRKLGP01QwqOjZUjJQQS2Y6RUUHu5Mp
JJbevq9u4ECKdaciYslMpziQYt2piFjG6KsZHEix7hTci7smgn2DvO33tm49
ZwMVHTuoiohljL6agbmIHVRFxJJ5qgsqOnZQFRFLhr7aig4eVHCs7pMRmGDo
qxlUdPCgKiWWzPV7qOiY5SkiljH6agYVHetORcSSoWGo6Fh3KiKWzB6JqOhY
dyoiljH6aga3gcS6k/dkhPoIXmdOv+a/3RYeIFHRsZtei4hljL6aQUXHulMR
sWToKyo61p2KiGXs2lcEVXSsOxURS36HE1T0h6HuVEQs+R1OUNExIFNELJmz
b6joWHcqIpbM/QLMFQWmkFjGrn01g4qOdaciYsloGW4DuSzSnXDqnEQqZ5Wc
CM4b//HLP443HmOBoCPwwMsngrOQKSSWDH2l/NMqb0S0vohYMvTV9PIZK4Ei
Ysk/A+Klw6eCrtMUEkv+GRCHj38Q29y1iFh+HKevpodK6KdpXlmEKCKWzNU+
VEe0SuxXKyKWMfpKsX72U1olZkWLiCXjnWmiplVeDw0JppBY8s+AIPF69Wi4
M5ARjqEPWQT7RvfBKFt3Os2MImLJ0Fc+iohln76eDdBXPoqIpeCZU4giYsnQ
Vz6KiKVgB1cbRcQyRl+TUUQs6UjGVeulUUQsS3dwtVFELBn6ysdLRwKPWamJ
YN/4/s1PBq8eSUYRsWToKx9FxJKhr3wUEUuGvvIRe9R7MATPuLSRTywZ+pqM
ImLJ0Fc+iohl6f5LNoqIJUNf+SgiloJnXCIOhZ4eWBPBvkF+8Lp7C7bktVFE
LBn6ykcRsWToKx9FxFLwTG1EEbEUPFPbRj6x5OkrH0XEsvQJNTaKiCVDX/ko
Ipal+z3aKCKWgmdqI470Hmj+lPNA88oI9g3KAOVB8LcVEUuGvvJRRCwZ+spH
EbFk6CsfRcSSufY1GfnEUvBEPBv5xFKwv7SNImJZur+0jSJiWbpbi40iYhm7
9jUZJLL0RhLc8g8YjmDf6Fz96G0PvND882QUzVE0PcboKx99Ynks60G0DH3l
o4hY8vSVibMbn+UTS8ETeG3kE0vBE3ht5BNL5trXZBQRy9LnWdgoIpYMfeXj
hRJiWbo7nA0y9SOhrfPEEewb3jMs8qOIWIrpaxGxFNPXImIppq9FxFJMX00J
sVyR0ldTQixr6GsRsRTT1yJiKaavRcRSTF/fO9O1w1SegvcGo9k3qJuNRO6O
SUYRsRTT1yJiKaavRcRSTF9NCbEU01dTQixr6Gs+sayhr0XEUkxfi4ilmL4W
EUsxfcUdqWQHBO8NRrNvfPLpJi1xz56CB6LZKCKWYvpaRCzF9LWIWIrpqykh
lqCvJ07lbtbhRj6xrKGv+cSyhr4WEUsxfS0ilmL6WkQsxfQVD3/87dwhwXuD
0ewb62e7S/xOtEQRsRTT1yJiKaavRcRSTF9NCbEU01dTQixr6Gs+sayhrw89
nUssa+hrEbEU09ciYimmr598Jh8GgtHsGxhpdopGmiJiKaavRcRSTF+LiKWY
vpoSYimmr6aEWIK+Luf9iF7kE8sa+ppPLGvoaxGxFNPXImIppq818CEYzftT
Tp35SIxQioilmL4WEUsxfS0ilmL6akqIpZi+mhJiWUNf84llDX3NJ5Y19LWI
WIrpaxGxFNNX0yu3X/xeUm7BaM4bJ9AAQ7t/JCOfWNY0wCJiKaavpoRYiumr
KSGWNfT1xpnnv5tHLGvoaz6xrKGv+cSyhr4WEUsxfS0ilmL6ano7bt16v2S8
D/9tjb7RN1zPSy4RySeWNfS1iFhecoOQvpoSYimmr6aEWNbQ13xiWUNf84ll
DX3NJ5aQGBl9LSKWYvpaRCzF9NVU4MRgNPvGkbfkl6TmE8sa+lpELGvSlU8s
xfTVgFjmDZ819DWfWNbQ13xiWUNf84llDX3NJ5Y19BXE8td7suywmL6a3unL
7ffk3nKYjGbfOHSsO0AeEN0Ck08sa+hrEbEU01dTQizF9NWUEMsa+ppPLGvo
az6xrKGv+cSyhr7mE8sa+lpk2MX0leIHtzx51V1Cw96MZt8ADsJz50sjn1jW
0NciYimmr6aEWIrpqykhljX0NZ9Y1tDXfGJZQ1/ziWUNfc0nljX01ZQQSzF9
pfjh5NPiQ7QZzb5Rs8VHPrGsoa8mm1ieQzN/WDJAmhJiWUNf84llDX3NJ5Y1
9DWfWNbQ13xiCfp68BUJfc0nljX01ZQQSzF9Nb2R+ArZSLyxPN4ZX9o6Qjb7
xsFX5FuK5RPLGvpqsollDX01JcSyhr7emk0sa+hrPrGsoa/5xLKGvuYTyxr6
mk8sa+irKUFwYvpqegjusttyN0lzYmP3BDWJseVU36jZwjSfWNbQV5NNLGvo
qykhljX0NZ9Y1tDXfGJZQ1/ziWUNfc0nljX0NZ9Y1tBXk00sa+irkYrOUeoa
45PbxyaS80bNlun5xLKGvppsYllDX00Jsayhr/nEktn3NRn5xLKGvuYTyxr6
mk8sa+hrPrGsoa8mm1jy+74mg0xu8NGxTGwc393p7DhpNneNjS9tHVSbfQNo
662TxVtXmRJiWUNfTY9YXpNBLGvoqykhljX0NZ9Y1tDXfGJZQ1/ziWUNfQWx
pAkq+coa+mqyiWUNfTXZxLKSvt583+JF15T9rDPUHSam5+ZmxzujO2bmTjqt
o7M1zECYYjuWJyOTWFZusExjwEQGsaykr5nEspK+5hPLGvqaP0Zed6+cvuYT
yxr6ijHygX3pMbKGvppsYvnq0ffE9NVkE8tK+ioYI48vLy4sLCwu7N8+Ojo9
t7TmbDPWnDd2Ys8u0QBJ8e2rHr09Y2IvespAM2hiz7m78+iJDzOvJwnG7XmP
dSi6nqQZmNhzyEPRUwa8ONCb2HNuOdx217P5TxnwAgnflzGxw50Jtq4yg4k9
B3fvPlD1XNSLr9+bk/CiO+CaQSYlhzxU7tn1K+leYeRXZscmkj6FDBT9/bEH
ZCQjM9VkBmmVY1IhyEz18jH5TRAmO9Vk0muEAMd2zp7G3Z4sPQ334l9wbKdv
HRqvuAninfdzj+2iR+14AfKQc2Zhp3QDcMQPbtmfQx4qRfD63zyfs6tGpQj+
pq6uvWj2jRohMNmprhSCzFRXCkFmqlfr3NC+XgsNPrzPjcpbofsgOqOF/uAW
uRs602uhOzNaKP2CpZjODWqhOSfUIIIyN2R6Yy39k3wZRFDshmis/da29Am1
ShHEWCv2EV40+wYJwbelON1kp7pSCDJTXSkEmamuFAI4iOS5y0o3lO8gyA3F
HkqYDDiI32Qw/xo3ZHpjbc4FM5Ui2NvvIv0hK0UQY+251IesFMHBh5RcMNOM
Zt8gIbi4QggyU10pBJmprhSCzFRXCgEcRPLapEo3lO8gatwQhqJfZQxFNW7I
9MbanDtDe25IsiEnIrMWKkUQY23y6SGVIrivjgx40ewb2/IKPxaZqa4UgsxU
VwpBZqorhQAOInkTcaUbynQQ9RtDZYLxGjdkssF4pRvKBOOVIpgJxitFMB+M
50Szb/SEQHhxkclOdaUQZKa6UggyU10pBHAQyUvuK91QpoOodEMmG4zXuCGT
DcYr3VAmGK8UQahb8pL7ShHMB+M50ewblffbZqa6UggyU10pBJmprhQCOIjk
3Q2VbijTQVS6IZMNxmvckMkG45VuKBOMV4pgJhivFMF8MJ4Tzb5Rc5GAyU51
pRBkprpSCDJTXSkEcBAP7EtcB1jphkyeg6h0QyYPjNe7oUwwXumGMsF4pQhm
gvFKEcwH4znR7BuZ/jQWmamuFILMVFcKAe47SKa6Uggyr2KqdEMmz0FUuiGT
B8br3VAmGK90Q3vywHilCGaC8UoRzAfjOeHtZ57Pw2ORmepKIchMdaUQZKa6
UgiQ86nUVUyVbsjkOYhKN0RBrSkJxuvdUCYYr3RDmWC8UgQzwXilCOZfWpMT
3rwBIcg5/x6LzFRXCkFmqiuFIDPVlUJgerfT3pq6iqnSDZk8B1HvhnLAeL0b
wlh7eo0D4/VuKBOMV4ogxtokGK8UwfxLa3LC6xsfVDelzFRXCkFmqiuFIDPV
lUJg8q5iqnRDJs9B1LuhHDBe74b2ZIDxejeUCcYrRTATjFeKYL2VcMPrG/XP
u89Jdb0QZKa6UggyUy3Y2cCLnKuYKt2QyXMQ9W4oB4zXu6EcMF7vhjLB+IV1
IpgJxitF0PTG2hp0ueWv2to3sCF5DXTNSXW9EGSmulIITF6qK4XA9BzEFamr
mOrd0O0ZdxDkb+8TixwwXu+GcsB4vRvKAeP1ItgH448mwHilCJreWEtmp+Zv
sOH1jeXqk7w5qa4XgsxUVwqByUt1vRCQg/j+zU/yr6l3QzkOot4N5YDxejeE
sXbxEDfWFj1HOBgYa3ez43e9CGaC8XoRzLy0Jie8vjEQAvlFZTmprheCnFSr
PEs3J9X1QkAOInkVU70bynEQ9W4IDuLoCc7p1LuhHDBe74ZywHi9CJo8MF4v
gpn3nOaE1zeKHigfjJxU1wuByUh1vRCYvFTXC0HOVUz1bijHQdS7oRwwXu+G
csB4vRvKAeP1ImgywLiKCGbec5oTXt+o3E7H5KW6XghMRqpVhCAn1TVPtUDk
XMVU74ZyHES9G8oB4/VuKAeM17uhHDCuIoJ0jPH7XqqIYA4YzwyvbwyEQH6T
fk6q64XAZKRaRQiSqVYRAjiIj9irmOrdUI6DqHm0EyIHjNe7oQEY57YYrXdD
JgOMq4hgEoyriGAOGM8Mr29Ubi7a/ztTqa4XApORahUhSKZaRQhyrmKqd0M5
DqLeDeWA8Xo3lAPGK3fYRiTBuIoIJsG4ighWbDHqh9c3KjcXRSRTrSIEyVSr
CEEy1SpCkHMVU70bynEQ9W4oB4zXu6EcMF7vhkwGGFcRwSQYVxFBxS1GvftT
6oXAZKRaRQiSqVYRgmSqVYQADuL1+FVMKm4ox0HUu6EcMF7vhkwGGK93QyYD
jKuIII21F7JgXEUEFbcY9eaNml2mbSRTrSIEyVSrCEEy1SpCAAfx6tHoVUwq
bijHQdS7oRwwXu+GTAYYJxG8oFoEk2BcRQSTYFxFBDPvOc0Jr2/UXyRgMlKt
IgTJVKsIQTLVKkKQvIpJxQ3lOIh6N5QDxuvdkMkA4/VuyGSAcRURTIJxFRHM
AeOZ4fWNys1FEclUqwhBMtUqQjB4zFk01SpCkLyKScUNJR2EihsyGWC83g2Z
DDCu4oZun32RB+MqIpgE4yoiqLjFqNc3KjcXRSRTrSIEyVSrCEEy1SpC0H8w
cfwqJhU3lHQQKm6IYjQFxuvdkMkA4ypuKAnGVUSwD8bfi461KiKouMWo1zcq
NxdFJFOtIgTJVKsIQTLVKkLwzvvr9JfQsRF7gYobSjoIFTdkMsB4vRsyvbGW
f3qvihtKgnEVEcRYy4BxFRFU3GLU6xuVm4sikqlWEYJkqlWEIJlqFSFIXsWk
4oZMykGouCGTAuNabqj7oGQWjKu4oSQYVxHBJBhXEcHMfS9zwusb9ffOmIxU
qwhBMtUqQpBM9ayGECSvYlJxQyblIFTckEmBcS03lATjKm4oCca33XmgXgST
YFxFBDHW8mA8M9y+obUjUDLVKkKQTLWKECRTrSIEyDwdG7EXqLgh03MQ2+IO
4tWjCm7IpMC4lhtKgnEVN5QE4yoiiLH2mZeiYFxFBPtg/Enu4vzMcPtG/eai
iGSqVYQgmWoVIUimWkUITP8qpqiDUHFDJuUgtNwQD8a13NAAjIfHWi03hLF2
OQ7GVUQwCcZVRFBxi1G3b9RvLopIplpFCJKpVhGCZKpVhMD0HARzFZOKGzIp
B6HlhngwruWGeDCu5YaSYFxFBJNgXEUEFbcYda8zr99cFMGn+pySECRTrSIE
yVSrCIFJXcWk4oZMykFouSEejGu5IR6Ma7mhJBhXEcEkGFcRQaO3xag7b2gJ
AZ9qLSFIplpFCEwq1SQEl1ULgcFVTL+IOggtN8Q7CC03xINxLTfEg3EtN8SD
8b4IPvxy5SoYa++Ng3EVETQZl9Zkhts3IAT1p3f5VGsJQTLVKkJgUqnWEgL+
KiYtN8Q7CLihD6vdEA/GtdxQH4y/Fh5rtUSQB+NaIpgE41oiyIPx/HD7Rv3m
ogg+1VpCwKdaSwhMKtVaQsBfxaTlhngHoeWGeDCu5YZ4MA4RPPhKrQjyYFxL
BE0KjGuJoNYWo27fqN9cFMGnWksIDJtqLSEwqVRrCQF/FZOWG+IdhJYb4sG4
lhviwbiWG+LBuJYIGhaMK4qg1hajbt+o31wUwadaSwgMm2pFIeBTrSUE/FVM
Wm6IdxBabogH41puiAfjWm6IB+OKItgdayNgXFEEtbYYdftG/S7TCD7VWkJg
2FQrCgGTakUhgIM4uxG+iknLDfEOQssN8WBcyw1hrJ2NjLVabsiwYFxRBBkw
riiCyXtOM8PtG1oXCRg21VpCYNhUKwoBk2pFIeCvYtJyQ7yD0HJDPBjXckM8
GNdyQ4YF44oiyIBxRREs22J0c3V2+yiu05ieP+7+F7dvqGwuimBSrSgETKoV
heDOeKoVhYC/iknLDfEOQssN8WBcyw3xYFzLDVGM3RoF44oiyIBxRREs2mJ0
dW68MzpzetOsrezqdCaObn7xn9y+obK5KIJJtaIQMKlWFAIm1YpCMHAQgauY
FN0Q7yC03BCNrAwY13JDhgXjWm7IsGBcUQS7YDwy1iqKYNEWo6dX5udXei1x
Y7HTGV1yStbtGyqbiyKYVCsKAZNqRSFgUq0oBM/2r2IKOAhFN8Q7CC03xINx
LTdk+mNtGIzDDamswoBxRRG8Mw7GFUVQtMXoyZmxzujUgjNufHGdOaJ+c1EE
k2pFIWBSrSgETKoVhYC5iknRDfEOQssN8WBcyw0ZjLURMK7lhgwLxhVFkAHj
iiKYvOfUi43VhYlOZ3x6S9MwW+cNlXtnEEyqFYWASbWiEDCpXtQTAuYqJkU3
xDgIRTdkWDCu5YYMC8YV3RADxu999FUtEWTAuKIIPpu659SNjeNzXSK60CWi
m5tbOofbN67Q2FwUwaRaUQiYVCsKAZNqRSHoX8UUchCKbqh/DiLkIKj9arkh
w4JxLTdkWDCu6IYYMK4oghhrV0NgXFEEMda+ELk434u57a4XGY/xDZXNRRFM
qhWFgEm1ohAwqVYUAuYqJkU3xDgIRTdkWDCu5YYMxtoIGL9Czw0NxtrAsaQo
ggwYVxRBrS1G3b6hsrkogkm1ohAwqVYUAibVikIABxG8iknRDZm4g1B0Q6bn
IMZDDkLXDTFgXNENMWBcUQQZMK4oglpbjLp9Q2VzUQSTakUhYFKtKARMqhWF
gLmKSdENmbiDUHRDJg7Gdd0QA8YV3RADxhVFkAHjiiKotcWo7Rta2+kgmFQr
CgGTakUhYFLdF4JPN5v/qTSYq5gU3ZCJOwhFN2TiYFzXDTFgXNENMWCcRPBH
d+iIYH+sDYFxRRHkL63JD9s3IAQqew8aNtWKQsCkWlEImFQrCoHpOYjbQg5C
0Q2ZuIOAG/rzio4bioFxXTeEsfaDxlir64YYMK4oggwYVxRBBowXhe0bWpuL
IphUKwoBk2pFIWBSrSgEJn4Vk6IbMnEHoeuGYmBc1w3FwLiuG2LAuKIIMmBc
UQS1thi1fUNrc1FELNW6QsCkWlEImFQrCoGJX8Wk6IZM3EHouqEYGNd1QzEw
ruuGGDCuKIIMGFcUQaO0xajtG7pCEEu1rhAwqVYUAhNPtaIQmLiD0HVDMQeh
64ZiYFzXDcXAuK4bioFxXRFkxlpFETRKW4zavqG1yzQilmpdIWBSrSgEJp5q
XSHoOYgnm3+u64ZiDkLXDcXAuK4bio21uiIYA+O6IsiAcV0RZC6tyQ97NZju
RQKxVOsKQSzVukJg4qnWFYLYVUy6bijmIHTdUAyM67qhGBjXdUMxMK4rgiYO
xnVFMDbWFoWdN7Q2F0XEUq0rBCaSal0hMN1UzwdTrSsEsauYdN1QzEHouqEY
GNd1QzEwruuGNiJjra4ImggYVxdBlS1Gbd/Q2lwUEUu1rhCYSKrVhSCWal0h
iDkIXTcUcxC6bogG16CD0HVDMTCu64boF7kgBMbVRTA41qqLoMoWo7ZvaG0u
ioilWlcITCTV6kIQTLW6ENCxEXQQum4o5iB03VAMjOu6odhYq+uGTASMq4tg
cKxVF0GVLUZt31DcXLT/N4dSrSsEJpJqdSEIplpdCGJXMem6oZiD0HVDMTCu
64ZiY62uGzIRMK4ugkEwri6CzD2n+WH7huK9M4hgqtWFIJhqdSEIpvr0mrIQ
xK5i0nVDMQeh64ZiYFzXDWGsbYJxXTdkImPtM9oiGATj6iIYG2uLwvYNrV2m
bQRTrS4EwVSrC0Ew1epCEHQQ6m4odg7i+zdruqGYg9B1QyYCxnXdkImMteoi
GBxr1UUwNtYWhe0bipuLIoKpVheCYKrVhSCYanUhCDoIdTcUcxC6bijmIHTd
kImMtbpuyETGWnURDI616iIo2mLUD9s3SAi0NhdFBFOtLgTBVKsLQTDV6kIQ
dBDqbijmIHTdUMxB6LohExlrdd2QiYBxdREMjrXqIli6xWgwbN9Q3FwUEUy1
uhAEU60uBMFUqwtB0EGou6Ggg1B3QyYCxnXdkImMtepuKDjWqotgcKxVF8Gi
LUZjYfuG4nY6iGCq1YUgmGp1IQimGkLwmp4QBB2EuhsKOgh1N2QiDkLXDZnI
WKvuhoJjrboIBsdadRGMgfGisNeZkxBobS6KCKZaXQiCqVYXgmCq1YUg6CDU
3VDQQcANPfiUmhsyEQeh64ZMZKxVd0PBsVZdBINjrboIMrvW5IedN2jY09ok
EIHv6202Tqtc8fOnFVeB6Ht3RNIPeuG2PYqrQPSfeP4N9w93hr5gTUD0va0C
D/S/4Htaq1B897q56+7dcpEtHavNL1gZJPreZuN4gNQ9kSe6yoIa4Nev3P3Z
5jn3Dy9ufMHKgOh7T+HcFt9NXRZwvt7+dd2p5spHvC9YEydO/S14kW1RuPuL
6saBUEX3Hsy3qLhKsKLVu9NHHwcqGt1J8cy1CR3wg+50VnGViUZFt9GdmhWN
7rRXtTs1K7qN7hSsaPXuBJblVbR6d6JfhBpR7Lm6mdFe32hWNK6YfWBf7d6G
bgQr+ttXRR8bKo7mQaLenUxIo9voTlMPLXkV3UZ3alZ0G92pWdFtzE7Nim6j
OwUrWr07mR6djj3nLjPa6xvNil7uGav5pSpj1QwvsW10JxOq6Da6U1Oj2+hO
zYpuozs1K7qN7tSs6Da6U7Oig4NufXgV3UZ3oqB6iT2QPTPa6xumUdEAia+/
HXjcSU14Fd1Sd/IquqXu1KzoNrrT4iG/otvoTs2KbqM7NSu6je5kehU94VR0
G93J9E4cuBXdUne6p3fiILgPfGa02je8isYTpWkO0V3Fq+iWupNX0TjNod6d
PI1uqTudaFR0G92pWdFtdCfTqOhud7rqUd3uZBoVPdtOd7p3a0W31J2oEVXW
SKt9w0PBXua1wqvolrqTV9EtdSdPo1vqTl5Ft9SdTKOi2+hOpnFctdSdvIpu
qTt5x1VL3Yka0UjkIeaZ0Wrf8Cr6B7dsOYq0wqvolrqTV9E4itS7k1fRLXUn
s7Wi0Z1qjqJYuL9Fe93Jq+iWupP3W1zRTnfyfouWuhM1osrfotW+4VY0VQS5
icqzP8HwKrql7uRVdEvdyWyt6Ja6k9lKxtrrTm5Ft9ed3M/fXnfyPn9L3QkX
4NnP31J3okZ0Yd3nb7VvuBUdPDetEm5Ft9edzNaK9iZwxXA7UnvdySVj7XUn
t6Lb605uRbfXndyK9qpbN9yKbqk7UVA7uqJid2J7nbniR7LhVnR/9jhUdVV8
LGwVt9edjFPFrXYnt4rb604uGWuvO7lV3F53cqu4ve5knIpurzsZZ8ZotTvR
Fwlugp0Zrc4bxjnyg1fqaoU98lvtTvbIb56PUAxb0a12J5eMtded3CO/ve5k
nIpurzsZp6Lrz0cwYSu61e5EP0rNXRJt9w17tKhfZu+GPVpa7U72aGm1O9mj
pdXuZCu61e5knIpurzsZp6Jb7U62olvtTvbGrla70zN1Z3jb7hs2w83rLRXD
ZrjV7mQrutXuZCs6eE+EYqCiW+1OZlDRbXcnW9Gtdidb0fXXWzJhK7rV7kTF
UnNFWdt9w1Z08x5MxbAV3Wp3shXdancyg4putTuZQUW33Z1Q0Sr3YDKBij71
wUf1d2wxYSu61e5krxFttTvhNhDxFext9w1U9N7n3hhp3H2mGLaiW+1OZlDR
zftJdQMV3XZ3QkU/PH+k1e6EisYB0F53QkVjlfa6Eyr6sYPHWu1O2E6BKrrV
7mRC2ynkR9t9AxW9/Z6FNi6zd4NKAKu0153MoKLb7k6o6J/+qt3uBDJGSWu1
O6Gi8dO0151Q0Vilve6EisYq7XUn06von00fbLU7mdB2CvnRdt8wvYr+5sSe
Ni6zd4MqGqu02p2oorFKq90JGk0LtdqdUNG0SqvdCT6aVmm1O2Hqxk/TXncy
vYrGKu11J9O7sQurtNqdagbav0PfoIqmDNSc9MkJqmj6LiONnYJ0AxXddnei
isZ3abU7oaLpn1a7E2k0vkur3cn0KppWabU7mV5F4+u02p2oovHTtNqdqCnR
d5F9EUHfKH0LKrr0IpPSVaii8YMWdafSVWxFF3Wn0lWoorFKUXcqXYU0WtCd
ZAdMaXcSrIKKLu1OpQtRRdNbSrtT6Sqo6NLuVLoKNSV6i+xygr9D30BFl17U
KqvotruTrehWu5PV6Fa7kxlUdKvdya7SdndCRZfOTrKKbrs7oaLb7k7UlOgt
Miv0d+gbqOjSy+xlFd12d0JFt92dzKDWWu1OdpWvRndCRZc6O1lFt92dUNFt
dydqSvSWqYeW+L9zGMMYxjByQr1HDWMYw/jKxM79K7JHiA77xjCGMYzSGPaN
YQxjGKUx7BvDGMYwhjGMYQxjGExsnlzcPgoAPDF/vPvA7uPzU/jfU/PHv+xP
J4qN5fHO+FLv2eMbx+fHe99lfGpe7aHCf684vbQLv8z4dO/DbxyfHuv977Gp
4+fbl1lbmet/9h27T/f+5Dw9zNZXdnVGZ9Z6/944ujbmp/p/sL9XSl/d2Jwb
pzQsbRqzsmuiM7Z7Y21xrDM6v7qxsTo/2hlbOv++/cbuie7hudz95Gszo53J
+VWzsUrH6PTy2pf92UpiY4UKbdfKOv0LHYu7jm8sTY+NTtLxSQfn6Oj08pf9
+YpifXa0s2P/qjGrk90fYt2cn4fZ6uJMr/fN9j6vf3StLU1TF1zdMKvUEge9
5Ssamyvz+5dPU9sw60vdn/TUMn33GWg1/dbTS+fZtz9KXWN8cvvYRPdQXF+i
Y3K5pwQrM2P0Zb7sT1cQ6/RDbJ87efLo4tLy0eMn1zfXZ1Bx3Y5C/3p+HZbr
s2OdyYWTNENRrVGJrZ+Ph9nG8vaxHbtmJqgndD954+hanh70881l6ornSzOs
ic3TiyRqUwsn6Qcdm+w/7H5panzqvPhBB7FxfHens+Ok2dw1Nr600f1lx0en
MBWvLU2NTZ1XfWNltjfVT89M0i8zsbS2NjM2toBfY31x7HyTs5Vd3QF+rOu7
xmnuO38Ps82jM/2O1zi6lqfHJxf6fzA9Or74Ve8bmL6mF2iMpGRMj04u4M8X
J8fOox+UPnv3a0xMz83NkvfaMTN38oOlsc7gl+19mS/5A5bE+jJ9mykcevPb
O1NLb0+PDvrG2sLY6PR59MNAmnEordCPM7V0/h5m6ytf9A3v6CIjOegbp6c6
Y1/tvnF8/w7SgYXV7pfc3Nw0J/dT7a1sdBvrRKez+3wCcJvHlxcXFhYWF/Zv
p4Fxbmltc5W+266jG13oMd4Z3330y/6EBbG5urv/Q5B4dR3KB9Q9xnd1v0LP
i+0+j34YmvBpbkdJUd8YpQZ+3h5mvX4Oh+UfXSfnd3TGdm30596Jo5tf9mdt
LzaPbncvqR+bpb6/vKv/ZxOz5xd8s7ExOzax1DsS15Z39b/axK7TX/bHKo2V
3Tv6P8vk/h7lXR78WNvPH33ux8rcZP+zj+5YXutW1Hl6mG2QfwTfCBxda7sG
5yZnl8+7w00hNjfW1ze+Ku2y92W+7A8hDf+H2FxfXz9ff5juD7Hu/8H5fpg1
jq6vwHcaxjCGMYxhDGMYwxjGMIbx1Y7/D+tSCBE=
            "], {{0, 233}, {360, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 233},
          PlotRange->{{0, 360}, {0, 233}}]], "ExerciseOutput",
         ImageSize->{364, 233},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnd17XcWV5jMzN3M5/8L8F3M7l3Pb88ytyAc5HbqD6CaJ6A6okxAZAubL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              "], {{0, 233}, {360, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 233}, 
            PlotRange -> {{0, 360}, {0, 233}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.6"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0602d125-d85c-4996-b8a0-0fd6253a51db"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["\<\
Make a list line plot of the first digit of the first 100 multiples of 3.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztndtbE9maxntmbuZy/oX5L+Z2Lud2zzO3Y6u70zp2x253G7vbHbdKWhrw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            "], {{0, 233}, {360, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 233},
          PlotRange->{{0, 360}, {0, 233}}]], "ExerciseOutput",
         ImageSize->{364, 233},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztndtbE9maxntmbuZy/oX5L+Z2Lud2zzO3Y6u70zp2x253G7vbHbdKWhrw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              "], {{0, 233}, {360, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 233}, 
            PlotRange -> {{0, 360}, {0, 233}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.7"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a9442c83-5bf3-4389-a823-759bf707a811"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["\<\
Make a list line plot of the total of the digits for each number up to 200.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 8}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnV17VUX65ntmTuZwvsJ8izmdwzn9zzWn2+5Wt9r/NnZjG7pbYwuCCCiC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            "], {{0, 
            236}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 236},
          PlotRange->{{0, 360}, {0, 236}}]], "ExerciseOutput",
         ImageSize->{364, 236},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnV17VUX65ntmTuZwvsJ8izmdwzn9zzWn2+5Wt9r/NnZjG7pbYwuCCCiC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              "], {{0, 
              236}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 236}, 
            PlotRange -> {{0, 360}, {0, 236}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.8"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"125a81d8-f0f3-44d1-bf37-befe4c56bacc"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell["\<\
Make a list line plot of the total of the digits for each of the first 100 \
squares.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 9}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXV17E0eWnmf3Zi/3L+y/2Nu93NvZZ2/FDCFKMgnKDswoGYgSkjEQcAI4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            "], {{0, 154}, {240, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{240, 154},
          PlotRange->{{0, 240}, {0, 154}}]], "ExerciseOutput",
         ImageSize->{244, 154},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXV17E0eWnmf3Zi/3L+y/2Nu93NvZZ2/FDCFKMgnKDswoGYgSkjEQcAI4
fCgJzkAciMiA8+EEGzAGQxTAgCEiIBOHGHBAYINxBAJkkK093W/3camqu9Xd
kiUH6n00GVm0pJJ06tT5fM9/LHz599F/+d3vfrf03+g/v//jK/+1ZMkf//Y/
/05//G9s6QvPxZ5d9N+xvzz73LNL/nPhv9KDH9L/fqX/GffLvhGNRv1frKEx
z6HlWeNJgpZnjScJURPNXoWGRn2ghVnjSYKWZ40nCVqeNZ4kaPtZwxH37k89
nHrc7FUwxrpaY6aotqRzRfq7OJpOmH8n2tNF4TotzBqOWPDW3o27B5u9Cgu5
3pZotGOC7vS3RWOdhXI+FYsm07lyMddO/5DN85VanjVUTD0uRd7c++6nJ5u9
EAuFsZHhXIHu5NLJaLyzUMjEovGsqZeHU/FoR4av1PKsoYKMDZLn1R8fb/ZC
RBS72+KGgdGVLRcyiVj7hPloPtMeb6+QZ21Ca0i4/esDkucV7elmL4RRsv4/
T5o5NjieiUdteR5MSvLchNVpzG9cH79H8vy3LUeavRALw4a5PGDcyw+SpZEp
5Nqi0a6RoqG0E9FE9whfqeVZQ8XI9UmS56Vth5q9EBuF4aRhaxghjvZ+Q3rz
2S7LsGjpmhAu1PKsoWLo8m2S58Xv9DZ7IRUoFArFkvB3qUgPSNdo41lDxffD
YyTP0dX7m72QwNDCrKFi4EKO5PkPb3U3eyGBoeVZQ8XRs7+QPNPtcWm62WsJ
Bi3PGip6T16GPBcePmr2WoJB288aKr5JX4I837n7sNlrCQYtzBoqOg//CHm+
OVFo9lqCQcuzhopP92chz1dv5qtfPZ+g5VlDxbZvfoA8/zR6p9lrCQYtzxoq
3v/8LOT5/M+3mr2WYND+4DzEvftTfaevjjbvrG/77DTk+czFm9I/Xc79+kX/
8Nid+96vcG387uf9w9fH783ZGp2hhXke4serEyRLXx39qVkLWLtjAPJ84vx1
6Z929Fygx4+cHfV+hZ7jI3QZifScrdEZWp7nIc7+aKSbySlr1gL+/o9jkGdV
bpclj/rZa/AoV247NmdrdIaW53mIdOYaCcPWrzLVL50bvPbBtwtbemgNvScv
i4/nC0XI+fZvfvB+hS17ztBlf/x7d/FRyftKXyjlOq3+wWhH2thiheGumF26
31nZb6VFer7hwICRniMjtlkL+OvG/pfX9dEavklfEh8/cT4HeV6/65T3K5Bm
xpU/XBqvfT253kQ0lpoolfPDXdFoy0ipnE3F4x0DExMTuVxuojC7ZbQwz0N8
eWS4ue1OL687SCraMIAP/yg+/o+vzy14c++fN/S9/mGV1pW/vHd4adsheoXP
eodqX8/EcDo9bJY5Fwej0VimUOxKRFs6+wfS6WyuIuOj5XkeYqdpfJJENWsB
z7+9f+0nhkuYOlBhw5OUkiS/s/Nk7N2D3q+waGXPls6zdP0bW+vYtDWWikdj
7QOlUi5JYt2W6u1OkdXRls7xFVqe5yG2fpkhWVqyoWntIWT3JjuNEPTHe8/z
g2gq3NU71P5VZsFbe6enZ9yeXnj4CHvho65zdOX9ehQ1FXMDLdFoomMAtkXJ
ruzPD7ZHE91c1q/7YechNuwywr+kJNV/mnpcelB8NDPjKktuKE49JoWP2z8P
XvS48nFpGpL8h7e6aWfx499+bxSRnvtpHNUdHqVKv4zdpQv2HR85/sN1ujOo
BLEDL3601/AEBwxPsFQqlYvZeDQ6YBogg+2xqO6Hnd9Ytf04nKlpRW47us/T
4xP5wGVv43fu0xP/b33fwpYesiU8riw8eAQ9HF29f5NAKbPn0EV6/Nd7xb7T
V+nOyPVJt1c4d2mcLhi4kLt+y+ir7Tn2c9DVSuhtjQpIZArl4d6k1U+Y6BgV
mq60PM9DLH//qFv5MeJgIfJuaHE9dPoq6efXP/SyzGmz0JVf9A8vfvfgu5/O
xjE+6TG2Eh0QZ3+8aWjdIVeti3aAH69OTN59qDqVdYNL/+CcvJdGDfjzhj7I
87iSVoab9tMvgcuEyE6gJ568kHu748QSz8btG7cNpdp97Gfy5lZ/fIIf/+CL
78muLpspb7rg4Kkrbq/w1dGfjMVP3i8+MniWduy7EHS1oaGN53kIOughzyQ5
0j+RaoURG/Q1j5mmbPby7U27z3g3ul4xxbXv1JVlyaNvtn/Hj5NV/2Kr0fFN
JgddsLvP1Qjfvtcoz3v02HDZyB8UjfC5hhbm+Ybp6RkShufeNkT6wohc3rZk
wyGYpkFfFjma0Zv57WYtaGnatTEQ1SPpzLUV7enlyaP8OOlq0tjGCmdmJFdR
Akn+n9YewP0X1hx475+N43XU8jzfcO+BwR33mmlCn1TkNrp6Hz1+ePBq0Jf9
vH8YjiS7dW5XwjI5lb3BAgzQ0ZCwQ+LkV3o4lW9snd0IZNuQhRN0taGh5Xm+
YcwMRKBis/9MRTkQKVXYId3BIwYIjJA3t8+sfLs2ftftSpJkmDTkDC4W8iam
OW2lLEl1e7CBvbzu4Ds7LW5S2ph1TalUgbaf5xtGrv+K4jr6797vKuQWhivd
OoNHDLZ0nl20sqdsFztdvDLhdiUuIKtj0+7B54QYOBnPXLZB2+35Nc5GOFkj
ZDO328VUK7cdi2/qD7ra0NDCPN9w/udbKGxTfS5SqpDnHT2BIwZrdwyQkVC2
uY9OD91wu5I8QbqAvMIPv7QCGsDClp4Pvvge91nbq09HjI533LrUqUbyhml5
nm8ANxFKoLfvrSjLJKUKeSZJC/qyr3+YpqOf7lz6ZVK1ZESQMUMX3Lh9D2EK
eI6PTIZzEmNc8/W3BqGBY5cKAt19py0L//3Pzz5jnguNgZbn+Qby9Ugefr42
uWjVvi17zoj/REoV8hyilJT9spsTBdWSEfGF7TmmDhg2z4OikdNB5TOfF8h9
OxotgxdvmvvRyraIm6IB0PI830CSFjGJL15e18deFUBKFfIcImJAljCS10hn
e5Rx7uodQmryc7NOY9Ks05B2AYwitRuLcNA0Vzhy/s+DRjjl3v2poAsOB+0P
qhi6fPujrnPXbzW6lxOAANy9P/W3LUfEdEbZpi0ivV21/Bg499M4fRCyChAY
QVOJ4a+9uZced3sWNOrj0jTeDpQy8FIP2VZEzizMcFTynx00tkPezkSrlknP
8RG2W+oOLcwqIFEhYrx1Aec7WrYde6UyMgDNuSx59K8bD/t5KdBokEEuWQsv
rD3gYbGwG8gpGLp/YcRQyMd/sBQyLY+uYfdQxPrUqRfWHOA/D9reJT9CH2ru
NLaWZxWbzZqfEDGEer17dPW+shkZeKkyMmCUExtjp+TH3YC2VtKimB9BihGP
/3Vjv0en6sbdgyhVPWKaN+Q/lm3T/fvhMb6MtpVjXdPStkPiix87Z0T/6MjD
nzMzM8+YnYn8SH2h5VnFivZ0OBu1LuDAGmm/hS0VkQFSqqRajYhBi6+IwfNr
9sPMQAqbnDg8/uZH33lkQ8hof3mdkUZB9fKFEUPw4AAOC3RJ5Ks+s7JHqmgt
Tj2OVHYBIFDDJdB3zGheROm0rQKlH9ZjnqYWaQkvtvbSF+5TB9YdXDUBposp
oT+a9B6pVpKWiA9mZpR90q11x8DgEGIOlnY1En/un27l9uP0LnTnjBCp2H/C
sD1+GZvNKqKITiJsvHRtErVM/AhijOnMNfyJnUW3bdU6xEUo/bB6nqZfQMPg
drdRXrkINgbE8AJgeIgffUdmsJ+1oQyDbvFN/bAcuMqUKz8dQVYEWhftIIZR
Q/LlEUN6b//6gC+DtEt5GbwRCS0/cvVmXtTGSD7SjWwhX1+HCbkfdlzP0/QL
9AqhuxlHbYPBaeV9J+RCC1KqpFrFsIMHkBYBkwaecuO29RT027qN535lcz+E
7afRO3TZ0bOGlSLGogE0vJCci8/due9CpLIN4dak0XXI/DNoXadVOXaTVYPd
D+s5TzP4yz7JQPMFdCM5+I1fAMcNYLKKug7/1FcZ4HUDwhSInoFf8d4DS6XD
VCBJc3yiUTu3w6idu3rDUK0HTxrGA7mikcr+L/LsFq3at2l3RcZnzScDL6/r
Ex/h7i38ufXLDK0KEaSJvPMCHFHRD1vwmqepTWgRCFKRHbjgrb3/+No1SDtH
EBs67ESbZfQ+KBqGEClArsz3fqnXPzRK4ND69Mqm/gWCNHrvCI7mkT7nILNj
F8CKrXKV3eJ3D7buqKgjRTk3W8urth//y3uHT5w3PkLGd1eC3A9b1vM0/WKH
eWKS8JAd+9ZH31V/Ql0BJw40hkOVntT45H0c3Cgo8mjfK5tJk0UrezbvOYNJ
giTMYkwYJSJuzEXPtPSQPpcW02pHXURs/cpQtuyZYuq3RNlBeFZI3P95Q9/b
HSdg1Hnk3CWo/bB6nqZPkO2K3grSUc+FsfFqAn7o/Scu0/1R05Nim+ey3QYl
Bd8cgfQ0CT9IM+gmpmCk5IgIUZ2CRgOmgmOIDySizOuLvaMujMuhSfJx6tEd
t3RMAOh+WB9YnrTqz2FCix59A8C9TmWbv4UcKPzTDzYJgCTnjkD6g3Q4KWqS
HLovps5hGDtGgGHVgNoURBzITZMwq6cVlnTM3heocVXNGHYwscu+/tbgxHNL
x9SIRhrPpenpcHVW5Hpcv3WP3fNLv0x6tAt5gByQqzfzHsQ+ZbOhCXU7OJTF
jJh/5AvFEC3YZTsIBhbxh2bkcKfNmmtnN25Bzr0Za9FdhRgI2asRI6s4W9pE
30PEZCRQnwgbg6uXjW5WszJfbDlhoNSZ0+ik1RdUBswB2krLzIi6WMWEdEzd
6+4aqZ/pm6GPE4L9Cafw8vePkmDnbt2jLzlcy8O61ClvEYUFiNoznO9cgRMI
pM0WVGYffOLIWTNQbKfhFtqmbNnWfqRamU3L7UVIr5Ktu6TtEGiUyF6l68XD
fQpep1NCH5E97luk3b3ZNH35jgSSSX5ltzTN2k8s2xulsORr8/26F8k0Up7p
8waN0gBZ0zDD1iblSXfcmn08gDp2Dqg6QqxFx+EYolOvbGcYQ1Qpf10ZW+bQ
WXm2LPkBmRCGiesee0GIhj8m2asIjIjXkBzyTmE8KD56Ye0B6A08QvK5PnUK
7+gY7Xnpnd4Nu6yPaSYWD6vXcEEIwnQovaNNRzuOPuAjpyaX0GikPK/YatRF
hOD2QXiHbnTqcfIu6CheqCnDfqvkNBYhOv5o1gvB7YOCTLzXyPUqUWIJyHSQ
EYs/Ex98yyyjFj2ReZq7acuyGfEjIaTzi80qVGxK9omj/QArRZyZstTsArjv
fiKQMcOFLgkX5iWUUdEeoTU/u2ofP44AO5zfeqGR9jO4I3DcBAIUDkL68Isj
AUeXwvXGK+x0n+Mgpt4QCva42A0oziTtR9aCFIytCqnWiEuDCMnO2cYltdRf
+ghIUgPQBn2VdEbk9q6obLu+92Aqunr/ivaKB5Fh97DYabvx65ByXrXdgbP6
U3uT0osvEwg9aMe9sqmfNHx9OPxNNFI/L1ppFAr6HAG2q3eIzj6YoKCMuDX5
gI6n7d/8cPCkWVJ7w3n8E+lt0k6ScYjKYTqsn2lxOGcZhpPS0gPNP2P2KXvU
vbvBYtc8MbLFpJwVc2p0NtGH2unOf7Xmk4owr1hoIf7TK5uN2PjpoRskgVIn
IB36JO0iAend+1PkMkxWbn9Sqn/eUBFPhisqtZzQZaTtr7pHVFZuO0aLwX2S
TPJQ1GtgKY1P3iflvLGSWwY/pZgDrRENk2eu8zmVde0sFpEwKyiQHYMFSL7w
d+eukVqGVXDOJR0Ad0lSFHgFEi1vIhT67UTGtueNHiXnY90DHN3lxiX+JxBv
ijpKwmvvHxV7T1A1gVcQ21UQDUaTtdQ5tdwf3wV2iij2TFMgXoZyC/hujhFv
8on4BAGHuXoNClHwItKmwE9ZxymHDZNnlK9UTQQAdPbBBEV4gTyOF9bOprek
EkQJCEah4pGx0aaS4DZnFWADEE9VEn63Y90DHFiD4SpyKiJ8ERHakSTE3q0w
a9FLeOO24XHQ5mLiLGTrSKRh2IivQFrXmw4XkLqiyk4VoYRhsySJlhRxyUhu
2WPlwS0v1akKFDl3vIjkPZ2pzOnXjobZzxxe8FPIDYoedsfobH1182xyyptV
GL0Yot9RNg9r0N17zEqAlS5O+KU3bQk+cYwFQy2TQCGQeqwzSGeKXARckoQI
G7fdbdo9iCxJxBizUtF3IJE2uwEf9qpgs3Fbt3gZmV70TeK9HKsNMVGF7nj4
jPg16UUWK988DiyV1iw0GqafsRPp1vVt9TGRKFnntk1yokX7QSrZkoCYW6Sy
uJHVssSRIoJOgejqfWKE3yitd1HmHkB9Mqk+OGIipyJ6Axe4xL7Uz5WxqeSs
zJodmYFjS7c/vNUt9hha2WofZVSQMTEUj8KVolJECr0acalfgq9Hz8KxyNlM
EUij0E21RlCjQmZk1QX7RMPkmXvtvYcdAORikCDx4SvpnBkzh+vGqcLBarFB
m7nXLJv2gZzToePy+TX7xSRa2dTqSz2pkh2B8BSJFlMu8z+t33XqxdZe2lwi
zyEDTdNixJtrNqTaJNjV5K6SaYFmQwBcjn5GSuG4FNMZbjsdNk/EpeIaIT5y
NmGt7Ts+ol7DGkYlsUE/iwe5TVA0TJ5JLeNDVe1VRxZ15/4s/e4k1RIzDyDZ
mSJQwCx5GVwDiSr3nMJFgO9csmHoKWA8DgQIbdnpx8Ix8Zm5p9TKENUv4MT0
sR8qVD3ctBVb01CqXJkPLkePADsDIThxHjEvWwLooCMuHTEoSSILHxvkiJNk
giAdIQ7pnxA5QYl1XVB3eS4+Kg1dvo2bWDGOb35BZeJVwujNPD0LPxb5CPiG
pbIcQIoDiIA7JgkG1yG4sREibCvFAGmpPjtPRXApGn5HsSpysbkNYTR2Hv6R
PuxVYei8Grfh0TzYhnziwEQnnw7Kk7enxJLhATKrJLMHzYnqlXRyvbDmQMQl
gYWoBb0vjApHYmpkphyHAuSCDFgpDHdFY6m8fb8x82GhlHATkxHgt/RmfuCx
0WQWPig+hrUJF7uv8jdaWxmnJeeLVA3iAPiGI3YdV5kr4c3FqDYAsD51iuwN
aW4UAmJBE5Fs20isF2SBIKBNW569OTGp4RhXf+7t/Rt3D+60q7LxIO1HsvbJ
dQUbAHtqYsdfVbxkdm/xn8uSR6VkCoM+gpsWgo9ANh4McscSfTpht+w5wz+H
CKkbywO5wZQhqfFOGD0Nmw+LanMSHqnA1RjbseGQN7s1uTZ0o98IKVdEA0BI
IkWtpTwaZBgFveA3Fk0UW8MbX9oVl9kfbznV91pcVQ+CdcWaFXpG1BralTkV
7wjDccgooo9J7yga0p87zUH768bDK7cfpxeUIjYAnAX2p7wL9SWIyfRyZa2I
f1jNBRdvqt1hfgDVvedQtaKCYrY13taVaiH9bMpz4+bD4kCnk1SajoTtv9xd
CZTRCiokmBCthS8vfVFSnQMivThnYa5EhHIgscVY7LkQgcSu9CBe1q3PzhFT
lda+waloO/U/X5NdsI3/HBTbQnEeSccBnVm0x1tcWJTREsVTtpnL0c9SJV4a
j5oQD1y0AxQimZJ/3H/oFaqSUBohFW3KcwPnwyIZRAaAJCGLzWQo/TpiJFmC
NJUDduYbZhUTFz8DUh0a/H1YqvC2yGHkbNqQoMQknckg7aTWWqBEM1DZp3gW
lCsLLSQSDMI2ZC3twqH3SLyVukGDQ2bNgaVthxzHeSPrysl95nL0s9Rtdta1
bDP/B+LEANAa0HfqCvx91ePzBrb/Jz2+6OwKw7Y8N3A+LJ0dCOCI/sWMzdnu
2IZmrVYJyKMQAvRQUtW0VCeMAcGwVBG7XrX9OL8RBIljraQSNyoTasyQoKyd
cIaKGZaq4DF/+FNMUqvmMUeq8aejEobULXQvO3lO+DjM5ehnqUigIMyCwm8/
oVQJiKjQPgrHI+pRiaqikLXluYHzYZmdEuRUePCu/XVJIwxEiM041vrN/ELE
TC1JF1ssUnYGdv2uU3zKozIB0VT4d8i3MlcVyYzE3jbjQrnJk0T8f3yJ/V7k
VJSkl9BTGbWIm3aF9IIYLuxxKKM2Cferzq4S0S+QzFQlhXYDfN49hy76ZG1S
IdL+e6M43Gnbz42bD8ueC2aRQ6I42I5R5o5PvKSYl2Wz7DxilD3LKl2yRREY
wddCpzYd0KLwwEPkygFVDT4oOudqPWJQbpD2jsipKG4xQPKhyNhQR5vB5om4
1wmLlXJSgbE3sPXgaKu2vU/AYCCDR2Xb84nnQhV9GWhIPyx/vbBjERyAG04e
vZVUdap3zThF0tD7lvhArhKX4jyko+hP0AqBz9A63M0UbWclcZZqpkpGLwNb
jGwb/x9fIi8Sf2Upxli2Uz/gKrQMe8WCRcjCY1uJlXIe5pwKsQqUm219PleE
4fV8laHj+E9CzZh/iGOGakfd48+vfWBNqbNrw4xf9sR5qyzQsq6dulm/M0Op
Ek0K6dKIySgoXYz6HPYj0N8EjwkuJxqc4Xzx4GlcrIYRYKir9b0obSIP1//H
t2vXLWtfbCpRQygiodYdl1HXQ3b63s2MF5uYpAmY3oAR+NlBw4zhH8j/J2WQ
cti4e7DqGGU3hIsTuqHu+pmWt8asVxQ5AK1qrpt5UcglIOclBXxAxexoX9HB
yvElUhGsxpe/b3Re4ACFX4ZWEX6iGuZFykYtZLVrbKpH+xlSYFzkVFTNCZ6U
Tfev3HDO/GJPRdzDhmKlnDexswq2XemLigTvDgOMCtUdAyu2BthKIow1O3W1
hEPd5ZnFTIwqsFruM783x0qtTqdsAuLMbp1rKJVEDJNuyE3gcSvObKo7qe9Y
jTO4jTALFB0FJKOCORWlAwW4K0QVzrmc+Ig8eLhaYqVc0LN7yQYrvfW1P45H
R4Cag0k2gmJ55ZTwGlFfeeZ6g3IlNQqHOiW2dhFwkKVuX0QAHP1uLpMYszsF
YL+9hJbk6dluKSMlsXnWAVTLJETibhEov1RtWg9IhSXs8UkFn+LrI1pl5aGU
wpIZc1i2R1mUWCkXlHSIvxmU9wfNhAL0QyxLHvVoafTGG1tdOyxCwL/9TF9s
ceqxd0BGnKUoFhBy7E7kS5FAWn2R4ptD0hxbWrge7Ge7YgRhPe76WWzX4EmG
65BSxtbnftrSqyWFql3yZB2HSDKkwj/OoahvCrARIsXuRNDh4vGLcw2eyOXo
E2T3ortEyuwEwlqzV4LnZwWFOiamFvjXz8hs7jnkFXLnVtDybGreuJ72IJrm
ONChPneN4v6XzfwXGdtqkXnZdutInyMwAioD/KbQeHQIgg5C6s1XA90eaTVo
e/6TPE0PL94oWqtsoWUxVom+AW5VsCuOHMh2yHL2oB0jIUS2xS2V7wFUg5Mv
uckW7BBAgHTBm7MzjgOBW4fqAv/yjKOTyUMcAWccWkgMQJEMQCqsAnWngkap
PKYquFQSNgxC0JBVlNKhFYgMV6lP02AFrMxJqZkOBu0ITjTTE+F4ujGBw/IR
q8WYa84i+lb6CLiFn44bkQI0EEh7003kcvQJGDkXRm6RjpXavf0DydmIQlnj
E9LU+xrhX57RieDYWMGQunjQV/JQqDEQKYUlsG/iEydNM5iUMxx8kHJAH8Lg
sfoBf7kTqZxQUxaCMADqQh2JekyOFMsehnCqQRgG8i8ibycXb5tE3w6/Gvcz
Lq+BnxABnKygTHwC1Ya0BegADdFZBiAmGRFY7wJho1PVSmj4t58hMI6EewyR
oKxsz9iFGMAImXSvD+QyS5+4bFd+IiaG7YY+DuwX/L5Q49Jg95Umq7b40dxy
Wzwch3DM7hQYdLL/Zz/+L7PlbcypSCrIMcrK8T3a+xtD2Z9lOzqBT+rom7iB
fAEYSG5UMH6A081NTVVFfQd8+9fPK7dZxfYeUUoUWLIhivYi+ESQATefxa3s
zQOo7kgdyEK7whzCb4ryZkTD1pscjBINHVLPzPTi1mpUrjwN+Ydzy7A42i1k
omANnzpRLSFhCjUeKDAoAtUseJegFcjxTf3kLJNB6G1JegC7yc2MrAq0W4Z7
axX+5ZnOaFKhEU8+Q5H/pGynnlE+wVWXjo6Dh972AErLtpiBEXiFMFP5zCVv
Dr1CUl+bWFpWtocgOL4FGd5cEbEudYruR9xHbW5xCtGQqGANjlEaVGvDTutT
ugx8Atl/vEtQUlPy5uhokCp1AwHx/IhABB0IoQuZHOFTnuFD0Wd30zPAVrPc
iEtujB6rVftgX7EP5RjYEQMj/kHKn+xbpDCQOwb7KDezMAej1N4iBXvdiATL
HMgyP9ESc/Ip+7Yq3mx3aHKho9zjXIMwIGcdqJBPAlRNRCHQqIrP7fq9cN5c
WRjBhkmFQfFpZWtGjfBpP3M6YPE7vR7ZdunghiVA8iY++PI6h8p5t/CsN9o+
O02uBOblYUcgysENRxhJGVFyJdLIBk41quA5ZaicJ4uIY48q6GOKLTkA+hEW
uFRhof+OvMWIzYMUDmQz4JM6xjY9wPVOjtQZfgB7MhJ2hLFHcEmC2A/rMR/W
z5ui/urE+RxpPEc/HUBzEP+JvU/noNj1+ermI2piVKU38QNkw+n1aVVIK5AK
jQilO9wbe6Uywy4V/3hYj8wahFo7sszpCHCsySw6ZbTLZroh4h4XQkgEpkIt
TMhMvhr0iSCbitQwnA58fREfI+QcoU7qdERlP2yt82HtDNrkDmVgoggpiY+I
mWkGzAYuHGvApMCIT4ivjybuhWYzC8fTEKyLKH1AZBGJZeQeaWLwS9CPjoTI
xSsTqINVe0Ask0khVIEJ5LZfmN3CQ0v4Aaq5QrCFIB0T4nBkcH42XPmHrx4x
qR+2UOt8WKuY+f6UW54LkBpakemI2EWJgGNhoc+ZpxLg10fMrM2MwCLOFIgQ
cscNyM0g3i1saOKgn4wTIihFU3tOrWJmhbQQFrhbXpXnT4Ur5mFASToSaFTF
8vePRmogRWQNH26oDZSSHzd2th+25vmwZj7UOGTVgeMi5IZWe4S0yHAi9mEx
3Gi4vIESEZYW8jQjCnvnkg2HQA4vPZdseLS9eLfMc2EwJ0TY9JKu5JpY6XGo
AjcCRqYRrnF4GfqePHrnPZA0eapDkzDz4PtwtOQ2I031o3m2H7bm+bBv2NWt
D6ceL6i0HxgqwySfRCIjBPopzl0a39J5los2pcCIT8Bk5VP+/9b34U8x4+PG
hbLdHMb0uDStshiJQCkpncXkeMKNdayUKwuDOKXHTw/doDPL4+gBt0yIwRYS
SOf4IWZRQccoKZnQk+nQrebWRlcV/ok7Zvtha54PawSp7MJa2s4LKuekAxZ5
mlDnw5zP4q+JoAe4i9naJPMyXLfOS+/0su23LHnU/xfLnQXoyHZrnUMkBKtF
0A+hS5XDM/RHWPzuwYg/Wuz5CfRoh5ovb8A/pbnYD1vLfFgraWvHJ0k4ya5Q
OzdVwbB2bmW0HLHWSCXXqBtfSlUgToXACIJ1PuvEuAramyML/BIRs/mFjw9H
kn+fxPgqsFnUyuffEJ5dtc9/36KEwdCU5mH7YdWBpIgOSfGZczZZsfggSb70
SUE8QnoVjBx48NXNDuNH/QAzSlAyAaZiN7pyCaAu7Dt91YN4rSw0C4ixRJNa
5LB0pU8icRUrtx/3E7Caz6AjxoMmyBv1pTRXjWf64aSuH/ziYvaHvnyy+qSf
7zun3hPSmRKLFNkG9Nz9Jy6/2Do7Pka8HwhkNryyqR+9dWg29Onjgyr50/1Z
iZpGveyFNQekvQYXQDx04I75IV5WQQYYfYTpgL7DvALZoh5TlrwxVEnBVyNU
/Ux77ZmWHrELAxlJqbPvNaGQEnCjVlbx6HGpND3NhJZGb5QTnUtQIDKmkhu4
4S/vHV6xNc0tfh5XSp67OpUJ7eTh+v2fcngQR4eAJM9ou4tUTkkg0VU7YlZ/
fELKee10cfDdwIHoEI0VjkDQz3+DMxhvkGQMNLUWrMVighhOrk+iLQ0RV10a
28NBkmeOJXLBMPqL1UpO8ASKj2zafUacfVAVXI3myIwUAuDX9d+VieZE1AsF
rYchK13ssifrMXQ9/FOOQJTmVSHZzxwx5gZStIGoQwPblYgxmcqBYhQoFqKj
HId10OINFcho+HfKkElBBCZo6BstIQh0o9g1dH3aUw7/lOZ+IOlniBaZ0GDI
L5v8igucOtklIqCyOevZrUrNEVCn45P3QdHmNu/VP1C4uDVIVyZiZW4UkR6A
F4moKdL64aolNaANwvVqqZDkGZ4OZBUhQVK5jm2qkEYxyuQ9SlgF1yD5rxj0
BiKZPsmEAdi9IWKn0CqIn9NRZW7/YMl6DaAQnLTHA5I8Q7TAPUWOEsxpxwJ+
KFUeyOh/UhjDDqTfVGfvhgMaBqVWwSprMGt3PQYQe4DOI9TBLtlwqI4MP08b
AlGaV4VkPzOn6yub+l9s7RWzbxIkpiPkXAI1y6OY88iZUXU2ejig9tLPvE4G
KYcFYWvbEB5599NTQTeRhoiZIJTmVSHpZyZ1SR3IkjzTjWxpR7oJifPNke3W
G1zv8epmh9klIfC4NE3OctAivYtXJsIV7g5cyOErolu41gwNIChNmQckeXYc
i+MIkeu1zGyiQUYzcFmI4wAIjacHjsM+Qr5UpTyTaKmFRo6whsLbBXI+u2Yk
PLOyZ8Ou03U0nzR+i6gjpbloPztyurpBYhjY5jRrrCrIbKZbRJg4pvEUIjil
eb6r1R4Pm+gUjUVRP7tVqjtCGqu9PuVKyeIB9D5Hamhe03gCEJidyZhvlRgY
HZsYM8bDirU1ojwHJQ0QA84GaUDwhC+CAxEn7mWNpwfLAlKaF0e6otEWYzrs
QFZKwonyfMyi9fY7REOcAGveD0xnvfUri5rST1WexpOKoJTmuf5kNBpPdfem
2sjqSIoxNbF/0H/BJ8DsBKELPkELH3FnoNV4GhCY0rxUsm2MfHs02iUMIBT1
c9CCT57hHrrgE+wWgaryNJ48GJTmQWZjGZwbSdN/nBiMRWMZwSEU5TlowScZ
GGhuCl3wiZaWOo4b0PgtIjCleX44aYc3OtIVjQCiPAct+Ex2Wsy9oQs+wWUR
qCpP48lDOEpzoxtWIfwQ5TlowSeK0x6XpkMXfKI3IXTrmcaTgTpSmrMzOD1j
jZXx/9w9h4xivF/vFeHWheg2oqeQ0dJfp94xjd8ojN6QOlGas35GMiVQm0CP
HQ9Znwo/y0ZDo46U5izPsIHdJoM4gicaLzWJvmtfjMbTiTpSmrM8o6Bo7M59
7+tFgJcDREOBRp9oaIioV4NSWbCfN+0+s2hlT6AmkQsjRj8IeAgPhp39oaEB
XRqIMsINrJ//tuVIUPo1tGW9/uG3kRrYVjU0fFGa+wPkmUzxP/498IQj9ISC
fyZoV4iGBsM/pXlVQJ7R/ReU0wOEz5GaZyVoPOXwT2leFbCfUVl37lKweWE8
4iFgMbaGRgVAnFIXkxX6GQ6mxLjoB8+v2e9GaKCh4RM81KP2l4I8h06ILDXn
o3lMjNXQqIrwlOYKIM+hEyKJD76tl+Wj8dSijpTmsJ9DJ0Te7jjhNvlUQ8Mn
0Oh3rB6U5iTM18fvkRkcLiGSu3Xv4m958IfGfMDP1yYXrdpXF4p+zqdMTzdn
3oHPAVt6AU/wAuq4Bu/XqfouTb+g6QuoekHTF1D1gqYvwM8FHk/U0JjnCCfb
tewLDY15CC3PGk8StDxraGhoaGhoPHkYG+y0uEBaUiBqGk2344H2dOMavQvD
ndFYCgwLDV9AKdPVhncEHUpxNJ0w/0y0p+vQdOQDw71JLKCtO1syV9ARN/+O
t4/O+QoKXYloRwbffTHdbn30/tFCuRlfRW0YbYlGU5kJg8I3EU10jZTzg/Fo
LJ0rFnPpWDSeqUOPgg8Uh1uM386kDm74AoytFG0ZLpaLI3QnMVLKp2LRZDpX
LuZoX3XIlJlzAINvNtqfK5bG0lHzI2c64rEkyQ9JVyzWMZfVkoXRTlNeO7Pm
d5/pIC2SK5ZzpFIM9dLwr6JGlCbSvQNIkGdIQ3RkCln6RClTiIqkuO1tO6co
drfQ9k/GE4Z+bvwCsh3x1u7h3Eg2kx0eHcuXChnaR1lTGRnMbB3BuoTCwJDn
2MBYydzLJM+FlCE8pnocprupufsKhjtbW1NdrfQepqxmO+ztUzKWlBlv+FdR
J4wN0vdmfKUkTvGkNeEi055on3txGu1tjbamy+WRlniqaMpzgxcw3Gkc7W0d
qWTCoJefKGQSsXbs8XymPd7egB/ROPHp+4+Zh5ShFePxAXzuwmA8NofybMLU
G5Y8J5KWest3xBKD443/KmpHcTBFp33C0A/0/WU6YkmrvWUwGZ9zcSpm6Uds
6eju7UzGoolUb/ZOgxdAP6JxpuKXGmuLxulHjEftH9FcwVwvAEeS+TnztLfa
M9c6YrY85wfisY45/goKKVueyc6x5XmivRlfRc0o9pMnFO8wnQ6TxnesH8Zk
uTRCUt49195IKZ8dHBwg9NOX2tKbGS01eAHGAUHmThdMd5PuNUdfSddI0TCE
yKfoHpnrBRQMowJiU+gy5PlOutX0ZejQMkyx7jn+CmbleSxNG7rL+OSj3fQr
jJQa/VXUCHPZs0ikDNspa9hTZsCjs4F9W6VsIg6zufELyHe3WTGeZL/xk+Wz
XdY30tLVkOrbfG8S4YxorK17wlyB9RVEW+f+gCrQoWD7erOTfTqzWEiDv4o5
QcmR/PSJXoD8huYKGrkA4w0LFSuQ/m4Ymv5VaGhoaGhoaGhoaDxJ+H8aob+2

              "], {{0, 154}, {240, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {240, 154}, 
            PlotRange -> {{0, 240}, {0, 154}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.9"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e684d972-fa32-4d46-94b8-ff36cf0b6dd9"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell[TextData[{
 "Make a number line plot of the numbers ",
 Cell[BoxData[
  RowBox[{"1", "/", "n"}]], "InlineCode"],
 " with ",
 Cell[BoxData["n"], "InlineCode"],
 " from 1 to 20."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 10}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmr2P40QYxhdoKPkXqPgXaClpD9Ei3Ymd40tG2kNzonCB5ArvFhEnuXFl
sZcqjeFSkOJSmMKLXLhxYR0pXFhKkcLSFJbOi3nHdnLOh8MmWtbD8vyUjcae
0eTJO8+8M57N+4++fcDePjk5efIuvT14+PSjs7OH33/yHl18qj358rF2+vnH
2nenj0/PPnz0Dt38gP6+eOvkRJZLAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABg
i+vrv371Xj19Nv3anHz142/1i//00vzZ589e0v3zS//88ora/OK9uri8unh+
RZcvfv/z9etrer94/sdGmTqkV/ty9UHbNzeU7G9wdOM76+oWUVMVOIh7PIj0
jT774cURL0ogO8vUYbtPKm9/0Opml5KdDY5ufGdd3SJqqgIHcY8HkZLhcXnj
m/PJzjJ12O6TytsftLrZpWRng6Mb31lXt4iaqsBB3ONBxH5DzUVBTVXgIO7x
IOJ8Q82HUDVVgYPAIAIAAAAAAAAAAAAAAAAAAPwnYIyhMRorrgSNVWusggY0
VrOxOkrQuN/GDAAADuHmaQcAAAAAAAAAAAAAAAD+l+SerVfnqfo0EWsViddU
2F7el7oOurQV88DU6uNhw1v/Ov2TJw6vpHE72Q5oHulMDxWTvMcei9CtI607
ytkj8ezaBLaXtO9n8aQZgcF40Ze4fQhXZ06Yrd/sHIIeyUKHopvmZUqh1oYt
xdlQY5aXlnlKY+BEWXcfd0+XtmKi05cIi7KMXYPxsVJ+Dh2uWTTFyAaa5kTr
lfnYkHaOVPFFQ6c98pgmoBsLKpCn3R15sD+ygDPNS/M89TTGW6lYjDQ2mKZl
mVrSNorFWiSjKj2M1oV1z9A+iZylh4uIov0myCKkmEeVHeIhpyTYl8IddGor
Ym8aLYqqibSGSs4Qw6VX85iKawaYUdbQLZMbqu03uuwhIoeZk/l8FoTRLJmL
okeNm0htbFgpzSlRtJZvMeLM8ue0V6J1R7GlsIxHpjl0TZK+LqxzhvZK5OiW
X2/ZMkfTg1be0DW7qQhtbquVN/ZrKxYBZW5bOkQdsiHnfu0IEfDWwpEnY8YG
87JwuR6qtG6X3fYQ8aja7TtDiyJtbO6se4XyBreCuhzaut0SF7tyRefy+UpX
LG3UVIluM290zNBeoc3zUtXCZrydNzhbzs3AUi1v7NGWBrSaM8dPe5HWDQ36
Mm9kPtecpTnkPoQZzmRCu1RtMJzMVUodXfYQEam26yvPZLZKiUOEjmb5dbly
xyrScptaX8UUbKUs3SC2N0KdM7RX5t6AcTdvVj1jRhvOXCwyupEO6Ll1JmvG
OtPHs76VttnWli8WGWlPplTD/VQGtyhU2j2XBc0v3ZVhrJ5K5NmLWCxEUSRR
4Pt+4E9N2pBOwkwl1dv2kO4g0am8jGWKyxzVjr/m00ZbMTMYGyd5Y+lc7vPr
KUh5Q1M+b1T22DVDlSBzl/+BGEUypqvHwyxym1+uG65qh8+b2uRSooXZzGz/
4J6PVHKzFL2UZ1arnnDWTufyETdUe07ZtkdUiaZCPB40YbamaqyBb4jcJtLG
SEpdWTqeWM0IaINIqQTdIE9glnljZY/NIVCHXIh8ZxQLWXPXam6Iyto6KYRQ
6hDxRnTao7Oif4oubbJCtTz3zygcaQAAAAAAAAD4F/kbB7htwg==
            "], {{0, 
            39}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 39},
          PlotRange->{{0, 360}, {0, 39}}]], "ExerciseOutput",
         ImageSize->{364, 39},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmr2P40QYxhdoKPkXqPgXaClpD9Ei3Ymd40tG2kNzonCB5ArvFhEnuXFl
sZcqjeFSkOJSmMKLXLhxYR0pXFhKkcLSFJbOi3nHdnLOh8MmWtbD8vyUjcae
0eTJO8+8M57N+4++fcDePjk5efIuvT14+PSjs7OH33/yHl18qj358rF2+vnH
2nenj0/PPnz0Dt38gP6+eOvkRJZLAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABg
i+vrv371Xj19Nv3anHz142/1i//00vzZ589e0v3zS//88ora/OK9uri8unh+
RZcvfv/z9etrer94/sdGmTqkV/ty9UHbNzeU7G9wdOM76+oWUVMVOIh7PIj0
jT774cURL0ogO8vUYbtPKm9/0Opml5KdDY5ufGdd3SJqqgIHcY8HkZLhcXnj
m/PJzjJ12O6TytsftLrZpWRng6Mb31lXt4iaqsBB3ONBxH5DzUVBTVXgIO7x
IOJ8Q82HUDVVgYPAIAIAAAAAAAAAAAAAAAAAAPwnYIyhMRorrgSNVWusggY0
VrOxOkrQuN/GDAAADuHmaQcAAAAAAAAAAAAAAAD+l+SerVfnqfo0EWsViddU
2F7el7oOurQV88DU6uNhw1v/Ov2TJw6vpHE72Q5oHulMDxWTvMcei9CtI607
ytkj8ezaBLaXtO9n8aQZgcF40Ze4fQhXZ06Yrd/sHIIeyUKHopvmZUqh1oYt
xdlQY5aXlnlKY+BEWXcfd0+XtmKi05cIi7KMXYPxsVJ+Dh2uWTTFyAaa5kTr
lfnYkHaOVPFFQ6c98pgmoBsLKpCn3R15sD+ygDPNS/M89TTGW6lYjDQ2mKZl
mVrSNorFWiSjKj2M1oV1z9A+iZylh4uIov0myCKkmEeVHeIhpyTYl8IddGor
Ym8aLYqqibSGSs4Qw6VX85iKawaYUdbQLZMbqu03uuwhIoeZk/l8FoTRLJmL
okeNm0htbFgpzSlRtJZvMeLM8ue0V6J1R7GlsIxHpjl0TZK+LqxzhvZK5OiW
X2/ZMkfTg1be0DW7qQhtbquVN/ZrKxYBZW5bOkQdsiHnfu0IEfDWwpEnY8YG
87JwuR6qtG6X3fYQ8aja7TtDiyJtbO6se4XyBreCuhzaut0SF7tyRefy+UpX
LG3UVIluM290zNBeoc3zUtXCZrydNzhbzs3AUi1v7NGWBrSaM8dPe5HWDQ36
Mm9kPtecpTnkPoQZzmRCu1RtMJzMVUodXfYQEam26yvPZLZKiUOEjmb5dbly
xyrScptaX8UUbKUs3SC2N0KdM7RX5t6AcTdvVj1jRhvOXCwyupEO6Ll1JmvG
OtPHs76VttnWli8WGWlPplTD/VQGtyhU2j2XBc0v3ZVhrJ5K5NmLWCxEUSRR
4Pt+4E9N2pBOwkwl1dv2kO4g0am8jGWKyxzVjr/m00ZbMTMYGyd5Y+lc7vPr
KUh5Q1M+b1T22DVDlSBzl/+BGEUypqvHwyxym1+uG65qh8+b2uRSooXZzGz/
4J6PVHKzFL2UZ1arnnDWTufyETdUe07ZtkdUiaZCPB40YbamaqyBb4jcJtLG
SEpdWTqeWM0IaINIqQTdIE9glnljZY/NIVCHXIh8ZxQLWXPXam6Iyto6KYRQ
6hDxRnTao7Oif4oubbJCtTz3zygcaQAAAAAAAAD4F/kbB7htwg==
              "], {{0, 
              39}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 39}, 
            PlotRange -> {{0, 360}, {0, 39}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.10"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3d2c01b6-b3ac-453f-b1c0-11c471af76c0"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}],

Cell[TextData[{
 "Make a line plot of a list of 100 random integers where the ",
 Cell[BoxData["n"], "InlineCode"],
 "th integer is between 0 and ",
 Cell[BoxData["n"], "InlineCode"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 11}, {
   "WebOnly", 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfVt7FEe2ZX8zL/M4f2H+xbyex3k955vXpG1DGfq0y31wt9xtI7ehBRhk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            "], {{0, 154}, {240, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{240, 154},
          PlotRange->{{0, 240}, {0, 154}}]], "ExerciseOutput",
         ImageSize->{244, 154},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfVt7FEe2ZX8zL/M4f2H+xbyex3k955vXpG1DGfq0y31wt9xtI7ehBRhk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              "], {{0, 154}, {
              240, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {240, 154}, 
            PlotRange -> {{0, 240}, {0, 154}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "Exercise", Previous, CellStyle, WrapAround -> 
          False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->Automatic]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x6.11"], StandardForm],
   ImageSizeCache->{2., {0., 6.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7cb34944-fc9b-47c5-8f7f-0696ed8e6a33"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{"OverlapContent"->True}]
},
WindowSize->{808, 911},
WindowMargins->{{554, Automatic}, {Automatic, 62}},
WindowTitle->"Making Tables: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[" 6  Making Tables", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
06-making-tables.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+6.1", "6.1", "+6.10", "6.10", "+6.11", "+6.2", "6.2", "+6.3", "6.3",
          "+6.4", "6.4", "+6.5", "6.5", "+6.6", "6.6", "+6.7", "6.7", "+6.8", 
         "6.8", "+6.9", "6.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+6.1", "6.1", "+6.10", "6.10", "+6.11", "+6.2", "6.2", "+6.3", "6.3", 
      "+6.4", "6.4", "+6.5", "6.5", "+6.6", "6.6", "+6.7", "6.7", "+6.8", 
      "6.8", "+6.9", "6.9"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.3 for Mac OS X x86 (32-bit, 64-bit Kernel) (March 5, \
2018)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.3 for Mac OS X x86 (32-bit, 64-bit Kernel) (March 5, 2018)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[6499, 178, 755, 25, 36, "Input",ExpressionUUID->"a7277846-fee8-4450-b6ae-9a96161dfbe8",
   CellTags->"FirstInputCell"],
  Cell[18825, 468, 755, 25, 36, "Input",ExpressionUUID->"f9898c6e-0636-4317-becc-b6f7cf4c79b5",
   CellTags->"FirstInputCell"],
  Cell[27290, 691, 755, 25, 36, "Input",ExpressionUUID->"46a80c10-dea0-4c77-9498-de23b304f239",
   CellTags->"FirstInputCell"],
  Cell[36570, 930, 755, 25, 36, "Input",ExpressionUUID->"fe8cd5f1-b3e1-460c-9dcf-8e5b79255225",
   CellTags->"FirstInputCell"],
  Cell[45681, 1170, 755, 25, 36, "Input",ExpressionUUID->"e627b21d-47bd-47ac-a1b5-785c89ce7382",
   CellTags->"FirstInputCell"],
  Cell[55597, 1416, 755, 25, 36, "Input",ExpressionUUID->"e02e00e9-737d-4136-b773-8c0b7f4e0873",
   CellTags->"FirstInputCell"],
  Cell[65649, 1665, 755, 25, 36, "Input",ExpressionUUID->"ba01e5d6-35c0-4197-aaf7-7cd74ad3e3f4",
   CellTags->"FirstInputCell"],
  Cell[80990, 2002, 755, 25, 36, "Input",ExpressionUUID->"7255a416-7d99-4aeb-a539-03d2178a5544",
   CellTags->"FirstInputCell"],
  Cell[89829, 2231, 755, 25, 36, "Input",ExpressionUUID->"dec3df48-11c3-499e-aa57-e21006d07b94",
   CellTags->"FirstInputCell"],
  Cell[127521, 2934, 755, 25, 36, "Input",ExpressionUUID->"330e9ab7-00f2-4e62-aef1-316c2337550f",
   CellTags->"FirstInputCell"],
  Cell[137388, 3186, 755, 25, 36, "Input",ExpressionUUID->"755e235d-2fd7-4610-833f-91a0cefec780",
   CellTags->"FirstInputCell"],
  Cell[153093, 3527, 755, 25, 36, "Input",ExpressionUUID->"930f3aa6-cdf0-4d00-90f9-cf96cad9fd7b",
   CellTags->"FirstInputCell"],
  Cell[175611, 3980, 755, 25, 36, "Input",ExpressionUUID->"2b3014cc-c173-41b0-88ea-d04a1abae96f",
   CellTags->"FirstInputCell"],
  Cell[183381, 4200, 755, 25, 36, "Input",ExpressionUUID->"608a3481-7a4d-4f77-ba09-c3a6bf3e62ed",
   CellTags->"FirstInputCell"],
  Cell[207342, 4684, 755, 25, 36, "Input",ExpressionUUID->"96606eb0-06f4-4368-a5d8-eb8eff20219e",
   CellTags->"FirstInputCell"],
  Cell[268745, 5776, 755, 25, 36, "Input",ExpressionUUID->"29514840-8b28-4206-a851-224bc7595c15",
   CellTags->"FirstInputCell"],
  Cell[296467, 6316, 755, 25, 36, "Input",ExpressionUUID->"073b335a-39ed-4e20-b514-b64f68f39af1",
   CellTags->"FirstInputCell"],
  Cell[352291, 7316, 755, 25, 36, "Input",ExpressionUUID->"fd081374-f62e-43e2-ba97-4826fc6f1221",
   CellTags->"FirstInputCell"],
  Cell[387511, 7980, 755, 25, 36, "Input",ExpressionUUID->"dce0490e-be6b-4e13-8d3e-c7d31307a7e9",
   CellTags->"FirstInputCell"],
  Cell[396333, 8213, 755, 25, 36, "Input",ExpressionUUID->"e2f1aa06-b7d6-4b79-aea0-deb1b92e0431",
   CellTags->"FirstInputCell"],
  Cell[435355, 8941, 755, 25, 36, "Input",ExpressionUUID->"8b0e3fd5-8e87-4414-9675-55da5935f7c0",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 494220, 10158}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[634, 21, 385, 9, 43, "Exercise",ExpressionUUID->"3dd3f59e-8c32-4702-9ed7-2aa8816f06fe",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 1}, {"WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1044, 34, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"53cb2067-90a3-46f9-81af-ff0dc3ceae58"],
Cell[1625, 54, 4270, 99, 57, "ExerciseOutput",ExpressionUUID->"ff6e755e-e80d-4525-b668-d67138635fac"]
}, Closed]],
Cell[CellGroupData[{
Cell[5932, 158, 564, 18, 19, "Subsection",ExpressionUUID->"d5196d5c-047e-4a4b-bd77-58ed6dd27c40"],
Cell[6499, 178, 755, 25, 36, "Input",ExpressionUUID->"a7277846-fee8-4450-b6ae-9a96161dfbe8",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7291, 208, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"50189fc8-1e24-4b16-936d-9344881c5ae1"],
Cell[7518, 217, 496, 16, 43, "Exercise",ExpressionUUID->"e2090763-de32-44ff-89ed-0a7fcd480dcc",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 2}, {"WebOnly", 0}}],
Cell[CellGroupData[{
Cell[8039, 237, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"4ddf09b5-42b1-4b6d-9652-6d7749616abc"],
Cell[8620, 257, 9601, 186, 57, "ExerciseOutput",ExpressionUUID->"037ac08f-fa1d-47d6-8147-4b1de8d6ca30"]
}, Closed]],
Cell[CellGroupData[{
Cell[18258, 448, 564, 18, 19, "Subsection",ExpressionUUID->"5025bd79-9c70-452e-9d02-e189708aad99"],
Cell[18825, 468, 755, 25, 36, "Input",ExpressionUUID->"f9898c6e-0636-4317-becc-b6f7cf4c79b5",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19629, 499, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"b98f1f79-bb0a-4e39-8ca8-114fae410644"],
Cell[19856, 508, 376, 9, 43, "Exercise",ExpressionUUID->"3c247e6e-b7f3-405a-82df-dbc696df6e87",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 3}, {"WebOnly", 0}}],
Cell[CellGroupData[{
Cell[20257, 521, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"19db49d8-7914-4906-876f-0de9bc1e1b16"],
Cell[20838, 541, 5848, 125, 74, "ExerciseOutput",ExpressionUUID->"ea14f7f8-606b-426f-83c9-17bb312626e7"]
}, Closed]],
Cell[CellGroupData[{
Cell[26723, 671, 564, 18, 19, "Subsection",ExpressionUUID->"2fdaa873-b859-4828-81bb-5001e21a3ad5"],
Cell[27290, 691, 755, 25, 36, "Input",ExpressionUUID->"46a80c10-dea0-4c77-9498-de23b304f239",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28094, 722, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"f74bc29a-ab37-4ade-9260-365d4f648638"],
Cell[28321, 731, 435, 13, 43, "Exercise",ExpressionUUID->"8a19b5db-4591-4065-87d5-3a260e100862",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 4}, {"WebOnly", 0}}],
Cell[CellGroupData[{
Cell[28781, 748, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"a039d418-3259-4d82-8a51-a4f0f30a481e"],
Cell[29362, 768, 6604, 137, 57, "ExerciseOutput",ExpressionUUID->"f6598cad-c486-4cce-8190-67a0b35be5b9"]
}, Closed]],
Cell[CellGroupData[{
Cell[36003, 910, 564, 18, 19, "Subsection",ExpressionUUID->"9eab19e6-f1ef-4554-a000-6aaabfa764db"],
Cell[36570, 930, 755, 25, 36, "Input",ExpressionUUID->"fe8cd5f1-b3e1-460c-9dcf-8e5b79255225",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37374, 961, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"9c250118-021d-4fc4-a93f-99631721286a"],
Cell[37601, 970, 555, 19, 43, "Exercise",ExpressionUUID->"c3b9b8c7-12c1-4906-84c5-88a616a99295",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 5}, {"WebOnly", 0}}],
Cell[CellGroupData[{
Cell[38181, 993, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"fc36585e-092f-4adb-a83f-c6a63b30809d"],
Cell[38762, 1013, 6315, 132, 57, "ExerciseOutput",ExpressionUUID->"16f4f385-188f-4fc3-8993-5042508f54aa"]
}, Closed]],
Cell[CellGroupData[{
Cell[45114, 1150, 564, 18, 19, "Subsection",ExpressionUUID->"7a59cbef-a0bb-47fe-93d0-b360072f5a67"],
Cell[45681, 1170, 755, 25, 36, "Input",ExpressionUUID->"e627b21d-47bd-47ac-a1b5-785c89ce7382",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46485, 1201, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"bcf4206a-05f9-4e04-a50a-de3b0b4f35c9"],
Cell[46712, 1210, 369, 9, 43, "Exercise",ExpressionUUID->"1abb5ea0-e298-4244-befb-f71bf426cae7",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 6}, {"WebOnly", 0}}],
Cell[CellGroupData[{
Cell[47106, 1223, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"6e734ed2-8071-47e8-96f6-bd317cb19aae"],
Cell[47687, 1243, 7306, 148, 166, "ExerciseOutput",ExpressionUUID->"2844ab61-337d-45f5-a43b-c06fdeee929b"]
}, Closed]],
Cell[CellGroupData[{
Cell[55030, 1396, 564, 18, 19, "Subsection",ExpressionUUID->"75c32002-8800-4d9e-aea7-9afaea9626f3"],
Cell[55597, 1416, 755, 25, 36, "Input",ExpressionUUID->"e02e00e9-737d-4136-b773-8c0b7f4e0873",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56401, 1447, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"f37dbb09-2cef-48d3-a5a7-fb4c1d3d2abf"],
Cell[56628, 1456, 385, 9, 43, "Exercise",ExpressionUUID->"aa79bfbc-1d23-492d-9230-30da043b66b9",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 7}, {"WebOnly", 0}}],
Cell[CellGroupData[{
Cell[57038, 1469, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"33880def-a707-4356-ac1a-ca6bc2ed7e13"],
Cell[57619, 1489, 7426, 151, 57, "ExerciseOutput",ExpressionUUID->"a1fab299-cb46-49fb-a16b-c52d3e73b402"]
}, Closed]],
Cell[CellGroupData[{
Cell[65082, 1645, 564, 18, 19, "Subsection",ExpressionUUID->"f74fbd6b-16bd-4ea1-b029-a913887d0527"],
Cell[65649, 1665, 755, 25, 36, "Input",ExpressionUUID->"ba01e5d6-35c0-4197-aaf7-7cd74ad3e3f4",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66453, 1696, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"3bab4ac9-5980-4a66-8788-b6ebfe6dd72a"],
Cell[66680, 1705, 434, 12, 43, "Exercise",ExpressionUUID->"015a8eda-a3e3-4798-bf64-c5a1cce756a3",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 8}, {"WebOnly", 0}}],
Cell[CellGroupData[{
Cell[67139, 1721, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"3feba629-0116-44ef-b7d7-a522d6af6cdd"],
Cell[67720, 1741, 12666, 236, 268, "ExerciseOutput",ExpressionUUID->"b2d33127-736b-40c3-8ac5-9e15f48c9847"]
}, Closed]],
Cell[CellGroupData[{
Cell[80423, 1982, 564, 18, 19, "Subsection",ExpressionUUID->"99a62a54-d8ff-4721-a2f5-a159ef7b2eb2"],
Cell[80990, 2002, 755, 25, 36, "Input",ExpressionUUID->"7255a416-7d99-4aeb-a539-03d2178a5544",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81794, 2033, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"5e2177bd-6350-4dac-bf4e-6c2a1f36580e"],
Cell[82021, 2042, 384, 9, 43, "Exercise",ExpressionUUID->"686830fa-adfe-4124-9c28-6e73b6308a97",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 9}, {"WebOnly", 0}}],
Cell[CellGroupData[{
Cell[82430, 2055, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"fd0de19c-0c73-4201-915c-7f330e46fafb"],
Cell[83011, 2075, 6214, 131, 57, "ExerciseOutput",ExpressionUUID->"9b1ea959-ed48-44d3-a0c0-c08268c22928"]
}, Closed]],
Cell[CellGroupData[{
Cell[89262, 2211, 564, 18, 19, "Subsection",ExpressionUUID->"1695a3b9-675c-4f3e-bcc5-782dea8240f3"],
Cell[89829, 2231, 755, 25, 36, "Input",ExpressionUUID->"dec3df48-11c3-499e-aa57-e21006d07b94",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90633, 2262, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"30053a00-8557-418a-bcf7-d8ea7188ab22"],
Cell[90860, 2271, 405, 11, 43, "Exercise",ExpressionUUID->"58a69bf7-7a58-41de-b76c-9e28c8f69112",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 10}, {"WebOnly", 0}}],
Cell[CellGroupData[{
Cell[91290, 2286, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"eb0e9fa9-09c7-4505-8433-22a2a8d44a05"],
Cell[91871, 2306, 35045, 603, 268, "ExerciseOutput",ExpressionUUID->"5d5056e4-0229-4932-ba54-40b3149ebe7c"]
}, Closed]],
Cell[CellGroupData[{
Cell[126953, 2914, 565, 18, 19, "Subsection",ExpressionUUID->"a7ee5aff-6de2-488b-8299-1deb9a6bb4e1"],
Cell[127521, 2934, 755, 25, 36, "Input",ExpressionUUID->"330e9ab7-00f2-4e62-aef1-316c2337550f",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[128325, 2965, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"b18f67a1-2f13-412e-9ba2-16edd32ea3fe"],
Cell[128552, 2974, 570, 19, 43, "Exercise",ExpressionUUID->"315b43fa-1650-4b93-94eb-13688fec332d",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 1}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[129147, 2997, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"3ed76fc4-7410-443d-ad84-a50d181a2f4e"],
Cell[129728, 3017, 7055, 144, 57, "ExerciseOutput",ExpressionUUID->"6bb982c0-69c1-40a8-b7b7-8f7a2b50e02e"]
}, Closed]],
Cell[CellGroupData[{
Cell[136820, 3166, 565, 18, 19, "Subsection",ExpressionUUID->"1c23abbd-80be-405f-adcf-e3471468ff5e"],
Cell[137388, 3186, 755, 25, 36, "Input",ExpressionUUID->"755e235d-2fd7-4610-833f-91a0cefec780",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[138192, 3217, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"d47ff153-d469-4704-8936-8e68938f9142"],
Cell[138419, 3226, 385, 9, 43, "Exercise",ExpressionUUID->"3de66cc5-dfd3-4132-ad50-cec28f07184c",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 2}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[138829, 3239, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"8a08d8ef-bd1b-43b2-8636-181fec6b262f"],
Cell[139410, 3259, 13078, 243, 77, "ExerciseOutput",ExpressionUUID->"05191477-7811-4870-96b8-fd27df581986"]
}, Closed]],
Cell[CellGroupData[{
Cell[152525, 3507, 565, 18, 19, "Subsection",ExpressionUUID->"40c7622b-4e76-40c8-b13a-bb40967649b0"],
Cell[153093, 3527, 755, 25, 36, "Input",ExpressionUUID->"930f3aa6-cdf0-4d00-90f9-cf96cad9fd7b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[153897, 3558, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"dfb633c1-92cf-4314-b587-e2fee619024a"],
Cell[154124, 3567, 382, 9, 43, "Exercise",ExpressionUUID->"62bebdd8-7dae-4ff7-ae5e-b686d5d99b3a",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 3}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[154531, 3580, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"748ad2b1-cd25-4360-ac92-1ad99064e314"],
Cell[155112, 3600, 19894, 355, 121, "ExerciseOutput",ExpressionUUID->"ce3a85bb-c66e-4826-adf3-acd59e591778"]
}, Closed]],
Cell[CellGroupData[{
Cell[175043, 3960, 565, 18, 19, "Subsection",ExpressionUUID->"7ed27c5c-27d3-415d-8c71-d39927f008e1"],
Cell[175611, 3980, 755, 25, 36, "Input",ExpressionUUID->"2b3014cc-c173-41b0-88ea-d04a1abae96f",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[176415, 4011, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"b752fbb5-a7b9-42c7-a7cd-1096535c2c48"],
Cell[176642, 4020, 616, 22, 43, "Exercise",ExpressionUUID->"f4441bee-f42d-4481-a654-c0606e748b5e",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 4}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[177283, 4046, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"955cf835-de19-4ca1-b020-9cc819361ef3"],
Cell[177864, 4066, 4912, 109, 57, "ExerciseOutput",ExpressionUUID->"d1d13097-30f4-43cd-a827-2389e7c786e2"]
}, Closed]],
Cell[CellGroupData[{
Cell[182813, 4180, 565, 18, 19, "Subsection",ExpressionUUID->"6e78091e-2a8a-4102-b362-9807a3743690"],
Cell[183381, 4200, 755, 25, 36, "Input",ExpressionUUID->"608a3481-7a4d-4f77-ba09-c3a6bf3e62ed",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[184185, 4231, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"814e8b42-2e80-4cdf-b27f-fffabaacd5e1"],
Cell[184412, 4240, 606, 20, 65, "Exercise",ExpressionUUID->"04449e0a-f5f9-4674-9ea6-1a4e8b776fce",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 5}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[185043, 4264, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"535ab57d-e824-47f5-8534-1ce187063f81"],
Cell[185624, 4284, 21113, 375, 152, "ExerciseOutput",ExpressionUUID->"8ce3e0e7-d1fc-463c-942b-d6d9cb0343e3"]
}, Closed]],
Cell[CellGroupData[{
Cell[206774, 4664, 565, 18, 19, "Subsection",ExpressionUUID->"729792ca-d223-4b22-acc3-b7d54d06a660"],
Cell[207342, 4684, 755, 25, 36, "Input",ExpressionUUID->"96606eb0-06f4-4368-a5d8-eb8eff20219e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[208146, 4715, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"118a2b47-bd77-4e0a-9193-e84077ab406b"],
Cell[208373, 4724, 403, 11, 43, "Exercise",ExpressionUUID->"88139dbd-7a64-46ed-9f59-0c6089258190",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 6}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[208801, 4739, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"9f3bbe3b-54b7-4da2-9e7e-1c0a92ea2f29"],
Cell[209382, 4759, 58758, 992, 268, "ExerciseOutput",ExpressionUUID->"0951af93-af55-46ff-83b4-804b3d411da6"]
}, Closed]],
Cell[CellGroupData[{
Cell[268177, 5756, 565, 18, 19, "Subsection",ExpressionUUID->"0602d125-d85c-4996-b8a0-0fd6253a51db"],
Cell[268745, 5776, 755, 25, 36, "Input",ExpressionUUID->"29514840-8b28-4206-a851-224bc7595c15",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[269549, 5807, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"bdc2d834-b022-4e13-afc8-c7b2c01508a4"],
Cell[269776, 5816, 410, 11, 43, "Exercise",ExpressionUUID->"cdd55c60-653f-4e72-81fa-ce8819d2e918",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 7}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[270211, 5831, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"606cd83e-beec-4e60-92e1-bc67de016e56"],
Cell[270792, 5851, 25070, 440, 268, "ExerciseOutput",ExpressionUUID->"88bdb921-ce72-452c-a2b9-16ab71c281b4"]
}, Closed]],
Cell[CellGroupData[{
Cell[295899, 6296, 565, 18, 19, "Subsection",ExpressionUUID->"a9442c83-5bf3-4389-a823-759bf707a811"],
Cell[296467, 6316, 755, 25, 36, "Input",ExpressionUUID->"073b335a-39ed-4e20-b514-b64f68f39af1",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[297271, 6347, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"8e774cda-7788-4f05-a2d7-fc6c9bf255e6"],
Cell[297498, 6356, 412, 11, 43, "Exercise",ExpressionUUID->"5e56bf92-af3a-4cf3-84a7-a8e746f4cfd1",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 8}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[297935, 6371, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"72b543d5-7704-41e1-bd19-7549a96e8250"],
Cell[298516, 6391, 53170, 900, 271, "ExerciseOutput",ExpressionUUID->"b47c262b-b462-4281-82e4-144eddefc90c"]
}, Closed]],
Cell[CellGroupData[{
Cell[351723, 7296, 565, 18, 19, "Subsection",ExpressionUUID->"125a81d8-f0f3-44d1-bf37-befe4c56bacc"],
Cell[352291, 7316, 755, 25, 36, "Input",ExpressionUUID->"fd081374-f62e-43e2-ba97-4826fc6f1221",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[353095, 7347, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"a8d09eab-6664-4fe1-895f-5ad84f8924b0"],
Cell[353322, 7356, 422, 12, 43, "Exercise",ExpressionUUID->"7a0266e9-13a4-48b8-899b-82a4943462e6",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 9}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[353769, 7372, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"be119da4-1083-4267-af71-617a61cca837"],
Cell[354350, 7392, 32556, 563, 189, "ExerciseOutput",ExpressionUUID->"6cf87044-d5bb-435c-bc56-199a5813d766"]
}, Closed]],
Cell[CellGroupData[{
Cell[386943, 7960, 565, 18, 19, "Subsection",ExpressionUUID->"e684d972-fa32-4d46-94b8-ff36cf0b6dd9"],
Cell[387511, 7980, 755, 25, 36, "Input",ExpressionUUID->"dce0490e-be6b-4e13-8d3e-c7d31307a7e9",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[388315, 8011, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"cb6cdc02-4279-416e-8cb4-2288cde6ec61"],
Cell[388542, 8020, 508, 16, 43, "Exercise",ExpressionUUID->"6a6aa8ce-e211-4609-80a0-0cd8349b0f78",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 10}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[389075, 8040, 578, 18, 30, "ExerciseExpectedResult",ExpressionUUID->"b327d328-23ea-4134-9a34-dc3848f910bf"],
Cell[389656, 8060, 6071, 128, 74, "ExerciseOutput",ExpressionUUID->"a607f8aa-e747-45e6-bfe8-bff571269516"]
}, Closed]],
Cell[CellGroupData[{
Cell[395764, 8193, 566, 18, 19, "Subsection",ExpressionUUID->"3d2c01b6-b3ac-453f-b1c0-11c471af76c0"],
Cell[396333, 8213, 755, 25, 36, "Input",ExpressionUUID->"e2f1aa06-b7d6-4b79-aea0-deb1b92e0431",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[397137, 8244, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"08f1615f-3462-4ccc-ba8f-4960419e05a8"],
Cell[397364, 8253, 563, 16, 43, "Exercise",ExpressionUUID->"6a906287-16c6-4724-a50a-b86416d4cbd4",
 CounterAssignments->{{"SectionNumber", 6}, {"ExerciseNumber", 11}, {"WebOnly", 1}}],
Cell[CellGroupData[{
Cell[397952, 8273, 598, 19, 30, "ExerciseExpectedResult",ExpressionUUID->"c2d3eb02-f30f-4619-8354-6a0f979e243f"],
Cell[398553, 8294, 36196, 622, 189, "ExerciseOutput",ExpressionUUID->"7b0b7087-aa3e-4937-ba83-e7ad51db4f14"]
}, Closed]],
Cell[CellGroupData[{
Cell[434786, 8921, 566, 18, 19, "Subsection",ExpressionUUID->"7cb34944-fc9b-47c5-8f7f-0696ed8e6a33"],
Cell[435355, 8941, 755, 25, 36, "Input",ExpressionUUID->"8b0e3fd5-8e87-4414-9675-55da5935f7c0",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[436137, 8970, 224, 7, 50, "CodeSectionDividerCloud",ExpressionUUID->"7e8b933a-c18f-4990-bba4-501db79f20fe"]
}
]
*)

(* NotebookSignature 5QWWvAn4PuX81luoAUtzr1If *)
