(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    149363,       3628]
NotebookOptionsPosition[     46632,       1560]
NotebookOutlinePosition[    140568,       3477]
CellTagsIndexPosition[    140125,       3457]
WindowTitle->Introducing Functions: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Introducing Functions", "SectionInline",ExpressionUUID->
   "7800ef93-90c6-42e8-865e-e4ae085d6719"],
  $Line = 0; Null]], "Section",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowCellLabel->False,
 CounterAssignments->{{"Section", 1}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{
  "p:3", "i:1"},ExpressionUUID->"54ed8130-640a-410d-9a5d-06af0f5cea6f"],

Cell[TextData[{
 "When you type ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineCodeText",ExpressionUUID->
  "3079b76b-c1ef-42bf-bdc6-e5942d3663e5"],
 ", the Wolfram Language understands it as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"2", ",", "2"}], "]"}]], "InlineCodeText",ExpressionUUID->
  "18f10171-fe37-43ac-a772-2223dba574d5"],
 ". ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 " is a ",
 StyleBox["function",
  FontSlant->"Italic"],
 ". There are more than 5000 functions built into the Wolfram Language. \
Arithmetic uses just a very few of these."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"1b55d5d3-a30c-42f4-88f4-bd47fdcddf42"],

Cell[TextData[{
 "Compute 3+4 using the function ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  10}},ExpressionUUID->"b9500f89-12d2-4bf5-ac17-af1c68dc0f9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "[", 
  RowBox[{"3", ",", "4"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"a1e8d18d-4097-465b-be4d-eed3036478d9"],

Cell[BoxData["7"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"015255e0-bf5e-4c83-a38c-54ddc58ae1bc"]
}, Open  ]],

Cell[TextData[{
 "Compute 1+2+3 using ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  10}},ExpressionUUID->"80196e49-29d0-4dff-93f1-2a27378c53bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "[", 
  RowBox[{"1", ",", "2", ",", "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"15005ee5-9fde-42b7-a346-5fc94e5f4ebd"],

Cell[BoxData["6"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"d32fb37a-df9f-4e6c-9d39-0bcae6867a80"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 ButtonBox["Times",
  BaseStyle->"Link"],
 " does multiplication:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 10}},
 CellTags->"i:3",ExpressionUUID->"933e543e-3f15-4e6e-a8e6-6631fa2b3c7e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "[", 
  RowBox[{"2", ",", "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"4bd1fecf-b3e8-4cd2-a239-f7c699311d0b"],

Cell[BoxData["6"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"b81ce32f-d234-4c6e-bf9c-ca9fed1d81d9"]
}, Open  ]],

Cell["You can put functions inside other functions:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  10}},ExpressionUUID->"5d3c3dfb-04fd-4c36-9058-b35177c617f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "[", 
  RowBox[{"2", ",", 
   RowBox[{"Plus", "[", 
    RowBox[{"2", ",", "3"}], "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"a5140266-a21e-433d-a9c5-8d86bc66e4ea"],

Cell[BoxData["10"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"6e9ddd3d-ddc0-416b-8458-779272897ad1"]
}, Open  ]],

Cell["\<\
All functions in the Wolfram Language use square brackets, and have names \
that start with capital letters. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {7, 5}},
 CellTags->"i:4",ExpressionUUID->"8ea36605-4a5b-40a7-91ed-a03e19c3c087"],

Cell[TextData[{
 "The function ",
 ButtonBox["Max",
  BaseStyle->"Link"],
 " finds the maximum, or largest, of ",
 "a collection of numbers",
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {7, 5}},
 CellTags->"i:5",ExpressionUUID->"227feee0-7e2d-4719-a411-82506f66c98c"],

Cell["The maximum of these numbers is 7:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  10}},ExpressionUUID->"44bb4687-d987-4e6b-9550-414fe0afb9b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"2", ",", "7", ",", "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"4781b511-93cf-4c77-a463-a2df6059946d"],

Cell[BoxData["7"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"2e8840be-6531-4da1-8fdd-f1d1ae00647b"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 ButtonBox["RandomInteger",
  BaseStyle->"Link"],
 " picks a random integer (whole number) between 0 and whatever size you say. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {7, 5}},
 CellTags->"i:6",ExpressionUUID->"f6fecac7-7050-4189-9dd7-20ef9d78b28e"],

Cell["Pick a random whole number between 0 and 100:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  10}},ExpressionUUID->"5b76f1d1-02e0-47ab-bf42-6d6d0fb374b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", "100", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"0d59ab3b-7f80-42fb-a373-00c62dabf73a"],

Cell[BoxData["71"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"9ada605b-4a58-4e8b-b1b8-6bb5701ab982"]
}, Open  ]],

Cell["Each time you ask, you get another random number: ", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  10}},ExpressionUUID->"c7caa9f4-6ab9-491f-abd1-306502adc700"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", "100", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"4f3cb2e9-ac50-454f-8d44-77389a1e0dae"],

Cell[BoxData["1"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[7]=",ExpressionUUID->"cf0f6fd9-cc32-46e2-b222-16eea55d8590"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:4",ExpressionUUID->"4893dd6b-e68c-4d5b-abf5-09e6f0654329"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Plus",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"2", ",", "2"}], "]"}], " ", 
    RowBox[{"2", "+", "2"}], " ", Cell[
    "addition ", "VocabularyText",ExpressionUUID->
     "1854b5cb-cf3d-4dc1-a3b1-46cdb7dde577"]},
   {
    RowBox[{
     ButtonBox["Subtract",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"5", ",", "2"}], "]"}], " ", 
    RowBox[{"5", "-", "2"}], " ", Cell[
    "subtraction ", "VocabularyText",ExpressionUUID->
     "839be50d-03d8-42f2-904d-4ade5f5fadac"]},
   {
    RowBox[{
     ButtonBox["Times",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"2", ",", "3"}], "]"}], " ", 
    RowBox[{"2", "*", "3"}], " ", Cell[TextData[{
     "multiplication (",
     StyleBox["2 3", "VocabularyText"],
     " also works) "
    }], "VocabularyText",ExpressionUUID->
     "f46ed055-7aa1-47b2-8e4c-44b3e9db506b"]},
   {
    RowBox[{
     ButtonBox["Divide",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"6", ",", "2"}], "]"}], " ", 
    RowBox[{"6", "/", "2"}], " ", Cell[
    "division ", "VocabularyText",ExpressionUUID->
     "a0dd6a28-a26f-4cae-b57e-84d0fa4dfc88"]},
   {
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"3", ",", "2"}], "]"}], " ", 
    RowBox[{"3", "^", "2"}], " ", Cell[
    "raising to a power ", "VocabularyText",ExpressionUUID->
     "b4239a5f-9339-42a1-b321-383da7c71db3"]},
   {
    RowBox[{
     ButtonBox["Max",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"3", ",", "4"}], "]"}], " ", " ", " ", Cell[
    "maximum (largest) ", "VocabularyText",ExpressionUUID->
     "5f9d7c10-054c-4a60-ab34-3586cbae9cc0"]},
   {
    RowBox[{
     ButtonBox["Min",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"3", ",", "4"}], "]"}], " ", " ", " ", Cell[
    "minimum (smallest) ", "VocabularyText",ExpressionUUID->
     "2cfc1427-1774-4695-98c0-358ea5ad8aa5"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"CodeLink"], "[", "10", "]"}], " ", " ", " ", Cell[
    "random whole number ", "VocabularyText",ExpressionUUID->
     "3bb5c952-0706-4366-816e-5f63afb3c25f"]}
  }]], "VocabularyTable3Column",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "Rows" -> {False, {True, True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True, True}, False}}},
 CellTags->"i:7",ExpressionUUID->"e122106c-f7d2-462c-a4fd-4de76f7407a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"4f59bfc1-25d5-49e4-a0aa-9b306a9c93c6"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"5 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 8 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-02-introducing-functions-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9fe83728-50c9-4a33-9c6d-f81df0ed48fe"],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute ",
 "7+6+5",
 " using the function ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "2.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"53264e16-9f57-40b9-a110-733ed81492d6"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "18"], "ExerciseOutput",ExpressionUUID->
       "2bd062ae-b74d-4416-af34-b88d0d0279fc"],
      Apply[TextCell, 
       Cell[
        BoxData["18"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c9789bda-448b-4640-a104-363ffd68e3f0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 2",
 "\[Times]",
 "(3+4) using ",
 ButtonBox["Times",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "2.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"698e3c30-1903-4409-82e9-b592d4b656c7"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "14"], "ExerciseOutput",ExpressionUUID->
       "52ce2e2b-0416-4037-9288-c18b2c2cb075"],
      Apply[TextCell, 
       Cell[
        BoxData["14"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c5686a61-808b-467f-a715-f5082b36ea3e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Max",
  BaseStyle->"Link"],
 " to find the larger of ",
 "6\[Times]8 and 5\[Times]9",
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "2.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e3cc0d8c-380b-4132-a0fc-b6b9dea5d36d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "48"], "ExerciseOutput",ExpressionUUID->
       "46858b09-be6b-48ad-baa9-fd9297267349"],
      Apply[TextCell, 
       Cell[
        BoxData["48"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"20f05a97-869b-4042-8766-54d715197a51"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["RandomInteger",
  BaseStyle->"Link"],
 " to generate a random number between 0 and 1000.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "2.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f383efb6-724e-4b5e-b27f-5f8cb0581b06"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "658"], "ExerciseOutput",ExpressionUUID->
       "e8c61140-b922-4a73-bc97-1b25cced9113"],
      Apply[TextCell, 
       Cell[
        BoxData["658"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"62a5a685-7bd8-416e-acd2-c8aa6e92a08f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["RandomInteger",
  BaseStyle->"Link"],
 " to generate a number between 10 and 20.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "2.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"17dc79f8-fd44-445f-a0e1-282ac6c005d1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "19"], "ExerciseOutput",ExpressionUUID->
       "df9236dc-53bc-48d2-ae4b-17b5bc10f016"],
      Apply[TextCell, 
       Cell[
        BoxData["19"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4159ad5f-27ad-4704-acd1-0130e7c4f9aa"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 5\[Times]4\[Times]3\[Times]2 using ",
 ButtonBox["Times",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+2.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d7213e14-24bf-46a7-a28b-7c8d89986b3d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "120"], "ExerciseOutput",ExpressionUUID->
       "0718a6f9-d238-45ba-bdde-eb12e87ccfcd"],
      Apply[TextCell, 
       Cell[
        BoxData["120"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"48d2e928-6556-43d9-a5f7-a34929412cc4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 2\[Minus]3 using ",
 ButtonBox["Subtract",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+2.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1b8205c6-3fc4-4131-b649-8fee131737a1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"-", "1"}]], "ExerciseOutput",ExpressionUUID->
       "906c0269-c94a-4972-b8e4-a987d6689cff"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"-", "1"}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c09fccec-b1a8-4735-ab6c-78b571f42506"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute (8+7)*(9+2) using ",
 ButtonBox["Times",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+2.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"64c51d53-99d0-42a7-b770-865aa97bdb73"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "165"], "ExerciseOutput",ExpressionUUID->
       "1852bcef-8d88-4126-a42c-6ff6c98d564d"],
      Apply[TextCell, 
       Cell[
        BoxData["165"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ff3b6e1c-8a0b-4088-8fbd-dd6196db63bf"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute (26\[Minus]89)/9 using ",
 ButtonBox["Subtract",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Divide",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+2.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"0cec5534-3960-4d52-994a-491dca66e396"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"-", "7"}]], "ExerciseOutput",ExpressionUUID->
       "93ca97cc-63f7-49d1-8657-e4e4f46ed812"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"-", "7"}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"35d0d5b0-3f30-41ee-997d-9dbd9c1c8a03"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 100\[Minus]5^2 using ",
 ButtonBox["Subtract",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Power",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+2.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1033ebb0-3105-4382-aa7d-4b5d99b7e3e6"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "75"], "ExerciseOutput",ExpressionUUID->
       "abf89878-c0f9-4b23-82ab-48796c39c45a"],
      Apply[TextCell, 
       Cell[
        BoxData["75"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"55d7f3f4-f7e6-4dba-baee-031abdd7b5da"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the larger of 3^5 and 5^3.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+2.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c793c2bf-55b0-4ee7-9de6-18d0bdd443dc"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "243"], "ExerciseOutput",ExpressionUUID->
       "8e1c29e0-c77f-4e87-958c-f0b61ccf7682"],
      Apply[TextCell, 
       Cell[
        BoxData["243"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0766a9a8-ef6c-47f7-9680-1038b0b9d7dc"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Multiply 3 and the larger of 4^3 and 3^4.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+2.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"03d0f2f0-2d60-4272-b408-260173be0580"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "243"], "ExerciseOutput",ExpressionUUID->
       "1593e34c-05da-47ad-a998-a663dfa68121"],
      Apply[TextCell, 
       Cell[
        BoxData["243"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e7bcd8c9-7afa-476f-9fa6-5ca0e8e4ac5c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Add two random numbers each between 0 and 1000.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+2.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f1667ffc-140f-4025-912d-8f38c708c223"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "1167"], "ExerciseOutput",ExpressionUUID->
       "4ecb9484-a074-4413-a438-269092007c1b"],
      Apply[TextCell, 
       Cell[
        BoxData["1167"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d99601a5-2338-468c-9dd8-344f137ffc86"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{64, Inherited}, {8, 
   28}},ExpressionUUID->"166acb6f-68a4-41a2-b546-77f52769b323"],

Cell[TextData[{
 "Do I have to type the capital letters in ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["RandomInteger",
  BaseStyle->"Link"],
 ", etc.?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"209a098d-73eb-4afd-a5d2-7eeefdf13bcd"],

Cell[TextData[{
 "Yes. In the Wolfram Language, ",
 Cell[BoxData[
 "plus"], "InlineCode",ExpressionUUID->"ea5d7dea-ff97-49ae-86c2-8141d0810a0e"],
 " is not the same as ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ". The capital letter in ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 " signifies that you\[CloseCurlyQuote]re talking about the built-in (\
\[OpenCurlyDoubleQuote]official\[CloseCurlyDoubleQuote]) plus function."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"34d1430d-6fb4-42fb-a350-c92b5fa701d2"],

Cell[TextData[{
 "Do I have to type square brackets ",
 Cell[BoxData[
  RowBox[{"[", "\[NegativeThinSpace]", 
   StyleBox["...",
    FontColor->GrayLevel[0.6]], "]"}]], "InlineCode",ExpressionUUID->
  "7ab104b1-fa6d-4fde-a407-da511d4cb13d"],
 " when I use functions?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 10}},
 CellTags->"i:9",ExpressionUUID->"bcdaa796-5d67-4fee-9179-763abd66191b"],

Cell[TextData[{
 "Yes. Square brackets ",
 Cell[BoxData[
  RowBox[{"[", "\[NegativeThinSpace]", 
   StyleBox["...",
    FontColor->GrayLevel[0.6]], "]"}]], "InlineCode",ExpressionUUID->
  "01397f22-26a5-4f89-beb9-e26a85ec65af"],
 " are for functions; parentheses ",
 Cell[BoxData[
  RowBox[{"(", "\[NegativeThinSpace]", 
   StyleBox["...",
    FontColor->GrayLevel[0.6]], ")"}]], "InlineCode",ExpressionUUID->
  "8f7c88ff-24d8-42b0-93f2-dfb1f9134675"],
 " are for grouping, as in 2*(3+4), not for functions."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 FontTracking->-0.05,ExpressionUUID->"4cebf128-b2b1-4009-91a5-245e8a5742a2"],

Cell[TextData[{
 "How does one read ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"2", ",", "3"}], "]"}]], "InlineCode",ExpressionUUID->
  "5a13e2f8-a0df-4dc8-833b-acb130c1eb1a"],
 " out loud?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 8}},
 CellTags->"i:10",ExpressionUUID->"d89d7a26-91f8-4223-9fd8-16b763dacf67"],

Cell[TextData[{
 "Usually \[OpenCurlyDoubleQuote]plus of 2 and 3\[CloseCurlyDoubleQuote]; \
sometimes \[OpenCurlyDoubleQuote]plus of 2 comma 3\[CloseCurlyDoubleQuote]. \
\[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "["], "InlineCode",ExpressionUUID->"a02a725f-2c7d-4f17-9fde-62c4cc64026a"],
 "\[CloseCurlyDoubleQuote] can be read as \[OpenCurlyDoubleQuote]open bracket\
\[CloseCurlyDoubleQuote]; \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "]"], "InlineCode",ExpressionUUID->"6ae31e09-699d-4129-a5d9-11a1a4ce45c2"],
 "\[CloseCurlyDoubleQuote] as \[OpenCurlyDoubleQuote]close bracket\
\[CloseCurlyDoubleQuote]."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9abb3897-9310-4320-9b6c-e97d1377836b"],

Cell[TextData[{
 "Why use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"2", ",", "3"}], "]"}]], "InlineCode",ExpressionUUID->
  "2b6af922-3d8e-49cc-923a-83027777ebe0"],
 " instead of ",
 Cell[BoxData[
  RowBox[{"2", "+", "3"}]], "InlineCode",ExpressionUUID->
  "40a1e184-f630-4f0a-b97c-4c3ee65c5d59"],
 "?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 
   10}},ExpressionUUID->"29c9a334-e03d-4223-9635-8ef122291042"],

Cell[TextData[{
 "For ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ", it\[CloseCurlyQuote]s not necessary. But for the vast majority of \
functions\[LongDash]like ",
 ButtonBox["Max",
  BaseStyle->"Link"],
 " or ",
 ButtonBox["RandomInteger",
  BaseStyle->"Link"],
 "\[LongDash]",
 "there\[CloseCurlyQuote]s no special form like ",
 Cell[BoxData[
  ButtonBox["+",
   BaseStyle->"Link",
   ButtonData->"Plus"]], "InlineCode",ExpressionUUID->
  "805f99f4-c823-45f7-b000-72c587ab46c4"],
 ", so you have to give their names. "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4e358088-739d-41c4-9c68-920bbf882ba9"],

Cell[TextData[{
 "Can I mix ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Plus",
     BaseStyle->"CodeLink"], "[", "\[NegativeThinSpace]", 
    StyleBox["...",
     FontColor->GrayLevel[0.6]], "]"}], " "}]], "InlineCode",ExpressionUUID->
  "13c85566-8269-4e97-bfa3-24ae6cdba1ab"],
 "and ",
 "+",
 "?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 
   10}},ExpressionUUID->"d90c8eba-9ad1-4384-9a28-2b5ce8f5a249"],

Cell[TextData[{
 "Yes. Things like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"4", "+", "5"}], ",", 
    RowBox[{"2", "+", "3"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "9997a972-4a91-4029-8493-3912762b03f2"],
 " or, for that matter, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Plus",
     BaseStyle->"CodeLink"], "[", 
    RowBox[{"4", ",", "5"}], "]"}], "*", "5"}]], "InlineCode",ExpressionUUID->
  "8e425677-145d-480d-b6e8-c52ca5acea86"],
 " are just fine."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0e24c1e6-c4dd-4341-90b6-3d2283003ca5"],

Cell["\<\
What does it mean if the Wolfram Language colors some of my input red?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 8}},
 CellTags->"i:11",ExpressionUUID->"7f1f976f-8da6-4060-8e04-c4eb3c0205b9"],

Cell[TextData[{
 "It means you\[CloseCurlyQuote]ve typed something that the Wolfram Language \
can\[CloseCurlyQuote]t understand. See ",
 ButtonBox["Section 47",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-47-debugging-your-code.nb", None}],
 " for more information. Start by checking that your open and close brackets \
are matched."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"0eafc7d5-f5f0-428e-97a0-6879d30b08df"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:5",ExpressionUUID->"95311b94-353d-4314-824f-ab7eca24eae5"],

Cell[TextData[{
 StyleBox["Expressions",
  FontSlant->"Italic"],
 " in the Wolfram Language (see ",
 ButtonBox["Section 33",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-33-expressions-and-their-structure.nb", None}],
 ") consist of nested trees of functions."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"aca586fb-3d25-4dbc-950a-670a0aa6e30a"],

Cell[TextData[{
 ButtonBox["Plus",
  BaseStyle->"Link"],
 " can add any number of numbers, but ",
 ButtonBox["Subtract",
  BaseStyle->"Link"],
 " only subtracts one number from another (to avoid ambiguities between (2\
\[Minus]3)\[Minus]4 and 2\[Minus](3\[Minus]4))."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"27c72d25-93ac-49f0-8d10-35550200e952"],

Cell[TextData[{
 "The notion of a function is considerably more general in the Wolfram \
Language than in either traditional mathematics or computer science. For \
example, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "CodeVariable"], "[", 
   StyleBox["anything", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "12b7dd61-3fbd-41b9-a73a-a24517714640"],
 " is considered a function, whether it evaluates to something definite or \
remains in symbolic form."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"5c1c27e8-28f5-4cec-94ce-96c1328cfabf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9b644817-c85a-4c02-b07b-11e276485c06"],

Cell[TextData[ButtonBox["Mathematical Functions in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"f7390ec3-749f-4697-acb5-6ab5dceff26d"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Introducing Functions: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Starting Out: Elementary Arithmetic\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Starting Out: Elementary Arithmetic", 
              "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"First Look at Lists\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "First Look at Lists", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingCopies->1,
PrintingStartingPageNumber->3,
PrintingPageRange->{1, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[
      " | Introducing Functions \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"4c605c3d-34cb-4fa3-8e63-4c1e889e89d4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:3"->{
  Cell[666, 24, 482, 13, 93, "Section",ExpressionUUID->"54ed8130-640a-410d-9a5d-06af0f5cea6f",
   CounterAssignments->{{"Section", 1}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->{"p:3", "i:1"}]},
 "i:1"->{
  Cell[666, 24, 482, 13, 93, "Section",ExpressionUUID->"54ed8130-640a-410d-9a5d-06af0f5cea6f",
   CounterAssignments->{{"Section", 1}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->{"p:3", "i:1"}]},
 "i:2"->{
  Cell[1151, 39, 763, 24, 91, "Text",ExpressionUUID->"1b55d5d3-a30c-42f4-88f4-bd47fdcddf42",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[3242, 119, 289, 10, 35, "CodeCaption",ExpressionUUID->"933e543e-3f15-4e6e-a8e6-6631fa2b3c7e",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[4598, 170, 302, 8, 59, "Text",ExpressionUUID->"8ea36605-4a5b-40a7-91ed-a03e19c3c087",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[4903, 180, 327, 12, 34, "Text",ExpressionUUID->"227feee0-7e2d-4719-a411-82506f66c98c",
   CellTags->"i:5"]},
 "i:6"->{
  Cell[5846, 216, 344, 10, 59, "Text",ExpressionUUID->"f6fecac7-7050-4189-9dd7-20ef9d78b28e",
   CellTags->"i:6"]},
 "LastCellOfAPage"->{
  Cell[7218, 263, 202, 5, 70, "Output",ExpressionUUID->"cf0f6fd9-cc32-46e2-b222-16eea55d8590",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[43921, 1471, 502, 13, 70, "Answer",ExpressionUUID->"0eafc7d5-f5f0-428e-97a0-6879d30b08df",
   CellTags->"LastCellOfAPage"],
  Cell[46267, 1549, 349, 8, 70, "MoreExplore",ExpressionUUID->"f7390ec3-749f-4697-acb5-6ab5dceff26d",
   CellTags->"LastCellOfAPage"]},
 "p:4"->{
  Cell[7469, 274, 174, 4, 70, "VocabularySection",ExpressionUUID->"4893dd6b-e68c-4d5b-abf5-09e6f0654329",
   CellTags->"p:4"]},
 "i:7"->{
  Cell[7646, 280, 2500, 73, 70, "VocabularyTable3Column",ExpressionUUID->"e122106c-f7d2-462c-a4fd-4de76f7407a2",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[38083, 1271, 321, 12, 70, "Question",ExpressionUUID->"209a098d-73eb-4afd-a5d2-7eeefdf13bcd",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[38970, 1303, 460, 13, 70, "Question",ExpressionUUID->"bcdaa796-5d67-4fee-9179-763abd66191b",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[40097, 1338, 435, 14, 70, "Question",ExpressionUUID->"d89d7a26-91f8-4223-9fd8-16b763dacf67",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[43643, 1462, 275, 7, 70, "Question",ExpressionUUID->"7f1f976f-8da6-4060-8e04-c4eb3c0205b9",
   CellTags->"i:11"]},
 "p:5"->{
  Cell[44460, 1489, 172, 4, 70, "TechNoteSection",ExpressionUUID->"95311b94-353d-4314-824f-ab7eca24eae5",
   CellTags->"p:5"]},
 "i:12"->{
  Cell[45443, 1523, 619, 15, 70, "TechNote",ExpressionUUID->"5c1c27e8-28f5-4cec-94ce-96c1328cfabf",
   CellTags->"i:12"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:3", 137447, 3399},
 {"i:1", 137699, 3403},
 {"i:2", 137951, 3407},
 {"i:3", 138076, 3410},
 {"i:4", 138209, 3413},
 {"i:5", 138334, 3416},
 {"i:6", 138460, 3419},
 {"LastCellOfAPage", 138598, 3422},
 {"p:4", 139026, 3430},
 {"i:7", 139164, 3433},
 {"i:8", 139309, 3436},
 {"i:9", 139441, 3439},
 {"i:10", 139574, 3442},
 {"i:11", 139708, 3445},
 {"p:5", 139840, 3448},
 {"i:12", 139979, 3451}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[666, 24, 482, 13, 93, "Section",ExpressionUUID->"54ed8130-640a-410d-9a5d-06af0f5cea6f",
 CounterAssignments->{{"Section", 1}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{"p:3", "i:1"}],
Cell[1151, 39, 763, 24, 91, "Text",ExpressionUUID->"1b55d5d3-a30c-42f4-88f4-bd47fdcddf42",
 CellTags->"i:2"],
Cell[1917, 65, 271, 10, 35, "CodeCaption",ExpressionUUID->"b9500f89-12d2-4bf5-ac17-af1c68dc0f9a"],
Cell[CellGroupData[{
Cell[2213, 79, 177, 4, 29, "Input",ExpressionUUID->"a1e8d18d-4097-465b-be4d-eed3036478d9"],
Cell[2393, 85, 172, 4, 40, "Output",ExpressionUUID->"015255e0-bf5e-4c83-a38c-54ddc58ae1bc",
 Evaluatable->False]
}, Open  ]],
Cell[2580, 92, 260, 10, 35, "CodeCaption",ExpressionUUID->"80196e49-29d0-4dff-93f1-2a27378c53bc"],
Cell[CellGroupData[{
Cell[2865, 106, 187, 4, 29, "Input",ExpressionUUID->"15005ee5-9fde-42b7-a346-5fc94e5f4ebd"],
Cell[3055, 112, 172, 4, 40, "Output",ExpressionUUID->"d32fb37a-df9f-4e6c-9d39-0bcae6867a80",
 Evaluatable->False]
}, Open  ]],
Cell[3242, 119, 289, 10, 35, "CodeCaption",ExpressionUUID->"933e543e-3f15-4e6e-a8e6-6631fa2b3c7e",
 CellTags->"i:3"],
Cell[CellGroupData[{
Cell[3556, 133, 178, 4, 29, "Input",ExpressionUUID->"4bd1fecf-b3e8-4cd2-a239-f7c699311d0b"],
Cell[3737, 139, 172, 4, 40, "Output",ExpressionUUID->"b81ce32f-d234-4c6e-bf9c-ca9fed1d81d9",
 Evaluatable->False]
}, Open  ]],
Cell[3924, 146, 223, 5, 35, "CodeCaption",ExpressionUUID->"5d3c3dfb-04fd-4c36-9058-b35177c617f5"],
Cell[CellGroupData[{
Cell[4172, 155, 235, 6, 29, "Input",ExpressionUUID->"a5140266-a21e-433d-a9c5-8d86bc66e4ea"],
Cell[4410, 163, 173, 4, 40, "Output",ExpressionUUID->"6e9ddd3d-ddc0-416b-8458-779272897ad1",
 Evaluatable->False]
}, Open  ]],
Cell[4598, 170, 302, 8, 59, "Text",ExpressionUUID->"8ea36605-4a5b-40a7-91ed-a03e19c3c087",
 CellTags->"i:4"],
Cell[4903, 180, 327, 12, 34, "Text",ExpressionUUID->"227feee0-7e2d-4719-a411-82506f66c98c",
 CellTags->"i:5"],
Cell[5233, 194, 212, 5, 35, "CodeCaption",ExpressionUUID->"44bb4687-d987-4e6b-9550-414fe0afb9b4"],
Cell[CellGroupData[{
Cell[5470, 203, 186, 4, 29, "Input",ExpressionUUID->"4781b511-93cf-4c77-a463-a2df6059946d"],
Cell[5659, 209, 172, 4, 40, "Output",ExpressionUUID->"2e8840be-6531-4da1-8fdd-f1d1ae00647b",
 Evaluatable->False]
}, Open  ]],
Cell[5846, 216, 344, 10, 59, "Text",ExpressionUUID->"f6fecac7-7050-4189-9dd7-20ef9d78b28e",
 CellTags->"i:6"],
Cell[6193, 228, 223, 5, 70, "CodeCaption",ExpressionUUID->"5b76f1d1-02e0-47ab-bf42-6d6d0fb374b6"],
Cell[CellGroupData[{
Cell[6441, 237, 165, 3, 70, "Input",ExpressionUUID->"0d59ab3b-7f80-42fb-a373-00c62dabf73a"],
Cell[6609, 242, 173, 4, 70, "Output",ExpressionUUID->"9ada605b-4a58-4e8b-b1b8-6bb5701ab982",
 Evaluatable->False]
}, Open  ]],
Cell[6797, 249, 228, 5, 70, "CodeCaption",ExpressionUUID->"c7caa9f4-6ab9-491f-abd1-306502adc700"],
Cell[CellGroupData[{
Cell[7050, 258, 165, 3, 70, "Input",ExpressionUUID->"4f3cb2e9-ac50-454f-8d44-77389a1e0dae"],
Cell[7218, 263, 202, 5, 70, "Output",ExpressionUUID->"cf0f6fd9-cc32-46e2-b222-16eea55d8590",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7469, 274, 174, 4, 70, "VocabularySection",ExpressionUUID->"4893dd6b-e68c-4d5b-abf5-09e6f0654329",
 CellTags->"p:4"],
Cell[7646, 280, 2500, 73, 70, "VocabularyTable3Column",ExpressionUUID->"e122106c-f7d2-462c-a4fd-4de76f7407a2",
 CellTags->"i:7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10183, 358, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"4f59bfc1-25d5-49e4-a0aa-9b306a9c93c6"],
Cell[CellGroupData[{
Cell[11988, 408, 1432, 43, 70, "ExerciseSummaryCell",ExpressionUUID->"9fe83728-50c9-4a33-9c6d-f81df0ed48fe"],
Cell[CellGroupData[{
Cell[13445, 455, 754, 25, 70, "Exercise",ExpressionUUID->"53264e16-9f57-40b9-a110-733ed81492d6"],
Cell[14202, 482, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"c9789bda-448b-4640-a104-363ffd68e3f0"]
}, Closed]],
Cell[CellGroupData[{
Cell[15306, 518, 802, 28, 70, "Exercise",ExpressionUUID->"698e3c30-1903-4409-82e9-b592d4b656c7"],
Cell[16111, 548, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"c5686a61-808b-467f-a715-f5082b36ea3e"]
}, Closed]],
Cell[CellGroupData[{
Cell[17215, 584, 772, 25, 70, "Exercise",ExpressionUUID->"e3cc0d8c-380b-4132-a0fc-b6b9dea5d36d"],
Cell[17990, 611, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"20f05a97-869b-4042-8766-54d715197a51"]
}, Closed]],
Cell[CellGroupData[{
Cell[19094, 647, 771, 23, 70, "Exercise",ExpressionUUID->"f383efb6-724e-4b5e-b27f-5f8cb0581b06"],
Cell[19868, 672, 1084, 31, 70, "ExerciseOutput",ExpressionUUID->"62a5a685-7bd8-416e-acd2-c8aa6e92a08f"]
}, Closed]],
Cell[CellGroupData[{
Cell[20989, 708, 814, 26, 70, "Exercise",ExpressionUUID->"17dc79f8-fd44-445f-a0e1-282ac6c005d1"],
Cell[21806, 736, 1082, 31, 70, "ExerciseOutput",ExpressionUUID->"4159ad5f-27ad-4704-acd1-0130e7c4f9aa"]
}, Closed]],
Cell[CellGroupData[{
Cell[22925, 772, 756, 23, 70, "Exercise",ExpressionUUID->"d7213e14-24bf-46a7-a28b-7c8d89986b3d"],
Cell[23684, 797, 1069, 31, 70, "ExerciseOutput",ExpressionUUID->"48d2e928-6556-43d9-a5f7-a34929412cc4"]
}, Closed]],
Cell[CellGroupData[{
Cell[24790, 833, 741, 23, 70, "Exercise",ExpressionUUID->"1b8205c6-3fc4-4131-b649-8fee131737a1"],
Cell[25534, 858, 1106, 32, 70, "ExerciseOutput",ExpressionUUID->"c09fccec-b1a8-4735-ab6c-78b571f42506"]
}, Closed]],
Cell[CellGroupData[{
Cell[26677, 895, 790, 26, 70, "Exercise",ExpressionUUID->"64c51d53-99d0-42a7-b770-865aa97bdb73"],
Cell[27470, 923, 1069, 31, 70, "ExerciseOutput",ExpressionUUID->"ff3b6e1c-8a0b-4088-8fbd-dd6196db63bf"]
}, Closed]],
Cell[CellGroupData[{
Cell[28576, 959, 800, 26, 70, "Exercise",ExpressionUUID->"0cec5534-3960-4d52-994a-491dca66e396"],
Cell[29379, 987, 1106, 32, 70, "ExerciseOutput",ExpressionUUID->"35d0d5b0-3f30-41ee-997d-9dbd9c1c8a03"]
}, Closed]],
Cell[CellGroupData[{
Cell[30522, 1024, 797, 26, 70, "Exercise",ExpressionUUID->"1033ebb0-3105-4382-aa7d-4b5d99b7e3e6"],
Cell[31322, 1052, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"55d7f3f4-f7e6-4dba-baee-031abdd7b5da"]
}, Closed]],
Cell[CellGroupData[{
Cell[32426, 1088, 696, 20, 70, "Exercise",ExpressionUUID->"c793c2bf-55b0-4ee7-9de6-18d0bdd443dc"],
Cell[33125, 1110, 1069, 31, 70, "ExerciseOutput",ExpressionUUID->"0766a9a8-ef6c-47f7-9680-1038b0b9d7dc"]
}, Closed]],
Cell[CellGroupData[{
Cell[34231, 1146, 706, 20, 70, "Exercise",ExpressionUUID->"03d0f2f0-2d60-4272-b408-260173be0580"],
Cell[34940, 1168, 1069, 31, 70, "ExerciseOutput",ExpressionUUID->"e7bcd8c9-7afa-476f-9fa6-5ca0e8e4ac5c"]
}, Closed]],
Cell[CellGroupData[{
Cell[36046, 1204, 712, 20, 70, "Exercise",ExpressionUUID->"f1667ffc-140f-4025-912d-8f38c708c223"],
Cell[36761, 1226, 1071, 31, 70, "ExerciseOutput",ExpressionUUID->"d99601a5-2338-468c-9dd8-344f137ffc86"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37893, 1264, 187, 5, 70, "QASection",ExpressionUUID->"166acb6f-68a4-41a2-b546-77f52769b323"],
Cell[38083, 1271, 321, 12, 70, "Question",ExpressionUUID->"209a098d-73eb-4afd-a5d2-7eeefdf13bcd",
 CellTags->"i:8"],
Cell[38407, 1285, 560, 16, 70, "Answer",ExpressionUUID->"34d1430d-6fb4-42fb-a350-c92b5fa701d2"],
Cell[38970, 1303, 460, 13, 70, "Question",ExpressionUUID->"bcdaa796-5d67-4fee-9179-763abd66191b",
 CellTags->"i:9"],
Cell[39433, 1318, 661, 18, 70, "Answer",ExpressionUUID->"4cebf128-b2b1-4009-91a5-245e8a5742a2"],
Cell[40097, 1338, 435, 14, 70, "Question",ExpressionUUID->"d89d7a26-91f8-4223-9fd8-16b763dacf67",
 CellTags->"i:10"],
Cell[40535, 1354, 739, 16, 70, "Answer",ExpressionUUID->"9abb3897-9310-4320-9b6c-e97d1377836b"],
Cell[41277, 1372, 535, 18, 70, "Question",ExpressionUUID->"29c9a334-e03d-4223-9635-8ef122291042"],
Cell[41815, 1392, 656, 23, 70, "Answer",ExpressionUUID->"4e358088-739d-41c4-9c68-920bbf882ba9"],
Cell[42474, 1417, 489, 18, 70, "Question",ExpressionUUID->"d90c8eba-9ad1-4384-9a28-2b5ce8f5a249"],
Cell[42966, 1437, 674, 23, 70, "Answer",ExpressionUUID->"0e24c1e6-c4dd-4341-90b6-3d2283003ca5"],
Cell[43643, 1462, 275, 7, 70, "Question",ExpressionUUID->"7f1f976f-8da6-4060-8e04-c4eb3c0205b9",
 CellTags->"i:11"],
Cell[43921, 1471, 502, 13, 70, "Answer",ExpressionUUID->"0eafc7d5-f5f0-428e-97a0-6879d30b08df",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44460, 1489, 172, 4, 70, "TechNoteSection",ExpressionUUID->"95311b94-353d-4314-824f-ab7eca24eae5",
 CellTags->"p:5"],
Cell[44635, 1495, 399, 12, 70, "TechNote",ExpressionUUID->"aca586fb-3d25-4dbc-950a-670a0aa6e30a"],
Cell[45037, 1509, 403, 12, 70, "TechNote",ExpressionUUID->"27c72d25-93ac-49f0-8d10-35550200e952"],
Cell[45443, 1523, 619, 15, 70, "TechNote",ExpressionUUID->"5c1c27e8-28f5-4cec-94ce-96c1328cfabf",
 CellTags->"i:12"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46099, 1543, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"9b644817-c85a-4c02-b07b-11e276485c06"],
Cell[46267, 1549, 349, 8, 70, "MoreExplore",ExpressionUUID->"f7390ec3-749f-4697-acb5-6ab5dceff26d",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature EIzwQ49VaO5XfKkDenUGToVa *)
