(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    152753,       3621]
NotebookOptionsPosition[     51765,       1588]
NotebookOutlinePosition[    144721,       3486]
CellTagsIndexPosition[    144377,       3470]
WindowTitle->Starting Out: Elementary Arithmetic: Elementary Introduction to \
the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Starting Out: Elementary Arithmetic", "SectionInline",ExpressionUUID->
   "f85bcacb-1961-4ac9-9c9f-c9dacd32f6d7"],
  $Line = 0; Null]], "Section",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowCellLabel->False,
 CounterAssignments->{{"Section", 0}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:1",ExpressionUUID->"496d755d-3e24-49d4-9af1-0bb7edefc163"],

Cell["\<\
As a first example of how the Wolfram Language operates, \
let\[CloseCurlyQuote]s look at elementary arithmetic.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"dd31f5f9-a280-4328-b08d-bc372fa04ecd"],

Cell["Add numbers:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"63437a81-6734-4689-b6a9-27871494aa0c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "+", "2"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"6360bb5c-1dde-4536-af27-a56a84fdb857"],

Cell[BoxData["4"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"3b06b17a-0e82-4de4-8fbb-1a16eedaa3dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1234", "+", "5678"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"ef12be15-66d7-462a-a405-f85f2d1bff51"],

Cell[BoxData["6912"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"aaf75c1c-802c-4072-8b5c-0b137e5063d0"]
}, Open  ]],

Cell["Multiply numbers:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"d424b443-f798-4bd9-8f3c-09baed38ed26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1234", "*", "5678"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"a9b7a0d8-3f31-4cfe-b830-5d220bac6889"],

Cell[BoxData["7006652"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"d9eeb8a6-da2d-4be0-af2b-c4f7dafc4d3f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fa0354b7-b711-4507-bb7a-2c9fc71c6720"],

Cell[BoxData[GridBox[{
   {
    RowBox[{"2", 
     ButtonBox["+",
      BaseStyle->"CodeLink",
      ButtonData->"Plus"], "2"}], " ", Cell[
    "addition ", "VocabularyText",ExpressionUUID->
     "399e57b4-77d4-49bb-bb7c-ccfaa908aa97"]},
   {
    RowBox[{"5", 
     ButtonBox["-",
      BaseStyle->"CodeLink",
      ButtonData->"Subtract"], "2"}], " ", Cell[
    "subtraction ", "VocabularyText",ExpressionUUID->
     "df370784-6b65-486e-b7c6-26252878d244"]},
   {
    RowBox[{"2", 
     ButtonBox["*",
      BaseStyle->"CodeLink",
      ButtonData->"Times"], "3"}], " ", Cell[TextData[{
     "multiplication (",
     StyleBox["2 3", "VocabularyText"],
     " also works) "
    }], "VocabularyText",ExpressionUUID->
     "83f89e80-b059-4b7e-a2ce-5b687e5e48b4"]},
   {
    RowBox[{"6", 
     ButtonBox["/",
      BaseStyle->"CodeLink",
      ButtonData->"Divide"], "2"}], " ", Cell[
    "division ", "VocabularyText",ExpressionUUID->
     "297fc027-9027-43f2-b2bd-6bd8b865b579"]},
   {
    RowBox[{"3", 
     ButtonBox["^",
      BaseStyle->"CodeLink",
      ButtonData->"Power"], "2"}], " ", Cell[
    "raising to a power (e.g. squaring) ", "VocabularyText",ExpressionUUID->
     "63325357-cdc1-4db2-9868-999bd86a25a0"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"2e136e94-4d5d-4c27-9dd2-d633c28e05dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"31f14dd8-a4ce-414c-a04b-be35d749bf78"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"9 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 8 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{
         "EIWL2-01-starting-out-elementary-arithmetic-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2bef78f4-dbf5-4542-89d0-dbff186376ab"],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 1+2+3.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d6d5f35b-17a4-4268-9c22-7ae8181a9a02"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "6"], "ExerciseOutput",ExpressionUUID->
       "c96623eb-07ac-44b7-98e7-9f516819f783"],
      Apply[TextCell, 
       Cell[
        BoxData["6"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ddc40c2f-5504-42fe-a11e-6bc22528e1ac"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Add the numbers 1, 2, 3, 4, 5.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a0a0f41a-ffff-45fe-bd9a-4e325dda1986"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "15"], "ExerciseOutput",ExpressionUUID->
       "16b0c56b-e289-4b69-8f7f-6639d3a0031b"],
      Apply[TextCell, 
       Cell[
        BoxData["15"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4c47ac1f-acdb-401b-a77f-fad70413de63"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Multiply the numbers 1, 2, 3, 4, 5.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f1484c09-afdb-4241-be8b-26a812dea986"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "120"], "ExerciseOutput",ExpressionUUID->
       "da74acf9-b4e2-45f7-aa23-0ec62d736a39"],
      Apply[TextCell, 
       Cell[
        BoxData["120"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c6dc3960-a0b2-4843-9339-dababcc473ce"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 5 squared (i.e. 5\[Times]5 or 5 raised to the power 2).",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"36bb4cb8-40bc-4573-85a7-f5742f850a8f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "25"], "ExerciseOutput",ExpressionUUID->
       "aad77957-3113-4cc2-a5f9-05b28b0e4208"],
      Apply[TextCell, 
       Cell[
        BoxData["25"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1b6893d0-fd7c-4a36-83e7-36a527f13803"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 3 raised to the fourth power.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ed392d60-79de-4137-ae13-e7a3ffcfe5bc"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "81"], "ExerciseOutput",ExpressionUUID->
       "99a779eb-2b24-4fb5-b8ef-cc0ed64cd431"],
      Apply[TextCell, 
       Cell[
        BoxData["81"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6d70476f-8197-4bc1-985f-324fdf81ed96"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 10 raised to the power 12 (a trillion).",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a77f2519-980b-461a-9404-536bcd73c46c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "1000000000000"], "ExerciseOutput",ExpressionUUID->
       "b196f9ed-e647-4094-936e-098ba8e0d680"],
      Apply[TextCell, 
       Cell[
        BoxData["1000000000000"], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3faedfc6-f27e-433a-bc6e-cf50f4770ed2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 3 raised to the power 7\[Times]8.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"8e07c4cf-24c1-4a0a-8a06-071e63b6194b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "523347633027360537213511521"], "ExerciseOutput",ExpressionUUID->
       "ed4580a5-8606-46e4-9af8-a8acbd9bfdda"],
      Apply[TextCell, 
       Cell[
        BoxData["523347633027360537213511521"], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ab48a99f-12c6-4a29-bc28-8305aee2d391"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Add parentheses to ",
 Cell[BoxData[
  RowBox[{"4", "-", 
   RowBox[{"2", "*", "3"}], "+", "4"}]], "InlineCode",ExpressionUUID->
  "e2556061-dfe7-4b06-afd0-6d64ec141e9d"],
 " to make 14.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a60e786b-8b92-49bd-a61f-4bef604c846e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "14"], "ExerciseOutput",ExpressionUUID->
       "421a0a75-d70f-4b3c-b8c9-0dff7f473350"],
      Apply[TextCell, 
       Cell[
        BoxData["14"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ee90e7b2-bf04-4f6b-8a0c-95ae525e1d33"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute twenty-nine thousand multiplied by seventy-three.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"7e00fe26-c5e5-406c-a6c4-a0bbf39f33c6"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "2117000"], "ExerciseOutput",ExpressionUUID->
       "b65732b7-f7ac-4984-af6b-611150672d32"],
      Apply[TextCell, 
       Cell[
        BoxData["2117000"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5500ed79-6216-4c84-8d9d-2287e9e747a2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Add all integers from -3 to +3. ",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"93b40b91-f481-4f55-b004-152eea2b585c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "0"], "ExerciseOutput",ExpressionUUID->
       "dfc98481-89ed-4e14-8534-465a81711a3d"],
      Apply[TextCell, 
       Cell[
        BoxData["0"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3c1c418b-038e-49a1-9f69-f47215e7ffd6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 24 divided by 3.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"5d2d92bf-44af-49e1-ac85-01e9122bb393"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "8"], "ExerciseOutput",ExpressionUUID->
       "34d58ca0-7b18-4d76-94e7-f4377f9fc7ea"],
      Apply[TextCell, 
       Cell[
        BoxData["8"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5a46f2ba-44b7-4261-b1fa-0ed6c2dec5f2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 5 raised to the power 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e281653d-7ae7-4d32-a90c-fdf71c9dff90"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "7888609052210118054117285652827862296732064351090230047702789306640625"\
], "ExerciseOutput",ExpressionUUID->"eaa089b3-806d-4ba3-97f3-3d59d2f0f980"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "788860905221011805411728565282786229673206435109023004770278930664062\
5"], "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5041e3af-e87a-42df-b2ca-f7c391afb7ec"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Subtract 5 squared from 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"00fa2ecf-067b-4d04-a03d-40ba327ce556"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "75"], "ExerciseOutput",ExpressionUUID->
       "0df5608c-f26a-4ba5-ae37-8b5d38b6ba0a"],
      Apply[TextCell, 
       Cell[
        BoxData["75"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e135473c-2654-4136-b955-b9891ad89330"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Multiply 6 by 5 squared, and add 7.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"6ebc25ec-9b52-42ba-b612-999ac45aea10"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "157"], "ExerciseOutput",ExpressionUUID->
       "52b5d4fa-e0c3-4a08-a6f2-b7fecd04eb1b"],
      Apply[TextCell, 
       Cell[
        BoxData["157"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"897228ed-e7cd-4101-b790-1ad7d9711dcb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 3 squared minus 2 cubed. ",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ad5fb202-81d2-4479-8dd4-a6dad95bd55f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "1"], "ExerciseOutput",ExpressionUUID->
       "e1d4cff0-0592-4cd2-a42d-75fe6a510d0c"],
      Apply[TextCell, 
       Cell[
        BoxData["1"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"86b1a65b-ebe1-4148-88c5-77b91977851b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute 2 cubed times 3 squared.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d81530b5-eef7-422d-baf4-0f661d94e28e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "72"], "ExerciseOutput",ExpressionUUID->
       "7da10528-b7db-4c77-8ce8-d9f503233f72"],
      Apply[TextCell, 
       Cell[
        BoxData["72"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5f09d4f3-ba84-44e2-ab25-ad6d7e4f6147"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute \[OpenCurlyDoubleQuote]double the sum of eight and negative eleven\
\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4de526d4-15a8-401a-97f5-0013e95ac78a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"-", "6"}]], "ExerciseOutput",ExpressionUUID->
       "7237fe44-3ebb-4e81-8540-1a8a8c4a7ef8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"-", "6"}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aec1b7f3-aafd-48ee-a42f-21afdf603878"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:2",ExpressionUUID->"e34c29d8-069d-4ba5-a75b-2ab99c46cff6"],

Cell["\<\
In 2+2, etc. how do I tell the Wolfram Language that I\[CloseCurlyQuote]ve \
finished my input?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7771e630-751b-422b-9d3a-2ee3202a723a"],

Cell[TextData[{
 "On a computer, press ",
 Cell[BoxData[
  TemplateBox[{"shift", "return"},
   "Key1"]],ExpressionUUID->"bfc3310b-e655-40e2-8c32-a453a6bac085"],
 ". On a mobile device, press the ",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJztnQeYFEUWxzGdXlbMEcxZjJwR1PvM6cScBUXUU0D0znTCIiwZlTORFDwx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     "], {{0, 128}, {
     115, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   BaseStyle->"ImageGraphics",
   ImagePadding->{{0, 0}, {4, 0}},
   ImageSize->{22, 24},
   ImageSizeRaw->{115, 128},
   PlotRange->{{0, 115}, {0, 128}}]], "InlineCodeText",ExpressionUUID->
  "d1837512-dd7a-4cf0-b1d6-142f21ffc2ea"],
 " button. See ",
 ButtonBox["Practicalities of Using the Wolfram Language",
  BaseStyle->"Hyperlink",
  ButtonData->{
   "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", None}],
 " for more details."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellBaseline->16,
 LineSpacing->{1.15, 1., 
  2.},ExpressionUUID->"a9505ff0-15a6-4fb0-88ca-ef6db2966866"],

Cell["Why is multiplication indicated by *?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8e925f1b-e9e1-4174-a8ed-cc6c8a9c8b3c"],

Cell[TextData[{
 "Because the * (\[OpenCurlyDoubleQuote]star\[CloseCurlyDoubleQuote], \
typically typed as ",
 Cell[BoxData[
  TemplateBox[{"shift", "8"},
   "Key1"]],ExpressionUUID->"4269681c-f928-4168-9c45-78a224c69599"],
 ") looks like a multiplication sign. In the Wolfram Language, you can also \
just put a space between numbers you want to multiply; t",
 StyleBox["he Wolfram Language will then automatically insert a ",
  Background->None],
 Cell[BoxData[
  ButtonBox["\[Times]",
   BaseStyle->"Link",
   ButtonData->"Times"]], "InlineCode",ExpressionUUID->
  "55426bca-b539-450a-bcf0-0ea94414699d"],
 StyleBox[" multiplication sign.",
  Background->None]
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"7d922352-857c-44f7-bfcd-b39085faa02b"],

Cell[TextData[{
 "What does \[OpenCurlyDoubleQuote]raised to the \
power\[CloseCurlyDoubleQuote] (",
 Cell[BoxData[
  ButtonBox["^",
   BaseStyle->"Link",
   ButtonData->"Power"]], "InlineCode",ExpressionUUID->
  "598e34ce-1cfd-498a-91ca-6ca26186cb10"],
 ") mean?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"d4e8a424-1c84-426c-bbba-6da0c932747b"],

Cell["\<\
6^3 means 6\[Times]6\[Times]6 (i.e. 6 multiplied by itself 3 times); 10^5 \
means 10\[Times]10\[Times]10\[Times]10\[Times]10; etc.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c784b1b3-9dd8-4e3c-ba34-3f9be9f5f3c9"],

Cell["How big can numbers get in the Wolfram Language?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 
   8}},ExpressionUUID->"bba023a4-6159-4c83-a58f-b2d3c5668c92"],

Cell["\<\
As big as you want\[LongDash]so long as they fit in your computer\
\[CloseCurlyQuote]s memory. \
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"2d320432-ee89-40bb-8701-7be959baa744"],

Cell["What is the order of operations in the Wolfram Language?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 8}},
 CellTags->"i:8",ExpressionUUID->"800c35fe-4402-4de8-9486-02201cef6730"],

Cell[TextData[{
 "The same as in ordinary math: powers, multiplication, addition. So 4*5^2+7 \
means (4*(5^2))+7. You can use parentheses just like in math. (In math, \
people sometimes use [",
 StyleBox["...",
  FontColor->GrayLevel[0.6]],
 "] as well as (",
 StyleBox["...",
  FontColor->GrayLevel[0.6]],
 "). In the Wolfram Language [",
 StyleBox["...",
  FontColor->GrayLevel[0.6]],
 "] means something different.)"
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2fe48899-2e23-4590-8560-f9b341f57899"],

Cell["\<\
When I do division, how do I avoid getting fractions in my answer?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eb207a1c-f995-43ac-ab36-236df4c0b8a8"],

Cell[TextData[{
 "If you put in numbers with decimal points, you\[CloseCurlyQuote]ll get out \
numbers with decimal points. You can also use ",
 ButtonBox["N",
  BaseStyle->"Link"],
 ", as we discuss in ",
 ButtonBox["Section 23",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-23-more-about-numbers.nb", "N"}],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2cfc6ed8-7141-4838-a0ed-777920775d22"],

Cell["\<\
What are the little spaces between digits in results like 7\[ThinSpace]006\
\[ThinSpace]652?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5236310e-4dbb-43ef-b46f-1d3e1b4abb25"],

Cell["\<\
They\[CloseCurlyQuote]re there to help you read the number when it\
\[CloseCurlyQuote]s displayed; they\[CloseCurlyQuote]re not part of the \
number. \
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e55df187-6629-4ef7-b465-ca3383f7373c"],

Cell["How do I enter a big number?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 
   8}},ExpressionUUID->"7ac03234-5f94-4ab5-b844-5aa419cf6594"],

Cell["\<\
Just type the digits, without putting any commas, spaces or other separators \
(e.g. 1234123511415223).\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"38c4c1dc-7876-4b86-a272-24ad16862a44"],

Cell[TextData[{
 "What happens if I compute ",
 Cell[BoxData[
  RowBox[{"1", "/", "0"}]], "InlineCode",ExpressionUUID->
  "c42f93bb-64c5-4a4d-b677-d4c79fc99b68"],
 "?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f9d42e71-d962-4cb5-818b-bf5f2049a6fa"],

Cell["\<\
Try it!  You\[CloseCurlyQuote]ll get a symbolic representation of infinity, \
on which the Wolfram Language can then do further computations.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"f50be669-1c9d-414c-84b9-c56d8610a7cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f098140f-4674-4e3b-a50e-e93f96e06e56"],

Cell[TextData[ButtonBox["Getting Started in Wolfram Programming Lab\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://www.wolfram.com/programming-lab/"], None},
 ButtonNote->"http://www.wolfram.com/programming-lab/"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"64f6490d-b8a4-4414-8ded-86065adc696a"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Starting Out: Elementary Arithmetic: Elementary Introduction to \
the Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Other Resources\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Other Resources", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Introducing Functions\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Introducing Functions", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingCopies->1,
PrintingStartingPageNumber->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[
      " | Starting Out: Elementary Arithmetic \[LongDash] wolfr.am/eiwl-", 
       "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"f45ae200-3e38-4aa3-904b-f55eb86992a6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:1"->{
  Cell[680, 24, 484, 12, 93, "Section",ExpressionUUID->"496d755d-3e24-49d4-9af1-0bb7edefc163",
   CounterAssignments->{{"Section", 0}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->"p:1"]},
 "i:1"->{
  Cell[1167, 38, 271, 7, 65, "Text",ExpressionUUID->"dd31f5f9-a280-4328-b08d-bc372fa04ecd",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[1441, 47, 170, 4, 37, "CodeCaption",ExpressionUUID->"63437a81-6734-4689-b6a9-27871494aa0c",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[2339, 81, 175, 4, 37, "CodeCaption",ExpressionUUID->"d424b443-f798-4bd9-8f3c-09baed38ed26",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[3083, 110, 1381, 43, 183, "VocabularyTable",ExpressionUUID->"2e136e94-4d5d-4c27-9dd2-d633c28e05dd",
   CellTags->"i:4"]},
 "LastCellOfAPage"->{
  Cell[22488, 726, 751, 21, 70, "Exercise",ExpressionUUID->"7e00fe26-c5e5-406c-a6c4-a0bbf39f33c6",
   CellTags->"LastCellOfAPage"],
  Cell[51321, 1575, 428, 10, 70, "MoreExplore",ExpressionUUID->"64f6490d-b8a4-4414-8ded-86065adc696a",
   CellTags->"LastCellOfAPage"]},
 "p:2"->{
  Cell[39051, 1255, 159, 4, 70, "QASection",ExpressionUUID->"e34c29d8-069d-4ba5-a75b-2ab99c46cff6",
   CellTags->"p:2"]},
 "i:5"->{
  Cell[46015, 1397, 812, 21, 70, "Answer",ExpressionUUID->"7d922352-857c-44f7-bfcd-b39085faa02b",
   CellTags->"i:5"]},
 "i:6"->{
  Cell[46830, 1420, 415, 13, 70, "Question",ExpressionUUID->"d4e8a424-1c84-426c-bbba-6da0c932747b",
   CellTags->"i:6"]},
 "i:7"->{
  Cell[47760, 1451, 256, 7, 70, "Answer",ExpressionUUID->"2d320432-ee89-40bb-8701-7be959baa744",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[48019, 1460, 252, 5, 70, "Question",ExpressionUUID->"800c35fe-4402-4de8-9486-02201cef6730",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[50814, 1557, 302, 7, 70, "Answer",ExpressionUUID->"f50be669-1c9d-414c-84b9-c56d8610a7cf",
   CellTags->"i:9"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:1", 142522, 3428},
 {"i:1", 142765, 3432},
 {"i:2", 142889, 3435},
 {"i:3", 143020, 3438},
 {"i:4", 143151, 3441},
 {"LastCellOfAPage", 143302, 3444},
 {"p:2", 143581, 3449},
 {"i:5", 143713, 3452},
 {"i:6", 143843, 3455},
 {"i:7", 143975, 3458},
 {"i:8", 144104, 3461},
 {"i:9", 144235, 3464}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[680, 24, 484, 12, 93, "Section",ExpressionUUID->"496d755d-3e24-49d4-9af1-0bb7edefc163",
 CounterAssignments->{{"Section", 0}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:1"],
Cell[1167, 38, 271, 7, 65, "Text",ExpressionUUID->"dd31f5f9-a280-4328-b08d-bc372fa04ecd",
 CellTags->"i:1"],
Cell[1441, 47, 170, 4, 37, "CodeCaption",ExpressionUUID->"63437a81-6734-4689-b6a9-27871494aa0c",
 CellTags->"i:2"],
Cell[CellGroupData[{
Cell[1636, 55, 146, 3, 29, "Input",ExpressionUUID->"6360bb5c-1dde-4536-af27-a56a84fdb857"],
Cell[1785, 60, 172, 4, 40, "Output",ExpressionUUID->"3b06b17a-0e82-4de4-8fbb-1a16eedaa3dc",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[1994, 69, 152, 3, 29, "Input",ExpressionUUID->"ef12be15-66d7-462a-a405-f85f2d1bff51"],
Cell[2149, 74, 175, 4, 40, "Output",ExpressionUUID->"aaf75c1c-802c-4072-8b5c-0b137e5063d0",
 Evaluatable->False]
}, Open  ]],
Cell[2339, 81, 175, 4, 37, "CodeCaption",ExpressionUUID->"d424b443-f798-4bd9-8f3c-09baed38ed26",
 CellTags->"i:3"],
Cell[CellGroupData[{
Cell[2539, 89, 152, 3, 29, "Input",ExpressionUUID->"a9b7a0d8-3f31-4cfe-b830-5d220bac6889"],
Cell[2694, 94, 178, 4, 40, "Output",ExpressionUUID->"d9eeb8a6-da2d-4be0-af2b-c4f7dafc4d3f",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2921, 104, 159, 4, 64, "VocabularySection",ExpressionUUID->"fa0354b7-b711-4507-bb7a-2c9fc71c6720"],
Cell[3083, 110, 1381, 43, 183, "VocabularyTable",ExpressionUUID->"2e136e94-4d5d-4c27-9dd2-d633c28e05dd",
 CellTags->"i:4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4501, 158, 1780, 46, 71, "ExerciseSection",ExpressionUUID->"31f14dd8-a4ce-414c-a04b-be35d749bf78"],
Cell[CellGroupData[{
Cell[6306, 208, 1455, 44, 85, "ExerciseSummaryCell",ExpressionUUID->"2bef78f4-dbf5-4542-89d0-dbff186376ab"],
Cell[CellGroupData[{
Cell[7786, 256, 678, 20, 70, "Exercise",ExpressionUUID->"d6d5f35b-17a4-4268-9c22-7ae8181a9a02"],
Cell[8467, 278, 1065, 31, 70, "ExerciseOutput",ExpressionUUID->"ddc40c2f-5504-42fe-a11e-6bc22528e1ac"]
}, Closed]],
Cell[CellGroupData[{
Cell[9569, 314, 694, 20, 70, "Exercise",ExpressionUUID->"a0a0f41a-ffff-45fe-bd9a-4e325dda1986"],
Cell[10266, 336, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"4c47ac1f-acdb-401b-a77f-fad70413de63"]
}, Closed]],
Cell[CellGroupData[{
Cell[11370, 372, 699, 20, 70, "Exercise",ExpressionUUID->"f1484c09-afdb-4241-be8b-26a812dea986"],
Cell[12072, 394, 1069, 31, 70, "ExerciseOutput",ExpressionUUID->"c6dc3960-a0b2-4843-9339-dababcc473ce"]
}, Closed]],
Cell[CellGroupData[{
Cell[13178, 430, 727, 20, 70, "Exercise",ExpressionUUID->"36bb4cb8-40bc-4573-85a7-f5742f850a8f"],
Cell[13908, 452, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"1b6893d0-fd7c-4a36-83e7-36a527f13803"]
}, Closed]],
Cell[CellGroupData[{
Cell[15012, 488, 701, 20, 70, "Exercise",ExpressionUUID->"ed392d60-79de-4137-ae13-e7a3ffcfe5bc"],
Cell[15716, 510, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"6d70476f-8197-4bc1-985f-324fdf81ed96"]
}, Closed]],
Cell[CellGroupData[{
Cell[16820, 546, 711, 20, 70, "Exercise",ExpressionUUID->"a77f2519-980b-461a-9404-536bcd73c46c"],
Cell[17534, 568, 1089, 31, 70, "ExerciseOutput",ExpressionUUID->"3faedfc6-f27e-433a-bc6e-cf50f4770ed2"]
}, Closed]],
Cell[CellGroupData[{
Cell[18660, 604, 705, 20, 70, "Exercise",ExpressionUUID->"8e07c4cf-24c1-4a0a-8a06-071e63b6194b"],
Cell[19368, 626, 1126, 32, 70, "ExerciseOutput",ExpressionUUID->"ab48a99f-12c6-4a29-bc28-8305aee2d391"]
}, Closed]],
Cell[CellGroupData[{
Cell[20531, 663, 850, 25, 70, "Exercise",ExpressionUUID->"a60e786b-8b92-49bd-a61f-4bef604c846e"],
Cell[21384, 690, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"ee90e7b2-bf04-4f6b-8a0c-95ae525e1d33"]
}, Closed]],
Cell[CellGroupData[{
Cell[22488, 726, 751, 21, 70, "Exercise",ExpressionUUID->"7e00fe26-c5e5-406c-a6c4-a0bbf39f33c6",
 CellTags->"LastCellOfAPage"],
Cell[23242, 749, 1077, 31, 70, "ExerciseOutput",ExpressionUUID->"5500ed79-6216-4c84-8d9d-2287e9e747a2"]
}, Closed]],
Cell[CellGroupData[{
Cell[24356, 785, 697, 20, 70, "Exercise",ExpressionUUID->"93b40b91-f481-4f55-b004-152eea2b585c"],
Cell[25056, 807, 1065, 31, 70, "ExerciseOutput",ExpressionUUID->"3c1c418b-038e-49a1-9f69-f47215e7ffd6"]
}, Closed]],
Cell[CellGroupData[{
Cell[26158, 843, 689, 20, 70, "Exercise",ExpressionUUID->"5d2d92bf-44af-49e1-ac85-01e9122bb393"],
Cell[26850, 865, 1065, 31, 70, "ExerciseOutput",ExpressionUUID->"5a46f2ba-44b7-4261-b1fa-0ed6c2dec5f2"]
}, Closed]],
Cell[CellGroupData[{
Cell[27952, 901, 699, 20, 70, "Exercise",ExpressionUUID->"e281653d-7ae7-4d32-a90c-fdf71c9dff90"],
Cell[28654, 923, 1208, 33, 70, "ExerciseOutput",ExpressionUUID->"5041e3af-e87a-42df-b2ca-f7c391afb7ec"]
}, Closed]],
Cell[CellGroupData[{
Cell[29899, 961, 693, 20, 70, "Exercise",ExpressionUUID->"00fa2ecf-067b-4d04-a03d-40ba327ce556"],
Cell[30595, 983, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"e135473c-2654-4136-b955-b9891ad89330"]
}, Closed]],
Cell[CellGroupData[{
Cell[31699, 1019, 700, 20, 70, "Exercise",ExpressionUUID->"6ebc25ec-9b52-42ba-b612-999ac45aea10"],
Cell[32402, 1041, 1069, 31, 70, "ExerciseOutput",ExpressionUUID->"897228ed-e7cd-4101-b790-1ad7d9711dcb"]
}, Closed]],
Cell[CellGroupData[{
Cell[33508, 1077, 698, 20, 70, "Exercise",ExpressionUUID->"ad5fb202-81d2-4479-8dd4-a6dad95bd55f"],
Cell[34209, 1099, 1065, 31, 70, "ExerciseOutput",ExpressionUUID->"86b1a65b-ebe1-4148-88c5-77b91977851b"]
}, Closed]],
Cell[CellGroupData[{
Cell[35311, 1135, 697, 20, 70, "Exercise",ExpressionUUID->"d81530b5-eef7-422d-baf4-0f661d94e28e"],
Cell[36011, 1157, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"5f09d4f3-ba84-44e2-ab25-ad6d7e4f6147"]
}, Closed]],
Cell[CellGroupData[{
Cell[37115, 1193, 766, 21, 70, "Exercise",ExpressionUUID->"4de526d4-15a8-401a-97f5-0013e95ac78a"],
Cell[37884, 1216, 1106, 32, 70, "ExerciseOutput",ExpressionUUID->"aec1b7f3-aafd-48ee-a42f-21afdf603878"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39051, 1255, 159, 4, 70, "QASection",ExpressionUUID->"e34c29d8-069d-4ba5-a75b-2ab99c46cff6",
 CellTags->"p:2"],
Cell[39213, 1261, 243, 7, 70, "Question",ExpressionUUID->"7771e630-751b-422b-9d3a-2ee3202a723a"],
Cell[39459, 1270, 6373, 119, 70, "Answer",ExpressionUUID->"a9505ff0-15a6-4fb0-88ca-ef6db2966866"],
Cell[45835, 1391, 177, 4, 70, "Question",ExpressionUUID->"8e925f1b-e9e1-4174-a8ed-cc6c8a9c8b3c"],
Cell[46015, 1397, 812, 21, 70, "Answer",ExpressionUUID->"7d922352-857c-44f7-bfcd-b39085faa02b",
 CellTags->"i:5"],
Cell[46830, 1420, 415, 13, 70, "Question",ExpressionUUID->"d4e8a424-1c84-426c-bbba-6da0c932747b",
 CellTags->"i:6"],
Cell[47248, 1435, 276, 7, 70, "Answer",ExpressionUUID->"c784b1b3-9dd8-4e3c-ba34-3f9be9f5f3c9"],
Cell[47527, 1444, 230, 5, 70, "Question",ExpressionUUID->"bba023a4-6159-4c83-a58f-b2d3c5668c92"],
Cell[47760, 1451, 256, 7, 70, "Answer",ExpressionUUID->"2d320432-ee89-40bb-8701-7be959baa744",
 CellTags->"i:7"],
Cell[48019, 1460, 252, 5, 70, "Question",ExpressionUUID->"800c35fe-4402-4de8-9486-02201cef6730",
 CellTags->"i:8"],
Cell[48274, 1467, 553, 17, 70, "Answer",ExpressionUUID->"2fe48899-2e23-4590-8560-f9b341f57899"],
Cell[48830, 1486, 214, 6, 70, "Question",ExpressionUUID->"eb207a1c-f995-43ac-ab36-236df4c0b8a8"],
Cell[49047, 1494, 451, 14, 70, "Answer",ExpressionUUID->"2cfc6ed8-7141-4838-a0ed-777920775d22"],
Cell[49501, 1510, 240, 7, 70, "Question",ExpressionUUID->"5236310e-4dbb-43ef-b46f-1d3e1b4abb25"],
Cell[49744, 1519, 296, 8, 70, "Answer",ExpressionUUID->"e55df187-6629-4ef7-b465-ca3383f7373c"],
Cell[50043, 1529, 210, 5, 70, "Question",ExpressionUUID->"7ac03234-5f94-4ab5-b844-5aa419cf6594"],
Cell[50256, 1536, 249, 7, 70, "Answer",ExpressionUUID->"38c4c1dc-7876-4b86-a272-24ad16862a44"],
Cell[50508, 1545, 303, 10, 70, "Question",ExpressionUUID->"f9d42e71-d962-4cb5-818b-bf5f2049a6fa"],
Cell[50814, 1557, 302, 7, 70, "Answer",ExpressionUUID->"f50be669-1c9d-414c-84b9-c56d8610a7cf",
 CellTags->"i:9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51153, 1569, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"f098140f-4674-4e3b-a50e-e93f96e06e56"],
Cell[51321, 1575, 428, 10, 70, "MoreExplore",ExpressionUUID->"64f6490d-b8a4-4414-8ded-86065adc696a",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature @KNT#ppDzn@R3I55CWSbjl4V *)
