(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16103,        449]
NotebookOptionsPosition[     15015,        409]
NotebookOutlinePosition[     15651,        433]
CellTagsIndexPosition[     15608,        430]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Propagation of a Plane Electromagnetic Wave ", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"wave1", "=", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", "  ", 
        RowBox[{
         RowBox[{"t", " ", 
          RowBox[{"(", 
           RowBox[{"x", "/", "6.28"}], ")"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", " ", "strength"}], "  ", 
          RowBox[{"Sin", "[", 
           RowBox[{"frequency", "  ", "t", " ", 
            RowBox[{"(", 
             RowBox[{"x", "/", "6.28"}], ")"}]}], "]"}]}], ",", "0"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", " ", "0", ",", " ", 
         RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", ".007", "]"}], ",", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Red", ",", ".5"}], "]"}]}], "]"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"wave2", "=", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"t", "  ", 
          RowBox[{"(", 
           RowBox[{"x", "/", "6.28"}], ")"}]}], ",", "0", ",", 
         RowBox[{"strength", "  ", 
          RowBox[{"Sin", "[", 
           RowBox[{"frequency", "  ", "t", 
            RowBox[{"(", " ", 
             RowBox[{"x", "/", "6.28"}], ")"}]}], " ", "]"}]}]}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{"t", ",", " ", "0", ",", " ", 
         RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", ".007", "]"}], ",", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Blue", ",", ".5"}], "]"}]}], "]"}]}]}], "]"}]}], ";", 
    RowBox[{"Show", "[", 
     RowBox[{"wave1", ",", "wave2", ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".5", "]"}], ",", 
         RowBox[{"EdgeForm", "[", "]"}], ",", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"wave1", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "/.", 
           RowBox[{
            RowBox[{"Line", "[", "t___", "]"}], "\[RuleDelayed]", 
            RowBox[{"Polygon", "[", 
             RowBox[{"Append", "[", 
              RowBox[{"t", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Last", "[", "t", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "0", ",", "0"}], 
                "}"}]}], "]"}], "]"}]}]}], ")"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".5", "]"}], ",", 
         RowBox[{"EdgeForm", "[", "]"}], ",", 
         RowBox[{
          RowBox[{"wave2", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "/.", 
          RowBox[{
           RowBox[{"Line", "[", "t___", "]"}], "\[RuleDelayed]", 
           RowBox[{"Polygon", "[", 
            RowBox[{"Append", "[", 
             RowBox[{"t", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"Last", "[", "t", "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", "0", ",", "0"}], 
               "}"}]}], "]"}], "]"}]}]}]}], "}"}], "]"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<x\>\"", ",", "Medium", ",", "Italic"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(B\), \(y\)]\)\>\"", ",", "Medium", ",", 
           RowBox[{"Lighter", "[", 
            RowBox[{"Red", ",", ".5"}], "]"}], ",", "Italic"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(E\), \(z\)]\)\>\"", ",", "Medium", ",", 
           RowBox[{"Lighter", "[", 
            RowBox[{"Blue", ",", ".5"}], "]"}], ",", "Italic"}], "]"}]}], 
        "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", " ", "strength"}], ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", " ", "strength"}], ",", " ", "strength"}], "}"}], ",",
          
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", " ", "strength"}], ",", "strength"}], "}"}]}], 
        "}"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"500", ",", "400"}], "}"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"2", " ", "\[Pi]"}], ",", "\"\<x\>\""}], "}"}], ",", "0", ",", 
     
     RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"strength", ",", 
     RowBox[{"{", " ", 
      RowBox[{"1", ",", "1.5", ",", "2", ",", "2.5"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"frequency", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", "Manipulate"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.4058546570693583`*^9, 3.405854770147484*^9}, {
   3.4058548005693583`*^9, 3.4058548128506083`*^9}, {3.405854874772484*^9, 
   3.4058549086318583`*^9}, {3.405855037709984*^9, 3.4058550715693583`*^9}, {
   3.4058551054908504`*^9, 3.4058551987396564`*^9}, {3.4058553586126103`*^9, 
   3.405855512220894*^9}, {3.4058555462363014`*^9, 3.405855577501726*^9}, {
   3.4058556084077783`*^9, 3.405855639516954*^9}},
 CellID->32812255]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`frequency$$ = 1, $CellContext`strength$$ = 
    1, $CellContext`x$$ = 6.283185307179586, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`x$$], 2 Pi, "x"}, 0, 2 Pi}, {
      Hold[$CellContext`strength$$], {1, 1.5, 2, 2.5}}, {
      Hold[$CellContext`frequency$$], {1, 2, 3, 4, 5}}}, Typeset`size$$ = {
    500., {198., 202.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x$78091$$ = 
    0, $CellContext`strength$78092$$ = 0, $CellContext`frequency$78093$$ = 0},
     
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`frequency$$ = 1, $CellContext`strength$$ = 
        1, $CellContext`x$$ = 2 Pi}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$78091$$, 0], 
        Hold[$CellContext`strength$$, $CellContext`strength$78092$$, 0], 
        Hold[$CellContext`frequency$$, $CellContext`frequency$78093$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`wave1 = 
        ParametricPlot3D[{$CellContext`t ($CellContext`x$$/
            6.28), (-$CellContext`strength$$) 
           Sin[($CellContext`frequency$$ $CellContext`t) ($CellContext`x$$/
              6.28)], 0}, {$CellContext`t, 0, 2 Pi}, PlotStyle -> Directive[
            Thickness[0.007], 
            Lighter[Red, 0.5]]]; $CellContext`wave2 = 
        ParametricPlot3D[{$CellContext`t ($CellContext`x$$/6.28), 
           0, $CellContext`strength$$ 
           Sin[($CellContext`frequency$$ $CellContext`t) ($CellContext`x$$/
              6.28)]}, {$CellContext`t, 0, 2 Pi}, PlotStyle -> Directive[
            Thickness[0.007], 
            Lighter[Blue, 0.5]]]; 
       Show[$CellContext`wave1, $CellContext`wave2, 
         Graphics3D[{
           Opacity[0.5], 
           EdgeForm[], 
           ReplaceAll[
            Part[$CellContext`wave1, 1], Line[
              Pattern[$CellContext`t, 
               BlankNullSequence[]]] :> Polygon[
              Append[$CellContext`t, {
                Part[
                 Last[$CellContext`t], 1], 0, 0}]]]}], 
         Graphics3D[{
           Opacity[0.5], 
           EdgeForm[], 
           ReplaceAll[
            Part[$CellContext`wave2, 1], Line[
              Pattern[$CellContext`t, 
               BlankNullSequence[]]] :> Polygon[
              Append[$CellContext`t, {
                Part[
                 Last[$CellContext`t], 1], 0, 0}]]]}], AxesLabel -> {
           Style["x", Medium, Italic], 
           Style["\!\(\*SubscriptBox[\(B\), \(y\)]\)", Medium, 
            Lighter[Red, 0.5], Italic], 
           Style["\!\(\*SubscriptBox[\(E\), \(z\)]\)", Medium, 
            Lighter[Blue, 0.5], Italic]}, 
         PlotRange -> {{-$CellContext`strength$$, 
            7}, {-$CellContext`strength$$, $CellContext`strength$$}, \
{-$CellContext`strength$$, $CellContext`strength$$}}, 
         ImageSize -> {500, 400}]), 
      "Specifications" :> {{{$CellContext`x$$, 2 Pi, "x"}, 0, 2 
         Pi}, {$CellContext`strength$$, {
         1, 1.5, 2, 2.5}}, {$CellContext`frequency$$, {1, 2, 3, 4, 5}}}, 
      "Options" :> {TrackedSymbols -> Manipulate}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{544., {266., 271.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->161056142],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Propagation of a Plane Electromagnetic Wave ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
PropagationOfAPlaneElectromagneticWave/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/PropagationOfAPlaneElectromagneticWave/\
"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
PropagationOfAPlaneElectromagneticWave/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
PropagationOfAPlaneElectromagneticWave/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/PropagationOfAPlaneElectromagneticWave/\
"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Alan Fafard",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Alan+Fafard"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Alan+Fafard"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
PropagationOfAPlaneElectromagneticWave"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Propagation of a Plane Electromagnetic Wave  - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (February 7, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 236, 4, 70, "Section"],
Cell[829, 29, 5809, 152, 70, "Input",
 CellID->32812255]
}, Open  ]],
Cell[6653, 184, 4060, 85, 70, "Output",
 CellID->161056142],
Cell[CellGroupData[{
Cell[10738, 273, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[11114, 284, 1029, 31, 70, "Text"],
Cell[12146, 317, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[12486, 328, 430, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[12941, 346, 829, 24, 70, "Text"],
Cell[13773, 372, 1214, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature aSNHg1kvFB#GAADHzeMOquD# *)
