(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     25441,        661]
NotebookOptionsPosition[     24124,        610]
NotebookOutlinePosition[     24785,        635]
CellTagsIndexPosition[     24742,        632]
WindowTitle->Snell's Law of Refraction (Wave Fronts) - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Snell's Law of Refraction (Wave Fronts)", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n1", "=", "nn"}], ",", 
       RowBox[{"n2", "=", "n"}], ",", 
       RowBox[{"a", "=", 
        RowBox[{"-", 
         RowBox[{"Sin", "[", "th", "]"}]}]}], ",", 
       RowBox[{"b", "=", 
        RowBox[{"Cos", "[", "th", "]"}]}], ",", 
       RowBox[{"\[Nu]", "=", 
        RowBox[{"1", "/", "f"}]}], ",", 
       RowBox[{"h", "=", "10"}]}], "}"}], ",", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"th2", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"n1", "/", "n2"}], " ", 
             RowBox[{"Sin", "[", "th", "]"}]}], "\[LessEqual]", "1"}], ",", 
           RowBox[{"ArcSin", "[", 
            RowBox[{
             RowBox[{"n1", "/", "n2"}], " ", 
             RowBox[{"Sin", "[", "th", "]"}]}], "]"}], ",", 
           RowBox[{"Pi", "-", "th"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{".41", ",", ".57", ",", ".91"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Opacity", "[", 
              RowBox[{".05", "+", 
               RowBox[{".95", 
                RowBox[{"(", 
                 RowBox[{"Min", "[", 
                  RowBox[{"1", ",", 
                   RowBox[{"Log", "[", "n2", "]"}]}], "]"}], ")"}]}]}], "]"}],
              ",", 
             RowBox[{"Rectangle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "h"}], ",", 
                 RowBox[{"-", "h"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"h", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Opacity", "[", 
              RowBox[{".05", "+", 
               RowBox[{".95", 
                RowBox[{"(", 
                 RowBox[{"Min", "[", 
                  RowBox[{"1", ",", 
                   RowBox[{"Log", "[", "n1", "]"}]}], "]"}], ")"}]}]}], "]"}],
              ",", 
             RowBox[{"Rectangle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "h"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"h", ",", "h"}], "}"}]}], "]"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".27", ",", ".2", ",", ".75"}], "]"}], ",", 
           RowBox[{"Thickness", "[", ".01", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"Sin", "[", "th", "]"}]}], ",", 
                RowBox[{"Cos", "[", "th", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"h", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Sin", "[", "th2", "]"}], ",", 
                 RowBox[{"-", 
                  RowBox[{"Cos", "[", "th2", "]"}]}]}], "}"}]}]}], "}"}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".9", ",", ".42", ",", ".17"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"t", "+", 
                    RowBox[{"r", " ", "\[Nu]"}]}], ")"}], "/", "n1"}], 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "+", "b"}], ">", "0"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"t", "+", 
                    RowBox[{"r", " ", "\[Nu]"}]}], ")"}], "/", "n1"}], "#"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"t", "+", 
                    RowBox[{"r", " ", "\[Nu]"}]}], ")"}], "/", "n2"}], 
                    "\[IndentingNewLine]", "+", 
                    RowBox[{"b", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n2", "-", "n1"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "n2"}], ")"}]}]}]}], 
                    ")"}], " ", "#"}]}], "]"}], "&"}], "[", 
                  RowBox[{"N", "@", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "s", "]"}], ",", 
                    RowBox[{"Sin", "[", "s", "]"}]}], "}"}]}], "]"}], "+", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "b"}], "}"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"s", ",", "0", ",", 
                  RowBox[{"2", "Pi"}], ",", 
                  RowBox[{"Pi", "/", "100"}]}], "}"}]}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"r", ",", "0", ",", 
               RowBox[{"Round", "[", 
                RowBox[{"f", 
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"2", 
                    RowBox[{"Max", "[", 
                    RowBox[{"n1", ",", "n2"}], "]"}]}]}], ")"}]}], "]"}]}], 
              "}"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "2"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"500", ",", "264"}], "}"}]}]}], "]"}]}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"th", ",", "1", ",", "\"\<angle to normal (radians)\>\""}], 
      "}"}], ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"nn", ",", "1", ",", "\"\<top refractive index\>\""}], "}"}], 
     ",", "1", ",", "4", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"nn", ",", "1", ",", "\"\<top material\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "\"\<vacuum\>\""}], ",", 
       RowBox[{"1.00029", "\[Rule]", "\"\<air\>\""}], ",", 
       RowBox[{"1.33", "\[Rule]", "\"\<water\>\""}], ",", 
       RowBox[{"1.6", "\[Rule]", "\"\<glass\>\""}], ",", 
       RowBox[{"2.5", "\[Rule]", "\"\<diamond\>\""}]}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "1.33", ",", "\"\<bottom refractive index\>\""}], 
      "}"}], ",", "1", ",", "4", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "1.33", ",", "\"\<bottom material\>\""}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "\"\<vacuum\>\""}], ",", 
       RowBox[{"1.00029", "\[Rule]", "\"\<air\>\""}], ",", 
       RowBox[{"1.33", "\[Rule]", "\"\<water\>\""}], ",", 
       RowBox[{"1.6", "\[Rule]", "\"\<glass\>\""}], ",", 
       RowBox[{"2.5", "\[Rule]", "\"\<diamond\>\""}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\"\<time\>\""}], "}"}], ",", "0", ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "1", ",", "\"\<frequency\>\""}], "}"}], ",", "1", ",",
      "3"}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35757176568782*^9, {3.36404311707775*^9, 3.36404323307775*^9}, {
   3.36931325742188*^9, 3.36931325907813*^9}, {3.372775119894546*^9, 
   3.372775125004183*^9}, {3.3792609200192733`*^9, 3.3792609417066345`*^9}, {
   3.3792610411122484`*^9, 3.3792610507684364`*^9}, {3.379261094596281*^9, 
   3.379261112111794*^9}, {3.3886100074375*^9, 3.388610007671875*^9}},
 CellID->1496021318]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`f$$ = 1, $CellContext`n$$ = 
    1.33, $CellContext`nn$$ = 1, $CellContext`t$$ = 0, $CellContext`th$$ = 1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`th$$], 1, "angle to normal (radians)"}, 0, 
      Rational[1, 2] Pi}, {{
       Hold[$CellContext`nn$$], 1, "top refractive index"}, 1, 4}, {{
       Hold[$CellContext`nn$$], 1, "top material"}, {
      1 -> "vacuum", 1.00029 -> "air", 1.33 -> "water", 1.6 -> "glass", 2.5 -> 
       "diamond"}}, {{
       Hold[$CellContext`n$$], 1.33, "bottom refractive index"}, 1, 4}, {{
       Hold[$CellContext`n$$], 1.33, "bottom material"}, {
      1 -> "vacuum", 1.00029 -> "air", 1.33 -> "water", 1.6 -> "glass", 2.5 -> 
       "diamond"}}, {{
       Hold[$CellContext`t$$], 0, "time"}, 0, 1}, {{
       Hold[$CellContext`f$$], 1, "frequency"}, 1, 3}}, Typeset`size$$ = {
    500., {130., 134.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`th$55348$$ = 
    0, $CellContext`nn$55349$$ = 0, $CellContext`n$55350$$ = 
    0, $CellContext`t$55351$$ = 0, $CellContext`f$55352$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`f$$ = 1, $CellContext`n$$ = 
        1.33, $CellContext`nn$$ = 1, $CellContext`t$$ = 0, $CellContext`th$$ = 
        1}, "ControllerVariables" :> {
        Hold[$CellContext`th$$, $CellContext`th$55348$$, 0], 
        Hold[$CellContext`nn$$, $CellContext`nn$55349$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$55350$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$55351$$, 0], 
        Hold[$CellContext`f$$, $CellContext`f$55352$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`n1$ = $CellContext`nn$$, $CellContext`n2$ = \
$CellContext`n$$, $CellContext`a$ = -Sin[$CellContext`th$$], $CellContext`b$ = 
         Cos[$CellContext`th$$], $CellContext`\[Nu]$ = 
         1/$CellContext`f$$, $CellContext`h$ = 10}, 
        With[{$CellContext`th2$ = 
          If[($CellContext`n1$/$CellContext`n2$) Sin[$CellContext`th$$] <= 1, 
            
            
            ArcSin[($CellContext`n1$/$CellContext`n2$) 
             Sin[$CellContext`th$$]], Pi - $CellContext`th$$]}, 
         Graphics[{
           RGBColor[0.41, 0.57, 0.91], {
            Opacity[0.05 + 0.95 Min[1, 
                Log[$CellContext`n2$]]], 
            
            Rectangle[{-$CellContext`h$, -$CellContext`h$}, {$CellContext`h$, 
              0}]}, {
            Opacity[0.05 + 0.95 Min[1, 
                Log[$CellContext`n1$]]], 
            
            Rectangle[{-$CellContext`h$, 
              0}, {$CellContext`h$, $CellContext`h$}]}, 
           RGBColor[0.27, 0.2, 0.75], 
           Thickness[0.01], 
           Line[{{0, 0}, {-Sin[$CellContext`th$$], 
              Cos[$CellContext`th$$]}}], 
           Line[{{0, 0}, $CellContext`h$ {
               Sin[$CellContext`th2$], -Cos[$CellContext`th2$]}}], 
           RGBColor[0.9, 0.42, 0.17], 
           Table[
            Line[
             
             Table[(If[(($CellContext`t$$ + $CellContext`r \
$CellContext`\[Nu]$)/$CellContext`n1$) Part[#, 2] + $CellContext`b$ > 
                0, (($CellContext`t$$ + $CellContext`r \
$CellContext`\[Nu]$)/$CellContext`n1$) #, (($CellContext`t$$ + $CellContext`r \
$CellContext`\[Nu]$)/$CellContext`n2$ + $CellContext`b$ (($CellContext`n2$ - \
$CellContext`n1$)/((-Part[#, 2]) $CellContext`n2$))) #]& )[
                N[{
                  Cos[$CellContext`s], 
                  
                  Sin[$CellContext`s]}]] + {$CellContext`a$, \
$CellContext`b$}, {$CellContext`s, 0, 2 Pi, Pi/100}]], {$CellContext`r, 0, 
             Round[$CellContext`f$$ (3 + 
               2 Max[$CellContext`n1$, $CellContext`n2$])]}]}, PlotRange -> 2,
           ImageSize -> {500, 264}]]], 
      "Specifications" :> {{{$CellContext`th$$, 1, 
          "angle to normal (radians)"}, 0, Rational[1, 2] Pi, Appearance -> 
         "Labeled"}, {{$CellContext`nn$$, 1, "top refractive index"}, 1, 4, 
         Appearance -> "Labeled"}, {{$CellContext`nn$$, 1, "top material"}, {
         1 -> "vacuum", 1.00029 -> "air", 1.33 -> "water", 1.6 -> "glass", 
          2.5 -> "diamond"}}, {{$CellContext`n$$, 1.33, 
          "bottom refractive index"}, 1, 4, Appearance -> 
         "Labeled"}, {{$CellContext`n$$, 1.33, "bottom material"}, {
         1 -> "vacuum", 1.00029 -> "air", 1.33 -> "water", 1.6 -> "glass", 
          2.5 -> "diamond"}}, {{$CellContext`t$$, 0, "time"}, 0, 
         1}, {{$CellContext`f$$, 1, "frequency"}, 1, 3}}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {252., 257.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->188551594],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Light travels at different speeds through different materials, causing it to \
bend according to Snell's law. Here light is represented by traveling wave \
fronts coming from a light source above the boundary between two materials.
\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Snell's Law of Refraction (Wave Fronts)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/SnellsLawOfRefractionWaveFronts/"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/SnellsLawOfRefractionWaveFronts/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/SnellsLawOfRefractionWaveFronts/\
",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/SnellsLawOfRefractionWaveFronts/"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/SnellsLawOfRefractionWaveFronts/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[CellGroupData[{

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Todd Rowland",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Todd+Rowland"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Todd+Rowland"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->198579005],

Cell[TextData[{
 "Suggested by: ",
 ButtonBox["Stephen Wolfram",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Stephen+\
Wolfram"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Stephen+Wolfram"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->77258351]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
SnellsLawOfRefractionWaveFronts"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Snell's Law of Refraction (Wave Fronts) - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[641, 23, 159, 3, 70, "Section"],
Cell[803, 28, 3700, 64, 70, "Section"],
Cell[4506, 94, 9148, 236, 70, "Input",
 CellID->1496021318]
}, Open  ]],
Cell[CellGroupData[{
Cell[13691, 335, 5520, 108, 70, "Output",
 CellID->188551594],
Cell[CellGroupData[{
Cell[19236, 447, 209, 6, 70, "Section"],
Cell[19448, 455, 256, 5, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19752, 466, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[20110, 477, 991, 29, 70, "Text"],
Cell[CellGroupData[{
Cell[21126, 510, 453, 15, 70, "Text",
 CellID->198579005],
Cell[21582, 527, 456, 15, 70, "Text",
 CellID->77258351]
}, Open  ]],
Cell[CellGroupData[{
Cell[22075, 547, 815, 24, 70, "Text"],
Cell[22893, 573, 1203, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature dRN#rex35ZpuSBD@aQE0FRgW *)
