(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16483,        460]
NotebookOptionsPosition[     15313,        417]
NotebookOutlinePosition[     15935,        441]
CellTagsIndexPosition[     15892,        438]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Scattering over Potential Step", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{"x_", ",", 
     RowBox[{"V0_:", "1"}]}], "]"}], ":=", 
   RowBox[{"V0", "*", 
    RowBox[{"UnitStep", "[", "x", "]"}]}]}], ";"}]], "Input",
 CellID->1936089772],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x_", ",", "En_", ",", "V0_"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "=", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"2", "En"}], "]"}]}], ",", 
      RowBox[{"q", "=", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"En", "-", "V0"}], ")"}]}], "]"}]}], ",", "R", ",", "T"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"R", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "-", "q"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"k", "+", "q"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"T", "=", 
      RowBox[{"1", "+", "R"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"I", " ", "k", " ", "x"}], "]"}], "+", 
          RowBox[{"R", " ", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], " ", "k", " ", "x"}], "]"}]}]}], ")"}], 
        RowBox[{"UnitStep", "[", 
         RowBox[{"-", "x"}], "]"}]}], "+", "\[IndentingNewLine]", 
       RowBox[{"T", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{"I", " ", "q", " ", "x"}], "]"}], 
        RowBox[{"UnitStep", "[", "x", "]"}]}]}], ")"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.400270948345895*^9, 3.400271044106113*^9}, 
   3.400271275045434*^9, {3.400271679936934*^9, 3.400271697273469*^9}, {
   3.4009369242787375`*^9, 3.4009369286693344`*^9}, 3.401803394614973*^9},
 CellID->630548010],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"val", "=", 
          RowBox[{"\[Psi]", "[", 
           RowBox[{"x", ",", "En", ",", "V0"}], "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", "val", "]"}], "^", "2"}], ",", 
          RowBox[{"Re", "[", "val", "]"}], ",", 
          RowBox[{"Im", "[", "val", "]"}], ",", "En", ",", 
          RowBox[{"V", "[", 
           RowBox[{"x", ",", "V0"}], "]"}]}], "}"}]}], "]"}], "//", 
      "Evaluate"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"1", ",", ".47", ",", "0"}], "]"}], ",", 
        RowBox[{"RGBColor", "[", 
         RowBox[{".38", ",", ".61", ",", ".51"}], "]"}], ",", 
        RowBox[{"ColorData", "[", 
         RowBox[{"\"\<HTML\>\"", ",", "\"\<SlateBlue\>\""}], "]"}], ",", 
        "Gray", ",", 
        RowBox[{"Lighter", "[", 
         RowBox[{"Orange", ",", ".75"}], "]"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"5", "\[Rule]", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FillingStyle", "\[Rule]", 
      RowBox[{"Lighter", "[", 
       RowBox[{"Orange", ",", ".75"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"500", ",", "350"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "5.5"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"En", ",", "0.5", ",", "\"\<particle energy\>\""}], "}"}], ",", 
     "0", ",", "5", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"V0", ",", "1", ",", "\"\<potential energy step\>\""}], "}"}], 
     ",", "0.5", ",", "5", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.400385332465995*^9, {3.4004245095934167`*^9, 
   3.4004245268746667`*^9}, {3.400424586984042*^9, 3.400424675921542*^9}, {
   3.400424925734042*^9, 3.4004249280934167`*^9}, {3.4004249697184167`*^9, 
   3.400425021046542*^9}, {3.4004250691871667`*^9, 3.4004251155621667`*^9}, {
   3.400445374246519*^9, 3.400445390605999*^9}, {3.4009368938258076`*^9, 
   3.4009369122475643`*^9}}]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`En$$ = 0.5, $CellContext`V0$$ = 1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`En$$], 0.5, "particle energy"}, 0, 5}, {{
       Hold[$CellContext`V0$$], 1, "potential energy step"}, 0.5, 5}}, 
    Typeset`size$$ = {500., {173., 177.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`En$16113$$ = 0, $CellContext`V0$16114$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`En$$ = 0.5, $CellContext`V0$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`En$$, $CellContext`En$16113$$, 0], 
        Hold[$CellContext`V0$$, $CellContext`V0$16114$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Evaluate[
         With[{$CellContext`val$ = $CellContext`\[Psi][$CellContext`x, \
$CellContext`En$$, $CellContext`V0$$]}, {Abs[$CellContext`val$]^2, 
           Re[$CellContext`val$], 
           Im[$CellContext`val$], $CellContext`En$$, 
           $CellContext`V[$CellContext`x, $CellContext`V0$$]}]], \
{$CellContext`x, -10, 10}, PlotStyle -> {
          RGBColor[1, 0.47, 0], 
          RGBColor[0.38, 0.61, 0.51], 
          ColorData["HTML", "SlateBlue"], Gray, 
          Lighter[Orange, 0.75]}, Filling -> {5 -> 0}, FillingStyle -> 
        Lighter[Orange, 0.75], ImageSize -> {500, 350}, 
        PlotRange -> {-2, 5.5}], 
      "Specifications" :> {{{$CellContext`En$$, 0.5, "particle energy"}, 0, 5,
          Appearance -> 
         "Labeled"}, {{$CellContext`V0$$, 1, "potential energy step"}, 0.5, 5,
          Appearance -> "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{544., {230., 235.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`\[Psi][
          Pattern[$CellContext`x, 
           Blank[]], 
          Pattern[$CellContext`En, 
           Blank[]], 
          Pattern[$CellContext`V0, 
           Blank[]]] := 
        Module[{$CellContext`k = Sqrt[2 $CellContext`En], $CellContext`q = 
           Sqrt[2 ($CellContext`En - $CellContext`V0)], $CellContext`R, \
$CellContext`T}, $CellContext`R = ($CellContext`k - \
$CellContext`q)/($CellContext`k + $CellContext`q); $CellContext`T = 
           1 + $CellContext`R; (
             Exp[I $CellContext`k $CellContext`x] + $CellContext`R 
              Exp[(-I) $CellContext`k $CellContext`x]) 
            UnitStep[-$CellContext`x] + $CellContext`T 
            Exp[I $CellContext`q $CellContext`x] 
            UnitStep[$CellContext`x]], $CellContext`R[
          Pattern[$CellContext`k, 
           Blank[]], 
          Optional[
           Pattern[$CellContext`V0, 
            Blank[]], 1]] := 
        With[{$CellContext`q = 
           Sqrt[$CellContext`k^2 - 
             2 $CellContext`V0]}, ($CellContext`k - \
$CellContext`q)/($CellContext`k + $CellContext`q)], $CellContext`T[
          Pattern[$CellContext`k, 
           Blank[]], 
          Optional[
           Pattern[$CellContext`V0, 
            Blank[]], 1]] := $CellContext`R[$CellContext`k, $CellContext`V0] + 
         1, $CellContext`V[
          Pattern[$CellContext`x, 
           Blank[]]] := UnitStep[$CellContext`x], $CellContext`V[
          Pattern[$CellContext`x, 
           Blank[]], 
          Optional[
           Pattern[$CellContext`V0, 
            Blank[]], 1]] := $CellContext`V0 UnitStep[$CellContext`x], 
        Attributes[PlotRange] = {ReadProtected}}; Typeset`initDone$$ = True); 
     ReleaseHold[
       HoldComplete[{$CellContext`V[
            Pattern[$CellContext`x, 
             Blank[]], 
            Optional[
             Pattern[$CellContext`V0, 
              Blank[]], 1]] := $CellContext`V0 UnitStep[$CellContext`x]; 
         Null, $CellContext`\[Psi][
           Pattern[$CellContext`x, 
            Blank[]], 
           Pattern[$CellContext`En, 
            Blank[]], 
           Pattern[$CellContext`V0, 
            Blank[]]] := 
         Module[{$CellContext`k = Sqrt[2 $CellContext`En], $CellContext`q = 
            Sqrt[2 ($CellContext`En - $CellContext`V0)], $CellContext`R, \
$CellContext`T}, $CellContext`R = ($CellContext`k - \
$CellContext`q)/($CellContext`k + $CellContext`q); $CellContext`T = 
            1 + $CellContext`R; (
              Exp[I $CellContext`k $CellContext`x] + $CellContext`R 
               Exp[(-I) $CellContext`k $CellContext`x]) 
             UnitStep[-$CellContext`x] + $CellContext`T 
             Exp[I $CellContext`q $CellContext`x] 
             UnitStep[$CellContext`x]]}]]; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->22306509],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Scattering over Potential Step",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ScatteringOverPotentialStep/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ScatteringOverPotentialStep/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/ScatteringOverPotentialStep/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ScatteringOverPotentialStep/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ScatteringOverPotentialStep/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Mahn-Soo Choi",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Mahn-Soo+Choi"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Mahn-Soo+Choi"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
ScatteringOverPotentialStep"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Scattering over Potential Step - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (February 7, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 222, 4, 70, "Section"],
Cell[815, 29, 230, 8, 70, "Input",
 CellID->1936089772],
Cell[1048, 39, 1698, 47, 70, "Input",
 CellID->630548010],
Cell[2749, 88, 2974, 74, 70, "Input"]
}, Open  ]],
Cell[5738, 165, 5347, 115, 70, "Output",
 CellID->22306509],
Cell[CellGroupData[{
Cell[11110, 284, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[11486, 295, 960, 28, 70, "Text"],
Cell[12449, 325, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[12789, 336, 436, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[13250, 354, 829, 24, 70, "Text"],
Cell[14082, 380, 1203, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature CQ4M@KkKWGfjYATYnK4TvEVx *)
