(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49112,       1186]
NotebookOptionsPosition[     47847,       1139]
NotebookOutlinePosition[     48476,       1163]
CellTagsIndexPosition[     48433,       1160]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Scattering by a Square-Well Potential", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{"x_", ",", "V0_", ",", "a_"}], "]"}], ":=", 
   RowBox[{"V0", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"UnitStep", "[", 
       RowBox[{"x", "+", 
        RowBox[{"a", "/", "2"}]}], "]"}], "-", 
      RowBox[{"UnitStep", "[", 
       RowBox[{"x", "-", 
        RowBox[{"a", "/", "2"}]}], "]"}]}], ")"}]}]}], "\n", 
  RowBox[{"(*", 
   RowBox[{
   "The", " ", "\"\<amplitude\>\"", " ", "of", " ", "the", " ", "reflected", 
    " ", "wave"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RR", "[", 
    RowBox[{"k_", ",", "q_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "k"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["k", "2"], "-", 
       SuperscriptBox["q", "2"]}], ")"}], " ", 
     RowBox[{"Sin", "[", "q", "]"}]}], 
    RowBox[{
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "q", " ", 
      RowBox[{"Cos", "[", "q", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["k", "2"], "+", 
        SuperscriptBox["q", "2"]}], ")"}], " ", 
      RowBox[{"Sin", "[", "q", "]"}]}]}]]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "The", " ", "\"\<amplitude\>\"", " ", "of", " ", "the", " ", "transmitted",
     " ", 
    RowBox[{"wave", "."}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TT", "[", 
    RowBox[{"k_", ",", "q_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{" ", 
     RowBox[{"\[ImaginaryI]", " ", "2", " ", "k", " ", "q", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "k"}]], " "}]}], 
    RowBox[{
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "q", " ", 
      RowBox[{"Cos", "[", "q", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["k", "2"], "+", 
        SuperscriptBox["q", "2"]}], ")"}], " ", 
      RowBox[{"Sin", "[", "q", "]"}]}]}]]}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "amplitudes", " ", "of", " ", "the", " ", "waves", " ", 
    "inside", " ", "the", " ", "well"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AA", "[", 
   RowBox[{"k_", ",", "q_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"TT", "[", 
    RowBox[{"k", ",", "q"}], "]"}], " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"q", "+", "k"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "q"}], ")"}]}], 
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"k", "-", "q"}], ")"}], "/", "2"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BB", "[", 
   RowBox[{"k_", ",", "q_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"TT", "[", 
    RowBox[{"k", ",", "q"}], "]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"q", "-", "k"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "q"}], ")"}]}], 
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"k", "+", "q"}], ")"}], "/", "2"}]}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x_", ",", "En_", ",", "V0_", ",", "a_"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"z", "=", 
       RowBox[{"x", "/", "a"}]}], ",", 
      RowBox[{"k", "=", 
       RowBox[{"a", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", " ", "En"}], "]"}]}]}], ",", 
      RowBox[{"q", "=", 
       RowBox[{"a", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", 
          RowBox[{"(", 
           RowBox[{"En", "-", "V0"}], ")"}]}], "]"}]}]}], ",", "Rv", ",", 
      "Tv", ",", "Av", ",", "Bv"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Rv", "=", 
      RowBox[{"RR", "[", 
       RowBox[{"k", ",", "q"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Tv", "=", 
      RowBox[{"TT", "[", 
       RowBox[{"k", ",", "q"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Av", "=", 
      RowBox[{"AA", "[", 
       RowBox[{"k", ",", "q"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Bv", "=", 
      RowBox[{"BB", "[", 
       RowBox[{"k", ",", "q"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Which", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"z", "<", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], ",", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"I", " ", "k", " ", "z"}], "]"}], "+", 
        RowBox[{"Rv", "*", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "k", " ", "z"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Abs", "[", "z", "]"}], "\[LessEqual]", 
        RowBox[{"1", "/", "2"}]}], ",", 
       RowBox[{
        RowBox[{"Av", "*", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "q", " ", 
           RowBox[{"x", "/", "a"}]}], "]"}]}], "+", 
        RowBox[{"Bv", "*", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "I"}], " ", "q", " ", "z"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"z", ">", 
        RowBox[{"1", "/", "2"}]}], ",", 
       RowBox[{"Tv", "*", 
        RowBox[{"Exp", "[", 
         RowBox[{"I", " ", "k", " ", "z"}], "]"}]}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TransmitanceAndReflectance", "[", 
   RowBox[{"En_", ",", " ", "V0_", ",", " ", "a_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "=", 
       RowBox[{"a", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", " ", "En"}], "]"}]}]}], ",", 
      RowBox[{"q", "=", 
       RowBox[{"a", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", 
          RowBox[{"(", 
           RowBox[{"En", "-", "V0"}], ")"}]}], "]"}]}]}], ",", "Rv", ",", 
      "Tv", ",", "Av", ",", "Bv"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Rv", "=", 
      RowBox[{"Abs", "[", 
       RowBox[{"RR", "[", 
        RowBox[{"k", ",", "q"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Tv", "=", 
      RowBox[{"Abs", "[", 
       RowBox[{"TT", "[", 
        RowBox[{"k", ",", "q"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Rv", "^", "2"}], ",", " ", 
       RowBox[{"Tv", "^", "2"}]}], "}"}]}]}], 
   "                                             ", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmax", "            ", "=", " ", "10.5"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ymax", "            ", "=", " ", "5.0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"energyMax", " ", "=", " ", "5.0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.3962159356117563`*^9, 3.396215971193563*^9}, 
   3.396443883953125*^9, {3.397248033977664*^9, 3.397248039447957*^9}, {
   3.400263874789119*^9, 3.400263888173911*^9}, {3.400263970409988*^9, 
   3.400264013241404*^9}, {3.400264055395938*^9, 3.400264069489381*^9}, {
   3.400265174977899*^9, 3.4002651779549437`*^9}, {3.4002863542441063`*^9, 
   3.400286367685034*^9}, {3.4003669979546223`*^9, 3.400367060399909*^9}, {
   3.400367116807486*^9, 3.40036712225233*^9}, {3.400388216942498*^9, 
   3.4003882186697807`*^9}, 3.400390599882655*^9, {3.400390721288044*^9, 
   3.40039072817482*^9}, {3.40049758522867*^9, 3.400497587486614*^9}, 
   3.407455357082629*^9, {3.407455524054922*^9, 3.407455533515131*^9}, {
   3.4074555649296*^9, 3.407455565439172*^9}, {3.407455779943369*^9, 
   3.407455828891638*^9}, {3.4074560132501307`*^9, 3.4074561080312977`*^9}, {
   3.407456149646379*^9, 3.407456325408495*^9}, {3.407456426304055*^9, 
   3.407456449205248*^9}, {3.4074564835716248`*^9, 3.4074565602725487`*^9}, {
   3.407456762701936*^9, 3.407456808262669*^9}, {3.407456841140286*^9, 
   3.407457022693967*^9}, {3.4074575744936333`*^9, 3.407457578112176*^9}, {
   3.407457742422124*^9, 3.4074578071380987`*^9}, {3.407457838761512*^9, 
   3.407457880142152*^9}, {3.407457910972068*^9, 3.4074579269436417`*^9}, 
   3.407458220056099*^9, 3.407458743672571*^9, {3.4074587738420057`*^9, 
   3.407458793452783*^9}, 3.407459164599717*^9, {3.4074592229665947`*^9, 
   3.407459238404025*^9}, {3.407459402626788*^9, 3.4074595296731777`*^9}, {
   3.407459566831327*^9, 3.4074595728153276`*^9}, {3.4075077093570538`*^9, 
   3.4075077173452168`*^9}, {3.4075081045835953`*^9, 3.40750811568524*^9}, {
   3.407528549035184*^9, 3.4075285987793007`*^9}, {3.407529203176705*^9, 
   3.407529216167498*^9}},
 CellID->1549168418],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TransmitanceAndReflectance", "[", 
           RowBox[{"z", " ", 
            RowBox[{"(*", "Energy", "*)"}], ",", " ", "V0", ",", " ", "a"}], 
           "]"}], "//", "Evaluate"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"z", ",", " ", "0", ",", " ", "energyMax"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotRange", " ", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{"0", ",", " ", "1.02"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"BaseStyle", "\[Rule]", 
          RowBox[{"Directive", "[", "Thick", "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Ticks", " ", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.5", ",", " ", "\"\<0.5\>\""}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"1.0", ",", " ", "\"\<1.0\>\""}], "}"}]}], "}"}]}], 
           "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"AxesLabel", " ", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<E\>\"", ",", "Italic"}], "]"}], ",", "  ", 
            "\"\<\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"AspectRatio", " ", "\[Rule]", 
          RowBox[{"1", "/", "5.5"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"490", ",", "100"}], "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Epilog", " ", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ColorData", "[", 
             RowBox[{"1", ",", "1"}], "]"}], ",", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<R\>\"", ",", "Italic"}], "]"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.1", ",", " ", "0.95"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", " ", 
                RowBox[{"+", "1"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ColorData", "[", 
             RowBox[{"1", ",", "2"}], "]"}], ",", " ", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<T\>\"", ",", "Italic"}], "]"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.1", ",", " ", "0.05"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", " ", 
                RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}]}]}], 
        "\[IndentingNewLine]", "     ", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"val", "=", 
              RowBox[{"\[Psi]", "[", 
               RowBox[{"x", ",", "En", ",", "V0", ",", "a"}], "]"}]}], "}"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"Abs", "[", "val", "]"}], "^", "2"}], ",", 
              RowBox[{"Re", "[", "val", "]"}], ",", 
              RowBox[{"Im", "[", "val", "]"}], ",", "En", ",", 
              RowBox[{"V", "[", 
               RowBox[{"x", ",", "V0", ",", "a"}], "]"}]}], "}"}]}], 
           "\[IndentingNewLine]", "    ", "]"}], "//", "Evaluate"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "xmax"}], ",", "xmax"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "ymax"}], ",", "ymax"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotPoints", " ", "\[Rule]", " ", "75"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotStyle", "\[Rule]", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"RGBColor", "[", 
             RowBox[{"1", ",", ".47", ",", "0"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RGBColor", "[", 
             RowBox[{".38", ",", ".61", ",", ".51"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RGBColor", "[", 
             RowBox[{".1", ",", ".1", ",", ".51"}], "]"}], ",", 
            "\[IndentingNewLine]", "Gray", ",", "\[IndentingNewLine]", 
            RowBox[{"Lighter", "[", 
             RowBox[{"Orange", ",", ".75"}], "]"}]}], "\[IndentingNewLine]", 
           " ", "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Filling", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"5", "\[Rule]", "Bottom"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FillingStyle", "\[Rule]", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Orange", ",", ".75"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"BaseStyle", "\[Rule]", 
          RowBox[{"Directive", "[", "Thick", "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"490", ",", "250"}], "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Epilog", " ", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<E\>\"", ",", "Italic"}], "]"}], ",", 
                 "\"\<  =   \>\""}], "}"}], "]"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"0.6", "xmax"}], ",", " ", 
                RowBox[{"0.9", "ymax"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"+", "1"}], ",", " ", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"ToString", "[", "En", "]"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"0.6", "xmax"}], ",", " ", 
                RowBox[{"0.9", " ", "ymax"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", " ", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Subscript", "[", 
                  RowBox[{
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<V\>\"", ",", "Italic"}], "]"}], ",", "0"}], 
                  "]"}], ",", "\"\<  =   \>\""}], "}"}], "]"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"0.6", "xmax"}], ",", " ", 
                RowBox[{"0.8", "ymax"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"+", "1"}], ",", " ", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"ToString", "[", "V0", "]"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"0.6", "xmax"}], ",", " ", 
                RowBox[{"0.8", " ", "ymax"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", " ", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{
                RowBox[{"Row", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<a\>\"", ",", "Italic"}], "]"}], ",", 
                   "\"\<  =   \>\""}], "}"}], "]"}], ",", "Italic"}], "]"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"0.6", "xmax"}], ",", " ", 
                RowBox[{"0.7", "ymax"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"+", "1"}], ",", " ", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"ToString", "[", "a", "]"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"0.6", "xmax"}], ",", " ", 
                RowBox[{"0.7", "ymax"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", " ", "0"}], "}"}]}], "]"}]}], 
           "\[IndentingNewLine]", "                ", "}"}]}]}], 
        "\[IndentingNewLine]", "         ", "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", "Center"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"En", ",", "1.5", ",", "\"\<particle energy E\>\""}], "}"}], 
     ",", "0", ",", "5", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"V0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<potential well depth \>\"", ",", 
          RowBox[{"Subscript", "[", 
           RowBox[{"\"\<V\>\"", ",", "0"}], "]"}]}], "}"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "5", ",", "\"\<potential well width a\>\""}], "}"}], 
     ",", "0.5", ",", "5", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "\[IndentingNewLine]", 
  "                          ", "]"}]], "Input",
 CellChangeTimes->{{3.3962159356117563`*^9, 3.396215971193563*^9}, 
   3.396443883953125*^9, {3.397248033977664*^9, 3.397248039447957*^9}, {
   3.400263874789119*^9, 3.400263888173911*^9}, {3.400263970409988*^9, 
   3.400264013241404*^9}, {3.400264055395938*^9, 3.400264069489381*^9}, {
   3.400265174977899*^9, 3.4002651779549437`*^9}, {3.4002863542441063`*^9, 
   3.400286367685034*^9}, {3.4003669979546223`*^9, 3.400367060399909*^9}, {
   3.400367116807486*^9, 3.40036712225233*^9}, {3.400388216942498*^9, 
   3.4003882186697807`*^9}, 3.400390599882655*^9, {3.400390721288044*^9, 
   3.40039072817482*^9}, {3.40049758522867*^9, 3.400497587486614*^9}, 
   3.407455357082629*^9, {3.407455524054922*^9, 3.407455533515131*^9}, {
   3.4074555649296*^9, 3.407455565439172*^9}, {3.407455779943369*^9, 
   3.407455828891638*^9}, {3.4074560132501307`*^9, 3.4074561080312977`*^9}, {
   3.407456149646379*^9, 3.407456325408495*^9}, {3.407456426304055*^9, 
   3.407456449205248*^9}, {3.4074564835716248`*^9, 3.4074565602725487`*^9}, {
   3.407456762701936*^9, 3.407456808262669*^9}, {3.407456841140286*^9, 
   3.407457022693967*^9}, {3.4074575744936333`*^9, 3.407457578112176*^9}, {
   3.407457742422124*^9, 3.4074578071380987`*^9}, {3.407457838761512*^9, 
   3.407457880142152*^9}, {3.407457910972068*^9, 3.4074579269436417`*^9}, 
   3.407458220056099*^9, 3.407458743672571*^9, {3.4074587738420057`*^9, 
   3.407458793452783*^9}, 3.407459164599717*^9, {3.4074592631429653`*^9, 
   3.407459267435994*^9}, {3.407507726669346*^9, 3.407507742953246*^9}, {
   3.4075077901001596`*^9, 3.40750779321762*^9}, {3.4075080672528152`*^9, 
   3.4075080960941896`*^9}, {3.40752860598419*^9, 3.407528643368753*^9}, {
   3.407528734879569*^9, 3.407528857281579*^9}, {3.40752893754319*^9, 
   3.407528976433464*^9}, {3.407529060636094*^9, 3.40752908802699*^9}, {
   3.411059955676928*^9, 3.411059961560935*^9}, {3.411060046013633*^9, 
   3.4110600806209383`*^9}, {3.4111304285453234`*^9, 
   3.4111306018098392`*^9}, {3.4111306443720665`*^9, 
   3.4111306452470613`*^9}, {3.411130681684328*^9, 3.411130684746808*^9}, {
   3.4111309000579305`*^9, 3.411131006104127*^9}, {3.4111310530569515`*^9, 
   3.411131057603797*^9}, {3.411131321055236*^9, 3.411131321273985*^9}, {
   3.4111702699758973`*^9, 3.411170282589872*^9}, 3.41117031560077*^9, {
   3.4111703874987698`*^9, 3.4111703928286*^9}, 3.411844037434417*^9},
 CellID->1043661014]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 5, $CellContext`En$$ = 
    1.5, $CellContext`V0$$ = -1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`En$$], 1.5, "particle energy E"}, 0, 5}, {{
       Hold[$CellContext`V0$$], -1, 
       Row[{"potential well depth ", 
         Subscript["V", 0]}]}, -5, -1}, {{
       Hold[$CellContext`a$$], 5, "potential well width a"}, 0.5, 5}}, 
    Typeset`size$$ = {490., {175., 180.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`En$15947$$ = 0, $CellContext`V0$15948$$ = 
    0, $CellContext`a$15949$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 5, $CellContext`En$$ = 
        1.5, $CellContext`V0$$ = -1}, "ControllerVariables" :> {
        Hold[$CellContext`En$$, $CellContext`En$15947$$, 0], 
        Hold[$CellContext`V0$$, $CellContext`V0$15948$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$15949$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         Plot[
          Evaluate[
           $CellContext`TransmitanceAndReflectance[$CellContext`z, \
$CellContext`V0$$, $CellContext`a$$]], {$CellContext`z, 
           0, $CellContext`energyMax}, PlotRange -> {0, 1.02}, BaseStyle -> 
          Directive[Thick], Ticks -> {Automatic, {{0.5, "0.5"}, {1., "1.0"}}},
           AxesLabel -> {
            Style["E", Italic], ""}, AspectRatio -> 1/5.5, 
          ImageSize -> {490, 100}, Exclusions -> None, Epilog -> {
            ColorData[1, 1], 
            Text[
             Style["R", Italic], {0.1, 0.95}, {-1, 
              Plus[1]}], 
            ColorData[1, 2], 
            Text[
             Style["T", Italic], {0.1, 0.05}, {-1, -1}]}], 
         Plot[
          Evaluate[
           
           With[{$CellContext`val$ = $CellContext`\[Psi][$CellContext`x, \
$CellContext`En$$, $CellContext`V0$$, $CellContext`a$$]}, {
            Abs[$CellContext`val$]^2, 
             Re[$CellContext`val$], 
             Im[$CellContext`val$], $CellContext`En$$, 
             $CellContext`V[$CellContext`x, $CellContext`V0$$, \
$CellContext`a$$]}]], {$CellContext`x, -$CellContext`xmax, $CellContext`xmax},
           PlotRange -> {-$CellContext`ymax, $CellContext`ymax}, PlotPoints -> 
          75, PlotStyle -> {
            RGBColor[1, 0.47, 0], 
            RGBColor[0.38, 0.61, 0.51], 
            RGBColor[0.1, 0.1, 0.51], Gray, 
            Lighter[Orange, 0.75]}, Filling -> {5 -> Bottom}, FillingStyle -> 
          Lighter[Orange, 0.75], BaseStyle -> Directive[Thick], 
          ImageSize -> {490, 250}, Exclusions -> None, Epilog -> {
            Text[
             Row[{
               Style["E", Italic], "  =   "}], {
             0.6 $CellContext`xmax, 0.9 $CellContext`ymax}, {
              Plus[1], 0}], 
            Text[
             ToString[$CellContext`En$$], {
             0.6 $CellContext`xmax, 0.9 $CellContext`ymax}, {-1, 0}], 
            Text[
             Row[{
               Subscript[
                Style["V", Italic], 0], "  =   "}], {
             0.6 $CellContext`xmax, 0.8 $CellContext`ymax}, {
              Plus[1], 0}], 
            Text[
             ToString[$CellContext`V0$$], {
             0.6 $CellContext`xmax, 0.8 $CellContext`ymax}, {-1, 0}], 
            Text[
             Style[
              Row[{
                Style["a", Italic], "  =   "}], Italic], {
             0.6 $CellContext`xmax, 0.7 $CellContext`ymax}, {
              Plus[1], 0}], 
            Text[
             ToString[$CellContext`a$$], {
             0.6 $CellContext`xmax, 0.7 $CellContext`ymax}, {-1, 0}]}]}, 
        Center], 
      "Specifications" :> {{{$CellContext`En$$, 1.5, "particle energy E"}, 0, 
         5, Appearance -> "Labeled"}, {{$CellContext`V0$$, -1, 
          Row[{"potential well depth ", 
            Subscript["V", 0]}]}, -5, -1, Appearance -> 
         "Labeled"}, {{$CellContext`a$$, 5, "potential well width a"}, 0.5, 5,
          Appearance -> "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{534., {245., 250.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`TransmitanceAndReflectance[
          Pattern[$CellContext`En, 
           Blank[]], 
          Pattern[$CellContext`V0, 
           Blank[]], 
          Pattern[$CellContext`a, 
           Blank[]]] := 
        Module[{$CellContext`k = $CellContext`a 
            Sqrt[2 $CellContext`En], $CellContext`q = $CellContext`a 
            Sqrt[2 ($CellContext`En - $CellContext`V0)], $CellContext`Rv, \
$CellContext`Tv, $CellContext`Av, $CellContext`Bv}, $CellContext`Rv = Abs[
             $CellContext`RR[$CellContext`k, $CellContext`q]]; \
$CellContext`Tv = Abs[
             $CellContext`TT[$CellContext`k, $CellContext`q]]; \
{$CellContext`Rv^2, $CellContext`Tv^2}], $CellContext`RR[
          Pattern[$CellContext`k, 
           Blank[]], 
          Pattern[$CellContext`q, 
           Blank[]]] := (($CellContext`k^2 - $CellContext`q^2) 
          Sin[$CellContext`q])/(
         E^(I $CellContext`k) (
          2 I $CellContext`k $CellContext`q 
           Cos[$CellContext`q] + ($CellContext`k^2 + $CellContext`q^2) 
           Sin[$CellContext`q])), $CellContext`TT[
          Pattern[$CellContext`k, 
           Blank[]], 
          Pattern[$CellContext`q, 
           Blank[]]] := (I 2 $CellContext`k $CellContext`q)/(
         E^(I $CellContext`k) (
          2 I $CellContext`k $CellContext`q 
           Cos[$CellContext`q] + ($CellContext`k^2 + $CellContext`q^2) 
           Sin[$CellContext`q])), $CellContext`energyMax = 5., 
        Attributes[PlotRange] = {ReadProtected}, $CellContext`\[Psi][
          Pattern[$CellContext`x, 
           Blank[]], 
          Pattern[$CellContext`En, 
           Blank[]], 
          Pattern[$CellContext`V0, 
           Blank[]], 
          Pattern[$CellContext`a, 
           Blank[]]] := 
        Module[{$CellContext`z = $CellContext`x/$CellContext`a, \
$CellContext`k = $CellContext`a 
            Sqrt[2 $CellContext`En], $CellContext`q = $CellContext`a 
            Sqrt[2 ($CellContext`En - $CellContext`V0)], $CellContext`Rv, \
$CellContext`Tv, $CellContext`Av, $CellContext`Bv}, $CellContext`Rv = \
$CellContext`RR[$CellContext`k, $CellContext`q]; $CellContext`Tv = \
$CellContext`TT[$CellContext`k, $CellContext`q]; $CellContext`Av = \
$CellContext`AA[$CellContext`k, $CellContext`q]; $CellContext`Bv = \
$CellContext`BB[$CellContext`k, $CellContext`q]; 
          Which[$CellContext`z < (-1)/2, 
            Exp[I $CellContext`k $CellContext`z] + $CellContext`Rv 
             Exp[(-I) $CellContext`k $CellContext`z], Abs[$CellContext`z] <= 
            1/2, $CellContext`Av 
             Exp[I $CellContext`q ($CellContext`x/$CellContext`a)] + \
$CellContext`Bv Exp[(-I) $CellContext`q $CellContext`z], $CellContext`z > 
            1/2, $CellContext`Tv 
            Exp[I $CellContext`k $CellContext`z]]], $CellContext`AA[
          Pattern[$CellContext`k, 
           Blank[]], 
          Pattern[$CellContext`q, 
           
           Blank[]]] := $CellContext`TT[$CellContext`k, $CellContext`q] \
(($CellContext`q + $CellContext`k)/(2 $CellContext`q)) 
         Exp[I (($CellContext`k - $CellContext`q)/2)], $CellContext`BB[
          Pattern[$CellContext`k, 
           Blank[]], 
          Pattern[$CellContext`q, 
           
           Blank[]]] := $CellContext`TT[$CellContext`k, $CellContext`q] \
(($CellContext`q - $CellContext`k)/(2 $CellContext`q)) 
         Exp[I (($CellContext`k + $CellContext`q)/2)], $CellContext`V[
          Pattern[$CellContext`x, 
           Blank[]], 
          Pattern[$CellContext`V0, 
           Blank[]], 
          Pattern[$CellContext`a, 
           Blank[]]] := $CellContext`V0 (
          UnitStep[$CellContext`x + $CellContext`a/2] - 
          UnitStep[$CellContext`x - $CellContext`a/2]), $CellContext`xmax = 
        10.5, $CellContext`ymax = 5., Attributes[Subscript] = {NHoldRest}, 
        Subscript[$CellContext`CA$6411, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CA$6411, $CellContext`init$6411] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CB$6411, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CB$6411, $CellContext`init$6411] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CA$8867, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CA$8867, $CellContext`init$8867] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CB$8867, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CB$8867, $CellContext`init$8867] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CA$11314, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CA$11314, $CellContext`init$11314] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CB$11314, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CB$11314, $CellContext`init$11314] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CA$13776, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CA$13776, $CellContext`init$13776] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CB$13776, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CB$13776, $CellContext`init$13776] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CA$16223, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CA$16223, $CellContext`init$16223] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CB$16223, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CB$16223, $CellContext`init$16223] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CA$18662, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CA$18662, $CellContext`init$18662] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CB$18662, 0][
          Pattern[$CellContext`t$, 
           Blank[]]] := 
        Subscript[$CellContext`CB$18662, $CellContext`init$18662] (
          UnitStep[$CellContext`t$] - UnitStep[$CellContext`t$ - 10]), 
        Subscript[$CellContext`CA$11314, $CellContext`init$11314] = 0.23, 
        Subscript[$CellContext`CA$13776, $CellContext`init$13776] = 0.23, 
        Subscript[$CellContext`CA$16223, $CellContext`init$16223] = 0.23, 
        Subscript[$CellContext`CA$18662, $CellContext`init$18662] = 0.23, 
        Subscript[$CellContext`CA$6411, $CellContext`init$6411] = 0.23, 
        Subscript[$CellContext`CA$8867, $CellContext`init$8867] = 0.23, 
        Subscript[$CellContext`CB$11314, $CellContext`init$11314] = 0.23, 
        Subscript[$CellContext`CB$13776, $CellContext`init$13776] = 0.23, 
        Subscript[$CellContext`CB$16223, $CellContext`init$16223] = 0.23, 
        Subscript[$CellContext`CB$18662, $CellContext`init$18662] = 0.23, 
        Subscript[$CellContext`CB$6411, $CellContext`init$6411] = 0.23, 
        Subscript[$CellContext`CB$8867, $CellContext`init$8867] = 0.23, 
        Subscript[$CellContext`V$11314, $CellContext`stage$11314] = 
        1.5707963267948966`, 
        Subscript[$CellContext`V$11314, $CellContext`tot$11314] = 
        314.1592653589793, 
        Subscript[$CellContext`V$13776, $CellContext`stage$13776] = 
        1.5707963267948966`, 
        Subscript[$CellContext`V$13776, $CellContext`tot$13776] = 
        314.1592653589793, 
        Subscript[$CellContext`V$16223, $CellContext`stage$16223] = 
        1.5707963267948966`, 
        Subscript[$CellContext`V$16223, $CellContext`tot$16223] = 
        314.1592653589793, 
        Subscript[$CellContext`V$18662, $CellContext`stage$18662] = 
        1.5707963267948966`, 
        Subscript[$CellContext`V$18662, $CellContext`tot$18662] = 
        314.1592653589793, 
        Subscript[$CellContext`V$6411, $CellContext`stage$6411] = 
        1.5707963267948966`, 
        Subscript[$CellContext`V$6411, $CellContext`tot$6411] = 
        314.1592653589793, 
        Subscript[$CellContext`V$8867, $CellContext`stage$8867] = 
        1.5707963267948966`, 
        Subscript[$CellContext`V$8867, $CellContext`tot$8867] = 
        314.1592653589793, 
        Subscript[$CellContext`w, $CellContext`opt] = {2.706, 3.686}, 
        Attributes[$CellContext`CA$6411] = {Temporary}, 
        Attributes[$CellContext`init$6411] = {Temporary}, 
        Attributes[$CellContext`CB$6411] = {Temporary}, 
        Attributes[$CellContext`CA$8867] = {Temporary}, 
        Attributes[$CellContext`init$8867] = {Temporary}, 
        Attributes[$CellContext`CB$8867] = {Temporary}, 
        Attributes[$CellContext`CA$11314] = {Temporary}, 
        Attributes[$CellContext`init$11314] = {Temporary}, 
        Attributes[$CellContext`CB$11314] = {Temporary}, 
        Attributes[$CellContext`CA$13776] = {Temporary}, 
        Attributes[$CellContext`init$13776] = {Temporary}, 
        Attributes[$CellContext`CB$13776] = {Temporary}, 
        Attributes[$CellContext`CA$16223] = {Temporary}, 
        Attributes[$CellContext`init$16223] = {Temporary}, 
        Attributes[$CellContext`CB$16223] = {Temporary}, 
        Attributes[$CellContext`CA$18662] = {Temporary}, 
        Attributes[$CellContext`init$18662] = {Temporary}, 
        Attributes[$CellContext`CB$18662] = {Temporary}, 
        Attributes[$CellContext`V$18662] = {Temporary}, 
        Attributes[$CellContext`stage$18662] = {Temporary}, 
        Attributes[$CellContext`V$16223] = {Temporary}, 
        Attributes[$CellContext`tot$16223] = {Temporary}, 
        Attributes[$CellContext`V$8867] = {Temporary}, 
        Attributes[$CellContext`tot$8867] = {Temporary}, 
        Attributes[$CellContext`tot$18662] = {Temporary}, 
        Attributes[$CellContext`V$13776] = {Temporary}, 
        Attributes[$CellContext`tot$13776] = {Temporary}, 
        Attributes[$CellContext`stage$13776] = {Temporary}, 
        Attributes[$CellContext`stage$8867] = {Temporary}, 
        Attributes[$CellContext`V$11314] = {Temporary}, 
        Attributes[$CellContext`stage$11314] = {Temporary}, 
        Attributes[$CellContext`V$6411] = {Temporary}, 
        Attributes[$CellContext`tot$6411] = {Temporary}, 
        Attributes[$CellContext`stage$16223] = {Temporary}, 
        Attributes[$CellContext`stage$6411] = {Temporary}, 
        Attributes[$CellContext`tot$11314] = {Temporary}}; 
      Typeset`initDone$$ = True); ReleaseHold[{{
         HoldComplete[$CellContext`V[
            Pattern[$CellContext`x, 
             Blank[]], 
            Pattern[$CellContext`V0, 
             Blank[]], 
            Pattern[$CellContext`a, 
             Blank[]]] := $CellContext`V0 (
            UnitStep[$CellContext`x + $CellContext`a/2] - 
            UnitStep[$CellContext`x - $CellContext`a/2])], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`RR[
            Pattern[$CellContext`k, 
             Blank[]], 
            Pattern[$CellContext`q, 
             Blank[]]] := 
          E^((-I) $CellContext`k) ($CellContext`k^2 - $CellContext`q^2) 
           Sin[$CellContext`q]/(
           2 I $CellContext`k $CellContext`q 
            Cos[$CellContext`q] + ($CellContext`k^2 + $CellContext`q^2) 
            Sin[$CellContext`q])], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`TT[
            Pattern[$CellContext`k, 
             Blank[]], 
            Pattern[$CellContext`q, 
             Blank[]]] := 
          I 2 $CellContext`k $CellContext`q E^((-I) $CellContext`k)/(
           2 I $CellContext`k $CellContext`q 
            Cos[$CellContext`q] + ($CellContext`k^2 + $CellContext`q^2) 
            Sin[$CellContext`q])], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`AA[
            Pattern[$CellContext`k, 
             Blank[]], 
            Pattern[$CellContext`q, 
             
             Blank[]]] := $CellContext`TT[$CellContext`k, $CellContext`q] \
(($CellContext`q + $CellContext`k)/(2 $CellContext`q)) 
           Exp[I (($CellContext`k - $CellContext`q)/2)]], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`BB[
            Pattern[$CellContext`k, 
             Blank[]], 
            Pattern[$CellContext`q, 
             
             Blank[]]] := $CellContext`TT[$CellContext`k, $CellContext`q] \
(($CellContext`q - $CellContext`k)/(2 $CellContext`q)) 
           Exp[I (($CellContext`k + $CellContext`q)/2)]], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`\[Psi][
            Pattern[$CellContext`x, 
             Blank[]], 
            Pattern[$CellContext`En, 
             Blank[]], 
            Pattern[$CellContext`V0, 
             Blank[]], 
            Pattern[$CellContext`a, 
             Blank[]]] := 
          Module[{$CellContext`z = $CellContext`x/$CellContext`a, \
$CellContext`k = $CellContext`a 
              Sqrt[2 $CellContext`En], $CellContext`q = $CellContext`a 
              Sqrt[2 ($CellContext`En - $CellContext`V0)], $CellContext`Rv, \
$CellContext`Tv, $CellContext`Av, $CellContext`Bv}, $CellContext`Rv = \
$CellContext`RR[$CellContext`k, $CellContext`q]; $CellContext`Tv = \
$CellContext`TT[$CellContext`k, $CellContext`q]; $CellContext`Av = \
$CellContext`AA[$CellContext`k, $CellContext`q]; $CellContext`Bv = \
$CellContext`BB[$CellContext`k, $CellContext`q]; 
            Which[$CellContext`z < (-1)/2, 
              Exp[I $CellContext`k $CellContext`z] + $CellContext`Rv 
               Exp[(-I) $CellContext`k $CellContext`z], Abs[$CellContext`z] <= 
              1/2, $CellContext`Av 
               Exp[I $CellContext`q ($CellContext`x/$CellContext`a)] + \
$CellContext`Bv Exp[(-I) $CellContext`q $CellContext`z], $CellContext`z > 
              1/2, $CellContext`Tv Exp[I $CellContext`k $CellContext`z]]]], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`TransmitanceAndReflectance[
            Pattern[$CellContext`En, 
             Blank[]], 
            Pattern[$CellContext`V0, 
             Blank[]], 
            Pattern[$CellContext`a, 
             Blank[]]] := 
          Module[{$CellContext`k = $CellContext`a 
              Sqrt[2 $CellContext`En], $CellContext`q = $CellContext`a 
              Sqrt[2 ($CellContext`En - $CellContext`V0)], $CellContext`Rv, \
$CellContext`Tv, $CellContext`Av, $CellContext`Bv}, $CellContext`Rv = Abs[
               $CellContext`RR[$CellContext`k, $CellContext`q]]; \
$CellContext`Tv = Abs[
               $CellContext`TT[$CellContext`k, $CellContext`q]]; \
{$CellContext`Rv^2, $CellContext`Tv^2}]], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`xmax = 10.5; Null], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`ymax = 5.; Null], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`energyMax = 5.; Null]}}]; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->26788140],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Scattering by a Square-Well Potential",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ScatteringByASquareWellPotential/"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ScatteringByASquareWellPotential/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
ScatteringByASquareWellPotential/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ScatteringByASquareWellPotential/"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ScatteringByASquareWellPotential/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[CellGroupData[{

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["M. Hanson",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=M.+Hanson"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=M.+Hanson"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->164233602],

Cell[TextData[{
 "Based on a program by: ",
 ButtonBox["Mahn-Soo Choi",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Mahn-Soo+Choi"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Mahn-Soo+Choi"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->1264739280]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
ScatteringByASquareWellPotential"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Scattering by a Square-Well Potential - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (February 7, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 229, 4, 70, "Section"],
Cell[822, 29, 8749, 234, 70, "Input",
 CellID->1549168418],
Cell[9574, 265, 13136, 293, 70, "Input",
 CellID->1043661014]
}, Open  ]],
Cell[22725, 561, 20352, 419, 70, "Output",
 CellID->26788140],
Cell[CellGroupData[{
Cell[43102, 984, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[43478, 995, 988, 29, 70, "Text"],
Cell[44469, 1026, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[CellGroupData[{
Cell[44831, 1039, 444, 15, 70, "Text",
 CellID->164233602],
Cell[45278, 1056, 464, 15, 70, "Text",
 CellID->1264739280]
}, Open  ]],
Cell[CellGroupData[{
Cell[45779, 1076, 829, 24, 70, "Text"],
Cell[46611, 1102, 1208, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 1QNEeTZdZJWjwA0wbrWmG1NK *)
