(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     82047,       1534]
NotebookOptionsPosition[     80838,       1488]
NotebookOutlinePosition[     81492,       1513]
CellTagsIndexPosition[     81449,       1510]
WindowTitle->Reflections in a Mirrored Corner - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Reflections in a Mirrored Corner", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG
xoZzQu3Aku7VfUj4Nk53//fLn//78q+Xl5f/NP/88e+Xl8v154Xj5+fp89y0
4+X63L7VnQu02XqOt9FzjRK5qtRMoYZFpk11/Ji+WDye92+r7+fFfbnGkuu9
eIQ4LBVJ+YRo5DPnRdITDp0TLRg6m/62nY/n08f5+H461G37fWqum57z4Xy2
jby0prMZOh4/jodLOx2bt6fzRSEA3B/KMKGSBy/DSKVcyYOn8krHqajvqed6
G6iol4qkfAIVNQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADsizPA/lj72AEA
AMCmWLu0AXh01j6jAAAAcdb+hNwUJ5e1zZnPDEeey/e1jx0AAABsirVLm03x
XFVlhs1X1JNY+4wCAAB02B9PJ4BdsvYpBAAAgOeGihpADo9GAUDIr+Lnr7ef
a9vw16/i73VtMPx6+2v1gGwMijeAE89FAQA2DRW1BxX14lBRA0wi+lx0baMA
AAAAAAAAAAAAbkj0uegR4L4cDoe1TYA1YQMAbIaDy9rm3JU9+w4AjwB3np3D
BgDYDHuuKu/su3k0ynNRACGLHMy93dm2ijCPpHvD7LliAQAAmA0VNRioqIGK
GlYk9Vz0AAAAAAAAAAAAALBR9KPR8Kf0a9sFAAAAAAAAAAAAcCt4LgoAAAAA
AAAAAAB7I/Vc9ONheH9/X9uEzUJsZ0PoAGBZ3gNuLQgggR21GUjl7SC2syF0
ALAsVNQgxMv14XAI/xOja9sIAAAAT0lYWM5jbT/msGffAQAAAGAp9lxV3sF3
b1r0uehSZgAAAAAAAAAAAAA8Ar9b6rpuXpu3+tf0PBcFWJcFvxYBAAAAANgh
VNQAADCK5LnobwAAAAAAAAAAAIANUbcPRav+wehH7LmoUqpsqKqmNTSXRVE0
by593mtRXlrfo7mImTlVN6ebUOhR07q3jmxVWXqquqxVOUjZq1eDVNe662ro
Nxe1Xr5o2lt5cUc7VWr3BpGindNL6TkDl5nVIGWtbuaXWbwJo/OVKjSX68oL
shMTO4ylHf+yy5GbhU5EubJJPeWgx5ayBfvOIR2qD5QJXWmFtJs2pLsLvu40
4oOesh/tJ3TKW/3DomZONgVdVPtNXvVXYWydyBRl/NWNWNW62L06G344TcNW
L/SVpaTqcmeOWGWOm3W+TFPWsbL8dE1yklUal73ghDtBH+Hu1dE/HBM7/t7h
sjNoN29Calrl2GadWfsMeoc0elcR584clrm5qzO5a+5mQe4imy2Tu1qcu+g2
7od7mkvVtqJtajgInQuqzUrRtWFCzIAkzQdK0/RR1U33JEhtgOhosnmLKtX0
DArVhaJHtZOlmgPbVN+mWZhRGzNvEc13MD61kIRcEPS2WciRp/C97a0ow569
DCOVRurZU0lFnUoBFbWkKiv7I0xFLc4dFXUAFfVUtVTUYRD2V1EnfTd7u920
v+va/NXoSXM86qXVwFtzgNvS7vJG3730Ga76Wkq/6lFz3dlWOa+69XpUOSix
ixQtrrVV1pxBleO+uesMsv6QjenXF+bViFjGO5rtObaUp7bVoENe21Kqy1Un
1M8xOaxNftysOh61q5joKStQpbkIQ2p54HRWXcqsOsbVU7oZNBr8Fbv+yotk
GBkvbuFbu9/LkY6DF3ZvTvqtOVXdBi0dlN6WZekEsHfQ2flmjpnQ+25vfn//
2yH1eswnokp/tNkpsJNrTqJruX4tzAkKBJXJVdUbbJmtrwtrUfuoGm2Ru5S3
AcrEGQyPld3jzbFTH+oP+is3d+XVuev2wI1zN9w8rZM1I3dFf203xxKvuUyT
TevJkd8JSzF7iVHBzJa+D0vFZJLapawNh6xiQ91ixaf03R+lDHvaMqwPCKl8
+lRGgkZF3W3Q0oGKmoq685yKmoo6L5jZ0vdhqZhMUruUteEQFfUk37VU98C8
qRvq+uPjQz8UPZ/P+snoZYIqVAwtaFY0r+E0+8l8VIM3Gs70JkelUoLR0XBm
2X5dldcmWS5lQ2r1jDue+DBaRvrzvidVpc2WOKJicRvVZu+HaFqjgpngC/MS
Fek2rRvSjKCy9rnxfepWFFKokVMzWaEsU9GDbEYnbfuoYOpGkdcwql/Sv+fc
CVdJcY1a+Yo3WuUaZsfE+9S+j3mTRuFZoAxL9eTtFK6ecccTH0bnlmGkMtXz
dKnMLCTpifZTUUfnyNOR4QGrstQuHTXGFqSiXiV3wlVSXKNWvuKNVrmG2TGh
ooZb0+T0rUWf/br9e1HvuWjR/z1/+JOUIujKPxYu+l9YCEX0kGVARDxjjHxa
ygZv6ejF6KiE0cfp0eUk6JMrmVamQx1qkPTIRzNSo4LC0OnbV7S/tD7WRw32
ElFYP1/y7EkZn09lPhHedej7vDiHSkbzq79YsWcWfUUUzYgXf7mdqa04eiK0
ebYxe86d9yE+T3n+OzuVqHbMx01Up/kkCud7Q0ZJ5uvCRQhNGvVCoueayK9O
mKP8qDDd9szol7b5AM5LSup0P7LvxXBX8dWGvlCGTTJm1IBwianK3QySyo2k
clR/KtShBkmPfDQjNSpIRS0xexJRy8NjS0UtMfVBcmegoh6FijrkEarKPVfU
Gd89w+rwd/Tt34uq/kuT6C2xsG5WhXvLsu+KUb+8/kxsvQMryUIxdp8PLc/c
FiblXaJEcgvKuODFf54N8yYXwYejZ2fUbO8i5b7kXwRSPfJtFu1JWZ7BtlZu
eRg9XXJEbcuriorIU2xkjYjQi2hJFjXeFvFmhjeNUWu9HhO3/LQoe8tdSKqC
ys+f+tE5aZVoBSU0T87U+sr2emq4Ur7k9eQrhydiaqiF3LqSX4QFfacMk684
yaT7l2GkUr7iJJOoqKMrUlGPritxZ9RyT9aIUFHn133e3IVQUQvVUlHPhor6
1r6r/k9G9X1A/47+dDrZ/9+lb9++vbr8+PHDe7X7w077rafHU+JNTo1GF/Wu
U52hhtCjqGEZJVGdoZsp5ZmZoRe2kc3Fd0tnKGKvJQ9UKr8pRh15dY0MZTOO
e/pTa43OSUmFpn5Pbzzv7agveTNCJRnZ70FCX4OU5ZWn9KfiELrpLZ3aIZn0
RYmGN+NRPsIpd7y19pa7qIhQZ15coicVmamMLjpb1SLmLUgmzlOtzau6RRAm
bYxFTJoh9Vy+U4aNKonqDN1MKc/MDL2wjXydWIaRylElz5LKVExSS2Scigqm
HHl1jQxlM457+lNrjc5JSYWmUlF7jqQ2RmqHZNIXJRrejEf5CKfc8dbaW+6i
IkKdeXGJnlRkpjK66GxVi5i3IJk4T7U2r+oWQZi0MRYxaYbUZnyPLvH/lte2
FP/69esnAAAAAAAAAAAAwM74B4thROM=
   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x0", "=", "0"}], ",", 
       RowBox[{"y0", "=", "0"}], ",", 
       RowBox[{"y1", "=", "0"}], ",", 
       RowBox[{"l", "=", "11"}], ",", 
       RowBox[{"pfin", "=", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], ",", "alf1", ",", "y2", ",", "phi",
        ",", "line2", ",", "fl", ",", "koord", ",", "x", ",", "x1", ",", "x2",
        ",", "x3", ",", "alf", ",", "alf2", ",", "alf3"}], "}"}], ",", 
     "\[IndentingNewLine]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"line2", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3_", ",", "x4_"}], "}"}]}], "]"}], ":=", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x3", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y2", "-", "y1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}], "x3"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x2", " ", "y1"}], "-", 
                RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x4", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y2", "-", "y1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}], "x4"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x2", " ", "y1"}], "-", 
                RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"phi", "=", 
       RowBox[{"\[CurlyPhi]", " ", "Degree"}]}], ";", 
      RowBox[{"fl", "=", "True"}], ";", "\[IndentingNewLine]", 
      RowBox[{"alf1", "=", 
       RowBox[{
        RowBox[{"\[Pi]", "/", "2."}], "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sunloc", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "x10"}], ")"}], ",", 
          RowBox[{"sunloc", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], ";", 
      RowBox[{"koord", "=", 
       RowBox[{"{", 
        RowBox[{"sunloc", ",", 
         RowBox[{"{", 
          RowBox[{"x10", ",", "y1"}], "}"}]}], "}"}]}], ";", 
      RowBox[{"x1", "=", "x10"}], ";", 
      RowBox[{"alf", "=", "\"\<\>\""}], ";", 
      RowBox[{"x3", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"x1", ">", "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"alf1", "\[Equal]", "0"}], ",", 
           RowBox[{"x2", "=", "x1"}], ",", "\[IndentingNewLine]", 
           RowBox[{"x2", "=", 
            RowBox[{"x", "/.", 
             RowBox[{"First", "[", 
              RowBox[{"Solve", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"Tan", "[", "phi", "]"}], " ", "x"}], "-", 
                  RowBox[{
                   RowBox[{"Tan", "[", 
                    RowBox[{
                    RowBox[{"\[Pi]", "/", "2"}], "+", "alf1"}], "]"}], 
                   RowBox[{"(", 
                    RowBox[{"x", "-", "x1"}], ")"}]}]}], "\[Equal]", "0"}], 
                ",", "x"}], "]"}], "]"}]}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"alf1", "<", "0"}], "&&", "fl"}], ",", 
           RowBox[{
            RowBox[{"alf", "=", 
             RowBox[{"alf", "<>", "\"\<\\n\>\""}]}], ";", 
            RowBox[{"fl", "=", "False"}]}]}], "]"}], ";", 
         RowBox[{"alf", "=", 
          RowBox[{"alf", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{"Round", "[", 
             RowBox[{
              RowBox[{"alf1", "/", "Degree"}], ",", ".1"}], "]"}], "]"}], 
           "<>", "\"\<\[Degree], \>\""}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"y2", "=", 
          RowBox[{
           RowBox[{"Tan", "[", "phi", "]"}], " ", "x2"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"x2", "<=", "0"}], ",", 
           RowBox[{
            RowBox[{"pfin", "=", 
             RowBox[{"{", 
              RowBox[{"x2", ",", "y2"}], "}"}]}], ";", 
            RowBox[{"Break", "[", "]"}]}], ",", 
           RowBox[{"koord", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"koord", ",", 
              RowBox[{"{", 
               RowBox[{"x2", ",", "y2"}], "}"}]}], "]"}]}]}], "]"}], ";", 
         RowBox[{"alf2", "=", 
          RowBox[{"alf1", "-", "phi"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"alf2", "<=", "0"}], "&&", "fl"}], ",", 
           RowBox[{
            RowBox[{"alf", "=", 
             RowBox[{"alf", "<>", "\"\<\\n\>\""}]}], ";", 
            RowBox[{"fl", "=", "False"}]}]}], "]"}], ";", 
         RowBox[{"alf", "=", 
          RowBox[{"alf", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{"Round", "[", 
             RowBox[{
              RowBox[{"alf2", "/", "Degree"}], ",", ".1"}], "]"}], "]"}], 
           "<>", "\"\<\[Degree], \>\""}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"alf3", "=", 
          RowBox[{"alf2", "-", "phi"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"alf3", "\[Equal]", "0"}], "||", 
            RowBox[{"alf3", "\[Equal]", 
             RowBox[{"Pi", "/", "2"}]}]}], ",", 
           RowBox[{"x3", "=", "x2"}], ",", "\[IndentingNewLine]", 
           RowBox[{"x3", "=", 
            RowBox[{"x", "/.", 
             RowBox[{"First", "[", 
              RowBox[{"Solve", "[", 
               RowBox[{
                RowBox[{"y2", "==", 
                 RowBox[{
                  RowBox[{"Tan", "[", 
                   RowBox[{
                    RowBox[{"\[Pi]", "/", "2"}], "-", "alf3"}], "]"}], 
                  RowBox[{"(", 
                   RowBox[{"x2", "-", "x"}], ")"}]}]}], ",", "x"}], "]"}], 
              "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"x3", "<=", "0"}], ",", 
           RowBox[{
            RowBox[{"pfin", "=", 
             RowBox[{"{", 
              RowBox[{"x3", ",", "0"}], "}"}]}], ";", 
            RowBox[{"Break", "[", "]"}]}], ",", 
           RowBox[{"koord", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"koord", ",", 
              RowBox[{"{", 
               RowBox[{"x3", ",", "0"}], "}"}]}], "]"}]}]}], "]"}], ";", 
         RowBox[{"x1", "=", "x3"}], ";", 
         RowBox[{"y1", "=", "0"}], ";", 
         RowBox[{"alf1", "=", "alf3"}]}]}], "\[IndentingNewLine]", "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"Blue", ",", "Thick", ",", "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"l", "+", "x0"}], ",", "y0"}], "}"}]}], "}"}], "]"}], 
          ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"l", "+", "x0"}], ",", 
               RowBox[{
                RowBox[{"l", " ", 
                 RowBox[{"Tan", "[", "phi", "]"}]}], "+", "y0"}]}], "}"}]}], 
            "}"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Blue", ",", ".85"}], "]"}], ",", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "-", "0.2"}], ",", 
               RowBox[{"y0", "-", "0.03"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"l", "+", "x0"}], ",", 
               RowBox[{"y0", "-", "0.03"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"l", "+", "x0"}], ",", 
               RowBox[{"y0", "-", "0.5"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "-", ".2"}], ",", 
               RowBox[{"y0", "-", "0.5"}]}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "-", "0.2"}], ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x0", ",", 
               RowBox[{"y0", "+", "0.03"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"l", "+", "x0"}], ",", 
               RowBox[{
                RowBox[{"l", " ", 
                 RowBox[{"Tan", "[", "phi", "]"}]}], "+", "y0", "+", 
                "0.03"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"l", "+", "x0"}], ",", 
               RowBox[{
                RowBox[{"l", " ", 
                 RowBox[{"Tan", "[", "phi", "]"}]}], "+", "y0", "+", ".6"}]}],
               "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "-", "0.2"}], ",", 
               RowBox[{"y0", "+", ".6"}]}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", "Thick", ",", 
          RowBox[{"Darker", "[", 
           RowBox[{"Red", ",", ".4"}], "]"}], ",", 
          RowBox[{"Line", "[", "koord", "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"pfin", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "<=", "0"}], ",", 
            RowBox[{"line2", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"pfin", ",", 
                RowBox[{"Last", "[", "koord", "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"Last", "[", "koord", "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", "11"}], "}"}]}], "]"}], 
            ",", 
            RowBox[{"{", "}"}]}], "]"}], ",", "Black", ",", 
          RowBox[{"If", "[", 
           RowBox[{"notat", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{
                 "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(n + 1\)]\) = \
\!\(\*SubscriptBox[\(\[Alpha]\), \(n\)]\) - \[CurlyPhi]\>\"", ",", "Large"}], 
                 "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"5", ",", "7.9"}], "}"}]}], "]"}], ",", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{
                  RowBox[{"\"\<\[CurlyPhi]=\>\"", "<>", 
                   RowBox[{"ToString", "[", "\[CurlyPhi]", "]"}], "<>", 
                   "\"\<\[Degree]\>\""}], ",", "Large"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"x0", "+", "1."}], ",", 
                  RowBox[{"y0", "+", "1.4"}]}], "}"}]}], "]"}], ",", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"alf", ",", "Medium"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"5.", ",", "6.5"}], "}"}]}], "]"}]}], "}"}], ",", 
            RowBox[{"{", "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"550", ",", "340"}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "0.6"}], ",", 
        RowBox[{"Axes", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.5`"}], ",", "11"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.5`"}], ",", "8"}], "}"}]}], "}"}]}]}], 
       "\[IndentingNewLine]", "]"}]}]}], 
    RowBox[{"(*", "Graphics", "*)"}], "\[IndentingNewLine]", "]"}], ",", 
   RowBox[{"(*", "Module", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sunloc", ",", 
       RowBox[{"{", 
        RowBox[{"10.373", ",", "0.5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0.01"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "10"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Control", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "x10", ",", "9", ",", 
             "\"\<\!\(\*SubscriptBox[\(\:0445\), \(1\)]\)\>\""}], "}"}], ",", 
           "1", ",", "11.", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Control", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[CurlyPhi]", ",", "20", ",", "\"\<\[CurlyPhi] \>\""}], 
            "}"}], ",", "1", ",", "45.", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Control", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"notat", ",", "False", ",", "\"\<notation\>\""}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Button", "[", 
         RowBox[{
         "\"\<reset \!\(\*SubscriptBox[\(x\), \(1\)]\) and the locator\>\"", 
          ",", 
          RowBox[{
           RowBox[{"sunloc", "=", 
            RowBox[{"{", 
             RowBox[{"10.5", ",", "0.2"}], "}"}]}], ";", 
           RowBox[{"notat", "=", "False"}], ";", 
           RowBox[{"x10", "=", "9"}]}]}], "]"}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.40231868285317*^9, 3.402318826368499*^9}, {
   3.402318865616293*^9, 3.4023188834256372`*^9}, {3.4023189613774443`*^9, 
   3.402318981540538*^9}, {3.402319048537404*^9, 3.402319051022964*^9}, {
   3.402319839342037*^9, 3.402319868557124*^9}, {3.402319929775968*^9, 
   3.40231995581493*^9}, {3.402319988765429*^9, 3.402320020499371*^9}, {
   3.40232019068532*^9, 3.4023202156203117`*^9}, {3.4023202746125183`*^9, 
   3.402320277887741*^9}, {3.402320415285728*^9, 3.402320430528645*^9}, {
   3.4023205008081007`*^9, 3.402320568280961*^9}, {3.402320670888543*^9, 
   3.4023207633819857`*^9}, {3.4023208116542883`*^9, 3.402320811990802*^9}, {
   3.402320891810433*^9, 3.40232094605602*^9}, {3.402321292913018*^9, 
   3.402321342767487*^9}, {3.402321394066876*^9, 3.4023214237627563`*^9}, {
   3.4023215203421373`*^9, 3.402321528060629*^9}, {3.402321674619534*^9, 
   3.4023217003714533`*^9}, {3.4023217984882174`*^9, 
   3.4023218339647713`*^9}, {3.4023218978503532`*^9, 
   3.4023222122581367`*^9}, {3.402322255345478*^9, 3.402322264689705*^9}, {
   3.402322319492154*^9, 3.40232236573615*^9}, {3.4023224050429564`*^9, 
   3.402322640849188*^9}, {3.402322687063345*^9, 3.402322690290566*^9}, 
   3.402322742480732*^9, 3.402322784849374*^9, {3.402322829298814*^9, 
   3.40232286973314*^9}, {3.402323011946101*^9, 3.402323092765067*^9}, 
   3.40232317685404*^9, {3.402323346952265*^9, 3.402323442973715*^9}, {
   3.402323859024531*^9, 3.402323865638506*^9}, {3.402323902941496*^9, 
   3.40232396979887*^9}, {3.402324011305174*^9, 3.402324045312091*^9}, {
   3.402324082139415*^9, 3.402324128685479*^9}, {3.40232417138323*^9, 
   3.402324196010634*^9}, {3.402324274787778*^9, 3.4023245129523287`*^9}, {
   3.4023245979158907`*^9, 3.402324676198897*^9}, {3.4023247259989223`*^9, 
   3.40232481659984*^9}, {3.4023250796063538`*^9, 3.4023250945067797`*^9}, {
   3.402325124921282*^9, 3.402325184711931*^9}, 3.402325255587064*^9, {
   3.402325304171589*^9, 3.4023254494713497`*^9}, {3.402325568355319*^9, 
   3.4023256118822203`*^9}, {3.402325646425758*^9, 3.4023256678213253`*^9}, {
   3.40232570467131*^9, 3.402325814328553*^9}, 3.402325863502571*^9, {
   3.402325990967867*^9, 3.402326001385871*^9}, {3.402326048150588*^9, 
   3.402326077690228*^9}, {3.402326292686479*^9, 3.402326352934392*^9}, {
   3.402326388666614*^9, 3.4023264256493*^9}, {3.4023264573415728`*^9, 
   3.402326498022635*^9}, {3.402326548339292*^9, 3.4023265953722057`*^9}, {
   3.402326667111238*^9, 3.402326718069149*^9}, {3.402326778775075*^9, 
   3.4023269111153812`*^9}, {3.402326944730464*^9, 3.402327023228105*^9}, {
   3.402327061868245*^9, 3.402327109881625*^9}, {3.402327155903082*^9, 
   3.40232721156074*^9}, {3.402327577451582*^9, 3.40232764266822*^9}, {
   3.402328338992955*^9, 3.402328339809719*^9}, {3.402332369202717*^9, 
   3.402332372415628*^9}, {3.402332428657157*^9, 3.4023324343772993`*^9}, {
   3.4023324923125563`*^9, 3.4023324928165627`*^9}, {3.402332792580061*^9, 
   3.4023327934823427`*^9}, {3.402333304461378*^9, 3.4023333419021673`*^9}, {
   3.402333387376837*^9, 3.4023334977904787`*^9}, {3.402333658625741*^9, 
   3.402333820506328*^9}, {3.40233385846661*^9, 3.402333922817564*^9}, {
   3.402333991182128*^9, 3.402334068795723*^9}, {3.402334149632696*^9, 
   3.40233419774756*^9}, {3.402334238045949*^9, 3.4023344834489326`*^9}, {
   3.402334535997303*^9, 3.402334692371393*^9}, {3.402336001845948*^9, 
   3.402336016516197*^9}, {3.402753235141433*^9, 3.4027532379266367`*^9}, {
   3.4027532765563717`*^9, 3.402753280110779*^9}, {3.402753313850478*^9, 
   3.4027533171117477`*^9}, {3.4027533543270397`*^9, 
   3.4027533961438313`*^9}, {3.402753463249316*^9, 3.402753468749481*^9}, {
   3.402753504801208*^9, 3.402753514444932*^9}, {3.402753624885334*^9, 
   3.402753711238185*^9}, {3.402753772930896*^9, 3.402753905266059*^9}, {
   3.402753964105823*^9, 3.402753964587797*^9}, {3.402754095253221*^9, 
   3.402754100869372*^9}, {3.402754150577834*^9, 3.4027541526356993`*^9}, {
   3.402754202228198*^9, 3.402754228473255*^9}, {3.402754313842664*^9, 
   3.402754373785614*^9}, {3.402754434672084*^9, 3.4027544372510643`*^9}, {
   3.402754520164584*^9, 3.4027545310370893`*^9}, {3.4027602783214545`*^9, 
   3.4027602788995795`*^9}, {3.419250179453125*^9, 3.419250242296875*^9}, {
   3.41925036065625*^9, 3.419250388953125*^9}, {3.419250473734375*^9, 
   3.419250482203125*^9}, {3.419250517296875*^9, 3.41925055846875*^9}, {
   3.419250596734375*^9, 3.419250600640625*^9}, {3.41925131540625*^9, 
   3.419251320109375*^9}, {3.419251842578125*^9, 3.419251855484375*^9}, {
   3.419251997890625*^9, 3.4192520280625*^9}, {3.419252476546875*^9, 
   3.419252477140625*^9}, {3.41925252484375*^9, 3.419252572359375*^9}, {
   3.419252650546875*^9, 3.41925267184375*^9}, {3.4192527479375*^9, 
   3.419252779578125*^9}, {3.419252921171875*^9, 3.419252933125*^9}, {
   3.419252976609375*^9, 3.419252978703125*^9}, {3.41925304003125*^9, 
   3.419253075375*^9}, {3.419254084078125*^9, 3.419254123296875*^9}, {
   3.419254224078125*^9, 3.41925426015625*^9}, {3.41925431490625*^9, 
   3.419254321546875*^9}, {3.419254427453125*^9, 3.419254432296875*^9}, {
   3.41925454503125*^9, 3.419254545546875*^9}, {3.419255329140625*^9, 
   3.4192553789375*^9}, {3.4192568365*^9, 3.419256905625*^9}, {
   3.419257077421875*^9, 3.4192570871875*^9}, {3.4192571279375*^9, 
   3.419257151796875*^9}, {3.4192575148125*^9, 3.4192575416875*^9}, {
   3.419257873375*^9, 3.41925787421875*^9}, {3.419258005328125*^9, 
   3.41925801690625*^9}, {3.4192581338125*^9, 3.41925814528125*^9}, {
   3.419258194859375*^9, 3.419258216953125*^9}, {3.419258281140625*^9, 
   3.4192583011875*^9}, {3.41925834503125*^9, 3.419258355046875*^9}, {
   3.419258404125*^9, 3.419258456953125*^9}, {3.419258535328125*^9, 
   3.41925858840625*^9}, {3.419258692546875*^9, 3.41925872759375*^9}, {
   3.4192587789375*^9, 3.4192588708125*^9}, 3.419258906765625*^9, {
   3.41925896096875*^9, 3.41925897146875*^9}, {3.419259004921875*^9, 
   3.419259011703125*^9}, {3.419259105828125*^9, 3.41925915609375*^9}, {
   3.419259403265625*^9, 3.4192594508125*^9}, {3.41925948175*^9, 
   3.419259516984375*^9}, {3.419259570546875*^9, 3.419259681078125*^9}, {
   3.4192597175625*^9, 3.419259738234375*^9}, 3.41925977990625*^9, {
   3.419259810890625*^9, 3.419259832109375*^9}, {3.419259908234375*^9, 
   3.419260015109375*^9}, {3.41926011659375*^9, 3.41926016265625*^9}, {
   3.4192602824375*^9, 3.419260335671875*^9}, {3.41926037178125*^9, 
   3.419260392859375*^9}, {3.419260428265625*^9, 3.419260431921875*^9}, {
   3.419260481984375*^9, 3.419260485375*^9}, {3.419260547078125*^9, 
   3.419260562546875*^9}, {3.419260594*^9, 3.419260622875*^9}, {
   3.419260983671875*^9, 3.4192611381875*^9}, {3.41926119184375*^9, 
   3.41926119228125*^9}, {3.419261482796875*^9, 3.41926150178125*^9}, {
   3.419261534109375*^9, 3.419261536046875*^9}, {3.41926158078125*^9, 
   3.419261582703125*^9}, {3.419261647546875*^9, 3.41926172*^9}, {
   3.4192617635625*^9, 3.41926189221875*^9}, {3.419262146578125*^9, 
   3.41926219703125*^9}, {3.41926229078125*^9, 3.419262306296875*^9}, {
   3.419262429265625*^9, 3.419262474203125*^9}, {3.4192626479375*^9, 
   3.419262771625*^9}, {3.419263048890625*^9, 3.41926304971875*^9}, {
   3.4192630815*^9, 3.41926308715625*^9}, {3.41926312353125*^9, 
   3.41926312403125*^9}, {3.419263211*^9, 3.4192632191875*^9}, {
   3.4192632620625*^9, 3.419263313609375*^9}, {3.419263382734375*^9, 
   3.419263398*^9}, {3.419263445234375*^9, 3.41926346715625*^9}, 
   3.41926350825*^9, {3.419263738171875*^9, 3.419263811453125*^9}, {
   3.419263876703125*^9, 3.419263917671875*^9}, {3.419263954453125*^9, 
   3.41926398190625*^9}, {3.419264015515625*^9, 3.419264042*^9}, {
   3.41926409159375*^9, 3.419264098578125*^9}, {3.4192643295*^9, 
   3.4192643425*^9}, {3.4192643945*^9, 3.419264396484375*^9}, 
   3.41926444328125*^9, {3.4192644830625*^9, 3.41926448578125*^9}, {
   3.4192645296875*^9, 3.41926456484375*^9}, {3.419264604734375*^9, 
   3.41926464003125*^9}, {3.41926476184375*^9, 3.41926477609375*^9}, {
   3.41926482940625*^9, 3.419264917109375*^9}, {3.419264948328125*^9, 
   3.419264953875*^9}, {3.4192650335625*^9, 3.41926507740625*^9}, {
   3.41926541103125*^9, 3.419265500546875*^9}, {3.41926594328125*^9, 
   3.419265969421875*^9}, {3.4192660488125*^9, 3.419266083640625*^9}, {
   3.41926617590625*^9, 3.41926620153125*^9}, {3.419266363125*^9, 
   3.41926640234375*^9}, {3.419266440578125*^9, 3.419266445296875*^9}, {
   3.4192665678125*^9, 3.41926659453125*^9}, {3.4192666293125*^9, 
   3.41926666325*^9}, {3.4192667424375*^9, 3.419266771203125*^9}, {
   3.4192668306875*^9, 3.4192669224375*^9}, {3.41926695428125*^9, 
   3.419267053015625*^9}, {3.419267376359375*^9, 3.41926740284375*^9}, {
   3.419267448296875*^9, 3.419267564390625*^9}, {3.41926797465625*^9, 
   3.4192679865625*^9}, {3.419268033515625*^9, 3.41926803421875*^9}, {
   3.41926811959375*^9, 3.419268159671875*^9}, {3.419268294921875*^9, 
   3.4192683039375*^9}, {3.419268403078125*^9, 3.41926841159375*^9}, {
   3.419268456640625*^9, 3.419268467109375*^9}, {3.4192685553125*^9, 
   3.419268588078125*^9}, {3.41926865278125*^9, 3.419268663734375*^9}, {
   3.41926879884375*^9, 3.419268803015625*^9}, {3.41926885790625*^9, 
   3.41926886325*^9}, 3.419268893828125*^9, {3.419269180515625*^9, 
   3.4192692874375*^9}, 3.419269317484375*^9, {3.41926949975*^9, 
   3.419269547515625*^9}, {3.41926988103125*^9, 3.419269944859375*^9}, 
   3.4192699835625*^9, {3.419270055828125*^9, 3.419270089296875*^9}, {
   3.419270481765625*^9, 3.41927048809375*^9}, {3.419270549484375*^9, 
   3.41927056003125*^9}, {3.4192706224375*^9, 3.419270626953125*^9}, {
   3.419270669109375*^9, 3.419270670484375*^9}, {3.41927075253125*^9, 
   3.41927092875*^9}, {3.41927097725*^9, 3.419271107546875*^9}, {
   3.419271137953125*^9, 3.419271139171875*^9}, {3.419271205203125*^9, 
   3.419271206*^9}, {3.41927139559375*^9, 3.41927139746875*^9}, {
   3.4192714689375*^9, 3.41927147009375*^9}, {3.41927158671875*^9, 
   3.419271607296875*^9}, {3.419271702859375*^9, 3.41927174484375*^9}, {
   3.4192719274375*^9, 3.419271979359375*^9}, {3.419272128359375*^9, 
   3.419272204328125*^9}, {3.419272280515625*^9, 3.419272315703125*^9}, {
   3.41927240659375*^9, 3.419272479734375*^9}, {3.41927255603125*^9, 
   3.419272567296875*^9}, {3.419274436203125*^9, 3.419274495875*^9}, {
   3.41927453853125*^9, 3.419274569*^9}, {3.419274634265625*^9, 
   3.419274656390625*^9}, {3.4192747183125*^9, 3.419274737125*^9}, {
   3.419274820875*^9, 3.4192748285625*^9}, {3.41927490515625*^9, 
   3.419274985703125*^9}, {3.419275084859375*^9, 3.419275093*^9}, {
   3.419275173203125*^9, 3.419275177640625*^9}, {3.419275211828125*^9, 
   3.419275212890625*^9}, {3.419275299625*^9, 3.419275395484375*^9}, 
   3.419275448265625*^9, {3.41927548140625*^9, 3.419275568984375*^9}, {
   3.419275609875*^9, 3.4192756106875*^9}, {3.41927565909375*^9, 
   3.41927567071875*^9}, {3.41927570365625*^9, 3.419275708453125*^9}, {
   3.419275955203125*^9, 3.419275958296875*^9}, {3.41927601971875*^9, 
   3.419276123390625*^9}, {3.4192762789375*^9, 3.419276330625*^9}, {
   3.41927639021875*^9, 3.419276396734375*^9}, {3.419276439375*^9, 
   3.41927645484375*^9}, {3.41927662728125*^9, 3.419276672234375*^9}, {
   3.419302957296875*^9, 3.4193030063125*^9}, {3.41930304434375*^9, 
   3.4193030563125*^9}, {3.419303116578125*^9, 3.41930311990625*^9}, {
   3.419303234421875*^9, 3.419303349609375*^9}, {3.419303389625*^9, 
   3.419303416125*^9}, {3.41930421009375*^9, 3.41930422140625*^9}, 
   3.41930455884375*^9, 3.419304625828125*^9, {3.41930480875*^9, 
   3.41930487603125*^9}, {3.419305033984375*^9, 3.419305036234375*^9}, 
   3.41930511546875*^9, {3.419305246046875*^9, 3.419305450203125*^9}, {
   3.419305672609375*^9, 3.4193056858125*^9}, {3.419305853578125*^9, 
   3.41930586434375*^9}, {3.4193062714375*^9, 3.419306271890625*^9}, {
   3.419306348515625*^9, 3.4193064105*^9}, {3.419306475578125*^9, 
   3.419306627703125*^9}, {3.4193066800625*^9, 3.419306689109375*^9}, {
   3.419307104046875*^9, 3.4193071411875*^9}, {3.41930717178125*^9, 
   3.419307260859375*^9}, {3.41930745421875*^9, 3.419307459484375*^9}, {
   3.419307498859375*^9, 3.419307500984375*^9}, {3.41930774790625*^9, 
   3.419307766234375*^9}, {3.419307812125*^9, 3.41930786321875*^9}, {
   3.419309116453125*^9, 3.419309164046875*^9}, 3.419309217875*^9, {
   3.419309292953125*^9, 3.419309325796875*^9}, {3.419309405171875*^9, 
   3.419309448375*^9}, {3.419309982828125*^9, 3.41931001778125*^9}, {
   3.419310317375*^9, 3.41931036553125*^9}, {3.41931067215625*^9, 
   3.419310716328125*^9}, {3.41931080009375*^9, 3.419310800765625*^9}, {
   3.41931088628125*^9, 3.41931088890625*^9}, 3.4193109378125*^9, {
   3.41931133765625*^9, 3.419311338359375*^9}, {3.41931146059375*^9, 
   3.419311473421875*^9}, {3.419311604640625*^9, 3.4193116211875*^9}, {
   3.41931479734375*^9, 3.41931491553125*^9}, {3.419315805109375*^9, 
   3.4193158674375*^9}, {3.419315910796875*^9, 3.419315913609375*^9}, {
   3.4193159704375*^9, 3.419316035859375*^9}, {3.41931607675*^9, 
   3.419316077484375*^9}, {3.419316316375*^9, 3.419316357765625*^9}, 
   3.41931640528125*^9, {3.419316440265625*^9, 3.419316444796875*^9}, {
   3.4193165103125*^9, 3.419316550125*^9}, {3.419317249859375*^9, 
   3.41931727603125*^9}, {3.41931732290625*^9, 3.41931733803125*^9}, {
   3.41931762321875*^9, 3.419317625171875*^9}, {3.419318248625*^9, 
   3.41931825190625*^9}, {3.4193185404375*^9, 3.419318544015625*^9}, {
   3.419318593484375*^9, 3.41931859603125*^9}, {3.419319228578125*^9, 
   3.4193193593125*^9}, {3.4193193990625*^9, 3.419319705203125*^9}, {
   3.4193197395*^9, 3.419319792671875*^9}, {3.419320044328125*^9, 
   3.419320106953125*^9}, 3.41932022428125*^9, {3.419320685265625*^9, 
   3.41932068803125*^9}, {3.41932072809375*^9, 3.4193207704375*^9}, {
   3.419320849578125*^9, 3.41932089528125*^9}, {3.419320957171875*^9, 
   3.419320985703125*^9}, {3.419321265734375*^9, 3.41932129215625*^9}, {
   3.419321325875*^9, 3.419321369734375*^9}, {3.41932146725*^9, 
   3.419321584765625*^9}, 3.419321786421875*^9, {3.419321952328125*^9, 
   3.41932200978125*^9}, {3.419322062*^9, 3.4193220630625*^9}, 
   3.4193220991875*^9, {3.419322177140625*^9, 3.419322208*^9}, {
   3.4193223281875*^9, 3.4193223476875*^9}, {3.419322392609375*^9, 
   3.4193223940625*^9}, {3.419322587078125*^9, 3.419322589671875*^9}, {
   3.41932262484375*^9, 3.419322648390625*^9}, {3.419322736609375*^9, 
   3.419322758453125*^9}, {3.41932281309375*^9, 3.419322838*^9}, {
   3.419322898546875*^9, 3.41932291121875*^9}, {3.419323067140625*^9, 
   3.419323069796875*^9}, 3.41932311240625*^9, {3.419323603046875*^9, 
   3.419323604265625*^9}, {3.4193236359375*^9, 3.419323640109375*^9}, {
   3.419323744125*^9, 3.419323745578125*^9}, {3.419323933328125*^9, 
   3.419324079203125*^9}, {3.419324193234375*^9, 3.419324233671875*^9}, {
   3.41932427325*^9, 3.419324291203125*^9}, {3.419324764*^9, 
   3.419324777109375*^9}, {3.419324819015625*^9, 3.4193248198125*^9}, {
   3.419325167921875*^9, 3.41932521109375*^9}, {3.41932524475*^9, 
   3.4193253003125*^9}, {3.419326326125*^9, 3.419326355828125*^9}, {
   3.419326389671875*^9, 3.419326405890625*^9}, {3.41932652878125*^9, 
   3.419326541421875*^9}, {3.419326850890625*^9, 3.41932687846875*^9}, {
   3.419327115953125*^9, 3.419327119109375*^9}, {3.4193273325*^9, 
   3.419327338703125*^9}, {3.419327376515625*^9, 3.41932746234375*^9}, {
   3.419327626828125*^9, 3.419327657421875*^9}, {3.4193282766875*^9, 
   3.419328302578125*^9}, {3.41932840865625*^9, 3.419328409359375*^9}, {
   3.41932845834375*^9, 3.419328485890625*^9}, {3.419328519953125*^9, 
   3.419328524859375*^9}, {3.41932865371875*^9, 3.41932867425*^9}, {
   3.419328784609375*^9, 3.419328929625*^9}, {3.41932913153125*^9, 
   3.419329283328125*^9}, {3.419329324578125*^9, 3.419329373015625*^9}, {
   3.419329450609375*^9, 3.419329496515625*^9}, {3.419329547546875*^9, 
   3.41932965478125*^9}, {3.419329759125*^9, 3.419329824953125*^9}, {
   3.41933032190625*^9, 3.419330407171875*^9}, {3.41933044978125*^9, 
   3.419330520625*^9}, {3.419330602890625*^9, 3.4193306284375*^9}, {
   3.419330701*^9, 3.4193307195*^9}, {3.419330775828125*^9, 
   3.419330790125*^9}, 3.419330823609375*^9, {3.419331019734375*^9, 
   3.419331034625*^9}, {3.41933107059375*^9, 3.419331110015625*^9}, {
   3.41933125946875*^9, 3.41933155475*^9}, {3.4193315960625*^9, 
   3.4193315974375*^9}, {3.419332859421875*^9, 3.419332861375*^9}, {
   3.41933295534375*^9, 3.4193330018125*^9}, {3.419333160734375*^9, 
   3.419333163*^9}, {3.419333225828125*^9, 3.419333229828125*^9}, {
   3.419333260546875*^9, 3.419333290859375*^9}, {3.4193347253125*^9, 
   3.41933473528125*^9}, 3.419334814703125*^9, {3.41933486046875*^9, 
   3.4193348620625*^9}, {3.419334911828125*^9, 3.419334914796875*^9}, {
   3.4193413419375*^9, 3.41934134396875*^9}, {3.419341516515625*^9, 
   3.419341519578125*^9}, {3.41934750378125*^9, 3.41934756990625*^9}, {
   3.419347606328125*^9, 3.419347612203125*^9}, {3.419347665109375*^9, 
   3.419347676765625*^9}, {3.419349116046875*^9, 3.419349119140625*^9}, {
   3.419349275828125*^9, 3.41934929853125*^9}, {3.419349405125*^9, 
   3.419349431859375*^9}, {3.419349537703125*^9, 3.419349545953125*^9}, {
   3.4193495879375*^9, 3.41934961865625*^9}, 3.419350495859375*^9, 
   3.41935064796875*^9, {3.41935075540625*^9, 3.41935077571875*^9}, {
   3.41935131221875*^9, 3.419351323015625*^9}, {3.41935140865625*^9, 
   3.419351409421875*^9}, {3.41935163965625*^9, 3.41935165721875*^9}, {
   3.41935176021875*^9, 3.419351795859375*^9}, {3.419352040078125*^9, 
   3.41935204325*^9}, {3.4193521229375*^9, 3.41935214821875*^9}, {
   3.41935218*^9, 3.419352181515625*^9}, 3.419352269984375*^9, {
   3.419352386484375*^9, 3.419352403125*^9}, {3.419352511203125*^9, 
   3.419352517046875*^9}, {3.419352587203125*^9, 3.41935262509375*^9}, {
   3.419352706328125*^9, 3.4193527081875*^9}, 3.419352745203125*^9, {
   3.41935282284375*^9, 3.41935289603125*^9}, 3.41935337796875*^9, {
   3.41935391796875*^9, 3.419353928625*^9}, {3.419354087703125*^9, 
   3.419354099578125*^9}, {3.41935420078125*^9, 3.4193542139375*^9}, {
   3.419354282203125*^9, 3.419354308140625*^9}, {3.419354340703125*^9, 
   3.41935434740625*^9}, {3.4193545188125*^9, 3.419354540640625*^9}, {
   3.419354616359375*^9, 3.419354621640625*^9}, 3.419354917375*^9, {
   3.4193549844375*^9, 3.41935498515625*^9}, {3.419355074625*^9, 
   3.419355099890625*^9}, {3.41935514415625*^9, 3.41935514603125*^9}, {
   3.419355275421875*^9, 3.4193552761875*^9}, {3.41935545434375*^9, 
   3.41935547271875*^9}, {3.419355585078125*^9, 3.419355635859375*^9}, {
   3.419356124421875*^9, 3.4193562255625*^9}, {3.41935626209375*^9, 
   3.41935628021875*^9}, {3.41935639959375*^9, 3.419356425625*^9}, {
   3.419356591609375*^9, 3.419356677265625*^9}, {3.419356791984375*^9, 
   3.419356841421875*^9}, {3.419356876859375*^9, 3.4193569118125*^9}, {
   3.419357013453125*^9, 3.419357107578125*^9}, {3.4193573375*^9, 
   3.419357411078125*^9}, {3.41935753871875*^9, 3.419357539328125*^9}, {
   3.41935757475*^9, 3.419357584765625*^9}, {3.41935763009375*^9, 
   3.419357667921875*^9}, {3.419357698375*^9, 3.419357772171875*^9}, {
   3.419357892296875*^9, 3.419357903765625*^9}, {3.4193579779375*^9, 
   3.419357978484375*^9}, {3.4193580201875*^9, 3.41935805253125*^9}, {
   3.41935813575*^9, 3.419358147734375*^9}, {3.4193582795*^9, 
   3.419358309046875*^9}, 3.41935837228125*^9, 3.4193584653125*^9, {
   3.419358514703125*^9, 3.419358514953125*^9}, {3.419358646703125*^9, 
   3.419358650140625*^9}, 3.419358730328125*^9, {3.419358882421875*^9, 
   3.419358904*^9}, {3.41935901959375*^9, 3.419359052234375*^9}, {
   3.4193591173125*^9, 3.41935915571875*^9}, 3.419359315828125*^9, {
   3.4193593536875*^9, 3.419359383328125*^9}, {3.4193594431875*^9, 
   3.4193594455625*^9}, {3.4193594980625*^9, 3.4193595375625*^9}, {
   3.419359766640625*^9, 3.41935982428125*^9}, 3.43314702465625*^9, {
   3.4437909335454063`*^9, 3.443790941486826*^9}, {3.4437910962193203`*^9, 
   3.4437911196630306`*^9}, {3.4437911750426626`*^9, 3.443791175913915*^9}, {
   3.4437912399059315`*^9, 3.443791252714349*^9}, {3.4437916227364144`*^9, 
   3.4437916400112543`*^9}, {3.4437916769243326`*^9, 
   3.4437917327145553`*^9}, {3.4437920340979233`*^9, 
   3.4437920391752243`*^9}, {3.4437921367855806`*^9, 3.443792140050275*^9}, {
   3.443792245051259*^9, 3.443792268084379*^9}, {3.443792312237869*^9, 
   3.4437923565616035`*^9}, 3.4437924259814243`*^9, {3.4437924801392994`*^9, 
   3.443792482162208*^9}, {3.4437925264859424`*^9, 3.44379253369631*^9}, {
   3.443792647079347*^9, 3.4437926682397747`*^9}, {3.4437927352361107`*^9, 
   3.44379276612052*^9}, {3.443792806849085*^9, 3.4437928381040273`*^9}, {
   3.443792892482219*^9, 3.44379291123919*^9}, 3.443792952258173*^9, {
   3.443793065470965*^9, 3.4437930844883103`*^9}, {3.443793164162877*^9, 
   3.4437932139745026`*^9}, {3.443793295952381*^9, 3.4437933140784445`*^9}, {
   3.4437941449231405`*^9, 3.4437941491492176`*^9}, {3.44379452715276*^9, 
   3.4437945294160147`*^9}, 3.443794658892192*^9, {3.4437949305428066`*^9, 
   3.443794967215539*^9}, {3.4437950484122944`*^9, 3.443795052938803*^9}, {
   3.4437951467937603`*^9, 3.443795150579203*^9}, {3.4437951987084093`*^9, 
   3.443795230414*^9}, {3.4437952679279423`*^9, 3.443795271442997*^9}, {
   3.443795322376235*^9, 3.443795332360592*^9}, {3.44379543912411*^9, 
   3.443795445523312*^9}, {3.4437955376257486`*^9, 3.4437955791855087`*^9}, {
   3.4437956132244544`*^9, 3.443795657908707*^9}, {3.4437956972252417`*^9, 
   3.443795764031304*^9}, {3.443795795606707*^9, 3.4437958376271296`*^9}, {
   3.443795942037264*^9, 3.4437959752850723`*^9}, {3.4437961336227503`*^9, 
   3.4437961997678623`*^9}, 3.443796412513776*^9, {3.4437965059982*^9, 
   3.443796507179899*^9}, {3.4437965704308496`*^9, 3.4437965900791025`*^9}, 
   3.4437966342125635`*^9, 3.4437966744003506`*^9, {3.4437967726416144`*^9, 
   3.443796840118642*^9}, {3.4437970713010654`*^9, 3.4437970962369213`*^9}, {
   3.4437972744231405`*^9, 3.443797293931192*^9}, {3.443797399883544*^9, 
   3.4437974690930624`*^9}, {3.443797572231368*^9, 3.443797615012885*^9}, {
   3.443797678133648*^9, 3.4437976902911296`*^9}, {3.4437979839333663`*^9, 
   3.4437979852452526`*^9}, {3.4437980619455423`*^9, 
   3.4437981461165743`*^9}, {3.443798221565064*^9, 3.4437982281345105`*^9}, {
   3.443798270545494*^9, 3.4437982868389235`*^9}, {3.443798352303056*^9, 
   3.4437983642302065`*^9}, {3.4437985679231024`*^9, 
   3.4437986171538925`*^9}, {3.4438004365901136`*^9, 3.443800496055621*^9}, {
   3.443800573406846*^9, 3.4438005830306845`*^9}, {3.4438006442286835`*^9, 
   3.443800698176256*^9}, {3.443800769679072*^9, 3.443800781095488*^9}, {
   3.4438021796965775`*^9, 3.4438021921344624`*^9}, {3.4438022786088066`*^9, 
   3.4438022833656464`*^9}, {3.4438023592347407`*^9, 
   3.4438024539008636`*^9}, {3.443802630655024*^9, 3.4438026864552608`*^9}, 
   3.4438027171994686`*^9, 3.443802818835614*^9, 3.443802969762637*^9, {
   3.4438030210964513`*^9, 3.4438030225084815`*^9}, {3.4438030873617363`*^9, 
   3.4438031087324657`*^9}, {3.443803161598483*^9, 3.4438032030180416`*^9}, {
   3.443803249064253*^9, 3.443803258197386*^9}, 3.443803291074661*^9, {
   3.4438034207511263`*^9, 3.4438034622207565`*^9}, {3.4438036616775618`*^9, 
   3.443803665112501*^9}, {3.4438037250386705`*^9, 3.443803866151581*^9}, {
   3.4438039184267488`*^9, 3.4438039187271805`*^9}, {3.4438039757191315`*^9, 
   3.443803987516094*^9}, {3.443804110633128*^9, 3.4438041347077456`*^9}, {
   3.4438041835079165`*^9, 3.443804234541299*^9}, {3.4438043849175296`*^9, 
   3.4438043938603888`*^9}, {3.4438044634804974`*^9, 
   3.4438044676765313`*^9}, {3.443804505460862*^9, 3.443804506272029*^9}, {
   3.443804593106891*^9, 3.4438045953901744`*^9}, {3.4438048109000626`*^9, 
   3.443804833943197*^9}, {3.4438049294204865`*^9, 3.4438049421888466`*^9}, {
   3.4438050123297043`*^9, 3.4438050311968336`*^9}, {3.4438050745291424`*^9, 
   3.4438051024693184`*^9}, {3.4438051396327567`*^9, 3.443805274757056*^9}, {
   3.4438053255901504`*^9, 3.4438054697774816`*^9}, {3.443805760004808*^9, 
   3.4438057895873456`*^9}, {3.4438058313774366`*^9, 
   3.4438058627926097`*^9}, {3.4438059183024287`*^9, 
   3.4438059456918125`*^9}, {3.443806165307605*^9, 3.443806357744315*^9}, {
   3.4438065057571473`*^9, 3.4438065313439393`*^9}, {3.4438065677262545`*^9, 
   3.4438065849309936`*^9}, {3.4438066374264784`*^9, 
   3.4438066532492304`*^9}, {3.443806794111781*^9, 3.4438068258374*^9}, {
   3.4438068620995426`*^9, 3.443806882408746*^9}, {3.4438070317735214`*^9, 
   3.4438070379524064`*^9}, {3.4438070766680765`*^9, 
   3.4438070833476815`*^9}, {3.4438071463582864`*^9, 
   3.4438071790853453`*^9}, {3.443807212793816*^9, 3.443807216599288*^9}, {
   3.443807290084955*^9, 3.443807298156562*^9}, {3.4438074184695635`*^9, 
   3.4438074274324512`*^9}, {3.4438074657675743`*^9, 3.4438074728076973`*^9}, 
   3.443807796503149*^9, {3.44380784805728*^9, 3.443807852343443*^9}, {
   3.4438078873638*^9, 3.4438080052633314`*^9}, {3.4438080461721554`*^9, 
   3.4438080647388525`*^9}, {3.443808160466502*^9, 3.443808166364984*^9}, {
   3.443808210728776*^9, 3.443808216066451*^9}, {3.4438082690426273`*^9, 
   3.4438082797680497`*^9}, {3.4438083136567793`*^9, 3.443808314047341*^9}, {
   3.4438083888148513`*^9, 3.4438084371643744`*^9}, {3.4438084790445952`*^9, 
   3.443808585597811*^9}, {3.443808803140622*^9, 3.443808803531184*^9}, {
   3.443808924254776*^9, 3.443808980465603*^9}, {3.4438090599599104`*^9, 
   3.4438090635150223`*^9}, {3.443847313203125*^9, 3.443847339484375*^9}, {
   3.4438473815*^9, 3.443847409*^9}, {3.443847506296875*^9, 
   3.443847528375*^9}, {3.443847566890625*^9, 3.4438475950625*^9}, {
   3.443847636578125*^9, 3.443847747703125*^9}, {3.44384778253125*^9, 
   3.443847838484375*^9}, {3.443847871390625*^9, 3.4438478955625*^9}, {
   3.443847936953125*^9, 3.4438479938125*^9}, {3.4438529555906096`*^9, 
   3.4438530196026545`*^9}, {3.4438530496558685`*^9, 3.443853119135776*^9}, {
   3.443853244936669*^9, 3.443853510718845*^9}, {3.4438535843847713`*^9, 
   3.443853596772584*^9}, {3.443853660734557*^9, 3.4438538669210386`*^9}, {
   3.4438539050458593`*^9, 3.44385400084361*^9}, {3.443854108778813*^9, 
   3.4438541113224707`*^9}, {3.443854149937997*^9, 3.443854154023872*^9}, {
   3.4438547547176275`*^9, 3.4438548011844435`*^9}, {3.4438548491934767`*^9, 
   3.4438549047333393`*^9}, {3.443855038045032*^9, 3.4438551217754307`*^9}, {
   3.4438552067776575`*^9, 3.4438552534647903`*^9}, {3.4438553890397377`*^9, 
   3.4438554546641006`*^9}, {3.443855487521347*^9, 3.4438554891236515`*^9}, {
   3.443855620853069*^9, 3.4438557065062323`*^9}, {3.4438560150899534`*^9, 
   3.443856020377557*^9}, {3.44385611829836*^9, 3.4438561197404337`*^9}, {
   3.443856164935421*^9, 3.443856169792405*^9}, {3.443961375734375*^9, 
   3.4439614063125*^9}, {3.4439619148125*^9, 3.44396199325*^9}, {
   3.44396202378125*^9, 3.4439621648125*^9}, {3.443962204015625*^9, 
   3.4439624286875*^9}, 3.443962492359375*^9, 3.443962553421875*^9, {
   3.443962618078125*^9, 3.4439626275625*^9}, {3.4439626784375*^9, 
   3.4439627189375*^9}, 3.4439627966875*^9, {3.4439641298125*^9, 
   3.443964132671875*^9}, {3.44396421709375*^9, 3.44396422728125*^9}, {
   3.443964292609375*^9, 3.443964354265625*^9}, 3.4440563267364883`*^9, {
   3.444056457514538*^9, 3.4440565052231393`*^9}, {3.4440565810321474`*^9, 
   3.444056599698989*^9}, {3.444056711619923*^9, 3.4440567554629664`*^9}, {
   3.4440567883402414`*^9, 3.444056820596624*^9}, {3.444056874674384*^9, 
   3.44405688784332*^9}, {3.4440569502430463`*^9, 3.44405695719304*^9}, {
   3.4440570223467264`*^9, 3.444057038379781*^9}, {3.4440571138883567`*^9, 
   3.4440571682965918`*^9}, {3.444058316417509*^9, 3.444058349074467*^9}, {
   3.444058415339752*^9, 3.4440584726321344`*^9}, {3.4440585634627423`*^9, 
   3.44405856441411*^9}, {3.444058626423275*^9, 3.4440586394720383`*^9}, {
   3.4440586939804173`*^9, 3.444058694270835*^9}, {3.44405873725264*^9, 
   3.444058801625203*^9}, {3.4440589311814957`*^9, 3.44405893378524*^9}, {
   3.4440591189915533`*^9, 3.4440591621235743`*^9}, {3.444059202842125*^9, 
   3.444059243280272*^9}, {3.444059277809923*^9, 3.444059279131824*^9}, {
   3.444059309395341*^9, 3.444059309996205*^9}, {3.444059540527693*^9, 
   3.4440595586737857`*^9}, {3.444059657175424*^9, 3.444059659278448*^9}, {
   3.444059860637989*^9, 3.444059875178898*^9}, {3.444060100312624*^9, 
   3.4440601153943105`*^9}, 3.4440602894746256`*^9, {3.4440603466067777`*^9, 
   3.4440603498213997`*^9}, {3.44406040314808*^9, 3.444060406122357*^9}, {
   3.4440604754921055`*^9, 3.4440604759227247`*^9}, 3.4440621979288483`*^9, {
   3.444063363024173*^9, 3.4440634315126543`*^9}, 3.4440634662526083`*^9, 
   3.444063499890978*^9, {3.444063556662611*^9, 3.444063612112344*^9}, 
   3.4440637913600893`*^9, {3.444063894778798*^9, 3.4440639335645695`*^9}, {
   3.4440639652701597`*^9, 3.444063969255891*^9}, {3.4440640681280622`*^9, 
   3.444064074407091*^9}, {3.444064108155619*^9, 3.4440641094274483`*^9}, {
   3.4440641665495853`*^9, 3.4440641889718275`*^9}, {3.4441318810515857`*^9, 
   3.444131904675555*^9}, {3.4441323017064576`*^9, 3.4441323030984592`*^9}, {
   3.444133565303421*^9, 3.444133610398264*^9}, {3.4441338057091074`*^9, 
   3.4441338312057695`*^9}, {3.444133985067011*^9, 3.4441339884018064`*^9}, {
   3.444135023149701*^9, 3.4441350397235327`*^9}, {3.444135086640997*^9, 
   3.444135225060034*^9}, {3.4441353159607425`*^9, 3.4441353268864527`*^9}, 
   3.4441353881645665`*^9, {3.444135453218109*^9, 3.444135557468013*^9}, {
   3.4441356034441233`*^9, 3.4441356500311117`*^9}, 3.44413583975392*^9, {
   3.4441358733422174`*^9, 3.444135895383912*^9}, {3.4441359282712016`*^9, 
   3.444135932417163*^9}, {3.444135990520712*^9, 3.4441359907911005`*^9}, {
   3.444136034413827*^9, 3.444136034934576*^9}, {3.44413607643425*^9, 
   3.4441362565131903`*^9}, {3.4441363022789984`*^9, 
   3.4441363072861986`*^9}, {3.444136446957035*^9, 3.4441364530057325`*^9}, {
   3.4441366255137873`*^9, 3.4441366824356365`*^9}, {3.444136857937997*^9, 
   3.444136879949648*^9}, {3.44413693808324*^9, 3.4441369580018816`*^9}, {
   3.4441371044624815`*^9, 3.4441371530623646`*^9}, {3.4441372259671965`*^9, 
   3.444137240788509*^9}, {3.4441372929134607`*^9, 3.4441374188044834`*^9}, {
   3.4441374593127313`*^9, 3.444137463098174*^9}, {3.4441375298241215`*^9, 
   3.444137668062899*^9}, {3.444137718174957*^9, 3.4441377439920797`*^9}, {
   3.4441377807549424`*^9, 3.4441377870840435`*^9}, {3.4441378253991375`*^9, 
   3.444137902099427*^9}, {3.444138031545562*^9, 3.4441380349504576`*^9}, {
   3.444141901600427*^9, 3.4441419242630143`*^9}, {3.4441421943013105`*^9, 
   3.444142197085314*^9}, {3.444142503095334*^9, 3.4441425070009503`*^9}, {
   3.4441425769014626`*^9, 3.4441425952478433`*^9}, 3.444142778781752*^9, {
   3.444142883402189*^9, 3.4441430599260178`*^9}, {3.444143232033496*^9, 
   3.4441432333754253`*^9}, {3.4441434268836765`*^9, 
   3.4441434325918846`*^9}, {3.4441435014408846`*^9, 
   3.4441435049158816`*^9}, {3.444143711723256*^9, 3.444143719384272*^9}, {
   3.444143768585019*^9, 3.4441437704977694`*^9}, {3.444143822802981*^9, 
   3.4441438244152994`*^9}, 3.4441439176293344`*^9, 3.444144058251539*^9, {
   3.444144129704283*^9, 3.4441441392480063`*^9}, {3.444144176591704*^9, 
   3.4441441964402447`*^9}, 3.444144254233347*^9, 3.4441448038336334`*^9, {
   3.4441450055436783`*^9, 3.444145022007352*^9}, 3.4441450612938433`*^9, {
   3.4441451324060974`*^9, 3.444145143281736*^9}, {3.444145209176488*^9, 
   3.444145249234088*^9}, {3.444145300708104*^9, 3.444145325313485*^9}, {
   3.444145633055997*^9, 3.4441456734540863`*^9}, {3.4441457481815395`*^9, 
   3.4441457965811343`*^9}, {3.444145835917698*^9, 3.4441458365986767`*^9}, {
   3.4441459741464605`*^9, 3.444145978823186*^9}, {3.444146035795107*^9, 
   3.444146184528976*^9}, {3.444146224336216*^9, 3.4441462467584577`*^9}, {
   3.444146279735877*^9, 3.444146280537029*^9}, 3.444146430883216*^9, {
   3.4441465595281982`*^9, 3.4441466063955903`*^9}, {3.4441467276499453`*^9, 
   3.444146777181168*^9}, {3.444146846661075*^9, 3.4441468653479457`*^9}, {
   3.4441469208577647`*^9, 3.4441469276475277`*^9}, {3.444147003005888*^9, 
   3.4441471207451887`*^9}, {3.4441472693488703`*^9, 
   3.4441474905369234`*^9}, {3.444147532036597*^9, 3.444147558043994*^9}, {
   3.4441475913819313`*^9, 3.444147672989277*^9}, {3.444147705325774*^9, 
   3.444147719826626*^9}, {3.4441477520930223`*^9, 3.4441477592332897`*^9}, {
   3.444148051233165*^9, 3.444148075427955*^9}, {3.4441482736730175`*^9, 
   3.4441483041468368`*^9}, {3.444148360708168*^9, 3.4441483748885584`*^9}, {
   3.4441484130033646`*^9, 3.444148692805701*^9}, {3.4441488521648483`*^9, 
   3.4441488622693777`*^9}, {3.4441489086560783`*^9, 3.444148909667533*^9}, 
   3.4441489536407633`*^9, {3.4441489870488014`*^9, 3.444148987359248*^9}, {
   3.444149206404219*^9, 3.444149241624864*^9}, {3.4441493461752*^9, 
   3.444149350661651*^9}, {3.444149534886554*^9, 3.4441495785693665`*^9}, {
   3.4441496152921715`*^9, 3.444149711320253*^9}, {3.444149800478456*^9, 
   3.444149803933424*^9}, {3.444149870909731*^9, 3.444149874044238*^9}, {
   3.444150053742632*^9, 3.444150068433757*^9}, {3.444150237486843*^9, 
   3.4441502757017937`*^9}, {3.444150372601128*^9, 3.4441503801019135`*^9}, {
   3.4441504585346947`*^9, 3.444150469620635*^9}, {3.4441511529932766`*^9, 
   3.444151157579872*^9}, {3.44423000977489*^9, 3.4442300146719313`*^9}, {
   3.4442306331412463`*^9, 3.444230639410261*^9}, 3.4442306740500703`*^9, 
   3.4442309302484655`*^9, {3.44423120966024*^9, 3.4442312568781357`*^9}, {
   3.444231348459824*^9, 3.4442313818778768`*^9}, 3.4442318801743917`*^9, {
   3.44423201707124*^9, 3.4442320492875648`*^9}, {3.4442321138203583`*^9, 
   3.4442322000844*^9}, 3.4442323292301025`*^9, {3.444232390478173*^9, 
   3.4442325810822477`*^9}, {3.444232800177291*^9, 3.444232897817691*^9}, {
   3.444232964763955*^9, 3.4442330254912767`*^9}, {3.44423387958941*^9, 
   3.444234013111405*^9}, {3.4442340611004095`*^9, 3.444234062201994*^9}, 
   3.444234113105189*^9, {3.444234178078616*^9, 3.44423426630548*^9}, {
   3.4462249759595137`*^9, 3.446224977651947*^9}, {3.4465643584691086`*^9, 
   3.446564361813918*^9}, {3.44656453395144*^9, 3.446564535073053*^9}, {
   3.446564594969179*^9, 3.446564645331597*^9}, {3.4465646769971294`*^9, 
   3.446564726608467*^9}, {3.4465647588548355`*^9, 3.4465647696203156`*^9}, {
   3.4465648214248066`*^9, 3.446564914318381*^9}, {3.4465649706894383`*^9, 
   3.4465650709936686`*^9}, {3.446565112383184*^9, 3.446565149616723*^9}, {
   3.4465651898145247`*^9, 3.4465651992280607`*^9}, {3.4465652367820606`*^9, 
   3.446565364425603*^9}, {3.4465654043430014`*^9, 3.4465654141871567`*^9}, {
   3.446565445912776*^9, 3.4465654902965965`*^9}, {3.446565523824808*^9, 
   3.4465655299235773`*^9}, {3.4465655952575235`*^9, 
   3.4465656440576944`*^9}, {3.4465656799292755`*^9, 3.446565696523136*^9}, {
   3.4465659519404078`*^9, 3.446566043091477*^9}, {3.446566090739992*^9, 
   3.4465660926126847`*^9}, {3.4465661452984433`*^9, 3.446566166328683*^9}, {
   3.4465662674140368`*^9, 3.4465663382559023`*^9}, {3.4465664948010035`*^9, 
   3.446566497144373*^9}, {3.4465665504910817`*^9, 3.4465665557185984`*^9}, {
   3.4465666218236527`*^9, 3.44656664582817*^9}, {3.4465667141964784`*^9, 
   3.4465667191736355`*^9}, {3.4465667922386975`*^9, 3.446566851403773*^9}, 
   3.4465668955172048`*^9, 3.4465669432057776`*^9, {3.4465670013293552`*^9, 
   3.446567066863589*^9}, {3.4465671408099184`*^9, 3.4465671644939747`*^9}, {
   3.4465672191024976`*^9, 3.446567260381854*^9}, 3.4465673462252913`*^9, {
   3.446567380073963*^9, 3.446567384880875*^9}, {3.4465679585057073`*^9, 
   3.446567988769224*^9}, {3.4465680315206976`*^9, 3.4465680678128834`*^9}, {
   3.446568140697686*^9, 3.446568264255354*^9}, {3.4465683235606303`*^9, 
   3.446568324451912*^9}, {3.446568355656782*^9, 3.4465684429823503`*^9}, 
   3.446568624933984*^9, 3.446568665922923*^9, 3.446568703877499*^9, 
   3.4465687761714525`*^9, {3.4465688398830657`*^9, 3.446568847754384*^9}, {
   3.446568913809366*^9, 3.4465689218208866`*^9}, {3.446569042314147*^9, 
   3.446569107387718*^9}, {3.4465691549561186`*^9, 3.4465691975874195`*^9}, {
   3.4465692594363537`*^9, 3.4465693052522335`*^9}, {3.4465693465616336`*^9, 
   3.446569358218395*^9}, {3.446569411665248*^9, 3.4465694301618447`*^9}, {
   3.4465694743754206`*^9, 3.4465694930522766`*^9}, {3.446569559277504*^9, 
   3.4465695861561537`*^9}, 3.446569755109096*^9, {3.4465698568654146`*^9, 
   3.4465699534442883`*^9}, {3.4465700420817423`*^9, 
   3.4465701107604976`*^9}, {3.446570142546203*^9, 3.446570242710232*^9}, 
   3.446570328773986*^9, {3.446570388770256*^9, 3.4465704189035854`*^9}, {
   3.4465705591152*^9, 3.4465706030483727`*^9}, {3.4465707023812065`*^9, 
   3.4465707736436768`*^9}, {3.446570839308098*^9, 3.4465708425427485`*^9}, 
   3.4465709514092913`*^9, {3.4465709849274883`*^9, 3.446570987110627*^9}, {
   3.4465710222611713`*^9, 3.4465711702539744`*^9}, {3.446571278850128*^9, 
   3.446571305738792*^9}, {3.4465728323239136`*^9, 3.4465728333453827`*^9}, {
   3.4465730009063234`*^9, 3.446573022337139*^9}, {3.4465733518336864`*^9, 
   3.4465734285940623`*^9}, {3.4465746266467776`*^9, 
   3.4465746907789955`*^9}, {3.446574738277294*^9, 3.4465747387079134`*^9}, {
   3.4465748003565598`*^9, 3.446574801358*^9}, {3.4465748417761183`*^9, 
   3.4465749015120144`*^9}, {3.446574981416912*^9, 3.446574983590037*^9}, {
   3.4465750549927087`*^9, 3.4465750834536333`*^9}, {3.4465751681253853`*^9, 
   3.4465752152932096`*^9}, {3.446575310640312*^9, 3.4465753152068787`*^9}, {
   3.4465753460011587`*^9, 3.4465753479639807`*^9}, {3.4465754009301424`*^9, 
   3.4465754029730797`*^9}, {3.446575474996645*^9, 3.44657551538472*^9}, {
   3.4465755529487343`*^9, 3.4465755624924574`*^9}, {3.4465755958103666`*^9, 
   3.4465756055543776`*^9}, {3.446575658530554*^9, 3.446575665250216*^9}, {
   3.446575708742755*^9, 3.446575710014584*^9}, {3.4465757587947264`*^9, 
   3.446575776129653*^9}, 3.446652651715602*^9, {3.4466527005057583`*^9, 
   3.446652710029453*^9}, {3.4466527770858755`*^9, 3.4466527854078417`*^9}, {
   3.446652913181571*^9, 3.4466529714253216`*^9}, {3.4466530056645555`*^9, 
   3.4466530404445667`*^9}, {3.4466534710437374`*^9, 
   3.4466534871368785`*^9}, {3.446653523429064*^9, 3.446653590134982*^9}, {
   3.4466536246746483`*^9, 3.446653721443795*^9}, {3.4466537588776226`*^9, 
   3.4466537983443727`*^9}, {3.4466539099748898`*^9, 
   3.4466539889784913`*^9}, {3.446654148287566*^9, 3.446654162217597*^9}, {
   3.4466541931320496`*^9, 3.44665421022663*^9}, {3.446654313194691*^9, 
   3.4466543209758797`*^9}, {3.4466543756244607`*^9, 3.446654383936413*^9}, {
   3.4466544591345425`*^9, 3.4466544935139775`*^9}, {3.4466546603739104`*^9, 
   3.4466546736530046`*^9}, {3.4466547207407136`*^9, 3.446654877355915*^9}, {
   3.44665491082404*^9, 3.4466549160816*^9}, {3.44665504076088*^9, 
   3.446655042212968*^9}, {3.446655103781499*^9, 3.446655107506856*^9}, {
   3.4466558123303423`*^9, 3.446655825088688*^9}, {3.446655876152114*^9, 
   3.446655915188245*^9}, {3.4466559503087454`*^9, 3.4466559506993074`*^9}, {
   3.4466560172750387`*^9, 3.446656019798667*^9}, {3.4466561847959213`*^9, 
   3.4466563833814735`*^9}, {3.4466564164990945`*^9, 3.446656449827018*^9}, {
   3.446657890939235*^9, 3.446657943064187*^9}, {3.446657978465091*^9, 
   3.4466580026899247`*^9}, {3.44665837330284*^9, 3.4466584771421537`*^9}, {
   3.446658532061123*^9, 3.4466585559354525`*^9}, {3.446658601410843*^9, 
   3.4466586193666625`*^9}, 3.4466587415122995`*^9, {3.4466588106917744`*^9, 
   3.446658916503925*^9}, {3.4466589671667747`*^9, 3.4466590031384993`*^9}, {
   3.4466591481770544`*^9, 3.4466592195296545`*^9}, {3.4466593217266064`*^9, 
   3.4466593220771103`*^9}, {3.446659455599106*^9, 3.446659509386448*^9}, 
   3.446659571175296*^9, {3.4466596132858477`*^9, 3.4466596141971583`*^9}, {
   3.4466596622162066`*^9, 3.4466597145514607`*^9}, {3.446659789048582*^9, 
   3.4466597906308575`*^9}, {3.446660671056848*^9, 3.446660737732723*^9}, {
   3.446660791930656*^9, 3.446660793182456*^9}, {3.4474256068706627`*^9, 
   3.4474257720381613`*^9}, {3.44742580995268*^9, 3.44742605630692*^9}, {
   3.4474261051171055`*^9, 3.447426110334608*^9}, {3.4474261511032305`*^9, 
   3.447426348897645*^9}, {3.447426405909624*^9, 3.447426437995762*^9}, {
   3.447426472845874*^9, 3.447426493315307*^9}, {3.4474265236989965`*^9, 
   3.4474265315502863`*^9}, {3.4474266233823347`*^9, 3.447426694574704*^9}, {
   3.4474267611904926`*^9, 3.4474267850548077`*^9}, {3.4474268378407106`*^9, 
   3.4474269273494177`*^9}, {3.447427337669429*^9, 3.447427347884117*^9}, {
   3.447427409652936*^9, 3.4474274796736207`*^9}, {3.447427545718589*^9, 
   3.4474275789864254`*^9}, {3.4474276717698417`*^9, 
   3.4474277245657587`*^9}, {3.4474277573228607`*^9, 
   3.4474278016566095`*^9}, {3.4474278371877007`*^9, 
   3.4474280228246336`*^9}, {3.4474280528978767`*^9, 
   3.4474280534386544`*^9}, {3.4474281414051437`*^9, 
   3.4474281477743025`*^9}, {3.4474283586775665`*^9, 3.447428385015438*^9}, {
   3.4474284282476034`*^9, 3.4474284287282944`*^9}, {3.4474285934751887`*^9, 
   3.44742860171704*^9}, {3.4474286387603054`*^9, 3.447428716151589*^9}, {
   3.447428946522846*^9, 3.447429098721698*^9}, {3.447429133411579*^9, 
   3.4474291844249325`*^9}, {3.447432977879653*^9, 3.4474330099958334`*^9}, {
   3.4474332626591454`*^9, 3.447433444080016*^9}, {3.447433497176365*^9, 
   3.447433585082768*^9}, {3.4474336833941326`*^9, 3.447433685807603*^9}, {
   3.447433719105483*^9, 3.447433732945384*^9}, {3.4474340353502207`*^9, 
   3.447434036181416*^9}, {3.447434908816203*^9, 3.447434914504382*^9}, 
   3.4474350615958896`*^9, 3.44743511358064*^9, {3.447435191472643*^9, 
   3.4474352140651293`*^9}, {3.4474353455041294`*^9, 3.4474353931826878`*^9}, 
   3.447435534706189*^9, {3.447511158741413*^9, 3.4475111629174175`*^9}, {
   3.447511270632304*^9, 3.447511290951522*^9}, {3.4475113404727297`*^9, 
   3.447511356225381*^9}, {3.44751143417747*^9, 3.447511435249011*^9}, {
   3.447511540650571*^9, 3.4475115605091267`*^9}, {3.4475116339847794`*^9, 
   3.4475116630766115`*^9}, {3.4475117556997967`*^9, 
   3.4475117793938675`*^9}, {3.4475121416647873`*^9, 3.447512211084608*^9}, {
   3.447512469235811*^9, 3.4475125412493615`*^9}, {3.447513092471981*^9, 
   3.4475131357642317`*^9}, 3.4475131670692463`*^9, {3.44751323360492*^9, 
   3.447513237340291*^9}, {3.4475136785046544`*^9, 3.4475137001958447`*^9}, {
   3.4475137380202336`*^9, 3.4475137727501726`*^9}, {3.447513831845147*^9, 
   3.4475138389653854`*^9}, {3.4475138884565506`*^9, 3.447513894855752*^9}, {
   3.4475141549397345`*^9, 3.447514214074766*^9}, {3.447514304074179*^9, 
   3.4475144117389936`*^9}, {3.4475144488824034`*^9, 3.447514511392288*^9}, 
   3.447514606599189*^9, 3.447514689678651*^9, {3.447514811003107*^9, 
   3.447514852562867*^9}, {3.4475149290328255`*^9, 3.4475149876170654`*^9}, {
   3.4475150232483006`*^9, 3.4475150370181007`*^9}, {3.4475150768653984`*^9, 
   3.447515195956643*^9}, {3.447515520242944*^9, 3.44751560701772*^9}, {
   3.4475156765276704`*^9, 3.4475156933218193`*^9}, {3.4475157942269135`*^9, 
   3.4475157965802975`*^9}, {3.4475158487553215`*^9, 
   3.4475159979999247`*^9}, {3.447516151340418*^9, 3.4475161536637583`*^9}, {
   3.4475161930403795`*^9, 3.4475163110901265`*^9}, 3.4475163440875745`*^9, {
   3.4475164148192816`*^9, 3.4475165440050416`*^9}, {3.4475165863859825`*^9, 
   3.4475165999254513`*^9}, {3.4475166354064703`*^9, 
   3.4475168036984625`*^9}, {3.447516865256979*^9, 3.4475168687119474`*^9}, {
   3.447517021701936*^9, 3.447517134393979*^9}, {3.4475171981656785`*^9, 
   3.447517249078888*^9}, {3.447517285210843*^9, 3.447517359487648*^9}, {
   3.4475174094795327`*^9, 3.4475174213766403`*^9}, {3.4475176390296097`*^9, 
   3.447517798318656*^9}, {3.447517842672434*^9, 3.4475179054226637`*^9}, {
   3.4475180378931475`*^9, 3.4475180902384157`*^9}, {3.4475181782950354`*^9, 
   3.4475182577492847`*^9}, {3.447518303855582*^9, 3.447518304075899*^9}, {
   3.4475184616324544`*^9, 3.447518468832808*^9}, {3.447557287551656*^9, 
   3.4475574107187614`*^9}, 3.447557487579282*^9, {3.447557590136752*^9, 
   3.4475576699114623`*^9}, 3.447557912830763*^9, {3.4488166563597927`*^9, 
   3.4488167164157977`*^9}, {3.4489059119973154`*^9, 
   3.4489059149660845`*^9}, {3.4489060097791915`*^9, 
   3.4489060268261757`*^9}, {3.449414000795689*^9, 3.449414015775433*^9}, {
   3.449414048665008*^9, 3.449414056123406*^9}, {3.449414121931037*^9, 
   3.449414209875989*^9}, {3.449414268313225*^9, 3.4494142757696447`*^9}, {
   3.449414468772908*^9, 3.449414510693252*^9}, 3.449414553124612*^9, {
   3.449414627672514*^9, 3.449414628552194*^9}, {3.449414783081532*^9, 
   3.449414784168243*^9}, 3.449414885750696*^9, {3.4494149669069777`*^9, 
   3.449415003969874*^9}, 3.449415051157309*^9, {3.449415115591289*^9, 
   3.449415150114503*^9}, {3.449415181736328*^9, 3.449415195381358*^9}, {
   3.4494152269813013`*^9, 3.449415321560728*^9}, {3.449415411142074*^9, 
   3.449415439687257*^9}, {3.449415477060503*^9, 3.449415523571879*^9}, {
   3.449415598077829*^9, 3.449415600894648*^9}, {3.4494157025745163`*^9, 
   3.449415709020096*^9}, 3.449415739475052*^9, {3.449415789408202*^9, 
   3.449415792114603*^9}, {3.449415825645344*^9, 3.4494158266578007`*^9}, {
   3.449415875905239*^9, 3.449415876737006*^9}, {3.449415915695912*^9, 
   3.4494159340500937`*^9}, {3.449415979858452*^9, 3.449415986577866*^9}, {
   3.449416239973271*^9, 3.449416243643076*^9}, {3.4494163190771313`*^9, 
   3.449416322773719*^9}, {3.4494164978327417`*^9, 3.44941651158876*^9}, {
   3.449416579636248*^9, 3.449416614853805*^9}, {3.449416762679989*^9, 
   3.449416769033572*^9}, {3.449416810236022*^9, 3.44941693711526*^9}, 
   3.4494169789882174`*^9, {3.449417253211566*^9, 3.449417261028592*^9}, {
   3.449417317592108*^9, 3.4494173339066277`*^9}, {3.449417515916189*^9, 
   3.449417521023315*^9}, {3.4494176767373238`*^9, 3.449417677404478*^9}, {
   3.4494177199697657`*^9, 3.449417726764324*^9}, {3.44941813492179*^9, 
   3.449418143515367*^9}, {3.449418188379533*^9, 3.449418189208577*^9}, {
   3.4494182719068813`*^9, 3.449418286227202*^9}, 3.44941833356995*^9, 
   3.449418378467062*^9, {3.4494187038613443`*^9, 3.449418733285777*^9}, {
   3.449418776099793*^9, 3.449418776560025*^9}, 3.4494188706479053`*^9, {
   3.4494191154945173`*^9, 3.449419134946169*^9}, {3.449419187203863*^9, 
   3.449419243591341*^9}, {3.4494192920710163`*^9, 3.449419295839745*^9}, {
   3.449419469816551*^9, 3.449419512350575*^9}, 3.4494195859130096`*^9, {
   3.449419620937914*^9, 3.4494196212751703`*^9}, {3.4494197122209063`*^9, 
   3.449419741770355*^9}, {3.4494198244148817`*^9, 3.449419859417996*^9}, {
   3.449419921721425*^9, 3.449419921984836*^9}},
 CellID->1669056134]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`notat$$ = False, $CellContext`sunloc$$ = {
    10.373, 0.5}, $CellContext`x10$$ = 9, $CellContext`\[CurlyPhi]$$ = 20, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`sunloc$$], {10.373, 0.5}}, {7, 0.01}, {11, 10}}, {
      Hold[
       Grid[{{
          Manipulate`Place[1], 
          Manipulate`Place[2]}, {
          Manipulate`Place[3], 
          Button[
          "reset \!\(\*SubscriptBox[\(x\), \(1\)]\) and the locator", \
$CellContext`sunloc$$ = {10.5, 0.2}; $CellContext`notat$$ = 
            False; $CellContext`x10$$ = 9]}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`x10$$], 9, 
       "\!\(\*SubscriptBox[\(\:0445\), \(1\)]\)"}, 1, 11.}, {{
       Hold[$CellContext`\[CurlyPhi]$$], 20, "\[CurlyPhi] "}, 1, 45.}, {{
       Hold[$CellContext`notat$$], False, "notation"}, {True, False}}}, 
    Typeset`size$$ = {550., {168., 172.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`sunloc$3695$$ = {0, 0}, $CellContext`x10$3696$$ = 
    0, $CellContext`\[CurlyPhi]$3697$$ = 0, $CellContext`notat$3698$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`notat$$ = 
        False, $CellContext`sunloc$$ = {10.373, 0.5}, $CellContext`x10$$ = 
        9, $CellContext`\[CurlyPhi]$$ = 20}, "ControllerVariables" :> {
        Hold[$CellContext`sunloc$$, $CellContext`sunloc$3695$$, {0, 0}], 
        Hold[$CellContext`x10$$, $CellContext`x10$3696$$, 0], 
        Hold[$CellContext`\[CurlyPhi]$$, $CellContext`\[CurlyPhi]$3697$$, 0], 
        
        Hold[$CellContext`notat$$, $CellContext`notat$3698$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`x0$ = 0, $CellContext`y0$ = 0, $CellContext`y1$ = 
         0, $CellContext`l$ = 
         11, $CellContext`pfin$ = {1, 
          0}, $CellContext`alf1$, $CellContext`y2$, $CellContext`phi$, \
$CellContext`line2$, $CellContext`fl$, $CellContext`koord$, $CellContext`x$, \
$CellContext`x1$, $CellContext`x2$, $CellContext`x3$, $CellContext`alf$, \
$CellContext`alf2$, $CellContext`alf3$}, $CellContext`line2$[{{
             Pattern[$CellContext`x1, 
              Blank[]], 
             Pattern[$CellContext`y1, 
              Blank[]]}, {
             Pattern[$CellContext`x2, 
              Blank[]], 
             Pattern[$CellContext`y2, 
              Blank[]]}}, {
            Pattern[$CellContext`x3, 
             Blank[]], 
            Pattern[$CellContext`x4, 
             Blank[]]}] := 
         Line[{{$CellContext`x3, (($CellContext`y2 - \
$CellContext`y1)/($CellContext`x2 - $CellContext`x1)) $CellContext`x3 + \
($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}, {$CellContext`x4, \
(($CellContext`y2 - $CellContext`y1)/($CellContext`x2 - $CellContext`x1)) \
$CellContext`x4 + ($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}}]; $CellContext`phi$ = \
$CellContext`\[CurlyPhi]$$ Degree; $CellContext`fl$ = 
         True; $CellContext`alf1$ = 
         Pi/2. - ArcTan[Part[$CellContext`sunloc$$, 1] - $CellContext`x10$$, 
           
           Part[$CellContext`sunloc$$, 
            2]]; $CellContext`koord$ = {$CellContext`sunloc$$, \
{$CellContext`x10$$, $CellContext`y1$}}; $CellContext`x1$ = \
$CellContext`x10$$; $CellContext`alf$ = ""; $CellContext`x3$ = 0; 
        While[$CellContext`x1$ > 0, 
          If[$CellContext`alf1$ == 
            0, $CellContext`x2$ = $CellContext`x1$, $CellContext`x2$ = 
            ReplaceAll[$CellContext`x$, 
              First[
               Solve[
               Tan[$CellContext`phi$] $CellContext`x$ - 
                 Tan[Pi/2 + $CellContext`alf1$] ($CellContext`x$ - \
$CellContext`x1$) == 0, $CellContext`x$]]]]; If[
            
            And[$CellContext`alf1$ < 0, $CellContext`fl$], $CellContext`alf$ = 
             StringJoin[$CellContext`alf$, "\n"]; $CellContext`fl$ = 
             False]; $CellContext`alf$ = StringJoin[$CellContext`alf$, 
             ToString[
              Round[$CellContext`alf1$/Degree, 0.1]], 
             "\[Degree], "]; $CellContext`y2$ = 
           Tan[$CellContext`phi$] $CellContext`x2$; 
          If[$CellContext`x2$ <= 
            0, $CellContext`pfin$ = {$CellContext`x2$, $CellContext`y2$}; 
            Break[], $CellContext`koord$ = 
            Append[$CellContext`koord$, {$CellContext`x2$, \
$CellContext`y2$}]]; $CellContext`alf2$ = $CellContext`alf1$ - \
$CellContext`phi$; If[
            
            And[$CellContext`alf2$ <= 0, $CellContext`fl$], $CellContext`alf$ = 
             StringJoin[$CellContext`alf$, "\n"]; $CellContext`fl$ = 
             False]; $CellContext`alf$ = StringJoin[$CellContext`alf$, 
             ToString[
              Round[$CellContext`alf2$/Degree, 0.1]], 
             "\[Degree], "]; $CellContext`alf3$ = $CellContext`alf2$ - \
$CellContext`phi$; If[
            
            Or[$CellContext`alf3$ == 0, $CellContext`alf3$ == 
             Pi/2], $CellContext`x3$ = $CellContext`x2$, $CellContext`x3$ = 
            ReplaceAll[$CellContext`x$, 
              First[
               
               Solve[$CellContext`y2$ == 
                Tan[Pi/2 - $CellContext`alf3$] ($CellContext`x2$ - \
$CellContext`x$), $CellContext`x$]]]]; 
          If[$CellContext`x3$ <= 
            0, $CellContext`pfin$ = {$CellContext`x3$, 0}; 
            Break[], $CellContext`koord$ = 
            Append[$CellContext`koord$, {$CellContext`x3$, 
               0}]]; $CellContext`x1$ = $CellContext`x3$; $CellContext`y1$ = 
           0; $CellContext`alf1$ = $CellContext`alf3$]; Graphics[{Blue, Thick, 
           
           Line[{{$CellContext`x0$, $CellContext`y0$}, {$CellContext`l$ + \
$CellContext`x0$, $CellContext`y0$}}], 
           
           Line[{{$CellContext`x0$, $CellContext`y0$}, {$CellContext`l$ + \
$CellContext`x0$, $CellContext`l$ 
               Tan[$CellContext`phi$] + $CellContext`y0$}}], 
           Lighter[Blue, 0.85], 
           
           Polygon[{{$CellContext`x0$ - 0.2, $CellContext`y0$ - 
              0.03}, {$CellContext`l$ + $CellContext`x0$, $CellContext`y0$ - 
              0.03}, {$CellContext`l$ + $CellContext`x0$, $CellContext`y0$ - 
              0.5}, {$CellContext`x0$ - 0.2, $CellContext`y0$ - 0.5}}], 
           
           Polygon[{{$CellContext`x0$ - 
              0.2, $CellContext`y0$}, {$CellContext`x0$, $CellContext`y0$ + 
              0.03}, {$CellContext`l$ + $CellContext`x0$, $CellContext`l$ 
               Tan[$CellContext`phi$] + $CellContext`y0$ + 
              0.03}, {$CellContext`l$ + $CellContext`x0$, $CellContext`l$ 
               Tan[$CellContext`phi$] + $CellContext`y0$ + 
              0.6}, {$CellContext`x0$ - 0.2, $CellContext`y0$ + 0.6}}], Thick, 
           Darker[Red, 0.4], 
           Line[$CellContext`koord$], 
           If[Part[$CellContext`pfin$, 1] <= 0, 
            $CellContext`line2$[{$CellContext`pfin$, 
              Last[$CellContext`koord$]}, {
              Part[
               Last[$CellContext`koord$], 1], 11}], {}], Black, 
           If[$CellContext`notat$$, {
             Text[
              Style[
              "\!\(\*SubscriptBox[\(\[Alpha]\), \(n + 1\)]\) = \
\!\(\*SubscriptBox[\(\[Alpha]\), \(n\)]\) - \[CurlyPhi]", Large], {5, 7.9}], 
             Text[
              Style[
               StringJoin["\[CurlyPhi]=", 
                ToString[$CellContext`\[CurlyPhi]$$], "\[Degree]"], 
               Large], {$CellContext`x0$ + 1., $CellContext`y0$ + 1.4}], 
             Text[
              Style[$CellContext`alf$, Medium], {5., 6.5}]}, {}]}, 
          ImageSize -> {550, 340}, AspectRatio -> 0.6, Axes -> False, 
          PlotRange -> {{-0.5, 11}, {-0.5, 8}}]], 
      "Specifications" :> {{{$CellContext`sunloc$$, {10.373, 0.5}}, {
         7, 0.01}, {11, 10}, ControlType -> Locator}, 
        Grid[{{
           Manipulate`Place[1], 
           Manipulate`Place[2]}, {
           Manipulate`Place[3], 
           Button[
           "reset \!\(\*SubscriptBox[\(x\), \(1\)]\) and the locator", \
$CellContext`sunloc$$ = {10.5, 0.2}; $CellContext`notat$$ = 
             False; $CellContext`x10$$ = 9]}}], {{$CellContext`x10$$, 9, 
          "\!\(\*SubscriptBox[\(\:0445\), \(1\)]\)"}, 1, 11., Appearance -> 
         "Labeled", ControlPlacement -> 
         1}, {{$CellContext`\[CurlyPhi]$$, 20, "\[CurlyPhi] "}, 1, 45., 
         Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`notat$$, False, "notation"}, {True, False}, 
         ControlPlacement -> 3}}, "Options" :> {TrackedSymbols -> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{601., {228., 233.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->413936035],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This Demonstration shows the reflection of a ray between two flat mirrors \
that form a corner.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Reflections in a Mirrored Corner",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ReflectionsInAMirroredCorner/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ReflectionsInAMirroredCorner/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/ReflectionsInAMirroredCorner/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ReflectionsInAMirroredCorner/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ReflectionsInAMirroredCorner/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Volodymyr Holovatsky",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Volodymyr+\
Holovatsky%2C"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Volodymyr+Holovatsky%\
2C"],
 " (Chernivtsi National University, Ukraine)"
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
ReflectionsInAMirroredCorner"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Reflections in a Mirrored Corner - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[634, 23, 152, 3, 70, "Section"],
Cell[789, 28, 3700, 64, 70, "Section"],
Cell[4492, 94, 62415, 1052, 70, "Input",
 CellID->1669056134]
}, Open  ]],
Cell[CellGroupData[{
Cell[66944, 1151, 9582, 192, 70, "Output",
 CellID->413936035],
Cell[CellGroupData[{
Cell[76551, 1347, 209, 6, 70, "Section"],
Cell[76763, 1355, 119, 3, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[76930, 1364, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[77288, 1375, 967, 28, 70, "Text"],
Cell[78258, 1405, 509, 16, 70, "Text"],
Cell[CellGroupData[{
Cell[78792, 1425, 815, 24, 70, "Text"],
Cell[79610, 1451, 1200, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature PT4sl4Wp4cPi2B04mxTq#Bv2 *)
