(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     20032,        515]
NotebookOptionsPosition[     18812,        468]
NotebookOutlinePosition[     19469,        493]
CellTagsIndexPosition[     19426,        490]
WindowTitle->Reflection from a Polynomial Mirror - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Reflection from a Polynomial Mirror", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"p", "=", 
        RowBox[{
         RowBox[{"a", 
          RowBox[{"x", "^", "3"}]}], "+", 
         RowBox[{"b", 
          RowBox[{"x", "^", "2"}]}], "+", 
         RowBox[{"c", " ", "x"}]}]}], ",", 
       RowBox[{"left", "=", 
        RowBox[{"-", "4"}]}], ",", 
       RowBox[{"right", "=", "4"}]}], "}"}], ",", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"pp", "=", 
         RowBox[{"D", "[", 
          RowBox[{"p", ",", "x"}], "]"}]}], "}"}], ",", 
       RowBox[{"Plot", "[", 
        RowBox[{"p", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "left", ",", "right"}], "}"}], ",", 
         RowBox[{"Filling", "\[Rule]", 
          RowBox[{"-", "100"}]}], ",", 
         RowBox[{"Axes", "\[Rule]", "False"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"left", ",", "right"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".75"}], ",", "4.5"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FillingStyle", "\[Rule]", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0.848", ",", "0.848", ",", "0.92"}], "]"}]}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"PlotRangeClipping", "\[Rule]", "True"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"500", ",", "340"}], "}"}]}], ",", 
         RowBox[{"Prolog", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Lighter", "[", "Orange", "]"}], ",", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"xi", ",", 
                    RowBox[{"p", "/.", 
                    RowBox[{"x", "\[Rule]", "xi"}]}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"xi", ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"10", ",", 
                    RowBox[{"p", "/.", 
                    RowBox[{"x", "\[Rule]", "xi"}]}]}], "]"}]}], "}"}]}], 
                  "}"}], "]"}], ",", "\[IndentingNewLine]", "Orange", ",", 
                RowBox[{"Line", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"xi", ",", 
                    RowBox[{"p", "/.", 
                    RowBox[{"x", "\[Rule]", "xi"}]}]}], "}"}], ",", 
                    RowBox[{"N", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xi", "-", 
                    RowBox[{"len", 
                    FractionBox[
                    RowBox[{"2", "pp"}], 
                    RowBox[{"1", "+", 
                    SuperscriptBox["pp", "2"]}]]}]}], ",", 
                    RowBox[{"p", "+", 
                    RowBox[{"len", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    FractionBox["2", 
                    RowBox[{"1", "+", 
                    SuperscriptBox["pp", "2"]}]]}], ")"}]}]}]}], "}"}], 
                    "]"}]}], "}"}], "/.", 
                  RowBox[{"x", "\[Rule]", "xi"}]}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"xi", ",", "left", ",", "right", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"right", "-", "left"}], ")"}], "/", "20"}]}], 
               "}"}]}], "]"}]}], "}"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "\"\<mirror shape coefficients\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "0", ",", "\"\<linear\>\""}], "}"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"1", "/", "4"}], ",", "\"\<quadratic\>\""}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", "1"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "\"\<cubic\>\""}], "}"}], ",", 
     RowBox[{"-", "0.05"}], ",", "0.05"}], "}"}], ",", "Delimiter", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"len", ",", "8", ",", "\"\<length of rays\>\""}], "}"}], ",", 
     "0.5", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.371175078714611*^9, 3.371175141415647*^9}, {
   3.371175197267726*^9, 3.3711752464859*^9}, 3.3711753305477467`*^9, 
   3.371175411348466*^9, {3.3711754449498672`*^9, 3.371175458224203*^9}, {
   3.371175531159477*^9, 3.371175631851742*^9}, {3.371175665260068*^9, 
   3.3711756657912693`*^9}, {3.371175708813786*^9, 3.3711757420690804`*^9}, {
   3.371175832017376*^9, 3.3711758829708357`*^9}, {3.37117639885122*^9, 
   3.371176401335623*^9}, {3.3711764401862593`*^9, 3.37117644947362*^9}, {
   3.371176490413465*^9, 3.371176532795628*^9}, {3.371176571137012*^9, 
   3.37117657384029*^9}, {3.371176628590839*^9, 3.3711766451565237`*^9}, {
   3.3711766793149567`*^9, 3.371176694843795*^9}, {3.371177426866275*^9, 
   3.371177452062282*^9}, {3.371177521699923*^9, 3.371177577609104*^9}, {
   3.371325916035466*^9, 3.371325921948659*^9}, {3.371325960780566*^9, 
   3.371325985130192*^9}, {3.3713263761257973`*^9, 3.371326376524056*^9}, {
   3.371326637830283*^9, 3.3713266605422363`*^9}},
 CellID->213893732]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0, $CellContext`b$$ = Rational[
    1, 4], $CellContext`c$$ = 0, $CellContext`len$$ = 8, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold["mirror shape coefficients"], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`c$$], 0, "linear"}, -1, 1}, {{
       Hold[$CellContext`b$$], 
       Rational[1, 4], "quadratic"}, 
      Rational[-1, 2], 1}, {{
       Hold[$CellContext`a$$], 0, "cubic"}, -0.05, 0.05}, {{
       Hold[$CellContext`len$$], 8, "length of rays"}, 0.5, 8}}, 
    Typeset`size$$ = {500., {168., 172.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`c$217503$$ = 0, $CellContext`b$217504$$ = 
    0, $CellContext`a$217505$$ = 0, $CellContext`len$217506$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0, $CellContext`b$$ = 
        Rational[1, 4], $CellContext`c$$ = 0, $CellContext`len$$ = 8}, 
      "ControllerVariables" :> {
        Hold[$CellContext`c$$, $CellContext`c$217503$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$217504$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$217505$$, 0], 
        Hold[$CellContext`len$$, $CellContext`len$217506$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`p$ = $CellContext`a$$ $CellContext`x^3 + \
$CellContext`b$$ $CellContext`x^2 + $CellContext`c$$ $CellContext`x, \
$CellContext`left$ = -4, $CellContext`right$ = 4}, 
        With[{$CellContext`pp$ = D[$CellContext`p$, $CellContext`x]}, 
         Plot[$CellContext`p$, {$CellContext`x, $CellContext`left$, \
$CellContext`right$}, Filling -> -100, Axes -> False, 
          PlotRange -> {{$CellContext`left$, $CellContext`right$}, {-0.75, 
            4.5}}, FillingStyle -> RGBColor[0.848, 0.848, 0.92], AspectRatio -> 
          Automatic, PlotRangeClipping -> True, ImageSize -> {500, 340}, 
          Prolog -> {
            Lighter[Orange], 
            Table[{
              Line[{{$CellContext`xi, 
                 
                 ReplaceAll[$CellContext`p$, $CellContext`x -> \
$CellContext`xi]}, {$CellContext`xi, 
                 Max[10, 
                  
                  ReplaceAll[$CellContext`p$, $CellContext`x -> \
$CellContext`xi]]}}], Orange, 
              Line[
               ReplaceAll[{{$CellContext`xi, 
                  
                  ReplaceAll[$CellContext`p$, $CellContext`x -> \
$CellContext`xi]}, 
                 
                 N[{$CellContext`xi - $CellContext`len$$ (2 $CellContext`pp$/(
                    1 + $CellContext`pp$^2)), $CellContext`p$ + \
$CellContext`len$$ (-1 + 
                    2/(1 + $CellContext`pp$^2))}]}, $CellContext`x -> \
$CellContext`xi]]}, {$CellContext`xi, $CellContext`left$, \
$CellContext`right$, ($CellContext`right$ - $CellContext`left$)/20}]}]]], 
      "Specifications" :> {
       "mirror shape coefficients", {{$CellContext`c$$, 0, "linear"}, -1, 
         1}, {{$CellContext`b$$, 
          Rational[1, 4], "quadratic"}, 
         Rational[-1, 2], 1}, {{$CellContext`a$$, 0, "cubic"}, -0.05, 0.05}, 
        Delimiter, {{$CellContext`len$$, 8, "length of rays"}, 0.5, 8}}, 
      "Options" :> {}, "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {268., 273.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->335525278],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
A parabolic mirror reflects parallel rays of light to a single focal point. \
Other mirror shapes can produce very different behaviors.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Reflection from a Polynomial Mirror",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ReflectionFromAPolynomialMirror/"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ReflectionFromAPolynomialMirror/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/ReflectionFromAPolynomialMirror/\
",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ReflectionFromAPolynomialMirror/"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ReflectionFromAPolynomialMirror/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Stephen Wolfram",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Stephen+\
Wolfram"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Stephen+Wolfram"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->213404688],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
ReflectionFromAPolynomialMirror"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Reflection from a Polynomial Mirror - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[637, 23, 155, 3, 70, "Section"],
Cell[795, 28, 3700, 64, 70, "Section"],
Cell[4498, 94, 5863, 142, 70, "Input",
 CellID->213893732]
}, Open  ]],
Cell[CellGroupData[{
Cell[10398, 241, 4089, 82, 70, "Output",
 CellID->335525278],
Cell[CellGroupData[{
Cell[14512, 327, 209, 6, 70, "Section"],
Cell[14724, 335, 159, 3, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14931, 344, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[15289, 355, 987, 29, 70, "Text"],
Cell[16279, 386, 459, 15, 70, "Text",
 CellID->213404688],
Cell[CellGroupData[{
Cell[16763, 405, 815, 24, 70, "Text"],
Cell[17581, 431, 1203, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature TSNEzvqxJI2h7CpNIZEHMl8o *)
