(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     35570,        886]
NotebookOptionsPosition[     34284,        838]
NotebookOutlinePosition[     34983,        864]
CellTagsIndexPosition[     34940,        861]
WindowTitle->Reflection and Refraction on a Flat Surface between Two \
Different Materials - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Reflection and Refraction on a Flat Surface between Two Different Materials\
\>", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ai", "=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"pt", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"-", 
        RowBox[{"pt", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ar", "=", 
     RowBox[{"ArcSin", "[", 
      RowBox[{
       RowBox[{"n1", "/", "n2"}], " ", 
       RowBox[{"Sin", "[", "ai", "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"riftot", "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", "ar", "]"}], ">", 
        RowBox[{"\[Pi]", "/", "2"}]}], ",", "True", ",", "False"}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"Pane", "[", 
     RowBox[{
      RowBox[{"Grid", "[", 
       RowBox[{"{", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Framed", "@", 
           RowBox[{"Graphics", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Blue", ",", 
                 RowBox[{"Opacity", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"n1", "-", "1"}], ")"}], "/", "3"}], "]"}], ",", 
                 RowBox[{"Polygon", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], "]"}]}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Blue", ",", 
                 RowBox[{"Opacity", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"n2", "-", "1"}], ")"}], "/", "3"}], "]"}], ",", 
                 RowBox[{"Polygon", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", 
                    RowBox[{"-", "1"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Blue", ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
                 "Dashed", ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Red", ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], 
                    RowBox[{"Sin", "[", "ai", "]"}]}], ",", 
                    RowBox[{"2", 
                    RowBox[{"Cos", "[", "ai", "]"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"n1", "\[NotEqual]", "n2"}], ",", 
                   RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"2", 
                    RowBox[{"Sin", "[", "ai", "]"}]}], ",", 
                    RowBox[{"2", 
                    RowBox[{"Cos", "[", "ai", "]"}]}]}], "}"}]}], "}"}], 
                    "]"}], ",", 
                   RowBox[{"{", "}"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{"riftot", ",", 
                   RowBox[{"{", "}"}], ",", 
                   RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"2", 
                    RowBox[{"Sin", "[", "ar", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", "2"}], 
                    RowBox[{"Cos", "[", "ar", "]"}]}]}], "}"}]}], "}"}], 
                    "]"}]}], "]"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"325", ",", "325"}], "}"}]}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Text", "@", 
           RowBox[{"Framed", "@", 
            RowBox[{"Column", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Row", "[", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<c = \>\"", ",", "299792458", ",", "\"\< m/s\>\""}], 
                  "}"}], "]"}], ",", 
                RowBox[{"Row", "[", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<\!\(\*SubscriptBox[\(v\), \(1\)]\) = \>\"", ",", 
                   RowBox[{"Floor", "[", 
                    RowBox[{"299792458", "/", "n1"}], "]"}], ",", 
                   "\"\< m/s\>\""}], "}"}], "]"}], ",", 
                RowBox[{"Row", "[", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<\!\(\*SubscriptBox[\(v\), \(2\)]\) = \>\"", ",", 
                   RowBox[{"Floor", "[", 
                    RowBox[{"299792458", "/", "n2"}], "]"}], ",", 
                   "\"\< m/s\>\""}], "}"}], "]"}], ",", 
                RowBox[{"Row", "[", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(i\)]\) = \>\"", ",", 
                   RowBox[{"Abs", "[", "ai", "]"}], ",", "\"\< rad = \>\"", 
                   ",", 
                   RowBox[{"DegForm", "[", 
                    RowBox[{
                    RowBox[{"180", "/", "\[Pi]"}], " ", 
                    RowBox[{"Abs", "[", "ai", "]"}]}], "]"}]}], "}"}], "]"}], 
                ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                 "riftot", ",", 
                  "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(r\)]\) does not \
exist\>\"", ",", 
                  RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(r\)]\) = \>\"", 
                    ",", 
                    RowBox[{"Abs", "[", "ar", "]"}], ",", "\"\< rad. = \>\"", 
                    ",", 
                    RowBox[{"DegForm", "[", 
                    RowBox[{
                    RowBox[{"180", "/", "\[Pi]"}], " ", 
                    RowBox[{"Abs", "[", "ar", "]"}]}], "]"}]}], "}"}], 
                   "]"}]}], "]"}]}], "}"}], ",", 
              RowBox[{"ItemSize", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"17", ",", "Automatic"}], "}"}]}]}], "]"}]}]}]}], 
         "\[IndentingNewLine]", "}"}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"575", ",", "350"}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "n1", ",", "1.00029", ",", 
       "\"\<\!\(\*SubscriptBox[\(n\), \(1\)]\)\>\""}], "}"}], ",", "1", ",", 
     "3", ",", "Manipulator", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "n2", ",", "1.33", ",", "\"\<\!\(\*SubscriptBox[\(n\), \(2\)]\)\>\""}], 
      "}"}], ",", "1", ",", "3", ",", "Manipulator", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "n1", ",", "1.00029", ",", 
       "\"\<\!\(\*SubscriptBox[\(n\), \(1\)]\)\>\""}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{"lang", ",", "dataen", ",", "datait"}], "]"}], ",", 
     "PopupMenu"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "n2", ",", "1.33", ",", "\"\<\!\(\*SubscriptBox[\(n\), \(2\)]\)\>\""}], 
      "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{"lang", ",", "dataen", ",", "datait"}], "]"}], ",", 
     "PopupMenu"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lang", ",", "True", ",", "\"\<language for pulldown\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"True", "\[Rule]", "\"\<English\>\""}], ",", 
       RowBox[{"False", "\[Rule]", "\"\<Italian\>\""}]}], "}"}], ",", 
     "RadioButtonBar"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pt", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], ",", 
         RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"DegDigits", "[", "x_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "p", "}"}], ",", 
         RowBox[{
          RowBox[{"p", "=", 
           RowBox[{"FractionalPart", "[", "x", "]"}]}], ";", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"IntegerPart", "[", "x", "]"}], ",", 
            RowBox[{"IntegerPart", "[", 
             RowBox[{"60", "p"}], "]"}], ",", 
            RowBox[{"60", 
             RowBox[{"FractionalPart", "[", 
              RowBox[{"60", "p"}], "]"}]}]}], "}"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"DegForm", "[", "x_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"p", ",", "m", ",", "s"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"p", ",", "m", ",", "s"}], "}"}], "=", 
           RowBox[{"DegDigits", "[", "x", "]"}]}], ";", 
          RowBox[{
           RowBox[{"ToString", "@", "p"}], "<>", "\"\<\[Degree] \>\"", "<>", 
           RowBox[{"ToString", "@", "m"}], "<>", "\"\<' \>\"", "<>", 
           RowBox[{"ToString", "@", 
            RowBox[{"N", "[", "s", "]"}]}], "<>", "\"\<'' \>\""}]}]}], 
        "]"}]}], ";", 
      RowBox[{"dataen", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "\"\<vacuum\>\""}], ",", 
         RowBox[{"1.00029", "\[Rule]", "\"\<air\>\""}], ",", 
         RowBox[{"1.33", "\[Rule]", "\"\<water\>\""}], ",", 
         RowBox[{"1.36", "\[Rule]", "\"\<acetone\>\""}], ",", 
         RowBox[{"1.37", "\[Rule]", "\"\<grain alcohol\>\""}], ",", 
         RowBox[{"1.38", "\[Rule]", "\"\<sugar sol. 30%\>\""}], ",", 
         RowBox[{"1.46", "\[Rule]", "\"\<melt quartz\>\""}], ",", 
         RowBox[{"1.49", "\[Rule]", "\"\<sugar sol. 80%\>\""}], ",", 
         RowBox[{"1.52", "\[Rule]", "\"\<'crown' glass\>\""}], ",", 
         RowBox[{"1.54", "\[Rule]", "\"\<sodium chloride\>\""}], ",", 
         RowBox[{"1.55", "\[Rule]", "\"\<polystyrene\>\""}], ",", 
         RowBox[{"1.63", "\[Rule]", "\"\<carbon disulfide\>\""}], ",", 
         RowBox[{"1.65", "\[Rule]", "\"\<'flint' glass\>\""}], ",", 
         RowBox[{"1.77", "\[Rule]", "\"\<sapphire\>\""}], ",", 
         RowBox[{"1.89", "\[Rule]", "\"\<heavy 'flint' glass\>\""}], ",", 
         RowBox[{"2.42", "\[Rule]", "\"\<diamond\>\""}]}], "}"}]}], ";", 
      RowBox[{"datait", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "\"\<vuoto\>\""}], ",", 
         RowBox[{"1.00029", "\[Rule]", "\"\<aria\>\""}], ",", 
         RowBox[{"1.33", "\[Rule]", "\"\<acqua\>\""}], ",", 
         RowBox[{"1.36", "\[Rule]", "\"\<acetone\>\""}], ",", 
         RowBox[{"1.37", "\[Rule]", "\"\<etanolo\>\""}], ",", 
         RowBox[{"1.38", "\[Rule]", "\"\<sol. zucch. 30%\>\""}], ",", 
         RowBox[{"1.46", "\[Rule]", "\"\<quarzo fuso\>\""}], ",", 
         RowBox[{"1.49", "\[Rule]", "\"\<sol. zucch. 80%\>\""}], ",", 
         RowBox[{"1.52", "\[Rule]", "\"\<vetro crown\>\""}], ",", 
         RowBox[{"1.54", "\[Rule]", "\"\<cloruro di sodio\>\""}], ",", 
         RowBox[{"1.55", "\[Rule]", "\"\<polistirene\>\""}], ",", 
         RowBox[{"1.63", "\[Rule]", "\"\<disolfuro di carbonio\>\""}], ",", 
         RowBox[{"1.65", "\[Rule]", "\"\<vetro flint\>\""}], ",", 
         RowBox[{"1.77", "\[Rule]", "\"\<zaffiro\>\""}], ",", 
         RowBox[{"1.89", "\[Rule]", "\"\<vetro flint pesante\>\""}], ",", 
         RowBox[{"2.42", "\[Rule]", "\"\<diamante\>\""}]}], "}"}]}]}], 
     ")"}]}], ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", "Manipulate"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.4355987726626077`*^9, 3.435598896839024*^9}, {
   3.4356068262559843`*^9, 3.4356068650555906`*^9}, {3.435606935716815*^9, 
   3.4356069631093683`*^9}, {3.4356070607568674`*^9, 3.435607069132457*^9}, {
   3.436722591021389*^9, 3.4367225951583686`*^9}, 3.4367235978744*^9, {
   3.437516249680132*^9, 3.437516250680145*^9}, {3.4375162876806183`*^9, 
   3.4375162905712805`*^9}, {3.437516336118738*^9, 3.437516476308033*^9}, {
   3.437516518683575*^9, 3.4375165201523438`*^9}, {3.437756662236009*^9, 
   3.4377566716369495`*^9}, {3.500756958063743*^9, 3.500756963502041*^9}, {
   3.500757105746612*^9, 3.500757151595694*^9}, 3.5007572129883137`*^9},
 CellID->109804202]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`lang$$ = True, $CellContext`n1$$ = 
    1.00029, $CellContext`n2$$ = 1.33, $CellContext`pt$$ = {
     Rational[-1, 2], 
     Rational[1, 2]}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n1$$], 1.00029, 
       "\!\(\*SubscriptBox[\(n\), \(1\)]\)"}, 1, 3}, {{
       Hold[$CellContext`n2$$], 1.33, "\!\(\*SubscriptBox[\(n\), \(2\)]\)"}, 
      1, 3}, {{
       Hold[$CellContext`n1$$], 1.00029, 
       "\!\(\*SubscriptBox[\(n\), \(1\)]\)"}, 
      Dynamic[
       If[$CellContext`lang$$, $CellContext`dataen, $CellContext`datait]]}, {{
      
       Hold[$CellContext`n2$$], 1.33, "\!\(\*SubscriptBox[\(n\), \(2\)]\)"}, 
      Dynamic[
       If[$CellContext`lang$$, $CellContext`dataen, $CellContext`datait]]}, {{
      
       Hold[$CellContext`lang$$], True, "language for pulldown"}, {
      True -> "English", False -> "Italian"}}, {{
       Hold[$CellContext`pt$$], {
        Rational[-1, 2], 
        Rational[1, 2]}}, {-1, 0}, {1, 1}}}, Typeset`size$$ = {
    862.5, {258.53125, 266.46875}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`n1$208000$$ = 
    0, $CellContext`n2$208001$$ = 0, $CellContext`lang$208002$$ = 
    False, $CellContext`pt$208003$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`lang$$ = True, $CellContext`n1$$ = 
        1.00029, $CellContext`n2$$ = 1.33, $CellContext`pt$$ = {
          Rational[-1, 2], 
          Rational[1, 2]}}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$208000$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$208001$$, 0], 
        Hold[$CellContext`lang$$, $CellContext`lang$208002$$, False], 
        Hold[$CellContext`pt$$, $CellContext`pt$208003$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ($CellContext`ai = ArcTan[
          Part[$CellContext`pt$$, 2], -
          Part[$CellContext`pt$$, 1]]; $CellContext`ar = 
        ArcSin[($CellContext`n1$$/$CellContext`n2$$) 
          Sin[$CellContext`ai]]; $CellContext`riftot = 
        If[Abs[$CellContext`ar] > Pi/2, True, False]; Pane[
         Grid[{{
            Framed[
             Graphics[{{Blue, 
                Opacity[($CellContext`n1$$ - 1)/3], 
                Polygon[{{-1, 0}, {1, 0}, {1, 1}, {-1, 1}}]}, {Blue, 
                Opacity[($CellContext`n2$$ - 1)/3], 
                Polygon[{{-1, 0}, {1, 0}, {1, -1}, {-1, -1}}]}, {Blue, 
                Line[{{-1, 0}, {1, 0}}], Dashed, 
                Line[{{0, 1}, {0, -1}}]}, {Red, 
                
                Line[{{(-2) Sin[$CellContext`ai], 2 Cos[$CellContext`ai]}, {0,
                   0}}], 
                If[$CellContext`n1$$ != $CellContext`n2$$, 
                 
                 Line[{{0, 0}, {
                   2 Sin[$CellContext`ai], 2 Cos[$CellContext`ai]}}], {}], 
                If[$CellContext`riftot, {}, 
                 
                 Line[{{0, 0}, {
                   2 Sin[$CellContext`ar], (-2) Cos[$CellContext`ar]}}]]}}, 
              PlotRange -> {{-1, 1}, {-1, 1}}, ImageSize -> {325, 325}]], 
            Text[
             Framed[
              Column[{
                Row[{"c = ", 299792458, " m/s"}], 
                Row[{"\!\(\*SubscriptBox[\(v\), \(1\)]\) = ", 
                  Floor[299792458/$CellContext`n1$$], " m/s"}], 
                Row[{"\!\(\*SubscriptBox[\(v\), \(2\)]\) = ", 
                  Floor[299792458/$CellContext`n2$$], " m/s"}], 
                Row[{"\!\(\*SubscriptBox[\(\[Alpha]\), \(i\)]\) = ", 
                  Abs[$CellContext`ai], " rad = ", 
                  $CellContext`DegForm[(180/Pi) Abs[$CellContext`ai]]}], 
                If[$CellContext`riftot, 
                 "\!\(\*SubscriptBox[\(\[Alpha]\), \(r\)]\) does not exist", 
                 Row[{"\!\(\*SubscriptBox[\(\[Alpha]\), \(r\)]\) = ", 
                   Abs[$CellContext`ar], " rad. = ", 
                   $CellContext`DegForm[(180/Pi) Abs[$CellContext`ar]]}]]}, 
               ItemSize -> {17, Automatic}]]]}}], ImageSize -> {575, 350}]), 
      "Specifications" :> {{{$CellContext`n1$$, 1.00029, 
          "\!\(\*SubscriptBox[\(n\), \(1\)]\)"}, 1, 3, ControlType -> 
         Manipulator, Appearance -> 
         "Labeled"}, {{$CellContext`n2$$, 1.33, 
          "\!\(\*SubscriptBox[\(n\), \(2\)]\)"}, 1, 3, ControlType -> 
         Manipulator, Appearance -> 
         "Labeled"}, {{$CellContext`n1$$, 1.00029, 
          "\!\(\*SubscriptBox[\(n\), \(1\)]\)"}, 
         Dynamic[
          If[$CellContext`lang$$, $CellContext`dataen, $CellContext`datait]], 
         ControlType -> 
         PopupMenu}, {{$CellContext`n2$$, 1.33, 
          "\!\(\*SubscriptBox[\(n\), \(2\)]\)"}, 
         Dynamic[
          If[$CellContext`lang$$, $CellContext`dataen, $CellContext`datait]], 
         ControlType -> 
         PopupMenu}, {{$CellContext`lang$$, True, "language for pulldown"}, {
         True -> "English", False -> "Italian"}, ControlType -> 
         RadioButtonBar}, {{$CellContext`pt$$, {
           Rational[-1, 2], 
           Rational[1, 2]}}, {-1, 0}, {1, 1}, ControlType -> Locator}}, 
      "Options" :> {TrackedSymbols -> Manipulate}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{914., {356., 361.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`DegDigits[
         Pattern[$CellContext`x, 
          Blank[]]] := 
       Module[{$CellContext`p}, $CellContext`p = 
          FractionalPart[$CellContext`x]; {
           IntegerPart[$CellContext`x], 
           IntegerPart[60 $CellContext`p], 60 
           FractionalPart[60 $CellContext`p]}]; $CellContext`DegForm[
         Pattern[$CellContext`x, 
          Blank[]]] := 
       Module[{$CellContext`p, $CellContext`m, $CellContext`s}, \
{$CellContext`p, $CellContext`m, $CellContext`s} = \
$CellContext`DegDigits[$CellContext`x]; StringJoin[
           ToString[$CellContext`p], "\[Degree] ", 
           ToString[$CellContext`m], "' ", 
           ToString[
            N[$CellContext`s]], "'' "]]; $CellContext`dataen = {
        1 -> "vacuum", 1.00029 -> "air", 1.33 -> "water", 1.36 -> "acetone", 
         1.37 -> "grain alcohol", 1.38 -> "sugar sol. 30%", 1.46 -> 
         "melt quartz", 1.49 -> "sugar sol. 80%", 1.52 -> "'crown' glass", 
         1.54 -> "sodium chloride", 1.55 -> "polystyrene", 1.63 -> 
         "carbon disulfide", 1.65 -> "'flint' glass", 1.77 -> "sapphire", 
         1.89 -> "heavy 'flint' glass", 2.42 -> 
         "diamond"}; $CellContext`datait = {
        1 -> "vuoto", 1.00029 -> "aria", 1.33 -> "acqua", 1.36 -> "acetone", 
         1.37 -> "etanolo", 1.38 -> "sol. zucch. 30%", 1.46 -> "quarzo fuso", 
         1.49 -> "sol. zucch. 80%", 1.52 -> "vetro crown", 1.54 -> 
         "cloruro di sodio", 1.55 -> "polistirene", 1.63 -> 
         "disolfuro di carbonio", 1.65 -> "vetro flint", 1.77 -> "zaffiro", 
         1.89 -> "vetro flint pesante", 2.42 -> "diamante"}); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->538720803],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "When a ray of light hits the surface between two different materials, part \
of it is reflected and part of it is refracted through the second material. \
Call ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "i"], TraditionalForm]], "InlineMath"],
 " the angle between the incoming ray and the normal to the surface. The \
angle of reflection is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "i"], TraditionalForm]], "InlineMath"],
 ", while the angle of refraction is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "r"], TraditionalForm]], "InlineMath"],
 ", satisfying ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["n", "1"], 
     RowBox[{"sin", "(", 
      SubscriptBox["\[Alpha]", "i"], ")"}]}], "=", 
    RowBox[{
     SubscriptBox["n", "2"], 
     RowBox[{"sin", "(", 
      SubscriptBox["\[Alpha]", "r"], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "2"], TraditionalForm]], "InlineMath"],
 " are the ratios between the speed of light in a vacuum and in the \
materials, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "1"], "=", 
    RowBox[{"c", "/", 
     SubscriptBox["v", "1"]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "2"], "=", 
    RowBox[{"c", "/", 
     SubscriptBox["v", "2"]}]}], TraditionalForm]], "InlineMath"],
 ". There is no reflected ray when ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "1"], "=", 
    SubscriptBox["n", "2"]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"]
}, Close]]
}, Open  ]],

Cell[TextData[{
 "If the angle ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "r"], TraditionalForm]], "InlineMath"],
 " is greater than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"90", "\[Degree]"}], TraditionalForm]], "InlineMath"],
 ", there is total reflection, which means that the ray does not cross the \
surface. (This is explicitly indicated in the panel on the right as \"",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "r"], TraditionalForm]], "InlineMath"],
 " does not exist\".)"
}], "Text"],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Reflection and Refraction on a Flat Surface between Two Different \
Materials",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
ReflectionAndRefractionOnAFlatSurfaceBetweenTwoDifferentMate/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
ReflectionAndRefractionOnAFlatSurfaceBetweenTwoDifferentMate/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
ReflectionAndRefractionOnAFlatSurfaceBetweenTwoDifferentMate/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
ReflectionAndRefractionOnAFlatSurfaceBetweenTwoDifferentMate/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
ReflectionAndRefractionOnAFlatSurfaceBetweenTwoDifferentMate/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Stra Federico",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Stra+Federico"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Stra+Federico"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
ReflectionAndRefractionOnAFlatSurfaceBetweenTwoDifferentMate"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Reflection and Refraction on a Flat Surface between Two \
Different Materials - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[679, 24, 203, 5, 70, "Section"],
Cell[885, 31, 3700, 64, 70, "Section"],
Cell[4588, 97, 15269, 363, 70, "Input",
 CellID->109804202]
}, Open  ]],
Cell[CellGroupData[{
Cell[19894, 465, 7770, 153, 70, "Output",
 CellID->538720803],
Cell[CellGroupData[{
Cell[27689, 622, 209, 6, 70, "Section"],
Cell[27901, 630, 1740, 59, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[29667, 693, 520, 15, 70, "Text"],
Cell[CellGroupData[{
Cell[30212, 712, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[30570, 723, 1172, 32, 70, "Text"],
Cell[31745, 757, 436, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[32206, 775, 815, 24, 70, "Text"],
Cell[33024, 801, 1232, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature ATjNbydcsGU5cDT0HLjl64Rb *)
