(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16213,        429]
NotebookOptionsPosition[     15114,        388]
NotebookOutlinePosition[     15740,        412]
CellTagsIndexPosition[     15697,        409]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Particle Moving on a Rotating Disk", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eqs", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", " ", "vx0"}], "+", "x0"}], ")"}], " ", 
           RowBox[{"Cos", "[", 
            FractionBox["t", "2"], "]"}]}], "+", 
          RowBox[{"t", " ", 
           RowBox[{"(", 
            RowBox[{"vy0", "+", 
             FractionBox["x0", "2"]}], ")"}], " ", 
           RowBox[{"Sin", "[", 
            FractionBox["t", "2"], "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"t", " ", 
           RowBox[{"(", 
            RowBox[{"vy0", "+", 
             FractionBox["x0", "2"]}], ")"}], " ", 
           RowBox[{"Cos", "[", 
            FractionBox["t", "2"], "]"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", " ", "vx0"}], "+", "x0"}], ")"}], " ", 
           RowBox[{"Sin", "[", 
            FractionBox["t", "2"], "]"}]}]}]}], "}"}]}], "}"}], ",", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", "eqs", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"NumberQ", "[", "#1", "]"}], ",", "#1", ",", "40"}], 
             "]"}], "&"}], ")"}], "[", 
          RowBox[{"Quiet", "@", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{"Evaluate", "[", 
               RowBox[{
                RowBox[{"Plus", "@@", 
                 SuperscriptBox["eqs", "2"]}], "\[Equal]", "1"}], "]"}], ",", 
              
              RowBox[{"{", 
               RowBox[{"t", ",", "155", ",", "0", ",", "5000"}], "}"}], ",", 
              RowBox[{"MaxIterations", "\[Rule]", "50"}]}], "]"}], 
            "\[LeftDoubleBracket]", 
            RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"Prolog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", ".8", "]"}], ",", 
          RowBox[{"Disk", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
          RowBox[{"PointSize", "[", ".02", "]"}], ",", 
          RowBox[{"GrayLevel", "[", ".0", "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "1000"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x0", ",", ".5", ",", "\"\<initial position x\>\""}], "}"}], 
     ",", "0", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vx0", ",", 
       RowBox[{"-", ".0004"}], ",", "\"\<initial velocity in x\>\""}], "}"}], 
     ",", 
     RowBox[{"-", "0.1"}], ",", ".1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vy0", ",", ".23", ",", "\"\<initial velocity in y\>\""}], 
      "}"}], ",", 
     RowBox[{"-", ".24"}], ",", ".24", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.350761518375*^9, 3.35076158245313*^9, 3.35076165110938*^9, 
   3.35076173865625*^9, 3.35076177476563*^9, 3.35076185707813*^9, 
   3.35076189442188*^9, 3.35076193559375*^9, 3.35076200207813*^9, {
   3.366401049875*^9, 3.36640105465625*^9}, {3.375878790448863*^9, 
   3.3758789011999702`*^9}, 3.376568953303611*^9, {3.3765717107274714`*^9, 
   3.376571750592125*^9}, {3.376571802426055*^9, 3.376571816180304*^9}, {
   3.376572621894813*^9, 3.376572675192952*^9}, {3.376572716110553*^9, 
   3.376572740534809*^9}, {3.376572778150085*^9, 3.376572781962944*^9}, {
   3.376572874935789*^9, 3.3765728794011173`*^9}, {3.376573073466723*^9, 
   3.376573089393648*^9}, {3.376573168001589*^9, 3.376573177776691*^9}, {
   3.3765732477530327`*^9, 3.3765732516395273`*^9}, {3.376573302072001*^9, 
   3.376573302485886*^9}, 3.376573343915662*^9, 3.376575400639586*^9, 
   3.3765754805070877`*^9, {3.376575988700227*^9, 3.37657599413174*^9}, 
   3.376576035986959*^9, 3.376576209600513*^9, {3.376576364170599*^9, 
   3.376576379930344*^9}, {3.3765765265865803`*^9, 3.3765765280466633`*^9}, 
   3.3765768958189077`*^9, {3.3765769883853493`*^9, 3.376576991739587*^9}, {
   3.376577947988102*^9, 3.3765779657997723`*^9}, 3.376578296124976*^9, {
   3.376578700294743*^9, 3.376578702390214*^9}, {3.376579142295188*^9, 
   3.376579159345595*^9}, {3.376579415647266*^9, 3.376579443836524*^9}, {
   3.376579836969109*^9, 3.3765798574141273`*^9}, {3.376580204789209*^9, 
   3.376580219728244*^9}, {3.376581043449885*^9, 3.376581135100088*^9}, {
   3.376581214943912*^9, 3.376581240219483*^9}, {3.3765812704173603`*^9, 
   3.3765812988268223`*^9}, {3.376581338473774*^9, 3.376581361973819*^9}, {
   3.3765820862423563`*^9, 3.376582116058165*^9}, {3.376582156415646*^9, 
   3.3765821582556353`*^9}, {3.376582212588619*^9, 3.3765822237053413`*^9}, {
   3.376582288670752*^9, 3.37658231665143*^9}, {3.376582375984655*^9, 
   3.376582385119918*^9}, {3.3765824510594597`*^9, 3.3765824579504213`*^9}, {
   3.37658255874833*^9, 3.3765825634572573`*^9}, 3.3765827341740723`*^9, {
   3.376582808053027*^9, 3.3765828296720943`*^9}, {3.376655639064015*^9, 
   3.376655657227824*^9}, {3.376655807552514*^9, 3.376655828090783*^9}, {
   3.3812736670532*^9, 3.3812736735701733`*^9}, {3.381273718773879*^9, 
   3.381273769052374*^9}, {3.381274168061721*^9, 3.381274169445313*^9}, 
   3.3815219731449013`*^9, 3.3815221441866617`*^9, {3.3815222678183613`*^9, 
   3.381522276722899*^9}, {3.381522323476026*^9, 3.381522334276561*^9}, {
   3.38152963138538*^9, 3.3815296377135053`*^9}, {3.3820328314816337`*^9, 
   3.3820328499934664`*^9}, {3.386613255775288*^9, 3.386613257469904*^9}, 
   3.386849703984375*^9, {3.3918804281951766`*^9, 3.3918804316326766`*^9}, 
   3.3918805355389266`*^9, {3.3918805741014266`*^9, 3.3918805758983016`*^9}},
 CellID->1998141418]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`vx0$$ = -0.0004, $CellContext`vy0$$ = 
    0.23, $CellContext`x0$$ = 0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`x0$$], 0.5, "initial position x"}, 0, 1}, {{
       Hold[$CellContext`vx0$$], -0.0004, "initial velocity in x"}, -0.1, 
      0.1}, {{
       Hold[$CellContext`vy0$$], 0.23, "initial velocity in y"}, -0.24, 
      0.24}}, Typeset`size$$ = {360., {178., 182.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x0$468111$$ = 0, $CellContext`vx0$468112$$ = 
    0, $CellContext`vy0$468113$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`vx0$$ = -0.0004, $CellContext`vy0$$ = 
        0.23, $CellContext`x0$$ = 0.5}, "ControllerVariables" :> {
        Hold[$CellContext`x0$$, $CellContext`x0$468111$$, 0], 
        Hold[$CellContext`vx0$$, $CellContext`vx0$468112$$, 0], 
        Hold[$CellContext`vy0$$, $CellContext`vy0$468113$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`eqs = {($CellContext`t $CellContext`vx0$$ + \
$CellContext`x0$$) 
            Cos[$CellContext`t/
              2] + $CellContext`t ($CellContext`vy0$$ + $CellContext`x0$$/2) 
            Sin[$CellContext`t/
              2], $CellContext`t ($CellContext`vy0$$ + $CellContext`x0$$/2) 
            Cos[$CellContext`t/
              2] - ($CellContext`t $CellContext`vx0$$ + $CellContext`x0$$) 
           Sin[$CellContext`t/2]}}, 
        ParametricPlot[
         Evaluate[$CellContext`eqs], {$CellContext`t, 0, 
          (If[
           NumberQ[#], #, 40]& )[
           Quiet[
            Part[
             FindRoot[
              Evaluate[
              Apply[Plus, $CellContext`eqs^2] == 1], {$CellContext`t, 155, 0, 
               5000}, MaxIterations -> 50], 1, 2]]]}, Prolog -> {
           GrayLevel[0.8], 
           Disk[{0, 0}, 1], 
           PointSize[0.02], 
           GrayLevel[0.], 
           Point[{0, 0}]}, PlotRange -> {{-1, 1}, {-1, 1}}, Axes -> False, 
         PlotPoints -> 1000]], 
      "Specifications" :> {{{$CellContext`x0$$, 0.5, "initial position x"}, 0,
          1, Appearance -> 
         "Labeled"}, {{$CellContext`vx0$$, -0.0004, 
          "initial velocity in x"}, -0.1, 0.1, Appearance -> 
         "Labeled"}, {{$CellContext`vy0$$, 0.23, 
          "initial velocity in y"}, -0.24, 0.24, Appearance -> "Labeled"}}, 
      "Options" :> {}, "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{404., {248., 253.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->718644300],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Particle Moving on a Rotating Disk",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ParticleMovingOnARotatingDisk/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ParticleMovingOnARotatingDisk/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/ParticleMovingOnARotatingDisk/",
  
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ParticleMovingOnARotatingDisk/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ParticleMovingOnARotatingDisk/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Enrique Zeleny",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->498224443],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
ParticleMovingOnARotatingDisk"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Particle Moving on a Rotating Disk - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (February 7, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 226, 4, 70, "Section"],
Cell[819, 29, 6678, 147, 70, "Input",
 CellID->1998141418]
}, Open  ]],
Cell[7512, 179, 3335, 70, 70, "Output",
 CellID->718644300],
Cell[CellGroupData[{
Cell[10872, 253, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[11248, 264, 977, 29, 70, "Text"],
Cell[12228, 295, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[12568, 306, 456, 15, 70, "Text",
 CellID->498224443],
Cell[CellGroupData[{
Cell[13049, 325, 829, 24, 70, "Text"],
Cell[13881, 351, 1205, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 3SNRv6858m8WyA0YiO5XG8VG *)
