(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1751449,      28237]
NotebookOptionsPosition[   1749811,      28178]
NotebookOutlinePosition[   1750463,      28203]
CellTagsIndexPosition[   1750420,      28200]
WindowTitle->Optical Model of the Human Eye - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Optical Model of the Human Eye", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell["\<\
Manipulate[
 Column[
  {
   Grid[
    {{Show[{Graphics[{{Opacity[0.8], 
           staticpolygons1118640200831284558144170, Opacity[1], 
           RGBColor[0.038747429704798886, 0.9161617552424038, 
            0.03984721226918142], AbsoluteThickness[Medium], 
           Line[Dynamic[({#1[[{1, 2}]], #1[[{4, 5}]]} & ) /@ 
              Select[raytracefunction118640200831284558148930[th, x, 
                y], #1[[1]] > -9.87654321*^8 & ], SynchronousUpdating -> 
              False]], Arrowheads[Large], Thickness[Large], 
           Dashing[{Small, Small}], RGBColor[1, 1, 0], 
           Arrow[Dynamic[If[laststartposth != {x, y} || lastth =!= th, 
               laststartposth = {x, y}; lastth = th; {xth, yth} = 
                 laststartposth + radiusth*{Cos[th*Degree], 
                    Sin[th*Degree]}]; {laststartposth, {xth, yth}}, 
             ({laststartposth, {xth, yth}} = #1) & ]], 
           Tooltip[Locator[Dynamic[BesselJ[1., 3.]; (
                If[{xth, yth} != lastlocposth || lastth != th, 
                 lastlocposth = {xth, yth}; lastth = th; {xth, yth} = 
                   laststartposth + radiusth*{Cos[th*Degree], 
                      Sin[th*Degree]}]; {xth, yth}), ({xth, yth} = #1; 
                xoffth = xth - x; yoffth = yth - y; radiusth = 
                 Sqrt[xoffth^2 + yoffth^2]; th = Chop[ArcTan[xoffth, 
                    yoffth]/Degree]; {xth, yth}) & ], 
             Graphics[{RGBColor[1/3, 1/3, 1], Disk[{0, 0}, 0.5]}, 
              ImageSize -> 10]], Dynamic[StringJoin[\"th = \", 
              ToString[th]]]], Tooltip[Locator[Dynamic[BesselJ[1., 3.]; {
                x, y}, ({x, y} = Chop[#1]) & ], Graphics[{RGBColor[1, 
                1/3, 1/3], Disk[{0, 0}, 0.8]}, ImageSize -> 10]], 
            Dynamic[StringJoin[\"{x, y} = \", ToString[Chop[
                {x, y}]]]]]}}]}, {PlotLabel -> \"eye model\", 
        ImageSize -> {225, 300}, AspectRatio -> Automatic}], 
      Show[{Graphics3D[{{Opacity[1], 
           staticpolygons211864020083128460945430, Opacity[1], 
           RGBColor[0.038747429704798886, 0.9161617552424038, 
            0.03984721226918142], AbsoluteThickness[Medium], 
           Line[Dynamic[({#1[[{1, 2, 3}]], #1[[{4, 5, 6}]]} & ) /@ 
              Select[raytracefunction21864020083128460953516[th, x, y], 
               #1[[1]] > -9.87654321*^8 & ], SynchronousUpdating -> 
              False]]}}]}, {PlotLabel -> None, ImageSize -> {225, 300}, 
        AspectRatio -> Automatic}]}}]}, Center], 
 {{th, 0.}, -180., 180., ControlType -> None}, 
 {{x, -5.}, -10, -0.05, ControlType -> None}, 
 {{y, 0.}, -10, 10, ControlType -> None}, 
 {{xth, -4.4019925}, ControlType -> None}, 
 {{yth, 0.}, ControlType -> None}, 
 {{radiusth, 0.5980074999999999}, 
  ControlType -> None}, {{xoffth, 0.5980074999999999}, 
  ControlType -> None}, {{yoffth, 0.}, ControlType -> None}, 
 {{laststartposth, {-5., 0.}}, ControlType -> None}, 
 {{lastlocposth, {-4.4019925, 0.}}, ControlType -> None}, 
 {{lastth, 0}, ControlType -> None}, 
 {{staticpolygons1118640200831284558144170, 
   {GrayLevel[0], AbsoluteThickness[0.5], 
    Line[{{{-0.654121133468629, -6.25}, {-0.9903057458473903, -5.9375}, 
       {-1.2964078972773794, -5.625}, {-1.575713724426754, -5.3125}, 
       {-1.830815380800448, -5.}, {-2.0637952929044054, -4.6875}, 
       {-2.276351075688101, -4.375}, {-2.4698828946113975, -4.0625}, 
       {-2.645556176913418, -3.75}, {-2.8043476264468827, -3.4375}, 
       {-2.947079616577351, -3.125}, {-3.0744462949685563, -2.8125}, 
       {-3.1870336467217917, -2.5}, {-3.285335063038256, -2.1875}, 
       {-3.3697635009278692, -1.875}, {-3.4406610073320936, -1.5625}, 
       {-3.4983061651113845, -1.25}, {-3.542919865616026, -0.9375}, 
       {-3.5746697019586033, -0.625}, {-3.593673194879362, -0.3125}, 
       {-3.5999999999999996, 0.}, {-3.593673194879362, 0.3125}, 
       {-3.5746697019586033, 0.625}, {-3.542919865616026, 0.9375}, 
       {-3.4983061651113845, 1.25}, {-3.4406610073320936, 1.5625}, 
       {-3.3697635009278692, 1.875}, {-3.285335063038256, 2.1875}, 
       {-3.1870336467217917, 2.5}, {-3.0744462949685563, 2.8125}, 
       {-2.947079616577351, 3.125}, {-2.8043476264468827, 3.4375}, 
       {-2.645556176913418, 3.75}, {-2.4698828946113975, 4.0625}, 
       {-2.276351075688101, 4.375}, {-2.0637952929044054, 4.6875}, 
       {-1.830815380800448, 5.}, {-1.575713724426754, 5.3125}, 
       {-1.2964078972773794, 5.625}, {-0.9903057458473903, 5.9375}, 
       {-0.654121133468629, 6.25}, {-0.654121133468629, 6.25}, 
       {-0.9903057458473903, 5.9375}, {-1.2964078972773794, 5.625}, 
       {-1.575713724426754, 5.3125}, {-1.830815380800448, 5.}, 
       {-2.0637952929044054, 4.6875}, {-2.276351075688101, 4.375}, 
       {-2.4698828946113975, 4.0625}, {-2.645556176913418, 3.75}, 
       {-2.8043476264468827, 3.4375}, {-2.947079616577351, 3.125}, 
       {-3.0744462949685563, 2.8125}, {-3.1870336467217917, 2.5}, 
       {-3.285335063038256, 2.1875}, {-3.3697635009278692, 1.875}, 
       {-3.4406610073320936, 1.5625}, {-3.4983061651113845, 1.25}, 
       {-3.542919865616026, 0.9375}, {-3.5746697019586033, 0.625}, 
       {-3.593673194879362, 0.3125}, {-3.5999999999999996, 0.}, 
       {-3.593673194879362, -0.3125}, {-3.5746697019586033, -0.625}, 
       {-3.542919865616026, -0.9375}, {-3.4983061651113845, -1.25}, 
       {-3.4406610073320936, -1.5625}, {-3.3697635009278692, -1.875}, 
       {-3.285335063038256, -2.1875}, {-3.1870336467217917, -2.5}, 
       {-3.0744462949685563, -2.8125}, {-2.947079616577351, -3.125}, 
       {-2.8043476264468827, -3.4375}, {-2.645556176913418, -3.75}, 
       {-2.4698828946113975, -4.0625}, {-2.276351075688101, -4.375}, 
       {-2.0637952929044054, -4.6875}, {-1.830815380800448, -5.}, 
       {-1.575713724426754, -5.3125}, {-1.2964078972773794, -5.625}, 
       {-0.9903057458473903, -5.9375}, {-0.654121133468629, -6.25}, 
       {-0.654121133468629, -6.25}}, {{-0.7033119314590373, -5.}, 
       {-0.9870598373247121, -4.75}, {-1.2404157598234296, -4.5}, 
       {-1.4680788932265, -4.25}, {-1.6734753829797988, -4.}, 
       {-1.8591901453988253, -3.75}, {-2.027225575051661, -3.5}, 
       {-2.1791651245988506, -3.25}, {-2.316281297335398, -3.}, 
       {-2.4396094946948734, -2.75}, {-2.55, -2.5}, 
       {-2.648155458825234, -2.25}, {-2.7346584384264903, -2.}, 
       {-2.8099920127744573, -1.75}, {-2.874555320336759, -1.5}, 
       {-2.9286754110865365, -1.25}, {-2.9726162893325645, -1.}, 
       {-3.0065857850724784, -0.75}, {-3.03074069840786, -0.5}, 
       {-3.04519052838329, -0.25}, {-3.05, 0.}, {-3.04519052838329, 
        0.25}, {-3.03074069840786, 0.5}, {-3.0065857850724784, 0.75}, 
       {-2.9726162893325645, 1.}, {-2.9286754110865365, 1.25}, 
       {-2.874555320336759, 1.5}, {-2.8099920127744573, 1.75}, 
       {-2.7346584384264903, 2.}, {-2.648155458825234, 2.25}, 
       {-2.55, 2.5}, {-2.4396094946948734, 2.75}, {-2.316281297335398, 
        3.}, {-2.1791651245988506, 3.25}, {-2.027225575051661, 3.5}, 
       {-1.8591901453988253, 3.75}, {-1.6734753829797988, 4.}, 
       {-1.4680788932265, 4.25}, {-1.2404157598234296, 4.5}, 
       {-0.9870598373247121, 4.75}, {-0.7033119314590373, 5.}, 
       {-0.7033119314590373, 5.}, {-0.9870598373247121, 4.75}, 
       {-1.2404157598234296, 4.5}, {-1.4680788932265, 4.25}, 
       {-1.6734753829797988, 4.}, {-1.8591901453988253, 3.75}, 
       {-2.027225575051661, 3.5}, {-2.1791651245988506, 3.25}, 
       {-2.316281297335398, 3.}, {-2.4396094946948734, 2.75}, 
       {-2.55, 2.5}, {-2.648155458825234, 2.25}, {-2.7346584384264903, 
        2.}, {-2.8099920127744573, 1.75}, {-2.874555320336759, 1.5}, 
       {-2.9286754110865365, 1.25}, {-2.9726162893325645, 1.}, 
       {-3.0065857850724784, 0.75}, {-3.03074069840786, 0.5}, 
       {-3.04519052838329, 0.25}, {-3.05, 0.}, {-3.04519052838329, 
        -0.25}, {-3.03074069840786, -0.5}, {-3.0065857850724784, -0.75}, 
       {-2.9726162893325645, -1.}, {-2.9286754110865365, -1.25}, 
       {-2.874555320336759, -1.5}, {-2.8099920127744573, -1.75}, 
       {-2.7346584384264903, -2.}, {-2.648155458825234, -2.25}, 
       {-2.55, -2.5}, {-2.4396094946948734, -2.75}, 
       {-2.316281297335398, -3.}, {-2.1791651245988506, -3.25}, 
       {-2.027225575051661, -3.5}, {-1.8591901453988253, -3.75}, 
       {-1.6734753829797988, -4.}, {-1.4680788932265, -4.25}, 
       {-1.2404157598234296, -4.5}, {-0.9870598373247121, -4.75}, 
       {-0.7033119314590373, -5.}, {-0.7033119314590373, -5.}}, 
      {{-0.05, -2.5}, {-0.05, -2.375}, {-0.05, -2.25}, {-0.05, -2.125}, 
       {-0.05, -2.}, {-0.05, -1.875}, {-0.05, -1.75}, {-0.05, -1.625}, 
       {-0.05, -1.5}, {-0.05, -1.375}, {-0.05, -1.25}, {-0.05, -1.125}, 
       {-0.05, -1.}, {-0.05, -0.875}, {-0.05, -0.75}, {-0.05, -0.625}, 
       {-0.05, -0.5}, {-0.05, -0.375}, {-0.05, -0.25}, {-0.05, -0.125}, 
       {-0.05, 0.}, {-0.05, 0.125}, {-0.05, 0.25}, {-0.05, 0.375}, 
       {-0.05, 0.5}, {-0.05, 0.625}, {-0.05, 0.75}, {-0.05, 0.875}, 
       {-0.05, 1.}, {-0.05, 1.125}, {-0.05, 1.25}, {-0.05, 1.375}, 
       {-0.05, 1.5}, {-0.05, 1.625}, {-0.05, 1.75}, {-0.05, 1.875}, 
       {-0.05, 2.}, {-0.05, 2.125}, {-0.05, 2.25}, {-0.05, 2.375}, 
       {-0.05, 2.5}, {-0.05, 2.5}, {-0.05, 2.375}, {-0.05, 2.25}, 
       {-0.05, 2.125}, {-0.05, 2.}, {-0.05, 1.875}, {-0.05, 1.75}, 
       {-0.05, 1.625}, {-0.05, 1.5}, {-0.05, 1.375}, {-0.05, 1.25}, 
       {-0.05, 1.125}, {-0.05, 1.}, {-0.05, 0.875}, {-0.05, 0.75}, 
       {-0.05, 0.625}, {-0.05, 0.5}, {-0.05, 0.375}, {-0.05, 0.25}, 
       {-0.05, 0.125}, {-0.05, 0.}, {-0.05, -0.125}, {-0.05, -0.25}, 
       {-0.05, -0.375}, {-0.05, -0.5}, {-0.05, -0.625}, {-0.05, -0.75}, 
       {-0.05, -0.875}, {-0.05, -1.}, {-0.05, -1.125}, {-0.05, -1.25}, 
       {-0.05, -1.375}, {-0.05, -1.5}, {-0.05, -1.625}, {-0.05, -1.75}, 
       {-0.05, -1.875}, {-0.05, -2.}, {-0.05, -2.125}, {-0.05, -2.25}, 
       {-0.05, -2.375}, {-0.05, -2.5}, {-0.05, -2.5}}, 
      {{-0.05, -5.}, {-0.05, -4.9375}, {-0.05, -4.875}, 
       {-0.05, -4.8125}, {-0.05, -4.75}, {-0.05, -4.6875}, 
       {-0.05, -4.625}, {-0.05, -4.5625}, {-0.05, -4.5}, 
       {-0.05, -4.4375}, {-0.05, -4.375}, {-0.05, -4.3125}, 
       {-0.05, -4.25}, {-0.05, -4.1875}, {-0.05, -4.125}, 
       {-0.05, -4.0625}, {-0.05, -4.}, {-0.05, -3.9375}, 
       {-0.05, -3.875}, {-0.05, -3.8125}, {-0.05, -3.75}, 
       {-0.05, -3.6875}, {-0.05, -3.625}, {-0.05, -3.5625}, 
       {-0.05, -3.5}, {-0.05, -3.4375}, {-0.05, -3.375}, 
       {-0.05, -3.3125}, {-0.05, -3.25}, {-0.05, -3.1875}, 
       {-0.05, -3.125}, {-0.05, -3.0625}, {-0.05, -3.}, 
       {-0.05, -2.9375}, {-0.05, -2.875}, {-0.05, -2.8125}, 
       {-0.05, -2.75}, {-0.05, -2.6875}, {-0.05, -2.625}, 
       {-0.05, -2.5625}, {-0.05, -2.5}, {-0.05, -2.5}, {-0.05, -2.5625}, 
       {-0.05, -2.625}, {-0.05, -2.6875}, {-0.05, -2.75}, 
       {-0.05, -2.8125}, {-0.05, -2.875}, {-0.05, -2.9375}, 
       {-0.05, -3.}, {-0.05, -3.0625}, {-0.05, -3.125}, 
       {-0.05, -3.1875}, {-0.05, -3.25}, {-0.05, -3.3125}, 
       {-0.05, -3.375}, {-0.05, -3.4375}, {-0.05, -3.5}, 
       {-0.05, -3.5625}, {-0.05, -3.625}, {-0.05, -3.6875}, 
       {-0.05, -3.75}, {-0.05, -3.8125}, {-0.05, -3.875}, 
       {-0.05, -3.9375}, {-0.05, -4.}, {-0.05, -4.0625}, 
       {-0.05, -4.125}, {-0.05, -4.1875}, {-0.05, -4.25}, 
       {-0.05, -4.3125}, {-0.05, -4.375}, {-0.05, -4.4375}, 
       {-0.05, -4.5}, {-0.05, -4.5625}, {-0.05, -4.625}, 
       {-0.05, -4.6875}, {-0.05, -4.75}, {-0.05, -4.8125}, 
       {-0.05, -4.875}, {-0.05, -4.9375}, {-0.05, -5.}, {-0.05, -5.}}, 
      {{-0.05, 2.5}, {-0.05, 2.5625}, {-0.05, 2.625}, {-0.05, 2.6875}, 
       {-0.05, 2.75}, {-0.05, 2.8125}, {-0.05, 2.875}, {-0.05, 2.9375}, 
       {-0.05, 3.}, {-0.05, 3.0625}, {-0.05, 3.125}, {-0.05, 3.1875}, 
       {-0.05, 3.25}, {-0.05, 3.3125}, {-0.05, 3.375}, {-0.05, 3.4375}, 
       {-0.05, 3.5}, {-0.05, 3.5625}, {-0.05, 3.625}, {-0.05, 3.6875}, 
       {-0.05, 3.75}, {-0.05, 3.8125}, {-0.05, 3.875}, {-0.05, 3.9375}, 
       {-0.05, 4.}, {-0.05, 4.0625}, {-0.05, 4.125}, {-0.05, 4.1875}, 
       {-0.05, 4.25}, {-0.05, 4.3125}, {-0.05, 4.375}, {-0.05, 4.4375}, 
       {-0.05, 4.5}, {-0.05, 4.5625}, {-0.05, 4.625}, {-0.05, 4.6875}, 
       {-0.05, 4.75}, {-0.05, 4.8125}, {-0.05, 4.875}, {-0.05, 4.9375}, 
       {-0.05, 5.}, {-0.05, 5.}, {-0.05, 4.9375}, {-0.05, 4.875}, 
       {-0.05, 4.8125}, {-0.05, 4.75}, {-0.05, 4.6875}, {-0.05, 4.625}, 
       {-0.05, 4.5625}, {-0.05, 4.5}, {-0.05, 4.4375}, {-0.05, 4.375}, 
       {-0.05, 4.3125}, {-0.05, 4.25}, {-0.05, 4.1875}, {-0.05, 4.125}, 
       {-0.05, 4.0625}, {-0.05, 4.}, {-0.05, 3.9375}, {-0.05, 3.875}, 
       {-0.05, 3.8125}, {-0.05, 3.75}, {-0.05, 3.6875}, {-0.05, 3.625}, 
       {-0.05, 3.5625}, {-0.05, 3.5}, {-0.05, 3.4375}, {-0.05, 3.375}, 
       {-0.05, 3.3125}, {-0.05, 3.25}, {-0.05, 3.1875}, {-0.05, 3.125}, 
       {-0.05, 3.0625}, {-0.05, 3.}, {-0.05, 2.9375}, {-0.05, 2.875}, 
       {-0.05, 2.8125}, {-0.05, 2.75}, {-0.05, 2.6875}, {-0.05, 2.625}, 
       {-0.05, 2.5625}, {-0.05, 2.5}, {-0.05, 2.5}}, 
      {{1.3689976525819987, -5.65}, {1.249200508667663, 
        -5.367500000000001}, {1.133305718014965, -5.085}, 
       {1.0215469448527958, -4.8025}, {0.9141675062554867, 
        -4.5200000000000005}, {0.8114194827665998, -4.237500000000001}, 
       {0.7135625066333096, -3.955}, {0.6208621909813115, 
        -3.6725000000000003}, {0.5335881696456211, -3.39}, 
       {0.4520117276705726, -3.1075}, {0.3764030171799524, -2.825}, 
       {0.30702787256214575, -2.5425}, {0.24414426241533377, -2.26}, 
       {0.18799844254256412, -1.9775}, {0.13882090285648163, 
        -1.6949999999999998}, {0.09682222901675835, 
        -1.4124999999999996}, {0.06218902406370809, -1.13}, 
       {0.03508005301320917, -0.8475000000000001}, 
       {0.01562278125633912, -0.5649999999999995}, 
       {0.0039104732351545445, -0.28249999999999975}, {0., 0.}, 
       {0.003910473235154569, 0.28250000000000064}, 
       {0.01562278125633917, 0.5650000000000004}, {0.03508005301320917, 
        0.8475000000000001}, {0.06218902406370819, 1.1300000000000008}, 
       {0.09682222901675848, 1.4125000000000005}, {0.13882090285648174, 
        1.6950000000000003}, {0.18799844254256412, 1.9775}, 
       {0.244144262415334, 2.2600000000000007}, {0.30702787256214586, 
        2.5425000000000004}, {0.37640301717995267, 2.825000000000001}, 
       {0.4520117276705726, 3.1075}, {0.5335881696456212, 
        3.3900000000000006}, {0.6208621909813118, 3.672500000000001}, 
       {0.7135625066333096, 3.955}, {0.8114194827665998, 
        4.237500000000001}, {0.914167506255487, 4.520000000000001}, 
       {1.0215469448527958, 4.8025}, {1.1333057180149655, 
        5.085000000000001}, {1.2492005086676634, 5.3675000000000015}, 
       {1.3689976525819987, 5.65}, {1.3689976525819987, 5.65}, 
       {1.249200508667663, 5.367500000000001}, {1.133305718014965, 
        5.085}, {1.0215469448527958, 4.8025}, {0.9141675062554867, 
        4.5200000000000005}, {0.8114194827665998, 4.237500000000001}, 
       {0.7135625066333096, 3.955}, {0.6208621909813115, 
        3.6725000000000003}, {0.5335881696456211, 3.39}, 
       {0.4520117276705726, 3.1075}, {0.3764030171799524, 2.825}, 
       {0.30702787256214575, 2.5425}, {0.24414426241533377, 2.26}, 
       {0.18799844254256412, 1.9775}, {0.13882090285648163, 
        1.6949999999999998}, {0.09682222901675835, 1.4124999999999996}, 
       {0.06218902406370809, 1.13}, {0.03508005301320917, 
        0.8475000000000001}, {0.01562278125633912, 0.5649999999999995}, 
       {0.0039104732351545445, 0.28249999999999975}, {0., 0.}, 
       {0.003910473235154569, -0.28250000000000064}, 
       {0.01562278125633917, -0.5650000000000004}, 
       {0.03508005301320917, -0.8475000000000001}, 
       {0.06218902406370819, -1.1300000000000008}, 
       {0.09682222901675848, -1.4125000000000005}, 
       {0.13882090285648174, -1.6950000000000003}, 
       {0.18799844254256412, -1.9775}, {0.244144262415334, 
        -2.2600000000000007}, {0.30702787256214586, 
        -2.5425000000000004}, {0.37640301717995267, -2.825000000000001}, 
       {0.4520117276705726, -3.1075}, {0.5335881696456212, 
        -3.3900000000000006}, {0.6208621909813118, -3.672500000000001}, 
       {0.7135625066333096, -3.955}, {0.8114194827665998, 
        -4.237500000000001}, {0.914167506255487, -4.520000000000001}, 
       {1.0215469448527958, -4.8025}, {1.1333057180149655, 
        -5.085000000000001}, {1.2492005086676634, -5.3675000000000015}, 
       {1.3689976525819987, -5.65}, {1.3689976525819987, -5.65}}, 
      {{1.3397916666666667, -5.65}, {1.5991619791666665, 
        -5.367500000000001}, {1.8452312500000003, -5.085}, 
       {2.0779994791666665, -4.8025}, {2.2974666666666663, 
        -4.5200000000000005}, {2.5036328124999994, -4.237500000000001}, 
       {2.696497916666667, -3.955}, {2.876061979166667, 
        -3.6725000000000003}, {3.042325, -3.39}, {3.1952869791666667, 
        -3.1075}, {3.3349479166666667, -2.825}, {3.4613078125000003, 
        -2.5425}, {3.5743666666666667, -2.26}, {3.6741244791666667, 
        -1.9775}, {3.76058125, -1.6949999999999998}, 
       {3.833736979166667, -1.4124999999999996}, {3.8935916666666666, 
        -1.13}, {3.9401453125, -0.8475000000000001}, 
       {3.973397916666667, -0.5649999999999995}, {3.9933494791666666, 
        -0.28249999999999975}, {4., 0.}, {3.9933494791666666, 
        0.28250000000000064}, {3.9733979166666664, 0.5650000000000004}, 
       {3.9401453125, 0.8475000000000001}, {3.8935916666666666, 
        1.1300000000000008}, {3.8337369791666664, 1.4125000000000005}, 
       {3.76058125, 1.6950000000000003}, {3.6741244791666667, 1.9775}, 
       {3.5743666666666662, 2.2600000000000007}, 
       {3.4613078125, 2.5425000000000004}, {3.3349479166666662, 
        2.825000000000001}, {3.1952869791666667, 3.1075}, 
       {3.042325, 3.3900000000000006}, {2.876061979166666, 
        3.672500000000001}, {2.696497916666667, 3.955}, 
       {2.5036328124999994, 4.237500000000001}, {2.297466666666666, 
        4.520000000000001}, {2.0779994791666665, 4.8025}, 
       {1.8452312499999994, 5.085000000000001}, {1.5991619791666656, 
        5.3675000000000015}, {1.3397916666666667, 5.65}, 
       {1.3397916666666667, 5.65}, {1.5991619791666665, 
        5.367500000000001}, {1.8452312500000003, 5.085}, 
       {2.0779994791666665, 4.8025}, {2.2974666666666663, 
        4.5200000000000005}, {2.5036328124999994, 4.237500000000001}, 
       {2.696497916666667, 3.955}, {2.876061979166667, 
        3.6725000000000003}, {3.042325, 3.39}, {3.1952869791666667, 
        3.1075}, {3.3349479166666667, 2.825}, {3.4613078125000003, 
        2.5425}, {3.5743666666666667, 2.26}, {3.6741244791666667, 
        1.9775}, {3.76058125, 1.6949999999999998}, 
       {3.833736979166667, 1.4124999999999996}, {3.8935916666666666, 
        1.13}, {3.9401453125, 0.8475000000000001}, 
       {3.973397916666667, 0.5649999999999995}, {3.9933494791666666, 
        0.28249999999999975}, {4., 0.}, {3.9933494791666666, 
        -0.28250000000000064}, {3.9733979166666664, 
        -0.5650000000000004}, {3.9401453125, -0.8475000000000001}, 
       {3.8935916666666666, -1.1300000000000008}, {3.8337369791666664, 
        -1.4125000000000005}, {3.76058125, -1.6950000000000003}, 
       {3.6741244791666667, -1.9775}, {3.5743666666666662, 
        -2.2600000000000007}, {3.4613078125, -2.5425000000000004}, 
       {3.3349479166666662, -2.825000000000001}, {3.1952869791666667, 
        -3.1075}, {3.042325, -3.3900000000000006}, 
       {2.876061979166666, -3.672500000000001}, {2.696497916666667, 
        -3.955}, {2.5036328124999994, -4.237500000000001}, 
       {2.297466666666666, -4.520000000000001}, {2.0779994791666665, 
        -4.8025}, {1.8452312499999994, -5.085000000000001}, 
       {1.5991619791666656, -5.3675000000000015}, {1.3397916666666667, 
        -5.65}, {1.3397916666666667, -5.65}}, 
      {{9.414603431411972, -11.95}, {12.208840053799115, -11.3525}, 
       {13.642891004388748, -10.754999999999999}, {14.709759581999093, 
        -10.157499999999999}, {15.573326954313629, -9.559999999999999}, 
       {16.299873531837402, -8.962499999999999}, {16.924181391558115, 
        -8.364999999999998}, {17.46720897243435, -7.767499999999999}, 
       {17.942726928795043, -7.169999999999999}, {18.360332059211764, 
        -6.572499999999999}, {18.726998563905845, -5.974999999999999}, 
       {19.04795089616548, -5.377499999999999}, {19.327188752049782, 
        -4.779999999999999}, {19.567819448749578, -4.182499999999999}, 
       {19.772276903574333, -3.584999999999999}, {19.942470354542216, 
        -2.987499999999999}, {20.079887577802207, -2.389999999999999}, 
       {20.18566740897643, -1.7924999999999986}, {20.260650706742243, 
        -1.1949999999999985}, {20.305415508412924, -0.5974999999999984}, 
       {20.3203, 1.7763568394002505*^-15}, {20.305415508412924, 
        0.5975000000000019}, {20.260650706742243, 1.195000000000002}, 
       {20.18566740897643, 1.7925000000000022}, {20.079887577802207, 
        2.3900000000000006}, {19.942470354542216, 2.9875000000000007}, 
       {19.772276903574333, 3.585000000000001}, {19.567819448749574, 
        4.182500000000001}, {19.32718875204978, 4.780000000000001}, 
       {19.047950896165478, 5.377500000000001}, {18.726998563905845, 
        5.975000000000001}, {18.360332059211764, 6.572500000000002}, 
       {17.94272692879504, 7.170000000000002}, {17.46720897243435, 
        7.767500000000002}, {16.924181391558115, 8.365000000000002}, 
       {16.2998735318374, 8.962500000000002}, {15.573326954313622, 
        9.560000000000002}, {14.709759581999087, 10.157500000000002}, 
       {13.64289100438874, 10.755000000000003}, {12.208840053799104, 
        11.352500000000003}, {9.414603431411933, 11.950000000000003}, 
       {9.414603431411972, 11.95}, {12.208840053799115, 11.3525}, 
       {13.642891004388748, 10.754999999999999}, {14.709759581999093, 
        10.157499999999999}, {15.573326954313629, 9.559999999999999}, 
       {16.299873531837402, 8.962499999999999}, {16.924181391558115, 
        8.364999999999998}, {17.46720897243435, 7.767499999999999}, 
       {17.942726928795043, 7.169999999999999}, {18.360332059211764, 
        6.572499999999999}, {18.726998563905845, 5.974999999999999}, 
       {19.04795089616548, 5.377499999999999}, {19.327188752049782, 
        4.779999999999999}, {19.567819448749578, 4.182499999999999}, 
       {19.772276903574333, 3.584999999999999}, {19.942470354542216, 
        2.987499999999999}, {20.079887577802207, 2.389999999999999}, 
       {20.18566740897643, 1.7924999999999986}, {20.260650706742243, 
        1.1949999999999985}, {20.305415508412924, 0.5974999999999984}, 
       {20.3203, -1.7763568394002505*^-15}, {20.305415508412924, 
        -0.5975000000000019}, {20.260650706742243, -1.195000000000002}, 
       {20.18566740897643, -1.7925000000000022}, {20.079887577802207, 
        -2.3900000000000006}, {19.942470354542216, -2.9875000000000007}, 
       {19.772276903574333, -3.585000000000001}, {19.567819448749574, 
        -4.182500000000001}, {19.32718875204978, -4.780000000000001}, 
       {19.047950896165478, -5.377500000000001}, {18.726998563905845, 
        -5.975000000000001}, {18.360332059211764, -6.572500000000002}, 
       {17.94272692879504, -7.170000000000002}, {17.46720897243435, 
        -7.767500000000002}, {16.924181391558115, -8.365000000000002}, 
       {16.2998735318374, -8.962500000000002}, {15.573326954313622, 
        -9.560000000000002}, {14.709759581999087, -10.157500000000002}, 
       {13.64289100438874, -10.755000000000003}, {12.208840053799104, 
        -11.352500000000003}, {9.414603431411933, -11.950000000000003}, 
       {9.414603431411972, -11.95}}}]}}, ControlType -> None}, 
 {{staticpolygons211864020083128460945430, 
   {GrayLevel[0], AbsoluteThickness[0.5], 
    Line[{{{-0.654121133468629, -6.25, 0.}, {-0.9903057458473903, 
        -5.9375, 0.}, {-1.2964078972773794, -5.625, 0.}, 
       {-1.575713724426754, -5.3125, 0.}, {-1.830815380800448, -5., 0.}, 
       {-2.0637952929044054, -4.6875, 0.}, {-2.276351075688101, -4.375, 
        0.}, {-2.4698828946113975, -4.0625, 0.}, {-2.645556176913418, 
        -3.75, 0.}, {-2.8043476264468827, -3.4375, 0.}, 
       {-2.947079616577351, -3.125, 0.}, {-3.0744462949685563, -2.8125, 
        0.}, {-3.1870336467217917, -2.5, 0.}, {-3.285335063038256, 
        -2.1875, 0.}, {-3.3697635009278692, -1.875, 0.}, 
       {-3.4406610073320936, -1.5625, 0.}, {-3.4983061651113845, -1.25, 
        0.}, {-3.542919865616026, -0.9375, 0.}, {-3.5746697019586033, 
        -0.625, 0.}, {-3.593673194879362, -0.3125, 0.}, 
       {-3.5999999999999996, 0., 0.}, {-3.593673194879362, 0.3125, 0.}, 
       {-3.5746697019586033, 0.625, 0.}, {-3.542919865616026, 0.9375, 
        0.}, {-3.4983061651113845, 1.25, 0.}, {-3.4406610073320936, 
        1.5625, 0.}, {-3.3697635009278692, 1.875, 0.}, 
       {-3.285335063038256, 2.1875, 0.}, {-3.1870336467217917, 2.5, 0.}, 
       {-3.0744462949685563, 2.8125, 0.}, {-2.947079616577351, 3.125, 
        0.}, {-2.8043476264468827, 3.4375, 0.}, {-2.645556176913418, 
        3.75, 0.}, {-2.4698828946113975, 4.0625, 0.}, 
       {-2.276351075688101, 4.375, 0.}, {-2.0637952929044054, 4.6875, 
        0.}, {-1.830815380800448, 5., 0.}, {-1.575713724426754, 5.3125, 
        0.}, {-1.2964078972773794, 5.625, 0.}, {-0.9903057458473903, 
        5.9375, 0.}, {-0.654121133468629, 6.25, 0.}, 
       {-0.654121133468629, 6.25, 0.}, {-0.9903057458473903, 5.9375, 
        0.}, {-1.2964078972773794, 5.625, 0.}, {-1.575713724426754, 
        5.3125, 0.}, {-1.830815380800448, 5., 0.}, 
       {-2.0637952929044054, 4.6875, 0.}, {-2.276351075688101, 4.375, 
        0.}, {-2.4698828946113975, 4.0625, 0.}, {-2.645556176913418, 
        3.75, 0.}, {-2.8043476264468827, 3.4375, 0.}, 
       {-2.947079616577351, 3.125, 0.}, {-3.0744462949685563, 2.8125, 
        0.}, {-3.1870336467217917, 2.5, 0.}, {-3.285335063038256, 
        2.1875, 0.}, {-3.3697635009278692, 1.875, 0.}, 
       {-3.4406610073320936, 1.5625, 0.}, {-3.4983061651113845, 1.25, 
        0.}, {-3.542919865616026, 0.9375, 0.}, {-3.5746697019586033, 
        0.625, 0.}, {-3.593673194879362, 0.3125, 0.}, 
       {-3.5999999999999996, 0., 0.}, {-3.593673194879362, -0.3125, 0.}, 
       {-3.5746697019586033, -0.625, 0.}, {-3.542919865616026, -0.9375, 
        0.}, {-3.4983061651113845, -1.25, 0.}, {-3.4406610073320936, 
        -1.5625, 0.}, {-3.3697635009278692, -1.875, 0.}, 
       {-3.285335063038256, -2.1875, 0.}, {-3.1870336467217917, -2.5, 
        0.}, {-3.0744462949685563, -2.8125, 0.}, {-2.947079616577351, 
        -3.125, 0.}, {-2.8043476264468827, -3.4375, 0.}, 
       {-2.645556176913418, -3.75, 0.}, {-2.4698828946113975, -4.0625, 
        0.}, {-2.276351075688101, -4.375, 0.}, {-2.0637952929044054, 
        -4.6875, 0.}, {-1.830815380800448, -5., 0.}, 
       {-1.575713724426754, -5.3125, 0.}, {-1.2964078972773794, -5.625, 
        0.}, {-0.9903057458473903, -5.9375, 0.}, {-0.654121133468629, 
        -6.25, 0.}, {-0.654121133468629, -6.25, 0.}}, 
      {{-0.654121133468629, 0., -6.25}, {-0.9903057458473903, 0., 
        -5.9375}, {-1.2964078972773794, 0., -5.625}, 
       {-1.575713724426754, 0., -5.3125}, {-1.830815380800448, 0., -5.}, 
       {-2.0637952929044054, 0., -4.6875}, {-2.276351075688101, 0., 
        -4.375}, {-2.4698828946113975, 0., -4.0625}, 
       {-2.645556176913418, 0., -3.75}, {-2.8043476264468827, 0., 
        -3.4375}, {-2.947079616577351, 0., -3.125}, 
       {-3.0744462949685563, 0., -2.8125}, {-3.1870336467217917, 0., 
        -2.5}, {-3.285335063038256, 0., -2.1875}, {-3.3697635009278692, 
        0., -1.875}, {-3.4406610073320936, 0., -1.5625}, 
       {-3.4983061651113845, 0., -1.25}, {-3.542919865616026, 0., 
        -0.9375}, {-3.5746697019586033, 0., -0.625}, 
       {-3.593673194879362, 0., -0.3125}, {-3.5999999999999996, 0., 0.}, 
       {-3.593673194879362, 0., 0.3125}, {-3.5746697019586033, 0., 
        0.625}, {-3.542919865616026, 0., 0.9375}, {-3.4983061651113845, 
        0., 1.25}, {-3.4406610073320936, 0., 1.5625}, 
       {-3.3697635009278692, 0., 1.875}, {-3.285335063038256, 0., 
        2.1875}, {-3.1870336467217917, 0., 2.5}, {-3.0744462949685563, 
        0., 2.8125}, {-2.947079616577351, 0., 3.125}, 
       {-2.8043476264468827, 0., 3.4375}, {-2.645556176913418, 0., 
        3.75}, {-2.4698828946113975, 0., 4.0625}, {-2.276351075688101, 
        0., 4.375}, {-2.0637952929044054, 0., 4.6875}, 
       {-1.830815380800448, 0., 5.}, {-1.575713724426754, 0., 5.3125}, 
       {-1.2964078972773794, 0., 5.625}, {-0.9903057458473903, 0., 
        5.9375}, {-0.654121133468629, 0., 6.25}, {-0.654121133468629, 
        0., 6.25}, {-0.9903057458473903, 0., 5.9375}, 
       {-1.2964078972773794, 0., 5.625}, {-1.575713724426754, 0., 
        5.3125}, {-1.830815380800448, 0., 5.}, {-2.0637952929044054, 0., 
        4.6875}, {-2.276351075688101, 0., 4.375}, {-2.4698828946113975, 
        0., 4.0625}, {-2.645556176913418, 0., 3.75}, 
       {-2.8043476264468827, 0., 3.4375}, {-2.947079616577351, 0., 
        3.125}, {-3.0744462949685563, 0., 2.8125}, 
       {-3.1870336467217917, 0., 2.5}, {-3.285335063038256, 0., 2.1875}, 
       {-3.3697635009278692, 0., 1.875}, {-3.4406610073320936, 0., 
        1.5625}, {-3.4983061651113845, 0., 1.25}, {-3.542919865616026, 
        0., 0.9375}, {-3.5746697019586033, 0., 0.625}, 
       {-3.593673194879362, 0., 0.3125}, {-3.5999999999999996, 0., 0.}, 
       {-3.593673194879362, 0., -0.3125}, {-3.5746697019586033, 0., 
        -0.625}, {-3.542919865616026, 0., -0.9375}, 
       {-3.4983061651113845, 0., -1.25}, {-3.4406610073320936, 0., 
        -1.5625}, {-3.3697635009278692, 0., -1.875}, 
       {-3.285335063038256, 0., -2.1875}, {-3.1870336467217917, 0., 
        -2.5}, {-3.0744462949685563, 0., -2.8125}, 
       {-2.947079616577351, 0., -3.125}, {-2.8043476264468827, 0., 
        -3.4375}, {-2.645556176913418, 0., -3.75}, 
       {-2.4698828946113975, 0., -4.0625}, {-2.276351075688101, 0., 
        -4.375}, {-2.0637952929044054, 0., -4.6875}, 
       {-1.830815380800448, 0., -5.}, {-1.575713724426754, 0., -5.3125}, 
       {-1.2964078972773794, 0., -5.625}, {-0.9903057458473903, 0., 
        -5.9375}, {-0.654121133468629, 0., -6.25}, 
       {-0.654121133468629, 0., -6.25}}, 
      {{-0.7033119314590373, -5., 0.}, {-0.9870598373247121, -4.75, 0.}, 
       {-1.2404157598234296, -4.5, 0.}, {-1.4680788932265, -4.25, 0.}, 
       {-1.6734753829797988, -4., 0.}, {-1.8591901453988253, -3.75, 0.}, 
       {-2.027225575051661, -3.5, 0.}, {-2.1791651245988506, -3.25, 0.}, 
       {-2.316281297335398, -3., 0.}, {-2.4396094946948734, -2.75, 0.}, 
       {-2.55, -2.5, 0.}, {-2.648155458825234, -2.25, 0.}, 
       {-2.7346584384264903, -2., 0.}, {-2.8099920127744573, -1.75, 0.}, 
       {-2.874555320336759, -1.5, 0.}, {-2.9286754110865365, -1.25, 0.}, 
       {-2.9726162893325645, -1., 0.}, {-3.0065857850724784, -0.75, 0.}, 
       {-3.03074069840786, -0.5, 0.}, {-3.04519052838329, -0.25, 0.}, 
       {-3.05, 0., 0.}, {-3.04519052838329, 0.25, 0.}, 
       {-3.03074069840786, 0.5, 0.}, {-3.0065857850724784, 0.75, 0.}, 
       {-2.9726162893325645, 1., 0.}, {-2.9286754110865365, 1.25, 0.}, 
       {-2.874555320336759, 1.5, 0.}, {-2.8099920127744573, 1.75, 0.}, 
       {-2.7346584384264903, 2., 0.}, {-2.648155458825234, 2.25, 0.}, 
       {-2.55, 2.5, 0.}, {-2.4396094946948734, 2.75, 0.}, 
       {-2.316281297335398, 3., 0.}, {-2.1791651245988506, 3.25, 0.}, 
       {-2.027225575051661, 3.5, 0.}, {-1.8591901453988253, 3.75, 0.}, 
       {-1.6734753829797988, 4., 0.}, {-1.4680788932265, 4.25, 0.}, 
       {-1.2404157598234296, 4.5, 0.}, {-0.9870598373247121, 4.75, 0.}, 
       {-0.7033119314590373, 5., 0.}, {-0.7033119314590373, 5., 0.}, 
       {-0.9870598373247121, 4.75, 0.}, {-1.2404157598234296, 4.5, 0.}, 
       {-1.4680788932265, 4.25, 0.}, {-1.6734753829797988, 4., 0.}, 
       {-1.8591901453988253, 3.75, 0.}, {-2.027225575051661, 3.5, 0.}, 
       {-2.1791651245988506, 3.25, 0.}, {-2.316281297335398, 3., 0.}, 
       {-2.4396094946948734, 2.75, 0.}, {-2.55, 2.5, 0.}, 
       {-2.648155458825234, 2.25, 0.}, {-2.7346584384264903, 2., 0.}, 
       {-2.8099920127744573, 1.75, 0.}, {-2.874555320336759, 1.5, 0.}, 
       {-2.9286754110865365, 1.25, 0.}, {-2.9726162893325645, 1., 0.}, 
       {-3.0065857850724784, 0.75, 0.}, {-3.03074069840786, 0.5, 0.}, 
       {-3.04519052838329, 0.25, 0.}, {-3.05, 0., 0.}, 
       {-3.04519052838329, -0.25, 0.}, {-3.03074069840786, -0.5, 0.}, 
       {-3.0065857850724784, -0.75, 0.}, {-2.9726162893325645, -1., 0.}, 
       {-2.9286754110865365, -1.25, 0.}, {-2.874555320336759, -1.5, 0.}, 
       {-2.8099920127744573, -1.75, 0.}, {-2.7346584384264903, -2., 0.}, 
       {-2.648155458825234, -2.25, 0.}, {-2.55, -2.5, 0.}, 
       {-2.4396094946948734, -2.75, 0.}, {-2.316281297335398, -3., 0.}, 
       {-2.1791651245988506, -3.25, 0.}, {-2.027225575051661, -3.5, 0.}, 
       {-1.8591901453988253, -3.75, 0.}, {-1.6734753829797988, -4., 0.}, 
       {-1.4680788932265, -4.25, 0.}, {-1.2404157598234296, -4.5, 0.}, 
       {-0.9870598373247121, -4.75, 0.}, {-0.7033119314590373, -5., 0.}, 
       {-0.7033119314590373, -5., 0.}}, {{-0.7033119314590373, 0., -5.}, 
       {-0.9870598373247121, 0., -4.75}, {-1.2404157598234296, 0., 
        -4.5}, {-1.4680788932265, 0., -4.25}, {-1.6734753829797988, 0., 
        -4.}, {-1.8591901453988253, 0., -3.75}, {-2.027225575051661, 0., 
        -3.5}, {-2.1791651245988506, 0., -3.25}, {-2.316281297335398, 
        0., -3.}, {-2.4396094946948734, 0., -2.75}, {-2.55, 0., -2.5}, 
       {-2.648155458825234, 0., -2.25}, {-2.7346584384264903, 0., -2.}, 
       {-2.8099920127744573, 0., -1.75}, {-2.874555320336759, 0., -1.5}, 
       {-2.9286754110865365, 0., -1.25}, {-2.9726162893325645, 0., -1.}, 
       {-3.0065857850724784, 0., -0.75}, {-3.03074069840786, 0., -0.5}, 
       {-3.04519052838329, 0., -0.25}, {-3.05, 0., 0.}, 
       {-3.04519052838329, 0., 0.25}, {-3.03074069840786, 0., 0.5}, 
       {-3.0065857850724784, 0., 0.75}, {-2.9726162893325645, 0., 1.}, 
       {-2.9286754110865365, 0., 1.25}, {-2.874555320336759, 0., 1.5}, 
       {-2.8099920127744573, 0., 1.75}, {-2.7346584384264903, 0., 2.}, 
       {-2.648155458825234, 0., 2.25}, {-2.55, 0., 2.5}, 
       {-2.4396094946948734, 0., 2.75}, {-2.316281297335398, 0., 3.}, 
       {-2.1791651245988506, 0., 3.25}, {-2.027225575051661, 0., 3.5}, 
       {-1.8591901453988253, 0., 3.75}, {-1.6734753829797988, 0., 4.}, 
       {-1.4680788932265, 0., 4.25}, {-1.2404157598234296, 0., 4.5}, 
       {-0.9870598373247121, 0., 4.75}, {-0.7033119314590373, 0., 5.}, 
       {-0.7033119314590373, 0., 5.}, {-0.9870598373247121, 0., 4.75}, 
       {-1.2404157598234296, 0., 4.5}, {-1.4680788932265, 0., 4.25}, 
       {-1.6734753829797988, 0., 4.}, {-1.8591901453988253, 0., 3.75}, 
       {-2.027225575051661, 0., 3.5}, {-2.1791651245988506, 0., 3.25}, 
       {-2.316281297335398, 0., 3.}, {-2.4396094946948734, 0., 2.75}, 
       {-2.55, 0., 2.5}, {-2.648155458825234, 0., 2.25}, 
       {-2.7346584384264903, 0., 2.}, {-2.8099920127744573, 0., 1.75}, 
       {-2.874555320336759, 0., 1.5}, {-2.9286754110865365, 0., 1.25}, 
       {-2.9726162893325645, 0., 1.}, {-3.0065857850724784, 0., 0.75}, 
       {-3.03074069840786, 0., 0.5}, {-3.04519052838329, 0., 0.25}, 
       {-3.05, 0., 0.}, {-3.04519052838329, 0., -0.25}, 
       {-3.03074069840786, 0., -0.5}, {-3.0065857850724784, 0., -0.75}, 
       {-2.9726162893325645, 0., -1.}, {-2.9286754110865365, 0., -1.25}, 
       {-2.874555320336759, 0., -1.5}, {-2.8099920127744573, 0., -1.75}, 
       {-2.7346584384264903, 0., -2.}, {-2.648155458825234, 0., -2.25}, 
       {-2.55, 0., -2.5}, {-2.4396094946948734, 0., -2.75}, 
       {-2.316281297335398, 0., -3.}, {-2.1791651245988506, 0., -3.25}, 
       {-2.027225575051661, 0., -3.5}, {-1.8591901453988253, 0., -3.75}, 
       {-1.6734753829797988, 0., -4.}, {-1.4680788932265, 0., -4.25}, 
       {-1.2404157598234296, 0., -4.5}, {-0.9870598373247121, 0., 
        -4.75}, {-0.7033119314590373, 0., -5.}, {-0.7033119314590373, 
        0., -5.}}, {{-0.05, -2.5, 0.}, {-0.05, -2.375, 0.}, 
       {-0.05, -2.25, 0.}, {-0.05, -2.125, 0.}, {-0.05, -2., 0.}, 
       {-0.05, -1.875, 0.}, {-0.05, -1.75, 0.}, {-0.05, -1.625, 0.}, 
       {-0.05, -1.5, 0.}, {-0.05, -1.375, 0.}, {-0.05, -1.25, 0.}, 
       {-0.05, -1.125, 0.}, {-0.05, -1., 0.}, {-0.05, -0.875, 0.}, 
       {-0.05, -0.75, 0.}, {-0.05, -0.625, 0.}, {-0.05, -0.5, 0.}, 
       {-0.05, -0.375, 0.}, {-0.05, -0.25, 0.}, {-0.05, -0.125, 0.}, 
       {-0.05, 0., 0.}, {-0.05, 0.125, 0.}, {-0.05, 0.25, 0.}, 
       {-0.05, 0.375, 0.}, {-0.05, 0.5, 0.}, {-0.05, 0.625, 0.}, 
       {-0.05, 0.75, 0.}, {-0.05, 0.875, 0.}, {-0.05, 1., 0.}, 
       {-0.05, 1.125, 0.}, {-0.05, 1.25, 0.}, {-0.05, 1.375, 0.}, 
       {-0.05, 1.5, 0.}, {-0.05, 1.625, 0.}, {-0.05, 1.75, 0.}, 
       {-0.05, 1.875, 0.}, {-0.05, 2., 0.}, {-0.05, 2.125, 0.}, 
       {-0.05, 2.25, 0.}, {-0.05, 2.375, 0.}, {-0.05, 2.5, 0.}, 
       {-0.05, 2.5, 0.}, {-0.05, 2.375, 0.}, {-0.05, 2.25, 0.}, 
       {-0.05, 2.125, 0.}, {-0.05, 2., 0.}, {-0.05, 1.875, 0.}, 
       {-0.05, 1.75, 0.}, {-0.05, 1.625, 0.}, {-0.05, 1.5, 0.}, 
       {-0.05, 1.375, 0.}, {-0.05, 1.25, 0.}, {-0.05, 1.125, 0.}, 
       {-0.05, 1., 0.}, {-0.05, 0.875, 0.}, {-0.05, 0.75, 0.}, 
       {-0.05, 0.625, 0.}, {-0.05, 0.5, 0.}, {-0.05, 0.375, 0.}, 
       {-0.05, 0.25, 0.}, {-0.05, 0.125, 0.}, {-0.05, 0., 0.}, 
       {-0.05, -0.125, 0.}, {-0.05, -0.25, 0.}, {-0.05, -0.375, 0.}, 
       {-0.05, -0.5, 0.}, {-0.05, -0.625, 0.}, {-0.05, -0.75, 0.}, 
       {-0.05, -0.875, 0.}, {-0.05, -1., 0.}, {-0.05, -1.125, 0.}, 
       {-0.05, -1.25, 0.}, {-0.05, -1.375, 0.}, {-0.05, -1.5, 0.}, 
       {-0.05, -1.625, 0.}, {-0.05, -1.75, 0.}, {-0.05, -1.875, 0.}, 
       {-0.05, -2., 0.}, {-0.05, -2.125, 0.}, {-0.05, -2.25, 0.}, 
       {-0.05, -2.375, 0.}, {-0.05, -2.5, 0.}, {-0.05, -2.5, 0.}}, 
      {{-0.05, 0., -2.5}, {-0.05, 0., -2.375}, {-0.05, 0., -2.25}, 
       {-0.05, 0., -2.125}, {-0.05, 0., -2.}, {-0.05, 0., -1.875}, 
       {-0.05, 0., -1.75}, {-0.05, 0., -1.625}, {-0.05, 0., -1.5}, 
       {-0.05, 0., -1.375}, {-0.05, 0., -1.25}, {-0.05, 0., -1.125}, 
       {-0.05, 0., -1.}, {-0.05, 0., -0.875}, {-0.05, 0., -0.75}, 
       {-0.05, 0., -0.625}, {-0.05, 0., -0.5}, {-0.05, 0., -0.375}, 
       {-0.05, 0., -0.25}, {-0.05, 0., -0.125}, {-0.05, 0., 0.}, 
       {-0.05, 0., 0.125}, {-0.05, 0., 0.25}, {-0.05, 0., 0.375}, 
       {-0.05, 0., 0.5}, {-0.05, 0., 0.625}, {-0.05, 0., 0.75}, 
       {-0.05, 0., 0.875}, {-0.05, 0., 1.}, {-0.05, 0., 1.125}, 
       {-0.05, 0., 1.25}, {-0.05, 0., 1.375}, {-0.05, 0., 1.5}, 
       {-0.05, 0., 1.625}, {-0.05, 0., 1.75}, {-0.05, 0., 1.875}, 
       {-0.05, 0., 2.}, {-0.05, 0., 2.125}, {-0.05, 0., 2.25}, 
       {-0.05, 0., 2.375}, {-0.05, 0., 2.5}, {-0.05, 0., 2.5}, 
       {-0.05, 0., 2.375}, {-0.05, 0., 2.25}, {-0.05, 0., 2.125}, 
       {-0.05, 0., 2.}, {-0.05, 0., 1.875}, {-0.05, 0., 1.75}, 
       {-0.05, 0., 1.625}, {-0.05, 0., 1.5}, {-0.05, 0., 1.375}, 
       {-0.05, 0., 1.25}, {-0.05, 0., 1.125}, {-0.05, 0., 1.}, 
       {-0.05, 0., 0.875}, {-0.05, 0., 0.75}, {-0.05, 0., 0.625}, 
       {-0.05, 0., 0.5}, {-0.05, 0., 0.375}, {-0.05, 0., 0.25}, 
       {-0.05, 0., 0.125}, {-0.05, 0., 0.}, {-0.05, 0., -0.125}, 
       {-0.05, 0., -0.25}, {-0.05, 0., -0.375}, {-0.05, 0., -0.5}, 
       {-0.05, 0., -0.625}, {-0.05, 0., -0.75}, {-0.05, 0., -0.875}, 
       {-0.05, 0., -1.}, {-0.05, 0., -1.125}, {-0.05, 0., -1.25}, 
       {-0.05, 0., -1.375}, {-0.05, 0., -1.5}, {-0.05, 0., -1.625}, 
       {-0.05, 0., -1.75}, {-0.05, 0., -1.875}, {-0.05, 0., -2.}, 
       {-0.05, 0., -2.125}, {-0.05, 0., -2.25}, {-0.05, 0., -2.375}, 
       {-0.05, 0., -2.5}, {-0.05, 0., -2.5}}, {{-0.05, -5., 0.}, 
       {-0.05, -4.9375, 0.}, {-0.05, -4.875, 0.}, {-0.05, -4.8125, 0.}, 
       {-0.05, -4.75, 0.}, {-0.05, -4.6875, 0.}, {-0.05, -4.625, 0.}, 
       {-0.05, -4.5625, 0.}, {-0.05, -4.5, 0.}, {-0.05, -4.4375, 0.}, 
       {-0.05, -4.375, 0.}, {-0.05, -4.3125, 0.}, {-0.05, -4.25, 0.}, 
       {-0.05, -4.1875, 0.}, {-0.05, -4.125, 0.}, {-0.05, -4.0625, 0.}, 
       {-0.05, -4., 0.}, {-0.05, -3.9375, 0.}, {-0.05, -3.875, 0.}, 
       {-0.05, -3.8125, 0.}, {-0.05, -3.75, 0.}, {-0.05, -3.6875, 0.}, 
       {-0.05, -3.625, 0.}, {-0.05, -3.5625, 0.}, {-0.05, -3.5, 0.}, 
       {-0.05, -3.4375, 0.}, {-0.05, -3.375, 0.}, {-0.05, -3.3125, 0.}, 
       {-0.05, -3.25, 0.}, {-0.05, -3.1875, 0.}, {-0.05, -3.125, 0.}, 
       {-0.05, -3.0625, 0.}, {-0.05, -3., 0.}, {-0.05, -2.9375, 0.}, 
       {-0.05, -2.875, 0.}, {-0.05, -2.8125, 0.}, {-0.05, -2.75, 0.}, 
       {-0.05, -2.6875, 0.}, {-0.05, -2.625, 0.}, {-0.05, -2.5625, 0.}, 
       {-0.05, -2.5, 0.}, {-0.05, -2.5, 0.}, {-0.05, -2.5625, 0.}, 
       {-0.05, -2.625, 0.}, {-0.05, -2.6875, 0.}, {-0.05, -2.75, 0.}, 
       {-0.05, -2.8125, 0.}, {-0.05, -2.875, 0.}, {-0.05, -2.9375, 0.}, 
       {-0.05, -3., 0.}, {-0.05, -3.0625, 0.}, {-0.05, -3.125, 0.}, 
       {-0.05, -3.1875, 0.}, {-0.05, -3.25, 0.}, {-0.05, -3.3125, 0.}, 
       {-0.05, -3.375, 0.}, {-0.05, -3.4375, 0.}, {-0.05, -3.5, 0.}, 
       {-0.05, -3.5625, 0.}, {-0.05, -3.625, 0.}, {-0.05, -3.6875, 0.}, 
       {-0.05, -3.75, 0.}, {-0.05, -3.8125, 0.}, {-0.05, -3.875, 0.}, 
       {-0.05, -3.9375, 0.}, {-0.05, -4., 0.}, {-0.05, -4.0625, 0.}, 
       {-0.05, -4.125, 0.}, {-0.05, -4.1875, 0.}, {-0.05, -4.25, 0.}, 
       {-0.05, -4.3125, 0.}, {-0.05, -4.375, 0.}, {-0.05, -4.4375, 0.}, 
       {-0.05, -4.5, 0.}, {-0.05, -4.5625, 0.}, {-0.05, -4.625, 0.}, 
       {-0.05, -4.6875, 0.}, {-0.05, -4.75, 0.}, {-0.05, -4.8125, 0.}, 
       {-0.05, -4.875, 0.}, {-0.05, -4.9375, 0.}, {-0.05, -5., 0.}, 
       {-0.05, -5., 0.}}, {{-0.05, 2.5, 0.}, {-0.05, 2.5625, 0.}, 
       {-0.05, 2.625, 0.}, {-0.05, 2.6875, 0.}, {-0.05, 2.75, 0.}, 
       {-0.05, 2.8125, 0.}, {-0.05, 2.875, 0.}, {-0.05, 2.9375, 0.}, 
       {-0.05, 3., 0.}, {-0.05, 3.0625, 0.}, {-0.05, 3.125, 0.}, 
       {-0.05, 3.1875, 0.}, {-0.05, 3.25, 0.}, {-0.05, 3.3125, 0.}, 
       {-0.05, 3.375, 0.}, {-0.05, 3.4375, 0.}, {-0.05, 3.5, 0.}, 
       {-0.05, 3.5625, 0.}, {-0.05, 3.625, 0.}, {-0.05, 3.6875, 0.}, 
       {-0.05, 3.75, 0.}, {-0.05, 3.8125, 0.}, {-0.05, 3.875, 0.}, 
       {-0.05, 3.9375, 0.}, {-0.05, 4., 0.}, {-0.05, 4.0625, 0.}, 
       {-0.05, 4.125, 0.}, {-0.05, 4.1875, 0.}, {-0.05, 4.25, 0.}, 
       {-0.05, 4.3125, 0.}, {-0.05, 4.375, 0.}, {-0.05, 4.4375, 0.}, 
       {-0.05, 4.5, 0.}, {-0.05, 4.5625, 0.}, {-0.05, 4.625, 0.}, 
       {-0.05, 4.6875, 0.}, {-0.05, 4.75, 0.}, {-0.05, 4.8125, 0.}, 
       {-0.05, 4.875, 0.}, {-0.05, 4.9375, 0.}, {-0.05, 5., 0.}, 
       {-0.05, 5., 0.}, {-0.05, 4.9375, 0.}, {-0.05, 4.875, 0.}, 
       {-0.05, 4.8125, 0.}, {-0.05, 4.75, 0.}, {-0.05, 4.6875, 0.}, 
       {-0.05, 4.625, 0.}, {-0.05, 4.5625, 0.}, {-0.05, 4.5, 0.}, 
       {-0.05, 4.4375, 0.}, {-0.05, 4.375, 0.}, {-0.05, 4.3125, 0.}, 
       {-0.05, 4.25, 0.}, {-0.05, 4.1875, 0.}, {-0.05, 4.125, 0.}, 
       {-0.05, 4.0625, 0.}, {-0.05, 4., 0.}, {-0.05, 3.9375, 0.}, 
       {-0.05, 3.875, 0.}, {-0.05, 3.8125, 0.}, {-0.05, 3.75, 0.}, 
       {-0.05, 3.6875, 0.}, {-0.05, 3.625, 0.}, {-0.05, 3.5625, 0.}, 
       {-0.05, 3.5, 0.}, {-0.05, 3.4375, 0.}, {-0.05, 3.375, 0.}, 
       {-0.05, 3.3125, 0.}, {-0.05, 3.25, 0.}, {-0.05, 3.1875, 0.}, 
       {-0.05, 3.125, 0.}, {-0.05, 3.0625, 0.}, {-0.05, 3., 0.}, 
       {-0.05, 2.9375, 0.}, {-0.05, 2.875, 0.}, {-0.05, 2.8125, 0.}, 
       {-0.05, 2.75, 0.}, {-0.05, 2.6875, 0.}, {-0.05, 2.625, 0.}, 
       {-0.05, 2.5625, 0.}, {-0.05, 2.5, 0.}, {-0.05, 2.5, 0.}}, 
      {{-0.05, 0., -5.}, {-0.05, 0., -4.9375}, {-0.05, 0., -4.875}, 
       {-0.05, 0., -4.8125}, {-0.05, 0., -4.75}, {-0.05, 0., -4.6875}, 
       {-0.05, 0., -4.625}, {-0.05, 0., -4.5625}, {-0.05, 0., -4.5}, 
       {-0.05, 0., -4.4375}, {-0.05, 0., -4.375}, {-0.05, 0., -4.3125}, 
       {-0.05, 0., -4.25}, {-0.05, 0., -4.1875}, {-0.05, 0., -4.125}, 
       {-0.05, 0., -4.0625}, {-0.05, 0., -4.}, {-0.05, 0., -3.9375}, 
       {-0.05, 0., -3.875}, {-0.05, 0., -3.8125}, {-0.05, 0., -3.75}, 
       {-0.05, 0., -3.6875}, {-0.05, 0., -3.625}, {-0.05, 0., -3.5625}, 
       {-0.05, 0., -3.5}, {-0.05, 0., -3.4375}, {-0.05, 0., -3.375}, 
       {-0.05, 0., -3.3125}, {-0.05, 0., -3.25}, {-0.05, 0., -3.1875}, 
       {-0.05, 0., -3.125}, {-0.05, 0., -3.0625}, {-0.05, 0., -3.}, 
       {-0.05, 0., -2.9375}, {-0.05, 0., -2.875}, {-0.05, 0., -2.8125}, 
       {-0.05, 0., -2.75}, {-0.05, 0., -2.6875}, {-0.05, 0., -2.625}, 
       {-0.05, 0., -2.5625}, {-0.05, 0., -2.5}, {-0.05, 0., -2.5}, 
       {-0.05, 0., -2.5625}, {-0.05, 0., -2.625}, {-0.05, 0., -2.6875}, 
       {-0.05, 0., -2.75}, {-0.05, 0., -2.8125}, {-0.05, 0., -2.875}, 
       {-0.05, 0., -2.9375}, {-0.05, 0., -3.}, {-0.05, 0., -3.0625}, 
       {-0.05, 0., -3.125}, {-0.05, 0., -3.1875}, {-0.05, 0., -3.25}, 
       {-0.05, 0., -3.3125}, {-0.05, 0., -3.375}, {-0.05, 0., -3.4375}, 
       {-0.05, 0., -3.5}, {-0.05, 0., -3.5625}, {-0.05, 0., -3.625}, 
       {-0.05, 0., -3.6875}, {-0.05, 0., -3.75}, {-0.05, 0., -3.8125}, 
       {-0.05, 0., -3.875}, {-0.05, 0., -3.9375}, {-0.05, 0., -4.}, 
       {-0.05, 0., -4.0625}, {-0.05, 0., -4.125}, {-0.05, 0., -4.1875}, 
       {-0.05, 0., -4.25}, {-0.05, 0., -4.3125}, {-0.05, 0., -4.375}, 
       {-0.05, 0., -4.4375}, {-0.05, 0., -4.5}, {-0.05, 0., -4.5625}, 
       {-0.05, 0., -4.625}, {-0.05, 0., -4.6875}, {-0.05, 0., -4.75}, 
       {-0.05, 0., -4.8125}, {-0.05, 0., -4.875}, {-0.05, 0., -4.9375}, 
       {-0.05, 0., -5.}, {-0.05, 0., -5.}}, {{-0.05, 0., 2.5}, 
       {-0.05, 0., 2.5625}, {-0.05, 0., 2.625}, {-0.05, 0., 2.6875}, 
       {-0.05, 0., 2.75}, {-0.05, 0., 2.8125}, {-0.05, 0., 2.875}, 
       {-0.05, 0., 2.9375}, {-0.05, 0., 3.}, {-0.05, 0., 3.0625}, 
       {-0.05, 0., 3.125}, {-0.05, 0., 3.1875}, {-0.05, 0., 3.25}, 
       {-0.05, 0., 3.3125}, {-0.05, 0., 3.375}, {-0.05, 0., 3.4375}, 
       {-0.05, 0., 3.5}, {-0.05, 0., 3.5625}, {-0.05, 0., 3.625}, 
       {-0.05, 0., 3.6875}, {-0.05, 0., 3.75}, {-0.05, 0., 3.8125}, 
       {-0.05, 0., 3.875}, {-0.05, 0., 3.9375}, {-0.05, 0., 4.}, 
       {-0.05, 0., 4.0625}, {-0.05, 0., 4.125}, {-0.05, 0., 4.1875}, 
       {-0.05, 0., 4.25}, {-0.05, 0., 4.3125}, {-0.05, 0., 4.375}, 
       {-0.05, 0., 4.4375}, {-0.05, 0., 4.5}, {-0.05, 0., 4.5625}, 
       {-0.05, 0., 4.625}, {-0.05, 0., 4.6875}, {-0.05, 0., 4.75}, 
       {-0.05, 0., 4.8125}, {-0.05, 0., 4.875}, {-0.05, 0., 4.9375}, 
       {-0.05, 0., 5.}, {-0.05, 0., 5.}, {-0.05, 0., 4.9375}, 
       {-0.05, 0., 4.875}, {-0.05, 0., 4.8125}, {-0.05, 0., 4.75}, 
       {-0.05, 0., 4.6875}, {-0.05, 0., 4.625}, {-0.05, 0., 4.5625}, 
       {-0.05, 0., 4.5}, {-0.05, 0., 4.4375}, {-0.05, 0., 4.375}, 
       {-0.05, 0., 4.3125}, {-0.05, 0., 4.25}, {-0.05, 0., 4.1875}, 
       {-0.05, 0., 4.125}, {-0.05, 0., 4.0625}, {-0.05, 0., 4.}, 
       {-0.05, 0., 3.9375}, {-0.05, 0., 3.875}, {-0.05, 0., 3.8125}, 
       {-0.05, 0., 3.75}, {-0.05, 0., 3.6875}, {-0.05, 0., 3.625}, 
       {-0.05, 0., 3.5625}, {-0.05, 0., 3.5}, {-0.05, 0., 3.4375}, 
       {-0.05, 0., 3.375}, {-0.05, 0., 3.3125}, {-0.05, 0., 3.25}, 
       {-0.05, 0., 3.1875}, {-0.05, 0., 3.125}, {-0.05, 0., 3.0625}, 
       {-0.05, 0., 3.}, {-0.05, 0., 2.9375}, {-0.05, 0., 2.875}, 
       {-0.05, 0., 2.8125}, {-0.05, 0., 2.75}, {-0.05, 0., 2.6875}, 
       {-0.05, 0., 2.625}, {-0.05, 0., 2.5625}, {-0.05, 0., 2.5}, 
       {-0.05, 0., 2.5}}, {{1.3689976525819987, -5.65, 0.}, 
       {1.249200508667663, -5.367500000000001, 0.}, 
       {1.133305718014965, -5.085, 0.}, {1.0215469448527958, -4.8025, 
        0.}, {0.9141675062554867, -4.5200000000000005, 0.}, 
       {0.8114194827665998, -4.237500000000001, 0.}, 
       {0.7135625066333096, -3.955, 0.}, {0.6208621909813115, 
        -3.6725000000000003, 0.}, {0.5335881696456211, -3.39, 0.}, 
       {0.4520117276705726, -3.1075, 0.}, {0.3764030171799524, -2.825, 
        0.}, {0.30702787256214575, -2.5425, 0.}, {0.24414426241533377, 
        -2.26, 0.}, {0.18799844254256412, -1.9775, 0.}, 
       {0.13882090285648163, -1.6949999999999998, 0.}, 
       {0.09682222901675835, -1.4124999999999996, 0.}, 
       {0.06218902406370809, -1.13, 0.}, {0.03508005301320917, 
        -0.8475000000000001, 0.}, {0.01562278125633912, 
        -0.5649999999999995, 0.}, {0.0039104732351545445, 
        -0.28249999999999975, 0.}, {0., 0., 0.}, {0.003910473235154569, 
        0.28250000000000064, 0.}, {0.01562278125633917, 
        0.5650000000000004, 0.}, {0.03508005301320917, 
        0.8475000000000001, 0.}, {0.06218902406370819, 
        1.1300000000000008, 0.}, {0.09682222901675848, 
        1.4125000000000005, 0.}, {0.13882090285648174, 
        1.6950000000000003, 0.}, {0.18799844254256412, 1.9775, 0.}, 
       {0.244144262415334, 2.2600000000000007, 0.}, 
       {0.30702787256214586, 2.5425000000000004, 0.}, 
       {0.37640301717995267, 2.825000000000001, 0.}, 
       {0.4520117276705726, 3.1075, 0.}, {0.5335881696456212, 
        3.3900000000000006, 0.}, {0.6208621909813118, 3.672500000000001, 
        0.}, {0.7135625066333096, 3.955, 0.}, {0.8114194827665998, 
        4.237500000000001, 0.}, {0.914167506255487, 4.520000000000001, 
        0.}, {1.0215469448527958, 4.8025, 0.}, {1.1333057180149655, 
        5.085000000000001, 0.}, {1.2492005086676634, 5.3675000000000015, 
        0.}, {1.3689976525819987, 5.65, 0.}, {1.3689976525819987, 5.65, 
        0.}, {1.249200508667663, 5.367500000000001, 0.}, 
       {1.133305718014965, 5.085, 0.}, {1.0215469448527958, 4.8025, 0.}, 
       {0.9141675062554867, 4.5200000000000005, 0.}, 
       {0.8114194827665998, 4.237500000000001, 0.}, 
       {0.7135625066333096, 3.955, 0.}, {0.6208621909813115, 
        3.6725000000000003, 0.}, {0.5335881696456211, 3.39, 0.}, 
       {0.4520117276705726, 3.1075, 0.}, {0.3764030171799524, 2.825, 
        0.}, {0.30702787256214575, 2.5425, 0.}, {0.24414426241533377, 
        2.26, 0.}, {0.18799844254256412, 1.9775, 0.}, 
       {0.13882090285648163, 1.6949999999999998, 0.}, 
       {0.09682222901675835, 1.4124999999999996, 0.}, 
       {0.06218902406370809, 1.13, 0.}, {0.03508005301320917, 
        0.8475000000000001, 0.}, {0.01562278125633912, 
        0.5649999999999995, 0.}, {0.0039104732351545445, 
        0.28249999999999975, 0.}, {0., 0., 0.}, {0.003910473235154569, 
        -0.28250000000000064, 0.}, {0.01562278125633917, 
        -0.5650000000000004, 0.}, {0.03508005301320917, 
        -0.8475000000000001, 0.}, {0.06218902406370819, 
        -1.1300000000000008, 0.}, {0.09682222901675848, 
        -1.4125000000000005, 0.}, {0.13882090285648174, 
        -1.6950000000000003, 0.}, {0.18799844254256412, -1.9775, 0.}, 
       {0.244144262415334, -2.2600000000000007, 0.}, 
       {0.30702787256214586, -2.5425000000000004, 0.}, 
       {0.37640301717995267, -2.825000000000001, 0.}, 
       {0.4520117276705726, -3.1075, 0.}, {0.5335881696456212, 
        -3.3900000000000006, 0.}, {0.6208621909813118, 
        -3.672500000000001, 0.}, {0.7135625066333096, -3.955, 0.}, 
       {0.8114194827665998, -4.237500000000001, 0.}, 
       {0.914167506255487, -4.520000000000001, 0.}, 
       {1.0215469448527958, -4.8025, 0.}, {1.1333057180149655, 
        -5.085000000000001, 0.}, {1.2492005086676634, 
        -5.3675000000000015, 0.}, {1.3689976525819987, -5.65, 0.}, 
       {1.3689976525819987, -5.65, 0.}}, 
      {{1.3689976525819987, 0., -5.65}, {1.249200508667663, 0., 
        -5.367500000000001}, {1.133305718014965, 0., -5.085}, 
       {1.0215469448527958, 0., -4.8025}, {0.9141675062554867, 0., 
        -4.5200000000000005}, {0.8114194827665998, 0., 
        -4.237500000000001}, {0.7135625066333096, 0., -3.955}, 
       {0.6208621909813115, 0., -3.6725000000000003}, 
       {0.5335881696456211, 0., -3.39}, {0.4520117276705726, 0., 
        -3.1075}, {0.3764030171799524, 0., -2.825}, 
       {0.30702787256214575, 0., -2.5425}, {0.24414426241533377, 0., 
        -2.26}, {0.18799844254256412, 0., -1.9775}, 
       {0.13882090285648163, 0., -1.6949999999999998}, 
       {0.09682222901675835, 0., -1.4124999999999996}, 
       {0.06218902406370809, 0., -1.13}, {0.03508005301320917, 0., 
        -0.8475000000000001}, {0.01562278125633912, 0., 
        -0.5649999999999995}, {0.0039104732351545445, 0., 
        -0.28249999999999975}, {0., 0., 0.}, {0.003910473235154569, 0., 
        0.28250000000000064}, {0.01562278125633917, 0., 
        0.5650000000000004}, {0.03508005301320917, 0., 
        0.8475000000000001}, {0.06218902406370819, 0., 
        1.1300000000000008}, {0.09682222901675848, 0., 
        1.4125000000000005}, {0.13882090285648174, 0., 
        1.6950000000000003}, {0.18799844254256412, 0., 1.9775}, 
       {0.244144262415334, 0., 2.2600000000000007}, 
       {0.30702787256214586, 0., 2.5425000000000004}, 
       {0.37640301717995267, 0., 2.825000000000001}, 
       {0.4520117276705726, 0., 3.1075}, {0.5335881696456212, 0., 
        3.3900000000000006}, {0.6208621909813118, 0., 
        3.672500000000001}, {0.7135625066333096, 0., 3.955}, 
       {0.8114194827665998, 0., 4.237500000000001}, 
       {0.914167506255487, 0., 4.520000000000001}, 
       {1.0215469448527958, 0., 4.8025}, {1.1333057180149655, 0., 
        5.085000000000001}, {1.2492005086676634, 0., 
        5.3675000000000015}, {1.3689976525819987, 0., 5.65}, 
       {1.3689976525819987, 0., 5.65}, {1.249200508667663, 0., 
        5.367500000000001}, {1.133305718014965, 0., 5.085}, 
       {1.0215469448527958, 0., 4.8025}, {0.9141675062554867, 0., 
        4.5200000000000005}, {0.8114194827665998, 0., 
        4.237500000000001}, {0.7135625066333096, 0., 3.955}, 
       {0.6208621909813115, 0., 3.6725000000000003}, 
       {0.5335881696456211, 0., 3.39}, {0.4520117276705726, 0., 3.1075}, 
       {0.3764030171799524, 0., 2.825}, {0.30702787256214575, 0., 
        2.5425}, {0.24414426241533377, 0., 2.26}, {0.18799844254256412, 
        0., 1.9775}, {0.13882090285648163, 0., 1.6949999999999998}, 
       {0.09682222901675835, 0., 1.4124999999999996}, 
       {0.06218902406370809, 0., 1.13}, {0.03508005301320917, 0., 
        0.8475000000000001}, {0.01562278125633912, 0., 
        0.5649999999999995}, {0.0039104732351545445, 0., 
        0.28249999999999975}, {0., 0., 0.}, {0.003910473235154569, 0., 
        -0.28250000000000064}, {0.01562278125633917, 0., 
        -0.5650000000000004}, {0.03508005301320917, 0., 
        -0.8475000000000001}, {0.06218902406370819, 0., 
        -1.1300000000000008}, {0.09682222901675848, 0., 
        -1.4125000000000005}, {0.13882090285648174, 0., 
        -1.6950000000000003}, {0.18799844254256412, 0., -1.9775}, 
       {0.244144262415334, 0., -2.2600000000000007}, 
       {0.30702787256214586, 0., -2.5425000000000004}, 
       {0.37640301717995267, 0., -2.825000000000001}, 
       {0.4520117276705726, 0., -3.1075}, {0.5335881696456212, 0., 
        -3.3900000000000006}, {0.6208621909813118, 0., 
        -3.672500000000001}, {0.7135625066333096, 0., -3.955}, 
       {0.8114194827665998, 0., -4.237500000000001}, 
       {0.914167506255487, 0., -4.520000000000001}, 
       {1.0215469448527958, 0., -4.8025}, {1.1333057180149655, 0., 
        -5.085000000000001}, {1.2492005086676634, 0., 
        -5.3675000000000015}, {1.3689976525819987, 0., -5.65}, 
       {1.3689976525819987, 0., -5.65}}, 
      {{1.3397916666666667, -5.65, 0.}, {1.5991619791666665, 
        -5.367500000000001, 0.}, {1.8452312500000003, -5.085, 0.}, 
       {2.0779994791666665, -4.8025, 0.}, {2.2974666666666663, 
        -4.5200000000000005, 0.}, {2.5036328124999994, 
        -4.237500000000001, 0.}, {2.696497916666667, -3.955, 0.}, 
       {2.876061979166667, -3.6725000000000003, 0.}, 
       {3.042325, -3.39, 0.}, {3.1952869791666667, -3.1075, 0.}, 
       {3.3349479166666667, -2.825, 0.}, {3.4613078125000003, -2.5425, 
        0.}, {3.5743666666666667, -2.26, 0.}, {3.6741244791666667, 
        -1.9775, 0.}, {3.76058125, -1.6949999999999998, 0.}, 
       {3.833736979166667, -1.4124999999999996, 0.}, 
       {3.8935916666666666, -1.13, 0.}, {3.9401453125, 
        -0.8475000000000001, 0.}, {3.973397916666667, 
        -0.5649999999999995, 0.}, {3.9933494791666666, 
        -0.28249999999999975, 0.}, {4., 0., 0.}, {3.9933494791666666, 
        0.28250000000000064, 0.}, {3.9733979166666664, 
        0.5650000000000004, 0.}, {3.9401453125, 0.8475000000000001, 0.}, 
       {3.8935916666666666, 1.1300000000000008, 0.}, 
       {3.8337369791666664, 1.4125000000000005, 0.}, 
       {3.76058125, 1.6950000000000003, 0.}, {3.6741244791666667, 
        1.9775, 0.}, {3.5743666666666662, 2.2600000000000007, 0.}, 
       {3.4613078125, 2.5425000000000004, 0.}, {3.3349479166666662, 
        2.825000000000001, 0.}, {3.1952869791666667, 3.1075, 0.}, 
       {3.042325, 3.3900000000000006, 0.}, {2.876061979166666, 
        3.672500000000001, 0.}, {2.696497916666667, 3.955, 0.}, 
       {2.5036328124999994, 4.237500000000001, 0.}, 
       {2.297466666666666, 4.520000000000001, 0.}, 
       {2.0779994791666665, 4.8025, 0.}, {1.8452312499999994, 
        5.085000000000001, 0.}, {1.5991619791666656, 5.3675000000000015, 
        0.}, {1.3397916666666667, 5.65, 0.}, {1.3397916666666667, 5.65, 
        0.}, {1.5991619791666665, 5.367500000000001, 0.}, 
       {1.8452312500000003, 5.085, 0.}, {2.0779994791666665, 4.8025, 
        0.}, {2.2974666666666663, 4.5200000000000005, 0.}, 
       {2.5036328124999994, 4.237500000000001, 0.}, 
       {2.696497916666667, 3.955, 0.}, {2.876061979166667, 
        3.6725000000000003, 0.}, {3.042325, 3.39, 0.}, 
       {3.1952869791666667, 3.1075, 0.}, {3.3349479166666667, 2.825, 
        0.}, {3.4613078125000003, 2.5425, 0.}, {3.5743666666666667, 
        2.26, 0.}, {3.6741244791666667, 1.9775, 0.}, 
       {3.76058125, 1.6949999999999998, 0.}, {3.833736979166667, 
        1.4124999999999996, 0.}, {3.8935916666666666, 1.13, 0.}, 
       {3.9401453125, 0.8475000000000001, 0.}, {3.973397916666667, 
        0.5649999999999995, 0.}, {3.9933494791666666, 
        0.28249999999999975, 0.}, {4., 0., 0.}, {3.9933494791666666, 
        -0.28250000000000064, 0.}, {3.9733979166666664, 
        -0.5650000000000004, 0.}, {3.9401453125, -0.8475000000000001, 
        0.}, {3.8935916666666666, -1.1300000000000008, 0.}, 
       {3.8337369791666664, -1.4125000000000005, 0.}, 
       {3.76058125, -1.6950000000000003, 0.}, {3.6741244791666667, 
        -1.9775, 0.}, {3.5743666666666662, -2.2600000000000007, 0.}, 
       {3.4613078125, -2.5425000000000004, 0.}, {3.3349479166666662, 
        -2.825000000000001, 0.}, {3.1952869791666667, -3.1075, 0.}, 
       {3.042325, -3.3900000000000006, 0.}, {2.876061979166666, 
        -3.672500000000001, 0.}, {2.696497916666667, -3.955, 0.}, 
       {2.5036328124999994, -4.237500000000001, 0.}, 
       {2.297466666666666, -4.520000000000001, 0.}, 
       {2.0779994791666665, -4.8025, 0.}, {1.8452312499999994, 
        -5.085000000000001, 0.}, {1.5991619791666656, 
        -5.3675000000000015, 0.}, {1.3397916666666667, -5.65, 0.}, 
       {1.3397916666666667, -5.65, 0.}}, 
      {{1.3397916666666667, 0., -5.65}, {1.5991619791666665, 0., 
        -5.367500000000001}, {1.8452312500000003, 0., -5.085}, 
       {2.0779994791666665, 0., -4.8025}, {2.2974666666666663, 0., 
        -4.5200000000000005}, {2.5036328124999994, 0., 
        -4.237500000000001}, {2.696497916666667, 0., -3.955}, 
       {2.876061979166667, 0., -3.6725000000000003}, 
       {3.042325, 0., -3.39}, {3.1952869791666667, 0., -3.1075}, 
       {3.3349479166666667, 0., -2.825}, {3.4613078125000003, 0., 
        -2.5425}, {3.5743666666666667, 0., -2.26}, 
       {3.6741244791666667, 0., -1.9775}, {3.76058125, 0., 
        -1.6949999999999998}, {3.833736979166667, 0., 
        -1.4124999999999996}, {3.8935916666666666, 0., -1.13}, 
       {3.9401453125, 0., -0.8475000000000001}, {3.973397916666667, 0., 
        -0.5649999999999995}, {3.9933494791666666, 0., 
        -0.28249999999999975}, {4., 0., 0.}, {3.9933494791666666, 0., 
        0.28250000000000064}, {3.9733979166666664, 0., 
        0.5650000000000004}, {3.9401453125, 0., 0.8475000000000001}, 
       {3.8935916666666666, 0., 1.1300000000000008}, 
       {3.8337369791666664, 0., 1.4125000000000005}, 
       {3.76058125, 0., 1.6950000000000003}, {3.6741244791666667, 0., 
        1.9775}, {3.5743666666666662, 0., 2.2600000000000007}, 
       {3.4613078125, 0., 2.5425000000000004}, {3.3349479166666662, 0., 
        2.825000000000001}, {3.1952869791666667, 0., 3.1075}, 
       {3.042325, 0., 3.3900000000000006}, {2.876061979166666, 0., 
        3.672500000000001}, {2.696497916666667, 0., 3.955}, 
       {2.5036328124999994, 0., 4.237500000000001}, 
       {2.297466666666666, 0., 4.520000000000001}, 
       {2.0779994791666665, 0., 4.8025}, {1.8452312499999994, 0., 
        5.085000000000001}, {1.5991619791666656, 0., 
        5.3675000000000015}, {1.3397916666666667, 0., 5.65}, 
       {1.3397916666666667, 0., 5.65}, {1.5991619791666665, 0., 
        5.367500000000001}, {1.8452312500000003, 0., 5.085}, 
       {2.0779994791666665, 0., 4.8025}, {2.2974666666666663, 0., 
        4.5200000000000005}, {2.5036328124999994, 0., 
        4.237500000000001}, {2.696497916666667, 0., 3.955}, 
       {2.876061979166667, 0., 3.6725000000000003}, 
       {3.042325, 0., 3.39}, {3.1952869791666667, 0., 3.1075}, 
       {3.3349479166666667, 0., 2.825}, {3.4613078125000003, 0., 
        2.5425}, {3.5743666666666667, 0., 2.26}, {3.6741244791666667, 
        0., 1.9775}, {3.76058125, 0., 1.6949999999999998}, 
       {3.833736979166667, 0., 1.4124999999999996}, 
       {3.8935916666666666, 0., 1.13}, {3.9401453125, 0., 
        0.8475000000000001}, {3.973397916666667, 0., 
        0.5649999999999995}, {3.9933494791666666, 0., 
        0.28249999999999975}, {4., 0., 0.}, {3.9933494791666666, 0., 
        -0.28250000000000064}, {3.9733979166666664, 0., 
        -0.5650000000000004}, {3.9401453125, 0., -0.8475000000000001}, 
       {3.8935916666666666, 0., -1.1300000000000008}, 
       {3.8337369791666664, 0., -1.4125000000000005}, 
       {3.76058125, 0., -1.6950000000000003}, {3.6741244791666667, 0., 
        -1.9775}, {3.5743666666666662, 0., -2.2600000000000007}, 
       {3.4613078125, 0., -2.5425000000000004}, {3.3349479166666662, 0., 
        -2.825000000000001}, {3.1952869791666667, 0., -3.1075}, 
       {3.042325, 0., -3.3900000000000006}, {2.876061979166666, 0., 
        -3.672500000000001}, {2.696497916666667, 0., -3.955}, 
       {2.5036328124999994, 0., -4.237500000000001}, 
       {2.297466666666666, 0., -4.520000000000001}, 
       {2.0779994791666665, 0., -4.8025}, {1.8452312499999994, 0., 
        -5.085000000000001}, {1.5991619791666656, 0., 
        -5.3675000000000015}, {1.3397916666666667, 0., -5.65}, 
       {1.3397916666666667, 0., -5.65}}, 
      {{9.414603431411972, -11.95, 0.}, {12.208840053799115, -11.3525, 
        0.}, {13.642891004388748, -10.754999999999999, 0.}, 
       {14.709759581999093, -10.157499999999999, 0.}, 
       {15.573326954313629, -9.559999999999999, 0.}, 
       {16.299873531837402, -8.962499999999999, 0.}, 
       {16.924181391558115, -8.364999999999998, 0.}, 
       {17.46720897243435, -7.767499999999999, 0.}, 
       {17.942726928795043, -7.169999999999999, 0.}, 
       {18.360332059211764, -6.572499999999999, 0.}, 
       {18.726998563905845, -5.974999999999999, 0.}, 
       {19.04795089616548, -5.377499999999999, 0.}, 
       {19.327188752049782, -4.779999999999999, 0.}, 
       {19.567819448749578, -4.182499999999999, 0.}, 
       {19.772276903574333, -3.584999999999999, 0.}, 
       {19.942470354542216, -2.987499999999999, 0.}, 
       {20.079887577802207, -2.389999999999999, 0.}, 
       {20.18566740897643, -1.7924999999999986, 0.}, 
       {20.260650706742243, -1.1949999999999985, 0.}, 
       {20.305415508412924, -0.5974999999999984, 0.}, 
       {20.3203, 1.7763568394002505*^-15, 0.}, {20.305415508412924, 
        0.5975000000000019, 0.}, {20.260650706742243, 1.195000000000002, 
        0.}, {20.18566740897643, 1.7925000000000022, 0.}, 
       {20.079887577802207, 2.3900000000000006, 0.}, 
       {19.942470354542216, 2.9875000000000007, 0.}, 
       {19.772276903574333, 3.585000000000001, 0.}, 
       {19.567819448749574, 4.182500000000001, 0.}, 
       {19.32718875204978, 4.780000000000001, 0.}, 
       {19.047950896165478, 5.377500000000001, 0.}, 
       {18.726998563905845, 5.975000000000001, 0.}, 
       {18.360332059211764, 6.572500000000002, 0.}, 
       {17.94272692879504, 7.170000000000002, 0.}, 
       {17.46720897243435, 7.767500000000002, 0.}, 
       {16.924181391558115, 8.365000000000002, 0.}, 
       {16.2998735318374, 8.962500000000002, 0.}, {15.573326954313622, 
        9.560000000000002, 0.}, {14.709759581999087, 10.157500000000002, 
        0.}, {13.64289100438874, 10.755000000000003, 0.}, 
       {12.208840053799104, 11.352500000000003, 0.}, 
       {9.414603431411933, 11.950000000000003, 0.}, 
       {9.414603431411972, 11.95, 0.}, {12.208840053799115, 11.3525, 
        0.}, {13.642891004388748, 10.754999999999999, 0.}, 
       {14.709759581999093, 10.157499999999999, 0.}, 
       {15.573326954313629, 9.559999999999999, 0.}, 
       {16.299873531837402, 8.962499999999999, 0.}, 
       {16.924181391558115, 8.364999999999998, 0.}, 
       {17.46720897243435, 7.767499999999999, 0.}, 
       {17.942726928795043, 7.169999999999999, 0.}, 
       {18.360332059211764, 6.572499999999999, 0.}, 
       {18.726998563905845, 5.974999999999999, 0.}, 
       {19.04795089616548, 5.377499999999999, 0.}, 
       {19.327188752049782, 4.779999999999999, 0.}, 
       {19.567819448749578, 4.182499999999999, 0.}, 
       {19.772276903574333, 3.584999999999999, 0.}, 
       {19.942470354542216, 2.987499999999999, 0.}, 
       {20.079887577802207, 2.389999999999999, 0.}, 
       {20.18566740897643, 1.7924999999999986, 0.}, 
       {20.260650706742243, 1.1949999999999985, 0.}, 
       {20.305415508412924, 0.5974999999999984, 0.}, 
       {20.3203, -1.7763568394002505*^-15, 0.}, {20.305415508412924, 
        -0.5975000000000019, 0.}, {20.260650706742243, 
        -1.195000000000002, 0.}, {20.18566740897643, 
        -1.7925000000000022, 0.}, {20.079887577802207, 
        -2.3900000000000006, 0.}, {19.942470354542216, 
        -2.9875000000000007, 0.}, {19.772276903574333, 
        -3.585000000000001, 0.}, {19.567819448749574, 
        -4.182500000000001, 0.}, {19.32718875204978, -4.780000000000001, 
        0.}, {19.047950896165478, -5.377500000000001, 0.}, 
       {18.726998563905845, -5.975000000000001, 0.}, 
       {18.360332059211764, -6.572500000000002, 0.}, 
       {17.94272692879504, -7.170000000000002, 0.}, 
       {17.46720897243435, -7.767500000000002, 0.}, 
       {16.924181391558115, -8.365000000000002, 0.}, 
       {16.2998735318374, -8.962500000000002, 0.}, 
       {15.573326954313622, -9.560000000000002, 0.}, 
       {14.709759581999087, -10.157500000000002, 0.}, 
       {13.64289100438874, -10.755000000000003, 0.}, 
       {12.208840053799104, -11.352500000000003, 0.}, 
       {9.414603431411933, -11.950000000000003, 0.}, 
       {9.414603431411972, -11.95, 0.}}, 
      {{9.414603431411972, 0., -11.95}, {12.208840053799115, 0., 
        -11.3525}, {13.642891004388748, 0., -10.754999999999999}, 
       {14.709759581999093, 0., -10.157499999999999}, 
       {15.573326954313629, 0., -9.559999999999999}, 
       {16.299873531837402, 0., -8.962499999999999}, 
       {16.924181391558115, 0., -8.364999999999998}, 
       {17.46720897243435, 0., -7.767499999999999}, 
       {17.942726928795043, 0., -7.169999999999999}, 
       {18.360332059211764, 0., -6.572499999999999}, 
       {18.726998563905845, 0., -5.974999999999999}, 
       {19.04795089616548, 0., -5.377499999999999}, 
       {19.327188752049782, 0., -4.779999999999999}, 
       {19.567819448749578, 0., -4.182499999999999}, 
       {19.772276903574333, 0., -3.584999999999999}, 
       {19.942470354542216, 0., -2.987499999999999}, 
       {20.079887577802207, 0., -2.389999999999999}, 
       {20.18566740897643, 0., -1.7924999999999986}, 
       {20.260650706742243, 0., -1.1949999999999985}, 
       {20.305415508412924, 0., -0.5974999999999984}, 
       {20.3203, 0., 1.7763568394002505*^-15}, {20.305415508412924, 0., 
        0.5975000000000019}, {20.260650706742243, 0., 
        1.195000000000002}, {20.18566740897643, 0., 1.7925000000000022}, 
       {20.079887577802207, 0., 2.3900000000000006}, 
       {19.942470354542216, 0., 2.9875000000000007}, 
       {19.772276903574333, 0., 3.585000000000001}, 
       {19.567819448749574, 0., 4.182500000000001}, 
       {19.32718875204978, 0., 4.780000000000001}, 
       {19.047950896165478, 0., 5.377500000000001}, 
       {18.726998563905845, 0., 5.975000000000001}, 
       {18.360332059211764, 0., 6.572500000000002}, 
       {17.94272692879504, 0., 7.170000000000002}, 
       {17.46720897243435, 0., 7.767500000000002}, 
       {16.924181391558115, 0., 8.365000000000002}, 
       {16.2998735318374, 0., 8.962500000000002}, {15.573326954313622, 
        0., 9.560000000000002}, {14.709759581999087, 0., 
        10.157500000000002}, {13.64289100438874, 0., 
        10.755000000000003}, {12.208840053799104, 0., 
        11.352500000000003}, {9.414603431411933, 0., 
        11.950000000000003}, {9.414603431411972, 0., 11.95}, 
       {12.208840053799115, 0., 11.3525}, {13.642891004388748, 0., 
        10.754999999999999}, {14.709759581999093, 0., 
        10.157499999999999}, {15.573326954313629, 0., 
        9.559999999999999}, {16.299873531837402, 0., 8.962499999999999}, 
       {16.924181391558115, 0., 8.364999999999998}, 
       {17.46720897243435, 0., 7.767499999999999}, 
       {17.942726928795043, 0., 7.169999999999999}, 
       {18.360332059211764, 0., 6.572499999999999}, 
       {18.726998563905845, 0., 5.974999999999999}, 
       {19.04795089616548, 0., 5.377499999999999}, 
       {19.327188752049782, 0., 4.779999999999999}, 
       {19.567819448749578, 0., 4.182499999999999}, 
       {19.772276903574333, 0., 3.584999999999999}, 
       {19.942470354542216, 0., 2.987499999999999}, 
       {20.079887577802207, 0., 2.389999999999999}, 
       {20.18566740897643, 0., 1.7924999999999986}, 
       {20.260650706742243, 0., 1.1949999999999985}, 
       {20.305415508412924, 0., 0.5974999999999984}, 
       {20.3203, 0., -1.7763568394002505*^-15}, {20.305415508412924, 0., 
        -0.5975000000000019}, {20.260650706742243, 0., 
        -1.195000000000002}, {20.18566740897643, 0., 
        -1.7925000000000022}, {20.079887577802207, 0., 
        -2.3900000000000006}, {19.942470354542216, 0., 
        -2.9875000000000007}, {19.772276903574333, 0., 
        -3.585000000000001}, {19.567819448749574, 0., 
        -4.182500000000001}, {19.32718875204978, 0., 
        -4.780000000000001}, {19.047950896165478, 0., 
        -5.377500000000001}, {18.726998563905845, 0., 
        -5.975000000000001}, {18.360332059211764, 0., 
        -6.572500000000002}, {17.94272692879504, 0., 
        -7.170000000000002}, {17.46720897243435, 0., 
        -7.767500000000002}, {16.924181391558115, 0., 
        -8.365000000000002}, {16.2998735318374, 0., -8.962500000000002}, 
       {15.573326954313622, 0., -9.560000000000002}, 
       {14.709759581999087, 0., -10.157500000000002}, 
       {13.64289100438874, 0., -10.755000000000003}, 
       {12.208840053799104, 0., -11.352500000000003}, 
       {9.414603431411933, 0., -11.950000000000003}, 
       {9.414603431411972, 0., -11.95}}, 
      {{-0.654121133468629, 6.25, 0.}, {-0.6541211334686294, 
        6.245181476504518, 0.24537384849417881}, {-0.654121133468629, 
        6.23073333583205, 0.4903693482990309}, {-0.6541211334686295, 
        6.206677855968289, 0.7346087341114853}, {-0.6541211334686289, 
        6.173052128719611, 0.977715406501443}, {-0.6541211334686288, 
        6.129908002520191, 1.2193145126008016}, {-0.6541211334686305, 
        6.0773120024854785, 1.4590335240994088}, {-0.6541211334686295, 
        6.0153452278352955, 1.6965028116567142}, {-0.6541211334686303, 
        5.944103226844709, 1.9313562148434211}, {-0.654121133468629, 
        5.863695849515526, 2.163231606734331}, {-0.6541211334686292, 
        5.774247078195542, 2.391771452281811}, {-0.6541211334686295, 
        5.675894836406758, 2.6166233596089254}, {-0.6541211334686297, 
        5.568790776177299, 2.837440623372167}, {-0.6541211334686294, 
        5.453100044204982, 3.053882759355968}, {-0.6541211334686303, 
        5.329001027213076, 3.26561602947468}, {-0.6541211334686303, 
        5.196685076890907, 3.4723139563725134}, {-0.6541211334686292, 
        5.056356214843421, 3.673657826827957}, {-0.6541211334686294, 
        4.908230818004656, 3.8693371831864622}, {-0.654121133468629, 
        4.7525372850001935, 4.059050302063648}, {-0.6541211334686297, 
        4.589515683973035, 4.242504659580885}, {-0.6541211334686303, 
        4.419417382415922, 4.419417382415921}, {-0.6541211334686288, 
        4.242504659580886, 4.589515683973035}, {-0.654121133468629, 
        4.059050302063648, 4.7525372850001935}, {-0.6541211334686294, 
        3.8693371831864622, 4.908230818004656}, {-0.6541211334686292, 
        3.673657826827957, 5.056356214843421}, {-0.654121133468629, 
        3.4723139563725143, 5.196685076890907}, {-0.6541211334686294, 
        3.2656160294746805, 5.329001027213076}, {-0.654121133468629, 
        3.0538827593559685, 5.453100044204982}, {-0.6541211334686303, 
        2.8374406233721676, 5.568790776177298}, {-0.6541211334686294, 
        2.616623359608926, 5.675894836406758}, {-0.654121133468629, 
        2.3917714522818114, 5.774247078195542}, {-0.654121133468629, 
        2.1632316067343313, 5.863695849515526}, {-0.6541211334686303, 
        1.9313562148434216, 5.944103226844709}, {-0.6541211334686294, 
        1.6965028116567145, 6.0153452278352955}, {-0.6541211334686294, 
        1.4590335240994092, 6.0773120024854785}, {-0.6541211334686285, 
        1.219314512600802, 6.129908002520191}, {-0.654121133468629, 
        0.9777154065014433, 6.173052128719611}, {-0.6541211334686294, 
        0.7346087341114856, 6.206677855968289}, {-0.654121133468629, 
        0.4903693482990312, 6.23073333583205}, {-0.6541211334686294, 
        0.24537384849417915, 6.245181476504518}, {-0.654121133468629, 
        3.826894855694929*^-16, 6.25}, {-0.6541211334686294, 
        -0.24537384849417843, 6.245181476504518}, {-0.654121133468629, 
        -0.49036934829903045, 6.23073333583205}, {-0.6541211334686294, 
        -0.7346087341114849, 6.206677855968289}, {-0.654121133468629, 
        -0.9777154065014426, 6.173052128719611}, {-0.654121133468629, 
        -1.2193145126008011, 6.129908002520191}, {-0.654121133468629, 
        -1.4590335240994083, 6.077312002485479}, {-0.6541211334686299, 
        -1.6965028116567138, 6.0153452278352955}, {-0.654121133468629, 
        -1.931356214843421, 5.94410322684471}, {-0.6541211334686294, 
        -2.1632316067343305, 5.863695849515526}, {-0.654121133468629, 
        -2.391771452281811, 5.774247078195542}, {-0.654121133468629, 
        -2.6166233596089237, 5.675894836406759}, {-0.6541211334686299, 
        -2.8374406233721667, 5.568790776177299}, {-0.654121133468629, 
        -3.053882759355969, 5.453100044204982}, {-0.654121133468629, 
        -3.26561602947468, 5.329001027213077}, {-0.654121133468629, 
        -3.472313956372512, 5.196685076890909}, {-0.6541211334686305, 
        -3.6736578268279563, 5.056356214843421}, {-0.6541211334686285, 
        -3.869337183186463, 4.908230818004656}, {-0.6541211334686285, 
        -4.059050302063647, 4.752537285000194}, {-0.654121133468629, 
        -4.242504659580884, 4.589515683973036}, {-0.6541211334686301, 
        -4.419417382415921, 4.419417382415922}, {-0.6541211334686297, 
        -4.589515683973035, 4.242504659580885}, {-0.6541211334686285, 
        -4.7525372850001935, 4.059050302063649}, {-0.6541211334686292, 
        -4.908230818004655, 3.8693371831864636}, {-0.6541211334686303, 
        -5.0563562148434205, 3.6736578268279576}, {-0.6541211334686292, 
        -5.196685076890908, 3.4723139563725134}, {-0.6541211334686294, 
        -5.329001027213076, 3.2656160294746805}, {-0.6541211334686293, 
        -5.453100044204981, 3.0538827593559703}, {-0.6541211334686302, 
        -5.568790776177298, 2.837440623372168}, {-0.6541211334686288, 
        -5.6758948364067585, 2.616623359608925}, {-0.6541211334686288, 
        -5.774247078195542, 2.391771452281812}, {-0.6541211334686288, 
        -5.863695849515525, 2.163231606734333}, {-0.6541211334686291, 
        -5.944103226844709, 1.931356214843422}, {-0.6541211334686303, 
        -6.0153452278352955, 1.6965028116567133}, {-0.6541211334686294, 
        -6.0773120024854785, 1.4590335240994095}, {-0.6541211334686284, 
        -6.129908002520191, 1.2193145126008038}, {-0.6541211334686298, 
        -6.17305212871961, 0.9777154065014436}, {-0.6541211334686297, 
        -6.206677855968289, 0.7346087341114846}, {-0.654121133468629, 
        -6.23073333583205, 0.49036934829903167}, {-0.6541211334686293, 
        -6.245181476504518, 0.24537384849418092}, {-0.654121133468629, 
        -6.25, 7.653789711389858*^-16}, {-0.6541211334686294, 
        -6.245181476504518, -0.24537384849417943}, 
       {-0.6541211334686291, -6.23073333583205, -0.4903693482990301}, 
       {-0.6541211334686303, -6.206677855968289, -0.7346087341114831}, 
       {-0.6541211334686291, -6.173052128719611, -0.9777154065014421}, 
       {-0.6541211334686287, -6.129908002520191, -1.2193145126008023}, 
       {-0.6541211334686289, -6.077312002485479, -1.459033524099408}, 
       {-0.6541211334686288, -6.015345227835296, -1.696502811656712}, 
       {-0.6541211334686291, -5.94410322684471, -1.9313562148434205}, 
       {-0.6541211334686287, -5.863695849515526, -2.163231606734332}, 
       {-0.6541211334686292, -5.774247078195542, -2.3917714522818105}, 
       {-0.6541211334686291, -5.675894836406759, -2.6166233596089232}, 
       {-0.6541211334686298, -5.568790776177299, -2.8374406233721667}, 
       {-0.654121133468629, -5.453100044204982, -3.053882759355969}, 
       {-0.6541211334686292, -5.329001027213077, -3.265616029474679}, 
       {-0.654121133468629, -5.196685076890909, -3.472313956372512}, 
       {-0.6541211334686292, -5.056356214843422, -3.6736578268279563}, 
       {-0.6541211334686288, -4.908230818004656, -3.869337183186463}, 
       {-0.6541211334686288, -4.752537285000194, -4.059050302063647}, 
       {-0.654121133468629, -4.589515683973036, -4.242504659580884}, 
       {-0.6541211334686292, -4.419417382415923, -4.419417382415921}, 
       {-0.6541211334686297, -4.242504659580885, -4.589515683973035}, 
       {-0.6541211334686297, -4.059050302063651, -4.752537285000191}, 
       {-0.6541211334686288, -3.8693371831864645, -4.908230818004655}, 
       {-0.6541211334686301, -3.6736578268279576, -5.0563562148434205}, 
       {-0.6541211334686303, -3.4723139563725134, -5.196685076890907}, 
       {-0.6541211334686285, -3.2656160294746788, -5.329001027213078}, 
       {-0.654121133468629, -3.0538827593559708, -5.453100044204981}, 
       {-0.6541211334686303, -2.837440623372168, -5.568790776177298}, 
       {-0.6541211334686285, -2.616623359608925, -5.6758948364067585}, 
       {-0.6541211334686294, -2.3917714522818145, -5.774247078195541}, 
       {-0.6541211334686285, -2.1632316067343336, -5.863695849515525}, 
       {-0.654121133468629, -1.9313562148434222, -5.944103226844709}, 
       {-0.6541211334686299, -1.6965028116567138, -6.0153452278352955}, 
       {-0.654121133468629, -1.4590335240994072, -6.077312002485479}, 
       {-0.6541211334686294, -1.2193145126008043, -6.12990800252019}, 
       {-0.6541211334686299, -0.977715406501444, -6.17305212871961}, 
       {-0.6541211334686294, -0.734608734111485, -6.206677855968289}, 
       {-0.6541211334686285, -0.4903693482990348, -6.23073333583205}, 
       {-0.6541211334686294, -0.24537384849418134, -6.245181476504518}, 
       {-0.654121133468629, -1.1480684567084787*^-15, -6.25}, 
       {-0.6541211334686294, 0.24537384849417904, -6.245181476504518}, 
       {-0.654121133468629, 0.49036934829903256, -6.23073333583205}, 
       {-0.6541211334686303, 0.7346087341114828, -6.206677855968289}, 
       {-0.654121133468629, 0.9777154065014417, -6.173052128719611}, 
       {-0.6541211334686285, 1.2193145126008018, -6.129908002520191}, 
       {-0.6541211334686294, 1.4590335240994048, -6.077312002485479}, 
       {-0.654121133468629, 1.6965028116567118, -6.015345227835296}, 
       {-0.654121133468629, 1.9313562148434202, -5.94410322684471}, 
       {-0.654121133468629, 2.1632316067343313, -5.863695849515526}, 
       {-0.654121133468629, 2.3917714522818123, -5.7742470781955415}, 
       {-0.654121133468629, 2.6166233596089232, -5.675894836406759}, 
       {-0.6541211334686303, 2.8374406233721663, -5.568790776177299}, 
       {-0.654121133468629, 3.0538827593559685, -5.453100044204982}, 
       {-0.6541211334686294, 3.2656160294746774, -5.329001027213078}, 
       {-0.6541211334686294, 3.4723139563725116, -5.196685076890909}, 
       {-0.6541211334686294, 3.673657826827956, -5.056356214843422}, 
       {-0.6541211334686294, 3.8693371831864622, -4.908230818004656}, 
       {-0.6541211334686285, 4.05905030206365, -4.752537285000193}, 
       {-0.654121133468629, 4.242504659580884, -4.589515683973036}, 
       {-0.6541211334686288, 4.419417382415921, -4.419417382415923}, 
       {-0.6541211334686292, 4.589515683973035, -4.242504659580886}, 
       {-0.654121133468629, 4.752537285000191, -4.0590503020636515}, 
       {-0.6541211334686301, 4.908230818004654, -3.8693371831864645}, 
       {-0.6541211334686292, 5.0563562148434205, -3.6736578268279585}, 
       {-0.6541211334686303, 5.196685076890907, -3.4723139563725134}, 
       {-0.6541211334686292, 5.329001027213077, -3.265616029474679}, 
       {-0.6541211334686295, 5.45310004420498, -3.0538827593559708}, 
       {-0.6541211334686294, 5.568790776177298, -2.8374406233721685}, 
       {-0.6541211334686295, 5.675894836406758, -2.6166233596089254}, 
       {-0.6541211334686294, 5.774247078195541, -2.391771452281815}, 
       {-0.6541211334686309, 5.8636958495155245, -2.1632316067343336}, 
       {-0.654121133468629, 5.944103226844709, -1.9313562148434227}, 
       {-0.6541211334686295, 6.0153452278352955, -1.6965028116567142}, 
       {-0.654121133468629, 6.077312002485479, -1.4590335240994075}, 
       {-0.6541211334686292, 6.12990800252019, -1.2193145126008045}, 
       {-0.6541211334686297, 6.17305212871961, -0.9777154065014443}, 
       {-0.6541211334686295, 6.206677855968289, -0.7346087341114854}, 
       {-0.6541211334686287, 6.23073333583205, -0.49036934829903517}, 
       {-0.6541211334686293, 6.245181476504518, -0.24537384849418173}, 
       {-0.654121133468629, 6.25, -1.5307579422779716*^-15}}, 
      {{-0.7033119314590373, 5., 0.}, {-0.7033119314590373, 
        4.996145181203614, 0.19629907879534306}, {-0.7033119314590373, 
        4.9845866686656395, 0.3922954786392247}, {-0.7033119314590373, 
        4.965342284774631, 0.5876869872891882}, {-0.7033119314590364, 
        4.938441702975689, 0.7821723252011543}, {-0.7033119314590373, 
        4.903926402016152, 0.9754516100806412}, {-0.7033119314590373, 
        4.861849601988383, 1.167226819279527}, {-0.7033119314590373, 
        4.812276182268237, 1.3572022493253713}, {-0.7033119314590381, 
        4.755282581475767, 1.545084971874737}, {-0.7033119314590373, 
        4.6909566796124205, 1.7305852853874648}, {-0.7033119314590373, 
        4.619397662556434, 1.913417161825449}, {-0.7033119314590381, 
        4.540715869125406, 2.0932986876871404}, {-0.7033119314590373, 
        4.455032620941839, 2.2699524986977337}, {-0.7033119314590373, 
        4.362480035363986, 2.4431062074847745}, {-0.7033119314590373, 
        4.263200821770461, 2.612492823579744}, {-0.7033119314590373, 
        4.157348061512726, 2.777851165098011}, {-0.7033119314590373, 
        4.045084971874737, 2.938926261462366}, {-0.7033119314590373, 
        3.9265846544037246, 3.0954697465491696}, {-0.7033119314590373, 
        3.8020298280001548, 3.2472402416509185}, {-0.7033119314590373, 
        3.6716125471784276, 3.3940037276647086}, {-0.7033119314590373, 
        3.5355339059327378, 3.5355339059327373}, {-0.7033119314590373, 
        3.394003727664709, 3.6716125471784276}, {-0.7033119314590373, 
        3.2472402416509185, 3.8020298280001548}, {-0.7033119314590373, 
        3.0954697465491696, 3.9265846544037246}, {-0.7033119314590364, 
        2.938926261462366, 4.045084971874737}, {-0.7033119314590364, 
        2.7778511650980113, 4.157348061512726}, {-0.7033119314590373, 
        2.6124928235797444, 4.263200821770461}, {-0.7033119314590373, 
        2.443106207484775, 4.362480035363985}, {-0.7033119314590373, 
        2.269952498697734, 4.455032620941839}, {-0.7033119314590373, 
        2.093298687687141, 4.540715869125406}, {-0.7033119314590373, 
        1.9134171618254492, 4.619397662556434}, {-0.7033119314590373, 
        1.730585285387465, 4.6909566796124205}, {-0.7033119314590381, 
        1.5450849718747373, 4.755282581475767}, {-0.7033119314590364, 
        1.3572022493253715, 4.812276182268237}, {-0.7033119314590373, 
        1.1672268192795274, 4.861849601988383}, {-0.7033119314590373, 
        0.9754516100806416, 4.903926402016152}, {-0.7033119314590364, 
        0.7821723252011547, 4.938441702975689}, {-0.7033119314590373, 
        0.5876869872891886, 4.965342284774631}, {-0.7033119314590373, 
        0.392295478639225, 4.9845866686656395}, {-0.7033119314590373, 
        0.19629907879534333, 4.996145181203614}, {-0.7033119314590373, 
        3.061515884555943*^-16, 5.}, {-0.7033119314590373, 
        -0.19629907879534275, 4.996145181203614}, {-0.7033119314590373, 
        -0.39229547863922437, 4.9845866686656395}, 
       {-0.7033119314590373, -0.5876869872891879, 4.965342284774631}, 
       {-0.7033119314590364, -0.7821723252011541, 4.938441702975689}, 
       {-0.7033119314590373, -0.975451610080641, 4.903926402016152}, 
       {-0.7033119314590373, -1.1672268192795268, 4.861849601988383}, 
       {-0.7033119314590373, -1.357202249325371, 4.812276182268237}, 
       {-0.7033119314590373, -1.5450849718747368, 4.755282581475768}, 
       {-0.7033119314590373, -1.7305852853874646, 4.6909566796124205}, 
       {-0.7033119314590373, -1.9134171618254485, 4.619397662556434}, 
       {-0.7033119314590364, -2.093298687687139, 4.540715869125408}, 
       {-0.7033119314590373, -2.2699524986977333, 4.455032620941839}, 
       {-0.7033119314590373, -2.4431062074847754, 4.362480035363985}, 
       {-0.7033119314590364, -2.612492823579744, 4.263200821770462}, 
       {-0.7033119314590373, -2.77785116509801, 4.157348061512727}, 
       {-0.7033119314590373, -2.938926261462365, 4.045084971874737}, 
       {-0.7033119314590373, -3.0954697465491705, 3.926584654403724}, 
       {-0.7033119314590373, -3.2472402416509176, 3.802029828000155}, 
       {-0.7033119314590373, -3.3940037276647077, 3.671612547178429}, 
       {-0.7033119314590373, -3.5355339059327373, 3.5355339059327378}, 
       {-0.7033119314590373, -3.6716125471784284, 3.3940037276647086}, 
       {-0.7033119314590373, -3.8020298280001548, 3.247240241650919}, 
       {-0.7033119314590373, -3.9265846544037237, 3.095469746549171}, 
       {-0.7033119314590373, -4.045084971874736, 2.9389262614623664}, 
       {-0.7033119314590373, -4.157348061512726, 2.777851165098011}, 
       {-0.7033119314590373, -4.263200821770461, 2.6124928235797444}, 
       {-0.7033119314590373, -4.362480035363985, 2.4431062074847762}, 
       {-0.7033119314590373, -4.455032620941839, 2.269952498697734}, 
       {-0.7033119314590373, -4.540715869125407, 2.09329868768714}, 
       {-0.7033119314590373, -4.619397662556434, 1.9134171618254494}, 
       {-0.7033119314590373, -4.6909566796124205, 1.7305852853874666}, 
       {-0.7033119314590373, -4.755282581475767, 1.5450849718747375}, 
       {-0.7033119314590373, -4.812276182268237, 1.3572022493253708}, 
       {-0.7033119314590373, -4.861849601988383, 1.1672268192795276}, 
       {-0.7033119314590373, -4.903926402016152, 0.9754516100806431}, 
       {-0.7033119314590373, -4.938441702975688, 0.7821723252011549}, 
       {-0.7033119314590373, -4.965342284774631, 0.5876869872891878}, 
       {-0.7033119314590373, -4.9845866686656395, 0.3922954786392253}, 
       {-0.7033119314590373, -4.996145181203614, 0.19629907879534475}, 
       {-0.7033119314590373, -5., 6.123031769111886*^-16}, 
       {-0.7033119314590373, -4.996145181203614, -0.19629907879534353}, 
       {-0.7033119314590373, -4.9845866686656395, -0.3922954786392241}, 
       {-0.7033119314590373, -4.965342284774631, -0.5876869872891864}, 
       {-0.7033119314590364, -4.938441702975689, -0.7821723252011537}, 
       {-0.7033119314590373, -4.903926402016152, -0.9754516100806419}, 
       {-0.7033119314590373, -4.861849601988383, -1.1672268192795263}, 
       {-0.7033119314590373, -4.812276182268237, -1.3572022493253697}, 
       {-0.7033119314590373, -4.755282581475768, -1.5450849718747364}, 
       {-0.7033119314590373, -4.6909566796124205, -1.7305852853874653}, 
       {-0.7033119314590373, -4.619397662556434, -1.9134171618254483}, 
       {-0.7033119314590373, -4.540715869125408, -2.0932986876871387}, 
       {-0.7033119314590373, -4.455032620941839, -2.2699524986977333}, 
       {-0.7033119314590373, -4.362480035363985, -2.443106207484775}, 
       {-0.7033119314590373, -4.263200821770462, -2.6124928235797436}, 
       {-0.7033119314590373, -4.157348061512727, -2.77785116509801}, 
       {-0.7033119314590364, -4.045084971874738, -2.938926261462365}, 
       {-0.7033119314590373, -3.926584654403724, -3.0954697465491705}, 
       {-0.7033119314590373, -3.802029828000155, -3.2472402416509176}, 
       {-0.7033119314590373, -3.671612547178429, -3.3940037276647073}, 
       {-0.7033119314590364, -3.5355339059327386, -3.5355339059327373}, 
       {-0.7033119314590373, -3.3940037276647086, -3.6716125471784276}, 
       {-0.7033119314590373, -3.2472402416509203, -3.802029828000153}, 
       {-0.7033119314590373, -3.0954697465491714, -3.9265846544037237}, 
       {-0.7033119314590373, -2.9389262614623664, -4.045084971874736}, 
       {-0.7033119314590373, -2.777851165098011, -4.157348061512726}, 
       {-0.7033119314590373, -2.6124928235797427, -4.263200821770462}, 
       {-0.7033119314590373, -2.4431062074847762, -4.362480035363985}, 
       {-0.7033119314590373, -2.2699524986977346, -4.455032620941839}, 
       {-0.7033119314590373, -2.09329868768714, -4.540715869125407}, 
       {-0.7033119314590373, -1.9134171618254516, -4.619397662556432}, 
       {-0.7033119314590373, -1.7305852853874668, -4.6909566796124205}, 
       {-0.7033119314590373, -1.5450849718747377, -4.755282581475767}, 
       {-0.7033119314590373, -1.357202249325371, -4.812276182268237}, 
       {-0.7033119314590381, -1.1672268192795257, -4.861849601988383}, 
       {-0.7033119314590373, -0.9754516100806433, -4.903926402016151}, 
       {-0.7033119314590373, -0.7821723252011552, -4.938441702975688}, 
       {-0.7033119314590373, -0.587686987289188, -4.965342284774631}, 
       {-0.7033119314590373, -0.39229547863922787, -4.9845866686656395}, 
       {-0.7033119314590373, -0.19629907879534506, -4.996145181203614}, 
       {-0.7033119314590373, -9.18454765366783*^-16, -5.}, 
       {-0.7033119314590373, 0.19629907879534322, -4.996145181203614}, 
       {-0.7033119314590373, 0.39229547863922604, -4.9845866686656395}, 
       {-0.7033119314590381, 0.5876869872891862, -4.965342284774631}, 
       {-0.7033119314590364, 0.7821723252011534, -4.938441702975689}, 
       {-0.7033119314590373, 0.9754516100806415, -4.903926402016152}, 
       {-0.7033119314590373, 1.1672268192795239, -4.861849601988384}, 
       {-0.7033119314590373, 1.3572022493253693, -4.812276182268237}, 
       {-0.7033119314590373, 1.5450849718747361, -4.755282581475768}, 
       {-0.7033119314590373, 1.730585285387465, -4.6909566796124205}, 
       {-0.7033119314590373, 1.91341716182545, -4.619397662556433}, 
       {-0.7033119314590373, 2.0932986876871382, -4.540715869125408}, 
       {-0.7033119314590373, 2.2699524986977333, -4.455032620941839}, 
       {-0.7033119314590373, 2.443106207484775, -4.362480035363985}, 
       {-0.7033119314590373, 2.6124928235797418, -4.263200821770463}, 
       {-0.7033119314590373, 2.777851165098009, -4.157348061512727}, 
       {-0.7033119314590373, 2.9389262614623646, -4.045084971874738}, 
       {-0.7033119314590373, 3.0954697465491696, -3.9265846544037246}, 
       {-0.7033119314590373, 3.2472402416509194, -3.802029828000154}, 
       {-0.7033119314590373, 3.3940037276647073, -3.671612547178429}, 
       {-0.7033119314590373, 3.535533905932737, -3.5355339059327386}, 
       {-0.7033119314590373, 3.6716125471784276, -3.394003727664709}, 
       {-0.7033119314590373, 3.8020298280001525, -3.247240241650921}, 
       {-0.7033119314590373, 3.9265846544037233, -3.0954697465491714}, 
       {-0.7033119314590373, 4.045084971874736, -2.938926261462367}, 
       {-0.7033119314590373, 4.157348061512726, -2.777851165098011}, 
       {-0.7033119314590373, 4.263200821770462, -2.6124928235797436}, 
       {-0.7033119314590373, 4.362480035363984, -2.4431062074847767}, 
       {-0.7033119314590373, 4.455032620941839, -2.2699524986977346}, 
       {-0.7033119314590381, 4.540715869125406, -2.0932986876871404}, 
       {-0.7033119314590373, 4.619397662556432, -1.913417161825452}, 
       {-0.7033119314590373, 4.69095667961242, -1.730585285387467}, 
       {-0.7033119314590373, 4.755282581475767, -1.5450849718747381}, 
       {-0.7033119314590373, 4.812276182268237, -1.3572022493253713}, 
       {-0.7033119314590373, 4.861849601988383, -1.1672268192795259}, 
       {-0.7033119314590373, 4.903926402016151, -0.9754516100806436}, 
       {-0.7033119314590373, 4.938441702975688, -0.7821723252011554}, 
       {-0.7033119314590373, 4.965342284774631, -0.5876869872891883}, 
       {-0.7033119314590373, 4.9845866686656395, -0.3922954786392281}, 
       {-0.7033119314590373, 4.996145181203614, -0.19629907879534536}, 
       {-0.7033119314590373, 5., -1.2246063538223773*^-15}}, 
      {{-0.05, 2.5, 0.}, {-0.05, 2.498072590601807, 
        0.09814953939767153}, {-0.05, 2.4922933343328197, 
        0.19614773931961235}, {-0.05, 2.4826711423873156, 
        0.2938434936445941}, {-0.05, 2.4692208514878446, 
        0.39108616260057716}, {-0.05, 2.451963201008076, 
        0.4877258050403206}, {-0.05, 2.4309248009941915, 
        0.5836134096397635}, {-0.05, 2.4061380911341184, 
        0.6786011246626856}, {-0.05, 2.3776412907378837, 
        0.7725424859373685}, {-0.05, 2.3454783398062102, 
        0.8652926426937324}, {-0.05, 2.309698831278217, 
        0.9567085809127245}, {-0.05, 2.270357934562703, 
        1.0466493438435702}, {-0.05, 2.2275163104709197, 
        1.1349762493488669}, {-0.05, 2.181240017681993, 
        1.2215531037423872}, {-0.05, 2.1316004108852304, 
        1.306246411789872}, {-0.05, 2.078674030756363, 
        1.3889255825490054}, {-0.05, 2.0225424859373686, 
        1.469463130731183}, {-0.05, 1.9632923272018623, 
        1.5477348732745848}, {-0.05, 1.9010149140000774, 
        1.6236201208254593}, {-0.05, 1.8358062735892138, 
        1.6970018638323543}, {-0.05, 1.7677669529663689, 
        1.7677669529663687}, {-0.05, 1.6970018638323545, 
        1.8358062735892138}, {-0.05, 1.6236201208254593, 
        1.9010149140000774}, {-0.05, 1.5477348732745848, 
        1.9632923272018623}, {-0.05, 1.469463130731183, 
        2.0225424859373686}, {-0.05, 1.3889255825490057, 
        2.078674030756363}, {-0.05, 1.3062464117898722, 
        2.1316004108852304}, {-0.05, 1.2215531037423875, 
        2.1812400176819926}, {-0.05, 1.134976249348867, 
        2.2275163104709197}, {-0.05, 1.0466493438435704, 
        2.270357934562703}, {-0.05, 0.9567085809127246, 
        2.309698831278217}, {-0.05, 0.8652926426937325, 
        2.3454783398062102}, {-0.05, 0.7725424859373686, 
        2.3776412907378837}, {-0.05, 0.6786011246626857, 
        2.4061380911341184}, {-0.05, 0.5836134096397637, 
        2.4309248009941915}, {-0.05, 0.4877258050403208, 
        2.451963201008076}, {-0.05, 0.3910861626005773, 
        2.4692208514878446}, {-0.05, 0.2938434936445943, 
        2.4826711423873156}, {-0.05, 0.1961477393196125, 
        2.4922933343328197}, {-0.05, 0.09814953939767167, 
        2.498072590601807}, {-0.05, 1.5307579422779716*^-16, 2.5}, 
       {-0.05, -0.09814953939767138, 2.498072590601807}, 
       {-0.05, -0.19614773931961219, 2.4922933343328197}, 
       {-0.05, -0.29384349364459394, 2.4826711423873156}, 
       {-0.05, -0.39108616260057705, 2.4692208514878446}, 
       {-0.05, -0.4877258050403205, 2.451963201008076}, 
       {-0.05, -0.5836134096397634, 2.4309248009941915}, 
       {-0.05, -0.6786011246626855, 2.4061380911341184}, 
       {-0.05, -0.7725424859373684, 2.377641290737884}, 
       {-0.05, -0.8652926426937323, 2.3454783398062102}, 
       {-0.05, -0.9567085809127243, 2.309698831278217}, 
       {-0.05, -1.0466493438435696, 2.270357934562704}, 
       {-0.05, -1.1349762493488667, 2.2275163104709197}, 
       {-0.05, -1.2215531037423877, 2.1812400176819926}, 
       {-0.05, -1.306246411789872, 2.131600410885231}, 
       {-0.05, -1.388925582549005, 2.0786740307563636}, 
       {-0.05, -1.4694631307311825, 2.0225424859373686}, 
       {-0.05, -1.5477348732745853, 1.963292327201862}, 
       {-0.05, -1.6236201208254588, 1.9010149140000776}, 
       {-0.05, -1.6970018638323539, 1.8358062735892144}, 
       {-0.05, -1.7677669529663687, 1.7677669529663689}, 
       {-0.05, -1.8358062735892142, 1.6970018638323543}, 
       {-0.05, -1.9010149140000774, 1.6236201208254595}, 
       {-0.05, -1.9632923272018619, 1.5477348732745855}, 
       {-0.05, -2.022542485937368, 1.4694631307311832}, 
       {-0.05, -2.078674030756363, 1.3889255825490054}, 
       {-0.05, -2.1316004108852304, 1.3062464117898722}, 
       {-0.05, -2.1812400176819926, 1.2215531037423881}, 
       {-0.05, -2.2275163104709197, 1.134976249348867}, 
       {-0.05, -2.2703579345627034, 1.04664934384357}, 
       {-0.05, -2.309698831278217, 0.9567085809127247}, 
       {-0.05, -2.3454783398062102, 0.8652926426937333}, 
       {-0.05, -2.3776412907378837, 0.7725424859373687}, 
       {-0.05, -2.4061380911341184, 0.6786011246626854}, 
       {-0.05, -2.4309248009941915, 0.5836134096397638}, 
       {-0.05, -2.451963201008076, 0.48772580504032154}, 
       {-0.05, -2.469220851487844, 0.39108616260057744}, 
       {-0.05, -2.4826711423873156, 0.2938434936445939}, 
       {-0.05, -2.4922933343328197, 0.19614773931961266}, 
       {-0.05, -2.498072590601807, 0.09814953939767238}, 
       {-0.05, -2.5, 3.061515884555943*^-16}, 
       {-0.05, -2.498072590601807, -0.09814953939767176}, 
       {-0.05, -2.4922933343328197, -0.19614773931961205}, 
       {-0.05, -2.4826711423873156, -0.2938434936445932}, 
       {-0.05, -2.4692208514878446, -0.3910861626005768}, 
       {-0.05, -2.451963201008076, -0.4877258050403209}, 
       {-0.05, -2.4309248009941915, -0.5836134096397632}, 
       {-0.05, -2.4061380911341184, -0.6786011246626849}, 
       {-0.05, -2.377641290737884, -0.7725424859373682}, 
       {-0.05, -2.3454783398062102, -0.8652926426937326}, 
       {-0.05, -2.309698831278217, -0.9567085809127241}, 
       {-0.05, -2.270357934562704, -1.0466493438435693}, 
       {-0.05, -2.2275163104709197, -1.1349762493488667}, 
       {-0.05, -2.1812400176819926, -1.2215531037423875}, 
       {-0.05, -2.131600410885231, -1.3062464117898718}, 
       {-0.05, -2.0786740307563636, -1.388925582549005}, 
       {-0.05, -2.022542485937369, -1.4694631307311825}, 
       {-0.05, -1.963292327201862, -1.5477348732745853}, 
       {-0.05, -1.9010149140000776, -1.6236201208254588}, 
       {-0.05, -1.8358062735892144, -1.6970018638323536}, 
       {-0.05, -1.7677669529663693, -1.7677669529663687}, 
       {-0.05, -1.6970018638323543, -1.8358062735892138}, 
       {-0.05, -1.6236201208254601, -1.9010149140000765}, 
       {-0.05, -1.5477348732745857, -1.9632923272018619}, 
       {-0.05, -1.4694631307311832, -2.022542485937368}, 
       {-0.05, -1.3889255825490054, -2.078674030756363}, 
       {-0.05, -1.3062464117898713, -2.131600410885231}, 
       {-0.05, -1.2215531037423881, -2.1812400176819926}, 
       {-0.05, -1.1349762493488673, -2.2275163104709197}, 
       {-0.05, -1.04664934384357, -2.2703579345627034}, 
       {-0.05, -0.9567085809127258, -2.309698831278216}, 
       {-0.05, -0.8652926426937334, -2.3454783398062102}, 
       {-0.05, -0.7725424859373689, -2.3776412907378837}, 
       {-0.05, -0.6786011246626855, -2.4061380911341184}, 
       {-0.05, -0.5836134096397628, -2.4309248009941915}, 
       {-0.05, -0.48772580504032165, -2.4519632010080756}, 
       {-0.05, -0.3910861626005776, -2.469220851487844}, 
       {-0.05, -0.293843493644594, -2.4826711423873156}, 
       {-0.05, -0.19614773931961393, -2.4922933343328197}, 
       {-0.05, -0.09814953939767253, -2.498072590601807}, 
       {-0.05, -4.592273826833915*^-16, -2.5}, 
       {-0.05, 0.09814953939767161, -2.498072590601807}, 
       {-0.05, 0.19614773931961302, -2.4922933343328197}, 
       {-0.05, 0.2938434936445931, -2.4826711423873156}, 
       {-0.05, 0.3910861626005767, -2.4692208514878446}, 
       {-0.05, 0.48772580504032076, -2.451963201008076}, 
       {-0.05, 0.5836134096397619, -2.430924800994192}, 
       {-0.05, 0.6786011246626846, -2.4061380911341184}, 
       {-0.05, 0.7725424859373681, -2.377641290737884}, 
       {-0.05, 0.8652926426937325, -2.3454783398062102}, 
       {-0.05, 0.956708580912725, -2.3096988312782165}, 
       {-0.05, 1.0466493438435691, -2.270357934562704}, 
       {-0.05, 1.1349762493488667, -2.2275163104709197}, 
       {-0.05, 1.2215531037423875, -2.1812400176819926}, 
       {-0.05, 1.3062464117898709, -2.1316004108852313}, 
       {-0.05, 1.3889255825490046, -2.0786740307563636}, 
       {-0.05, 1.4694631307311823, -2.022542485937369}, 
       {-0.05, 1.5477348732745848, -1.9632923272018623}, 
       {-0.05, 1.6236201208254597, -1.901014914000077}, 
       {-0.05, 1.6970018638323536, -1.8358062735892144}, 
       {-0.05, 1.7677669529663684, -1.7677669529663693}, 
       {-0.05, 1.8358062735892138, -1.6970018638323545}, 
       {-0.05, 1.9010149140000763, -1.6236201208254606}, 
       {-0.05, 1.9632923272018616, -1.5477348732745857}, 
       {-0.05, 2.022542485937368, -1.4694631307311834}, 
       {-0.05, 2.078674030756363, -1.3889255825490054}, 
       {-0.05, 2.131600410885231, -1.3062464117898718}, 
       {-0.05, 2.181240017681992, -1.2215531037423883}, 
       {-0.05, 2.2275163104709197, -1.1349762493488673}, 
       {-0.05, 2.270357934562703, -1.0466493438435702}, 
       {-0.05, 2.309698831278216, -0.956708580912726}, 
       {-0.05, 2.34547833980621, -0.8652926426937335}, 
       {-0.05, 2.3776412907378837, -0.7725424859373691}, 
       {-0.05, 2.4061380911341184, -0.6786011246626856}, 
       {-0.05, 2.4309248009941915, -0.5836134096397629}, 
       {-0.05, 2.4519632010080756, -0.4877258050403218}, 
       {-0.05, 2.469220851487844, -0.3910861626005777}, 
       {-0.05, 2.4826711423873156, -0.29384349364459417}, 
       {-0.05, 2.4922933343328197, -0.19614773931961405}, 
       {-0.05, 2.498072590601807, -0.09814953939767268}, 
       {-0.05, 2.5, -6.123031769111886*^-16}}, {{-0.05, 2.5, 0.}, 
       {-0.05, 2.498072590601807, 0.09814953939767153}, 
       {-0.05, 2.4922933343328197, 0.19614773931961235}, 
       {-0.05, 2.4826711423873156, 0.2938434936445941}, 
       {-0.05, 2.4692208514878446, 0.39108616260057716}, 
       {-0.05, 2.451963201008076, 0.4877258050403206}, 
       {-0.05, 2.4309248009941915, 0.5836134096397635}, 
       {-0.05, 2.4061380911341184, 0.6786011246626856}, 
       {-0.05, 2.3776412907378837, 0.7725424859373685}, 
       {-0.05, 2.3454783398062102, 0.8652926426937324}, 
       {-0.05, 2.309698831278217, 0.9567085809127245}, 
       {-0.05, 2.270357934562703, 1.0466493438435702}, 
       {-0.05, 2.2275163104709197, 1.1349762493488669}, 
       {-0.05, 2.181240017681993, 1.2215531037423872}, 
       {-0.05, 2.1316004108852304, 1.306246411789872}, 
       {-0.05, 2.078674030756363, 1.3889255825490054}, 
       {-0.05, 2.0225424859373686, 1.469463130731183}, 
       {-0.05, 1.9632923272018623, 1.5477348732745848}, 
       {-0.05, 1.9010149140000774, 1.6236201208254593}, 
       {-0.05, 1.8358062735892138, 1.6970018638323543}, 
       {-0.05, 1.7677669529663689, 1.7677669529663687}, 
       {-0.05, 1.6970018638323545, 1.8358062735892138}, 
       {-0.05, 1.6236201208254593, 1.9010149140000774}, 
       {-0.05, 1.5477348732745848, 1.9632923272018623}, 
       {-0.05, 1.469463130731183, 2.0225424859373686}, 
       {-0.05, 1.3889255825490057, 2.078674030756363}, 
       {-0.05, 1.3062464117898722, 2.1316004108852304}, 
       {-0.05, 1.2215531037423875, 2.1812400176819926}, 
       {-0.05, 1.134976249348867, 2.2275163104709197}, 
       {-0.05, 1.0466493438435704, 2.270357934562703}, 
       {-0.05, 0.9567085809127246, 2.309698831278217}, 
       {-0.05, 0.8652926426937325, 2.3454783398062102}, 
       {-0.05, 0.7725424859373686, 2.3776412907378837}, 
       {-0.05, 0.6786011246626857, 2.4061380911341184}, 
       {-0.05, 0.5836134096397637, 2.4309248009941915}, 
       {-0.05, 0.4877258050403208, 2.451963201008076}, 
       {-0.05, 0.3910861626005773, 2.4692208514878446}, 
       {-0.05, 0.2938434936445943, 2.4826711423873156}, 
       {-0.05, 0.1961477393196125, 2.4922933343328197}, 
       {-0.05, 0.09814953939767167, 2.498072590601807}, 
       {-0.05, 1.5307579422779716*^-16, 2.5}, 
       {-0.05, -0.09814953939767138, 2.498072590601807}, 
       {-0.05, -0.19614773931961219, 2.4922933343328197}, 
       {-0.05, -0.29384349364459394, 2.4826711423873156}, 
       {-0.05, -0.39108616260057705, 2.4692208514878446}, 
       {-0.05, -0.4877258050403205, 2.451963201008076}, 
       {-0.05, -0.5836134096397634, 2.4309248009941915}, 
       {-0.05, -0.6786011246626855, 2.4061380911341184}, 
       {-0.05, -0.7725424859373684, 2.377641290737884}, 
       {-0.05, -0.8652926426937323, 2.3454783398062102}, 
       {-0.05, -0.9567085809127243, 2.309698831278217}, 
       {-0.05, -1.0466493438435696, 2.270357934562704}, 
       {-0.05, -1.1349762493488667, 2.2275163104709197}, 
       {-0.05, -1.2215531037423877, 2.1812400176819926}, 
       {-0.05, -1.306246411789872, 2.131600410885231}, 
       {-0.05, -1.388925582549005, 2.0786740307563636}, 
       {-0.05, -1.4694631307311825, 2.0225424859373686}, 
       {-0.05, -1.5477348732745853, 1.963292327201862}, 
       {-0.05, -1.6236201208254588, 1.9010149140000776}, 
       {-0.05, -1.6970018638323539, 1.8358062735892144}, 
       {-0.05, -1.7677669529663687, 1.7677669529663689}, 
       {-0.05, -1.8358062735892142, 1.6970018638323543}, 
       {-0.05, -1.9010149140000774, 1.6236201208254595}, 
       {-0.05, -1.9632923272018619, 1.5477348732745855}, 
       {-0.05, -2.022542485937368, 1.4694631307311832}, 
       {-0.05, -2.078674030756363, 1.3889255825490054}, 
       {-0.05, -2.1316004108852304, 1.3062464117898722}, 
       {-0.05, -2.1812400176819926, 1.2215531037423881}, 
       {-0.05, -2.2275163104709197, 1.134976249348867}, 
       {-0.05, -2.2703579345627034, 1.04664934384357}, 
       {-0.05, -2.309698831278217, 0.9567085809127247}, 
       {-0.05, -2.3454783398062102, 0.8652926426937333}, 
       {-0.05, -2.3776412907378837, 0.7725424859373687}, 
       {-0.05, -2.4061380911341184, 0.6786011246626854}, 
       {-0.05, -2.4309248009941915, 0.5836134096397638}, 
       {-0.05, -2.451963201008076, 0.48772580504032154}, 
       {-0.05, -2.469220851487844, 0.39108616260057744}, 
       {-0.05, -2.4826711423873156, 0.2938434936445939}, 
       {-0.05, -2.4922933343328197, 0.19614773931961266}, 
       {-0.05, -2.498072590601807, 0.09814953939767238}, 
       {-0.05, -2.5, 3.061515884555943*^-16}, 
       {-0.05, -2.498072590601807, -0.09814953939767176}, 
       {-0.05, -2.4922933343328197, -0.19614773931961205}, 
       {-0.05, -2.4826711423873156, -0.2938434936445932}, 
       {-0.05, -2.4692208514878446, -0.3910861626005768}, 
       {-0.05, -2.451963201008076, -0.4877258050403209}, 
       {-0.05, -2.4309248009941915, -0.5836134096397632}, 
       {-0.05, -2.4061380911341184, -0.6786011246626849}, 
       {-0.05, -2.377641290737884, -0.7725424859373682}, 
       {-0.05, -2.3454783398062102, -0.8652926426937326}, 
       {-0.05, -2.309698831278217, -0.9567085809127241}, 
       {-0.05, -2.270357934562704, -1.0466493438435693}, 
       {-0.05, -2.2275163104709197, -1.1349762493488667}, 
       {-0.05, -2.1812400176819926, -1.2215531037423875}, 
       {-0.05, -2.131600410885231, -1.3062464117898718}, 
       {-0.05, -2.0786740307563636, -1.388925582549005}, 
       {-0.05, -2.022542485937369, -1.4694631307311825}, 
       {-0.05, -1.963292327201862, -1.5477348732745853}, 
       {-0.05, -1.9010149140000776, -1.6236201208254588}, 
       {-0.05, -1.8358062735892144, -1.6970018638323536}, 
       {-0.05, -1.7677669529663693, -1.7677669529663687}, 
       {-0.05, -1.6970018638323543, -1.8358062735892138}, 
       {-0.05, -1.6236201208254601, -1.9010149140000765}, 
       {-0.05, -1.5477348732745857, -1.9632923272018619}, 
       {-0.05, -1.4694631307311832, -2.022542485937368}, 
       {-0.05, -1.3889255825490054, -2.078674030756363}, 
       {-0.05, -1.3062464117898713, -2.131600410885231}, 
       {-0.05, -1.2215531037423881, -2.1812400176819926}, 
       {-0.05, -1.1349762493488673, -2.2275163104709197}, 
       {-0.05, -1.04664934384357, -2.2703579345627034}, 
       {-0.05, -0.9567085809127258, -2.309698831278216}, 
       {-0.05, -0.8652926426937334, -2.3454783398062102}, 
       {-0.05, -0.7725424859373689, -2.3776412907378837}, 
       {-0.05, -0.6786011246626855, -2.4061380911341184}, 
       {-0.05, -0.5836134096397628, -2.4309248009941915}, 
       {-0.05, -0.48772580504032165, -2.4519632010080756}, 
       {-0.05, -0.3910861626005776, -2.469220851487844}, 
       {-0.05, -0.293843493644594, -2.4826711423873156}, 
       {-0.05, -0.19614773931961393, -2.4922933343328197}, 
       {-0.05, -0.09814953939767253, -2.498072590601807}, 
       {-0.05, -4.592273826833915*^-16, -2.5}, 
       {-0.05, 0.09814953939767161, -2.498072590601807}, 
       {-0.05, 0.19614773931961302, -2.4922933343328197}, 
       {-0.05, 0.2938434936445931, -2.4826711423873156}, 
       {-0.05, 0.3910861626005767, -2.4692208514878446}, 
       {-0.05, 0.48772580504032076, -2.451963201008076}, 
       {-0.05, 0.5836134096397619, -2.430924800994192}, 
       {-0.05, 0.6786011246626846, -2.4061380911341184}, 
       {-0.05, 0.7725424859373681, -2.377641290737884}, 
       {-0.05, 0.8652926426937325, -2.3454783398062102}, 
       {-0.05, 0.956708580912725, -2.3096988312782165}, 
       {-0.05, 1.0466493438435691, -2.270357934562704}, 
       {-0.05, 1.1349762493488667, -2.2275163104709197}, 
       {-0.05, 1.2215531037423875, -2.1812400176819926}, 
       {-0.05, 1.3062464117898709, -2.1316004108852313}, 
       {-0.05, 1.3889255825490046, -2.0786740307563636}, 
       {-0.05, 1.4694631307311823, -2.022542485937369}, 
       {-0.05, 1.5477348732745848, -1.9632923272018623}, 
       {-0.05, 1.6236201208254597, -1.901014914000077}, 
       {-0.05, 1.6970018638323536, -1.8358062735892144}, 
       {-0.05, 1.7677669529663684, -1.7677669529663693}, 
       {-0.05, 1.8358062735892138, -1.6970018638323545}, 
       {-0.05, 1.9010149140000763, -1.6236201208254606}, 
       {-0.05, 1.9632923272018616, -1.5477348732745857}, 
       {-0.05, 2.022542485937368, -1.4694631307311834}, 
       {-0.05, 2.078674030756363, -1.3889255825490054}, 
       {-0.05, 2.131600410885231, -1.3062464117898718}, 
       {-0.05, 2.181240017681992, -1.2215531037423883}, 
       {-0.05, 2.2275163104709197, -1.1349762493488673}, 
       {-0.05, 2.270357934562703, -1.0466493438435702}, 
       {-0.05, 2.309698831278216, -0.956708580912726}, 
       {-0.05, 2.34547833980621, -0.8652926426937335}, 
       {-0.05, 2.3776412907378837, -0.7725424859373691}, 
       {-0.05, 2.4061380911341184, -0.6786011246626856}, 
       {-0.05, 2.4309248009941915, -0.5836134096397629}, 
       {-0.05, 2.4519632010080756, -0.4877258050403218}, 
       {-0.05, 2.469220851487844, -0.3910861626005777}, 
       {-0.05, 2.4826711423873156, -0.29384349364459417}, 
       {-0.05, 2.4922933343328197, -0.19614773931961405}, 
       {-0.05, 2.498072590601807, -0.09814953939767268}, 
       {-0.05, 2.5, -6.123031769111886*^-16}}, {{-0.05, 5., 0.}, 
       {-0.05, 4.996145181203614, 0.19629907879534306}, 
       {-0.05, 4.9845866686656395, 0.3922954786392247}, 
       {-0.05, 4.965342284774631, 0.5876869872891882}, 
       {-0.05, 4.938441702975689, 0.7821723252011543}, 
       {-0.05, 4.903926402016152, 0.9754516100806412}, 
       {-0.05, 4.861849601988383, 1.167226819279527}, 
       {-0.05, 4.812276182268237, 1.3572022493253713}, 
       {-0.05, 4.755282581475767, 1.545084971874737}, 
       {-0.05, 4.6909566796124205, 1.7305852853874648}, 
       {-0.05, 4.619397662556434, 1.913417161825449}, 
       {-0.05, 4.540715869125406, 2.0932986876871404}, 
       {-0.05, 4.455032620941839, 2.2699524986977337}, 
       {-0.05, 4.362480035363986, 2.4431062074847745}, 
       {-0.05, 4.263200821770461, 2.612492823579744}, 
       {-0.05, 4.157348061512726, 2.777851165098011}, 
       {-0.05, 4.045084971874737, 2.938926261462366}, 
       {-0.05, 3.9265846544037246, 3.0954697465491696}, 
       {-0.05, 3.8020298280001548, 3.2472402416509185}, 
       {-0.05, 3.6716125471784276, 3.3940037276647086}, 
       {-0.05, 3.5355339059327378, 3.5355339059327373}, 
       {-0.05, 3.394003727664709, 3.6716125471784276}, 
       {-0.05, 3.2472402416509185, 3.8020298280001548}, 
       {-0.05, 3.0954697465491696, 3.9265846544037246}, 
       {-0.05, 2.938926261462366, 4.045084971874737}, 
       {-0.05, 2.7778511650980113, 4.157348061512726}, 
       {-0.05, 2.6124928235797444, 4.263200821770461}, 
       {-0.05, 2.443106207484775, 4.362480035363985}, 
       {-0.05, 2.269952498697734, 4.455032620941839}, 
       {-0.05, 2.093298687687141, 4.540715869125406}, 
       {-0.05, 1.9134171618254492, 4.619397662556434}, 
       {-0.05, 1.730585285387465, 4.6909566796124205}, 
       {-0.05, 1.5450849718747373, 4.755282581475767}, 
       {-0.05, 1.3572022493253715, 4.812276182268237}, 
       {-0.05, 1.1672268192795274, 4.861849601988383}, 
       {-0.05, 0.9754516100806416, 4.903926402016152}, 
       {-0.05, 0.7821723252011547, 4.938441702975689}, 
       {-0.05, 0.5876869872891886, 4.965342284774631}, 
       {-0.05, 0.392295478639225, 4.9845866686656395}, 
       {-0.05, 0.19629907879534333, 4.996145181203614}, 
       {-0.05, 3.061515884555943*^-16, 5.}, 
       {-0.05, -0.19629907879534275, 4.996145181203614}, 
       {-0.05, -0.39229547863922437, 4.9845866686656395}, 
       {-0.05, -0.5876869872891879, 4.965342284774631}, 
       {-0.05, -0.7821723252011541, 4.938441702975689}, 
       {-0.05, -0.975451610080641, 4.903926402016152}, 
       {-0.05, -1.1672268192795268, 4.861849601988383}, 
       {-0.05, -1.357202249325371, 4.812276182268237}, 
       {-0.05, -1.5450849718747368, 4.755282581475768}, 
       {-0.05, -1.7305852853874646, 4.6909566796124205}, 
       {-0.05, -1.9134171618254485, 4.619397662556434}, 
       {-0.05, -2.093298687687139, 4.540715869125408}, 
       {-0.05, -2.2699524986977333, 4.455032620941839}, 
       {-0.05, -2.4431062074847754, 4.362480035363985}, 
       {-0.05, -2.612492823579744, 4.263200821770462}, 
       {-0.05, -2.77785116509801, 4.157348061512727}, 
       {-0.05, -2.938926261462365, 4.045084971874737}, 
       {-0.05, -3.0954697465491705, 3.926584654403724}, 
       {-0.05, -3.2472402416509176, 3.802029828000155}, 
       {-0.05, -3.3940037276647077, 3.671612547178429}, 
       {-0.05, -3.5355339059327373, 3.5355339059327378}, 
       {-0.05, -3.6716125471784284, 3.3940037276647086}, 
       {-0.05, -3.8020298280001548, 3.247240241650919}, 
       {-0.05, -3.9265846544037237, 3.095469746549171}, 
       {-0.05, -4.045084971874736, 2.9389262614623664}, 
       {-0.05, -4.157348061512726, 2.777851165098011}, 
       {-0.05, -4.263200821770461, 2.6124928235797444}, 
       {-0.05, -4.362480035363985, 2.4431062074847762}, 
       {-0.05, -4.455032620941839, 2.269952498697734}, 
       {-0.05, -4.540715869125407, 2.09329868768714}, 
       {-0.05, -4.619397662556434, 1.9134171618254494}, 
       {-0.05, -4.6909566796124205, 1.7305852853874666}, 
       {-0.05, -4.755282581475767, 1.5450849718747375}, 
       {-0.05, -4.812276182268237, 1.3572022493253708}, 
       {-0.05, -4.861849601988383, 1.1672268192795276}, 
       {-0.05, -4.903926402016152, 0.9754516100806431}, 
       {-0.05, -4.938441702975688, 0.7821723252011549}, 
       {-0.05, -4.965342284774631, 0.5876869872891878}, 
       {-0.05, -4.9845866686656395, 0.3922954786392253}, 
       {-0.05, -4.996145181203614, 0.19629907879534475}, 
       {-0.05, -5., 6.123031769111886*^-16}, {-0.05, -4.996145181203614, 
        -0.19629907879534353}, {-0.05, -4.9845866686656395, 
        -0.3922954786392241}, {-0.05, -4.965342284774631, 
        -0.5876869872891864}, {-0.05, -4.938441702975689, 
        -0.7821723252011537}, {-0.05, -4.903926402016152, 
        -0.9754516100806419}, {-0.05, -4.861849601988383, 
        -1.1672268192795263}, {-0.05, -4.812276182268237, 
        -1.3572022493253697}, {-0.05, -4.755282581475768, 
        -1.5450849718747364}, {-0.05, -4.6909566796124205, 
        -1.7305852853874653}, {-0.05, -4.619397662556434, 
        -1.9134171618254483}, {-0.05, -4.540715869125408, 
        -2.0932986876871387}, {-0.05, -4.455032620941839, 
        -2.2699524986977333}, {-0.05, -4.362480035363985, 
        -2.443106207484775}, {-0.05, -4.263200821770462, 
        -2.6124928235797436}, {-0.05, -4.157348061512727, 
        -2.77785116509801}, {-0.05, -4.045084971874738, 
        -2.938926261462365}, {-0.05, -3.926584654403724, 
        -3.0954697465491705}, {-0.05, -3.802029828000155, 
        -3.2472402416509176}, {-0.05, -3.671612547178429, 
        -3.3940037276647073}, {-0.05, -3.5355339059327386, 
        -3.5355339059327373}, {-0.05, -3.3940037276647086, 
        -3.6716125471784276}, {-0.05, -3.2472402416509203, 
        -3.802029828000153}, {-0.05, -3.0954697465491714, 
        -3.9265846544037237}, {-0.05, -2.9389262614623664, 
        -4.045084971874736}, {-0.05, -2.777851165098011, 
        -4.157348061512726}, {-0.05, -2.6124928235797427, 
        -4.263200821770462}, {-0.05, -2.4431062074847762, 
        -4.362480035363985}, {-0.05, -2.2699524986977346, 
        -4.455032620941839}, {-0.05, -2.09329868768714, 
        -4.540715869125407}, {-0.05, -1.9134171618254516, 
        -4.619397662556432}, {-0.05, -1.7305852853874668, 
        -4.6909566796124205}, {-0.05, -1.5450849718747377, 
        -4.755282581475767}, {-0.05, -1.357202249325371, 
        -4.812276182268237}, {-0.05, -1.1672268192795257, 
        -4.861849601988383}, {-0.05, -0.9754516100806433, 
        -4.903926402016151}, {-0.05, -0.7821723252011552, 
        -4.938441702975688}, {-0.05, -0.587686987289188, 
        -4.965342284774631}, {-0.05, -0.39229547863922787, 
        -4.9845866686656395}, {-0.05, -0.19629907879534506, 
        -4.996145181203614}, {-0.05, -9.18454765366783*^-16, -5.}, 
       {-0.05, 0.19629907879534322, -4.996145181203614}, 
       {-0.05, 0.39229547863922604, -4.9845866686656395}, 
       {-0.05, 0.5876869872891862, -4.965342284774631}, 
       {-0.05, 0.7821723252011534, -4.938441702975689}, 
       {-0.05, 0.9754516100806415, -4.903926402016152}, 
       {-0.05, 1.1672268192795239, -4.861849601988384}, 
       {-0.05, 1.3572022493253693, -4.812276182268237}, 
       {-0.05, 1.5450849718747361, -4.755282581475768}, 
       {-0.05, 1.730585285387465, -4.6909566796124205}, 
       {-0.05, 1.91341716182545, -4.619397662556433}, 
       {-0.05, 2.0932986876871382, -4.540715869125408}, 
       {-0.05, 2.2699524986977333, -4.455032620941839}, 
       {-0.05, 2.443106207484775, -4.362480035363985}, 
       {-0.05, 2.6124928235797418, -4.263200821770463}, 
       {-0.05, 2.777851165098009, -4.157348061512727}, 
       {-0.05, 2.9389262614623646, -4.045084971874738}, 
       {-0.05, 3.0954697465491696, -3.9265846544037246}, 
       {-0.05, 3.2472402416509194, -3.802029828000154}, 
       {-0.05, 3.3940037276647073, -3.671612547178429}, 
       {-0.05, 3.535533905932737, -3.5355339059327386}, 
       {-0.05, 3.6716125471784276, -3.394003727664709}, 
       {-0.05, 3.8020298280001525, -3.247240241650921}, 
       {-0.05, 3.9265846544037233, -3.0954697465491714}, 
       {-0.05, 4.045084971874736, -2.938926261462367}, 
       {-0.05, 4.157348061512726, -2.777851165098011}, 
       {-0.05, 4.263200821770462, -2.6124928235797436}, 
       {-0.05, 4.362480035363984, -2.4431062074847767}, 
       {-0.05, 4.455032620941839, -2.2699524986977346}, 
       {-0.05, 4.540715869125406, -2.0932986876871404}, 
       {-0.05, 4.619397662556432, -1.913417161825452}, 
       {-0.05, 4.69095667961242, -1.730585285387467}, 
       {-0.05, 4.755282581475767, -1.5450849718747381}, 
       {-0.05, 4.812276182268237, -1.3572022493253713}, 
       {-0.05, 4.861849601988383, -1.1672268192795259}, 
       {-0.05, 4.903926402016151, -0.9754516100806436}, 
       {-0.05, 4.938441702975688, -0.7821723252011554}, 
       {-0.05, 4.965342284774631, -0.5876869872891883}, 
       {-0.05, 4.9845866686656395, -0.3922954786392281}, 
       {-0.05, 4.996145181203614, -0.19629907879534536}, 
       {-0.05, 5., -1.2246063538223773*^-15}}, 
      {{1.3689976525819987, 5.65, 0.}, {1.3689976525819982, 
        5.645644054760084, 0.22181795903873766}, {1.3689976525819987, 
        5.632582935592174, 0.44329389086232396}, {1.3689976525819991, 
        5.610836781795334, 0.6640862956367828}, {1.3689976525819987, 
        5.580439124362528, 0.8838547274773044}, {1.3689976525819985, 
        5.541436834278252, 1.1022603193911247}, {1.3689976525819985, 
        5.493890050246873, 1.3189663057858656}, {1.3689976525819985, 
        5.437872085963107, 1.5336385417376697}, {1.3689976525819985, 
        5.3734693170676175, 1.745946018218453}, {1.3689976525819987, 
        5.300781047962036, 1.9555613724878353}, {1.3689976525819985, 
        5.21991935868877, 2.162161392862757}, {1.3689976525819985, 
        5.131008932111709, 2.3654275170864687}, {1.3689976525819985, 
        5.034186861664279, 2.5650463235284393}, {1.368997652581999, 
        4.929602439961305, 2.7607100144577954}, {1.3689976525819982, 
        4.817416928600621, 2.9521168906451107}, {1.368997652581999, 
        4.697803309509381, 3.1389718165607525}, {1.368997652581999, 
        4.570946018218454, 3.3209866754524735}, {1.368997652581999, 
        4.437040659476209, 3.4978808136005624}, {1.368997652581999, 
        4.296293705640175, 3.669381473065538}, {1.368997652581999, 
        4.148922178311624, 3.835224212261121}, {1.368997652581999, 
        3.995153313703994, 3.9951533137039936}, {1.368997652581999, 
        3.8352242122611213, 4.148922178311624}, {1.368997652581999, 
        3.669381473065538, 4.296293705640175}, {1.368997652581999, 
        3.4978808136005624, 4.437040659476209}, {1.368997652581999, 
        3.3209866754524735, 4.570946018218454}, {1.368997652581999, 
        3.138971816560753, 4.697803309509381}, {1.3689976525819985, 
        2.9521168906451116, 4.817416928600621}, {1.3689976525819987, 
        2.760710014457796, 4.929602439961304}, {1.3689976525819987, 
        2.5650463235284398, 5.034186861664279}, {1.3689976525819987, 
        2.365427517086469, 5.131008932111709}, {1.3689976525819987, 
        2.1621613928627577, 5.21991935868877}, {1.3689976525819987, 
        1.9555613724878356, 5.300781047962036}, {1.3689976525819985, 
        1.7459460182184532, 5.3734693170676175}, {1.3689976525819985, 
        1.53363854173767, 5.437872085963107}, {1.3689976525819985, 
        1.318966305785866, 5.493890050246873}, {1.3689976525819985, 
        1.1022603193911251, 5.541436834278252}, {1.3689976525819987, 
        0.8838547274773048, 5.580439124362528}, {1.3689976525819991, 
        0.664086295636783, 5.610836781795334}, {1.3689976525819987, 
        0.4432938908623243, 5.632582935592174}, {1.3689976525819982, 
        0.22181795903873797, 5.645644054760084}, {1.3689976525819987, 
        3.459512949548216*^-16, 5.65}, {1.3689976525819982, 
        -0.2218179590387373, 5.645644054760084}, {1.3689976525819987, 
        -0.44329389086232357, 5.632582935592174}, {1.368997652581999, 
        -0.6640862956367823, 5.610836781795334}, {1.3689976525819987, 
        -0.8838547274773042, 5.580439124362528}, {1.3689976525819985, 
        -1.1022603193911245, 5.541436834278252}, {1.368997652581999, 
        -1.3189663057858652, 5.493890050246874}, {1.3689976525819985, 
        -1.5336385417376694, 5.437872085963107}, {1.368997652581999, 
        -1.7459460182184525, 5.373469317067618}, {1.3689976525819987, 
        -1.9555613724878351, 5.300781047962036}, {1.3689976525819985, 
        -2.162161392862757, 5.21991935868877}, {1.368997652581999, 
        -2.3654275170864674, 5.131008932111711}, {1.3689976525819985, 
        -2.565046323528439, 5.034186861664279}, {1.368997652581999, 
        -2.7607100144577963, 4.929602439961304}, {1.368997652581999, 
        -2.9521168906451107, 4.817416928600622}, {1.368997652581999, 
        -3.138971816560751, 4.697803309509382}, {1.3689976525819985, 
        -3.3209866754524726, 4.570946018218454}, {1.368997652581999, 
        -3.497880813600563, 4.437040659476208}, {1.368997652581999, 
        -3.6693814730655374, 4.296293705640176}, {1.3689976525819987, 
        -3.83522421226112, 4.148922178311625}, {1.368997652581999, 
        -3.9951533137039936, 3.995153313703994}, {1.368997652581999, 
        -4.148922178311624, 3.835224212261121}, {1.368997652581999, 
        -4.296293705640175, 3.6693814730655387}, {1.368997652581999, 
        -4.437040659476208, 3.4978808136005632}, {1.368997652581999, 
        -4.570946018218453, 3.320986675452474}, {1.368997652581999, 
        -4.697803309509381, 3.1389718165607525}, {1.3689976525819985, 
        -4.817416928600621, 2.9521168906451116}, {1.368997652581999, 
        -4.929602439961303, 2.760710014457797}, {1.3689976525819987, 
        -5.034186861664279, 2.5650463235284398}, {1.3689976525819987, 
        -5.13100893211171, 2.3654275170864683}, {1.3689976525819987, 
        -5.21991935868877, 2.162161392862758}, {1.3689976525819987, 
        -5.300781047962035, 1.9555613724878373}, {1.3689976525819985, 
        -5.3734693170676175, 1.7459460182184536}, {1.3689976525819982, 
        -5.437872085963107, 1.533638541737669}, {1.3689976525819985, 
        -5.493890050246873, 1.3189663057858663}, {1.3689976525819987, 
        -5.541436834278252, 1.1022603193911267}, {1.3689976525819987, 
        -5.580439124362528, 0.8838547274773051}, {1.368997652581999, 
        -5.610836781795334, 0.6640862956367822}, {1.3689976525819987, 
        -5.632582935592174, 0.4432938908623247}, {1.3689976525819982, 
        -5.645644054760084, 0.22181795903873958}, {1.3689976525819987, 
        -5.65, 6.919025899096432*^-16}, {1.3689976525819982, 
        -5.645644054760084, -0.22181795903873822}, 
       {1.3689976525819987, -5.632582935592174, -0.44329389086232324}, 
       {1.368997652581999, -5.610836781795334, -0.6640862956367808}, 
       {1.3689976525819987, -5.580439124362528, -0.8838547274773036}, 
       {1.3689976525819985, -5.541436834278252, -1.1022603193911253}, 
       {1.368997652581999, -5.493890050246874, -1.318966305785865}, 
       {1.368997652581999, -5.437872085963108, -1.533638541737668}, 
       {1.368997652581999, -5.373469317067618, -1.7459460182184523}, 
       {1.368997652581999, -5.300781047962036, -1.955561372487836}, 
       {1.3689976525819987, -5.219919358688771, -2.1621613928627568}, 
       {1.368997652581999, -5.131008932111711, -2.365427517086467}, 
       {1.3689976525819985, -5.034186861664279, -2.565046323528439}, 
       {1.3689976525819987, -4.929602439961304, -2.760710014457796}, 
       {1.3689976525819987, -4.817416928600622, -2.9521168906451103}, 
       {1.368997652581999, -4.697803309509382, -3.138971816560751}, 
       {1.3689976525819985, -4.570946018218454, -3.3209866754524726}, 
       {1.368997652581999, -4.437040659476208, -3.497880813600563}, 
       {1.368997652581999, -4.296293705640176, -3.6693814730655374}, 
       {1.3689976525819985, -4.148922178311625, -3.8352242122611195}, 
       {1.368997652581999, -3.9951533137039945, -3.9951533137039936}, 
       {1.368997652581999, -3.835224212261121, -4.148922178311624}, 
       {1.368997652581999, -3.6693814730655405, -4.296293705640173}, 
       {1.3689976525819991, -3.497880813600564, -4.437040659476208}, 
       {1.368997652581999, -3.320986675452474, -4.570946018218453}, 
       {1.368997652581999, -3.1389718165607525, -4.697803309509381}, 
       {1.3689976525819987, -2.95211689064511, -4.817416928600623}, 
       {1.368997652581999, -2.7607100144577976, -4.929602439961303}, 
       {1.3689976525819987, -2.56504632352844, -5.034186861664279}, 
       {1.3689976525819987, -2.3654275170864683, -5.13100893211171}, 
       {1.3689976525819987, -2.1621613928627603, -5.219919358688769}, 
       {1.3689976525819987, -1.9555613724878376, -5.300781047962035}, 
       {1.3689976525819987, -1.7459460182184539, -5.3734693170676175}, 
       {1.3689976525819985, -1.5336385417376694, -5.437872085963107}, 
       {1.3689976525819987, -1.318966305785864, -5.493890050246874}, 
       {1.3689976525819987, -1.1022603193911271, -5.541436834278252}, 
       {1.3689976525819987, -0.8838547274773054, -5.580439124362528}, 
       {1.368997652581999, -0.6640862956367825, -5.610836781795334}, 
       {1.368997652581999, -0.4432938908623275, -5.632582935592174}, 
       {1.3689976525819982, -0.22181795903873994, -5.645644054760084}, 
       {1.3689976525819987, -1.0378538848644648*^-15, -5.65}, 
       {1.3689976525819982, 0.22181795903873786, -5.645644054760084}, 
       {1.3689976525819987, 0.44329389086232546, -5.632582935592174}, 
       {1.368997652581999, 0.6640862956367805, -5.610836781795334}, 
       {1.3689976525819987, 0.8838547274773033, -5.580439124362528}, 
       {1.3689976525819985, 1.102260319391125, -5.541436834278252}, 
       {1.3689976525819985, 1.318966305785862, -5.493890050246874}, 
       {1.3689976525819987, 1.5336385417376674, -5.437872085963108}, 
       {1.3689976525819987, 1.7459460182184519, -5.373469317067618}, 
       {1.3689976525819987, 1.9555613724878356, -5.300781047962036}, 
       {1.368997652581999, 2.1621613928627585, -5.21991935868877}, 
       {1.3689976525819987, 2.3654275170864665, -5.131008932111711}, 
       {1.3689976525819985, 2.565046323528439, -5.034186861664279}, 
       {1.3689976525819987, 2.760710014457796, -4.929602439961304}, 
       {1.3689976525819985, 2.9521168906451085, -4.817416928600623}, 
       {1.3689976525819987, 3.1389718165607507, -4.697803309509382}, 
       {1.3689976525819985, 3.320986675452472, -4.570946018218454}, 
       {1.368997652581999, 3.4978808136005624, -4.437040659476209}, 
       {1.3689976525819987, 3.669381473065539, -4.296293705640174}, 
       {1.3689976525819985, 3.8352242122611195, -4.148922178311625}, 
       {1.3689976525819985, 3.9951533137039927, -3.9951533137039945}, 
       {1.368997652581999, 4.148922178311624, -3.8352242122611213}, 
       {1.3689976525819987, 4.296293705640172, -3.669381473065541}, 
       {1.3689976525819985, 4.4370406594762075, -3.497880813600564}, 
       {1.3689976525819991, 4.570946018218453, -3.320986675452475}, 
       {1.368997652581999, 4.697803309509381, -3.1389718165607525}, 
       {1.3689976525819987, 4.817416928600622, -2.9521168906451103}, 
       {1.3689976525819985, 4.929602439961302, -2.760710014457798}, 
       {1.368997652581999, 5.034186861664279, -2.5650463235284406}, 
       {1.3689976525819985, 5.131008932111709, -2.3654275170864687}, 
       {1.368997652581999, 5.219919358688769, -2.1621613928627608}, 
       {1.3689976525819987, 5.300781047962035, -1.9555613724878378}, 
       {1.3689976525819987, 5.3734693170676175, -1.745946018218454}, 
       {1.3689976525819985, 5.437872085963107, -1.5336385417376697}, 
       {1.368997652581999, 5.493890050246874, -1.3189663057858645}, 
       {1.3689976525819987, 5.541436834278252, -1.1022603193911273}, 
       {1.3689976525819987, 5.580439124362528, -0.8838547274773058}, 
       {1.3689976525819991, 5.610836781795334, -0.6640862956367828}, 
       {1.368997652581999, 5.632582935592174, -0.4432938908623278}, 
       {1.3689976525819985, 5.645644054760084, -0.2218179590387403}, 
       {1.3689976525819987, 5.65, -1.3838051798192863*^-15}}, 
      {{1.3397916666666667, 5.65, 0.}, {1.339791666666667, 
        5.645644054760084, 0.22181795903873766}, {1.339791666666666, 
        5.632582935592174, 0.44329389086232396}, {1.339791666666666, 
        5.610836781795334, 0.6640862956367828}, {1.3397916666666667, 
        5.580439124362528, 0.8838547274773044}, {1.339791666666667, 
        5.541436834278252, 1.1022603193911247}, {1.3397916666666667, 
        5.493890050246873, 1.3189663057858656}, {1.3397916666666667, 
        5.437872085963107, 1.5336385417376697}, {1.3397916666666672, 
        5.3734693170676175, 1.745946018218453}, {1.3397916666666663, 
        5.300781047962036, 1.9555613724878353}, {1.3397916666666667, 
        5.21991935868877, 2.162161392862757}, {1.3397916666666672, 
        5.131008932111709, 2.3654275170864687}, {1.3397916666666667, 
        5.034186861664279, 2.5650463235284393}, {1.3397916666666658, 
        4.929602439961305, 2.7607100144577954}, {1.3397916666666674, 
        4.817416928600621, 2.9521168906451107}, {1.3397916666666667, 
        4.697803309509381, 3.1389718165607525}, {1.339791666666666, 
        4.570946018218454, 3.3209866754524735}, {1.3397916666666665, 
        4.437040659476209, 3.4978808136005624}, {1.3397916666666665, 
        4.296293705640175, 3.669381473065538}, {1.3397916666666667, 
        4.148922178311624, 3.835224212261121}, {1.3397916666666663, 
        3.995153313703994, 3.9951533137039936}, {1.339791666666666, 
        3.8352242122611213, 4.148922178311624}, {1.3397916666666663, 
        3.669381473065538, 4.296293705640175}, {1.3397916666666665, 
        3.4978808136005624, 4.437040659476209}, {1.3397916666666658, 
        3.3209866754524735, 4.570946018218454}, {1.3397916666666665, 
        3.138971816560753, 4.697803309509381}, {1.3397916666666665, 
        2.9521168906451116, 4.817416928600621}, {1.3397916666666667, 
        2.760710014457796, 4.929602439961304}, {1.3397916666666663, 
        2.5650463235284398, 5.034186861664279}, {1.3397916666666667, 
        2.365427517086469, 5.131008932111709}, {1.3397916666666667, 
        2.1621613928627577, 5.21991935868877}, {1.3397916666666663, 
        1.9555613724878356, 5.300781047962036}, {1.3397916666666667, 
        1.7459460182184532, 5.3734693170676175}, {1.3397916666666667, 
        1.53363854173767, 5.437872085963107}, {1.3397916666666667, 
        1.318966305785866, 5.493890050246873}, {1.3397916666666667, 
        1.1022603193911251, 5.541436834278252}, {1.3397916666666667, 
        0.8838547274773048, 5.580439124362528}, {1.3397916666666658, 
        0.664086295636783, 5.610836781795334}, {1.3397916666666658, 
        0.4432938908623243, 5.632582935592174}, {1.3397916666666672, 
        0.22181795903873797, 5.645644054760084}, {1.3397916666666667, 
        3.459512949548216*^-16, 5.65}, {1.3397916666666672, 
        -0.2218179590387373, 5.645644054760084}, {1.3397916666666658, 
        -0.44329389086232357, 5.632582935592174}, {1.3397916666666658, 
        -0.6640862956367823, 5.610836781795334}, {1.3397916666666667, 
        -0.8838547274773042, 5.580439124362528}, {1.3397916666666672, 
        -1.1022603193911245, 5.541436834278252}, {1.3397916666666658, 
        -1.3189663057858652, 5.493890050246874}, {1.3397916666666667, 
        -1.5336385417376694, 5.437872085963107}, {1.3397916666666663, 
        -1.7459460182184525, 5.373469317067618}, {1.3397916666666663, 
        -1.9555613724878351, 5.300781047962036}, {1.3397916666666667, 
        -2.162161392862757, 5.21991935868877}, {1.3397916666666658, 
        -2.3654275170864674, 5.131008932111711}, {1.3397916666666667, 
        -2.565046323528439, 5.034186861664279}, {1.3397916666666663, 
        -2.7607100144577963, 4.929602439961304}, {1.3397916666666665, 
        -2.9521168906451107, 4.817416928600622}, {1.3397916666666665, 
        -3.138971816560751, 4.697803309509382}, {1.3397916666666667, 
        -3.3209866754524726, 4.570946018218454}, {1.3397916666666667, 
        -3.497880813600563, 4.437040659476208}, {1.339791666666666, 
        -3.6693814730655374, 4.296293705640176}, {1.3397916666666663, 
        -3.83522421226112, 4.148922178311625}, {1.3397916666666663, 
        -3.9951533137039936, 3.995153313703994}, {1.3397916666666667, 
        -4.148922178311624, 3.835224212261121}, {1.3397916666666658, 
        -4.296293705640175, 3.6693814730655387}, {1.3397916666666663, 
        -4.437040659476208, 3.4978808136005632}, {1.3397916666666667, 
        -4.570946018218453, 3.320986675452474}, {1.3397916666666667, 
        -4.697803309509381, 3.1389718165607525}, {1.339791666666667, 
        -4.817416928600621, 2.9521168906451116}, {1.3397916666666665, 
        -4.929602439961303, 2.760710014457797}, {1.3397916666666665, 
        -5.034186861664279, 2.5650463235284398}, {1.3397916666666663, 
        -5.13100893211171, 2.3654275170864683}, {1.3397916666666665, 
        -5.21991935868877, 2.162161392862758}, {1.3397916666666667, 
        -5.300781047962035, 1.9555613724878373}, {1.3397916666666667, 
        -5.3734693170676175, 1.7459460182184536}, {1.3397916666666667, 
        -5.437872085963107, 1.533638541737669}, {1.3397916666666665, 
        -5.493890050246873, 1.3189663057858663}, {1.3397916666666665, 
        -5.541436834278252, 1.1022603193911267}, {1.3397916666666665, 
        -5.580439124362528, 0.8838547274773051}, {1.339791666666666, 
        -5.610836781795334, 0.6640862956367822}, {1.339791666666666, 
        -5.632582935592174, 0.4432938908623247}, {1.339791666666667, 
        -5.645644054760084, 0.22181795903873958}, {1.3397916666666667, 
        -5.65, 6.919025899096432*^-16}, {1.339791666666667, 
        -5.645644054760084, -0.22181795903873822}, 
       {1.339791666666666, -5.632582935592174, -0.44329389086232324}, 
       {1.3397916666666663, -5.610836781795334, -0.6640862956367808}, 
       {1.3397916666666667, -5.580439124362528, -0.8838547274773036}, 
       {1.3397916666666667, -5.541436834278252, -1.1022603193911253}, 
       {1.3397916666666658, -5.493890050246874, -1.318966305785865}, 
       {1.3397916666666663, -5.437872085963108, -1.533638541737668}, 
       {1.3397916666666663, -5.373469317067618, -1.7459460182184523}, 
       {1.3397916666666663, -5.300781047962036, -1.955561372487836}, 
       {1.339791666666666, -5.219919358688771, -2.1621613928627568}, 
       {1.339791666666666, -5.131008932111711, -2.365427517086467}, 
       {1.3397916666666667, -5.034186861664279, -2.565046323528439}, 
       {1.3397916666666667, -4.929602439961304, -2.760710014457796}, 
       {1.3397916666666667, -4.817416928600622, -2.9521168906451103}, 
       {1.3397916666666665, -4.697803309509382, -3.138971816560751}, 
       {1.3397916666666665, -4.570946018218454, -3.3209866754524726}, 
       {1.3397916666666667, -4.437040659476208, -3.497880813600563}, 
       {1.3397916666666663, -4.296293705640176, -3.6693814730655374}, 
       {1.3397916666666667, -4.148922178311625, -3.8352242122611195}, 
       {1.3397916666666658, -3.9951533137039945, -3.9951533137039936}, 
       {1.3397916666666665, -3.835224212261121, -4.148922178311624}, 
       {1.3397916666666663, -3.6693814730655405, -4.296293705640173}, 
       {1.3397916666666658, -3.497880813600564, -4.437040659476208}, 
       {1.3397916666666665, -3.320986675452474, -4.570946018218453}, 
       {1.3397916666666665, -3.1389718165607525, -4.697803309509381}, 
       {1.3397916666666658, -2.95211689064511, -4.817416928600623}, 
       {1.3397916666666663, -2.7607100144577976, -4.929602439961303}, 
       {1.3397916666666663, -2.56504632352844, -5.034186861664279}, 
       {1.3397916666666663, -2.3654275170864683, -5.13100893211171}, 
       {1.3397916666666667, -2.1621613928627603, -5.219919358688769}, 
       {1.3397916666666667, -1.9555613724878376, -5.300781047962035}, 
       {1.3397916666666667, -1.7459460182184539, -5.3734693170676175}, 
       {1.3397916666666667, -1.5336385417376694, -5.437872085963107}, 
       {1.3397916666666663, -1.318966305785864, -5.493890050246874}, 
       {1.3397916666666663, -1.1022603193911271, -5.541436834278252}, 
       {1.3397916666666663, -0.8838547274773054, -5.580439124362528}, 
       {1.3397916666666658, -0.6640862956367825, -5.610836781795334}, 
       {1.3397916666666658, -0.4432938908623275, -5.632582935592174}, 
       {1.3397916666666667, -0.22181795903873994, -5.645644054760084}, 
       {1.3397916666666667, -1.0378538848644648*^-15, -5.65}, 
       {1.3397916666666672, 0.22181795903873786, -5.645644054760084}, 
       {1.3397916666666658, 0.44329389086232546, -5.632582935592174}, 
       {1.3397916666666663, 0.6640862956367805, -5.610836781795334}, 
       {1.3397916666666667, 0.8838547274773033, -5.580439124362528}, 
       {1.3397916666666667, 1.102260319391125, -5.541436834278252}, 
       {1.3397916666666667, 1.318966305785862, -5.493890050246874}, 
       {1.3397916666666663, 1.5336385417376674, -5.437872085963108}, 
       {1.3397916666666667, 1.7459460182184519, -5.373469317067618}, 
       {1.3397916666666663, 1.9555613724878356, -5.300781047962036}, 
       {1.3397916666666663, 2.1621613928627585, -5.21991935868877}, 
       {1.3397916666666663, 2.3654275170864665, -5.131008932111711}, 
       {1.3397916666666667, 2.565046323528439, -5.034186861664279}, 
       {1.3397916666666667, 2.760710014457796, -4.929602439961304}, 
       {1.3397916666666667, 2.9521168906451085, -4.817416928600623}, 
       {1.3397916666666665, 3.1389718165607507, -4.697803309509382}, 
       {1.3397916666666667, 3.320986675452472, -4.570946018218454}, 
       {1.3397916666666665, 3.4978808136005624, -4.437040659476209}, 
       {1.3397916666666663, 3.669381473065539, -4.296293705640174}, 
       {1.3397916666666667, 3.8352242122611195, -4.148922178311625}, 
       {1.3397916666666665, 3.9951533137039927, -3.9951533137039945}, 
       {1.3397916666666663, 4.148922178311624, -3.8352242122611213}, 
       {1.3397916666666667, 4.296293705640172, -3.669381473065541}, 
       {1.3397916666666667, 4.4370406594762075, -3.497880813600564}, 
       {1.3397916666666663, 4.570946018218453, -3.320986675452475}, 
       {1.3397916666666667, 4.697803309509381, -3.1389718165607525}, 
       {1.3397916666666667, 4.817416928600622, -2.9521168906451103}, 
       {1.339791666666667, 4.929602439961302, -2.760710014457798}, 
       {1.339791666666666, 5.034186861664279, -2.5650463235284406}, 
       {1.3397916666666672, 5.131008932111709, -2.3654275170864687}, 
       {1.3397916666666663, 5.219919358688769, -2.1621613928627608}, 
       {1.3397916666666665, 5.300781047962035, -1.9555613724878378}, 
       {1.3397916666666667, 5.3734693170676175, -1.745946018218454}, 
       {1.3397916666666667, 5.437872085963107, -1.5336385417376697}, 
       {1.339791666666666, 5.493890050246874, -1.3189663057858645}, 
       {1.3397916666666665, 5.541436834278252, -1.1022603193911273}, 
       {1.3397916666666665, 5.580439124362528, -0.8838547274773058}, 
       {1.339791666666666, 5.610836781795334, -0.6640862956367828}, 
       {1.3397916666666658, 5.632582935592174, -0.4432938908623278}, 
       {1.339791666666667, 5.645644054760084, -0.2218179590387403}, 
       {1.3397916666666667, 5.65, -1.3838051798192863*^-15}}, 
      {{9.414603431411972, 11.95, 0.}, {9.414603431411981, 
        11.940786983076638, 0.46915479832086987}, {9.41460343141197, 
        11.913162138110879, 0.937586193947747}, {9.414603431411978, 
        11.867168060611368, 1.4045718996211598}, {9.414603431411978, 
        11.802875670111895, 1.8693918572307588}, {9.414603431411978, 
        11.720384100818602, 2.3313293480927326}, {9.414603431411978, 
        11.619820548752234, 2.789672098078069}, {9.414603431411981, 
        11.501340075621084, 3.243713375887637}, {9.414603431411983, 
        11.365125369727084, 3.692753082780621}, {9.414603431411967, 
        11.211386464273685, 4.136098832076041}, {9.414603431411965, 
        11.040360413509877, 4.573067016762822}, {9.414603431411981, 
        10.85231092720972, 5.002983863572266}, {9.41460343141197, 
        10.647527964050996, 5.425186471887583}, {9.41460343141196, 
        10.426327284519926, 5.839023835888611}, {9.414603431411976, 
        10.189049964031401, 6.243857848355588}, {9.41460343141198, 
        9.936061867015415, 6.639064284584245}, {9.414603431411972, 
        9.66775308278062, 7.024033764895053}, {9.414603431411976, 
        9.384537324024901, 7.398172694252516}, {9.414603431411967, 
        9.08685128892037, 7.760904177545695}, {9.414603431411987, 
        8.775153987756442, 8.111668909118652}, {9.414603431411972, 
        8.449926035179242, 8.449926035179242}, {9.414603431411972, 
        8.111668909118654, 8.775153987756442}, {9.414603431411967, 
        7.760904177545695, 9.08685128892037}, {9.41460343141198, 
        7.398172694252516, 9.384537324024901}, {9.414603431411972, 
        7.024033764895053, 9.66775308278062}, {9.414603431411972, 
        6.639064284584247, 9.936061867015415}, {9.414603431411967, 
        6.2438578483555895, 10.189049964031401}, {9.414603431411967, 
        5.839023835888612, 10.426327284519925}, {9.414603431411987, 
        5.425186471887584, 10.647527964050994}, {9.41460343141198, 
        5.002983863572266, 10.85231092720972}, {9.41460343141196, 
        4.573067016762823, 11.040360413509877}, {9.41460343141196, 
        4.1360988320760415, 11.211386464273685}, {9.414603431411987, 
        3.6927530827806216, 11.365125369727084}, {9.414603431411972, 
        3.243713375887638, 11.501340075621084}, {9.414603431411972, 
        2.78967209807807, 11.619820548752234}, {9.414603431411972, 
        2.3313293480927335, 11.720384100818602}, {9.414603431411972, 
        1.8693918572307595, 11.802875670111895}, {9.414603431411972, 
        1.4045718996211605, 11.867168060611368}, {9.414603431411972, 
        0.9375861939477477, 11.913162138110879}, {9.414603431411987, 
        0.46915479832087054, 11.940786983076638}, {9.414603431411972, 
        7.317022964088704*^-16, 11.95}, {9.414603431411987, 
        -0.4691547983208691, 11.940786983076638}, {9.414603431411972, 
        -0.9375861939477462, 11.913162138110879}, {9.414603431411972, 
        -1.404571899621159, 11.867168060611368}, {9.414603431411972, 
        -1.8693918572307582, 11.802875670111895}, {9.414603431411987, 
        -2.3313293480927317, 11.720384100818602}, {9.41460343141196, 
        -2.7896720980780687, 11.619820548752235}, {9.414603431411987, 
        -3.2437133758876366, 11.501340075621084}, {9.414603431411972, 
        -3.6927530827806203, 11.365125369727085}, {9.414603431411972, 
        -4.13609883207604, 11.211386464273685}, {9.414603431411967, 
        -4.573067016762822, 11.040360413509877}, {9.414603431411967, 
        -5.002983863572262, 10.852310927209723}, {9.414603431411972, 
        -5.425186471887582, 10.647527964050996}, {9.414603431411967, 
        -5.839023835888613, 10.426327284519925}, {9.414603431411967, 
        -6.243857848355588, 10.189049964031403}, {9.414603431411967, 
        -6.639064284584243, 9.936061867015418}, {9.41460343141198, 
        -7.024033764895052, 9.66775308278062}, {9.414603431411967, 
        -7.398172694252517, 9.384537324024901}, {9.41460343141198, 
        -7.760904177545693, 9.08685128892037}, {9.414603431411967, 
        -8.11166890911865, 8.775153987756445}, {9.414603431411972, 
        -8.449926035179242, 8.449926035179242}, {9.414603431411967, 
        -8.775153987756443, 8.111668909118652}, {9.41460343141196, 
        -9.08685128892037, 7.7609041775456955}, {9.414603431411972, 
        -9.3845373240249, 7.398172694252518}, {9.414603431411964, 
        -9.66775308278062, 7.024033764895055}, {9.414603431411967, 
        -9.936061867015416, 6.639064284584245}, {9.414603431411967, 
        -10.189049964031401, 6.2438578483555895}, {9.414603431411976, 
        -10.426327284519923, 5.839023835888614}, {9.414603431411981, 
        -10.647527964050994, 5.425186471887585}, {9.414603431411969, 
        -10.852310927209722, 5.002983863572264}, {9.414603431411956, 
        -11.040360413509877, 4.573067016762824}, {9.414603431411969, 
        -11.211386464273684, 4.136098832076045}, {9.41460343141198, 
        -11.365125369727084, 3.6927530827806225}, {9.414603431411985, 
        -11.501340075621084, 3.2437133758876358}, {9.414603431411972, 
        -11.619820548752234, 2.789672098078071}, {9.414603431411969, 
        -11.720384100818602, 2.3313293480927366}, {9.414603431411974, 
        -11.802875670111895, 1.8693918572307602}, {9.41460343141198, 
        -11.867168060611368, 1.4045718996211587}, {9.414603431411969, 
        -11.913162138110879, 0.9375861939477486}, {9.41460343141198, 
        -11.940786983076638, 0.4691547983208739}, {9.414603431411972, 
        -11.95, 1.4634045928177408*^-15}, {9.414603431411981, 
        -11.940786983076638, -0.46915479832087104}, 
       {9.414603431411972, -11.913162138110879, -0.9375861939477456}, 
       {9.414603431411983, -11.867168060611368, -1.4045718996211556}, 
       {9.41460343141198, -11.802875670111895, -1.869391857230757}, 
       {9.414603431411974, -11.720384100818602, -2.331329348092734}, 
       {9.414603431411967, -11.619820548752235, -2.789672098078068}, 
       {9.41460343141198, -11.501340075621085, -3.243713375887633}, 
       {9.414603431411976, -11.365125369727085, -3.69275308278062}, 
       {9.41460343141196, -11.211386464273685, -4.136098832076042}, 
       {9.414603431411969, -11.040360413509877, -4.573067016762821}, 
       {9.414603431411969, -10.852310927209723, -5.002983863572261}, 
       {9.414603431411974, -10.647527964050996, -5.425186471887582}, 
       {9.414603431411969, -10.426327284519925, -5.839023835888612}, 
       {9.414603431411967, -10.189049964031403, -6.243857848355587}, 
       {9.414603431411964, -9.936061867015418, -6.639064284584243}, 
       {9.414603431411967, -9.667753082780623, -7.024033764895052}, 
       {9.414603431411969, -9.384537324024901, -7.398172694252517}, 
       {9.41460343141198, -9.08685128892037, -7.760904177545693}, 
       {9.414603431411967, -8.775153987756445, -8.11166890911865}, 
       {9.41460343141196, -8.449926035179244, -8.449926035179242}, 
       {9.414603431411987, -8.111668909118652, -8.775153987756442}, 
       {9.414603431411972, -7.7609041775457, -9.086851288920364}, 
       {9.414603431411967, -7.398172694252519, -9.3845373240249}, 
       {9.41460343141196, -7.024033764895055, -9.66775308278062}, 
       {9.41460343141198, -6.639064284584245, -9.936061867015415}, 
       {9.41460343141198, -6.243857848355585, -10.189049964031403}, 
       {9.414603431411972, -5.839023835888615, -10.426327284519923}, 
       {9.41460343141198, -5.425186471887585, -10.647527964050994}, 
       {9.414603431411967, -5.002983863572265, -10.852310927209722}, 
       {9.414603431411972, -4.573067016762829, -11.040360413509873}, 
       {9.414603431411967, -4.136098832076045, -11.211386464273684}, 
       {9.414603431411972, -3.692753082780623, -11.365125369727084}, 
       {9.414603431411987, -3.2437133758876366, -11.501340075621084}, 
       {9.414603431411972, -2.7896720980780665, -11.619820548752235}, 
       {9.414603431411972, -2.3313293480927375, -11.720384100818602}, 
       {9.414603431411972, -1.8693918572307608, -11.802875670111895}, 
       {9.414603431411972, -1.4045718996211594, -11.867168060611368}, 
       {9.41460343141196, -0.9375861939477544, -11.913162138110879}, 
       {9.414603431411972, -0.46915479832087464, -11.940786983076638}, 
       {9.414603431411972, -2.195106889226611*^-15, -11.95}, 
       {9.414603431411987, 0.46915479832087026, -11.940786983076638}, 
       {9.414603431411972, 0.9375861939477502, -11.913162138110879}, 
       {9.414603431411987, 1.404571899621155, -11.867168060611368}, 
       {9.414603431411987, 1.8693918572307564, -11.802875670111895}, 
       {9.414603431411972, 2.331329348092733, -11.720384100818602}, 
       {9.414603431411972, 2.789672098078062, -11.619820548752237}, 
       {9.414603431411987, 3.2437133758876326, -11.501340075621085}, 
       {9.414603431411972, 3.692753082780619, -11.365125369727085}, 
       {9.41460343141196, 4.1360988320760415, -11.211386464273685}, 
       {9.414603431411972, 4.573067016762825, -11.040360413509875}, 
       {9.414603431411972, 5.00298386357226, -10.852310927209723}, 
       {9.414603431411972, 5.425186471887582, -10.647527964050996}, 
       {9.414603431411967, 5.839023835888612, -10.426327284519925}, 
       {9.414603431411972, 6.243857848355582, -10.189049964031405}, 
       {9.414603431411967, 6.639064284584242, -9.936061867015418}, 
       {9.41460343141198, 7.024033764895051, -9.667753082780623}, 
       {9.41460343141198, 7.398172694252516, -9.384537324024901}, 
       {9.41460343141196, 7.760904177545697, -9.086851288920368}, 
       {9.414603431411967, 8.11166890911865, -8.775153987756445}, 
       {9.414603431411972, 8.44992603517924, -8.449926035179244}, 
       {9.414603431411972, 8.775153987756442, -8.111668909118654}, 
       {9.414603431411964, 9.086851288920364, -7.760904177545701}, 
       {9.41460343141198, 9.384537324024897, -7.398172694252519}, 
       {9.414603431411956, 9.66775308278062, -7.024033764895056}, 
       {9.41460343141198, 9.936061867015415, -6.639064284584245}, 
       {9.414603431411967, 10.189049964031403, -6.243857848355587}, 
       {9.414603431411987, 10.426327284519921, -5.839023835888616}, 
       {9.414603431411976, 10.647527964050994, -5.425186471887586}, 
       {9.414603431411981, 10.85231092720972, -5.002983863572266}, 
       {9.414603431411969, 11.040360413509873, -4.57306701676283}, 
       {9.414603431411987, 11.211386464273682, -4.136098832076046}, 
       {9.414603431411974, 11.365125369727084, -3.692753082780624}, 
       {9.414603431411981, 11.501340075621084, -3.243713375887637}, 
       {9.41460343141197, 11.619820548752235, -2.789672098078067}, 
       {9.414603431411967, 11.720384100818602, -2.331329348092738}, 
       {9.414603431411972, 11.802875670111895, -1.8693918572307615}, 
       {9.414603431411978, 11.867168060611368, -1.40457189962116}, 
       {9.414603431411964, 11.913162138110879, -0.9375861939477551}, 
       {9.41460343141198, 11.940786983076638, -0.4691547983208754}, 
       {9.414603431411972, 11.95, -2.9268091856354816*^-15}}}]}}, 
  ControlType -> None}, Initialization :> 
  ( raytracefunction118640200831284558148930 = 
    Compile[{{th, _Real}, {x, _Real}, {y, _Real}}, 
     Module[{activeregion, allcreatedamplitudes, allcreatedrays, 
       allowzeroraylength, alternateindex, amplitude, axismagnitude, 
       axismatrix, clonedata, clonegenerationnumber, cloneinput, 
       clonenumber, cloneposition, clonereportedrays, clonerotation, 
       clonescale, clonescalevector, clonesorthistogram, 
       clonetraceinput, clonetraceoutput, closestdistances, 
       closestposition, closestpositions, closestraylength, 
       completedray, componentnumber, cosangle, crossmatrix, 
       deflecteddummyrayspresent, deflectedlocalrays, deflectedrays, 
       deflectedrayspresent, dummymatrix, dummymatrixlist, dummyvector, 
       frontid, generationlimit, generationnumber, holeintersections, 
       holeQ, holeQlist, hor, index, index1, index2, inrays, intensity, 
       intensityscale, intersectionnumber, intersections, 
       intersectionslist, intersectionspresent, 
       localdummyoutrayspresent, localoutrays, localoutrayspresent, 
       magnitude, maxclonegenerationnumber, maximumposition, 
       minimumraylength, minresonateraylength, n12, newcomponentnumber, 
       newdeflectedrays, newdistance, newsurfaceid, newsurfacenumber, 
       nonintersectingrays, normalizedpolarization, oldgenerationnumber, 
       opticallength, originalray, originalraytilt, originalrotation, 
       originalsurfnorm, outrays, parallelamplitude, PAxis, 
       perpendicularamplitude, phaseshift, pol1, pol2, pol3, 
       previoustilt, propagate, propagatedrays, r1, r2, r3, r4, r5, r6, 
       r7, r8, r9, ray1, ray2, ray3, LocRayL, rayslot, raysreported, 
       raytiltx, raytiltz, reporteddummyrayspresent, reportedlocalrays, 
       reportedrays, reportedrayspresent, resonateintersections, 
       resonatenumber, resonateraylength, rex, rey, rez, rotationaxis, 
       rsx, LocRSx, rsy, LocRSy, rsz, LocRSz, RTx, LocRTy, LocRTz, rx, 
       rxhlp, ry, ryhlp, rz, rzhlp, LocSCx, LocSCy, sid, sinangle, sno1, 
       sno2, sno3, sno4, surfaceid, surfacenumber, 
       surfacerotationmatrix, surfacetranslationvector, surfnorm, symr1, 
       symr2, symr3, symr4, symr5, symr6, symr7, symr8, symr9, 
       tempclonedata, terminatedeflection, thresholdintensity, 
       tiltmagnitude, transmatrix, LocTV1, LocTV10, LocTV2, LocTV3, 
       LocTV4, LocTV5, LocTV6, LocTV7, LocTV8, LocTV9, u, 
       unfilteredintersections, unit, uu, ver, wavelength, XAxis, xunit, 
       YAxis, yunit, ZAxis, zunit}, activeregion = 1.; 
       allcreatedamplitudes = {{0. + 0.*I, 0. + 0.*I, 0. + 0.*I}}; 
       allcreatedrays = {{1.}}; allowzeroraylength = True; 
       alternateindex = 1.; amplitude = {1. + 0.*I, 0. + 0.*I, 
         0. + 0.*I}; axismagnitude = 1.; axismatrix = 
        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}; clonedata = {{1.}}; 
       clonegenerationnumber = 1.; cloneinput = {1.}; clonenumber = 1; 
       cloneposition = {0., 0., 0.}; clonereportedrays = {{1.}}; 
       clonerotation = {{1.}}; clonescale = 1.; clonescalevector = {1.}; 
       clonesorthistogram = {1}; clonetraceinput = {{1.}}; 
       clonetraceoutput = {{1.}}; closestdistances = {1.}; 
       closestposition = 0; closestpositions = {0}; 
       closestraylength = 1.; completedray = {1.}; 
       componentnumber = -1.; cosangle = 1.; crossmatrix = 
        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}; 
       deflecteddummyrayspresent = False; deflectedlocalrays = {{1.}}; 
       deflectedrays = {{1.}}; deflectedrayspresent = False; 
       dummymatrix = {{1.}}; dummymatrixlist = {{{1.}}}; 
       dummyvector = {1.}; frontid = 1.; generationlimit = 200.; 
       generationnumber = 1.; holeintersections = {{-1., 0., 0.}}; 
       holeQ = False; holeQlist = {0}; hor = 1. + 0.*I; index = 1.; 
       index1 = 1.; index2 = 1.; inrays = {{1.}}; intensity = 1.; 
       intensityscale = 1.; intersectionnumber = 1.; 
       intersections = {{-1., 0., 0.}}; intersectionslist = 
        {{{-1., 0., 0.}}}; intersectionspresent = False; 
       localdummyoutrayspresent = False; localoutrays = {{1.}}; 
       localoutrayspresent = False; magnitude = 1.; 
       maxclonegenerationnumber = 1.; maximumposition = 1; 
       minimumraylength = 0.0001; minresonateraylength = 1.; n12 = 1.; 
       newcomponentnumber = -1.; newdeflectedrays = {{1.}}; 
       newdistance = 1.; newsurfaceid = -1.; newsurfacenumber = -1.; 
       nonintersectingrays = {{1.}}; normalizedpolarization = {1., 1.}; 
       oldgenerationnumber = 1.; opticallength = 1.; originalray = {1.}; 
       originalraytilt = {1.}; originalrotation = {{1., 0., 0.}, 
         {0., 1., 0.}, {0., 0., 1.}}; originalsurfnorm = {{1.}}; 
       outrays = {{1.}}; parallelamplitude = 1. + 0.*I; 
       PAxis = {1., 0., 0.}; perpendicularamplitude = 1. + 0.*I; 
       phaseshift = 0.; pol1 = 1.; pol2 = 1.; pol3 = 1.; 
       previoustilt = {1., 0., 0.}; propagate = True; 
       propagatedrays = {{1.}}; r1 = 1.; r2 = 1.; r3 = 1.; r4 = 1.; 
       r5 = 1.; r6 = 1.; r7 = 1.; r8 = 1.; r9 = 1.; ray1 = 1.; 
       ray2 = 1.; ray3 = 1.; LocRayL = 1.; rayslot = 1.; 
       raysreported = False; raytiltx = 1.; raytiltz = 1.; 
       reporteddummyrayspresent = False; reportedlocalrays = {{1.}}; 
       reportedrays = {{1.}}; reportedrayspresent = False; 
       resonateintersections = {{-1., 0., 0.}}; resonatenumber = 0; 
       resonateraylength = 1.; rex = 1.; rey = 1.; rez = 1.; rsx = 1.; 
       LocRSx = 1.; rsy = 1.; LocRSy = 1.; rsz = 1.; LocRSz = 1.; 
       RTx = 1.; LocRTy = 1.; LocRTz = 1.; rx = 1.; rxhlp = 1.; ry = 1.; 
       ryhlp = 1.; rz = 1.; rzhlp = 1.; LocSCx = 1.; LocSCy = 1.; 
       sid = 1.; sinangle = 1.; sno1 = 1.; sno2 = 1.; sno3 = 1.; 
       sno4 = 1.; surfaceid = -1.; surfacenumber = -1.; 
       surfacerotationmatrix = {{1., 0., 0.}, {0., 1., 0.}, 
         {0., 0., 1.}}; surfacetranslationvector = {0., 0., 0.}; 
       surfnorm = {{1.}}; symr1 = 1.; symr2 = 1.; symr3 = 1.; 
       symr4 = 1.; symr5 = 1.; symr6 = 1.; symr7 = 1.; symr8 = 1.; 
       symr9 = 1.; tempclonedata = {{1.}}; terminatedeflection = False; 
       thresholdintensity = 1.; tiltmagnitude = 1.; 
       transmatrix = {{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}}; 
       LocTV1 = 1.; LocTV10 = 1.; LocTV2 = 1.; LocTV3 = 1.; LocTV4 = 1.; 
       LocTV5 = 1.; LocTV6 = 1.; LocTV7 = 1.; LocTV8 = 1.; LocTV9 = 1.; 
       u = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}; 
       unfilteredintersections = {{-1., 0., 0.}}; 
       unit = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}; 
       uu = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}; ver = 0. + 0.*I; 
       wavelength = 1.; XAxis = {1., 0., 0.}; xunit = 1.; 
       YAxis = {1., 0., 0.}; yunit = 1.; ZAxis = {1., 0., 0.}; 
       zunit = 1.; propagatedrays = 
        Join[{symr1, symr2, symr3, symr4, symr5, symr6, symr7, symr8, 
            symr9} = {Cos[Degree*th], Sin[Degree*th], 0, 
            -Sin[Degree*th], Cos[Degree*th], 0, 0, 0, 1}; 
          (({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
               r8, r9, wavelength, intensity, intensityscale, ray1, 
               index, opticallength, phaseshift, componentnumber, 
               surfacenumber, surfaceid, ray2, ray3, sid, frontid, sno1, 
               sno2, sno3, sno4, rayslot, oldgenerationnumber, 
               intersectionnumber, pol1, pol2, pol3} = #1; 
             {LocTV1, LocTV2, LocTV3} = {rsx*symr1 + rsy*symr4 + 
                rsz*symr7 + x, rsx*symr2 + rsy*symr5 + rsz*symr8 + y, 
               rsx*symr3 + rsy*symr6 + rsz*symr9}; {rsx, rsy, rsz} = 
              {LocTV1, LocTV2, LocTV3}; {LocTV1, LocTV2, LocTV3} = 
              {rex*symr1 + rey*symr4 + rez*symr7 + x, rex*symr2 + 
                rey*symr5 + rez*symr8 + y, rex*symr3 + rey*symr6 + 
                rez*symr9}; {rex, rey, rez} = {LocTV1, LocTV2, LocTV3}; 
             {LocTV1, LocTV2, LocTV3} = {r1*symr1 + r2*symr4 + r3*symr7, 
               r1*symr2 + r2*symr5 + r3*symr8, r1*symr3 + r2*symr6 + 
                r3*symr9}; {LocTV4, LocTV5, LocTV6} = {r4*symr1 + 
                r5*symr4 + r6*symr7, r4*symr2 + r5*symr5 + r6*symr8, 
               r4*symr3 + r5*symr6 + r6*symr9}; {LocTV7, LocTV8, 
               LocTV9} = {r7*symr1 + r8*symr4 + r9*symr7, r7*symr2 + 
                r8*symr5 + r9*symr8, r7*symr3 + r8*symr6 + r9*symr9}; 
             {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
              {{LocTV1, LocTV2, LocTV3}, {LocTV4, LocTV5, LocTV6}, {
                LocTV7, LocTV8, LocTV9}}; {rsx, rsy, rsz, rex, rey, rez, 
              r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
              intensityscale, ray1, index, opticallength, phaseshift, 
              componentnumber, surfacenumber, surfaceid, ray2, ray3, 
              sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
              generationnumber, intersectionnumber, pol1, pol2, 
              pol3}) & ) /@ {{0., -1.5, 0., 0., -1.5, 0., 1., 0., 0., 
             0., 1., 0., 0., 0., 1., 0.532, 100., 0.09090909090909091, 
             0., 1.00026945145708, 0., 0., 1., 0., 0., 0., 0., 100431., 
             100431., 1., 11., 1., 0., 1., 0., 0., 0., 1., 0.}, 
            {0., -1.2, 0., 0., -1.2, 0., 1., 0., 0., 0., 1., 0., 0., 0., 
             1., 0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 
             0., 0., 1., 0., 0., 0., 0., 100431., 100431., 2., 11., 2., 
             0., 1., 0., 0., 0., 1., 0.}, {0., -0.8999999999999999, 0., 
             0., -0.8999999999999999, 0., 1., 0., 0., 0., 1., 0., 0., 
             0., 1., 0.532, 100., 0.09090909090909091, 0., 
             1.00026945145708, 0., 0., 1., 0., 0., 0., 0., 100431., 
             100431., 3., 11., 3., 0., 1., 0., 0., 0., 1., 0.}, 
            {0., -0.5999999999999999, 0., 0., -0.5999999999999999, 0., 
             1., 0., 0., 0., 1., 0., 0., 0., 1., 0.532, 100., 
             0.09090909090909091, 0., 1.00026945145708, 0., 0., 1., 0., 
             0., 0., 0., 100431., 100431., 4., 11., 4., 0., 1., 0., 0., 
             0., 1., 0.}, {0., -0.2999999999999998, 0., 0., 
             -0.2999999999999998, 0., 1., 0., 0., 0., 1., 0., 0., 0., 
             1., 0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 
             0., 0., 1., 0., 0., 0., 0., 100431., 100431., 5., 11., 5., 
             0., 1., 0., 0., 0., 1., 0.}, {0., 2.220446049250313*^-16, 
             0., 0., 2.220446049250313*^-16, 0., 1., 0., 0., 0., 1., 0., 
             0., 0., 1., 0.532, 100., 0.09090909090909091, 0., 
             1.00026945145708, 0., 0., 1., 0., 0., 0., 0., 100431., 
             100431., 6., 11., 6., 0., 1., 0., 0., 0., 1., 0.}, 
            {0., 0.30000000000000027, 0., 0., 0.30000000000000027, 0., 
             1., 0., 0., 0., 1., 0., 0., 0., 1., 0.532, 100., 
             0.09090909090909091, 0., 1.00026945145708, 0., 0., 1., 0., 
             0., 0., 0., 100431., 100431., 7., 11., 7., 0., 1., 0., 0., 
             0., 1., 0.}, {0., 0.6000000000000005, 0., 0., 
             0.6000000000000005, 0., 1., 0., 0., 0., 1., 0., 0., 0., 1., 
             0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 0., 
             0., 1., 0., 0., 0., 0., 100431., 100431., 8., 11., 8., 0., 
             1., 0., 0., 0., 1., 0.}, {0., 0.9000000000000004, 0., 0., 
             0.9000000000000004, 0., 1., 0., 0., 0., 1., 0., 0., 0., 1., 
             0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 0., 
             0., 1., 0., 0., 0., 0., 100431., 100431., 9., 11., 9., 0., 
             1., 0., 0., 0., 1., 0.}, {0., 1.2000000000000002, 0., 0., 
             1.2000000000000002, 0., 1., 0., 0., 0., 1., 0., 0., 0., 1., 
             0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 0., 
             0., 1., 0., 0., 0., 0., 100431., 100431., 10., 11., 10., 
             0., 1., 0., 0., 0., 1., 0.}, {0., 1.5000000000000004, 0., 
             0., 1.5000000000000004, 0., 1., 0., 0., 0., 1., 0., 0., 0., 
             1., 0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 
             0., 0., 1., 0., 0., 0., 0., 100431., 100431., 11., 11., 
             11., 0., 1., 0., 0., 0., 1., 0.}}]; propagatedrays = 
        (({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
             r9, wavelength, intensity, intensityscale, ray1, index, 
             opticallength, phaseshift, componentnumber, surfacenumber, 
             surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, 
             sno4, rayslot, oldgenerationnumber, intersectionnumber, 
             pol1, pol2, pol3} = #1; componentnumber = 1.; frontid = 1.; 
           {rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
            r8, r9, wavelength, intensity, intensityscale, ray1, index, 
            opticallength, phaseshift, componentnumber, surfacenumber, 
            surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
            rayslot, generationnumber, intersectionnumber, pol1, pol2, 
            pol3}) & ) /@ propagatedrays; thresholdintensity = 1.; 
       generationlimit = 200.; reportedrays = 
        {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
          r9, wavelength, intensity, intensityscale, ray1, index, 
          opticallength, phaseshift, componentnumber, surfacenumber, 
          surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
          rayslot, generationnumber, intersectionnumber, pol1, pol2, 
          pol3}}; generationnumber = 0.; (generationnumber += 1.; 
        reportedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, 
           r4, r5, r6, r7, r8, r9, wavelength, 0, intensityscale, ray1, 
           index, opticallength, phaseshift, componentnumber, 
           surfacenumber, surfaceid, ray2, ray3, sid, frontid, sno1, 
           sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; deflectedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, intensity, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; (deflectedrayspresent = False; reportedrayspresent = 
          False; deflecteddummyrayspresent = False; 
         reporteddummyrayspresent = False; {deflectedlocalrays, 
           reportedlocalrays} = Transpose[
           ((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                 r8, r9, wavelength, intensity, intensityscale, ray1, 
                 index, opticallength, phaseshift, componentnumber, 
                 surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                 sno1, sno2, sno3, sno4, rayslot, oldgenerationnumber, 
                 intersectionnumber, pol1, pol2, pol3} = #1; index1 = 
                index; xunit = r1; yunit = r2; zunit = r3; xunit = 
                Chop[xunit]; yunit = Chop[yunit]; zunit = Chop[zunit]; 
               magnitude = (xunit^2 + yunit^2 + zunit^2)^2^(-1); xunit = 
                xunit/magnitude; yunit = yunit/magnitude; zunit = 
                zunit/magnitude; rx = 3.5999999999999996 + rex; ry = 
                rey; rz = rez; rx = Chop[rx]; ry = Chop[ry]; rz = 
                Chop[rz]; terminatedeflection = False; intersections = 
                {{-1., 0., 0.}}); If[intensity > thresholdintensity, 
               deflectedrayspresent = True; (intersections = 
                  Block[{LocRayL, LocSCx, LocSCy}, LocRayL = 1. + I*0.; 
                    LocSCx = 1. + I*0.; LocSCy = 1. + I*0.; 
                    Re[Select[{{-1. + 0.*I, 0. + 0.*I, 0. + 0.*I}, 
                       {(386.*xunit - 37.*rx*xunit - 50.*ry*yunit - 
                        50.*rz*zunit - 1.4142135623730951*Sqrt[
                        74498.*xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*
                        xunit^2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*
                        xunit*yunit + 19300.*rx*yunit^2 - 925.*rx^2*
                        yunit^2 - 1250.*rz^2*yunit^2 - 19300.*rz*xunit*
                        zunit + 1850.*rx*rz*xunit*zunit + 2500.*ry*rz*
                        yunit*zunit + 19300.*rx*zunit^2 - 925.*rx^2*
                        zunit^2 - 1250.*ry^2*zunit^2])/(37.*xunit^2 + 
                        50.*yunit^2 + 50.*zunit^2), (37.*ry*xunit^2 + 
                        386.*xunit*yunit - 37.*rx*xunit*yunit - 50.*rz*
                        yunit*zunit + 50.*ry*zunit^2 - 
                        1.4142135623730951*yunit*Sqrt[74498.*xunit^2 - 
                        925.*ry^2*xunit^2 - 925.*rz^2*xunit^2 - 19300.*
                        ry*xunit*yunit + 1850.*rx*ry*xunit*yunit + 
                        19300.*rx*yunit^2 - 925.*rx^2*yunit^2 - 1250.*
                        rz^2*yunit^2 - 19300.*rz*xunit*zunit + 1850.*rx*
                        rz*xunit*zunit + 2500.*ry*rz*yunit*zunit + 
                        19300.*rx*zunit^2 - 925.*rx^2*zunit^2 - 1250.*
                        ry^2*zunit^2])/(37.*xunit^2 + 50.*yunit^2 + 
                        50.*zunit^2), (37.*rz*xunit^2 + 50.*rz*yunit^2 + 
                        386.*xunit*zunit - 37.*rx*xunit*zunit - 50.*ry*
                        yunit*zunit - 1.4142135623730951*zunit*Sqrt[
                        74498.*xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*
                        xunit^2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*
                        xunit*yunit + 19300.*rx*yunit^2 - 925.*rx^2*
                        yunit^2 - 1250.*rz^2*yunit^2 - 19300.*rz*xunit*
                        zunit + 1850.*rx*rz*xunit*zunit + 2500.*ry*rz*
                        yunit*zunit + 19300.*rx*zunit^2 - 925.*rx^2*
                        zunit^2 - 1250.*ry^2*zunit^2])/(37.*xunit^2 + 
                        50.*yunit^2 + 50.*zunit^2)}, {(386.*xunit - 
                        37.*rx*xunit - 50.*ry*yunit - 50.*rz*zunit + 
                        1.4142135623730951*Sqrt[74498.*xunit^2 - 925.*
                        ry^2*xunit^2 - 925.*rz^2*xunit^2 - 19300.*ry*
                        xunit*yunit + 1850.*rx*ry*xunit*yunit + 19300.*
                        rx*yunit^2 - 925.*rx^2*yunit^2 - 1250.*rz^2*
                        yunit^2 - 19300.*rz*xunit*zunit + 1850.*rx*rz*
                        xunit*zunit + 2500.*ry*rz*yunit*zunit + 19300.*
                        rx*zunit^2 - 925.*rx^2*zunit^2 - 1250.*ry^2*
                        zunit^2])/(37.*xunit^2 + 50.*yunit^2 + 50.*
                        zunit^2), (37.*ry*xunit^2 + 386.*xunit*yunit - 
                        37.*rx*xunit*yunit - 50.*rz*yunit*zunit + 
                        50.*ry*zunit^2 + 1.4142135623730951*yunit*
                        Sqrt[74498.*xunit^2 - 925.*ry^2*xunit^2 - 
                        925.*rz^2*xunit^2 - 19300.*ry*xunit*yunit + 
                        1850.*rx*ry*xunit*yunit + 19300.*rx*yunit^2 - 
                        925.*rx^2*yunit^2 - 1250.*rz^2*yunit^2 - 19300.*
                        rz*xunit*zunit + 1850.*rx*rz*xunit*zunit + 
                        2500.*ry*rz*yunit*zunit + 19300.*rx*zunit^2 - 
                        925.*rx^2*zunit^2 - 1250.*ry^2*zunit^2])/
                        (37.*xunit^2 + 50.*yunit^2 + 50.*zunit^2), 
                        (37.*rz*xunit^2 + 50.*rz*yunit^2 + 386.*xunit*
                        zunit - 37.*rx*xunit*zunit - 50.*ry*yunit*
                        zunit + 1.4142135623730951*zunit*Sqrt[74498.*
                        xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*xunit^
                        2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*xunit*
                        yunit + 19300.*rx*yunit^2 - 925.*rx^2*yunit^2 - 
                        1250.*rz^2*yunit^2 - 19300.*rz*xunit*zunit + 
                        1850.*rx*rz*xunit*zunit + 2500.*ry*rz*yunit*
                        zunit + 19300.*rx*zunit^2 - 925.*rx^2*zunit^2 - 
                        1250.*ry^2*zunit^2])/(37.*xunit^2 + 50.*yunit^
                        2 + 50.*zunit^2)}}, ({LocRayL, LocSCx, LocSCy} = 
                        #1; {LocRayL, LocSCx, LocSCy} == {-1., 0., 
                        0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[Re[LocRayL]]] >= 0. && Abs[ry + LocRayL*
                        yunit - LocSCx] + Abs[rz + LocRayL*zunit - 
                        LocSCy] + Abs[rx + LocRayL*xunit - (25*(LocSCx^
                        2 + LocSCy^2))/(193*(1 + Sqrt[1 - (925*(LocSCx^
                        2 + LocSCy^2))/74498]))] < 1.*^-7 && 
                        Re[LocSCx]^2 + Re[LocSCy]^2 <= 39.0625)) & ]]]; 
                 AppendTo[intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100987.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 1., 
                     100987.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 1., 100987.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -3.5999999999999996 + rxhlp; rey = ryhlp; 
                   rez = rzhlp; rex = Chop[rex]; rey = Chop[rey]; 
                   rez = Chop[rez]; intersectionnumber = 
                    intersectionnumber + 1.; opticallength = 
                    opticallength + ray1*index1; completedray = 
                    {rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                     r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., (-0.0016083472422043674*ray2^3)/
                        (Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])^2) - (0.0016083472422043674*
                        ray2*ray3^2)/(Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)])^2) - 
                        (0.2590673575129534*ray2)/(1. + Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]), 
                        (-0.0016083472422043674*ray2^2*ray3)/(Sqrt[
                        1. - 0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) - (0.0016083472422043674*ray3^3)/
                        (Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])^2) - (0.2590673575129534*
                        ray3)/(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])}, {(0.0016083472422043674*
                        ray2*(ray2^2 + ray3^2))/(Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) + (0.2590673575129534*ray2)/(1. + 
                        Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]), 1., 0.}, {(0.0016083472422043674*ray3*
                        (ray2^2 + ray3^2))/(Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) + (0.2590673575129534*ray3)/(1. + 
                        Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]), 0., 1.}}]; If[surfnorm[[1]] == {0., 0., 
                        0.} || surfnorm[[2]] == {0., 0., 0.} || 
                      surfnorm[[3]] == {0., 0., 0.}, surfnorm = 
                       1.*Re[{{1., (-0.0016083472422043674*(1.*^-6 + 
                        ray2)^3)/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.0016083472422043674*(1.*^-6 + ray2)*(1.*^-6 + 
                        ray3)^2)/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.2590673575129534*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 
                        (-0.0016083472422043674*(1.*^-6 + ray2)^2*
                        (1.*^-6 + ray3))/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.0016083472422043674*(1.*^-6 + ray3)^3)/
                        (Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.2590673575129534*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])}, {(0.0016083472422043674*
                        (1.*^-6 + ray2)*((1.*^-6 + ray2)^2 + (1.*^-6 + 
                        ray3)^2))/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) + 
                        (0.2590673575129534*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 1., 0.}, 
                        {(0.0016083472422043674*(1.*^-6 + ray3)*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2))/
                        (Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.2590673575129534*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = 
                     {-3.5999999999999996, 0, 0}; activeregion = 1.; 
                    completedray = {rsx, rsy, rsz, rex, rey, rez, r1, 
                      r2, r3, r4, r5, r6, r7, r8, r9, wavelength, 
                      intensity, intensityscale, ray1, index, 
                      opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.5392664079781753 - 
                        0.7232199521975703*wavelength + 
                        1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        Sqrt[1.0005281111748805 - 2.364805676582992*^-10*
                        wavelength^2 + 2.9781670902982902*^-6/wavelength^
                        2 + 2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]; 
                        If[Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = Sqrt[1.0005281111748805 - 
                        2.364805676582992*^-10*wavelength^2 + 
                        2.9781670902982902*^-6/wavelength^2 + 
                        2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]], 
                     index2 = Sqrt[1.0005281111748805 - 
                        2.364805676582992*^-10*wavelength^2 + 
                        2.9781670902982902*^-6/wavelength^2 + 
                        2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]; index1 = 
                       index; If[Abs[index2 - index1] < 0.01, 
                       alternateindex = 1.5392664079781753 - 
                        0.7232199521975703*wavelength + 
                        1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                3.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = Block[{TempVar, TempVar1, TempVar2, 
                    TempVar3, LocRayL, LocSCx, LocSCy}, TempVar1 = 1.; 
                    TempVar2 = 1.; TempVar3 = 1.; TempVar = 
                     {{-1., 0., 0.}}; LocRayL = 1.; LocSCx = 1.; 
                    LocSCy = 1.; TempVar1 = rx^2 + ry^2 + rz^2; 
                    TempVar2 = rx*xunit + ry*yunit + rz*zunit - 
                      6.5*xunit; TempVar3 = -TempVar1 + TempVar2^2 + 
                      2*rx*6.5; TempVar3 = Re[TempVar3]; 
                    If[N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 25. && Abs[ry + LocRayL*
                        yunit - LocSCx] + Abs[rz + LocRayL*zunit - 
                        LocSCy] + Abs[-6.5 + rx + LocRayL*xunit + Sqrt[
                        42.25 - LocSCx^2 - LocSCy^2]] < 1.*^-7, 
                        {LocRayL, LocSCx, LocSCy}, {-1., 0., 0.}], 
                        {LocRayL, LocSCx, LocSCy} = {-TempVar2 + 
                        TempVar3, ry + (-TempVar2 + TempVar3)*yunit, 
                        rz + (-TempVar2 + TempVar3)*zunit}; If[
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        25. && Abs[ry + LocRayL*yunit - LocSCx] + 
                        Abs[rz + LocRayL*zunit - LocSCy] + Abs[-6.5 + 
                        rx + LocRayL*xunit + Sqrt[42.25 - LocSCx^2 - 
                        LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, LocSCy}, 
                        {-1., 0., 0.}]}; If[TempVar[[1]] == TempVar[[
                        2]], {TempVar[[1]]}, TempVar], {{-1., 0., 
                       0.}}]]; AppendTo[intersections, {-1., 0., 0.}]; 
                 holeQ = False; If[ !(Chop[surfaceid - 100988.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 2., 
                     100988.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 2., 100988.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -3.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., -(ray2/(42.25 - ray2^2 - ray3^2)^
                        2^(-1)), -(ray3/(42.25 - ray2^2 - ray3^2)^
                        2^(-1))}, {ray2/(42.25 - ray2^2 - ray3^2)^
                        2^(-1), 1., 0.}, {ray3/(42.25 - ray2^2 - ray3^2)^
                        2^(-1), 0., 1.}}]; dummymatrix = (#1 & ) /@ 
                      surfnorm; surfnorm = (#1/Sqrt[#1 . #1] & ) /@ 
                      dummymatrix; surfacerotationmatrix = {{1., 0, 0}, 
                      {0, 1., 0}, {0, 0, 1.}}; 
                    surfacetranslationvector = {-3.05, 0, 0}; 
                    activeregion = 1.; completedray = {rsx, rsy, rsz, 
                      rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.5532682085807892 - 
                        1.0054245500487249*wavelength + 
                        1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3], index2 = 
                       1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                0.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = If[Chop[xunit] != 0, 
                   {(If[N[Chop[#1[[1]]]] >= 0. && #1[[2]]^2 + #1[[3]]^
                        2 <= 6.25, {#1[[1]], #1[[2]], #1[[3]]}, 
                       {-1., 0., 0.}] & )[{-(rx/xunit), ry - (rx*yunit)/
                        xunit, rz - (rx*zunit)/xunit}]}, {{-1., 0., 
                     0.}}]; AppendTo[intersections, {-1., 0., 0.}]; 
                 holeQ = False; If[ !(Chop[surfaceid - 100989.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 3., 
                     100989.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 3., 100989.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -0.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {-0.05, 0, 
                      0}; activeregion = 0.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; 
                    allcreatedrays = {{rsx, rsy, rsz, rex, rey, rez, r1, 
                       r2, r3, r4, r5, r6, r7, r8, r9, wavelength, 
                       intensity, intensityscale, ray1, index, 
                       opticallength, phaseshift, componentnumber, 
                       surfacenumber, surfaceid, ray2, ray3, sid, 
                       frontid, sno1, sno2, sno3, sno4, rayslot, 
                       generationnumber, intersectionnumber, pol1, pol2, 
                       pol3}})); {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                0.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = If[Chop[xunit] != 0, 
                   {(If[N[Chop[#1[[1]]]] >= 0. && #1[[2]]^2 + #1[[3]]^
                        2 <= 25., {#1[[1]], #1[[2]], #1[[3]]}, {-1., 0., 
                        0.}] & )[{-(rx/xunit), ry - (rx*yunit)/xunit, 
                      rz - (rx*zunit)/xunit}]}, {{-1., 0., 0.}}]; 
                 AppendTo[intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100990.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]; intersections = 
                  Union[(If[#1[[2]]^2 + #1[[3]]^2 <= 6.25, holeQ = True; 
                       {-1., 0., 0.}, #1] & ) /@ 
                    unfilteredintersections]; If[Length[intersections] > 
                   1, dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 4., 
                     100990.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 4., 100990.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -0.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {-0.05, 0, 
                      0}; activeregion = 0.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; intensity = 
                     0.; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}})); {First[allcreatedrays], 
                   completedray}, reporteddummyrayspresent = True; 
                  {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                    r6, r7, r8, r9, wavelength, intensity, 
                    intensityscale, ray1, index, opticallength, 
                    phaseshift, componentnumber, surfacenumber, 
                    surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                    sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = rex; ry = 
                rey; rz = rez; rx = Chop[rx]; ry = Chop[ry]; rz = 
                Chop[rz]; terminatedeflection = False; intersections = 
                {{-1., 0., 0.}}); If[intensity > thresholdintensity, 
               deflectedrayspresent = True; (intersections = 
                  Block[{surfaceapprox, tempapprox, intersects, LocRayL, 
                    LocSCx, LocSCy}, LocRayL = 1.; LocSCx = 1.; 
                    LocSCy = 1.; surfaceapprox = {{-1., 0., 0.}}; 
                    tempapprox = {{-1., 0., 0.}}; intersects = 
                     {{-1., 0., 0.}}; surfaceapprox = Block[{TempVar, 
                       TempVar1, TempVar2, TempVar3, LocRayL, LocSCx, 
                       LocSCy}, TempVar1 = 1.; TempVar2 = 1.; TempVar3 = 
                        1.; TempVar = {{-1., 0., 0.}}; LocRayL = 1.; 
                       LocSCx = 1.; LocSCy = 1.; TempVar1 = rx^2 + 
                        ry^2 + rz^2; TempVar2 = rx*xunit + ry*yunit + 
                        rz*zunit - 10.2*xunit; TempVar3 = -TempVar1 + 
                        TempVar2^2 + 2*rx*10.2; TempVar3 = Re[TempVar3]; 
                       If[N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[-10.2 + rx + 
                        LocRayL*xunit + Sqrt[104.03999999999999 - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}], {LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 + TempVar3, ry + 
                        (-TempVar2 + TempVar3)*yunit, rz + (-TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[-10.2 + rx + 
                        LocRayL*xunit + Sqrt[104.03999999999999 - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}]}; If[TempVar[[1]] == 
                        TempVar[[2]], {TempVar[[1]]}, TempVar], 
                        {{-1., 0., 0.}}]]; tempapprox = Union[Join[
                       (Take[#1, 3] & ) /@ surfaceapprox, {{-1., 0., 
                        0.}}]]; If[Length[Select[tempapprox, 
                        Chop[First[#1]] <= 0 & ]] != Length[tempapprox], 
                     surfaceapprox = Select[tempapprox, 
                       Chop[First[#1]] > 0 & ], surfaceapprox = 
                      {{-1., 0., 0.}}]; If[surfaceapprox != {{-1., 0., 
                        0.}}, intersects = {{-1., 0., 0.}}; Scan[
                       (AppendTo[intersects, {LocRayL, LocSCx, LocSCy} = 
                        {#1[[1]], #1[[2]], #1[[3]]}; If[Plus @@ Abs[
                        {rx + LocRayL*xunit, ry + LocRayL*yunit, rz + 
                        LocRayL*zunit} - {(0.09803921568627452*(LocSCx^
                        2 + LocSCy^2))/(1 + Sqrt[1 + 
                        0.020488273740868906*(LocSCx^2 + LocSCy^2)]), 
                        LocSCx, LocSCy}] < 1.*^-9, {LocRayL, LocSCx, 
                        LocSCy}, LocRayL = 0.99*LocRayL; Function[{rx, 
                        ry, rz, xunit, yunit, zunit, startpoint}, Block[
                        {values, stepsizes, fvector, success, steps, 
                        denominator}, values = {1.}; stepsizes = {1.}; 
                        fvector = {1.}; success = False; steps = 0; 
                        denominator = 1.; stepsizes = Table[
                        1.0000000000000001*^-7, {3}]; values = 
                        startpoint; While[steps < 50 && (success = True; 
                        (If[Abs[#1] > 1.*^-9, success = False; 1., 
                        1.] & ) /@ stepsizes;  !success), steps = 
                        steps + 1; fvector = {rx + xunit*values[[1]], 
                        ry + yunit*values[[1]], rz + zunit*values[[
                        1]]} - {(0.09803921568627452*(values[[2]]^2 + 
                        values[[3]]^2))/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]), values[[2]], values[[3]]}; 
                        denominator = xunit - yunit*((
                        (0.002008654288320481*values[[2]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1) - zunit*(((0.002008654288320481*
                        values[[3]]*(values[[2]]^2 + values[[3]]^2))/
                        (Sqrt[1 + 0.020488273740868906*(values[[2]]^2 + 
                        values[[3]]^2)]*(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)])^2) - (0.19607843137254904*values[[3]])/
                        (1 + Sqrt[1 + 0.020488273740868906*(values[[2]]^
                        2 + values[[3]]^2)]))*-1); If[Chop[
                        denominator] != 0, denominator, denominator = 
                        1.]; stepsizes = -(#1 . fvector & ) /@ ({{1, 
                        -(((0.002008654288320481*values[[2]]*(values[[
                        2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1), -(((0.002008654288320481*values[[
                        3]]*(values[[2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1)}, {yunit, -xunit - 
                        ((0.002008654288320481*values[[3]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*zunit, ((0.002008654288320481*values[[
                        3]]*(values[[2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*yunit}, {zunit, ((0.002008654288320481*
                        values[[2]]*(values[[2]]^2 + values[[3]]^2))/
                        (Sqrt[1 + 0.020488273740868906*(values[[2]]^2 + 
                        values[[3]]^2)]*(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)])^2) - (0.19607843137254904*values[[2]])/
                        (1 + Sqrt[1 + 0.020488273740868906*(values[[2]]^
                        2 + values[[3]]^2)]))*zunit, -xunit - 
                        ((0.002008654288320481*values[[2]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*yunit}}/denominator); values = 
                        values + stepsizes]; If[steps >= 50, If[First[
                        values] > 0, values = -values; 1., 1.]; 
                        denominator = 1., 1.]; values]][rx, ry, rz, 
                        xunit, yunit, zunit, {LocRayL, LocSCx, 
                        LocSCy}]]]; {-1., 0., 0.}) & , surfaceapprox]; 
                      Union[Re[Select[intersects, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Plus @@ Abs[{rx + LocRayL*
                        xunit, ry + LocRayL*yunit, rz + LocRayL*zunit} - 
                        {(0.09803921568627452*(LocSCx^2 + LocSCy^2))/
                        (1 + Sqrt[1 + 0.020488273740868906*(LocSCx^2 + 
                        LocSCy^2)]), LocSCx, LocSCy}] < 1.*^-9)) & ]]], 
                     {{-1., 0., 0.}}]]; AppendTo[intersections, 
                  {-1., 0., 0.}]; holeQ = False; If[
                   !(Chop[surfaceid - 100991.] == 0. || N[Chop[ray1]] < 
                      0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 5., 
                     100991.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 5., 100991.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = rxhlp; rey = ryhlp; rez = rzhlp; rex = 
                    Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., (0.002008654288320481*ray2^3)/
                        (Sqrt[1. + 0.020488273740868906*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])^2) + (0.002008654288320481*
                        ray2*ray3^2)/(Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)])^2) - 
                        (0.19607843137254904*ray2)/(1. + Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]), 
                        (0.002008654288320481*ray2^2*ray3)/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.002008654288320481*ray3^3)/
                        (Sqrt[1. + 0.020488273740868906*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])^2) - (0.19607843137254904*
                        ray3)/(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])}, {(-0.002008654288320481*
                        ray2*(ray2^2 + ray3^2))/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.19607843137254904*ray2)/
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)]), 1., 0.}, {(-0.002008654288320481*ray3*
                        (ray2^2 + ray3^2))/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.19607843137254904*ray3)/
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)]), 0., 1.}}]; If[surfnorm[[1]] == 
                       {0., 0., 0.} || surfnorm[[2]] == {0., 0., 0.} || 
                      surfnorm[[3]] == {0., 0., 0.}, surfnorm = 
                       1.*Re[{{1., (0.002008654288320481*(1.*^-6 + ray2)^
                        3)/(Sqrt[1. + 0.020488273740868906*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.002008654288320481*
                        (1.*^-6 + ray2)*(1.*^-6 + ray3)^2)/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.19607843137254904*
                        (1.*^-6 + ray2))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), (0.002008654288320481*
                        (1.*^-6 + ray2)^2*(1.*^-6 + ray3))/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.002008654288320481*
                        (1.*^-6 + ray3)^3)/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.19607843137254904*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])}, {(-0.002008654288320481*
                        (1.*^-6 + ray2)*((1.*^-6 + ray2)^2 + (1.*^-6 + 
                        ray3)^2))/(Sqrt[1. + 0.020488273740868906*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) + 
                        (0.19607843137254904*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. + 0.020488273740868906*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 1., 0.}, 
                        {(-0.002008654288320481*(1.*^-6 + ray3)*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2))/
                        (Sqrt[1. + 0.020488273740868906*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.19607843137254904*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1, 0, 0}, {0, 1, 0}, 
                      {0, 0, 1}}; surfacetranslationvector = {0, 0, 0}; 
                    activeregion = 1.; completedray = {rsx, rsy, rsz, 
                      rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.6765916828635454 - 
                        1.1701284013462314*wavelength + 
                        1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3], index2 = 
                       1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                -4. + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = Block[{surfaceapprox, tempapprox, 
                    intersects, LocRayL, LocSCx, LocSCy}, LocRayL = 1.; 
                    LocSCx = 1.; LocSCy = 1.; surfaceapprox = 
                     {{-1., 0., 0.}}; tempapprox = {{-1., 0., 0.}}; 
                    intersects = {{-1., 0., 0.}}; surfaceapprox = 
                     Block[{TempVar, TempVar1, TempVar2, TempVar3, 
                       LocRayL, LocSCx, LocSCy}, TempVar1 = 1.; 
                       TempVar2 = 1.; TempVar3 = 1.; TempVar = 
                        {{-1., 0., 0.}}; LocRayL = 1.; LocSCx = 1.; 
                       LocSCy = 1.; TempVar1 = rx^2 + ry^2 + rz^2; 
                       TempVar2 = rx*xunit + ry*yunit + rz*zunit - 
                        -6.*xunit; TempVar3 = -TempVar1 + TempVar2^2 + 
                        2*rx*-6.; TempVar3 = Re[TempVar3]; If[
                        N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[6. + rx + LocRayL*
                        xunit - Sqrt[36. - LocSCx^2 - LocSCy^2]] < 
                        1.*^-7, {LocRayL, LocSCx, LocSCy}, {-1., 0., 
                        0.}], {LocRayL, LocSCx, LocSCy} = {-TempVar2 + 
                        TempVar3, ry + (-TempVar2 + TempVar3)*yunit, 
                        rz + (-TempVar2 + TempVar3)*zunit}; If[
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Abs[ry + LocRayL*yunit - 
                        LocSCx] + Abs[rz + LocRayL*zunit - LocSCy] + 
                        Abs[6. + rx + LocRayL*xunit - Sqrt[36. - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}]}; If[TempVar[[1]] == 
                        TempVar[[2]], {TempVar[[1]]}, TempVar], 
                        {{-1., 0., 0.}}]]; tempapprox = Union[Join[
                       (Take[#1, 3] & ) /@ surfaceapprox, {{-1., 0., 
                        0.}}]]; If[Length[Select[tempapprox, 
                        Chop[First[#1]] <= 0 & ]] != Length[tempapprox], 
                     surfaceapprox = Select[tempapprox, 
                       Chop[First[#1]] > 0 & ], surfaceapprox = 
                      {{-1., 0., 0.}}]; If[surfaceapprox != {{-1., 0., 
                        0.}}, intersects = {{-1., 0., 0.}}; Scan[
                       (AppendTo[intersects, {LocRayL, LocSCx, LocSCy} = 
                        {#1[[1]], #1[[2]], #1[[3]]}; If[Plus @@ Abs[
                        {rx + LocRayL*xunit, ry + LocRayL*yunit, rz + 
                        LocRayL*zunit} - {(-0.16666666666666666*(LocSCx^
                        2 + LocSCy^2))/(1 + Sqrt[Plus[1]]), LocSCx, 
                        LocSCy}] < 1.*^-9, {LocRayL, LocSCx, LocSCy}, 
                        LocRayL = 0.99*LocRayL; Function[{rx, ry, rz, 
                        xunit, yunit, zunit, startpoint}, Block[{values, 
                        stepsizes, fvector, success, steps, 
                        denominator}, values = {1.}; stepsizes = {1.}; 
                        fvector = {1.}; success = False; steps = 0; 
                        denominator = 1.; stepsizes = Table[
                        1.0000000000000001*^-7, {3}]; values = 
                        startpoint; While[steps < 50 && (success = True; 
                        (If[Abs[#1] > 1.*^-9, success = False; 1., 
                        1.] & ) /@ stepsizes;  !success), steps = 
                        steps + 1; fvector = {rx + xunit*values[[1]], 
                        ry + yunit*values[[1]], rz + zunit*values[[
                        1]]} - {(-0.16666666666666666*(values[[2]]^2 + 
                        values[[3]]^2))/(1 + Sqrt[Plus[1]]), values[[
                        2]], values[[3]]}; denominator = xunit - yunit*
                        ((Plus[(0.3333333333333333*values[[2]])/(1 + 
                        Sqrt[Plus[1]])])*-1) - zunit*((Plus[
                        (0.3333333333333333*values[[3]])/(1 + Sqrt[Plus[
                        1]])])*-1); If[Chop[denominator] != 0, 
                        denominator, denominator = 1.]; stepsizes = 
                        -(#1 . fvector & ) /@ ({{1, -((Plus[
                        (0.3333333333333333*values[[2]])/(1 + Sqrt[Plus[
                        1]])])*-1), -((Plus[(0.3333333333333333*values[[
                        3]])/(1 + Sqrt[Plus[1]])])*-1)}, {yunit, 
                        -xunit - (Plus[(0.3333333333333333*values[[3]])/
                        (1 + Sqrt[Plus[1]])])*zunit, (Plus[
                        (0.3333333333333333*values[[3]])/(1 + Sqrt[Plus[
                        1]])])*yunit}, {zunit, (Plus[(0.3333333333333333*
                        values[[2]])/(1 + Sqrt[Plus[1]])])*zunit, 
                        -xunit - (Plus[(0.3333333333333333*values[[2]])/
                        (1 + Sqrt[Plus[1]])])*yunit}}/denominator); 
                        values = values + stepsizes]; If[steps >= 50, 
                        If[First[values] > 0, values = -values; 1., 1.]; 
                        denominator = 1., 1.]; values]][rx, ry, rz, 
                        xunit, yunit, zunit, {LocRayL, LocSCx, 
                        LocSCy}]]]; {-1., 0., 0.}) & , surfaceapprox]; 
                      Union[Re[Select[intersects, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Plus @@ Abs[{rx + LocRayL*
                        xunit, ry + LocRayL*yunit, rz + LocRayL*zunit} - 
                        {(-0.16666666666666666*(LocSCx^2 + LocSCy^2))/
                        (1 + Sqrt[Plus[1]]), LocSCx, LocSCy}] < 
                        1.*^-9)) & ]]], {{-1., 0., 0.}}]]; AppendTo[
                  intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100992.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 6., 
                     100992.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 6., 100992.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = 4. + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., Plus[(0.3333333333333333*ray2)/(1. + 
                        Sqrt[Plus[1.]])], Plus[(0.3333333333333333*ray3)/
                        (1. + Sqrt[Plus[1.]])]}, {Plus[
                        (-0.3333333333333333*ray2)/(1. + Sqrt[Plus[
                        1.]])], 1., 0.}, {Plus[(-0.3333333333333333*
                        ray3)/(1. + Sqrt[Plus[1.]])], 0., 1.}}]; 
                    If[surfnorm[[1]] == {0., 0., 0.} || surfnorm[[2]] == 
                       {0., 0., 0.} || surfnorm[[3]] == {0., 0., 0.}, 
                     surfnorm = 1.*Re[{{1., Plus[(0.3333333333333333*
                        (1.*^-6 + ray2))/(1. + Sqrt[Plus[1.]])], Plus[
                        (0.3333333333333333*(1.*^-6 + ray3))/(1. + 
                        Sqrt[Plus[1.]])]}, {Plus[(-0.3333333333333333*
                        (1.*^-6 + ray2))/(1. + Sqrt[Plus[1.]])], 1., 
                        0.}, {Plus[(-0.3333333333333333*(1.*^-6 + ray3))/
                        (1. + Sqrt[Plus[1.]])], 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {4., 0, 
                      0}; activeregion = 1.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; ZAxis = 
                     First[surfnorm]*Sign[First[surfnorm] . {r1, r2, 
                        r3}]; raytiltz = ZAxis . {r1, r2, r3}; 
                    raytiltx = 1 - raytiltz^2; If[raytiltx < 
                      2.220446049250313*^-16, raytiltx = 0., raytiltx = 
                      Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - ZAxis*
                       raytiltz; If[Abs[raytiltx] < 1.*^-7, XAxis = 
                      surfnorm[[2]], XAxis = XAxis/raytiltx]; YAxis = 
                     {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*XAxis[[3]], 
                      ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*XAxis[[3]], 
                      -(ZAxis[[2]]*XAxis[[1]]) + ZAxis[[1]]*XAxis[[2]]}; 
                    YAxis = YAxis/Sqrt[YAxis . YAxis]; PAxis = 
                     ZAxis*{r1, r2, r3} . XAxis - XAxis*{r1, r2, r3} . 
                        ZAxis; PAxis = PAxis/Sqrt[PAxis . PAxis]; 
                    normalizedpolarization = {pol1, pol2, pol3}[[
                      {1, 2}]]; normalizedpolarization = 
                     normalizedpolarization/Sqrt[
                       normalizedpolarization . normalizedpolarization]; 
                    allcreatedamplitudes = {{I*0., I*0., I*0.}}; 
                    amplitude = Sqrt[intensity]*(normalizedpolarization[[
                        1]]*{r4, r5, r6} + normalizedpolarization[[2]]*
                        {r7, r8, r9}*Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.499266407978439 - 
                        0.7232199521991957*wavelength + 
                        1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3], index2 = 
                       1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.499266407978439 - 0.7232199521991957*
                        wavelength + 1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.499266407978439 - 0.7232199521991957*
                        wavelength + 1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                -20.3203 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = Block[{TempVar, TempVar1, TempVar2, 
                    TempVar3, LocRayL, LocSCx, LocSCy}, TempVar1 = 1.; 
                    TempVar2 = 1.; TempVar3 = 1.; TempVar = 
                     {{-1., 0., 0.}}; LocRayL = 1.; LocSCx = 1.; 
                    LocSCy = 1.; TempVar1 = rx^2 + ry^2 + rz^2; 
                    TempVar2 = rx*xunit + ry*yunit + rz*zunit - 
                      -12*xunit; TempVar3 = -TempVar1 + TempVar2^2 + 
                      2*rx*-12; TempVar3 = Re[TempVar3]; 
                    If[N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 142.80249999999998 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[12 + rx + LocRayL*
                        xunit - Sqrt[144 - LocSCx^2 - LocSCy^2]] < 
                        1.*^-7, {LocRayL, LocSCx, LocSCy}, {-1., 0., 
                        0.}], {LocRayL, LocSCx, LocSCy} = {-TempVar2 + 
                        TempVar3, ry + (-TempVar2 + TempVar3)*yunit, 
                        rz + (-TempVar2 + TempVar3)*zunit}; If[
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        142.80249999999998 && Abs[ry + LocRayL*yunit - 
                        LocSCx] + Abs[rz + LocRayL*zunit - LocSCy] + 
                        Abs[12 + rx + LocRayL*xunit - Sqrt[144 - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}]}; If[TempVar[[1]] == 
                        TempVar[[2]], {TempVar[[1]]}, TempVar], 
                     {{-1., 0., 0.}}]]; AppendTo[intersections, 
                  {-1., 0., 0.}]; holeQ = False; If[
                   !(Chop[surfaceid - 100993.] == 0. || N[Chop[ray1]] < 
                      0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 7., 
                     100993.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 7., 100993.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = 20.3203 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., -(-(ray2/(144 - ray2^2 - ray3^2)^
                        2^(-1))), -(-(ray3/(144 - ray2^2 - ray3^2)^
                        2^(-1)))}, {-(ray2/(144 - ray2^2 - ray3^2)^
                        2^(-1)), 1., 0.}, {-(ray3/(144 - ray2^2 - 
                        ray3^2)^2^(-1)), 0., 1.}}]; dummymatrix = 
                     (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {20.3203, 
                      0, 0}; activeregion = 0.; completedray = 
                     {rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                      r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; 
                    componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; intensity = 0.; allcreatedrays = 
                     {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                       r6, r7, r8, r9, wavelength, intensity, 
                       intensityscale, ray1, index, opticallength, 
                       phaseshift, componentnumber, surfacenumber, 
                       surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                       sno3, sno4, rayslot, generationnumber, 
                       intersectionnumber, pol1, pol2, pol3}})); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                -4. + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = Block[{surfaceapprox, tempapprox, 
                    intersects, LocRayL, LocSCx, LocSCy}, LocRayL = 1.; 
                    LocSCx = 1.; LocSCy = 1.; surfaceapprox = 
                     {{-1., 0., 0.}}; tempapprox = {{-1., 0., 0.}}; 
                    intersects = {{-1., 0., 0.}}; surfaceapprox = 
                     Block[{TempVar, TempVar1, TempVar2, TempVar3, 
                       LocRayL, LocSCx, LocSCy}, TempVar1 = 1.; 
                       TempVar2 = 1.; TempVar3 = 1.; TempVar = 
                        {{-1., 0., 0.}}; LocRayL = 1.; LocSCx = 1.; 
                       LocSCy = 1.; TempVar1 = rx^2 + ry^2 + rz^2; 
                       TempVar2 = rx*xunit + ry*yunit + rz*zunit - 
                        -6.*xunit; TempVar3 = -TempVar1 + TempVar2^2 + 
                        2*rx*-6.; TempVar3 = Re[TempVar3]; If[
                        N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[6. + rx + LocRayL*
                        xunit - Sqrt[36. - LocSCx^2 - LocSCy^2]] < 
                        1.*^-7, {LocRayL, LocSCx, LocSCy}, {-1., 0., 
                        0.}], {LocRayL, LocSCx, LocSCy} = {-TempVar2 + 
                        TempVar3, ry + (-TempVar2 + TempVar3)*yunit, 
                        rz + (-TempVar2 + TempVar3)*zunit}; If[
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Abs[ry + LocRayL*yunit - 
                        LocSCx] + Abs[rz + LocRayL*zunit - LocSCy] + 
                        Abs[6. + rx + LocRayL*xunit - Sqrt[36. - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}]}; If[TempVar[[1]] == 
                        TempVar[[2]], {TempVar[[1]]}, TempVar], 
                        {{-1., 0., 0.}}]]; tempapprox = Union[Join[
                       (Take[#1, 3] & ) /@ surfaceapprox, {{-1., 0., 
                        0.}}]]; If[Length[Select[tempapprox, 
                        Chop[First[#1]] <= 0 & ]] != Length[tempapprox], 
                     surfaceapprox = Select[tempapprox, 
                       Chop[First[#1]] > 0 & ], surfaceapprox = 
                      {{-1., 0., 0.}}]; If[surfaceapprox != {{-1., 0., 
                        0.}}, intersects = {{-1., 0., 0.}}; Scan[
                       (AppendTo[intersects, {LocRayL, LocSCx, LocSCy} = 
                        {#1[[1]], #1[[2]], #1[[3]]}; If[Plus @@ Abs[
                        {rx + LocRayL*xunit, ry + LocRayL*yunit, rz + 
                        LocRayL*zunit} - {(-0.16666666666666666*(LocSCx^
                        2 + LocSCy^2))/(1 + Sqrt[Plus[1]]), LocSCx, 
                        LocSCy}] < 1.*^-9, {LocRayL, LocSCx, LocSCy}, 
                        LocRayL = 0.99*LocRayL; Function[{rx, ry, rz, 
                        xunit, yunit, zunit, startpoint}, Block[{values, 
                        stepsizes, fvector, success, steps, 
                        denominator}, values = {1.}; stepsizes = {1.}; 
                        fvector = {1.}; success = False; steps = 0; 
                        denominator = 1.; stepsizes = Table[
                        1.0000000000000001*^-7, {3}]; values = 
                        startpoint; While[steps < 50 && (success = True; 
                        (If[Abs[#1] > 1.*^-9, success = False; 1., 
                        1.] & ) /@ stepsizes;  !success), steps = 
                        steps + 1; fvector = {rx + xunit*values[[1]], 
                        ry + yunit*values[[1]], rz + zunit*values[[
                        1]]} - {(-0.16666666666666666*(values[[2]]^2 + 
                        values[[3]]^2))/(1 + Sqrt[Plus[1]]), values[[
                        2]], values[[3]]}; denominator = xunit - yunit*
                        ((Plus[(0.3333333333333333*values[[2]])/(1 + 
                        Sqrt[Plus[1]])])*-1) - zunit*((Plus[
                        (0.3333333333333333*values[[3]])/(1 + Sqrt[Plus[
                        1]])])*-1); If[Chop[denominator] != 0, 
                        denominator, denominator = 1.]; stepsizes = 
                        -(#1 . fvector & ) /@ ({{1, -((Plus[
                        (0.3333333333333333*values[[2]])/(1 + Sqrt[Plus[
                        1]])])*-1), -((Plus[(0.3333333333333333*values[[
                        3]])/(1 + Sqrt[Plus[1]])])*-1)}, {yunit, 
                        -xunit - (Plus[(0.3333333333333333*values[[3]])/
                        (1 + Sqrt[Plus[1]])])*zunit, (Plus[
                        (0.3333333333333333*values[[3]])/(1 + Sqrt[Plus[
                        1]])])*yunit}, {zunit, (Plus[(0.3333333333333333*
                        values[[2]])/(1 + Sqrt[Plus[1]])])*zunit, 
                        -xunit - (Plus[(0.3333333333333333*values[[2]])/
                        (1 + Sqrt[Plus[1]])])*yunit}}/denominator); 
                        values = values + stepsizes]; If[steps >= 50, 
                        If[First[values] > 0, values = -values; 1., 1.]; 
                        denominator = 1., 1.]; values]][rx, ry, rz, 
                        xunit, yunit, zunit, {LocRayL, LocSCx, 
                        LocSCy}]]]; {-1., 0., 0.}) & , surfaceapprox]; 
                      Union[Re[Select[intersects, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Plus @@ Abs[{rx + LocRayL*
                        xunit, ry + LocRayL*yunit, rz + LocRayL*zunit} - 
                        {(-0.16666666666666666*(LocSCx^2 + LocSCy^2))/
                        (1 + Sqrt[Plus[1]]), LocSCx, LocSCy}] < 
                        1.*^-9)) & ]]], {{-1., 0., 0.}}]]; AppendTo[
                  intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100994.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 8., 
                     100994.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 8., 100994.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = 4. + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., Plus[(0.3333333333333333*ray2)/(1. + 
                        Sqrt[Plus[1.]])], Plus[(0.3333333333333333*ray3)/
                        (1. + Sqrt[Plus[1.]])]}, {Plus[
                        (-0.3333333333333333*ray2)/(1. + Sqrt[Plus[
                        1.]])], 1., 0.}, {Plus[(-0.3333333333333333*
                        ray3)/(1. + Sqrt[Plus[1.]])], 0., 1.}}]; 
                    If[surfnorm[[1]] == {0., 0., 0.} || surfnorm[[2]] == 
                       {0., 0., 0.} || surfnorm[[3]] == {0., 0., 0.}, 
                     surfnorm = 1.*Re[{{1., Plus[(0.3333333333333333*
                        (1.*^-6 + ray2))/(1. + Sqrt[Plus[1.]])], Plus[
                        (0.3333333333333333*(1.*^-6 + ray3))/(1. + 
                        Sqrt[Plus[1.]])]}, {Plus[(-0.3333333333333333*
                        (1.*^-6 + ray2))/(1. + Sqrt[Plus[1.]])], 1., 
                        0.}, {Plus[(-0.3333333333333333*(1.*^-6 + ray3))/
                        (1. + Sqrt[Plus[1.]])], 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {4., 0, 
                      0}; activeregion = 1.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; ZAxis = 
                     First[surfnorm]*Sign[First[surfnorm] . {r1, r2, 
                        r3}]; raytiltz = ZAxis . {r1, r2, r3}; 
                    raytiltx = 1 - raytiltz^2; If[raytiltx < 
                      2.220446049250313*^-16, raytiltx = 0., raytiltx = 
                      Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - ZAxis*
                       raytiltz; If[Abs[raytiltx] < 1.*^-7, XAxis = 
                      surfnorm[[2]], XAxis = XAxis/raytiltx]; YAxis = 
                     {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*XAxis[[3]], 
                      ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*XAxis[[3]], 
                      -(ZAxis[[2]]*XAxis[[1]]) + ZAxis[[1]]*XAxis[[2]]}; 
                    YAxis = YAxis/Sqrt[YAxis . YAxis]; PAxis = 
                     ZAxis*{r1, r2, r3} . XAxis - XAxis*{r1, r2, r3} . 
                        ZAxis; PAxis = PAxis/Sqrt[PAxis . PAxis]; 
                    normalizedpolarization = {pol1, pol2, pol3}[[
                      {1, 2}]]; normalizedpolarization = 
                     normalizedpolarization/Sqrt[
                       normalizedpolarization . normalizedpolarization]; 
                    allcreatedamplitudes = {{I*0., I*0., I*0.}}; 
                    amplitude = Sqrt[intensity]*(normalizedpolarization[[
                        1]]*{r4, r5, r6} + normalizedpolarization[[2]]*
                        {r7, r8, r9}*Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.499266407978439 - 
                        0.7232199521991957*wavelength + 
                        1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3], index2 = 
                       1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.499266407978439 - 0.7232199521991957*
                        wavelength + 1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.499266407978439 - 0.7232199521991957*
                        wavelength + 1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = rex; ry = 
                rey; rz = rez; rx = Chop[rx]; ry = Chop[ry]; rz = 
                Chop[rz]; terminatedeflection = False; intersections = 
                {{-1., 0., 0.}}); If[intensity > thresholdintensity, 
               deflectedrayspresent = True; (intersections = 
                  Block[{surfaceapprox, tempapprox, intersects, LocRayL, 
                    LocSCx, LocSCy}, LocRayL = 1.; LocSCx = 1.; 
                    LocSCy = 1.; surfaceapprox = {{-1., 0., 0.}}; 
                    tempapprox = {{-1., 0., 0.}}; intersects = 
                     {{-1., 0., 0.}}; surfaceapprox = Block[{TempVar, 
                       TempVar1, TempVar2, TempVar3, LocRayL, LocSCx, 
                       LocSCy}, TempVar1 = 1.; TempVar2 = 1.; TempVar3 = 
                        1.; TempVar = {{-1., 0., 0.}}; LocRayL = 1.; 
                       LocSCx = 1.; LocSCy = 1.; TempVar1 = rx^2 + 
                        ry^2 + rz^2; TempVar2 = rx*xunit + ry*yunit + 
                        rz*zunit - 10.2*xunit; TempVar3 = -TempVar1 + 
                        TempVar2^2 + 2*rx*10.2; TempVar3 = Re[TempVar3]; 
                       If[N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[-10.2 + rx + 
                        LocRayL*xunit + Sqrt[104.03999999999999 - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}], {LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 + TempVar3, ry + 
                        (-TempVar2 + TempVar3)*yunit, rz + (-TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[-10.2 + rx + 
                        LocRayL*xunit + Sqrt[104.03999999999999 - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}]}; If[TempVar[[1]] == 
                        TempVar[[2]], {TempVar[[1]]}, TempVar], 
                        {{-1., 0., 0.}}]]; tempapprox = Union[Join[
                       (Take[#1, 3] & ) /@ surfaceapprox, {{-1., 0., 
                        0.}}]]; If[Length[Select[tempapprox, 
                        Chop[First[#1]] <= 0 & ]] != Length[tempapprox], 
                     surfaceapprox = Select[tempapprox, 
                       Chop[First[#1]] > 0 & ], surfaceapprox = 
                      {{-1., 0., 0.}}]; If[surfaceapprox != {{-1., 0., 
                        0.}}, intersects = {{-1., 0., 0.}}; Scan[
                       (AppendTo[intersects, {LocRayL, LocSCx, LocSCy} = 
                        {#1[[1]], #1[[2]], #1[[3]]}; If[Plus @@ Abs[
                        {rx + LocRayL*xunit, ry + LocRayL*yunit, rz + 
                        LocRayL*zunit} - {(0.09803921568627452*(LocSCx^
                        2 + LocSCy^2))/(1 + Sqrt[1 + 
                        0.020488273740868906*(LocSCx^2 + LocSCy^2)]), 
                        LocSCx, LocSCy}] < 1.*^-9, {LocRayL, LocSCx, 
                        LocSCy}, LocRayL = 0.99*LocRayL; Function[{rx, 
                        ry, rz, xunit, yunit, zunit, startpoint}, Block[
                        {values, stepsizes, fvector, success, steps, 
                        denominator}, values = {1.}; stepsizes = {1.}; 
                        fvector = {1.}; success = False; steps = 0; 
                        denominator = 1.; stepsizes = Table[
                        1.0000000000000001*^-7, {3}]; values = 
                        startpoint; While[steps < 50 && (success = True; 
                        (If[Abs[#1] > 1.*^-9, success = False; 1., 
                        1.] & ) /@ stepsizes;  !success), steps = 
                        steps + 1; fvector = {rx + xunit*values[[1]], 
                        ry + yunit*values[[1]], rz + zunit*values[[
                        1]]} - {(0.09803921568627452*(values[[2]]^2 + 
                        values[[3]]^2))/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]), values[[2]], values[[3]]}; 
                        denominator = xunit - yunit*((
                        (0.002008654288320481*values[[2]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1) - zunit*(((0.002008654288320481*
                        values[[3]]*(values[[2]]^2 + values[[3]]^2))/
                        (Sqrt[1 + 0.020488273740868906*(values[[2]]^2 + 
                        values[[3]]^2)]*(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)])^2) - (0.19607843137254904*values[[3]])/
                        (1 + Sqrt[1 + 0.020488273740868906*(values[[2]]^
                        2 + values[[3]]^2)]))*-1); If[Chop[
                        denominator] != 0, denominator, denominator = 
                        1.]; stepsizes = -(#1 . fvector & ) /@ ({{1, 
                        -(((0.002008654288320481*values[[2]]*(values[[
                        2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1), -(((0.002008654288320481*values[[
                        3]]*(values[[2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1)}, {yunit, -xunit - 
                        ((0.002008654288320481*values[[3]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*zunit, ((0.002008654288320481*values[[
                        3]]*(values[[2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*yunit}, {zunit, ((0.002008654288320481*
                        values[[2]]*(values[[2]]^2 + values[[3]]^2))/
                        (Sqrt[1 + 0.020488273740868906*(values[[2]]^2 + 
                        values[[3]]^2)]*(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)])^2) - (0.19607843137254904*values[[2]])/
                        (1 + Sqrt[1 + 0.020488273740868906*(values[[2]]^
                        2 + values[[3]]^2)]))*zunit, -xunit - 
                        ((0.002008654288320481*values[[2]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*yunit}}/denominator); values = 
                        values + stepsizes]; If[steps >= 50, If[First[
                        values] > 0, values = -values; 1., 1.]; 
                        denominator = 1., 1.]; values]][rx, ry, rz, 
                        xunit, yunit, zunit, {LocRayL, LocSCx, 
                        LocSCy}]]]; {-1., 0., 0.}) & , surfaceapprox]; 
                      Union[Re[Select[intersects, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Plus @@ Abs[{rx + LocRayL*
                        xunit, ry + LocRayL*yunit, rz + LocRayL*zunit} - 
                        {(0.09803921568627452*(LocSCx^2 + LocSCy^2))/
                        (1 + Sqrt[1 + 0.020488273740868906*(LocSCx^2 + 
                        LocSCy^2)]), LocSCx, LocSCy}] < 1.*^-9)) & ]]], 
                     {{-1., 0., 0.}}]]; AppendTo[intersections, 
                  {-1., 0., 0.}]; holeQ = False; If[
                   !(Chop[surfaceid - 100995.] == 0. || N[Chop[ray1]] < 
                      0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 9., 
                     100995.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 9., 100995.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = rxhlp; rey = ryhlp; rez = rzhlp; rex = 
                    Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., (0.002008654288320481*ray2^3)/
                        (Sqrt[1. + 0.020488273740868906*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])^2) + (0.002008654288320481*
                        ray2*ray3^2)/(Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)])^2) - 
                        (0.19607843137254904*ray2)/(1. + Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]), 
                        (0.002008654288320481*ray2^2*ray3)/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.002008654288320481*ray3^3)/
                        (Sqrt[1. + 0.020488273740868906*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])^2) - (0.19607843137254904*
                        ray3)/(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])}, {(-0.002008654288320481*
                        ray2*(ray2^2 + ray3^2))/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.19607843137254904*ray2)/
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)]), 1., 0.}, {(-0.002008654288320481*ray3*
                        (ray2^2 + ray3^2))/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.19607843137254904*ray3)/
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)]), 0., 1.}}]; If[surfnorm[[1]] == 
                       {0., 0., 0.} || surfnorm[[2]] == {0., 0., 0.} || 
                      surfnorm[[3]] == {0., 0., 0.}, surfnorm = 
                       1.*Re[{{1., (0.002008654288320481*(1.*^-6 + ray2)^
                        3)/(Sqrt[1. + 0.020488273740868906*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.002008654288320481*
                        (1.*^-6 + ray2)*(1.*^-6 + ray3)^2)/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.19607843137254904*
                        (1.*^-6 + ray2))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), (0.002008654288320481*
                        (1.*^-6 + ray2)^2*(1.*^-6 + ray3))/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.002008654288320481*
                        (1.*^-6 + ray3)^3)/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.19607843137254904*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])}, {(-0.002008654288320481*
                        (1.*^-6 + ray2)*((1.*^-6 + ray2)^2 + (1.*^-6 + 
                        ray3)^2))/(Sqrt[1. + 0.020488273740868906*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) + 
                        (0.19607843137254904*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. + 0.020488273740868906*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 1., 0.}, 
                        {(-0.002008654288320481*(1.*^-6 + ray3)*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2))/
                        (Sqrt[1. + 0.020488273740868906*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.19607843137254904*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1, 0, 0}, {0, 1, 0}, 
                      {0, 0, 1}}; surfacetranslationvector = {0, 0, 0}; 
                    activeregion = 1.; completedray = {rsx, rsy, rsz, 
                      rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.6765916828635454 - 
                        1.1701284013462314*wavelength + 
                        1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3], index2 = 
                       1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                0.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = If[Chop[xunit] != 0, 
                   {(If[N[Chop[#1[[1]]]] >= 0. && #1[[2]]^2 + #1[[3]]^
                        2 <= 6.25, {#1[[1]], #1[[2]], #1[[3]]}, 
                       {-1., 0., 0.}] & )[{-(rx/xunit), ry - (rx*yunit)/
                        xunit, rz - (rx*zunit)/xunit}]}, {{-1., 0., 
                     0.}}]; AppendTo[intersections, {-1., 0., 0.}]; 
                 holeQ = False; If[ !(Chop[surfaceid - 100996.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 10., 
                     100996.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 10., 100996.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -0.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {-0.05, 0, 
                      0}; activeregion = 0.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; 
                    allcreatedrays = {{rsx, rsy, rsz, rex, rey, rez, r1, 
                       r2, r3, r4, r5, r6, r7, r8, r9, wavelength, 
                       intensity, intensityscale, ray1, index, 
                       opticallength, phaseshift, componentnumber, 
                       surfacenumber, surfaceid, ray2, ray3, sid, 
                       frontid, sno1, sno2, sno3, sno4, rayslot, 
                       generationnumber, intersectionnumber, pol1, pol2, 
                       pol3}})); {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                0.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = If[Chop[xunit] != 0, 
                   {(If[N[Chop[#1[[1]]]] >= 0. && #1[[2]]^2 + #1[[3]]^
                        2 <= 25., {#1[[1]], #1[[2]], #1[[3]]}, {-1., 0., 
                        0.}] & )[{-(rx/xunit), ry - (rx*yunit)/xunit, 
                      rz - (rx*zunit)/xunit}]}, {{-1., 0., 0.}}]; 
                 AppendTo[intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100997.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]; intersections = 
                  Union[(If[#1[[2]]^2 + #1[[3]]^2 <= 6.25, holeQ = True; 
                       {-1., 0., 0.}, #1] & ) /@ 
                    unfilteredintersections]; If[Length[intersections] > 
                   1, dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 11., 
                     100997.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 11., 100997.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -0.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {-0.05, 0, 
                      0}; activeregion = 0.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; intensity = 
                     0.; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}})); {First[allcreatedrays], 
                   completedray}, reporteddummyrayspresent = True; 
                  {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                    r6, r7, r8, r9, wavelength, intensity, 
                    intensityscale, ray1, index, opticallength, 
                    phaseshift, componentnumber, surfacenumber, 
                    surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                    sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                3.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = Block[{TempVar, TempVar1, TempVar2, 
                    TempVar3, LocRayL, LocSCx, LocSCy}, TempVar1 = 1.; 
                    TempVar2 = 1.; TempVar3 = 1.; TempVar = 
                     {{-1., 0., 0.}}; LocRayL = 1.; LocSCx = 1.; 
                    LocSCy = 1.; TempVar1 = rx^2 + ry^2 + rz^2; 
                    TempVar2 = rx*xunit + ry*yunit + rz*zunit - 
                      6.5*xunit; TempVar3 = -TempVar1 + TempVar2^2 + 
                      2*rx*6.5; TempVar3 = Re[TempVar3]; 
                    If[N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 25. && Abs[ry + LocRayL*
                        yunit - LocSCx] + Abs[rz + LocRayL*zunit - 
                        LocSCy] + Abs[-6.5 + rx + LocRayL*xunit + Sqrt[
                        42.25 - LocSCx^2 - LocSCy^2]] < 1.*^-7, 
                        {LocRayL, LocSCx, LocSCy}, {-1., 0., 0.}], 
                        {LocRayL, LocSCx, LocSCy} = {-TempVar2 + 
                        TempVar3, ry + (-TempVar2 + TempVar3)*yunit, 
                        rz + (-TempVar2 + TempVar3)*zunit}; If[
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        25. && Abs[ry + LocRayL*yunit - LocSCx] + 
                        Abs[rz + LocRayL*zunit - LocSCy] + Abs[-6.5 + 
                        rx + LocRayL*xunit + Sqrt[42.25 - LocSCx^2 - 
                        LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, LocSCy}, 
                        {-1., 0., 0.}]}; If[TempVar[[1]] == TempVar[[
                        2]], {TempVar[[1]]}, TempVar], {{-1., 0., 
                       0.}}]]; AppendTo[intersections, {-1., 0., 0.}]; 
                 holeQ = False; If[ !(Chop[surfaceid - 100998.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 12., 
                     100998.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 12., 100998.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -3.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., -(ray2/(42.25 - ray2^2 - ray3^2)^
                        2^(-1)), -(ray3/(42.25 - ray2^2 - ray3^2)^
                        2^(-1))}, {ray2/(42.25 - ray2^2 - ray3^2)^
                        2^(-1), 1., 0.}, {ray3/(42.25 - ray2^2 - ray3^2)^
                        2^(-1), 0., 1.}}]; dummymatrix = (#1 & ) /@ 
                      surfnorm; surfnorm = (#1/Sqrt[#1 . #1] & ) /@ 
                      dummymatrix; surfacerotationmatrix = {{1., 0, 0}, 
                      {0, 1., 0}, {0, 0, 1.}}; 
                    surfacetranslationvector = {-3.05, 0, 0}; 
                    activeregion = 1.; completedray = {rsx, rsy, rsz, 
                      rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.5532682085807892 - 
                        1.0054245500487249*wavelength + 
                        1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3], index2 = 
                       1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                3.5999999999999996 + rex; ry = rey; rz = rez; rx = 
                Chop[rx]; ry = Chop[ry]; rz = Chop[rz]; 
               terminatedeflection = False; intersections = 
                {{-1., 0., 0.}}); If[intensity > thresholdintensity, 
               deflectedrayspresent = True; (intersections = 
                  Block[{LocRayL, LocSCx, LocSCy}, LocRayL = 1. + I*0.; 
                    LocSCx = 1. + I*0.; LocSCy = 1. + I*0.; 
                    Re[Select[{{-1. + 0.*I, 0. + 0.*I, 0. + 0.*I}, 
                       {(386.*xunit - 37.*rx*xunit - 50.*ry*yunit - 
                        50.*rz*zunit - 1.4142135623730951*Sqrt[
                        74498.*xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*
                        xunit^2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*
                        xunit*yunit + 19300.*rx*yunit^2 - 925.*rx^2*
                        yunit^2 - 1250.*rz^2*yunit^2 - 19300.*rz*xunit*
                        zunit + 1850.*rx*rz*xunit*zunit + 2500.*ry*rz*
                        yunit*zunit + 19300.*rx*zunit^2 - 925.*rx^2*
                        zunit^2 - 1250.*ry^2*zunit^2])/(37.*xunit^2 + 
                        50.*yunit^2 + 50.*zunit^2), (37.*ry*xunit^2 + 
                        386.*xunit*yunit - 37.*rx*xunit*yunit - 50.*rz*
                        yunit*zunit + 50.*ry*zunit^2 - 
                        1.4142135623730951*yunit*Sqrt[74498.*xunit^2 - 
                        925.*ry^2*xunit^2 - 925.*rz^2*xunit^2 - 19300.*
                        ry*xunit*yunit + 1850.*rx*ry*xunit*yunit + 
                        19300.*rx*yunit^2 - 925.*rx^2*yunit^2 - 1250.*
                        rz^2*yunit^2 - 19300.*rz*xunit*zunit + 1850.*rx*
                        rz*xunit*zunit + 2500.*ry*rz*yunit*zunit + 
                        19300.*rx*zunit^2 - 925.*rx^2*zunit^2 - 1250.*
                        ry^2*zunit^2])/(37.*xunit^2 + 50.*yunit^2 + 
                        50.*zunit^2), (37.*rz*xunit^2 + 50.*rz*yunit^2 + 
                        386.*xunit*zunit - 37.*rx*xunit*zunit - 50.*ry*
                        yunit*zunit - 1.4142135623730951*zunit*Sqrt[
                        74498.*xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*
                        xunit^2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*
                        xunit*yunit + 19300.*rx*yunit^2 - 925.*rx^2*
                        yunit^2 - 1250.*rz^2*yunit^2 - 19300.*rz*xunit*
                        zunit + 1850.*rx*rz*xunit*zunit + 2500.*ry*rz*
                        yunit*zunit + 19300.*rx*zunit^2 - 925.*rx^2*
                        zunit^2 - 1250.*ry^2*zunit^2])/(37.*xunit^2 + 
                        50.*yunit^2 + 50.*zunit^2)}, {(386.*xunit - 
                        37.*rx*xunit - 50.*ry*yunit - 50.*rz*zunit + 
                        1.4142135623730951*Sqrt[74498.*xunit^2 - 925.*
                        ry^2*xunit^2 - 925.*rz^2*xunit^2 - 19300.*ry*
                        xunit*yunit + 1850.*rx*ry*xunit*yunit + 19300.*
                        rx*yunit^2 - 925.*rx^2*yunit^2 - 1250.*rz^2*
                        yunit^2 - 19300.*rz*xunit*zunit + 1850.*rx*rz*
                        xunit*zunit + 2500.*ry*rz*yunit*zunit + 19300.*
                        rx*zunit^2 - 925.*rx^2*zunit^2 - 1250.*ry^2*
                        zunit^2])/(37.*xunit^2 + 50.*yunit^2 + 50.*
                        zunit^2), (37.*ry*xunit^2 + 386.*xunit*yunit - 
                        37.*rx*xunit*yunit - 50.*rz*yunit*zunit + 
                        50.*ry*zunit^2 + 1.4142135623730951*yunit*
                        Sqrt[74498.*xunit^2 - 925.*ry^2*xunit^2 - 
                        925.*rz^2*xunit^2 - 19300.*ry*xunit*yunit + 
                        1850.*rx*ry*xunit*yunit + 19300.*rx*yunit^2 - 
                        925.*rx^2*yunit^2 - 1250.*rz^2*yunit^2 - 19300.*
                        rz*xunit*zunit + 1850.*rx*rz*xunit*zunit + 
                        2500.*ry*rz*yunit*zunit + 19300.*rx*zunit^2 - 
                        925.*rx^2*zunit^2 - 1250.*ry^2*zunit^2])/
                        (37.*xunit^2 + 50.*yunit^2 + 50.*zunit^2), 
                        (37.*rz*xunit^2 + 50.*rz*yunit^2 + 386.*xunit*
                        zunit - 37.*rx*xunit*zunit - 50.*ry*yunit*
                        zunit + 1.4142135623730951*zunit*Sqrt[74498.*
                        xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*xunit^
                        2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*xunit*
                        yunit + 19300.*rx*yunit^2 - 925.*rx^2*yunit^2 - 
                        1250.*rz^2*yunit^2 - 19300.*rz*xunit*zunit + 
                        1850.*rx*rz*xunit*zunit + 2500.*ry*rz*yunit*
                        zunit + 19300.*rx*zunit^2 - 925.*rx^2*zunit^2 - 
                        1250.*ry^2*zunit^2])/(37.*xunit^2 + 50.*yunit^
                        2 + 50.*zunit^2)}}, ({LocRayL, LocSCx, LocSCy} = 
                        #1; {LocRayL, LocSCx, LocSCy} == {-1., 0., 
                        0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[Re[LocRayL]]] >= 0. && Abs[ry + LocRayL*
                        yunit - LocSCx] + Abs[rz + LocRayL*zunit - 
                        LocSCy] + Abs[rx + LocRayL*xunit - (25*(LocSCx^
                        2 + LocSCy^2))/(193*(1 + Sqrt[1 - (925*(LocSCx^
                        2 + LocSCy^2))/74498]))] < 1.*^-7 && 
                        Re[LocSCx]^2 + Re[LocSCy]^2 <= 39.0625)) & ]]]; 
                 AppendTo[intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100999.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 13., 
                     100999.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 13., 100999.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -3.5999999999999996 + rxhlp; rey = ryhlp; 
                   rez = rzhlp; rex = Chop[rex]; rey = Chop[rey]; 
                   rez = Chop[rez]; intersectionnumber = 
                    intersectionnumber + 1.; opticallength = 
                    opticallength + ray1*index1; completedray = 
                    {rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                     r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., (-0.0016083472422043674*ray2^3)/
                        (Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])^2) - (0.0016083472422043674*
                        ray2*ray3^2)/(Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)])^2) - 
                        (0.2590673575129534*ray2)/(1. + Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]), 
                        (-0.0016083472422043674*ray2^2*ray3)/(Sqrt[
                        1. - 0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) - (0.0016083472422043674*ray3^3)/
                        (Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])^2) - (0.2590673575129534*
                        ray3)/(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])}, {(0.0016083472422043674*
                        ray2*(ray2^2 + ray3^2))/(Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) + (0.2590673575129534*ray2)/(1. + 
                        Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]), 1., 0.}, {(0.0016083472422043674*ray3*
                        (ray2^2 + ray3^2))/(Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) + (0.2590673575129534*ray3)/(1. + 
                        Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]), 0., 1.}}]; If[surfnorm[[1]] == {0., 0., 
                        0.} || surfnorm[[2]] == {0., 0., 0.} || 
                      surfnorm[[3]] == {0., 0., 0.}, surfnorm = 
                       1.*Re[{{1., (-0.0016083472422043674*(1.*^-6 + 
                        ray2)^3)/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.0016083472422043674*(1.*^-6 + ray2)*(1.*^-6 + 
                        ray3)^2)/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.2590673575129534*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 
                        (-0.0016083472422043674*(1.*^-6 + ray2)^2*
                        (1.*^-6 + ray3))/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.0016083472422043674*(1.*^-6 + ray3)^3)/
                        (Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.2590673575129534*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])}, {(0.0016083472422043674*
                        (1.*^-6 + ray2)*((1.*^-6 + ray2)^2 + (1.*^-6 + 
                        ray3)^2))/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) + 
                        (0.2590673575129534*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 1., 0.}, 
                        {(0.0016083472422043674*(1.*^-6 + ray3)*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2))/
                        (Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.2590673575129534*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = 
                     {-3.5999999999999996, 0, 0}; activeregion = 1.; 
                    completedray = {rsx, rsy, rsz, rex, rey, rez, r1, 
                      r2, r3, r4, r5, r6, r7, r8, r9, wavelength, 
                      intensity, intensityscale, ray1, index, 
                      opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.5392664079781753 - 
                        0.7232199521975703*wavelength + 
                        1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        Sqrt[1.0005281111748805 - 2.364805676582992*^-10*
                        wavelength^2 + 2.9781670902982902*^-6/wavelength^
                        2 + 2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]; 
                        If[Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = Sqrt[1.0005281111748805 - 
                        2.364805676582992*^-10*wavelength^2 + 
                        2.9781670902982902*^-6/wavelength^2 + 
                        2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]], 
                     index2 = Sqrt[1.0005281111748805 - 
                        2.364805676582992*^-10*wavelength^2 + 
                        2.9781670902982902*^-6/wavelength^2 + 
                        2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]; index1 = 
                       index; If[Abs[index2 - index1] < 0.01, 
                       alternateindex = 1.5392664079781753 - 
                        0.7232199521975703*wavelength + 
                        1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       If[Length[reportedrays] > 2, reportedrays = Drop[reportedrays, 
          2], reportedrays]; ({#1[[1]], #1[[2]], #1[[3]], #1[[4]], 
          #1[[5]], #1[[6]]} & ) /@ reportedrays]]; 
   raytracefunction21864020083128460953516 = 
    Compile[{{th, _Real}, {x, _Real}, {y, _Real}}, 
     Module[{activeregion, allcreatedamplitudes, allcreatedrays, 
       allowzeroraylength, alternateindex, amplitude, axismagnitude, 
       axismatrix, clonedata, clonegenerationnumber, cloneinput, 
       clonenumber, cloneposition, clonereportedrays, clonerotation, 
       clonescale, clonescalevector, clonesorthistogram, 
       clonetraceinput, clonetraceoutput, closestdistances, 
       closestposition, closestpositions, closestraylength, 
       completedray, componentnumber, cosangle, crossmatrix, 
       deflecteddummyrayspresent, deflectedlocalrays, deflectedrays, 
       deflectedrayspresent, dummymatrix, dummymatrixlist, dummyvector, 
       frontid, generationlimit, generationnumber, holeintersections, 
       holeQ, holeQlist, hor, index, index1, index2, inrays, intensity, 
       intensityscale, intersectionnumber, intersections, 
       intersectionslist, intersectionspresent, 
       localdummyoutrayspresent, localoutrays, localoutrayspresent, 
       magnitude, maxclonegenerationnumber, maximumposition, 
       minimumraylength, minresonateraylength, n12, newcomponentnumber, 
       newdeflectedrays, newdistance, newsurfaceid, newsurfacenumber, 
       nonintersectingrays, normalizedpolarization, oldgenerationnumber, 
       opticallength, originalray, originalraytilt, originalrotation, 
       originalsurfnorm, outrays, parallelamplitude, PAxis, 
       perpendicularamplitude, phaseshift, pol1, pol2, pol3, 
       previoustilt, propagate, propagatedrays, r1, r2, r3, r4, r5, r6, 
       r7, r8, r9, ray1, ray2, ray3, LocRayL, rayslot, raysreported, 
       raytiltx, raytiltz, reporteddummyrayspresent, reportedlocalrays, 
       reportedrays, reportedrayspresent, resonateintersections, 
       resonatenumber, resonateraylength, rex, rey, rez, rotationaxis, 
       rsx, LocRSx, rsy, LocRSy, rsz, LocRSz, RTx, LocRTy, LocRTz, rx, 
       rxhlp, ry, ryhlp, rz, rzhlp, LocSCx, LocSCy, sid, sinangle, sno1, 
       sno2, sno3, sno4, surfaceid, surfacenumber, 
       surfacerotationmatrix, surfacetranslationvector, surfnorm, symr1, 
       symr2, symr3, symr4, symr5, symr6, symr7, symr8, symr9, 
       tempclonedata, terminatedeflection, thresholdintensity, 
       tiltmagnitude, transmatrix, LocTV1, LocTV10, LocTV2, LocTV3, 
       LocTV4, LocTV5, LocTV6, LocTV7, LocTV8, LocTV9, u, 
       unfilteredintersections, unit, uu, ver, wavelength, XAxis, xunit, 
       YAxis, yunit, ZAxis, zunit}, activeregion = 1.; 
       allcreatedamplitudes = {{0. + 0.*I, 0. + 0.*I, 0. + 0.*I}}; 
       allcreatedrays = {{1.}}; allowzeroraylength = True; 
       alternateindex = 1.; amplitude = {1. + 0.*I, 0. + 0.*I, 
         0. + 0.*I}; axismagnitude = 1.; axismatrix = 
        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}; clonedata = {{1.}}; 
       clonegenerationnumber = 1.; cloneinput = {1.}; clonenumber = 1; 
       cloneposition = {0., 0., 0.}; clonereportedrays = {{1.}}; 
       clonerotation = {{1.}}; clonescale = 1.; clonescalevector = {1.}; 
       clonesorthistogram = {1}; clonetraceinput = {{1.}}; 
       clonetraceoutput = {{1.}}; closestdistances = {1.}; 
       closestposition = 0; closestpositions = {0}; 
       closestraylength = 1.; completedray = {1.}; 
       componentnumber = -1.; cosangle = 1.; crossmatrix = 
        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}; 
       deflecteddummyrayspresent = False; deflectedlocalrays = {{1.}}; 
       deflectedrays = {{1.}}; deflectedrayspresent = False; 
       dummymatrix = {{1.}}; dummymatrixlist = {{{1.}}}; 
       dummyvector = {1.}; frontid = 1.; generationlimit = 200.; 
       generationnumber = 1.; holeintersections = {{-1., 0., 0.}}; 
       holeQ = False; holeQlist = {0}; hor = 1. + 0.*I; index = 1.; 
       index1 = 1.; index2 = 1.; inrays = {{1.}}; intensity = 1.; 
       intensityscale = 1.; intersectionnumber = 1.; 
       intersections = {{-1., 0., 0.}}; intersectionslist = 
        {{{-1., 0., 0.}}}; intersectionspresent = False; 
       localdummyoutrayspresent = False; localoutrays = {{1.}}; 
       localoutrayspresent = False; magnitude = 1.; 
       maxclonegenerationnumber = 1.; maximumposition = 1; 
       minimumraylength = 0.0001; minresonateraylength = 1.; n12 = 1.; 
       newcomponentnumber = -1.; newdeflectedrays = {{1.}}; 
       newdistance = 1.; newsurfaceid = -1.; newsurfacenumber = -1.; 
       nonintersectingrays = {{1.}}; normalizedpolarization = {1., 1.}; 
       oldgenerationnumber = 1.; opticallength = 1.; originalray = {1.}; 
       originalraytilt = {1.}; originalrotation = {{1., 0., 0.}, 
         {0., 1., 0.}, {0., 0., 1.}}; originalsurfnorm = {{1.}}; 
       outrays = {{1.}}; parallelamplitude = 1. + 0.*I; 
       PAxis = {1., 0., 0.}; perpendicularamplitude = 1. + 0.*I; 
       phaseshift = 0.; pol1 = 1.; pol2 = 1.; pol3 = 1.; 
       previoustilt = {1., 0., 0.}; propagate = True; 
       propagatedrays = {{1.}}; r1 = 1.; r2 = 1.; r3 = 1.; r4 = 1.; 
       r5 = 1.; r6 = 1.; r7 = 1.; r8 = 1.; r9 = 1.; ray1 = 1.; 
       ray2 = 1.; ray3 = 1.; LocRayL = 1.; rayslot = 1.; 
       raysreported = False; raytiltx = 1.; raytiltz = 1.; 
       reporteddummyrayspresent = False; reportedlocalrays = {{1.}}; 
       reportedrays = {{1.}}; reportedrayspresent = False; 
       resonateintersections = {{-1., 0., 0.}}; resonatenumber = 0; 
       resonateraylength = 1.; rex = 1.; rey = 1.; rez = 1.; rsx = 1.; 
       LocRSx = 1.; rsy = 1.; LocRSy = 1.; rsz = 1.; LocRSz = 1.; 
       RTx = 1.; LocRTy = 1.; LocRTz = 1.; rx = 1.; rxhlp = 1.; ry = 1.; 
       ryhlp = 1.; rz = 1.; rzhlp = 1.; LocSCx = 1.; LocSCy = 1.; 
       sid = 1.; sinangle = 1.; sno1 = 1.; sno2 = 1.; sno3 = 1.; 
       sno4 = 1.; surfaceid = -1.; surfacenumber = -1.; 
       surfacerotationmatrix = {{1., 0., 0.}, {0., 1., 0.}, 
         {0., 0., 1.}}; surfacetranslationvector = {0., 0., 0.}; 
       surfnorm = {{1.}}; symr1 = 1.; symr2 = 1.; symr3 = 1.; 
       symr4 = 1.; symr5 = 1.; symr6 = 1.; symr7 = 1.; symr8 = 1.; 
       symr9 = 1.; tempclonedata = {{1.}}; terminatedeflection = False; 
       thresholdintensity = 1.; tiltmagnitude = 1.; 
       transmatrix = {{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}}; 
       LocTV1 = 1.; LocTV10 = 1.; LocTV2 = 1.; LocTV3 = 1.; LocTV4 = 1.; 
       LocTV5 = 1.; LocTV6 = 1.; LocTV7 = 1.; LocTV8 = 1.; LocTV9 = 1.; 
       u = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}; 
       unfilteredintersections = {{-1., 0., 0.}}; 
       unit = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}; 
       uu = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}; ver = 0. + 0.*I; 
       wavelength = 1.; XAxis = {1., 0., 0.}; xunit = 1.; 
       YAxis = {1., 0., 0.}; yunit = 1.; ZAxis = {1., 0., 0.}; 
       zunit = 1.; propagatedrays = 
        Join[{symr1, symr2, symr3, symr4, symr5, symr6, symr7, symr8, 
            symr9} = {Cos[Degree*th], Sin[Degree*th], 0, 
            -Sin[Degree*th], Cos[Degree*th], 0, 0, 0, 1}; 
          (({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
               r8, r9, wavelength, intensity, intensityscale, ray1, 
               index, opticallength, phaseshift, componentnumber, 
               surfacenumber, surfaceid, ray2, ray3, sid, frontid, sno1, 
               sno2, sno3, sno4, rayslot, oldgenerationnumber, 
               intersectionnumber, pol1, pol2, pol3} = #1; 
             {LocTV1, LocTV2, LocTV3} = {rsx*symr1 + rsy*symr4 + 
                rsz*symr7 + x, rsx*symr2 + rsy*symr5 + rsz*symr8 + y, 
               rsx*symr3 + rsy*symr6 + rsz*symr9}; {rsx, rsy, rsz} = 
              {LocTV1, LocTV2, LocTV3}; {LocTV1, LocTV2, LocTV3} = 
              {rex*symr1 + rey*symr4 + rez*symr7 + x, rex*symr2 + 
                rey*symr5 + rez*symr8 + y, rex*symr3 + rey*symr6 + 
                rez*symr9}; {rex, rey, rez} = {LocTV1, LocTV2, LocTV3}; 
             {LocTV1, LocTV2, LocTV3} = {r1*symr1 + r2*symr4 + r3*symr7, 
               r1*symr2 + r2*symr5 + r3*symr8, r1*symr3 + r2*symr6 + 
                r3*symr9}; {LocTV4, LocTV5, LocTV6} = {r4*symr1 + 
                r5*symr4 + r6*symr7, r4*symr2 + r5*symr5 + r6*symr8, 
               r4*symr3 + r5*symr6 + r6*symr9}; {LocTV7, LocTV8, 
               LocTV9} = {r7*symr1 + r8*symr4 + r9*symr7, r7*symr2 + 
                r8*symr5 + r9*symr8, r7*symr3 + r8*symr6 + r9*symr9}; 
             {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
              {{LocTV1, LocTV2, LocTV3}, {LocTV4, LocTV5, LocTV6}, {
                LocTV7, LocTV8, LocTV9}}; {rsx, rsy, rsz, rex, rey, rez, 
              r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
              intensityscale, ray1, index, opticallength, phaseshift, 
              componentnumber, surfacenumber, surfaceid, ray2, ray3, 
              sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
              generationnumber, intersectionnumber, pol1, pol2, 
              pol3}) & ) /@ {{0., -1.5, 0., 0., -1.5, 0., 1., 0., 0., 
             0., 1., 0., 0., 0., 1., 0.532, 100., 0.09090909090909091, 
             0., 1.00026945145708, 0., 0., 1., 0., 0., 0., 0., 100431., 
             100431., 1., 11., 1., 0., 1., 0., 0., 0., 1., 0.}, 
            {0., -1.2, 0., 0., -1.2, 0., 1., 0., 0., 0., 1., 0., 0., 0., 
             1., 0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 
             0., 0., 1., 0., 0., 0., 0., 100431., 100431., 2., 11., 2., 
             0., 1., 0., 0., 0., 1., 0.}, {0., -0.8999999999999999, 0., 
             0., -0.8999999999999999, 0., 1., 0., 0., 0., 1., 0., 0., 
             0., 1., 0.532, 100., 0.09090909090909091, 0., 
             1.00026945145708, 0., 0., 1., 0., 0., 0., 0., 100431., 
             100431., 3., 11., 3., 0., 1., 0., 0., 0., 1., 0.}, 
            {0., -0.5999999999999999, 0., 0., -0.5999999999999999, 0., 
             1., 0., 0., 0., 1., 0., 0., 0., 1., 0.532, 100., 
             0.09090909090909091, 0., 1.00026945145708, 0., 0., 1., 0., 
             0., 0., 0., 100431., 100431., 4., 11., 4., 0., 1., 0., 0., 
             0., 1., 0.}, {0., -0.2999999999999998, 0., 0., 
             -0.2999999999999998, 0., 1., 0., 0., 0., 1., 0., 0., 0., 
             1., 0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 
             0., 0., 1., 0., 0., 0., 0., 100431., 100431., 5., 11., 5., 
             0., 1., 0., 0., 0., 1., 0.}, {0., 2.220446049250313*^-16, 
             0., 0., 2.220446049250313*^-16, 0., 1., 0., 0., 0., 1., 0., 
             0., 0., 1., 0.532, 100., 0.09090909090909091, 0., 
             1.00026945145708, 0., 0., 1., 0., 0., 0., 0., 100431., 
             100431., 6., 11., 6., 0., 1., 0., 0., 0., 1., 0.}, 
            {0., 0.30000000000000027, 0., 0., 0.30000000000000027, 0., 
             1., 0., 0., 0., 1., 0., 0., 0., 1., 0.532, 100., 
             0.09090909090909091, 0., 1.00026945145708, 0., 0., 1., 0., 
             0., 0., 0., 100431., 100431., 7., 11., 7., 0., 1., 0., 0., 
             0., 1., 0.}, {0., 0.6000000000000005, 0., 0., 
             0.6000000000000005, 0., 1., 0., 0., 0., 1., 0., 0., 0., 1., 
             0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 0., 
             0., 1., 0., 0., 0., 0., 100431., 100431., 8., 11., 8., 0., 
             1., 0., 0., 0., 1., 0.}, {0., 0.9000000000000004, 0., 0., 
             0.9000000000000004, 0., 1., 0., 0., 0., 1., 0., 0., 0., 1., 
             0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 0., 
             0., 1., 0., 0., 0., 0., 100431., 100431., 9., 11., 9., 0., 
             1., 0., 0., 0., 1., 0.}, {0., 1.2000000000000002, 0., 0., 
             1.2000000000000002, 0., 1., 0., 0., 0., 1., 0., 0., 0., 1., 
             0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 0., 
             0., 1., 0., 0., 0., 0., 100431., 100431., 10., 11., 10., 
             0., 1., 0., 0., 0., 1., 0.}, {0., 1.5000000000000004, 0., 
             0., 1.5000000000000004, 0., 1., 0., 0., 0., 1., 0., 0., 0., 
             1., 0.532, 100., 0.09090909090909091, 0., 1.00026945145708, 
             0., 0., 1., 0., 0., 0., 0., 100431., 100431., 11., 11., 
             11., 0., 1., 0., 0., 0., 1., 0.}}]; propagatedrays = 
        (({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
             r9, wavelength, intensity, intensityscale, ray1, index, 
             opticallength, phaseshift, componentnumber, surfacenumber, 
             surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, 
             sno4, rayslot, oldgenerationnumber, intersectionnumber, 
             pol1, pol2, pol3} = #1; componentnumber = 1.; frontid = 1.; 
           {rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
            r8, r9, wavelength, intensity, intensityscale, ray1, index, 
            opticallength, phaseshift, componentnumber, surfacenumber, 
            surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
            rayslot, generationnumber, intersectionnumber, pol1, pol2, 
            pol3}) & ) /@ propagatedrays; thresholdintensity = 1.; 
       generationlimit = 200.; reportedrays = 
        {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
          r9, wavelength, intensity, intensityscale, ray1, index, 
          opticallength, phaseshift, componentnumber, surfacenumber, 
          surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
          rayslot, generationnumber, intersectionnumber, pol1, pol2, 
          pol3}}; generationnumber = 0.; (generationnumber += 1.; 
        reportedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, 
           r4, r5, r6, r7, r8, r9, wavelength, 0, intensityscale, ray1, 
           index, opticallength, phaseshift, componentnumber, 
           surfacenumber, surfaceid, ray2, ray3, sid, frontid, sno1, 
           sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; deflectedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, intensity, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; (deflectedrayspresent = False; reportedrayspresent = 
          False; deflecteddummyrayspresent = False; 
         reporteddummyrayspresent = False; {deflectedlocalrays, 
           reportedlocalrays} = Transpose[
           ((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                 r8, r9, wavelength, intensity, intensityscale, ray1, 
                 index, opticallength, phaseshift, componentnumber, 
                 surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                 sno1, sno2, sno3, sno4, rayslot, oldgenerationnumber, 
                 intersectionnumber, pol1, pol2, pol3} = #1; index1 = 
                index; xunit = r1; yunit = r2; zunit = r3; xunit = 
                Chop[xunit]; yunit = Chop[yunit]; zunit = Chop[zunit]; 
               magnitude = (xunit^2 + yunit^2 + zunit^2)^2^(-1); xunit = 
                xunit/magnitude; yunit = yunit/magnitude; zunit = 
                zunit/magnitude; rx = 3.5999999999999996 + rex; ry = 
                rey; rz = rez; rx = Chop[rx]; ry = Chop[ry]; rz = 
                Chop[rz]; terminatedeflection = False; intersections = 
                {{-1., 0., 0.}}); If[intensity > thresholdintensity, 
               deflectedrayspresent = True; (intersections = 
                  Block[{LocRayL, LocSCx, LocSCy}, LocRayL = 1. + I*0.; 
                    LocSCx = 1. + I*0.; LocSCy = 1. + I*0.; 
                    Re[Select[{{-1. + 0.*I, 0. + 0.*I, 0. + 0.*I}, 
                       {(386.*xunit - 37.*rx*xunit - 50.*ry*yunit - 
                        50.*rz*zunit - 1.4142135623730951*Sqrt[
                        74498.*xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*
                        xunit^2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*
                        xunit*yunit + 19300.*rx*yunit^2 - 925.*rx^2*
                        yunit^2 - 1250.*rz^2*yunit^2 - 19300.*rz*xunit*
                        zunit + 1850.*rx*rz*xunit*zunit + 2500.*ry*rz*
                        yunit*zunit + 19300.*rx*zunit^2 - 925.*rx^2*
                        zunit^2 - 1250.*ry^2*zunit^2])/(37.*xunit^2 + 
                        50.*yunit^2 + 50.*zunit^2), (37.*ry*xunit^2 + 
                        386.*xunit*yunit - 37.*rx*xunit*yunit - 50.*rz*
                        yunit*zunit + 50.*ry*zunit^2 - 
                        1.4142135623730951*yunit*Sqrt[74498.*xunit^2 - 
                        925.*ry^2*xunit^2 - 925.*rz^2*xunit^2 - 19300.*
                        ry*xunit*yunit + 1850.*rx*ry*xunit*yunit + 
                        19300.*rx*yunit^2 - 925.*rx^2*yunit^2 - 1250.*
                        rz^2*yunit^2 - 19300.*rz*xunit*zunit + 1850.*rx*
                        rz*xunit*zunit + 2500.*ry*rz*yunit*zunit + 
                        19300.*rx*zunit^2 - 925.*rx^2*zunit^2 - 1250.*
                        ry^2*zunit^2])/(37.*xunit^2 + 50.*yunit^2 + 
                        50.*zunit^2), (37.*rz*xunit^2 + 50.*rz*yunit^2 + 
                        386.*xunit*zunit - 37.*rx*xunit*zunit - 50.*ry*
                        yunit*zunit - 1.4142135623730951*zunit*Sqrt[
                        74498.*xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*
                        xunit^2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*
                        xunit*yunit + 19300.*rx*yunit^2 - 925.*rx^2*
                        yunit^2 - 1250.*rz^2*yunit^2 - 19300.*rz*xunit*
                        zunit + 1850.*rx*rz*xunit*zunit + 2500.*ry*rz*
                        yunit*zunit + 19300.*rx*zunit^2 - 925.*rx^2*
                        zunit^2 - 1250.*ry^2*zunit^2])/(37.*xunit^2 + 
                        50.*yunit^2 + 50.*zunit^2)}, {(386.*xunit - 
                        37.*rx*xunit - 50.*ry*yunit - 50.*rz*zunit + 
                        1.4142135623730951*Sqrt[74498.*xunit^2 - 925.*
                        ry^2*xunit^2 - 925.*rz^2*xunit^2 - 19300.*ry*
                        xunit*yunit + 1850.*rx*ry*xunit*yunit + 19300.*
                        rx*yunit^2 - 925.*rx^2*yunit^2 - 1250.*rz^2*
                        yunit^2 - 19300.*rz*xunit*zunit + 1850.*rx*rz*
                        xunit*zunit + 2500.*ry*rz*yunit*zunit + 19300.*
                        rx*zunit^2 - 925.*rx^2*zunit^2 - 1250.*ry^2*
                        zunit^2])/(37.*xunit^2 + 50.*yunit^2 + 50.*
                        zunit^2), (37.*ry*xunit^2 + 386.*xunit*yunit - 
                        37.*rx*xunit*yunit - 50.*rz*yunit*zunit + 
                        50.*ry*zunit^2 + 1.4142135623730951*yunit*
                        Sqrt[74498.*xunit^2 - 925.*ry^2*xunit^2 - 
                        925.*rz^2*xunit^2 - 19300.*ry*xunit*yunit + 
                        1850.*rx*ry*xunit*yunit + 19300.*rx*yunit^2 - 
                        925.*rx^2*yunit^2 - 1250.*rz^2*yunit^2 - 19300.*
                        rz*xunit*zunit + 1850.*rx*rz*xunit*zunit + 
                        2500.*ry*rz*yunit*zunit + 19300.*rx*zunit^2 - 
                        925.*rx^2*zunit^2 - 1250.*ry^2*zunit^2])/
                        (37.*xunit^2 + 50.*yunit^2 + 50.*zunit^2), 
                        (37.*rz*xunit^2 + 50.*rz*yunit^2 + 386.*xunit*
                        zunit - 37.*rx*xunit*zunit - 50.*ry*yunit*
                        zunit + 1.4142135623730951*zunit*Sqrt[74498.*
                        xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*xunit^
                        2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*xunit*
                        yunit + 19300.*rx*yunit^2 - 925.*rx^2*yunit^2 - 
                        1250.*rz^2*yunit^2 - 19300.*rz*xunit*zunit + 
                        1850.*rx*rz*xunit*zunit + 2500.*ry*rz*yunit*
                        zunit + 19300.*rx*zunit^2 - 925.*rx^2*zunit^2 - 
                        1250.*ry^2*zunit^2])/(37.*xunit^2 + 50.*yunit^
                        2 + 50.*zunit^2)}}, ({LocRayL, LocSCx, LocSCy} = 
                        #1; {LocRayL, LocSCx, LocSCy} == {-1., 0., 
                        0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[Re[LocRayL]]] >= 0. && Abs[ry + LocRayL*
                        yunit - LocSCx] + Abs[rz + LocRayL*zunit - 
                        LocSCy] + Abs[rx + LocRayL*xunit - (25*(LocSCx^
                        2 + LocSCy^2))/(193*(1 + Sqrt[1 - (925*(LocSCx^
                        2 + LocSCy^2))/74498]))] < 1.*^-7 && 
                        Re[LocSCx]^2 + Re[LocSCy]^2 <= 39.0625)) & ]]]; 
                 AppendTo[intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100987.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 1., 
                     100987.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 1., 100987.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -3.5999999999999996 + rxhlp; rey = ryhlp; 
                   rez = rzhlp; rex = Chop[rex]; rey = Chop[rey]; 
                   rez = Chop[rez]; intersectionnumber = 
                    intersectionnumber + 1.; opticallength = 
                    opticallength + ray1*index1; completedray = 
                    {rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                     r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., (-0.0016083472422043674*ray2^3)/
                        (Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])^2) - (0.0016083472422043674*
                        ray2*ray3^2)/(Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)])^2) - 
                        (0.2590673575129534*ray2)/(1. + Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]), 
                        (-0.0016083472422043674*ray2^2*ray3)/(Sqrt[
                        1. - 0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) - (0.0016083472422043674*ray3^3)/
                        (Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])^2) - (0.2590673575129534*
                        ray3)/(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])}, {(0.0016083472422043674*
                        ray2*(ray2^2 + ray3^2))/(Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) + (0.2590673575129534*ray2)/(1. + 
                        Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]), 1., 0.}, {(0.0016083472422043674*ray3*
                        (ray2^2 + ray3^2))/(Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) + (0.2590673575129534*ray3)/(1. + 
                        Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]), 0., 1.}}]; If[surfnorm[[1]] == {0., 0., 
                        0.} || surfnorm[[2]] == {0., 0., 0.} || 
                      surfnorm[[3]] == {0., 0., 0.}, surfnorm = 
                       1.*Re[{{1., (-0.0016083472422043674*(1.*^-6 + 
                        ray2)^3)/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.0016083472422043674*(1.*^-6 + ray2)*(1.*^-6 + 
                        ray3)^2)/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.2590673575129534*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 
                        (-0.0016083472422043674*(1.*^-6 + ray2)^2*
                        (1.*^-6 + ray3))/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.0016083472422043674*(1.*^-6 + ray3)^3)/
                        (Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.2590673575129534*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])}, {(0.0016083472422043674*
                        (1.*^-6 + ray2)*((1.*^-6 + ray2)^2 + (1.*^-6 + 
                        ray3)^2))/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) + 
                        (0.2590673575129534*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 1., 0.}, 
                        {(0.0016083472422043674*(1.*^-6 + ray3)*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2))/
                        (Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.2590673575129534*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = 
                     {-3.5999999999999996, 0, 0}; activeregion = 1.; 
                    completedray = {rsx, rsy, rsz, rex, rey, rez, r1, 
                      r2, r3, r4, r5, r6, r7, r8, r9, wavelength, 
                      intensity, intensityscale, ray1, index, 
                      opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.5392664079781753 - 
                        0.7232199521975703*wavelength + 
                        1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        Sqrt[1.0005281111748805 - 2.364805676582992*^-10*
                        wavelength^2 + 2.9781670902982902*^-6/wavelength^
                        2 + 2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]; 
                        If[Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = Sqrt[1.0005281111748805 - 
                        2.364805676582992*^-10*wavelength^2 + 
                        2.9781670902982902*^-6/wavelength^2 + 
                        2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]], 
                     index2 = Sqrt[1.0005281111748805 - 
                        2.364805676582992*^-10*wavelength^2 + 
                        2.9781670902982902*^-6/wavelength^2 + 
                        2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]; index1 = 
                       index; If[Abs[index2 - index1] < 0.01, 
                       alternateindex = 1.5392664079781753 - 
                        0.7232199521975703*wavelength + 
                        1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                3.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = Block[{TempVar, TempVar1, TempVar2, 
                    TempVar3, LocRayL, LocSCx, LocSCy}, TempVar1 = 1.; 
                    TempVar2 = 1.; TempVar3 = 1.; TempVar = 
                     {{-1., 0., 0.}}; LocRayL = 1.; LocSCx = 1.; 
                    LocSCy = 1.; TempVar1 = rx^2 + ry^2 + rz^2; 
                    TempVar2 = rx*xunit + ry*yunit + rz*zunit - 
                      6.5*xunit; TempVar3 = -TempVar1 + TempVar2^2 + 
                      2*rx*6.5; TempVar3 = Re[TempVar3]; 
                    If[N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 25. && Abs[ry + LocRayL*
                        yunit - LocSCx] + Abs[rz + LocRayL*zunit - 
                        LocSCy] + Abs[-6.5 + rx + LocRayL*xunit + Sqrt[
                        42.25 - LocSCx^2 - LocSCy^2]] < 1.*^-7, 
                        {LocRayL, LocSCx, LocSCy}, {-1., 0., 0.}], 
                        {LocRayL, LocSCx, LocSCy} = {-TempVar2 + 
                        TempVar3, ry + (-TempVar2 + TempVar3)*yunit, 
                        rz + (-TempVar2 + TempVar3)*zunit}; If[
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        25. && Abs[ry + LocRayL*yunit - LocSCx] + 
                        Abs[rz + LocRayL*zunit - LocSCy] + Abs[-6.5 + 
                        rx + LocRayL*xunit + Sqrt[42.25 - LocSCx^2 - 
                        LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, LocSCy}, 
                        {-1., 0., 0.}]}; If[TempVar[[1]] == TempVar[[
                        2]], {TempVar[[1]]}, TempVar], {{-1., 0., 
                       0.}}]]; AppendTo[intersections, {-1., 0., 0.}]; 
                 holeQ = False; If[ !(Chop[surfaceid - 100988.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 2., 
                     100988.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 2., 100988.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -3.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., -(ray2/(42.25 - ray2^2 - ray3^2)^
                        2^(-1)), -(ray3/(42.25 - ray2^2 - ray3^2)^
                        2^(-1))}, {ray2/(42.25 - ray2^2 - ray3^2)^
                        2^(-1), 1., 0.}, {ray3/(42.25 - ray2^2 - ray3^2)^
                        2^(-1), 0., 1.}}]; dummymatrix = (#1 & ) /@ 
                      surfnorm; surfnorm = (#1/Sqrt[#1 . #1] & ) /@ 
                      dummymatrix; surfacerotationmatrix = {{1., 0, 0}, 
                      {0, 1., 0}, {0, 0, 1.}}; 
                    surfacetranslationvector = {-3.05, 0, 0}; 
                    activeregion = 1.; completedray = {rsx, rsy, rsz, 
                      rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.5532682085807892 - 
                        1.0054245500487249*wavelength + 
                        1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3], index2 = 
                       1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                0.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = If[Chop[xunit] != 0, 
                   {(If[N[Chop[#1[[1]]]] >= 0. && #1[[2]]^2 + #1[[3]]^
                        2 <= 6.25, {#1[[1]], #1[[2]], #1[[3]]}, 
                       {-1., 0., 0.}] & )[{-(rx/xunit), ry - (rx*yunit)/
                        xunit, rz - (rx*zunit)/xunit}]}, {{-1., 0., 
                     0.}}]; AppendTo[intersections, {-1., 0., 0.}]; 
                 holeQ = False; If[ !(Chop[surfaceid - 100989.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 3., 
                     100989.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 3., 100989.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -0.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {-0.05, 0, 
                      0}; activeregion = 0.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; 
                    allcreatedrays = {{rsx, rsy, rsz, rex, rey, rez, r1, 
                       r2, r3, r4, r5, r6, r7, r8, r9, wavelength, 
                       intensity, intensityscale, ray1, index, 
                       opticallength, phaseshift, componentnumber, 
                       surfacenumber, surfaceid, ray2, ray3, sid, 
                       frontid, sno1, sno2, sno3, sno4, rayslot, 
                       generationnumber, intersectionnumber, pol1, pol2, 
                       pol3}})); {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                0.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = If[Chop[xunit] != 0, 
                   {(If[N[Chop[#1[[1]]]] >= 0. && #1[[2]]^2 + #1[[3]]^
                        2 <= 25., {#1[[1]], #1[[2]], #1[[3]]}, {-1., 0., 
                        0.}] & )[{-(rx/xunit), ry - (rx*yunit)/xunit, 
                      rz - (rx*zunit)/xunit}]}, {{-1., 0., 0.}}]; 
                 AppendTo[intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100990.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]; intersections = 
                  Union[(If[#1[[2]]^2 + #1[[3]]^2 <= 6.25, holeQ = True; 
                       {-1., 0., 0.}, #1] & ) /@ 
                    unfilteredintersections]; If[Length[intersections] > 
                   1, dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 4., 
                     100990.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 4., 100990.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -0.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {-0.05, 0, 
                      0}; activeregion = 0.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; intensity = 
                     0.; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}})); {First[allcreatedrays], 
                   completedray}, reporteddummyrayspresent = True; 
                  {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                    r6, r7, r8, r9, wavelength, intensity, 
                    intensityscale, ray1, index, opticallength, 
                    phaseshift, componentnumber, surfacenumber, 
                    surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                    sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = rex; ry = 
                rey; rz = rez; rx = Chop[rx]; ry = Chop[ry]; rz = 
                Chop[rz]; terminatedeflection = False; intersections = 
                {{-1., 0., 0.}}); If[intensity > thresholdintensity, 
               deflectedrayspresent = True; (intersections = 
                  Block[{surfaceapprox, tempapprox, intersects, LocRayL, 
                    LocSCx, LocSCy}, LocRayL = 1.; LocSCx = 1.; 
                    LocSCy = 1.; surfaceapprox = {{-1., 0., 0.}}; 
                    tempapprox = {{-1., 0., 0.}}; intersects = 
                     {{-1., 0., 0.}}; surfaceapprox = Block[{TempVar, 
                       TempVar1, TempVar2, TempVar3, LocRayL, LocSCx, 
                       LocSCy}, TempVar1 = 1.; TempVar2 = 1.; TempVar3 = 
                        1.; TempVar = {{-1., 0., 0.}}; LocRayL = 1.; 
                       LocSCx = 1.; LocSCy = 1.; TempVar1 = rx^2 + 
                        ry^2 + rz^2; TempVar2 = rx*xunit + ry*yunit + 
                        rz*zunit - 10.2*xunit; TempVar3 = -TempVar1 + 
                        TempVar2^2 + 2*rx*10.2; TempVar3 = Re[TempVar3]; 
                       If[N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[-10.2 + rx + 
                        LocRayL*xunit + Sqrt[104.03999999999999 - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}], {LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 + TempVar3, ry + 
                        (-TempVar2 + TempVar3)*yunit, rz + (-TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[-10.2 + rx + 
                        LocRayL*xunit + Sqrt[104.03999999999999 - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}]}; If[TempVar[[1]] == 
                        TempVar[[2]], {TempVar[[1]]}, TempVar], 
                        {{-1., 0., 0.}}]]; tempapprox = Union[Join[
                       (Take[#1, 3] & ) /@ surfaceapprox, {{-1., 0., 
                        0.}}]]; If[Length[Select[tempapprox, 
                        Chop[First[#1]] <= 0 & ]] != Length[tempapprox], 
                     surfaceapprox = Select[tempapprox, 
                       Chop[First[#1]] > 0 & ], surfaceapprox = 
                      {{-1., 0., 0.}}]; If[surfaceapprox != {{-1., 0., 
                        0.}}, intersects = {{-1., 0., 0.}}; Scan[
                       (AppendTo[intersects, {LocRayL, LocSCx, LocSCy} = 
                        {#1[[1]], #1[[2]], #1[[3]]}; If[Plus @@ Abs[
                        {rx + LocRayL*xunit, ry + LocRayL*yunit, rz + 
                        LocRayL*zunit} - {(0.09803921568627452*(LocSCx^
                        2 + LocSCy^2))/(1 + Sqrt[1 + 
                        0.020488273740868906*(LocSCx^2 + LocSCy^2)]), 
                        LocSCx, LocSCy}] < 1.*^-9, {LocRayL, LocSCx, 
                        LocSCy}, LocRayL = 0.99*LocRayL; Function[{rx, 
                        ry, rz, xunit, yunit, zunit, startpoint}, Block[
                        {values, stepsizes, fvector, success, steps, 
                        denominator}, values = {1.}; stepsizes = {1.}; 
                        fvector = {1.}; success = False; steps = 0; 
                        denominator = 1.; stepsizes = Table[
                        1.0000000000000001*^-7, {3}]; values = 
                        startpoint; While[steps < 50 && (success = True; 
                        (If[Abs[#1] > 1.*^-9, success = False; 1., 
                        1.] & ) /@ stepsizes;  !success), steps = 
                        steps + 1; fvector = {rx + xunit*values[[1]], 
                        ry + yunit*values[[1]], rz + zunit*values[[
                        1]]} - {(0.09803921568627452*(values[[2]]^2 + 
                        values[[3]]^2))/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]), values[[2]], values[[3]]}; 
                        denominator = xunit - yunit*((
                        (0.002008654288320481*values[[2]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1) - zunit*(((0.002008654288320481*
                        values[[3]]*(values[[2]]^2 + values[[3]]^2))/
                        (Sqrt[1 + 0.020488273740868906*(values[[2]]^2 + 
                        values[[3]]^2)]*(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)])^2) - (0.19607843137254904*values[[3]])/
                        (1 + Sqrt[1 + 0.020488273740868906*(values[[2]]^
                        2 + values[[3]]^2)]))*-1); If[Chop[
                        denominator] != 0, denominator, denominator = 
                        1.]; stepsizes = -(#1 . fvector & ) /@ ({{1, 
                        -(((0.002008654288320481*values[[2]]*(values[[
                        2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1), -(((0.002008654288320481*values[[
                        3]]*(values[[2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1)}, {yunit, -xunit - 
                        ((0.002008654288320481*values[[3]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*zunit, ((0.002008654288320481*values[[
                        3]]*(values[[2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*yunit}, {zunit, ((0.002008654288320481*
                        values[[2]]*(values[[2]]^2 + values[[3]]^2))/
                        (Sqrt[1 + 0.020488273740868906*(values[[2]]^2 + 
                        values[[3]]^2)]*(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)])^2) - (0.19607843137254904*values[[2]])/
                        (1 + Sqrt[1 + 0.020488273740868906*(values[[2]]^
                        2 + values[[3]]^2)]))*zunit, -xunit - 
                        ((0.002008654288320481*values[[2]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*yunit}}/denominator); values = 
                        values + stepsizes]; If[steps >= 50, If[First[
                        values] > 0, values = -values; 1., 1.]; 
                        denominator = 1., 1.]; values]][rx, ry, rz, 
                        xunit, yunit, zunit, {LocRayL, LocSCx, 
                        LocSCy}]]]; {-1., 0., 0.}) & , surfaceapprox]; 
                      Union[Re[Select[intersects, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Plus @@ Abs[{rx + LocRayL*
                        xunit, ry + LocRayL*yunit, rz + LocRayL*zunit} - 
                        {(0.09803921568627452*(LocSCx^2 + LocSCy^2))/
                        (1 + Sqrt[1 + 0.020488273740868906*(LocSCx^2 + 
                        LocSCy^2)]), LocSCx, LocSCy}] < 1.*^-9)) & ]]], 
                     {{-1., 0., 0.}}]]; AppendTo[intersections, 
                  {-1., 0., 0.}]; holeQ = False; If[
                   !(Chop[surfaceid - 100991.] == 0. || N[Chop[ray1]] < 
                      0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 5., 
                     100991.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 5., 100991.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = rxhlp; rey = ryhlp; rez = rzhlp; rex = 
                    Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., (0.002008654288320481*ray2^3)/
                        (Sqrt[1. + 0.020488273740868906*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])^2) + (0.002008654288320481*
                        ray2*ray3^2)/(Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)])^2) - 
                        (0.19607843137254904*ray2)/(1. + Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]), 
                        (0.002008654288320481*ray2^2*ray3)/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.002008654288320481*ray3^3)/
                        (Sqrt[1. + 0.020488273740868906*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])^2) - (0.19607843137254904*
                        ray3)/(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])}, {(-0.002008654288320481*
                        ray2*(ray2^2 + ray3^2))/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.19607843137254904*ray2)/
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)]), 1., 0.}, {(-0.002008654288320481*ray3*
                        (ray2^2 + ray3^2))/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.19607843137254904*ray3)/
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)]), 0., 1.}}]; If[surfnorm[[1]] == 
                       {0., 0., 0.} || surfnorm[[2]] == {0., 0., 0.} || 
                      surfnorm[[3]] == {0., 0., 0.}, surfnorm = 
                       1.*Re[{{1., (0.002008654288320481*(1.*^-6 + ray2)^
                        3)/(Sqrt[1. + 0.020488273740868906*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.002008654288320481*
                        (1.*^-6 + ray2)*(1.*^-6 + ray3)^2)/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.19607843137254904*
                        (1.*^-6 + ray2))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), (0.002008654288320481*
                        (1.*^-6 + ray2)^2*(1.*^-6 + ray3))/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.002008654288320481*
                        (1.*^-6 + ray3)^3)/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.19607843137254904*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])}, {(-0.002008654288320481*
                        (1.*^-6 + ray2)*((1.*^-6 + ray2)^2 + (1.*^-6 + 
                        ray3)^2))/(Sqrt[1. + 0.020488273740868906*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) + 
                        (0.19607843137254904*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. + 0.020488273740868906*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 1., 0.}, 
                        {(-0.002008654288320481*(1.*^-6 + ray3)*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2))/
                        (Sqrt[1. + 0.020488273740868906*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.19607843137254904*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1, 0, 0}, {0, 1, 0}, 
                      {0, 0, 1}}; surfacetranslationvector = {0, 0, 0}; 
                    activeregion = 1.; completedray = {rsx, rsy, rsz, 
                      rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.6765916828635454 - 
                        1.1701284013462314*wavelength + 
                        1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3], index2 = 
                       1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                -4. + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = Block[{surfaceapprox, tempapprox, 
                    intersects, LocRayL, LocSCx, LocSCy}, LocRayL = 1.; 
                    LocSCx = 1.; LocSCy = 1.; surfaceapprox = 
                     {{-1., 0., 0.}}; tempapprox = {{-1., 0., 0.}}; 
                    intersects = {{-1., 0., 0.}}; surfaceapprox = 
                     Block[{TempVar, TempVar1, TempVar2, TempVar3, 
                       LocRayL, LocSCx, LocSCy}, TempVar1 = 1.; 
                       TempVar2 = 1.; TempVar3 = 1.; TempVar = 
                        {{-1., 0., 0.}}; LocRayL = 1.; LocSCx = 1.; 
                       LocSCy = 1.; TempVar1 = rx^2 + ry^2 + rz^2; 
                       TempVar2 = rx*xunit + ry*yunit + rz*zunit - 
                        -6.*xunit; TempVar3 = -TempVar1 + TempVar2^2 + 
                        2*rx*-6.; TempVar3 = Re[TempVar3]; If[
                        N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[6. + rx + LocRayL*
                        xunit - Sqrt[36. - LocSCx^2 - LocSCy^2]] < 
                        1.*^-7, {LocRayL, LocSCx, LocSCy}, {-1., 0., 
                        0.}], {LocRayL, LocSCx, LocSCy} = {-TempVar2 + 
                        TempVar3, ry + (-TempVar2 + TempVar3)*yunit, 
                        rz + (-TempVar2 + TempVar3)*zunit}; If[
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Abs[ry + LocRayL*yunit - 
                        LocSCx] + Abs[rz + LocRayL*zunit - LocSCy] + 
                        Abs[6. + rx + LocRayL*xunit - Sqrt[36. - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}]}; If[TempVar[[1]] == 
                        TempVar[[2]], {TempVar[[1]]}, TempVar], 
                        {{-1., 0., 0.}}]]; tempapprox = Union[Join[
                       (Take[#1, 3] & ) /@ surfaceapprox, {{-1., 0., 
                        0.}}]]; If[Length[Select[tempapprox, 
                        Chop[First[#1]] <= 0 & ]] != Length[tempapprox], 
                     surfaceapprox = Select[tempapprox, 
                       Chop[First[#1]] > 0 & ], surfaceapprox = 
                      {{-1., 0., 0.}}]; If[surfaceapprox != {{-1., 0., 
                        0.}}, intersects = {{-1., 0., 0.}}; Scan[
                       (AppendTo[intersects, {LocRayL, LocSCx, LocSCy} = 
                        {#1[[1]], #1[[2]], #1[[3]]}; If[Plus @@ Abs[
                        {rx + LocRayL*xunit, ry + LocRayL*yunit, rz + 
                        LocRayL*zunit} - {(-0.16666666666666666*(LocSCx^
                        2 + LocSCy^2))/(1 + Sqrt[Plus[1]]), LocSCx, 
                        LocSCy}] < 1.*^-9, {LocRayL, LocSCx, LocSCy}, 
                        LocRayL = 0.99*LocRayL; Function[{rx, ry, rz, 
                        xunit, yunit, zunit, startpoint}, Block[{values, 
                        stepsizes, fvector, success, steps, 
                        denominator}, values = {1.}; stepsizes = {1.}; 
                        fvector = {1.}; success = False; steps = 0; 
                        denominator = 1.; stepsizes = Table[
                        1.0000000000000001*^-7, {3}]; values = 
                        startpoint; While[steps < 50 && (success = True; 
                        (If[Abs[#1] > 1.*^-9, success = False; 1., 
                        1.] & ) /@ stepsizes;  !success), steps = 
                        steps + 1; fvector = {rx + xunit*values[[1]], 
                        ry + yunit*values[[1]], rz + zunit*values[[
                        1]]} - {(-0.16666666666666666*(values[[2]]^2 + 
                        values[[3]]^2))/(1 + Sqrt[Plus[1]]), values[[
                        2]], values[[3]]}; denominator = xunit - yunit*
                        ((Plus[(0.3333333333333333*values[[2]])/(1 + 
                        Sqrt[Plus[1]])])*-1) - zunit*((Plus[
                        (0.3333333333333333*values[[3]])/(1 + Sqrt[Plus[
                        1]])])*-1); If[Chop[denominator] != 0, 
                        denominator, denominator = 1.]; stepsizes = 
                        -(#1 . fvector & ) /@ ({{1, -((Plus[
                        (0.3333333333333333*values[[2]])/(1 + Sqrt[Plus[
                        1]])])*-1), -((Plus[(0.3333333333333333*values[[
                        3]])/(1 + Sqrt[Plus[1]])])*-1)}, {yunit, 
                        -xunit - (Plus[(0.3333333333333333*values[[3]])/
                        (1 + Sqrt[Plus[1]])])*zunit, (Plus[
                        (0.3333333333333333*values[[3]])/(1 + Sqrt[Plus[
                        1]])])*yunit}, {zunit, (Plus[(0.3333333333333333*
                        values[[2]])/(1 + Sqrt[Plus[1]])])*zunit, 
                        -xunit - (Plus[(0.3333333333333333*values[[2]])/
                        (1 + Sqrt[Plus[1]])])*yunit}}/denominator); 
                        values = values + stepsizes]; If[steps >= 50, 
                        If[First[values] > 0, values = -values; 1., 1.]; 
                        denominator = 1., 1.]; values]][rx, ry, rz, 
                        xunit, yunit, zunit, {LocRayL, LocSCx, 
                        LocSCy}]]]; {-1., 0., 0.}) & , surfaceapprox]; 
                      Union[Re[Select[intersects, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Plus @@ Abs[{rx + LocRayL*
                        xunit, ry + LocRayL*yunit, rz + LocRayL*zunit} - 
                        {(-0.16666666666666666*(LocSCx^2 + LocSCy^2))/
                        (1 + Sqrt[Plus[1]]), LocSCx, LocSCy}] < 
                        1.*^-9)) & ]]], {{-1., 0., 0.}}]]; AppendTo[
                  intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100992.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 6., 
                     100992.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 6., 100992.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = 4. + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., Plus[(0.3333333333333333*ray2)/(1. + 
                        Sqrt[Plus[1.]])], Plus[(0.3333333333333333*ray3)/
                        (1. + Sqrt[Plus[1.]])]}, {Plus[
                        (-0.3333333333333333*ray2)/(1. + Sqrt[Plus[
                        1.]])], 1., 0.}, {Plus[(-0.3333333333333333*
                        ray3)/(1. + Sqrt[Plus[1.]])], 0., 1.}}]; 
                    If[surfnorm[[1]] == {0., 0., 0.} || surfnorm[[2]] == 
                       {0., 0., 0.} || surfnorm[[3]] == {0., 0., 0.}, 
                     surfnorm = 1.*Re[{{1., Plus[(0.3333333333333333*
                        (1.*^-6 + ray2))/(1. + Sqrt[Plus[1.]])], Plus[
                        (0.3333333333333333*(1.*^-6 + ray3))/(1. + 
                        Sqrt[Plus[1.]])]}, {Plus[(-0.3333333333333333*
                        (1.*^-6 + ray2))/(1. + Sqrt[Plus[1.]])], 1., 
                        0.}, {Plus[(-0.3333333333333333*(1.*^-6 + ray3))/
                        (1. + Sqrt[Plus[1.]])], 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {4., 0, 
                      0}; activeregion = 1.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; ZAxis = 
                     First[surfnorm]*Sign[First[surfnorm] . {r1, r2, 
                        r3}]; raytiltz = ZAxis . {r1, r2, r3}; 
                    raytiltx = 1 - raytiltz^2; If[raytiltx < 
                      2.220446049250313*^-16, raytiltx = 0., raytiltx = 
                      Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - ZAxis*
                       raytiltz; If[Abs[raytiltx] < 1.*^-7, XAxis = 
                      surfnorm[[2]], XAxis = XAxis/raytiltx]; YAxis = 
                     {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*XAxis[[3]], 
                      ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*XAxis[[3]], 
                      -(ZAxis[[2]]*XAxis[[1]]) + ZAxis[[1]]*XAxis[[2]]}; 
                    YAxis = YAxis/Sqrt[YAxis . YAxis]; PAxis = 
                     ZAxis*{r1, r2, r3} . XAxis - XAxis*{r1, r2, r3} . 
                        ZAxis; PAxis = PAxis/Sqrt[PAxis . PAxis]; 
                    normalizedpolarization = {pol1, pol2, pol3}[[
                      {1, 2}]]; normalizedpolarization = 
                     normalizedpolarization/Sqrt[
                       normalizedpolarization . normalizedpolarization]; 
                    allcreatedamplitudes = {{I*0., I*0., I*0.}}; 
                    amplitude = Sqrt[intensity]*(normalizedpolarization[[
                        1]]*{r4, r5, r6} + normalizedpolarization[[2]]*
                        {r7, r8, r9}*Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.499266407978439 - 
                        0.7232199521991957*wavelength + 
                        1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3], index2 = 
                       1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.499266407978439 - 0.7232199521991957*
                        wavelength + 1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.499266407978439 - 0.7232199521991957*
                        wavelength + 1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                -20.3203 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = Block[{TempVar, TempVar1, TempVar2, 
                    TempVar3, LocRayL, LocSCx, LocSCy}, TempVar1 = 1.; 
                    TempVar2 = 1.; TempVar3 = 1.; TempVar = 
                     {{-1., 0., 0.}}; LocRayL = 1.; LocSCx = 1.; 
                    LocSCy = 1.; TempVar1 = rx^2 + ry^2 + rz^2; 
                    TempVar2 = rx*xunit + ry*yunit + rz*zunit - 
                      -12*xunit; TempVar3 = -TempVar1 + TempVar2^2 + 
                      2*rx*-12; TempVar3 = Re[TempVar3]; 
                    If[N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 142.80249999999998 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[12 + rx + LocRayL*
                        xunit - Sqrt[144 - LocSCx^2 - LocSCy^2]] < 
                        1.*^-7, {LocRayL, LocSCx, LocSCy}, {-1., 0., 
                        0.}], {LocRayL, LocSCx, LocSCy} = {-TempVar2 + 
                        TempVar3, ry + (-TempVar2 + TempVar3)*yunit, 
                        rz + (-TempVar2 + TempVar3)*zunit}; If[
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        142.80249999999998 && Abs[ry + LocRayL*yunit - 
                        LocSCx] + Abs[rz + LocRayL*zunit - LocSCy] + 
                        Abs[12 + rx + LocRayL*xunit - Sqrt[144 - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}]}; If[TempVar[[1]] == 
                        TempVar[[2]], {TempVar[[1]]}, TempVar], 
                     {{-1., 0., 0.}}]]; AppendTo[intersections, 
                  {-1., 0., 0.}]; holeQ = False; If[
                   !(Chop[surfaceid - 100993.] == 0. || N[Chop[ray1]] < 
                      0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 7., 
                     100993.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 7., 100993.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = 20.3203 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., -(-(ray2/(144 - ray2^2 - ray3^2)^
                        2^(-1))), -(-(ray3/(144 - ray2^2 - ray3^2)^
                        2^(-1)))}, {-(ray2/(144 - ray2^2 - ray3^2)^
                        2^(-1)), 1., 0.}, {-(ray3/(144 - ray2^2 - 
                        ray3^2)^2^(-1)), 0., 1.}}]; dummymatrix = 
                     (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {20.3203, 
                      0, 0}; activeregion = 0.; completedray = 
                     {rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                      r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; 
                    componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; intensity = 0.; allcreatedrays = 
                     {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                       r6, r7, r8, r9, wavelength, intensity, 
                       intensityscale, ray1, index, opticallength, 
                       phaseshift, componentnumber, surfacenumber, 
                       surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                       sno3, sno4, rayslot, generationnumber, 
                       intersectionnumber, pol1, pol2, pol3}})); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                -4. + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = Block[{surfaceapprox, tempapprox, 
                    intersects, LocRayL, LocSCx, LocSCy}, LocRayL = 1.; 
                    LocSCx = 1.; LocSCy = 1.; surfaceapprox = 
                     {{-1., 0., 0.}}; tempapprox = {{-1., 0., 0.}}; 
                    intersects = {{-1., 0., 0.}}; surfaceapprox = 
                     Block[{TempVar, TempVar1, TempVar2, TempVar3, 
                       LocRayL, LocSCx, LocSCy}, TempVar1 = 1.; 
                       TempVar2 = 1.; TempVar3 = 1.; TempVar = 
                        {{-1., 0., 0.}}; LocRayL = 1.; LocSCx = 1.; 
                       LocSCy = 1.; TempVar1 = rx^2 + ry^2 + rz^2; 
                       TempVar2 = rx*xunit + ry*yunit + rz*zunit - 
                        -6.*xunit; TempVar3 = -TempVar1 + TempVar2^2 + 
                        2*rx*-6.; TempVar3 = Re[TempVar3]; If[
                        N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[6. + rx + LocRayL*
                        xunit - Sqrt[36. - LocSCx^2 - LocSCy^2]] < 
                        1.*^-7, {LocRayL, LocSCx, LocSCy}, {-1., 0., 
                        0.}], {LocRayL, LocSCx, LocSCy} = {-TempVar2 + 
                        TempVar3, ry + (-TempVar2 + TempVar3)*yunit, 
                        rz + (-TempVar2 + TempVar3)*zunit}; If[
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Abs[ry + LocRayL*yunit - 
                        LocSCx] + Abs[rz + LocRayL*zunit - LocSCy] + 
                        Abs[6. + rx + LocRayL*xunit - Sqrt[36. - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}]}; If[TempVar[[1]] == 
                        TempVar[[2]], {TempVar[[1]]}, TempVar], 
                        {{-1., 0., 0.}}]]; tempapprox = Union[Join[
                       (Take[#1, 3] & ) /@ surfaceapprox, {{-1., 0., 
                        0.}}]]; If[Length[Select[tempapprox, 
                        Chop[First[#1]] <= 0 & ]] != Length[tempapprox], 
                     surfaceapprox = Select[tempapprox, 
                       Chop[First[#1]] > 0 & ], surfaceapprox = 
                      {{-1., 0., 0.}}]; If[surfaceapprox != {{-1., 0., 
                        0.}}, intersects = {{-1., 0., 0.}}; Scan[
                       (AppendTo[intersects, {LocRayL, LocSCx, LocSCy} = 
                        {#1[[1]], #1[[2]], #1[[3]]}; If[Plus @@ Abs[
                        {rx + LocRayL*xunit, ry + LocRayL*yunit, rz + 
                        LocRayL*zunit} - {(-0.16666666666666666*(LocSCx^
                        2 + LocSCy^2))/(1 + Sqrt[Plus[1]]), LocSCx, 
                        LocSCy}] < 1.*^-9, {LocRayL, LocSCx, LocSCy}, 
                        LocRayL = 0.99*LocRayL; Function[{rx, ry, rz, 
                        xunit, yunit, zunit, startpoint}, Block[{values, 
                        stepsizes, fvector, success, steps, 
                        denominator}, values = {1.}; stepsizes = {1.}; 
                        fvector = {1.}; success = False; steps = 0; 
                        denominator = 1.; stepsizes = Table[
                        1.0000000000000001*^-7, {3}]; values = 
                        startpoint; While[steps < 50 && (success = True; 
                        (If[Abs[#1] > 1.*^-9, success = False; 1., 
                        1.] & ) /@ stepsizes;  !success), steps = 
                        steps + 1; fvector = {rx + xunit*values[[1]], 
                        ry + yunit*values[[1]], rz + zunit*values[[
                        1]]} - {(-0.16666666666666666*(values[[2]]^2 + 
                        values[[3]]^2))/(1 + Sqrt[Plus[1]]), values[[
                        2]], values[[3]]}; denominator = xunit - yunit*
                        ((Plus[(0.3333333333333333*values[[2]])/(1 + 
                        Sqrt[Plus[1]])])*-1) - zunit*((Plus[
                        (0.3333333333333333*values[[3]])/(1 + Sqrt[Plus[
                        1]])])*-1); If[Chop[denominator] != 0, 
                        denominator, denominator = 1.]; stepsizes = 
                        -(#1 . fvector & ) /@ ({{1, -((Plus[
                        (0.3333333333333333*values[[2]])/(1 + Sqrt[Plus[
                        1]])])*-1), -((Plus[(0.3333333333333333*values[[
                        3]])/(1 + Sqrt[Plus[1]])])*-1)}, {yunit, 
                        -xunit - (Plus[(0.3333333333333333*values[[3]])/
                        (1 + Sqrt[Plus[1]])])*zunit, (Plus[
                        (0.3333333333333333*values[[3]])/(1 + Sqrt[Plus[
                        1]])])*yunit}, {zunit, (Plus[(0.3333333333333333*
                        values[[2]])/(1 + Sqrt[Plus[1]])])*zunit, 
                        -xunit - (Plus[(0.3333333333333333*values[[2]])/
                        (1 + Sqrt[Plus[1]])])*yunit}}/denominator); 
                        values = values + stepsizes]; If[steps >= 50, 
                        If[First[values] > 0, values = -values; 1., 1.]; 
                        denominator = 1., 1.]; values]][rx, ry, rz, 
                        xunit, yunit, zunit, {LocRayL, LocSCx, 
                        LocSCy}]]]; {-1., 0., 0.}) & , surfaceapprox]; 
                      Union[Re[Select[intersects, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Plus @@ Abs[{rx + LocRayL*
                        xunit, ry + LocRayL*yunit, rz + LocRayL*zunit} - 
                        {(-0.16666666666666666*(LocSCx^2 + LocSCy^2))/
                        (1 + Sqrt[Plus[1]]), LocSCx, LocSCy}] < 
                        1.*^-9)) & ]]], {{-1., 0., 0.}}]]; AppendTo[
                  intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100994.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 8., 
                     100994.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 8., 100994.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = 4. + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., Plus[(0.3333333333333333*ray2)/(1. + 
                        Sqrt[Plus[1.]])], Plus[(0.3333333333333333*ray3)/
                        (1. + Sqrt[Plus[1.]])]}, {Plus[
                        (-0.3333333333333333*ray2)/(1. + Sqrt[Plus[
                        1.]])], 1., 0.}, {Plus[(-0.3333333333333333*
                        ray3)/(1. + Sqrt[Plus[1.]])], 0., 1.}}]; 
                    If[surfnorm[[1]] == {0., 0., 0.} || surfnorm[[2]] == 
                       {0., 0., 0.} || surfnorm[[3]] == {0., 0., 0.}, 
                     surfnorm = 1.*Re[{{1., Plus[(0.3333333333333333*
                        (1.*^-6 + ray2))/(1. + Sqrt[Plus[1.]])], Plus[
                        (0.3333333333333333*(1.*^-6 + ray3))/(1. + 
                        Sqrt[Plus[1.]])]}, {Plus[(-0.3333333333333333*
                        (1.*^-6 + ray2))/(1. + Sqrt[Plus[1.]])], 1., 
                        0.}, {Plus[(-0.3333333333333333*(1.*^-6 + ray3))/
                        (1. + Sqrt[Plus[1.]])], 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {4., 0, 
                      0}; activeregion = 1.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; ZAxis = 
                     First[surfnorm]*Sign[First[surfnorm] . {r1, r2, 
                        r3}]; raytiltz = ZAxis . {r1, r2, r3}; 
                    raytiltx = 1 - raytiltz^2; If[raytiltx < 
                      2.220446049250313*^-16, raytiltx = 0., raytiltx = 
                      Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - ZAxis*
                       raytiltz; If[Abs[raytiltx] < 1.*^-7, XAxis = 
                      surfnorm[[2]], XAxis = XAxis/raytiltx]; YAxis = 
                     {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*XAxis[[3]], 
                      ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*XAxis[[3]], 
                      -(ZAxis[[2]]*XAxis[[1]]) + ZAxis[[1]]*XAxis[[2]]}; 
                    YAxis = YAxis/Sqrt[YAxis . YAxis]; PAxis = 
                     ZAxis*{r1, r2, r3} . XAxis - XAxis*{r1, r2, r3} . 
                        ZAxis; PAxis = PAxis/Sqrt[PAxis . PAxis]; 
                    normalizedpolarization = {pol1, pol2, pol3}[[
                      {1, 2}]]; normalizedpolarization = 
                     normalizedpolarization/Sqrt[
                       normalizedpolarization . normalizedpolarization]; 
                    allcreatedamplitudes = {{I*0., I*0., I*0.}}; 
                    amplitude = Sqrt[intensity]*(normalizedpolarization[[
                        1]]*{r4, r5, r6} + normalizedpolarization[[2]]*
                        {r7, r8, r9}*Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.499266407978439 - 
                        0.7232199521991957*wavelength + 
                        1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3], index2 = 
                       1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.499266407978439 - 0.7232199521991957*
                        wavelength + 1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.499266407978439 - 0.7232199521991957*
                        wavelength + 1.0984449372252627*wavelength^2 - 
                        0.5792106405003761*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = rex; ry = 
                rey; rz = rez; rx = Chop[rx]; ry = Chop[ry]; rz = 
                Chop[rz]; terminatedeflection = False; intersections = 
                {{-1., 0., 0.}}); If[intensity > thresholdintensity, 
               deflectedrayspresent = True; (intersections = 
                  Block[{surfaceapprox, tempapprox, intersects, LocRayL, 
                    LocSCx, LocSCy}, LocRayL = 1.; LocSCx = 1.; 
                    LocSCy = 1.; surfaceapprox = {{-1., 0., 0.}}; 
                    tempapprox = {{-1., 0., 0.}}; intersects = 
                     {{-1., 0., 0.}}; surfaceapprox = Block[{TempVar, 
                       TempVar1, TempVar2, TempVar3, LocRayL, LocSCx, 
                       LocSCy}, TempVar1 = 1.; TempVar2 = 1.; TempVar3 = 
                        1.; TempVar = {{-1., 0., 0.}}; LocRayL = 1.; 
                       LocSCx = 1.; LocSCy = 1.; TempVar1 = rx^2 + 
                        ry^2 + rz^2; TempVar2 = rx*xunit + ry*yunit + 
                        rz*zunit - 10.2*xunit; TempVar3 = -TempVar1 + 
                        TempVar2^2 + 2*rx*10.2; TempVar3 = Re[TempVar3]; 
                       If[N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[-10.2 + rx + 
                        LocRayL*xunit + Sqrt[104.03999999999999 - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}], {LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 + TempVar3, ry + 
                        (-TempVar2 + TempVar3)*yunit, rz + (-TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 31.922500000000003 && 
                        Abs[ry + LocRayL*yunit - LocSCx] + Abs[rz + 
                        LocRayL*zunit - LocSCy] + Abs[-10.2 + rx + 
                        LocRayL*xunit + Sqrt[104.03999999999999 - LocSCx^
                        2 - LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, 
                        LocSCy}, {-1., 0., 0.}]}; If[TempVar[[1]] == 
                        TempVar[[2]], {TempVar[[1]]}, TempVar], 
                        {{-1., 0., 0.}}]]; tempapprox = Union[Join[
                       (Take[#1, 3] & ) /@ surfaceapprox, {{-1., 0., 
                        0.}}]]; If[Length[Select[tempapprox, 
                        Chop[First[#1]] <= 0 & ]] != Length[tempapprox], 
                     surfaceapprox = Select[tempapprox, 
                       Chop[First[#1]] > 0 & ], surfaceapprox = 
                      {{-1., 0., 0.}}]; If[surfaceapprox != {{-1., 0., 
                        0.}}, intersects = {{-1., 0., 0.}}; Scan[
                       (AppendTo[intersects, {LocRayL, LocSCx, LocSCy} = 
                        {#1[[1]], #1[[2]], #1[[3]]}; If[Plus @@ Abs[
                        {rx + LocRayL*xunit, ry + LocRayL*yunit, rz + 
                        LocRayL*zunit} - {(0.09803921568627452*(LocSCx^
                        2 + LocSCy^2))/(1 + Sqrt[1 + 
                        0.020488273740868906*(LocSCx^2 + LocSCy^2)]), 
                        LocSCx, LocSCy}] < 1.*^-9, {LocRayL, LocSCx, 
                        LocSCy}, LocRayL = 0.99*LocRayL; Function[{rx, 
                        ry, rz, xunit, yunit, zunit, startpoint}, Block[
                        {values, stepsizes, fvector, success, steps, 
                        denominator}, values = {1.}; stepsizes = {1.}; 
                        fvector = {1.}; success = False; steps = 0; 
                        denominator = 1.; stepsizes = Table[
                        1.0000000000000001*^-7, {3}]; values = 
                        startpoint; While[steps < 50 && (success = True; 
                        (If[Abs[#1] > 1.*^-9, success = False; 1., 
                        1.] & ) /@ stepsizes;  !success), steps = 
                        steps + 1; fvector = {rx + xunit*values[[1]], 
                        ry + yunit*values[[1]], rz + zunit*values[[
                        1]]} - {(0.09803921568627452*(values[[2]]^2 + 
                        values[[3]]^2))/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]), values[[2]], values[[3]]}; 
                        denominator = xunit - yunit*((
                        (0.002008654288320481*values[[2]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1) - zunit*(((0.002008654288320481*
                        values[[3]]*(values[[2]]^2 + values[[3]]^2))/
                        (Sqrt[1 + 0.020488273740868906*(values[[2]]^2 + 
                        values[[3]]^2)]*(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)])^2) - (0.19607843137254904*values[[3]])/
                        (1 + Sqrt[1 + 0.020488273740868906*(values[[2]]^
                        2 + values[[3]]^2)]))*-1); If[Chop[
                        denominator] != 0, denominator, denominator = 
                        1.]; stepsizes = -(#1 . fvector & ) /@ ({{1, 
                        -(((0.002008654288320481*values[[2]]*(values[[
                        2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1), -(((0.002008654288320481*values[[
                        3]]*(values[[2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*-1)}, {yunit, -xunit - 
                        ((0.002008654288320481*values[[3]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*zunit, ((0.002008654288320481*values[[
                        3]]*(values[[2]]^2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[3]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*yunit}, {zunit, ((0.002008654288320481*
                        values[[2]]*(values[[2]]^2 + values[[3]]^2))/
                        (Sqrt[1 + 0.020488273740868906*(values[[2]]^2 + 
                        values[[3]]^2)]*(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)])^2) - (0.19607843137254904*values[[2]])/
                        (1 + Sqrt[1 + 0.020488273740868906*(values[[2]]^
                        2 + values[[3]]^2)]))*zunit, -xunit - 
                        ((0.002008654288320481*values[[2]]*(values[[2]]^
                        2 + values[[3]]^2))/(Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]*(1 + Sqrt[1 + 0.020488273740868906*
                        (values[[2]]^2 + values[[3]]^2)])^2) - 
                        (0.19607843137254904*values[[2]])/(1 + Sqrt[1 + 
                        0.020488273740868906*(values[[2]]^2 + values[[
                        3]]^2)]))*yunit}}/denominator); values = 
                        values + stepsizes]; If[steps >= 50, If[First[
                        values] > 0, values = -values; 1., 1.]; 
                        denominator = 1., 1.]; values]][rx, ry, rz, 
                        xunit, yunit, zunit, {LocRayL, LocSCx, 
                        LocSCy}]]]; {-1., 0., 0.}) & , surfaceapprox]; 
                      Union[Re[Select[intersects, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        31.922500000000003 && Plus @@ Abs[{rx + LocRayL*
                        xunit, ry + LocRayL*yunit, rz + LocRayL*zunit} - 
                        {(0.09803921568627452*(LocSCx^2 + LocSCy^2))/
                        (1 + Sqrt[1 + 0.020488273740868906*(LocSCx^2 + 
                        LocSCy^2)]), LocSCx, LocSCy}] < 1.*^-9)) & ]]], 
                     {{-1., 0., 0.}}]]; AppendTo[intersections, 
                  {-1., 0., 0.}]; holeQ = False; If[
                   !(Chop[surfaceid - 100995.] == 0. || N[Chop[ray1]] < 
                      0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 9., 
                     100995.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 9., 100995.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = rxhlp; rey = ryhlp; rez = rzhlp; rex = 
                    Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., (0.002008654288320481*ray2^3)/
                        (Sqrt[1. + 0.020488273740868906*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])^2) + (0.002008654288320481*
                        ray2*ray3^2)/(Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)])^2) - 
                        (0.19607843137254904*ray2)/(1. + Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]), 
                        (0.002008654288320481*ray2^2*ray3)/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.002008654288320481*ray3^3)/
                        (Sqrt[1. + 0.020488273740868906*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])^2) - (0.19607843137254904*
                        ray3)/(1. + Sqrt[1. + 0.020488273740868906*
                        (ray2^2 + ray3^2)])}, {(-0.002008654288320481*
                        ray2*(ray2^2 + ray3^2))/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.19607843137254904*ray2)/
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)]), 1., 0.}, {(-0.002008654288320481*ray3*
                        (ray2^2 + ray3^2))/(Sqrt[1. + 
                        0.020488273740868906*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)])^2) + (0.19607843137254904*ray3)/
                        (1. + Sqrt[1. + 0.020488273740868906*(ray2^2 + 
                        ray3^2)]), 0., 1.}}]; If[surfnorm[[1]] == 
                       {0., 0., 0.} || surfnorm[[2]] == {0., 0., 0.} || 
                      surfnorm[[3]] == {0., 0., 0.}, surfnorm = 
                       1.*Re[{{1., (0.002008654288320481*(1.*^-6 + ray2)^
                        3)/(Sqrt[1. + 0.020488273740868906*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.002008654288320481*
                        (1.*^-6 + ray2)*(1.*^-6 + ray3)^2)/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.19607843137254904*
                        (1.*^-6 + ray2))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), (0.002008654288320481*
                        (1.*^-6 + ray2)^2*(1.*^-6 + ray3))/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.002008654288320481*
                        (1.*^-6 + ray3)^3)/(Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.19607843137254904*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])}, {(-0.002008654288320481*
                        (1.*^-6 + ray2)*((1.*^-6 + ray2)^2 + (1.*^-6 + 
                        ray3)^2))/(Sqrt[1. + 0.020488273740868906*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. + 0.020488273740868906*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) + 
                        (0.19607843137254904*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. + 0.020488273740868906*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 1., 0.}, 
                        {(-0.002008654288320481*(1.*^-6 + ray3)*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2))/
                        (Sqrt[1. + 0.020488273740868906*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.19607843137254904*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. + 
                        0.020488273740868906*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1, 0, 0}, {0, 1, 0}, 
                      {0, 0, 1}}; surfacetranslationvector = {0, 0, 0}; 
                    activeregion = 1.; completedray = {rsx, rsy, rsz, 
                      rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.6765916828635454 - 
                        1.1701284013462314*wavelength + 
                        1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3], index2 = 
                       1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.6765916828635454 - 1.1701284013462314*
                        wavelength + 1.8245302544520878*wavelength^2 - 
                        0.9804493049132843*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                0.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = If[Chop[xunit] != 0, 
                   {(If[N[Chop[#1[[1]]]] >= 0. && #1[[2]]^2 + #1[[3]]^
                        2 <= 6.25, {#1[[1]], #1[[2]], #1[[3]]}, 
                       {-1., 0., 0.}] & )[{-(rx/xunit), ry - (rx*yunit)/
                        xunit, rz - (rx*zunit)/xunit}]}, {{-1., 0., 
                     0.}}]; AppendTo[intersections, {-1., 0., 0.}]; 
                 holeQ = False; If[ !(Chop[surfaceid - 100996.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 10., 
                     100996.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 10., 100996.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -0.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {-0.05, 0, 
                      0}; activeregion = 0.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; 
                    allcreatedrays = {{rsx, rsy, rsz, rex, rey, rez, r1, 
                       r2, r3, r4, r5, r6, r7, r8, r9, wavelength, 
                       intensity, intensityscale, ray1, index, 
                       opticallength, phaseshift, componentnumber, 
                       surfacenumber, surfaceid, ray2, ray3, sid, 
                       frontid, sno1, sno2, sno3, sno4, rayslot, 
                       generationnumber, intersectionnumber, pol1, pol2, 
                       pol3}})); {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                0.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = If[Chop[xunit] != 0, 
                   {(If[N[Chop[#1[[1]]]] >= 0. && #1[[2]]^2 + #1[[3]]^
                        2 <= 25., {#1[[1]], #1[[2]], #1[[3]]}, {-1., 0., 
                        0.}] & )[{-(rx/xunit), ry - (rx*yunit)/xunit, 
                      rz - (rx*zunit)/xunit}]}, {{-1., 0., 0.}}]; 
                 AppendTo[intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100997.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]; intersections = 
                  Union[(If[#1[[2]]^2 + #1[[3]]^2 <= 6.25, holeQ = True; 
                       {-1., 0., 0.}, #1] & ) /@ 
                    unfilteredintersections]; If[Length[intersections] > 
                   1, dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 11., 
                     100997.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 11., 100997.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -0.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = {-0.05, 0, 
                      0}; activeregion = 0.; completedray = {rsx, rsy, 
                      rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, 
                      r8, r9, wavelength, intensity, intensityscale, 
                      ray1, index, opticallength, phaseshift, 
                      componentnumber, surfacenumber, surfaceid, ray2, 
                      ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                      rayslot, generationnumber, intersectionnumber, 
                      pol1, pol2, pol3}; componentnumber = 
                     newcomponentnumber; surfacenumber = 
                     newsurfacenumber; surfaceid = newsurfaceid; 
                    originalray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                      r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                      intensityscale, ray1, index, opticallength, 
                      phaseshift, componentnumber, surfacenumber, 
                      surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                      sno3, sno4, rayslot, generationnumber, 
                      intersectionnumber, pol1, pol2, pol3}; intensity = 
                     0.; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}})); {First[allcreatedrays], 
                   completedray}, reporteddummyrayspresent = True; 
                  {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                    r6, r7, r8, r9, wavelength, intensity, 
                    intensityscale, ray1, index, opticallength, 
                    phaseshift, componentnumber, surfacenumber, 
                    surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                    sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                3.05 + rex; ry = rey; rz = rez; rx = Chop[rx]; ry = 
                Chop[ry]; rz = Chop[rz]; terminatedeflection = False; 
               intersections = {{-1., 0., 0.}}); If[intensity > 
                thresholdintensity, deflectedrayspresent = True; 
                (intersections = Block[{TempVar, TempVar1, TempVar2, 
                    TempVar3, LocRayL, LocSCx, LocSCy}, TempVar1 = 1.; 
                    TempVar2 = 1.; TempVar3 = 1.; TempVar = 
                     {{-1., 0., 0.}}; LocRayL = 1.; LocSCx = 1.; 
                    LocSCy = 1.; TempVar1 = rx^2 + ry^2 + rz^2; 
                    TempVar2 = rx*xunit + ry*yunit + rz*zunit - 
                      6.5*xunit; TempVar3 = -TempVar1 + TempVar2^2 + 
                      2*rx*6.5; TempVar3 = Re[TempVar3]; 
                    If[N[Chop[TempVar3]] >= 0., TempVar3 = Sqrt[
                        TempVar3]; TempVar = {{LocRayL, LocSCx, 
                        LocSCy} = {-TempVar2 - TempVar3, ry - 
                        (TempVar2 + TempVar3)*yunit, rz - (TempVar2 + 
                        TempVar3)*zunit}; If[N[Chop[LocRayL]] >= 0. && 
                        LocSCx^2 + LocSCy^2 <= 25. && Abs[ry + LocRayL*
                        yunit - LocSCx] + Abs[rz + LocRayL*zunit - 
                        LocSCy] + Abs[-6.5 + rx + LocRayL*xunit + Sqrt[
                        42.25 - LocSCx^2 - LocSCy^2]] < 1.*^-7, 
                        {LocRayL, LocSCx, LocSCy}, {-1., 0., 0.}], 
                        {LocRayL, LocSCx, LocSCy} = {-TempVar2 + 
                        TempVar3, ry + (-TempVar2 + TempVar3)*yunit, 
                        rz + (-TempVar2 + TempVar3)*zunit}; If[
                        N[Chop[LocRayL]] >= 0. && LocSCx^2 + LocSCy^2 <= 
                        25. && Abs[ry + LocRayL*yunit - LocSCx] + 
                        Abs[rz + LocRayL*zunit - LocSCy] + Abs[-6.5 + 
                        rx + LocRayL*xunit + Sqrt[42.25 - LocSCx^2 - 
                        LocSCy^2]] < 1.*^-7, {LocRayL, LocSCx, LocSCy}, 
                        {-1., 0., 0.}]}; If[TempVar[[1]] == TempVar[[
                        2]], {TempVar[[1]]}, TempVar], {{-1., 0., 
                       0.}}]]; AppendTo[intersections, {-1., 0., 0.}]; 
                 holeQ = False; If[ !(Chop[surfaceid - 100998.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 12., 
                     100998.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 12., 100998.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -3.05 + rxhlp; rey = ryhlp; rez = rzhlp; 
                   rex = Chop[rex]; rey = Chop[rey]; rez = Chop[rez]; 
                   intersectionnumber = intersectionnumber + 1.; 
                   opticallength = opticallength + ray1*index1; 
                   completedray = {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                     r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., -(ray2/(42.25 - ray2^2 - ray3^2)^
                        2^(-1)), -(ray3/(42.25 - ray2^2 - ray3^2)^
                        2^(-1))}, {ray2/(42.25 - ray2^2 - ray3^2)^
                        2^(-1), 1., 0.}, {ray3/(42.25 - ray2^2 - ray3^2)^
                        2^(-1), 0., 1.}}]; dummymatrix = (#1 & ) /@ 
                      surfnorm; surfnorm = (#1/Sqrt[#1 . #1] & ) /@ 
                      dummymatrix; surfacerotationmatrix = {{1., 0, 0}, 
                      {0, 1., 0}, {0, 0, 1.}}; 
                    surfacetranslationvector = {-3.05, 0, 0}; 
                    activeregion = 1.; completedray = {rsx, rsy, rsz, 
                      rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.5532682085807892 - 
                        1.0054245500487249*wavelength + 
                        1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3], index2 = 
                       1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5532682085807892 - 1.0054245500487249*
                        wavelength + 1.6027810806758462*wavelength^2 - 
                        0.8794405514273502*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       (generationnumber += 1.; reportedlocalrays = 
         {{rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, 
           r9, wavelength, 0, intensityscale, ray1, index, 
           opticallength, phaseshift, componentnumber, surfacenumber, 
           surfaceid, ray2, ray3, sid, frontid, sno1, sno2, sno3, sno4, 
           rayslot, generationnumber, intersectionnumber, pol1, pol2, 
           pol3}}; deflectedlocalrays = {{rsx, rsy, rsz, rex, rey, rez, 
           r1, r2, r3, r4, r5, r6, r7, r8, r9, wavelength, intensity, 
           intensityscale, ray1, index, opticallength, phaseshift, 
           componentnumber, surfacenumber, surfaceid, ray2, ray3, sid, 
           frontid, sno1, sno2, sno3, sno4, rayslot, generationnumber, 
           intersectionnumber, pol1, pol2, pol3}}; 
        (deflectedrayspresent = False; reportedrayspresent = False; 
         deflecteddummyrayspresent = False; reporteddummyrayspresent = 
          False; {deflectedlocalrays, reportedlocalrays} = 
          Transpose[((({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                 r5, r6, r7, r8, r9, wavelength, intensity, 
                 intensityscale, ray1, index, opticallength, phaseshift, 
                 componentnumber, surfacenumber, surfaceid, ray2, ray3, 
                 sid, frontid, sno1, sno2, sno3, sno4, rayslot, 
                 oldgenerationnumber, intersectionnumber, pol1, pol2, 
                 pol3} = #1; index1 = index; xunit = r1; yunit = r2; 
               zunit = r3; xunit = Chop[xunit]; yunit = Chop[yunit]; 
               zunit = Chop[zunit]; magnitude = (xunit^2 + yunit^2 + 
                  zunit^2)^2^(-1); xunit = xunit/magnitude; yunit = 
                yunit/magnitude; zunit = zunit/magnitude; rx = 
                3.5999999999999996 + rex; ry = rey; rz = rez; rx = 
                Chop[rx]; ry = Chop[ry]; rz = Chop[rz]; 
               terminatedeflection = False; intersections = 
                {{-1., 0., 0.}}); If[intensity > thresholdintensity, 
               deflectedrayspresent = True; (intersections = 
                  Block[{LocRayL, LocSCx, LocSCy}, LocRayL = 1. + I*0.; 
                    LocSCx = 1. + I*0.; LocSCy = 1. + I*0.; 
                    Re[Select[{{-1. + 0.*I, 0. + 0.*I, 0. + 0.*I}, 
                       {(386.*xunit - 37.*rx*xunit - 50.*ry*yunit - 
                        50.*rz*zunit - 1.4142135623730951*Sqrt[
                        74498.*xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*
                        xunit^2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*
                        xunit*yunit + 19300.*rx*yunit^2 - 925.*rx^2*
                        yunit^2 - 1250.*rz^2*yunit^2 - 19300.*rz*xunit*
                        zunit + 1850.*rx*rz*xunit*zunit + 2500.*ry*rz*
                        yunit*zunit + 19300.*rx*zunit^2 - 925.*rx^2*
                        zunit^2 - 1250.*ry^2*zunit^2])/(37.*xunit^2 + 
                        50.*yunit^2 + 50.*zunit^2), (37.*ry*xunit^2 + 
                        386.*xunit*yunit - 37.*rx*xunit*yunit - 50.*rz*
                        yunit*zunit + 50.*ry*zunit^2 - 
                        1.4142135623730951*yunit*Sqrt[74498.*xunit^2 - 
                        925.*ry^2*xunit^2 - 925.*rz^2*xunit^2 - 19300.*
                        ry*xunit*yunit + 1850.*rx*ry*xunit*yunit + 
                        19300.*rx*yunit^2 - 925.*rx^2*yunit^2 - 1250.*
                        rz^2*yunit^2 - 19300.*rz*xunit*zunit + 1850.*rx*
                        rz*xunit*zunit + 2500.*ry*rz*yunit*zunit + 
                        19300.*rx*zunit^2 - 925.*rx^2*zunit^2 - 1250.*
                        ry^2*zunit^2])/(37.*xunit^2 + 50.*yunit^2 + 
                        50.*zunit^2), (37.*rz*xunit^2 + 50.*rz*yunit^2 + 
                        386.*xunit*zunit - 37.*rx*xunit*zunit - 50.*ry*
                        yunit*zunit - 1.4142135623730951*zunit*Sqrt[
                        74498.*xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*
                        xunit^2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*
                        xunit*yunit + 19300.*rx*yunit^2 - 925.*rx^2*
                        yunit^2 - 1250.*rz^2*yunit^2 - 19300.*rz*xunit*
                        zunit + 1850.*rx*rz*xunit*zunit + 2500.*ry*rz*
                        yunit*zunit + 19300.*rx*zunit^2 - 925.*rx^2*
                        zunit^2 - 1250.*ry^2*zunit^2])/(37.*xunit^2 + 
                        50.*yunit^2 + 50.*zunit^2)}, {(386.*xunit - 
                        37.*rx*xunit - 50.*ry*yunit - 50.*rz*zunit + 
                        1.4142135623730951*Sqrt[74498.*xunit^2 - 925.*
                        ry^2*xunit^2 - 925.*rz^2*xunit^2 - 19300.*ry*
                        xunit*yunit + 1850.*rx*ry*xunit*yunit + 19300.*
                        rx*yunit^2 - 925.*rx^2*yunit^2 - 1250.*rz^2*
                        yunit^2 - 19300.*rz*xunit*zunit + 1850.*rx*rz*
                        xunit*zunit + 2500.*ry*rz*yunit*zunit + 19300.*
                        rx*zunit^2 - 925.*rx^2*zunit^2 - 1250.*ry^2*
                        zunit^2])/(37.*xunit^2 + 50.*yunit^2 + 50.*
                        zunit^2), (37.*ry*xunit^2 + 386.*xunit*yunit - 
                        37.*rx*xunit*yunit - 50.*rz*yunit*zunit + 
                        50.*ry*zunit^2 + 1.4142135623730951*yunit*
                        Sqrt[74498.*xunit^2 - 925.*ry^2*xunit^2 - 
                        925.*rz^2*xunit^2 - 19300.*ry*xunit*yunit + 
                        1850.*rx*ry*xunit*yunit + 19300.*rx*yunit^2 - 
                        925.*rx^2*yunit^2 - 1250.*rz^2*yunit^2 - 19300.*
                        rz*xunit*zunit + 1850.*rx*rz*xunit*zunit + 
                        2500.*ry*rz*yunit*zunit + 19300.*rx*zunit^2 - 
                        925.*rx^2*zunit^2 - 1250.*ry^2*zunit^2])/
                        (37.*xunit^2 + 50.*yunit^2 + 50.*zunit^2), 
                        (37.*rz*xunit^2 + 50.*rz*yunit^2 + 386.*xunit*
                        zunit - 37.*rx*xunit*zunit - 50.*ry*yunit*
                        zunit + 1.4142135623730951*zunit*Sqrt[74498.*
                        xunit^2 - 925.*ry^2*xunit^2 - 925.*rz^2*xunit^
                        2 - 19300.*ry*xunit*yunit + 1850.*rx*ry*xunit*
                        yunit + 19300.*rx*yunit^2 - 925.*rx^2*yunit^2 - 
                        1250.*rz^2*yunit^2 - 19300.*rz*xunit*zunit + 
                        1850.*rx*rz*xunit*zunit + 2500.*ry*rz*yunit*
                        zunit + 19300.*rx*zunit^2 - 925.*rx^2*zunit^2 - 
                        1250.*ry^2*zunit^2])/(37.*xunit^2 + 50.*yunit^
                        2 + 50.*zunit^2)}}, ({LocRayL, LocSCx, LocSCy} = 
                        #1; {LocRayL, LocSCx, LocSCy} == {-1., 0., 
                        0.} || (Chop[Im[#1]] == {0, 0, 0} && 
                        N[Chop[Re[LocRayL]]] >= 0. && Abs[ry + LocRayL*
                        yunit - LocSCx] + Abs[rz + LocRayL*zunit - 
                        LocSCy] + Abs[rx + LocRayL*xunit - (25*(LocSCx^
                        2 + LocSCy^2))/(193*(1 + Sqrt[1 - (925*(LocSCx^
                        2 + LocSCy^2))/74498]))] < 1.*^-7 && 
                        Re[LocSCx]^2 + Re[LocSCy]^2 <= 39.0625)) & ]]]; 
                 AppendTo[intersections, {-1., 0., 0.}]; holeQ = False; 
                 If[ !(Chop[surfaceid - 100999.] == 0. || 
                     N[Chop[ray1]] < 0.0001) || generationnumber == 1., 
                  minresonateraylength = 0., minresonateraylength = 
                   0.0001]; Block[{LocRayL, LocSCx, LocSCy}, 
                  LocRayL = 1.; LocSCx = 1.; LocSCy = 1.; dummymatrix = 
                    Union[Select[intersections, ({LocRayL, LocSCx, 
                        LocSCy} = #1; {LocRayL, LocSCx, LocSCy} == 
                        {-1., 0., 0.} || N[Chop[LocRayL]] >= 
                        minresonateraylength) & ]]; intersections = 
                    dummymatrix]; unfilteredintersections = 
                  intersections; If[Length[intersections] > 1, 
                  dummymatrix = Take[intersections, {2}]; 
                   intersections = dummymatrix; 1., 1.]); 
                If[intersections != {{-1., 0., 0.}}, 
                 intersectionspresent = True; ({newcomponentnumber, 
                     newsurfacenumber, newsurfaceid} = {1., 13., 
                     100999.}; {componentnumber, surfacenumber, 
                     surfaceid} = {1., 13., 100999.}; {ray1, ray2, 
                     ray3} = intersections[[1]]; rsx = rex; rsy = rey; 
                   rsz = rez; rxhlp = rx + ray1*xunit; ryhlp = 
                    ry + ray1*yunit; rzhlp = rz + ray1*zunit; 
                   rex = -3.5999999999999996 + rxhlp; rey = ryhlp; 
                   rez = rzhlp; rex = Chop[rex]; rey = Chop[rey]; 
                   rez = Chop[rez]; intersectionnumber = 
                    intersectionnumber + 1.; opticallength = 
                    opticallength + ray1*index1; completedray = 
                    {rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, r5, 
                     r6, r7, r8, r9, wavelength, intensity, 
                     intensityscale, ray1, index, opticallength, 
                     phaseshift, componentnumber, surfacenumber, 
                     surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                     sno3, sno4, rayslot, generationnumber, 
                     intersectionnumber, pol1, pol2, pol3}); 
                  (reportedrayspresent = True; (surfnorm = 
                     1.*Re[{{1., (-0.0016083472422043674*ray2^3)/
                        (Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])^2) - (0.0016083472422043674*
                        ray2*ray3^2)/(Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)])^2) - 
                        (0.2590673575129534*ray2)/(1. + Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]), 
                        (-0.0016083472422043674*ray2^2*ray3)/(Sqrt[
                        1. - 0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) - (0.0016083472422043674*ray3^3)/
                        (Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]*(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])^2) - (0.2590673575129534*
                        ray3)/(1. + Sqrt[1. - 0.012416440709817716*
                        (ray2^2 + ray3^2)])}, {(0.0016083472422043674*
                        ray2*(ray2^2 + ray3^2))/(Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) + (0.2590673575129534*ray2)/(1. + 
                        Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]), 1., 0.}, {(0.0016083472422043674*ray3*
                        (ray2^2 + ray3^2))/(Sqrt[1. - 
                        0.012416440709817716*(ray2^2 + ray3^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*(ray2^2 + 
                        ray3^2)])^2) + (0.2590673575129534*ray3)/(1. + 
                        Sqrt[1. - 0.012416440709817716*(ray2^2 + ray3^
                        2)]), 0., 1.}}]; If[surfnorm[[1]] == {0., 0., 
                        0.} || surfnorm[[2]] == {0., 0., 0.} || 
                      surfnorm[[3]] == {0., 0., 0.}, surfnorm = 
                       1.*Re[{{1., (-0.0016083472422043674*(1.*^-6 + 
                        ray2)^3)/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.0016083472422043674*(1.*^-6 + ray2)*(1.*^-6 + 
                        ray3)^2)/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.2590673575129534*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 
                        (-0.0016083472422043674*(1.*^-6 + ray2)^2*
                        (1.*^-6 + ray3))/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) - 
                        (0.0016083472422043674*(1.*^-6 + ray3)^3)/
                        (Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) - (0.2590673575129534*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])}, {(0.0016083472422043674*
                        (1.*^-6 + ray2)*((1.*^-6 + ray2)^2 + (1.*^-6 + 
                        ray3)^2))/(Sqrt[1. - 0.012416440709817716*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2)]*
                        (1. + Sqrt[1. - 0.012416440709817716*((1.*^-6 + 
                        ray2)^2 + (1.*^-6 + ray3)^2)])^2) + 
                        (0.2590673575129534*(1.*^-6 + ray2))/(1. + 
                        Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]), 1., 0.}, 
                        {(0.0016083472422043674*(1.*^-6 + ray3)*
                        ((1.*^-6 + ray2)^2 + (1.*^-6 + ray3)^2))/
                        (Sqrt[1. - 0.012416440709817716*((1.*^-6 + ray2)^
                        2 + (1.*^-6 + ray3)^2)]*(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)])^2) + (0.2590673575129534*
                        (1.*^-6 + ray3))/(1. + Sqrt[1. - 
                        0.012416440709817716*((1.*^-6 + ray2)^2 + 
                        (1.*^-6 + ray3)^2)]), 0., 1.}}]; 1., 1.]; 
                    dummymatrix = (#1 & ) /@ surfnorm; surfnorm = 
                     (#1/Sqrt[#1 . #1] & ) /@ dummymatrix; 
                    surfacerotationmatrix = {{1., 0, 0}, {0, 1., 0}, 
                      {0, 0, 1.}}; surfacetranslationvector = 
                     {-3.5999999999999996, 0, 0}; activeregion = 1.; 
                    completedray = {rsx, rsy, rsz, rex, rey, rez, r1, 
                      r2, r3, r4, r5, r6, r7, r8, r9, wavelength, 
                      intensity, intensityscale, ray1, index, 
                      opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; componentnumber = newcomponentnumber; 
                    surfacenumber = newsurfacenumber; surfaceid = 
                     newsurfaceid; originalray = {rsx, rsy, rsz, rex, 
                      rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                      wavelength, intensity, intensityscale, ray1, 
                      index, opticallength, phaseshift, componentnumber, 
                      surfacenumber, surfaceid, ray2, ray3, sid, 
                      frontid, sno1, sno2, sno3, sno4, rayslot, 
                      generationnumber, intersectionnumber, pol1, pol2, 
                      pol3}; ZAxis = First[surfnorm]*Sign[First[
                        surfnorm] . {r1, r2, r3}]; raytiltz = ZAxis . 
                      {r1, r2, r3}; raytiltx = 1 - raytiltz^2; 
                    If[raytiltx < 2.220446049250313*^-16, raytiltx = 0., 
                     raytiltx = Sqrt[raytiltx]]; XAxis = {r1, r2, r3} - 
                      ZAxis*raytiltz; If[Abs[raytiltx] < 1.*^-7, 
                     XAxis = surfnorm[[2]], XAxis = XAxis/raytiltx]; 
                    YAxis = {-(ZAxis[[3]]*XAxis[[2]]) + ZAxis[[2]]*
                        XAxis[[3]], ZAxis[[3]]*XAxis[[1]] - ZAxis[[1]]*
                        XAxis[[3]], -(ZAxis[[2]]*XAxis[[1]]) + 
                       ZAxis[[1]]*XAxis[[2]]}; YAxis = YAxis/Sqrt[
                       YAxis . YAxis]; PAxis = ZAxis*{r1, r2, r3} . 
                        XAxis - XAxis*{r1, r2, r3} . ZAxis; PAxis = 
                     PAxis/Sqrt[PAxis . PAxis]; normalizedpolarization = 
                     {pol1, pol2, pol3}[[{1, 2}]]; 
                    normalizedpolarization = normalizedpolarization/
                      Sqrt[normalizedpolarization . 
                        normalizedpolarization]; allcreatedamplitudes = 
                     {{I*0., I*0., I*0.}}; amplitude = Sqrt[intensity]*
                      (normalizedpolarization[[1]]*{r4, r5, r6} + 
                       normalizedpolarization[[2]]*{r7, r8, r9}*
                        Exp[I*pol3*0.017453292519943295]); 
                    perpendicularamplitude = amplitude . YAxis; 
                    parallelamplitude = amplitude . PAxis; 
                    If[activeregion*(surfacerotationmatrix . {r1, r2, 
                        r3})[[1]] > 0, index2 = 1.5392664079781753 - 
                        0.7232199521975703*wavelength + 
                        1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; index1 = index; 
                      If[Abs[index2 - index1] < 0.01, alternateindex = 
                        Sqrt[1.0005281111748805 - 2.364805676582992*^-10*
                        wavelength^2 + 2.9781670902982902*^-6/wavelength^
                        2 + 2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]; 
                        If[Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = Sqrt[1.0005281111748805 - 
                        2.364805676582992*^-10*wavelength^2 + 
                        2.9781670902982902*^-6/wavelength^2 + 
                        2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]], 
                     index2 = Sqrt[1.0005281111748805 - 
                        2.364805676582992*^-10*wavelength^2 + 
                        2.9781670902982902*^-6/wavelength^2 + 
                        2.6004099469477187*^-8/wavelength^4 + 
                        3.7787839314048715*^-10/wavelength^6 + 
                        2.830549017940716*^-12/wavelength^8]; index1 = 
                       index; If[Abs[index2 - index1] < 0.01, 
                       alternateindex = 1.5392664079781753 - 
                        0.7232199521975703*wavelength + 
                        1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3; If[
                        Abs[alternateindex - index1] > Abs[index2 - 
                        index1], index1 = index2; index2 = 
                        alternateindex, index1 = alternateindex], 
                       index1 = 1.5392664079781753 - 0.7232199521975703*
                        wavelength + 1.0984449372238456*wavelength^2 - 
                        0.5792106404991648*wavelength^3]]; n12 = 
                     index1/index2; index = index2; If[1 - n12^2*
                        raytiltx^2 >= 0., dummyvector = n12*{r1, r2, 
                        r3} + ZAxis*(-(n12*raytiltz) + Sqrt[1 - n12^2*
                        raytiltx^2]); {r1, r2, r3} = dummyvector; 1., 
                     If[{r1, r2, r3} . surfnorm[[1]] > 0, phaseshift = 
                        phaseshift + 0.5, 1.]; index2 = index1; 
                      index = index1; dummyvector = {r1, r2, r3} - 
                        2*ZAxis*ZAxis . {r1, r2, r3}; {r1, r2, r3} = 
                       dummyvector; dummyvector = {pol1, pol2, pol3} + 
                        {0, 0, -180}; {pol1, pol2, pol3} = dummyvector; 
                      1.]; allcreatedrays = {{rsx, rsy, rsz, rex, rey, 
                       rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                       wavelength, intensity, intensityscale, ray1, 
                       index, opticallength, phaseshift, 
                       componentnumber, surfacenumber, surfaceid, ray2, 
                       ray3, sid, frontid, sno1, sno2, sno3, sno4, 
                       rayslot, generationnumber, intersectionnumber, 
                       pol1, pol2, pol3}}; originalrotation = Partition[
                      Take[originalray, {7, 15}], 3]; previoustilt = 
                     originalrotation[[1]]; transmatrix = MapIndexed[
                      ({rsx, rsy, rsz, rex, rey, rez, r1, r2, r3, r4, 
                        r5, r6, r7, r8, r9, wavelength, intensity, 
                        intensityscale, ray1, index, opticallength, 
                        phaseshift, componentnumber, surfacenumber, 
                        surfaceid, ray2, ray3, sid, frontid, sno1, sno2, 
                        sno3, sno4, rayslot, oldgenerationnumber, 
                        intersectionnumber, pol1, pol2, pol3} = #1; 
                        rotationaxis = Cross[previoustilt, {r1, r2, 
                        r3}]; axismagnitude = Sqrt[rotationaxis . 
                        rotationaxis]; If[Chop[axismagnitude] != 0., 
                        rotationaxis = rotationaxis/axismagnitude; 
                        axismatrix = (#1*rotationaxis & ) /@ 
                        rotationaxis; crossmatrix = {{0., -rotationaxis[[
                        3]], rotationaxis[[2]]}, {rotationaxis[[3]], 0., 
                        -rotationaxis[[1]]}, {-rotationaxis[[2]], 
                        rotationaxis[[1]], 0.}}; cosangle = 
                        previoustilt . {r1, r2, r3}; If[1. - cosangle < 
                        2.220446049250313*^-16, cosangle = 1.]; 
                        sinangle = 1 - cosangle^2; If[sinangle < 
                        2.220446049250313*^-16, sinangle = 0., 
                        sinangle = Sqrt[sinangle]]; axismatrix + 
                        ({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}} - 
                        axismatrix)*cosangle + crossmatrix*sinangle, 
                        {{r1, r2, r3}, {r4, r5, r6}, {r7, r8, r9}} = 
                        If[Sign[previoustilt . {r1, r2, r3}] === 1, 
                        {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, 
                        {{-1., 0., 0.}, {0., -1., 0.}, {0., 0., 
                        -1.}}]]) & , allcreatedrays]; allcreatedrays = 
                     MapIndexed[({rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        oldgenerationnumber, intersectionnumber, pol1, 
                        pol2, pol3} = #1; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = Function[mm, (mm . #1 & ) /@ 
                        originalrotation][transmatrix[[First[#2]]]]; 
                        tiltmagnitude = {r1, r2, r3} . {r1, r2, r3}; 
                        If[Abs[tiltmagnitude - 1.] > 1.*^-6, 
                        dummyvector = {r1, r2, r3}/Sqrt[tiltmagnitude]; 
                        {r1, r2, r3} = dummyvector; dummymatrix = 
                        (#1/Sqrt[#1 . #1] & ) /@ {{r1, r2, r3}, {r4, r5, 
                        r6}, {r7, r8, r9}}; {{r1, r2, r3}, {r4, r5, r6}, 
                        {r7, r8, r9}} = dummymatrix; 1., 1.]; 
                        If[allcreatedamplitudes != {{I*0., I*0., I*0.}}, 
                        amplitude = allcreatedamplitudes[[First[#2]]]; 
                        hor = {r4, r5, r6} . amplitude; ver = {r7, r8, 
                        r9} . amplitude; If[Abs[hor] > 0. || Abs[ver] > 
                        0., {pol1, pol2, pol3} = {Abs[hor], Abs[ver], 
                        0.}; dummyvector = {pol1, pol2, pol3}/Sqrt[
                        {pol1, pol2, pol3} . {pol1, pol2, pol3}]; 
                        {pol1, pol2, pol3} = dummyvector; dummyvector = 
                        ReplacePart[{pol1, pol2, pol3}, (If[ver == 0., 
                        0., Arg[ver]] - If[hor == 0., 0., Arg[hor]])/
                        Degree, 3]; {pol1, pol2, pol3} = dummyvector]; 
                        1., 1.]; {rsx, rsy, rsz, rex, rey, rez, r1, r2, 
                        r3, r4, r5, r6, r7, r8, r9, wavelength, 
                        intensity, intensityscale, ray1, index, 
                        opticallength, phaseshift, componentnumber, 
                        surfacenumber, surfaceid, ray2, ray3, sid, 
                        frontid, sno1, sno2, sno3, sno4, rayslot, 
                        generationnumber, intersectionnumber, pol1, 
                        pol2, pol3}) & , allcreatedrays])); 
                  {First[allcreatedrays], completedray}, 
                 reporteddummyrayspresent = True; {{rsx, rsy, rsz, rex, 
                    rey, rez, r1, r2, r3, r4, r5, r6, r7, r8, r9, 
                    wavelength, intensity, intensityscale, ray1, index, 
                    opticallength, phaseshift, componentnumber, 
                    surfacenumber, surfaceid, ray2, ray3, sid, frontid, 
                    sno1, sno2, sno3, sno4, rayslot, generationnumber, 
                    intersectionnumber, pol1, pol2, pol3}, {1., 1., 1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 
                    1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                    1.}}], reporteddummyrayspresent = True; 
                deflecteddummyrayspresent = True; {{1., 1., 1., 1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  -9.87654321*^8, 1., 1., 1., 1., 0., -1., -1., -1., 1., 
                  1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.}, 
                 {1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1., -9.87654321*^8, 1., 1., 1., 1., 0., -1., 
                  -1., -1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 
                  1., 1., 1.}}]) & ) /@ propagatedrays]; 
         If[deflectedrayspresent && deflecteddummyrayspresent, 
          deflectedlocalrays = Select[deflectedlocalrays, 
             #1[[23]] > 0. & ]; 1., 1.]; If[reportedrayspresent && 
           reporteddummyrayspresent, reportedlocalrays = 
            Select[reportedlocalrays, #1[[23]] > 0. & ]; 1., 1.]); 
        (If[reportedrayspresent, reportedrays = Join[reportedrays, 
             {{-9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8, 
               -9.87654321*^8, -9.87654321*^8, -9.87654321*^8}}, 
             reportedlocalrays]; 1., 1.]; propagatedrays = 
          deflectedlocalrays); raysreported = reportedrayspresent; 1.); 
       If[Length[reportedrays] > 2, reportedrays = Drop[reportedrays, 
          2], reportedrays]; ({#1[[1]], #1[[2]], #1[[3]], #1[[4]], 
          #1[[5]], #1[[6]]} & ) /@ reportedrays]]), Deployed -> False, 
 AutorunSequencing -> {2}, SynchronousInitialization -> False, 
 SynchronousUpdating -> False]\
\>", "Input",
 CellChangeTimes->{{3.414318364326291*^9, 3.414318377985168*^9}, 
   3.4147156038057337`*^9, {3.414715638076907*^9, 3.4147157072129393`*^9}, {
   3.4147157916528997`*^9, 3.414715806108724*^9}, 3.4147684769993286`*^9, {
   3.4147685083741274`*^9, 3.414768509999117*^9}, {3.506346052133934*^9, 
   3.5063461398097005`*^9}},
 CellID->315662424]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`lastlocposth$$ = {-4.4019925, 
    0.}, $CellContext`laststartposth$$ = {-5., 0.}, $CellContext`lastth$$ = 
    0., $CellContext`radiusth$$ = 
    0.5980074999999999, \
$CellContext`staticpolygons1118640200831284558144170$$ = {
     GrayLevel[0], 
     AbsoluteThickness[0.5], 
     Line[CompressedData["
1:eJyFmnlwV9UVx19WCAkkIQuLkUCQkFJZJEsFxHukw74MiwIVKGVzLGUrOgUj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      
      "]]}, $CellContext`staticpolygons211864020083128460945430$$ = {
     GrayLevel[0], 
     AbsoluteThickness[0.5], 
     Line[{CompressedData["
1:eJyNlT1IQlEUx1+a9mFERhrWIEFEtCtBQ0L0RR9kBQ5WQtlWSC2SDYpDQRB9
UTk1tDTU0B70pMkhXCqqrUAiIgzBCiMl8d17Hl74YxfecH4c7jv3nP85p2XW
Nz6vkSRpIv9p81/sYXVpK5mQpcKxRCV2nnaTZ/vnHwqPNhKPO40282Va4SEz
8SZXa8RqzyjcYVL9byJG3VCW3d9AvH20t/kkLCl2tJ54zB3e/LZpFDtkJG5f
3vhyXmkV21FH3Hs45bZ06JhdSzx3nIqP+PTsHgNxf48ncLRXwewqNZ6DnWF/
pJL564mfeqxBQ5D7lRM32Z/l6YFq5l9G/O4tu933ybiUkzn/ee3sX1njcWSI
B+YmU+u/nKeJd7kfZ15cNYwniS+MyYvvEc4TxAfbvBf3Mue3xK8Lh3P1CP7d
4H7iQjzEhfiJC+8lLuSHuJBPB+dC/okL9SIu1Je4oAfign6IC3ojLuhTjadY
z8QF/RMX+kX1L+4v4kI/qvEU929Jju5B/4VxgnehPKC8oTyjuqA6orojnSBd
IR0i3SKdo75AfYT6DvXpP/u65NxAcwbNJTTH0NxDcxLNVTSH0dxGcx7tBbRH
0N5BewrtNbgHwd5EexbtZcT/ALb6qpI=
       "], CompressedData["
1:eJyVVT1IQlEUvmlaZkQv0rAGCSKkXQka3oXoj37IChyshLKtkFokGxSHgiD6
o3pTQ0tDDe1B99DkEC4V1VYgERGGYIWRkrTdC9/Qg7t8HM6795zvp3UmMjZn
YoyNl4+5fFL3K4ub2Yxg0ueix53s6d7Zu4xTE6X9mtd5kZfxhJOaA22G21eQ
ce6g9LWhWQaLSv9G8oz0tBwnGcn9GygVTG58eU0yntDIt7T+6b80yzivp/DB
ZNDVYZFxVkelo1x6OGJV+tgp2h2KHe5WKfU28uxvD0WNaqXeSichd9wetyn1
leTwPYmp/hqlvoJuX4tbvR8Kzkri+6Wzb3nVruAFEZudyK39qHhedAUfpp8D
tQqeFfOjYuHNUPGMGGgPn98JFb8RV3+fijMG6nXQXwf30cH9dfBeHcxHB/Pk
YP4c7IuD/XLABw74wwHfOOAnB3zmgP8c6IUDfXGgRw70C3HUB/0X3hO8C80B
zQ3NGe0F7RHtHfEE8QrxEPEW8RzpAukI6Q7p9J+6hr6BfAb5EvIx5HvIJ5Gv
Ih9Gvo18HuUCyhGUOyinUK7BHAS5iXIW5TLCfwEU1KqS
       "], CompressedData["
1:eJyN1U0ow2EcB/C/beZtNCaSlzUypVAubuPuhKtSihyYm7TsICsrUsouDq7k
hBuHTQ6UUsoFUctByrCYWfO65nm+6lff5l//w/Np/fc8v+f34hqe7B8xGYYx
kHnNmTdaY7cGZ28jRvap3DfUs+G2z32FnpQ74GMtDZ3h8xflFfDYVnNvj/9N
eTk8/hx0Lh2mldvhqeB0qyfyqbwMHtg+Kz7oMtTaBk/fvDofvXlqXQw/bmzy
h+dNal0IT56E3vsCZrW2wkezj0WtLfBNq8M13pGv1ia4r21qdSWq3YCv1axX
X/v0dz8i2m31tVdV39pTcO/e7tDDRIHyBNwUW7bdH2mPw4+L6i5mSvV57uDt
CzvphEd7FO5OllwuDmo/hf+e9y8u5Pfd5PtwsR+42D9cnBcu4gMX8YSL+Pdo
F/cFF/cLF/kAF/kDF/kGF/kJF/kMF/kPF/UCF/UFF/UIF/Wb09l32P+yfbJz
sTiwuLE4s3th98juneUJyyuWhyxvWZ6zumB1xOqO1ek/6zpn32B9hvUl1sdY
32N9kvVV1odZ32Z9ns0FNkfY3GFzis01NgfZ3GRzls1l5j/8GZHy
       
       "], CompressedData["
1:eJyVlU8og2Ecx1/bDDOaP9HyL2RKoVzc9j53J1yVUuTA3CRxkJUVKWUXB1dy
wo3DnicHaqWUC6KWg5RhMaP5Hye/+hy89V4+rXfP8/t9/9QPjPUMOizL6v1+
nd9vwu9zR2autPXnKTfrAd/sR/Re8DIz3FzbETt5FLzUJDebutT0s+AlJvUQ
qVvczwruMy+RiZagfhe82IS3jj17nZb5y70me/lUdxfKEdxj4g2N07E5h+D5
JnMYfe0OOwV3m6GfxyW4y2y4y+pH2nMFd5jJ1vGV5YTklln1r1VeTLoFf9Pe
mqrzik/JX3Rod6f/djRP8LR2JJe8NweSp3S8oPp0qihf8GvdNr+dTQclT+hA
pvBsoU/yI/17X8ktC35vw/dtOI8N57fhvjbMx4Z52jB/BftSsF8FelCgHwV6
U6BPBXpWoH8FflHgLwV+VOBf5PQd+l86J92L5kBzoznTXmiPtHfSCemKdEi6
JZ2TL8hH5Dvy6T99jblBOUO5RDlGuUc5SblKOUy5TTlPvUA9Qr1DPUW9Rj1I
vUk9S71M/AvV+5Hy
       "], CompressedData["
1:eJyV1UsKglAUBuDrYyOtpNZQOwgat57aQavIJTR06MCBAwciESIiPQik8IM6
4ORDfNx77n8W2/16F4cQNo8reVzHw7NO5/CqNAvv+vQEHsMjeICP53kf4D28
g9/gV3gLb+A1vIKX8AKewy/wDD7V1/1LPB+ewwt4Ca/gNbyBt/Ar/Abv4D18
gI/wsJr3CB7DE3j6p+s5eq++U/+lddC6aZ21L9pH7bv6RH2lPlTfqs91LnSO
dO50Tqf6LQeUG8oZ5ZJyTLmnnFSuKoeV28p5zQXNEc0dzSnNNc1BzU3NWc3l
ye98hwBd
       "], CompressedData["
1:eJyV1bENgkAUBuATWMRJdAbdwMTaeXQDp+BGsKSkoKCgIIQQQggRSxO+ApJr
vuKAu/f+d7w9LvckhHBdV7qu1/P3vPPw92Rx21N4Aj/AA3zJt32GT/ARPsB7
eAdv4Q28hlfwEl7AP/AI173HE/aHF/ASXsFreANv4R28hw/wET7BZ/gCD2f0
CzyBp/Bsp2sfvVffqf/SOejcdM66F92j7l11orpSHapuVefqC/WR+k59yr7e
mRvKGeWScky5p5xUriqHldvKec0FzRHNHc0pzTXNQc1NzVnN5Sx+AX/aAF0=

       "], CompressedData["
1:eJyV1ckNAjEQRNEW+74nQCaOATJA4kwKnQZkQBQ4NAbEASTeYSz58lXqGdvd
VfvT5XDuRMSx2d1m366vdX/Ee+1qfNYPr9v/PMELeIDXDeqDF/AAr2vUBy/g
AV5XqA9ewEN1ltCD5wJ68JxDD54z6MFzCj14TqAHzzH04DmCHjyH0IPnAHrw
7EMPnj3oW3LW0Xf1nzqX7kH3pnvWu+gd9e7qE/WV+lB9qz7XXGiONHeaU821
fEC+IZ9p6WPyPfmkfFU+LN+WzysXlCPKHeWUck05qNxUziqXv/gTK1f7Mg==

       "], CompressedData["
1:eJyV1dkJQjEUhOHBfd8bsJNbg3Yg+GwLaUM7sApTmgu+CH6Igbz8DOfeJOfM
bA+n3bGVZP/Y7ce+nJ/restrdZq81wcv4OlCD54e9ODpQw+eAfTgGUIPnhH0
4BlDD54J9OCZQg+eGfTgmUMPnsV33oAX8AqeJeqDF/AKnhXqgxfwCp416oMX
8AqezX9cdfRd/afOpXvQveme9S56R727+kR9pT5U36rPNRecI82d5lRzLR+Q
b8hn5EvyMfmefFK+Kh+Wb8vnlQvKEeWOckq5phxUbipnf/M7J8jRog==
       
       "], CompressedData["
1:eJyV1ckNAjEQRNEW+74nQCaOATJA4kwKnQZkQBQ4NMwRad5hLPnyVeoZ291V
59vjch9ExLXtYduv52+9P/G3TrWT12M3T/ACHuD1gPrgBTzA6x71wQt4gNcd
6oMX8FCdLfTguYEePNfQg+cKevBcQg+eC+jBcw49eM6gB88p9OA5gR48x9CD
5wj6npx19F39p86le9C96Z71LnpHvbv6RH2lPlTfqs81F5ojzZ3mVHMtH5Bv
yGd6+ph8Tz4pX5UPy7fl88oF5YhyRzmlXFMOKjeVs8rlxr9Xivsy
       
       "], CompressedData["
1:eJyV1ckNwjAUhOER+05YGqCT1AAdIHGmBbcBHVAFLo1wRMp3wJIvv0Yvsf3e
zOl6P98GSS7dHnb7+fiu1zs/a9T28gKeMfTgmUAPnin04JlBD5459OBZQA+e
JfTgWUEPnjX04NlAD54t9OBp+nkLXsAreHaoD17AK3j2qA9ewCt4DqgPXsAr
eI7/cdXRd/WfOpfuQfeme9a76B317uoT9ZX6UH2rPtdccI40d5pTzbV8QL4h
n5Evycfke/JJ+ap8WL4tn1cuKEeUO8op5ZpyULmpnDX/AKCK0aI=
       
       "], CompressedData["
1:eJyF1V1Ik1EYB/ChS6oVLn03ImjZINzNunFKKuNZQghBQUa4oiCFboRI0Ivw
JiqCSMFb+7iRhWLEgopwdpFJF3Uh0ee8eBGc2ogxGBubF66Pt/c8+wcPHN4D
782Pw3mf8/E/5/Dgtb4rdS6X66z11VvfKQr6hrJlenD/X/MvurhNV8NPU9US
pQJ3cmeu++CpbFt4R7BI6cRwdHe/AQ+Nbz08Hi9QJXRxcqm9Gf7CXO4wY3ny
JXvXxowm+Gz3wq8jWz8p0ma1khfuvvdy181vP+ixNXw60QgvLD8fPLC6Tpkx
I9k7sBceD5640dq8RoesMucDHvhoV2FqKW+SVU05ZO78P87XzmTVv8LzbYA3
Xsh2x2e+8Lzc8KNdJ28HYh/JsOuvg+fm2qPnvO+5zj9vah65mwlm3r2lgF3P
Ntw82DrS/2Gepuz/VuB94T0D0fQzHr8I7/Gsxuor09Rij5ODf7o0Efn+e5K8
dv8M/PTErSdX3cPsn+G6NsT9W1R/qnmex9+vxoeLeuCXuX7Vvwjf5Pk+UvOF
H+P1UeNsw8V6wjt4/f1q/WM138f7taL2C17m/VX/bYCL8wA/z+dH1eOBl/i8
bajzBhfnEy7OM/wVn39VfxNc5AX+mvOl5mXAE5zHBZVHuMivo4tcw0WuHesU
uXZcB926iVzDRa7hun0UuYaLXMNFruG6cyhyDRe5hotcO+ZI5Boucg3XNZFr
3AMi1473jMg1XOQaLnIN192TIteLNRe5hotcw3X3vMg1XOQarnt3dO+UyDVc
9w6KXMNFruG6d1nnfwHOe2s5
       "], CompressedData["
1:eJx1lU9IVFEUxh86STWFk74ZImiygXA208ZRUhnuSQghKMgIpyhIoY0QCrYI
N1ERSApu1drIRFLEBBXh2OLepEUtJPo7Lh6CYzXEMDDMMOPC6c/r3biLA9+B
u3gfl/O+c+753Xt4eHTgSoNlWWfd1eiuUyISHMlXhfU/5uf+RUgt1GNPMvWK
0TPhO4Uz14Mqk++I7YiUjZ5NjSV2D9oqOrV173iyZPRa9OLMSmereu6sdjlU
NHow3b8xYbeoxd7lX0e2fho93uFGJaB8d1/suvnlh9EfuOmzqWZVWn02fGB9
0+i5CTvdP7RXJSMnbrS3bhj9kGtzKexX13pKsytFx+ium2rU2alKn7vT9dAa
q7dJNV/I9yYffmJ1+dTRnpO3w/Te6Lbnv0EVHnUmzgXeMp9/ZHwyF8m9eW30
sOdnWzoH28cH3y0Zfdb7b00OxPYMJbJPWf6y7POvU2NtwehtXp6C/HBpOv71
94zRA97+nDw9fevxVd8Y0z9KC8QI29+m94siy79f5xfAj7jM/Ov9ZfGd1Xtf
1yuOsf7oPNsC9FN0sf6HdP9pHzuvNX1eVGXnq//bRGAe6DybH+3HTxU2b9/0
vBGYTwLzTC/Z/Gv/LQR4oVeML12XTSnG47LmkQC/UAdcE+Aa+gRcwz6gvgGu
CXANzxFwTYBrAlwTmkPAtQBcC8A15AhwLQDX5psH4FoCruE9A7iWgGsJuJbo
ngRcK8C1AlzDex5wrQDX8N1B7xTgGr6DgGsFuFboXUb6X3a8azk=
       
       "], CompressedData["
1:eJyFlU1IVFEUx1/T5MdMOpO+MVfjVKASLoSmVslc2tjnwiLbBKJWC6l0aZLl
opFahOBCLKshFDfSUK2qRYlQ5KoIYlxE4SAECS2mNGQKe71z3z/4D5d34W1+
XM4759zzu3dXT//J8wHLsk4531bna5343bPYv5a6e+ffqpu39BoZqP+yd2Ij
9TyeXu0YjIEf/xZM7hj9k8pND7SFztjgb7Yst77MWGq9+ezYwv5a8D2fm5IH
ugMqlm1fHrJrwA+GnAjlQZXc56wfUXB79Pv1S+Pb1IwTPjcdAZ/tuPy2JVCu
8kN2tr27Cvznxc7hbGeFanDSfBYPg2/mZh8UxiqVk81a86eK/3mOd7VsPAop
qbcM/Oj9kcaFx2EldQXBb/2qvH1icruy3fwD4OmHxa6pc1U6z81XHm+bOp2Z
i1WruJtPEfzpys5j1+aq1aT733Xw/PCh3trGiI5fAH934ePXvnREJdw4q+BX
Mu+XbixGVNTdnwd321zw+AdwWVFl0fL2J2R/yuODOn69xAenfMC9/GV/AfyJ
rvee1Avu9UfiFMGpn+A3df/rpP+o44g+ryU5L/DX+nzlv2XgNA/g3vxIPmHw
GT1vKzJv4DSf4DTP4Lv1/Ev+NeDkC/hh7ZfUZYNf1T6+EB/ByV9fTl6Dk9e+
eZLXvn0w9Y28LjmXBjoX0zmS1+DkNTh5DW6aQ/IanLwu8cImL0wekdfg5DW4
LF+vcQ+Q1773DHkNTl6X3HsJuvdM9yR5Pe9x8hqcvAY33fPkNTh5DW56d0zv
FHkNbnoHyWtw8hrc9C6b+F/sXEUv
       "], CompressedData["
1:eJyNlUtIVFEYx2/T5GMmH+kdczVZgkm4EJpaJefDjb1caGSbQNRqEZYuTfKx
aKQWIbgQS2sIxY00lCt10fkQklwVQYyLKByEQKHFpIZMord7rmfgDH/wwF3c
P+d+9/89fuecbu9qvuuzLOuG8xx1ntrRf+3LXVvC8tbLF/9XGQ92l/88N7qj
9flwdKOpJ8TX1/2RE0O7Wk9MdtcFbtm8dGS19kPMogN9u/r28OKFUq78cTZy
sc2n9VC8YbXXLuFLAefLXL/WI+ed9aeY7aHfAw9Gjml9ygmfmCzi6aaHn2p8
uVpP9trxhrYC3uxs6Yu35Gn9lGNzLhzkvcT069RwvtYdN1vV3/N4aaS1Zudt
QOsq3xy++mqwavFdUOsqLz8/+5v/vHHsuNZt17+Po2/SreN3Cgyfe7Ju/GZs
JlSo9bDrJy1n105e65/J6GPuf7dlsq++o7SqyIifkp/vfft1P5rRK9w4G/JR
7MvKk+WMXuzuT0q3zClT/yq9N60fLHN/hdoveoz45Sq+AH6E6V/tT4n3Rr4T
Kl9h1kfFSQtQT/HUqH+Zqj9dMfq1ovpFH43+qv/mEJgHMudH+QnSlDFva2re
CMwngXmmM8b8K/8lBHihywZfKi+bHhs8LigeCfALdcA1Aa6hT8A1rAOqG+A6
qy8e17CPgGsCXBPgmtAcAq4F4DqLC49ryBHgWgCuvT4dmmsJuIbnDOBaAq6z
zj2Pa4nOScA1A64ZcA3PecA1A67hvYPuKcA1vAcB1wy4ZnQvI30flJ1FLw==

       "], CompressedData["
1:eJx11V1Ik1Ecx/HppEh2YThfiAfbWpsLsU03AyvrX5C9UDJdeBHrZrUwCxIL
irUgtBEYERHUhQSFRV2YBGmMIaRiNxHeJGgQVAQj0ELp5Uqo7Tnn+QU/6YFd
7MPDec45z/lu7vi5jkSxzWaL5j/2/Odu7+Nc6+wmOVW4crUTNn2tdMQrvnX7
xTmy/3Ny1AcvTV0p3nKwTqZ++WO3+rzwj90PBxNn6qWnpXRuKLIZfil+xLjh
DUhNeqE9U+OBX64v6Z8+HJS3hWvRDT8WmfXdWwxKsvDgrAs+b3tfNHixQfKD
pBfWb4SP7Yjc7FxukGf5aTpHDPiM/U1mV6xR1s0N9bQc2gD/vm3pjpFtlIS5
3ir49vmBvlZHSCbNdVXA9wwffzQVDen5l8PTpwfux26H9DzL4O/azi69eB2S
YXM+Dnhn08vxfcshOWk+dy38RImv/7wzLIY5vh3+INWcux4Iy1NznJVXlrs9
TUXZvWGpNu//8c+jP8cCbWEpM/0L/MnXA1v/tIdFffu0k+8Pqvt38/h+NT7c
mk9GzQduzd+l5i+83i61Xri1P8/V/sCv6f1Mqf2Ei95/NX45vFm/r2n1vuDW
+1XPrYJb58GhzgN8VJ8fNR8Dbp23o+q8wa3zqebpgif1eZ5R5xl+QZ9/NX8P
/IPupVf1Al+j+1Lr8sJ/6x4rVY/wq7pftd5aOHUNp67h1DWcuoZT13DqetW+
JWnfqGs4dQ2nruHUNZy6hlPXcOoaTl3DqWs4dQ2nrld1V03dUddw6nqc7w/S
7wB1Daeu4dT1BK+3i37HqGs4dQ2nruHUNZy6hlPXcOoaTl3DqWs4dQ2nruHU
NZy6hlPXcOoa/r//67+NQD56
       "], CompressedData["
1:eJx11V9IU1EcB/CrkyLZg+HUiIttrc1F2OyPgZXdX0H2h5LpwodYL6tFWZBY
UKwFoY3AiIigHiQoLOrBJEhjDOH+FHuJ8EVBg6AiGIEWSn+ehNru73APnMPv
wH35cjn3d875fc4NJC91psoNw4gXH0/xedj7vNA2uxEMMc6WRqEBVzqTNT+6
I27uGzn0NT0axsrMjfLNR7a4+eSfSOJeXwg/dz8dTF1odPOe1sq5odgmvJY8
bt4JRd28PrvQkasP4vXGiv6pY01u/qE0FgN4MjYbfrQo83Tpw3k/zhsfywav
bnPz4iTZhbUbcGxP7G7XssxfFcv0jZg47Xmf25fY7uZr5oZ6Wo+ux5+7lh6Y
eZmnnPXW4e75gb427w43n3DWVYP7h089m4zLnOqvxuz5gceJ+zKnOqtwpv3i
0pt3Mh926vFiV/Pb8YPLMj/jfHc1nq4I91/27XRz05nfg08yLYXbUZm/dOZZ
sQPB5rL8AZmvc97/ZQfiv8ei7TKvcvJv9ovvh7f+65A5jS971feb6H1LnT9C
81tqPTmqx1Lr91P9oK73HK0X1P15TfsDt5T9zNB+Aij7T/NXQ4tyXlN0XqCe
L323DtR+8FI/wKjSP1SPCWq/naB+A7U/qU4/pJV+nqZ+hitK/1P9QfikeOkl
L7BK8UXrCsFfxWMteYSbil9abwMwroFxDYxrYFwD4xoY19q+CdfaPgvXwLjW
zlG41s5duAbGNTCugXGt9a1wrfW5cA2Ma2Bca+6Ea4txbTGuxxnX2r0hXNuM
a5txrd1jwrV27wnXyLhGxjUyrrV7W7jW7nnhGhnX2n9EuNb+O8I1Mq6RcY2M
a2RcI+MaGdfI/a//AwmRPno=
       "], CompressedData["
1:eJx1l1lslVUQx6+FFAO5Wuj2qUih9smIAUoIkMZ74oJWUQhraW+XlEoXtfRC
jSEkxtYgtEYw9EHUB6KmQAVqsXvBfGOX2wXaslwUsQYeXBIl5QFMNU2sxPP/
H/hOvE2aJpPpnJk5/9+Z+RYUbl/3aozP5/vszu+0O78DV3aHDoz/7Pr++3lI
+fBzDvbYpuDVuElHVbuZM0pLRgP0r5n0B5+74ah147vmLSu8FhiGfahnfvCL
S47KPjFr4e9VvwX6YS8p66tbespRxTETF0KZNwNh2MvUrk9i9ziqo2bJzTXV
twLfwd7pb7j++BpHtRcFa9KzJkz8eaMjx9oedNS36VcXXE+bDERgLy70T3WH
k9X7YyvDl3/9x+TZW/HyV69XJqsj/UX5q1+5Tw3Bnv/2tRURJ1ltrFw+Z0vq
NMX4tz49Gn60JUm9152z8sr4dDUCe+vQ90mhVUmqYnh4dkJzrGJ/hlqeevPv
0USVNb02Mbv8fsV8Hr6xqP6XtYkq4ky9NJky09ifL48/XzyYoDrenV+7un+W
yeex9v2h1hUJKj13ou3IVr+JX71kx9MzPo9X28Y+8hfffkCxrv7Ctakfx8Sr
L7uaGt/KiDN5fn1wbKohZ45aOHd52vq/4sy5HdviZffJ2aodf9n/J+HH/2N8
xuU5zId5MC/mz7xZB+N0oU7WzTiX0Rf2if5b0Ef2lfmH0PcW3APj7MU98d4Y
ZxPulfdM+1HogLpg/A+gG+qI8buhM+qO9k7okjrtZb3QMXXNc8uge3LAOLng
hNzQPwtckTP67weH5PJefgvqTmeQY/pXan/X9n9Rx3ft+Jt0Pq6dT5HO33BM
e5uu17XrbdX9cbvQn/Owu7qfhmP61+r+uyVW/+v1fQnvi/7gVuz7rdZ6kD+h
B567XetHyDH9s7XehHqjHdzKI5Y+W7WeJRN65nu1WOtfqH/qoUTzIuSF9gbN
lwyAL8Z/QvMozeDxIuzgVsixxbuQd8YHt3IcHJPTKp2HlIJj6j9V5y1LwTH9
X9B1Ct8r3gu4FXJ8FvZB3UfJBceXYAe3sgMc8/25re9J9oBj2nGvshkc096j
dSDHwfGg9/2XA+CYdUFn8g04NvxqXUoXOO7xziPpBsejjK91L2+AY/YfnMgG
cGzNRykAx+wPOJQRa56CW9Ecn82w5q8cAseDVvxnwXHEymcVOKY/uJV8cNxn
1XsaHHNeg1tpBsfsfwr62Q6OTXz0fx84ZnxwK8fAsTV/ZQM4ZhxwK1XgmP0H
t0KO2TdwK4Zj2MGtXATH9Ae3Qo7pnwb9k2PWC26FHNMObsVwDDu4FXLM+J3g
lxxTP+BWyDHtJxG3F+fw3NeQBznm+wBuhRybuY86MX+F78MF9GUu+sT889BH
csw44FbIMeOAWyHHZq7hXnNxz/Q/AR2QY577IXRDjqPMC+Pf5J0v5txe6LgU
umacCuieHNN/s3femTwPeeej8f/JO0/lXn73NUbOkGP613rntfGv8M530+dn
vPuA8Q969weTZ6d33zDn1uNdY3/MvMY7mGL1cy/eTXIcZV8y9iy8y3m4X9rB
rSLHrKsc7z45jrLvmfxHMFeoT9pbMIfIMe2LMLfIcZR99a4OMRfD4Muav4oc
kzvuzeSYXHNvxh5t4oBb1QiOyek72APIMeOAW7UMHEf5XrDfN8X3jd8vA9hj
yLHpG/aeneA4yvfOXX6xV+WB4x+4D2MPI8esl3vzQXAc5XvNNd8F2AtPgWPW
BW5VHzjmewhu1U5wbH9v5oBjzh3utYfBsTV/1R/g+P++fwvqfjzzL8SyJUg=

       "], CompressedData["
1:eJx1l2tM1mUYxt+Qg4LE4WUrbQTqtGKzD27pSidPyZyibaY2B5kONhvo0GVb
xcmUwca0ROlLVq95olk6R3YwGPneoNLJnC1DmHzAQ8zDMkNDBq5lPdd15//e
fLd3bNcenvf538/1u6/7P6F43eJVMaFQaPfd76i7375xqfH1m/qjof8+GS6E
D/WdBdWVyXfC7qkdZ+KWZn+fS73sztmqGTfC7tyf325Y8UiP6jOnj2+u6Q27
ykldN5aeupDbDb31eqR3UMJucUnjs1sTruj66zuGz++MhN3bKbUL+qf/oXrR
q62f168Pu5WZ1QmDBwdUP9zUveREbtj91HDoi3FH/sq9DD3ry8STJXFht/fi
SOyBr4d0fek7ZydvPpbuEnuemVbRPKL6wvfeKppTke7alhQueinyt+7TML9l
zWdPpLu4mItF4WjIcf3xmXPTb/2c5iQx6Vzv4zGqr3t51e2pr6W5vtK1eZVb
Rqk+b9JjtbXJaW5OxbS9xf2xqsdP/qQna3eqG44ZPzrx6XjVrwzNbs95MtUN
NjeeuFaToHokM3NGU2mKe7S6fF/dsdGqd69+PrJ19YPu05xNDxUMj1G95sjU
V15fmeyq3p1Sdm1KkuqSmBXqnDfWRfGXejXW8f+oc1/+DnWeg+fi/fLcfA7q
I3hOPjf3yUNdWCfq51HHtawr9HbUnfeg9cQ98d6of4N75T1TT4IP6Ave+z74
hj7i+U/BZ/Sd+hO+pE+pb4OP6Wvu8yJ8Tw64fgM4ITfU+8AVOaOeCw7J5b38
bkz5ahY5pp7j10ft+l/9/lG7/5v+PMoxz7/Inz9qz7/ZP69yTH2Fr0/U1uek
r2fU1nOPr380G/WnPsbfl3JMvdXfr3LMc8Z4P8h244eo949Y/1zwfhP6jfuA
W5lv/Dnk/SwJxs+3vP+F/qee7XmRD8EL9f2eL+kxfFV4HqXO8AhuRQy/tX6d
WN7BrRww/eEDfw6ZYPrJZX9uuW36D7gV26/AreSZ/oY6yiXTD1F3aTf9c5u/
J4k1/Rb3KkfBsennkm76ObiVJtP/4TP5ERybfJFiky/wsURMHrV438syk1/g
RN4AxyYfpd/kIziU9SZPwa14jjtn2fVzwbHd/zQ4tudZA45N/spCcGyftxEc
2/osB8e2np3gWH2O+u8Cx/a+xoJje78t4Jg6uJUHwLH1Dzm2fkNuqA5u5Tlw
TB3cCjlmfa7C/+SY68GtkGPq4FbIMXVwK+XgmPt3gF9yzPXgVpC/qh/Cvmfw
O9Qn4hzkmDq4FXJMHdwKOabugv1N9UvBfqh6R7B/qg5uhRxT/w73mo97ph4O
9nPVP4ZvyPF98kKY1wXBfNH1H8HHv8PX1Avhe3JMvTyYd6pnDATyUfXqYJ6q
/i+3u7acbiPHymMwr1W/Gcx3fa7S4Dyg/skPzg+6T0Nw3lD9BfS1YlOf48F5
5v+6oW9mm/qbeUn1dvTlBeZ+Q+jj240fosH5TXUz76k+G7mSb/w5iBxKMH6+
idy6avxv5lXVDyIXuwxf4NbVGR6PInc7DL+cmzFHq/4Lcr3Z9If3MQdMNP0E
3Loh03/M+4Ltb872tzLMMb+Zfsi5hxzf531H14Nb94PpzyWYwzJMP+fcvN/0
f/O+ZvPFFZp8Abduj8kjcOuWm/zinFoFjk0+uocHgvnIObje5Om9778bU7ra
/gGOOeMG
       "], CompressedData["
1:eJx1l31olWUYxs/O2VrNZKBCZaxNRbOB/SGklOJ5yiE6DUyN2DJlA2NTpmRQ
7eOYjQ1Ey+n6p1nH/JpoiqysbGP5PJu6vkz6MHU4yM9hjsbaxtna1of2XPet
7wUdOAx+vHvP897P9bvv551QuG7JqnAoFNp96xu59d1Rd/tz0Ib++ySbED7C
d+bFykePRMwTdWdTlmU1RoWXjJyvmNkTMRf/+GrDioe/UT5rxviGyo6IKZ90
rmfZmZ+UN3XHOxIuYpYU1T69NbVdeXfd0OWd8Yh5O71qYeeMX5UXvNJ0dNP6
iFmZEUtNHL6i/JP6C0tPRSPm+5ojnz507LryzM/SThelRMzeq8PJh764obz4
nfOTN58Im7T2p6aXNXQpX/TemwVzy8KmeWn+4hfj3cprFjSu+fixsEkJXy0Y
a3uUn5w1b0z/j0nGpY262DG1V/m6l1YNTHs1yVwqXptTvqVP+fxJj1ZVjU4y
c8um7y3s7Fd+z+SD7Zm7Q2YoPP7etCcTyn8bnNOS/XjIJBpqT3VVDiiPZ2TM
rC/+J/pIrHRf9YlB5RdWPxvfuvrv6EfZbz2QN/Sn8spj015+beVf0Yp3p5R0
TRlW7tIyQ23zR6IWf4XHcJ38n3C5r/yOcFmHrEu4rFueQ/gwnlOeW3gO6iJ1
En4ZdVyLugpvQd1lH7Se2CfZN+FfYl9ln4WPQg4kF8L3ITeSI+FnkDPJneYT
uZScCt+GHEuuhT+P3IsHwjfAE/FG+CV4JZ4Jj8JD8fJufzem758tHgvP9tdb
vv4Xf3/L93/Dr8fyehb79Vte/2b/vJafd4Wvj+X6nPb1tFzPPb7+Novqf5/f
L8v71eT31/L+hn0e7HbKg/X5sZyfKz5vlvMGb+0Cyuegz7NNpTz3+/xbzn+W
98V+QL4c8H7ZdvKrzPtoq8lHeKseC6/y11n2Hd7aQ9Qf3vfrsBOon9zw63YD
1H/greN+BW9dDvU31NFdo36IursW6p/b/D65ZOq32Fd3nPozcuDGUD+Ht66e
+j9y5r6jeYFcukKaL8ixi9M8avS5dy/Q/IIn7nWad/DKddJ8hIduPc1TeOu8
x5/P5uvnwWO+/w/wmNezBh7T/HWL4DE/by085vosh8dczzZ4rDlH/XfBY96v
++Ex728jPBYOb10SPOb8iMecN8wN5fDWPQOPhcNbJx4Lv4n8i8fC4a16LBze
qsfC4a0thcfCW+GveCwc3srcVn4E9z2L3xE+EesQj4XDW/VYOLxVj4WbYH9T
fi3YD92d9Qf6p3J4qx4L/xr7mot9Fj422M+V70duxOP/mRfK84LzRfmHyPHv
yLXwfORePBZeGpx3ysf1Buaj8lhwniq/7e2uLa5ZPFYfg/NaeV9wvisvDp4H
lOcGzw/Ka4LnDeXPoa8VUn1OBs8zd+qGvplF9afzkvIW9OWFtL8h9PHtlAcb
PL8pp/Oe8jmYK7mUzwTmUCrluQ9z6ybln86r6sthzMVz5Be8jVaTj8cxd1vJ
Xzk3x8j3nzHXG6g/7MA5YCL1E3hrBqn/0PsC9zfD/a0E55jr1A/l3NNK/ZPe
d5TDW/Mt9ecinMPGUT+Xc/MB6v/0vsbzxeTTfIG3Zg/NI3hrltP8knNqBc07
Odc+2Bucj3IO3kTz9O73343pbc3/AkGQAV4=
       "], CompressedData["
1:eJx1l31olWUYxs/O2VrNZKBCZaxNRbOB/SGklOJ5yiE6DUyN2DJlA2NTpmRQ
7eOYjQ1Ey+n6p1nH/JpoiqysbGP5PJu6vkz6MHU4yM9hjsbaxtna1of2XPet
7wUdOAx+vHvP897P9bvv551QuG7JqnAoFNp96xu59d1Rd/tz0Ib++ySbED7C
d+bFykePRMwTdWdTlmU1RoWXjJyvmNkTMRf/+GrDioe/UT5rxviGyo6IKZ90
rmfZmZ+UN3XHOxIuYpYU1T69NbVdeXfd0OWd8Yh5O71qYeeMX5UXvNJ0dNP6
iFmZEUtNHL6i/JP6C0tPRSPm+5ojnz507LryzM/SThelRMzeq8PJh764obz4
nfOTN58Im7T2p6aXNXQpX/TemwVzy8KmeWn+4hfj3cprFjSu+fixsEkJXy0Y
a3uUn5w1b0z/j0nGpY262DG1V/m6l1YNTHs1yVwqXptTvqVP+fxJj1ZVjU4y
c8um7y3s7Fd+z+SD7Zm7Q2YoPP7etCcTyn8bnNOS/XjIJBpqT3VVDiiPZ2TM
rC/+J/pIrHRf9YlB5RdWPxvfuvrv6EfZbz2QN/Sn8spj015+beVf0Yp3p5R0
TRlW7tIyQ23zR6IWf4XHcJ38n3C5r/yOcFmHrEu4rFueQ/gwnlOeW3gO6iJ1
En4ZdVyLugpvQd1lH7Se2CfZN+FfYl9ln4WPQg4kF8L3ITeSI+FnkDPJneYT
uZScCt+GHEuuhT+P3IsHwjfAE/FG+CV4JZ4Jj8JD8fJufzem758tHgvP9tdb
vv4Xf3/L93/Dr8fyehb79Vte/2b/vJafd4Wvj+X6nPb1tFzPPb7+Novqf5/f
L8v71eT31/L+hn0e7HbKg/X5sZyfKz5vlvMGb+0Cyuegz7NNpTz3+/xbzn+W
98V+QL4c8H7ZdvKrzPtoq8lHeKseC6/y11n2Hd7aQ9Qf3vfrsBOon9zw63YD
1H/greN+BW9dDvU31NFdo36IursW6p/b/D65ZOq32Fd3nPozcuDGUD+Ht66e
+j9y5r6jeYFcukKaL8ixi9M8avS5dy/Q/IIn7nWad/DKddJ8hIduPc1TeOu8
x5/P5uvnwWO+/w/wmNezBh7T/HWL4DE/by085vosh8dczzZ4rDlH/XfBY96v
++Ex728jPBYOb10SPOb8iMecN8wN5fDWPQOPhcNbJx4Lv4n8i8fC4a16LBze
qsfC4a0thcfCW+GveCwc3srcVn4E9z2L3xE+EesQj4XDW/VYOLxVj4WbYH9T
fi3YD92d9Qf6p3J4qx4L/xr7mot9Fj422M+V70duxOP/mRfK84LzRfmHyPHv
yLXwfORePBZeGpx3ysf1Buaj8lhwniq/7e2uLa5ZPFYfg/NaeV9wvisvDp4H
lOcGzw/Ka4LnDeXPoa8VUn1OBs8zd+qGvplF9afzkvIW9OWFtL8h9PHtlAcb
PL8pp/Oe8jmYK7mUzwTmUCrluQ9z6ybln86r6sthzMVz5Be8jVaTj8cxd1vJ
Xzk3x8j3nzHXG6g/7MA5YCL1E3hrBqn/0PsC9zfD/a0E55jr1A/l3NNK/ZPe
d5TDW/Mt9ecinMPGUT+Xc/MB6v/0vsbzxeTTfIG3Zg/NI3hrltP8knNqBc07
Odc+2Bucj3IO3kTz9O73343pbc3/AkGQAV4=
       "], CompressedData["
1:eJx1l21olWUYx0/HzaNnrrnzDCpjbSpaDeyDkFKKu8shOg1MjdgyZQNjU6Zk
UO3lmI0NRMvp+tKsY74tNEXWq20sn2tTp5WJkU2H++BbI5XMps2xiajd/+t2
zx86cBj8ePac+7nu/++67mds8aoFy8KhUGj7ve+we98tDfc/e/zQf58ME8JH
+daCeGXqbc8823AqeVH2j7nKy26frpp63TNn/zm6ZsnjXY5PmzKmqbrbM5Xj
O68vOnHB8ZZrie4+8cyCkvoXNkYuO36tYeD81oRnPkirmdsz5W/Hi95s+Xrd
as8szYxH+vb1Ov5V45mFR3I980vd/m8eO/Cv41nfRo+XJHtm58XBpL3f9zte
+uHpCesPxUy06/nJFU2Djs/7+L2imRUx07qwcP5riTuO181pXvHl0zGTHL5Y
5Pkho/zwtFmxm7+mG4mmnO1+Kuz4qteX3Zr0Vro5V7oyr3LDMMdnj3+ypiY1
3cysmLyzuCfJ8eET9nRlbR9tBsJjRkSfG+745f4ZbTnPjDZ9TfVHrlZHHE9k
Zk5tLE0zT8TLd9UeGuH4meUvJTYuf9h8kfP+IwUDIx2vPjDpjbeXppqqjyaW
XZ2Y4rhEs0Ids0cZH3+Vx3Gd/p9yva/+jnJdh65Lua5bn0P5IJ5Tn1t5Huqi
dVJ+HnVciboqb0PddR9cPbFPum/Kf8C+6j4rT0EONBfKdyE3miPlJ5AzzZ3L
J3KpOVW+CTnWXCt/BblXD5SvgSfqjfJz8Eo9U54LD9XLof6uTftuunqsPMde
7/P1v9v7+3z/d+16fF7PfLt+n9e/3j6vz8+7xNbH5/oct/X0uZ47bP39bKr/
SLtfPu9Xi91fn/c3bPMgmykPvs2PcH4u2LwJ5w3eyhzKZ7/Ns0Qozzdt/oXz
n219kU/Jl93WL+kivyqsj1JLPsJbEfK3xl4n7Du8lb3UHz6x65Cx1E/+tOuW
W9R/4K1wv4K3kkf9DXWUS9QPUXdpo/65ye6TJFG/xb7KQerPyIHEqJ/DW2mk
/o+cyc80L5BLKab5ghxLguZRs829vErzC57IOzTv4JX00HyEh7Ka5im8Fetx
x3S+fhY85vufhMe8nhXwmOavzIPH/Lz18Jjrsxgecz074LHLOeq/DR7zfo2C
x7y/zfBYObyVh+Ax50c95rxhbjgOb+VFeKwc3op6rPwK8q8eK4e3oh4rh7ei
HiuHt1IOj5W3w1/1WDm8Fcxfx/fjvqfwO8rHYR3qsXJ4K+qxcngr6rFyE+xv
jl8K9sMh6w/0T8fhrajHyo9hX/Oxz8q9YD93/HPkRj3+n3nheEFwvjj+GXL8
F3KtvBC5V4+VlwfnneMZvYH56Hg8OE8dv+/ttg0nW9Vj52NwXjt+IzjfHS8N
ngcczw+eHxyvC543HH8Zfa2Y6nM4eJ55UDf0zWyqP52XHG9DX55L+xtCH99M
efCD5zfH6bzn+AzMlXzKZx/mUITyfANz6wrln86rju/DXOwkv+CtqSUfD2Lu
tpO/em6Ok++/Ya43UX/YgnPAOOon8Nb0U/+h9wXub4b7WxnOMX9QP9RzTzv1
T3rfeZA3nKt+ov5cgnNYBvVzPTfvpv5P72s8X0whzRd4a3bQPIK3ZjHNLz2n
VtG803Pto73B+ajn4HU0T4e+/65N62y9CzNdrcc=
       "], CompressedData["
1:eJx1l39olWUUx/dLW45su7v3jpYKa+TKMNGmFc3us8pwdc1dQQvDrZUj2h8L
GxZFbBXZ3EjMTNPWhbapbGEZhmyQ+R4mhNk1aJQtE92lH0tz3a3QLVea8Xy/
T70HduFy4cu55z3Pec7nnPMWPf70itqMtLS09ivfzCvfZZEbQnVD5yPv7Pz3
EzZp+DwIvb00t6d4W9iMVZ4aal6biNA+/PL8/sPNYXNrdHTVcNXJyHLoY1mv
LmhaFzZddfOG5pufnH2yv7yjakXY7OuLH2hZei4Shd4dHayrnxM2eXXP9Xzf
Mer0xRsWVR76M2Sypxx66sXC804fvOW+1hoJmZHqB7YcaRl3evv6tk/rG0Nm
9f2bCmpTE+65nZnrfr98W8g0NfX1Xqy47OwfW7aydUEyaNpLepdcH0031NfE
20pLXgua0OaCe2vPZTh9bmlDMr04aI6W9aXfviHLPAR9W3fPx2d68s2FfV8W
pUJTDfO2/MbG0ewl+eZ47MT6VPwqZ795Y+0frx8NmLZNz5fHZ1zt9LWzPgrs
WRowkZujz9Zsmeb01A9ztzd7eWb24XiqayLH6d+NXIo/OS/PFPz6wt4fV1/j
9Gf+Xji9aUeuueNMcXbrh9OdfvrsZyOBC9eaU/ilfifs+D/q9MvnUGccjIs6
4+Y5qL+Lc/LczOcA8sI88b7GkMe3kFfqXyDvvAdXh7gn3hv1Dtwr75n6S6gD
1gXjeRR1wzqiPoo6Y91Rn4a6ZJ1Sz0cds6753P2oe3JAXt4HJ+SG9qXgipyx
rjJilkNySftjiURi73BvGTmm/VnLraftS6x/j/55X7tsPJ6O5wMbv8f4ed5c
e16P56WfqTY/3t0qPymbT4/5pP0jNv9eB/LP5zba+/L0fYFb4f3ST8DWg1Sj
Hmj/ua0fYf3QftzWm7DeqINbqUR9Ut9h61neUPW82Na/6PovsbzIb4qXsOVL
ToAvnneR5VEaFI/gVk4rfsGtaN7BrVyn+gPikJtUP3nCxi1G9R9wK+xXPC+4
lQHV37baPMpFcMxzIe9CjqlX2XuSIDimjnuVTnDsuLZ1IBtVPwe3sgYcs/5R
ZzKs5gW4lRxwTP+oYykEx2p+yQFwzPOCE+lU8w5cyV3gWM1TKYv55ym4Fcvx
kTJtn2PtPe2/CBzreLaDYx1/FzhW81eC4Jh+wK1MAcfUk8jnL+CYOriVh8Ex
dXArr4BjxlOD+30PHNMe3EoeOFbzV8gx/YBbwdxwOriVb8Ax/YNbIcf0D26F
HGteyDF1cCvkmH7ArSwEx7QfBL/kmDq4FXJMfSb8fovncF7M8fcTZw9uhRxT
B7dCjpmfr5GXGPJE+wnkkRzTPuHvn04Ht0KOqXfhXqtxz9RbUAfk2PUB1A05
nmReOPt0/3xx+gz/PHJ6r39+ufPu9s87p9f756OQx4qYb57K//kt399/kBzT
/lKlb147+wr/fHfP3erfB5z9bv/+4PIT8O8bTh/Psn1N5+dn9MGkyudK9E1y
PMm+5OLc5d+vnH0u+jg5VvPX6PpR+56z/wpzhfVJ+7cxh8gx7cv8+6eLU+2r
zk8h5uIA+KIfcGvIMfWTmLuDil/uzdijnf/jmOuzVH8Yxh5Ajsk1uDX3qP6j
3hd0fzPsb/T/JvaYv8Ax/XDvOQaOJ3nf+a8PY6/qBsdq/ppW1c+5N1eD40ne
1/R8MZngWM1fMxMc6/fHT8DxJO+bzj/32gZw7PYE7MGr1Dzl3mzn78DBfwCN
79td
       "], CompressedData["
1:eJx1l39MlWUUx/mlkSyDC/eySN0YK4oCBNFqUfdQ2aTRAjet2YQwWYs/cMas
1RpUyxCWMzPJorsFaINm2WwOtsz3DLcmdm2LlZE5g/XDNOlCTSExzfZ8v896
n+2yMbbvHr7vec9zPuecN3fdhpUNSQkJCd1Xf5Ov/i7uvLRueMP58Lvv/PcT
kgT8lEDvLksfyNsZkunqU6fb1kfDhdBDL5eMHG4LSVHV1OqJ2pNWn055tbR1
Y0j6GotPl8gvYfqPj1T01K4Myb6hyIH2FefC9O+vGmtsKghJRuNzAz/0TNnz
92xeVn3o76Ckzjn09Is5560+dtsDHfUalMm6h7YfaZ8JlzLOTV2fN7UEZc2D
W7MbYrPhIui9yRv/vLIkKK2tQ4MXK69YnyceXtVROp4l3fmDy2+sShT6rI10
leW/liXBbdn3N5xLEp4vLGseT8zLkqPlQ4l3bE6R26Hv7B/49MxAplzY91Vu
LDhXlkB/5KaWqdTlmXK85sSmWOQa67NtS8Nfrx8NSNfW5ysiC64V5m39ok8C
H6wISPjWqmfrt8+TYuixnwo727wMuflwJNY3m2b17ycvR54qzpDs31/Y+/Oa
66z/M/8snd+6K13uPJOX2vHxfGEefjz7xWTgwvVyCn/53Ltwjv/H8/Tlc/hc
xsG4mAfGzffg+ffwnnxv6qPIC/PE+KeRx7eQV8bzJfLOe+D5EO6J90a9B/fK
e6bPS6gD1gXPP466YR1Rn0Kdse6oz0Ndsk6pZ6KOWdfU96PuyQHz9iE4ITfU
y8AVOWN9JtUYDskl/Y9Fo9G9E4Pl5JjnzxpuPZ6nf77x9+hPfbeJx2M89P/I
xO8xfvqnm/f1+L70mWvy493r5Cdm8ukxn7yXx0z+vR7kn3qLuS/PvS9wq7xf
Pjdg6kHrnHoYNvWjrB/6z5h6U9Yb6xPcajXqk/ouU8/6BurZ9itT/8r6p55v
eNE/wIvtn4YvPQG+GM8yw6M2OzyCWyXHDu9K3pkHcKs3gGP6IA69BRzT50kT
two4dvqVsl+xb4NbJcfMzw6TR70Ijqkj70qOGU+tuSfNAsc8j3vVXnBsuTZ1
oFucfg5udS04duaFToBj+oNbTQPH1FHHmgOOqaPu9QA4duad9oJjZz7q3eDY
madaDo6d+auG4yPl7vk0c95z/XPBcZETTyc4duav9oHjxc77ZoFj1g+41Tng
mP7jyOdv4Jg6uNVHwbEzf/UVcMz463G/74Nj6uBWM8CxM3+VHFMHt4q5YXVw
q9+CY94juFVyTB3cKjmmD3khx3wvcKvkmOfBrS4Fx8znGPglx3wuuFVyTP+F
8P0Oz6FPgb+fWB9wq+SYOrhVckyfb5CXGuSJz51FHskx9ai/f1od3Co5Zh76
cK91uGfq7agDcky9FnVDjuPMC/vcRP98sfoC/zyy+qB/ftk87PHPO6s3+eej
jaeyxjdP9f/8VuwfOUiOOR8vV/vmtfWv9M93G+cO/z5g/ff49werB/z7htVn
Ukxfc/PzK/ogOeb5Veib5DjOvmT13f79yurp6ON1Tj0M+/c3qzv7ntW/xlxh
fbKe38YcIsc8X+7fPzXOvmrjzMFcHAVf9AG3Qo7pcxJzlxzTh3sz9mjrcxxz
fZHTHyawBxQ4/QTcyn1O/3G+F9z+JuxvnBdvYo+5BI7ZV7n3HAPHcb53bDzg
VvrBMfMAbqUDHDvzV+rAcZzvNdv/uRcmg2Nn/spCcOzMX/kMHMf53rTzi3tt
Mzh2v2dXg2P3+9fM39GD/wL1Oaj9
       "], CompressedData["
1:eJx1l31oFHQYx68tF8saopPsRb1N3Xnzln8Y5dK1Xy0zN9LarSA8y11TCopF
lia00ZtQvmxp6t5OZeVWGGSrWTJf7iEdYaPMl7O18DY9utoYQhQbUsNWv+/3
R78f3MEQvjw+9/ye5/k8z3M54eryNWkej6d1/C99/G/3S23Jh87nqrX/fpI+
5cGnBXruBz+d//SST/0YSPS2ZsSLd0F/riT+97vnfOqJqxNOdHquFDdBDw4f
Xjd2xKeKskJh78YRo/95csqmyS0+dbH6w+obBseMnpEXnH/hRZ+6+/Zyz3vt
aYp6fv3LM54s8qmfX403Fz+WoRjPyJWNbQc943E+3Hht5h+ZKgL9UuyZL3/v
ylOdozHv15tvVu9Djx4/1nvv83kq5E+vXbVlktoBfcgnMw5k56k322uyz5ZO
Nv5Lvrnp1nDnHLUn1rEgKz1b8b2Vn2Weeqdsjvo+Nn1q1RdTVT30j04PbF/a
N1t5ztVO8q+8RTVCL2/3z+1ZPVvtK7qz/9DVaaqZelfJ6yX9s9RQuT++tu42
xfx7O549knh8lgr/8vHyyLQ7jJ/aupopl0/mqrnJ+bu6Gqabd9VnfdK9IZCr
HukZXZ8/cabaC31ZXfdfA1tz1I2lZw4ECr3G//oXtnWGkl7zL/WJsOP/o3/6
5fcwfsbBuOiHcfMd1IfxTr6b/luRF+aJ+nXIYzvyynedRt5Xow6Mh3Vi3ViX
t1BX1pn6KvQB+4L+D6Fv2EeMPw19xr6jfhF9yT6lvhB9zL6mPoC+JwfUFTgh
N9RD4IqcMc4EOCSXtF8w/jkR+nYxOab9KW0fde1XaP9R+qdeqOOJuvH06fij
jJ/+79LvFb6Xee7T+ZF5yA/try39L5/i5vNznX+57OR/pa6XsF7sE3ArrC/1
Jt0PsgT9QD/f6f4Rckz7NN1vwn6jDm4l6PTnr7qfpQL9zD6s1P0v7H/a+zUv
Ql5oX6b5EvJF+0zNo5SBR4dfIb+0L9V2Qt6Zf/iV5eCYfmp0HDIPHG+3549U
gWP6D+p3CucVdXAr5Jjzqk3nUa4Hx5yr4FZ+AMc7oT+o6yQt4HibPZ/lbXBM
++O6D6QSHDOf4Fa+Asd77H0hY7rvTB7ArfSDY/pHH0sxOG6w95ckwDG/F5zI
QnBMP+BKqsAx7cGheAs0x87+Fc1x32Jn/8owON7t+F8GjiNOPPnguNmJPwaO
G5z3FoJj1hfcSi84pp9R5HMUHLPu4FY6wDH7ENzKU+B4p1PfN8AxdXArjeCY
cYJbIce0B7eCvWHiB7eyFxyzz8GtkGPa56D/yTH9g1shx8wD+SLH9ANuhRwz
DxtsfoXzENwK9q+wvkH43Yrvof8A4iDH9F9lzx8TJ7gV7F+jR+z5Zr53AvJI
jmkPboUcM54I6kSO6Wcz6vob6kx7cCvkmPaH0TfkOMW+MPYxe78Y/X57Hxk9
ae8voy+y953JZ5O9H419QYG1T+X//O7oThwlx4w/bu9rY7/O3u/G3mffA0Y/
a98Pxs899r1h9B7MtQDyQz8jmIOjTj4PYm6S4xT3krHfhLk8iPpSb8AcX+L0
A7g1HKe494x9E/ZKBfqT9knsoQqnn5/G3spx+t+5V827HsVerHP4AreGY8bz
CvYuOabOuxl3tJkz4FZVgGPG8xruAHLMfce7YQ04TvF7wZ1vivON9d2POyYD
HHM+824+A45T/N4xcw/cqi3gmP6P4Q4Lg2POZ97NXeA4xe814e8p3oUXwDHf
xTvyAXDMPPPuHATH7u/N+8Ax88+7dh84dvavWlRg71PezXr/Dh39B1LSOHI=

       "]}]}, $CellContext`th$$ = 
    0., $CellContext`x$$ = -5., $CellContext`xoffth$$ = 
    0.5980074999999999, $CellContext`xth$$ = -4.4019925, $CellContext`y$$ = 
    0., $CellContext`yoffth$$ = 0., $CellContext`yth$$ = 0., Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`th$$], 0.}, -180., 180.}, {{
       Hold[$CellContext`x$$], -5.}, -10, -0.05}, {{
       Hold[$CellContext`y$$], 0.}, -10, 10}, {{
       Hold[$CellContext`xth$$], -4.4019925}}, {{
       Hold[$CellContext`yth$$], 0.}}, {{
       Hold[$CellContext`radiusth$$], 0.5980074999999999}}, {{
       Hold[$CellContext`xoffth$$], 0.5980074999999999}}, {{
       Hold[$CellContext`yoffth$$], 0.}}, {{
       Hold[$CellContext`laststartposth$$], {-5., 0.}}}, {{
       Hold[$CellContext`lastlocposth$$], {-4.4019925, 0.}}}, {{
       Hold[$CellContext`lastth$$], 0.}}, {{
       Hold[$CellContext`staticpolygons1118640200831284558144170$$], {
        GrayLevel[0], 
        AbsoluteThickness[0.5], 
        Line[CompressedData["
1:eJyFmnlwV9UVx19WCAkkIQuLkUCQkFJZJEsFxHukw74MiwIVKGVzLGUrOgUj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         "]]}}}, {{
       Hold[$CellContext`staticpolygons211864020083128460945430$$], {
        GrayLevel[0], 
        AbsoluteThickness[0.5], 
        Line[{CompressedData["
1:eJyNlT1IQlEUx1+a9mFERhrWIEFEtCtBQ0L0RR9kBQ5WQtlWSC2SDYpDQRB9
UTk1tDTU0B70pMkhXCqqrUAiIgzBCiMl8d17Hl74YxfecH4c7jv3nP85p2XW
Nz6vkSRpIv9p81/sYXVpK5mQpcKxRCV2nnaTZ/vnHwqPNhKPO40282Va4SEz
8SZXa8RqzyjcYVL9byJG3VCW3d9AvH20t/kkLCl2tJ54zB3e/LZpFDtkJG5f
3vhyXmkV21FH3Hs45bZ06JhdSzx3nIqP+PTsHgNxf48ncLRXwewqNZ6DnWF/
pJL564mfeqxBQ5D7lRM32Z/l6YFq5l9G/O4tu933ybiUkzn/ee3sX1njcWSI
B+YmU+u/nKeJd7kfZ15cNYwniS+MyYvvEc4TxAfbvBf3Mue3xK8Lh3P1CP7d
4H7iQjzEhfiJC+8lLuSHuJBPB+dC/okL9SIu1Je4oAfign6IC3ojLuhTjadY
z8QF/RMX+kX1L+4v4kI/qvEU929Jju5B/4VxgnehPKC8oTyjuqA6orojnSBd
IR0i3SKdo75AfYT6DvXpP/u65NxAcwbNJTTH0NxDcxLNVTSH0dxGcx7tBbRH
0N5BewrtNbgHwd5EexbtZcT/ALb6qpI=
          "], CompressedData["
1:eJyVVT1IQlEUvmlaZkQv0rAGCSKkXQka3oXoj37IChyshLKtkFokGxSHgiD6
o3pTQ0tDDe1B99DkEC4V1VYgERGGYIWRkrTdC9/Qg7t8HM6795zvp3UmMjZn
YoyNl4+5fFL3K4ub2Yxg0ueix53s6d7Zu4xTE6X9mtd5kZfxhJOaA22G21eQ
ce6g9LWhWQaLSv9G8oz0tBwnGcn9GygVTG58eU0yntDIt7T+6b80yzivp/DB
ZNDVYZFxVkelo1x6OGJV+tgp2h2KHe5WKfU28uxvD0WNaqXeSichd9wetyn1
leTwPYmp/hqlvoJuX4tbvR8Kzkri+6Wzb3nVruAFEZudyK39qHhedAUfpp8D
tQqeFfOjYuHNUPGMGGgPn98JFb8RV3+fijMG6nXQXwf30cH9dfBeHcxHB/Pk
YP4c7IuD/XLABw74wwHfOOAnB3zmgP8c6IUDfXGgRw70C3HUB/0X3hO8C80B
zQ3NGe0F7RHtHfEE8QrxEPEW8RzpAukI6Q7p9J+6hr6BfAb5EvIx5HvIJ5Gv
Ih9Gvo18HuUCyhGUOyinUK7BHAS5iXIW5TLCfwEU1KqS
          "], CompressedData["
1:eJyN1U0ow2EcB/C/beZtNCaSlzUypVAubuPuhKtSihyYm7TsICsrUsouDq7k
hBuHTQ6UUsoFUctByrCYWfO65nm+6lff5l//w/Np/fc8v+f34hqe7B8xGYYx
kHnNmTdaY7cGZ28jRvap3DfUs+G2z32FnpQ74GMtDZ3h8xflFfDYVnNvj/9N
eTk8/hx0Lh2mldvhqeB0qyfyqbwMHtg+Kz7oMtTaBk/fvDofvXlqXQw/bmzy
h+dNal0IT56E3vsCZrW2wkezj0WtLfBNq8M13pGv1ia4r21qdSWq3YCv1axX
X/v0dz8i2m31tVdV39pTcO/e7tDDRIHyBNwUW7bdH2mPw4+L6i5mSvV57uDt
CzvphEd7FO5OllwuDmo/hf+e9y8u5Pfd5PtwsR+42D9cnBcu4gMX8YSL+Pdo
F/cFF/cLF/kAF/kDF/kGF/kJF/kMF/kPF/UCF/UFF/UIF/Wb09l32P+yfbJz
sTiwuLE4s3th98juneUJyyuWhyxvWZ6zumB1xOqO1ek/6zpn32B9hvUl1sdY
32N9kvVV1odZ32Z9ns0FNkfY3GFzis01NgfZ3GRzls1l5j/8GZHy
          
          "], CompressedData["
1:eJyVlU8og2Ecx1/bDDOaP9HyL2RKoVzc9j53J1yVUuTA3CRxkJUVKWUXB1dy
wo3DnicHaqWUC6KWg5RhMaP5Hye/+hy89V4+rXfP8/t9/9QPjPUMOizL6v1+
nd9vwu9zR2autPXnKTfrAd/sR/Re8DIz3FzbETt5FLzUJDebutT0s+AlJvUQ
qVvczwruMy+RiZagfhe82IS3jj17nZb5y70me/lUdxfKEdxj4g2N07E5h+D5
JnMYfe0OOwV3m6GfxyW4y2y4y+pH2nMFd5jJ1vGV5YTklln1r1VeTLoFf9Pe
mqrzik/JX3Rod6f/djRP8LR2JJe8NweSp3S8oPp0qihf8GvdNr+dTQclT+hA
pvBsoU/yI/17X8ktC35vw/dtOI8N57fhvjbMx4Z52jB/BftSsF8FelCgHwV6
U6BPBXpWoH8FflHgLwV+VOBf5PQd+l86J92L5kBzoznTXmiPtHfSCemKdEi6
JZ2TL8hH5Dvy6T99jblBOUO5RDlGuUc5SblKOUy5TTlPvUA9Qr1DPUW9Rj1I
vUk9S71M/AvV+5Hy
          "], CompressedData["
1:eJyV1UsKglAUBuDrYyOtpNZQOwgat57aQavIJTR06MCBAwciESIiPQik8IM6
4ORDfNx77n8W2/16F4cQNo8reVzHw7NO5/CqNAvv+vQEHsMjeICP53kf4D28
g9/gV3gLb+A1vIKX8AKewy/wDD7V1/1LPB+ewwt4Ca/gNbyBt/Ar/Abv4D18
gI/wsJr3CB7DE3j6p+s5eq++U/+lddC6aZ21L9pH7bv6RH2lPlTfqs91LnSO
dO50Tqf6LQeUG8oZ5ZJyTLmnnFSuKoeV28p5zQXNEc0dzSnNNc1BzU3NWc3l
ye98hwBd
          "], CompressedData["
1:eJyV1bENgkAUBuATWMRJdAbdwMTaeXQDp+BGsKSkoKCgIIQQQggRSxO+ApJr
vuKAu/f+d7w9LvckhHBdV7qu1/P3vPPw92Rx21N4Aj/AA3zJt32GT/ARPsB7
eAdv4Q28hlfwEl7AP/AI173HE/aHF/ASXsFreANv4R28hw/wET7BZ/gCD2f0
CzyBp/Bsp2sfvVffqf/SOejcdM66F92j7l11orpSHapuVefqC/WR+k59yr7e
mRvKGeWScky5p5xUriqHldvKec0FzRHNHc0pzTXNQc1NzVnN5Sx+AX/aAF0=

          "], CompressedData["
1:eJyV1ckNAjEQRNEW+74nQCaOATJA4kwKnQZkQBQ4NAbEASTeYSz58lXqGdvd
VfvT5XDuRMSx2d1m366vdX/Ee+1qfNYPr9v/PMELeIDXDeqDF/AAr2vUBy/g
AV5XqA9ewEN1ltCD5wJ68JxDD54z6MFzCj14TqAHzzH04DmCHjyH0IPnAHrw
7EMPnj3oW3LW0Xf1nzqX7kH3pnvWu+gd9e7qE/WV+lB9qz7XXGiONHeaU821
fEC+IZ9p6WPyPfmkfFU+LN+WzysXlCPKHeWUck05qNxUziqXv/gTK1f7Mg==

          "], CompressedData["
1:eJyV1dkJQjEUhOHBfd8bsJNbg3Yg+GwLaUM7sApTmgu+CH6Igbz8DOfeJOfM
bA+n3bGVZP/Y7ce+nJ/restrdZq81wcv4OlCD54e9ODpQw+eAfTgGUIPnhH0
4BlDD54J9OCZQg+eGfTgmUMPnsV33oAX8AqeJeqDF/AKnhXqgxfwCp416oMX
8AqezX9cdfRd/afOpXvQveme9S56R727+kR9pT5U36rPNRecI82d5lRzLR+Q
b8hn5EvyMfmefFK+Kh+Wb8vnlQvKEeWOckq5phxUbipnf/M7J8jRog==
          
          "], CompressedData["
1:eJyV1ckNAjEQRNEW+74nQCaOATJA4kwKnQZkQBQ4NMwRad5hLPnyVeoZ291V
59vjch9ExLXtYduv52+9P/G3TrWT12M3T/ACHuD1gPrgBTzA6x71wQt4gNcd
6oMX8FCdLfTguYEePNfQg+cKevBcQg+eC+jBcw49eM6gB88p9OA5gR48x9CD
5wj6npx19F39p86le9C96Z71LnpHvbv6RH2lPlTfqs81F5ojzZ3mVHMtH5Bv
yGd6+ph8Tz4pX5UPy7fl88oF5YhyRzmlXFMOKjeVs8rlxr9Xivsy
          
          "], CompressedData["
1:eJyV1ckNwjAUhOER+05YGqCT1AAdIHGmBbcBHVAFLo1wRMp3wJIvv0Yvsf3e
zOl6P98GSS7dHnb7+fiu1zs/a9T28gKeMfTgmUAPnin04JlBD5459OBZQA+e
JfTgWUEPnjX04NlAD54t9OBp+nkLXsAreHaoD17AK3j2qA9ewCt4DqgPXsAr
eI7/cdXRd/WfOpfuQfeme9a76B317uoT9ZX6UH2rPtdccI40d5pTzbV8QL4h
n5Evycfke/JJ+ap8WL4tn1cuKEeUO8op5ZpyULmpnDX/AKCK0aI=
          
          "], CompressedData["
1:eJyF1V1Ik1EYB/ChS6oVLn03ImjZINzNunFKKuNZQghBQUa4oiCFboRI0Ivw
JiqCSMFb+7iRhWLEgopwdpFJF3Uh0ee8eBGc2ogxGBubF66Pt/c8+wcPHN4D
782Pw3mf8/E/5/Dgtb4rdS6X66z11VvfKQr6hrJlenD/X/MvurhNV8NPU9US
pQJ3cmeu++CpbFt4R7BI6cRwdHe/AQ+Nbz08Hi9QJXRxcqm9Gf7CXO4wY3ny
JXvXxowm+Gz3wq8jWz8p0ma1khfuvvdy181vP+ixNXw60QgvLD8fPLC6Tpkx
I9k7sBceD5640dq8RoesMucDHvhoV2FqKW+SVU05ZO78P87XzmTVv8LzbYA3
Xsh2x2e+8Lzc8KNdJ28HYh/JsOuvg+fm2qPnvO+5zj9vah65mwlm3r2lgF3P
Ntw82DrS/2Gepuz/VuB94T0D0fQzHr8I7/Gsxuor09Rij5ODf7o0Efn+e5K8
dv8M/PTErSdX3cPsn+G6NsT9W1R/qnmex9+vxoeLeuCXuX7Vvwjf5Pk+UvOF
H+P1UeNsw8V6wjt4/f1q/WM138f7taL2C17m/VX/bYCL8wA/z+dH1eOBl/i8
bajzBhfnEy7OM/wVn39VfxNc5AX+mvOl5mXAE5zHBZVHuMivo4tcw0WuHesU
uXZcB926iVzDRa7hun0UuYaLXMNFruG6cyhyDRe5hotcO+ZI5Boucg3XNZFr
3AMi1473jMg1XOQaLnIN192TIteLNRe5hotcw3X3vMg1XOQarnt3dO+UyDVc
9w6KXMNFruG6d1nnfwHOe2s5
          "], CompressedData["
1:eJx1lU9IVFEUxh86STWFk74ZImiygXA208ZRUhnuSQghKMgIpyhIoY0QCrYI
N1ERSApu1drIRFLEBBXh2OLepEUtJPo7Lh6CYzXEMDDMMOPC6c/r3biLA9+B
u3gfl/O+c+753Xt4eHTgSoNlWWfd1eiuUyISHMlXhfU/5uf+RUgt1GNPMvWK
0TPhO4Uz14Mqk++I7YiUjZ5NjSV2D9oqOrV173iyZPRa9OLMSmereu6sdjlU
NHow3b8xYbeoxd7lX0e2fho93uFGJaB8d1/suvnlh9EfuOmzqWZVWn02fGB9
0+i5CTvdP7RXJSMnbrS3bhj9kGtzKexX13pKsytFx+ium2rU2alKn7vT9dAa
q7dJNV/I9yYffmJ1+dTRnpO3w/Te6Lbnv0EVHnUmzgXeMp9/ZHwyF8m9eW30
sOdnWzoH28cH3y0Zfdb7b00OxPYMJbJPWf6y7POvU2NtwehtXp6C/HBpOv71
94zRA97+nDw9fevxVd8Y0z9KC8QI29+m94siy79f5xfAj7jM/Ov9ZfGd1Xtf
1yuOsf7oPNsC9FN0sf6HdP9pHzuvNX1eVGXnq//bRGAe6DybH+3HTxU2b9/0
vBGYTwLzTC/Z/Gv/LQR4oVeML12XTSnG47LmkQC/UAdcE+Aa+gRcwz6gvgGu
CXANzxFwTYBrAlwTmkPAtQBcC8A15AhwLQDX5psH4FoCruE9A7iWgGsJuJbo
ngRcK8C1AlzDex5wrQDX8N1B7xTgGr6DgGsFuFboXUb6X3a8azk=
          
          "], CompressedData["
1:eJyFlU1IVFEUx1/T5MdMOpO+MVfjVKASLoSmVslc2tjnwiLbBKJWC6l0aZLl
opFahOBCLKshFDfSUK2qRYlQ5KoIYlxE4SAECS2mNGQKe71z3z/4D5d34W1+
XM4759zzu3dXT//J8wHLsk4531bna5343bPYv5a6e+ffqpu39BoZqP+yd2Ij
9TyeXu0YjIEf/xZM7hj9k8pND7SFztjgb7Yst77MWGq9+ezYwv5a8D2fm5IH
ugMqlm1fHrJrwA+GnAjlQZXc56wfUXB79Pv1S+Pb1IwTPjcdAZ/tuPy2JVCu
8kN2tr27Cvznxc7hbGeFanDSfBYPg2/mZh8UxiqVk81a86eK/3mOd7VsPAop
qbcM/Oj9kcaFx2EldQXBb/2qvH1icruy3fwD4OmHxa6pc1U6z81XHm+bOp2Z
i1WruJtPEfzpys5j1+aq1aT733Xw/PCh3trGiI5fAH934ePXvnREJdw4q+BX
Mu+XbixGVNTdnwd321zw+AdwWVFl0fL2J2R/yuODOn69xAenfMC9/GV/AfyJ
rvee1Avu9UfiFMGpn+A3df/rpP+o44g+ryU5L/DX+nzlv2XgNA/g3vxIPmHw
GT1vKzJv4DSf4DTP4Lv1/Ev+NeDkC/hh7ZfUZYNf1T6+EB/ByV9fTl6Dk9e+
eZLXvn0w9Y28LjmXBjoX0zmS1+DkNTh5DW6aQ/IanLwu8cImL0wekdfg5DW4
LF+vcQ+Q1773DHkNTl6X3HsJuvdM9yR5Pe9x8hqcvAY33fPkNTh5DW56d0zv
FHkNbnoHyWtw8hrc9C6b+F/sXEUv
          "], CompressedData["
1:eJyNlUtIVFEYx2/T5GMmH+kdczVZgkm4EJpaJefDjb1caGSbQNRqEZYuTfKx
aKQWIbgQS2sIxY00lCt10fkQklwVQYyLKByEQKHFpIZMord7rmfgDH/wwF3c
P+d+9/89fuecbu9qvuuzLOuG8xx1ntrRf+3LXVvC8tbLF/9XGQ92l/88N7qj
9flwdKOpJ8TX1/2RE0O7Wk9MdtcFbtm8dGS19kPMogN9u/r28OKFUq78cTZy
sc2n9VC8YbXXLuFLAefLXL/WI+ed9aeY7aHfAw9Gjml9ygmfmCzi6aaHn2p8
uVpP9trxhrYC3uxs6Yu35Gn9lGNzLhzkvcT069RwvtYdN1vV3/N4aaS1Zudt
QOsq3xy++mqwavFdUOsqLz8/+5v/vHHsuNZt17+Po2/SreN3Cgyfe7Ju/GZs
JlSo9bDrJy1n105e65/J6GPuf7dlsq++o7SqyIifkp/vfft1P5rRK9w4G/JR
7MvKk+WMXuzuT0q3zClT/yq9N60fLHN/hdoveoz45Sq+AH6E6V/tT4n3Rr4T
Kl9h1kfFSQtQT/HUqH+Zqj9dMfq1ovpFH43+qv/mEJgHMudH+QnSlDFva2re
CMwngXmmM8b8K/8lBHihywZfKi+bHhs8LigeCfALdcA1Aa6hT8A1rAOqG+A6
qy8e17CPgGsCXBPgmtAcAq4F4DqLC49ryBHgWgCuvT4dmmsJuIbnDOBaAq6z
zj2Pa4nOScA1A64ZcA3PecA1A67hvYPuKcA1vAcB1wy4ZnQvI30flJ1FLw==

          "], CompressedData["
1:eJx11V1Ik1Ecx/HppEh2YThfiAfbWpsLsU03AyvrX5C9UDJdeBHrZrUwCxIL
irUgtBEYERHUhQSFRV2YBGmMIaRiNxHeJGgQVAQj0ELp5Uqo7Tnn+QU/6YFd
7MPDec45z/lu7vi5jkSxzWaL5j/2/Odu7+Nc6+wmOVW4crUTNn2tdMQrvnX7
xTmy/3Ny1AcvTV0p3nKwTqZ++WO3+rzwj90PBxNn6qWnpXRuKLIZfil+xLjh
DUhNeqE9U+OBX64v6Z8+HJS3hWvRDT8WmfXdWwxKsvDgrAs+b3tfNHixQfKD
pBfWb4SP7Yjc7FxukGf5aTpHDPiM/U1mV6xR1s0N9bQc2gD/vm3pjpFtlIS5
3ir49vmBvlZHSCbNdVXA9wwffzQVDen5l8PTpwfux26H9DzL4O/azi69eB2S
YXM+Dnhn08vxfcshOWk+dy38RImv/7wzLIY5vh3+INWcux4Iy1NznJVXlrs9
TUXZvWGpNu//8c+jP8cCbWEpM/0L/MnXA1v/tIdFffu0k+8Pqvt38/h+NT7c
mk9GzQduzd+l5i+83i61Xri1P8/V/sCv6f1Mqf2Ei95/NX45vFm/r2n1vuDW
+1XPrYJb58GhzgN8VJ8fNR8Dbp23o+q8wa3zqebpgif1eZ5R5xl+QZ9/NX8P
/IPupVf1Al+j+1Lr8sJ/6x4rVY/wq7pftd5aOHUNp67h1DWcuoZT13DqetW+
JWnfqGs4dQ2nruHUNZy6hlPXcOoaTl3DqWs4dQ2nrld1V03dUddw6nqc7w/S
7wB1Daeu4dT1BK+3i37HqGs4dQ2nruHUNZy6hlPXcOoaTl3DqWs4dQ2nruHU
NZy6hlPXcOoa/r//67+NQD56
          "], CompressedData["
1:eJx11V9IU1EcB/CrkyLZg+HUiIttrc1F2OyPgZXdX0H2h5LpwodYL6tFWZBY
UKwFoY3AiIigHiQoLOrBJEhjDOH+FHuJ8EVBg6AiGIEWSn+ehNru73APnMPv
wH35cjn3d875fc4NJC91psoNw4gXH0/xedj7vNA2uxEMMc6WRqEBVzqTNT+6
I27uGzn0NT0axsrMjfLNR7a4+eSfSOJeXwg/dz8dTF1odPOe1sq5odgmvJY8
bt4JRd28PrvQkasP4vXGiv6pY01u/qE0FgN4MjYbfrQo83Tpw3k/zhsfywav
bnPz4iTZhbUbcGxP7G7XssxfFcv0jZg47Xmf25fY7uZr5oZ6Wo+ux5+7lh6Y
eZmnnPXW4e75gb427w43n3DWVYP7h089m4zLnOqvxuz5gceJ+zKnOqtwpv3i
0pt3Mh926vFiV/Pb8YPLMj/jfHc1nq4I91/27XRz05nfg08yLYXbUZm/dOZZ
sQPB5rL8AZmvc97/ZQfiv8ei7TKvcvJv9ovvh7f+65A5jS971feb6H1LnT9C
81tqPTmqx1Lr91P9oK73HK0X1P15TfsDt5T9zNB+Aij7T/NXQ4tyXlN0XqCe
L323DtR+8FI/wKjSP1SPCWq/naB+A7U/qU4/pJV+nqZ+hitK/1P9QfikeOkl
L7BK8UXrCsFfxWMteYSbil9abwMwroFxDYxrYFwD4xoY19q+CdfaPgvXwLjW
zlG41s5duAbGNTCugXGt9a1wrfW5cA2Ma2Bca+6Ea4txbTGuxxnX2r0hXNuM
a5txrd1jwrV27wnXyLhGxjUyrrV7W7jW7nnhGhnX2n9EuNb+O8I1Mq6RcY2M
a2RcI+MaGdfI/a//AwmRPno=
          "], CompressedData["
1:eJx1l1lslVUQx6+FFAO5Wuj2qUih9smIAUoIkMZ74oJWUQhraW+XlEoXtfRC
jSEkxtYgtEYw9EHUB6KmQAVqsXvBfGOX2wXaslwUsQYeXBIl5QFMNU2sxPP/
H/hOvE2aJpPpnJk5/9+Z+RYUbl/3aozP5/vszu+0O78DV3aHDoz/7Pr++3lI
+fBzDvbYpuDVuElHVbuZM0pLRgP0r5n0B5+74ah147vmLSu8FhiGfahnfvCL
S47KPjFr4e9VvwX6YS8p66tbespRxTETF0KZNwNh2MvUrk9i9ziqo2bJzTXV
twLfwd7pb7j++BpHtRcFa9KzJkz8eaMjx9oedNS36VcXXE+bDERgLy70T3WH
k9X7YyvDl3/9x+TZW/HyV69XJqsj/UX5q1+5Tw3Bnv/2tRURJ1ltrFw+Z0vq
NMX4tz49Gn60JUm9152z8sr4dDUCe+vQ90mhVUmqYnh4dkJzrGJ/hlqeevPv
0USVNb02Mbv8fsV8Hr6xqP6XtYkq4ky9NJky09ifL48/XzyYoDrenV+7un+W
yeex9v2h1hUJKj13ou3IVr+JX71kx9MzPo9X28Y+8hfffkCxrv7Ctakfx8Sr
L7uaGt/KiDN5fn1wbKohZ45aOHd52vq/4sy5HdviZffJ2aodf9n/J+HH/2N8
xuU5zId5MC/mz7xZB+N0oU7WzTiX0Rf2if5b0Ef2lfmH0PcW3APj7MU98d4Y
ZxPulfdM+1HogLpg/A+gG+qI8buhM+qO9k7okjrtZb3QMXXNc8uge3LAOLng
hNzQPwtckTP67weH5PJefgvqTmeQY/pXan/X9n9Rx3ft+Jt0Pq6dT5HO33BM
e5uu17XrbdX9cbvQn/Owu7qfhmP61+r+uyVW/+v1fQnvi/7gVuz7rdZ6kD+h
B567XetHyDH9s7XehHqjHdzKI5Y+W7WeJRN65nu1WOtfqH/qoUTzIuSF9gbN
lwyAL8Z/QvMozeDxIuzgVsixxbuQd8YHt3IcHJPTKp2HlIJj6j9V5y1LwTH9
X9B1Ct8r3gu4FXJ8FvZB3UfJBceXYAe3sgMc8/25re9J9oBj2nGvshkc096j
dSDHwfGg9/2XA+CYdUFn8g04NvxqXUoXOO7xziPpBsejjK91L2+AY/YfnMgG
cGzNRykAx+wPOJQRa56CW9Ecn82w5q8cAseDVvxnwXHEymcVOKY/uJV8cNxn
1XsaHHNeg1tpBsfsfwr62Q6OTXz0fx84ZnxwK8fAsTV/ZQM4ZhxwK1XgmP0H
t0KO2TdwK4Zj2MGtXATH9Ae3Qo7pnwb9k2PWC26FHNMObsVwDDu4FXLM+J3g
lxxTP+BWyDHtJxG3F+fw3NeQBznm+wBuhRybuY86MX+F78MF9GUu+sT889BH
csw44FbIMeOAWyHHZq7hXnNxz/Q/AR2QY577IXRDjqPMC+Pf5J0v5txe6LgU
umacCuieHNN/s3femTwPeeej8f/JO0/lXn73NUbOkGP613rntfGv8M530+dn
vPuA8Q969weTZ6d33zDn1uNdY3/MvMY7mGL1cy/eTXIcZV8y9iy8y3m4X9rB
rSLHrKsc7z45jrLvmfxHMFeoT9pbMIfIMe2LMLfIcZR99a4OMRfD4Muav4oc
kzvuzeSYXHNvxh5t4oBb1QiOyek72APIMeOAW7UMHEf5XrDfN8X3jd8vA9hj
yLHpG/aeneA4yvfOXX6xV+WB4x+4D2MPI8esl3vzQXAc5XvNNd8F2AtPgWPW
BW5VHzjmewhu1U5wbH9v5oBjzh3utYfBsTV/1R/g+P++fwvqfjzzL8SyJUg=

          "], CompressedData["
1:eJx1l2tM1mUYxt+Qg4LE4WUrbQTqtGKzD27pSidPyZyibaY2B5kONhvo0GVb
xcmUwca0ROlLVq95olk6R3YwGPneoNLJnC1DmHzAQ8zDMkNDBq5lPdd15//e
fLd3bNcenvf538/1u6/7P6F43eJVMaFQaPfd76i7375xqfH1m/qjof8+GS6E
D/WdBdWVyXfC7qkdZ+KWZn+fS73sztmqGTfC7tyf325Y8UiP6jOnj2+u6Q27
ykldN5aeupDbDb31eqR3UMJucUnjs1sTruj66zuGz++MhN3bKbUL+qf/oXrR
q62f168Pu5WZ1QmDBwdUP9zUveREbtj91HDoi3FH/sq9DD3ry8STJXFht/fi
SOyBr4d0fek7ZydvPpbuEnuemVbRPKL6wvfeKppTke7alhQueinyt+7TML9l
zWdPpLu4mItF4WjIcf3xmXPTb/2c5iQx6Vzv4zGqr3t51e2pr6W5vtK1eZVb
Rqk+b9JjtbXJaW5OxbS9xf2xqsdP/qQna3eqG44ZPzrx6XjVrwzNbs95MtUN
NjeeuFaToHokM3NGU2mKe7S6fF/dsdGqd69+PrJ19YPu05xNDxUMj1G95sjU
V15fmeyq3p1Sdm1KkuqSmBXqnDfWRfGXejXW8f+oc1/+DnWeg+fi/fLcfA7q
I3hOPjf3yUNdWCfq51HHtawr9HbUnfeg9cQ98d6of4N75T1TT4IP6Ave+z74
hj7i+U/BZ/Sd+hO+pE+pb4OP6Wvu8yJ8Tw64fgM4ITfU+8AVOaOeCw7J5b38
bkz5ahY5pp7j10ft+l/9/lG7/5v+PMoxz7/Inz9qz7/ZP69yTH2Fr0/U1uek
r2fU1nOPr380G/WnPsbfl3JMvdXfr3LMc8Z4P8h244eo949Y/1zwfhP6jfuA
W5lv/Dnk/SwJxs+3vP+F/qee7XmRD8EL9f2eL+kxfFV4HqXO8AhuRQy/tX6d
WN7BrRww/eEDfw6ZYPrJZX9uuW36D7gV26/AreSZ/oY6yiXTD1F3aTf9c5u/
J4k1/Rb3KkfBsennkm76ObiVJtP/4TP5ERybfJFiky/wsURMHrV438syk1/g
RN4AxyYfpd/kIziU9SZPwa14jjtn2fVzwbHd/zQ4tudZA45N/spCcGyftxEc
2/osB8e2np3gWH2O+u8Cx/a+xoJje78t4Jg6uJUHwLH1Dzm2fkNuqA5u5Tlw
TB3cCjlmfa7C/+SY68GtkGPq4FbIMXVwK+XgmPt3gF9yzPXgVpC/qh/Cvmfw
O9Qn4hzkmDq4FXJMHdwKOabugv1N9UvBfqh6R7B/qg5uhRxT/w73mo97ph4O
9nPVP4ZvyPF98kKY1wXBfNH1H8HHv8PX1Avhe3JMvTyYd6pnDATyUfXqYJ6q
/i+3u7acbiPHymMwr1W/Gcx3fa7S4Dyg/skPzg+6T0Nw3lD9BfS1YlOf48F5
5v+6oW9mm/qbeUn1dvTlBeZ+Q+jj240fosH5TXUz76k+G7mSb/w5iBxKMH6+
idy6avxv5lXVDyIXuwxf4NbVGR6PInc7DL+cmzFHq/4Lcr3Z9If3MQdMNP0E
3Loh03/M+4Ltb872tzLMMb+Zfsi5hxzf531H14Nb94PpzyWYwzJMP+fcvN/0
f/O+ZvPFFZp8Abduj8kjcOuWm/zinFoFjk0+uocHgvnIObje5Om9778bU7ra
/gGOOeMG
          "], CompressedData["
1:eJx1l31olWUYxs/O2VrNZKBCZaxNRbOB/SGklOJ5yiE6DUyN2DJlA2NTpmRQ
7eOYjQ1Ey+n6p1nH/JpoiqysbGP5PJu6vkz6MHU4yM9hjsbaxtna1of2XPet
7wUdOAx+vHvP897P9bvv551QuG7JqnAoFNp96xu59d1Rd/tz0Ib++ySbED7C
d+bFykePRMwTdWdTlmU1RoWXjJyvmNkTMRf/+GrDioe/UT5rxviGyo6IKZ90
rmfZmZ+UN3XHOxIuYpYU1T69NbVdeXfd0OWd8Yh5O71qYeeMX5UXvNJ0dNP6
iFmZEUtNHL6i/JP6C0tPRSPm+5ojnz507LryzM/SThelRMzeq8PJh764obz4
nfOTN58Im7T2p6aXNXQpX/TemwVzy8KmeWn+4hfj3cprFjSu+fixsEkJXy0Y
a3uUn5w1b0z/j0nGpY262DG1V/m6l1YNTHs1yVwqXptTvqVP+fxJj1ZVjU4y
c8um7y3s7Fd+z+SD7Zm7Q2YoPP7etCcTyn8bnNOS/XjIJBpqT3VVDiiPZ2TM
rC/+J/pIrHRf9YlB5RdWPxvfuvrv6EfZbz2QN/Sn8spj015+beVf0Yp3p5R0
TRlW7tIyQ23zR6IWf4XHcJ38n3C5r/yOcFmHrEu4rFueQ/gwnlOeW3gO6iJ1
En4ZdVyLugpvQd1lH7Se2CfZN+FfYl9ln4WPQg4kF8L3ITeSI+FnkDPJneYT
uZScCt+GHEuuhT+P3IsHwjfAE/FG+CV4JZ4Jj8JD8fJufzem758tHgvP9tdb
vv4Xf3/L93/Dr8fyehb79Vte/2b/vJafd4Wvj+X6nPb1tFzPPb7+Novqf5/f
L8v71eT31/L+hn0e7HbKg/X5sZyfKz5vlvMGb+0Cyuegz7NNpTz3+/xbzn+W
98V+QL4c8H7ZdvKrzPtoq8lHeKseC6/y11n2Hd7aQ9Qf3vfrsBOon9zw63YD
1H/greN+BW9dDvU31NFdo36IursW6p/b/D65ZOq32Fd3nPozcuDGUD+Ht66e
+j9y5r6jeYFcukKaL8ixi9M8avS5dy/Q/IIn7nWad/DKddJ8hIduPc1TeOu8
x5/P5uvnwWO+/w/wmNezBh7T/HWL4DE/by085vosh8dczzZ4rDlH/XfBY96v
++Ex728jPBYOb10SPOb8iMecN8wN5fDWPQOPhcNbJx4Lv4n8i8fC4a16LBze
qsfC4a0thcfCW+GveCwc3srcVn4E9z2L3xE+EesQj4XDW/VYOLxVj4WbYH9T
fi3YD92d9Qf6p3J4qx4L/xr7mot9Fj422M+V70duxOP/mRfK84LzRfmHyPHv
yLXwfORePBZeGpx3ysf1Buaj8lhwniq/7e2uLa5ZPFYfg/NaeV9wvisvDp4H
lOcGzw/Ka4LnDeXPoa8VUn1OBs8zd+qGvplF9afzkvIW9OWFtL8h9PHtlAcb
PL8pp/Oe8jmYK7mUzwTmUCrluQ9z6ybln86r6sthzMVz5Be8jVaTj8cxd1vJ
Xzk3x8j3nzHXG6g/7MA5YCL1E3hrBqn/0PsC9zfD/a0E55jr1A/l3NNK/ZPe
d5TDW/Mt9ecinMPGUT+Xc/MB6v/0vsbzxeTTfIG3Zg/NI3hrltP8knNqBc07
Odc+2Bucj3IO3kTz9O73343pbc3/AkGQAV4=
          "], CompressedData["
1:eJx1l31olWUYxs/O2VrNZKBCZaxNRbOB/SGklOJ5yiE6DUyN2DJlA2NTpmRQ
7eOYjQ1Ey+n6p1nH/JpoiqysbGP5PJu6vkz6MHU4yM9hjsbaxtna1of2XPet
7wUdOAx+vHvP897P9bvv551QuG7JqnAoFNp96xu59d1Rd/tz0Ib++ySbED7C
d+bFykePRMwTdWdTlmU1RoWXjJyvmNkTMRf/+GrDioe/UT5rxviGyo6IKZ90
rmfZmZ+UN3XHOxIuYpYU1T69NbVdeXfd0OWd8Yh5O71qYeeMX5UXvNJ0dNP6
iFmZEUtNHL6i/JP6C0tPRSPm+5ojnz507LryzM/SThelRMzeq8PJh764obz4
nfOTN58Im7T2p6aXNXQpX/TemwVzy8KmeWn+4hfj3cprFjSu+fixsEkJXy0Y
a3uUn5w1b0z/j0nGpY262DG1V/m6l1YNTHs1yVwqXptTvqVP+fxJj1ZVjU4y
c8um7y3s7Fd+z+SD7Zm7Q2YoPP7etCcTyn8bnNOS/XjIJBpqT3VVDiiPZ2TM
rC/+J/pIrHRf9YlB5RdWPxvfuvrv6EfZbz2QN/Sn8spj015+beVf0Yp3p5R0
TRlW7tIyQ23zR6IWf4XHcJ38n3C5r/yOcFmHrEu4rFueQ/gwnlOeW3gO6iJ1
En4ZdVyLugpvQd1lH7Se2CfZN+FfYl9ln4WPQg4kF8L3ITeSI+FnkDPJneYT
uZScCt+GHEuuhT+P3IsHwjfAE/FG+CV4JZ4Jj8JD8fJufzem758tHgvP9tdb
vv4Xf3/L93/Dr8fyehb79Vte/2b/vJafd4Wvj+X6nPb1tFzPPb7+Novqf5/f
L8v71eT31/L+hn0e7HbKg/X5sZyfKz5vlvMGb+0Cyuegz7NNpTz3+/xbzn+W
98V+QL4c8H7ZdvKrzPtoq8lHeKseC6/y11n2Hd7aQ9Qf3vfrsBOon9zw63YD
1H/greN+BW9dDvU31NFdo36IursW6p/b/D65ZOq32Fd3nPozcuDGUD+Ht66e
+j9y5r6jeYFcukKaL8ixi9M8avS5dy/Q/IIn7nWad/DKddJ8hIduPc1TeOu8
x5/P5uvnwWO+/w/wmNezBh7T/HWL4DE/by085vosh8dczzZ4rDlH/XfBY96v
++Ex728jPBYOb10SPOb8iMecN8wN5fDWPQOPhcNbJx4Lv4n8i8fC4a16LBze
qsfC4a0thcfCW+GveCwc3srcVn4E9z2L3xE+EesQj4XDW/VYOLxVj4WbYH9T
fi3YD92d9Qf6p3J4qx4L/xr7mot9Fj422M+V70duxOP/mRfK84LzRfmHyPHv
yLXwfORePBZeGpx3ysf1Buaj8lhwniq/7e2uLa5ZPFYfg/NaeV9wvisvDp4H
lOcGzw/Ka4LnDeXPoa8VUn1OBs8zd+qGvplF9afzkvIW9OWFtL8h9PHtlAcb
PL8pp/Oe8jmYK7mUzwTmUCrluQ9z6ybln86r6sthzMVz5Be8jVaTj8cxd1vJ
Xzk3x8j3nzHXG6g/7MA5YCL1E3hrBqn/0PsC9zfD/a0E55jr1A/l3NNK/ZPe
d5TDW/Mt9ecinMPGUT+Xc/MB6v/0vsbzxeTTfIG3Zg/NI3hrltP8knNqBc07
Odc+2Bucj3IO3kTz9O73343pbc3/AkGQAV4=
          "], CompressedData["
1:eJx1l21olWUYx0/HzaNnrrnzDCpjbSpaDeyDkFKKu8shOg1MjdgyZQNjU6Zk
UO3lmI0NRMvp+tKsY74tNEXWq20sn2tTp5WJkU2H++BbI5XMps2xiajd/+t2
zx86cBj8ePac+7nu/++67mds8aoFy8KhUGj7ve+we98tDfc/e/zQf58ME8JH
+daCeGXqbc8823AqeVH2j7nKy26frpp63TNn/zm6ZsnjXY5PmzKmqbrbM5Xj
O68vOnHB8ZZrie4+8cyCkvoXNkYuO36tYeD81oRnPkirmdsz5W/Hi95s+Xrd
as8szYxH+vb1Ov5V45mFR3I980vd/m8eO/Cv41nfRo+XJHtm58XBpL3f9zte
+uHpCesPxUy06/nJFU2Djs/7+L2imRUx07qwcP5riTuO181pXvHl0zGTHL5Y
5Pkho/zwtFmxm7+mG4mmnO1+Kuz4qteX3Zr0Vro5V7oyr3LDMMdnj3+ypiY1
3cysmLyzuCfJ8eET9nRlbR9tBsJjRkSfG+745f4ZbTnPjDZ9TfVHrlZHHE9k
Zk5tLE0zT8TLd9UeGuH4meUvJTYuf9h8kfP+IwUDIx2vPjDpjbeXppqqjyaW
XZ2Y4rhEs0Ids0cZH3+Vx3Gd/p9yva/+jnJdh65Lua5bn0P5IJ5Tn1t5Huqi
dVJ+HnVciboqb0PddR9cPbFPum/Kf8C+6j4rT0EONBfKdyE3miPlJ5AzzZ3L
J3KpOVW+CTnWXCt/BblXD5SvgSfqjfJz8Eo9U54LD9XLof6uTftuunqsPMde
7/P1v9v7+3z/d+16fF7PfLt+n9e/3j6vz8+7xNbH5/oct/X0uZ47bP39bKr/
SLtfPu9Xi91fn/c3bPMgmykPvs2PcH4u2LwJ5w3eyhzKZ7/Ns0Qozzdt/oXz
n219kU/Jl93WL+kivyqsj1JLPsJbEfK3xl4n7Du8lb3UHz6x65Cx1E/+tOuW
W9R/4K1wv4K3kkf9DXWUS9QPUXdpo/65ye6TJFG/xb7KQerPyIHEqJ/DW2mk
/o+cyc80L5BLKab5ghxLguZRs829vErzC57IOzTv4JX00HyEh7Ka5im8Fetx
x3S+fhY85vufhMe8nhXwmOavzIPH/Lz18Jjrsxgecz074LHLOeq/DR7zfo2C
x7y/zfBYObyVh+Ax50c95rxhbjgOb+VFeKwc3op6rPwK8q8eK4e3oh4rh7ei
HiuHt1IOj5W3w1/1WDm8Fcxfx/fjvqfwO8rHYR3qsXJ4K+qxcngr6rFyE+xv
jl8K9sMh6w/0T8fhrajHyo9hX/Oxz8q9YD93/HPkRj3+n3nheEFwvjj+GXL8
F3KtvBC5V4+VlwfnneMZvYH56Hg8OE8dv+/ttg0nW9Vj52NwXjt+IzjfHS8N
ngcczw+eHxyvC543HH8Zfa2Y6nM4eJ55UDf0zWyqP52XHG9DX55L+xtCH99M
efCD5zfH6bzn+AzMlXzKZx/mUITyfANz6wrln86rju/DXOwkv+CtqSUfD2Lu
tpO/em6Ok++/Ya43UX/YgnPAOOon8Nb0U/+h9wXub4b7WxnOMX9QP9RzTzv1
T3rfeZA3nKt+ov5cgnNYBvVzPTfvpv5P72s8X0whzRd4a3bQPIK3ZjHNLz2n
VtG803Pto73B+ajn4HU0T4e+/65N62y9CzNdrcc=
          "], CompressedData["
1:eJx1l39olWUUx/dLW45su7v3jpYKa+TKMNGmFc3us8pwdc1dQQvDrZUj2h8L
GxZFbBXZ3EjMTNPWhbapbGEZhmyQ+R4mhNk1aJQtE92lH0tz3a3QLVea8Xy/
T70HduFy4cu55z3Pec7nnPMWPf70itqMtLS09ivfzCvfZZEbQnVD5yPv7Pz3
EzZp+DwIvb00t6d4W9iMVZ4aal6biNA+/PL8/sPNYXNrdHTVcNXJyHLoY1mv
LmhaFzZddfOG5pufnH2yv7yjakXY7OuLH2hZei4Shd4dHayrnxM2eXXP9Xzf
Mer0xRsWVR76M2Sypxx66sXC804fvOW+1hoJmZHqB7YcaRl3evv6tk/rG0Nm
9f2bCmpTE+65nZnrfr98W8g0NfX1Xqy47OwfW7aydUEyaNpLepdcH0031NfE
20pLXgua0OaCe2vPZTh9bmlDMr04aI6W9aXfviHLPAR9W3fPx2d68s2FfV8W
pUJTDfO2/MbG0ewl+eZ47MT6VPwqZ795Y+0frx8NmLZNz5fHZ1zt9LWzPgrs
WRowkZujz9Zsmeb01A9ztzd7eWb24XiqayLH6d+NXIo/OS/PFPz6wt4fV1/j
9Gf+Xji9aUeuueNMcXbrh9OdfvrsZyOBC9eaU/ilfifs+D/q9MvnUGccjIs6
4+Y5qL+Lc/LczOcA8sI88b7GkMe3kFfqXyDvvAdXh7gn3hv1Dtwr75n6S6gD
1gXjeRR1wzqiPoo6Y91Rn4a6ZJ1Sz0cds6753P2oe3JAXt4HJ+SG9qXgipyx
rjJilkNySftjiURi73BvGTmm/VnLraftS6x/j/55X7tsPJ6O5wMbv8f4ed5c
e16P56WfqTY/3t0qPymbT4/5pP0jNv9eB/LP5zba+/L0fYFb4f3ST8DWg1Sj
Hmj/ua0fYf3QftzWm7DeqINbqUR9Ut9h61neUPW82Na/6PovsbzIb4qXsOVL
ToAvnneR5VEaFI/gVk4rfsGtaN7BrVyn+gPikJtUP3nCxi1G9R9wK+xXPC+4
lQHV37baPMpFcMxzIe9CjqlX2XuSIDimjnuVTnDsuLZ1IBtVPwe3sgYcs/5R
ZzKs5gW4lRxwTP+oYykEx2p+yQFwzPOCE+lU8w5cyV3gWM1TKYv55ym4Fcvx
kTJtn2PtPe2/CBzreLaDYx1/FzhW81eC4Jh+wK1MAcfUk8jnL+CYOriVh8Ex
dXArr4BjxlOD+30PHNMe3EoeOFbzV8gx/YBbwdxwOriVb8Ax/YNbIcf0D26F
HGteyDF1cCvkmH7ArSwEx7QfBL/kmDq4FXJMfSb8fovncF7M8fcTZw9uhRxT
B7dCjpmfr5GXGPJE+wnkkRzTPuHvn04Ht0KOqXfhXqtxz9RbUAfk2PUB1A05
nmReOPt0/3xx+gz/PHJ6r39+ufPu9s87p9f756OQx4qYb57K//kt399/kBzT
/lKlb147+wr/fHfP3erfB5z9bv/+4PIT8O8bTh/Psn1N5+dn9MGkyudK9E1y
PMm+5OLc5d+vnH0u+jg5VvPX6PpR+56z/wpzhfVJ+7cxh8gx7cv8+6eLU+2r
zk8h5uIA+KIfcGvIMfWTmLuDil/uzdijnf/jmOuzVH8Yxh5Ajsk1uDX3qP6j
3hd0fzPsb/T/JvaYv8Ax/XDvOQaOJ3nf+a8PY6/qBsdq/ppW1c+5N1eD40ne
1/R8MZngWM1fMxMc6/fHT8DxJO+bzj/32gZw7PYE7MGr1Dzl3mzn78DBfwCN
79td
          "], CompressedData["
1:eJx1l39MlWUUx/mlkSyDC/eySN0YK4oCBNFqUfdQ2aTRAjet2YQwWYs/cMas
1RpUyxCWMzPJorsFaINm2WwOtsz3DLcmdm2LlZE5g/XDNOlCTSExzfZ8v896
n+2yMbbvHr7vec9zPuecN3fdhpUNSQkJCd1Xf5Ov/i7uvLRueMP58Lvv/PcT
kgT8lEDvLksfyNsZkunqU6fb1kfDhdBDL5eMHG4LSVHV1OqJ2pNWn055tbR1
Y0j6GotPl8gvYfqPj1T01K4Myb6hyIH2FefC9O+vGmtsKghJRuNzAz/0TNnz
92xeVn3o76Ckzjn09Is5560+dtsDHfUalMm6h7YfaZ8JlzLOTV2fN7UEZc2D
W7MbYrPhIui9yRv/vLIkKK2tQ4MXK69YnyceXtVROp4l3fmDy2+sShT6rI10
leW/liXBbdn3N5xLEp4vLGseT8zLkqPlQ4l3bE6R26Hv7B/49MxAplzY91Vu
LDhXlkB/5KaWqdTlmXK85sSmWOQa67NtS8Nfrx8NSNfW5ysiC64V5m39ok8C
H6wISPjWqmfrt8+TYuixnwo727wMuflwJNY3m2b17ycvR54qzpDs31/Y+/Oa
66z/M/8snd+6K13uPJOX2vHxfGEefjz7xWTgwvVyCn/53Ltwjv/H8/Tlc/hc
xsG4mAfGzffg+ffwnnxv6qPIC/PE+KeRx7eQV8bzJfLOe+D5EO6J90a9B/fK
e6bPS6gD1gXPP466YR1Rn0Kdse6oz0Ndsk6pZ6KOWdfU96PuyQHz9iE4ITfU
y8AVOWN9JtUYDskl/Y9Fo9G9E4Pl5JjnzxpuPZ6nf77x9+hPfbeJx2M89P/I
xO8xfvqnm/f1+L70mWvy493r5Cdm8ukxn7yXx0z+vR7kn3qLuS/PvS9wq7xf
Pjdg6kHrnHoYNvWjrB/6z5h6U9Yb6xPcajXqk/ouU8/6BurZ9itT/8r6p55v
eNE/wIvtn4YvPQG+GM8yw6M2OzyCWyXHDu9K3pkHcKs3gGP6IA69BRzT50kT
two4dvqVsl+xb4NbJcfMzw6TR70Ijqkj70qOGU+tuSfNAsc8j3vVXnBsuTZ1
oFucfg5udS04duaFToBj+oNbTQPH1FHHmgOOqaPu9QA4duad9oJjZz7q3eDY
madaDo6d+auG4yPl7vk0c95z/XPBcZETTyc4duav9oHjxc77ZoFj1g+41Tng
mP7jyOdv4Jg6uNVHwbEzf/UVcMz463G/74Nj6uBWM8CxM3+VHFMHt4q5YXVw
q9+CY94juFVyTB3cKjmmD3khx3wvcKvkmOfBrS4Fx8znGPglx3wuuFVyTP+F
8P0Oz6FPgb+fWB9wq+SYOrhVckyfb5CXGuSJz51FHskx9ai/f1od3Co5Zh76
cK91uGfq7agDcky9FnVDjuPMC/vcRP98sfoC/zyy+qB/ftk87PHPO6s3+eej
jaeyxjdP9f/8VuwfOUiOOR8vV/vmtfWv9M93G+cO/z5g/ff49werB/z7htVn
Ukxfc/PzK/ogOeb5Veib5DjOvmT13f79yurp6ON1Tj0M+/c3qzv7ntW/xlxh
fbKe38YcIsc8X+7fPzXOvmrjzMFcHAVf9AG3Qo7pcxJzlxzTh3sz9mjrcxxz
fZHTHyawBxQ4/QTcyn1O/3G+F9z+JuxvnBdvYo+5BI7ZV7n3HAPHcb53bDzg
VvrBMfMAbqUDHDvzV+rAcZzvNdv/uRcmg2Nn/spCcOzMX/kMHMf53rTzi3tt
Mzh2v2dXg2P3+9fM39GD/wL1Oaj9
          "], CompressedData["
1:eJx1l31oFHQYx68tF8saopPsRb1N3Xnzln8Y5dK1Xy0zN9LarSA8y11TCopF
lia00ZtQvmxp6t5OZeVWGGSrWTJf7iEdYaPMl7O18DY9utoYQhQbUsNWv+/3
R78f3MEQvjw+9/ye5/k8z3M54eryNWkej6d1/C99/G/3S23Jh87nqrX/fpI+
5cGnBXruBz+d//SST/0YSPS2ZsSLd0F/riT+97vnfOqJqxNOdHquFDdBDw4f
Xjd2xKeKskJh78YRo/95csqmyS0+dbH6w+obBseMnpEXnH/hRZ+6+/Zyz3vt
aYp6fv3LM54s8qmfX403Fz+WoRjPyJWNbQc943E+3Hht5h+ZKgL9UuyZL3/v
ylOdozHv15tvVu9Djx4/1nvv83kq5E+vXbVlktoBfcgnMw5k56k322uyz5ZO
Nv5Lvrnp1nDnHLUn1rEgKz1b8b2Vn2Weeqdsjvo+Nn1q1RdTVT30j04PbF/a
N1t5ztVO8q+8RTVCL2/3z+1ZPVvtK7qz/9DVaaqZelfJ6yX9s9RQuT++tu42
xfx7O549knh8lgr/8vHyyLQ7jJ/aupopl0/mqrnJ+bu6Gqabd9VnfdK9IZCr
HukZXZ8/cabaC31ZXfdfA1tz1I2lZw4ECr3G//oXtnWGkl7zL/WJsOP/o3/6
5fcwfsbBuOiHcfMd1IfxTr6b/luRF+aJ+nXIYzvyynedRt5Xow6Mh3Vi3ViX
t1BX1pn6KvQB+4L+D6Fv2EeMPw19xr6jfhF9yT6lvhB9zL6mPoC+JwfUFTgh
N9RD4IqcMc4EOCSXtF8w/jkR+nYxOab9KW0fde1XaP9R+qdeqOOJuvH06fij
jJ/+79LvFb6Xee7T+ZF5yA/try39L5/i5vNznX+57OR/pa6XsF7sE3ArrC/1
Jt0PsgT9QD/f6f4Rckz7NN1vwn6jDm4l6PTnr7qfpQL9zD6s1P0v7H/a+zUv
Ql5oX6b5EvJF+0zNo5SBR4dfIb+0L9V2Qt6Zf/iV5eCYfmp0HDIPHG+3549U
gWP6D+p3CucVdXAr5Jjzqk3nUa4Hx5yr4FZ+AMc7oT+o6yQt4HibPZ/lbXBM
++O6D6QSHDOf4Fa+Asd77H0hY7rvTB7ArfSDY/pHH0sxOG6w95ckwDG/F5zI
QnBMP+BKqsAx7cGheAs0x87+Fc1x32Jn/8owON7t+F8GjiNOPPnguNmJPwaO
G5z3FoJj1hfcSi84pp9R5HMUHLPu4FY6wDH7ENzKU+B4p1PfN8AxdXArjeCY
cYJbIce0B7eCvWHiB7eyFxyzz8GtkGPa56D/yTH9g1shx8wD+SLH9ANuhRwz
DxtsfoXzENwK9q+wvkH43Yrvof8A4iDH9F9lzx8TJ7gV7F+jR+z5Zr53AvJI
jmkPboUcM54I6kSO6Wcz6vob6kx7cCvkmPaH0TfkOMW+MPYxe78Y/X57Hxk9
ae8voy+y953JZ5O9H419QYG1T+X//O7oThwlx4w/bu9rY7/O3u/G3mffA0Y/
a98Pxs899r1h9B7MtQDyQz8jmIOjTj4PYm6S4xT3krHfhLk8iPpSb8AcX+L0
A7g1HKe494x9E/ZKBfqT9knsoQqnn5/G3spx+t+5V827HsVerHP4AreGY8bz
CvYuOabOuxl3tJkz4FZVgGPG8xruAHLMfce7YQ04TvF7wZ1vivON9d2POyYD
HHM+824+A45T/N4xcw/cqi3gmP6P4Q4Lg2POZ97NXeA4xe814e8p3oUXwDHf
xTvyAXDMPPPuHATH7u/N+8Ax88+7dh84dvavWlRg71PezXr/Dh39B1LSOHI=

          "]}]}}}}, Typeset`size$$ = {458., {148., 153.}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`th$43294$$ = 0, $CellContext`x$43295$$ = 
    0, $CellContext`y$43296$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`lastlocposth$$ = {-4.4019925, 
         0.}, $CellContext`laststartposth$$ = {-5., 
         0.}, $CellContext`lastth$$ = 0., $CellContext`radiusth$$ = 
        0.5980074999999999, \
$CellContext`staticpolygons1118640200831284558144170$$ = {
          GrayLevel[0], 
          AbsoluteThickness[0.5], 
          Line[CompressedData["
1:eJyFmnlwV9UVx19WCAkkIQuLkUCQkFJZJEsFxHukw74MiwIVKGVzLGUrOgUj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           
           "]]}, $CellContext`staticpolygons211864020083128460945430$$ = {
          GrayLevel[0], 
          AbsoluteThickness[0.5], 
          Line[{CompressedData["
1:eJyNlT1IQlEUx1+a9mFERhrWIEFEtCtBQ0L0RR9kBQ5WQtlWSC2SDYpDQRB9
UTk1tDTU0B70pMkhXCqqrUAiIgzBCiMl8d17Hl74YxfecH4c7jv3nP85p2XW
Nz6vkSRpIv9p81/sYXVpK5mQpcKxRCV2nnaTZ/vnHwqPNhKPO40282Va4SEz
8SZXa8RqzyjcYVL9byJG3VCW3d9AvH20t/kkLCl2tJ54zB3e/LZpFDtkJG5f
3vhyXmkV21FH3Hs45bZ06JhdSzx3nIqP+PTsHgNxf48ncLRXwewqNZ6DnWF/
pJL564mfeqxBQ5D7lRM32Z/l6YFq5l9G/O4tu933ybiUkzn/ee3sX1njcWSI
B+YmU+u/nKeJd7kfZ15cNYwniS+MyYvvEc4TxAfbvBf3Mue3xK8Lh3P1CP7d
4H7iQjzEhfiJC+8lLuSHuJBPB+dC/okL9SIu1Je4oAfign6IC3ojLuhTjadY
z8QF/RMX+kX1L+4v4kI/qvEU929Jju5B/4VxgnehPKC8oTyjuqA6orojnSBd
IR0i3SKdo75AfYT6DvXpP/u65NxAcwbNJTTH0NxDcxLNVTSH0dxGcx7tBbRH
0N5BewrtNbgHwd5EexbtZcT/ALb6qpI=
            "], CompressedData["
1:eJyVVT1IQlEUvmlaZkQv0rAGCSKkXQka3oXoj37IChyshLKtkFokGxSHgiD6
o3pTQ0tDDe1B99DkEC4V1VYgERGGYIWRkrTdC9/Qg7t8HM6795zvp3UmMjZn
YoyNl4+5fFL3K4ub2Yxg0ueix53s6d7Zu4xTE6X9mtd5kZfxhJOaA22G21eQ
ce6g9LWhWQaLSv9G8oz0tBwnGcn9GygVTG58eU0yntDIt7T+6b80yzivp/DB
ZNDVYZFxVkelo1x6OGJV+tgp2h2KHe5WKfU28uxvD0WNaqXeSichd9wetyn1
leTwPYmp/hqlvoJuX4tbvR8Kzkri+6Wzb3nVruAFEZudyK39qHhedAUfpp8D
tQqeFfOjYuHNUPGMGGgPn98JFb8RV3+fijMG6nXQXwf30cH9dfBeHcxHB/Pk
YP4c7IuD/XLABw74wwHfOOAnB3zmgP8c6IUDfXGgRw70C3HUB/0X3hO8C80B
zQ3NGe0F7RHtHfEE8QrxEPEW8RzpAukI6Q7p9J+6hr6BfAb5EvIx5HvIJ5Gv
Ih9Gvo18HuUCyhGUOyinUK7BHAS5iXIW5TLCfwEU1KqS
            "], CompressedData["
1:eJyN1U0ow2EcB/C/beZtNCaSlzUypVAubuPuhKtSihyYm7TsICsrUsouDq7k
hBuHTQ6UUsoFUctByrCYWfO65nm+6lff5l//w/Np/fc8v+f34hqe7B8xGYYx
kHnNmTdaY7cGZ28jRvap3DfUs+G2z32FnpQ74GMtDZ3h8xflFfDYVnNvj/9N
eTk8/hx0Lh2mldvhqeB0qyfyqbwMHtg+Kz7oMtTaBk/fvDofvXlqXQw/bmzy
h+dNal0IT56E3vsCZrW2wkezj0WtLfBNq8M13pGv1ia4r21qdSWq3YCv1axX
X/v0dz8i2m31tVdV39pTcO/e7tDDRIHyBNwUW7bdH2mPw4+L6i5mSvV57uDt
CzvphEd7FO5OllwuDmo/hf+e9y8u5Pfd5PtwsR+42D9cnBcu4gMX8YSL+Pdo
F/cFF/cLF/kAF/kDF/kGF/kJF/kMF/kPF/UCF/UFF/UIF/Wb09l32P+yfbJz
sTiwuLE4s3th98juneUJyyuWhyxvWZ6zumB1xOqO1ek/6zpn32B9hvUl1sdY
32N9kvVV1odZ32Z9ns0FNkfY3GFzis01NgfZ3GRzls1l5j/8GZHy
            
            "], CompressedData["
1:eJyVlU8og2Ecx1/bDDOaP9HyL2RKoVzc9j53J1yVUuTA3CRxkJUVKWUXB1dy
wo3DnicHaqWUC6KWg5RhMaP5Hye/+hy89V4+rXfP8/t9/9QPjPUMOizL6v1+
nd9vwu9zR2autPXnKTfrAd/sR/Re8DIz3FzbETt5FLzUJDebutT0s+AlJvUQ
qVvczwruMy+RiZagfhe82IS3jj17nZb5y70me/lUdxfKEdxj4g2N07E5h+D5
JnMYfe0OOwV3m6GfxyW4y2y4y+pH2nMFd5jJ1vGV5YTklln1r1VeTLoFf9Pe
mqrzik/JX3Rod6f/djRP8LR2JJe8NweSp3S8oPp0qihf8GvdNr+dTQclT+hA
pvBsoU/yI/17X8ktC35vw/dtOI8N57fhvjbMx4Z52jB/BftSsF8FelCgHwV6
U6BPBXpWoH8FflHgLwV+VOBf5PQd+l86J92L5kBzoznTXmiPtHfSCemKdEi6
JZ2TL8hH5Dvy6T99jblBOUO5RDlGuUc5SblKOUy5TTlPvUA9Qr1DPUW9Rj1I
vUk9S71M/AvV+5Hy
            "], CompressedData["
1:eJyV1UsKglAUBuDrYyOtpNZQOwgat57aQavIJTR06MCBAwciESIiPQik8IM6
4ORDfNx77n8W2/16F4cQNo8reVzHw7NO5/CqNAvv+vQEHsMjeICP53kf4D28
g9/gV3gLb+A1vIKX8AKewy/wDD7V1/1LPB+ewwt4Ca/gNbyBt/Ar/Abv4D18
gI/wsJr3CB7DE3j6p+s5eq++U/+lddC6aZ21L9pH7bv6RH2lPlTfqs91LnSO
dO50Tqf6LQeUG8oZ5ZJyTLmnnFSuKoeV28p5zQXNEc0dzSnNNc1BzU3NWc3l
ye98hwBd
            "], CompressedData["
1:eJyV1bENgkAUBuATWMRJdAbdwMTaeXQDp+BGsKSkoKCgIIQQQggRSxO+ApJr
vuKAu/f+d7w9LvckhHBdV7qu1/P3vPPw92Rx21N4Aj/AA3zJt32GT/ARPsB7
eAdv4Q28hlfwEl7AP/AI173HE/aHF/ASXsFreANv4R28hw/wET7BZ/gCD2f0
CzyBp/Bsp2sfvVffqf/SOejcdM66F92j7l11orpSHapuVefqC/WR+k59yr7e
mRvKGeWScky5p5xUriqHldvKec0FzRHNHc0pzTXNQc1NzVnN5Sx+AX/aAF0=

            "], CompressedData["
1:eJyV1ckNAjEQRNEW+74nQCaOATJA4kwKnQZkQBQ4NAbEASTeYSz58lXqGdvd
VfvT5XDuRMSx2d1m366vdX/Ee+1qfNYPr9v/PMELeIDXDeqDF/AAr2vUBy/g
AV5XqA9ewEN1ltCD5wJ68JxDD54z6MFzCj14TqAHzzH04DmCHjyH0IPnAHrw
7EMPnj3oW3LW0Xf1nzqX7kH3pnvWu+gd9e7qE/WV+lB9qz7XXGiONHeaU821
fEC+IZ9p6WPyPfmkfFU+LN+WzysXlCPKHeWUck05qNxUziqXv/gTK1f7Mg==

            "], CompressedData["
1:eJyV1dkJQjEUhOHBfd8bsJNbg3Yg+GwLaUM7sApTmgu+CH6Igbz8DOfeJOfM
bA+n3bGVZP/Y7ce+nJ/restrdZq81wcv4OlCD54e9ODpQw+eAfTgGUIPnhH0
4BlDD54J9OCZQg+eGfTgmUMPnsV33oAX8AqeJeqDF/AKnhXqgxfwCp416oMX
8AqezX9cdfRd/afOpXvQveme9S56R727+kR9pT5U36rPNRecI82d5lRzLR+Q
b8hn5EvyMfmefFK+Kh+Wb8vnlQvKEeWOckq5phxUbipnf/M7J8jRog==
            
            "], CompressedData["
1:eJyV1ckNAjEQRNEW+74nQCaOATJA4kwKnQZkQBQ4NMwRad5hLPnyVeoZ291V
59vjch9ExLXtYduv52+9P/G3TrWT12M3T/ACHuD1gPrgBTzA6x71wQt4gNcd
6oMX8FCdLfTguYEePNfQg+cKevBcQg+eC+jBcw49eM6gB88p9OA5gR48x9CD
5wj6npx19F39p86le9C96Z71LnpHvbv6RH2lPlTfqs81F5ojzZ3mVHMtH5Bv
yGd6+ph8Tz4pX5UPy7fl88oF5YhyRzmlXFMOKjeVs8rlxr9Xivsy
            
            "], CompressedData["
1:eJyV1ckNwjAUhOER+05YGqCT1AAdIHGmBbcBHVAFLo1wRMp3wJIvv0Yvsf3e
zOl6P98GSS7dHnb7+fiu1zs/a9T28gKeMfTgmUAPnin04JlBD5459OBZQA+e
JfTgWUEPnjX04NlAD54t9OBp+nkLXsAreHaoD17AK3j2qA9ewCt4DqgPXsAr
eI7/cdXRd/WfOpfuQfeme9a76B317uoT9ZX6UH2rPtdccI40d5pTzbV8QL4h
n5Evycfke/JJ+ap8WL4tn1cuKEeUO8op5ZpyULmpnDX/AKCK0aI=
            
            "], CompressedData["
1:eJyF1V1Ik1EYB/ChS6oVLn03ImjZINzNunFKKuNZQghBQUa4oiCFboRI0Ivw
JiqCSMFb+7iRhWLEgopwdpFJF3Uh0ee8eBGc2ogxGBubF66Pt/c8+wcPHN4D
782Pw3mf8/E/5/Dgtb4rdS6X66z11VvfKQr6hrJlenD/X/MvurhNV8NPU9US
pQJ3cmeu++CpbFt4R7BI6cRwdHe/AQ+Nbz08Hi9QJXRxcqm9Gf7CXO4wY3ny
JXvXxowm+Gz3wq8jWz8p0ma1khfuvvdy181vP+ixNXw60QgvLD8fPLC6Tpkx
I9k7sBceD5640dq8RoesMucDHvhoV2FqKW+SVU05ZO78P87XzmTVv8LzbYA3
Xsh2x2e+8Lzc8KNdJ28HYh/JsOuvg+fm2qPnvO+5zj9vah65mwlm3r2lgF3P
Ntw82DrS/2Gepuz/VuB94T0D0fQzHr8I7/Gsxuor09Rij5ODf7o0Efn+e5K8
dv8M/PTErSdX3cPsn+G6NsT9W1R/qnmex9+vxoeLeuCXuX7Vvwjf5Pk+UvOF
H+P1UeNsw8V6wjt4/f1q/WM138f7taL2C17m/VX/bYCL8wA/z+dH1eOBl/i8
bajzBhfnEy7OM/wVn39VfxNc5AX+mvOl5mXAE5zHBZVHuMivo4tcw0WuHesU
uXZcB926iVzDRa7hun0UuYaLXMNFruG6cyhyDRe5hotcO+ZI5Boucg3XNZFr
3AMi1473jMg1XOQaLnIN192TIteLNRe5hotcw3X3vMg1XOQarnt3dO+UyDVc
9w6KXMNFruG6d1nnfwHOe2s5
            "], CompressedData["
1:eJx1lU9IVFEUxh86STWFk74ZImiygXA208ZRUhnuSQghKMgIpyhIoY0QCrYI
N1ERSApu1drIRFLEBBXh2OLepEUtJPo7Lh6CYzXEMDDMMOPC6c/r3biLA9+B
u3gfl/O+c+753Xt4eHTgSoNlWWfd1eiuUyISHMlXhfU/5uf+RUgt1GNPMvWK
0TPhO4Uz14Mqk++I7YiUjZ5NjSV2D9oqOrV173iyZPRa9OLMSmereu6sdjlU
NHow3b8xYbeoxd7lX0e2fho93uFGJaB8d1/suvnlh9EfuOmzqWZVWn02fGB9
0+i5CTvdP7RXJSMnbrS3bhj9kGtzKexX13pKsytFx+ium2rU2alKn7vT9dAa
q7dJNV/I9yYffmJ1+dTRnpO3w/Te6Lbnv0EVHnUmzgXeMp9/ZHwyF8m9eW30
sOdnWzoH28cH3y0Zfdb7b00OxPYMJbJPWf6y7POvU2NtwehtXp6C/HBpOv71
94zRA97+nDw9fevxVd8Y0z9KC8QI29+m94siy79f5xfAj7jM/Ov9ZfGd1Xtf
1yuOsf7oPNsC9FN0sf6HdP9pHzuvNX1eVGXnq//bRGAe6DybH+3HTxU2b9/0
vBGYTwLzTC/Z/Gv/LQR4oVeML12XTSnG47LmkQC/UAdcE+Aa+gRcwz6gvgGu
CXANzxFwTYBrAlwTmkPAtQBcC8A15AhwLQDX5psH4FoCruE9A7iWgGsJuJbo
ngRcK8C1AlzDex5wrQDX8N1B7xTgGr6DgGsFuFboXUb6X3a8azk=
            
            "], CompressedData["
1:eJyFlU1IVFEUx1/T5MdMOpO+MVfjVKASLoSmVslc2tjnwiLbBKJWC6l0aZLl
opFahOBCLKshFDfSUK2qRYlQ5KoIYlxE4SAECS2mNGQKe71z3z/4D5d34W1+
XM4759zzu3dXT//J8wHLsk4531bna5343bPYv5a6e+ffqpu39BoZqP+yd2Ij
9TyeXu0YjIEf/xZM7hj9k8pND7SFztjgb7Yst77MWGq9+ezYwv5a8D2fm5IH
ugMqlm1fHrJrwA+GnAjlQZXc56wfUXB79Pv1S+Pb1IwTPjcdAZ/tuPy2JVCu
8kN2tr27Cvznxc7hbGeFanDSfBYPg2/mZh8UxiqVk81a86eK/3mOd7VsPAop
qbcM/Oj9kcaFx2EldQXBb/2qvH1icruy3fwD4OmHxa6pc1U6z81XHm+bOp2Z
i1WruJtPEfzpys5j1+aq1aT733Xw/PCh3trGiI5fAH934ePXvnREJdw4q+BX
Mu+XbixGVNTdnwd321zw+AdwWVFl0fL2J2R/yuODOn69xAenfMC9/GV/AfyJ
rvee1Avu9UfiFMGpn+A3df/rpP+o44g+ryU5L/DX+nzlv2XgNA/g3vxIPmHw
GT1vKzJv4DSf4DTP4Lv1/Ev+NeDkC/hh7ZfUZYNf1T6+EB/ByV9fTl6Dk9e+
eZLXvn0w9Y28LjmXBjoX0zmS1+DkNTh5DW6aQ/IanLwu8cImL0wekdfg5DW4
LF+vcQ+Q1773DHkNTl6X3HsJuvdM9yR5Pe9x8hqcvAY33fPkNTh5DW56d0zv
FHkNbnoHyWtw8hrc9C6b+F/sXEUv
            "], CompressedData["
1:eJyNlUtIVFEYx2/T5GMmH+kdczVZgkm4EJpaJefDjb1caGSbQNRqEZYuTfKx
aKQWIbgQS2sIxY00lCt10fkQklwVQYyLKByEQKHFpIZMord7rmfgDH/wwF3c
P+d+9/89fuecbu9qvuuzLOuG8xx1ntrRf+3LXVvC8tbLF/9XGQ92l/88N7qj
9flwdKOpJ8TX1/2RE0O7Wk9MdtcFbtm8dGS19kPMogN9u/r28OKFUq78cTZy
sc2n9VC8YbXXLuFLAefLXL/WI+ed9aeY7aHfAw9Gjml9ygmfmCzi6aaHn2p8
uVpP9trxhrYC3uxs6Yu35Gn9lGNzLhzkvcT069RwvtYdN1vV3/N4aaS1Zudt
QOsq3xy++mqwavFdUOsqLz8/+5v/vHHsuNZt17+Po2/SreN3Cgyfe7Ju/GZs
JlSo9bDrJy1n105e65/J6GPuf7dlsq++o7SqyIifkp/vfft1P5rRK9w4G/JR
7MvKk+WMXuzuT0q3zClT/yq9N60fLHN/hdoveoz45Sq+AH6E6V/tT4n3Rr4T
Kl9h1kfFSQtQT/HUqH+Zqj9dMfq1ovpFH43+qv/mEJgHMudH+QnSlDFva2re
CMwngXmmM8b8K/8lBHihywZfKi+bHhs8LigeCfALdcA1Aa6hT8A1rAOqG+A6
qy8e17CPgGsCXBPgmtAcAq4F4DqLC49ryBHgWgCuvT4dmmsJuIbnDOBaAq6z
zj2Pa4nOScA1A64ZcA3PecA1A67hvYPuKcA1vAcB1wy4ZnQvI30flJ1FLw==

            "], CompressedData["
1:eJx11V1Ik1Ecx/HppEh2YThfiAfbWpsLsU03AyvrX5C9UDJdeBHrZrUwCxIL
irUgtBEYERHUhQSFRV2YBGmMIaRiNxHeJGgQVAQj0ELp5Uqo7Tnn+QU/6YFd
7MPDec45z/lu7vi5jkSxzWaL5j/2/Odu7+Nc6+wmOVW4crUTNn2tdMQrvnX7
xTmy/3Ny1AcvTV0p3nKwTqZ++WO3+rzwj90PBxNn6qWnpXRuKLIZfil+xLjh
DUhNeqE9U+OBX64v6Z8+HJS3hWvRDT8WmfXdWwxKsvDgrAs+b3tfNHixQfKD
pBfWb4SP7Yjc7FxukGf5aTpHDPiM/U1mV6xR1s0N9bQc2gD/vm3pjpFtlIS5
3ir49vmBvlZHSCbNdVXA9wwffzQVDen5l8PTpwfux26H9DzL4O/azi69eB2S
YXM+Dnhn08vxfcshOWk+dy38RImv/7wzLIY5vh3+INWcux4Iy1NznJVXlrs9
TUXZvWGpNu//8c+jP8cCbWEpM/0L/MnXA1v/tIdFffu0k+8Pqvt38/h+NT7c
mk9GzQduzd+l5i+83i61Xri1P8/V/sCv6f1Mqf2Ei95/NX45vFm/r2n1vuDW
+1XPrYJb58GhzgN8VJ8fNR8Dbp23o+q8wa3zqebpgif1eZ5R5xl+QZ9/NX8P
/IPupVf1Al+j+1Lr8sJ/6x4rVY/wq7pftd5aOHUNp67h1DWcuoZT13DqetW+
JWnfqGs4dQ2nruHUNZy6hlPXcOoaTl3DqWs4dQ2nrld1V03dUddw6nqc7w/S
7wB1Daeu4dT1BK+3i37HqGs4dQ2nruHUNZy6hlPXcOoaTl3DqWs4dQ2nruHU
NZy6hlPXcOoa/r//67+NQD56
            "], CompressedData["
1:eJx11V9IU1EcB/CrkyLZg+HUiIttrc1F2OyPgZXdX0H2h5LpwodYL6tFWZBY
UKwFoY3AiIigHiQoLOrBJEhjDOH+FHuJ8EVBg6AiGIEWSn+ehNru73APnMPv
wH35cjn3d875fc4NJC91psoNw4gXH0/xedj7vNA2uxEMMc6WRqEBVzqTNT+6
I27uGzn0NT0axsrMjfLNR7a4+eSfSOJeXwg/dz8dTF1odPOe1sq5odgmvJY8
bt4JRd28PrvQkasP4vXGiv6pY01u/qE0FgN4MjYbfrQo83Tpw3k/zhsfywav
bnPz4iTZhbUbcGxP7G7XssxfFcv0jZg47Xmf25fY7uZr5oZ6Wo+ux5+7lh6Y
eZmnnPXW4e75gb427w43n3DWVYP7h089m4zLnOqvxuz5gceJ+zKnOqtwpv3i
0pt3Mh926vFiV/Pb8YPLMj/jfHc1nq4I91/27XRz05nfg08yLYXbUZm/dOZZ
sQPB5rL8AZmvc97/ZQfiv8ei7TKvcvJv9ovvh7f+65A5jS971feb6H1LnT9C
81tqPTmqx1Lr91P9oK73HK0X1P15TfsDt5T9zNB+Aij7T/NXQ4tyXlN0XqCe
L323DtR+8FI/wKjSP1SPCWq/naB+A7U/qU4/pJV+nqZ+hitK/1P9QfikeOkl
L7BK8UXrCsFfxWMteYSbil9abwMwroFxDYxrYFwD4xoY19q+CdfaPgvXwLjW
zlG41s5duAbGNTCugXGt9a1wrfW5cA2Ma2Bca+6Ea4txbTGuxxnX2r0hXNuM
a5txrd1jwrV27wnXyLhGxjUyrrV7W7jW7nnhGhnX2n9EuNb+O8I1Mq6RcY2M
a2RcI+MaGdfI/a//AwmRPno=
            "], CompressedData["
1:eJx1l1lslVUQx6+FFAO5Wuj2qUih9smIAUoIkMZ74oJWUQhraW+XlEoXtfRC
jSEkxtYgtEYw9EHUB6KmQAVqsXvBfGOX2wXaslwUsQYeXBIl5QFMNU2sxPP/
H/hOvE2aJpPpnJk5/9+Z+RYUbl/3aozP5/vszu+0O78DV3aHDoz/7Pr++3lI
+fBzDvbYpuDVuElHVbuZM0pLRgP0r5n0B5+74ah147vmLSu8FhiGfahnfvCL
S47KPjFr4e9VvwX6YS8p66tbespRxTETF0KZNwNh2MvUrk9i9ziqo2bJzTXV
twLfwd7pb7j++BpHtRcFa9KzJkz8eaMjx9oedNS36VcXXE+bDERgLy70T3WH
k9X7YyvDl3/9x+TZW/HyV69XJqsj/UX5q1+5Tw3Bnv/2tRURJ1ltrFw+Z0vq
NMX4tz49Gn60JUm9152z8sr4dDUCe+vQ90mhVUmqYnh4dkJzrGJ/hlqeevPv
0USVNb02Mbv8fsV8Hr6xqP6XtYkq4ky9NJky09ifL48/XzyYoDrenV+7un+W
yeex9v2h1hUJKj13ou3IVr+JX71kx9MzPo9X28Y+8hfffkCxrv7Ctakfx8Sr
L7uaGt/KiDN5fn1wbKohZ45aOHd52vq/4sy5HdviZffJ2aodf9n/J+HH/2N8
xuU5zId5MC/mz7xZB+N0oU7WzTiX0Rf2if5b0Ef2lfmH0PcW3APj7MU98d4Y
ZxPulfdM+1HogLpg/A+gG+qI8buhM+qO9k7okjrtZb3QMXXNc8uge3LAOLng
hNzQPwtckTP67weH5PJefgvqTmeQY/pXan/X9n9Rx3ft+Jt0Pq6dT5HO33BM
e5uu17XrbdX9cbvQn/Owu7qfhmP61+r+uyVW/+v1fQnvi/7gVuz7rdZ6kD+h
B567XetHyDH9s7XehHqjHdzKI5Y+W7WeJRN65nu1WOtfqH/qoUTzIuSF9gbN
lwyAL8Z/QvMozeDxIuzgVsixxbuQd8YHt3IcHJPTKp2HlIJj6j9V5y1LwTH9
X9B1Ct8r3gu4FXJ8FvZB3UfJBceXYAe3sgMc8/25re9J9oBj2nGvshkc096j
dSDHwfGg9/2XA+CYdUFn8g04NvxqXUoXOO7xziPpBsejjK91L2+AY/YfnMgG
cGzNRykAx+wPOJQRa56CW9Ecn82w5q8cAseDVvxnwXHEymcVOKY/uJV8cNxn
1XsaHHNeg1tpBsfsfwr62Q6OTXz0fx84ZnxwK8fAsTV/ZQM4ZhxwK1XgmP0H
t0KO2TdwK4Zj2MGtXATH9Ae3Qo7pnwb9k2PWC26FHNMObsVwDDu4FXLM+J3g
lxxTP+BWyDHtJxG3F+fw3NeQBznm+wBuhRybuY86MX+F78MF9GUu+sT889BH
csw44FbIMeOAWyHHZq7hXnNxz/Q/AR2QY577IXRDjqPMC+Pf5J0v5txe6LgU
umacCuieHNN/s3femTwPeeej8f/JO0/lXn73NUbOkGP613rntfGv8M530+dn
vPuA8Q969weTZ6d33zDn1uNdY3/MvMY7mGL1cy/eTXIcZV8y9iy8y3m4X9rB
rSLHrKsc7z45jrLvmfxHMFeoT9pbMIfIMe2LMLfIcZR99a4OMRfD4Muav4oc
kzvuzeSYXHNvxh5t4oBb1QiOyek72APIMeOAW7UMHEf5XrDfN8X3jd8vA9hj
yLHpG/aeneA4yvfOXX6xV+WB4x+4D2MPI8esl3vzQXAc5XvNNd8F2AtPgWPW
BW5VHzjmewhu1U5wbH9v5oBjzh3utYfBsTV/1R/g+P++fwvqfjzzL8SyJUg=

            "], CompressedData["
1:eJx1l2tM1mUYxt+Qg4LE4WUrbQTqtGKzD27pSidPyZyibaY2B5kONhvo0GVb
xcmUwca0ROlLVq95olk6R3YwGPneoNLJnC1DmHzAQ8zDMkNDBq5lPdd15//e
fLd3bNcenvf538/1u6/7P6F43eJVMaFQaPfd76i7375xqfH1m/qjof8+GS6E
D/WdBdWVyXfC7qkdZ+KWZn+fS73sztmqGTfC7tyf325Y8UiP6jOnj2+u6Q27
ykldN5aeupDbDb31eqR3UMJucUnjs1sTruj66zuGz++MhN3bKbUL+qf/oXrR
q62f168Pu5WZ1QmDBwdUP9zUveREbtj91HDoi3FH/sq9DD3ry8STJXFht/fi
SOyBr4d0fek7ZydvPpbuEnuemVbRPKL6wvfeKppTke7alhQueinyt+7TML9l
zWdPpLu4mItF4WjIcf3xmXPTb/2c5iQx6Vzv4zGqr3t51e2pr6W5vtK1eZVb
Rqk+b9JjtbXJaW5OxbS9xf2xqsdP/qQna3eqG44ZPzrx6XjVrwzNbs95MtUN
NjeeuFaToHokM3NGU2mKe7S6fF/dsdGqd69+PrJ19YPu05xNDxUMj1G95sjU
V15fmeyq3p1Sdm1KkuqSmBXqnDfWRfGXejXW8f+oc1/+DnWeg+fi/fLcfA7q
I3hOPjf3yUNdWCfq51HHtawr9HbUnfeg9cQ98d6of4N75T1TT4IP6Ave+z74
hj7i+U/BZ/Sd+hO+pE+pb4OP6Wvu8yJ8Tw64fgM4ITfU+8AVOaOeCw7J5b38
bkz5ahY5pp7j10ft+l/9/lG7/5v+PMoxz7/Inz9qz7/ZP69yTH2Fr0/U1uek
r2fU1nOPr380G/WnPsbfl3JMvdXfr3LMc8Z4P8h244eo949Y/1zwfhP6jfuA
W5lv/Dnk/SwJxs+3vP+F/qee7XmRD8EL9f2eL+kxfFV4HqXO8AhuRQy/tX6d
WN7BrRww/eEDfw6ZYPrJZX9uuW36D7gV26/AreSZ/oY6yiXTD1F3aTf9c5u/
J4k1/Rb3KkfBsennkm76ObiVJtP/4TP5ERybfJFiky/wsURMHrV438syk1/g
RN4AxyYfpd/kIziU9SZPwa14jjtn2fVzwbHd/zQ4tudZA45N/spCcGyftxEc
2/osB8e2np3gWH2O+u8Cx/a+xoJje78t4Jg6uJUHwLH1Dzm2fkNuqA5u5Tlw
TB3cCjlmfa7C/+SY68GtkGPq4FbIMXVwK+XgmPt3gF9yzPXgVpC/qh/Cvmfw
O9Qn4hzkmDq4FXJMHdwKOabugv1N9UvBfqh6R7B/qg5uhRxT/w73mo97ph4O
9nPVP4ZvyPF98kKY1wXBfNH1H8HHv8PX1Avhe3JMvTyYd6pnDATyUfXqYJ6q
/i+3u7acbiPHymMwr1W/Gcx3fa7S4Dyg/skPzg+6T0Nw3lD9BfS1YlOf48F5
5v+6oW9mm/qbeUn1dvTlBeZ+Q+jj240fosH5TXUz76k+G7mSb/w5iBxKMH6+
idy6avxv5lXVDyIXuwxf4NbVGR6PInc7DL+cmzFHq/4Lcr3Z9If3MQdMNP0E
3Loh03/M+4Ltb872tzLMMb+Zfsi5hxzf531H14Nb94PpzyWYwzJMP+fcvN/0
f/O+ZvPFFZp8Abduj8kjcOuWm/zinFoFjk0+uocHgvnIObje5Om9778bU7ra
/gGOOeMG
            "], CompressedData["
1:eJx1l31olWUYxs/O2VrNZKBCZaxNRbOB/SGklOJ5yiE6DUyN2DJlA2NTpmRQ
7eOYjQ1Ey+n6p1nH/JpoiqysbGP5PJu6vkz6MHU4yM9hjsbaxtna1of2XPet
7wUdOAx+vHvP897P9bvv551QuG7JqnAoFNp96xu59d1Rd/tz0Ib++ySbED7C
d+bFykePRMwTdWdTlmU1RoWXjJyvmNkTMRf/+GrDioe/UT5rxviGyo6IKZ90
rmfZmZ+UN3XHOxIuYpYU1T69NbVdeXfd0OWd8Yh5O71qYeeMX5UXvNJ0dNP6
iFmZEUtNHL6i/JP6C0tPRSPm+5ojnz507LryzM/SThelRMzeq8PJh764obz4
nfOTN58Im7T2p6aXNXQpX/TemwVzy8KmeWn+4hfj3cprFjSu+fixsEkJXy0Y
a3uUn5w1b0z/j0nGpY262DG1V/m6l1YNTHs1yVwqXptTvqVP+fxJj1ZVjU4y
c8um7y3s7Fd+z+SD7Zm7Q2YoPP7etCcTyn8bnNOS/XjIJBpqT3VVDiiPZ2TM
rC/+J/pIrHRf9YlB5RdWPxvfuvrv6EfZbz2QN/Sn8spj015+beVf0Yp3p5R0
TRlW7tIyQ23zR6IWf4XHcJ38n3C5r/yOcFmHrEu4rFueQ/gwnlOeW3gO6iJ1
En4ZdVyLugpvQd1lH7Se2CfZN+FfYl9ln4WPQg4kF8L3ITeSI+FnkDPJneYT
uZScCt+GHEuuhT+P3IsHwjfAE/FG+CV4JZ4Jj8JD8fJufzem758tHgvP9tdb
vv4Xf3/L93/Dr8fyehb79Vte/2b/vJafd4Wvj+X6nPb1tFzPPb7+Novqf5/f
L8v71eT31/L+hn0e7HbKg/X5sZyfKz5vlvMGb+0Cyuegz7NNpTz3+/xbzn+W
98V+QL4c8H7ZdvKrzPtoq8lHeKseC6/y11n2Hd7aQ9Qf3vfrsBOon9zw63YD
1H/greN+BW9dDvU31NFdo36IursW6p/b/D65ZOq32Fd3nPozcuDGUD+Ht66e
+j9y5r6jeYFcukKaL8ixi9M8avS5dy/Q/IIn7nWad/DKddJ8hIduPc1TeOu8
x5/P5uvnwWO+/w/wmNezBh7T/HWL4DE/by085vosh8dczzZ4rDlH/XfBY96v
++Ex728jPBYOb10SPOb8iMecN8wN5fDWPQOPhcNbJx4Lv4n8i8fC4a16LBze
qsfC4a0thcfCW+GveCwc3srcVn4E9z2L3xE+EesQj4XDW/VYOLxVj4WbYH9T
fi3YD92d9Qf6p3J4qx4L/xr7mot9Fj422M+V70duxOP/mRfK84LzRfmHyPHv
yLXwfORePBZeGpx3ysf1Buaj8lhwniq/7e2uLa5ZPFYfg/NaeV9wvisvDp4H
lOcGzw/Ka4LnDeXPoa8VUn1OBs8zd+qGvplF9afzkvIW9OWFtL8h9PHtlAcb
PL8pp/Oe8jmYK7mUzwTmUCrluQ9z6ybln86r6sthzMVz5Be8jVaTj8cxd1vJ
Xzk3x8j3nzHXG6g/7MA5YCL1E3hrBqn/0PsC9zfD/a0E55jr1A/l3NNK/ZPe
d5TDW/Mt9ecinMPGUT+Xc/MB6v/0vsbzxeTTfIG3Zg/NI3hrltP8knNqBc07
Odc+2Bucj3IO3kTz9O73343pbc3/AkGQAV4=
            "], CompressedData["
1:eJx1l31olWUYxs/O2VrNZKBCZaxNRbOB/SGklOJ5yiE6DUyN2DJlA2NTpmRQ
7eOYjQ1Ey+n6p1nH/JpoiqysbGP5PJu6vkz6MHU4yM9hjsbaxtna1of2XPet
7wUdOAx+vHvP897P9bvv551QuG7JqnAoFNp96xu59d1Rd/tz0Ib++ySbED7C
d+bFykePRMwTdWdTlmU1RoWXjJyvmNkTMRf/+GrDioe/UT5rxviGyo6IKZ90
rmfZmZ+UN3XHOxIuYpYU1T69NbVdeXfd0OWd8Yh5O71qYeeMX5UXvNJ0dNP6
iFmZEUtNHL6i/JP6C0tPRSPm+5ojnz507LryzM/SThelRMzeq8PJh764obz4
nfOTN58Im7T2p6aXNXQpX/TemwVzy8KmeWn+4hfj3cprFjSu+fixsEkJXy0Y
a3uUn5w1b0z/j0nGpY262DG1V/m6l1YNTHs1yVwqXptTvqVP+fxJj1ZVjU4y
c8um7y3s7Fd+z+SD7Zm7Q2YoPP7etCcTyn8bnNOS/XjIJBpqT3VVDiiPZ2TM
rC/+J/pIrHRf9YlB5RdWPxvfuvrv6EfZbz2QN/Sn8spj015+beVf0Yp3p5R0
TRlW7tIyQ23zR6IWf4XHcJ38n3C5r/yOcFmHrEu4rFueQ/gwnlOeW3gO6iJ1
En4ZdVyLugpvQd1lH7Se2CfZN+FfYl9ln4WPQg4kF8L3ITeSI+FnkDPJneYT
uZScCt+GHEuuhT+P3IsHwjfAE/FG+CV4JZ4Jj8JD8fJufzem758tHgvP9tdb
vv4Xf3/L93/Dr8fyehb79Vte/2b/vJafd4Wvj+X6nPb1tFzPPb7+Novqf5/f
L8v71eT31/L+hn0e7HbKg/X5sZyfKz5vlvMGb+0Cyuegz7NNpTz3+/xbzn+W
98V+QL4c8H7ZdvKrzPtoq8lHeKseC6/y11n2Hd7aQ9Qf3vfrsBOon9zw63YD
1H/greN+BW9dDvU31NFdo36IursW6p/b/D65ZOq32Fd3nPozcuDGUD+Ht66e
+j9y5r6jeYFcukKaL8ixi9M8avS5dy/Q/IIn7nWad/DKddJ8hIduPc1TeOu8
x5/P5uvnwWO+/w/wmNezBh7T/HWL4DE/by085vosh8dczzZ4rDlH/XfBY96v
++Ex728jPBYOb10SPOb8iMecN8wN5fDWPQOPhcNbJx4Lv4n8i8fC4a16LBze
qsfC4a0thcfCW+GveCwc3srcVn4E9z2L3xE+EesQj4XDW/VYOLxVj4WbYH9T
fi3YD92d9Qf6p3J4qx4L/xr7mot9Fj422M+V70duxOP/mRfK84LzRfmHyPHv
yLXwfORePBZeGpx3ysf1Buaj8lhwniq/7e2uLa5ZPFYfg/NaeV9wvisvDp4H
lOcGzw/Ka4LnDeXPoa8VUn1OBs8zd+qGvplF9afzkvIW9OWFtL8h9PHtlAcb
PL8pp/Oe8jmYK7mUzwTmUCrluQ9z6ybln86r6sthzMVz5Be8jVaTj8cxd1vJ
Xzk3x8j3nzHXG6g/7MA5YCL1E3hrBqn/0PsC9zfD/a0E55jr1A/l3NNK/ZPe
d5TDW/Mt9ecinMPGUT+Xc/MB6v/0vsbzxeTTfIG3Zg/NI3hrltP8knNqBc07
Odc+2Bucj3IO3kTz9O73343pbc3/AkGQAV4=
            "], CompressedData["
1:eJx1l21olWUYx0/HzaNnrrnzDCpjbSpaDeyDkFKKu8shOg1MjdgyZQNjU6Zk
UO3lmI0NRMvp+tKsY74tNEXWq20sn2tTp5WJkU2H++BbI5XMps2xiajd/+t2
zx86cBj8ePac+7nu/++67mds8aoFy8KhUGj7ve+we98tDfc/e/zQf58ME8JH
+daCeGXqbc8823AqeVH2j7nKy26frpp63TNn/zm6ZsnjXY5PmzKmqbrbM5Xj
O68vOnHB8ZZrie4+8cyCkvoXNkYuO36tYeD81oRnPkirmdsz5W/Hi95s+Xrd
as8szYxH+vb1Ov5V45mFR3I980vd/m8eO/Cv41nfRo+XJHtm58XBpL3f9zte
+uHpCesPxUy06/nJFU2Djs/7+L2imRUx07qwcP5riTuO181pXvHl0zGTHL5Y
5Pkho/zwtFmxm7+mG4mmnO1+Kuz4qteX3Zr0Vro5V7oyr3LDMMdnj3+ypiY1
3cysmLyzuCfJ8eET9nRlbR9tBsJjRkSfG+745f4ZbTnPjDZ9TfVHrlZHHE9k
Zk5tLE0zT8TLd9UeGuH4meUvJTYuf9h8kfP+IwUDIx2vPjDpjbeXppqqjyaW
XZ2Y4rhEs0Ids0cZH3+Vx3Gd/p9yva/+jnJdh65Lua5bn0P5IJ5Tn1t5Huqi
dVJ+HnVciboqb0PddR9cPbFPum/Kf8C+6j4rT0EONBfKdyE3miPlJ5AzzZ3L
J3KpOVW+CTnWXCt/BblXD5SvgSfqjfJz8Eo9U54LD9XLof6uTftuunqsPMde
7/P1v9v7+3z/d+16fF7PfLt+n9e/3j6vz8+7xNbH5/oct/X0uZ47bP39bKr/
SLtfPu9Xi91fn/c3bPMgmykPvs2PcH4u2LwJ5w3eyhzKZ7/Ns0Qozzdt/oXz
n219kU/Jl93WL+kivyqsj1JLPsJbEfK3xl4n7Du8lb3UHz6x65Cx1E/+tOuW
W9R/4K1wv4K3kkf9DXWUS9QPUXdpo/65ye6TJFG/xb7KQerPyIHEqJ/DW2mk
/o+cyc80L5BLKab5ghxLguZRs829vErzC57IOzTv4JX00HyEh7Ka5im8Fetx
x3S+fhY85vufhMe8nhXwmOavzIPH/Lz18Jjrsxgecz074LHLOeq/DR7zfo2C
x7y/zfBYObyVh+Ax50c95rxhbjgOb+VFeKwc3op6rPwK8q8eK4e3oh4rh7ei
HiuHt1IOj5W3w1/1WDm8Fcxfx/fjvqfwO8rHYR3qsXJ4K+qxcngr6rFyE+xv
jl8K9sMh6w/0T8fhrajHyo9hX/Oxz8q9YD93/HPkRj3+n3nheEFwvjj+GXL8
F3KtvBC5V4+VlwfnneMZvYH56Hg8OE8dv+/ttg0nW9Vj52NwXjt+IzjfHS8N
ngcczw+eHxyvC543HH8Zfa2Y6nM4eJ55UDf0zWyqP52XHG9DX55L+xtCH99M
efCD5zfH6bzn+AzMlXzKZx/mUITyfANz6wrln86rju/DXOwkv+CtqSUfD2Lu
tpO/em6Ok++/Ya43UX/YgnPAOOon8Nb0U/+h9wXub4b7WxnOMX9QP9RzTzv1
T3rfeZA3nKt+ov5cgnNYBvVzPTfvpv5P72s8X0whzRd4a3bQPIK3ZjHNLz2n
VtG803Pto73B+ajn4HU0T4e+/65N62y9CzNdrcc=
            "], CompressedData["
1:eJx1l39olWUUx/dLW45su7v3jpYKa+TKMNGmFc3us8pwdc1dQQvDrZUj2h8L
GxZFbBXZ3EjMTNPWhbapbGEZhmyQ+R4mhNk1aJQtE92lH0tz3a3QLVea8Xy/
T70HduFy4cu55z3Pec7nnPMWPf70itqMtLS09ivfzCvfZZEbQnVD5yPv7Pz3
EzZp+DwIvb00t6d4W9iMVZ4aal6biNA+/PL8/sPNYXNrdHTVcNXJyHLoY1mv
LmhaFzZddfOG5pufnH2yv7yjakXY7OuLH2hZei4Shd4dHayrnxM2eXXP9Xzf
Mer0xRsWVR76M2Sypxx66sXC804fvOW+1hoJmZHqB7YcaRl3evv6tk/rG0Nm
9f2bCmpTE+65nZnrfr98W8g0NfX1Xqy47OwfW7aydUEyaNpLepdcH0031NfE
20pLXgua0OaCe2vPZTh9bmlDMr04aI6W9aXfviHLPAR9W3fPx2d68s2FfV8W
pUJTDfO2/MbG0ewl+eZ47MT6VPwqZ795Y+0frx8NmLZNz5fHZ1zt9LWzPgrs
WRowkZujz9Zsmeb01A9ztzd7eWb24XiqayLH6d+NXIo/OS/PFPz6wt4fV1/j
9Gf+Xji9aUeuueNMcXbrh9OdfvrsZyOBC9eaU/ilfifs+D/q9MvnUGccjIs6
4+Y5qL+Lc/LczOcA8sI88b7GkMe3kFfqXyDvvAdXh7gn3hv1Dtwr75n6S6gD
1gXjeRR1wzqiPoo6Y91Rn4a6ZJ1Sz0cds6753P2oe3JAXt4HJ+SG9qXgipyx
rjJilkNySftjiURi73BvGTmm/VnLraftS6x/j/55X7tsPJ6O5wMbv8f4ed5c
e16P56WfqTY/3t0qPymbT4/5pP0jNv9eB/LP5zba+/L0fYFb4f3ST8DWg1Sj
Hmj/ua0fYf3QftzWm7DeqINbqUR9Ut9h61neUPW82Na/6PovsbzIb4qXsOVL
ToAvnneR5VEaFI/gVk4rfsGtaN7BrVyn+gPikJtUP3nCxi1G9R9wK+xXPC+4
lQHV37baPMpFcMxzIe9CjqlX2XuSIDimjnuVTnDsuLZ1IBtVPwe3sgYcs/5R
ZzKs5gW4lRxwTP+oYykEx2p+yQFwzPOCE+lU8w5cyV3gWM1TKYv55ym4Fcvx
kTJtn2PtPe2/CBzreLaDYx1/FzhW81eC4Jh+wK1MAcfUk8jnL+CYOriVh8Ex
dXArr4BjxlOD+30PHNMe3EoeOFbzV8gx/YBbwdxwOriVb8Ax/YNbIcf0D26F
HGteyDF1cCvkmH7ArSwEx7QfBL/kmDq4FXJMfSb8fovncF7M8fcTZw9uhRxT
B7dCjpmfr5GXGPJE+wnkkRzTPuHvn04Ht0KOqXfhXqtxz9RbUAfk2PUB1A05
nmReOPt0/3xx+gz/PHJ6r39+ufPu9s87p9f756OQx4qYb57K//kt399/kBzT
/lKlb147+wr/fHfP3erfB5z9bv/+4PIT8O8bTh/Psn1N5+dn9MGkyudK9E1y
PMm+5OLc5d+vnH0u+jg5VvPX6PpR+56z/wpzhfVJ+7cxh8gx7cv8+6eLU+2r
zk8h5uIA+KIfcGvIMfWTmLuDil/uzdijnf/jmOuzVH8Yxh5Ajsk1uDX3qP6j
3hd0fzPsb/T/JvaYv8Ax/XDvOQaOJ3nf+a8PY6/qBsdq/ppW1c+5N1eD40ne
1/R8MZngWM1fMxMc6/fHT8DxJO+bzj/32gZw7PYE7MGr1Dzl3mzn78DBfwCN
79td
            "], CompressedData["
1:eJx1l39MlWUUx/mlkSyDC/eySN0YK4oCBNFqUfdQ2aTRAjet2YQwWYs/cMas
1RpUyxCWMzPJorsFaINm2WwOtsz3DLcmdm2LlZE5g/XDNOlCTSExzfZ8v896
n+2yMbbvHr7vec9zPuecN3fdhpUNSQkJCd1Xf5Ov/i7uvLRueMP58Lvv/PcT
kgT8lEDvLksfyNsZkunqU6fb1kfDhdBDL5eMHG4LSVHV1OqJ2pNWn055tbR1
Y0j6GotPl8gvYfqPj1T01K4Myb6hyIH2FefC9O+vGmtsKghJRuNzAz/0TNnz
92xeVn3o76Ckzjn09Is5560+dtsDHfUalMm6h7YfaZ8JlzLOTV2fN7UEZc2D
W7MbYrPhIui9yRv/vLIkKK2tQ4MXK69YnyceXtVROp4l3fmDy2+sShT6rI10
leW/liXBbdn3N5xLEp4vLGseT8zLkqPlQ4l3bE6R26Hv7B/49MxAplzY91Vu
LDhXlkB/5KaWqdTlmXK85sSmWOQa67NtS8Nfrx8NSNfW5ysiC64V5m39ok8C
H6wISPjWqmfrt8+TYuixnwo727wMuflwJNY3m2b17ycvR54qzpDs31/Y+/Oa
66z/M/8snd+6K13uPJOX2vHxfGEefjz7xWTgwvVyCn/53Ltwjv/H8/Tlc/hc
xsG4mAfGzffg+ffwnnxv6qPIC/PE+KeRx7eQV8bzJfLOe+D5EO6J90a9B/fK
e6bPS6gD1gXPP466YR1Rn0Kdse6oz0Ndsk6pZ6KOWdfU96PuyQHz9iE4ITfU
y8AVOWN9JtUYDskl/Y9Fo9G9E4Pl5JjnzxpuPZ6nf77x9+hPfbeJx2M89P/I
xO8xfvqnm/f1+L70mWvy493r5Cdm8ukxn7yXx0z+vR7kn3qLuS/PvS9wq7xf
Pjdg6kHrnHoYNvWjrB/6z5h6U9Yb6xPcajXqk/ouU8/6BurZ9itT/8r6p55v
eNE/wIvtn4YvPQG+GM8yw6M2OzyCWyXHDu9K3pkHcKs3gGP6IA69BRzT50kT
two4dvqVsl+xb4NbJcfMzw6TR70Ijqkj70qOGU+tuSfNAsc8j3vVXnBsuTZ1
oFucfg5udS04duaFToBj+oNbTQPH1FHHmgOOqaPu9QA4duad9oJjZz7q3eDY
madaDo6d+auG4yPl7vk0c95z/XPBcZETTyc4duav9oHjxc77ZoFj1g+41Tng
mP7jyOdv4Jg6uNVHwbEzf/UVcMz463G/74Nj6uBWM8CxM3+VHFMHt4q5YXVw
q9+CY94juFVyTB3cKjmmD3khx3wvcKvkmOfBrS4Fx8znGPglx3wuuFVyTP+F
8P0Oz6FPgb+fWB9wq+SYOrhVckyfb5CXGuSJz51FHskx9ai/f1od3Co5Zh76
cK91uGfq7agDcky9FnVDjuPMC/vcRP98sfoC/zyy+qB/ftk87PHPO6s3+eej
jaeyxjdP9f/8VuwfOUiOOR8vV/vmtfWv9M93G+cO/z5g/ff49werB/z7htVn
Ukxfc/PzK/ogOeb5Veib5DjOvmT13f79yurp6ON1Tj0M+/c3qzv7ntW/xlxh
fbKe38YcIsc8X+7fPzXOvmrjzMFcHAVf9AG3Qo7pcxJzlxzTh3sz9mjrcxxz
fZHTHyawBxQ4/QTcyn1O/3G+F9z+JuxvnBdvYo+5BI7ZV7n3HAPHcb53bDzg
VvrBMfMAbqUDHDvzV+rAcZzvNdv/uRcmg2Nn/spCcOzMX/kMHMf53rTzi3tt
Mzh2v2dXg2P3+9fM39GD/wL1Oaj9
            "], CompressedData["
1:eJx1l31oFHQYx68tF8saopPsRb1N3Xnzln8Y5dK1Xy0zN9LarSA8y11TCopF
lia00ZtQvmxp6t5OZeVWGGSrWTJf7iEdYaPMl7O18DY9utoYQhQbUsNWv+/3
R78f3MEQvjw+9/ye5/k8z3M54eryNWkej6d1/C99/G/3S23Jh87nqrX/fpI+
5cGnBXruBz+d//SST/0YSPS2ZsSLd0F/riT+97vnfOqJqxNOdHquFDdBDw4f
Xjd2xKeKskJh78YRo/95csqmyS0+dbH6w+obBseMnpEXnH/hRZ+6+/Zyz3vt
aYp6fv3LM54s8qmfX403Fz+WoRjPyJWNbQc943E+3Hht5h+ZKgL9UuyZL3/v
ylOdozHv15tvVu9Djx4/1nvv83kq5E+vXbVlktoBfcgnMw5k56k322uyz5ZO
Nv5Lvrnp1nDnHLUn1rEgKz1b8b2Vn2Weeqdsjvo+Nn1q1RdTVT30j04PbF/a
N1t5ztVO8q+8RTVCL2/3z+1ZPVvtK7qz/9DVaaqZelfJ6yX9s9RQuT++tu42
xfx7O549knh8lgr/8vHyyLQ7jJ/aupopl0/mqrnJ+bu6Gqabd9VnfdK9IZCr
HukZXZ8/cabaC31ZXfdfA1tz1I2lZw4ECr3G//oXtnWGkl7zL/WJsOP/o3/6
5fcwfsbBuOiHcfMd1IfxTr6b/luRF+aJ+nXIYzvyynedRt5Xow6Mh3Vi3ViX
t1BX1pn6KvQB+4L+D6Fv2EeMPw19xr6jfhF9yT6lvhB9zL6mPoC+JwfUFTgh
N9RD4IqcMc4EOCSXtF8w/jkR+nYxOab9KW0fde1XaP9R+qdeqOOJuvH06fij
jJ/+79LvFb6Xee7T+ZF5yA/try39L5/i5vNznX+57OR/pa6XsF7sE3ArrC/1
Jt0PsgT9QD/f6f4Rckz7NN1vwn6jDm4l6PTnr7qfpQL9zD6s1P0v7H/a+zUv
Ql5oX6b5EvJF+0zNo5SBR4dfIb+0L9V2Qt6Zf/iV5eCYfmp0HDIPHG+3549U
gWP6D+p3CucVdXAr5Jjzqk3nUa4Hx5yr4FZ+AMc7oT+o6yQt4HibPZ/lbXBM
++O6D6QSHDOf4Fa+Asd77H0hY7rvTB7ArfSDY/pHH0sxOG6w95ckwDG/F5zI
QnBMP+BKqsAx7cGheAs0x87+Fc1x32Jn/8owON7t+F8GjiNOPPnguNmJPwaO
G5z3FoJj1hfcSi84pp9R5HMUHLPu4FY6wDH7ENzKU+B4p1PfN8AxdXArjeCY
cYJbIce0B7eCvWHiB7eyFxyzz8GtkGPa56D/yTH9g1shx8wD+SLH9ANuhRwz
DxtsfoXzENwK9q+wvkH43Yrvof8A4iDH9F9lzx8TJ7gV7F+jR+z5Zr53AvJI
jmkPboUcM54I6kSO6Wcz6vob6kx7cCvkmPaH0TfkOMW+MPYxe78Y/X57Hxk9
ae8voy+y953JZ5O9H419QYG1T+X//O7oThwlx4w/bu9rY7/O3u/G3mffA0Y/
a98Pxs899r1h9B7MtQDyQz8jmIOjTj4PYm6S4xT3krHfhLk8iPpSb8AcX+L0
A7g1HKe494x9E/ZKBfqT9knsoQqnn5/G3spx+t+5V827HsVerHP4AreGY8bz
CvYuOabOuxl3tJkz4FZVgGPG8xruAHLMfce7YQ04TvF7wZ1vivON9d2POyYD
HHM+824+A45T/N4xcw/cqi3gmP6P4Q4Lg2POZ97NXeA4xe814e8p3oUXwDHf
xTvyAXDMPPPuHATH7u/N+8Ax88+7dh84dvavWlRg71PezXr/Dh39B1LSOHI=

            "]}]}, $CellContext`th$$ = 
        0., $CellContext`x$$ = -5., $CellContext`xoffth$$ = 
        0.5980074999999999, $CellContext`xth$$ = -4.4019925, $CellContext`y$$ = 
        0., $CellContext`yoffth$$ = 0., $CellContext`yth$$ = 0.}, 
      "ControllerVariables" :> {
        Hold[$CellContext`th$$, $CellContext`th$43294$$, 0], 
        Hold[$CellContext`x$$, $CellContext`x$43295$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$43296$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         Grid[{{
            Show[{
              Graphics[{{
                 Opacity[
                 0.8], $CellContext`staticpolygons1118640200831284558144170$$, 
                 Opacity[1], 
                 RGBColor[
                 0.038747429704798886`, 0.9161617552424038, 
                  0.03984721226918142], 
                 AbsoluteThickness[Medium], 
                 Line[
                  Dynamic[
                   Map[{
                    Part[#, {1, 2}], 
                    Part[#, {4, 5}]}& , 
                    Select[
                    $CellContext`raytracefunction118640200831284558148930[$\
CellContext`th$$, $CellContext`x$$, $CellContext`y$$], 
                    Part[#, 1] > -9.87654321*^8& ]], SynchronousUpdating -> 
                   False]], 
                 Arrowheads[Large], 
                 Thickness[Large], 
                 Dashing[{Small, Small}], 
                 RGBColor[1, 1, 0], 
                 Arrow[
                  Dynamic[If[
                    
                    Or[$CellContext`laststartposth$$ != {$CellContext`x$$, \
$CellContext`y$$}, $CellContext`lastth$$ =!= $CellContext`th$$], \
$CellContext`laststartposth$$ = {$CellContext`x$$, $CellContext`y$$}; \
$CellContext`lastth$$ = $CellContext`th$$; {$CellContext`xth$$, \
$CellContext`yth$$} = $CellContext`laststartposth$$ + $CellContext`radiusth$$ {
                    Cos[$CellContext`th$$ Degree], 
                    
                    Sin[$CellContext`th$$ 
                    Degree]}]; {$CellContext`laststartposth$$, \
{$CellContext`xth$$, $CellContext`yth$$}}, ({$CellContext`laststartposth$$, \
{$CellContext`xth$$, $CellContext`yth$$}} = #)& ]], 
                 Tooltip[
                  Locator[
                   Dynamic[BesselJ[1., 3.]; (If[
                    
                    Or[{$CellContext`xth$$, $CellContext`yth$$} != \
$CellContext`lastlocposth$$, $CellContext`lastth$$ != $CellContext`th$$], \
$CellContext`lastlocposth$$ = {$CellContext`xth$$, $CellContext`yth$$}; \
$CellContext`lastth$$ = $CellContext`th$$; {$CellContext`xth$$, \
$CellContext`yth$$} = $CellContext`laststartposth$$ + $CellContext`radiusth$$ {
                    Cos[$CellContext`th$$ Degree], 
                    
                    Sin[$CellContext`th$$ 
                    Degree]}]; {$CellContext`xth$$, $CellContext`yth$$}), \
({$CellContext`xth$$, $CellContext`yth$$} = #; $CellContext`xoffth$$ = \
$CellContext`xth$$ - $CellContext`x$$; $CellContext`yoffth$$ = \
$CellContext`yth$$ - $CellContext`y$$; $CellContext`radiusth$$ = 
                    Sqrt[$CellContext`xoffth$$^2 + $CellContext`yoffth$$^2]; \
$CellContext`th$$ = Chop[
                    ArcTan[$CellContext`xoffth$$, $CellContext`yoffth$$]/
                    Degree]; {$CellContext`xth$$, $CellContext`yth$$})& ], 
                   Graphics[{
                    RGBColor[1/3, 1/3, 1], 
                    Disk[{0, 0}, 0.5]}, ImageSize -> 10]], 
                  Dynamic[
                   StringJoin["th = ", 
                    ToString[$CellContext`th$$]]]], 
                 Tooltip[
                  Locator[
                   Dynamic[
                   BesselJ[
                    1., 3.]; {$CellContext`x$$, $CellContext`y$$}, \
({$CellContext`x$$, $CellContext`y$$} = Chop[#])& ], 
                   Graphics[{
                    RGBColor[1, 1/3, 1/3], 
                    Disk[{0, 0}, 0.8]}, ImageSize -> 10]], 
                  Dynamic[
                   StringJoin["{x, y} = ", 
                    ToString[
                    Chop[{$CellContext`x$$, $CellContext`y$$}]]]]]}}]}, {
             PlotLabel -> "eye model", ImageSize -> {225, 300}, AspectRatio -> 
              Automatic}], 
            Show[{
              Graphics3D[{{
                 Opacity[
                 1], $CellContext`staticpolygons211864020083128460945430$$, 
                 Opacity[1], 
                 RGBColor[
                 0.038747429704798886`, 0.9161617552424038, 
                  0.03984721226918142], 
                 AbsoluteThickness[Medium], 
                 Line[
                  Dynamic[
                   Map[{
                    Part[#, {1, 2, 3}], 
                    Part[#, {4, 5, 6}]}& , 
                    Select[
                    $CellContext`raytracefunction21864020083128460953516[$\
CellContext`th$$, $CellContext`x$$, $CellContext`y$$], 
                    Part[#, 1] > -9.87654321*^8& ]], SynchronousUpdating -> 
                   False]]}}]}, {
             PlotLabel -> None, ImageSize -> {225, 300}, AspectRatio -> 
              Automatic}]}}]}, Center], 
      "Specifications" :> {{{$CellContext`th$$, 0.}, -180., 180., ControlType -> 
         None}, {{$CellContext`x$$, -5.}, -10, -0.05, ControlType -> 
         None}, {{$CellContext`y$$, 0.}, -10, 10, ControlType -> 
         None}, {{$CellContext`xth$$, -4.4019925}, ControlType -> 
         None}, {{$CellContext`yth$$, 0.}, ControlType -> 
         None}, {{$CellContext`radiusth$$, 0.5980074999999999}, ControlType -> 
         None}, {{$CellContext`xoffth$$, 0.5980074999999999}, ControlType -> 
         None}, {{$CellContext`yoffth$$, 0.}, ControlType -> 
         None}, {{$CellContext`laststartposth$$, {-5., 0.}}, ControlType -> 
         None}, {{$CellContext`lastlocposth$$, {-4.4019925, 0.}}, ControlType -> 
         None}, {{$CellContext`lastth$$, 0.}, ControlType -> 
         None}, {{$CellContext`staticpolygons1118640200831284558144170$$, {
           GrayLevel[0], 
           AbsoluteThickness[0.5], 
           Line[CompressedData["
1:eJyFmnlwV9UVx19WCAkkIQuLkUCQkFJZJEsFxHukw74MiwIVKGVzLGUrOgUj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            "]]}}, ControlType -> 
         None}, {{$CellContext`staticpolygons211864020083128460945430$$, {
           GrayLevel[0], 
           AbsoluteThickness[0.5], 
           Line[{CompressedData["
1:eJyNlT1IQlEUx1+a9mFERhrWIEFEtCtBQ0L0RR9kBQ5WQtlWSC2SDYpDQRB9
UTk1tDTU0B70pMkhXCqqrUAiIgzBCiMl8d17Hl74YxfecH4c7jv3nP85p2XW
Nz6vkSRpIv9p81/sYXVpK5mQpcKxRCV2nnaTZ/vnHwqPNhKPO40282Va4SEz
8SZXa8RqzyjcYVL9byJG3VCW3d9AvH20t/kkLCl2tJ54zB3e/LZpFDtkJG5f
3vhyXmkV21FH3Hs45bZ06JhdSzx3nIqP+PTsHgNxf48ncLRXwewqNZ6DnWF/
pJL564mfeqxBQ5D7lRM32Z/l6YFq5l9G/O4tu933ybiUkzn/ee3sX1njcWSI
B+YmU+u/nKeJd7kfZ15cNYwniS+MyYvvEc4TxAfbvBf3Mue3xK8Lh3P1CP7d
4H7iQjzEhfiJC+8lLuSHuJBPB+dC/okL9SIu1Je4oAfign6IC3ojLuhTjadY
z8QF/RMX+kX1L+4v4kI/qvEU929Jju5B/4VxgnehPKC8oTyjuqA6orojnSBd
IR0i3SKdo75AfYT6DvXpP/u65NxAcwbNJTTH0NxDcxLNVTSH0dxGcx7tBbRH
0N5BewrtNbgHwd5EexbtZcT/ALb6qpI=
             "], CompressedData["
1:eJyVVT1IQlEUvmlaZkQv0rAGCSKkXQka3oXoj37IChyshLKtkFokGxSHgiD6
o3pTQ0tDDe1B99DkEC4V1VYgERGGYIWRkrTdC9/Qg7t8HM6795zvp3UmMjZn
YoyNl4+5fFL3K4ub2Yxg0ueix53s6d7Zu4xTE6X9mtd5kZfxhJOaA22G21eQ
ce6g9LWhWQaLSv9G8oz0tBwnGcn9GygVTG58eU0yntDIt7T+6b80yzivp/DB
ZNDVYZFxVkelo1x6OGJV+tgp2h2KHe5WKfU28uxvD0WNaqXeSichd9wetyn1
leTwPYmp/hqlvoJuX4tbvR8Kzkri+6Wzb3nVruAFEZudyK39qHhedAUfpp8D
tQqeFfOjYuHNUPGMGGgPn98JFb8RV3+fijMG6nXQXwf30cH9dfBeHcxHB/Pk
YP4c7IuD/XLABw74wwHfOOAnB3zmgP8c6IUDfXGgRw70C3HUB/0X3hO8C80B
zQ3NGe0F7RHtHfEE8QrxEPEW8RzpAukI6Q7p9J+6hr6BfAb5EvIx5HvIJ5Gv
Ih9Gvo18HuUCyhGUOyinUK7BHAS5iXIW5TLCfwEU1KqS
             "], CompressedData["

1:eJyN1U0ow2EcB/C/beZtNCaSlzUypVAubuPuhKtSihyYm7TsICsrUsouDq7k
hBuHTQ6UUsoFUctByrCYWfO65nm+6lff5l//w/Np/fc8v+f34hqe7B8xGYYx
kHnNmTdaY7cGZ28jRvap3DfUs+G2z32FnpQ74GMtDZ3h8xflFfDYVnNvj/9N
eTk8/hx0Lh2mldvhqeB0qyfyqbwMHtg+Kz7oMtTaBk/fvDofvXlqXQw/bmzy
h+dNal0IT56E3vsCZrW2wkezj0WtLfBNq8M13pGv1ia4r21qdSWq3YCv1axX
X/v0dz8i2m31tVdV39pTcO/e7tDDRIHyBNwUW7bdH2mPw4+L6i5mSvV57uDt
CzvphEd7FO5OllwuDmo/hf+e9y8u5Pfd5PtwsR+42D9cnBcu4gMX8YSL+Pdo
F/cFF/cLF/kAF/kDF/kGF/kJF/kMF/kPF/UCF/UFF/UIF/Wb09l32P+yfbJz
sTiwuLE4s3th98juneUJyyuWhyxvWZ6zumB1xOqO1ek/6zpn32B9hvUl1sdY
32N9kvVV1odZ32Z9ns0FNkfY3GFzis01NgfZ3GRzls1l5j/8GZHy
             
             "], CompressedData["
1:eJyVlU8og2Ecx1/bDDOaP9HyL2RKoVzc9j53J1yVUuTA3CRxkJUVKWUXB1dy
wo3DnicHaqWUC6KWg5RhMaP5Hye/+hy89V4+rXfP8/t9/9QPjPUMOizL6v1+
nd9vwu9zR2autPXnKTfrAd/sR/Re8DIz3FzbETt5FLzUJDebutT0s+AlJvUQ
qVvczwruMy+RiZagfhe82IS3jj17nZb5y70me/lUdxfKEdxj4g2N07E5h+D5
JnMYfe0OOwV3m6GfxyW4y2y4y+pH2nMFd5jJ1vGV5YTklln1r1VeTLoFf9Pe
mqrzik/JX3Rod6f/djRP8LR2JJe8NweSp3S8oPp0qihf8GvdNr+dTQclT+hA
pvBsoU/yI/17X8ktC35vw/dtOI8N57fhvjbMx4Z52jB/BftSsF8FelCgHwV6
U6BPBXpWoH8FflHgLwV+VOBf5PQd+l86J92L5kBzoznTXmiPtHfSCemKdEi6
JZ2TL8hH5Dvy6T99jblBOUO5RDlGuUc5SblKOUy5TTlPvUA9Qr1DPUW9Rj1I
vUk9S71M/AvV+5Hy
             "], CompressedData["
1:eJyV1UsKglAUBuDrYyOtpNZQOwgat57aQavIJTR06MCBAwciESIiPQik8IM6
4ORDfNx77n8W2/16F4cQNo8reVzHw7NO5/CqNAvv+vQEHsMjeICP53kf4D28
g9/gV3gLb+A1vIKX8AKewy/wDD7V1/1LPB+ewwt4Ca/gNbyBt/Ar/Abv4D18
gI/wsJr3CB7DE3j6p+s5eq++U/+lddC6aZ21L9pH7bv6RH2lPlTfqs91LnSO
dO50Tqf6LQeUG8oZ5ZJyTLmnnFSuKoeV28p5zQXNEc0dzSnNNc1BzU3NWc3l
ye98hwBd
             "], CompressedData["
1:eJyV1bENgkAUBuATWMRJdAbdwMTaeXQDp+BGsKSkoKCgIIQQQggRSxO+ApJr
vuKAu/f+d7w9LvckhHBdV7qu1/P3vPPw92Rx21N4Aj/AA3zJt32GT/ARPsB7
eAdv4Q28hlfwEl7AP/AI173HE/aHF/ASXsFreANv4R28hw/wET7BZ/gCD2f0
CzyBp/Bsp2sfvVffqf/SOejcdM66F92j7l11orpSHapuVefqC/WR+k59yr7e
mRvKGeWScky5p5xUriqHldvKec0FzRHNHc0pzTXNQc1NzVnN5Sx+AX/aAF0=

             "], CompressedData["
1:eJyV1ckNAjEQRNEW+74nQCaOATJA4kwKnQZkQBQ4NAbEASTeYSz58lXqGdvd
VfvT5XDuRMSx2d1m366vdX/Ee+1qfNYPr9v/PMELeIDXDeqDF/AAr2vUBy/g
AV5XqA9ewEN1ltCD5wJ68JxDD54z6MFzCj14TqAHzzH04DmCHjyH0IPnAHrw
7EMPnj3oW3LW0Xf1nzqX7kH3pnvWu+gd9e7qE/WV+lB9qz7XXGiONHeaU821
fEC+IZ9p6WPyPfmkfFU+LN+WzysXlCPKHeWUck05qNxUziqXv/gTK1f7Mg==

             "], CompressedData["
1:eJyV1dkJQjEUhOHBfd8bsJNbg3Yg+GwLaUM7sApTmgu+CH6Igbz8DOfeJOfM
bA+n3bGVZP/Y7ce+nJ/restrdZq81wcv4OlCD54e9ODpQw+eAfTgGUIPnhH0
4BlDD54J9OCZQg+eGfTgmUMPnsV33oAX8AqeJeqDF/AKnhXqgxfwCp416oMX
8AqezX9cdfRd/afOpXvQveme9S56R727+kR9pT5U36rPNRecI82d5lRzLR+Q
b8hn5EvyMfmefFK+Kh+Wb8vnlQvKEeWOckq5phxUbipnf/M7J8jRog==
             
             "], CompressedData["
1:eJyV1ckNAjEQRNEW+74nQCaOATJA4kwKnQZkQBQ4NMwRad5hLPnyVeoZ291V
59vjch9ExLXtYduv52+9P/G3TrWT12M3T/ACHuD1gPrgBTzA6x71wQt4gNcd
6oMX8FCdLfTguYEePNfQg+cKevBcQg+eC+jBcw49eM6gB88p9OA5gR48x9CD
5wj6npx19F39p86le9C96Z71LnpHvbv6RH2lPlTfqs81F5ojzZ3mVHMtH5Bv
yGd6+ph8Tz4pX5UPy7fl88oF5YhyRzmlXFMOKjeVs8rlxr9Xivsy
             
             "], CompressedData["
1:eJyV1ckNwjAUhOER+05YGqCT1AAdIHGmBbcBHVAFLo1wRMp3wJIvv0Yvsf3e
zOl6P98GSS7dHnb7+fiu1zs/a9T28gKeMfTgmUAPnin04JlBD5459OBZQA+e
JfTgWUEPnjX04NlAD54t9OBp+nkLXsAreHaoD17AK3j2qA9ewCt4DqgPXsAr
eI7/cdXRd/WfOpfuQfeme9a76B317uoT9ZX6UH2rPtdccI40d5pTzbV8QL4h
n5Evycfke/JJ+ap8WL4tn1cuKEeUO8op5ZpyULmpnDX/AKCK0aI=
             
             "], CompressedData["
1:eJyF1V1Ik1EYB/ChS6oVLn03ImjZINzNunFKKuNZQghBQUa4oiCFboRI0Ivw
JiqCSMFb+7iRhWLEgopwdpFJF3Uh0ee8eBGc2ogxGBubF66Pt/c8+wcPHN4D
782Pw3mf8/E/5/Dgtb4rdS6X66z11VvfKQr6hrJlenD/X/MvurhNV8NPU9US
pQJ3cmeu++CpbFt4R7BI6cRwdHe/AQ+Nbz08Hi9QJXRxcqm9Gf7CXO4wY3ny
JXvXxowm+Gz3wq8jWz8p0ma1khfuvvdy181vP+ixNXw60QgvLD8fPLC6Tpkx
I9k7sBceD5640dq8RoesMucDHvhoV2FqKW+SVU05ZO78P87XzmTVv8LzbYA3
Xsh2x2e+8Lzc8KNdJ28HYh/JsOuvg+fm2qPnvO+5zj9vah65mwlm3r2lgF3P
Ntw82DrS/2Gepuz/VuB94T0D0fQzHr8I7/Gsxuor09Rij5ODf7o0Efn+e5K8
dv8M/PTErSdX3cPsn+G6NsT9W1R/qnmex9+vxoeLeuCXuX7Vvwjf5Pk+UvOF
H+P1UeNsw8V6wjt4/f1q/WM138f7taL2C17m/VX/bYCL8wA/z+dH1eOBl/i8
bajzBhfnEy7OM/wVn39VfxNc5AX+mvOl5mXAE5zHBZVHuMivo4tcw0WuHesU
uXZcB926iVzDRa7hun0UuYaLXMNFruG6cyhyDRe5hotcO+ZI5Boucg3XNZFr
3AMi1473jMg1XOQaLnIN192TIteLNRe5hotcw3X3vMg1XOQarnt3dO+UyDVc
9w6KXMNFruG6d1nnfwHOe2s5
             "], CompressedData["
1:eJx1lU9IVFEUxh86STWFk74ZImiygXA208ZRUhnuSQghKMgIpyhIoY0QCrYI
N1ERSApu1drIRFLEBBXh2OLepEUtJPo7Lh6CYzXEMDDMMOPC6c/r3biLA9+B
u3gfl/O+c+753Xt4eHTgSoNlWWfd1eiuUyISHMlXhfU/5uf+RUgt1GNPMvWK
0TPhO4Uz14Mqk++I7YiUjZ5NjSV2D9oqOrV173iyZPRa9OLMSmereu6sdjlU
NHow3b8xYbeoxd7lX0e2fho93uFGJaB8d1/suvnlh9EfuOmzqWZVWn02fGB9
0+i5CTvdP7RXJSMnbrS3bhj9kGtzKexX13pKsytFx+ium2rU2alKn7vT9dAa
q7dJNV/I9yYffmJ1+dTRnpO3w/Te6Lbnv0EVHnUmzgXeMp9/ZHwyF8m9eW30
sOdnWzoH28cH3y0Zfdb7b00OxPYMJbJPWf6y7POvU2NtwehtXp6C/HBpOv71
94zRA97+nDw9fevxVd8Y0z9KC8QI29+m94siy79f5xfAj7jM/Ov9ZfGd1Xtf
1yuOsf7oPNsC9FN0sf6HdP9pHzuvNX1eVGXnq//bRGAe6DybH+3HTxU2b9/0
vBGYTwLzTC/Z/Gv/LQR4oVeML12XTSnG47LmkQC/UAdcE+Aa+gRcwz6gvgGu
CXANzxFwTYBrAlwTmkPAtQBcC8A15AhwLQDX5psH4FoCruE9A7iWgGsJuJbo
ngRcK8C1AlzDex5wrQDX8N1B7xTgGr6DgGsFuFboXUb6X3a8azk=
             
             "], CompressedData["
1:eJyFlU1IVFEUx1/T5MdMOpO+MVfjVKASLoSmVslc2tjnwiLbBKJWC6l0aZLl
opFahOBCLKshFDfSUK2qRYlQ5KoIYlxE4SAECS2mNGQKe71z3z/4D5d34W1+
XM4759zzu3dXT//J8wHLsk4531bna5343bPYv5a6e+ffqpu39BoZqP+yd2Ij
9TyeXu0YjIEf/xZM7hj9k8pND7SFztjgb7Yst77MWGq9+ezYwv5a8D2fm5IH
ugMqlm1fHrJrwA+GnAjlQZXc56wfUXB79Pv1S+Pb1IwTPjcdAZ/tuPy2JVCu
8kN2tr27Cvznxc7hbGeFanDSfBYPg2/mZh8UxiqVk81a86eK/3mOd7VsPAop
qbcM/Oj9kcaFx2EldQXBb/2qvH1icruy3fwD4OmHxa6pc1U6z81XHm+bOp2Z
i1WruJtPEfzpys5j1+aq1aT733Xw/PCh3trGiI5fAH934ePXvnREJdw4q+BX
Mu+XbixGVNTdnwd321zw+AdwWVFl0fL2J2R/yuODOn69xAenfMC9/GV/AfyJ
rvee1Avu9UfiFMGpn+A3df/rpP+o44g+ryU5L/DX+nzlv2XgNA/g3vxIPmHw
GT1vKzJv4DSf4DTP4Lv1/Ev+NeDkC/hh7ZfUZYNf1T6+EB/ByV9fTl6Dk9e+
eZLXvn0w9Y28LjmXBjoX0zmS1+DkNTh5DW6aQ/IanLwu8cImL0wekdfg5DW4
LF+vcQ+Q1773DHkNTl6X3HsJuvdM9yR5Pe9x8hqcvAY33fPkNTh5DW56d0zv
FHkNbnoHyWtw8hrc9C6b+F/sXEUv
             "], CompressedData["
1:eJyNlUtIVFEYx2/T5GMmH+kdczVZgkm4EJpaJefDjb1caGSbQNRqEZYuTfKx
aKQWIbgQS2sIxY00lCt10fkQklwVQYyLKByEQKHFpIZMord7rmfgDH/wwF3c
P+d+9/89fuecbu9qvuuzLOuG8xx1ntrRf+3LXVvC8tbLF/9XGQ92l/88N7qj
9flwdKOpJ8TX1/2RE0O7Wk9MdtcFbtm8dGS19kPMogN9u/r28OKFUq78cTZy
sc2n9VC8YbXXLuFLAefLXL/WI+ed9aeY7aHfAw9Gjml9ygmfmCzi6aaHn2p8
uVpP9trxhrYC3uxs6Yu35Gn9lGNzLhzkvcT069RwvtYdN1vV3/N4aaS1Zudt
QOsq3xy++mqwavFdUOsqLz8/+5v/vHHsuNZt17+Po2/SreN3Cgyfe7Ju/GZs
JlSo9bDrJy1n105e65/J6GPuf7dlsq++o7SqyIifkp/vfft1P5rRK9w4G/JR
7MvKk+WMXuzuT0q3zClT/yq9N60fLHN/hdoveoz45Sq+AH6E6V/tT4n3Rr4T
Kl9h1kfFSQtQT/HUqH+Zqj9dMfq1ovpFH43+qv/mEJgHMudH+QnSlDFva2re
CMwngXmmM8b8K/8lBHihywZfKi+bHhs8LigeCfALdcA1Aa6hT8A1rAOqG+A6
qy8e17CPgGsCXBPgmtAcAq4F4DqLC49ryBHgWgCuvT4dmmsJuIbnDOBaAq6z
zj2Pa4nOScA1A64ZcA3PecA1A67hvYPuKcA1vAcB1wy4ZnQvI30flJ1FLw==

             "], CompressedData["
1:eJx11V1Ik1Ecx/HppEh2YThfiAfbWpsLsU03AyvrX5C9UDJdeBHrZrUwCxIL
irUgtBEYERHUhQSFRV2YBGmMIaRiNxHeJGgQVAQj0ELp5Uqo7Tnn+QU/6YFd
7MPDec45z/lu7vi5jkSxzWaL5j/2/Odu7+Nc6+wmOVW4crUTNn2tdMQrvnX7
xTmy/3Ny1AcvTV0p3nKwTqZ++WO3+rzwj90PBxNn6qWnpXRuKLIZfil+xLjh
DUhNeqE9U+OBX64v6Z8+HJS3hWvRDT8WmfXdWwxKsvDgrAs+b3tfNHixQfKD
pBfWb4SP7Yjc7FxukGf5aTpHDPiM/U1mV6xR1s0N9bQc2gD/vm3pjpFtlIS5
3ir49vmBvlZHSCbNdVXA9wwffzQVDen5l8PTpwfux26H9DzL4O/azi69eB2S
YXM+Dnhn08vxfcshOWk+dy38RImv/7wzLIY5vh3+INWcux4Iy1NznJVXlrs9
TUXZvWGpNu//8c+jP8cCbWEpM/0L/MnXA1v/tIdFffu0k+8Pqvt38/h+NT7c
mk9GzQduzd+l5i+83i61Xri1P8/V/sCv6f1Mqf2Ei95/NX45vFm/r2n1vuDW
+1XPrYJb58GhzgN8VJ8fNR8Dbp23o+q8wa3zqebpgif1eZ5R5xl+QZ9/NX8P
/IPupVf1Al+j+1Lr8sJ/6x4rVY/wq7pftd5aOHUNp67h1DWcuoZT13DqetW+
JWnfqGs4dQ2nruHUNZy6hlPXcOoaTl3DqWs4dQ2nrld1V03dUddw6nqc7w/S
7wB1Daeu4dT1BK+3i37HqGs4dQ2nruHUNZy6hlPXcOoaTl3DqWs4dQ2nruHU
NZy6hlPXcOoa/r//67+NQD56
             "], CompressedData["
1:eJx11V9IU1EcB/CrkyLZg+HUiIttrc1F2OyPgZXdX0H2h5LpwodYL6tFWZBY
UKwFoY3AiIigHiQoLOrBJEhjDOH+FHuJ8EVBg6AiGIEWSn+ehNru73APnMPv
wH35cjn3d875fc4NJC91psoNw4gXH0/xedj7vNA2uxEMMc6WRqEBVzqTNT+6
I27uGzn0NT0axsrMjfLNR7a4+eSfSOJeXwg/dz8dTF1odPOe1sq5odgmvJY8
bt4JRd28PrvQkasP4vXGiv6pY01u/qE0FgN4MjYbfrQo83Tpw3k/zhsfywav
bnPz4iTZhbUbcGxP7G7XssxfFcv0jZg47Xmf25fY7uZr5oZ6Wo+ux5+7lh6Y
eZmnnPXW4e75gb427w43n3DWVYP7h089m4zLnOqvxuz5gceJ+zKnOqtwpv3i
0pt3Mh926vFiV/Pb8YPLMj/jfHc1nq4I91/27XRz05nfg08yLYXbUZm/dOZZ
sQPB5rL8AZmvc97/ZQfiv8ei7TKvcvJv9ovvh7f+65A5jS971feb6H1LnT9C
81tqPTmqx1Lr91P9oK73HK0X1P15TfsDt5T9zNB+Aij7T/NXQ4tyXlN0XqCe
L323DtR+8FI/wKjSP1SPCWq/naB+A7U/qU4/pJV+nqZ+hitK/1P9QfikeOkl
L7BK8UXrCsFfxWMteYSbil9abwMwroFxDYxrYFwD4xoY19q+CdfaPgvXwLjW
zlG41s5duAbGNTCugXGt9a1wrfW5cA2Ma2Bca+6Ea4txbTGuxxnX2r0hXNuM
a5txrd1jwrV27wnXyLhGxjUyrrV7W7jW7nnhGhnX2n9EuNb+O8I1Mq6RcY2M
a2RcI+MaGdfI/a//AwmRPno=
             "], CompressedData["
1:eJx1l1lslVUQx6+FFAO5Wuj2qUih9smIAUoIkMZ74oJWUQhraW+XlEoXtfRC
jSEkxtYgtEYw9EHUB6KmQAVqsXvBfGOX2wXaslwUsQYeXBIl5QFMNU2sxPP/
H/hOvE2aJpPpnJk5/9+Z+RYUbl/3aozP5/vszu+0O78DV3aHDoz/7Pr++3lI
+fBzDvbYpuDVuElHVbuZM0pLRgP0r5n0B5+74ah147vmLSu8FhiGfahnfvCL
S47KPjFr4e9VvwX6YS8p66tbespRxTETF0KZNwNh2MvUrk9i9ziqo2bJzTXV
twLfwd7pb7j++BpHtRcFa9KzJkz8eaMjx9oedNS36VcXXE+bDERgLy70T3WH
k9X7YyvDl3/9x+TZW/HyV69XJqsj/UX5q1+5Tw3Bnv/2tRURJ1ltrFw+Z0vq
NMX4tz49Gn60JUm9152z8sr4dDUCe+vQ90mhVUmqYnh4dkJzrGJ/hlqeevPv
0USVNb02Mbv8fsV8Hr6xqP6XtYkq4ky9NJky09ifL48/XzyYoDrenV+7un+W
yeex9v2h1hUJKj13ou3IVr+JX71kx9MzPo9X28Y+8hfffkCxrv7Ctakfx8Sr
L7uaGt/KiDN5fn1wbKohZ45aOHd52vq/4sy5HdviZffJ2aodf9n/J+HH/2N8
xuU5zId5MC/mz7xZB+N0oU7WzTiX0Rf2if5b0Ef2lfmH0PcW3APj7MU98d4Y
ZxPulfdM+1HogLpg/A+gG+qI8buhM+qO9k7okjrtZb3QMXXNc8uge3LAOLng
hNzQPwtckTP67weH5PJefgvqTmeQY/pXan/X9n9Rx3ft+Jt0Pq6dT5HO33BM
e5uu17XrbdX9cbvQn/Owu7qfhmP61+r+uyVW/+v1fQnvi/7gVuz7rdZ6kD+h
B567XetHyDH9s7XehHqjHdzKI5Y+W7WeJRN65nu1WOtfqH/qoUTzIuSF9gbN
lwyAL8Z/QvMozeDxIuzgVsixxbuQd8YHt3IcHJPTKp2HlIJj6j9V5y1LwTH9
X9B1Ct8r3gu4FXJ8FvZB3UfJBceXYAe3sgMc8/25re9J9oBj2nGvshkc096j
dSDHwfGg9/2XA+CYdUFn8g04NvxqXUoXOO7xziPpBsejjK91L2+AY/YfnMgG
cGzNRykAx+wPOJQRa56CW9Ecn82w5q8cAseDVvxnwXHEymcVOKY/uJV8cNxn
1XsaHHNeg1tpBsfsfwr62Q6OTXz0fx84ZnxwK8fAsTV/ZQM4ZhxwK1XgmP0H
t0KO2TdwK4Zj2MGtXATH9Ae3Qo7pnwb9k2PWC26FHNMObsVwDDu4FXLM+J3g
lxxTP+BWyDHtJxG3F+fw3NeQBznm+wBuhRybuY86MX+F78MF9GUu+sT889BH
csw44FbIMeOAWyHHZq7hXnNxz/Q/AR2QY577IXRDjqPMC+Pf5J0v5txe6LgU
umacCuieHNN/s3femTwPeeej8f/JO0/lXn73NUbOkGP613rntfGv8M530+dn
vPuA8Q969weTZ6d33zDn1uNdY3/MvMY7mGL1cy/eTXIcZV8y9iy8y3m4X9rB
rSLHrKsc7z45jrLvmfxHMFeoT9pbMIfIMe2LMLfIcZR99a4OMRfD4Muav4oc
kzvuzeSYXHNvxh5t4oBb1QiOyek72APIMeOAW7UMHEf5XrDfN8X3jd8vA9hj
yLHpG/aeneA4yvfOXX6xV+WB4x+4D2MPI8esl3vzQXAc5XvNNd8F2AtPgWPW
BW5VHzjmewhu1U5wbH9v5oBjzh3utYfBsTV/1R/g+P++fwvqfjzzL8SyJUg=

             "], CompressedData["
1:eJx1l2tM1mUYxt+Qg4LE4WUrbQTqtGKzD27pSidPyZyibaY2B5kONhvo0GVb
xcmUwca0ROlLVq95olk6R3YwGPneoNLJnC1DmHzAQ8zDMkNDBq5lPdd15//e
fLd3bNcenvf538/1u6/7P6F43eJVMaFQaPfd76i7375xqfH1m/qjof8+GS6E
D/WdBdWVyXfC7qkdZ+KWZn+fS73sztmqGTfC7tyf325Y8UiP6jOnj2+u6Q27
ykldN5aeupDbDb31eqR3UMJucUnjs1sTruj66zuGz++MhN3bKbUL+qf/oXrR
q62f168Pu5WZ1QmDBwdUP9zUveREbtj91HDoi3FH/sq9DD3ry8STJXFht/fi
SOyBr4d0fek7ZydvPpbuEnuemVbRPKL6wvfeKppTke7alhQueinyt+7TML9l
zWdPpLu4mItF4WjIcf3xmXPTb/2c5iQx6Vzv4zGqr3t51e2pr6W5vtK1eZVb
Rqk+b9JjtbXJaW5OxbS9xf2xqsdP/qQna3eqG44ZPzrx6XjVrwzNbs95MtUN
NjeeuFaToHokM3NGU2mKe7S6fF/dsdGqd69+PrJ19YPu05xNDxUMj1G95sjU
V15fmeyq3p1Sdm1KkuqSmBXqnDfWRfGXejXW8f+oc1/+DnWeg+fi/fLcfA7q
I3hOPjf3yUNdWCfq51HHtawr9HbUnfeg9cQ98d6of4N75T1TT4IP6Ave+z74
hj7i+U/BZ/Sd+hO+pE+pb4OP6Wvu8yJ8Tw64fgM4ITfU+8AVOaOeCw7J5b38
bkz5ahY5pp7j10ft+l/9/lG7/5v+PMoxz7/Inz9qz7/ZP69yTH2Fr0/U1uek
r2fU1nOPr380G/WnPsbfl3JMvdXfr3LMc8Z4P8h244eo949Y/1zwfhP6jfuA
W5lv/Dnk/SwJxs+3vP+F/qee7XmRD8EL9f2eL+kxfFV4HqXO8AhuRQy/tX6d
WN7BrRww/eEDfw6ZYPrJZX9uuW36D7gV26/AreSZ/oY6yiXTD1F3aTf9c5u/
J4k1/Rb3KkfBsennkm76ObiVJtP/4TP5ERybfJFiky/wsURMHrV438syk1/g
RN4AxyYfpd/kIziU9SZPwa14jjtn2fVzwbHd/zQ4tudZA45N/spCcGyftxEc
2/osB8e2np3gWH2O+u8Cx/a+xoJje78t4Jg6uJUHwLH1Dzm2fkNuqA5u5Tlw
TB3cCjlmfa7C/+SY68GtkGPq4FbIMXVwK+XgmPt3gF9yzPXgVpC/qh/Cvmfw
O9Qn4hzkmDq4FXJMHdwKOabugv1N9UvBfqh6R7B/qg5uhRxT/w73mo97ph4O
9nPVP4ZvyPF98kKY1wXBfNH1H8HHv8PX1Avhe3JMvTyYd6pnDATyUfXqYJ6q
/i+3u7acbiPHymMwr1W/Gcx3fa7S4Dyg/skPzg+6T0Nw3lD9BfS1YlOf48F5
5v+6oW9mm/qbeUn1dvTlBeZ+Q+jj240fosH5TXUz76k+G7mSb/w5iBxKMH6+
idy6avxv5lXVDyIXuwxf4NbVGR6PInc7DL+cmzFHq/4Lcr3Z9If3MQdMNP0E
3Loh03/M+4Ltb872tzLMMb+Zfsi5hxzf531H14Nb94PpzyWYwzJMP+fcvN/0
f/O+ZvPFFZp8Abduj8kjcOuWm/zinFoFjk0+uocHgvnIObje5Om9778bU7ra
/gGOOeMG
             "], CompressedData["
1:eJx1l31olWUYxs/O2VrNZKBCZaxNRbOB/SGklOJ5yiE6DUyN2DJlA2NTpmRQ
7eOYjQ1Ey+n6p1nH/JpoiqysbGP5PJu6vkz6MHU4yM9hjsbaxtna1of2XPet
7wUdOAx+vHvP897P9bvv551QuG7JqnAoFNp96xu59d1Rd/tz0Ib++ySbED7C
d+bFykePRMwTdWdTlmU1RoWXjJyvmNkTMRf/+GrDioe/UT5rxviGyo6IKZ90
rmfZmZ+UN3XHOxIuYpYU1T69NbVdeXfd0OWd8Yh5O71qYeeMX5UXvNJ0dNP6
iFmZEUtNHL6i/JP6C0tPRSPm+5ojnz507LryzM/SThelRMzeq8PJh764obz4
nfOTN58Im7T2p6aXNXQpX/TemwVzy8KmeWn+4hfj3cprFjSu+fixsEkJXy0Y
a3uUn5w1b0z/j0nGpY262DG1V/m6l1YNTHs1yVwqXptTvqVP+fxJj1ZVjU4y
c8um7y3s7Fd+z+SD7Zm7Q2YoPP7etCcTyn8bnNOS/XjIJBpqT3VVDiiPZ2TM
rC/+J/pIrHRf9YlB5RdWPxvfuvrv6EfZbz2QN/Sn8spj015+beVf0Yp3p5R0
TRlW7tIyQ23zR6IWf4XHcJ38n3C5r/yOcFmHrEu4rFueQ/gwnlOeW3gO6iJ1
En4ZdVyLugpvQd1lH7Se2CfZN+FfYl9ln4WPQg4kF8L3ITeSI+FnkDPJneYT
uZScCt+GHEuuhT+P3IsHwjfAE/FG+CV4JZ4Jj8JD8fJufzem758tHgvP9tdb
vv4Xf3/L93/Dr8fyehb79Vte/2b/vJafd4Wvj+X6nPb1tFzPPb7+Novqf5/f
L8v71eT31/L+hn0e7HbKg/X5sZyfKz5vlvMGb+0Cyuegz7NNpTz3+/xbzn+W
98V+QL4c8H7ZdvKrzPtoq8lHeKseC6/y11n2Hd7aQ9Qf3vfrsBOon9zw63YD
1H/greN+BW9dDvU31NFdo36IursW6p/b/D65ZOq32Fd3nPozcuDGUD+Ht66e
+j9y5r6jeYFcukKaL8ixi9M8avS5dy/Q/IIn7nWad/DKddJ8hIduPc1TeOu8
x5/P5uvnwWO+/w/wmNezBh7T/HWL4DE/by085vosh8dczzZ4rDlH/XfBY96v
++Ex728jPBYOb10SPOb8iMecN8wN5fDWPQOPhcNbJx4Lv4n8i8fC4a16LBze
qsfC4a0thcfCW+GveCwc3srcVn4E9z2L3xE+EesQj4XDW/VYOLxVj4WbYH9T
fi3YD92d9Qf6p3J4qx4L/xr7mot9Fj422M+V70duxOP/mRfK84LzRfmHyPHv
yLXwfORePBZeGpx3ysf1Buaj8lhwniq/7e2uLa5ZPFYfg/NaeV9wvisvDp4H
lOcGzw/Ka4LnDeXPoa8VUn1OBs8zd+qGvplF9afzkvIW9OWFtL8h9PHtlAcb
PL8pp/Oe8jmYK7mUzwTmUCrluQ9z6ybln86r6sthzMVz5Be8jVaTj8cxd1vJ
Xzk3x8j3nzHXG6g/7MA5YCL1E3hrBqn/0PsC9zfD/a0E55jr1A/l3NNK/ZPe
d5TDW/Mt9ecinMPGUT+Xc/MB6v/0vsbzxeTTfIG3Zg/NI3hrltP8knNqBc07
Odc+2Bucj3IO3kTz9O73343pbc3/AkGQAV4=
             "], CompressedData["
1:eJx1l31olWUYxs/O2VrNZKBCZaxNRbOB/SGklOJ5yiE6DUyN2DJlA2NTpmRQ
7eOYjQ1Ey+n6p1nH/JpoiqysbGP5PJu6vkz6MHU4yM9hjsbaxtna1of2XPet
7wUdOAx+vHvP897P9bvv551QuG7JqnAoFNp96xu59d1Rd/tz0Ib++ySbED7C
d+bFykePRMwTdWdTlmU1RoWXjJyvmNkTMRf/+GrDioe/UT5rxviGyo6IKZ90
rmfZmZ+UN3XHOxIuYpYU1T69NbVdeXfd0OWd8Yh5O71qYeeMX5UXvNJ0dNP6
iFmZEUtNHL6i/JP6C0tPRSPm+5ojnz507LryzM/SThelRMzeq8PJh764obz4
nfOTN58Im7T2p6aXNXQpX/TemwVzy8KmeWn+4hfj3cprFjSu+fixsEkJXy0Y
a3uUn5w1b0z/j0nGpY262DG1V/m6l1YNTHs1yVwqXptTvqVP+fxJj1ZVjU4y
c8um7y3s7Fd+z+SD7Zm7Q2YoPP7etCcTyn8bnNOS/XjIJBpqT3VVDiiPZ2TM
rC/+J/pIrHRf9YlB5RdWPxvfuvrv6EfZbz2QN/Sn8spj015+beVf0Yp3p5R0
TRlW7tIyQ23zR6IWf4XHcJ38n3C5r/yOcFmHrEu4rFueQ/gwnlOeW3gO6iJ1
En4ZdVyLugpvQd1lH7Se2CfZN+FfYl9ln4WPQg4kF8L3ITeSI+FnkDPJneYT
uZScCt+GHEuuhT+P3IsHwjfAE/FG+CV4JZ4Jj8JD8fJufzem758tHgvP9tdb
vv4Xf3/L93/Dr8fyehb79Vte/2b/vJafd4Wvj+X6nPb1tFzPPb7+Novqf5/f
L8v71eT31/L+hn0e7HbKg/X5sZyfKz5vlvMGb+0Cyuegz7NNpTz3+/xbzn+W
98V+QL4c8H7ZdvKrzPtoq8lHeKseC6/y11n2Hd7aQ9Qf3vfrsBOon9zw63YD
1H/greN+BW9dDvU31NFdo36IursW6p/b/D65ZOq32Fd3nPozcuDGUD+Ht66e
+j9y5r6jeYFcukKaL8ixi9M8avS5dy/Q/IIn7nWad/DKddJ8hIduPc1TeOu8
x5/P5uvnwWO+/w/wmNezBh7T/HWL4DE/by085vosh8dczzZ4rDlH/XfBY96v
++Ex728jPBYOb10SPOb8iMecN8wN5fDWPQOPhcNbJx4Lv4n8i8fC4a16LBze
qsfC4a0thcfCW+GveCwc3srcVn4E9z2L3xE+EesQj4XDW/VYOLxVj4WbYH9T
fi3YD92d9Qf6p3J4qx4L/xr7mot9Fj422M+V70duxOP/mRfK84LzRfmHyPHv
yLXwfORePBZeGpx3ysf1Buaj8lhwniq/7e2uLa5ZPFYfg/NaeV9wvisvDp4H
lOcGzw/Ka4LnDeXPoa8VUn1OBs8zd+qGvplF9afzkvIW9OWFtL8h9PHtlAcb
PL8pp/Oe8jmYK7mUzwTmUCrluQ9z6ybln86r6sthzMVz5Be8jVaTj8cxd1vJ
Xzk3x8j3nzHXG6g/7MA5YCL1E3hrBqn/0PsC9zfD/a0E55jr1A/l3NNK/ZPe
d5TDW/Mt9ecinMPGUT+Xc/MB6v/0vsbzxeTTfIG3Zg/NI3hrltP8knNqBc07
Odc+2Bucj3IO3kTz9O73343pbc3/AkGQAV4=
             "], CompressedData["
1:eJx1l21olWUYx0/HzaNnrrnzDCpjbSpaDeyDkFKKu8shOg1MjdgyZQNjU6Zk
UO3lmI0NRMvp+tKsY74tNEXWq20sn2tTp5WJkU2H++BbI5XMps2xiajd/+t2
zx86cBj8ePac+7nu/++67mds8aoFy8KhUGj7ve+we98tDfc/e/zQf58ME8JH
+daCeGXqbc8823AqeVH2j7nKy26frpp63TNn/zm6ZsnjXY5PmzKmqbrbM5Xj
O68vOnHB8ZZrie4+8cyCkvoXNkYuO36tYeD81oRnPkirmdsz5W/Hi95s+Xrd
as8szYxH+vb1Ov5V45mFR3I980vd/m8eO/Cv41nfRo+XJHtm58XBpL3f9zte
+uHpCesPxUy06/nJFU2Djs/7+L2imRUx07qwcP5riTuO181pXvHl0zGTHL5Y
5Pkho/zwtFmxm7+mG4mmnO1+Kuz4qteX3Zr0Vro5V7oyr3LDMMdnj3+ypiY1
3cysmLyzuCfJ8eET9nRlbR9tBsJjRkSfG+745f4ZbTnPjDZ9TfVHrlZHHE9k
Zk5tLE0zT8TLd9UeGuH4meUvJTYuf9h8kfP+IwUDIx2vPjDpjbeXppqqjyaW
XZ2Y4rhEs0Ids0cZH3+Vx3Gd/p9yva/+jnJdh65Lua5bn0P5IJ5Tn1t5Huqi
dVJ+HnVciboqb0PddR9cPbFPum/Kf8C+6j4rT0EONBfKdyE3miPlJ5AzzZ3L
J3KpOVW+CTnWXCt/BblXD5SvgSfqjfJz8Eo9U54LD9XLof6uTftuunqsPMde
7/P1v9v7+3z/d+16fF7PfLt+n9e/3j6vz8+7xNbH5/oct/X0uZ47bP39bKr/
SLtfPu9Xi91fn/c3bPMgmykPvs2PcH4u2LwJ5w3eyhzKZ7/Ns0Qozzdt/oXz
n219kU/Jl93WL+kivyqsj1JLPsJbEfK3xl4n7Du8lb3UHz6x65Cx1E/+tOuW
W9R/4K1wv4K3kkf9DXWUS9QPUXdpo/65ye6TJFG/xb7KQerPyIHEqJ/DW2mk
/o+cyc80L5BLKab5ghxLguZRs829vErzC57IOzTv4JX00HyEh7Ka5im8Fetx
x3S+fhY85vufhMe8nhXwmOavzIPH/Lz18Jjrsxgecz074LHLOeq/DR7zfo2C
x7y/zfBYObyVh+Ax50c95rxhbjgOb+VFeKwc3op6rPwK8q8eK4e3oh4rh7ei
HiuHt1IOj5W3w1/1WDm8Fcxfx/fjvqfwO8rHYR3qsXJ4K+qxcngr6rFyE+xv
jl8K9sMh6w/0T8fhrajHyo9hX/Oxz8q9YD93/HPkRj3+n3nheEFwvjj+GXL8
F3KtvBC5V4+VlwfnneMZvYH56Hg8OE8dv+/ttg0nW9Vj52NwXjt+IzjfHS8N
ngcczw+eHxyvC543HH8Zfa2Y6nM4eJ55UDf0zWyqP52XHG9DX55L+xtCH99M
efCD5zfH6bzn+AzMlXzKZx/mUITyfANz6wrln86rju/DXOwkv+CtqSUfD2Lu
tpO/em6Ok++/Ya43UX/YgnPAOOon8Nb0U/+h9wXub4b7WxnOMX9QP9RzTzv1
T3rfeZA3nKt+ov5cgnNYBvVzPTfvpv5P72s8X0whzRd4a3bQPIK3ZjHNLz2n
VtG803Pto73B+ajn4HU0T4e+/65N62y9CzNdrcc=
             "], CompressedData["
1:eJx1l39olWUUx/dLW45su7v3jpYKa+TKMNGmFc3us8pwdc1dQQvDrZUj2h8L
GxZFbBXZ3EjMTNPWhbapbGEZhmyQ+R4mhNk1aJQtE92lH0tz3a3QLVea8Xy/
T70HduFy4cu55z3Pec7nnPMWPf70itqMtLS09ivfzCvfZZEbQnVD5yPv7Pz3
EzZp+DwIvb00t6d4W9iMVZ4aal6biNA+/PL8/sPNYXNrdHTVcNXJyHLoY1mv
LmhaFzZddfOG5pufnH2yv7yjakXY7OuLH2hZei4Shd4dHayrnxM2eXXP9Xzf
Mer0xRsWVR76M2Sypxx66sXC804fvOW+1hoJmZHqB7YcaRl3evv6tk/rG0Nm
9f2bCmpTE+65nZnrfr98W8g0NfX1Xqy47OwfW7aydUEyaNpLepdcH0031NfE
20pLXgua0OaCe2vPZTh9bmlDMr04aI6W9aXfviHLPAR9W3fPx2d68s2FfV8W
pUJTDfO2/MbG0ewl+eZ47MT6VPwqZ795Y+0frx8NmLZNz5fHZ1zt9LWzPgrs
WRowkZujz9Zsmeb01A9ztzd7eWb24XiqayLH6d+NXIo/OS/PFPz6wt4fV1/j
9Gf+Xji9aUeuueNMcXbrh9OdfvrsZyOBC9eaU/ilfifs+D/q9MvnUGccjIs6
4+Y5qL+Lc/LczOcA8sI88b7GkMe3kFfqXyDvvAdXh7gn3hv1Dtwr75n6S6gD
1gXjeRR1wzqiPoo6Y91Rn4a6ZJ1Sz0cds6753P2oe3JAXt4HJ+SG9qXgipyx
rjJilkNySftjiURi73BvGTmm/VnLraftS6x/j/55X7tsPJ6O5wMbv8f4ed5c
e16P56WfqTY/3t0qPymbT4/5pP0jNv9eB/LP5zba+/L0fYFb4f3ST8DWg1Sj
Hmj/ua0fYf3QftzWm7DeqINbqUR9Ut9h61neUPW82Na/6PovsbzIb4qXsOVL
ToAvnneR5VEaFI/gVk4rfsGtaN7BrVyn+gPikJtUP3nCxi1G9R9wK+xXPC+4
lQHV37baPMpFcMxzIe9CjqlX2XuSIDimjnuVTnDsuLZ1IBtVPwe3sgYcs/5R
ZzKs5gW4lRxwTP+oYykEx2p+yQFwzPOCE+lU8w5cyV3gWM1TKYv55ym4Fcvx
kTJtn2PtPe2/CBzreLaDYx1/FzhW81eC4Jh+wK1MAcfUk8jnL+CYOriVh8Ex
dXArr4BjxlOD+30PHNMe3EoeOFbzV8gx/YBbwdxwOriVb8Ax/YNbIcf0D26F
HGteyDF1cCvkmH7ArSwEx7QfBL/kmDq4FXJMfSb8fovncF7M8fcTZw9uhRxT
B7dCjpmfr5GXGPJE+wnkkRzTPuHvn04Ht0KOqXfhXqtxz9RbUAfk2PUB1A05
nmReOPt0/3xx+gz/PHJ6r39+ufPu9s87p9f756OQx4qYb57K//kt399/kBzT
/lKlb147+wr/fHfP3erfB5z9bv/+4PIT8O8bTh/Psn1N5+dn9MGkyudK9E1y
PMm+5OLc5d+vnH0u+jg5VvPX6PpR+56z/wpzhfVJ+7cxh8gx7cv8+6eLU+2r
zk8h5uIA+KIfcGvIMfWTmLuDil/uzdijnf/jmOuzVH8Yxh5Ajsk1uDX3qP6j
3hd0fzPsb/T/JvaYv8Ax/XDvOQaOJ3nf+a8PY6/qBsdq/ppW1c+5N1eD40ne
1/R8MZngWM1fMxMc6/fHT8DxJO+bzj/32gZw7PYE7MGr1Dzl3mzn78DBfwCN
79td
             "], CompressedData["
1:eJx1l39MlWUUx/mlkSyDC/eySN0YK4oCBNFqUfdQ2aTRAjet2YQwWYs/cMas
1RpUyxCWMzPJorsFaINm2WwOtsz3DLcmdm2LlZE5g/XDNOlCTSExzfZ8v896
n+2yMbbvHr7vec9zPuecN3fdhpUNSQkJCd1Xf5Ov/i7uvLRueMP58Lvv/PcT
kgT8lEDvLksfyNsZkunqU6fb1kfDhdBDL5eMHG4LSVHV1OqJ2pNWn055tbR1
Y0j6GotPl8gvYfqPj1T01K4Myb6hyIH2FefC9O+vGmtsKghJRuNzAz/0TNnz
92xeVn3o76Ckzjn09Is5560+dtsDHfUalMm6h7YfaZ8JlzLOTV2fN7UEZc2D
W7MbYrPhIui9yRv/vLIkKK2tQ4MXK69YnyceXtVROp4l3fmDy2+sShT6rI10
leW/liXBbdn3N5xLEp4vLGseT8zLkqPlQ4l3bE6R26Hv7B/49MxAplzY91Vu
LDhXlkB/5KaWqdTlmXK85sSmWOQa67NtS8Nfrx8NSNfW5ysiC64V5m39ok8C
H6wISPjWqmfrt8+TYuixnwo727wMuflwJNY3m2b17ycvR54qzpDs31/Y+/Oa
66z/M/8snd+6K13uPJOX2vHxfGEefjz7xWTgwvVyCn/53Ltwjv/H8/Tlc/hc
xsG4mAfGzffg+ffwnnxv6qPIC/PE+KeRx7eQV8bzJfLOe+D5EO6J90a9B/fK
e6bPS6gD1gXPP466YR1Rn0Kdse6oz0Ndsk6pZ6KOWdfU96PuyQHz9iE4ITfU
y8AVOWN9JtUYDskl/Y9Fo9G9E4Pl5JjnzxpuPZ6nf77x9+hPfbeJx2M89P/I
xO8xfvqnm/f1+L70mWvy493r5Cdm8ukxn7yXx0z+vR7kn3qLuS/PvS9wq7xf
Pjdg6kHrnHoYNvWjrB/6z5h6U9Yb6xPcajXqk/ouU8/6BurZ9itT/8r6p55v
eNE/wIvtn4YvPQG+GM8yw6M2OzyCWyXHDu9K3pkHcKs3gGP6IA69BRzT50kT
two4dvqVsl+xb4NbJcfMzw6TR70Ijqkj70qOGU+tuSfNAsc8j3vVXnBsuTZ1
oFucfg5udS04duaFToBj+oNbTQPH1FHHmgOOqaPu9QA4duad9oJjZz7q3eDY
madaDo6d+auG4yPl7vk0c95z/XPBcZETTyc4duav9oHjxc77ZoFj1g+41Tng
mP7jyOdv4Jg6uNVHwbEzf/UVcMz463G/74Nj6uBWM8CxM3+VHFMHt4q5YXVw
q9+CY94juFVyTB3cKjmmD3khx3wvcKvkmOfBrS4Fx8znGPglx3wuuFVyTP+F
8P0Oz6FPgb+fWB9wq+SYOrhVckyfb5CXGuSJz51FHskx9ai/f1od3Co5Zh76
cK91uGfq7agDcky9FnVDjuPMC/vcRP98sfoC/zyy+qB/ftk87PHPO6s3+eej
jaeyxjdP9f/8VuwfOUiOOR8vV/vmtfWv9M93G+cO/z5g/ff49werB/z7htVn
Ukxfc/PzK/ogOeb5Veib5DjOvmT13f79yurp6ON1Tj0M+/c3qzv7ntW/xlxh
fbKe38YcIsc8X+7fPzXOvmrjzMFcHAVf9AG3Qo7pcxJzlxzTh3sz9mjrcxxz
fZHTHyawBxQ4/QTcyn1O/3G+F9z+JuxvnBdvYo+5BI7ZV7n3HAPHcb53bDzg
VvrBMfMAbqUDHDvzV+rAcZzvNdv/uRcmg2Nn/spCcOzMX/kMHMf53rTzi3tt
Mzh2v2dXg2P3+9fM39GD/wL1Oaj9
             "], CompressedData["
1:eJx1l31oFHQYx68tF8saopPsRb1N3Xnzln8Y5dK1Xy0zN9LarSA8y11TCopF
lia00ZtQvmxp6t5OZeVWGGSrWTJf7iEdYaPMl7O18DY9utoYQhQbUsNWv+/3
R78f3MEQvjw+9/ye5/k8z3M54eryNWkej6d1/C99/G/3S23Jh87nqrX/fpI+
5cGnBXruBz+d//SST/0YSPS2ZsSLd0F/riT+97vnfOqJqxNOdHquFDdBDw4f
Xjd2xKeKskJh78YRo/95csqmyS0+dbH6w+obBseMnpEXnH/hRZ+6+/Zyz3vt
aYp6fv3LM54s8qmfX403Fz+WoRjPyJWNbQc943E+3Hht5h+ZKgL9UuyZL3/v
ylOdozHv15tvVu9Djx4/1nvv83kq5E+vXbVlktoBfcgnMw5k56k322uyz5ZO
Nv5Lvrnp1nDnHLUn1rEgKz1b8b2Vn2Weeqdsjvo+Nn1q1RdTVT30j04PbF/a
N1t5ztVO8q+8RTVCL2/3z+1ZPVvtK7qz/9DVaaqZelfJ6yX9s9RQuT++tu42
xfx7O549knh8lgr/8vHyyLQ7jJ/aupopl0/mqrnJ+bu6Gqabd9VnfdK9IZCr
HukZXZ8/cabaC31ZXfdfA1tz1I2lZw4ECr3G//oXtnWGkl7zL/WJsOP/o3/6
5fcwfsbBuOiHcfMd1IfxTr6b/luRF+aJ+nXIYzvyynedRt5Xow6Mh3Vi3ViX
t1BX1pn6KvQB+4L+D6Fv2EeMPw19xr6jfhF9yT6lvhB9zL6mPoC+JwfUFTgh
N9RD4IqcMc4EOCSXtF8w/jkR+nYxOab9KW0fde1XaP9R+qdeqOOJuvH06fij
jJ/+79LvFb6Xee7T+ZF5yA/try39L5/i5vNznX+57OR/pa6XsF7sE3ArrC/1
Jt0PsgT9QD/f6f4Rckz7NN1vwn6jDm4l6PTnr7qfpQL9zD6s1P0v7H/a+zUv
Ql5oX6b5EvJF+0zNo5SBR4dfIb+0L9V2Qt6Zf/iV5eCYfmp0HDIPHG+3549U
gWP6D+p3CucVdXAr5Jjzqk3nUa4Hx5yr4FZ+AMc7oT+o6yQt4HibPZ/lbXBM
++O6D6QSHDOf4Fa+Asd77H0hY7rvTB7ArfSDY/pHH0sxOG6w95ckwDG/F5zI
QnBMP+BKqsAx7cGheAs0x87+Fc1x32Jn/8owON7t+F8GjiNOPPnguNmJPwaO
G5z3FoJj1hfcSi84pp9R5HMUHLPu4FY6wDH7ENzKU+B4p1PfN8AxdXArjeCY
cYJbIce0B7eCvWHiB7eyFxyzz8GtkGPa56D/yTH9g1shx8wD+SLH9ANuhRwz
DxtsfoXzENwK9q+wvkH43Yrvof8A4iDH9F9lzx8TJ7gV7F+jR+z5Zr53AvJI
jmkPboUcM54I6kSO6Wcz6vob6kx7cCvkmPaH0TfkOMW+MPYxe78Y/X57Hxk9
ae8voy+y953JZ5O9H419QYG1T+X//O7oThwlx4w/bu9rY7/O3u/G3mffA0Y/
a98Pxs899r1h9B7MtQDyQz8jmIOjTj4PYm6S4xT3krHfhLk8iPpSb8AcX+L0
A7g1HKe494x9E/ZKBfqT9knsoQqnn5/G3spx+t+5V827HsVerHP4AreGY8bz
CvYuOabOuxl3tJkz4FZVgGPG8xruAHLMfce7YQ04TvF7wZ1vivON9d2POyYD
HHM+824+A45T/N4xcw/cqi3gmP6P4Q4Lg2POZ97NXeA4xe814e8p3oUXwDHf
xTvyAXDMPPPuHATH7u/N+8Ax88+7dh84dvavWlRg71PezXr/Dh39B1LSOHI=

             "]}]}}, ControlType -> None}}, 
      "Options" :> {
       Deployed -> False, AutorunSequencing -> {2}, SynchronousInitialization -> 
        False, SynchronousUpdating -> False}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{503., {177., 182.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`raytracefunction118640200831284558148930 = 
       Compile[{{$CellContext`th$$, 
           Blank[Real]}, {$CellContext`x$$, 
           Blank[Real]}, {$CellContext`y$$, 
           Blank[Real]}}, 
         Module[{$CellContext`activeregion$, \
$CellContext`allcreatedamplitudes$, $CellContext`allcreatedrays$, \
$CellContext`allowzeroraylength$, $CellContext`alternateindex$, \
$CellContext`amplitude$, $CellContext`axismagnitude$, \
$CellContext`axismatrix$, $CellContext`clonedata$, \
$CellContext`clonegenerationnumber$, $CellContext`cloneinput$, \
$CellContext`clonenumber$, $CellContext`cloneposition$, \
$CellContext`clonereportedrays$, $CellContext`clonerotation$, \
$CellContext`clonescale$, $CellContext`clonescalevector$, \
$CellContext`clonesorthistogram$, $CellContext`clonetraceinput$, \
$CellContext`clonetraceoutput$, $CellContext`closestdistances$, \
$CellContext`closestposition$, $CellContext`closestpositions$, \
$CellContext`closestraylength$, $CellContext`completedray$, \
$CellContext`componentnumber$, $CellContext`cosangle$, \
$CellContext`crossmatrix$, $CellContext`deflecteddummyrayspresent$, \
$CellContext`deflectedlocalrays$, $CellContext`deflectedrays$, \
$CellContext`deflectedrayspresent$, $CellContext`dummymatrix$, \
$CellContext`dummymatrixlist$, $CellContext`dummyvector$, \
$CellContext`frontid$, $CellContext`generationlimit$, \
$CellContext`generationnumber$, $CellContext`holeintersections$, \
$CellContext`holeQ$, $CellContext`holeQlist$, $CellContext`hor$, \
$CellContext`index$, $CellContext`index1$, $CellContext`index2$, \
$CellContext`inrays$, $CellContext`intensity$, $CellContext`intensityscale$, \
$CellContext`intersectionnumber$, $CellContext`intersections$, \
$CellContext`intersectionslist$, $CellContext`intersectionspresent$, \
$CellContext`localdummyoutrayspresent$, $CellContext`localoutrays$, \
$CellContext`localoutrayspresent$, $CellContext`magnitude$, \
$CellContext`maxclonegenerationnumber$, $CellContext`maximumposition$, \
$CellContext`minimumraylength$, $CellContext`minresonateraylength$, \
$CellContext`n12$, $CellContext`newcomponentnumber$, \
$CellContext`newdeflectedrays$, $CellContext`newdistance$, \
$CellContext`newsurfaceid$, $CellContext`newsurfacenumber$, \
$CellContext`nonintersectingrays$, $CellContext`normalizedpolarization$, \
$CellContext`oldgenerationnumber$, $CellContext`opticallength$, \
$CellContext`originalray$, $CellContext`originalraytilt$, \
$CellContext`originalrotation$, $CellContext`originalsurfnorm$, \
$CellContext`outrays$, $CellContext`parallelamplitude$, $CellContext`PAxis$, \
$CellContext`perpendicularamplitude$, $CellContext`phaseshift$, \
$CellContext`pol1$, $CellContext`pol2$, $CellContext`pol3$, \
$CellContext`previoustilt$, $CellContext`propagate$, \
$CellContext`propagatedrays$, $CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$, $CellContext`r4$, $CellContext`r5$, $CellContext`r6$, \
$CellContext`r7$, $CellContext`r8$, $CellContext`r9$, $CellContext`ray1$, \
$CellContext`ray2$, $CellContext`ray3$, $CellContext`LocRayL$, \
$CellContext`rayslot$, $CellContext`raysreported$, $CellContext`raytiltx$, \
$CellContext`raytiltz$, $CellContext`reporteddummyrayspresent$, \
$CellContext`reportedlocalrays$, $CellContext`reportedrays$, \
$CellContext`reportedrayspresent$, $CellContext`resonateintersections$, \
$CellContext`resonatenumber$, $CellContext`resonateraylength$, \
$CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`rotationaxis$, $CellContext`rsx$, $CellContext`LocRSx$, \
$CellContext`rsy$, $CellContext`LocRSy$, $CellContext`rsz$, \
$CellContext`LocRSz$, $CellContext`RTx$, $CellContext`LocRTy$, \
$CellContext`LocRTz$, $CellContext`rx$, $CellContext`rxhlp$, \
$CellContext`ry$, $CellContext`ryhlp$, $CellContext`rz$, $CellContext`rzhlp$, \
$CellContext`LocSCx$, $CellContext`LocSCy$, $CellContext`sid$, \
$CellContext`sinangle$, $CellContext`sno1$, $CellContext`sno2$, \
$CellContext`sno3$, $CellContext`sno4$, $CellContext`surfaceid$, \
$CellContext`surfacenumber$, $CellContext`surfacerotationmatrix$, \
$CellContext`surfacetranslationvector$, $CellContext`surfnorm$, \
$CellContext`symr1$, $CellContext`symr2$, $CellContext`symr3$, \
$CellContext`symr4$, $CellContext`symr5$, $CellContext`symr6$, \
$CellContext`symr7$, $CellContext`symr8$, $CellContext`symr9$, \
$CellContext`tempclonedata$, $CellContext`terminatedeflection$, \
$CellContext`thresholdintensity$, $CellContext`tiltmagnitude$, \
$CellContext`transmatrix$, $CellContext`LocTV1$, $CellContext`LocTV10$, \
$CellContext`LocTV2$, $CellContext`LocTV3$, $CellContext`LocTV4$, \
$CellContext`LocTV5$, $CellContext`LocTV6$, $CellContext`LocTV7$, \
$CellContext`LocTV8$, $CellContext`LocTV9$, $CellContext`u$, \
$CellContext`unfilteredintersections$, $CellContext`unit$, $CellContext`uu$, \
$CellContext`ver$, $CellContext`wavelength$, $CellContext`XAxis$, \
$CellContext`xunit$, $CellContext`YAxis$, $CellContext`yunit$, \
$CellContext`ZAxis$, $CellContext`zunit$}, $CellContext`activeregion$ = 
           1.; $CellContext`allcreatedamplitudes$ = {{
             0. + 0. I, 0. + 0. I, 0. + 
              0. I}}; $CellContext`allcreatedrays$ = {{
            1.}}; $CellContext`allowzeroraylength$ = 
           True; $CellContext`alternateindex$ = 
           1.; $CellContext`amplitude$ = {
            1. + 0. I, 0. + 0. I, 0. + 0. I}; $CellContext`axismagnitude$ = 
           1.; $CellContext`axismatrix$ = {{1., 0., 0.}, {0., 1., 0.}, {0., 
            0., 1.}}; $CellContext`clonedata$ = {{
            1.}}; $CellContext`clonegenerationnumber$ = 
           1.; $CellContext`cloneinput$ = {1.}; $CellContext`clonenumber$ = 
           1; $CellContext`cloneposition$ = {0., 0., 
            0.}; $CellContext`clonereportedrays$ = {{
            1.}}; $CellContext`clonerotation$ = {{
            1.}}; $CellContext`clonescale$ = 
           1.; $CellContext`clonescalevector$ = {
            1.}; $CellContext`clonesorthistogram$ = {
            1}; $CellContext`clonetraceinput$ = {{
            1.}}; $CellContext`clonetraceoutput$ = {{
            1.}}; $CellContext`closestdistances$ = {
            1.}; $CellContext`closestposition$ = 
           0; $CellContext`closestpositions$ = {
            0}; $CellContext`closestraylength$ = 
           1.; $CellContext`completedray$ = {
            1.}; $CellContext`componentnumber$ = -1.; $CellContext`cosangle$ = 
           1.; $CellContext`crossmatrix$ = {{1., 0., 0.}, {0., 1., 0.}, {0., 
            0., 1.}}; $CellContext`deflecteddummyrayspresent$ = 
           False; $CellContext`deflectedlocalrays$ = {{
            1.}}; $CellContext`deflectedrays$ = {{
            1.}}; $CellContext`deflectedrayspresent$ = 
           False; $CellContext`dummymatrix$ = {{
            1.}}; $CellContext`dummymatrixlist$ = {{{
            1.}}}; $CellContext`dummyvector$ = {1.}; $CellContext`frontid$ = 
           1.; $CellContext`generationlimit$ = 
           200.; $CellContext`generationnumber$ = 
           1.; $CellContext`holeintersections$ = {{-1., 0., 
            0.}}; $CellContext`holeQ$ = 
           False; $CellContext`holeQlist$ = {0}; $CellContext`hor$ = 
           1. + 0. I; $CellContext`index$ = 1.; $CellContext`index1$ = 
           1.; $CellContext`index2$ = 
           1.; $CellContext`inrays$ = {{1.}}; $CellContext`intensity$ = 
           1.; $CellContext`intensityscale$ = 
           1.; $CellContext`intersectionnumber$ = 
           1.; $CellContext`intersections$ = {{-1., 0., 
            0.}}; $CellContext`intersectionslist$ = {{{-1., 0., 
            0.}}}; $CellContext`intersectionspresent$ = 
           False; $CellContext`localdummyoutrayspresent$ = 
           False; $CellContext`localoutrays$ = {{
            1.}}; $CellContext`localoutrayspresent$ = 
           False; $CellContext`magnitude$ = 
           1.; $CellContext`maxclonegenerationnumber$ = 
           1.; $CellContext`maximumposition$ = 
           1; $CellContext`minimumraylength$ = 
           0.0001; $CellContext`minresonateraylength$ = 1.; $CellContext`n12$ = 
           1.; $CellContext`newcomponentnumber$ = -1.; \
$CellContext`newdeflectedrays$ = {{1.}}; $CellContext`newdistance$ = 
           1.; $CellContext`newsurfaceid$ = -1.; \
$CellContext`newsurfacenumber$ = -1.; $CellContext`nonintersectingrays$ = {{
            1.}}; $CellContext`normalizedpolarization$ = {1., 
            1.}; $CellContext`oldgenerationnumber$ = 
           1.; $CellContext`opticallength$ = 
           1.; $CellContext`originalray$ = {
            1.}; $CellContext`originalraytilt$ = {
            1.}; $CellContext`originalrotation$ = {{1., 0., 0.}, {0., 1., 
            0.}, {0., 0., 1.}}; $CellContext`originalsurfnorm$ = {{
            1.}}; $CellContext`outrays$ = {{
            1.}}; $CellContext`parallelamplitude$ = 
           1. + 0. I; $CellContext`PAxis$ = {1., 0., 
            0.}; $CellContext`perpendicularamplitude$ = 
           1. + 0. I; $CellContext`phaseshift$ = 0.; $CellContext`pol1$ = 
           1.; $CellContext`pol2$ = 1.; $CellContext`pol3$ = 
           1.; $CellContext`previoustilt$ = {1., 0., 
            0.}; $CellContext`propagate$ = 
           True; $CellContext`propagatedrays$ = {{1.}}; $CellContext`r1$ = 
           1.; $CellContext`r2$ = 1.; $CellContext`r3$ = 1.; $CellContext`r4$ = 
           1.; $CellContext`r5$ = 1.; $CellContext`r6$ = 1.; $CellContext`r7$ = 
           1.; $CellContext`r8$ = 1.; $CellContext`r9$ = 
           1.; $CellContext`ray1$ = 1.; $CellContext`ray2$ = 
           1.; $CellContext`ray3$ = 1.; $CellContext`LocRayL$ = 
           1.; $CellContext`rayslot$ = 1.; $CellContext`raysreported$ = 
           False; $CellContext`raytiltx$ = 1.; $CellContext`raytiltz$ = 
           1.; $CellContext`reporteddummyrayspresent$ = 
           False; $CellContext`reportedlocalrays$ = {{
            1.}}; $CellContext`reportedrays$ = {{
            1.}}; $CellContext`reportedrayspresent$ = 
           False; $CellContext`resonateintersections$ = {{-1., 0., 
            0.}}; $CellContext`resonatenumber$ = 
           0; $CellContext`resonateraylength$ = 1.; $CellContext`rex$ = 
           1.; $CellContext`rey$ = 1.; $CellContext`rez$ = 
           1.; $CellContext`rsx$ = 1.; $CellContext`LocRSx$ = 
           1.; $CellContext`rsy$ = 1.; $CellContext`LocRSy$ = 
           1.; $CellContext`rsz$ = 1.; $CellContext`LocRSz$ = 
           1.; $CellContext`RTx$ = 1.; $CellContext`LocRTy$ = 
           1.; $CellContext`LocRTz$ = 1.; $CellContext`rx$ = 
           1.; $CellContext`rxhlp$ = 1.; $CellContext`ry$ = 
           1.; $CellContext`ryhlp$ = 1.; $CellContext`rz$ = 
           1.; $CellContext`rzhlp$ = 1.; $CellContext`LocSCx$ = 
           1.; $CellContext`LocSCy$ = 1.; $CellContext`sid$ = 
           1.; $CellContext`sinangle$ = 1.; $CellContext`sno1$ = 
           1.; $CellContext`sno2$ = 1.; $CellContext`sno3$ = 
           1.; $CellContext`sno4$ = 
           1.; $CellContext`surfaceid$ = -1.; $CellContext`surfacenumber$ = \
-1.; $CellContext`surfacerotationmatrix$ = {{1., 0., 0.}, {0., 1., 0.}, {0., 
            0., 1.}}; $CellContext`surfacetranslationvector$ = {0., 0., 
            0.}; $CellContext`surfnorm$ = {{1.}}; $CellContext`symr1$ = 
           1.; $CellContext`symr2$ = 1.; $CellContext`symr3$ = 
           1.; $CellContext`symr4$ = 1.; $CellContext`symr5$ = 
           1.; $CellContext`symr6$ = 1.; $CellContext`symr7$ = 
           1.; $CellContext`symr8$ = 1.; $CellContext`symr9$ = 
           1.; $CellContext`tempclonedata$ = {{
            1.}}; $CellContext`terminatedeflection$ = 
           False; $CellContext`thresholdintensity$ = 
           1.; $CellContext`tiltmagnitude$ = 
           1.; $CellContext`transmatrix$ = {{{1., 0., 0.}, {0., 1., 0.}, {0., 
            0., 1.}}}; $CellContext`LocTV1$ = 1.; $CellContext`LocTV10$ = 
           1.; $CellContext`LocTV2$ = 1.; $CellContext`LocTV3$ = 
           1.; $CellContext`LocTV4$ = 1.; $CellContext`LocTV5$ = 
           1.; $CellContext`LocTV6$ = 1.; $CellContext`LocTV7$ = 
           1.; $CellContext`LocTV8$ = 1.; $CellContext`LocTV9$ = 
           1.; $CellContext`u$ = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
            1.}}; $CellContext`unfilteredintersections$ = {{-1., 0., 
            0.}}; $CellContext`unit$ = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
            1.}}; $CellContext`uu$ = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
            1.}}; $CellContext`ver$ = 0. + 0. I; $CellContext`wavelength$ = 
           1.; $CellContext`XAxis$ = {1., 0., 0.}; $CellContext`xunit$ = 
           1.; $CellContext`YAxis$ = {1., 0., 0.}; $CellContext`yunit$ = 
           1.; $CellContext`ZAxis$ = {1., 0., 0.}; $CellContext`zunit$ = 
           1.; $CellContext`propagatedrays$ = 
           Join[{$CellContext`symr1$, $CellContext`symr2$, \
$CellContext`symr3$, $CellContext`symr4$, $CellContext`symr5$, \
$CellContext`symr6$, $CellContext`symr7$, $CellContext`symr8$, \
$CellContext`symr9$} = {
                Cos[Degree $CellContext`th$$], 
                Sin[Degree $CellContext`th$$], 0, -
                Sin[Degree $CellContext`th$$], 
                Cos[Degree $CellContext`th$$], 0, 0, 0, 1}; 
             Map[({$CellContext`rsx$, $CellContext`rsy$, $CellContext`rsz$, \
$CellContext`rex$, $CellContext`rey$, $CellContext`rez$, $CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$, $CellContext`r4$, $CellContext`r5$, \
$CellContext`r6$, $CellContext`r7$, $CellContext`r8$, $CellContext`r9$, \
$CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; {$CellContext`LocTV1$, $CellContext`LocTV2$, \
$CellContext`LocTV3$} = {$CellContext`rsx$ $CellContext`symr1$ + \
$CellContext`rsy$ $CellContext`symr4$ + $CellContext`rsz$ $CellContext`symr7$ + \
$CellContext`x$$, $CellContext`rsx$ $CellContext`symr2$ + $CellContext`rsy$ \
$CellContext`symr5$ + $CellContext`rsz$ $CellContext`symr8$ + \
$CellContext`y$$, $CellContext`rsx$ $CellContext`symr3$ + $CellContext`rsy$ \
$CellContext`symr6$ + $CellContext`rsz$ $CellContext`symr9$}; \
{$CellContext`rsx$, $CellContext`rsy$, $CellContext`rsz$} = \
{$CellContext`LocTV1$, $CellContext`LocTV2$, $CellContext`LocTV3$}; \
{$CellContext`LocTV1$, $CellContext`LocTV2$, $CellContext`LocTV3$} = \
{$CellContext`rex$ $CellContext`symr1$ + $CellContext`rey$ \
$CellContext`symr4$ + $CellContext`rez$ $CellContext`symr7$ + \
$CellContext`x$$, $CellContext`rex$ $CellContext`symr2$ + $CellContext`rey$ \
$CellContext`symr5$ + $CellContext`rez$ $CellContext`symr8$ + \
$CellContext`y$$, $CellContext`rex$ $CellContext`symr3$ + $CellContext`rey$ \
$CellContext`symr6$ + $CellContext`rez$ $CellContext`symr9$}; \
{$CellContext`rex$, $CellContext`rey$, $CellContext`rez$} = \
{$CellContext`LocTV1$, $CellContext`LocTV2$, $CellContext`LocTV3$}; \
{$CellContext`LocTV1$, $CellContext`LocTV2$, $CellContext`LocTV3$} = \
{$CellContext`r1$ $CellContext`symr1$ + $CellContext`r2$ $CellContext`symr4$ + \
$CellContext`r3$ $CellContext`symr7$, $CellContext`r1$ $CellContext`symr2$ + \
$CellContext`r2$ $CellContext`symr5$ + $CellContext`r3$ $CellContext`symr8$, \
$CellContext`r1$ $CellContext`symr3$ + $CellContext`r2$ $CellContext`symr6$ + \
$CellContext`r3$ $CellContext`symr9$}; {$CellContext`LocTV4$, \
$CellContext`LocTV5$, $CellContext`LocTV6$} = {$CellContext`r4$ \
$CellContext`symr1$ + $CellContext`r5$ $CellContext`symr4$ + $CellContext`r6$ \
$CellContext`symr7$, $CellContext`r4$ $CellContext`symr2$ + $CellContext`r5$ \
$CellContext`symr5$ + $CellContext`r6$ $CellContext`symr8$, $CellContext`r4$ \
$CellContext`symr3$ + $CellContext`r5$ $CellContext`symr6$ + $CellContext`r6$ \
$CellContext`symr9$}; {$CellContext`LocTV7$, $CellContext`LocTV8$, \
$CellContext`LocTV9$} = {$CellContext`r7$ $CellContext`symr1$ + \
$CellContext`r8$ $CellContext`symr4$ + $CellContext`r9$ $CellContext`symr7$, \
$CellContext`r7$ $CellContext`symr2$ + $CellContext`r8$ $CellContext`symr5$ + \
$CellContext`r9$ $CellContext`symr8$, $CellContext`r7$ $CellContext`symr3$ + \
$CellContext`r8$ $CellContext`symr6$ + $CellContext`r9$ $CellContext`symr9$}; \
{{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$}, {$CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$}, {$CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$}} = {{$CellContext`LocTV1$, $CellContext`LocTV2$, \
$CellContext`LocTV3$}, {$CellContext`LocTV4$, $CellContext`LocTV5$, \
$CellContext`LocTV6$}, {$CellContext`LocTV7$, $CellContext`LocTV8$, \
$CellContext`LocTV9$}}; {$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$})& , CompressedData["
1:eJxTTMoPSmViYGDgBmJ1BnTwYz+GEFbxD/bY1REvv0BK/64K20OoukgHN/HY
kouu2+H6nigFd0kx4jKHkPlQVS0/HJBphD41ND7x7kYXMQaDzxjhhl18qIYb
A5RWQ+MT7250kTNg8AYj3LCLD9Vw44DSamh84t2NLmIETlePMcINu/hQDTcB
KK2Gxife3egiBuDwuYwRbtjFh2q4iUBpNTQ+8e7GLr7BhjjxoRpuElBaDY1P
vLvRRSwg6YpI8aEabjJQWg2NT7y70UUg4fOYSPGhGm4KUFoNjU+8u9FFLkDq
TSLFh2q4KUFpNTQ+8e5GFzGBtNOIFB+q4aYCpdXQ+MS7G12ECUz+IFJ8qIab
Gg6aeHfDWABpSUal
               "]]]; $CellContext`propagatedrays$ = 
           Map[({$CellContext`rsx$, $CellContext`rsy$, $CellContext`rsz$, \
$CellContext`rex$, $CellContext`rey$, $CellContext`rez$, $CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$, $CellContext`r4$, $CellContext`r5$, \
$CellContext`r6$, $CellContext`r7$, $CellContext`r8$, $CellContext`r9$, \
$CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; $CellContext`componentnumber$ = 
              1.; $CellContext`frontid$ = 
              1.; {$CellContext`rsx$, $CellContext`rsy$, $CellContext`rsz$, \
$CellContext`rex$, $CellContext`rey$, $CellContext`rez$, $CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$, $CellContext`r4$, $CellContext`r5$, \
$CellContext`r6$, $CellContext`r7$, $CellContext`r8$, $CellContext`r9$, \
$CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$})& , $CellContext`propagatedrays$]; \
$CellContext`thresholdintensity$ = 1.; $CellContext`generationlimit$ = 
           200.; $CellContext`reportedrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; $CellContext`generationnumber$ = 0.; (
           AddTo[$CellContext`generationnumber$, 
             1.]; $CellContext`reportedlocalrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, 
               0, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; $CellContext`deflectedlocalrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; ($CellContext`deflectedrayspresent$ = 
             False; $CellContext`reportedrayspresent$ = 
             False; $CellContext`deflecteddummyrayspresent$ = 
             False; $CellContext`reporteddummyrayspresent$ = 
             False; {$CellContext`deflectedlocalrays$, \
$CellContext`reportedlocalrays$} = Transpose[
               
               Map[(({$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; $CellContext`index1$ = $CellContext`index$; \
$CellContext`xunit$ = $CellContext`r1$; $CellContext`yunit$ = \
$CellContext`r2$; $CellContext`zunit$ = $CellContext`r3$; $CellContext`xunit$ = 
                  Chop[$CellContext`xunit$]; $CellContext`yunit$ = 
                  Chop[$CellContext`yunit$]; $CellContext`zunit$ = 
                  Chop[$CellContext`zunit$]; $CellContext`magnitude$ = \
($CellContext`xunit$^2 + $CellContext`yunit$^2 + $CellContext`zunit$^2)^(
                    2^(-1)); $CellContext`xunit$ = \
$CellContext`xunit$/$CellContext`magnitude$; $CellContext`yunit$ = \
$CellContext`yunit$/$CellContext`magnitude$; $CellContext`zunit$ = \
$CellContext`zunit$/$CellContext`magnitude$; $CellContext`rx$ = 
                  3.5999999999999996` + $CellContext`rex$; $CellContext`ry$ = \
$CellContext`rey$; $CellContext`rz$ = $CellContext`rez$; $CellContext`rx$ = 
                  Chop[$CellContext`rx$]; $CellContext`ry$ = 
                  Chop[$CellContext`ry$]; $CellContext`rz$ = 
                  Chop[$CellContext`rz$]; $CellContext`terminatedeflection$ = 
                  False; $CellContext`intersections$ = {{-1., 0., 0.}}); 
                If[$CellContext`intensity$ > \
$CellContext`thresholdintensity$, $CellContext`deflectedrayspresent$ = 
                   True; ($CellContext`intersections$ = 
                    Block[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, $CellContext`LocRayL$ = 
                    1. + I 0.; $CellContext`LocSCx$ = 
                    1. + I 0.; $CellContext`LocSCy$ = 1. + I 0.; Re[
                    
                    Select[{{-1. + 0. I, 0. + 0. I, 0. + 
                    0. I}, {(386. $CellContext`xunit$ - 
                    37. $CellContext`rx$ $CellContext`xunit$ - 
                    50. $CellContext`ry$ $CellContext`yunit$ - 
                    50. $CellContext`rz$ $CellContext`zunit$ - 
                    1.4142135623730951` 
                    Sqrt[74498. $CellContext`xunit$^2 - 
                    925. $CellContext`ry$^2 $CellContext`xunit$^2 - 
                    925. $CellContext`rz$^2 $CellContext`xunit$^2 - 
                    19300. $CellContext`ry$ $CellContext`xunit$ \
$CellContext`yunit$ + 
                    1850. $CellContext`rx$ $CellContext`ry$ \
$CellContext`xunit$ $CellContext`yunit$ + 
                    19300. $CellContext`rx$ $CellContext`yunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`yunit$^2 - 
                    1250. $CellContext`rz$^2 $CellContext`yunit$^2 - 
                    19300. $CellContext`rz$ $CellContext`xunit$ \
$CellContext`zunit$ + 
                    1850. $CellContext`rx$ $CellContext`rz$ \
$CellContext`xunit$ $CellContext`zunit$ + 
                    2500. $CellContext`ry$ $CellContext`rz$ \
$CellContext`yunit$ $CellContext`zunit$ + 
                    19300. $CellContext`rx$ $CellContext`zunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`zunit$^2 - 
                    1250. $CellContext`ry$^2 $CellContext`zunit$^2])/(
                    37. $CellContext`xunit$^2 + 50. $CellContext`yunit$^2 + 
                    50. $CellContext`zunit$^2), (
                    37. $CellContext`ry$ $CellContext`xunit$^2 + 
                    386. $CellContext`xunit$ $CellContext`yunit$ - 
                    37. $CellContext`rx$ $CellContext`xunit$ \
$CellContext`yunit$ - 
                    50. $CellContext`rz$ $CellContext`yunit$ \
$CellContext`zunit$ + 50. $CellContext`ry$ $CellContext`zunit$^2 - 
                    1.4142135623730951` $CellContext`yunit$ 
                    Sqrt[74498. $CellContext`xunit$^2 - 
                    925. $CellContext`ry$^2 $CellContext`xunit$^2 - 
                    925. $CellContext`rz$^2 $CellContext`xunit$^2 - 
                    19300. $CellContext`ry$ $CellContext`xunit$ \
$CellContext`yunit$ + 
                    1850. $CellContext`rx$ $CellContext`ry$ \
$CellContext`xunit$ $CellContext`yunit$ + 
                    19300. $CellContext`rx$ $CellContext`yunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`yunit$^2 - 
                    1250. $CellContext`rz$^2 $CellContext`yunit$^2 - 
                    19300. $CellContext`rz$ $CellContext`xunit$ \
$CellContext`zunit$ + 
                    1850. $CellContext`rx$ $CellContext`rz$ \
$CellContext`xunit$ $CellContext`zunit$ + 
                    2500. $CellContext`ry$ $CellContext`rz$ \
$CellContext`yunit$ $CellContext`zunit$ + 
                    19300. $CellContext`rx$ $CellContext`zunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`zunit$^2 - 
                    1250. $CellContext`ry$^2 $CellContext`zunit$^2])/(
                    37. $CellContext`xunit$^2 + 50. $CellContext`yunit$^2 + 
                    50. $CellContext`zunit$^2), (
                    37. $CellContext`rz$ $CellContext`xunit$^2 + 
                    50. $CellContext`rz$ $CellContext`yunit$^2 + 
                    386. $CellContext`xunit$ $CellContext`zunit$ - 
                    
                    37. $CellContext`rx$ $CellContext`xunit$ \
$CellContext`zunit$ - 
                    50. $CellContext`ry$ $CellContext`yunit$ \
$CellContext`zunit$ - 1.4142135623730951` $CellContext`zunit$ 
                    Sqrt[74498. $CellContext`xunit$^2 - 
                    925. $CellContext`ry$^2 $CellContext`xunit$^2 - 
                    925. $CellContext`rz$^2 $CellContext`xunit$^2 - 
                    19300. $CellContext`ry$ $CellContext`xunit$ \
$CellContext`yunit$ + 
                    1850. $CellContext`rx$ $CellContext`ry$ \
$CellContext`xunit$ $CellContext`yunit$ + 
                    19300. $CellContext`rx$ $CellContext`yunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`yunit$^2 - 
                    1250. $CellContext`rz$^2 $CellContext`yunit$^2 - 
                    19300. $CellContext`rz$ $CellContext`xunit$ \
$CellContext`zunit$ + 
                    1850. $CellContext`rx$ $CellContext`rz$ \
$CellContext`xunit$ $CellContext`zunit$ + 
                    2500. $CellContext`ry$ $CellContext`rz$ \
$CellContext`yunit$ $CellContext`zunit$ + 
                    19300. $CellContext`rx$ $CellContext`zunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`zunit$^2 - 
                    1250. $CellContext`ry$^2 $CellContext`zunit$^2])/(
                    37. $CellContext`xunit$^2 + 50. $CellContext`yunit$^2 + 
                    50. $CellContext`zunit$^2)}, {(386. $CellContext`xunit$ - 
                    37. $CellContext`rx$ $CellContext`xunit$ - 
                    50. $CellContext`ry$ $CellContext`yunit$ - 
                    50. $CellContext`rz$ $CellContext`zunit$ + 
                    1.4142135623730951` 
                    Sqrt[74498. $CellContext`xunit$^2 - 
                    925. $CellContext`ry$^2 $CellContext`xunit$^2 - 
                    925. $CellContext`rz$^2 $CellContext`xunit$^2 - 
                    19300. $CellContext`ry$ $CellContext`xunit$ \
$CellContext`yunit$ + 
                    1850. $CellContext`rx$ $CellContext`ry$ \
$CellContext`xunit$ $CellContext`yunit$ + 
                    19300. $CellContext`rx$ $CellContext`yunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`yunit$^2 - 
                    1250. $CellContext`rz$^2 $CellContext`yunit$^2 - 
                    19300. $CellContext`rz$ $CellContext`xunit$ \
$CellContext`zunit$ + 
                    1850. $CellContext`rx$ $CellContext`rz$ \
$CellContext`xunit$ $CellContext`zunit$ + 
                    2500. $CellContext`ry$ $CellContext`rz$ \
$CellContext`yunit$ $CellContext`zunit$ + 
                    19300. $CellContext`rx$ $CellContext`zunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`zunit$^2 - 
                    1250. $CellContext`ry$^2 $CellContext`zunit$^2])/(
                    37. $CellContext`xunit$^2 + 50. $CellContext`yunit$^2 + 
                    50. $CellContext`zunit$^2), (
                    37. $CellContext`ry$ $CellContext`xunit$^2 + 
                    386. $CellContext`xunit$ $CellContext`yunit$ - 
                    37. $CellContext`rx$ $CellContext`xunit$ \
$CellContext`yunit$ - 
                    50. $CellContext`rz$ $CellContext`yunit$ \
$CellContext`zunit$ + 50. $CellContext`ry$ $CellContext`zunit$^2 + 
                    1.4142135623730951` $CellContext`yunit$ 
                    Sqrt[74498. $CellContext`xunit$^2 - 
                    925. $CellContext`ry$^2 $CellContext`xunit$^2 - 
                    925. $CellContext`rz$^2 $CellContext`xunit$^2 - 
                    19300. $CellContext`ry$ $CellContext`xunit$ \
$CellContext`yunit$ + 
                    1850. $CellContext`rx$ $CellContext`ry$ \
$CellContext`xunit$ $CellContext`yunit$ + 
                    19300. $CellContext`rx$ $CellContext`yunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`yunit$^2 - 
                    1250. $CellContext`rz$^2 $CellContext`yunit$^2 - 
                    19300. $CellContext`rz$ $CellContext`xunit$ \
$CellContext`zunit$ + 
                    1850. $CellContext`rx$ $CellContext`rz$ \
$CellContext`xunit$ $CellContext`zunit$ + 
                    2500. $CellContext`ry$ $CellContext`rz$ \
$CellContext`yunit$ $CellContext`zunit$ + 
                    19300. $CellContext`rx$ $CellContext`zunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`zunit$^2 - 
                    1250. $CellContext`ry$^2 $CellContext`zunit$^2])/(
                    37. $CellContext`xunit$^2 + 50. $CellContext`yunit$^2 + 
                    50. $CellContext`zunit$^2), (
                    37. $CellContext`rz$ $CellContext`xunit$^2 + 
                    50. $CellContext`rz$ $CellContext`yunit$^2 + 
                    386. $CellContext`xunit$ $CellContext`zunit$ - 
                    37. $CellContext`rx$ $CellContext`xunit$ \
$CellContext`zunit$ - 
                    50. $CellContext`ry$ $CellContext`yunit$ \
$CellContext`zunit$ + 1.4142135623730951` $CellContext`zunit$ 
                    Sqrt[74498. $CellContext`xunit$^2 - 
                    925. $CellContext`ry$^2 $CellContext`xunit$^2 - 
                    925. $CellContext`rz$^2 $CellContext`xunit$^2 - 
                    
                    19300. $CellContext`ry$ $CellContext`xunit$ \
$CellContext`yunit$ + 
                    1850. $CellContext`rx$ $CellContext`ry$ \
$CellContext`xunit$ $CellContext`yunit$ + 
                    19300. $CellContext`rx$ $CellContext`yunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`yunit$^2 - 
                    1250. $CellContext`rz$^2 $CellContext`yunit$^2 - 
                    19300. $CellContext`rz$ $CellContext`xunit$ \
$CellContext`zunit$ + 
                    1850. $CellContext`rx$ $CellContext`rz$ \
$CellContext`xunit$ $CellContext`zunit$ + 
                    2500. $CellContext`ry$ $CellContext`rz$ \
$CellContext`yunit$ $CellContext`zunit$ + 
                    19300. $CellContext`rx$ $CellContext`zunit$^2 - 
                    925. $CellContext`rx$^2 $CellContext`zunit$^2 - 
                    1250. $CellContext`ry$^2 $CellContext`zunit$^2])/(
                    37. $CellContext`xunit$^2 + 50. $CellContext`yunit$^2 + 
                    50. $CellContext`zunit$^2)}}, ({$CellContext`LocRayL$, \
$CellContext`LocSCx$, $CellContext`LocSCy$} = #; 
                    Or[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$} == {-1., 0., 0.}, 
                    And[Chop[
                    Im[#]] == {0, 0, 0}, N[
                    Chop[
                    Re[$CellContext`LocRayL$]]] >= 0., 
                    Abs[$CellContext`ry$ + $CellContext`LocRayL$ \
$CellContext`yunit$ - $CellContext`LocSCx$] + 
                    Abs[$CellContext`rz$ + $CellContext`LocRayL$ \
$CellContext`zunit$ - $CellContext`LocSCy$] + 
                    Abs[$CellContext`rx$ + $CellContext`LocRayL$ \
$CellContext`xunit$ - (25 ($CellContext`LocSCx$^2 + $CellContext`LocSCy$^2))/(
                    193 (1 + Sqrt[
                    1 - (925 ($CellContext`LocSCx$^2 + \
$CellContext`LocSCy$^2))/74498]))] < 1.*^-7, 
                    Re[$CellContext`LocSCx$]^2 + Re[$CellContext`LocSCy$]^2 <= 
                    39.0625]])& ]]]; 
                   AppendTo[$CellContext`intersections$, {-1., 0., 
                    0.}]; $CellContext`holeQ$ = False; If[
                    Or[
                    Not[
                    Or[Chop[$CellContext`surfaceid$ - 100987.] == 0., N[
                    Chop[$CellContext`ray1$]] < 
                    0.0001]], $CellContext`generationnumber$ == 
                    1.], $CellContext`minresonateraylength$ = 
                    0., $CellContext`minresonateraylength$ = 0.0001]; 
                   Block[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, $CellContext`LocRayL$ = 1.; $CellContext`LocSCx$ = 
                    1.; $CellContext`LocSCy$ = 1.; $CellContext`dummymatrix$ = 
                    Union[
                    
                    Select[$CellContext`intersections$, \
({$CellContext`LocRayL$, $CellContext`LocSCx$, $CellContext`LocSCy$} = #; 
                    Or[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$} == {-1., 0., 0.}, N[
                    
                    Chop[$CellContext`LocRayL$]] >= \
$CellContext`minresonateraylength$])& ]]; $CellContext`intersections$ = \
$CellContext`dummymatrix$]; $CellContext`unfilteredintersections$ = \
$CellContext`intersections$; 
                   If[Length[$CellContext`intersections$] > 
                    1, $CellContext`dummymatrix$ = 
                    Take[$CellContext`intersections$, {
                    2}]; $CellContext`intersections$ = \
$CellContext`dummymatrix$; 1., 1.]); 
                  If[$CellContext`intersections$ != {{-1., 0., 
                    0.}}, $CellContext`intersectionspresent$ = 
                    True; ({$CellContext`newcomponentnumber$, \
$CellContext`newsurfacenumber$, $CellContext`newsurfaceid$} = {1., 1., 
                    100987.}; {$CellContext`componentnumber$, \
$CellContext`surfacenumber$, $CellContext`surfaceid$} = {1., 1., 
                    100987.}; {$CellContext`ray1$, $CellContext`ray2$, \
$CellContext`ray3$} = Part[$CellContext`intersections$, 
                    1]; $CellContext`rsx$ = $CellContext`rex$; \
$CellContext`rsy$ = $CellContext`rey$; $CellContext`rsz$ = $CellContext`rez$; \
$CellContext`rxhlp$ = $CellContext`rx$ + $CellContext`ray1$ \
$CellContext`xunit$; $CellContext`ryhlp$ = $CellContext`ry$ + \
$CellContext`ray1$ $CellContext`yunit$; $CellContext`rzhlp$ = \
$CellContext`rz$ + $CellContext`ray1$ $CellContext`zunit$; $CellContext`rex$ = \
-3.5999999999999996` + $CellContext`rxhlp$; $CellContext`rey$ = \
$CellContext`ryhlp$; $CellContext`rez$ = $CellContext`rzhlp$; \
$CellContext`rex$ = Chop[$CellContext`rex$]; $CellContext`rey$ = 
                    Chop[$CellContext`rey$]; $CellContext`rez$ = 
                    Chop[$CellContext`rez$]; $CellContext`intersectionnumber$ = \
$CellContext`intersectionnumber$ + 
                    1.; $CellContext`opticallength$ = \
$CellContext`opticallength$ + $CellContext`ray1$ $CellContext`index1$; \
$CellContext`completedray$ = {$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}); ($CellContext`reportedrayspresent$ = 
                    True; ($CellContext`surfnorm$ = 
                    1. Re[{{
                    1., ((-0.0016083472422043674`) $CellContext`ray2$^3)/(
                    Sqrt[1. - 
                    0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. - 0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) - (
                    0.0016083472422043674` $CellContext`ray2$ \
$CellContext`ray3$^2)/(Sqrt[1. - 
                    0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. - 0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) - (0.2590673575129534 $CellContext`ray2$)/(1. + 
                    Sqrt[1. - 
                    0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)]), ((-0.0016083472422043674`) $CellContext`ray2$^2 \
$CellContext`ray3$)/(Sqrt[1. - 
                    0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. - 0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) - (0.0016083472422043674` $CellContext`ray3$^3)/(
                    Sqrt[1. - 
                    0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. - 0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) - (0.2590673575129534 $CellContext`ray3$)/(1. + 
                    Sqrt[1. - 
                    0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])}, {(
                    0.0016083472422043674` $CellContext`ray2$ \
($CellContext`ray2$^2 + $CellContext`ray3$^2))/(
                    Sqrt[1. - 
                    0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. - 0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) + (0.2590673575129534 $CellContext`ray2$)/(1. + 
                    Sqrt[1. - 
                    0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)]), 1., 
                    0.}, {(0.0016083472422043674` $CellContext`ray3$ \
($CellContext`ray2$^2 + $CellContext`ray3$^2))/(
                    Sqrt[1. - 
                    0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. - 0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) + (0.2590673575129534 $CellContext`ray3$)/(1. + 
                    Sqrt[1. - 
                    0.012416440709817716` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)]), 0., 1.}}]; If[
                    Or[
                    Part[$CellContext`surfnorm$, 1] == {0., 0., 0.}, 
                    Part[$CellContext`surfnorm$, 2] == {0., 0., 0.}, 
                    Part[$CellContext`surfnorm$, 3] == {0., 0., 
                    0.}], $CellContext`surfnorm$ = 
                    1. Re[{{1., ((-0.0016083472422043674`) (
                    1.*^-6 + $CellContext`ray2$)^3)/(
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) - (
                    0.0016083472422043674` (
                    1.*^-6 + $CellContext`ray2$) (
                    1.*^-6 + $CellContext`ray3$)^2)/(
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) - (
                    0.2590673575129534 (1.*^-6 + $CellContext`ray2$))/(1. + 
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)]), \
((-0.0016083472422043674`) (1.*^-6 + $CellContext`ray2$)^2 (
                    1.*^-6 + $CellContext`ray3$))/(
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) - (
                    0.0016083472422043674` (1.*^-6 + $CellContext`ray3$)^3)/(
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) - (
                    0.2590673575129534 (1.*^-6 + $CellContext`ray3$))/(1. + 
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])}, {(
                    0.0016083472422043674` (
                    1.*^-6 + $CellContext`ray2$) ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2))/(
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) + (
                    0.2590673575129534 (1.*^-6 + $CellContext`ray2$))/(1. + 
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)]), 1., 
                    0.}, {(0.0016083472422043674` (
                    1.*^-6 + $CellContext`ray3$) ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2))/(
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) + (
                    0.2590673575129534 (1.*^-6 + $CellContext`ray3$))/(1. + 
                    Sqrt[1. - 0.012416440709817716` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)]), 0., 1.}}]; 1., 
                    1.]; $CellContext`dummymatrix$ = 
                    Map[#& , $CellContext`surfnorm$]; $CellContext`surfnorm$ = 
                    Map[#/Sqrt[
                    
                    Dot[#, #]]& , $CellContext`dummymatrix$]; \
$CellContext`surfacerotationmatrix$ = {{1., 0, 0}, {0, 1., 0}, {
                    0, 0, 1.}}; $CellContext`surfacetranslationvector$ = \
{-3.5999999999999996`, 0, 0}; $CellContext`activeregion$ = 
                    1.; $CellContext`completedray$ = {$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}; $CellContext`componentnumber$ = \
$CellContext`newcomponentnumber$; $CellContext`surfacenumber$ = \
$CellContext`newsurfacenumber$; $CellContext`surfaceid$ = \
$CellContext`newsurfaceid$; $CellContext`originalray$ = {$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}; $CellContext`ZAxis$ = 
                    First[$CellContext`surfnorm$] Sign[
                    Dot[
                    
                    First[$CellContext`surfnorm$], {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]]; $CellContext`raytiltz$ = 
                    Dot[$CellContext`ZAxis$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]; $CellContext`raytiltx$ = 
                    1 - $CellContext`raytiltz$^2; 
                    If[$CellContext`raytiltx$ < 
                    2.220446049250313*^-16, $CellContext`raytiltx$ = 
                    0., $CellContext`raytiltx$ = 
                    Sqrt[$CellContext`raytiltx$]]; $CellContext`XAxis$ = \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$} - $CellContext`ZAxis$ \
$CellContext`raytiltz$; 
                    If[Abs[$CellContext`raytiltx$] < 
                    1.*^-7, $CellContext`XAxis$ = 
                    Part[$CellContext`surfnorm$, 
                    2], $CellContext`XAxis$ = \
$CellContext`XAxis$/$CellContext`raytiltx$]; $CellContext`YAxis$ = {-(
                    Part[$CellContext`ZAxis$, 3] 
                    Part[$CellContext`XAxis$, 2]) + 
                    Part[$CellContext`ZAxis$, 2] Part[$CellContext`XAxis$, 3],
                     Part[$CellContext`ZAxis$, 3] 
                    Part[$CellContext`XAxis$, 1] - 
                    Part[$CellContext`ZAxis$, 1] 
                    Part[$CellContext`XAxis$, 3], -(
                    Part[$CellContext`ZAxis$, 2] 
                    Part[$CellContext`XAxis$, 1]) + 
                    Part[$CellContext`ZAxis$, 1] 
                    Part[$CellContext`XAxis$, 
                    2]}; $CellContext`YAxis$ = $CellContext`YAxis$/Sqrt[
                    
                    Dot[$CellContext`YAxis$, $CellContext`YAxis$]]; \
$CellContext`PAxis$ = $CellContext`ZAxis$ 
                    Dot[{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, $CellContext`XAxis$] - $CellContext`XAxis$ 
                    Dot[{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, $CellContext`ZAxis$]; $CellContext`PAxis$ = \
$CellContext`PAxis$/Sqrt[
                    
                    Dot[$CellContext`PAxis$, $CellContext`PAxis$]]; \
$CellContext`normalizedpolarization$ = 
                    Part[{$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}, {1, 
                    2}]; $CellContext`normalizedpolarization$ = \
$CellContext`normalizedpolarization$/Sqrt[
                    
                    Dot[$CellContext`normalizedpolarization$, \
$CellContext`normalizedpolarization$]]; $CellContext`allcreatedamplitudes$ = \
{{I 0., I 0., I 0.}}; $CellContext`amplitude$ = 
                    Sqrt[$CellContext`intensity$] (
                    Part[$CellContext`normalizedpolarization$, 
                    1] {$CellContext`r4$, $CellContext`r5$, $CellContext`r6$} + 
                    Part[$CellContext`normalizedpolarization$, 
                    2] {$CellContext`r7$, $CellContext`r8$, $CellContext`r9$} 
                    Exp[I $CellContext`pol3$ 
                    0.017453292519943295`]); \
$CellContext`perpendicularamplitude$ = 
                    Dot[$CellContext`amplitude$, $CellContext`YAxis$]; \
$CellContext`parallelamplitude$ = 
                    Dot[$CellContext`amplitude$, $CellContext`PAxis$]; 
                    If[$CellContext`activeregion$ Part[
                    
                    Dot[$CellContext`surfacerotationmatrix$, \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$}], 1] > 
                    0, $CellContext`index2$ = 
                    1.5392664079781753` - 
                    0.7232199521975703 $CellContext`wavelength$ + 
                    1.0984449372238456` $CellContext`wavelength$^2 - 
                    0.5792106404991648 $CellContext`wavelength$^3; \
$CellContext`index1$ = $CellContext`index$; 
                    If[Abs[$CellContext`index2$ - $CellContext`index1$] < 
                    0.01, $CellContext`alternateindex$ = 
                    Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength$^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength$^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength$^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength$^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength$^8]; 
                    If[Abs[$CellContext`alternateindex$ - \
$CellContext`index1$] > 
                    Abs[$CellContext`index2$ - $CellContext`index1$], \
$CellContext`index1$ = $CellContext`index2$; $CellContext`index2$ = \
$CellContext`alternateindex$, $CellContext`index1$ = \
$CellContext`alternateindex$], $CellContext`index1$ = 
                    Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength$^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength$^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength$^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength$^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength$^8]], \
$CellContext`index2$ = Sqrt[
                    1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength$^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength$^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength$^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength$^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength$^8]; \
$CellContext`index1$ = $CellContext`index$; 
                    If[Abs[$CellContext`index2$ - $CellContext`index1$] < 
                    0.01, $CellContext`alternateindex$ = 
                    1.5392664079781753` - 
                    0.7232199521975703 $CellContext`wavelength$ + 
                    1.0984449372238456` $CellContext`wavelength$^2 - 
                    0.5792106404991648 $CellContext`wavelength$^3; 
                    If[Abs[$CellContext`alternateindex$ - \
$CellContext`index1$] > 
                    Abs[$CellContext`index2$ - $CellContext`index1$], \
$CellContext`index1$ = $CellContext`index2$; $CellContext`index2$ = \
$CellContext`alternateindex$, $CellContext`index1$ = \
$CellContext`alternateindex$], $CellContext`index1$ = 
                    1.5392664079781753` - 
                    0.7232199521975703 $CellContext`wavelength$ + 
                    1.0984449372238456` $CellContext`wavelength$^2 - 
                    0.5792106404991648 $CellContext`wavelength$^3]]; \
$CellContext`n12$ = $CellContext`index1$/$CellContext`index2$; \
$CellContext`index$ = $CellContext`index2$; 
                    If[1 - $CellContext`n12$^2 $CellContext`raytiltx$^2 >= 
                    0., $CellContext`dummyvector$ = $CellContext`n12$ \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$} + $CellContext`ZAxis$ \
(-($CellContext`n12$ $CellContext`raytiltz$) + 
                    Sqrt[1 - $CellContext`n12$^2 $CellContext`raytiltx$^2]); \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$} = \
$CellContext`dummyvector$; 1., 
                    If[Dot[{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, 
                    Part[$CellContext`surfnorm$, 1]] > 
                    0, $CellContext`phaseshift$ = $CellContext`phaseshift$ + 
                    0.5, 1.]; $CellContext`index2$ = $CellContext`index1$; \
$CellContext`index$ = $CellContext`index1$; $CellContext`dummyvector$ = \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$} - 
                    2 $CellContext`ZAxis$ 
                    Dot[$CellContext`ZAxis$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]; {$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$} = $CellContext`dummyvector$; $CellContext`dummyvector$ = \
{$CellContext`pol1$, $CellContext`pol2$, $CellContext`pol3$} + {0, 
                    0, -180}; {$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = $CellContext`dummyvector$; 
                    1.]; $CellContext`allcreatedrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; $CellContext`originalrotation$ = Partition[
                    Take[$CellContext`originalray$, {7, 15}], 
                    3]; $CellContext`previoustilt$ = 
                    Part[$CellContext`originalrotation$, 
                    1]; $CellContext`transmatrix$ = 
                    MapIndexed[({$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; $CellContext`rotationaxis$ = 
                    Cross[$CellContext`previoustilt$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]; $CellContext`axismagnitude$ = Sqrt[
                    
                    Dot[$CellContext`rotationaxis$, \
$CellContext`rotationaxis$]]; 
                    If[Chop[$CellContext`axismagnitude$] != 
                    0., $CellContext`rotationaxis$ = \
$CellContext`rotationaxis$/$CellContext`axismagnitude$; \
$CellContext`axismatrix$ = 
                    Map[# $CellContext`rotationaxis$& , \
$CellContext`rotationaxis$]; $CellContext`crossmatrix$ = {{
                    0., -Part[$CellContext`rotationaxis$, 3], 
                    Part[$CellContext`rotationaxis$, 2]}, {
                    Part[$CellContext`rotationaxis$, 3], 0., -
                    Part[$CellContext`rotationaxis$, 1]}, {-
                    Part[$CellContext`rotationaxis$, 2], 
                    Part[$CellContext`rotationaxis$, 1], 
                    0.}}; $CellContext`cosangle$ = 
                    Dot[$CellContext`previoustilt$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]; 
                    If[1. - $CellContext`cosangle$ < 
                    2.220446049250313*^-16, $CellContext`cosangle$ = 
                    1.]; $CellContext`sinangle$ = 
                    1 - $CellContext`cosangle$^2; 
                    If[$CellContext`sinangle$ < 
                    2.220446049250313*^-16, $CellContext`sinangle$ = 
                    0., $CellContext`sinangle$ = 
                    Sqrt[$CellContext`sinangle$]]; $CellContext`axismatrix$ + \
({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
                    1.}} - $CellContext`axismatrix$) $CellContext`cosangle$ + \
$CellContext`crossmatrix$ $CellContext`sinangle$, {{$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}, {$CellContext`r4$, $CellContext`r5$, \
$CellContext`r6$}, {$CellContext`r7$, $CellContext`r8$, $CellContext`r9$}} = 
                    If[Sign[
                    
                    Dot[$CellContext`previoustilt$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]] === 1, {{1., 0., 0.}, {0., 1., 0.}, {0.,
                     0., 1.}}, {{-1., 0., 0.}, {0., -1., 0.}, {0., 
                    0., -1.}}]])& , $CellContext`allcreatedrays$]; \
$CellContext`allcreatedrays$ = 
                    MapIndexed[({$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; {{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, {$CellContext`r4$, $CellContext`r5$, $CellContext`r6$}, \
{$CellContext`r7$, $CellContext`r8$, $CellContext`r9$}} = 
                    Function[$CellContext`mm$, 
                    Map[
                    Dot[$CellContext`mm$, #]& , \
$CellContext`originalrotation$]][
                    Part[$CellContext`transmatrix$, 
                    First[#2]]]; $CellContext`tiltmagnitude$ = 
                    Dot[{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, {$CellContext`r1$, $CellContext`r2$, $CellContext`r3$}]; 
                    If[Abs[$CellContext`tiltmagnitude$ - 1.] > 
                    1.*^-6, $CellContext`dummyvector$ = {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}/
                    Sqrt[$CellContext`tiltmagnitude$]; {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$} = $CellContext`dummyvector$; \
$CellContext`dummymatrix$ = Map[#/Sqrt[
                    
                    Dot[#, #]]& , {{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, {$CellContext`r4$, $CellContext`r5$, $CellContext`r6$}, \
{$CellContext`r7$, $CellContext`r8$, $CellContext`r9$}}]; {{$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}, {$CellContext`r4$, $CellContext`r5$, \
$CellContext`r6$}, {$CellContext`r7$, $CellContext`r8$, $CellContext`r9$}} = \
$CellContext`dummymatrix$; 1., 1.]; 
                    If[$CellContext`allcreatedamplitudes$ != {{
                    I 0., I 0., I 0.}}, $CellContext`amplitude$ = 
                    Part[$CellContext`allcreatedamplitudes$, 
                    First[#2]]; $CellContext`hor$ = 
                    Dot[{$CellContext`r4$, $CellContext`r5$, \
$CellContext`r6$}, $CellContext`amplitude$]; $CellContext`ver$ = 
                    Dot[{$CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$}, $CellContext`amplitude$]; If[
                    Or[
                    Abs[$CellContext`hor$] > 0., Abs[$CellContext`ver$] > 
                    0.], {$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = {
                    Abs[$CellContext`hor$], 
                    Abs[$CellContext`ver$], 
                    0.}; $CellContext`dummyvector$ = {$CellContext`pol1$, \
$CellContext`pol2$, $CellContext`pol3$}/Sqrt[
                    
                    Dot[{$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}, {$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}]]; {$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = $CellContext`dummyvector$; $CellContext`dummyvector$ = 
                    ReplacePart[{$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}, (If[$CellContext`ver$ == 0., 0., 
                    Arg[$CellContext`ver$]] - 
                    If[$CellContext`hor$ == 0., 0., 
                    Arg[$CellContext`hor$]])/Degree, 
                    3]; {$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = $CellContext`dummyvector$]; 1., 
                    1.]; {$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$})& , $CellContext`allcreatedrays$])); {
                    
                    First[$CellContext`allcreatedrays$], \
$CellContext`completedray$}, $CellContext`reporteddummyrayspresent$ = 
                    True; {{$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}, CompressedData["
1:eJxTTMoPSmVkYGBQZ4CBD/YDRzdEmOSfPUicerh79+Og6eZuAGaoMiY=
                   
                     "]}], $CellContext`reporteddummyrayspresent$ = 
                   True; $CellContext`deflecteddummyrayspresent$ = 
                   True; CompressedData["
1:eJxTTMoPSmViYGAAYXUGGPhgP3B0Q4RJ/tmDxKmHu3c/DnoA/UFvemiGGwCy
wWJ9
                   "]])& , $CellContext`propagatedrays$]]; If[
              
              And[$CellContext`deflectedrayspresent$, \
$CellContext`deflecteddummyrayspresent$], $CellContext`deflectedlocalrays$ = 
               Select[$CellContext`deflectedlocalrays$, Part[#, 23] > 0.& ]; 
              1., 1.]; If[
              
              And[$CellContext`reportedrayspresent$, \
$CellContext`reporteddummyrayspresent$], $CellContext`reportedlocalrays$ = 
               Select[$CellContext`reportedlocalrays$, Part[#, 23] > 0.& ]; 
              1., 1.]); (
            If[$CellContext`reportedrayspresent$, $CellContext`reportedrays$ = 
               Join[$CellContext`reportedrays$, CompressedData["
1:eJxTTMoPSmViYGBgBGJ1BhBoiDDJP3twlCaNBgAGqngz
                 
                 "], $CellContext`reportedlocalrays$]; 1., 
              1.]; $CellContext`propagatedrays$ = \
$CellContext`deflectedlocalrays$); $CellContext`raysreported$ = \
$CellContext`reportedrayspresent$; 1.); (
           AddTo[$CellContext`generationnumber$, 
             1.]; $CellContext`reportedlocalrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, 
               0, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; $CellContext`deflectedlocalrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; ($CellContext`deflectedrayspresent$ = 
             False; $CellContext`reportedrayspresent$ = 
             False; $CellContext`deflecteddummyrayspresent$ = 
             False; $CellContext`reporteddummyrayspresent$ = 
             False; {$CellContext`deflectedlocalrays$, \
$CellContext`reportedlocalrays$} = Transpose[
               
               Map[(({$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; $CellContext`index1$ = $CellContext`index$; \
$CellContext`xunit$ = $CellContext`r1$; $CellContext`yunit$ = \
$CellContext`r2$; $CellContext`zunit$ = $CellContext`r3$; $CellContext`xunit$ = 
                  Chop[$CellContext`xunit$]; $CellContext`yunit$ = 
                  Chop[$CellContext`yunit$]; $CellContext`zunit$ = 
                  Chop[$CellContext`zunit$]; $CellContext`magnitude$ = \
($CellContext`xunit$^2 + $CellContext`yunit$^2 + $CellContext`zunit$^2)^(
                    2^(-1)); $CellContext`xunit$ = \
$CellContext`xunit$/$CellContext`magnitude$; $CellContext`yunit$ = \
$CellContext`yunit$/$CellContext`magnitude$; $CellContext`zunit$ = \
$CellContext`zunit$/$CellContext`magnitude$; $CellContext`rx$ = 
                  3.05 + $CellContext`rex$; $CellContext`ry$ = \
$CellContext`rey$; $CellContext`rz$ = $CellContext`rez$; $CellContext`rx$ = 
                  Chop[$CellContext`rx$]; $CellContext`ry$ = 
                  Chop[$CellContext`ry$]; $CellContext`rz$ = 
                  Chop[$CellContext`rz$]; $CellContext`terminatedeflection$ = 
                  False; $CellContext`intersections$ = {{-1., 0., 0.}}); 
                If[$CellContext`intensity$ > \
$CellContext`thresholdintensity$, $CellContext`deflectedrayspresent$ = 
                   True; ($CellContext`intersections$ = 
                    Block[{$CellContext`TempVar, $CellContext`TempVar1, \
$CellContext`TempVar2, $CellContext`TempVar3, $CellContext`LocRayL$, \
$CellContext`LocSCx$, $CellContext`LocSCy$}, $CellContext`TempVar1 = 
                    1.; $CellContext`TempVar2 = 1.; $CellContext`TempVar3 = 
                    1.; $CellContext`TempVar = {{-1., 0., 
                    0.}}; $CellContext`LocRayL$ = 1.; $CellContext`LocSCx$ = 
                    1.; $CellContext`LocSCy$ = 
                    1.; $CellContext`TempVar1 = $CellContext`rx$^2 + \
$CellContext`ry$^2 + $CellContext`rz$^2; $CellContext`TempVar2 = \
$CellContext`rx$ $CellContext`xunit$ + $CellContext`ry$ $CellContext`yunit$ + \
$CellContext`rz$ $CellContext`zunit$ - 
                    6.5 $CellContext`xunit$; $CellContext`TempVar3 = \
-$CellContext`TempVar1 + $CellContext`TempVar2^2 + 
                    2 $CellContext`rx$ 6.5; $CellContext`TempVar3 = 
                    Re[$CellContext`TempVar3]; If[N[
                    Chop[$CellContext`TempVar3]] >= 
                    0., $CellContext`TempVar3 = 
                    Sqrt[$CellContext`TempVar3]; $CellContext`TempVar = \
{{$CellContext`LocRayL$, $CellContext`LocSCx$, $CellContext`LocSCy$} = \
{-$CellContext`TempVar2 - $CellContext`TempVar3, $CellContext`ry$ - \
($CellContext`TempVar2 + $CellContext`TempVar3) $CellContext`yunit$, \
$CellContext`rz$ - ($CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`zunit$}; If[
                    And[N[
                    Chop[$CellContext`LocRayL$]] >= 
                    0., $CellContext`LocSCx$^2 + $CellContext`LocSCy$^2 <= 
                    25., Abs[$CellContext`ry$ + $CellContext`LocRayL$ \
$CellContext`yunit$ - $CellContext`LocSCx$] + 
                    Abs[$CellContext`rz$ + $CellContext`LocRayL$ \
$CellContext`zunit$ - $CellContext`LocSCy$] + 
                    
                    Abs[-6.5 + $CellContext`rx$ + $CellContext`LocRayL$ \
$CellContext`xunit$ + 
                    Sqrt[42.25 - $CellContext`LocSCx$^2 - \
$CellContext`LocSCy$^2]] < 
                    1.*^-7], {$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, {-1., 0., 
                    0.}], {$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$} = {-$CellContext`TempVar2 + $CellContext`TempVar3, \
$CellContext`ry$ + (-$CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`yunit$, $CellContext`rz$ + (-$CellContext`TempVar2 + \
$CellContext`TempVar3) $CellContext`zunit$}; If[
                    And[N[
                    Chop[$CellContext`LocRayL$]] >= 
                    0., $CellContext`LocSCx$^2 + $CellContext`LocSCy$^2 <= 
                    25., Abs[$CellContext`ry$ + $CellContext`LocRayL$ \
$CellContext`yunit$ - $CellContext`LocSCx$] + 
                    Abs[$CellContext`rz$ + $CellContext`LocRayL$ \
$CellContext`zunit$ - $CellContext`LocSCy$] + 
                    Abs[-6.5 + $CellContext`rx$ + $CellContext`LocRayL$ \
$CellContext`xunit$ + 
                    Sqrt[42.25 - $CellContext`LocSCx$^2 - \
$CellContext`LocSCy$^2]] < 
                    1.*^-7], {$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, {-1., 0., 0.}]}; 
                    If[Part[$CellContext`TempVar, 1] == 
                    Part[$CellContext`TempVar, 2], {
                    
                    Part[$CellContext`TempVar, 
                    1]}, $CellContext`TempVar], {{-1., 0., 0.}}]]; 
                   AppendTo[$CellContext`intersections$, {-1., 0., 
                    0.}]; $CellContext`holeQ$ = False; If[
                    Or[
                    Not[
                    Or[Chop[$CellContext`surfaceid$ - 100988.] == 0., N[
                    Chop[$CellContext`ray1$]] < 
                    0.0001]], $CellContext`generationnumber$ == 
                    1.], $CellContext`minresonateraylength$ = 
                    0., $CellContext`minresonateraylength$ = 0.0001]; 
                   Block[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, $CellContext`LocRayL$ = 1.; $CellContext`LocSCx$ = 
                    1.; $CellContext`LocSCy$ = 1.; $CellContext`dummymatrix$ = 
                    Union[
                    
                    Select[$CellContext`intersections$, \
({$CellContext`LocRayL$, $CellContext`LocSCx$, $CellContext`LocSCy$} = #; 
                    Or[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$} == {-1., 0., 0.}, N[
                    
                    Chop[$CellContext`LocRayL$]] >= \
$CellContext`minresonateraylength$])& ]]; $CellContext`intersections$ = \
$CellContext`dummymatrix$]; $CellContext`unfilteredintersections$ = \
$CellContext`intersections$; 
                   If[Length[$CellContext`intersections$] > 
                    1, $CellContext`dummymatrix$ = 
                    Take[$CellContext`intersections$, {
                    2}]; $CellContext`intersections$ = \
$CellContext`dummymatrix$; 1., 1.]); 
                  If[$CellContext`intersections$ != {{-1., 0., 
                    0.}}, $CellContext`intersectionspresent$ = 
                    True; ({$CellContext`newcomponentnumber$, \
$CellContext`newsurfacenumber$, $CellContext`newsurfaceid$} = {1., 2., 
                    100988.}; {$CellContext`componentnumber$, \
$CellContext`surfacenumber$, $CellContext`surfaceid$} = {1., 2., 
                    100988.}; {$CellContext`ray1$, $CellContext`ray2$, \
$CellContext`ray3$} = Part[$CellContext`intersections$, 
                    1]; $CellContext`rsx$ = $CellContext`rex$; \
$CellContext`rsy$ = $CellContext`rey$; $CellContext`rsz$ = $CellContext`rez$; \
$CellContext`rxhlp$ = $CellContext`rx$ + $CellContext`ray1$ \
$CellContext`xunit$; $CellContext`ryhlp$ = $CellContext`ry$ + \
$CellContext`ray1$ $CellContext`yunit$; $CellContext`rzhlp$ = \
$CellContext`rz$ + $CellContext`ray1$ $CellContext`zunit$; $CellContext`rex$ = \
-3.05 + $CellContext`rxhlp$; $CellContext`rey$ = $CellContext`ryhlp$; \
$CellContext`rez$ = $CellContext`rzhlp$; $CellContext`rex$ = 
                    Chop[$CellContext`rex$]; $CellContext`rey$ = 
                    Chop[$CellContext`rey$]; $CellContext`rez$ = 
                    Chop[$CellContext`rez$]; $CellContext`intersectionnumber$ = \
$CellContext`intersectionnumber$ + 
                    1.; $CellContext`opticallength$ = \
$CellContext`opticallength$ + $CellContext`ray1$ $CellContext`index1$; \
$CellContext`completedray$ = {$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}); ($CellContext`reportedrayspresent$ = 
                    True; ($CellContext`surfnorm$ = 
                    1. Re[{{
                    1., -($CellContext`ray2$/(
                    42.25 - $CellContext`ray2$^2 - $CellContext`ray3$^2)^(
                    2^(-1))), -($CellContext`ray3$/(
                    42.25 - $CellContext`ray2$^2 - $CellContext`ray3$^2)^(
                    2^(-1)))}, {$CellContext`ray2$/(
                    42.25 - $CellContext`ray2$^2 - $CellContext`ray3$^2)^(
                    2^(-1)), 1., 
                    0.}, {$CellContext`ray3$/(
                    42.25 - $CellContext`ray2$^2 - $CellContext`ray3$^2)^(
                    2^(-1)), 0., 1.}}]; $CellContext`dummymatrix$ = 
                    Map[#& , $CellContext`surfnorm$]; $CellContext`surfnorm$ = 
                    Map[#/Sqrt[
                    
                    Dot[#, #]]& , $CellContext`dummymatrix$]; \
$CellContext`surfacerotationmatrix$ = {{1., 0, 0}, {0, 1., 0}, {
                    0, 0, 1.}}; $CellContext`surfacetranslationvector$ = \
{-3.05, 0, 0}; $CellContext`activeregion$ = 
                    1.; $CellContext`completedray$ = {$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}; $CellContext`componentnumber$ = \
$CellContext`newcomponentnumber$; $CellContext`surfacenumber$ = \
$CellContext`newsurfacenumber$; $CellContext`surfaceid$ = \
$CellContext`newsurfaceid$; $CellContext`originalray$ = {$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}; $CellContext`ZAxis$ = 
                    First[$CellContext`surfnorm$] Sign[
                    Dot[
                    
                    First[$CellContext`surfnorm$], {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]]; $CellContext`raytiltz$ = 
                    
                    Dot[$CellContext`ZAxis$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]; $CellContext`raytiltx$ = 
                    1 - $CellContext`raytiltz$^2; 
                    If[$CellContext`raytiltx$ < 
                    2.220446049250313*^-16, $CellContext`raytiltx$ = 
                    0., $CellContext`raytiltx$ = 
                    Sqrt[$CellContext`raytiltx$]]; $CellContext`XAxis$ = \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$} - $CellContext`ZAxis$ \
$CellContext`raytiltz$; 
                    If[Abs[$CellContext`raytiltx$] < 
                    1.*^-7, $CellContext`XAxis$ = 
                    Part[$CellContext`surfnorm$, 
                    2], $CellContext`XAxis$ = \
$CellContext`XAxis$/$CellContext`raytiltx$]; $CellContext`YAxis$ = {-(
                    Part[$CellContext`ZAxis$, 3] 
                    Part[$CellContext`XAxis$, 2]) + 
                    Part[$CellContext`ZAxis$, 2] Part[$CellContext`XAxis$, 3],
                     Part[$CellContext`ZAxis$, 3] 
                    Part[$CellContext`XAxis$, 1] - 
                    Part[$CellContext`ZAxis$, 1] 
                    Part[$CellContext`XAxis$, 3], -(
                    Part[$CellContext`ZAxis$, 2] 
                    Part[$CellContext`XAxis$, 1]) + 
                    Part[$CellContext`ZAxis$, 1] 
                    Part[$CellContext`XAxis$, 
                    2]}; $CellContext`YAxis$ = $CellContext`YAxis$/Sqrt[
                    
                    Dot[$CellContext`YAxis$, $CellContext`YAxis$]]; \
$CellContext`PAxis$ = $CellContext`ZAxis$ 
                    Dot[{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, $CellContext`XAxis$] - $CellContext`XAxis$ 
                    Dot[{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, $CellContext`ZAxis$]; $CellContext`PAxis$ = \
$CellContext`PAxis$/Sqrt[
                    
                    Dot[$CellContext`PAxis$, $CellContext`PAxis$]]; \
$CellContext`normalizedpolarization$ = 
                    Part[{$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}, {1, 
                    2}]; $CellContext`normalizedpolarization$ = \
$CellContext`normalizedpolarization$/Sqrt[
                    
                    Dot[$CellContext`normalizedpolarization$, \
$CellContext`normalizedpolarization$]]; $CellContext`allcreatedamplitudes$ = \
{{I 0., I 0., I 0.}}; $CellContext`amplitude$ = 
                    Sqrt[$CellContext`intensity$] (
                    Part[$CellContext`normalizedpolarization$, 
                    1] {$CellContext`r4$, $CellContext`r5$, $CellContext`r6$} + 
                    Part[$CellContext`normalizedpolarization$, 
                    2] {$CellContext`r7$, $CellContext`r8$, $CellContext`r9$} 
                    Exp[I $CellContext`pol3$ 
                    0.017453292519943295`]); \
$CellContext`perpendicularamplitude$ = 
                    Dot[$CellContext`amplitude$, $CellContext`YAxis$]; \
$CellContext`parallelamplitude$ = 
                    Dot[$CellContext`amplitude$, $CellContext`PAxis$]; 
                    If[$CellContext`activeregion$ Part[
                    
                    Dot[$CellContext`surfacerotationmatrix$, \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$}], 1] > 
                    0, $CellContext`index2$ = 
                    1.5532682085807892` - 
                    1.0054245500487249` $CellContext`wavelength$ + 
                    1.6027810806758462` $CellContext`wavelength$^2 - 
                    0.8794405514273502 $CellContext`wavelength$^3; \
$CellContext`index1$ = $CellContext`index$; 
                    If[Abs[$CellContext`index2$ - $CellContext`index1$] < 
                    0.01, $CellContext`alternateindex$ = 
                    1.5392664079781753` - 
                    0.7232199521975703 $CellContext`wavelength$ + 
                    1.0984449372238456` $CellContext`wavelength$^2 - 
                    0.5792106404991648 $CellContext`wavelength$^3; 
                    If[Abs[$CellContext`alternateindex$ - \
$CellContext`index1$] > 
                    Abs[$CellContext`index2$ - $CellContext`index1$], \
$CellContext`index1$ = $CellContext`index2$; $CellContext`index2$ = \
$CellContext`alternateindex$, $CellContext`index1$ = \
$CellContext`alternateindex$], $CellContext`index1$ = 
                    1.5392664079781753` - 
                    0.7232199521975703 $CellContext`wavelength$ + 
                    1.0984449372238456` $CellContext`wavelength$^2 - 
                    0.5792106404991648 $CellContext`wavelength$^3], \
$CellContext`index2$ = 1.5392664079781753` - 
                    0.7232199521975703 $CellContext`wavelength$ + 
                    1.0984449372238456` $CellContext`wavelength$^2 - 
                    0.5792106404991648 $CellContext`wavelength$^3; \
$CellContext`index1$ = $CellContext`index$; 
                    If[Abs[$CellContext`index2$ - $CellContext`index1$] < 
                    0.01, $CellContext`alternateindex$ = 
                    1.5532682085807892` - 
                    1.0054245500487249` $CellContext`wavelength$ + 
                    1.6027810806758462` $CellContext`wavelength$^2 - 
                    0.8794405514273502 $CellContext`wavelength$^3; 
                    If[Abs[$CellContext`alternateindex$ - \
$CellContext`index1$] > 
                    Abs[$CellContext`index2$ - $CellContext`index1$], \
$CellContext`index1$ = $CellContext`index2$; $CellContext`index2$ = \
$CellContext`alternateindex$, $CellContext`index1$ = \
$CellContext`alternateindex$], $CellContext`index1$ = 
                    1.5532682085807892` - 
                    1.0054245500487249` $CellContext`wavelength$ + 
                    1.6027810806758462` $CellContext`wavelength$^2 - 
                    0.8794405514273502 $CellContext`wavelength$^3]]; \
$CellContext`n12$ = $CellContext`index1$/$CellContext`index2$; \
$CellContext`index$ = $CellContext`index2$; 
                    If[1 - $CellContext`n12$^2 $CellContext`raytiltx$^2 >= 
                    0., $CellContext`dummyvector$ = $CellContext`n12$ \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$} + $CellContext`ZAxis$ \
(-($CellContext`n12$ $CellContext`raytiltz$) + 
                    Sqrt[1 - $CellContext`n12$^2 $CellContext`raytiltx$^2]); \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$} = \
$CellContext`dummyvector$; 1., 
                    If[Dot[{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, 
                    Part[$CellContext`surfnorm$, 1]] > 
                    0, $CellContext`phaseshift$ = $CellContext`phaseshift$ + 
                    0.5, 1.]; $CellContext`index2$ = $CellContext`index1$; \
$CellContext`index$ = $CellContext`index1$; $CellContext`dummyvector$ = \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$} - 
                    2 $CellContext`ZAxis$ 
                    Dot[$CellContext`ZAxis$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]; {$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$} = $CellContext`dummyvector$; $CellContext`dummyvector$ = \
{$CellContext`pol1$, $CellContext`pol2$, $CellContext`pol3$} + {0, 
                    0, -180}; {$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = $CellContext`dummyvector$; 
                    1.]; $CellContext`allcreatedrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; $CellContext`originalrotation$ = Partition[
                    Take[$CellContext`originalray$, {7, 15}], 
                    3]; $CellContext`previoustilt$ = 
                    Part[$CellContext`originalrotation$, 
                    1]; $CellContext`transmatrix$ = 
                    MapIndexed[({$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; $CellContext`rotationaxis$ = 
                    Cross[$CellContext`previoustilt$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]; $CellContext`axismagnitude$ = Sqrt[
                    
                    Dot[$CellContext`rotationaxis$, \
$CellContext`rotationaxis$]]; 
                    If[Chop[$CellContext`axismagnitude$] != 
                    0., $CellContext`rotationaxis$ = \
$CellContext`rotationaxis$/$CellContext`axismagnitude$; \
$CellContext`axismatrix$ = 
                    Map[# $CellContext`rotationaxis$& , \
$CellContext`rotationaxis$]; $CellContext`crossmatrix$ = {{
                    0., -Part[$CellContext`rotationaxis$, 3], 
                    Part[$CellContext`rotationaxis$, 2]}, {
                    Part[$CellContext`rotationaxis$, 3], 0., -
                    Part[$CellContext`rotationaxis$, 1]}, {-
                    Part[$CellContext`rotationaxis$, 2], 
                    Part[$CellContext`rotationaxis$, 1], 
                    0.}}; $CellContext`cosangle$ = 
                    Dot[$CellContext`previoustilt$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]; 
                    If[1. - $CellContext`cosangle$ < 
                    2.220446049250313*^-16, $CellContext`cosangle$ = 
                    1.]; $CellContext`sinangle$ = 
                    1 - $CellContext`cosangle$^2; 
                    If[$CellContext`sinangle$ < 
                    2.220446049250313*^-16, $CellContext`sinangle$ = 
                    0., $CellContext`sinangle$ = 
                    Sqrt[$CellContext`sinangle$]]; $CellContext`axismatrix$ + \
({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
                    1.}} - $CellContext`axismatrix$) $CellContext`cosangle$ + \
$CellContext`crossmatrix$ $CellContext`sinangle$, {{$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}, {$CellContext`r4$, $CellContext`r5$, \
$CellContext`r6$}, {$CellContext`r7$, $CellContext`r8$, $CellContext`r9$}} = 
                    If[Sign[
                    
                    Dot[$CellContext`previoustilt$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]] === 1, {{1., 0., 0.}, {0., 1., 0.}, {0.,
                     0., 1.}}, {{-1., 0., 0.}, {0., -1., 0.}, {0., 
                    0., -1.}}]])& , $CellContext`allcreatedrays$]; \
$CellContext`allcreatedrays$ = 
                    MapIndexed[({$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; {{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, {$CellContext`r4$, $CellContext`r5$, $CellContext`r6$}, \
{$CellContext`r7$, $CellContext`r8$, $CellContext`r9$}} = 
                    Function[$CellContext`mm$, 
                    Map[
                    Dot[$CellContext`mm$, #]& , \
$CellContext`originalrotation$]][
                    Part[$CellContext`transmatrix$, 
                    First[#2]]]; $CellContext`tiltmagnitude$ = 
                    Dot[{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, {$CellContext`r1$, $CellContext`r2$, $CellContext`r3$}]; 
                    If[Abs[$CellContext`tiltmagnitude$ - 1.] > 
                    1.*^-6, $CellContext`dummyvector$ = {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}/
                    Sqrt[$CellContext`tiltmagnitude$]; {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$} = $CellContext`dummyvector$; \
$CellContext`dummymatrix$ = Map[#/Sqrt[
                    
                    Dot[#, #]]& , {{$CellContext`r1$, $CellContext`r2$, \
$CellContext`r3$}, {$CellContext`r4$, $CellContext`r5$, $CellContext`r6$}, \
{$CellContext`r7$, $CellContext`r8$, $CellContext`r9$}}]; {{$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}, {$CellContext`r4$, $CellContext`r5$, \
$CellContext`r6$}, {$CellContext`r7$, $CellContext`r8$, $CellContext`r9$}} = \
$CellContext`dummymatrix$; 1., 1.]; 
                    If[$CellContext`allcreatedamplitudes$ != {{
                    I 0., I 0., I 0.}}, $CellContext`amplitude$ = 
                    Part[$CellContext`allcreatedamplitudes$, 
                    First[#2]]; $CellContext`hor$ = 
                    Dot[{$CellContext`r4$, $CellContext`r5$, \
$CellContext`r6$}, $CellContext`amplitude$]; $CellContext`ver$ = 
                    Dot[{$CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$}, $CellContext`amplitude$]; If[
                    Or[
                    Abs[$CellContext`hor$] > 0., Abs[$CellContext`ver$] > 
                    0.], {$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = {
                    Abs[$CellContext`hor$], 
                    Abs[$CellContext`ver$], 
                    0.}; $CellContext`dummyvector$ = {$CellContext`pol1$, \
$CellContext`pol2$, $CellContext`pol3$}/Sqrt[
                    
                    Dot[{$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}, {$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}]]; {$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = $CellContext`dummyvector$; $CellContext`dummyvector$ = 
                    ReplacePart[{$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}, (If[$CellContext`ver$ == 0., 0., 
                    Arg[$CellContext`ver$]] - 
                    If[$CellContext`hor$ == 0., 0., 
                    Arg[$CellContext`hor$]])/Degree, 
                    3]; {$CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = $CellContext`dummyvector$]; 1., 
                    1.]; {$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$})& , $CellContext`allcreatedrays$])); {
                    
                    First[$CellContext`allcreatedrays$], \
$CellContext`completedray$}, $CellContext`reporteddummyrayspresent$ = 
                    True; {{$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}, CompressedData["
1:eJxTTMoPSmVkYGBQZ4CBD/YDRzdEmOSfPUicerh79+Og6eZuAGaoMiY=
                   
                     "]}], $CellContext`reporteddummyrayspresent$ = 
                   True; $CellContext`deflecteddummyrayspresent$ = 
                   True; CompressedData["
1:eJxTTMoPSmViYGAAYXUGGPhgP3B0Q4RJ/tmDxKmHu3c/DnoA/UFvemiGGwCy
wWJ9
                   "]])& , $CellContext`propagatedrays$]]; If[
              
              And[$CellContext`deflectedrayspresent$, \
$CellContext`deflecteddummyrayspresent$], $CellContext`deflectedlocalrays$ = 
               Select[$CellContext`deflectedlocalrays$, Part[#, 23] > 0.& ]; 
              1., 1.]; If[
              
              And[$CellContext`reportedrayspresent$, \
$CellContext`reporteddummyrayspresent$], $CellContext`reportedlocalrays$ = 
               Select[$CellContext`reportedlocalrays$, Part[#, 23] > 0.& ]; 
              1., 1.]); (
            If[$CellContext`reportedrayspresent$, $CellContext`reportedrays$ = 
               Join[$CellContext`reportedrays$, CompressedData["
1:eJxTTMoPSmViYGBgBGJ1BhBoiDDJP3twlCaNBgAGqngz
                 
                 "], $CellContext`reportedlocalrays$]; 1., 
              1.]; $CellContext`propagatedrays$ = \
$CellContext`deflectedlocalrays$); $CellContext`raysreported$ = \
$CellContext`reportedrayspresent$; 1.); (
           AddTo[$CellContext`generationnumber$, 
             1.]; $CellContext`reportedlocalrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, 
               0, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; $CellContext`deflectedlocalrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; ($CellContext`deflectedrayspresent$ = 
             False; $CellContext`reportedrayspresent$ = 
             False; $CellContext`deflecteddummyrayspresent$ = 
             False; $CellContext`reporteddummyrayspresent$ = 
             False; {$CellContext`deflectedlocalrays$, \
$CellContext`reportedlocalrays$} = Transpose[
               
               Map[(({$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; $CellContext`index1$ = $CellContext`index$; \
$CellContext`xunit$ = $CellContext`r1$; $CellContext`yunit$ = \
$CellContext`r2$; $CellContext`zunit$ = $CellContext`r3$; $CellContext`xunit$ = 
                  Chop[$CellContext`xunit$]; $CellContext`yunit$ = 
                  Chop[$CellContext`yunit$]; $CellContext`zunit$ = 
                  Chop[$CellContext`zunit$]; $CellContext`magnitude$ = \
($CellContext`xunit$^2 + $CellContext`yunit$^2 + $CellContext`zunit$^2)^(
                    2^(-1)); $CellContext`xunit$ = \
$CellContext`xunit$/$CellContext`magnitude$; $CellContext`yunit$ = \
$CellContext`yunit$/$CellContext`magnitude$; $CellContext`zunit$ = \
$CellContext`zunit$/$CellContext`magnitude$; $CellContext`rx$ = 
                  0.05 + $CellContext`rex$; $CellContext`ry$ = \
$CellContext`rey$; $CellContext`rz$ = $CellContext`rez$; $CellContext`rx$ = 
                  Chop[$CellContext`rx$]; $CellContext`ry$ = 
                  Chop[$CellContext`ry$]; $CellContext`rz$ = 
                  Chop[$CellContext`rz$]; $CellContext`terminatedeflection$ = 
                  False; $CellContext`intersections$ = {{-1., 0., 0.}}); 
                If[$CellContext`intensity$ > \
$CellContext`thresholdintensity$, $CellContext`deflectedrayspresent$ = 
                   True; ($CellContext`intersections$ = 
                    If[Chop[$CellContext`xunit$] != 0, {
                    (If[
                    And[N[
                    Chop[
                    Part[#, 1]]] >= 0., Part[#, 2]^2 + Part[#, 3]^2 <= 6.25], {
                    Part[#, 1], 
                    Part[#, 2], 
                    Part[#, 3]}, {-1., 0., 
                    0.}]& )[{-($CellContext`rx$/$CellContext`xunit$), \
$CellContext`ry$ - ($CellContext`rx$ \
$CellContext`yunit$)/$CellContext`xunit$, $CellContext`rz$ - \
($CellContext`rx$ $CellContext`zunit$)/$CellContext`xunit$}]}, {{-1., 0., 
                    0.}}]; AppendTo[$CellContext`intersections$, {-1., 0., 
                    0.}]; $CellContext`holeQ$ = False; If[
                    Or[
                    Not[
                    Or[Chop[$CellContext`surfaceid$ - 100989.] == 0., N[
                    Chop[$CellContext`ray1$]] < 
                    0.0001]], $CellContext`generationnumber$ == 
                    1.], $CellContext`minresonateraylength$ = 
                    0., $CellContext`minresonateraylength$ = 0.0001]; 
                   Block[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, $CellContext`LocRayL$ = 1.; $CellContext`LocSCx$ = 
                    1.; $CellContext`LocSCy$ = 1.; $CellContext`dummymatrix$ = 
                    Union[
                    
                    Select[$CellContext`intersections$, \
({$CellContext`LocRayL$, $CellContext`LocSCx$, $CellContext`LocSCy$} = #; 
                    Or[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$} == {-1., 0., 0.}, N[
                    
                    Chop[$CellContext`LocRayL$]] >= \
$CellContext`minresonateraylength$])& ]]; $CellContext`intersections$ = \
$CellContext`dummymatrix$]; $CellContext`unfilteredintersections$ = \
$CellContext`intersections$; 
                   If[Length[$CellContext`intersections$] > 
                    1, $CellContext`dummymatrix$ = 
                    Take[$CellContext`intersections$, {
                    2}]; $CellContext`intersections$ = \
$CellContext`dummymatrix$; 1., 1.]); 
                  If[$CellContext`intersections$ != {{-1., 0., 
                    0.}}, $CellContext`intersectionspresent$ = 
                    True; ({$CellContext`newcomponentnumber$, \
$CellContext`newsurfacenumber$, $CellContext`newsurfaceid$} = {1., 3., 
                    100989.}; {$CellContext`componentnumber$, \
$CellContext`surfacenumber$, $CellContext`surfaceid$} = {1., 3., 
                    100989.}; {$CellContext`ray1$, $CellContext`ray2$, \
$CellContext`ray3$} = Part[$CellContext`intersections$, 
                    1]; $CellContext`rsx$ = $CellContext`rex$; \
$CellContext`rsy$ = $CellContext`rey$; $CellContext`rsz$ = $CellContext`rez$; \
$CellContext`rxhlp$ = $CellContext`rx$ + $CellContext`ray1$ \
$CellContext`xunit$; $CellContext`ryhlp$ = $CellContext`ry$ + \
$CellContext`ray1$ $CellContext`yunit$; $CellContext`rzhlp$ = \
$CellContext`rz$ + $CellContext`ray1$ $CellContext`zunit$; $CellContext`rex$ = \
-0.05 + $CellContext`rxhlp$; $CellContext`rey$ = $CellContext`ryhlp$; \
$CellContext`rez$ = $CellContext`rzhlp$; $CellContext`rex$ = 
                    Chop[$CellContext`rex$]; $CellContext`rey$ = 
                    Chop[$CellContext`rey$]; $CellContext`rez$ = 
                    
                    Chop[$CellContext`rez$]; $CellContext`intersectionnumber$ = \
$CellContext`intersectionnumber$ + 
                    1.; $CellContext`opticallength$ = \
$CellContext`opticallength$ + $CellContext`ray1$ $CellContext`index1$; \
$CellContext`completedray$ = {$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}); ($CellContext`reportedrayspresent$ = 
                    True; ($CellContext`surfnorm$ = 
                    1. Re[{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
                    1.}}]; $CellContext`dummymatrix$ = 
                    Map[#& , $CellContext`surfnorm$]; $CellContext`surfnorm$ = 
                    Map[#/Sqrt[
                    
                    Dot[#, #]]& , $CellContext`dummymatrix$]; \
$CellContext`surfacerotationmatrix$ = {{1., 0, 0}, {0, 1., 0}, {
                    0, 0, 1.}}; $CellContext`surfacetranslationvector$ = \
{-0.05, 0, 0}; $CellContext`activeregion$ = 
                    0.; $CellContext`completedray$ = {$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}; $CellContext`componentnumber$ = \
$CellContext`newcomponentnumber$; $CellContext`surfacenumber$ = \
$CellContext`newsurfacenumber$; $CellContext`surfaceid$ = \
$CellContext`newsurfaceid$; $CellContext`originalray$ = {$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}; $CellContext`allcreatedrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}})); {
                    
                    First[$CellContext`allcreatedrays$], \
$CellContext`completedray$}, $CellContext`reporteddummyrayspresent$ = 
                    True; {{$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}, CompressedData["
1:eJxTTMoPSmVkYGBQZ4CBD/YDRzdEmOSfPUicerh79+Og6eZuAGaoMiY=
                   
                     "]}], $CellContext`reporteddummyrayspresent$ = 
                   True; $CellContext`deflecteddummyrayspresent$ = 
                   True; CompressedData["
1:eJxTTMoPSmViYGAAYXUGGPhgP3B0Q4RJ/tmDxKmHu3c/DnoA/UFvemiGGwCy
wWJ9
                   "]])& , $CellContext`propagatedrays$]]; If[
              
              And[$CellContext`deflectedrayspresent$, \
$CellContext`deflecteddummyrayspresent$], $CellContext`deflectedlocalrays$ = 
               Select[$CellContext`deflectedlocalrays$, Part[#, 23] > 0.& ]; 
              1., 1.]; If[
              
              And[$CellContext`reportedrayspresent$, \
$CellContext`reporteddummyrayspresent$], $CellContext`reportedlocalrays$ = 
               Select[$CellContext`reportedlocalrays$, Part[#, 23] > 0.& ]; 
              1., 1.]); (
            If[$CellContext`reportedrayspresent$, $CellContext`reportedrays$ = 
               Join[$CellContext`reportedrays$, CompressedData["
1:eJxTTMoPSmViYGBgBGJ1BhBoiDDJP3twlCaNBgAGqngz
                 
                 "], $CellContext`reportedlocalrays$]; 1., 
              1.]; $CellContext`propagatedrays$ = \
$CellContext`deflectedlocalrays$); $CellContext`raysreported$ = \
$CellContext`reportedrayspresent$; 1.); (
           AddTo[$CellContext`generationnumber$, 
             1.]; $CellContext`reportedlocalrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, 
               0, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; $CellContext`deflectedlocalrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; ($CellContext`deflectedrayspresent$ = 
             False; $CellContext`reportedrayspresent$ = 
             False; $CellContext`deflecteddummyrayspresent$ = 
             False; $CellContext`reporteddummyrayspresent$ = 
             False; {$CellContext`deflectedlocalrays$, \
$CellContext`reportedlocalrays$} = Transpose[
               
               Map[(({$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; $CellContext`index1$ = $CellContext`index$; \
$CellContext`xunit$ = $CellContext`r1$; $CellContext`yunit$ = \
$CellContext`r2$; $CellContext`zunit$ = $CellContext`r3$; $CellContext`xunit$ = 
                  Chop[$CellContext`xunit$]; $CellContext`yunit$ = 
                  Chop[$CellContext`yunit$]; $CellContext`zunit$ = 
                  Chop[$CellContext`zunit$]; $CellContext`magnitude$ = \
($CellContext`xunit$^2 + $CellContext`yunit$^2 + $CellContext`zunit$^2)^(
                    2^(-1)); $CellContext`xunit$ = \
$CellContext`xunit$/$CellContext`magnitude$; $CellContext`yunit$ = \
$CellContext`yunit$/$CellContext`magnitude$; $CellContext`zunit$ = \
$CellContext`zunit$/$CellContext`magnitude$; $CellContext`rx$ = 
                  0.05 + $CellContext`rex$; $CellContext`ry$ = \
$CellContext`rey$; $CellContext`rz$ = $CellContext`rez$; $CellContext`rx$ = 
                  Chop[$CellContext`rx$]; $CellContext`ry$ = 
                  Chop[$CellContext`ry$]; $CellContext`rz$ = 
                  Chop[$CellContext`rz$]; $CellContext`terminatedeflection$ = 
                  False; $CellContext`intersections$ = {{-1., 0., 0.}}); 
                If[$CellContext`intensity$ > \
$CellContext`thresholdintensity$, $CellContext`deflectedrayspresent$ = 
                   True; ($CellContext`intersections$ = 
                    If[Chop[$CellContext`xunit$] != 0, {
                    (If[
                    And[N[
                    Chop[
                    Part[#, 1]]] >= 0., Part[#, 2]^2 + Part[#, 3]^2 <= 25.], {
                    
                    Part[#, 1], 
                    Part[#, 2], 
                    Part[#, 3]}, {-1., 0., 
                    0.}]& )[{-($CellContext`rx$/$CellContext`xunit$), \
$CellContext`ry$ - ($CellContext`rx$ \
$CellContext`yunit$)/$CellContext`xunit$, $CellContext`rz$ - \
($CellContext`rx$ $CellContext`zunit$)/$CellContext`xunit$}]}, {{-1., 0., 
                    0.}}]; AppendTo[$CellContext`intersections$, {-1., 0., 
                    0.}]; $CellContext`holeQ$ = False; If[
                    Or[
                    Not[
                    Or[Chop[$CellContext`surfaceid$ - 100990.] == 0., N[
                    Chop[$CellContext`ray1$]] < 
                    0.0001]], $CellContext`generationnumber$ == 
                    1.], $CellContext`minresonateraylength$ = 
                    0., $CellContext`minresonateraylength$ = 0.0001]; 
                   Block[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, $CellContext`LocRayL$ = 1.; $CellContext`LocSCx$ = 
                    1.; $CellContext`LocSCy$ = 1.; $CellContext`dummymatrix$ = 
                    Union[
                    
                    Select[$CellContext`intersections$, \
({$CellContext`LocRayL$, $CellContext`LocSCx$, $CellContext`LocSCy$} = #; 
                    Or[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$} == {-1., 0., 0.}, N[
                    
                    Chop[$CellContext`LocRayL$]] >= \
$CellContext`minresonateraylength$])& ]]; $CellContext`intersections$ = \
$CellContext`dummymatrix$]; $CellContext`unfilteredintersections$ = \
$CellContext`intersections$; 
                   If[Length[$CellContext`intersections$] > 
                    1, $CellContext`dummymatrix$ = 
                    Take[$CellContext`intersections$, {
                    2}]; $CellContext`intersections$ = \
$CellContext`dummymatrix$; 1., 1.]; $CellContext`intersections$ = Union[
                    Map[
                    If[Part[#, 2]^2 + Part[#, 3]^2 <= 
                    6.25, $CellContext`holeQ$ = True; {-1., 0., 
                    0.}, #]& , $CellContext`unfilteredintersections$]]; 
                   If[Length[$CellContext`intersections$] > 
                    1, $CellContext`dummymatrix$ = 
                    Take[$CellContext`intersections$, {
                    2}]; $CellContext`intersections$ = \
$CellContext`dummymatrix$; 1., 1.]); 
                  If[$CellContext`intersections$ != {{-1., 0., 
                    0.}}, $CellContext`intersectionspresent$ = 
                    True; ({$CellContext`newcomponentnumber$, \
$CellContext`newsurfacenumber$, $CellContext`newsurfaceid$} = {1., 4., 
                    100990.}; {$CellContext`componentnumber$, \
$CellContext`surfacenumber$, $CellContext`surfaceid$} = {1., 4., 
                    100990.}; {$CellContext`ray1$, $CellContext`ray2$, \
$CellContext`ray3$} = Part[$CellContext`intersections$, 
                    1]; $CellContext`rsx$ = $CellContext`rex$; \
$CellContext`rsy$ = $CellContext`rey$; $CellContext`rsz$ = $CellContext`rez$; \
$CellContext`rxhlp$ = $CellContext`rx$ + $CellContext`ray1$ \
$CellContext`xunit$; $CellContext`ryhlp$ = $CellContext`ry$ + \
$CellContext`ray1$ $CellContext`yunit$; $CellContext`rzhlp$ = \
$CellContext`rz$ + $CellContext`ray1$ $CellContext`zunit$; $CellContext`rex$ = \
-0.05 + $CellContext`rxhlp$; $CellContext`rey$ = $CellContext`ryhlp$; \
$CellContext`rez$ = $CellContext`rzhlp$; $CellContext`rex$ = 
                    Chop[$CellContext`rex$]; $CellContext`rey$ = 
                    Chop[$CellContext`rey$]; $CellContext`rez$ = 
                    Chop[$CellContext`rez$]; $CellContext`intersectionnumber$ = \
$CellContext`intersectionnumber$ + 
                    1.; $CellContext`opticallength$ = \
$CellContext`opticallength$ + $CellContext`ray1$ $CellContext`index1$; \
$CellContext`completedray$ = {$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}); ($CellContext`reportedrayspresent$ = 
                    True; ($CellContext`surfnorm$ = 
                    1. Re[{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
                    1.}}]; $CellContext`dummymatrix$ = 
                    Map[#& , $CellContext`surfnorm$]; $CellContext`surfnorm$ = 
                    Map[#/Sqrt[
                    
                    Dot[#, #]]& , $CellContext`dummymatrix$]; \
$CellContext`surfacerotationmatrix$ = {{1., 0, 0}, {0, 1., 0}, {
                    0, 0, 
                    1.}}; $CellContext`surfacetranslationvector$ = {-0.05, 0, 
                    0}; $CellContext`activeregion$ = 
                    0.; $CellContext`completedray$ = {$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}; $CellContext`componentnumber$ = \
$CellContext`newcomponentnumber$; $CellContext`surfacenumber$ = \
$CellContext`newsurfacenumber$; $CellContext`surfaceid$ = \
$CellContext`newsurfaceid$; $CellContext`originalray$ = {$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}; $CellContext`intensity$ = 
                    0.; $CellContext`allcreatedrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}})); {
                    
                    First[$CellContext`allcreatedrays$], \
$CellContext`completedray$}, $CellContext`reporteddummyrayspresent$ = 
                    True; {{$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}, CompressedData["
1:eJxTTMoPSmVkYGBQZ4CBD/YDRzdEmOSfPUicerh79+Og6eZuAGaoMiY=
                   
                     "]}], $CellContext`reporteddummyrayspresent$ = 
                   True; $CellContext`deflecteddummyrayspresent$ = 
                   True; CompressedData["
1:eJxTTMoPSmViYGAAYXUGGPhgP3B0Q4RJ/tmDxKmHu3c/DnoA/UFvemiGGwCy
wWJ9
                   "]])& , $CellContext`propagatedrays$]]; If[
              
              And[$CellContext`deflectedrayspresent$, \
$CellContext`deflecteddummyrayspresent$], $CellContext`deflectedlocalrays$ = 
               Select[$CellContext`deflectedlocalrays$, Part[#, 23] > 0.& ]; 
              1., 1.]; If[
              
              And[$CellContext`reportedrayspresent$, \
$CellContext`reporteddummyrayspresent$], $CellContext`reportedlocalrays$ = 
               Select[$CellContext`reportedlocalrays$, Part[#, 23] > 0.& ]; 
              1., 1.]); (
            If[$CellContext`reportedrayspresent$, $CellContext`reportedrays$ = 
               Join[$CellContext`reportedrays$, CompressedData["
1:eJxTTMoPSmViYGBgBGJ1BhBoiDDJP3twlCaNBgAGqngz
                 
                 "], $CellContext`reportedlocalrays$]; 1., 
              1.]; $CellContext`propagatedrays$ = \
$CellContext`deflectedlocalrays$); $CellContext`raysreported$ = \
$CellContext`reportedrayspresent$; 1.); (
           AddTo[$CellContext`generationnumber$, 
             1.]; $CellContext`reportedlocalrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, 
               0, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; $CellContext`deflectedlocalrays$ = {{$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}}; ($CellContext`deflectedrayspresent$ = 
             False; $CellContext`reportedrayspresent$ = 
             False; $CellContext`deflecteddummyrayspresent$ = 
             False; $CellContext`reporteddummyrayspresent$ = 
             False; {$CellContext`deflectedlocalrays$, \
$CellContext`reportedlocalrays$} = Transpose[
               
               Map[(({$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`oldgenerationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$} = #; $CellContext`index1$ = $CellContext`index$; \
$CellContext`xunit$ = $CellContext`r1$; $CellContext`yunit$ = \
$CellContext`r2$; $CellContext`zunit$ = $CellContext`r3$; $CellContext`xunit$ = 
                  Chop[$CellContext`xunit$]; $CellContext`yunit$ = 
                  Chop[$CellContext`yunit$]; $CellContext`zunit$ = 
                  Chop[$CellContext`zunit$]; $CellContext`magnitude$ = \
($CellContext`xunit$^2 + $CellContext`yunit$^2 + $CellContext`zunit$^2)^(
                    2^(-1)); $CellContext`xunit$ = \
$CellContext`xunit$/$CellContext`magnitude$; $CellContext`yunit$ = \
$CellContext`yunit$/$CellContext`magnitude$; $CellContext`zunit$ = \
$CellContext`zunit$/$CellContext`magnitude$; $CellContext`rx$ = \
$CellContext`rex$; $CellContext`ry$ = $CellContext`rey$; $CellContext`rz$ = \
$CellContext`rez$; $CellContext`rx$ = 
                  Chop[$CellContext`rx$]; $CellContext`ry$ = 
                  Chop[$CellContext`ry$]; $CellContext`rz$ = 
                  Chop[$CellContext`rz$]; $CellContext`terminatedeflection$ = 
                  False; $CellContext`intersections$ = {{-1., 0., 0.}}); 
                If[$CellContext`intensity$ > \
$CellContext`thresholdintensity$, $CellContext`deflectedrayspresent$ = 
                   True; ($CellContext`intersections$ = 
                    Block[{$CellContext`surfaceapprox, \
$CellContext`tempapprox, $CellContext`intersects, $CellContext`LocRayL$, \
$CellContext`LocSCx$, $CellContext`LocSCy$}, $CellContext`LocRayL$ = 
                    1.; $CellContext`LocSCx$ = 1.; $CellContext`LocSCy$ = 
                    1.; $CellContext`surfaceapprox = {{-1., 0., 
                    0.}}; $CellContext`tempapprox = {{-1., 0., 
                    0.}}; $CellContext`intersects = {{-1., 0., 
                    0.}}; $CellContext`surfaceapprox = 
                    Block[{$CellContext`TempVar, $CellContext`TempVar1, \
$CellContext`TempVar2, $CellContext`TempVar3, $CellContext`LocRayL$, \
$CellContext`LocSCx$, $CellContext`LocSCy$}, $CellContext`TempVar1 = 
                    1.; $CellContext`TempVar2 = 1.; $CellContext`TempVar3 = 
                    1.; $CellContext`TempVar = {{-1., 0., 
                    0.}}; $CellContext`LocRayL$ = 1.; $CellContext`LocSCx$ = 
                    1.; $CellContext`LocSCy$ = 
                    1.; $CellContext`TempVar1 = $CellContext`rx$^2 + \
$CellContext`ry$^2 + $CellContext`rz$^2; $CellContext`TempVar2 = \
$CellContext`rx$ $CellContext`xunit$ + $CellContext`ry$ $CellContext`yunit$ + \
$CellContext`rz$ $CellContext`zunit$ - 
                    10.2 $CellContext`xunit$; $CellContext`TempVar3 = \
-$CellContext`TempVar1 + $CellContext`TempVar2^2 + 
                    2 $CellContext`rx$ 10.2; $CellContext`TempVar3 = 
                    Re[$CellContext`TempVar3]; If[N[
                    Chop[$CellContext`TempVar3]] >= 
                    0., $CellContext`TempVar3 = 
                    Sqrt[$CellContext`TempVar3]; $CellContext`TempVar = \
{{$CellContext`LocRayL$, $CellContext`LocSCx$, $CellContext`LocSCy$} = \
{-$CellContext`TempVar2 - $CellContext`TempVar3, $CellContext`ry$ - \
($CellContext`TempVar2 + $CellContext`TempVar3) $CellContext`yunit$, \
$CellContext`rz$ - ($CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`zunit$}; If[
                    And[N[
                    Chop[$CellContext`LocRayL$]] >= 
                    0., $CellContext`LocSCx$^2 + $CellContext`LocSCy$^2 <= 
                    31.922500000000003`, 
                    Abs[$CellContext`ry$ + $CellContext`LocRayL$ \
$CellContext`yunit$ - $CellContext`LocSCx$] + 
                    Abs[$CellContext`rz$ + $CellContext`LocRayL$ \
$CellContext`zunit$ - $CellContext`LocSCy$] + 
                    Abs[-10.2 + $CellContext`rx$ + $CellContext`LocRayL$ \
$CellContext`xunit$ + 
                    Sqrt[104.03999999999999` - $CellContext`LocSCx$^2 - \
$CellContext`LocSCy$^2]] < 
                    1.*^-7], {$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, {-1., 0., 
                    0.}], {$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$} = {-$CellContext`TempVar2 + $CellContext`TempVar3, \
$CellContext`ry$ + (-$CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`yunit$, $CellContext`rz$ + (-$CellContext`TempVar2 + \
$CellContext`TempVar3) $CellContext`zunit$}; If[
                    And[N[
                    Chop[$CellContext`LocRayL$]] >= 
                    0., $CellContext`LocSCx$^2 + $CellContext`LocSCy$^2 <= 
                    31.922500000000003`, 
                    Abs[$CellContext`ry$ + $CellContext`LocRayL$ \
$CellContext`yunit$ - $CellContext`LocSCx$] + 
                    Abs[$CellContext`rz$ + $CellContext`LocRayL$ \
$CellContext`zunit$ - $CellContext`LocSCy$] + 
                    Abs[-10.2 + $CellContext`rx$ + $CellContext`LocRayL$ \
$CellContext`xunit$ + 
                    Sqrt[104.03999999999999` - $CellContext`LocSCx$^2 - \
$CellContext`LocSCy$^2]] < 
                    1.*^-7], {$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, {-1., 0., 0.}]}; 
                    If[Part[$CellContext`TempVar, 1] == 
                    Part[$CellContext`TempVar, 2], {
                    
                    Part[$CellContext`TempVar, 
                    1]}, $CellContext`TempVar], {{-1., 0., 
                    0.}}]]; $CellContext`tempapprox = Union[
                    Join[
                    Map[Take[#, 3]& , $CellContext`surfaceapprox], {{-1., 0., 
                    0.}}]]; If[Length[
                    Select[$CellContext`tempapprox, Chop[
                    First[#]] <= 0& ]] != 
                    Length[$CellContext`tempapprox], \
$CellContext`surfaceapprox = Select[$CellContext`tempapprox, Chop[
                    First[#]] > 0& ], $CellContext`surfaceapprox = {{-1., 0., 
                    0.}}]; If[$CellContext`surfaceapprox != {{-1., 0., 
                    0.}}, $CellContext`intersects = {{-1., 0., 0.}}; 
                    Scan[(AppendTo[$CellContext`intersects, \
{$CellContext`LocRayL$, $CellContext`LocSCx$, $CellContext`LocSCy$} = {
                    Part[#, 1], 
                    Part[#, 2], 
                    Part[#, 3]}; If[Apply[Plus, 
                    
                    Abs[{$CellContext`rx$ + $CellContext`LocRayL$ \
$CellContext`xunit$, $CellContext`ry$ + $CellContext`LocRayL$ \
$CellContext`yunit$, $CellContext`rz$ + $CellContext`LocRayL$ \
$CellContext`zunit$} - {(
                    0.09803921568627452 ($CellContext`LocSCx$^2 + \
$CellContext`LocSCy$^2))/(1 + Sqrt[
                    1 + 0.020488273740868906` ($CellContext`LocSCx$^2 + \
$CellContext`LocSCy$^2)]), $CellContext`LocSCx$, $CellContext`LocSCy$}]] < 
                    1.*^-9, {$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, $CellContext`LocRayL$ = 0.99 $CellContext`LocRayL$; 
                    Function[{$CellContext`rx, $CellContext`ry, \
$CellContext`rz, $CellContext`xunit, $CellContext`yunit, $CellContext`zunit, \
$CellContext`startpoint}, 
                    
                    Block[{$CellContext`values, $CellContext`stepsizes, \
$CellContext`fvector, $CellContext`success, $CellContext`steps, \
$CellContext`denominator}, $CellContext`values = {
                    1.}; $CellContext`stepsizes = {
                    1.}; $CellContext`fvector = {1.}; $CellContext`success = 
                    False; $CellContext`steps = 0; $CellContext`denominator = 
                    1.; $CellContext`stepsizes = 
                    Table[1.0000000000000001`*^-7, {
                    3}]; $CellContext`values = $CellContext`startpoint; 
                    While[
                    
                    And[$CellContext`steps < 50, $CellContext`success = True; 
                    Map[If[Abs[#] > 1.*^-9, $CellContext`success = False; 1., 
                    1.]& , $CellContext`stepsizes]; 
                    Not[$CellContext`success]], $CellContext`steps = \
$CellContext`steps + 
                    1; $CellContext`fvector = {$CellContext`rx + \
$CellContext`xunit Part[$CellContext`values, 
                    1], $CellContext`ry + $CellContext`yunit 
                    Part[$CellContext`values, 
                    1], $CellContext`rz + $CellContext`zunit 
                    Part[$CellContext`values, 1]} - {(
                    0.09803921568627452 (Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2))/(1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)]), 
                    Part[$CellContext`values, 2], 
                    Part[$CellContext`values, 
                    3]}; $CellContext`denominator = $CellContext`xunit - \
$CellContext`yunit (((0.002008654288320481 
                    Part[$CellContext`values, 2] (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2))/(
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)] (1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)])^2) - (
                    0.19607843137254904` Part[$CellContext`values, 2])/(1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 
                    3]^2)])) (-1)) - $CellContext`zunit (((
                    0.002008654288320481 Part[$CellContext`values, 3] (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2))/(
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)] (1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)])^2) - (
                    0.19607843137254904` Part[$CellContext`values, 3])/(1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)])) (-1)); 
                    If[Chop[$CellContext`denominator] != 
                    0, $CellContext`denominator, $CellContext`denominator = 
                    1.]; $CellContext`stepsizes = -
                    Map[Dot[#, $CellContext`fvector]& , {{
                    1, -(((0.002008654288320481 
                    Part[$CellContext`values, 2] (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2))/(
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)] (1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + Part[$CellContext`values,
                     3]^2)])^2) - (0.19607843137254904` 
                    Part[$CellContext`values, 2])/(1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)])) (-1)), -(((
                    0.002008654288320481 Part[$CellContext`values, 3] (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2))/(
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)] (1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + Part[$CellContext`values,
                     3]^2)])^2) - (0.19607843137254904` 
                    Part[$CellContext`values, 3])/(1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 
                    3]^2)])) (-1))}, {$CellContext`yunit, -$CellContext`xunit - \
((0.002008654288320481 Part[$CellContext`values, 3] (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2))/(
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)] (1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)])^2) - (
                    0.19607843137254904` Part[$CellContext`values, 3])/(1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)])) $CellContext`zunit, ((
                    0.002008654288320481 Part[$CellContext`values, 3] (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2))/(
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)] (1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)])^2) - (
                    0.19607843137254904` Part[$CellContext`values, 3])/(1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 
                    3]^2)])) $CellContext`yunit}, {$CellContext`zunit, ((
                    0.002008654288320481 Part[$CellContext`values, 2] (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2))/(
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)] (1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)])^2) - (
                    0.19607843137254904` Part[$CellContext`values, 2])/(1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 
                    3]^2)])) $CellContext`zunit, -$CellContext`xunit - ((
                    0.002008654288320481 Part[$CellContext`values, 2] (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2))/(
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)] (1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 3]^2)])^2) - (
                    0.19607843137254904` Part[$CellContext`values, 2])/(1 + 
                    Sqrt[1 + 0.020488273740868906` (
                    Part[$CellContext`values, 2]^2 + 
                    Part[$CellContext`values, 
                    3]^2)])) $CellContext`yunit}}/$CellContext`denominator]; \
$CellContext`values = $CellContext`values + $CellContext`stepsizes]; 
                    If[$CellContext`steps >= 50, 
                    If[First[$CellContext`values] > 
                    0, $CellContext`values = -$CellContext`values; 1., 
                    1.]; $CellContext`denominator = 1., 
                    1.]; $CellContext`values]][$CellContext`rx$, \
$CellContext`ry$, $CellContext`rz$, $CellContext`xunit$, $CellContext`yunit$, \
$CellContext`zunit$, {$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}]]]; {-1., 0., 0.})& , $CellContext`surfaceapprox]; Union[
                    Re[
                    
                    Select[$CellContext`intersects, ({$CellContext`LocRayL$, \
$CellContext`LocSCx$, $CellContext`LocSCy$} = #; 
                    Or[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$} == {-1., 0., 0.}, 
                    And[Chop[
                    Im[#]] == {0, 0, 0}, N[
                    Chop[$CellContext`LocRayL$]] >= 
                    0., $CellContext`LocSCx$^2 + $CellContext`LocSCy$^2 <= 
                    31.922500000000003`, Apply[Plus, 
                    
                    Abs[{$CellContext`rx$ + $CellContext`LocRayL$ \
$CellContext`xunit$, $CellContext`ry$ + $CellContext`LocRayL$ \
$CellContext`yunit$, $CellContext`rz$ + $CellContext`LocRayL$ \
$CellContext`zunit$} - {(
                    0.09803921568627452 ($CellContext`LocSCx$^2 + \
$CellContext`LocSCy$^2))/(1 + Sqrt[1 + 
                    0.020488273740868906` ($CellContext`LocSCx$^2 + \
$CellContext`LocSCy$^2)]), $CellContext`LocSCx$, $CellContext`LocSCy$}]] < 
                    1.*^-9]])& ]]], {{-1., 0., 0.}}]]; 
                   AppendTo[$CellContext`intersections$, {-1., 0., 
                    0.}]; $CellContext`holeQ$ = False; If[
                    Or[
                    Not[
                    Or[Chop[$CellContext`surfaceid$ - 100991.] == 0., N[
                    Chop[$CellContext`ray1$]] < 
                    0.0001]], $CellContext`generationnumber$ == 
                    1.], $CellContext`minresonateraylength$ = 
                    0., $CellContext`minresonateraylength$ = 0.0001]; 
                   Block[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$}, $CellContext`LocRayL$ = 1.; $CellContext`LocSCx$ = 
                    1.; $CellContext`LocSCy$ = 1.; $CellContext`dummymatrix$ = 
                    Union[
                    
                    Select[$CellContext`intersections$, \
({$CellContext`LocRayL$, $CellContext`LocSCx$, $CellContext`LocSCy$} = #; 
                    Or[{$CellContext`LocRayL$, $CellContext`LocSCx$, \
$CellContext`LocSCy$} == {-1., 0., 0.}, N[
                    
                    Chop[$CellContext`LocRayL$]] >= \
$CellContext`minresonateraylength$])& ]]; $CellContext`intersections$ = \
$CellContext`dummymatrix$]; $CellContext`unfilteredintersections$ = \
$CellContext`intersections$; 
                   If[Length[$CellContext`intersections$] > 
                    1, $CellContext`dummymatrix$ = 
                    Take[$CellContext`intersections$, {
                    2}]; $CellContext`intersections$ = \
$CellContext`dummymatrix$; 1., 1.]); 
                  If[$CellContext`intersections$ != {{-1., 0., 
                    0.}}, $CellContext`intersectionspresent$ = 
                    True; ({$CellContext`newcomponentnumber$, \
$CellContext`newsurfacenumber$, $CellContext`newsurfaceid$} = {1., 5., 
                    100991.}; {$CellContext`componentnumber$, \
$CellContext`surfacenumber$, $CellContext`surfaceid$} = {1., 5., 
                    100991.}; {$CellContext`ray1$, $CellContext`ray2$, \
$CellContext`ray3$} = Part[$CellContext`intersections$, 
                    1]; $CellContext`rsx$ = $CellContext`rex$; \
$CellContext`rsy$ = $CellContext`rey$; $CellContext`rsz$ = $CellContext`rez$; \
$CellContext`rxhlp$ = $CellContext`rx$ + $CellContext`ray1$ \
$CellContext`xunit$; $CellContext`ryhlp$ = $CellContext`ry$ + \
$CellContext`ray1$ $CellContext`yunit$; $CellContext`rzhlp$ = \
$CellContext`rz$ + $CellContext`ray1$ $CellContext`zunit$; $CellContext`rex$ = \
$CellContext`rxhlp$; $CellContext`rey$ = $CellContext`ryhlp$; \
$CellContext`rez$ = $CellContext`rzhlp$; $CellContext`rex$ = 
                    Chop[$CellContext`rex$]; $CellContext`rey$ = 
                    Chop[$CellContext`rey$]; $CellContext`rez$ = 
                    Chop[$CellContext`rez$]; $CellContext`intersectionnumber$ = \
$CellContext`intersectionnumber$ + 
                    1.; $CellContext`opticallength$ = \
$CellContext`opticallength$ + $CellContext`ray1$ $CellContext`index1$; \
$CellContext`completedray$ = {$CellContext`rsx$, $CellContext`rsy$, \
$CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, $CellContext`rez$, \
$CellContext`r1$, $CellContext`r2$, $CellContext`r3$, $CellContext`r4$, \
$CellContext`r5$, $CellContext`r6$, $CellContext`r7$, $CellContext`r8$, \
$CellContext`r9$, $CellContext`wavelength$, $CellContext`intensity$, \
$CellContext`intensityscale$, $CellContext`ray1$, $CellContext`index$, \
$CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}); ($CellContext`reportedrayspresent$ = 
                    True; ($CellContext`surfnorm$ = 
                    1. Re[{{
                    1., (0.002008654288320481 $CellContext`ray2$^3)/(
                    Sqrt[1. + 
                    0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. + 0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) + (
                    0.002008654288320481 $CellContext`ray2$ \
$CellContext`ray3$^2)/(Sqrt[1. + 
                    0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. + 0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) - (0.19607843137254904` $CellContext`ray2$)/(1. + 
                    Sqrt[1. + 
                    0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)]), (
                    0.002008654288320481 $CellContext`ray2$^2 \
$CellContext`ray3$)/(Sqrt[1. + 
                    0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. + 0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) + (0.002008654288320481 $CellContext`ray3$^3)/(
                    Sqrt[1. + 
                    0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. + 0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) - (0.19607843137254904` $CellContext`ray3$)/(1. + 
                    Sqrt[1. + 
                    0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])}, {((-0.002008654288320481) $CellContext`ray2$ \
($CellContext`ray2$^2 + $CellContext`ray3$^2))/(
                    Sqrt[1. + 
                    0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. + 0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) + (0.19607843137254904` $CellContext`ray2$)/(1. + 
                    Sqrt[1. + 
                    0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)]), 1., 
                    0.}, {((-0.002008654288320481) $CellContext`ray3$ \
($CellContext`ray2$^2 + $CellContext`ray3$^2))/(
                    Sqrt[1. + 
                    0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)] (1. + Sqrt[
                    1. + 0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)])^2) + (0.19607843137254904` $CellContext`ray3$)/(1. + 
                    Sqrt[1. + 
                    0.020488273740868906` ($CellContext`ray2$^2 + \
$CellContext`ray3$^2)]), 0., 1.}}]; If[
                    Or[
                    Part[$CellContext`surfnorm$, 1] == {0., 0., 0.}, 
                    Part[$CellContext`surfnorm$, 2] == {0., 0., 0.}, 
                    Part[$CellContext`surfnorm$, 3] == {0., 0., 
                    0.}], $CellContext`surfnorm$ = 
                    1. Re[{{1., (
                    0.002008654288320481 (1.*^-6 + $CellContext`ray2$)^3)/(
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) + (
                    0.002008654288320481 (
                    1.*^-6 + $CellContext`ray2$) (
                    1.*^-6 + $CellContext`ray3$)^2)/(
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) - (
                    0.19607843137254904` (1.*^-6 + $CellContext`ray2$))/(1. + 
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)]), (
                    0.002008654288320481 (1.*^-6 + $CellContext`ray2$)^2 (
                    1.*^-6 + $CellContext`ray3$))/(
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) + (
                    0.002008654288320481 (1.*^-6 + $CellContext`ray3$)^3)/(
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) - (
                    0.19607843137254904` (1.*^-6 + $CellContext`ray3$))/(1. + 
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])}, \
{((-0.002008654288320481) (1.*^-6 + $CellContext`ray2$) ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2))/(
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) + (
                    0.19607843137254904` (1.*^-6 + $CellContext`ray2$))/(1. + 
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)]), 1., 
                    0.}, {((-0.002008654288320481) (
                    1.*^-6 + $CellContext`ray3$) ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2))/(
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)] (1. + 
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)])^2) + (
                    0.19607843137254904` (1.*^-6 + $CellContext`ray3$))/(1. + 
                    Sqrt[1. + 0.020488273740868906` ((
                    1.*^-6 + $CellContext`ray2$)^2 + (
                    1.*^-6 + $CellContext`ray3$)^2)]), 0., 1.}}]; 1., 
                    1.]; $CellContext`dummymatrix$ = 
                    Map[#& , $CellContext`surfnorm$]; $CellContext`surfnorm$ = 
                    Map[#/Sqrt[
                    
                    Dot[#, #]]& , $CellContext`dummymatrix$]; \
$CellContext`surfacerotationmatrix$ = {{1, 0, 0}, {0, 1, 0}, {0, 0, 
                    1}}; $CellContext`surfacetranslationvector$ = {0, 0, 
                    0}; $CellContext`activeregion$ = 
                    1.; $CellContext`completedray$ = {$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}; $CellContext`componentnumber$ = \
$CellContext`newcomponentnumber$; $CellContext`surfacenumber$ = \
$CellContext`newsurfacenumber$; $CellContext`surfaceid$ = \
$CellContext`newsurfaceid$; $CellContext`originalray$ = {$CellContext`rsx$, \
$CellContext`rsy$, $CellContext`rsz$, $CellContext`rex$, $CellContext`rey$, \
$CellContext`rez$, $CellContext`r1$, $CellContext`r2$, $CellContext`r3$, \
$CellContext`r4$, $CellContext`r5$, $CellContext`r6$, $CellContext`r7$, \
$CellContext`r8$, $CellContext`r9$, $CellContext`wavelength$, \
$CellContext`intensity$, $CellContext`intensityscale$, $CellContext`ray1$, \
$CellContext`index$, $CellContext`opticallength$, $CellContext`phaseshift$, \
$CellContext`componentnumber$, $CellContext`surfacenumber$, \
$CellContext`surfaceid$, $CellContext`ray2$, $CellContext`ray3$, \
$CellContext`sid$, $CellContext`frontid$, $CellContext`sno1$, \
$CellContext`sno2$, $CellContext`sno3$, $CellContext`sno4$, \
$CellContext`rayslot$, $CellContext`generationnumber$, \
$CellContext`intersectionnumber$, $CellContext`pol1$, $CellContext`pol2$, \
$CellContext`pol3$}; $CellContext`ZAxis$ = 
                    First[$CellContext`surfnorm$] Sign[
                    Dot[
                    
                    First[$CellContext`surfnorm$], {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]]; $CellContext`raytiltz$ = 
                    Dot[$CellContext`ZAxis$, {$CellContext`r1$, \
$CellContext`r2$, $CellContext`r3$}]; $CellContext`raytiltx$ = 
                    1 - $CellContext`raytiltz$^2; 
                    If[$CellContext`raytiltx$ < 
                    2.220446049250313*^-16, $CellContext`raytiltx$ = 
                    0., $CellContext`raytiltx$ = 
                    Sqrt[$CellContext`raytiltx$]]; $CellContext`XAxis$ = \
{$CellContext`r1$, $CellContext`r2$, $CellContext`r3$} - $CellContext`ZAxis$ \
$CellContext`raytiltz$; 
                    If[Abs[$CellContext`raytiltx$] < 
                    1.*^-7, $CellContext`XAxis$ = 
                    Part[$CellContext`surfnorm$, 
                    2], $CellContext`XAxis$ = \
$CellContext`XAxis$/$CellContext`raytiltx$]; $CellContext`YAxis$ = {-(
                    Part[$CellContext`ZAxis$, 3] 
                    Part[$CellContext`XAxis$, 2]) + 
        