(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     33213,        819]
NotebookOptionsPosition[     31883,        769]
NotebookOutlinePosition[     32539,        794]
CellTagsIndexPosition[     32496,        791]
WindowTitle->Nearsightedness and Farsightedness - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Nearsightedness and Farsightedness", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pts", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{".0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{".95", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{".05", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", ".065", "]"}], ",", "Orange", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".8", ",", ".55"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", ".63"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Thickness", "[", ".025", "]"}], ",", 
         RowBox[{"BSplineCurve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{".015", ",", ".3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{".215", ",", ".3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{".215", ",", ".7"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{".015", ",", ".7"}], "}"}]}], "}"}], ",", 
           RowBox[{"SplineClosed", "\[Rule]", "True"}]}], "]"}], ",", 
         "LightRed", ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{".5", ",", ".5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{".43", ",", ".47"}], "}"}]}], "]"}], ",", "Orange", ",", 
         RowBox[{"Thickness", "[", ".025", "]"}], ",", "Orange", ",", 
         RowBox[{"BSplineCurve", "[", 
          RowBox[{"pts", ",", 
           RowBox[{"SplineClosed", "\[Rule]", "True"}], ",", 
           RowBox[{"SplineKnots", "\[Rule]", "\"\<Unclamped\>\""}]}], "]"}], 
         ",", "LightOrange", ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{".09", ",", ".5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{".065", ",", ".175"}], "}"}]}], "]"}], ",", "LightBlue", 
         ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{".12", ",", ".5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{".04", ",", ".17"}], "}"}]}], "]"}], ",", 
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{"correct", "\[And]", 
            RowBox[{"r", ">", "0"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"Blue", ",", 
             RowBox[{"Polygon", "@", 
              RowBox[{"Join", "[", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"1.01", 
                    RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
                    "0.955336489125606", "-", ".2"}], ",", 
                    RowBox[{
                    RowBox[{"1.01", 
                    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", ".5"}]}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"\[Theta]", ",", 
                    RowBox[{"\[Pi]", "-", ".3"}], ",", 
                    RowBox[{"\[Pi]", "+", ".3"}], ",", ".01"}], "}"}]}], 
                 "]"}], ",", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"1.01", 
                    RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
                    "0.955336489125606", "-", ".2"}], ",", 
                    RowBox[{
                    RowBox[{"1.01", 
                    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", ".5"}]}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"\[Theta]", ",", 
                    RowBox[{"-", ".3"}], ",", 
                    RowBox[{"+", ".3"}], ",", ".01"}], "}"}]}], "]"}]}], 
               "]"}]}]}], "}"}], ",", 
           RowBox[{"correct", "\[And]", 
            RowBox[{"r", "<", "0"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"Blue", ",", 
             RowBox[{"Polygon", "@", 
              RowBox[{"Join", "[", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"1.01", 
                    RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
                    "0.955336489125606", "-", ".1"}], ",", 
                    RowBox[{
                    RowBox[{"1.01", 
                    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", ".5"}]}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"\[Theta]", ",", 
                    RowBox[{"\[Pi]", "-", ".3"}], ",", 
                    RowBox[{"\[Pi]", "+", ".3"}], ",", ".01"}], "}"}]}], 
                 "]"}], ",", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"1.01", 
                    RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
                    "0.955336489125606", "-", ".3"}], ",", 
                    RowBox[{
                    RowBox[{"1.01", 
                    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", ".5"}]}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"\[Theta]", ",", 
                    RowBox[{"-", ".3"}], ",", 
                    RowBox[{"+", ".3"}], ",", ".01"}], "}"}]}], "]"}]}], 
               "]"}]}]}], "}"}], ",", "True", ",", 
           RowBox[{"{", "}"}]}], "]"}], ",", "Red", ",", 
         RowBox[{"Thickness", "[", ".005", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".5"}], ",", ".5"}], "}"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{"correct", ",", 
              RowBox[{"{", 
               RowBox[{".93", ",", ".5"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"1", "+", "r"}], ",", ".5"}], "}"}]}], "]"}]}], "}"}],
           "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".12", ",", 
              RowBox[{"Which", "[", 
               RowBox[{
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", "<", "0"}]}], ",", ".65", ",", 
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", ">", "0"}]}], ",", ".62", ",", "True", ",", 
                ".635"}], "]"}]}], "}"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{"correct", ",", 
              RowBox[{"{", 
               RowBox[{".93", ",", ".5"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"1", "+", "r"}], ",", ".5"}], "}"}]}], "]"}]}], "}"}],
           "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".12", ",", 
              RowBox[{"Which", "[", 
               RowBox[{
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", "<", "0"}]}], ",", ".35", ",", 
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", ">", "0"}]}], ",", ".38", ",", "True", ",", 
                ".365"}], "]"}]}], "}"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{"correct", ",", 
              RowBox[{"{", 
               RowBox[{".93", ",", ".5"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"1", "+", "r"}], ",", ".5"}], "}"}]}], "]"}]}], "}"}],
           "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".12", ",", 
              RowBox[{"Which", "[", 
               RowBox[{
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", "<", "0"}]}], ",", ".65", ",", 
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", ">", "0"}]}], ",", ".62", ",", "True", ",", 
                ".635"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".2"}], ",", 
              RowBox[{"Which", "[", 
               RowBox[{
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", "<", "0"}]}], ",", ".62", ",", 
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", ">", "0"}]}], ",", ".65", ",", "True", ",", 
                ".635"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".5"}], ",", 
              RowBox[{"Which", "[", 
               RowBox[{
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", "<", "0"}]}], ",", ".62", ",", 
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", ">", "0"}]}], ",", ".65", ",", "True", ",", 
                ".635"}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".12", ",", 
              RowBox[{"Which", "[", 
               RowBox[{
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", "<", "0"}]}], ",", ".35", ",", 
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", ">", "0"}]}], ",", ".38", ",", "True", ",", 
                ".365"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".2"}], ",", 
              RowBox[{"Which", "[", 
               RowBox[{
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", "<", "0"}]}], ",", ".38", ",", 
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", ">", "0"}]}], ",", ".35", ",", "True", ",", 
                ".365"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".5"}], ",", 
              RowBox[{"Which", "[", 
               RowBox[{
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", "<", "0"}]}], ",", ".38", ",", 
                RowBox[{"correct", "\[And]", 
                 RowBox[{"r", ">", "0"}]}], ",", ".35", ",", "True", ",", 
                ".365"}], "]"}]}], "}"}]}], "}"}], "]"}], ",", "Black", ",", 
         RowBox[{"Point", "[", 
          RowBox[{"If", "[", 
           RowBox[{"correct", ",", 
            RowBox[{"{", 
             RowBox[{".93", ",", ".5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "+", "r"}], ",", ".5"}], "}"}]}], "]"}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".5"}], ",", "1.5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", 
       RowBox[{"-", ".5"}], ",", "\"\<image distance q\>\""}], "}"}], ",", 
     RowBox[{"-", ".5"}], ",", ".5", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"correct", ",", "correct", ",", "\"\<corrective lens\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.492962045717413*^9, 3.49296205670321*^9}, {
   3.492962120344722*^9, 3.4929621220671988`*^9}, {3.4929625094241905`*^9, 
   3.4929627010297055`*^9}, {3.4929629160589027`*^9, 3.492963320951109*^9}, {
   3.4929663650082483`*^9, 3.492966375673584*^9}, 3.492973542999693*^9, {
   3.492973688669155*^9, 3.4929737099096975`*^9}, {3.4929748581107297`*^9, 
   3.4929749466780834`*^9}, {3.4929749787742352`*^9, 
   3.4929750369679136`*^9}, {3.4929751402163773`*^9, 3.49297516896772*^9}, {
   3.4929752046089697`*^9, 3.492975207703419*^9}, {3.49297524507716*^9, 
   3.492975245317506*^9}, {3.492975340233989*^9, 3.4929753553256893`*^9}, {
   3.4929754114163437`*^9, 3.4929754191074033`*^9}, {3.492975455229344*^9, 
   3.492975517548955*^9}, {3.4929755519083614`*^9, 3.4929755591587873`*^9}, {
   3.4929757133404894`*^9, 3.4929758197134466`*^9}, {3.4929758576179504`*^9, 
   3.492975860992803*^9}, {3.4929759083909583`*^9, 3.492975944432784*^9}, {
   3.4929760043789825`*^9, 3.4929760234363856`*^9}, {3.492976056303646*^9, 
   3.492976071084901*^9}, {3.492976174083005*^9, 3.492976277361512*^9}, {
   3.4929765027956705`*^9, 3.4929765644142733`*^9}, {3.4929765987336226`*^9, 
   3.492976604311643*^9}, {3.4929774924086637`*^9, 3.49297750657904*^9}, {
   3.492977541699541*^9, 3.4929775950662785`*^9}, {3.4929776526691074`*^9, 
   3.4929777060859165`*^9}, {3.492980547581787*^9, 3.492980621838563*^9}, {
   3.4929806672138095`*^9, 3.492980739617922*^9}, {3.492980774748437*^9, 
   3.4929808002250705`*^9}, {3.4929809293207006`*^9, 
   3.4929809609662046`*^9}, {3.4929809956060143`*^9, 
   3.4929810007634306`*^9}, {3.492981059427786*^9, 3.492981124160867*^9}, {
   3.4929812647630434`*^9, 3.4929812754884653`*^9}, {3.4929841429516754`*^9, 
   3.492984146056139*^9}, {3.4929846505014963`*^9, 3.4929846605459394`*^9}, {
   3.4929846933531137`*^9, 3.4929846954961953`*^9}, {3.492985129370075*^9, 
   3.4929851784706783`*^9}, {3.4929855737690897`*^9, 3.492985595009632*^9}, {
   3.4929861608232317`*^9, 3.4929862710617476`*^9}, {3.4929863727880225`*^9, 
   3.492986381240176*^9}, 3.492987624047245*^9, 3.4929876671291933`*^9, {
   3.4929877857798047`*^9, 3.4929877885738225`*^9}, {3.492987821060536*^9, 
   3.492987824535533*^9}, {3.4929879314793105`*^9, 3.492987937307691*^9}, {
   3.492988426651333*^9, 3.492988428253637*^9}, {3.492988535838336*^9, 
   3.4929885443305473`*^9}, {3.4929887043406305`*^9, 
   3.4929887471421757`*^9}, {3.4929887800294657`*^9, 
   3.4929887869394016`*^9}, {3.493039755786496*^9, 3.4930397737723584`*^9}, {
   3.493039926051325*^9, 3.493039953861314*^9}, {3.4930402785982623`*^9, 
   3.493040286109062*^9}, {3.4930403225614786`*^9, 3.4930403568207407`*^9}, {
   3.493040528948248*^9, 3.493040552081512*^9}, {3.4930408300912704`*^9, 
   3.493040902685656*^9}, {3.4930409566732864`*^9, 3.493041028766952*^9}, {
   3.4930411032540593`*^9, 3.493041122581851*^9}, {3.4930415423554564`*^9, 
   3.493041564567395*^9}, {3.4930416637700415`*^9, 3.493041666614131*^9}, {
   3.493041710266901*^9, 3.493041737746414*^9}, {3.4930417818999043`*^9, 
   3.493041782100192*^9}, {3.4930418146469917`*^9, 3.493041817230707*^9}, {
   3.4930419139698114`*^9, 3.493041920058566*^9}, {3.4930421177428226`*^9, 
   3.493042123420987*^9}, {3.4930421789007635`*^9, 3.4930422047178864`*^9}, {
   3.493042240108776*^9, 3.493042252797021*^9}, {3.49304290407351*^9, 
   3.4930429121351023`*^9}, {3.4930504514689007`*^9, 3.493050485015913*^9}, {
   3.493492529178239*^9, 3.493492533033842*^9}, 3.4934925636626062`*^9, {
   3.493492783834209*^9, 3.493492871279574*^9}, {3.493492926002276*^9, 
   3.493492949353568*^9}, {3.4935611988122463`*^9, 3.493561202327301*^9}, 
   3.493561387012373*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`correct$$ = False, $CellContext`r$$ = -0.5, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`r$$], -0.5, "image distance q"}, -0.5, 0.5}, {{
       Hold[$CellContext`correct$$], False, "corrective lens"}, {
      False, True}}}, Typeset`size$$ = {450., {133., 137.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`r$1526$$ = 0, $CellContext`correct$1527$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`correct$$ = 
        False, $CellContext`r$$ = -0.5}, "ControllerVariables" :> {
        Hold[$CellContext`r$$, $CellContext`r$1526$$, 0], 
        Hold[$CellContext`correct$$, $CellContext`correct$1527$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`pts$ = {{0., 0}, {1, 0}, {0.95, 1}, {0.05, 1}}}, 
        Graphics[{
          Thickness[0.065], Orange, 
          Line[{{0.8, 0.55}, {1, 0.63}}], 
          Thickness[0.025], 
          
          BSplineCurve[{{0.015, 0.3}, {0.215, 0.3}, {0.215, 0.7}, {0.015, 
           0.7}}, SplineClosed -> True], LightRed, 
          Disk[{0.5, 0.5}, {0.43, 0.47}], Orange, 
          Thickness[0.025], Orange, 
          
          BSplineCurve[$CellContext`pts$, SplineClosed -> True, SplineKnots -> 
           "Unclamped"], LightOrange, 
          Disk[{0.09, 0.5}, {0.065, 0.175}], LightBlue, 
          Disk[{0.12, 0.5}, {0.04, 0.17}], 
          Which[
           And[$CellContext`correct$$, $CellContext`r$$ > 0], {Blue, 
            Polygon[
             Join[
              
              Table[{1.01 Cos[$CellContext`\[Theta]] + 0.955336489125606 - 
                0.2, 1.01 Sin[$CellContext`\[Theta]] + 
                0.5}, {$CellContext`\[Theta], Pi - 0.3, Pi + 0.3, 0.01}], 
              
              Table[{1.01 Cos[$CellContext`\[Theta]] - 0.955336489125606 - 
                0.2, 1.01 Sin[$CellContext`\[Theta]] + 
                0.5}, {$CellContext`\[Theta], -0.3, 
                Plus[0.3], 0.01}]]]}, 
           And[$CellContext`correct$$, $CellContext`r$$ < 0], {Blue, 
            Polygon[
             Join[
              
              Table[{1.01 Cos[$CellContext`\[Theta]] + 0.955336489125606 - 
                0.1, 1.01 Sin[$CellContext`\[Theta]] + 
                0.5}, {$CellContext`\[Theta], Pi - 0.3, Pi + 0.3, 0.01}], 
              
              Table[{1.01 Cos[$CellContext`\[Theta]] - 0.955336489125606 - 
                0.3, 1.01 Sin[$CellContext`\[Theta]] + 
                0.5}, {$CellContext`\[Theta], -0.3, 
                Plus[0.3], 0.01}]]]}, True, {}], Red, 
          Thickness[0.005], 
          Line[{{-0.5, 0.5}, 
            
            If[$CellContext`correct$$, {0.93, 0.5}, {
             1 + $CellContext`r$$, 0.5}]}], 
          Line[{{0.12, 
             Which[
              And[$CellContext`correct$$, $CellContext`r$$ < 0], 0.65, 
              And[$CellContext`correct$$, $CellContext`r$$ > 0], 0.62, True, 
              0.635]}, 
            
            If[$CellContext`correct$$, {0.93, 0.5}, {
             1 + $CellContext`r$$, 0.5}]}], 
          Line[{{0.12, 
             Which[
              And[$CellContext`correct$$, $CellContext`r$$ < 0], 0.35, 
              And[$CellContext`correct$$, $CellContext`r$$ > 0], 0.38, True, 
              0.365]}, 
            
            If[$CellContext`correct$$, {0.93, 0.5}, {
             1 + $CellContext`r$$, 0.5}]}], 
          Line[{{0.12, 
             Which[
              And[$CellContext`correct$$, $CellContext`r$$ < 0], 0.65, 
              And[$CellContext`correct$$, $CellContext`r$$ > 0], 0.62, True, 
              0.635]}, {-0.2, 
             Which[
              And[$CellContext`correct$$, $CellContext`r$$ < 0], 0.62, 
              And[$CellContext`correct$$, $CellContext`r$$ > 0], 0.65, True, 
              0.635]}, {-0.5, 
             Which[
              And[$CellContext`correct$$, $CellContext`r$$ < 0], 0.62, 
              And[$CellContext`correct$$, $CellContext`r$$ > 0], 0.65, True, 
              0.635]}}], 
          Line[{{0.12, 
             Which[
              And[$CellContext`correct$$, $CellContext`r$$ < 0], 0.35, 
              And[$CellContext`correct$$, $CellContext`r$$ > 0], 0.38, True, 
              0.365]}, {-0.2, 
             Which[
              And[$CellContext`correct$$, $CellContext`r$$ < 0], 0.38, 
              And[$CellContext`correct$$, $CellContext`r$$ > 0], 0.35, True, 
              0.365]}, {-0.5, 
             Which[
              And[$CellContext`correct$$, $CellContext`r$$ < 0], 0.38, 
              And[$CellContext`correct$$, $CellContext`r$$ > 0], 0.35, True, 
              0.365]}}], Black, 
          Point[
           
           If[$CellContext`correct$$, {0.93, 0.5}, {
            1 + $CellContext`r$$, 0.5}]]}, 
         PlotRange -> {{-0.5, 1.5}, {-0.1, 1.1}}, ImageSize -> 450]], 
      "Specifications" :> {{{$CellContext`r$$, -0.5, 
          "image distance q"}, -0.5, 0.5, Appearance -> 
         "Labeled"}, {{$CellContext`correct$$, False, "corrective lens"}, {
         False, True}}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{495., {186., 191.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->21521584],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "Nearsightedness and farsightedness (also known as myopia and hyperopia) are \
defects of the lens, cornea, or axial dimension of the eyeball. The image of \
an object comes to a focus in front of the retina in one case and behind the \
retina in the other, causing blurred vision of distant or nearby objects. \
This can be corrected with concave and convex lenses, respectively, by \
adjusting the image distance ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ", which spans from the lens (light blue) to the focus (black point), to be \
on the retina. "
}], "Text"]
}, Close]]
}, Open  ]],

Cell["", "Text"],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "For more details on the subject, see the Wikipedia entries ",
 ButtonBox["Myopia",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://en.wikipedia.org/wiki/Myopia"], None},
  ButtonNote->"http://en.wikipedia.org/wiki/Myopia"],
 " and ",
 ButtonBox["Hyperopia",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://en.wikipedia.org/wiki/Hyperopia"], None},
  ButtonNote->"http://en.wikipedia.org/wiki/Hyperopia"],
 "."
}], "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Nearsightedness and Farsightedness",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/NearsightednessAndFarsightedness/"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/NearsightednessAndFarsightedness/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
NearsightednessAndFarsightedness/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/NearsightednessAndFarsightedness/"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/NearsightednessAndFarsightedness/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Enrique Zeleny",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
NearsightednessAndFarsightedness"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Nearsightedness and Farsightedness - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[636, 23, 154, 3, 70, "Section"],
Cell[793, 28, 3700, 64, 70, "Section"],
Cell[4496, 94, 15832, 359, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20365, 458, 6044, 130, 70, "Output",
 CellID->21521584],
Cell[CellGroupData[{
Cell[26434, 592, 209, 6, 70, "Section"],
Cell[26646, 600, 606, 11, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[27278, 615, 16, 0, 70, "Text"],
Cell[CellGroupData[{
Cell[27319, 619, 209, 6, 70, "Section"],
Cell[27531, 627, 459, 14, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[28026, 646, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[28384, 657, 985, 29, 70, "Text"],
Cell[29372, 688, 436, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[29833, 706, 815, 24, 70, "Text"],
Cell[30651, 732, 1204, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 9RzcJ5MBwyBQHBDRB7Bw6Ltu *)
