(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    560198,      10424]
NotebookOptionsPosition[    557904,      10351]
NotebookOutlinePosition[    558578,      10376]
CellTagsIndexPosition[    558535,      10373]
WindowTitle->Motion/Pursuit Law in 2D (Visual Depth Perception 3) - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Motion/Pursuit Law in 2D (Visual Depth Perception 3)", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"nORM", "[", 
      RowBox[{"vector_", "?", "VectorQ"}], "]"}], ":=", 
     SqrtBox[
      RowBox[{"vector", ".", "vector"}]]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"degrees", "[", "q_", "]"}], ":=", 
     RowBox[{"q", "*", 
      RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"arcMinutes", "[", "q_", "]"}], ":=", 
     RowBox[{"q", "*", "60", "*", 
      RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"aim\[Psi]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"headAimVector", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"headAimVector", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"midPoint", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"base", "-", 
      RowBox[{"aimOffset", "*", "interOcular", "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"headAimVector", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightEyeCenter", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"base", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "-", "aimOffset"}], ")"}], "*", "interOcular",
        "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"headAimVector", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftEyeCenter", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"base", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "+", "aimOffset"}], ")"}], "*", "interOcular",
        "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"headAimVector", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightViewVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"fixate", "-", 
      RowBox[{"rightEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[CurlyPhi]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rightViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"rightViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightEyeNode", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"rightEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "+", 
      RowBox[{"nodePercent", "*", "eyeRadius", "*", 
       RowBox[{
        RowBox[{"rightViewVector", "[", 
         RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
        "/", 
        RowBox[{"nORM", "[", 
         RowBox[{"rightViewVector", "[", 
          RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
          "]"}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftViewVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"fixate", "-", 
      RowBox[{"leftEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[CurlyPhi]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"leftViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"leftViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftEyeNode", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"leftEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "+", 
      RowBox[{"nodePercent", "*", "eyeRadius", "*", 
       RowBox[{
        RowBox[{"leftViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "/", 
        RowBox[{"nORM", "[", 
         RowBox[{"leftViewVector", "[", 
          RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
          "]"}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"fixateConvergence", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"right\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
       RowBox[{"left\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}]}], 
      ")"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Alpha]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"left\[CurlyPhi]", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
      RowBox[{"aim\[Psi]", "[", 
       RowBox[{"headAimVector", ",", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Alpha]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"right\[CurlyPhi]", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
      RowBox[{"aim\[Psi]", "[", 
       RowBox[{"headAimVector", ",", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightDistractVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"distraction", "-", 
      RowBox[{"rightEyeNode", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Delta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rightDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"rightDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftDistractVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"distraction", "-", 
      RowBox[{"leftEyeNode", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Delta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"leftDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"leftDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"convergenceDistraction", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"left\[CurlyPhi]", "[", 
             RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
             "]"}], "-", 
            RowBox[{"left\[Delta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
              "base"}], "]"}]}], "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"right\[CurlyPhi]", "[", 
             RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
             "]"}], "-", 
            RowBox[{"right\[Delta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
              "base"}], "]"}]}], "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}]}], "]"}], ",", "0.0", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[Delta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
           "base"}], "]"}], "-", 
         RowBox[{"left\[Delta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
           "base"}], "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Theta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"right\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
       "-", 
       RowBox[{"right\[Delta]", "[", 
        RowBox[{
        "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
        "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Theta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"left\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
       "-", 
       RowBox[{"left\[Delta]", "[", 
        RowBox[{
        "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
        "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{
     RowBox[{"binocularDisparity", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2."}]}], ",", 
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "2."}]}]}], "]"}], ",", "0", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "-", 
         RowBox[{"left\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Theta]inside", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"right\[Theta]", "[", 
       RowBox[{
       "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
       "]"}], "+", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"nodePercent", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"right\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Theta]inside", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"left\[Theta]", "[", 
       RowBox[{
       "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
       "]"}], "+", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"nodePercent", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"left\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"retinalDisparity", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2."}]}], ",", 
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "2."}]}]}], "]"}], ",", "0", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[Theta]inside", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "-", 
         RowBox[{"left\[Theta]inside", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eyePict", "[", 
      RowBox[{
       RowBox[{"eyeCenter_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "viewVector"}], "}"}], ",", 
       RowBox[{
        RowBox[{"viewVector", "=", 
         RowBox[{"fixate", "-", "eyeCenter"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Lambda]", "=", 
         RowBox[{"ArcTan", "[", 
          RowBox[{
           RowBox[{"viewVector", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"viewVector", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"viewVector", "=", 
         RowBox[{"viewVector", "/", 
          RowBox[{"nORM", "[", "viewVector", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Gray", ",", 
               RowBox[{"Circle", "[", 
                RowBox[{"eyeCenter", ",", "eyeRadius", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\[Lambda]", "+", ".4"}], ",", 
                   RowBox[{
                    RowBox[{"2", "\[Pi]"}], "+", "\[Lambda]", "-", ".4"}]}], 
                  "}"}]}], "]"}]}], "}"}], "]"}], ",", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Gray", ",", "\[IndentingNewLine]", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"eyeCenter", "+", " ", 
                  RowBox[{".8", "eyeRadius", " ", "viewVector"}]}], ",", 
                 RowBox[{".5", "eyeRadius"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\[Lambda]", "-", "1.5"}], ",", 
                   RowBox[{"\[Lambda]", "+", "1.5"}]}], "}"}]}], "]"}]}], 
              "}"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Black", ",", "\[IndentingNewLine]", 
               RowBox[{"Disk", "[", 
                RowBox[{
                 RowBox[{"eyeCenter", "+", 
                  RowBox[{
                  "eyeRadius", "*", "nodePercent", "*", "viewVector"}]}], ",", 
                 RowBox[{"eyeRadius", "/", "10"}]}], "]"}]}], 
              "\[IndentingNewLine]", "}"}], "]"}]}], "\[IndentingNewLine]", 
           "}"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"movingEyePict", "[", 
      RowBox[{
       RowBox[{"eyeCenter_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "viewVector"}], "}"}], ",", 
       RowBox[{
        RowBox[{"viewVector", "=", 
         RowBox[{"fixate", "-", "eyeCenter"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Lambda]", "=", 
         RowBox[{"ArcTan", "[", 
          RowBox[{
           RowBox[{"viewVector", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"viewVector", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"viewVector", "=", 
         RowBox[{"viewVector", "/", 
          RowBox[{"nORM", "[", "viewVector", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
               RowBox[{"Dashing", "[", ".01", "]"}], ",", "Gray", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"eyeCenter", "-", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1.", "eyeRadius"}], ",", 
                    RowBox[{"1.5", "eyeRadius"}]}], "}"}]}], ",", 
                    RowBox[{"eyeCenter", "+", 
                    RowBox[{"{", " ", 
                    RowBox[{
                    RowBox[{"1.", "eyeRadius"}], ",", 
                    RowBox[{
                    RowBox[{"-", "1.5"}], "eyeRadius"}]}], "}"}]}], ",", 
                    RowBox[{"eyeCenter", "+", 
                    RowBox[{"{", " ", 
                    RowBox[{
                    RowBox[{".7", "eyeRadius"}], ",", 
                    RowBox[{
                    RowBox[{"-", "1.6"}], "eyeRadius"}]}], "}"}]}]}], "}"}], 
                  "]"}], ",", 
                 RowBox[{"Circle", "[", 
                  RowBox[{"eyeCenter", ",", "eyeRadius", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\[Lambda]", "+", ".4"}], ",", 
                    RowBox[{
                    RowBox[{"2", "\[Pi]"}], "+", "\[Lambda]", "-", ".4"}]}], 
                    "}"}]}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Gray", ",", "\[IndentingNewLine]", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"eyeCenter", "+", " ", 
                  RowBox[{".8", "eyeRadius", " ", "viewVector"}]}], ",", 
                 RowBox[{".5", "eyeRadius"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\[Lambda]", "-", "1.5"}], ",", 
                   RowBox[{"\[Lambda]", "+", "1.5"}]}], "}"}]}], "]"}]}], 
              "}"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Black", ",", "\[IndentingNewLine]", 
               RowBox[{"Disk", "[", 
                RowBox[{
                 RowBox[{"eyeCenter", "+", 
                  RowBox[{
                  "eyeRadius", "*", "nodePercent", "*", "viewVector"}]}], ",", 
                 RowBox[{"eyeRadius", "/", "10"}]}], "]"}]}], 
              "\[IndentingNewLine]", "}"}], "]"}]}], "\[IndentingNewLine]", 
           "}"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eyeEdge", "[", "\[Theta]_", "]"}], ":=", 
     RowBox[{"eyeRadius", "*", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eyeEdge", "[", "\[Theta]_", "]"}], ":=", 
     RowBox[{"eyeRadius", "*", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"inRays", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"eyePict", "[", 
          RowBox[{
           RowBox[{"leftEyeCenter", "[", 
            RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
           "fixate"}], "]"}], ",", 
         RowBox[{"eyePict", "[", 
          RowBox[{
           RowBox[{"rightEyeCenter", "[", 
            RowBox[{"headAimVector", ",", "base"}], "]"}], ",", "fixate"}], 
          "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "-", 
                 RowBox[{"eyeRadius", "*", 
                  RowBox[{
                   RowBox[{"rightViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "/", 
                   RowBox[{"nORM", "[", 
                    RowBox[{"rightViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "]"}]}]}]}]}], "}"}], "]"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "-", 
                 RowBox[{"eyeRadius", "*", 
                  RowBox[{
                   RowBox[{"leftViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "/", 
                   RowBox[{"nORM", "[", 
                    RowBox[{"leftViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "]"}]}]}]}]}], "}"}], "]"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"right\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"left\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"left\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Purple", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeCenter", "[", 
                 RowBox[{"headAimVector", ",", "base"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"right\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Purple", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeCenter", "[", 
                 RowBox[{"headAimVector", ",", "base"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"left\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"left\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Green", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}], "}"}],
                "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"min", "=", 
           RowBox[{"Min", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}], "-", 
               RowBox[{"retinalDisparity", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}]}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"MAX", "=", 
           RowBox[{"Max", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}], "-", 
               RowBox[{"retinalDisparity", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}]}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Brown", ",", 
             RowBox[{"AbsoluteThickness", "[", "3", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"Circle", "[", 
               RowBox[{
                RowBox[{"leftEyeCenter", "[", 
                 RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
                "eyeRadius", ",", 
                RowBox[{"{", 
                 RowBox[{"min", ",", "MAX"}], "}"}]}], "]"}], "}"}]}], "}"}], 
           "]"}]}]}], "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", "interOcular"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", "interOcular"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "-", "interOcular"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", "interOcular"}]}], "}"}]}],
          "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"outRays", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Point", "[", 
              RowBox[{"N", "[", "fixate", "]"}], "]"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Point", "[", 
              RowBox[{"N", "[", "distraction", "]"}], "]"}], "}"}]}], "}"}], 
          "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"fixate", ",", 
                 RowBox[{"rightEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"fixate", ",", 
                 RowBox[{"leftEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"distraction", ",", 
                 RowBox[{"rightEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"distraction", ",", 
                 RowBox[{"leftEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Beta]Ratio", "[", 
      RowBox[{"f_", ",", "d1_", ",", "d2_", ",", "t_"}], "]"}], ":=", 
     FractionBox[
      RowBox[{
       RowBox[{"f", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"d1", 
           RowBox[{"(", 
            RowBox[{"d1", "+", "f"}], ")"}]}], "+", 
          SuperscriptBox["d2", "2"], "-", 
          RowBox[{"2", "d2", " ", "i", " ", "t"}]}], ")"}]}], "-", 
       RowBox[{"d1", " ", 
        SuperscriptBox["i", "2"], " ", 
        SuperscriptBox["t", "2"]}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d1", "+", "f"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["f", "2"], "+", 
         RowBox[{
          SuperscriptBox["i", "2"], " ", 
          SuperscriptBox["t", "2"]}]}], ")"}]}]]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"t1", "[", 
      RowBox[{"f_", ",", "d1_", ",", "d2_"}], "]"}], ":=", 
     FractionBox[
      RowBox[{
       SuperscriptBox["d1", "2"], " ", "+", 
       SuperscriptBox["d2", "2"], " ", "+", 
       RowBox[{"2", " ", "d1", " ", "f"}], " ", "+", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["d1", "2"], "+", 
          SuperscriptBox["d2", "2"]}]], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["d1", "2"], "+", 
          SuperscriptBox["d2", "2"], "+", 
          RowBox[{"4", " ", "d1", " ", "f"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["f", "2"]}]}]], " "}]}], 
      RowBox[{"2", " ", "d2", " ", "i"}]]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"t2", "[", 
      RowBox[{"f_", ",", "d1_", ",", "d2_"}], "]"}], ":=", 
     FractionBox[
      RowBox[{
       SuperscriptBox["d1", "2"], " ", "+", 
       SuperscriptBox["d2", "2"], " ", "+", 
       RowBox[{"2", " ", "d1", " ", "f"}], " ", "-", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["d1", "2"], "+", 
          SuperscriptBox["d2", "2"]}]], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["d1", "2"], "+", 
          SuperscriptBox["d2", "2"], "+", 
          RowBox[{"4", " ", "d1", " ", "f"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["f", "2"]}]}]], " "}]}], 
      RowBox[{"2", " ", "d2", " ", "i"}]]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"tC", "[", 
      RowBox[{"f_", ",", "d1_", ",", "d2_"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", "d2", "]"}], ">", ".01"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"d1", "\[GreaterEqual]", "0"}], ",", 
         RowBox[{"t2", "[", 
          RowBox[{"f", ",", "d1", ",", "d2"}], "]"}], ",", 
         RowBox[{"t1", "[", 
          RowBox[{"f", ",", "d1", ",", "d2"}], "]"}]}], "]"}], ",", "0"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightPeak\[Beta]Ratio", "[", 
      RowBox[{"f_", ",", "d1_", ",", "d2_"}], "]"}], ":=", 
     RowBox[{"right\[Beta]Ratio", "[", 
      RowBox[{"f", ",", "d1", ",", "d2", ",", 
       RowBox[{"tC", "[", 
        RowBox[{"f", ",", "d1", ",", "d2"}], "]"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"r", "=", 
     RowBox[{"eyeRadius", "=", "1.3"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"n", "=", 
     RowBox[{"nodePercent", "=", "0"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"i", "=", 
     RowBox[{"interOcular", "=", "6.5"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"aimOffset", "=", "0"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"f", "=", 
     RowBox[{"fixate", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"fixate", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "f"}], "}"}]}], ";"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"d1", ":=", 
     RowBox[{
      RowBox[{"distractor", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "-", "f"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"d2", ":=", 
     RowBox[{"distractor", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"headAimVector", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"base", "[", "tt_", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"interOcular", "*", 
        RowBox[{"(", "tt", ")"}]}], ",", "0"}], "}"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "distractor", "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<D\>\"", ",", 
               RowBox[{"1.05", "distractor"}]}], "]"}]}], 
            "\[IndentingNewLine]", "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{"midPoint", "[", 
             RowBox[{"headAimVector", ",", 
              RowBox[{"base", "[", "0", "]"}]}], "]"}], "]"}]}], "}"}], "]"}],
         "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"Point", "[", 
             RowBox[{"base", "[", "0", "]"}], "]"}], "\[IndentingNewLine]", 
            "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "fixate", "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<F\>\"", ",", 
               RowBox[{"1.05", "fixate"}]}], "]"}]}], "}"}]}], "}"}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"{", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "fixate"}], "}"}], "]"}],
             "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
           RowBox[{"Dashing", "[", ".01", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"nodePercent", "*", 
                   RowBox[{"13", "/", "10"}]}]}], "}"}], ",", "distractor"}], 
               "}"}], "]"}], ",", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{
                  RowBox[{"n", "*", "r"}], "+", 
                  RowBox[{
                   FractionBox[
                    RowBox[{"d1", "+", "f"}], "2"], 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["d2", 
                    RowBox[{"d1", "+", "f"}]], ")"}], "2"]}], ")"}]}]}]}], 
                "}"}], ",", 
               RowBox[{
                FractionBox[
                 RowBox[{"d1", "+", "f"}], "2"], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    FractionBox["d2", 
                    RowBox[{"d1", "+", "f"}]], ")"}], "2"]}], ")"}]}]}], 
              "]"}]}], "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"movingEyePict", "[", 
         RowBox[{
          RowBox[{"base", "[", "0", "]"}], ",", "fixate"}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Gray", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<t\>\"", ",", "Italic"}], "]"}], ",", 
                  "\"\< = \>\"", ",", "0"}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{
                  RowBox[{"-", ".23"}], " ", "scale"}]}], "}"}]}], "]"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"HoldForm", "[", 
                   FractionBox[
                    RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
                    RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], "]"}], 
                  ",", "\"\< = \>\"", ",", 
                  RowBox[{"Round", "[", 
                   RowBox[{
                    RowBox[{"right\[Beta]Ratio", "[", 
                    RowBox[{"f", ",", "d1", ",", "d2", ",", "0"}], "]"}], ",",
                     ".001"}], "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{
                  RowBox[{"-", ".1"}], " ", "scale"}]}], "}"}]}], "]"}]}], 
            "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"movingEyePict", "[", 
         RowBox[{
          RowBox[{"base", "[", "t", "]"}], ",", "fixate"}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"movingEyePict", "[", 
         RowBox[{
          RowBox[{"base", "[", 
           RowBox[{"tC", "[", 
            RowBox[{"f", ",", "d1", ",", "d2"}], "]"}], "]"}], ",", 
          "fixate"}], "]"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Magenta", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"distractor", ",", 
                RowBox[{"base", "[", "t", "]"}], ",", "fixate"}], "}"}], 
              "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<t\>\"", ",", "Italic"}], "]"}], ",", 
                  "\"\< = \>\"", ",", 
                  RowBox[{"Round", "[", 
                   RowBox[{"t", ",", ".1"}], "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"t", " ", "i"}], ",", 
                 RowBox[{
                  RowBox[{"-", ".2"}], " ", "scale"}]}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"HoldForm", "[", 
                   FractionBox[
                    RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
                    RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], "]"}], 
                  ",", "\"\< = \>\"", ",", 
                  RowBox[{"Round", "[", 
                   RowBox[{
                    RowBox[{"right\[Beta]Ratio", "[", 
                    RowBox[{"f", ",", "d1", ",", "d2", ",", "t"}], "]"}], ",",
                     ".001"}], "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"t", " ", "i"}], ",", 
                 RowBox[{
                  RowBox[{"-", ".05"}], " ", "scale"}]}], "}"}]}], "]"}]}], 
            "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Brown", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"distractor", ",", 
                RowBox[{"base", "[", 
                 RowBox[{"tC", "[", 
                  RowBox[{"f", ",", "d1", ",", "d2"}], "]"}], "]"}], ",", 
                "fixate"}], "}"}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<t\>\"", ",", "Italic"}], "]"}], ",", 
                  "\"\< \>\"", ",", "C", ",", "\"\< = \>\"", ",", 
                  RowBox[{"Round", "[", 
                   RowBox[{
                    RowBox[{"tC", "[", 
                    RowBox[{"f", ",", "d1", ",", "d2"}], "]"}], ",", ".1"}], 
                   "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"tC", "[", 
                   RowBox[{"f", ",", "d1", ",", "d2"}], "]"}], " ", "i"}], 
                 ",", 
                 RowBox[{
                  RowBox[{"-", ".25"}], " ", "scale"}]}], "}"}]}], "]"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"HoldForm", "[", 
                   FractionBox[
                    RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
                    RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], "]"}], 
                  ",", "\"\< = \>\"", ",", 
                  RowBox[{"Round", "[", 
                   RowBox[{
                    RowBox[{"rightPeak\[Beta]Ratio", "[", 
                    RowBox[{"f", ",", "d1", ",", "d2"}], "]"}], ",", ".001"}],
                    "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"tC", "[", 
                   RowBox[{"f", ",", "d1", ",", "d2"}], "]"}], " ", "i"}], 
                 ",", 
                 RowBox[{
                  RowBox[{"-", ".15"}], " ", "scale"}]}], "}"}]}], "]"}]}], 
            "}"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"fixate", ",", "distractor"}], "}"}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<|\>\"", ",", "\"\<D\>\"", ",", "\"\<-\>\"", ",", 
                  "\"\<F\>\"", ",", "\"\<|\>\"", ",", "\"\</\>\"", ",", 
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}], ",", 
                  "\"\< = \>\"", ",", 
                  RowBox[{"Round", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", "d1", "]"}], 
                    RowBox[{
                    RowBox[{"nORM", "[", 
                    RowBox[{"{", 
                    RowBox[{"d1", ",", "d2"}], "}"}], "]"}], "/", "f"}]}], 
                    ",", ".001"}], "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"scale", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", ".3"}], ",", ".4"}], "}"}]}]}], "]"}]}], 
            "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"{", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<|\>\"", ",", "\"\<D\>\"", ",", "\"\<-\>\"", ",", 
                 "\"\<F\>\"", ",", "\"\<|\>\"", ",", "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Sign", "[", "d1", "]"}], 
                    RowBox[{"nORM", "[", 
                    RowBox[{"{", 
                    RowBox[{"d1", ",", "d2"}], "}"}], "]"}]}], ",", ".001"}], 
                  "]"}]}], "}"}], "]"}], ",", 
              RowBox[{"scale", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", ".3"}], ",", ".6"}], "}"}]}]}], "]"}], "}"}]}], 
          "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"{", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}], ",", 
                 "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{"f", ",", ".001"}], "]"}]}], "}"}], "]"}], ",", 
              RowBox[{"scale", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", ".3"}], ",", ".5"}], "}"}]}]}], "]"}], "}"}]}], 
          "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"{", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{"\"\<F\>\"", ",", "\"\< = (0,\>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{"f", ",", ".001"}], "]"}], ",", "\"\<)\>\""}], 
                "}"}], "]"}], ",", 
              RowBox[{"scale", 
               RowBox[{"{", 
                RowBox[{".3", ",", ".5"}], "}"}]}]}], "]"}], "}"}]}], "}"}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"{", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{"\"\<D\>\"", ",", "\"\< = (\>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"distractor", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", ".001"}], "]"}], 
                 ",", "\"\<,\>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"distractor", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", ".001"}], "]"}], 
                 ",", "\"\<)\>\""}], "}"}], "]"}], ",", 
              RowBox[{"scale", 
               RowBox[{"{", 
                RowBox[{".3", ",", ".6"}], "}"}]}]}], "]"}], "}"}]}], "}"}], 
         "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"scale", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".6"}], ",", ".6"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".3"}], ",", "1.1"}], "}"}]}], "}"}]}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"400", ",", "400"}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "5"}], ",", "\"\<time t\>\""}], "}"}], ",", 
     RowBox[{"-", "10"}], ",", "10", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"scale", ",", "125"}], "}"}], ",", "50", ",", "1000", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fixate", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "100"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1000"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"distractor", ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "110"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "500"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"500", ",", "1100"}], "}"}], ",", "Locator"}], "}"}], ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", "Manipulate"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.424700090669854*^9, 3.424700179657638*^9}, {
   3.424703174206171*^9, 3.424703195225628*^9}, 3.424703249455967*^9, {
   3.424703310240911*^9, 3.424703341621011*^9}, {3.424703406147723*^9, 
   3.424703487750498*^9}, {3.424703587954802*^9, 3.424703592948882*^9}, {
   3.424703635817727*^9, 3.424703649077084*^9}, {3.424703729316387*^9, 
   3.424703745168614*^9}, {3.424713127995158*^9, 3.4247131742076883`*^9}, {
   3.424713204333799*^9, 3.424713322030746*^9}, {3.424713455528717*^9, 
   3.424713464067161*^9}, 3.424713498823077*^9, 3.424713576907153*^9, 
   3.424713916896472*^9, {3.424713986079142*^9, 3.4247139956107883`*^9}, {
   3.42471403094821*^9, 3.424714141865486*^9}, {3.4247141980210133`*^9, 
   3.424714217587628*^9}, {3.424714285321116*^9, 3.424714321147676*^9}, {
   3.424714368230012*^9, 3.424714422775343*^9}, {3.424714484364451*^9, 
   3.4247144927792892`*^9}, {3.424714599377195*^9, 3.424714616694086*^9}, {
   3.424716595386483*^9, 3.4247166212669897`*^9}, {3.424716694561042*^9, 
   3.42471671380056*^9}, {3.424716756594067*^9, 3.424716768908182*^9}, {
   3.424717255681838*^9, 3.4247172584486647`*^9}, {3.4247173110533867`*^9, 
   3.424717359412581*^9}, {3.4247175940908613`*^9, 3.424717602562158*^9}, {
   3.424717644434876*^9, 3.424717753117037*^9}, {3.424717800859456*^9, 
   3.4247178163076973`*^9}, {3.424718068121101*^9, 3.4247182800303507`*^9}, 
   3.424718353142374*^9, {3.424719065921816*^9, 3.424719126571014*^9}, {
   3.42471917248374*^9, 3.424719258000701*^9}, {3.424719324199663*^9, 
   3.424719417703589*^9}, 3.4247194974948673`*^9, {3.424719546989506*^9, 
   3.424719549855213*^9}, {3.424719599312951*^9, 3.42471961415446*^9}, {
   3.4247196585222197`*^9, 3.42471965877595*^9}, 3.4247197133441143`*^9, {
   3.424719792774782*^9, 3.424719794211705*^9}, 3.424719850461482*^9, 
   3.424719884787341*^9, 3.424719936182859*^9, {3.4247199855849133`*^9, 
   3.4247199866954308`*^9}, {3.424720034249297*^9, 3.4247200747992764`*^9}, {
   3.424720145997554*^9, 3.424720200262694*^9}, {3.424720315573998*^9, 
   3.424720479121234*^9}, {3.424720513393835*^9, 3.42472052020818*^9}, {
   3.424720770626955*^9, 3.4247208012232656`*^9}, {3.424729914050819*^9, 
   3.424729928022873*^9}, {3.42473092135541*^9, 3.4247309248808537`*^9}, {
   3.426434266751872*^9, 3.4264343096021566`*^9}, {3.4264343606072564`*^9, 
   3.4264343625754533`*^9}, {3.4270616380978165`*^9, 
   3.4270616383482533`*^9}, {3.427061676101601*^9, 3.4270618502482123`*^9}, {
   3.427061918764288*^9, 3.427062131555934*^9}, {3.427062168879896*^9, 
   3.4270622171447186`*^9}, {3.427062259610885*^9, 3.4270622609863076`*^9}, {
   3.4270623056562757`*^9, 3.4270623084227505`*^9}, {3.427125049148487*^9, 
   3.427125055134841*^9}, {3.4271251059995337`*^9, 3.4271251134155197`*^9}, {
   3.427125272590157*^9, 3.427125296295586*^9}, {3.4271253397103987`*^9, 
   3.427125400642477*^9}, 3.427125524909466*^9, {3.427125609611882*^9, 
   3.427125616259768*^9}, {3.427125647101365*^9, 3.4271256972937326`*^9}, {
   3.427462127228266*^9, 3.427462145255917*^9}, 3.427462409008567*^9, {
   3.4304974311550283`*^9, 3.430497441805093*^9}, 3.4307416587308397`*^9, {
   3.4307418106166487`*^9, 3.4307418113415422`*^9}, {3.457562214036186*^9, 
   3.457562231379373*^9}, 3.457562330874955*^9, 3.457562407659438*^9},
 CellID->670459734]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`distractor$$ = {10, 
    110}, $CellContext`fixate$$ = {0, 100}, $CellContext`scale$$ = 
    125, $CellContext`t$$ = -5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], -5, "time t"}, -10, 10}, {{
       Hold[$CellContext`scale$$], 125}, 50, 1000}, {{
       Hold[$CellContext`fixate$$], {0, 100}}, {0, 15}, {0, 1000}}, {{
       Hold[$CellContext`distractor$$], {10, 110}}, {-500, 10}, {500, 1100}}},
     Typeset`size$$ = {400., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$29791$$ = 0, $CellContext`scale$29792$$ = 
    0, $CellContext`fixate$29793$$ = {0, 
    0}, $CellContext`distractor$29794$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`distractor$$ = {10, 
         110}, $CellContext`fixate$$ = {0, 100}, $CellContext`scale$$ = 
        125, $CellContext`t$$ = -5}, "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$29791$$, 0], 
        Hold[$CellContext`scale$$, $CellContext`scale$29792$$, 0], 
        Hold[$CellContext`fixate$$, $CellContext`fixate$29793$$, {0, 0}], 
        Hold[$CellContext`distractor$$, $CellContext`distractor$29794$$, {0, 
         0}]}, "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ($CellContext`nORM[
          PatternTest[
           Pattern[$CellContext`vector, 
            Blank[]], VectorQ]] := 
        Dot[$CellContext`vector, $CellContext`vector]^
         Rational[1, 2]; $CellContext`degrees[
          Pattern[$CellContext`q, 
           Blank[]]] := $CellContext`q (180/Pi); $CellContext`arcMinutes[
          Pattern[$CellContext`q, 
           Blank[]]] := $CellContext`q 60 (180/Pi); $CellContext`aim\[Psi][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[$CellContext`headAimVector, 1], 
          Part[$CellContext`headAimVector, 2]]; $CellContext`midPoint[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`base - $CellContext`aimOffset \
$CellContext`interOcular {
           Part[$CellContext`headAimVector, 2], -
           Part[$CellContext`headAimVector, 1]}; $CellContext`rightEyeCenter[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := $CellContext`base + (
           1/2 - $CellContext`aimOffset) $CellContext`interOcular {
            Part[$CellContext`headAimVector, 2], -
            Part[$CellContext`headAimVector, 1]}; $CellContext`leftEyeCenter[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := $CellContext`base - (
          1/2 + $CellContext`aimOffset) $CellContext`interOcular {
           Part[$CellContext`headAimVector, 2], -
           Part[$CellContext`headAimVector, 1]}; $CellContext`rightViewVector[
         
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`fixate - \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base]; \
$CellContext`right\[CurlyPhi][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 1], 
          Part[
           $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 2]]; $CellContext`rightEyeNode[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base] + \
$CellContext`nodePercent $CellContext`eyeRadius \
($CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]/$CellContext`nORM[
            $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]]); $CellContext`leftViewVector[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`fixate - \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base]; \
$CellContext`left\[CurlyPhi][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 1], 
          Part[
           $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 2]]; $CellContext`leftEyeNode[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base] + \
$CellContext`nodePercent $CellContext`eyeRadius \
($CellContext`leftViewVector[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]/$CellContext`nORM[
            $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]]); $CellContext`fixateConvergence[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]; $CellContext`left\[Alpha][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - $CellContext`aim\[Psi][$CellContext`headAimVector, \
$CellContext`base]; $CellContext`right\[Alpha][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`aim\[Psi][$CellContext`headAimVector, $CellContext`base]; \
$CellContext`rightDistractVector[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`distraction - \
$CellContext`rightEyeNode[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]; $CellContext`right\[Delta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`rightDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 1], 
          Part[
           $CellContext`rightDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 
           2]]; $CellContext`leftDistractVector[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`distraction - \
$CellContext`leftEyeNode[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]; $CellContext`left\[Delta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`leftDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 1], 
          Part[
           $CellContext`leftDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 
           2]]; $CellContext`convergenceDistraction[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := If[
          Or[
          Abs[$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`left\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]] > Pi/3., 
           Abs[$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`right\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]] > Pi/3.], 
          0., $CellContext`right\[Delta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] - \
$CellContext`left\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]]; $CellContext`right\[Theta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`right\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]; $CellContext`left\[Theta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - $CellContext`left\[Delta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base]; \
$CellContext`binocularDisparity[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := If[
          
          Or[$CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            2., $CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > 
           Pi/3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > Pi/2.], 
          0, $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] - \
$CellContext`left\[Theta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]]; \
$CellContext`right\[Theta]inside[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[Theta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base] + 
         ArcSin[$CellContext`nodePercent Sin[
             $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base]]]; \
$CellContext`left\[Theta]inside[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] + 
         ArcSin[$CellContext`nodePercent Sin[
             $CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base]]]; \
$CellContext`retinalDisparity[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := If[
          
          Or[$CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            2., $CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > 
           Pi/3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > Pi/2.], 
          0, $CellContext`right\[Theta]inside[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] - \
$CellContext`left\[Theta]inside[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base]]; \
$CellContext`eyePict[
          PatternTest[
           Pattern[$CellContext`eyeCenter, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ]] := 
        Module[{$CellContext`\[Lambda], $CellContext`viewVector}, \
$CellContext`viewVector = $CellContext`fixate - $CellContext`eyeCenter; \
$CellContext`\[Lambda] = ArcTan[
             Part[$CellContext`viewVector, 1], 
             
             Part[$CellContext`viewVector, 
              2]]; $CellContext`viewVector = \
$CellContext`viewVector/$CellContext`nORM[$CellContext`viewVector]; Show[{
             Graphics[{
               AbsoluteThickness[2], Gray, 
               
               Circle[$CellContext`eyeCenter, $CellContext`eyeRadius, \
{$CellContext`\[Lambda] + 0.4, 2 Pi + $CellContext`\[Lambda] - 0.4}]}], 
             Graphics[{Gray, 
               
               Circle[$CellContext`eyeCenter + 
                0.8 $CellContext`eyeRadius $CellContext`viewVector, 
                0.5 $CellContext`eyeRadius, {$CellContext`\[Lambda] - 
                 1.5, $CellContext`\[Lambda] + 1.5}]}], 
             Graphics[{Black, 
               
               Disk[$CellContext`eyeCenter + $CellContext`eyeRadius \
$CellContext`nodePercent $CellContext`viewVector, $CellContext`eyeRadius/
                10]}]}, AspectRatio -> Automatic]]; $CellContext`movingEyePict[
          PatternTest[
           Pattern[$CellContext`eyeCenter, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ]] := 
        Module[{$CellContext`\[Lambda], $CellContext`viewVector}, \
$CellContext`viewVector = $CellContext`fixate - $CellContext`eyeCenter; \
$CellContext`\[Lambda] = ArcTan[
             Part[$CellContext`viewVector, 1], 
             
             Part[$CellContext`viewVector, 
              2]]; $CellContext`viewVector = \
$CellContext`viewVector/$CellContext`nORM[$CellContext`viewVector]; Show[{
             Graphics[{
               AbsoluteThickness[2], 
               Dashing[0.01], Gray, {
                
                Line[{$CellContext`eyeCenter - {
                  1. $CellContext`eyeRadius, 
                   1.5 $CellContext`eyeRadius}, $CellContext`eyeCenter + {
                   1. $CellContext`eyeRadius, (-1.5) $CellContext`eyeRadius}, \
$CellContext`eyeCenter + {
                   0.7 $CellContext`eyeRadius, (-1.6) \
$CellContext`eyeRadius}}], 
                
                Circle[$CellContext`eyeCenter, $CellContext`eyeRadius, \
{$CellContext`\[Lambda] + 0.4, 2 Pi + $CellContext`\[Lambda] - 0.4}]}}], 
             Graphics[{Gray, 
               
               Circle[$CellContext`eyeCenter + 
                0.8 $CellContext`eyeRadius $CellContext`viewVector, 
                0.5 $CellContext`eyeRadius, {$CellContext`\[Lambda] - 
                 1.5, $CellContext`\[Lambda] + 1.5}]}], 
             Graphics[{Black, 
               
               Disk[$CellContext`eyeCenter + $CellContext`eyeRadius \
$CellContext`nodePercent $CellContext`viewVector, $CellContext`eyeRadius/
                10]}]}, AspectRatio -> Automatic]]; $CellContext`eyeEdge[
          Pattern[$CellContext`\[Theta], 
           Blank[]]] := $CellContext`eyeRadius {
           Cos[$CellContext`\[Theta]], 
           Sin[$CellContext`\[Theta]]}; $CellContext`eyeEdge[
          Pattern[$CellContext`\[Theta], 
           Blank[]]] := $CellContext`eyeRadius {
           Cos[$CellContext`\[Theta]], 
           Sin[$CellContext`\[Theta]]}; $CellContext`inRays[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := Show[{
           $CellContext`eyePict[
            $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`fixate], 
           $CellContext`eyePict[
            $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`fixate], 
           Graphics[{Red, {
              Line[{
                $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base] - \
$CellContext`eyeRadius \
($CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]/$CellContext`nORM[
                  $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]])}]}}], 
           Graphics[{Red, {
              Line[{
                $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base] - \
$CellContext`eyeRadius \
($CellContext`leftViewVector[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]/$CellContext`nORM[
                  $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]])}]}}], 
           Graphics[{Blue, {
              Line[{
                $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base] + \
$CellContext`eyeEdge[$CellContext`right\[CurlyPhi][$CellContext`headAimVector,\
 $CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`right\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Blue, {
              Line[{
                $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base] + \
$CellContext`eyeEdge[$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Purple, {
              Line[{
                $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base] + \
$CellContext`eyeEdge[$CellContext`right\[CurlyPhi][$CellContext`headAimVector,\
 $CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`right\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Purple, {
              Line[{
                $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base] + \
$CellContext`eyeEdge[$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Green, {
              Line[
               N[{
                 $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], 
                 $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base]}]]}}], $CellContext`min = 
            Min[{$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base] - \
$CellContext`retinalDisparity[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]}]; $CellContext`MAX = 
            Max[{$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base] - \
$CellContext`retinalDisparity[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]}]; Graphics[{Brown, 
              AbsoluteThickness[3], {
               Circle[
                $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`eyeRadius, {$CellContext`min, \
$CellContext`MAX}]}}]}, AspectRatio -> Automatic, PlotRange -> {{Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 1] - $CellContext`interOcular, Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 1] + $CellContext`interOcular}, {Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 2] - $CellContext`interOcular, Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 2] + $CellContext`interOcular}}]; $CellContext`outRays[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := Show[{
           Graphics[{Black, 
             AbsolutePointSize[4], {
              Point[
               N[$CellContext`fixate]]}}], 
           Graphics[{Black, 
             AbsolutePointSize[4], {
              Point[
               N[$CellContext`distraction]]}}], 
           Graphics[{Black, {
              Line[
               N[{$CellContext`fixate, 
                 $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}], 
           Graphics[{Black, {
              Line[
               N[{$CellContext`fixate, 
                 $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}], 
           Graphics[{Black, {
              Line[
               N[{$CellContext`distraction, 
                 $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}], 
           Graphics[{Black, {
              Line[
               N[{$CellContext`distraction, 
                 $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}]}, AspectRatio -> 
          Automatic]; $CellContext`right\[Beta]Ratio[
          Pattern[$CellContext`f, 
           Blank[]], 
          Pattern[$CellContext`d1, 
           Blank[]], 
          Pattern[$CellContext`d2, 
           Blank[]], 
          Pattern[$CellContext`t, 
           
           Blank[]]] := ($CellContext`f ($CellContext`d1 ($CellContext`d1 + \
$CellContext`f) + $CellContext`d2^2 - 
            2 $CellContext`d2 $CellContext`i $CellContext`t) - \
$CellContext`d1 $CellContext`i^2 $CellContext`t^2)/(($CellContext`d1 + \
$CellContext`f) ($CellContext`f^2 + $CellContext`i^2 $CellContext`t^2)); \
$CellContext`t1[
          Pattern[$CellContext`f, 
           Blank[]], 
          Pattern[$CellContext`d1, 
           Blank[]], 
          Pattern[$CellContext`d2, 
           Blank[]]] := ($CellContext`d1^2 + $CellContext`d2^2 + 
          2 $CellContext`d1 $CellContext`f + ($CellContext`d1^2 + \
$CellContext`d2^2)^
            Rational[1, 2] ($CellContext`d1^2 + $CellContext`d2^2 + 
             4 $CellContext`d1 $CellContext`f + 4 $CellContext`f^2)^
            Rational[1, 2])/(
         2 $CellContext`d2 $CellContext`i); $CellContext`t2[
          Pattern[$CellContext`f, 
           Blank[]], 
          Pattern[$CellContext`d1, 
           Blank[]], 
          Pattern[$CellContext`d2, 
           Blank[]]] := ($CellContext`d1^2 + $CellContext`d2^2 + 
          2 $CellContext`d1 $CellContext`f - ($CellContext`d1^2 + \
$CellContext`d2^2)^
           Rational[1, 2] ($CellContext`d1^2 + $CellContext`d2^2 + 
            4 $CellContext`d1 $CellContext`f + 4 $CellContext`f^2)^
           Rational[1, 2])/(2 $CellContext`d2 $CellContext`i); $CellContext`tC[
          Pattern[$CellContext`f, 
           Blank[]], 
          Pattern[$CellContext`d1, 
           Blank[]], 
          Pattern[$CellContext`d2, 
           Blank[]]] := If[Abs[$CellContext`d2] > 0.01, 
          If[$CellContext`d1 >= 0, 
           $CellContext`t2[$CellContext`f, $CellContext`d1, $CellContext`d2], \

           $CellContext`t1[$CellContext`f, $CellContext`d1, $CellContext`d2]],
           0]; $CellContext`rightPeak\[Beta]Ratio[
          Pattern[$CellContext`f, 
           Blank[]], 
          Pattern[$CellContext`d1, 
           Blank[]], 
          Pattern[$CellContext`d2, 
           
           Blank[]]] := $CellContext`right\[Beta]Ratio[$CellContext`f, \
$CellContext`d1, $CellContext`d2, 
          $CellContext`tC[$CellContext`f, $CellContext`d1, $CellContext`d2]]; \
$CellContext`r = ($CellContext`eyeRadius = 1.3); 
       DemonstrationsTools`n = ($CellContext`nodePercent = 
         0); $CellContext`i = ($CellContext`interOcular = 
         6.5); $CellContext`aimOffset = 0; $CellContext`f = 
        Part[$CellContext`fixate$$, 2]; $CellContext`d1 := 
        Part[$CellContext`distractor$$, 2] - $CellContext`f; $CellContext`d2 := 
        Part[$CellContext`distractor$$, 1]; $CellContext`headAimVector = {0, 
         1}; $CellContext`base[
          Pattern[$CellContext`tt, 
           Blank[]]] = {$CellContext`interOcular $CellContext`tt, 0}; Show[{
          Graphics[{Blue, 
            AbsolutePointSize[5], {
             Point[$CellContext`distractor$$], 
             Text["D", 1.05 $CellContext`distractor$$]}}], 
          Graphics[{
            AbsolutePointSize[4], 
            Point[
             $CellContext`midPoint[$CellContext`headAimVector, 
              $CellContext`base[0]]]}], 
          Graphics[{Black, 
            AbsolutePointSize[4], {
             Point[
              $CellContext`base[0]]}}], 
          Graphics[{Red, 
            AbsolutePointSize[4], {
             Point[$CellContext`fixate$$], 
             Text["F", 1.05 $CellContext`fixate$$]}}], 
          Graphics[{Black, {
             Line[{{0, 0}, $CellContext`fixate$$}]}}], 
          Graphics[{Black, 
            AbsolutePointSize[5], 
            Dashing[0.01], {
             
             Line[{{0, $CellContext`nodePercent (13/
                 10)}, $CellContext`distractor$$}], 
             
             Circle[{0, 
               DemonstrationsTools`n $CellContext`r + (($CellContext`d1 + \
$CellContext`f)/2) (
                 1 + ($CellContext`d2/($CellContext`d1 + \
$CellContext`f))^2)}, (($CellContext`d1 + $CellContext`f)/2) (
               1 + ($CellContext`d2/($CellContext`d1 + \
$CellContext`f))^2)]}}], 
          $CellContext`movingEyePict[
           $CellContext`base[0], $CellContext`fixate$$], 
          Graphics[{Gray, {
             Text[
              Row[{
                Style["t", Italic], " = ", 0}], {
              0, (-0.23) $CellContext`scale$$}], 
             Text[
              Row[{
                
                HoldForm[$CellContext`d $CellContext`\[Theta]/($CellContext`d \
$CellContext`\[Beta])], " = ", 
                Round[
                 $CellContext`right\[Beta]Ratio[$CellContext`f, \
$CellContext`d1, $CellContext`d2, 0], 0.001]}], {
              0, (-0.1) $CellContext`scale$$}]}}], 
          $CellContext`movingEyePict[
           $CellContext`base[$CellContext`t$$], $CellContext`fixate$$], 
          $CellContext`movingEyePict[
           $CellContext`base[
            $CellContext`tC[$CellContext`f, $CellContext`d1, \
$CellContext`d2]], $CellContext`fixate$$], 
          Graphics[{Magenta, {
             Line[{$CellContext`distractor$$, 
               $CellContext`base[$CellContext`t$$], $CellContext`fixate$$}], 
             Text[
              Row[{
                Style["t", Italic], " = ", 
                
                Round[$CellContext`t$$, 
                 0.1]}], {$CellContext`t$$ $CellContext`i, (-0.2) \
$CellContext`scale$$}], 
             Text[
              Row[{
                
                HoldForm[$CellContext`d $CellContext`\[Theta]/($CellContext`d \
$CellContext`\[Beta])], " = ", 
                Round[
                 $CellContext`right\[Beta]Ratio[$CellContext`f, \
$CellContext`d1, $CellContext`d2, $CellContext`t$$], 
                 0.001]}], {$CellContext`t$$ $CellContext`i, (-0.05) \
$CellContext`scale$$}]}}], 
          Graphics[{Brown, {
             Line[{$CellContext`distractor$$, 
               $CellContext`base[
                $CellContext`tC[$CellContext`f, $CellContext`d1, \
$CellContext`d2]], $CellContext`fixate$$}], 
             Text[
              Row[{
                Style["t", Italic], " ", C, " = ", 
                Round[
                 $CellContext`tC[$CellContext`f, $CellContext`d1, \
$CellContext`d2], 
                 0.1]}], {$CellContext`tC[$CellContext`f, $CellContext`d1, \
$CellContext`d2] $CellContext`i, (-0.25) $CellContext`scale$$}], 
             Text[
              Row[{
                
                HoldForm[$CellContext`d $CellContext`\[Theta]/($CellContext`d \
$CellContext`\[Beta])], " = ", 
                Round[
                 $CellContext`rightPeak\[Beta]Ratio[$CellContext`f, \
$CellContext`d1, $CellContext`d2], 
                 0.001]}], {$CellContext`tC[$CellContext`f, $CellContext`d1, \
$CellContext`d2] $CellContext`i, (-0.15) $CellContext`scale$$}]}}], 
          Graphics[{Blue, {
             Line[{$CellContext`fixate$$, $CellContext`distractor$$}], 
             Text[
              Row[{"|", "D", "-", "F", "|", "/", 
                Style["f", Italic], " = ", 
                Round[
                Sign[$CellContext`d1] ($CellContext`nORM[{$CellContext`d1, \
$CellContext`d2}]/$CellContext`f), 0.001]}], $CellContext`scale$$ {-0.3, 
               0.4}]}}], 
          Graphics[{Blue, {
             Text[
              Row[{"|", "D", "-", "F", "|", " = ", 
                Round[
                Sign[$CellContext`d1] $CellContext`nORM[{$CellContext`d1, \
$CellContext`d2}], 0.001]}], $CellContext`scale$$ {-0.3, 0.6}]}}], 
          Graphics[{Red, {
             Text[
              Row[{
                Style["f", Italic], " = ", 
                Round[$CellContext`f, 0.001]}], $CellContext`scale$$ {-0.3, 
               0.5}]}}], 
          Graphics[{Red, {
             Text[
              Row[{"F", " = (0,", 
                Round[$CellContext`f, 0.001], ")"}], $CellContext`scale$$ {
               0.3, 0.5}]}}], 
          Graphics[{Blue, {
             Text[
              Row[{"D", " = (", 
                Round[
                 Part[$CellContext`distractor$$, 1], 0.001], ",", 
                Round[
                 Part[$CellContext`distractor$$, 2], 0.001], 
                ")"}], $CellContext`scale$$ {0.3, 0.6}]}}]}, 
         PlotRange -> $CellContext`scale$$ {{-0.6, 0.6}, {-0.3, 1.1}}, 
         AspectRatio -> Automatic, ImageSize -> {400, 400}]), 
      "Specifications" :> {{{$CellContext`t$$, -5, "time t"}, -10, 10, 
         Appearance -> "Labeled"}, {{$CellContext`scale$$, 125}, 50, 1000, 
         Appearance -> "Labeled"}, {{$CellContext`fixate$$, {0, 100}}, {0, 
         15}, {0, 1000}, ControlType -> 
         Locator}, {{$CellContext`distractor$$, {10, 110}}, {-500, 10}, {500, 
         1100}, ControlType -> Locator}}, 
      "Options" :> {TrackedSymbols -> Manipulate}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{451., {259., 264.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->695675211],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This Demonstration computes the motion/pursuit law in the two-dimensional \
horizontal fixation plane of the eyes. The observer is looking mainly at F on \
the vertical axis, but also sees D as he translates to the right at speed \
equal to the interocular distance per second.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[TextData[{
 "We do not know a theoretical explanation for the rough approximation of the \
peak motion pursuit law by the 2D relative distance, but this Demonstration \
compares ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], 
    RowBox[{"(", "0", ")"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], 
    RowBox[{"(", 
     SubscriptBox["t", "c"], ")"}]}], TraditionalForm]], "InlineMath"],
 ", and the 2D signed relative distance, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PlusMinus]", " ", 
    FractionBox[
     RowBox[{"|", 
      RowBox[{
       StyleBox["D",
        FontSlant->"Plain"], "-", 
       StyleBox["F",
        FontSlant->"Plain"]}], "|"}], "f"]}], TraditionalForm]], "InlineMath"],
 ". It also lets you vary time and compare the motion/pursuit law at other \
times. You can drag the distractor point and the fixate distance is \
variable."
}], "Text"],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "See the details in \"",
 ButtonBox["Motion/Pursuit Law in 1D (Visual Depth Perception 1)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitLawIn1DVisualDepthPerception1/"], None}],
 "\" for the basic set-up."
}], "Text"],

Cell["\<\
The relative depth formula extends to the two-dimensional distractor as:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
     RowBox[{
      RowBox[{"d", "\[InvisibleSpace]", "\[Alpha]"}], "-", 
      RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}]}]], 
    RowBox[{"(", "t", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
      RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], 
     RowBox[{"(", "t", ")"}]}], "=", 
    RowBox[{
     RowBox[{"f", "(", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", "n", " ", "r"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["d", "1"], "+", "f"}], ")"}], " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{
               SuperscriptBox["s", "2"], " ", 
               SuperscriptBox["t", "2"]}]}]]}]}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"n", " ", "r", " ", "s", " ", "t"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["d", "2"], "-", 
              RowBox[{"s", " ", "t"}]}], ")"}], " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{
               SuperscriptBox["s", "2"], " ", 
               SuperscriptBox["t", "2"]}]}]]}]}], ")"}], "2"]}], 
       RowBox[{
        RowBox[{"f", " ", "n", " ", "r", " ", "s", " ", "t", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"n", " ", "r", " ", "s", " ", "t"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["d", "2"], "-", 
              RowBox[{"s", " ", "t"}]}], ")"}], " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{
               SuperscriptBox["s", "2"], " ", 
               SuperscriptBox["t", "2"]}]}]]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", " ", "n", " ", "r"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["d", "1"], "+", "f"}], ")"}], " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{
               SuperscriptBox["s", "2"], " ", 
               SuperscriptBox["t", "2"]}]}]]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["f", "2"], " ", "n", " ", "r"}], "-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{
               SuperscriptBox["s", "2"], " ", 
               SuperscriptBox["t", "2"]}]}], ")"}], 
            RowBox[{"3", "/", "2"}]]}], ")"}]}]}]], ")"}], "-", "1"}]}]}], 
  TraditionalForm]], "InlineMath"]], "Text"],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "0"}], TraditionalForm]]],
 " this is somewhat simpler:"
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[VeryThinSpace]", "\[Beta]"}]], "[", "t", "]"}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["d", "1"], "(", 
        RowBox[{
         SubscriptBox["d", "1"], "+", "f"}], ")"}], "+", 
       SuperscriptBox[
        SubscriptBox["d", "2"], "2"], "-", 
       RowBox[{"2", 
        SubscriptBox["d", "2"], " ", "s", " ", "t"}]}], ")"}], "-", 
     RowBox[{
      SubscriptBox["d", "1"], " ", 
      SuperscriptBox["s", "2"], " ", 
      SuperscriptBox["t", "2"]}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["d", "1"], "+", "f"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["f", "2"], "+", 
       RowBox[{
        SuperscriptBox["s", "2"], " ", 
        SuperscriptBox["t", "2"]}]}], ")"}]}]]}], 
  TraditionalForm]], "EquationNumbered"]], "Text"],

Cell[TextData[{
 "This simplifies greatly at the time, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", when the eye crosses the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["d", "1"], TraditionalForm]], "InlineMath"],
 " axis:"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
      RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], 
     RowBox[{"(", "0", ")"}]}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{
       SubscriptBox["d", "1"], "(", 
       RowBox[{
        SubscriptBox["d", "1"], "+", "f"}], ")"}], "+", 
      SuperscriptBox[
       SubscriptBox["d", "2"], "2"]}], 
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["d", "1"], " ", "+", "f"}], ")"}]]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "The motion/pursuit ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[InvisibleSpace]", 
    RowBox[{"\[Theta]", "/", "d"}], "\[InvisibleSpace]", "\[Alpha]"}], 
   TraditionalForm]], "InlineMath"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 " is constant on circles passing through the eye node at time zero and \
distractor ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", "+", 
      SubscriptBox["d", "1"]}], ",", 
     SubscriptBox["d", "2"]}], ")"}], TraditionalForm]], "InlineMath"],
 " with diameter on the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["d", "1"], TraditionalForm]], "InlineMath"],
 " axis. (These circles are similar to the invariant circles for binocular \
disparity, but slightly different.) "
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  GraphicsBox[{{{
      {GrayLevel[0.5], AbsoluteThickness[2], 
       CircleBox[{-3.25, 0}, 1.3, {1.7063079442456641`, 7.18949325142525}]}, 
      {GrayLevel[0.5], 
       CircleBox[{-2.978127905242549, 1.0038354267967415`}, 
        0.65, {-0.193692055754336, 2.806307944245664}]}, 
      {GrayLevel[0], DiskBox[{-3.25, 0}, 0.13]}}, {
      {GrayLevel[0.5], AbsoluteThickness[2], 
       CircleBox[{3.25, 0}, 1.3, {2.2352847093441293`, 7.718470016523716}]}, 
      {GrayLevel[0.5], 
       CircleBox[{2.978127905242549, 1.0038354267967415`}, 0.65, {
        0.33528470934412913`, 3.335284709344129}]}, 
      {GrayLevel[0], DiskBox[{3.25, 0}, 0.13]}}, 
     {RGBColor[1, 0, 0], 
      LineBox[{{3.25, 0}, {3.5898401184468134`, -1.2547942834959267`}}]}, 
     {RGBColor[1, 0, 0], 
      LineBox[{{-3.25, 0}, {-3.5898401184468134`, -1.2547942834959267`}}]}, 
     {RGBColor[0, 0, 1], 
      LineBox[{{3.25, 0}, {4.301356909594145, -0.7646232069775603}}]}, 
     {RGBColor[0, 0, 1], LineBox[{{-3.25, 0}, {-2.886, -1.248}}]}, 
     {RGBColor[0.5, 0, 0.5], 
      LineBox[{{3.25, 0}, {4.301356909594145, -0.7646232069775603}}]}, 
     {RGBColor[0.5, 0, 0.5], LineBox[{{-3.25, 0}, {-2.886, -1.248}}]}, 
     {RGBColor[0, 1, 0], LineBox[{{-3.25, 0.}, {3.25, 0.}}]}, 
     {RGBColor[0.6, 0.4, 0.2], AbsoluteThickness[3], 
      CircleBox[{-3.25, 0}, 
       1.3, {-1.2870022175865687`, -1.1577730515138982`}]}}, {
     {GrayLevel[0], AbsolutePointSize[4], PointBox[{0., 12.}]}, 
     {GrayLevel[0], AbsolutePointSize[4], PointBox[{-5., 6.}]}, 
     {GrayLevel[0], LineBox[{{0., 12.}, {3.25, 0.}}]}, 
     {GrayLevel[0], LineBox[{{0., 12.}, {-3.25, 0.}}]}, 
     {GrayLevel[0], LineBox[{{-5., 6.}, {3.25, 0.}}]}, 
     {GrayLevel[0], LineBox[{{-5., 6.}, {-3.25, 0.}}]}}, 
    {AbsolutePointSize[4], PointBox[{0, 0}]}, 
    {GrayLevel[0], AbsolutePointSize[4], PointBox[{0, 0}]}, 
    {RGBColor[1, 0, 0], AbsolutePointSize[4], PointBox[{0, 12}], 
     InsetBox["\<\"F\"\>", {0, 12.600000000000001`}], 
     LineBox[{{-3.25, 0}, {0, 12}}], LineBox[{{3.25, 0}, {0, 12}}], 
     CircleBox[{8.358897582593104*^-17, 5.559895833333333}, 
      6.440104166666666]}, 
    {RGBColor[0, 0, 1], AbsolutePointSize[5], 
     PointBox[{0, 9.516199417474784}], PointBox[{-5, 6}], 
     InsetBox["\<\"D\"\>", {-5.25, 6.300000000000001}], 
     LineBox[{{-3.25, 0}, {-5, 6}}], LineBox[{{3.25, 0}, {-5, 6}}], 
     CircleBox[{0., 4.203124999999999}, 5.313074417474781]}, 
    {GrayLevel[0], LineBox[{{0, 0}, {0, 12}}]}, 
    {GrayLevel[0], AbsolutePointSize[5], Dashing[0.01], 
     LineBox[{{0, 0}, {-5, 6}}], 
     PointBox[NCache[{0, Rational[61, 6]}, {0, 10.166666666666666`}]], 
     CircleBox[NCache[{0, Rational[61, 12]}, {0, 5.083333333333333}], NCache[
      Rational[61, 12], 5.083333333333333]]}, {
     {GrayLevel[0.5], AbsoluteThickness[2], Dashing[0.01], 
      LineBox[{{-1.3, -1.9500000000000002`}, {1.3, -1.9500000000000002`}, {
       0.9099999999999999, -2.08}}], 
      CircleBox[{0, 0}, 1.3, {1.9707963267948965`, 7.453981633974482}]}, 
     {GrayLevel[0.5], 
      CircleBox[{0, 1.04}, 0.65, {0.07079632679489656, 3.0707963267948966`}]}, 
     {GrayLevel[0], DiskBox[{0, 0}, 0.13]}}},
   AspectRatio->Automatic,
   ImageSize->{258., Automatic},
   PlotRange->{{-8, 8}, {-2.5, 13}}], 
  TraditionalForm]], "InlineMath"]], "Text"],

Cell[TextData[{
 "This means that the time zero motion/pursuit law is NOT an especially good \
indicator of the relative distance between the two-dimensional distractor and \
fixate, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{
     StyleBox["D",
      FontSlant->"Plain"], "-", 
     StyleBox["F",
      FontSlant->"Plain"]}], "|", 
    RowBox[{"/", "f"}]}], TraditionalForm]], "InlineMath"],
 ", because you can move quite far from F on this circle with no change in \
the quantity ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[InvisibleSpace]", 
    RowBox[{"\[Theta]", "/", "d"}], "\[InvisibleSpace]", 
    RowBox[{"\[Beta]", "(", "0", ")"}]}], TraditionalForm]], "InlineMath"],
 ". If we take the translation of the observer into account, we can show that \
the peak value of the motion/pursuit law is a good indicator of the relative \
distance in two dimensions. (It is also likely that the changing value of the \
motion/pursuit ratio is a cue that the brain could use.)"
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {InsetBox[
      Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxc3XdUz/////GshOyVIklGZGVk5ZWVEVHREAlF2aOIslVGIUWo7HZpl5KW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         "], {{
           {GrayLevel[0.5], Opacity[0.2], EdgeForm[None], Specularity[
             GrayLevel[1], 20], 
            GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxMnXncF9P7xj/P83m2zzLzUPadLNkKSXtRRCVLCkUUKqFEyJL2RSllaUHI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               "]], Polygon3DBox[CompressedData["
1:eJxNnAW0VVXXhs/l3nPvPWfve44tCigGBqCfYCsWfoKYiAEGdhIGGNiighig
AgYqIhIWoYKCGBgYYGOLgYFio9j5P49zfWP8Y/AO5jxr7Vp77bVmvPOuc/Qp
PU5uVigUfqgrFPhXuKJaKBRLhcJn/NgxKxQWVgqF1o2Fwjrg/bxQqKf9Q+Rf
wVjkibRf2lAoXAJG0f4G+gG07Q8+QH8a/RfafgXPo89C/wh5Mbg/j/N3o+/u
4D306eiDabsYTEB/Fv035N/BS+gXoj9ZXyg8BQ5Ff6YS57bPi+hbNxUKr/Ic
r4DDy4XCeNr3pa07uJb2SeiHIfcG16FPRT8H+VwwHv069B7I+4EL0CejX4F8
eer/BGOzCve6KjirFNdfD3ndxni+VyvxLF3BIvTX0PdojGd0/CagH8S5eqbx
mofeiraW4Dn0x9HrkGvBo+gPcI0m+lbACb4X2u+gbTL4jfbX0dsit0vjPdr7
oe/66f5fqcS9dAHvJn0t5LXT/Tm+6zfGMzh+S9GnIU8Ff6TnsW/r9H5uRz+f
c5+XxvMq9D95F3+Bk9FfQt+OvtuC1zw/c2RN7vu0Gu6Z93E37ady7GlgXB76
WORbwK3oY9CPRT7GOYD+PHoj5yqBV9FfRK8gV9P5p6CP81hwG/q76H1p6wM+
Qx+LfgptJ4Mr0Ueh74m8Bzjf+cn9rcb93cr9HcHc2QYsLMQcOoL7vaUSx/YH
V9B/GvqdyHek+fIU+vfIPzTE+3sL/VCufQhYjD4fvQa5GXgZ/Tb0M+h7Orgm
vX+PXQ7moz+H3qYx3onzfTD6c4ztfNAb/Z5KjN2A9LzjKnGugWAE+g7c/4/c
+3LQl/t/iPbPafsMzEzHO1Zj0/h7/869FuBZ9DfROyB3TPd/LXoL+rb0G0Gf
gT4JeTKYjn45+nfc2zLQF31kJfq2SuO7AH0TztU+Pf8L6Fsgb57e596MfZmF
551a5hby97S/4LcEGnmW49Gv5twjwOb0X4x+BG1Hgm/Rv0a/CflmUEf/byoh
3wLq0b+thDwWNKB/gN4L+WDwNcefij6Lcz8IdkM/g/nwt+OPnjk/uKfj0I8H
5yPP4BxrcK/NwZasj33o/y1tPVkvh9N2GdgUeRPwKePfj/PfzrnGg20532n0
X0b/B2kfS9+u6N83xno7qSnmb2f0XcHn9B/aFOdqDz7mfJfSv5b7GIq+Atcf
RntH5A5gCe0DqrE2u0afirwxWIp8INdfm/OdzfnfQ14E9lXn+L+Y+3+CFzj+
XPQC5/oH/SX0lTj+Y++F39pwvfNor2kWfV6h/TzON5tzPQQO5nwHoOfITWB1
9EPQ/4O8GVgfvTnH78vh+4D2HL8meg/k/cCm6D3oX0/fBrAq/S+lvR3XagsW
094Cff9CHLMZ+on0v56+14Et6d/H9418M9ja9cU5wbFfg425/5N5nu8aY/xG
0/Yw+g/oq/M+70Ofi74S47s7+qPI4+1D3zlgNY6/wvWQub1WQ8z3i/x+udb3
aT86Df1K5KvA7ml+XYY8DHRBH1CJtuFgD/TP0Ydy/cvSejuO683mWrPAylzv
K9qvo+161xDaPkE/C3kQ+IX+S9AvRL4o7QcXux9y7l/SevEix9zDs9wNjuB8
H9Pej779wU+0f4k+ujGuUUPfl8CU2jjmGPofR/vhnOuI9P2dgH4c8vFpvIe4
XzEWteDIPObD57R9BnqhD0K/B3lKmm+L0Ltzrf3AF+j7MsbLkX8sYmMoM/Y/
o99P//uRz6/E3JoDDqF/L/r8RPsB6O2QT3K9R+6X3vd7lTh3D/AV+gXoX9C2
NB3f1/UTeUD6Hn/mee9m/bkLXJ/F9ez7eZrPd9H+Je/iC7AR7Xc2hbwUbIB+
APfwY1ovNkQezvHtGYt2DbEffoc+j/an0vozEP1R+j6S3v96HPMZbW3QK+gP
0j7DtTrZRwcxBk8xNiPBPcgHlkI+CtyNfEAp5M3AXciHg4s5Vw8wHflQsD/y
emAacg/wD8/6ErgD+V6uN51rTUv21mzHG3lO2i+Ops9ijr0PzEA+shSy17gP
+UP6X8z9D07r6Yn8tn1D2CzaLo+CuciPu+cj9wejkU8EDyH3KYXsMbORDwbL
i/HMU0rxPs/h3Gen+fI++rmN8Zvv91H0Vzj2VfBwHuv/k7Q9kfYDv59HkB9O
81t7oDN9dwVX5bE/+G6eTPvFjehb0rZVsj/8Pjx2DijQflwpbDHHZKZ2A+1d
0Lum/Xcu+tvI7zSE/ab9sEtDXFP745BSvAufcWop9m+P3T3ZA59qz3CtW9P3
/R7XzHlXGTiX+XYt+qHMvUPAj6x/j2l/cewf6flnor+GvDDtz37vozjXSL8x
9P1LMVecA3eWYr/WFuqW9vf5/HY/fWeAS5CX0T4ReVLaj/cqxV59JxiPvI/v
uy728AnIR/g8rn1gY79vfutXF30mIq/MObZkKLcA63L/e5biXGeB21x3warI
S9wfkWfzfZT4f4k2cjXmtHPbOd0buWsp+j4AbkFuX4297lJwjM9WinN3AeOQ
u5VC9hq3Il9G/7pS7MfrZbE++20+nNbv7rSNrYtnmITcGRxE3w3BTcgr8jz/
ce8Ca/E8KzSFvAlohb49fRawl44F1yNXm6KtPWhB+43ol3OuYaCe63/E9S/n
WYcl+2a/Unyr3sNk5JWaYuw2B+tw/M6luJdfOf+NyFuBU5H/C0Yht3P9oO9N
4CrkNmAA8p5gmL4F59sYeSPQnPP9l9+GNItnvBl521Lcu+e8DvmUUnzLfsMP
I3cAzWn7huOvQb6U+3+dsXujPvaDWvAb820+2M25wfXWon8rcDbXu4pnPoFn
2wp8RdsV6IchtwNfoN+M/hjycPA7+hj0GcgXg1/Rb0J/CHkY+A19APo03u1i
MBD5HFCk7XX0RbQPQv8deT54B/0M9C+RHwJvop+O/inyDPAG+vnoq9bFbx+g
n4X+E/I88Db62eg6zi+jv+v64fXRzwe/oN+CPg95FPgDfRz6rcivgFuRx4L5
yDeCP2kfmcWzOgbfo1+bxbP1BMvQR2fR1zFbjj4qi3MfDX7QNmU+NwczwQPg
mizGaj/wHe1non/HvT4G3kK/wT2NtrPAT+gj0AchdwXfoI9Hf6cu+vyNfhv6
637r4C/0K7O4dgfwJfp1WbQNAD+iX53FWOwFvkUfnkXbLuBr9FOyeDcTwEL0
89BXoO1D9Pf9NrJ49g3AUvde5sxO2r7gCvdm9N20zcCV6EvRt0Uug8td/11j
kFuCq9A/Q69F3hx8jvw2+Mb5iP4O8hvgI/QV0d9EfgrMQV8K5iHPBS8i3wZO
4XxPoi9GngFOQ38cfSryIvAE8j7aY8X4BlbSn+C3r2mbCwbQ/2v0dblWD/AN
8nLQS1sVXE37W+V4ts/pfz76YHAReJ/fPwCXZPHtOMc/5fch6Ksh7w6GIl+a
xVg7pktoH5bFXGgNPtdfyeLdtACfoV+YRZtzZDH6BVm0+Y186LWzeBd+Ax+h
X5zFu/cb+ET/hXtah/v9gfu9QHu1HPa7/sUQ9H6gL3iE3x8F2zA+4xmb28Ey
zrVmNeawc/dBMDiLtcBv9mOOe6Yc534aDETf0/WCtnZgDno39O7Ia4PZfg/0
3zDclUKuf59iEcYkVqGtpfdHG8tVoUL7OqVYG9uA1q5vtG9lLAl0RF4dbIDM
KQqZaz9690KsoWugr+ceUIhj1kf+kXP85vqova2txjP9hvwJWLka9vnZ3Os5
yd7e2DWYY9cGq9C2AXpz5B3BhshrleLa3sMQ1/5SrO2u6a7t29BnIPItYD33
mlKsze4B7gUX+71wghbIz3H909HXqInfutF/81LsHa7pru1DmLMnGfsCd/Ku
dijFXuOe5t52IMfP49zfgW05/oFyzO2R4ETnC31G8KwzjW8hn1sKX3pHbWLk
waWwNYYbf0AeVIo2Y2zG2s4oRaztK64/1/0FvN0YNoq2ygWlOFYfXV/9QnBC
Y1zTa+/BmB7E2LZxjed+HnTP5d6eAbOQD89i7RngnkD7LPuAXfn9v35bxhOY
m7eAb9G3d//QH6d/J+QdwGbI//DbTI7b0f0GfWuwE/LW4FvaWqNvg7wt+FHf
AX075Mf1OUF3v0twP+/kPrAbche/TXBUbVzjYfrtg94PeXv9U/S93T+RtwKP
6Ftn8Sy7uMaj7+J6itxZIO+cxbFl8ADtB2Yx97qBp9CPz2Lvuxi8jH4A+h7I
54GDkJ/ntwXgSO8LHOJ+VRvf4NP8fpj7U23c07Paqugja+MZnkHv6XMiXwJ6
Ifd2D6yNZ3qO9oPRL6uNdzbP9SKLvdpzvop+bBb34h5/nM/u/ui3D040HuN+
6L2AvsgnZbHXeY+vcHx/919lcDLyk/z2hDEI5P3BbqWwJbWBtIXO0CYAzzFX
5oNXwULmTjPaF7r+5hGrvNqYYCW+kTnavOnbGQwOb4gYsrHk1sZHmUvbgxez
iHka+zRGORx5mD4q8o5gkP4XKCFv7TWMfaH/XR8+pr7m2eg7I68E+nitPHz/
NvobtB+WR2zCmIWxizPzOPcK+mDIR+Xhu3fQfzF2gn5jQ9zD5cir89ua3GsL
8Dj3e1Y6vg+4uRIxUWOj3sM5yDlzNwNvgrfAdYzdB42xp9VyfGd+2wX0A/31
342fMVYf+90jr5WH/W7MaiP0pmqc03O9DU7LYyyMERsr3r0aMTRjZ5PBrWCx
8ZQUP7nImEFD5CjMVZyXh69jDNZY7IV5xPqNaRvbXtP4K8+6gT4ox7+QR2zf
GL6xfO+hjvf+WinurQfYDwwCZ/vdcv2Wrq/gLPr1z+NdmFMwtzAxD1/7Xf1j
Yy955E70wfXF7zYmi3y944s8VZuhId7JWOQ7wZNpPb4JeUWOqeVe68Ac7vf6
PHIVD4D7aFvB+DNtzcBsbWXalzXEOachTzEGjfwteIS+9+bhO+pT6lvenkes
W59S3/KGPOb6w8Yn0O/L41nMWZi7eCCPWPMK+tToq4Aq114BPMr159JebowY
sLHgR/LwXY15G/s2Bm0s2nucYzw5j1yDMXdj71fnEes25m/sv18esThj+sb2
n3TOGotAn2X8LY+57Td4g7EYY5C0f2O8AfktsEtj/PYM8mN55F6MWRu7fjyP
ZzGnYW7jTb+3xrjG076rdL2djG9XIsdirsWczgLkGXnkunzmJ/TNy2EbZszP
15F7MmcOAueC88CqYBUwGdwBunDMAsbued9xHj6UvpS/NfNZGNMrOdcjYA3k
tuDRZrHntENuD5YjPwXuYW6u7hxoFj7nbei/cg/bIfcBvyH/Ay5C3g+Mov1v
9HOahQ09En1n41dc+zHwK+f6k/YutJ0J/kL+XZ8U+VTwh7YM/Z+h77NFDTDG
lWN+o20+mKL9hF7HWvw6+jT07eh/B33vBD/QtmkWe+vLYCrtO9B+P20zwE+0
/VwOW/4Y8AvyT+DgFC++hv4vov9hbBsMQn8Z/W/kl8E52nuc41363g0moDdm
ca5RoIS8LvgQeTqYSPuGWcTCjc/egd4BvVobfe5F3yyLvdVzTtfXRR9nrBys
jdwSjEFeAFpp72ZxrXmghbZ3FmMxEdzO8U15xAaNEa7LfGioRg7W3OutoOx+
S9+TwBj6f+/3Sd8TwRLjP67xjRFTMLawLA/bSBvpU+RX8sjNmLM1d2uMyFiR
ObSlyB/mkcs15mbs7aM8clvG/Iz9daqGbauN+2sl5q527aQ0h1dLc9q5fCdo
AT5tjJi7+eX7m0J3TM2neI5fwPbVOHe930xd+Jz30L4wj9yROTZzba/nkWv0
Gd+uRM7P3J/f9DvulcZUG2NMlucRwzOWZ0zsZ/Qmznmu3waoIOdZjP0Zxj/o
m7lHI59ivAf9uzxiM+ZIzZVWs5gbfjO30P5DGv8HjFcam+QZFhvDAT+6f6T1
5iTvD/3LPGKbxvyM/X2TRyzVHK+53j/zyMW+5pih/55H7tccmbmyX/OIFRpj
Nta8eTl8heONsSFvqb2P3F+fBHm4/g7vqhcYoW+UR+y8k/E0jt8gj9j+VuAw
9LYph2TuqDVYB2xAW09jynns187Pg8C6yG3BWfURAzQWuFEesfbO4HD31zxi
g809B/pqeVzLnI+5nxboeyO3Mn+A/hXje10x1pBvkFfJI5ekw9ad9iX8Npq2
p8HXyG3yyFWYczL39D2/vVoMH1Nfc888uAOjwenoA/OwhbRptG3cT8xdmtM0
t7kl2MKcAOf5Igt7Tu7AZmk/0f47uiFixsaOtTfM7bd1D0/2hrFdc6jmUpvn
MdbmyA5I9tiKtO2U7L1T8jjWnLq5de0dY9GNyf5bzj28VYw10rXS/c17aZbs
N+3BlRsi5qw9pv0hF+Dn+rAHf+T49409g07OF9DR78Z1DXyXxV6jz6Pv047j
z6+Pd3KUOnNmb4b/dOOb+pflyOWdYfwz+dvGEs3xmevTf+5diJjv+snfbl+I
HJ65vM7oo5H7pfmpz3ol38oGyZfd2TlL23FpPheNsTRGztfcb0l/pDFi1Maq
N6JP60LMef3nHdCHFOIe9N/11801DjJ+ajyA57upPnJI5pK2ymNumOMy1+X3
473pk+ubb5FH7s6cmLmxHfOINc8Eu/pu88h1OWYn0z6oHLZgV7CX/jXfUkew
s+tAHva+775fsrc7gyEc+wD4L/IaeXw7K/mNcb5ueeTCzDGaa9ze9aA+vrn+
6Jty7k3Apvz+H+dGuj9t6mNp75DHt2tOsiPyduC2+siJ9U3rh2O9Q4o3mLM0
d2mOt6u2G8+wkLGektajxVns1WeBTdA/zCKWcxpoj/4E+p7F8CH0JV7VfyvG
b+ujT3W/LEaMsRF9Sha2rGu+a/+0LGzHD9FLrqdZXKsLWA/95SyutTNY1/mQ
x9qyFH0v9HIea8k36Hujb+wc0Y7zOwKv6W/SdpA2v/uJ/izyYWBD9IXoFyPv
B9qgLzIfYZyQ+dka+d4sfKMvzdHQPhn9p7qI+dZqyxgvqIsYb52xBPkFHPsX
GIPcNt2T9/I2eA8sAu9ol2grZXHv2lzaXh5zI7ipGueaQXu7YlyjQvvcLMZm
VbCatlIWvoz31IT+MPoWxfAZ9B2mZ9H3U3M42vPaIOjfoefoj2Uxttrw2vKP
ZOG7+s5WroRPoW/hOR/KwsbT1jPmWZOHfyX3Sk6S3KSX6NO3GD6wvvC8LMZe
n0vfa588cgf/zmn0vdFfro85eiZ6d/2N+sgpm1vWv5V7IidMbtiXnK8nY9sL
vCh3IQtb0Xf4H9o/QZ9djHe+mfZMFmuhc3JT9A+yiPV4j+3QT+L8n9bHmqp/
vVceXBzXjDNoPyiPb9U+PfPYK1xTXUvdM47TBquPNV5/+9MsbGfnWAf6vaG9
WYw97v0s/H3Xep9xKO1PZzEXfcct0evz4Ea4B3RDL6LX1Mcetzt6Yx5rxcd+
Y/pDWcxd3+ka6GuBVtrk/P6saz1YAJ4zzgLWr0ZO2lx01WvlweVwz9ijEvEC
9xpzPOZ6fs7iWtrk2ubGH9xr5CzJXfoli2/RMd+pEvELuWK+00sqYd/+VAyb
YoU8OA5yHR4FtcirlSN2u2GKtxoPdW1a3Xgn8vHmQJGXghOQTypHLNKY5HbG
i9BnI3/sHoJ8NLgPeRE4BvlQ8BzyOHNq9D8NPWet/siYK/oAOTDon6PvZL6i
HMc2mBMrx/6lbXUd2DXtV9peI8AuthkrQP4HnOxeYvwa+VnQifP1QV+G/DTY
3rga+l2FOOYo5NuzWPvMKf1D+4QsvlVzYAXGb2IWa485sJpK+Lf68mskf1Z/
QFvzmmT/av+fmOxhbVU5IHJBRid7WHtSrpQcE7km+gdyC+WwyWUzRmis0Jjg
ASk+IjdUjqdcTzlsctnWSv7vpCzWEnN4zSrhPzdP9rm2sPb7No3B6ZPbpz/u
vXdO9rv+h1wOOY5yHbX/5abJCXw+2cPmpuXAyIXZkTE7gqG5zPdl/rUctok2
ytrmM9CbeHfbgguRzy3Hu9EmPk9bIcXHjYnv2RTYA1ya2i4CK9O2ExiMfD7o
gFwPdjefUo693j1/b/NX6Hsirw321bYx36MMrkK+GnSUewiuQR4J+iDvCPan
/7XoxyJvA3qgz69G7L6leWXkc8oRb/qeZ+hC+w3G/9G7gJ7oY3x+7w0cjD4N
fTzy6eBY48XlGCu/ie7adj4T8h2OGfL+5mkKYaO1p/9+5ZjbflM9tA/KkWsw
57C+Y+WcRT7bnDL6tuWwFfdO9uH4cjzrcHA78ljzJ+aKwK3I94ILayKHdh/y
TPCQYwVO4Pj70YcizzTnhjwJ3FATY3Y47ePK4dvY5zbkCdoz5sLBxHL4r3L/
5DjKddSfk3slp3Bx8r/kUskRlCvo+NzLvQ9N82l3cGv6fjum8ZhVCBvV790c
yNXyEFJuxDXBteGxNH6uV64ljun+aT16txDXcPxdr1x7ZqXxNb4ml2Rqihf+
lUcuZUTyL/Vv/bZngX/yGP8JHPuC9nRTcKDlQk9O7/Ng8Ewh5ovrjfO/LWPz
9/9bn+SOmqPvmtYn+zrHjG26hrqW+g25Pvp9nZnWzw3R1ywHj9x8mNwCOQqb
h9tdaI28NuDfv5wJuROu2a7d/35TTREv+7AhOFByoVxv/bbeTeu166n3ujCt
j67BrsUd0/fn9+m345rt2u337rfjmu7abo5rJO+mYylyXz3LsfYuS/uF+8H8
QnBo5dIaD5VbJOdV7qvx2DHIz6T4qfHOJQ3BmZI7NSaP2PgNKX5rjNZYrTm0
uyoRPx3RED6j+QLjq3Jp5aDLRTc+7LuWAy8X3ni8vsGYFP81/in3V86R3CPj
k3KhvQfjrcYLtM3lFMotXJLW+51TvOGTPGKVJ6b4j/EhubTbpPiJ8Qi5hXL0
5OrJQZWL2i/Fg4yvGjttnuKf9+QRr/a3hyvBIZBLMCjx6YxHD2sIzr3ce+O/
crl9x8ZDJ+XBdRuW4tXGvx07Y9LGpo13Gwv3Gl7rjjSexsDvyiNeK7dazpXc
KzldcrvkmJtPMb5s7YAcMblis9P9P5Xi3caX5f5bI2CtgPF4aw/k6MvVfyKP
WLIxXmO9k/Pgxo1I8W/j6c6F71O8elbq/2QaD5/PWLw1D9Y+6N/LDeyV4gM+
g309Zk4l4iPdsIXOlj9TCf7M79hHbdH3TfZfI/I2cqCS/ddMXw7sl+y/lfVF
k79ovGEHfcMU39GeqyDvqE9YCf/SvgNTfMb4jrGcNske+yLZsSPZa0ZVI8Zi
rEWbbddkb9vHttHgH2OyKR7zv3hNB2MH4NBKxHu21rdO8SWP+bMUNrvn0l9b
i7Z9UvxHPoNcFDk4cnHkDMgdONN51hSysV1jvP4mR0OuxurNgi8hX+OlmuA4
y3U2/i435N3EzzAGbiz8isTv1X9coz7egfEp+SByTeR4yPUwfiw3Wo63XG/5
Kityb50Tv0K+UT3y1omPsaAceUNjmsY25S8srwnOxwUpPi03Qo6EXGf5KHJV
5IjIFZF/7L0Z42+eYjTGaq5j3K4HK3K/G3GvvyR/a930/oYkf9/4hlzoBclf
MV5wB/Kbyb/Sn7FNzrDcYeNj8+qD0yy32figc0dOdZ/kj71SHzlI7Xfjhb5L
OdhysY0vDE3xQOODxkvk7st5lftqfEWu9rwUfzO+dAHy1BQvMV7oXJQzL3fe
eN6R9VEDYC2A8cVB9fEMxjuMV73As/8Juib/0WeTkyw32fiG3PtXkv9o/Ozt
YnxD+k/GBxcW4xvaPfkrXxRjDhg/WKsa3EM5iPdUwx//thhz1HiC8bQPivFN
7ZH8U7n15myHJv/ok2J8k3smf/GTFC8yvmM8R66hHGW5ysaPHAs5+nL1jRPt
BLbk2ltVI8bksfqU51aCYy3XelaKzxg/9dtxTI3XWRNgbUBNylebczL3tN3/
40ft1Sxi4OZ35EfIrdGm0rbSfjwTeQI4jvbp6PfIRUr2mjacttyc/2efyYUa
kuwv10tzhdagWItifmUk1zo65Wu0GQemeOJu6KPBAI5dlfF+nue9W3+oHLyh
/k3Br/LbnZLsQ+3Z21M+59Sm4GvJldJm1HbURtRWlNMlP0sbUFvw8cRPmVIO
LpecrpObIgdmLmxMyqfIpxiIrzMx8UPkhVgbIGdH3oacCrkVAxPfQr7G0bXB
QZDvII9DHsnjiWcgp8PflOUe2OY5PZd9zJmZOxuX8g3ym3pzrhGJXyHfQa6i
HAm5EvJB+tcGp0H+hBwSuSTyNF5oCn7HubXB6ZfbL+dC7sXMxO+QTzG1NvrI
75BPciLymMTf0B/pWxOcGe1rOTNyZ5Yn/pU+kL5Q3+SvyJmTO7dz4ufJ/7J2
Rc6y3GX5buYW5YjJFfuoHLm6gxPf7cNy8Nr+0JapBP/NtbxL4veZ3zsk5S/l
zsrZk7u3V+L3fV8OroGcg0I18pPmcuQIyhU0P2kuRw6hXELzn+bO5AzKHZSD
JxdvcMp//lCOc3qummrkG527HRN/0JyOuZ1OYE45+E/OLTmFA5I/qO+lD9ar
Kfy9w2vCZ9R3lIO1Kv9vmbhZbbXJudx5YC/0jd1TCvHbnuXwqfSt/K1bOXxY
fdnjkn9ofqdnTdj0//Nn9V0PpO2g5MfqG+ojHpj8073cG8Fh6O2a4tr6gPqC
1kRZGzU0xYtv4bfz6LtP8l/1t/zWe6Z8kv6W3C99Vn1X/T19t8OTfysfq2dt
cHbk9xin3gRsxjh0qEZ8bK7xR7CL9ot7jrHcxD8x52Pux5jXynnUP8nFkdMp
t7NBG4m+xWLkC+Uc/pn2f+unfAdnJP/3+nLUV9lmTth6rRauqRzbsxj8j0Np
H0TbWeAm2lelvbP3lvgM8is2R+4IZqKv5B6HvGUx+Bi9m2KtdMwcu0Oa4lyu
qTeWY8wde69xM3p39L1r4p0MK0cO2+9D+0C+/zqcvz/n7lcM/pDxwd7II1K8
2vqtVzj21ZpUn9UUspwluUvmvF0r7WN9lznxF9L6Z/2X8cIenOuSFO/+qxJc
VL+pEU0Rr3VshqV4ufHgTsW4J+9NTqzrqTGGx/T3+O142o4DL9B3QClx+RpS
bYj2HW2DUjzfeLNjOyDF880f+O7PT/kC49eOref03OZUuqZ4xyVcbx/jUyne
MRR9C22wQvh0h5TDZ9d31wfu5bfDOV4rhg0g/3R79HeKYSPIP/D7m1gIn9rv
rbXvrxA+73bpe51UiD5+n/I1/iiGzS4/Q5tE28Tf5G/ok+ubP29Oyu++KWTv
8TD0dZsi1jCkELkr+RPadtrU2tbm3E5P8Zaty5HDMpflPXVybW2Kb9M5dEU5
fHJ9c2MWXdG35nwvFsNmks8oP3nj+rAhtSX1MfQ1/E2+8qlpvryU3qd75L9z
BTxcDh9CX0Ifw3o/fRJ9E2186/dcT4w9TErrmT6KvkqH9P0e0xRzxTlzTzm+
eb99bSz5Jcc3xV6vzaHtsSPtnxbDppL/oU+hb6GNaH2hNoq2ijbB1HL4UPpS
2ozWozzIMQ9kEQM3Fm7+pmUx1hjXGvMhqxVjTpo/MT+VFWOOm++Qfz8G235B
4uvLn7d27N3Ejzf/8zPyhsXIt1gvZj2fnBvrx+Rky80+O/Hr5ZDIJbGP9WTy
sfem7YLEl5e/rW8xMPHl5UO3R+6d6iPkY2+I3Cvx4+Vvr4PcI/G75c/bdnmq
H5Cv3RH5mMTXlz+ur3Jiqr+wXlIukRwiuUTGb5fRtk4x8kHGn5fUxRiZL7J+
wbH4I+W3rHd4ui7GwPyXNQ7WOshBK1aCT96yLp5Rvrn5mIeKYXObH7DeY25d
XNN4sfHtr+riHZlfsx7BsfadmC+0HmRmXdyT8XDzbd5L+2Lkw6xHmIj+RqpX
MJ6+GHnFYuQTrWewzT3DvcN6kjl1cU3j6dZzTK+LY4y/y593bC9J9RTWq/gu
RtRFvYb1GKPrYgys9/gq+cujU37H/OiEYqw5rj3mT+8qxprj2mM+aloxfArz
8/NTbsYcoblC81Nji/EN+y2bIzRXaN5JroL5NfeGsSl/Zf7UZ3XPcu9yDXYt
ds8yX2e+z3fbI+WHzBc6d90D3Qv9VtzbzFH5zZhvdGx7p3yU92YeyZyq92gO
01ymnALzYOZ7Xbt9JvNr5m9d631m88XWm/gtWINpLab1Ko6t79T6HutH/BZ8
B9bTWB/jWDtHrAeyPsa57Tuz/sd6FOe278B6GOuLnNt+s9bLWH/it+ScsD7F
fLO2gnu2e7f5ZPce35H5a8fWZ/JZHOPOyf8yp25u3fywe+XMYuQXzSe7Nzqn
zS+af7TNNcu1y/yye7U2jvk/+dByra1ZsHbB+P3paf90bZRfre0/N/GXJydu
VfNUJ6F9YS7BGLqx9Gb0r9HuoW2oPiNy81JwrORadUr7nzkv/z7AbfQZB44B
x4INQJvEa92/Gvlmc9XGaEYnHtfkdG1rNcwxuPd2TfbUI7aV4prPVCPn4F7c
Ldk7xomMJd2Q8thnVqPm3lr7HCyjz64c+x3oa3wji9o8a/SGoa+fRa28f6Pk
ymrYZ3vURI5F+2mlLI6x7+XVsLe89h7JfmvFNQ6zrhGcI3+uGue3Jr8L8rXg
11L0se9E9AnVqNs4uhr5YLnWn6R874X8dgHYoRr8ZevHVy7FGDgW98rnLMVv
jzmmHNMDbIO8LTiyKXxdfd47y8E3XNwsOPvyCa25lxvn+5M7t3o1akesIfH5
5Y9+Yk2EHDPkzbOoZfeaj6PfLoeuHJxluctCLvX41OYYO9ZysOViO3esjfdv
DDiHLgaD5atUg7e9VzVqnf0bCaenOfMlfYtpLt2cuAnWbT4ELgG/lOKd+m7l
LMpdPBwcUQ3+5SKul9UGX7JZNa5vjf6uyHdVozbcGvG7kfvQ5yTwUDn8rVbV
qAt9B7xbDR9KX8oYv7H+On6rBa+DN9L4H0vbO2DrFLMcleaic11Oh9yOxnKc
7z2QIy/lt0PTmI1P34zPe4hzvBqcHrk9BzRFfs4c4iiOu5HrnVyKmgBrA8zZ
mbtrBV6oRrxD3WM81t9s82+S+PdS5EDJhbrcnF9T5JTMLQ0HmzTFM9Xw28JS
PKs5DXMb14Kdtd18BmtuwLF5zBHninPcue7fd/B78m9QdEvPYO29Nfg+m8/s
s5u0eQ15IfgN/QhzXJzvffQqbV95jWrkFE9P/q72l/fkvTmGjqVj7tgvAa8i
/12Jv53h39DYqRr1KZ1qI6ZhfctVab5ZYz8ceZE2otwZa32a4h0495zjvpur
q/G3AfwbAdekOeZcs4agKUHu/helaNO+NPdozvHe9M6dS2unuWBO1fyXOXvr
VZ3vrpVyWldLa4Jrg5xXua+OgWMhR2hR6vN6Kb6R/x17dOrrObT3rS0zZ23u
+o00V+X4yvXVnl+nJnLG5o6tObL2qHeqd5vh+HPuCphSDQ6rXNZFic9sHah9
bJtajZo6a+umgenVqF/qUBsxK+uLrJdxr1mW6kOtqbG25qtUH/tvTVNtxIis
N5IvO4lrvZH4yvKd5WrLmZU7K99ZrrccZbnK8mXvbRZrnHxq66UN1TjFrJ+e
nu6tq3ZyFnx0YzH3Jn6tfGm57CMTP9t6X2tFp6Z6oKnpWa2hspZqlSzsa/+G
yQrV4Fd7r9ZoyTf374+0LUQNoH9PZNUsjrHvitWo6TOXaR//Pok1gvXyPwpR
v229lLG0Jale2HqlBch/1EZ98ebJ/7ot+Z/WD/9cGza79ZP+vSpz7XcW4u8N
WY/sWGsjW29pfewbtZFTsH75VNfL2vibAP5tAOutjNUtSPVR1i97L9aAWq9s
DbS10OYorKf17xt5LTkmck2sB/Zd6zNY72k9c01d+AjWc1ov7bPoc1h/af2U
tc7WbFm7Jf+gVdrf9b2dWzPTXPM9Wl9n7NRnsL7XmjFrx15Dfr0pZP82ic/k
b9ZkWZvlPVhPrf/u2I1P/rH+svLtyX+23stabGvMrDWz5svaL8fY+mzr7X1X
zjHr8d0f/V5WLMXfe3kirbctU7zZ+j1r6axJsDbBGj1r9YxZWT9o/X0lwoH/
/v0C+f7uXZ1SPZ01ftb6WeNm/amck30KwYc1XmA9nrV51gxYO2A9oLWJ1mhY
q+HfR/Dc1pBaSzqvGnuB9+i9Wn9oras1FNZS/Gvf1cbfrNHeknMi96Rlin/I
b7e2wRqOv1N8qXVNrCnGB6yvKNTGGmD9ovaKa0k12Q/+zRz/do5/A8f6EuMf
Pkv3FG+wHsK/heLfRPJvI7nnz057snuzNQ/WPngN6zfqsqjNskarsRr1kdbq
+jd6rFexJsLaCGssrQ+xJsLaCGsmrV95shp/q8sxcWwasvjbCfrP/u0ca3zT
5f79ewbWu/i3e/wbLv4tFzk4cnFap/haMYt78l5KYE415obPP6saNS3WtkxK
9QD/B3bChIw=
               "]], Polygon3DBox[CompressedData["
1:eJwtlndU11UUwB+gwPf348dzJJTHkeFEEfE40lw40hylhINOhYKmuBVwVg5U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               
               "]]}]}, {}, {}, {}}, {
           {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl1GWUFlUAgOELuwts0CGisiwhjZQBCCqKYBFLKiiy0pJKKXYABhYWKCAd
SiixdOcuy9KthGBQoggGKj5z9scz771z5nx3Zs58NyWtf2q/XCGE6FAiIYRo
XDo+hNdJZiTlGEF53uBG3qIyb1KF0VTjXW7iHWryPrX5gJspbo1b9UNuo5h5
phbWIhSlvnkh3abfkcXtbOcYR/mEO/idSxznHGO5i8tkc4Lz/MLd/MGP7OAq
OwnW+kmTdJfm0hhy87P5bmKN8xDHafM95DVO0rqJ3l1MCM20acS4taYyzDhN
Z+lAPaTDNTHWM9GXCUx0Lltna4gLIV1raYZmkmZ8WI8wxjirYAgdrN2ef/iX
/8jvngqQj73m8XpGC+o+TdD9epYLdOJPDvA9v/IbnfmLvznJRb6hC1d4glMc
pCuH+IHDJFqjux4hnV58y5P0YRn9WMEAnmYQaxjCMzzLBp7jRV5iC6+wMJ/n
TQphkS7mqnG6LmEpy1jOCmLyh7BSV7GaNcQ5t1bXsZ4NbGQTm9nCVjKId22m
biOL7WSzg53sIsE1u3UPe9nHfg7wmvvdyqtk8DKbeYGNPM8mhrOeYaxlKOsY
zGqeYiUDWUV/ltOXpfRmCT1ZRA8W0y16X6SxgMf5mseYx6PMpyNzeYQ5PMxX
tONL2jKbNsyiNTNJZQatmE5LptGCqTRnCg8xmQeZxAN8wf1M5D4m0IzxNOVz
7qUJ9/AZjRnHnXxKIxrSgI+px0fcwhjqUodavEcNqlOVt6lERSowirKkUCY6
569YnnKUJYUyVPJ9J0f7JDdwPddRimspSQXXXKMlKE4xilKEwhTCXzgUiH7T
tT6h4DMOiTnbUUh2cAvBJxTykidnWwix0TrR/qS5Q86e/T9zTb0T
             "]]}, 
           {GrayLevel[0], 
            Line3DBox[{2582, 3339, 2583, 3351, 2602, 3349, 2603, 3357, 2615, 
             3356, 2616, 3363, 2628, 3375, 2644, 3373, 2645, 3385, 2664, 3394,
              2675, 3392, 2676, 3401, 2690, 4040, 4041, 4042, 4044, 2726, 
             4039, 4035, 4037, 3423, 2727, 3827, 3434, 2746, 3828, 4048, 3830,
              2762, 3832, 3900, 3898, 3455, 2779, 3965, 3967, 3902, 3945, 
             3947, 2800, 3971, 3839, 3906, 3949, 3932, 4051, 3931, 4060, 3844,
              4053, 3847, 3998, 3935, 3853, 4056, 4002, 4000, 3940, 3862, 
             4008, 2868}], Line3DBox[CompressedData["
1:eJwNzCFLg1EUgOGjA8PcNDk+F4TBMKlg3MQwUBGEBRnf0gyaJuqSiyKCNpNW
EZNgWRsaJytjVTD6DzSJIAaf8PKce+7llvY7uycTEVFXMRuRz0ckzHGeCZdY
4DIXWOEiN1nmFleZcoVNVtnmBk9ZY5c7vGTKGzZ4y/FsxEBDverJ7tjdM9t8
4feMv8wj8495zbtffjj/8ZNndus61LW3X3bn5gvVdKSOJqcjrthSRm+a0p32
lNO7HnSvA83pUUX11dO2f/4BvVYndg==
             "]], Line3DBox[CompressedData["
1:eJwNy7FKQmEcxuH/GVqSPBUtpqYO0VbSqEFBiBJOomCbnDHCIgJbIxva6w4i
amlrbNYrcOwi2iKInuHH857v+04tu+iNk4joq7IcsbYSscVVlpmyyDxLLLLO
Te6ywD3WeMAqG6ywyR22uc0O9zlknads8owtTnjMG3Z5xxNOOeATM75yxDee
85MTznjNOX/yEbf2l/1rH6YRf/z2ndiRc88jjfXobeLs3l5SS5e60rrzB46U
00KpnpVpQy8q6EPvavvnH1u5I4c=
             "]], Line3DBox[CompressedData["
1:eJwV0EsoJVAcwOFDDHHHgtXdeZadxo7CdkoiCytRLGbhdq+VbJRJs/GImGys
uNfWo9iZIZRmNoNI8ipsPMY0C49E+Sx+ff1P53ROp6gj0RxPCyF8U2FOCEXK
/xhCMQtYwlJ9UqVqVGy9lnVqVJM61KmEuvXZnj6OakzTmtEX60vc0Kb6zAcc
4jVf9KopcyTXGRZyjhWsVZ1WzA3cYit3GOMhe3nOr7ziIP9znM+cYnpeCLOM
cJFRrrOMu6zg+ft9vGcNH1jP7EgILYyyjeWMsYpdrGYPGzjAdo4wzmEmOMl+
pjjBJL9zgUnOM8Xl9/dxjT+4yp/8zT/8xW3u85R7POMJb3jMKx7xmpd85AWf
+I9Z/uSOH/iXGbxlJt8AKv1PoA==
             "]], Line3DBox[CompressedData["
1:eJwV0LsrBVAAx/Eji9f1B1yTATHdYlMeuxSLSR5Rluu1yELERAphsV33rkKY
JKEUC8pr8OjG4FFYhJLPHb59+nWWc05xZ19zb1YIYUgleSGUqkyVqlKd6tWk
ZnWpWzWREAY4otHMmT3LhFbUY29ykIe80rWm7RfO8Y+R/BAKlbCLucoYN1nH
HTbyiK2Mq1c39jDTHOczp/jJef5ymdmFIaQY4TqLuM8oD1jKc8aYZi2/2MDc
ghBaGGU7y9nGCsZZzSE2cpLtnGAHZ9jPJY4xxQUmucg1JrmduRe3uME97vKE
pzzmGS95zws+8I6vvOUbn/jNR/7wgzn+4D3zDv4DxuJIFg==
             "]], 
            Line3DBox[CompressedData["
1:eJwVzz8oBFAAx/GnTP4uNhYWxGJgUjizyC0m5Qa2u44Fg3BlUgqFYsOt8t8i
KcrAgEEs6Iryr1jIFZ8bvn36veW9VxlLdMfzQghJ1RSEUFYcQi0b1aSI2lXv
PMp+DajFHuS4JhS1Z9nLNe5qT0P2Kcd4y1e9ac7+4zJLC0NYZRU32MA2RXRo
d/KMvbxkgnccZYYpvnCaX5xnlivMLwkhzRJusYInrOY1G5jJ3cdvtvKHHSwo
CqGH5exjHeNs5gg7OcwuTjHGGSa5xEkuMsU0F7jJdR5wm/vc4TGPeMErnufe
xxs+8oHvvOcHn/nLJ2b5mXuvP/8DmfZFjw==
             "]], 
            Line3DBox[CompressedData["
1:eJwV0j9IlHEYwPFfFCFXGg3aUoFeRA2CBDZYU2gRN2gXGOm1hP2xIh0ishQj
BLs7Sy0iLT2FaNErE4fIQXMIRBSEAtdr0bYgF3OIPu/w5fM+vA+87+/lLb/a
lry7I4TwRck9ISwUh1DH6X0h5DWjz5pVQgeU1RE77+2ec92ruHk/SxnjWRVp
l/mVvZ18zc1YCP38yScssIcrfMBldnCebZxjOz+yhR94jcO8zCE28Q2b+ZYp
plnPp2xghheYZZ9GdMU8ypymdN38idP6qgV91w+l3fvFLf3VsDnmTAd1SHlz
JU/ptGbNCX5jE1fZyjXeZ4Hd3Ijekb85wK3obAwlIbyLviWnWMZ5xrnKShai
5/EPa7jJ89y9N4SLLGWSZUzxKG+ymjd4kveY4GM2s5spZnibad7hS3bxBR9x
kJ0c5wDH+Jw59jPPcU5yjBPM8Zn6NGrOcoQZPlSHbqlVl9SoWp1RlVrsVvCw
jvm3Shhnvcr1z/m3o//N9TpP2F/jcS5ySf8BdmNlvA==
             "]], 
            Line3DBox[CompressedData["
1:eJwV0jksZVEcwOGjsA2G8DQkEoxEocEUaC3Dq1BZOomlMoZoMK/jySiYZqIy
ybSTCA0R8fIKiUZshVZibURILNXEfLf45bv/k5Ock3tv5dDX3vGMEMKShvJC
OCwIoYdptnGbqcIQNpRWo7VNa7ue4/qhBmvlrGExu1SkmHnN3hL+ZjZ/MYur
fPkQwgqf+ZNXnOclF3jNJI85wyPO8oRzPOWZbrRovuWdXvWmHOfkqiy6n/7a
U8dmtWjHHOc++zmqMZ2bp3nBBG+Z5AOX+cZVvvNPdMbHENZZyj3GmGIVj1nH
i+hcPrKJT+xkZr73zRJ2M8ZBfuIAazjCRg7zM6cY5yQ7+Y1dTHCA39nPOfbx
izo0YW5ng+pVrUoVqUBVvtk/92q175430btQrfmAFdyK/gn9Byi5SpY=
             "]], 
            Line3DBox[CompressedData["
1:eJwVz68vxGEcwPHPF8Hmxw0bJ9hcwZEdHWcKphAUgshsqkgUqS5xNoUx4Uy7
ckMhun/AkIh4PeG91z6fJzzPU9jcWdnOImJdux0RL10RG2xwmQ+c4S3vc2bV
VFfJ/sp+ktcc5RlHeM4xVjnAU/azwjwHVdSFeZwTmtK07uwWuKo1PZu3+Mo9
NrnPAx3qw3zEHx7zmyf8ZYXt3RGX7GONBT5ymE/pbjbT/fxkiV+cZ1tnRJkt
nGMrl9jLRfYwU2jW/Jfeo3e9pTerriFnN8yxmv6tf4jHMjY=
             "]], 
            Line3DBox[{2939, 3548, 2928, 3539, 2912, 3530, 2911, 3533, 2915, 
             3534, 2901, 3523, 2900, 2902, 2916, 2917, 2930, 2931, 3549, 2940,
              3557, 2948, 3564, 2957, 3572, 2965, 3581, 2976, 3591, 2987, 
             3590, 2988, 3602, 3002, 3601, 3003, 3615, 3020, 3001, 3000, 3600,
              2996, 2984, 3589, 2974, 2975}], Line3DBox[CompressedData["
1:eJwV0ltMj2EcwPEnmxlRzEVdMVtbCs0W6qJcyELKBRmTIq2NUtZGDhk5jGLa
mMPWNMphcwirbihGSAkTY426cIU7zA3N5vNefPf5Pe/e5/8+//f/n7Vlx+rq
mBDCLw3GhjCg1LgQhpnOrzwfH8IS85j5hvmmCrRT+UpS/OQQklmoFM20nssy
++aZ55sXM0d1rhWyXFtVqz1qUKMuqkXtuqP7eqAXempvP59xgC/1SW+tP3OI
I3zHUb7nKz7nIPv4OvosvmE/e/iQ3XzEe+zkXXaxLToLW6Pz8AxbeZptPMiz
PMBzrOJJlvAQi3mY+dzFTG5jBiuYzGImspAJXMsJzONv7z2LX5jGISbxCRP4
mInRuRnLq4xhM/9McU7+YCO/sZ5fuJvDrGSFitRnnc9uZrOLaWznTM6InqFm
67FJIfzVd52w/sgP6lWNdSc7dFmX1KRT2q86VatKpdqsTHs2MYMlXKUCzYnO
xFSuZApXcDbzuIjFXMiNXMANTGcRs6PvyCxu5zLuZS73Rc/hsehZPM71PM91
vMAy3orOydvRudnNSvawloM8whHWc5T//AZN5p/m4P+fo3Ea7/1N5FQe5VLV
qMW901xrMMdpua67Vs4rKtV0XVOiutSuDuXa1+veNfwPu1WFeA==
             "]], 
            Line3DBox[{3036, 3034, 3637, 3049, 3987, 3992, 3994, 4024, 3868, 
             4057, 3871, 3943, 3958, 3084, 3982, 3877, 3922, 3961, 3673, 3100,
              3983, 3984, 3926, 3963, 3925, 3886, 3119, 3887, 3929, 3890, 
             3136, 3894, 3706, 3154, 3896, 3171, 3175, 3728, 3188, 3204, 3207,
              3753, 3226, 3240, 3243, 3771, 3255, 3266, 3269, 3286, 3288, 
             3801, 3301, 3313, 3315, 3326, 3327}], 
            Line3DBox[{3325, 3817, 3314, 3312, 3300, 3299, 3285, 3791, 3267, 
             3265, 3254, 3770, 3241, 3239, 3224, 3752, 3205, 3738, 3189, 3186,
              4047, 3172, 3719, 3897, 3155, 3895, 4049, 3892, 3137, 3891, 
             3930, 3133, 4050, 3116, 3682, 3964, 3927, 4046, 3985, 3101, 3962,
              3959, 3923, 3878, 3944, 4061, 3942, 4059, 3872, 4058, 3869, 
             4025, 3995, 3993, 3988, 3050, 4045}], 
            Line3DBox[{3331, 3330, 3819, 3329, 3818, 3328, 3318, 3317, 3810, 
             3316, 3304, 3303, 3802, 3302, 3289, 3287, 3270, 3268, 3256, 3772,
              3244, 3242, 3227, 3225, 3206, 3739, 3191, 3187, 3174, 3720, 
             3157, 3153, 3893, 3135, 3695, 3889, 3118, 3885, 3928, 3883, 3104,
              3882, 3920, 3960, 3921, 3981, 3980, 3083, 3957, 3955, 3918, 
             3870, 4011, 3068, 3996, 3991, 3986, 3048, 3636, 3033, 
             3035}]}, {}, {}}},
         VertexNormals->CompressedData["
1:eJwcm3c41W0Yx0VSGUmRJqmIKBmRyp2RIoqSIjt77304w86eWckuIVSE9NgS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          "]], {GraphicsComplex3DBox[CompressedData["
1:eJx1mnlUztv3x1MuQqbKmAaSkpIkhTynuafSiDRoHpEhZLzmsSK6TcLllqio
VK5bqB5kCpVGKkLSnFIphX797mPvc9f5rscfWuu1zvqs83l1Pvu890bOfaON
l7CQkJDc4F8igz8vRnRPFxKyJxUnMw8mJVnxarz+Pjr/bCvn+ISea/JPHZDf
WJ4SY7a/hbM5tFebG+aE/Flpl9fL1maOw+i+x/6OzsjP1Rotd3jezInN+zGH
O8EVefzVn86Roi2cSYd+bq76Srn5xxObiiNaOCG6A5n+VW7I7cfHF6V7tHKG
DO5ViOeOvF7bdXe/TxsnMEfIOOyyB3LOav+DK89+5jTvGXJK/oQn8qEJUY3D
d7RzXJcIl93y90K+iica81m9g1P2TViKa+ONfN6W9Laivg6OaaaIR5WmD3KZ
hKwX4S++cHIDhyb5T/NFXnpXqvpoYidn/sLfOgYGKI+PE7PTO9nFAc8RBZPe
mYSZ81SyEie26TSgZ+DDmuX+2L6hHj0Dv2NvvFx+Vj16Bh4lM81U2LwePQPX
XGp57EphPXoGvig9unzBxQb0DFxO2eqM1/VG9Ay84P14763NTegZ+GaRGMly
mxb0DLz3uYZlY2UregbuVC/q/+fvn9Ez8F2tnHzxc+3oGXirsK2Pw/4O9Iz7
v75tnbT/F/QMPK1kdpaiayd63nMg5/bSQmNe9zWHpmemtegZ+KO47qIvOR/Q
M/A3N0+YKGR/QM/AReOf6y1VqUXPwIV9AwvGfatFz8Bz3Mpkd4rVoWfgoyqz
HqQ7fELPwHvapRX0S+vRM3DFHYUyhzY1omfgCYe5q8crNqNn4PfjP4tYdLeg
Z+DLOa4rWkva0DNwXcXtU61d29Ez8MOn9ozc6NSBnoF/DhqeaLXmC3r20PCK
UButzxu1OeT82cA36Bn47PrdQXPfVqNn4BH2UyIq/d+gZ3xO+nqHyU1v0TPw
vsTXJdkn36Fn4LmdyUtFm96jZ+DFG9W41jtq0TNw6V3eVxKU69AzcJtO7ae5
fZ/QM/Dye2VC9W8b0DPw7csiHbklTegZeJOKQpNzaQt6Bl69uHJqUE0begY+
RXd8vd/OdvQMfP4jPX3nox3oOfzfc76U936DUL23ZBl6Bp6r7x+Q1l+KnoHP
muE3Yv38cvQMPO+u9eRql1foGfi2hztkLyyuQs/Ay/zT0gtOvEXPwGeIawUM
lXiPnoFzZdxid/38gJ6Bl1gb8lZ//4iegSeNq9NbPaIePQMfdyx2WK10I3oG
vlY7MmCnTjN6Bu6aYGtt696KnoHXNd/4PjPkM3oG/qwxr+9bdTt6dv/X/wLe
ArNASfWifPQMfI5nzMT7uc/QM/AXP6c/Lq4qRM/A1U612+l1F6Nn4P3Xp6mF
nChHz8Bt3f5xuruhEj0DT67pKuYdfouegXtYGSt2Or1Hz8DNlEuTvxyoRc/A
R+/bULw4pQ49Ax+1bW3Hk5p69Ax8xh+jNY0km9AzcPv7JYseLW9Bz8C/n0wR
/ut4G3oG/iC3dkKKO/Xs9i+fycvIP76/8EwWegZ+JUvuIWdeLnoGfnh3VNIi
o0foGfgMv2eT/EwL0DPw6Kk2M4p9StAzcGGvBSKjnlSgZ+Dqr8QUftOqRs/A
b4QGiyesfoeegXPU8sWMoz+gZ+C59eu8G19/RM/Aq/qTb/ZKUc/Aw/Qtvou7
NaJn4PXrYtq+xTejZ+D2iSN69zS3omfgXhP0lXImU89C//5pX7pbIuWf43O3
LAPPwH1Ul52dxU1Hz8ATG14PyHPvo2fg0rclFvzj/ww9A3/+cHaGPLcYPQMP
Vn343L+qHD0DN4ly/3TLvwo9Axf59yf1DNz9ZkGIPJd6Bp7re2EKN4x6xn1O
X3/Fv+oTegb++8vFC8LkqWfgb4+I8m75U8/AdRa/Mq+6RT0D/6PtyuuBgc/o
2Yvvn2Qy5xl4InOegbPnGfhM5jwDP8ucZ+DseQbOnmfgacx5Bs6eZ+DseQbO
nmfg7HkGzp5n4Ox5Bs6eZ09+PSELmfoMnK3PwF8y9Rk4W5+Bs/UZuA1Tn4Gn
MPUZOFufgZsz9Rk4W5+Bs/UZOFufgbP1GThbn4Gz9TmSfz+SWiZvAL/H5A3g
CkzeAM7mDeCBTN4A/pLJG8DZvAHclMkbwNm8AZzNG8DZvAHcl8kbwN2YvAGc
zRvA2bzB969PRjP5Gbgik5+BRzH5GbgYk5+Bs/kZOI/Jz8BLmPwMfDqTn4Hb
MvkZ+CsmPwNn8zPwRiY/A2fzM3A2PwNXY/Lz7/z+hXxl+kHgT5h+EHgN0w8C
H8n0g8DZfhA42w8CF2X6QeC9TD8InO0HgScy/SBwth8Ebsr0g8DZfhA42w8C
b2f6Qf45NyeqzHwDODvfAJ7NzDeARzPzDeDsfAO4FjPfAC7PzDeAP2PmG8C3
MvMN4D3MfAM4O98Azs43gLPzDeDsfAM4O9/4NV8iAuZ1RMC8jgiY1xEB8zoi
YF5HBMzriIB5HREwryMC5nVEwLyOCJjXEQHzOiJgXkcEzOsIzOskVnz1DPto
T2Zsy/tS0GnBO/8y8C8Pmyb0D1y6faW/0dsmTm/Z4Re3TvoiV+48K92xiz4f
+NKx1deOdnSyzycCnk8EPJ/A84HD/stSFMbum0r3j3PLooihgX0t7HqegPUE
1jP7J7D/yq5tutwAe6LhKfbTZIIVz8NBL394YzMn/DdDl6pHvsiVNgvdPCXS
xa4nAtYTWA8e4DnRYpLablotuB72H3V8/ulEW/p82P+26847xhjSPAnPf++p
Xz5t2f+s5wlYz4P1zH6IgP0Q2A98jwf99xSHKljxVi48oizi04zfo4JRcUaY
D+XwPead1Zcct41y+B6N0t48FLekHL7Hs0/EfxxstEQO36ND6F8pO59aIIfv
MTMuynHUkuXI022yIyLG0Lku8IDQRzEltXSufuX0aDvVXvqdrlpgs2dtuSVy
7L/yVPpGOC5Hfu77kHkWyXQODLw/eZideyydt3/v5t67bvAFv9/1dwtf73G1
RJ59b+JK9y46HwYOnss17ear9Jjxhlb+GKgo+4S/L72HN79VL6Ic/FcZjHkb
sdQcOfifmxlg8Y8o5eC/6GLBOicn+hzw39WvPGaqmily8F/U6ryhcZ8J8uWK
kef7ZtF5L3CcqwfN9WsabYb+wfP2V5mlFstMkM9ZLdG5MoHOgYFDPUzhZs6Z
MMkUPb/Xnbz1zWs6BwYO9VC/xX/3rjdm6PNgT7eGeBOd97KefV2mbNIwMeZl
7A0svW7wAT1finXJCMo2Qg6eyW/796QQuh48J+zLa9sXT9eD59BG4Z+7Nxoi
B8/q9+/O/SdCH/nlnZMqa+bQeS9wOOeHAoRDg4YboeecA5/FHMPovBc4nNv2
n2lyQ1YZoM/LQ6ZPO5pK573A4XymO3bNsCwxRJ/rzMIto1PpvBc41JMxoj0z
9+r/r8/TW2YrXlDS4+UZvbUW8alCn6Nyfwi5vdNFDj6z7tyw4t2iHHxOO9Tl
FvI7QQ4+Za5aXFtUuRT5yc+2ufrSdK4LHM4td/68+rSrBH1+FFK/7+tH57rA
4dzOfnNiy6ibeujzslS00vQtdK4LHM7ns5civirBOujTXTrtTIQHnesCh/Mp
tThnR9ImDvo8yNMam2FM57fAwWdO7vprMz5r8WacLuy7blCMPsOSjaLnSmgj
B59+ozo1o2M0kSfsbntp1bmGzj9/cTiHhR02N6eYL0RvfsE1klIqdE4LHM5h
nF95v+VKLfRmOFpCYZcsndMCh+89u62/NVh1CXprVP50ZfsQOqcFbuvXfVm8
ks5pwdsqtWPe01Po3JX1c3O6pNpJndm8IRkHjJMN7qOfgv6gJI29c5A7m9+u
XrTfEeeKwOG8OXkMxE+xnY9+VPPX/Tye5ELnsb+4w9q5uS5pdL4Kfj6EX8p2
OUTnqOCBk26+Ks6azkvhfbP0R/+QkKZzUXjf9v7Eg3sb6fwT3vfrip4KvzN0
ngn7nx30/YnfeDqfhH0W+/2Il66k80nY517uz4MlsXQOCfucozTgcnwdnTfC
PktHCOnoaNC5Iuxzf4PQ1C/f6fwQ9gmeYd4F+1T55RM46xM46xM46xM46xM4
6xM4e35u8c8PYc9PIf/8EPacOPPPCWG/L5xf/eLwHQGH94LvBTi8F3wXwNnv
Ajj7XQAXUDeIgLpBBNQNwtaHMn59IGy9xTkYUx9i+fWBsPUW1rP1IZdfHwhb
b2E9cI9fdRU4eID6CZz18Os+IgLuIyLgPiLsfSTFv4+IgPuICLh38H3jft3v
MM9h7x0F/r1D2Psd1rP3ziv+vUPY+x3Ws/eONP/eIez9DutZb978XEQE5CLC
5iIOPxcRAbmIsLnoND8XEQG5iLD55zA//6AHi1/5E+Y2bP7p4Ocf9KD0K2fC
ejb/ZPDzD2FzJqxn889Ifv4hkH8O/MqZsF5AnicC8jxh83wlP88TAXmesHn+
JT/PEwF5nrB5voSf5wmb28P4uZ2w/RTMbdg8H8jP84TN7en83E7Yvgmew+Z2
A35uJ2x/BOtZn7/6UCKgDyUC+lAioA8lAvpQwvahq/l9KGH70Lv8PvR//Njx
+0p8X6YPJWy/OYTfbyKH8+nP7x/RA9NvIo9y9jVrUXAkGxSfr76kQvvrx5K2
lrqPnMhYtYg7Ll6Urzqn1VV03Jm82XnbWGED5ccH3uc9WepKphkl66zS/k+f
fuOw/d+2bkT4QLy6rDft08s37L214g93UlCaP+HIftqPF1SYLJw0w4uYhXQt
OD/LAvOMeVnbsIGt9mRLodITMwfah7rozL2nJeJIhIcHXfX9T/+7a37w2N6/
ncjLLUus5RbQfvatXEZBQ4wzecuZUyDUSNffWDXGQt7DlfROXrtLrJb2s8fm
1j5qT3IjjUYrplW8pP2sb9MK3vfVniRY+7rI+CLan/bW3ctf7WpP6laa6FsV
0P7uVWTQbIsBB2LzrGZawTLaDwZcSrpSUeJEdiXWRq+TpTx0u3o075szifH4
PXSkEn3OmCDhaSGFrkRnbPztije07zNvei41ZaM9abr6srW1lvZHl5Xunz2o
4kgefD2/KViI9ll+gSMmRnDXkAK506beM+l6yXXdIceGu5K8E9OeDf1NB3nU
aePGo+n2xK/xnzj5StpfPH7UtiQzx5FEu59dGLx1EfKvKmOUZ2/zJsdju8PX
SC9BP/P2llsYrvUlx0uvXzfnauPv96SiU5yMkwNR7VLtGBdF83n70ZiJ3QFu
xOHe1icNPGXcj1nWzMBeHw9yJXbWjyFTFNFDQ9gxI3ddLzK28YJMfbYC/r7E
lN+/aJ/gQyZdPpfsM1IB9+M1vTdI+b0vmaI2+17thVm4n4yigC6b0MH8HPml
fnF0ai7s55FY2Q+R/8/PN+qzJk+5lgvvu/ND5J2nrwfzc4CZ/cd9abmwz9Z5
RXcODebn/WmGjtvb/86FfX5X/rlr8WB+3l9hocw7dDsX63bnty+fF/iQ/VY1
E67J5+bCPuW+PS25PJifeT+alnTU3cuFfSq6Sc4vGeZEbE8evb9w51TMnxlR
qfu1nroQb+NAz9Dd0pjTjB5fi7uY6UY07DcVpMySxRxiIuPY/+KYB2kwbD2/
74os3qdPwsKO3F7hRTYU3/uq1COL9d/JYbf5OlkfojlqxMjDKnJYxw6729k4
NfuSP62WOdXaymFdejMsuObQVXvSG9llJTKc5uQau1pRewlHIjq5QclFVQF5
en+FttQCZ3Kqaqip4kJ13L9pYsr5UKnB98ppljKYrIz805quhzc3u5GkhyHh
PSYqNKfNv7D9q6kHEbFVOnn7kiq+1/KDhv5zZLxIhfW4quSQefhekfvPa/q2
e5O6EH/vLCk1fC8Z5cV/5uT6kq9PDGa8cFbD93LnRKStnOVA8rMzE+IUaU62
sLT48+xtRzJv5vu/usVprvas0Pz6cdwaInNz2NyNqQuRGySnuBhecCVP6zY8
Ti/Xwv3fNtmeeUrcjahNm3zEdpkG8nlZwZfDB+vnIbUmr12Zi2l+LhXiSX1z
JxXZk4mH/0LkLj2bG+z3eJIJywIsK0RpTj51oMbsbZknqfaK3xu9TBP5xOdl
BnHJ3iTA/FDn+UpN9HB3cWTcooO+5Irojv6YFYvQQ4xeyUOJLQ6kSdSx8oYC
zc8y5TLhkfJOpKb9xZHEepqT489qz7OLW0Mq7LISuHKU/zlkTHXbYN1bFVHR
HVfDQV5mUMutm+hKvHbblG59QPNzXpT8+ZExbkRLqMJqW6ou7ftO7XlXN92d
jFhldcTUjoNcdvfn1OXnPUjHduepk9/9Jz9H3THxHO9Jtjww3Hn4JEHOJQ+F
VvZ5Efnrj1KmLtKlOfDDx417nbzJ1pJy57kDtL8ozx7ZcbnahxxPPepll62L
fha5zU7u1fQlrQ2a18UzdZAvS/OdxwtzIGP2tj5QW0bzcKqP3A9LVyeyY1K5
/zfuf/i1g3Odfq4hf+8reyRWQXPyu5rTaUI7XMhW354UMRHKOzbbenv5uRJR
BdXZj6sNkEePiN0qKepGcqxf9Hr50/y807X7Um2wOxk4pCZplUXzs0rqevGZ
UzyI1RFbm8h6A+QtDXeP3ZroRSbKxEovGTBED2+kk4ZfOzWYT4xD4zru0P7i
g0l32RJRH3L18Ob8xioj9OCbcTGge7sPSdnYp+PtY4D84Q9pL6cuX9Jgf6FI
6QzNyYpzJiotP+ZAOJlrX938QHNsSFpd1+QAJxKkdLo44D95OFmz7vQMFWcy
vSkotmwi5WK7Fxhb57mQlAQ7j3Nn6HOWfpDoGHrRlQzP164qyqZ5eGjzOLWR
lm7k3jVZx+B4LvJqzSlihzrdiFKnye4US5qTkwLTxbO2eZAh8c9m+kfTnFx6
q6VEZaQn2SSSOCDfykWuoS4+VirSkziYBPA8JWhOTn1Q5HhirDcJXO2mYapq
Rr39vT726WlvUuv3pTpciot8qsZITpHoYH/BC45fpUHz8JmUxoeOg99v3crK
y+pdXOQviuqU61c6EHVNcxWR8TTffhPt7L3v5EQWzU8rN/egPPXlvQcnNJxJ
Z7h/cWEg5dbBqi9W1LsQnSVX5UTsKbdTdb+rneNKDq663xkvTvlfT5/kKe1x
I/lG39o49jQ/24cHSLepupNjb/baXLKk+XmhbF/YHxXuRHhWXMywcTQ/a7Wc
XK5i70ku33pdfm8OzckndEv2He30JO/OBIYnDOZw4D3qddcWHPUiE3r2pH6Q
oPk5Rlc0R3vAm6y2fpxvNZHmZOdCZfm+Yz5kZZfepxY9C+QZdldLSyLtyayJ
UVtkH9B8y/hEjv8fQ0/dSnM9Xc88B98L/l1yyDlb+7vNdD3Dcb1qv6NSxGJ7
Yvp6zvjhp+l6hhMB+0H+f/g6oIk=
          "], {{
            {Opacity[1], EdgeForm[None], 
             GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmHn811MWxu/5ptKqiErb75fElBEi2QtlSygNkVaRJmGUjBHZZRfZt6zJ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                "]], Polygon3DBox[CompressedData["
1:eJw1mHfgn9MVxs/9RpDEShCRRIbVWCFW7Yq9asTeBEGREETM0pqxY8WqrYvY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                "]]}]}, {}, {}, {}}, {
            {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0LlOQkEYgNEBF9yhNSQQCmOlnZ0W1lDRqR2dJECL9kaeQCoTG30CeQJ9
AvddiTHGrVHcOs8NFiff/e/MZJLJlWrFaiyEsMQX0fc76XgI95piyM+sjuu0
TuqczmhB52Pd82VWWDA3tKRNreiOrmpLG7qvj+Tc86OHdHjliGNOOOWMcy64
ZNP5K73mhi3zrd7xxC9tPnnjgD3W7NvVbTZYp84yi+SZZcK+Kc3wwDdJPnhh
jFH67RvR4eiNiJsHdYBEtE4fvfRE6zz/v/MfB1sv2A==
              "]]}, 
            {GrayLevel[0], 
             Line3DBox[{258, 259, 423, 260, 261, 276, 277, 291, 292, 306, 307,
               443, 319, 449, 329, 456, 336, 463, 343, 472, 352, 483, 363, 
              496, 375, 495, 376, 508, 387, 507, 388, 521, 401, 520, 402, 534,
               414, 533, 412, 532, 413}], 
             Line3DBox[{262, 263, 264, 278, 279, 293}], 
             Line3DBox[{266, 424, 265, 425, 267, 426, 268, 427, 269, 428, 270,
               429, 271, 272, 287, 288, 302, 303, 316, 317, 447, 327, 454, 
              334, 461, 341, 470, 350, 481, 360, 480, 361, 492, 371, 491, 372,
               504, 383, 503, 384, 516, 397, 515, 396, 514, 395, 513, 394, 
              512, 393, 511, 391, 510, 392}], 
             Line3DBox[{281, 431, 280, 432, 282, 433, 283, 434, 284, 435, 285,
               286, 300, 301, 314, 315, 446, 326, 453, 333, 460, 340, 469, 
              349, 479, 358, 478, 359, 490, 369, 489, 370, 502, 382, 501, 381,
               500, 380, 499, 379, 498, 377, 497, 378}], 
             Line3DBox[{295, 436, 294, 437, 296, 438, 297, 439, 298, 299, 312,
               313, 445, 325, 452, 332, 459, 339, 468, 348, 477, 356, 476, 
              357, 488, 368, 487, 367, 486, 366, 485, 364, 484, 365}], 
             Line3DBox[{309, 440, 308, 441, 310, 311, 323, 324, 451, 331, 458,
               338, 467, 346, 466, 347, 475, 355, 474, 353, 473, 354}], 
             Line3DBox[{321, 444, 320, 322, 450, 330, 457, 337, 465, 344, 464,
               345}], Line3DBox[{389, 509, 390, 523, 403, 522, 404, 536, 415, 
              535, 416}], 
             Line3DBox[{539, 543, 537, 541, 538, 250, 417, 251, 418, 252, 419,
               253, 420, 254, 421, 255, 422, 256, 257, 273, 430, 274, 275, 
              289, 290, 304, 305, 442, 318, 448, 328, 455, 335, 462, 342, 471,
               351, 482, 362, 494, 373, 493, 374, 506, 385, 505, 386, 519, 
              400, 518, 398, 517, 399, 531, 411, 530, 410, 529, 409, 528, 408,
               527, 407, 526, 406, 525, 405, 524, 542, 540, 544, 
              545}]}, {}, {}}},
          VertexColors->CompressedData["
1:eJztmHlUzHsfx8cWleRGUpZSkVaEyJ28kSSKRIsKiUgLWa+UZEsi9LiUJC0o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           "],
          VertexNormals->CompressedData["
1:eJxtmndYz+37/1M0qJQRkq20lJlUulIaRrf2VJT23nu9R3tHA4U2Ik0ROilF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           "]], 
         GraphicsComplex3DBox[CompressedData["
1:eJx1mHlYzen7x2VJxthahpQRLdoXrdLytDrVaTnVqdQ3VMwwOVLSSIjIjzZq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          "], {{
            {Opacity[1], EdgeForm[None], 
             GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mHf8z1UYxZ+b9qJfe2tpSZTR4EdLaaMpSWQ1UFQ0f22lVELaRJoaGiIy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                "]], Polygon3DBox[CompressedData["
1:eJxNl+m7l1MUhvc2U4YiGZKOEImMlUJljFBS5kjJ1KTMGYoSKmQuaTQUMoYy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                "]]}]}, {}, {}, {}}, {
            {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0DlOglEUgNFfxQlxqCk0LkCpTWAFWlmJdHRQYGWircbACnQFugJdgawA
nEGFGGNEaBCcYuH5g8XJd2/y8l7yFrNb64WhIAjSfBDOXZ6YY4FlUqyRIc8u
JY444YwyL3xRpUebCy7Zc/mVXrNvvtFb7jiw17TOPUX7gz7S4JVvmvTphO87
U9Fzts2nekzWfKgbWtQdcqzYNzWhq5okbl7S+fAN87N+Mss7b8wwTYwRZ6Y0
ymQw+LAJGWeMX0aJ8BOeZ5jW///+AcHDMec=
              "]]}, 
            {GrayLevel[0], 
             Line3DBox[{250, 393, 251, 401, 261, 400, 262, 412, 273, 421, 283,
               431, 293, 441, 304, 451, 315, 461, 325, 467, 335, 472, 345, 
              477, 355, 481, 365, 374, 375, 487, 386}], 
             Line3DBox[{252, 394, 253, 403, 263, 402, 264, 413, 274, 422, 284,
               432, 294, 442, 305, 452, 316, 462, 326, 468, 336, 473, 346, 
              478, 356, 482, 366, 376, 377, 488, 387}], 
             Line3DBox[{256, 396, 254, 395, 255, 405, 265, 404, 266, 414, 275,
               423, 285, 434, 295, 433, 296, 443, 306, 453, 317, 463, 327, 
              469, 337, 347, 348, 479, 357, 483, 367, 378, 379, 388, 389}], 
             Line3DBox[{259, 398, 257, 397, 258, 407, 267, 406, 268, 416, 276,
               415, 277, 425, 286, 424, 287, 435, 297, 444, 307, 454, 318, 
              464, 328, 470, 338, 474, 349, 358, 359, 368, 369, 380, 381, 390,
               391}], Line3DBox[{282, 420, 280, 419, 281, 430, 292, 429, 290, 
              428, 291, 438, 299, 437, 300, 447, 310, 456, 320, 466, 330, 471,
               341, 351, 352, 362, 480, 363, 364, 372, 484, 373}], 
             Line3DBox[{303, 440, 301, 439, 302, 449, 311, 448, 312, 458, 321,
               457, 322, 331, 332, 342, 343, 353, 476, 354}], 
             Line3DBox[{313, 450, 314, 460, 323, 459, 324, 333, 334, 344}], 
             Line3DBox[{392, 490, 385, 384, 486, 383, 485, 382, 371, 370, 361,
               360, 350, 475, 340, 339, 329, 465, 319, 455, 309, 445, 308, 
              446, 298, 436, 289, 426, 288, 427, 279, 417, 278, 418, 270, 408,
               269, 409, 271, 410, 272, 411, 260, 399, 489}]}, {}, {}}},
          VertexColors->CompressedData["
1:eJztmHs4lHn/x6lUi1KkkLRit2KlLYdIvZHONjrqfFCkQgePYrfaSk4TlaJC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           "],
          VertexNormals->CompressedData["
1:eJxtmXk0Vm3U/wnRRKVJkiiZpxJl6AqJMs8pZJ7n2W2+75vMSQkVMiQlw0PK
ENtYmtCohDQQEqWBJH7nus/ved+etV7/WOu79jrOufa+vvuzNwE7byPHJUxM
TOPMTEwsxO8jlhsUc2XDkfuAWPr63SxN9PYMw67FKZR99ZFPkHo4qJZy5PNO
qMAqhZK+R4Tu+CGmsex3GLxUWp10/qsuLNzolsLx57jig9/FhMEdn4th8RQz
cDi4/jbWP6T+85TlKQW+c2csqC1YQY9IFq2b0Gv6q32/joeCwRovcGmyg60z
g3E9hE6NaFR43h4Cnie/snb5OwG7GeXuY0L361E0uHE8GNQGy2pZud0g+0D1
oaeEfvKs43e70kC4GHsvOjnBE+SyWNmeE7oDW13ap3/84aP1m8Bf1j6QtzWQ
uZfQj73tknDw9YV3rgd/bOr0BcFTz/a+IvSEJO38F+89oUd4pdKfz36wecVs
0WtCl0iTe2kU5wK8Xkf8m5v84fqEmPIgoRuHVvE+n7WDLQ8sBvZJBIBCxc6v
Q4TezMQZvn/8GExeW5tdLh0Apwc6qt8T+nZqm6qcSh2S8r9+NejI0qZrIvJT
G15OoY18Jczj9yKhKe1d0Rmv/VBP6YhrJ+LFNXgrAmIjoZ2W1RYSqwdeEhsH
sX7KksnEfXUkfE3lSNFdNIMOYU3fDkJXVnqsbuoUAdtaPTTCXlpDltUztTuE
XskjyP4hOhxWSGp4bnKxh5xcUbO7hL4bbbq/5mgY1DluOMrl4wxiO20qOgl9
NFPQnPouFGY7iprvUNzhyP2vRvcJvbGb85PnhhDolY2J3BLkDSxuwhoPCb1o
zEfV+1MgPPhWMLyvwBcW6UIJOO978iYaQ638oVTTKR7/5qjM5Md5NI++0fvZ
xwea3OM9jzwOACWdP6zPCP0Bh2/WTU83YHZOaNvzJhBawielcb66C5PKL+Ta
gyZfrh6/RxAMvWRJ6yP0yfSBlC8XLIAunMzj5xIEob7ynDgvC7td6tKlaoHt
qsQan8u24EgVHrF4PYUOn3+eU3slGjrquU8ll6lAkr2bdz0Rz9/N6U9NiIar
Xw9/cOnVBd7YhFas7xjTmbIyjYbRqbiHKhlmwKRTqt9A6KUvuNjpHNFwcfPu
b0UUa9gil7z5Nj7noKjd11Si4MQSPc1TpvZglJwt0ojzVf1A8ahQJKxqWjFY
kukM+jLT0U2Evt9Ubim9LhysVB9qLTJ7wP3H2hLNhH7WYh/lwigFVEaCix0P
+sCJm5flWgn9J7OlVnheCNz/xTy5Pt4P5M44F+F64DmbXyjzKBBs9h0Zz6oK
gCGZPDrO76uFqowtbn7A9oVmG3ExCA4FMPXhPCqeMlf+wOoJxQXrI+XXhkBC
RNUlnK9Kscg366MdgH+QUq02GAJH/efuPiH0F3OfDNqvm4OMnZD9o9chEGKz
Swbn5cw/D9iy2KhIY/wyJ/vpEFSrkbQugdD1ni67FdwXA9tj86/2aCiB8GiC
QCWhp6SvWpfYSujGoeNdUdqQm8nqgnUuJqmVA1kxUJ7v3jAwagLtC/uHsH6o
fNI/8hihl/VkVLtZgtjPsdR/CN16sd5taEkMMF3/9WT7LjsY43xMqSL0DKE3
fGZJ0RB6vWDVtVAnWLHLr6wa37ul+rK9z6JAPFLhItcmd1guEbO7BvvJVp12
i52RwCwOT1Yu84GEclu+W7jOlXhXhYyFwXnbQcVN5X5wNdswqg77RrOyUMDP
EJgKm3tz0jEQprijfHDex0VSpGVEAsEjRJ3PfjEYtNSr2XEeB13DHnP7+kDv
WpMoA1EKdGo8Nsb5koz7seXNT0eYz6BpOweHgdrbXP17hO6c6RQ3/scE1Kue
RqmlhMFv4fTnOC86ifrJ33loSNn5HzmjT8xNPFZqnUWEbiNcyN8xRoUf8ZaZ
rtPyIBum61tM6NLzxmI3X1EhK3EZr/5uTbA6qVqI9V1di5TgRioIsCxE0OsM
Idh+0y+s2znqtiWnU8Giqb6GVe0oqCcIB18h9EvvSpSmTajAiQ4tv2l9AsZl
P2wvIXR07s4Nq4UYKP1WHLAt3x5+vp3nuEroWiUT6htiYyB+cv/aVG4XqBYz
lrtG6Murwyjr+6JBM+jw8107PWFBuqmulNA9iuLEUh9GgacHc8Yuii+MWzrX
lBH6gYzon6c5I+BM0HYr9ZYACEsN1sP1IMQsp/p7Syiw929dtuxwCDh8DqrF
+a0s6LzPkeUPNsLUDYFXw+DnD3apWkJfstAiiPpdQCxMVE+b8MvJo+59+D52
2V2yL/U0hI/v6BOjUZEwqmx7Heclm/Xwrc1LWpHA9k1/lqiGA1P9z89G5VNI
oIH5nV8zDeoLv/3oL5OB3Lhsx1wivmdvv4p2LQ2i/AZZtn08AH0+HNFYt1ha
FPbsKg0+9R7yb588DNeymsqwvqXnuMHpMzSYkGWr2fraEAove33FOp3pUOgf
Pxr8MyY0mq1tDoZqPvp5hN6281TTtDoNfi+XbjGiWUHVH6curJsJbv4Ys0iF
W5/fM9W72MGlQ0khlwjdUmPl7tvZVIhbyqr05rETsPy4a5WP8/vL/YfWnxgY
nzdrXn3YA6a3FWYW4PPR45AJI+7R6UaBsIIsX+C5eswA19XLxTW2J29HghJL
U/bwD6Kuuy924zopuSN2X3dDKLScXvEjWDQMpJyOp+D8svZsGwhP8oa+gKrk
aPZoqNy0TwHna0T3rkdkxWGgtOTyCr+Ohg/bLhnhvFybDrvoe4GO5MXttMSr
UmCbMZNF3QLhqwFlTR1H6HBpj5jkgWwB8DM2WZZNxLevaRI8rUWHtpa6EuMB
WRAyzFqN9Q2loQ9zDtIhOdvByCJcCZy22PBhvSiRe2nYfjpM+jtR65jVwVLd
QwbrOU5/emz20GGt9p/fNd+04JDEDm2sdycMGMwJ00FPPnxg77A+FFyr9MY6
5anW6AQ3HYzeJoxvFTaBnfwZ+Vh3vbnvWO93Gnxo/Xk1K9ACCvOLR7DOH6C/
9XMLDQS63vn/UbGBqc18h88TeubDsvIMZxrM5pa8lxJ3BNbn9v1YPyUp7/6i
mgr3HjVVDJz1gPyKK/cuEHpYrdH8da4Y6Hue5/pBNwCqlG8G5hC6ezu7cf1I
CHS0DJfvXowAnRk1ZpxffRfRSkVzZZjgSfWTJPLfkfXMGN/HcQ3RiFvhsYiJ
/Ik+mBuSnkzon3/GDlyi0OFfPWKH5c5MQhccKXua85eepxrG0OtSdM/l/qVf
D/Fn6DdU4nb9rbsEBTP0kS0L0n/rpmmkbrneVORvvWOQ1DeUlPwnHs6QupP8
LeG/9Y3DpO4WHyb5t77sGqlz7KNJ/a1H5JH614gxib/1oQpSbynU/8/f1c8k
dZOs/v/EO1SS+h6lG4znG8a0b7ymQGk8mUPqbJKCF5gu0v/nnK+nxXZn4L6j
RdbzndGiV5AtgBRXkfXs+GuxDdfz0WM1iZsHZJG0Zzqjnls2URj1bH/s0sTO
cCWUeI+s58Ipsp4DertrSpjVEdP7/9bzKrKe0b/1fE2v2xLX852W7H3Kw/qo
dL6CUc/3tMXe43q+zpyI6xklGpH13E+dN8f1XFrm7pwZaIG2z5L1fGFMXQTX
88MNOU/mVWyQ33Kynq9d31SK67niiL0aUc8oxM6BUc8VF6944nouzcy7T9Qz
uhNN1rPN8sd/cD0/dpG2JOoZcRmR9XzUopZRz6N+gflEPaMkYXVGPX9vKmzH
9fxFrSCcqGfUpkjWsxaP4wN5wp//PefVAUXGdMKfX+9f5hxI+HOpI5vRUJkM
WpcTzfDnUw6kP/vWnM7Z+PEAenGL9OdnFP027M/V547P3pk8jIxuNTD8OZhD
OAL7s4oKK/ZnJD7lwfDnF/0aDH+O1P9H7IK2OcphJ/35xUbSn/N6qiSMaVZo
7APpz8MveRj+vMzhUy/hz+jz/USGP+v3d8lgf97BNGxK+DMq+0n6s3Gl6wz2
5/McQZcJf0YPd5L+fGvbU1nszx19B2wIf0Zzz/7rz/tIf0b/+vOWKNKfvQ5O
cIWIhqGJ5aQ/a7a8e4P9WVl3LpbwZ/RUm/TnSw6kP38qV9tE+DOSUyH9WY7b
9voowRsaycG7lHt90d6MjvdphD5lZ7r+LsEb+QXcC5rT8mipsRKDN4SyPx+7
RfCG58cT0ha7NZHD6z0M3oiITWbBvDEYFpceXWeI6nX5GLwx/HZ2eQrBG9v9
I6jsakfRa+cdDN7IePpUDfOG0JLTn25Yn0Bh8iRvVN0leWOMrjPMn2+PRvb9
YfDGuzFRPcwblyNP30/hdkGTS0neYOnW8sa8ofiQwRvoWCrJG9ulAxQxb7By
bKARvIHgIMkbW/sOMKcTvLHfisEbyMuZ5A39LxWKmDeSPzF4A/UxBzN44+H3
9keYN/T67WQJ3kA3T5O84X9hPx/mjarJ3RoEb6D3kSRv5J0neSNUqugxwRvI
rpDkjYh5lqH5+Bj0enpVbIcI636ux+Pbqv/iZwGSn9G//DzgKLgE83N4VdWD
Z1Ha6MMwyc/U2Zj2foKfW1U8MT8jh0BVBj/TObZrYn6+v7LP44abJdqm/YnB
z8ohStGYnwc1NtUS/Ix0nHsY/Nxm+lgU83NP+NaCq6FOqGEzyc+KrXoMfr56
om+C4GfU8TGawc+b08waMD9PKDH4Gen3kPx8WUCUGfPz51AGPyOzNpKfA5aq
MPh5uaNtE8HP6IEnyc+nxJeJYn4O2fyUi+Bn9Cyc5OcrWZFdmJ/v6Fy+QvAz
WtfZw+Bn1Ou7EfOzoez1EwQ/o+d5JD9bi4iGY372/pgUR/Azil1L8vPSShFu
gSO30dtnQqVTObZoFXvxQtcjYp5i/fngJjEPsu6X/phSpoI040IZ82BU9nZb
PA9y+4Rmefbqog1PyXnwuGKLkzUxD+ZPZv9GGWaok+cKYx5cFvBFAM+Dq37s
3nqZYo2cjJIY8yBnGjkPyp/Q2ULMg0ivmJwHp21fSeF5sJuHS+5qpjMa4yPn
QZXZn79pxDwYPfPIn5gH0XgPOQ96J+xIxvNg1l3GPIg2U8h50H2j4wE8D567
R2XZEO+HPoaS8+CKbSsv4XmwEjHmQVSkSM6DHGaheXgepM8VHCLmQdR8lZwH
RW8bqOF50Ne3JoSYB5F2PDkP7nrIPIznQUuTY4XEPIi+5pPzYGeg6HE8D8qx
OR4l5kE0H0XOgz+eRQT2e9bA6PpTiZpSx0BrKH+1yvsp1Pzl9OWRe5HALvTq
UbbXfkQzfMLYb0gMHrELjI2Ee5KNWgGxeki4Yx1jv2F1Q+U33m/sf7AU7zfQ
weqDjP3GjxWuOXi/IdR2ViDspTWa3fKUsd+IH+3Sw/uNg4FUhU0u9ugFiDD2
GytHJj/j/UbXm9MTnD7OyG3uBGO/wTZ2whbvN2L068rvUNxRci2531idoNaE
9xv+Deo3tgR5o5W3yf3Ggi1NFu83pmzL+vcV+CKHdnK/8SyY3G+8OqBZSPxG
M17kfsPai9xvUEZmKUceByA1UXK/4W1tX4T3G/frztTveROI7JPI/YbLWXK/
8aLtjDm/RxBqBXK/wV65ugXvN+QeX2L3cwlCbtnkfkPWmG3oomw4ymotWp37
2Bj9WtLdid+To4Hc1zW+s7PYMKGCHhwh93WbtlEZ+zpx24bfGV91kfovcl/H
8eckY1+n/jn8ZzzFDHVJkfs6gTpyX5d6OFlYbcEKyR0n93UCXeS+zll856BL
kx3aOkzu64ZyyX0d07GYu4/8nZBgDLmv6/tE7uumW7ITWbndkJATua/7nEju
6xaThdKSEzzR0kRyX3ditJaxr5twGkv+Ze2DKFMB/9e+Dv27r0ulkPu69yL1
an8++6GJ2RnGvq44htzX9XvNUpqb/FHtK3Jf136B3Nd5d+rf2ScRgPTHyH3d
bh5yX3epJCWlXDoAFc6R+7rd25wsGs9FwObzPezXtaWgWStqH/aZCL4ZJb2k
O0g2M5Ijx90JzTWtCB6NmkIXB9a/jdptAzS+n/OvTAKBNngy8A32K6oAr6Pp
MTh6QKJp9mAg1NRosL4l9CP85PP75kJWl2lLoXbN//P58O/zBx6Sz7/23WpZ
n0kg8m4kn59wOCVpXNYGVpqfWa+qFIDWvu01fEfoY3srKPKm4eDjz8l8eFwS
hF1eduB6yD1IxueZu/EQ8WDZS8YPvy9nxFc3Q23FuCQS5CDjd4eS7184oNdK
vD+6dY18/w9vVfXu/QqH39d6fMUEt0LJ3YfUB7iPF62Xb4qxghAY61psDQDn
amoJjm96R8bzH3AI2im4FWV1kvGxp8l417ShF0Q8up1LxrsZLGQOuIejzKp9
1lnKpihSJbgZx8uPv4xNKrQCpdo0u7a9AdA1dX8JzpegG9KMtSC+VzdGassn
PlS9aW0Lfn8P4eeyUkXHQGxhr19GbQAaOeXigL+XNYeMV2309dw5zgeCRmR8
9l4y/o+EmhsRD/FFZHx8fAX/HeJ9nq+UMTmpHAh5FQ+McT9VfEm+T2rdfjfi
fZBDP/k+FSef/XnzOgymVlV15E4agO4tjRP4fm35MnX/V3gkcHEk1ocV6YP3
FabP2PdOyz/QEDlEgRnF444nNGzBYSRKFt8vtSXWM4sKETDvohkqo2gD81YN
cdj3euN+iLqOBkOH157nmrZusD79rRO+d3OsWcatxRSQmgQfmeOuMGZocArX
lfxHLqPVa4LhFdublHXX3SDl9rZ8fB/9xEYPLbz3Ba7lj8/F7PSD8te1zvje
8Ywmyt26GQgGPaNBPzp8YeRF7z38/pc9cw7cSfGBbQ2drDUyfkA5elgW+9UW
nQQeZU17kDTolv3iHgTjpQUdWOf5lLGxMD8KJugqPvf26YGXdEE67mvXr6UZ
8iZHQ0N6+esDKTrwiOUd4D5bkzA3f/ZTJHSddGifK7AGVmXxszjeK0g99/fa
aLgXcTDHxNkKHIc/L8V99kVcCg89KwKYRXYkvDvlDO/E4hjx6zoOqSeoRoJL
2cFidjFn0Im46IT7rLoYdVCENwjkJp2Guat8oY/5yTucd+bB9duLciiwPvXn
22upPqB5enUm7rObbvM6Nqj7QQvdJ/Z8aBC8StY+i+uwsP9VS0+nH/xcRa35
7RQEVkrHzuI+0nb0J8tXb3eQunwq3as+CFYKR37D5xxUfbmGmm8PkVK2xVIB
QSDafykYn8/lo6d/l9+NgYfOoRyDdC1QP73GFvNbdW+L+Yx/DFzbJdfbbWEB
y1u3mOF6e6tZlqTzKBp0VxpsF+ZzALszPTyY0zp0ReasnMMgy8TmHxMlH8h8
0pqFz0E7/Z1J044osAvUsdkn4AnyqXe33iR0S7TkJ+fjYPBr73tSsiMQhPzD
LuB4ieGHl015KFASs3TgvEUARJuiJMw5Kx7ZFyQMOoLRXZerCjphwGnA+x3X
VeDmzCOTrc5w+xjbLvcDYfBD+mcr7rP3DJy/L79vCs7cViPHmylwNnHYDden
iPdk4Z1BKixuS2BLjlYHwda583gukPjhMyJYRoXli9svf95jAnzCybvxXBDw
hemnrA4VUl7H7XBfbwPK761U8VwwUH/ao5AnBixn3sSWDbiAe2qLEub5rBfq
97zPxoD+Q4XIEJoznKR0bMJzwZ1HV6420iMhfVxkf/4bX0iu5X+Cz1Nmle+y
VoFoqL8pkTra7gNfK/it8HPYAjs+4T346AXfyNCDIcCpqJJ4g9BtK+2K7JxD
QdkmfI/X0hD4dvDKOXz+8vQvbW1+vjAdevHj70IK5F3fmYPP88BIg6l/Aw22
NvxiE5JUglxPMQqeK9k3ji6vLqKB3fcvS+qldeBhSGkL1vkuRubvvUuF0e1j
PiM7LIFboRjw3Hdn+wLKDqbB0AXPY7lxZhA3+1oDz5s5nMU3hARosPKqR8m2
HBt4luO4G8+bMw9C+8opVLD+rX0/46MzvJp8V4XnTV3v1S1nv0SDwa8mUY8K
X1h7l+Mmfn7oj8n4G+wxkDnOrrU3zheGyg11sO7JF/r4bLoH7OeT+mdcPAp6
avxpuH4Sf7+aWccVAhYRK1VeVocB11eH13jOusAvFOd0Ux8oW+1L+7OjQKfH
7Dw+h6rC+3O0w3QY+V3SaDUpDmYj9Zx4z5D65TCtWZ0OHto3C9lnlWGse2Qb
1m8sN1g6p0CHV2WvnymqakK9vKkG1lm5POJ4BOmwb6l9sKSUIWQmc1Gx/s8B
Y201dxoEejY+L6m3gWy5Fgu8Z8gOSVBInqUBs+uniotPj4LWjZC3OP5XdNne
qxk08MkRezJ9xQ5oy0+W4j1GQ+/By+tqQ4FzxbRBRTkF0hJfieD6GZAOlj7h
T4WlKrUahzy94MjhIY+LhH5z21HF38yqoLUh4tohcSooPvomjeuHlS+QZ5Ve
AOR4LuWN9oyCpNVlUbhuFwzsJfP+d7/ElObpydgjzbgqJP21d2LaPU7u2QaF
X8j8rf9zktw7pQ79EP1b39xF6i83hP1HZ3lK6tOeT//emzHFFpP69dzVqSpl
xLkZrXv8uMcC1oT2ZePvorNu/E88Z/n/38vtDmlPqqGAUIy+RWEuBRoL6/nx
PWX9vvfv/RtTYAEZj/orzehE3lnKjqYYT4qjxSO3GHmvsj7CyPtzrq4LvTPK
6GnER0beZyXJvD87Lb5MXlUThXuReX+oa5WC8765y+aKlJQhGuEj8z5x9Lsc
zq/WphdnLjw9iiTZQhn5zRhZVML5Dd0wLEPkFzFrkfm9ukH8FP7eLM3jY8T3
IkNX8nuNDNpkcX7Z4y2OEvlFtoJkfi+9W9eBv7ctxk6X+F5ke4/83sU69c04
v2ka6uuI/KLVomR+G71c9QOI+/696+fSLZJK6ObENsZ9zx+21cH3/bbJsW8N
0jroeF8J474b7TI5hO+1vuxR77w4M7QlkbzXFR8uM+41NU9aRiDHBlmYk/ea
xrThMK5z1L0iiqhzVBpM1nmpJfcrfN+LQ2P6iPuOyqfI+07prU/E9/p6pZck
ca/Rq1fkvX6+hsKo84j3TK5EnaPifWSdp1YyzeJ7fWMo1Ji41+hrAXmvswO5
1HCdR55W/YeocxRxiqzzIb/KtZ2En1ete5mXEq2Ovkt+Zvh54Kpbt7Cf87fv
15rYY4LS1qYy/Dze9eFl7G9OrtkahL8hmU2kvw16+c1jnx9UlchwW2+DzL+Q
Pr9guecJ9vN+jhBJws/RAWfSz6uXNKzEvi1OvxRN+Dbq/of07ae8P1qxvx1e
yOMi/A11fiH9rcF+Rx72bQlPhm+jbFPSt60yUnqwv/2+2XCZ8Dek8p70t1Q/
0seYy9wzCR9DEvzmDB8bNY3+jPv1NmHe4nd0LdTwnOzX4nvm+XG/9q11N+ux
sECpp7Yy+jUYD1/E/Xrs9JEPO/kckJkY2a8V+AUCcP8qrFzpRPQvFONE9q8/
snsNcb/+uv3bKaJfI15fsl+XFDhV4v5l3LVjF9G/0NU6sn9xDe3Kx/2aVfBE
J9GvEWc22a8dHVWHcf9yu3gxguhf6LkB2b+OMfW34j6ltaxwxXwhBS1RIPuU
HzOTBu7jxQZRh4k+jgQ//GD0cXu37TyY07jFdihopOigkKz3DE5L/wEdmMdU
95ziNHW2QsypEwwe61gWvxdz135LvSmCu9BqX5K7Yg1n2a0JPolSZvAJOlRI
8sktvkpZzF1Wt299ILgLLRwjuUvuUc13zCfjc96NBJ+gnAqST7QrxO5j7qou
SsshuAu9cyO5S8krMwfzyYy6fAPBJyhzA8knussOfMEcksb94SPBIUgqjuSQ
Z8GHPDGXRgSUfOvcp4dm3l9icCnzd9WIOYLP2wLupgcX6aMzqgsTmM8tjm5X
yyC49NfOmEcEl6I4KTEGZ87Fmesy7Y0Ag7KtNgSfozqZegaf6zD/2YC5tJZf
pI7gUsS6huTSk9u13DGf69FapQk+R5HyJJ9P7BXoxlyasTNpkOBSFKtEcqkr
94gQ5vBdfS98CA5HgitfMjh8/c/tXgwurcrzJLgUbW8guVRbLWMV5s83CouJ
BH+iw3IkfzL33GLwZ7koawXBn2iojeTPSb/HmzG3sx332EdwO+rKILl9rIac
X8KlT8rnTBog3glyfolUJeeUKokmXWJOQdu/kXPK9z5pCTyPKEWplhHzCLK8
Ts4jY/Pk3PHGzcmNmDvQ1j5y7ugSIOcOlMqdQ8wdiPKInDta3Mj5IjaWzk7M
F0jdiJwvjisiy29/LEDXIfW1c1cgsn0tWITnXyuBJIcPLuGguMbh/VyOARhd
HgnF+xCNmfk9X6lhwM79Z43oIxsw0E3Xwvq6gVSdA7RQaMgrNit85AqeB1XG
sc45fqmz0CMYmh07ZzeluUFDoV453nfFKX23C6f6g6fDZu+EVQTvaxj24vf3
F7yQ3KjnC7mv1rHyyvrB+uk/mS9xHo0kpr+HWoL2EqVa/u+BgH4U1+D9A2et
6FkBv2jgtxPI2nNdB6ZfuZ7F9/Tz4ODDA5cjwT7CqirKWh+eCbma43rTHHOe
iX0ZBdWtSftjrljBjfVDknh/yP7t9d6NJRGQPiJ6d2jqBDQ6nluB92P0ypDJ
C+yR4LNxy+4hbWfo79UTAVzn/RzHvtWHwUxMlrzVLRcQE29wwPWZPr5vnbB1
CMDcGo7Du3yhVvaWM77vq1hYpE6MB4KEGbK43+gLPBJ8+jjv1wZrzOMD/UDy
3JMbEYFB8LQ7QRLX28cgJ83sC14Qyvp8oqwhCHb1PODCeU8M1elae88F/DVY
zXqqg6CIT0XmBaGHr7AU2pVoD0Ymt/fQ/IJgY1RGIs6vMu8R8dSEGNj5McGg
c1oLxhxNovFeOkjcZMv+JTEgvZhtPON7DIIfqXzFPvbJdK7MUSIauvOW338j
7wjBo7bpeP/8nuY2K50XAdV156rb0rygkTPkFParLQKrrln8osD0totzJR4+
wL1k4WoLoQec93WUHg6BMwplq4efBsA3w5Kd2K90uIKnfc8Egr1ImgrqI86j
f5QTn3P6k49fbXSdQLdLVbRDNwzuS+kV4PubeMtiicITC5CrzKz3+0iBsPle
YXwvHi1rfx6cQgUdywPi38wPwjNToyT8/4sV4jE32jip4CvJLXIxwgxWNxdH
X8f8f40FZIxi4OZ81NzQZTsQVXU+VUHo+0OSCkK9YuBi6eF230li3uJtXo/7
cryt9xIbIaLfPShRDM92h3MzJhP43CIfqNuglCgwFBDyeanmC97iaiL4OeuK
tUeyDoTDnOX1h3+0/SGi7voL3F8UpjatyuQNhXh/1k5jqRDo7ry9Cp+zr8K+
rNojAfA1c7Tk9FIK2K2VncR16yI146PB5w3PKPHfzrGFQbZypHIbPh/hJSvP
EXxyaSgwq7lDBQ6MlUdiDskfD+SaZqbBc+emN+rthoBYLXxxX353Wj6A7ygN
6rWiC3ldzaH3U40e5pzL973CDjpTQaW0afyg4gnYYJpAx/ywquWlfnAuFTb1
KR/MG7SDVk9aeyGh9w3wXPI8EQPzV2USvjR7wLSj4yUcH3yy8fCjhWhYjJ+8
oJLlCyJ7on3w3y3RnL85fjcCxDc95dM/FAiZ3Baa+PwF7WJtNy76QHEdt2Zk
cSToCwQo4n5dH6KSvC3ZBtYYP1Sxr4kCl0spb3G/2zsTMBvHRYeN5rvsRK1l
IdOazRD/39NgSVV2RCcNvL4LnuGK0YL+w7anMacJ6q3SHF1Bh92fBvPKarRB
t1uuE3OpYxS0+WXRwO/Owc1tNRYQf9HPHccPn+XdqjZAg86iz35bU47BF6+i
LByvy/nigUkbFU75z4k5DjuC7Tb/SHxu2UlGrtrvqJBcc9c48J4zpAVTmDFn
ivsY3HotHw0RGRR1ZsFAOGPIZ4n/z1i1TOHEmXWhcMmK5+Mz9TAY+rRxH+ar
u0dDv4onG8EOhZNPzqylQhJwMGE+Ufq+7VeiIx1esqUG5TNzgdWOj/OY87vG
w82mtOkwvzvqR2urAjTeXP8mi9BjlnokGzvTobLpglq2vQi8gWPvcDxfga+i
/n46aEef8X94SBN2GbKyYW43vzJyJoV4/ozXT1mZBBkQar48gePLWZSfy3LS
oZNjrSDLWmNIX5vEhs+hZ+WV4kobOqTvvzEQOSkNSwVt+fHfNa/zoq4fpsL2
0Yd658NdoWVxUxbm+UoW2q/ZDTQYPXmodTDGBu7eryvA5zZoveTFeFYosMRf
KTCrCocOye9ncF1ZSbia6ljTYY1PAE1q7w60eucRVfz8/p/2btf86dA/G8c7
fXYNYtrj7IHf09T5jd8PYt557d5nti5BFcVzJd/D8TIC7bp1tnRYaBY+UJW4
G71NGF2J9WI1oUTNpcS8I8FqsmyHGfowb/ACn8PywSE5VqJOlo8sGm8m5h2X
5ElX/L03RkPfpk/ToGeMx1HrtQI69GHUFn8XKxquCRWhQ2GikxWrsipqCG/Z
iuOXTB9Lu3SGBkbKhZ1G602R3k4Jf1wPbHSTK7draFCmqiPj/cccNSXz5+Pn
OFuxc6lviQH++RGRRuSLvt1fLo/vS/10TdoLIRpwO6/4ekhHDcnpfVqC9Qs3
77LoHqeB+N38CbkdBuhXmos+vu/iUzW3Z17GgFXzOXq1sRPKlLQ6g3m+VKuC
PdMgBvbogGFRlgcKD5bRwLql73M5jsd24N0jtYkmE4V0nk1cw/1u6ydd+iIb
FfIf9R11faGJfNToSuX4nNPFZYJXUmExPNvoOKc5ElErDsP319LhbrTSMirs
0rBumemyQQe3aKrhenajfZUyeBoM+nylOZZpIagifW039j0r5kvNt0qiYUi3
mLLbXAfV2Vs+x/+vjGHtuzOkFw3Zpd3ZGx9aooIYIw3cR9hpCvPHuyIhNPIA
i+11JwSVwlewD7zZJcr7lNcR5pXPCC7uD0OBrVOFmEu/zq5KLj3vC+9Ffd8s
RAahzOadTJjrpua+jZQ/tgf+I9Gj6wKDUFOziznug1f9inV6FSPhpGgdX9+4
PhJ1znmP+05FV67D4I5wuOYzdrw31wbFREVI4ud/4eI9iLnoxsTjtwQXwZ5u
kot8xdq4fhAc4m28pZrgEHRrnuSQ/we2ImWC
           "]]}},
       Axes->True,
       AxesLabel->{
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(d\\), \\(1\\)]\\)+f\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(d\\), \\(2\\)]\\)\"", TraditionalForm], 
         FormBox["\"\"", TraditionalForm]},
       BoxRatios->{1, 1, 1},
       ImageSize->{332.9032258064516, 332.9032258064516},
       Lighting->"Neutral",
       Method->{"RotationControl" -> "Globe"},
       PlotRange->NCache[{{2, 200}, {
           Rational[-200, 3], 
           Rational[200, 3]}, {-1, 1}}, {{2, 200}, {-66.66666666666667, 
          66.66666666666667}, {-1, 1}}],
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02], Automatic},
       ViewPoint->{-0.15395677650571923`, -3.3522370207717067`, 
        0.4345161303514616},
       ViewVertical->{0., 0., 1.}], {192., -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
      
      ContentSelectable->True], InsetBox[
      Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1mHlUjd0XxyuhIkPSZEoIoVmUuCcNKk2Gom7zLCX9RC9lrowVIYXML5V4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         "], {{
           {GrayLevel[0.5], Opacity[0.9], EdgeForm[None], Specularity[
             GrayLevel[1], 20], 
            GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmHfcl2MYxe/rLZtSRjbJSkQR9RJSkkSkrEQyekXDyEqUZI8oI0mSkZGR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               "]], Polygon3DBox[CompressedData["
1:eJwtl3fc11MYhs95ycyeWWWPbApZ2dkrykoKhZSRrEpCEpWiqOythApJRDYh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               "]]}]}, {}, {}, {}}, {
           {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0Lsug2EcwOGvVUWdOnYiLgCzRK+gJkMHNumiA6PDLGE2tBEzV8AVtFfg
VLR1iIigFm0dJp43DM/3+7+Hb3knllbnV2JRFC3yQZjfeSDNgI1xzeiUZpk2
z+lM7O+/IhvkrXe0oGU9ZNN8rFta1Se+OKVDi11nZ3rOBTUuuaLs7FrrNNiz
buoN++ZbveOZb+7p8sYJFY5Yc/dAS2yzzjIL5Jh0PhvKGI98MkqbV0YYptfd
IR0kbk6Fd6KfH/pIhnsk6An3wp7Py/87/wKqHDEP
             "]]}, 
           {GrayLevel[0], 
            Line3DBox[{255, 256, 257, 272, 419, 273, 274, 422, 287, 297, 298, 
             430, 310, 323, 324, 438, 332, 445, 339, 458, 351, 457, 352, 468, 
             362, 478, 371, 477, 372, 489, 384, 501, 396, 500, 394, 499, 395, 
             512, 406, 511, 407}], 
            Line3DBox[{258, 259, 260, 275, 276, 423, 288, 299, 300, 431, 311, 
             325, 326, 439, 333, 446, 340, 460, 353, 459, 354, 469, 363, 480, 
             373, 479, 374, 490, 385, 503, 397, 502, 398, 514, 408, 513, 
             409}], Line3DBox[{261, 262, 263, 277, 278, 424, 289, 301}], 
            Line3DBox[{265, 415, 264, 416, 266, 417, 267, 268, 282, 421, 283, 
             284, 293, 294, 428, 308, 319, 320, 436, 330, 443, 337, 454, 347, 
             453, 348, 466, 360, 474, 367, 473, 368, 486, 381, 485, 379, 484, 
             380, 495, 390, 494, 389, 493, 387, 492, 388}], 
            Line3DBox[{280, 420, 279, 281, 290, 425, 291, 292, 306, 307, 317, 
             318, 435, 329, 442, 336, 452, 345, 451, 346, 465, 358, 464, 359, 
             472, 366, 471, 364, 470, 365, 483, 377, 482, 378}], 
            Line3DBox[{303, 426, 302, 427, 304, 305, 315, 316, 434, 328, 441, 
             335, 450, 343, 449, 344, 463, 357, 462, 355, 461, 356}], 
            Line3DBox[{313, 432, 312, 314, 433, 327, 440, 334, 448, 341, 447, 
             342}], Line3DBox[{375, 481, 376, 491, 386, 505, 399, 504, 400, 
             516, 410, 515, 411}], 
            Line3DBox[{402, 506, 401, 507, 403, 508, 404, 509, 405, 510, 392, 
             496, 391, 497, 393, 498, 383, 487, 382, 488, 370, 475, 369, 476, 
             361, 467, 350, 455, 349, 456, 338, 444, 331, 437, 322, 321, 309, 
             429, 296, 295, 286, 285, 271, 270, 418, 269, 254, 253, 414, 252, 
             413, 251, 412, 250, 517, 518}]}, {}, {}}},
         VertexNormals->CompressedData["
1:eJx1mXlYTesXx9N1I2OTIqJQSIOoULQr0qDSPEk0F6V5Hs+ARBkaVFRIlFLu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          "]], GraphicsComplex3DBox[CompressedData["
1:eJx1mHk0lV0XwIXK2BySIplSZIrIcLjmTJlF00uTkkql0EChUSUZmqc3GZop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         "], {{
           {GrayLevel[0.5], Opacity[1], EdgeForm[None], Specularity[
             GrayLevel[1], 20], 
            GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mHn8V3MWxs/5UXYyY99mGoOx70JpKKEsEWM3yL4VRsmWkq2SNPbC/DIz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               "]], Polygon3DBox[CompressedData["
1:eJw1l3e811MYx8+5kb0SmQ0zs+zsQpKRZGSr7FWyMkJZKZKRvYskRWYZRQgZ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               "]]}]}, {}, {}, {}}, {
           {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0Dsvg1EcwOHTutXdZiOYde6gs4GpIxsTEVZmA2vTlE/AJ6hPUJ/AvWhL
pBG3hSoSCc9JOjz5/U/OeU9O3omljdx6IoSwSIs4v/PACOOkmbKR1fn22VW2
2GWfeMmhHnHMI9+c0uSVM84pOHuhlxTNV1rhOt5lfaO3VKlR547uZAhP+sM9
n7xxQt53Zd3Wkh6wZt7TZd3RTVaYtV7QjM7pDJPmaR3VMW3wxTAfvJCyN6SD
DNBPH70k7aW0J76TP7ro5JeOeIbn9n/+B1oDMbY=
             "]]}, 
           {GrayLevel[0], 
            Line3DBox[{252, 413, 250, 412, 251, 423, 265, 422, 266, 436, 280, 
             446, 291}], 
            Line3DBox[{255, 415, 253, 414, 254, 425, 267, 424, 268, 437, 281, 
             448, 292, 447, 293, 458, 303, 468, 313, 467, 314, 481, 328, 488, 
             335, 342, 343, 496, 356, 367, 368, 504, 379, 390, 391, 404, 
             405}], Line3DBox[{258, 417, 256, 416, 257, 428, 271, 427, 269, 
             426, 270, 438, 282, 450, 294, 449, 295, 459, 304, 470, 315, 469, 
             316, 482, 329, 489, 336, 344, 345, 497, 357, 369, 370, 505, 380, 
             392, 508, 393, 394, 406, 407}], 
            Line3DBox[{264, 516, 263, 421, 262, 420, 261, 419, 259, 418, 260, 
             431, 274, 430, 272, 429, 273, 440, 283, 439, 284, 452, 296, 451, 
             297, 460, 305, 472, 317, 471, 318, 483, 330, 490, 337, 346, 347, 
             498, 358, 371, 372, 381, 382, 395, 509, 396, 397, 408, 513, 409, 
             514, 410, 515, 411, 517, 518}], 
            Line3DBox[{279, 435, 278, 434, 277, 433, 275, 432, 276, 443, 287, 
             442, 285, 441, 286, 454, 298, 453, 299, 461, 306, 474, 319, 473, 
             320, 484, 331, 491, 338, 348, 349, 499, 359, 373, 374, 383, 506, 
             384, 385, 398, 510, 399, 511, 400, 512, 401}], 
            Line3DBox[{290, 445, 288, 444, 289, 457, 302, 456, 300, 455, 301, 
             463, 307, 462, 308, 476, 321, 475, 322, 485, 332, 492, 339, 350, 
             351, 360, 361, 375, 502, 376, 377, 386, 507, 387}], 
            Line3DBox[{312, 466, 311, 465, 309, 464, 310, 478, 323, 477, 324, 
             486, 333, 493, 340, 352, 353, 362, 500, 363, 501, 364}], 
            Line3DBox[{327, 480, 325, 479, 326, 487, 334, 494, 341, 354, 495, 
             355}], Line3DBox[{366, 365, 503, 378, 388, 389, 402, 
             403}]}, {}, {}}},
         VertexNormals->CompressedData["
1:eJx1mnlYTmsXxp2kJFOFiFIiQzMNFO1Es9KsUtGggdI8j++AUJmayZRUSjon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          "]], {GraphicsComplex3DBox[CompressedData["
1:eJx1mnlUztv3x1MuQqbKmAaSkpIkhTynuafSiDRoHpEhZLzmsSK6TcLllqio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          "], {{
            {Opacity[0.5], EdgeForm[None], 
             GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmHn811MWxu/5ptKqiErb75fElBEi2QtlSygNkVaRJmGUjBHZZRfZt6zJ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                "]], Polygon3DBox[CompressedData["
1:eJw1mHfgn9MVxs/9RpDEShCRRIbVWCFW7Yq9asTeBEGREETM0pqxY8WqrYvY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                "]]}]}, {}, {}, {}}, {
            {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0LlOQkEYgNEBF9yhNSQQCmOlnZ0W1lDRqR2dJECL9kaeQCoTG30CeQJ9
AvddiTHGrVHcOs8NFiff/e/MZJLJlWrFaiyEsMQX0fc76XgI95piyM+sjuu0
TuqczmhB52Pd82VWWDA3tKRNreiOrmpLG7qvj+Tc86OHdHjliGNOOOWMcy64
ZNP5K73mhi3zrd7xxC9tPnnjgD3W7NvVbTZYp84yi+SZZcK+Kc3wwDdJPnhh
jFH67RvR4eiNiJsHdYBEtE4fvfRE6zz/v/MfB1sv2A==
              "]]}, 
            {GrayLevel[0], 
             Line3DBox[{258, 259, 423, 260, 261, 276, 277, 291, 292, 306, 307,
               443, 319, 449, 329, 456, 336, 463, 343, 472, 352, 483, 363, 
              496, 375, 495, 376, 508, 387, 507, 388, 521, 401, 520, 402, 534,
               414, 533, 412, 532, 413}], 
             Line3DBox[{262, 263, 264, 278, 279, 293}], 
             Line3DBox[{266, 424, 265, 425, 267, 426, 268, 427, 269, 428, 270,
               429, 271, 272, 287, 288, 302, 303, 316, 317, 447, 327, 454, 
              334, 461, 341, 470, 350, 481, 360, 480, 361, 492, 371, 491, 372,
               504, 383, 503, 384, 516, 397, 515, 396, 514, 395, 513, 394, 
              512, 393, 511, 391, 510, 392}], 
             Line3DBox[{281, 431, 280, 432, 282, 433, 283, 434, 284, 435, 285,
               286, 300, 301, 314, 315, 446, 326, 453, 333, 460, 340, 469, 
              349, 479, 358, 478, 359, 490, 369, 489, 370, 502, 382, 501, 381,
               500, 380, 499, 379, 498, 377, 497, 378}], 
             Line3DBox[{295, 436, 294, 437, 296, 438, 297, 439, 298, 299, 312,
               313, 445, 325, 452, 332, 459, 339, 468, 348, 477, 356, 476, 
              357, 488, 368, 487, 367, 486, 366, 485, 364, 484, 365}], 
             Line3DBox[{309, 440, 308, 441, 310, 311, 323, 324, 451, 331, 458,
               338, 467, 346, 466, 347, 475, 355, 474, 353, 473, 354}], 
             Line3DBox[{321, 444, 320, 322, 450, 330, 457, 337, 465, 344, 464,
               345}], Line3DBox[{389, 509, 390, 523, 403, 522, 404, 536, 415, 
              535, 416}], 
             Line3DBox[{539, 543, 537, 541, 538, 250, 417, 251, 418, 252, 419,
               253, 420, 254, 421, 255, 422, 256, 257, 273, 430, 274, 275, 
              289, 290, 304, 305, 442, 318, 448, 328, 455, 335, 462, 342, 471,
               351, 482, 362, 494, 373, 493, 374, 506, 385, 505, 386, 519, 
              400, 518, 398, 517, 399, 531, 411, 530, 410, 529, 409, 528, 408,
               527, 407, 526, 406, 525, 405, 524, 542, 540, 544, 
              545}]}, {}, {}}},
          VertexColors->CompressedData["
1:eJztmHlUzHsfx8cWleRGUpZSkVaEyJ28kSSKRIsKiUgLWa+UZEsi9LiUJC0o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           "],
          VertexNormals->CompressedData["
1:eJxtmndYz+37/1M0qJQRkq20lJlUulIaRrf2VJT23nu9R3tHA4U2Ik0ROilF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           "]], 
         GraphicsComplex3DBox[CompressedData["
1:eJx1mHlYzen7x2VJxthahpQRLdoXrdLytDrVaTnVqdQ3VMwwOVLSSIjIjzZq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          "], {{
            {Opacity[0.5], EdgeForm[None], 
             GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mHf8z1UYxZ+b9qJfe2tpSZTR4EdLaaMpSWQ1UFQ0f22lVELaRJoaGiIy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                "]], Polygon3DBox[CompressedData["
1:eJxNl+m7l1MUhvc2U4YiGZKOEImMlUJljFBS5kjJ1KTMGYoSKmQuaTQUMoYy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                "]]}]}, {}, {}, {}}, {
            {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0DlOglEUgNFfxQlxqCk0LkCpTWAFWlmJdHRQYGWircbACnQFugJdgawA
nEGFGGNEaBCcYuH5g8XJd2/y8l7yFrNb64WhIAjSfBDOXZ6YY4FlUqyRIc8u
JY444YwyL3xRpUebCy7Zc/mVXrNvvtFb7jiw17TOPUX7gz7S4JVvmvTphO87
U9Fzts2nekzWfKgbWtQdcqzYNzWhq5okbl7S+fAN87N+Mss7b8wwTYwRZ6Y0
ymQw+LAJGWeMX0aJ8BOeZ5jW///+AcHDMec=
              "]]}, 
            {GrayLevel[0], 
             Line3DBox[{250, 393, 251, 401, 261, 400, 262, 412, 273, 421, 283,
               431, 293, 441, 304, 451, 315, 461, 325, 467, 335, 472, 345, 
              477, 355, 481, 365, 374, 375, 487, 386}], 
             Line3DBox[{252, 394, 253, 403, 263, 402, 264, 413, 274, 422, 284,
               432, 294, 442, 305, 452, 316, 462, 326, 468, 336, 473, 346, 
              478, 356, 482, 366, 376, 377, 488, 387}], 
             Line3DBox[{256, 396, 254, 395, 255, 405, 265, 404, 266, 414, 275,
               423, 285, 434, 295, 433, 296, 443, 306, 453, 317, 463, 327, 
              469, 337, 347, 348, 479, 357, 483, 367, 378, 379, 388, 389}], 
             Line3DBox[{259, 398, 257, 397, 258, 407, 267, 406, 268, 416, 276,
               415, 277, 425, 286, 424, 287, 435, 297, 444, 307, 454, 318, 
              464, 328, 470, 338, 474, 349, 358, 359, 368, 369, 380, 381, 390,
               391}], Line3DBox[{282, 420, 280, 419, 281, 430, 292, 429, 290, 
              428, 291, 438, 299, 437, 300, 447, 310, 456, 320, 466, 330, 471,
               341, 351, 352, 362, 480, 363, 364, 372, 484, 373}], 
             Line3DBox[{303, 440, 301, 439, 302, 449, 311, 448, 312, 458, 321,
               457, 322, 331, 332, 342, 343, 353, 476, 354}], 
             Line3DBox[{313, 450, 314, 460, 323, 459, 324, 333, 334, 344}], 
             Line3DBox[{392, 490, 385, 384, 486, 383, 485, 382, 371, 370, 361,
               360, 350, 475, 340, 339, 329, 465, 319, 455, 309, 445, 308, 
              446, 298, 436, 289, 426, 288, 427, 279, 417, 278, 418, 270, 408,
               269, 409, 271, 410, 272, 411, 260, 399, 489}]}, {}, {}}},
          VertexColors->CompressedData["
1:eJztmHs4lHn/x6lUi1KkkLRit2KlLYdIvZHONjrqfFCkQgePYrfaSk4TlaJC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           "],
          VertexNormals->CompressedData["
1:eJxtmXk0Vm3U/wnRRKVJkiiZpxJl6AqJMs8pZJ7n2W2+75vMSQkVMiQlw0PK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           "]]}},
       Axes->True,
       AxesLabel->{
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(d\\), \\(1\\)]\\)+f\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*SubscriptBox[\\(d\\), \\(2\\)]\\)\"", TraditionalForm], 
         FormBox["\"\"", TraditionalForm]},
       BoxRatios->{1, 1, 1},
       ImageSize->{173.70967741935488`, 173.70967741935482`},
       Lighting->"Neutral",
       Method->{"RotationControl" -> "Globe"},
       PlotRange->All,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02], 
         Scaled[0.02]},
       ViewPoint->{-1.5609949598017592`, -2.9213544322157823`, 
        0.6920859894888179},
       ViewVertical->{0., 0., 1.}], {576., -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
      
      ContentSelectable->True]}, {}},
   ImageSize->{689., Automatic},
   PlotRangePadding->{6, 5}], TraditionalForm]], "InlineMath"]], "Text"],

Cell["\<\
The figure above on the left shows the peak values of the motion/pursuit law \
in color and the time zero M/PL in gray. On the right the dark gray graph is \
the two-dimensional relative depth.\
\>", "Text"],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["d", "2"], "=", "0"}], TraditionalForm]], "InlineMath"],
 " the motion ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[InvisibleSpace]", 
    RowBox[{"\[Theta]", "/", "d"}], "\[InvisibleSpace]", "t"}], 
   TraditionalForm]], "InlineMath"],
 ", the motion pursuit ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[InvisibleSpace]", 
    RowBox[{"\[Theta]", "/", "d"}], "\[InvisibleSpace]", "\[Alpha]"}], 
   TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[InvisibleSpace]", 
    RowBox[{"\[Theta]", "/", "d"}], "\[InvisibleSpace]", "\[Beta]"}], 
   TraditionalForm]], "InlineMath"],
 " all peak at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 " and this peak value satisfies"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
      RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], 
     RowBox[{"(", "0", ")"}]}], "=", 
    FractionBox[
     SubscriptBox["d", "1"], "f"]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["d", "2"], "\[NotEqual]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " and the eye node is at the center of the eye, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", the motion/pursuit ratio and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[InvisibleSpace]", 
    RowBox[{"\[Theta]", "/", "d"}], "\[InvisibleSpace]", "\[Beta]"}], 
   TraditionalForm]], "InlineMath"],
 " have critical points at the times"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      SubscriptBox["t", "1"], "=", 
      FractionBox[
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          SubscriptBox["d", "1"], "2"]}], " ", "-", 
        SuperscriptBox[
         SubscriptBox["d", "2"], "2"], " ", "-", 
        RowBox[{"2", " ", 
         SubscriptBox["d", "1"], " ", "f"}], " ", "-", 
        RowBox[{
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            SubscriptBox["d", "1"], "2"], "+", 
           SuperscriptBox[
            SubscriptBox["d", "2"], "2"]}]], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            SubscriptBox["d", "1"], "2"], "+", 
           SuperscriptBox[
            SubscriptBox["d", "2"], "2"], "+", 
           RowBox[{"4", " ", 
            SubscriptBox["d", "1"], " ", "f"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["f", "2"]}]}]], " "}]}], 
       RowBox[{"2", " ", 
        SubscriptBox["d", "2"], " ", "i"}]]}], TraditionalForm]], 
    "InlineMath"]]], ","}], TraditionalForm]], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      SubscriptBox["t", "2"], "=", 
      FractionBox[
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          SubscriptBox["d", "1"], "2"]}], " ", "-", 
        SuperscriptBox[
         SubscriptBox["d", "2"], "2"], " ", "-", 
        RowBox[{"2", " ", 
         SubscriptBox["d", "1"], " ", "f"}], " ", "+", 
        RowBox[{
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            SubscriptBox["d", "1"], "2"], "+", 
           SuperscriptBox[
            SubscriptBox["d", "2"], "2"]}]], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            SubscriptBox["d", "1"], "2"], "+", 
           SuperscriptBox[
            SubscriptBox["d", "2"], "2"], "+", 
           RowBox[{"4", " ", 
            SubscriptBox["d", "1"], " ", "f"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["f", "2"]}]}]], " "}]}], 
       RowBox[{"2", " ", 
        SubscriptBox["d", "2"], " ", "i"}]]}], TraditionalForm]], 
    "InlineMath"]]], TraditionalForm]]],
 "."
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  GraphicsBox[{
    {RGBColor[0, 0, 1], AbsolutePointSize[5], PointBox[{-20, 120}], 
     InsetBox["\<\"D\"\>", {-21., 126.}]}, 
    {AbsolutePointSize[4], PointBox[{0, 0}]}, 
    {GrayLevel[0], AbsolutePointSize[4], PointBox[{0, 0}]}, 
    {RGBColor[1, 0, 0], AbsolutePointSize[4], PointBox[{0, 100}], 
     InsetBox["\<\"F\"\>", {0, 105.}]}, 
    {GrayLevel[0], LineBox[{{0, 0}, {0, 100}}]}, 
    {GrayLevel[0], AbsolutePointSize[5], Dashing[0.01], 
     LineBox[{{0, 0}, {-20, 120}}], 
     CircleBox[NCache[{0, Rational[185, 3]}, {0, 61.666666666666664`}], 
      NCache[Rational[185, 3], 61.666666666666664`]]}, {
     {GrayLevel[0.5], AbsoluteThickness[2], Dashing[0.01], 
      LineBox[{{-1.3, -1.9500000000000002`}, {1.3, -1.9500000000000002`}, {
       0.9099999999999999, -2.08}}], 
      CircleBox[{0, 0}, 1.3, {1.9707963267948965`, 7.453981633974482}]}, 
     {GrayLevel[0.5], 
      CircleBox[{0, 1.04}, 0.65, {0.07079632679489656, 3.0707963267948966`}]}, 
     {GrayLevel[0], DiskBox[{0, 0}, 0.13]}}, {
     {GrayLevel[0.5], AbsoluteThickness[2], Dashing[0.01], 
      LineBox[{{-34.25499351813307, -1.9500000000000002`}, \
{-31.65499351813307, -1.9500000000000002`}, {-32.044993518133076`, -2.08}}], 
      CircleBox[{-32.95499351813307, 0}, 1.3, {1.6524546867293837`, 
       7.13563999390897}]}, 
     {GrayLevel[0.5], 
      CircleBox[{-32.62948188514295, 0.9877460082369895}, 
       0.65, {-0.24754531327061624`, 2.7524546867293838`}]}, 
     {GrayLevel[0], DiskBox[{-32.95499351813307, 0}, 0.13]}}, 
    {RGBColor[0.6, 0.4, 0.2], 
     LineBox[{{-20, 120}, {-32.95499351813307, 0}, {0, 100}}]}},
   AspectRatio->Automatic,
   ImageSize->{203., Automatic},
   PlotRange->All], TraditionalForm]], "InlineMath"]], "Text"],

Cell[TextData[{
 "The peak time motion/pursuit formula gives a value close to the relative \
distance ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PlusMinus]", 
    RowBox[{"|", 
     RowBox[{
      StyleBox["D",
       FontSlant->"Plain"], "-", 
      StyleBox["F",
       FontSlant->"Plain"]}], "|", 
     RowBox[{"/", "f"}]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
        RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["t", "2"], "(", 
         RowBox[{"f", ",", 
          SubscriptBox["d", "1"], ",", 
          SubscriptBox["d", "2"]}], ")"}], ")"}]}], "\[TildeEqual]", 
      FractionBox[
       RowBox[{"|", 
        RowBox[{
         StyleBox["D",
          FontSlant->"Plain"], "-", 
         StyleBox["F",
          FontSlant->"Plain"]}], "|"}], "f"]}], TraditionalForm]]]], 
    "InlineMath"], ",", " ", 
   RowBox[{"when", " ", Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["d", "2"], ">", "0"}], TraditionalForm]], 
     "InlineMath"]]]}], ",", " ", Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
        RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["t", "1"], "(", 
         RowBox[{"f", ",", 
          SubscriptBox["d", "1"], ",", 
          SubscriptBox["d", "2"]}], ")"}], ")"}]}], "\[TildeEqual]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"|", 
         RowBox[{
          StyleBox["D",
           FontSlant->"Plain"], "-", 
          StyleBox["F",
           FontSlant->"Plain"]}], "|"}], "f"]}]}], TraditionalForm]]]], 
    "InlineMath"], ",", " ", 
   RowBox[{"when", " ", Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["d", "2"], "<", "0"}], TraditionalForm]], 
     "InlineMath"]]]}], ",", " ", 
   RowBox[{"and", " ", Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
         RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], 
        RowBox[{"(", "0", ")"}]}], "=", 
       FractionBox[
        RowBox[{"|", 
         RowBox[{
          StyleBox["D",
           FontSlant->"Plain"], "-", 
          StyleBox["F",
           FontSlant->"Plain"]}], "|"}], "f"]}], TraditionalForm]], 
     "InlineMath"]], "InlineMath"]}], ",", " ", 
   RowBox[{"when", " ", 
    RowBox[{Cell[TextData[Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["d", "2"], "=", "0"}], TraditionalForm]], 
      "InlineMath"]]], "."}]}]}], TraditionalForm]], "Text"],

Cell[TextData[{
 "We do not know a theoretical explanation for the rough approximation of the \
peak motion/pursuit law by the 2D relative distance, but this Demonstration \
compares ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], 
    RowBox[{"(", "0", ")"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], 
    RowBox[{"(", 
     SubscriptBox["t", "c"], ")"}]}], TraditionalForm]], "InlineMath"],
 ", and the 2D signed relative distance, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PlusMinus]", 
    FractionBox[
     RowBox[{"|", 
      RowBox[{
       StyleBox["D",
        FontSlant->"Plain"], "-", 
       StyleBox["F",
        FontSlant->"Plain"]}], "|"}], "f"]}], TraditionalForm]], "InlineMath"],
 ". It also lets you vary time and compare the motion/pursuit law at other \
times. You can drag the distractor in two dimensions."
}], "Text"],

Cell["\<\
The Demonstration \"Motion/Pursuit Law on Invariant Circles (Visual Depth \
Perception 4)\" (see Related Links) lets you vary the distractor on the time \
zero invariant circles. \
\>", "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Motion/Pursuit Law in 2D (Visual Depth Perception 3)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitLawIn2DVisualDepthPerception3/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
MotionPursuitLawIn2DVisualDepthPerception3/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
MotionPursuitLawIn2DVisualDepthPerception3/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitLawIn2DVisualDepthPerception3/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
MotionPursuitLawIn2DVisualDepthPerception3/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Keith Stroyan",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->95413255],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
MotionPursuitLawIn2DVisualDepthPerception3"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Motion/Pursuit Law in 2D (Visual Depth Perception 3) - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[654, 23, 172, 3, 70, "Section"],
Cell[829, 28, 3700, 64, 70, "Section"],
Cell[4532, 94, 66028, 1603, 70, "Input",
 CellID->670459734]
}, Open  ]],
Cell[CellGroupData[{
Cell[70597, 1702, 39039, 880, 70, "Output",
 CellID->695675211],
Cell[CellGroupData[{
Cell[109661, 2586, 209, 6, 70, "Section"],
Cell[109873, 2594, 301, 5, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[110200, 2603, 1154, 34, 70, "Text"],
Cell[CellGroupData[{
Cell[111379, 2641, 209, 6, 70, "Section"],
Cell[111591, 2649, 290, 8, 70, "Text"],
Cell[111884, 2659, 96, 2, 70, "Text"],
Cell[111983, 2663, 3092, 91, 70, "Text"],
Cell[115078, 2756, 141, 6, 70, "Text"],
Cell[115222, 2764, 1018, 33, 70, "Text"],
Cell[116243, 2799, 286, 10, 70, "Text"],
Cell[116532, 2811, 601, 22, 70, "Text"],
Cell[117136, 2835, 834, 26, 70, "Text"],
Cell[117973, 2863, 3362, 63, 70, "Text"],
Cell[121338, 2928, 1007, 24, 70, "Text"],
Cell[122348, 2954, 421328, 6951, 70, "Text"],
Cell[543679, 9907, 217, 4, 70, "Text"],
Cell[543899, 9913, 860, 29, 70, "Text"],
Cell[544762, 9944, 337, 12, 70, "Text"],
Cell[545102, 9958, 548, 18, 70, "Text"],
Cell[545653, 9978, 1125, 34, 70, "Text"],
Cell[546781, 10014, 1135, 36, 70, "Text"],
Cell[547919, 10052, 1777, 34, 70, "Text"],
Cell[549699, 10088, 380, 14, 70, "Text"],
Cell[550082, 10104, 2496, 75, 70, "Text"],
Cell[552581, 10181, 1123, 33, 70, "Text"],
Cell[553707, 10216, 203, 4, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[553946, 10225, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[554304, 10236, 1057, 31, 70, "Text"],
Cell[555364, 10269, 455, 15, 70, "Text",
 CellID->95413255],
Cell[CellGroupData[{
Cell[555844, 10288, 815, 24, 70, "Text"],
Cell[556662, 10314, 1214, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature LSNxsij#4EnjSA0kJXG@Gj4I *)
