(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     49434,       1217]
NotebookOptionsPosition[     48064,       1167]
NotebookOutlinePosition[     48726,       1192]
CellTagsIndexPosition[     48683,       1189]
WindowTitle->Light Polarization and Stokes Parameters - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Light Polarization and Stokes Parameters", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "\[CapitalDelta]\[Phi]", ",", "\[Alpha]", ",", 
       "Imax", ",", "sx", ",", "sy", ",", "sz", ",", "sxy", ",", "ellipse", 
       ",", "principalAxes", ",", "psaxes", ",", "poincareSphere", ",", 
       "equators", ",", "stokesVector", ",", "circles"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Imax", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"DOLP", "+", "1"}], ")"}], "/", "2"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Alpha]", "=", 
       RowBox[{"orientation", " ", 
        FractionBox["\[Pi]", "180.0"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"a", "=", 
       SqrtBox[
        RowBox[{
         RowBox[{"Imax", " ", 
          SuperscriptBox[
           RowBox[{"Cos", "[", "\[Alpha]", "]"}], "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "Imax"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Alpha]", "]"}], "2"]}]}]]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"b", "=", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"]}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalDelta]\[Phi]", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Imax", "\[Equal]", "1"}], "&&", 
          RowBox[{"\[Alpha]", "\[Equal]", "0"}]}], ",", "0", ",", 
         RowBox[{"Switch", "[", 
          RowBox[{"handedness", ",", "\"\<right\>\"", ",", 
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "-", 
            RowBox[{"ArcTan", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Sin", "[", 
                RowBox[{"2", "\[Alpha]"}], "]"}], 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "Imax"}], "-", "1"}], ")"}]}], ",", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"Imax", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "Imax"}], ")"}]}]]}]}], "]"}]}], ",", 
           "\"\<left\>\"", ",", 
           RowBox[{"ArcTan", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{"2", "\[Alpha]"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "Imax"}], "-", "1"}], ")"}]}], ",", 
             RowBox[{"2", " ", 
              SqrtBox[
               RowBox[{"Imax", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "Imax"}], ")"}]}]]}]}], "]"}]}], "]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"sx", ",", "sy", ",", "sz"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ",", 
         RowBox[{"2", " ", "a", " ", "b", " ", 
          RowBox[{"Cos", "[", "\[CapitalDelta]\[Phi]", "]"}]}], ",", 
         RowBox[{"2", " ", "a", " ", "b", " ", 
          RowBox[{"Sin", "[", "\[CapitalDelta]\[Phi]", "]"}]}]}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"sxy", "=", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["sx", "2"], "+", 
         SuperscriptBox["sy", "2"]}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ellipse", "=", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a", " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], ",", " ", 
           RowBox[{"b", " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"t", "+", "\[CapitalDelta]\[Phi]"}], "]"}]}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", 
           RowBox[{"2", "Pi"}]}], "}"}], ",", 
         RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Darker", "[", "Blue", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}], ",", 
         RowBox[{"Epilog", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Darker", "[", "Blue", "]"}], ",", "Thick", ",", 
            RowBox[{"Arrowheads", "[", ".1", "]"}], ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                SqrtBox[
                 RowBox[{"1", "-", "Imax"}]], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Sin", "[", "\[Alpha]", "]"}], ",", 
                    RowBox[{"-", 
                    RowBox[{"Cos", "[", "\[Alpha]", "]"}]}]}], "}"}], "-", 
                  RowBox[{
                   RowBox[{"Switch", "[", 
                    RowBox[{"handedness", ",", "\"\<right\>\"", ",", 
                    RowBox[{"-", "1"}], ",", "\"\<left\>\"", ",", 
                    RowBox[{"+", "1"}]}], "]"}], "0.1", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "\[Alpha]", "]"}], ",", 
                    RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], "}"}]}]}], 
                 ")"}]}], ",", 
               RowBox[{
                SqrtBox[
                 RowBox[{"1", "-", "Imax"}]], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Sin", "[", "\[Alpha]", "]"}], ",", 
                    RowBox[{"-", 
                    RowBox[{"Cos", "[", "\[Alpha]", "]"}]}]}], "}"}], "+", 
                  RowBox[{
                   RowBox[{"Switch", "[", 
                    RowBox[{"handedness", ",", "\"\<right\>\"", ",", 
                    RowBox[{"-", "1"}], ",", "\"\<left\>\"", ",", 
                    RowBox[{"+", "1"}]}], "]"}], "0.1", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "\[Alpha]", "]"}], ",", 
                    RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], "}"}]}]}], 
                 ")"}]}]}], "}"}], "]"}]}], "}"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"principalAxes", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Darker", "[", "Blue", "]"}], ",", "Thin", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                SqrtBox["Imax"], 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], ",", 
                  RowBox[{"-", 
                   RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}], "}"}]}], ",", 
               RowBox[{
                SqrtBox["Imax"], 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Cos", "[", "\[Alpha]", "]"}], ",", 
                  RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], "}"}]}]}], "}"}], 
             "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Darker", "[", "Blue", "]"}], ",", "Thin", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                SqrtBox[
                 RowBox[{"1", "-", "Imax"}]], 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], ",", 
                  RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], "}"}]}], ",", 
               RowBox[{
                SqrtBox[
                 RowBox[{"1", "-", "Imax"}]], 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Sin", "[", "\[Alpha]", "]"}], ",", 
                  RowBox[{"-", 
                   RowBox[{"Cos", "[", "\[Alpha]", "]"}]}]}], "}"}]}]}], 
              "}"}], "]"}]}], "}"}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"poincareSphere", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}], ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", 
               RowBox[{"-", "1"}]}], "}"}], "]"}], ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], "]"}], ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
            RowBox[{"Sphere", " ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "1"}], "]"}]}], 
           "}"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"psaxes", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"ps", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "]"}], 
           ",", 
           RowBox[{"Line", "[", 
            RowBox[{"ps", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "]"}], 
           ",", 
           RowBox[{"Line", "[", 
            RowBox[{"ps", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", 
                 RowBox[{"-", "1"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "]"}], 
           ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<\!\(\*SubscriptBox[\(S\), \(x\)]\)\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"lp", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<\!\(\*SubscriptBox[\(S\), \(y\)]\)\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "lp", ",", "0"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<\!\(\*SubscriptBox[\(S\), \(z\)]\)\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "lp"}], "}"}]}], "]"}]}], "}"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ps", "\[Rule]", " ", "1.15"}], ",", 
           RowBox[{"lp", "\[Rule]", "1.3"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"equators", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ParametricPlot3D", " ", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", "t", "]"}], ",", 
              RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Black", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"ParametricPlot3D", " ", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", "t", "]"}], ",", "0", ",", 
              RowBox[{"Sin", "[", "t", "]"}]}], "}"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Black", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"ParametricPlot3D", " ", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"Cos", "[", "t", "]"}], ",", 
              RowBox[{"Sin", "[", "t", "]"}]}], "}"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Black", ",", "Thin"}], "}"}]}]}], "]"}]}], "}"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"circles", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ParametricPlot3D", " ", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"2", "\[Alpha]"}], "]"}], " ", 
               RowBox[{"Cos", "[", "t", "]"}]}], ",", 
              RowBox[{
               RowBox[{"Sin", "[", 
                RowBox[{"2", "\[Alpha]"}], "]"}], " ", 
               RowBox[{"Cos", "[", "t", "]"}]}], ",", 
              RowBox[{"Sin", "[", "t", "]"}]}], "}"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Red", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"ParametricPlot3D", " ", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"sxy", " ", 
               RowBox[{"Cos", "[", "t", "]"}]}], ",", 
              RowBox[{"sxy", " ", 
               RowBox[{"Sin", "[", "t", "]"}]}], ",", "sz"}], " ", "}"}], 
            "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Red", ",", "Thin"}], "}"}]}]}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"stokesVector", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Sphere", " ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"sx", ",", "sy", ",", "sz"}], "}"}], ",", "0.06"}], 
           "]"}], ",", 
          RowBox[{"Thickness", "[", "0.012", "]"}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Grid", "[", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Text", "@", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\<polarization ellipse\>\"", ",", "16"}], "]"}]}], 
           ",", 
           RowBox[{"Text", "@", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\<Poincar\[EAcute] sphere\>\"", ",", "16"}], 
             "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Pane", "[", 
            RowBox[{
             RowBox[{"Show", "[", 
              RowBox[{"ellipse", ",", "principalAxes", ",", 
               RowBox[{"Frame", "\[Rule]", "False"}], ",", 
               RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
               RowBox[{"BaseStyle", "\[Rule]", 
                RowBox[{"{", "Medium", "}"}]}], ",", 
               RowBox[{"AxesLabel", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<\!\(\*SubscriptBox[\(E\), \(H\)]\)\>\"", ",", 
                  "\"\<\!\(\*SubscriptBox[\(E\), \(V\)]\)\>\""}], "}"}]}], 
               ",", 
               RowBox[{"ImageSize", "\[Rule]", "260"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"280", ",", "280"}], "}"}], ",", 
             RowBox[{"Alignment", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Center", ",", "Top"}], "}"}]}]}], "]"}], ",", 
           RowBox[{"Pane", "[", 
            RowBox[{
             RowBox[{"Show", "[", 
              RowBox[{
              "poincareSphere", ",", "equators", ",", "stokesVector", ",", 
               "circles", ",", "psaxes", ",", 
               RowBox[{"Axes", "\[Rule]", "False"}], ",", 
               RowBox[{"PlotRange", "\[Rule]", "1.2"}], ",", 
               RowBox[{"BaseStyle", "\[Rule]", 
                RowBox[{"{", "Medium", "}"}]}], ",", 
               RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
               RowBox[{"ViewPoint", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"1.3", ",", "2.4", ",", "1"}], "}"}]}], ",", 
               RowBox[{"ImageSize", "\[Rule]", "340"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"300", ",", "300"}], "}"}], ",", 
             RowBox[{"Alignment", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Center", ",", "Top"}], "}"}]}]}], "]"}]}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Pane", "[", 
            RowBox[{"\"\<\>\"", ",", 
             RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ",", 
           RowBox[{"Pane", "[", 
            RowBox[{
             RowBox[{"Row", "[", 
              RowBox[{"Text", "/@", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{
                  "\"\<\!\(\*SubscriptBox[\(S\), \(x\)]\)=\>\"", ",", 
                   "Italic"}], "]"}], ",", 
                 RowBox[{"NumberForm", "[", 
                  RowBox[{
                   RowBox[{"sx", "//", "Chop"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
                 RowBox[{"Style", "[", 
                  RowBox[{
                  "\"\<,  \!\(\*SubscriptBox[\(S\), \(y\)]\)=\>\"", ",", 
                   "Italic"}], "]"}], ",", 
                 RowBox[{"NumberForm", "[", 
                  RowBox[{
                   RowBox[{"sy", "//", "Chop"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
                 RowBox[{"Style", "[", 
                  RowBox[{
                  "\"\<,  \!\(\*SubscriptBox[\(S\), \(z\)]\)=\>\"", ",", 
                   "Italic"}], "]"}], ",", 
                 RowBox[{"NumberForm", "[", 
                  RowBox[{
                   RowBox[{"sz", "//", "Chop"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], "]"}],
              ",", 
             RowBox[{"BaseStyle", "\[Rule]", 
              RowBox[{"{", "14", "}"}]}], ",", 
             RowBox[{"Alignment", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Center", ",", "Top"}], "}"}]}]}], "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}], "]"}]}]}], " ", "\[IndentingNewLine]", 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "DOLP", ",", "0.6", ",", 
       "\"\<degree of linear polarization (0 \[LessEqual] DOLP \[LessEqual] \
1)\>\""}], "}"}], ",", "0", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "orientation", ",", "20", ",", 
       "\"\<orientation of ellipse (0 \[LessEqual] \[Alpha] \[LessEqual] 180\
\[Degree])\>\""}], "}"}], ",", "0", ",", "180", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"handedness", ",", "\"\<left\>\"", ",", "\"\<handedness\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<left\>\"", ",", "\"\<right\>\""}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.418357544023625*^9, 3.41835757853925*^9}, {
   3.418357634054875*^9, 3.4183576453205*^9}, {3.418357733508*^9, 
   3.418357764211125*^9}, {3.418357794336125*^9, 3.418357806961125*^9}, {
   3.41835786435175*^9, 3.418357873086125*^9}, {3.4183579403205*^9, 
   3.418357998273625*^9}, {3.418358038804875*^9, 3.418358045648625*^9}, {
   3.418358077211125*^9, 3.418358140648625*^9}, {3.4183581801955*^9, 
   3.41835820066425*^9}, {3.418358273148625*^9, 3.418358382648625*^9}, 
   3.418358478242375*^9, {3.41835862391425*^9, 3.418358645961125*^9}, {
   3.418368163179875*^9, 3.418368262742375*^9}, 3.418368494304875*^9, {
   3.41836853497675*^9, 3.41836855697675*^9}, {3.41836863591425*^9, 
   3.418368656992375*^9}, {3.418368703367375*^9, 3.418368779836125*^9}, {
   3.418368814617375*^9, 3.4183689009455*^9}, {3.418368938258*^9, 
   3.418368944961125*^9}, {3.4183719970705*^9, 3.418372029929875*^9}, {
   3.41837207803925*^9, 3.418372094258*^9}, {3.418372128898625*^9, 
   3.41837217847675*^9}, {3.418372226523625*^9, 3.41837222716425*^9}, {
   3.418372280867375*^9, 3.418372328617375*^9}, {3.418372414367375*^9, 
   3.41837246372675*^9}, {3.41837252316425*^9, 3.418372551054875*^9}, {
   3.418381365019131*^9, 3.418381373769019*^9}, {3.4183820901973486`*^9, 
   3.4183822412422905`*^9}, {3.4183823245380993`*^9, 3.418382337256686*^9}, {
   3.418382375193701*^9, 3.4183823998183856`*^9}, {3.4183824416928496`*^9, 
   3.418382454067691*^9}, {3.4183824865829*^9, 3.41838263931532*^9}, {
   3.418382734720349*^9, 3.4183829518894444`*^9}, {3.41839917146875*^9, 
   3.418399171734375*^9}, {3.4183993008125*^9, 3.418399441953125*^9}, {
   3.4183996483125*^9, 3.418399675015625*^9}, {3.41839980290625*^9, 
   3.418399817859375*^9}, {3.418399873125*^9, 3.4183999253125*^9}, {
   3.41839995865625*^9, 3.418400103375*^9}, {3.41840148615625*^9, 
   3.418401502984375*^9}, {3.418401542625*^9, 3.41840156221875*^9}, {
   3.4184015968125*^9, 3.418401686734375*^9}, {3.41840176390625*^9, 
   3.418401768859375*^9}, {3.418401809125*^9, 3.4184018299375*^9}, {
   3.4184024665*^9, 3.418402589515625*^9}, {3.418402619609375*^9, 
   3.4184026604375*^9}, {3.4184027050625*^9, 3.41840270809375*^9}, 
   3.418402805671875*^9, {3.418402852578125*^9, 3.418403118125*^9}, {
   3.4184067581875*^9, 3.41840675925*^9}, {3.418406804984375*^9, 
   3.41840681084375*^9}, {3.41840687115625*^9, 3.418406913046875*^9}, {
   3.418406954875*^9, 3.418407039125*^9}, {3.418407200015625*^9, 
   3.41840752121875*^9}, {3.418407574546875*^9, 3.418407608453125*^9}, {
   3.418407663875*^9, 3.418407679921875*^9}, {3.418407754421875*^9, 
   3.41840778165625*^9}, {3.418407816125*^9, 3.41840781803125*^9}, {
   3.418407878015625*^9, 3.4184078785*^9}, {3.418407932296875*^9, 
   3.41840796790625*^9}, {3.418408525359375*^9, 3.418408526171875*^9}, 
   3.418408578796875*^9, {3.418408609078125*^9, 3.41840878790625*^9}, {
   3.418408834171875*^9, 3.41840887809375*^9}, {3.418409016125*^9, 
   3.41840904215625*^9}, {3.418409147890625*^9, 3.41840939603125*^9}, {
   3.418409441859375*^9, 3.41840981296875*^9}, {3.41840987571875*^9, 
   3.418410009546875*^9}, {3.418410057109375*^9, 3.418410138515625*^9}, {
   3.418410172140625*^9, 3.418410197546875*^9}, {3.418410235875*^9, 
   3.41841027140625*^9}, {3.418410370796875*^9, 3.4184103781875*^9}, {
   3.418411532921875*^9, 3.418411695796875*^9}, {3.41841175646875*^9, 
   3.418411759875*^9}, {3.4184334008125*^9, 3.418433407078125*^9}, {
   3.418433455890625*^9, 3.418433456953125*^9}, {3.418433558015625*^9, 
   3.418433570921875*^9}, {3.4184336018125*^9, 3.41843360446875*^9}, 
   3.418433960921875*^9, {3.418434064015625*^9, 3.418434066828125*^9}, 
   3.418434097140625*^9, 3.418434224140625*^9, {3.41843427025*^9, 
   3.4184342751875*^9}, {3.418434329171875*^9, 3.41843442390625*^9}, {
   3.41843446428125*^9, 3.418434471640625*^9}, {3.418434520515625*^9, 
   3.4184345384375*^9}, {3.418435140390625*^9, 3.4184351545625*^9}, {
   3.418435219640625*^9, 3.41843525475*^9}, {3.4184352916875*^9, 
   3.418435327625*^9}, {3.4184495280611043`*^9, 3.4184496671375647`*^9}, {
   3.4184501345848637`*^9, 3.4184501746795464`*^9}, {3.418450314605941*^9, 
   3.4184503860164585`*^9}, {3.418450424801799*^9, 3.4184504399326005`*^9}, {
   3.4185354690065904`*^9, 3.418535637993889*^9}, {3.4185358061383004`*^9, 
   3.418535952505822*^9}, {3.4185379870419035`*^9, 3.4185379985108733`*^9}, 
   3.4185744574998136`*^9, {3.4185744916074424`*^9, 3.4185745584946423`*^9}},
 CellID->56198445]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`DOLP$$ = 0.848, $CellContext`handedness$$ = 
    "left", $CellContext`orientation$$ = 59.400000000000006`, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`DOLP$$], 0.6, 
       "degree of linear polarization (0 \[LessEqual] DOLP \[LessEqual] 1)"}, 
      0, 1}, {{
       Hold[$CellContext`orientation$$], 20, 
       "orientation of ellipse (0 \[LessEqual] \[Alpha] \[LessEqual] 180\
\[Degree])"}, 0, 180}, {{
       Hold[$CellContext`handedness$$], "left", "handedness"}, {
      "left", "right"}}}, Typeset`size$$ = {588., {172., 177.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`DOLP$11217$$ = 0, $CellContext`orientation$11218$$ = 
    0, $CellContext`handedness$11219$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`DOLP$$ = 0.6, $CellContext`handedness$$ = 
        "left", $CellContext`orientation$$ = 20}, "ControllerVariables" :> {
        Hold[$CellContext`DOLP$$, $CellContext`DOLP$11217$$, 0], 
        Hold[$CellContext`orientation$$, $CellContext`orientation$11218$$, 0], 
        Hold[$CellContext`handedness$$, $CellContext`handedness$11219$$, 
         False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`a$, $CellContext`b$, $CellContext`\[CapitalDelta]\
\[Phi]$, $CellContext`\[Alpha]$, $CellContext`Imax$, $CellContext`sx$, \
$CellContext`sy$, $CellContext`sz$, $CellContext`sxy$, $CellContext`ellipse$, \
$CellContext`principalAxes$, $CellContext`psaxes$, \
$CellContext`poincareSphere$, $CellContext`equators$, \
$CellContext`stokesVector$, $CellContext`circles$}, $CellContext`Imax$ = \
($CellContext`DOLP$$ + 1)/
          2; $CellContext`\[Alpha]$ = $CellContext`orientation$$ (Pi/
           180.); $CellContext`a$ = ($CellContext`Imax$ 
            Cos[$CellContext`\[Alpha]$]^2 + (1 - $CellContext`Imax$) 
            Sin[$CellContext`\[Alpha]$]^2)^
          Rational[1, 2]; $CellContext`b$ = (1 - $CellContext`a$^2)^
          Rational[1, 2]; $CellContext`\[CapitalDelta]\[Phi]$ = If[
           And[$CellContext`Imax$ == 1, $CellContext`\[Alpha]$ == 0], 0, 
           
           Switch[$CellContext`handedness$$, "right", 2 Pi - ArcTan[
            Sin[2 $CellContext`\[Alpha]$] (2 $CellContext`Imax$ - 1), 
             2 ($CellContext`Imax$ (1 - $CellContext`Imax$))^Rational[1, 2]], 
            "left", 
            ArcTan[
            Sin[2 $CellContext`\[Alpha]$] (2 $CellContext`Imax$ - 1), 
             2 ($CellContext`Imax$ (1 - $CellContext`Imax$))^
              Rational[
               1, 2]]]]; {$CellContext`sx$, $CellContext`sy$, \
$CellContext`sz$} = {$CellContext`a$^2 - $CellContext`b$^2, ((
             2 $CellContext`a$) $CellContext`b$) 
           Cos[$CellContext`\[CapitalDelta]\[Phi]$], ((
             2 $CellContext`a$) $CellContext`b$) 
           Sin[$CellContext`\[CapitalDelta]\[Phi]$]}; $CellContext`sxy$ = \
($CellContext`sx$^2 + $CellContext`sy$^2)^
          Rational[1, 2]; $CellContext`ellipse$ = 
         ParametricPlot[{$CellContext`a$ Cos[$CellContext`t], $CellContext`b$ 
            Cos[$CellContext`t + $CellContext`\[CapitalDelta]\[Phi]$]}, \
{$CellContext`t, 0, 2 Pi}, Mesh -> False, PlotStyle -> {
             Darker[Blue], 
             Thickness[0.01]}, Epilog -> {
             Darker[Blue], Thick, 
             Arrowheads[0.1], 
             Arrow[{(1 - $CellContext`Imax$)^Rational[1, 2] ({
                  Sin[$CellContext`\[Alpha]$], -
                  Cos[$CellContext`\[Alpha]$]} - (
                 Switch[$CellContext`handedness$$, "right", -1, "left", 
                   Plus[1]] 0.1) {
                  Cos[$CellContext`\[Alpha]$], 
                  Sin[$CellContext`\[Alpha]$]}), (1 - $CellContext`Imax$)^
                Rational[1, 2] ({
                  Sin[$CellContext`\[Alpha]$], -
                  Cos[$CellContext`\[Alpha]$]} + (
                  Switch[$CellContext`handedness$$, "right", -1, "left", 
                    Plus[1]] 0.1) {
                   Cos[$CellContext`\[Alpha]$], 
                   
                   Sin[$CellContext`\[Alpha]$]})}]}]; \
$CellContext`principalAxes$ = Graphics[{{
             Darker[Blue], Thin, 
             
             Line[{$CellContext`Imax$^
                Rational[1, 2] {-Cos[$CellContext`\[Alpha]$], -
                 Sin[$CellContext`\[Alpha]$]}, $CellContext`Imax$^
                Rational[1, 2] {
                 Cos[$CellContext`\[Alpha]$], 
                 Sin[$CellContext`\[Alpha]$]}}]}, {
             Darker[Blue], Thin, 
             
             Line[{(1 - $CellContext`Imax$)^
                Rational[1, 2] {-Sin[$CellContext`\[Alpha]$], 
                 Cos[$CellContext`\[Alpha]$]}, (1 - $CellContext`Imax$)^
                Rational[1, 2] {
                 Sin[$CellContext`\[Alpha]$], -
                 Cos[$CellContext`\[Alpha]$]}}]}}]; \
$CellContext`poincareSphere$ = Graphics3D[{{Black, 
             PointSize[0.02], 
             Point[{0, 0, 1}], 
             Point[{0, 0, -1}], 
             Point[{1, 0, 0}], 
             Point[{-1, 0, 0}], 
             Point[{0, 1, 0}], 
             Point[{0, -1, 0}]}, {
             Opacity[0.6], 
             Sphere[{0, 0, 0}, 1]}}]; $CellContext`psaxes$ = Graphics3D[
           ReplaceAll[{
             Line[$CellContext`ps {{-1, 0, 0}, {1, 0, 0}}], 
             Line[$CellContext`ps {{0, -1, 0}, {0, 1, 0}}], 
             Line[$CellContext`ps {{0, 0, -1}, {0, 0, 1}}], 
             Text[
             "\!\(\*SubscriptBox[\(S\), \(x\)]\)", {$CellContext`lp, 0, 0}], 
             Text[
             "\!\(\*SubscriptBox[\(S\), \(y\)]\)", {0, $CellContext`lp, 0}], 
             Text[
             "\!\(\*SubscriptBox[\(S\), \(z\)]\)", {
              0, 0, $CellContext`lp}]}, {$CellContext`ps -> 
             1.15, $CellContext`lp -> 1.3}]]; $CellContext`equators$ = {
           ParametricPlot3D[
            Evaluate[{
              Cos[$CellContext`t], 
              Sin[$CellContext`t], 0}], {$CellContext`t, 0, 2 Pi}, 
            PlotStyle -> {Black, Thin}], 
           ParametricPlot3D[
            Evaluate[{
              Cos[$CellContext`t], 0, 
              Sin[$CellContext`t]}], {$CellContext`t, 0, 2 Pi}, 
            PlotStyle -> {Black, Thin}], 
           ParametricPlot3D[
            Evaluate[{0, 
              Cos[$CellContext`t], 
              Sin[$CellContext`t]}], {$CellContext`t, 0, 2 Pi}, 
            PlotStyle -> {Black, Thin}]}; $CellContext`circles$ = {
           ParametricPlot3D[
            
            Evaluate[{
             Cos[2 $CellContext`\[Alpha]$] Cos[$CellContext`t], 
              Sin[2 $CellContext`\[Alpha]$] Cos[$CellContext`t], 
              Sin[$CellContext`t]}], {$CellContext`t, 0, 2 Pi}, 
            PlotStyle -> {Red, Thin}], 
           ParametricPlot3D[
            
            Evaluate[{$CellContext`sxy$ 
              Cos[$CellContext`t], $CellContext`sxy$ 
              Sin[$CellContext`t], $CellContext`sz$}], {$CellContext`t, 0, 2 
             Pi}, PlotStyle -> {Red, Thin}]}; $CellContext`stokesVector$ = 
         Graphics3D[{Red, 
            
            Sphere[{$CellContext`sx$, $CellContext`sy$, $CellContext`sz$}, 
             0.06], 
            Thickness[0.012]}]; Grid[{{
            Text[
             Style["polarization ellipse", 16]], 
            Text[
             Style["Poincar\[EAcute] sphere", 16]]}, {
            Pane[
             
             Show[$CellContext`ellipse$, $CellContext`principalAxes$, Frame -> 
              False, PlotRange -> 1, BaseStyle -> {Medium}, 
              AxesLabel -> {
               "\!\(\*SubscriptBox[\(E\), \(H\)]\)", 
                "\!\(\*SubscriptBox[\(E\), \(V\)]\)"}, ImageSize -> 260], {
             280, 280}, Alignment -> {Center, Top}], 
            Pane[
             
             Show[$CellContext`poincareSphere$, $CellContext`equators$, \
$CellContext`stokesVector$, $CellContext`circles$, $CellContext`psaxes$, Axes -> 
              False, PlotRange -> 1.2, BaseStyle -> {Medium}, Boxed -> False, 
              ViewPoint -> {1.3, 2.4, 1}, ImageSize -> 340], {300, 300}, 
             Alignment -> {Center, Top}]}, {
            Pane["", Alignment -> Center], 
            Pane[
             Row[
              Map[Text, {
                Style["\!\(\*SubscriptBox[\(S\), \(x\)]\)=", Italic], 
                NumberForm[
                 Chop[$CellContext`sx$], {2, 2}], 
                Style[",  \!\(\*SubscriptBox[\(S\), \(y\)]\)=", Italic], 
                NumberForm[
                 Chop[$CellContext`sy$], {2, 2}], 
                Style[",  \!\(\*SubscriptBox[\(S\), \(z\)]\)=", Italic], 
                NumberForm[
                 Chop[$CellContext`sz$], {2, 2}]}]], BaseStyle -> {14}, 
             Alignment -> {Center, Top}]}}]], 
      "Specifications" :> {{{$CellContext`DOLP$$, 0.6, 
          "degree of linear polarization (0 \[LessEqual] DOLP \[LessEqual] \
1)"}, 0, 1, Appearance -> 
         "Labeled"}, {{$CellContext`orientation$$, 20, 
          "orientation of ellipse (0 \[LessEqual] \[Alpha] \[LessEqual] 180\
\[Degree])"}, 0, 180, Appearance -> 
         "Labeled"}, {{$CellContext`handedness$$, "left", "handedness"}, {
         "left", "right"}}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{633., {242., 247.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->69254558],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "The polarization state of an electromagnetic wave can conveniently be \
described by a set of Stokes parameters. On the left, the polarization \
ellipse describes the motion of the optical electric field (",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["E", "H"], ",", " ", 
    RowBox[{
     SubscriptBox["E", "V"], 
     SuperscriptBox["e", "i\[CapitalDelta]\[Phi]"]}]}], TraditionalForm]], 
  "InlineMath"],
 ") in a plane transverse to the light propagation direction. On the right \
are the corresponding Stokes parameters defined in terms of intensity \
difference measurements"
}], "Text"]
}, Close]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "x"], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["I", "H"], "-", 
      SubscriptBox["I", "V"]}], "=", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["E", "H"], "2"], "-", 
      SuperscriptBox[
       SubscriptBox["E", "V"], "2"]}]}]}], TraditionalForm]], "InlineMath"],
 ","
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "y"], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["I", 
       RowBox[{
        RowBox[{"-", "45"}], "\[Degree]"}]], "-", 
      SubscriptBox["I", 
       RowBox[{
        RowBox[{"+", "45"}], "\[Degree]"}]]}], "=", 
     RowBox[{"2", 
      SubscriptBox["E", "H"], 
      SubscriptBox["E", "V"], 
      RowBox[{"cos", "(", 
       RowBox[{"\[CapitalDelta]", " ", "\[Phi]"}], ")"}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ","
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "z"], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["I", "L"], "-", 
      SubscriptBox["I", "R"]}], "=", 
     RowBox[{"2", 
      SubscriptBox["E", "H"], 
      SubscriptBox["E", "V"], 
      RowBox[{"sin", "(", 
       RowBox[{"\[CapitalDelta]", " ", "\[Phi]"}], ")"}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ","
}], "Text"],

Cell[TextData[{
 "where the intensities of the polarization components (",
 Cell[BoxData[
  FormBox["H", TraditionalForm]], "InlineMath"],
 ": horizontal, ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]], "InlineMath"],
 ": vertical, \[PlusMinus]45",
 Cell[BoxData[
  FormBox["\[Degree]", TraditionalForm]], "InlineMath"],
 ": along diagonals, ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 ": circular left, ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 ": circular right) are normalized to the total light intensity. The \
parameters that you can vary are the orientation of the ellipse, its degree \
of linear polarization ",
 Cell[BoxData[
  FormBox[
   RowBox[{"DOLP", "=", 
    FractionBox[
     RowBox[{
      SubscriptBox["I", "max"], "-", 
      SubscriptBox["I", "min"]}], 
     RowBox[{
      SubscriptBox["I", "max"], "+", 
      SubscriptBox["I", "min"]}]]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "max"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "min"], TraditionalForm]], "InlineMath"],
 " are the intensities measured along the major and minor axes, and its \
handedness (direction of rotation). For 100% polarized light, the endpoint of \
the Stokes vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["S", "\[RightVector]"], "=", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["S", "x"], ",", 
      SubscriptBox["S", "y"], ",", 
      SubscriptBox["S", "z"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 " lies on a unit sphere called the Poincar\[EAcute] sphere."
}], "Text"],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Light Polarization and Stokes Parameters",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
LightPolarizationAndStokesParameters/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/LightPolarizationAndStokesParameters/"],\

 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
LightPolarizationAndStokesParameters/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
LightPolarizationAndStokesParameters/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/LightPolarizationAndStokesParameters/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Gianni Di Domenico",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Gianni+Di+\
Domenico"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Gianni+Di+Domenico"],\

 " and ",
 ButtonBox["Antoine Weis",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Antoine+Weis"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Antoine+Weis"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
LightPolarizationAndStokesParameters"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Light Polarization and Stokes Parameters - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[642, 23, 160, 3, 70, "Section"],
Cell[805, 28, 3700, 64, 70, "Section"],
Cell[4508, 94, 25264, 584, 70, "Input",
 CellID->56198445]
}, Open  ]],
Cell[CellGroupData[{
Cell[29809, 683, 10183, 209, 70, "Output",
 CellID->69254558],
Cell[CellGroupData[{
Cell[40017, 896, 209, 6, 70, "Section"],
Cell[40229, 904, 624, 15, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[40879, 923, 383, 15, 70, "Text"],
Cell[41265, 940, 527, 20, 70, "Text"],
Cell[41795, 962, 415, 16, 70, "Text"],
Cell[42213, 980, 1666, 50, 70, "Text"],
Cell[CellGroupData[{
Cell[43904, 1034, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[44262, 1045, 1013, 30, 70, "Text"],
Cell[45278, 1077, 707, 23, 70, "Text"],
Cell[CellGroupData[{
Cell[46010, 1104, 815, 24, 70, "Text"],
Cell[46828, 1130, 1208, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature hQzy2wMgNvYIgDp@wcvhCBS7 *)
