(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18435,        517]
NotebookOptionsPosition[     17377,        478]
NotebookOutlinePosition[     18003,        502]
CellTagsIndexPosition[     17960,        499]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Fourier Series of Simple Functions", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PeriodicExtension", "[", 
        RowBox[{
         RowBox[{"k", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"k", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "+", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"k", "[", 
              RowBox[{"[", "3", "]"}], "]"}], " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"n", " ", "x"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"k", "[", 
              RowBox[{"[", "4", "]"}], "]"}], " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"n", " ", "x"}], "]"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "1", ",", "m"}], "}"}]}], "]"}]}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "r"}], ",", "r"}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True"}], "}"}]}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.003", "]"}], ",", "Black"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.003", "]"}], ",", "Blue"}], "}"}]}], 
       "}"}]}], " ", ",", "\[IndentingNewLine]", "              ", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "2", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Yellow", ",", "Orange"}], "}"}]}], "}"}]}], "}"}]}], ",", 
     
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"500", ",", "400"}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "30"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"{", 
        RowBox[{"Sign", ",", "0", ",", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"Pi", "*", "n"}], ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", 
             RowBox[{"Cos", "[", 
              RowBox[{"n", "*", "Pi"}], "]"}]}], "+", "1"}], ")"}]}], ",", 
         "0"}], "}"}], ",", "\"\<function\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Sign", ",", "0", ",", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"Pi", "*", "n"}], ")"}]}], "*", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"2", 
              RowBox[{"Cos", "[", 
               RowBox[{"n", "*", "Pi"}], "]"}]}]}], ")"}]}], ",", "0"}], 
         "}"}], "\[Rule]", "\"\<step\>\""}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "&"}], ",", "0", ",", 
          RowBox[{"2", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "/", "n"}]}], ",", "0"}], 
         "}"}], "\[Rule]", "\"\<sawtooth\>\""}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "^", "2"}], "&"}], ",", 
          FractionBox[
           SuperscriptBox["\[Pi]", "2"], "3"], ",", "0", ",", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "n"]}], 
           SuperscriptBox["n", "2"]]}], "}"}], "\[Rule]", 
        "\"\<parabola\>\""}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"#", "-", "Pi"}], " ", ")"}], 
            RowBox[{"(", 
             RowBox[{"#", "+", "Pi"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"#", "-", "1"}], ")"}]}], "&"}], ",", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["\[Pi]", "2"]}], "3"], ",", 
          FractionBox[
           RowBox[{"12", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "n"]}], 
           SuperscriptBox["n", "3"]], ",", 
          RowBox[{"-", 
           FractionBox[
            RowBox[{" ", 
             RowBox[{"4", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "n"]}]}], 
            SuperscriptBox["n", "2"]]}]}], "}"}], "\[Rule]", 
        "\"\<cubic\>\""}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Sin", "[", "#", "]"}], 
             RowBox[{"UnitStep", "[", "#", "]"}]}], ")"}], "&"}], ",", 
          RowBox[{"1", "/", "Pi"}], ",", 
          RowBox[{
           RowBox[{"KroneckerDelta", "[", 
            RowBox[{"n", ",", "1"}], "]"}], "/", "2"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"n", "\[Equal]", "1"}], ",", "0", ",", 
            RowBox[{"(", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{"1", "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "n"]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SuperscriptBox["n", "2"]}], ")"}], " ", "\[Pi]"}]]}], 
             ")"}]}], "]"}]}], "}"}], "\[Rule]", 
        "\"\<half-wave rectifier\>\""}]}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", ",", "3", ",", "\"\<number of terms\>\""}], "}"}], ",", 
     "1", ",", "50", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", "Pi", ",", "\"\<x range\>\""}], "}"}], ",", "Pi", ",",
      
     RowBox[{"5", "*", "Pi"}], ",", "Pi", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"PeriodicExtension", "[", 
        RowBox[{"g_", ",", "x_"}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", "x", "]"}], "<", "Pi"}], ",", 
         RowBox[{"g", "[", "x", "]"}], ",", 
         RowBox[{"PeriodicExtension", "[", 
          RowBox[{"g", ",", 
           RowBox[{"x", "-", 
            RowBox[{"2", 
             RowBox[{"Sign", "[", "x", "]"}], "Pi"}]}]}], "]"}]}], "]"}]}], 
      ")"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.3987760529337587`*^9, {3.398776195193953*^9, 
   3.398776196242725*^9}, {3.398811421859375*^9, 3.398811439328125*^9}}]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`k$$ = {
    Sign, 0, ($CellContext`n^(-1)/Pi) (2 - 2 Cos[$CellContext`n Pi]), 
     0}, $CellContext`m$$ = 3, $CellContext`r$$ = Pi, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`k$$], {
       Sign, 0, ($CellContext`n^(-1)/Pi) (2 - 2 Cos[$CellContext`n Pi]), 0}, 
       "function"}, {{
        Sign, 0, ($CellContext`n^(-1)/Pi) (2 - 2 Cos[$CellContext`n Pi]), 0} -> 
       "step", {#& , 0, 2 ((-1)^(1 + $CellContext`n)/$CellContext`n), 0} -> 
       "sawtooth", {#^2& , Rational[1, 3] Pi^2, 
         0, (4 (-1)^$CellContext`n) $CellContext`n^(-2)} -> 
       "parabola", {((# - Pi) (# + Pi)) (# - 1)& , Rational[2, 3] 
         Pi^2, (12 (-1)^$CellContext`n) $CellContext`n^(-3), ((-4) \
(-1)^$CellContext`n) $CellContext`n^(-2)} -> 
       "cubic", {
        Sin[#] UnitStep[#]& , Pi^(-1), Rational[1, 2] 
         KroneckerDelta[1, $CellContext`n], 
         If[$CellContext`n == 1, 
          0, -((1 + (-1)^$CellContext`n)/((-1 + $CellContext`n^2) Pi))]} -> 
       "half-wave rectifier"}}, {{
       Hold[$CellContext`m$$], 3, "number of terms"}, 1, 50, 1}, {{
       Hold[$CellContext`r$$], Pi, "x range"}, Pi, 5 Pi, Pi}}, 
    Typeset`size$$ = {500., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`k$126935$$ = False, $CellContext`m$126936$$ = 
    0, $CellContext`r$126937$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`k$$ = {
         Sign, 0, ($CellContext`n^(-1)/Pi) (2 - 2 Cos[$CellContext`n Pi]), 
          0}, $CellContext`m$$ = 3, $CellContext`r$$ = Pi}, 
      "ControllerVariables" :> {
        Hold[$CellContext`k$$, $CellContext`k$126935$$, False], 
        Hold[$CellContext`m$$, $CellContext`m$126936$$, 0], 
        Hold[$CellContext`r$$, $CellContext`r$126937$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[{
         $CellContext`PeriodicExtension[
          Part[$CellContext`k$$, 1], $CellContext`x], 
         Evaluate[
         Part[$CellContext`k$$, 2] + 
          Sum[Part[$CellContext`k$$, 3] Sin[$CellContext`n $CellContext`x] + 
            Part[$CellContext`k$$, 4] 
             Cos[$CellContext`n $CellContext`x], {$CellContext`n, 
             1, $CellContext`m$$}]]}, {$CellContext`x, -$CellContext`r$$, \
$CellContext`r$$}, Axes -> {True, True}, PlotStyle -> {{
           Thickness[0.003], Black}, {
           Thickness[0.003], Blue}}, 
        Filling -> {1 -> {{2}, {Yellow, Orange}}}, ImageSize -> {500, 400}, 
        ImagePadding -> 30], 
      "Specifications" :> {{{$CellContext`k$$, {
          Sign, 0, ($CellContext`n^(-1)/Pi) (2 - 2 Cos[$CellContext`n Pi]), 
           0}, "function"}, {{
           Sign, 0, ($CellContext`n^(-1)/Pi) (2 - 2 Cos[$CellContext`n Pi]), 
            0} -> "step", {#& , 0, 
            2 ((-1)^(1 + $CellContext`n)/$CellContext`n), 0} -> 
          "sawtooth", {#^2& , Rational[1, 3] Pi^2, 
            0, (4 (-1)^$CellContext`n) $CellContext`n^(-2)} -> 
          "parabola", {((# - Pi) (# + Pi)) (# - 1)& , Rational[2, 3] 
            Pi^2, (12 (-1)^$CellContext`n) $CellContext`n^(-3), ((-4) \
(-1)^$CellContext`n) $CellContext`n^(-2)} -> 
          "cubic", {
           Sin[#] UnitStep[#]& , Pi^(-1), Rational[1, 2] 
            KroneckerDelta[1, $CellContext`n], 
            
            If[$CellContext`n == 1, 
             0, -((1 + (-1)^$CellContext`n)/((-1 + $CellContext`n^2) Pi))]} -> 
          "half-wave rectifier"}}, {{$CellContext`m$$, 3, "number of terms"}, 
         1, 50, 1, Appearance -> 
         "Labeled"}, {{$CellContext`r$$, Pi, "x range"}, Pi, 5 Pi, Pi, 
         Appearance -> "Labeled"}}, 
      "Options" :> {AutorunSequencing -> Automatic}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{544., {267., 272.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`PeriodicExtension[
         Pattern[$CellContext`g, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := If[Abs[$CellContext`x] < Pi, 
         $CellContext`g[$CellContext`x], 
         $CellContext`PeriodicExtension[$CellContext`g, $CellContext`x - (2 
           Sign[$CellContext`x]) Pi]]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->104904270],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Fourier Series of Simple Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/FourierSeriesOfSimpleFunctions/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/FourierSeriesOfSimpleFunctions/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/FourierSeriesOfSimpleFunctions/\
",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/FourierSeriesOfSimpleFunctions/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/FourierSeriesOfSimpleFunctions/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Alain Goriely",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Alain+Goriely"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Alain+Goriely"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
FourierSeriesOfSimpleFunctions"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Fourier Series of Simple Functions - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (February 7, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 226, 4, 70, "Section"],
Cell[819, 29, 7279, 209, 70, "Input"]
}, Open  ]],
Cell[8113, 241, 5012, 99, 70, "Output",
 CellID->104904270],
Cell[CellGroupData[{
Cell[13150, 344, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[13526, 355, 981, 29, 70, "Text"],
Cell[14510, 386, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[14850, 397, 436, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[15311, 415, 829, 24, 70, "Text"],
Cell[16143, 441, 1206, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature fRzvXsecIpjvhDDOSXnQ7m83 *)
