(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     30447,        740]
NotebookOptionsPosition[     29183,        692]
NotebookOutlinePosition[     29846,        717]
CellTagsIndexPosition[     29803,        714]
WindowTitle->Constructive and Destructive Interference - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Constructive and Destructive Interference", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG
xoZzQu3Aku7VfUj4Nk53//fLn//78q+Xl5f/NP/88e+Xl8v154Xj5+fp89y0
4+X63L7VnQu02XqOt9FzjRK5qtRMoYZFpk11/Ji+WDye92+r7+fFfbnGkuu9
eIQ4LBVJ+YRo5DPnRdITDp0TLRg6m/62nY/n08f5+H461G37fWqum57z4Xy2
jby0prMZOh4/jodLOx2bt6fzRSEA3B/KMKGSBy/DSKVcyYOn8krHqajvqed6
G6iol4qkfAIVNQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADsizPA/lj72AEA
AMCmWLu0AXh01j6jAAAAcdb+hNwUJ5e1zZnPDEeey/e1jx0AAABsirVLm03x
XFVlhs1X1JNY+4wCAAB02B9PJ4BdsvYpBAAAgOeGihpADo9GAUDIr+Lnr7ef
a9vw16/i73VtMPx6+2v1gGwMijeAE89FAQA2DRW1BxX14lBRA0wi+lx0baMA
AAAAAAAAAAAAbkj0uegR4L4cDoe1TYA1YQMAbIaDy9rm3JU9+w4AjwB3np3D
BgDYDHuuKu/su3k0ynNRACGLHMy93dm2ijCPpHvD7LliAQAAmA0VNRioqIGK
GlYk9Vz0AAAAAAAAAAAAALBR9KPR8Kf0a9sFAAAAAAAAAAAAcCt4LgoAAAAA
AAAAAAB7I/Vc9ONheH9/X9uEzUJsZ0PoAGBZ3gNuLQgggR21GUjl7SC2syF0
ALAsVNQgxMv14XAI/xOja9sIAAAAT0lYWM5jbT/msGffAQAAAGAp9lxV3sF3
b1r0uehSZgAAAAAAAAAAAAA8Ar9b6rpuXpu3+tf0PBcFWJcFvxYBAAAAANgh
VNQAADCK5LnobwAAAAAAAAAAAIANUbcPRav+wehH7LmoUqpsqKqmNTSXRVE0
by593mtRXlrfo7mImTlVN6ebUOhR07q3jmxVWXqquqxVOUjZq1eDVNe662ro
Nxe1Xr5o2lt5cUc7VWr3BpGindNL6TkDl5nVIGWtbuaXWbwJo/OVKjSX68oL
shMTO4ylHf+yy5GbhU5EubJJPeWgx5ayBfvOIR2qD5QJXWmFtJs2pLsLvu40
4oOesh/tJ3TKW/3DomZONgVdVPtNXvVXYWydyBRl/NWNWNW62L06G344TcNW
L/SVpaTqcmeOWGWOm3W+TFPWsbL8dE1yklUal73ghDtBH+Hu1dE/HBM7/t7h
sjNoN29Calrl2GadWfsMeoc0elcR584clrm5qzO5a+5mQe4imy2Tu1qcu+g2
7od7mkvVtqJtajgInQuqzUrRtWFCzIAkzQdK0/RR1U33JEhtgOhosnmLKtX0
DArVhaJHtZOlmgPbVN+mWZhRGzNvEc13MD61kIRcEPS2WciRp/C97a0ow569
DCOVRurZU0lFnUoBFbWkKiv7I0xFLc4dFXUAFfVUtVTUYRD2V1EnfTd7u920
v+va/NXoSXM86qXVwFtzgNvS7vJG3730Ga76Wkq/6lFz3dlWOa+69XpUOSix
ixQtrrVV1pxBleO+uesMsv6QjenXF+bViFjGO5rtObaUp7bVoENe21Kqy1Un
1M8xOaxNftysOh61q5joKStQpbkIQ2p54HRWXcqsOsbVU7oZNBr8Fbv+yotk
GBkvbuFbu9/LkY6DF3ZvTvqtOVXdBi0dlN6WZekEsHfQ2flmjpnQ+25vfn//
2yH1eswnokp/tNkpsJNrTqJruX4tzAkKBJXJVdUbbJmtrwtrUfuoGm2Ru5S3
AcrEGQyPld3jzbFTH+oP+is3d+XVuev2wI1zN9w8rZM1I3dFf203xxKvuUyT
TevJkd8JSzF7iVHBzJa+D0vFZJLapawNh6xiQ91ixaf03R+lDHvaMqwPCKl8
+lRGgkZF3W3Q0oGKmoq685yKmoo6L5jZ0vdhqZhMUruUteEQFfUk37VU98C8
qRvq+uPjQz8UPZ/P+snoZYIqVAwtaFY0r+E0+8l8VIM3Gs70JkelUoLR0XBm
2X5dldcmWS5lQ2r1jDue+DBaRvrzvidVpc2WOKJicRvVZu+HaFqjgpngC/MS
Fek2rRvSjKCy9rnxfepWFFKokVMzWaEsU9GDbEYnbfuoYOpGkdcwql/Sv+fc
CVdJcY1a+Yo3WuUaZsfE+9S+j3mTRuFZoAxL9eTtFK6ecccTH0bnlmGkMtXz
dKnMLCTpifZTUUfnyNOR4QGrstQuHTXGFqSiXiV3wlVSXKNWvuKNVrmG2TGh
ooZb0+T0rUWf/br9e1HvuWjR/z1/+JOUIujKPxYu+l9YCEX0kGVARDxjjHxa
ygZv6ejF6KiE0cfp0eUk6JMrmVamQx1qkPTIRzNSo4LC0OnbV7S/tD7WRw32
ElFYP1/y7EkZn09lPhHedej7vDiHSkbzq79YsWcWfUUUzYgXf7mdqa04eiK0
ebYxe86d9yE+T3n+OzuVqHbMx01Up/kkCud7Q0ZJ5uvCRQhNGvVCoueayK9O
mKP8qDDd9szol7b5AM5LSup0P7LvxXBX8dWGvlCGTTJm1IBwianK3QySyo2k
clR/KtShBkmPfDQjNSpIRS0xexJRy8NjS0UtMfVBcmegoh6FijrkEarKPVfU
Gd89w+rwd/Tt34uq/kuT6C2xsG5WhXvLsu+KUb+8/kxsvQMryUIxdp8PLc/c
FiblXaJEcgvKuODFf54N8yYXwYejZ2fUbO8i5b7kXwRSPfJtFu1JWZ7BtlZu
eRg9XXJEbcuriorIU2xkjYjQi2hJFjXeFvFmhjeNUWu9HhO3/LQoe8tdSKqC
ys+f+tE5aZVoBSU0T87U+sr2emq4Ur7k9eQrhydiaqiF3LqSX4QFfacMk684
yaT7l2GkUr7iJJOoqKMrUlGPritxZ9RyT9aIUFHn133e3IVQUQvVUlHPhor6
1r6r/k9G9X1A/47+dDrZ/9+lb9++vbr8+PHDe7X7w077rafHU+JNTo1GF/Wu
U52hhtCjqGEZJVGdoZsp5ZmZoRe2kc3Fd0tnKGKvJQ9UKr8pRh15dY0MZTOO
e/pTa43OSUmFpn5Pbzzv7agveTNCJRnZ70FCX4OU5ZWn9KfiELrpLZ3aIZn0
RYmGN+NRPsIpd7y19pa7qIhQZ15coicVmamMLjpb1SLmLUgmzlOtzau6RRAm
bYxFTJoh9Vy+U4aNKonqDN1MKc/MDL2wjXydWIaRylElz5LKVExSS2Scigqm
HHl1jQxlM457+lNrjc5JSYWmUlF7jqQ2RmqHZNIXJRrejEf5CKfc8dbaW+6i
IkKdeXGJnlRkpjK66GxVi5i3IJk4T7U2r+oWQZi0MRYxaYbUZnyPLvH/lte2
FP/69esnAAAAAAAAAAAAwM74B4thROM=
   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", ".5", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "2"}], ",", 
               RowBox[{"-", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1.5`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1.15`"}], ",", "1.5`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1.15`"}], ",", 
               RowBox[{"-", "1.5`"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", 
               RowBox[{"-", "1.4`"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", 
               RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", 
               RowBox[{"-", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1.5`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1.15`", ",", "1.5`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1.15`", ",", 
               RowBox[{"-", "1.5`"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", 
               RowBox[{"-", "1.5`"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", 
               RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0.85`", ",", 
               RowBox[{"-", "1.5`"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0.85`", ",", "1.5`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "0.85`"}], ",", "1.5`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "0.85`"}], ",", 
               RowBox[{"-", "1.5`"}]}], "}"}]}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Opacity", "[", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"4", " ", "d"}], "]"}], "2"], "]"}], ",", 
            RowBox[{"Polygon", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"2", ",", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "d"}], ",", 
                 RowBox[{"-", "1.5"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "d"}], ",", "1.5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", ".05", "+", "d"}], ",", "1.5"}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", ".05", "+", "d"}], ",", 
                 RowBox[{"-", "1.5"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
          
          RowBox[{"{", 
           RowBox[{"d", ",", "0", ",", "4", ",", ".05"}], "}"}]}], "]"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "1."}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1"}], ",", "1."}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{
              RowBox[{"2", 
               RowBox[{"Tan", "[", "\[Theta]", "]"}]}], "+", "1"}], ",", 
             "1."}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{
              RowBox[{"2", 
               RowBox[{"Tan", "[", "\[Theta]", "]"}]}], "+", "1"}], ",", 
             RowBox[{"-", "1."}]}], "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", 
             RowBox[{"-", "1."}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "1."}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{
              RowBox[{"2", 
               RowBox[{"Tan", "[", "\[Theta]", "]"}]}], "+", "1"}], ",", 
             "1."}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{
              RowBox[{"2", 
               RowBox[{"Tan", "[", "\[Theta]", "]"}]}], "+", "1"}], ",", 
             RowBox[{"-", "1."}]}], "}"}]}], "}"}], "]"}], ",", "Red", ",", 
        RowBox[{"Thickness", "[", ".01", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"RotationMatrix", "[", 
              RowBox[{"\[Theta]", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], ".", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"t", ",", "0", ",", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"10", "t"}], "]"}]}], "}"}], "/.", 
               RowBox[{"t", "->", 
                RowBox[{"Norm", "[", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", 
                   RowBox[{"2", 
                    RowBox[{"Tan", "[", "\[Theta]", "]"}]}]}], "}"}], 
                 "]"}]}]}], ")"}]}], "+", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"RotationMatrix", "[", 
              RowBox[{
               RowBox[{"ArcTan", "[", 
                RowBox[{"2", ",", 
                 RowBox[{"2", "+", 
                  RowBox[{"2", 
                   RowBox[{"Tan", "[", "\[Theta]", "]"}]}]}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], ".", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"t", ",", "0", ",", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"10", "t"}], "]"}]}], "}"}], "/.", 
               RowBox[{"t", "->", 
                RowBox[{"Norm", "[", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", 
                   RowBox[{
                    RowBox[{"2", 
                    RowBox[{"Tan", "[", "\[Theta]", "]"}]}], "+", "2"}]}], 
                  "}"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]}], "}"}], "]"}]}], 
       "}"}], "]"}], ",", 
     RowBox[{
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "1", ",", 
          RowBox[{"Sin", "[", 
           RowBox[{"10", "t"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"Norm", "[", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"2", 
              RowBox[{"Tan", "[", "\[Theta]", "]"}]}]}], "}"}], "]"}]}], 
         "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "/.", 
      RowBox[{
       RowBox[{"Line", "[", "l_", "]"}], ":>", 
       RowBox[{"Rotate", "[", 
        RowBox[{
         RowBox[{"Line", "[", "l", "]"}], ",", "\[Theta]", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"Sin", "[", 
           RowBox[{"10", "t"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"Norm", "[", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{
              RowBox[{"2", 
               RowBox[{"Tan", "[", "\[Theta]", "]"}]}], "+", "2"}]}], "}"}], 
           "]"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "/.", 
      RowBox[{
       RowBox[{"Line", "[", "l_", "]"}], ":>", 
       RowBox[{"Rotate", "[", 
        RowBox[{
         RowBox[{"Line", "[", "l", "]"}], ",", 
         RowBox[{"ArcTan", "[", 
          RowBox[{"2", ",", 
           RowBox[{"2", "+", 
            RowBox[{"2", 
             RowBox[{"Tan", "[", "\[Theta]", "]"}]}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]}]}], ",", 
     RowBox[{"Boxed", "->", "False"}], ",", 
     RowBox[{"BoxRatios", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "1"}], "}"}]}], ",", 
     RowBox[{"SphericalRegion", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{"-", "0.732`"}]}], "}"}], ",", 
     RowBox[{"-", ".98"}], ",", ".46"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.43645074571875*^9, 3.436450867265625*^9}, {
   3.436450948234375*^9, 3.43645105165625*^9}, {3.436451092921875*^9, 
   3.4364511393125*^9}, {3.4364512061875*^9, 3.43645127675*^9}, {
   3.43645131428125*^9, 3.43645140309375*^9}, {3.436451575*^9, 
   3.436451616703125*^9}, {3.43645247346875*^9, 3.436452475890625*^9}, {
   3.43645254153125*^9, 3.436452553328125*^9}, {3.4364527216875*^9, 
   3.43645273003125*^9}, 3.4364527758125*^9, {3.436452814859375*^9, 
   3.43645283334375*^9}, {3.436452906296875*^9, 3.43645291090625*^9}, {
   3.436452969*^9, 3.436453006796875*^9}, {3.436453051265625*^9, 
   3.436453057921875*^9}, {3.4364531156875*^9, 3.43645315565625*^9}, {
   3.436453190734375*^9, 3.436453210328125*^9}, {3.436453295265625*^9, 
   3.4364532960625*^9}, {3.43645333696875*^9, 3.436453337203125*^9}, 
   3.4364533843125*^9, {3.436457079109375*^9, 3.43645708253125*^9}, {
   3.436457216796875*^9, 3.43645721715625*^9}, {3.436457255875*^9, 
   3.43645726303125*^9}, {3.4364573180625*^9, 3.436457342796875*^9}, {
   3.436457398109375*^9, 3.436457425671875*^9}, {3.436457811171875*^9, 
   3.436457865296875*^9}, {3.436457897046875*^9, 3.436457990828125*^9}, {
   3.4364580370625*^9, 3.43645804078125*^9}, {3.436458090921875*^9, 
   3.436458093390625*^9}, {3.4364582874375*^9, 3.436458384203125*^9}, {
   3.436458935671875*^9, 3.43645895096875*^9}, {3.43646106528125*^9, 
   3.43646106875*^9}, {3.436461143375*^9, 3.43646120646875*^9}, {
   3.43646228015625*^9, 3.43646228703125*^9}, 3.43646244665625*^9, {
   3.436462511046875*^9, 3.436462545234375*^9}, {3.436465438421875*^9, 
   3.436465442453125*^9}, {3.436465559265625*^9, 3.43646555971875*^9}, {
   3.4364662771875*^9, 3.436466281796875*^9}, {3.43647417884375*^9, 
   3.436474182546875*^9}, {3.436474737984375*^9, 3.4364747653125*^9}, {
   3.4364757148125*^9, 3.436475756296875*^9}, {3.4364759004375*^9, 
   3.436475908875*^9}, {3.436476342796875*^9, 3.43647634303125*^9}, {
   3.436478083953125*^9, 3.436478085921875*^9}, {3.4364781165*^9, 
   3.436478118265625*^9}, {3.4364807846875*^9, 3.43648079390625*^9}, {
   3.4366404939687643`*^9, 3.436640546695662*^9}, {3.4366406955228443`*^9, 
   3.436640710268733*^9}, {3.4366408165525303`*^9, 3.4366408557274847`*^9}, {
   3.436640886610587*^9, 3.436640916994442*^9}, {3.436641134391609*^9, 
   3.436641148171623*^9}, {3.436641180580195*^9, 3.436641252226226*^9}, {
   3.436641284442471*^9, 3.4366412848753433`*^9}, {3.4366413564508953`*^9, 
   3.436641373297634*^9}, {3.4366414983657627`*^9, 3.436641498758114*^9}, 
   3.436641555503422*^9, 3.4366416265675297`*^9, {3.436641672394517*^9, 
   3.436641677810318*^9}, {3.4366417198469563`*^9, 3.4366417269442663`*^9}, {
   3.436646707500387*^9, 3.436646718814193*^9}, {3.436646861045127*^9, 
   3.4366469732107687`*^9}, {3.436647131448587*^9, 3.436647145397008*^9}, {
   3.436647180511951*^9, 3.436647233520347*^9}, {3.4366473450442047`*^9, 
   3.43664735116854*^9}, {3.438638516730624*^9, 3.438638531228544*^9}, {
   3.438638575729764*^9, 3.4386386118648777`*^9}, {3.4386387848597517`*^9, 
   3.438638838907115*^9}, {3.438638892526932*^9, 3.438638934831436*^9}, 
   3.438638982100822*^9, {3.4386391421763563`*^9, 3.438639155692943*^9}, 
   3.438640488088238*^9, {3.4386405193686657`*^9, 3.4386405365057173`*^9}, {
   3.43864069577894*^9, 3.4386407030198812`*^9}, {3.4386407928712463`*^9, 
   3.438640830797697*^9}, {3.4386411382153587`*^9, 3.438641138377211*^9}, {
   3.4386420602511063`*^9, 3.438642118172007*^9}, {3.438642589853413*^9, 
   3.43864259290556*^9}, {3.438642628607257*^9, 3.438642657752803*^9}, {
   3.438643366762236*^9, 3.438643381322379*^9}, {3.4386434499923067`*^9, 
   3.438643460085475*^9}, {3.4386435176174393`*^9, 3.4386435221274347`*^9}, {
   3.4386447539975023`*^9, 3.438644755903861*^9}, {3.438644797021946*^9, 
   3.438644797303649*^9}, {3.438645164528124*^9, 3.438645165308743*^9}, {
   3.438645208817621*^9, 3.4386452095584717`*^9}, {3.438645664729554*^9, 
   3.438645665887052*^9}, {3.438646502154482*^9, 3.438646506602116*^9}, {
   3.438646541203979*^9, 3.438646544128841*^9}, {3.438646593269885*^9, 
   3.43864660417337*^9}, {3.438646667201927*^9, 3.438646674367682*^9}, {
   3.438649392337783*^9, 3.4386493937955914`*^9}, 3.4386496907276573`*^9, {
   3.438649737118763*^9, 3.438649737732523*^9}, {3.438649796346999*^9, 
   3.438649796967671*^9}, {3.438649842292244*^9, 3.4386498431668587`*^9}, {
   3.442086504568233*^9, 3.442086504804574*^9}, {3.44208811013647*^9, 
   3.4420881612995768`*^9}, {3.442088222430851*^9, 3.442088242426773*^9}, {
   3.4420885985479813`*^9, 3.442088629665482*^9}, {3.442088701811837*^9, 
   3.4420887701376553`*^9}, 3.4420889264838057`*^9, {3.442089169820677*^9, 
   3.4420892047141457`*^9}, {3.44208932202628*^9, 3.442089350327981*^9}, {
   3.44208938779494*^9, 3.442089396006605*^9}, {3.44208943993855*^9, 
   3.442089444473343*^9}, {3.4420897370269527`*^9, 3.4420897599252863`*^9}, 
   3.442092016299426*^9, {3.44209205169516*^9, 3.442092067336011*^9}, {
   3.44209341686412*^9, 3.442093418124202*^9}, {3.4420935729761457`*^9, 
   3.442093596791717*^9}, 3.44209458552953*^9, 3.442094639956114*^9, 
   3.442095039357744*^9, 3.44209513861726*^9, {3.442097053285658*^9, 
   3.442097053642766*^9}, {3.4420975796821613`*^9, 3.4420975874040003`*^9}, {
   3.442097618494315*^9, 3.442097619138727*^9}, {3.442097708075405*^9, 
   3.442097717424209*^9}, {3.442097798169598*^9, 3.442097856699428*^9}, 
   3.442107921359375*^9},
 CellID->34292817]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Theta]$$ = -0.732, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Theta]$$], -0.732}, -0.98, 0.46}}, 
    Typeset`size$$ = {360., {178., 182.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`\[Theta]$173249$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Theta]$$ = -0.732}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$173249$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Graphics3D[{
          Opacity[0.5], 
          EdgeForm[], 
          
          Polygon[{{{0, -2, -2}, {0, -2, 2}, {0, 0, 2}, {0, 0, 1.5}, {
             0, -1.15, 1.5}, {0, -1.15, -1.5}, {0, 0, -1.4}, {0, 0, -2}}, {{0,
              2, -2}, {0, 2, 2}, {0, 0, 2}, {0, 0, 1.5}, {0, 1.15, 1.5}, {
             0, 1.15, -1.5}, {0, 0, -1.5}, {0, 0, -2}}, {{0, 0.85, -1.5}, {
             0, 0.85, 1.5}, {0, -0.85, 1.5}, {0, -0.85, -1.5}}}], 
          Table[{
            Opacity[Sin[4 $CellContext`d]^2], 
            
            Polygon[{{2, -2 + $CellContext`d, -1.5}, {
              2, -2 + $CellContext`d, 1.5}, {
              2, -2 + 0.05 + $CellContext`d, 1.5}, {
              2, -2 + 0.05 + $CellContext`d, -1.5}}]}, {$CellContext`d, 0, 4, 
            0.05}], 
          
          Polygon[{{0, -1, -1.}, {0, -1, 1.}, {
            2, 2 Tan[$CellContext`\[Theta]$$] + 1, 1.}, {
            2, 2 Tan[$CellContext`\[Theta]$$] + 1, -1.}}], 
          
          Polygon[{{0, 1, -1.}, {0, 1, 1.}, {
            2, 2 Tan[$CellContext`\[Theta]$$] + 1, 1.}, {
            2, 2 Tan[$CellContext`\[Theta]$$] + 1, -1.}}], Red, 
          Thickness[0.01], 
          Line[{Dot[
              RotationMatrix[$CellContext`\[Theta]$$, {0, 0, 1}], 
              ReplaceAll[{$CellContext`t, 0, 
                Sin[10 $CellContext`t]}, $CellContext`t -> 
               Norm[{2, 2 Tan[$CellContext`\[Theta]$$]}]]] + {0, 1, 0}, Dot[
              RotationMatrix[
               ArcTan[2, 2 + 2 Tan[$CellContext`\[Theta]$$]], {0, 0, 1}], 
              ReplaceAll[{$CellContext`t, 0, 
                Sin[10 $CellContext`t]}, $CellContext`t -> 
               Norm[{2, 2 Tan[$CellContext`\[Theta]$$] + 2}]]] - {0, 1, 
            0}}]}], 
        ReplaceAll[
         ParametricPlot3D[{$CellContext`t, 1, 
           Sin[10 $CellContext`t]}, {$CellContext`t, 0, 
           Norm[{2, 2 Tan[$CellContext`\[Theta]$$]}]}, PlotRange -> All], Line[
           Pattern[$CellContext`l$, 
            Blank[]]] :> Rotate[
           Line[$CellContext`l$], $CellContext`\[Theta]$$, {0, 0, 1}, {0, 1, 
           0}]], 
        ReplaceAll[
         ParametricPlot3D[{$CellContext`t, -1, 
           Sin[10 $CellContext`t]}, {$CellContext`t, 0, 
           Norm[{2, 2 Tan[$CellContext`\[Theta]$$] + 2}]}, PlotRange -> All], 
         Line[
           Pattern[$CellContext`l$, 
            Blank[]]] :> Rotate[
           Line[$CellContext`l$], 
           ArcTan[2, 2 + 2 Tan[$CellContext`\[Theta]$$]], {0, 0, 1}, {0, -1, 
           0}]], Boxed -> False, BoxRatios -> {2, 4, 1}, SphericalRegion -> 
        True], "Specifications" :> {{{$CellContext`\[Theta]$$, -0.732}, -0.98,
          0.46}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{405., {222., 227.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->80587003],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Two waves are said to interfere with each other when they pass though the \
same medium at the same time; sometimes the waves reinforce each other and \
sometimes they cancel, depending on their relative phases.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell["\<\
The figure shows waves emerging from two slits that hit a screen and yield \
bright and dark strips  corresponding to constructive and destructive \
interference.\
\>", "Text"],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Constructive and Destructive Interference",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
ConstructiveAndDestructiveInterference/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ConstructiveAndDestructiveInterference/\
"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
ConstructiveAndDestructiveInterference/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
ConstructiveAndDestructiveInterference/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ConstructiveAndDestructiveInterference/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Enrique Zeleny",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->260342157],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
ConstructiveAndDestructiveInterference"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Constructive and Destructive Interference - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[643, 23, 161, 3, 70, "Section"],
Cell[807, 28, 3700, 64, 70, "Section"],
Cell[4510, 94, 15831, 352, 70, "Input",
 CellID->34292817]
}, Open  ]],
Cell[CellGroupData[{
Cell[20378, 451, 4174, 88, 70, "Output",
 CellID->80587003],
Cell[CellGroupData[{
Cell[24577, 543, 209, 6, 70, "Section"],
Cell[24789, 551, 235, 4, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[25050, 559, 186, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[25261, 567, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[25619, 578, 1024, 30, 70, "Text"],
Cell[26646, 610, 456, 15, 70, "Text",
 CellID->260342157],
Cell[CellGroupData[{
Cell[27127, 629, 815, 24, 70, "Text"],
Cell[27945, 655, 1210, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 4Tj1gXPgIUO6MB0xN4PTu3je *)
