(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   2219250,      42582]
NotebookOptionsPosition[   2217863,      42532]
NotebookOutlinePosition[   2218521,      42557]
CellTagsIndexPosition[   2218478,      42554]
WindowTitle->Constructing A Simple Optical System - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Constructing A Simple Optical System", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Opacity", "[", "0.8", "]"}], ",", " ", 
            RowBox[{"GeometricTransformation", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", " ", 
                RowBox[{"AbsolutePointSize", "[", "1", "]"}], ",", " ", 
                RowBox[{"EdgeForm", "[", "]"}], ",", " ", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.4", ",", " ", "0.6", ",", " ", "0.8"}], "]"}], 
                ",", " ", 
                RowBox[{"Polygon", "[", 
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", "element", "}"}], ",", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"#1", ",", " ", "element"}], "]"}]}], "]"}], " ", 
                    "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "27"}], "}"}], "}"}]}], " ", "&"}],
                     " ", ")"}], "[", 
                   RowBox[{"polygons113200200710102030024133", "[", 
                    RowBox[{
                    "\[Theta]3", ",", " ", "PlanoConvexLensFocalLength", ",", 
                    " ", "PlanoConvexLensThickness"}], "]"}], "]"}], "]"}], 
                 "]"}]}], "}"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"x3", ",", " ", "y3"}], "}"}]}], "}"}], "]"}]}], 
             "]"}], ",", " ", 
            RowBox[{"GeometricTransformation", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", " ", 
                RowBox[{"AbsolutePointSize", "[", "1", "]"}], ",", " ", 
                RowBox[{"EdgeForm", "[", "]"}], ",", " ", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.4", ",", " ", "0.6", ",", " ", "0.8"}], "]"}], 
                ",", " ", 
                RowBox[{"Polygon", "[", 
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", "element", "}"}], ",", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"#1", ",", " ", "element"}], "]"}]}], "]"}], " ", 
                    "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "27"}], "}"}], "}"}]}], " ", "&"}],
                     " ", ")"}], "[", 
                   RowBox[{
                   "polygons123200200710102030043537", "[", "\[Theta]9", 
                    "]"}], "]"}], "]"}], "]"}]}], "}"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"x9", ",", " ", "y9"}], "}"}]}], "}"}], "]"}]}], 
             "]"}], ",", " ", 
            RowBox[{"GeometricTransformation", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", " ", 
                RowBox[{"AbsolutePointSize", "[", "1", "]"}], ",", " ", 
                RowBox[{"EdgeForm", "[", "]"}], ",", " ", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.4", ",", " ", "0.6", ",", " ", "0.8"}], "]"}], 
                ",", " ", 
                RowBox[{"Polygon", "[", 
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", "element", "}"}], ",", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"#1", ",", " ", "element"}], "]"}]}], "]"}], " ", 
                    "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "27"}], "}"}], "}"}]}], " ", "&"}],
                     " ", ")"}], "[", 
                   RowBox[{"polygons133200200710102030079069", "[", 
                    RowBox[{
                    "\[Theta]4", ",", " ", "PlanoConcaveLensFocalLength", ",",
                     " ", "PlanoConcaveLensThickness"}], "]"}], "]"}], "]"}], 
                 "]"}]}], "}"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"x4", ",", " ", "y4"}], "}"}]}], "}"}], "]"}]}], 
             "]"}], ",", " ", 
            RowBox[{"GeometricTransformation", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", " ", 
                RowBox[{"AbsolutePointSize", "[", "1", "]"}], ",", " ", 
                RowBox[{"EdgeForm", "[", "]"}], ",", " ", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.4", ",", " ", "0.6", ",", " ", "0.8"}], "]"}], 
                ",", " ", 
                RowBox[{"Polygon", "[", 
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", "element", "}"}], ",", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"#1", ",", " ", "element"}], "]"}]}], "]"}], " ", 
                    "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "27"}], "}"}], "}"}]}], " ", "&"}],
                     " ", ")"}], "[", 
                   RowBox[{
                   "polygons143200200710102030099685", "[", "\[Theta]5", 
                    "]"}], "]"}], "]"}], "]"}]}], "}"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"x5", ",", " ", "y5"}], "}"}]}], "}"}], "]"}]}], 
             "]"}], ",", " ", 
            RowBox[{"GeometricTransformation", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", " ", 
                RowBox[{"AbsolutePointSize", "[", "1", "]"}], ",", " ", 
                RowBox[{"EdgeForm", "[", "]"}], ",", " ", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.4", ",", " ", "0.6", ",", " ", "0.8"}], "]"}], 
                ",", " ", 
                RowBox[{"Polygon", "[", 
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", "element", "}"}], ",", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"#1", ",", " ", "element"}], "]"}]}], "]"}], " ", 
                    "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "27"}], "}"}], "}"}]}], " ", "&"}],
                     " ", ")"}], "[", 
                   RowBox[{
                   "polygons153200200710102030120567", "[", "\[Theta]6", 
                    "]"}], "]"}], "]"}], "]"}]}], "}"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"x6", ",", " ", "y6"}], "}"}]}], "}"}], "]"}]}], 
             "]"}], ",", " ", 
            RowBox[{"GeometricTransformation", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", " ", 
                RowBox[{"AbsolutePointSize", "[", "1", "]"}], ",", " ", 
                RowBox[{"EdgeForm", "[", "]"}], ",", " ", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.4", ",", " ", "0.6", ",", " ", "0.8"}], "]"}], 
                ",", " ", 
                RowBox[{"Polygon", "[", 
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", "element", "}"}], ",", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"#1", ",", " ", "element"}], "]"}]}], "]"}], " ", 
                    "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "27"}], "}"}], "}"}]}], " ", "&"}],
                     " ", ")"}], "[", 
                   RowBox[{
                   "polygons163200200710102030139107", "[", "\[Theta]10", 
                    "]"}], "]"}], "]"}], "]"}]}], "}"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"x10", ",", " ", "y10"}], "}"}]}], "}"}], "]"}]}], 
             "]"}], ",", " ", 
            RowBox[{"GeometricTransformation", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
                RowBox[{"AbsoluteThickness", "[", "0.5", "]"}], ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "50."}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "41.66666666666667"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "33.333333333333336"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "25.000000000000004"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "16.66666666666667"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "8.333333333333343"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "7.105427357601002*^-15"}]}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "8.333333333333329"}], "}"}], ",",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "16.666666666666657"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "24.999999999999986"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "33.333333333333314"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "41.66666666666666"}], "}"}], ",",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "49.999999999999986"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "50."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "41.66666666666667"}], "}"}], ",",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "33.333333333333336"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "25.000000000000004"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "16.66666666666667"}], "}"}], ",",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "8.333333333333343"}], "}"}], ",",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "7.105427357601002*^-15"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "8.333333333333329"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "16.666666666666657"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "24.999999999999986"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "33.333333333333314"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "41.66666666666666"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "49.999999999999986"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "50."}]}], "}"}]}], "}"}], "}"}], "]"}]}], 
               "}"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"x8", ",", " ", "0"}], "}"}]}], "}"}], "]"}]}], 
             "]"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
              RowBox[{"AbsoluteThickness", "[", "0.5", "]"}], ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", "100."}], "}"}]}], "}"}], ",", 
                 " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "100."}], "}"}]}], "}"}], ",", 
                 " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"200.", ",", " ", "100."}], "}"}]}], "}"}]}], 
                "}"}], "]"}]}], "}"}], ",", " ", 
            RowBox[{"Opacity", "[", "1", "]"}], ",", " ", 
            RowBox[{"Dynamic", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"RGBColor", "[", 
                 RowBox[{
                  RowBox[{"Abs", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "0.3183098861837907"}], "*", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"63.75", " ", "-", " ", 
                    RowBox[{"0.25", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{"0.3183098861837907", "*", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"43.", " ", "-", " ", 
                    RowBox[{"0.1", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}]}], "]"}], ",", " ", 
                  RowBox[{"Abs", "[", 
                   RowBox[{
                    RowBox[{"0.3183098861837907", "*", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"60.", " ", "-", " ", 
                    RowBox[{"0.2", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], " ", "-", " ", 
                    RowBox[{"0.3183098861837907", "*", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"18.", " ", "-", " ", 
                    RowBox[{"0.1", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}]}], "]"}], ",", " ", 
                  RowBox[{"Abs", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "0.3183098861837907"}], "*", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"10.", " ", "-", " ", 
                    RowBox[{"0.2", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{"0.3183098861837907", "*", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"22.5", " ", "-", " ", 
                    RowBox[{"0.125", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}], " ", 
                "&"}], " ", ")"}], "[", "\[Lambda]", "]"}], "]"}], ",", " ", 
            RowBox[{"AbsoluteThickness", "[", "Medium", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}], ",", 
                   " ", 
                   RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", " ", "5"}], "}"}], "]"}], "]"}]}], 
                  "}"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
               RowBox[{"Select", "[", 
                RowBox[{
                 RowBox[{"raytracefunction13200200710102030153833", "[", 
                  RowBox[{
                  "\[Lambda]", ",", " ", "PlanoConcaveLensFocalLength", ",", 
                   " ", "PlanoConcaveLensThickness", ",", " ", 
                   "PlanoConvexLensFocalLength", ",", " ", 
                   "PlanoConvexLensThickness", ",", " ", "x10", ",", " ", 
                   "x3", ",", " ", "x4", ",", " ", "x5", ",", " ", "x6", ",", 
                   " ", "x8", ",", " ", "x9", ",", " ", "y10", ",", " ", "y3",
                    ",", " ", "y4", ",", " ", "y5", ",", " ", "y6", ",", " ", 
                   "y9", ",", " ", "\[Theta]10", ",", " ", "\[Theta]3", ",", 
                   " ", "\[Theta]4", ",", " ", "\[Theta]5", ",", " ", 
                   "\[Theta]6", ",", " ", "\[Theta]9"}], "]"}], ",", " ", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", ">", " ", 
                   RowBox[{"-", "9.87654321*^8"}]}], " ", "&"}]}], " ", 
                "]"}]}], "]"}], "]"}], ",", " ", 
            RowBox[{"Arrowheads", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{"Small", ",", " ", "Small"}], "}"}], "]"}], ",", " ", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "]"}], ",", " ", 
            RowBox[{"Arrow", "[", 
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]3", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x3", ",", " ", "y3"}], "}"}]}], " ", "||", " ", 
                   RowBox[{"last\[Theta]3", " ", "=!=", " ", "\[Theta]3"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]3", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x3", ",", " ", "y3"}], "}"}]}], ";", " ", 
                   RowBox[{"last\[Theta]3", " ", "=", " ", "\[Theta]3"}], ";",
                    " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]3", ",", " ", "y\[Theta]3"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]3", " ", "+", " ", 
                    RowBox[{"radius\[Theta]3", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]3", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]3", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                RowBox[{"{", 
                 RowBox[{"laststartpos\[Theta]3", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"x\[Theta]3", ",", " ", "y\[Theta]3"}], "}"}]}], 
                 "}"}]}], ",", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"laststartpos\[Theta]3", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]3", ",", " ", "y\[Theta]3"}], "}"}]}], 
                   "}"}], " ", "=", " ", "#1"}], ")"}], " ", "&"}]}], " ", 
              "]"}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]3", ",", " ", "y\[Theta]3"}], "}"}], 
                    " ", "!=", " ", "lastlocpos\[Theta]3"}], " ", "||", " ", 
                    RowBox[{"last\[Theta]3", " ", "!=", " ", "\[Theta]3"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"lastlocpos\[Theta]3", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]3", ",", " ", "y\[Theta]3"}], "}"}]}], 
                    ";", " ", 
                    RowBox[{"last\[Theta]3", " ", "=", " ", "\[Theta]3"}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]3", ",", " ", "y\[Theta]3"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]3", " ", "+", " ", 
                    RowBox[{"radius\[Theta]3", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]3", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]3", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                   RowBox[{"{", 
                    RowBox[{"x\[Theta]3", ",", " ", "y\[Theta]3"}], "}"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]3", ",", " ", "y\[Theta]3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"xoff\[Theta]3", " ", "=", " ", 
                    RowBox[{"x\[Theta]3", " ", "-", " ", "x3"}]}], ";", " ", 
                    RowBox[{"yoff\[Theta]3", " ", "=", " ", 
                    RowBox[{"y\[Theta]3", " ", "-", " ", "y3"}]}], ";", " ", 
                    RowBox[{"radius\[Theta]3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"xoff\[Theta]3", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yoff\[Theta]3", "^", "2"}]}], "]"}]}], ";", " ", 
                    
                    RowBox[{"\[Theta]3", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"xoff\[Theta]3", ",", " ", "yoff\[Theta]3"}], 
                    "]"}], "/", "Degree"}], "]"}]}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]3", ",", " ", "y\[Theta]3"}], "}"}]}], 
                    ")"}], " ", "&"}]}], " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.5"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<\[Theta]3 = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", "\[Theta]3", "]"}]}], "]"}], 
               "]"}]}], "]"}], ",", " ", 
            RowBox[{"Arrowheads", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{"Small", ",", " ", "Small"}], "}"}], "]"}], ",", " ", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "]"}], ",", " ", 
            RowBox[{"Arrow", "[", 
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]9", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x9", ",", " ", "y9"}], "}"}]}], " ", "||", " ", 
                   RowBox[{"last\[Theta]9", " ", "=!=", " ", "\[Theta]9"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]9", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x9", ",", " ", "y9"}], "}"}]}], ";", " ", 
                   RowBox[{"last\[Theta]9", " ", "=", " ", "\[Theta]9"}], ";",
                    " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]9", ",", " ", "y\[Theta]9"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]9", " ", "+", " ", 
                    RowBox[{"radius\[Theta]9", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]9", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]9", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                RowBox[{"{", 
                 RowBox[{"laststartpos\[Theta]9", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"x\[Theta]9", ",", " ", "y\[Theta]9"}], "}"}]}], 
                 "}"}]}], ",", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"laststartpos\[Theta]9", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]9", ",", " ", "y\[Theta]9"}], "}"}]}], 
                   "}"}], " ", "=", " ", "#1"}], ")"}], " ", "&"}]}], " ", 
              "]"}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]9", ",", " ", "y\[Theta]9"}], "}"}], 
                    " ", "!=", " ", "lastlocpos\[Theta]9"}], " ", "||", " ", 
                    RowBox[{"last\[Theta]9", " ", "!=", " ", "\[Theta]9"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"lastlocpos\[Theta]9", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]9", ",", " ", "y\[Theta]9"}], "}"}]}], 
                    ";", " ", 
                    RowBox[{"last\[Theta]9", " ", "=", " ", "\[Theta]9"}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]9", ",", " ", "y\[Theta]9"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]9", " ", "+", " ", 
                    RowBox[{"radius\[Theta]9", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]9", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]9", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                   RowBox[{"{", 
                    RowBox[{"x\[Theta]9", ",", " ", "y\[Theta]9"}], "}"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]9", ",", " ", "y\[Theta]9"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"xoff\[Theta]9", " ", "=", " ", 
                    RowBox[{"x\[Theta]9", " ", "-", " ", "x9"}]}], ";", " ", 
                    RowBox[{"yoff\[Theta]9", " ", "=", " ", 
                    RowBox[{"y\[Theta]9", " ", "-", " ", "y9"}]}], ";", " ", 
                    RowBox[{"radius\[Theta]9", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"xoff\[Theta]9", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yoff\[Theta]9", "^", "2"}]}], "]"}]}], ";", " ", 
                    
                    RowBox[{"\[Theta]9", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"xoff\[Theta]9", ",", " ", "yoff\[Theta]9"}], 
                    "]"}], "/", "Degree"}], "]"}]}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]9", ",", " ", "y\[Theta]9"}], "}"}]}], 
                    ")"}], " ", "&"}]}], " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.5"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<\[Theta]9 = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", "\[Theta]9", "]"}]}], "]"}], 
               "]"}]}], "]"}], ",", " ", 
            RowBox[{"Arrowheads", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{"Small", ",", " ", "Small"}], "}"}], "]"}], ",", " ", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "]"}], ",", " ", 
            RowBox[{"Arrow", "[", 
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]4", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x4", ",", " ", "y4"}], "}"}]}], " ", "||", " ", 
                   RowBox[{"last\[Theta]4", " ", "=!=", " ", "\[Theta]4"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]4", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x4", ",", " ", "y4"}], "}"}]}], ";", " ", 
                   RowBox[{"last\[Theta]4", " ", "=", " ", "\[Theta]4"}], ";",
                    " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]4", ",", " ", "y\[Theta]4"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]4", " ", "+", " ", 
                    RowBox[{"radius\[Theta]4", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]4", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]4", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                RowBox[{"{", 
                 RowBox[{"laststartpos\[Theta]4", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"x\[Theta]4", ",", " ", "y\[Theta]4"}], "}"}]}], 
                 "}"}]}], ",", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"laststartpos\[Theta]4", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]4", ",", " ", "y\[Theta]4"}], "}"}]}], 
                   "}"}], " ", "=", " ", "#1"}], ")"}], " ", "&"}]}], " ", 
              "]"}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]4", ",", " ", "y\[Theta]4"}], "}"}], 
                    " ", "!=", " ", "lastlocpos\[Theta]4"}], " ", "||", " ", 
                    RowBox[{"last\[Theta]4", " ", "!=", " ", "\[Theta]4"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"lastlocpos\[Theta]4", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]4", ",", " ", "y\[Theta]4"}], "}"}]}], 
                    ";", " ", 
                    RowBox[{"last\[Theta]4", " ", "=", " ", "\[Theta]4"}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]4", ",", " ", "y\[Theta]4"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]4", " ", "+", " ", 
                    RowBox[{"radius\[Theta]4", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]4", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]4", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                   RowBox[{"{", 
                    RowBox[{"x\[Theta]4", ",", " ", "y\[Theta]4"}], "}"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]4", ",", " ", "y\[Theta]4"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"xoff\[Theta]4", " ", "=", " ", 
                    RowBox[{"x\[Theta]4", " ", "-", " ", "x4"}]}], ";", " ", 
                    RowBox[{"yoff\[Theta]4", " ", "=", " ", 
                    RowBox[{"y\[Theta]4", " ", "-", " ", "y4"}]}], ";", " ", 
                    RowBox[{"radius\[Theta]4", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"xoff\[Theta]4", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yoff\[Theta]4", "^", "2"}]}], "]"}]}], ";", " ", 
                    
                    RowBox[{"\[Theta]4", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"xoff\[Theta]4", ",", " ", "yoff\[Theta]4"}], 
                    "]"}], "/", "Degree"}], "]"}]}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]4", ",", " ", "y\[Theta]4"}], "}"}]}], 
                    ")"}], " ", "&"}]}], " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.5"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<\[Theta]4 = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", "\[Theta]4", "]"}]}], "]"}], 
               "]"}]}], "]"}], ",", " ", 
            RowBox[{"Arrowheads", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{"Small", ",", " ", "Small"}], "}"}], "]"}], ",", " ", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "]"}], ",", " ", 
            RowBox[{"Arrow", "[", 
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]5", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x5", ",", " ", "y5"}], "}"}]}], " ", "||", " ", 
                   RowBox[{"last\[Theta]5", " ", "=!=", " ", "\[Theta]5"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]5", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x5", ",", " ", "y5"}], "}"}]}], ";", " ", 
                   RowBox[{"last\[Theta]5", " ", "=", " ", "\[Theta]5"}], ";",
                    " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]5", ",", " ", "y\[Theta]5"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]5", " ", "+", " ", 
                    RowBox[{"radius\[Theta]5", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]5", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]5", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                RowBox[{"{", 
                 RowBox[{"laststartpos\[Theta]5", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"x\[Theta]5", ",", " ", "y\[Theta]5"}], "}"}]}], 
                 "}"}]}], ",", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"laststartpos\[Theta]5", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]5", ",", " ", "y\[Theta]5"}], "}"}]}], 
                   "}"}], " ", "=", " ", "#1"}], ")"}], " ", "&"}]}], " ", 
              "]"}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]5", ",", " ", "y\[Theta]5"}], "}"}], 
                    " ", "!=", " ", "lastlocpos\[Theta]5"}], " ", "||", " ", 
                    RowBox[{"last\[Theta]5", " ", "!=", " ", "\[Theta]5"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"lastlocpos\[Theta]5", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]5", ",", " ", "y\[Theta]5"}], "}"}]}], 
                    ";", " ", 
                    RowBox[{"last\[Theta]5", " ", "=", " ", "\[Theta]5"}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]5", ",", " ", "y\[Theta]5"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]5", " ", "+", " ", 
                    RowBox[{"radius\[Theta]5", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]5", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]5", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                   RowBox[{"{", 
                    RowBox[{"x\[Theta]5", ",", " ", "y\[Theta]5"}], "}"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]5", ",", " ", "y\[Theta]5"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"xoff\[Theta]5", " ", "=", " ", 
                    RowBox[{"x\[Theta]5", " ", "-", " ", "x5"}]}], ";", " ", 
                    RowBox[{"yoff\[Theta]5", " ", "=", " ", 
                    RowBox[{"y\[Theta]5", " ", "-", " ", "y5"}]}], ";", " ", 
                    RowBox[{"radius\[Theta]5", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"xoff\[Theta]5", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yoff\[Theta]5", "^", "2"}]}], "]"}]}], ";", " ", 
                    
                    RowBox[{"\[Theta]5", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"xoff\[Theta]5", ",", " ", "yoff\[Theta]5"}], 
                    "]"}], "/", "Degree"}], "]"}]}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]5", ",", " ", "y\[Theta]5"}], "}"}]}], 
                    ")"}], " ", "&"}]}], " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.5"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<\[Theta]5 = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", "\[Theta]5", "]"}]}], "]"}], 
               "]"}]}], "]"}], ",", " ", 
            RowBox[{"Arrowheads", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{"Small", ",", " ", "Small"}], "}"}], "]"}], ",", " ", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "]"}], ",", " ", 
            RowBox[{"Arrow", "[", 
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]6", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x6", ",", " ", "y6"}], "}"}]}], " ", "||", " ", 
                   RowBox[{"last\[Theta]6", " ", "=!=", " ", "\[Theta]6"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]6", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x6", ",", " ", "y6"}], "}"}]}], ";", " ", 
                   RowBox[{"last\[Theta]6", " ", "=", " ", "\[Theta]6"}], ";",
                    " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]6", ",", " ", "y\[Theta]6"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]6", " ", "+", " ", 
                    RowBox[{"radius\[Theta]6", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]6", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]6", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                RowBox[{"{", 
                 RowBox[{"laststartpos\[Theta]6", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"x\[Theta]6", ",", " ", "y\[Theta]6"}], "}"}]}], 
                 "}"}]}], ",", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"laststartpos\[Theta]6", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]6", ",", " ", "y\[Theta]6"}], "}"}]}], 
                   "}"}], " ", "=", " ", "#1"}], ")"}], " ", "&"}]}], " ", 
              "]"}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]6", ",", " ", "y\[Theta]6"}], "}"}], 
                    " ", "!=", " ", "lastlocpos\[Theta]6"}], " ", "||", " ", 
                    RowBox[{"last\[Theta]6", " ", "!=", " ", "\[Theta]6"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"lastlocpos\[Theta]6", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]6", ",", " ", "y\[Theta]6"}], "}"}]}], 
                    ";", " ", 
                    RowBox[{"last\[Theta]6", " ", "=", " ", "\[Theta]6"}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]6", ",", " ", "y\[Theta]6"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]6", " ", "+", " ", 
                    RowBox[{"radius\[Theta]6", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]6", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]6", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                   RowBox[{"{", 
                    RowBox[{"x\[Theta]6", ",", " ", "y\[Theta]6"}], "}"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]6", ",", " ", "y\[Theta]6"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"xoff\[Theta]6", " ", "=", " ", 
                    RowBox[{"x\[Theta]6", " ", "-", " ", "x6"}]}], ";", " ", 
                    RowBox[{"yoff\[Theta]6", " ", "=", " ", 
                    RowBox[{"y\[Theta]6", " ", "-", " ", "y6"}]}], ";", " ", 
                    RowBox[{"radius\[Theta]6", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"xoff\[Theta]6", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yoff\[Theta]6", "^", "2"}]}], "]"}]}], ";", " ", 
                    
                    RowBox[{"\[Theta]6", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"xoff\[Theta]6", ",", " ", "yoff\[Theta]6"}], 
                    "]"}], "/", "Degree"}], "]"}]}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]6", ",", " ", "y\[Theta]6"}], "}"}]}], 
                    ")"}], " ", "&"}]}], " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.5"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<\[Theta]6 = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", "\[Theta]6", "]"}]}], "]"}], 
               "]"}]}], "]"}], ",", " ", 
            RowBox[{"Arrowheads", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Dashing", "[", 
             RowBox[{"{", 
              RowBox[{"Small", ",", " ", "Small"}], "}"}], "]"}], ",", " ", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "]"}], ",", " ", 
            RowBox[{"Arrow", "[", 
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]10", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x10", ",", " ", "y10"}], "}"}]}], " ", "||", " ", 
                   RowBox[{
                   "last\[Theta]10", " ", "=!=", " ", "\[Theta]10"}]}], ",", 
                  " ", 
                  RowBox[{
                   RowBox[{"laststartpos\[Theta]10", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x10", ",", " ", "y10"}], "}"}]}], ";", " ", 
                   RowBox[{"last\[Theta]10", " ", "=", " ", "\[Theta]10"}], 
                   ";", " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]10", ",", " ", "y\[Theta]10"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]10", " ", "+", " ", 
                    RowBox[{"radius\[Theta]10", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]10", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]10", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                RowBox[{"{", 
                 RowBox[{"laststartpos\[Theta]10", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"x\[Theta]10", ",", " ", "y\[Theta]10"}], "}"}]}], 
                 "}"}]}], ",", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"laststartpos\[Theta]10", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]10", ",", " ", "y\[Theta]10"}], "}"}]}],
                    "}"}], " ", "=", " ", "#1"}], ")"}], " ", "&"}]}], " ", 
              "]"}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]10", ",", " ", "y\[Theta]10"}], "}"}], 
                    " ", "!=", " ", "lastlocpos\[Theta]10"}], " ", "||", " ", 
                    
                    RowBox[{
                    "last\[Theta]10", " ", "!=", " ", "\[Theta]10"}]}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"lastlocpos\[Theta]10", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]10", ",", " ", "y\[Theta]10"}], "}"}]}],
                     ";", " ", 
                    RowBox[{"last\[Theta]10", " ", "=", " ", "\[Theta]10"}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]10", ",", " ", "y\[Theta]10"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]10", " ", "+", " ", 
                    RowBox[{"radius\[Theta]10", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]10", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]10", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                   RowBox[{"{", 
                    RowBox[{"x\[Theta]10", ",", " ", "y\[Theta]10"}], "}"}]}],
                   ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]10", ",", " ", "y\[Theta]10"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"xoff\[Theta]10", " ", "=", " ", 
                    RowBox[{"x\[Theta]10", " ", "-", " ", "x10"}]}], ";", " ", 
                    RowBox[{"yoff\[Theta]10", " ", "=", " ", 
                    RowBox[{"y\[Theta]10", " ", "-", " ", "y10"}]}], ";", " ", 
                    RowBox[{"radius\[Theta]10", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"xoff\[Theta]10", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yoff\[Theta]10", "^", "2"}]}], "]"}]}], ";", " ", 
                    RowBox[{"\[Theta]10", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"xoff\[Theta]10", ",", " ", "yoff\[Theta]10"}], 
                    "]"}], "/", "Degree"}], "]"}]}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]10", ",", " ", "y\[Theta]10"}], "}"}]}],
                     ")"}], " ", "&"}]}], " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.5"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<\[Theta]10 = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", "\[Theta]10", "]"}]}], "]"}], 
               "]"}]}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x3", ",", " ", "y3"}], "}"}], ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x3", ",", " ", "y3"}], "}"}], " ", "=", " ", 
                    RowBox[{"Chop", "[", "#1", "]"}]}], ")"}], " ", "&"}]}], 
                 " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}]}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.8"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<{x3, y3} = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"Chop", "[", 
                   RowBox[{"{", 
                    RowBox[{"x3", ",", " ", "y3"}], "}"}], "]"}], "]"}]}], 
                "]"}], "]"}]}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x9", ",", " ", "y9"}], "}"}], ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x9", ",", " ", "y9"}], "}"}], " ", "=", " ", 
                    RowBox[{"Chop", "[", "#1", "]"}]}], ")"}], " ", "&"}]}], 
                 " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}]}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.8"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<{x9, y9} = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"Chop", "[", 
                   RowBox[{"{", 
                    RowBox[{"x9", ",", " ", "y9"}], "}"}], "]"}], "]"}]}], 
                "]"}], "]"}]}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x4", ",", " ", "y4"}], "}"}], ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x4", ",", " ", "y4"}], "}"}], " ", "=", " ", 
                    RowBox[{"Chop", "[", "#1", "]"}]}], ")"}], " ", "&"}]}], 
                 " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}]}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.8"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<{x4, y4} = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"Chop", "[", 
                   RowBox[{"{", 
                    RowBox[{"x4", ",", " ", "y4"}], "}"}], "]"}], "]"}]}], 
                "]"}], "]"}]}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x5", ",", " ", "y5"}], "}"}], ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x5", ",", " ", "y5"}], "}"}], " ", "=", " ", 
                    RowBox[{"Chop", "[", "#1", "]"}]}], ")"}], " ", "&"}]}], 
                 " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}]}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.8"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<{x5, y5} = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"Chop", "[", 
                   RowBox[{"{", 
                    RowBox[{"x5", ",", " ", "y5"}], "}"}], "]"}], "]"}]}], 
                "]"}], "]"}]}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x6", ",", " ", "y6"}], "}"}], ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x6", ",", " ", "y6"}], "}"}], " ", "=", " ", 
                    RowBox[{"Chop", "[", "#1", "]"}]}], ")"}], " ", "&"}]}], 
                 " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}]}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.8"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<{x6, y6} = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"Chop", "[", 
                   RowBox[{"{", 
                    RowBox[{"x6", ",", " ", "y6"}], "}"}], "]"}], "]"}]}], 
                "]"}], "]"}]}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x10", ",", " ", "y10"}], "}"}], ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x10", ",", " ", "y10"}], "}"}], " ", "=", " ", 
                    RowBox[{"Chop", "[", "#1", "]"}]}], ")"}], " ", "&"}]}], 
                 " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}]}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.8"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<{x10, y10} = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"Chop", "[", 
                   RowBox[{"{", 
                    RowBox[{"x10", ",", " ", "y10"}], "}"}], "]"}], "]"}]}], 
                "]"}], "]"}]}], "]"}], ",", " ", 
            RowBox[{"Tooltip", "[", 
             RowBox[{
              RowBox[{"Locator", "[", 
               RowBox[{
                RowBox[{"Dynamic", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x8", ",", " ", "0"}], "}"}], ",", " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"x8", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ")"}], " ", 
                   "&"}]}], " ", "]"}], ",", " ", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}]}], "]"}], ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.8"}], 
                    "]"}]}], "}"}], ",", " ", 
                  RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}],
                "]"}], ",", " ", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"\"\<x8 = \>\"", ",", " ", 
                 RowBox[{"ToString", "[", "x8", "]"}]}], "]"}], "]"}]}], 
             "]"}]}], "}"}], "}"}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Axes", " ", "\[Rule]", " ", "True"}], ",", " ", 
          RowBox[{"ImageSize", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{"425", ",", "425"}], "}"}]}], ",", " ", 
          RowBox[{"AspectRatio", " ", "\[Rule]", " ", "Automatic"}]}], 
         "}"}]}], "]"}], "}"}], ",", " ", "Center"}], "]"}], ",", " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<planoconcave lens\>\"", ",", "Bold"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"PlanoConcaveLensFocalLength", ",", 
       RowBox[{"-", "100"}], ",", "\"\<focal length\>\""}], "}"}], ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "47"}], ",", ".01", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "PlanoConcaveLensThickness", ",", "1", ",", "\"\<thickness\>\""}], 
      "}"}], ",", "1", ",", "5", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<planoconvex lens\>\"", ",", "Bold"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "PlanoConvexLensFocalLength", ",", "70", ",", "\"\<focal length\>\""}], 
      "}"}], ",", "70", ",", "120", ",", ".01", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "PlanoConvexLensThickness", ",", "10", ",", "\"\<thickness\>\""}], 
      "}"}], ",", "10", ",", "15", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", ".5", ",", "\"\<wavelength\>\""}], "}"}], ",",
      ".4", ",", ".7", ",", ".01", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "}"}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"PlanoConcaveLensFocalLength", ",", " ", 
       RowBox[{"-", "49.8149"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"PlanoConcaveLensThickness", ",", " ", "2.5"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"PlanoConvexLensFocalLength", ",", " ", "100."}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"PlanoConvexLensThickness", ",", " ", "10."}], "}"}], ",", " ", 
     
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x10", ",", " ", "60."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x3", ",", " ", "50."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x4", ",", " ", "90."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x5", ",", " ", "75."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x6", ",", " ", "100."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x8", ",", " ", "190."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x9", ",", " ", "10."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y10", ",", " ", 
       RowBox[{"-", "75."}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y3", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y4", ",", " ", 
       RowBox[{"-", "75."}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y5", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y6", ",", " ", 
       RowBox[{"-", "75."}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y9", ",", " ", 
       RowBox[{"-", "75."}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]10", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]3", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]4", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]5", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]6", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]9", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x\[Theta]3", ",", " ", "55.20953470592178"}], "}"}], ",", " ", 
     
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y\[Theta]3", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"radius\[Theta]3", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xoff\[Theta]3", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yoff\[Theta]3", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"laststartpos\[Theta]3", ",", " ", 
       RowBox[{"{", 
        RowBox[{"50.", ",", " ", "0."}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lastlocpos\[Theta]3", ",", " ", 
       RowBox[{"{", 
        RowBox[{"55.20953470592178", ",", " ", "0."}], "}"}]}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"last\[Theta]3", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x\[Theta]9", ",", " ", "15.209534705921783"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y\[Theta]9", ",", " ", 
       RowBox[{"-", "75."}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"radius\[Theta]9", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xoff\[Theta]9", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yoff\[Theta]9", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"laststartpos\[Theta]9", ",", " ", 
       RowBox[{"{", 
        RowBox[{"10.", ",", " ", 
         RowBox[{"-", "75."}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lastlocpos\[Theta]9", ",", " ", 
       RowBox[{"{", 
        RowBox[{"15.209534705921783", ",", " ", 
         RowBox[{"-", "75."}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"last\[Theta]9", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x\[Theta]4", ",", " ", "95.20953470592178"}], "}"}], ",", " ", 
     
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y\[Theta]4", ",", " ", 
       RowBox[{"-", "75."}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"radius\[Theta]4", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xoff\[Theta]4", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yoff\[Theta]4", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"laststartpos\[Theta]4", ",", " ", 
       RowBox[{"{", 
        RowBox[{"90.", ",", " ", 
         RowBox[{"-", "75."}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lastlocpos\[Theta]4", ",", " ", 
       RowBox[{"{", 
        RowBox[{"95.20953470592178", ",", " ", 
         RowBox[{"-", "75."}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"last\[Theta]4", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x\[Theta]5", ",", " ", "80.20953470592178"}], "}"}], ",", " ", 
     
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y\[Theta]5", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"radius\[Theta]5", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xoff\[Theta]5", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yoff\[Theta]5", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"laststartpos\[Theta]5", ",", " ", 
       RowBox[{"{", 
        RowBox[{"75.", ",", " ", "0."}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lastlocpos\[Theta]5", ",", " ", 
       RowBox[{"{", 
        RowBox[{"80.20953470592178", ",", " ", "0."}], "}"}]}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"last\[Theta]5", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x\[Theta]6", ",", " ", "105.20953470592178"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y\[Theta]6", ",", " ", 
       RowBox[{"-", "75."}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"radius\[Theta]6", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xoff\[Theta]6", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yoff\[Theta]6", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"laststartpos\[Theta]6", ",", " ", 
       RowBox[{"{", 
        RowBox[{"100.", ",", " ", 
         RowBox[{"-", "75."}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lastlocpos\[Theta]6", ",", " ", 
       RowBox[{"{", 
        RowBox[{"105.20953470592178", ",", " ", 
         RowBox[{"-", "75."}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"last\[Theta]6", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x\[Theta]10", ",", " ", "65.20953470592178"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y\[Theta]10", ",", " ", 
       RowBox[{"-", "75."}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"radius\[Theta]10", ",", " ", "5.209534705921783"}], "}"}], ",",
      " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xoff\[Theta]10", ",", " ", "5.209534705921783"}], "}"}], ",", 
     " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yoff\[Theta]10", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"laststartpos\[Theta]10", ",", " ", 
       RowBox[{"{", 
        RowBox[{"60.", ",", " ", 
         RowBox[{"-", "75."}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lastlocpos\[Theta]10", ",", " ", 
       RowBox[{"{", 
        RowBox[{"65.20953470592178", ",", " ", 
         RowBox[{"-", "75."}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"last\[Theta]10", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}], ",", " ", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "5"}], "}"}]}], ",", 
   RowBox[{"Initialization", " ", "\[RuleDelayed]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"raytracefunction13200200710102030153833", " ", "=", " ", 
       RowBox[{"Compile", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Lambda]", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"PlanoConcaveLensFocalLength", ",", " ", "_Real"}], "}"}],
            ",", " ", 
           RowBox[{"{", 
            RowBox[{"PlanoConcaveLensThickness", ",", " ", "_Real"}], "}"}], 
           ",", " ", 
           RowBox[{"{", 
            RowBox[{"PlanoConvexLensFocalLength", ",", " ", "_Real"}], "}"}], 
           ",", " ", 
           RowBox[{"{", 
            RowBox[{"PlanoConvexLensThickness", ",", " ", "_Real"}], "}"}], 
           ",", " ", 
           RowBox[{"{", 
            RowBox[{"x10", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x3", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x4", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x5", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x6", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x8", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x9", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"y10", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"y3", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"y4", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"y5", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"y6", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"y9", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Theta]10", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Theta]3", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Theta]4", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Theta]5", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Theta]6", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Theta]9", ",", " ", "_Real"}], "}"}]}], "}"}], ",", 
         " ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "activeregion", ",", " ", "allcreatedamplitudes", ",", " ", 
             "allcreatedrays", ",", " ", "allowzeroraylength", ",", " ", 
             "alternateindex", ",", " ", "amplitude", ",", " ", 
             "axismagnitude", ",", " ", "axismatrix", ",", " ", "clonedata", 
             ",", " ", "clonegenerationnumber", ",", " ", "cloneinput", ",", 
             " ", "clonenumber", ",", " ", "cloneposition", ",", " ", 
             "clonereportedrays", ",", " ", "clonerotation", ",", " ", 
             "clonescale", ",", " ", "clonescalevector", ",", " ", 
             "clonesorthistogram", ",", " ", "clonetraceinput", ",", " ", 
             "clonetraceoutput", ",", " ", "closestdistances", ",", " ", 
             "closestposition", ",", " ", "closestpositions", ",", " ", 
             "closestraylength", ",", " ", "completedray", ",", " ", 
             "componentnumber", ",", " ", "cosangle", ",", " ", "crossmatrix",
              ",", " ", "deflecteddummyrayspresent", ",", " ", 
             "deflectedlocalrays", ",", " ", "deflectedrays", ",", " ", 
             "deflectedrayspresent", ",", " ", "dummymatrix", ",", " ", 
             "dummymatrixlist", ",", " ", "dummyvector", ",", " ", "frontid", 
             ",", " ", "generationlimit", ",", " ", "generationnumber", ",", 
             " ", "holeintersections", ",", " ", "holeQ", ",", " ", 
             "holeQlist", ",", " ", "hor", ",", " ", "index", ",", " ", 
             "index1", ",", " ", "index2", ",", " ", "inrays", ",", " ", 
             "intensity", ",", " ", "intensityscale", ",", " ", 
             "intersectionnumber", ",", " ", "intersections", ",", " ", 
             "intersectionslist", ",", " ", "intersectionspresent", ",", " ", 
             "localdummyoutrayspresent", ",", " ", "localoutrays", ",", " ", 
             "localoutrayspresent", ",", " ", "magnitude", ",", " ", 
             "maxclonegenerationnumber", ",", " ", "maximumposition", ",", 
             " ", "minimumraylength", ",", " ", "minresonateraylength", ",", 
             " ", "n12", ",", " ", "newcomponentnumber", ",", " ", 
             "newdeflectedrays", ",", " ", "newdistance", ",", " ", 
             "newsurfaceid", ",", " ", "newsurfacenumber", ",", " ", 
             "nonintersectingrays", ",", " ", "normalizedpolarization", ",", 
             " ", "oldgenerationnumber", ",", " ", "opticallength", ",", " ", 
             "originalray", ",", " ", "originalraytilt", ",", " ", 
             "originalrotation", ",", " ", "originalsurfnorm", ",", " ", 
             "outrays", ",", " ", "parallelamplitude", ",", " ", "PAxis", ",",
              " ", "perpendicularamplitude", ",", " ", "phaseshift", ",", " ",
              "pol1", ",", " ", "pol2", ",", " ", "pol3", ",", " ", 
             "previoustilt", ",", " ", "propagate", ",", " ", 
             "propagatedrays", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3",
              ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "r7", 
             ",", " ", "r8", ",", " ", "r9", ",", " ", "ray1", ",", " ", 
             "ray2", ",", " ", "ray3", ",", " ", "RayL", ",", " ", "rayslot", 
             ",", " ", "raysreported", ",", " ", "raytiltx", ",", " ", 
             "raytiltz", ",", " ", "reporteddummyrayspresent", ",", " ", 
             "reportedlocalrays", ",", " ", "reportedrays", ",", " ", 
             "reportedrayspresent", ",", " ", "resonateintersections", ",", 
             " ", "resonatenumber", ",", " ", "resonateraylength", ",", " ", 
             "rex", ",", " ", "rey", ",", " ", "rez", ",", " ", 
             "rotationaxis", ",", " ", "rsx", ",", " ", "RSx", ",", " ", 
             "rsy", ",", " ", "RSy", ",", " ", "rsz", ",", " ", "RSz", ",", 
             " ", "RTx", ",", " ", "RTy", ",", " ", "RTz", ",", " ", "rx", 
             ",", " ", "rxhlp", ",", " ", "ry", ",", " ", "ryhlp", ",", " ", 
             "rz", ",", " ", "rzhlp", ",", " ", "SCx", ",", " ", "SCy", ",", 
             " ", "sid", ",", " ", "sinangle", ",", " ", "sno1", ",", " ", 
             "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ", 
             "surfaceid", ",", " ", "surfacenumber", ",", " ", 
             "surfacerotationmatrix", ",", " ", "surfacetranslationvector", 
             ",", " ", "surfnorm", ",", " ", "symr1", ",", " ", "symr2", ",", 
             " ", "symr3", ",", " ", "symr4", ",", " ", "symr5", ",", " ", 
             "symr6", ",", " ", "symr7", ",", " ", "symr8", ",", " ", "symr9",
              ",", " ", "tempclonedata", ",", " ", "terminatedeflection", ",",
              " ", "thresholdintensity", ",", " ", "tiltmagnitude", ",", " ", 
             "transmatrix", ",", " ", "TV1", ",", " ", "TV10", ",", " ", 
             "TV2", ",", " ", "TV3", ",", " ", "TV4", ",", " ", "TV5", ",", 
             " ", "TV6", ",", " ", "TV7", ",", " ", "TV8", ",", " ", "TV9", 
             ",", " ", "u", ",", " ", "unfilteredintersections", ",", " ", 
             "unit", ",", " ", "uu", ",", " ", "ver", ",", " ", "wavelength", 
             ",", " ", "XAxis", ",", " ", "xunit", ",", " ", "YAxis", ",", 
             " ", "yunit", ",", " ", "ZAxis", ",", " ", "zunit"}], "}"}], ",",
            " ", 
           RowBox[{
            RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"allcreatedamplitudes", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"0.", " ", "+", " ", 
                 RowBox[{"0.", "*", "I"}]}], ",", " ", 
                RowBox[{"0.", " ", "+", " ", 
                 RowBox[{"0.", "*", "I"}]}], ",", " ", 
                RowBox[{"0.", " ", "+", " ", 
                 RowBox[{"0.", "*", "I"}]}]}], "}"}], "}"}]}], ";", " ", 
            RowBox[{"allcreatedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"allowzeroraylength", " ", "=", " ", "True"}], ";", " ", 
            RowBox[{"alternateindex", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"amplitude", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}], ",", " ", 
               RowBox[{"0.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}], ",", " ", 
               RowBox[{"0.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}]}], "}"}]}], ";", " ", 
            RowBox[{"axismagnitude", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"axismatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"clonedata", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"clonegenerationnumber", " ", "=", " ", "1."}], ";", " ", 
            
            RowBox[{"cloneinput", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"clonenumber", " ", "=", " ", "1"}], ";", " ", 
            RowBox[{"cloneposition", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"0.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"clonereportedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"clonerotation", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"clonescale", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"clonescalevector", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"clonesorthistogram", " ", "=", " ", 
             RowBox[{"{", "1", "}"}]}], ";", " ", 
            RowBox[{"clonetraceinput", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"clonetraceoutput", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"closestdistances", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"closestposition", " ", "=", " ", "0"}], ";", " ", 
            RowBox[{"closestpositions", " ", "=", " ", 
             RowBox[{"{", "0", "}"}]}], ";", " ", 
            RowBox[{"closestraylength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"completedray", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"componentnumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"cosangle", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"crossmatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"deflecteddummyrayspresent", " ", "=", " ", "False"}], 
            ";", " ", 
            RowBox[{"deflectedlocalrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"deflectedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"deflectedrayspresent", " ", "=", " ", "False"}], ";", 
            " ", 
            RowBox[{"dummymatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"dummymatrixlist", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"{", "1.", "}"}], "}"}], "}"}]}], ";", " ", 
            RowBox[{"dummyvector", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"frontid", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"generationlimit", " ", "=", " ", "200."}], ";", " ", 
            RowBox[{"generationnumber", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"holeintersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"holeQlist", " ", "=", " ", 
             RowBox[{"{", "0", "}"}]}], ";", " ", 
            RowBox[{"hor", " ", "=", " ", 
             RowBox[{"1.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
            RowBox[{"index", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"index1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"index2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"inrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"intensity", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"intensityscale", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"intersectionnumber", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"intersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"intersectionslist", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}],
                "}"}], "}"}]}], ";", " ", 
            RowBox[{"intersectionspresent", " ", "=", " ", "False"}], ";", 
            " ", 
            RowBox[{"localdummyoutrayspresent", " ", "=", " ", "False"}], ";",
             " ", 
            RowBox[{"localoutrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"localoutrayspresent", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"magnitude", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"maxclonegenerationnumber", " ", "=", " ", "1."}], ";", 
            " ", 
            RowBox[{"maximumposition", " ", "=", " ", "1"}], ";", " ", 
            RowBox[{"minimumraylength", " ", "=", " ", "0.0001"}], ";", " ", 
            RowBox[{"minresonateraylength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"n12", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"newcomponentnumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"newdeflectedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"newdistance", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"newsurfaceid", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"newsurfacenumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"nonintersectingrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"normalizedpolarization", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "1."}], "}"}]}], ";", " ", 
            RowBox[{"oldgenerationnumber", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"opticallength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"originalray", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"originalraytilt", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"originalrotation", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"originalsurfnorm", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"outrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"parallelamplitude", " ", "=", " ", 
             RowBox[{"1.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
            RowBox[{"PAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"perpendicularamplitude", " ", "=", " ", 
             RowBox[{"1.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
            RowBox[{"phaseshift", " ", "=", " ", "0."}], ";", " ", 
            RowBox[{"pol1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"pol2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"pol3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"previoustilt", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"propagate", " ", "=", " ", "True"}], ";", " ", 
            RowBox[{"propagatedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"r1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r4", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r5", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r6", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r7", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r8", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r9", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ray1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ray2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ray3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rayslot", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"raysreported", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"raytiltx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"raytiltz", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"reporteddummyrayspresent", " ", "=", " ", "False"}], ";",
             " ", 
            RowBox[{"reportedlocalrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"reportedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"resonateintersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"resonatenumber", " ", "=", " ", "0"}], ";", " ", 
            RowBox[{"resonateraylength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rex", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rey", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rez", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rsx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RSx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rsy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RSy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rsz", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RSz", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RTx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RTy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RTz", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rxhlp", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ry", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ryhlp", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rz", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rzhlp", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sid", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sinangle", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sno1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sno2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sno3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sno4", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"surfaceid", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"surfacenumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"surfacerotationmatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"surfacetranslationvector", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"0.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"surfnorm", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"symr1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr4", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr5", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr6", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr7", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr8", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr9", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"tempclonedata", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"terminatedeflection", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"thresholdintensity", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"tiltmagnitude", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"transmatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
                " ", 
                RowBox[{"{", 
                 RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
                " ", 
                RowBox[{"{", 
                 RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
               "}"}], "}"}]}], ";", " ", 
            RowBox[{"TV1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV10", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV4", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV5", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV6", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV7", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV8", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV9", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"u", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"unfilteredintersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"unit", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"uu", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"ver", " ", "=", " ", 
             RowBox[{"0.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
            RowBox[{"wavelength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"XAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"xunit", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"YAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"yunit", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ZAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"zunit", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"propagatedrays", " ", "=", " ", 
             RowBox[{"Join", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                   RowBox[{"wavelength", " ", "=", " ", "\[Lambda]"}], ";", 
                   " ", 
                   RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0.", ",", " ", 
                   RowBox[{"-", "22.5"}], ",", " ", "0.", ",", " ", "0.", ",",
                    " ", 
                   RowBox[{"-", "22.5"}], ",", " ", "0.", ",", " ", "1.", ",",
                    " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.",
                    ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "1.", ",", " ", "0.5", ",", " ", "100.", ",", " ", 
                   "0.14285714285714285", ",", " ", "0.", ",", " ", 
                   "1.0002701958763696", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "5256.", ",", " ", "5256.", ",", 
                   " ", "1.", ",", " ", "7.", ",", " ", "1.", ",", " ", "0.", 
                   ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"0.", ",", " ", 
                   RowBox[{"-", "15."}], ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", 
                   RowBox[{"-", "15."}], ",", " ", "0.", ",", " ", "1.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", 
                   ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "1.", ",", " ", "0.5", ",", " ", "100.", ",", " ", 
                   "0.14285714285714285", ",", " ", "0.", ",", " ", 
                   "1.0002701958763696", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "5256.", ",", " ", "5256.", ",", 
                   " ", "2.", ",", " ", "7.", ",", " ", "2.", ",", " ", "0.", 
                   ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"0.", ",", " ", 
                   RowBox[{"-", "7.5"}], ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", 
                   RowBox[{"-", "7.5"}], ",", " ", "0.", ",", " ", "1.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", 
                   ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "1.", ",", " ", "0.5", ",", " ", "100.", ",", " ", 
                   "0.14285714285714285", ",", " ", "0.", ",", " ", 
                   "1.0002701958763696", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "5256.", ",", " ", "5256.", ",", 
                   " ", "3.", ",", " ", "7.", ",", " ", "3.", ",", " ", "0.", 
                   ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", 
                   " ", "0.5", ",", " ", "100.", ",", " ", 
                   "0.14285714285714285", ",", " ", "0.", ",", " ", 
                   "1.0002701958763696", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "5256.", ",", " ", "5256.", ",", 
                   " ", "4.", ",", " ", "7.", ",", " ", "4.", ",", " ", "0.", 
                   ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "7.5", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "7.5", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.",
                    ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", 
                   " ", "0.5", ",", " ", "100.", ",", " ", 
                   "0.14285714285714285", ",", " ", "0.", ",", " ", 
                   "1.0002701958763696", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "5256.", ",", " ", "5256.", ",", 
                   " ", "5.", ",", " ", "7.", ",", " ", "5.", ",", " ", "0.", 
                   ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "15.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "15.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.",
                    ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", 
                   " ", "0.5", ",", " ", "100.", ",", " ", 
                   "0.14285714285714285", ",", " ", "0.", ",", " ", 
                   "1.0002701958763696", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "5256.", ",", " ", "5256.", ",", 
                   " ", "6.", ",", " ", "7.", ",", " ", "6.", ",", " ", "0.", 
                   ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "22.5", ",", " ", "0.", ",", " ", "0.", ",",
                    " ", "22.5", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", 
                   ",", " ", "0.5", ",", " ", "100.", ",", " ", 
                   "0.14285714285714285", ",", " ", "0.", ",", " ", 
                   "1.0002701958763696", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "5256.", ",", " ", "5256.", ",", 
                   " ", "7.", ",", " ", "7.", ",", " ", "7.", ",", " ", "0.", 
                   ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "0.", ",", " ", "1.", ",", " ", "0."}], "}"}]}], "}"}]}], 
              "]"}]}], ";", " ", 
            RowBox[{"propagatedrays", " ", "=", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                  RowBox[{"componentnumber", " ", "=", " ", "1."}], ";", " ", 
                  
                  RowBox[{"frontid", " ", "=", " ", "1."}], ";", " ", 
                  RowBox[{"{", 
                   RowBox[{
                   "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                   "}"}]}], ")"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
              "propagatedrays"}]}], ";", " ", 
            RowBox[{"thresholdintensity", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"generationlimit", " ", "=", " ", "200."}], ";", " ", 
            RowBox[{"reportedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
               "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", ",", 
                " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "r2", 
                ",", " ", "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", 
                "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", 
                " ", "wavelength", ",", " ", "0", ",", " ", "intensityscale", 
                ",", " ", "ray1", ",", " ", "index", ",", " ", 
                "opticallength", ",", " ", "phaseshift", ",", " ", 
                "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ", 
                "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ", 
                "rayslot", ",", " ", "generationnumber", ",", " ", 
                "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", ",",
                 " ", "pol3"}], "}"}], "}"}]}], ";", " ", 
            RowBox[{"generationnumber", " ", "=", " ", "0."}], ";", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"inrays", " ", "=", " ", "propagatedrays"}], ";", " ", 
              RowBox[{"outrays", " ", "=", " ", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                 "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", 
                  RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", 
                  " ", 
                  RowBox[{"-", "1."}], ",", " ", 
                  RowBox[{"-", "1."}], ",", " ", 
                  RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1."}], "}"}], "}"}]}], ";", " ", 
              RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], ";", 
              " ", 
              RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], ";", 
              " ", 
              RowBox[{"propagate", " ", "=", " ", "True"}], ";", " ", 
              RowBox[{"While", "[", 
               RowBox[{
                RowBox[{"deflectedrayspresent", " ", "&&", " ", "propagate"}],
                 ",", " ", 
                RowBox[{
                 RowBox[{"generationnumber", " ", "+=", " ", "1."}], ";", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                   "deflecteddummyrayspresent", " ", "=", " ", "False"}], ";",
                    " ", 
                   RowBox[{"deflectedrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", 
                   RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", 
                   RowBox[{
                   "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                   " ", 
                   RowBox[{
                   "localdummyoutrayspresent", " ", "=", " ", "False"}], ";", 
                   " ", 
                   RowBox[{"localoutrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "deflectedlocalrays", ",", " ", "localoutrays", ",", " ", 
                    "reportedlocalrays"}], "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"#1", ",", " ", "1"}], "]"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "intensity", " ", ">", " ", "thresholdintensity"}], " ", "&&",
                     " ", 
                    RowBox[{
                    "generationnumber", " ", "<", " ", "generationlimit"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"resonatenumber", " ", "=", " ", "0"}], ";", " ", 
                    
                    RowBox[{
                    "resonateraylength", " ", "=", " ", "9.87654321*^8"}], 
                    ";", " ", 
                    RowBox[{"resonateintersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
                    RowBox[{"-", "1."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", "<", " ", 
                    "resonateraylength"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"resonateraylength", " ", "=", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", " ", 
                    RowBox[{"resonateintersections", " ", "=", " ", "#1"}], 
                    ";", " ", 
                    RowBox[{"resonatenumber", " ", "=", " ", 
                    RowBox[{"First", "[", "#2", "]"}]}]}], ",", " ", 
                    "resonatenumber"}], "]"}], " ", "&"}], " ", ",", " ", 
                    RowBox[{
                    RowBox[{"intersectionslist", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"holeQlist", " ", "=", " ", 
                    RowBox[{"{", "0", "}"}]}], ";", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x3", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y3", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y3", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x3", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "TempVar1", ",", " ", "TempVar2", 
                    ",", " ", "TempVar3", ",", " ", "RayL", ",", " ", "SCx", 
                    ",", " ", "SCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"14921604", "*", "PlanoConvexLensFocalLength"}], 
                    ")"}], "/", "28766183"}], ")"}], "*", "xunit"}]}]}], ";", 
                    " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"14921604", "*", "PlanoConvexLensFocalLength"}], 
                    ")"}], "/", "28766183"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "625."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "14921604"}], "*", 
                    "PlanoConvexLensFocalLength"}], ")"}], "/", "28766183"}], 
                    " ", "+", " ", "rx", " ", "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"222654265932816", "*", 
                    RowBox[{"PlanoConvexLensFocalLength", "^", "2"}]}], ")"}],
                     "/", "827493284389489"}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{
                    "Sign", "[", "PlanoConvexLensFocalLength", "]"}]}]}], 
                    "]"}]}], " ", "<", " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "625."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "14921604"}], "*", 
                    "PlanoConvexLensFocalLength"}], ")"}], "/", "28766183"}], 
                    " ", "+", " ", "rx", " ", "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"222654265932816", "*", 
                    RowBox[{"PlanoConvexLensFocalLength", "^", "2"}]}], ")"}],
                     "/", "827493284389489"}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{
                    "Sign", "[", "PlanoConvexLensFocalLength", "]"}]}]}], 
                    "]"}]}], " ", "<", " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5294."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "^", "2"}]}], " ", "<=", 
                    " ", "625."}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5295."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x9", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y9", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y9", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x9", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "TempVar1", ",", " ", "TempVar2", 
                    ",", " ", "TempVar3", ",", " ", "RayL", ",", " ", "SCx", 
                    ",", " ", "SCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{"30.614874029872187", "*", "xunit"}]}]}], ";", 
                    " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", "30.614874029872187"}]}]}], 
                    ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "645.16"}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "30.614874029872187"}], " ", "+", " ", "rx", 
                    " ", "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "645.16"}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "30.614874029872187"}], " ", "+", " ", "rx", 
                    " ", "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5358."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "TempVar1", ",", " ", "TempVar2", 
                    ",", " ", "TempVar3", ",", " ", "RayL", ",", " ", "SCx", 
                    ",", " ", "SCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"-", "30.614874029872187"}], "*", "xunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", 
                    RowBox[{"-", "30.614874029872187"}]}]}]}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "645.16"}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "30.614874029872187", " ", "+", " ", "rx", " ", "+", " ", 
                    
                    RowBox[{"RayL", "*", "xunit"}], " ", "-", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "645.16"}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "30.614874029872187", " ", "+", " ", "rx", " ", "+", " ", 
                    
                    RowBox[{"RayL", "*", "xunit"}], " ", "-", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5359."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x4", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y4", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y4", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x4", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "TempVar1", ",", " ", "TempVar2", 
                    ",", " ", "TempVar3", ",", " ", "RayL", ",", " ", "SCx", 
                    ",", " ", "SCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"14921604", "*", "PlanoConcaveLensFocalLength"}], 
                    ")"}], "/", "28766183"}], ")"}], "*", "xunit"}]}]}], ";", 
                    " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"14921604", "*", "PlanoConcaveLensFocalLength"}], 
                    ")"}], "/", "28766183"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", 
                    "362.90250000000003"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "14921604"}], "*", 
                    "PlanoConcaveLensFocalLength"}], ")"}], "/", "28766183"}],
                     " ", "+", " ", "rx", " ", "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"222654265932816", "*", 
                    RowBox[{"PlanoConcaveLensFocalLength", "^", "2"}]}], 
                    ")"}], "/", "827493284389489"}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{
                    "Sign", "[", "PlanoConcaveLensFocalLength", "]"}]}]}], 
                    "]"}]}], " ", "<", " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", 
                    "362.90250000000003"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "14921604"}], "*", 
                    "PlanoConcaveLensFocalLength"}], ")"}], "/", "28766183"}],
                     " ", "+", " ", "rx", " ", "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"222654265932816", "*", 
                    RowBox[{"PlanoConcaveLensFocalLength", "^", "2"}]}], 
                    ")"}], "/", "827493284389489"}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{
                    "Sign", "[", "PlanoConcaveLensFocalLength", "]"}]}]}], 
                    "]"}]}], " ", "<", " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5423."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", 
                    "0.0001"}]}], "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "^", "2"}]}], " ", "<=", 
                    " ", "362.90250000000003"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5424."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x5", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y5", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y5", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x5", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "^", "2"}]}], " ", "<=", 
                    " ", "625."}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5488."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "^", "2"}]}], " ", "<=", 
                    " ", "625."}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5489."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x6", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y6", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y6", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x6", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "^", "2"}]}], " ", "<=", 
                    " ", "625."}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5553."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "^", "2"}]}], " ", "<=", 
                    " ", "625."}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5554."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x10", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y10", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y10", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x10", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "TempVar1", ",", " ", "TempVar2", 
                    ",", " ", "TempVar3", ",", " ", "RayL", ",", " ", "SCx", 
                    ",", " ", "SCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"-", "91.80458356418029"}], "*", "xunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", 
                    RowBox[{"-", "91.80458356418029"}]}]}]}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "625."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "91.80458356418029", " ", "+", " ", "rx", " ", "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "-", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"8428.081563392561", " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "625."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "91.80458356418029", " ", "+", " ", "rx", " ", "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "-", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"8428.081563392561", " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5617."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x10", " ", "+", " ", 
                    RowBox[{"3.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y10", " ", "+", " ", 
                    RowBox[{"3.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x10", " ", "+", " ", 
                    RowBox[{"3.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y10", " ", "+", " ", 
                    RowBox[{"3.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "TempVar1", ",", " ", "TempVar2", 
                    ",", " ", "TempVar3", ",", " ", "RayL", ",", " ", "SCx", 
                    ",", " ", "SCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{"91.80458356418029", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", "91.80458356418029"}]}]}], 
                    ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "625."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "91.80458356418029"}], " ", "+", " ", "rx", 
                    " ", "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"8428.081563392561", " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "625."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "91.80458356418029"}], " ", "+", " ", "rx", 
                    " ", "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"8428.081563392561", " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "5618."}], "]"}], " ",
                     "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}]}], 
                    ")"}], ";", " ", 
                    RowBox[{"holeQlist", " ", "=", " ", 
                    RowBox[{"Drop", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}]}], ";", " ", 
                    RowBox[{"Drop", "[", 
                    RowBox[{"intersectionslist", ",", " ", "1"}], "]"}]}]}], 
                    "]"}]}], ")"}], ";", " ", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"resonatenumber", " ", "==", " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x3", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y3", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y3", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x3", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "1.", ",", " ", "5294."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "1.", ",", " ", "5294."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "x3", "]"}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "y3", "]"}], " ", "+", " ", 
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"localdummyoutrayspresent", " ", "=", " ", 
                    "True"}], ";", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "PlanoConvexLensFocalLength", "]"}], 
                    "*", "ray2"}], ")"}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"0.2690707829696608", "*", 
                    RowBox[{"PlanoConvexLensFocalLength", "^", "2"}]}], " ", 
                    "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "PlanoConvexLensFocalLength", "]"}], 
                    "*", "ray3"}], ")"}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"0.2690707829696608", "*", 
                    RowBox[{"PlanoConvexLensFocalLength", "^", "2"}]}], " ", 
                    "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "PlanoConvexLensFocalLength", "]"}], 
                    "*", "ray2"}], ")"}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"0.2690707829696608", "*", 
                    RowBox[{"PlanoConvexLensFocalLength", "^", "2"}]}], " ", 
                    "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "PlanoConvexLensFocalLength", "]"}], 
                    "*", "ray3"}], ")"}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"0.2690707829696608", "*", 
                    RowBox[{"PlanoConvexLensFocalLength", "^", "2"}]}], " ", 
                    "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", "x3", "]"}], ",", " ", 
                    RowBox[{"Re", "[", "y3", "]"}], ",", " ", "0."}], "}"}]}],
                     ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "1."}]}],
                     "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{"cosangle", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "axismatrix"}], ")"}], "*", 
                    "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "2"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "2.", ",", " ", "5295."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "2.", ",", " ", "5295."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"x3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y3", " ", "+", " ", 
                    RowBox[{"PlanoConvexLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]3"}], 
                    "]"}]}]}], "]"}], ",", " ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", 
                    RowBox[{"-", "1."}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "1."}]}],
                     "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{"cosangle", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "axismatrix"}], ")"}], "*", 
                    "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "3"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x9", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y9", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y9", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x9", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "3.", ",", " ", "5358."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "3.", ",", " ", "5358."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "x9", "]"}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "y9", "]"}], " ", "+", " ", 
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"ray2", "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"ray2", "^", "2"}], " ", "-", " ", 
                    RowBox[{"ray3", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"ray3", "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"ray2", "^", "2"}], " ", "-", " ", 
                    RowBox[{"ray3", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}]}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ray2", "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"ray2", "^", "2"}], " ", "-", " ", 
                    RowBox[{"ray3", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ",", " ", "1.", ",", " ",
                     "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ray3", "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"ray2", "^", "2"}], " ", "-", " ", 
                    RowBox[{"ray3", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ",", " ", "0.", ",", " ",
                     "1."}], "}"}]}], "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", "x9", "]"}], ",", " ", 
                    RowBox[{"Re", "[", "y9", "]"}], ",", " ", "0."}], "}"}]}],
                     ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.957925419324613", " ", "+", " ", 
                    RowBox[{"0.048255135182472264", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.1422250055971522", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"0.05660788966187853", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"0.01140110294469355", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "-", " ", 
                    RowBox[{"0.000875836614554464", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.957925419324613", " ", "+", " ", 
                    RowBox[{"0.048255135182472264", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.1422250055971522", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"0.05660788966187853", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"0.01140110294469355", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "-", " ", 
                    RowBox[{"0.000875836614554464", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.957925419324613", " ", "+", " ", 
                    RowBox[{"0.048255135182472264", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.1422250055971522", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"0.05660788966187853", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"0.01140110294469355", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "-", " ", 
                    RowBox[{"0.000875836614554464", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "1."}]}],
                     "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{"cosangle", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "axismatrix"}], ")"}], "*", 
                    "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "4"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "4.", ",", " ", "5359."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "4.", ",", " ", "5359."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"ray2", "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"ray2", "^", "2"}], " ", "-", " ", 
                    RowBox[{"ray3", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ")"}]}], ",", 
                    " ", 
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"ray3", "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"ray2", "^", "2"}], " ", "-", " ", 
                    RowBox[{"ray3", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ")"}]}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"ray2", "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"ray2", "^", "2"}], " ", "-", " ", 
                    RowBox[{"ray3", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", " ", "1.", 
                    ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"ray3", "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"937.2705118649425", " ", "-", " ", 
                    RowBox[{"ray2", "^", "2"}], " ", "-", " ", 
                    RowBox[{"ray3", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", " ", "0.", 
                    ",", " ", "1."}], "}"}]}], "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"x9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y9", " ", "+", " ", 
                    RowBox[{"28.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]9"}], 
                    "]"}]}]}], "]"}], ",", " ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", 
                    RowBox[{"-", "1."}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.957925419324613", " ", "+", " ", 
                    RowBox[{"0.048255135182472264", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.1422250055971522", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"0.05660788966187853", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"0.01140110294469355", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "-", " ", 
                    RowBox[{"0.000875836614554464", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.957925419324613", " ", "+", " ", 
                    RowBox[{"0.048255135182472264", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.1422250055971522", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"0.05660788966187853", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"0.01140110294469355", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "-", " ", 
                    RowBox[{"0.000875836614554464", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.957925419324613", " ", "+", " ", 
                    RowBox[{"0.048255135182472264", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.1422250055971522", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"0.05660788966187853", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"0.01140110294469355", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "-", " ", 
                    RowBox[{"0.000875836614554464", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "1."}]}],
                     "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{"cosangle", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "axismatrix"}], ")"}], "*", 
                    "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "5"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x4", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y4", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y4", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x4", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "5.", ",", " ", "5423."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "5.", ",", " ", "5423."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "x4", "]"}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "y4", "]"}], " ", "+", " ", 
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "PlanoConcaveLensFocalLength", "]"}],
                     "*", "ray2"}], ")"}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"0.2690707829696608", "*", 
                    RowBox[{"PlanoConcaveLensFocalLength", "^", "2"}]}], " ", 
                    "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "PlanoConcaveLensFocalLength", "]"}],
                     "*", "ray3"}], ")"}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"0.2690707829696608", "*", 
                    RowBox[{"PlanoConcaveLensFocalLength", "^", "2"}]}], " ", 
                    "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "PlanoConcaveLensFocalLength", "]"}],
                     "*", "ray2"}], ")"}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"0.2690707829696608", "*", 
                    RowBox[{"PlanoConcaveLensFocalLength", "^", "2"}]}], " ", 
                    "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "PlanoConcaveLensFocalLength", "]"}],
                     "*", "ray3"}], ")"}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"0.2690707829696608", "*", 
                    RowBox[{"PlanoConcaveLensFocalLength", "^", "2"}]}], " ", 
                    "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", "x4", "]"}], ",", " ", 
                    RowBox[{"Re", "[", "y4", "]"}], ",", " ", "0."}], "}"}]}],
                     ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "1."}]}],
                     "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{"cosangle", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "axismatrix"}], ")"}], "*", 
                    "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "6"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "6.", ",", " ", "5424."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "6.", ",", " ", "5424."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"x4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y4", " ", "+", " ", 
                    RowBox[{"PlanoConcaveLensThickness", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]4"}], 
                    "]"}]}]}], "]"}], ",", " ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", 
                    RowBox[{"-", "1."}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "1."}]}],
                     "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{"cosangle", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "axismatrix"}], ")"}], "*", 
                    "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "7"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x5", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y5", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y5", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x5", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "7.", ",", " ", "5488."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "7.", ",", " ", "5488."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "x5", "]"}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "y5", "]"}], " ", "+", " ", 
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", "x5", "]"}], ",", " ", 
                    RowBox[{"Re", "[", "y5", "]"}], ",", " ", "0."}], "}"}]}],
                     ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"componentnumber", " ", "=", " ", 
                    "newcomponentnumber"}], ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{"cosangle", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "axismatrix"}], ")"}], "*", 
                    "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "8"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "8.", ",", " ", "5489."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "8.", ",", " ", "5489."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"x5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y5", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]5"}], 
                    "]"}]}]}], "]"}], ",", " ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", 
                    RowBox[{"-", "1."}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"componentnumber", " ", "=", " ", 
                    "newcomponentnumber"}], ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "1."}]}],
                     "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{"cosangle", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "axismatrix"}], ")"}], "*", 
                    "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "9"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x6", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y6", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "y6", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x6", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "9.", ",", " ", "5553."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "9.", ",", " ", "5553."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "x6", "]"}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "y6", "]"}], " ", "+", " ", 
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", "x6", "]"}], ",", " ", 
                    RowBox[{"Re", "[", "y6", "]"}], ",", " ", "0."}], "}"}]}],
                     ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{"cosangle", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "axismatrix"}], ")"}], "*", 
                    "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "10"}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "10.", ",", " ", "5554."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "10.", ",", " ", "5554."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], "]"}],
                     "]"}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"x6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"y6", " ", "+", " ", 
                    RowBox[{"5.", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]6"}], 
                    "]"}]}]}], "]"}], ",", " ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", 
                    RowBox[{"-", "1."}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "1."}]}],
                     "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{"cosangle", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "axismatrix"}], ")"}], "*", 
                    "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "11"}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]10"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*"