(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     30644,        750]
NotebookOptionsPosition[     29408,        704]
NotebookOutlinePosition[     30079,        729]
CellTagsIndexPosition[     30036,        726]
WindowTitle->Circular and Elliptic Polarization of Light Waves - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Circular and Elliptic Polarization of Light Waves", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"waveplot", "[", 
    RowBox[{"a", ",", " ", "\[Phi]", ",", " ", "t", ",", " ", "components"}], 
    "]"}], ",", " ", "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", " ", "0", ",", " ", "\"\<time\>\""}], "}"}], ",", " ",
      "0", ",", " ", 
     RowBox[{
      RowBox[{"2", "*", "Pi"}], " ", "-", " ", 
      RowBox[{"Pi", "/", "16"}]}], ",", " ", 
     RowBox[{"Pi", "/", "16"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "Animator"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", " ", "1", ",", " ", "\"\<amplitude ratio\>\""}], 
      "}"}], ",", " ", "0.5", ",", " ", "2", ",", " ", 
     RowBox[{"Appearance", " ", "\[Rule]", " ", "\"\<Labeled\>\""}]}], "}"}], 
   ",", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", " ", 
       RowBox[{"Pi", "/", "2"}], ",", " ", "\"\<phase shift \[Phi]\>\""}], 
      "}"}], ",", " ", "0", ",", " ", "Pi", ",", " ", 
     RowBox[{"Appearance", " ", "\[Rule]", " ", "\"\<Labeled\>\""}]}], "}"}], 
   ",", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "components", ",", " ", "False", ",", " ", "\"\<show components\>\""}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"True", ",", " ", "False"}], "}"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"Initialization", " ", "\[RuleDelayed]", "\[IndentingNewLine]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"blue", " ", "=", " ", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0.392193", ",", " ", "0.584307", ",", " ", "0.929395"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"red", " ", "=", " ", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0.829997", ",", " ", "0.239998", ",", " ", "0.099994"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"green", " ", "=", " ", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0.380001", ",", " ", "0.700003", ",", " ", "0.159993"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"orange", "=", "Orange"}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Omega]", " ", "=", " ", "3"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"w1", "[", 
        RowBox[{"a_", ",", " ", "t_", ",", " ", "s_", ",", " ", "\[Phi]_"}], 
        "]"}], " ", ":=", " ", 
       RowBox[{"4", "*", 
        RowBox[{"Sqrt", "[", "a", "]"}], "*", 
        RowBox[{"Sin", "[", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"s", " ", "+", " ", "\[Phi]"}], ")"}], " ", "-", " ", 
          RowBox[{"\[Omega]", "*", "t"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"w2", "[", 
        RowBox[{"a_", ",", " ", "t_", ",", " ", "s_"}], "]"}], " ", ":=", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "/", 
          RowBox[{"Sqrt", "[", "a", "]"}]}], ")"}], "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"s", " ", "-", " ", 
          RowBox[{"\[Omega]", "*", "t"}]}], " ", "]"}]}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"v1", "[", 
        RowBox[{"a_", ",", " ", "t_", ",", " ", "s_", ",", " ", "\[Phi]_"}], 
        "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", 
         RowBox[{"w1", "[", 
          RowBox[{"a", ",", " ", "t", ",", " ", "s", ",", " ", "\[Phi]"}], 
          "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"v2", "[", 
        RowBox[{"a_", ",", " ", "t_", ",", " ", "s_", ",", " ", "\[Phi]_"}], 
        "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"w2", "[", 
          RowBox[{"a", ",", " ", "t", ",", " ", "s"}], "]"}], ",", " ", "s", 
         ",", " ", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"v3", "[", 
        RowBox[{"a_", ",", " ", "t_", ",", " ", "s_", ",", " ", "\[Phi]_"}], 
        "]"}], " ", ":=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"w2", "[", 
          RowBox[{"a", ",", " ", "t", ",", " ", "s"}], "]"}], ",", " ", "s", 
         ",", " ", 
         RowBox[{"w1", "[", 
          RowBox[{"a", ",", " ", "t", ",", " ", "s", ",", " ", "\[Phi]"}], 
          "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"waveplot", "[", 
        RowBox[{
        "a_", ",", " ", "\[Phi]_", ",", " ", "t_", ",", " ", "components_"}], 
        "]"}], " ", ":=", " ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"s", ",", " ", "t2"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Show", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{"components", ",", " ", "\[IndentingNewLine]", 
             RowBox[{"ParametricPlot3D", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"v1", "[", 
                  RowBox[{
                  "a", ",", " ", "t", ",", " ", "s", ",", " ", "\[Phi]"}], 
                  "]"}], ",", 
                 RowBox[{"v2", "[", 
                  RowBox[{
                  "a", ",", " ", "t", ",", " ", "s", ",", " ", "\[Phi]"}], 
                  "]"}], ",", " ", 
                 RowBox[{"v3", "[", 
                  RowBox[{
                  "a", ",", " ", "t", ",", " ", "s", ",", " ", "\[Phi]"}], 
                  "]"}]}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"s", ",", " ", "0", ",", " ", 
                 RowBox[{"10", "*", "Pi"}]}], "}"}], ",", 
               RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
               RowBox[{"Ticks", " ", "\[Rule]", " ", 
                RowBox[{"{", 
                 RowBox[{"None", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "\"\<0\[Pi]\>\""}], "}"}], ",", 
                    " ", 
                    RowBox[{"2", "*", "Pi"}], ",", " ", 
                    RowBox[{"4", "*", "Pi"}], ",", 
                    RowBox[{"6", "*", "Pi"}], ",", " ", 
                    RowBox[{"8", "*", "Pi"}], ",", " ", 
                    RowBox[{"10", "*", "Pi"}]}], "}"}], ",", " ", "None"}], 
                 "}"}]}], ",", 
               RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"blue", ",", " ", 
                    RowBox[{"AbsoluteThickness", "[", "2.", "]"}]}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{"red", ",", " ", 
                    RowBox[{"AbsoluteThickness", "[", "2.", "]"}]}], "}"}], 
                  ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"green", ",", " ", 
                    RowBox[{"AbsoluteThickness", "[", "3.", "]"}]}], "}"}], 
                  ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"orange", ",", " ", 
                    RowBox[{"AbsoluteThickness", "[", "3.", "]"}]}], "}"}]}], 
                 "}"}]}], ",", " ", 
               RowBox[{"Method", " ", "\[Rule]", " ", 
                RowBox[{"{", 
                 RowBox[{"Compiled", " ", "\[Rule]", " ", "False"}], 
                 "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"ParametricPlot3D", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"v3", "[", 
                 RowBox[{
                 "a", ",", " ", "t", ",", " ", "s", ",", " ", "\[Phi]"}], 
                 "]"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"s", ",", " ", "0", ",", " ", 
                 RowBox[{"10", "*", "Pi"}]}], "}"}], ",", " ", 
               RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", 
               RowBox[{"Ticks", " ", "\[Rule]", " ", 
                RowBox[{"{", 
                 RowBox[{"None", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "\"\<0\[Pi]\>\""}], "}"}], ",", 
                    " ", 
                    RowBox[{"2", "*", "Pi"}], ",", " ", 
                    RowBox[{"4", "*", "Pi"}], ",", " ", 
                    RowBox[{"6", "*", "Pi"}], ",", " ", 
                    RowBox[{"8", "*", "Pi"}], ",", 
                    RowBox[{"10", "*", "Pi"}]}], "}"}], ",", " ", "None"}], 
                 "}"}]}], ",", " ", 
               RowBox[{"PlotStyle", " ", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"green", ",", " ", 
                  RowBox[{"AbsoluteThickness", "[", "3.", "]"}]}], "}"}]}]}], 
              "]"}], ",", " ", 
             RowBox[{"Method", " ", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Compiled", " ", "\[Rule]", " ", "False"}], "}"}]}]}], 
            "]"}], ",", " ", "\[IndentingNewLine]", 
           RowBox[{"Graphics3D", "[", 
            RowBox[{"{", 
             RowBox[{"green", ",", " ", 
              RowBox[{"AbsoluteThickness", "[", "3.", "]"}], ",", " ", 
              "\[IndentingNewLine]", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", " ", "pos", ",", " ", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"w2", "[", 
                    RowBox[{"a", ",", " ", "t", ",", " ", "pos"}], "]"}], ",",
                    " ", "pos", ",", " ", 
                   RowBox[{"w1", "[", 
                    RowBox[{
                    "a", ",", " ", "t", ",", " ", "pos", ",", " ", "\[Phi]"}],
                     "]"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
           RowBox[{"ParametricPlot3D", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"w2", "[", 
                RowBox[{"a", ",", " ", "t2", ",", " ", "pos"}], "]"}], ",", 
               " ", "pos", ",", " ", 
               RowBox[{"w1", "[", 
                RowBox[{
                "a", ",", " ", "t2", ",", " ", "pos", ",", " ", "\[Phi]"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t2", ",", " ", "0", ",", " ", 
               RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
             RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
              RowBox[{"{", 
               RowBox[{"Black", ",", " ", 
                RowBox[{"AbsoluteThickness", "[", "1.", "]"}]}], "}"}]}], ",", 
             RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}], ",", " ", 
             RowBox[{"Method", " ", "\[Rule]", " ", 
              RowBox[{"{", 
               RowBox[{"Compiled", " ", "\[Rule]", " ", "False"}], "}"}]}]}], 
            "]"}], ",", 
           RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"500", ",", "400"}], "}"}]}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pos", "=", " ", 
       RowBox[{"12", "*", "Pi"}]}], ";"}], " ", ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.432225501640625*^9, {3.432226964984375*^9, 
   3.432226987421875*^9}, {3.432227076484375*^9, 3.432227084140625*^9}, {
   3.4323140235628986`*^9, 3.4323140353550777`*^9}, {3.4324042192962046`*^9, 
   3.43240422585686*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 1, $CellContext`components$$ = 
    False, $CellContext`t$$ = 0, $CellContext`\[Phi]$$ = Rational[1, 2] Pi, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 0, "time"}, 0, Rational[31, 16] Pi, 
      Rational[1, 16] Pi}, {{
       Hold[$CellContext`a$$], 1, "amplitude ratio"}, 0.5, 2}, {{
       Hold[$CellContext`\[Phi]$$], Rational[1, 2] Pi, "phase shift \[Phi]"}, 
      0, Pi}, {{
       Hold[$CellContext`components$$], False, "show components"}, {
      True, False}}}, Typeset`size$$ = {500., {198., 202.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`t$3266$$ = 0, $CellContext`a$3267$$ = 
    0, $CellContext`\[Phi]$3268$$ = 0, $CellContext`components$3269$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`components$$ = 
        False, $CellContext`t$$ = 0, $CellContext`\[Phi]$$ = 
        Rational[1, 2] Pi}, "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$3266$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$3267$$, 0], 
        Hold[$CellContext`\[Phi]$$, $CellContext`\[Phi]$3268$$, 0], 
        Hold[$CellContext`components$$, $CellContext`components$3269$$, 
         False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`waveplot[$CellContext`a$$, \
$CellContext`\[Phi]$$, $CellContext`t$$, $CellContext`components$$], 
      "Specifications" :> {{{$CellContext`t$$, 0, "time"}, 0, 
         Rational[31, 16] Pi, Rational[1, 16] Pi, ControlType -> Animator, 
         AnimationRunning -> 
         False}, {{$CellContext`a$$, 1, "amplitude ratio"}, 0.5, 2, 
         Appearance -> 
         "Labeled"}, {{$CellContext`\[Phi]$$, Rational[1, 2] Pi, 
          "phase shift \[Phi]"}, 0, Pi, Appearance -> 
         "Labeled"}, {{$CellContext`components$$, False, "show components"}, {
         True, False}}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {279., 284.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`blue = 
       RGBColor[0.392193, 0.584307, 0.929395]; $CellContext`red = 
       RGBColor[0.829997, 0.239998, 0.099994]; $CellContext`green = 
       RGBColor[0.380001, 0.700003, 0.159993]; $CellContext`orange = 
       Orange; $CellContext`\[Omega] = 3; $CellContext`w1[
         Pattern[$CellContext`a, 
          Blank[]], 
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Phi], 
          Blank[]]] := 
       4 Sqrt[$CellContext`a] 
        Sin[($CellContext`s + $CellContext`\[Phi]) - $CellContext`\[Omega] \
$CellContext`t]; $CellContext`w2[
         Pattern[$CellContext`a, 
          Blank[]], 
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`s, 
          Blank[]]] := (4/Sqrt[$CellContext`a]) 
        Sin[$CellContext`s - $CellContext`\[Omega] $CellContext`t]; \
$CellContext`v1[
         Pattern[$CellContext`a, 
          Blank[]], 
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Phi], 
          Blank[]]] := {0, $CellContext`s, 
         $CellContext`w1[$CellContext`a, $CellContext`t, $CellContext`s, \
$CellContext`\[Phi]]}; $CellContext`v2[
         Pattern[$CellContext`a, 
          Blank[]], 
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Phi], 
          Blank[]]] := {
         $CellContext`w2[$CellContext`a, $CellContext`t, $CellContext`s], \
$CellContext`s, 0}; $CellContext`v3[
         Pattern[$CellContext`a, 
          Blank[]], 
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Phi], 
          Blank[]]] := {
         $CellContext`w2[$CellContext`a, $CellContext`t, $CellContext`s], \
$CellContext`s, 
         $CellContext`w1[$CellContext`a, $CellContext`t, $CellContext`s, \
$CellContext`\[Phi]]}; $CellContext`waveplot[
         Pattern[$CellContext`a, 
          Blank[]], 
         Pattern[$CellContext`\[Phi], 
          Blank[]], 
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`components, 
          Blank[]]] := Module[{$CellContext`s, $CellContext`t2}, 
         Show[
          If[$CellContext`components, 
           ParametricPlot3D[{
             $CellContext`v1[$CellContext`a, $CellContext`t, $CellContext`s, \
$CellContext`\[Phi]], 
             $CellContext`v2[$CellContext`a, $CellContext`t, $CellContext`s, \
$CellContext`\[Phi]], 
             $CellContext`v3[$CellContext`a, $CellContext`t, $CellContext`s, \
$CellContext`\[Phi]]}, {$CellContext`s, 0, 10 Pi}, Boxed -> False, 
            Ticks -> {
             None, {{0, "0\[Pi]"}, 2 Pi, 4 Pi, 6 Pi, 8 Pi, 10 Pi}, None}, 
            PlotStyle -> {{$CellContext`blue, 
               AbsoluteThickness[2.]}, {$CellContext`red, 
               AbsoluteThickness[2.]}, {$CellContext`green, 
               AbsoluteThickness[3.]}, {$CellContext`orange, 
               AbsoluteThickness[3.]}}, Method -> {Compiled -> False}], 
           ParametricPlot3D[{
             $CellContext`v3[$CellContext`a, $CellContext`t, $CellContext`s, \
$CellContext`\[Phi]]}, {$CellContext`s, 0, 10 Pi}, Boxed -> False, 
            Ticks -> {
             None, {{0, "0\[Pi]"}, 2 Pi, 4 Pi, 6 Pi, 8 Pi, 10 Pi}, None}, 
            PlotStyle -> {$CellContext`green, 
              AbsoluteThickness[3.]}], Method -> {Compiled -> False}], 
          Graphics3D[{$CellContext`green, 
            AbsoluteThickness[3.], 
            Line[{{0, $CellContext`pos, 0}, {
               $CellContext`w2[$CellContext`a, $CellContext`t, \
$CellContext`pos], $CellContext`pos, 
               $CellContext`w1[$CellContext`a, $CellContext`t, \
$CellContext`pos, $CellContext`\[Phi]]}}]}], 
          ParametricPlot3D[{
            $CellContext`w2[$CellContext`a, $CellContext`t2, \
$CellContext`pos], $CellContext`pos, 
            $CellContext`w1[$CellContext`a, $CellContext`t2, \
$CellContext`pos, $CellContext`\[Phi]]}, {$CellContext`t2, 0, 2 Pi}, 
           PlotStyle -> {Black, 
             AbsoluteThickness[1.]}, PlotRange -> All, 
           Method -> {Compiled -> False}], PlotRange -> All, 
          ImageSize -> {500, 400}]]; $CellContext`pos = 12 Pi; Null); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->58934932],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
A superposition of two linearly polarized light waves with perpendicular \
polarization planes results in a linear, elliptical, or circular polarized \
wave, depending on the amplitudes and the phase shift between the two waves. \
\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[TextData[{
 "In the animation the electric field components of the two individual waves \
are shown in red and blue if \"show components\" is selected. The electric \
field component of the resulting superposition is shown in green. If the \
superimposed waves have equal amplitude and a phase shift of a quarter \
wavelength (",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 "), the resulting wave has circular polarization. This is the default \
setting for the animation. If the phase shift is not equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 ", or if the waves have different amplitudes, the superposition wave has \
elliptic polarization. Adjust \"amplitude ratio\" or \"phase shift\" to see \
the effect. A \"detector\" at position ",
 Cell[BoxData[
  FormBox[
   RowBox[{"12", " ", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 " traces the amplitude of the resulting wave and shows the polarization. The \
animation can be freely rotated. Select a phase shift of zero or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 " to obtain a superposition wave with linear polarization."
}], "Text"],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Circular and Elliptic Polarization of Light Waves",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
CircularAndEllipticPolarizationOfLightWaves/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
CircularAndEllipticPolarizationOfLightWaves/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
CircularAndEllipticPolarizationOfLightWaves/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
CircularAndEllipticPolarizationOfLightWaves/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
CircularAndEllipticPolarizationOfLightWaves/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Jochen Autschbach",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Jochen+\
Autschbach"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Jochen+Autschbach"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
CircularAndEllipticPolarizationOfLightWaves"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Circular and Elliptic Polarization of Light Waves - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[651, 23, 169, 3, 70, "Section"],
Cell[823, 28, 3700, 64, 70, "Section"],
Cell[4526, 94, 11748, 269, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16311, 368, 7345, 160, 70, "Output",
 CellID->58934932],
Cell[CellGroupData[{
Cell[23681, 532, 209, 6, 70, "Section"],
Cell[23893, 540, 255, 5, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[24174, 549, 1258, 26, 70, "Text"],
Cell[CellGroupData[{
Cell[25457, 579, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[25815, 590, 1059, 31, 70, "Text"],
Cell[26877, 623, 445, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[27347, 641, 815, 24, 70, "Text"],
Cell[28165, 667, 1215, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature oQjjQnh7Y4cpID0EY8dAQwFU *)
